/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class SubImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private final long startPos;
    private final long length;

    public SubImageInputStream(ImageInputStream imageInputStream, long l15) throws IOException {
        Validate.notNull(imageInputStream, "stream");
        Validate.isTrue(l15 >= 0L, l15, "length < 0: %d");
        this.stream = imageInputStream;
        this.startPos = imageInputStream.getStreamPosition();
        this.length = l15;
    }

    @Override
    public int read() throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        int n15 = this.stream.read();
        if (n15 >= 0) {
            ++this.streamPos;
        }
        return n15;
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        if (this.streamPos >= this.length) {
            return -1;
        }
        int n17 = (int)Math.min((long)n16, this.length - this.streamPos);
        int n18 = this.stream.read(byArray, n15, n17);
        if (n18 >= 0) {
            this.streamPos += (long)n18;
        }
        return n18;
    }

    @Override
    public long length() {
        try {
            long l15 = this.stream.length();
            return l15 < 0L ? -1L : Math.min(l15 - this.startPos, this.length);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public void seek(long l15) throws IOException {
        if (l15 < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException("pos < flushedPosition");
        }
        this.stream.seek(this.startPos + l15);
        this.streamPos = l15;
    }

    @Override
    protected void finalize() {
    }
}

