/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Bytes;
import java.util.Arrays;
import java.util.Comparator;

@GwtCompatible
public final class SignedBytes {
    public static final byte MAX_POWER_OF_TWO = 64;

    private SignedBytes() {
    }

    public static byte checkedCast(long value) {
        byte result = (byte)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", value);
        return result;
    }

    public static byte saturatedCast(long value) {
        if (value > 127L) {
            return 127;
        }
        if (value < -128L) {
            return -128;
        }
        return (byte)value;
    }

    public static int compare(byte a15, byte b15) {
        return Byte.compare(a15, b15);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        byte min = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] >= min) continue;
            min = array[i15];
        }
        return min;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        byte max = array[0];
        for (int i15 = 1; i15 < array.length; ++i15) {
            if (array[i15] <= max) continue;
            max = array[i15];
        }
        return max;
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(array[0]);
        for (int i15 = 1; i15 < array.length; ++i15) {
            builder.append(separator).append(array[i15]);
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sortDescending(byte[] array) {
        Preconditions.checkNotNull(array);
        SignedBytes.sortDescending(array, 0, array.length);
    }

    public static void sortDescending(byte[] array, int fromIndex, int toIndex) {
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        Arrays.sort(array, fromIndex, toIndex);
        Bytes.reverse(array, fromIndex, toIndex);
    }

    private static enum LexicographicalComparator implements Comparator<byte[]>
    {
        INSTANCE;


        @Override
        public int compare(byte[] left, byte[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i15 = 0; i15 < minLength; ++i15) {
                int result = Byte.compare(left[i15], right[i15]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }

        public String toString() {
            return "SignedBytes.lexicographicalComparator()";
        }
    }
}

