/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.paint.impl;

import com.github.weisj.jsvg.renderer.output.Output;
import com.github.weisj.jsvg.renderer.output.impl.GraphicsUtil;
import com.github.weisj.jsvg.util.CachedSurfaceSupplier;
import com.github.weisj.jsvg.util.ColorUtil;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaskedPaint
implements Paint,
GraphicsUtil.WrappingPaint,
GraphicsUtil.DisposablePaint {
    @NotNull
    private Paint paint;
    @NotNull
    private final Raster maskRaster;
    @NotNull
    private final Point maskOffset;
    @Nullable
    private final CachedSurfaceSupplier.ResourceCleaner cleaner;

    public MaskedPaint(@NotNull Paint paint, @NotNull Raster maskRaster, @NotNull Point2D maskOffset, @Nullable CachedSurfaceSupplier.ResourceCleaner cleaner) {
        this.paint = paint;
        this.maskRaster = maskRaster;
        this.maskOffset = new Point((int)Math.floor(maskOffset.getX()), (int)Math.floor(maskOffset.getY()));
        this.cleaner = cleaner;
    }

    @Override
    public void cleanupIfNeeded(@NotNull Output output) {
        if (this.cleaner != null) {
            this.cleaner.clean(output);
        }
    }

    @Override
    public void setPaint(@NotNull Paint paint) {
        this.paint = paint;
    }

    @Override
    @NotNull
    public Paint paint() {
        return this.paint;
    }

    @Override
    public PaintContext createContext(ColorModel cm4, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        PaintContext parentContext = this.paint.createContext(null, deviceBounds, userBounds, xform, hints);
        return new MaskPaintContext(parentContext, this.maskRaster, this.maskOffset);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private static final class MaskPaintContext
    implements PaintContext {
        @NotNull
        private final PaintContext parentContext;
        @NotNull
        private final ColorModel colorModel;
        private final int numColorComponents;
        @NotNull
        private final ColorModel parentColorModel;
        @NotNull
        private final Raster maskRaster;
        @NotNull
        private final Point offset;

        MaskPaintContext(@NotNull PaintContext parentContext, @NotNull Raster maskRaster, @NotNull Point offset) {
            this.parentContext = parentContext;
            this.parentColorModel = parentContext.getColorModel();
            this.maskRaster = maskRaster;
            this.offset = offset;
            this.colorModel = parentContext.getColorModel().hasAlpha() ? this.parentColorModel : new ComponentColorModel(parentContext.getColorModel().getColorSpace(), true, false, 1, 0);
            this.numColorComponents = this.colorModel.getNumColorComponents();
        }

        @Override
        @NotNull
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        @Override
        public void dispose() {
            this.parentContext.dispose();
        }

        @Override
        public Raster getRaster(int x15, int y15, int w15, int h15) {
            WritableRaster result;
            Raster parentRaster = this.parentContext.getRaster(x15, y15, w15, h15);
            int parentMinX = parentRaster.getMinX();
            int parentMinY = parentRaster.getMinY();
            if (parentRaster instanceof WritableRaster) {
                if (this.parentColorModel.equals(this.colorModel)) {
                    result = parentRaster.createCompatibleWritableRaster();
                    result.setDataElements(-parentMinX, -parentMinY, parentRaster);
                } else {
                    BufferedImage parentImage = new BufferedImage(this.parentColorModel, (WritableRaster)parentRaster, this.parentColorModel.isAlphaPremultiplied(), null);
                    result = Raster.createWritableRaster(this.colorModel.createCompatibleSampleModel(w15, h15), new Point(0, 0));
                    BufferedImage resultImage = new BufferedImage(this.colorModel, result, false, null);
                    Graphics graphics = resultImage.getGraphics();
                    graphics.drawImage(parentImage, 0, 0, null);
                    graphics.dispose();
                }
            } else {
                result = Raster.createInterleavedRaster(0, w15, h15, this.getColorModel().getNumComponents(), new Point(0, 0));
                ColorConvertOp colorConvertOp = new ColorConvertOp(this.parentColorModel.getColorSpace(), this.colorModel.getColorSpace(), null);
                colorConvertOp.filter(parentRaster, result);
            }
            int softMaskMinX = this.maskRaster.getMinX();
            int softMaskMinY = this.maskRaster.getMinY();
            int softMaskMaxX = softMaskMinX + this.maskRaster.getWidth();
            int softMaskMaxY = softMaskMinY + this.maskRaster.getHeight();
            for (int j15 = 0; j15 < h15; ++j15) {
                for (int i15 = 0; i15 < w15; ++i15) {
                    int rx4 = x15 + i15 - this.offset.x;
                    int ry4 = y15 + j15 - this.offset.y;
                    int luminance = rx4 >= softMaskMinX && rx4 < softMaskMaxX && ry4 >= softMaskMinY && ry4 < softMaskMaxY ? this.maskRaster.getSample(rx4, ry4, 0) : 0;
                    int newAlpha = ColorUtil.div255(luminance * result.getSample(i15, j15, this.numColorComponents));
                    result.setSample(i15, j15, this.numColorComponents, newAlpha);
                }
            }
            return result;
        }
    }
}

