/*
 * Copyright 2023 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.internal.configuration.inputs;

import java.util.concurrent.atomic.AtomicReference;

/**
 * Main entry point to the input tracking.
 */
public class InstrumentedInputs {
    private static final AtomicReference<InstrumentedInputsListener> LISTENER = new AtomicReference<>(NoOpInputsListener.INSTANCE);

    /**
     * @deprecated do not use outside of this class
     */
    @Deprecated
    @SuppressWarnings("NullAway") // https://github.com/uber/NullAway/issues/681, this method may be heavily used
    public static InstrumentedInputsListener listener() {
        // TODO(mlopatkin): Reduce the visibility of this method once everything moves into this project.
        return LISTENER.get();
    }

    public static void setListener(InstrumentedInputsListener listener) {
        LISTENER.set(listener);
    }

    public static void discardListener() {
        setListener(NoOpInputsListener.INSTANCE);
    }
}
