/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.types;

import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.util.PropertyValueHandler;
import net.infonode.properties.util.ValueHandlerProperty;

public class FloatProperty
extends ValueHandlerProperty {
    private float minValue;
    private float maxValue;
    private int preferredDigitCount;
    private float preferredDelta;

    public FloatProperty(PropertyGroup group, String name, String description, PropertyValueHandler valueHandler) {
        this(group, name, description, valueHandler, Float.MIN_VALUE, Float.MAX_VALUE);
    }

    public FloatProperty(PropertyGroup group, String name, String description, PropertyValueHandler valueHandler, float minValue, float maxValue) {
        this(group, name, description, valueHandler, minValue, maxValue, 6, 0.1f);
    }

    public FloatProperty(PropertyGroup group, String name, String description, PropertyValueHandler valueHandler, float minValue, float maxValue, int preferredDigitCount, float preferredDelta) {
        super(group, name, Float.class, description, valueHandler);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.preferredDigitCount = preferredDigitCount;
        this.preferredDelta = preferredDelta;
    }

    public float getPreferredDelta() {
        return this.preferredDelta;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public int getPreferredDigitCount() {
        return this.preferredDigitCount;
    }

    public float get(Object valueContainer) {
        Object value = this.getValue(valueContainer);
        return value == null ? 0.0f : ((Number)this.getValue(valueContainer)).floatValue();
    }

    public void set(Object valueContainer, float value) {
        this.setValue(valueContainer, new Float(value));
    }

    @Override
    public boolean canBeAssiged(Object value) {
        if (!super.canBeAssiged(value)) {
            return false;
        }
        float v = ((Number)value).floatValue();
        return v >= this.minValue && v <= this.maxValue;
    }
}

