/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.preferences;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.StringUtils;

public final class AIPreferencePagePrompts
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private final AISettingsManager settingsManager;
    private final AISettings settings;
    private final Map<String, String> customInstructions = new LinkedHashMap<String, String>();
    private AIPromptGeneratorDescriptor activeGenerator;
    private Viewer promptsViewer;
    private Text instructionsText;

    public AIPreferencePagePrompts() {
        this.settingsManager = AISettingsManager.getInstance();
        this.settings = this.settingsManager.getSettings();
        this.customInstructions.putAll(this.settingsManager.getSettings().getCustomInstructions());
    }

    public void init(@NotNull IWorkbench workbench) {
    }

    @NotNull
    public IAdaptable getElement() {
        return this.settings;
    }

    public void setElement(@NotNull IAdaptable element) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        List<AIPromptGeneratorDescriptor> generators = AIPromptGeneratorRegistry.getInstance().getAllPromptGenerator().stream().sorted(Comparator.comparing(AIPromptGeneratorDescriptor::getLabel)).toList();
        SashForm sash = new SashForm(parent, 65792);
        this.promptsViewer = this.createViewer((Composite)sash, generators);
        this.instructionsText = this.createEditor((Composite)sash);
        sash.setSashWidth(6);
        sash.setWeights(new int[]{30, 70});
        UIUtils.createInfoLabel((Composite)parent, (String)AIUIMessages.gpt_preference_page_prompts_hint);
        this.promptsViewer.setSelection((ISelection)new StructuredSelection((Object)generators.getFirst()));
        return sash;
    }

    public boolean performOk() {
        LinkedHashMap<String, String> instructions = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : this.customInstructions.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            instructions.put(entry.getKey(), entry.getValue());
        }
        this.settings.setCustomInstructions(instructions);
        this.settingsManager.saveSettings(this.settings);
        return super.performOk();
    }

    protected void performDefaults() {
        this.customInstructions.clear();
        this.activeGenerator = null;
        this.instructionsText.setText("");
        this.promptsViewer.refresh();
    }

    @NotNull
    private Viewer createViewer(@NotNull Composite parent, @NotNull List<AIPromptGeneratorDescriptor> generators) {
        TableViewer viewer = new TableViewer(parent, 2816);
        viewer.setContentProvider((IContentProvider)new ListContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ViewerLabelProvider()));
        viewer.setInput(generators);
        viewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = event.getStructuredSelection();
            if (!selection.isEmpty()) {
                AIPromptGeneratorDescriptor descriptor = (AIPromptGeneratorDescriptor)selection.getFirstElement();
                this.onGeneratorChanged(descriptor);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer, (int)2);
        return viewer;
    }

    @NotNull
    private Text createEditor(@NotNull Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        Text editor = new Text(contents, 2626);
        editor.setLayoutData((Object)new GridData(4, 4, true, true));
        editor.addModifyListener(e -> this.onInstructionsChanged(editor.getText().strip()));
        return editor;
    }

    private void onGeneratorChanged(@NotNull AIPromptGeneratorDescriptor generator) {
        this.activeGenerator = generator;
        this.instructionsText.setText(this.getCustomInstructions(generator));
    }

    private void onInstructionsChanged(@NotNull String instructions) {
        String previous;
        if (!(this.activeGenerator == null || (previous = this.customInstructions.put(this.activeGenerator.getId(), instructions)) != null && previous.equals(instructions))) {
            this.promptsViewer.refresh();
        }
    }

    private boolean isModified(@NotNull AIPromptGeneratorDescriptor generator) {
        return !this.getCustomInstructions(generator).isEmpty();
    }

    @NotNull
    private String getCustomInstructions(@NotNull AIPromptGeneratorDescriptor generator) {
        return this.customInstructions.getOrDefault(generator.getId(), "");
    }

    private final class ViewerLabelProvider
    extends ColumnLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final StyledString.Styler ITALIC_STYLER = new StyledString.Styler(){

            public void applyStyles(@NotNull TextStyle style) {
                style.font = BaseThemeSettings.instance.treeAndTableFontItalic;
            }
        };

        private ViewerLabelProvider() {
        }

        @NotNull
        public StyledString getStyledText(Object element) {
            AIPromptGeneratorDescriptor descriptor = (AIPromptGeneratorDescriptor)element;
            boolean modified = AIPreferencePagePrompts.this.isModified(descriptor);
            return new StyledString(descriptor.getLabel(), (StyledString.Styler)(modified ? ITALIC_STYLER : null));
        }

        @Nullable
        public Image getImage(@NotNull Object element) {
            AIPromptGeneratorDescriptor descriptor = (AIPromptGeneratorDescriptor)element;
            return descriptor.getIcon() != null ? DBeaverIcons.getImage((DBPImage)descriptor.getIcon()) : null;
        }

        public String getToolTipText(Object element) {
            AIPromptGeneratorDescriptor descriptor = (AIPromptGeneratorDescriptor)element;
            String description = descriptor.getDescription();
            if (description != null) {
                description = StringUtils.wrap((String)description, (int)60);
            }
            return description;
        }
    }
}

