/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.views;

import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.cubrid.ui.internal.CubridMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageCubrid
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.cubrid.general";
    private Button trace;
    private Button info;
    private Button allInfo;
    private Button enableDbmsOutputCheck;
    private Text dbmsOutputBufferSize;
    private Button oid;

    public PrefPageCubrid() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dsContainer) {
        DBPPreferenceStore store = dsContainer.getPreferenceStore();
        return store.contains("pref.dbms.output") || store.contains("pref.dbms.output.buffer.size");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.trace.setSelection(store.getBoolean("statistic_trace"));
        this.info.setSelection(store.getString("statistic").equals("statistic_info"));
        this.allInfo.setSelection(store.getString("statistic").equals("statistic_all_info"));
        this.enableDbmsOutputCheck.setSelection(store.getBoolean("pref.dbms.output"));
        this.dbmsOutputBufferSize.setText(String.valueOf(store.getInt("pref.dbms.output.buffer.size")));
        this.oid.setSelection(store.getBoolean("oid_navigator"));
    }

    protected void savePreferences(DBPPreferenceStore store) {
        store.setValue("pref.dbms.output", this.enableDbmsOutputCheck.getSelection());
        store.setValue("pref.dbms.output.buffer.size", this.dbmsOutputBufferSize.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.clearPreferences(this.getTargetPreferenceStore());
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setValue("statistic_trace", false);
        store.setValue("statistic", "");
        this.trace.setSelection(false);
        this.info.setSelection(false);
        this.allInfo.setSelection(false);
        store.setToDefault("pref.dbms.output");
        store.setToDefault("pref.dbms.output.buffer.size");
        this.oid.setSelection(false);
    }

    @NotNull
    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        final DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        Composite planGroup = UIUtils.createTitledComposite((Composite)composite, (String)CubridMessages.statistic_group_editor_title, (int)1, (int)768);
        this.trace = UIUtils.createCheckbox((Composite)planGroup, (String)CubridMessages.statistic_trace_info, (boolean)false);
        this.trace.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                preferenceStore.setValue("statistic_trace", ((Button)e.widget).getSelection());
            }
        });
        SelectionAdapter radioListener = new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals(preferenceStore.getString("statistic"))) {
                    ((Button)e.widget).setSelection(false);
                    preferenceStore.setValue("statistic", "");
                } else {
                    preferenceStore.setValue("statistic", e.widget.getData().toString());
                }
            }
        };
        this.info = UIUtils.createRadioButton((Composite)planGroup, (String)CubridMessages.statistic_info, (Object)"statistic_info", (SelectionListener)radioListener);
        this.allInfo = UIUtils.createRadioButton((Composite)planGroup, (String)CubridMessages.statistic_all_info, (Object)"statistic_all_info", (SelectionListener)radioListener);
        Composite miscGroup = UIUtils.createTitledComposite((Composite)composite, (String)CubridMessages.pref_page_cubrid_group_dbms_output, (int)2, (int)768);
        this.enableDbmsOutputCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)CubridMessages.pref_page_cubrid_checkbox_enable_dbms_output, (String)"", (boolean)true, (int)2);
        this.dbmsOutputBufferSize = UIUtils.createLabelText((Composite)miscGroup, (String)CubridMessages.pref_page_cubrid_label_buffer_size, (String)"");
        this.dbmsOutputBufferSize.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
        Composite oidNavigator = UIUtils.createTitledComposite((Composite)composite, (String)CubridMessages.pref_page_cubrid_oid_title, (int)1, (int)768);
        this.oid = UIUtils.createCheckbox((Composite)oidNavigator, (String)CubridMessages.pref_page_cubrid_oid_checkbox, (boolean)false);
        this.oid.addSelectionListener((SelectionListener)new SelectionAdapter(this){

            public void widgetSelected(SelectionEvent e) {
                preferenceStore.setValue("oid_navigator", ((Button)e.widget).getSelection());
            }
        });
        return composite;
    }
}

