/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.ColumnLayoutData;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBECommandListener;
import org.jkiss.dbeaver.model.edit.prop.DBECommandProperty;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAdapter;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.ui.ICustomActionsProvider;
import org.jkiss.dbeaver.ui.IRefreshablePart;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomFormEditor;
import org.jkiss.dbeaver.ui.controls.ObjectEditorPageControl;
import org.jkiss.dbeaver.ui.controls.folders.TabbedFolderPage;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditor;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectOpen;

public class TabbedFolderPageForm
extends TabbedFolderPage
implements IRefreshablePart,
ICustomActionsProvider {
    private static final Log log = Log.getLog(TabbedFolderPageForm.class);
    private final IWorkbenchPart part;
    private final IDatabaseEditorInput input;
    private final ObjectEditorPageControl ownerControl;
    private final CustomFormEditor formEditor;
    private Composite propertiesGroup;
    private DBPPropertySource curPropertySource;
    private boolean activated;
    private Button saveButton;
    private Button scriptButton;
    private Button revertButton;
    private transient boolean lastPersistedState;

    TabbedFolderPageForm(IWorkbenchPart part, ObjectEditorPageControl ownerControl, IDatabaseEditorInput input) {
        this.part = part;
        this.ownerControl = ownerControl;
        this.input = input;
        this.formEditor = new CustomFormEditor(this, input.getDatabaseObject(), input.getCommandContext(), input.getPropertySource()){

            protected void openObjectLink(Object linkData) {
                if (linkData instanceof DBSObject) {
                    DBSObject dbsObject = (DBSObject)linkData;
                    NavigatorHandlerObjectOpen.openEntityEditor(dbsObject);
                }
            }
        };
    }

    public void createControl(Composite parent) {
        ScrolledComposite propertiesGroupHost = UIUtils.createScrolledComposite((Composite)parent, (int)512);
        CSSUtils.markConnectionTypeColor((Widget)propertiesGroupHost);
        this.propertiesGroup = new Composite((Composite)propertiesGroupHost, 0);
        UIUtils.configureScrolledComposite((ScrolledComposite)propertiesGroupHost, (Control)this.propertiesGroup);
        this.curPropertySource = this.input.getPropertySource();
        DBECommandContext commandContext = this.input.getCommandContext();
        if (commandContext != null) {
            commandContext.addCommandListener((DBECommandListener)new DBECommandAdapter(){

                public void onCommandChange(DBECommand<?> command) {
                    UIUtils.asyncExec(() -> {
                        TabbedFolderPageForm.this.updateEditButtonsState();
                        if (command instanceof DBECommandProperty) {
                            DBECommandProperty cp = (DBECommandProperty)command;
                            String propId = cp.getHandler().getId();
                            TabbedFolderPageForm.this.formEditor.updateOtherPropertyValues((Object)propId);
                        }
                    });
                }

                public void onSave() {
                    UIUtils.asyncExec(() -> TabbedFolderPageForm.this.updateEditButtonsState());
                }

                public void onReset() {
                    UIUtils.asyncExec(() -> {
                        TabbedFolderPageForm.this.refreshProperties();
                        TabbedFolderPageForm.this.updateEditButtonsState();
                    });
                }
            });
        }
        this.propertiesGroup.addDisposeListener(e -> this.dispose());
        this.refreshProperties();
    }

    private void updateEditButtonsState() {
        if (this.saveButton == null || this.saveButton.isDisposed()) {
            return;
        }
        DBECommandContext commandContext = this.input.getCommandContext();
        boolean isDirty = commandContext != null && commandContext.isDirty();
        this.saveButton.setEnabled(isDirty);
        this.revertButton.setEnabled(isDirty);
        this.scriptButton.setEnabled(isDirty);
    }

    public void setFocus() {
        this.propertiesGroup.setFocus();
    }

    public void dispose() {
        if (this.curPropertySource != null && this.curPropertySource.getEditableValue() instanceof DBSObject) {
            this.curPropertySource = null;
        }
        super.dispose();
    }

    private void refreshProperties() {
        this.refreshProperties(null);
    }

    private void refreshProperties(@Nullable Runnable afterRefresh) {
        boolean firstInit;
        if (this.curPropertySource == null) {
            return;
        }
        this.curPropertySource = this.input.getPropertySource();
        List allProps = this.formEditor.filterProperties(this.curPropertySource.getProperties());
        DBSObject databaseObject = this.input.getDatabaseObject();
        if (databaseObject == null) {
            return;
        }
        boolean objectPersisted = databaseObject.isPersisted();
        boolean objectStateChanged = objectPersisted != this.lastPersistedState;
        this.lastPersistedState = objectPersisted;
        boolean bl = firstInit = !this.formEditor.hasEditors();
        if (firstInit || objectStateChanged) {
            if (!firstInit) {
                UIUtils.disposeChildControls((Composite)this.propertiesGroup);
                this.formEditor.clearEditors();
            }
            if (firstInit) {
                ColumnLayout layout = new ColumnLayout();
                layout.minNumColumns = 1;
                layout.maxNumColumns = 3;
                layout.horizontalSpacing = 10;
                this.propertiesGroup.setLayout((Layout)layout);
                this.propertiesGroup.addControlListener(ControlListener.controlResizedAdapter(e -> this.layoutProperties()));
            }
            ArrayList<DBPPropertyDescriptor> sortedProps = new ArrayList<DBPPropertyDescriptor>(allProps);
            sortedProps.sort(Comparator.comparingInt(prop -> TabbedFolderPageForm.getPropertyCategory(prop, this.curPropertySource)));
            for (DBPPropertyDescriptor prop2 : sortedProps) {
                Composite placeholder = (Composite)((CompositeFactory)((CompositeFactory)CompositeFactory.newComposite((int)0).layoutData((Object)new ColumnLayoutData())).layout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create())).create((Widget)this.propertiesGroup);
                this.formEditor.createPropertyEditor(placeholder, prop2);
                if (placeholder.getChildren().length != 0) continue;
                placeholder.dispose();
            }
            this.layoutProperties();
        }
        for (Control x : this.propertiesGroup.getChildren()) {
            CSSUtils.markConnectionTypeColor((Widget)x);
        }
        UIUtils.installAndUpdateMainFont((Control)this.propertiesGroup);
        this.refreshPropertyValues(allProps, firstInit, afterRefresh);
    }

    private static int getPropertyCategory(@NotNull DBPPropertyDescriptor property, @NotNull DBPPropertySource source) {
        ObjectPropertyDescriptor opd;
        if (property.getId().equals("name") || property.getId().equals("description")) {
            return 1;
        }
        if (property.isEditable(source.getEditableValue())) {
            return 10;
        }
        if (!(property instanceof ObjectPropertyDescriptor) || !(opd = (ObjectPropertyDescriptor)property).isSpecific()) {
            return 100;
        }
        return 1000;
    }

    private void layoutProperties() {
        this.propertiesGroup.layout(true, true);
        TabbedFolderPageForm.layoutPropertyColumns(this.propertiesGroup);
    }

    private static void layoutPropertyColumns(@NotNull Composite composite) {
        Collection<List<Composite>> columns = Stream.of(composite.getChildren()).map(Composite.class::cast).collect(Collectors.groupingBy(child -> child.getLocation().x)).values();
        boolean layout = false;
        for (List<Composite> column : columns) {
            int widthHint = TabbedFolderPageForm.computePropertyColumnWidth(column);
            if (widthHint <= 0) continue;
            layout |= TabbedFolderPageForm.layoutPropertyColumn(column, widthHint);
        }
        if (layout) {
            composite.layout(true, true);
        }
    }

    private static int computePropertyColumnWidth(@NotNull List<Composite> rows) {
        int widthHint = 0;
        for (Composite row : rows) {
            Control key = row.getChildren()[0];
            Rectangle bounds = key.getBounds();
            widthHint = Math.max(widthHint, key.computeSize((int)bounds.width, (int)bounds.height).x);
        }
        return widthHint;
    }

    private static boolean layoutPropertyColumn(@NotNull Collection<Composite> rows, int widthHint) {
        boolean layout = false;
        for (Composite row : rows) {
            GridData gd;
            Control key = row.getChildren()[0];
            Object object = key.getLayoutData();
            if (object instanceof GridData) {
                GridData data;
                gd = data = (GridData)object;
            } else {
                gd = new GridData();
                key.setLayoutData((Object)gd);
            }
            if (gd.widthHint == widthHint) continue;
            gd.widthHint = widthHint;
            layout = true;
        }
        return layout;
    }

    private void showAlterScript() {
        EntityEditor ownerEditor = this.getOwnerEditor();
        if (ownerEditor != null) {
            ownerEditor.showChanges(false);
        }
    }

    private EntityEditor getOwnerEditor() {
        MultiPageEditorSite mpe;
        MultiPageEditorPart mainEditor;
        IWorkbenchPartSite site = this.part.getSite();
        if (site instanceof MultiPageEditorSite && (mainEditor = (mpe = (MultiPageEditorSite)site).getMultiPageEditor()) instanceof EntityEditor) {
            EntityEditor ee = (EntityEditor)mainEditor;
            return ee;
        }
        return null;
    }

    private void refreshPropertyValues(final List<DBPPropertyDescriptor> allProps, boolean disableControls, final Runnable afterRefresh) {
        DBSObject databaseObject = this.input.getDatabaseObject();
        if (databaseObject == null) {
            return;
        }
        disableControls = false;
        ControlEnableState blockEnableState = disableControls ? ControlEnableState.disable((Control)this.propertiesGroup) : null;
        final DBPPropertySource propertySource = this.curPropertySource;
        LoadingJob service = LoadingJob.createService((ILoadService)new DatabaseLoadService<Map<DBPPropertyDescriptor, Object>>(this, "Load '" + DBValueFormatting.getDefaultValueDisplayString((Object)propertySource.getEditableValue(), (DBDDisplayFormat)DBDDisplayFormat.UI) + "' properties", databaseObject.getDataSource()){

            public Map<DBPPropertyDescriptor, Object> evaluate(@NotNull DBRProgressMonitor monitor) {
                HashMap<DBPPropertyDescriptor, Object> propValues = new HashMap<DBPPropertyDescriptor, Object>();
                for (DBPPropertyDescriptor prop : allProps) {
                    if (monitor.isCanceled()) break;
                    Object value = propertySource.getPropertyValue(monitor, prop.getId());
                    propValues.put(prop, value);
                }
                return propValues;
            }
        }, (ILoadVisualizer)this.ownerControl.createDefaultLoadVisualizer(editorValues -> {
            if (this.ownerControl.isDisposed()) {
                return;
            }
            this.formEditor.loadEditorValues(editorValues);
            if (blockEnableState != null) {
                blockEnableState.restore();
            }
        }));
        service.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(this){

            public void done(IJobChangeEvent event) {
                try {
                    if (afterRefresh != null) {
                        UIUtils.asyncExec((Runnable)afterRefresh);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Exception after refreshing in TabbedFolderPageForm", (Throwable)e);
                }
            }
        });
        this.ownerControl.runService(service);
    }

    public IRefreshablePart.RefreshResult refreshPart(Object source, boolean force) {
        return this.refreshPart(force, null);
    }

    public IRefreshablePart.RefreshResult refreshPart(boolean force, @Nullable Runnable afterRefresh) {
        if (force) {
            this.refreshProperties(afterRefresh);
            this.updateEditButtonsState();
            return IRefreshablePart.RefreshResult.REFRESHED;
        }
        return IRefreshablePart.RefreshResult.IGNORED;
    }

    public void aboutToBeShown() {
        if (!this.activated) {
            this.activated = true;
        }
    }

    public void fillCustomActions(IContributionManager contributionManager) {
    }
}

