# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "search service private-endpoint-connection update",
)
class Update(AAZCommand):
    """Update a private endpoint connection to the search service in the given resource group.
    """

    _aaz_info = {
        "version": "2025-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.search/searchservices/{}/privateendpointconnections/{}", "2025-05-01"],
        ]
    }

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.private_endpoint_connection_name = AAZStrArg(
            options=["-n", "--name", "--private-endpoint-connection-name"],
            help="The name of the private endpoint connection to the Azure AI Search service with the specified resource group.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.search_service_name = AAZStrArg(
            options=["--search-service-name"],
            help="The name of the Azure AI Search service associated with the specified resource group.",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                pattern="^(?=.{2,60}$)[a-z0-9][a-z0-9]+(-[a-z0-9]+)*$",
            ),
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.group_id = AAZStrArg(
            options=["--group-id"],
            arg_group="Properties",
            help="The group ID of the Azure resource for which the private link service is for.",
            nullable=True,
        )
        _args_schema.private_endpoint = AAZObjectArg(
            options=["--private-endpoint"],
            arg_group="Properties",
            help="The private endpoint resource from Microsoft.Network provider.",
            nullable=True,
        )
        _args_schema.private_link_service_connection_state = AAZObjectArg(
            options=["--private-link-service-connection-state", "--connection-state"],
            arg_group="Properties",
            help="Describes the current state of an existing Azure Private Link service connection to the private endpoint.",
            nullable=True,
        )
        _args_schema.provisioning_state = AAZStrArg(
            options=["--provisioning-state"],
            arg_group="Properties",
            help="The provisioning state of the private link service connection. Valid values are Updating, Deleting, Failed, Succeeded, Incomplete, or Canceled.",
            nullable=True,
            enum={"Canceled": "Canceled", "Deleting": "Deleting", "Failed": "Failed", "Incomplete": "Incomplete", "Succeeded": "Succeeded", "Updating": "Updating"},
        )

        private_endpoint = cls._args_schema.private_endpoint
        private_endpoint.id = AAZStrArg(
            options=["id"],
            help="The resource ID of the private endpoint resource from Microsoft.Network provider.",
            nullable=True,
        )

        private_link_service_connection_state = cls._args_schema.private_link_service_connection_state
        private_link_service_connection_state.actions_required = AAZStrArg(
            options=["actions-required"],
            help="A description of any extra actions that may be required.",
            nullable=True,
        )
        private_link_service_connection_state.description = AAZStrArg(
            options=["description"],
            help="The description for the private link service connection state.",
            nullable=True,
        )
        private_link_service_connection_state.status = AAZStrArg(
            options=["status"],
            help="Status of the the private link service connection. Valid values are Pending, Approved, Rejected, or Disconnected.",
            nullable=True,
            enum={"Approved": "Approved", "Disconnected": "Disconnected", "Pending": "Pending", "Rejected": "Rejected"},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.PrivateEndpointConnectionsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        self.PrivateEndpointConnectionsUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class PrivateEndpointConnectionsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/privateEndpointConnections/{privateEndpointConnectionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "privateEndpointConnectionName", self.ctx.args.private_endpoint_connection_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "searchServiceName", self.ctx.args.search_service_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_private_endpoint_connection_read(cls._schema_on_200)

            return cls._schema_on_200

    class PrivateEndpointConnectionsUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Search/searchServices/{searchServiceName}/privateEndpointConnections/{privateEndpointConnectionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "privateEndpointConnectionName", self.ctx.args.private_endpoint_connection_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "searchServiceName", self.ctx.args.search_service_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_private_endpoint_connection_read(cls._schema_on_200)

            return cls._schema_on_200

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("properties", AAZObjectType)

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("groupId", AAZStrType, ".group_id")
                properties.set_prop("privateEndpoint", AAZObjectType, ".private_endpoint")
                properties.set_prop("privateLinkServiceConnectionState", AAZObjectType, ".private_link_service_connection_state")
                properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")

            private_endpoint = _builder.get(".properties.privateEndpoint")
            if private_endpoint is not None:
                private_endpoint.set_prop("id", AAZStrType, ".id")

            private_link_service_connection_state = _builder.get(".properties.privateLinkServiceConnectionState")
            if private_link_service_connection_state is not None:
                private_link_service_connection_state.set_prop("actionsRequired", AAZStrType, ".actions_required")
                private_link_service_connection_state.set_prop("description", AAZStrType, ".description")
                private_link_service_connection_state.set_prop("status", AAZStrType, ".status")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_private_endpoint_connection_read = None

    @classmethod
    def _build_schema_private_endpoint_connection_read(cls, _schema):
        if cls._schema_private_endpoint_connection_read is not None:
            _schema.id = cls._schema_private_endpoint_connection_read.id
            _schema.name = cls._schema_private_endpoint_connection_read.name
            _schema.properties = cls._schema_private_endpoint_connection_read.properties
            _schema.system_data = cls._schema_private_endpoint_connection_read.system_data
            _schema.type = cls._schema_private_endpoint_connection_read.type
            return

        cls._schema_private_endpoint_connection_read = _schema_private_endpoint_connection_read = AAZObjectType()

        private_endpoint_connection_read = _schema_private_endpoint_connection_read
        private_endpoint_connection_read.id = AAZStrType(
            flags={"read_only": True},
        )
        private_endpoint_connection_read.name = AAZStrType(
            flags={"read_only": True},
        )
        private_endpoint_connection_read.properties = AAZObjectType()
        private_endpoint_connection_read.system_data = AAZObjectType(
            serialized_name="systemData",
            flags={"read_only": True},
        )
        private_endpoint_connection_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_private_endpoint_connection_read.properties
        properties.group_id = AAZStrType(
            serialized_name="groupId",
        )
        properties.private_endpoint = AAZObjectType(
            serialized_name="privateEndpoint",
        )
        properties.private_link_service_connection_state = AAZObjectType(
            serialized_name="privateLinkServiceConnectionState",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        private_endpoint = _schema_private_endpoint_connection_read.properties.private_endpoint
        private_endpoint.id = AAZStrType()

        private_link_service_connection_state = _schema_private_endpoint_connection_read.properties.private_link_service_connection_state
        private_link_service_connection_state.actions_required = AAZStrType(
            serialized_name="actionsRequired",
        )
        private_link_service_connection_state.description = AAZStrType()
        private_link_service_connection_state.status = AAZStrType()

        system_data = _schema_private_endpoint_connection_read.system_data
        system_data.created_at = AAZStrType(
            serialized_name="createdAt",
        )
        system_data.created_by = AAZStrType(
            serialized_name="createdBy",
        )
        system_data.created_by_type = AAZStrType(
            serialized_name="createdByType",
        )
        system_data.last_modified_at = AAZStrType(
            serialized_name="lastModifiedAt",
        )
        system_data.last_modified_by = AAZStrType(
            serialized_name="lastModifiedBy",
        )
        system_data.last_modified_by_type = AAZStrType(
            serialized_name="lastModifiedByType",
        )

        _schema.id = cls._schema_private_endpoint_connection_read.id
        _schema.name = cls._schema_private_endpoint_connection_read.name
        _schema.properties = cls._schema_private_endpoint_connection_read.properties
        _schema.system_data = cls._schema_private_endpoint_connection_read.system_data
        _schema.type = cls._schema_private_endpoint_connection_read.type


__all__ = ["Update"]
