﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elasticloadbalancing/ElasticLoadBalancing_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace ElasticLoadBalancing {
namespace Model {

/**
 * <p>Information about the configuration of an EC2 instance.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancing-2012-06-01/BackendServerDescription">AWS
 * API Reference</a></p>
 */
class BackendServerDescription {
 public:
  AWS_ELASTICLOADBALANCING_API BackendServerDescription() = default;
  AWS_ELASTICLOADBALANCING_API BackendServerDescription(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_ELASTICLOADBALANCING_API BackendServerDescription& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_ELASTICLOADBALANCING_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index,
                                                   const char* locationValue) const;
  AWS_ELASTICLOADBALANCING_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The port on which the EC2 instance is listening.</p>
   */
  inline int GetInstancePort() const { return m_instancePort; }
  inline bool InstancePortHasBeenSet() const { return m_instancePortHasBeenSet; }
  inline void SetInstancePort(int value) {
    m_instancePortHasBeenSet = true;
    m_instancePort = value;
  }
  inline BackendServerDescription& WithInstancePort(int value) {
    SetInstancePort(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The names of the policies enabled for the EC2 instance.</p>
   */
  inline const Aws::Vector<Aws::String>& GetPolicyNames() const { return m_policyNames; }
  inline bool PolicyNamesHasBeenSet() const { return m_policyNamesHasBeenSet; }
  template <typename PolicyNamesT = Aws::Vector<Aws::String>>
  void SetPolicyNames(PolicyNamesT&& value) {
    m_policyNamesHasBeenSet = true;
    m_policyNames = std::forward<PolicyNamesT>(value);
  }
  template <typename PolicyNamesT = Aws::Vector<Aws::String>>
  BackendServerDescription& WithPolicyNames(PolicyNamesT&& value) {
    SetPolicyNames(std::forward<PolicyNamesT>(value));
    return *this;
  }
  template <typename PolicyNamesT = Aws::String>
  BackendServerDescription& AddPolicyNames(PolicyNamesT&& value) {
    m_policyNamesHasBeenSet = true;
    m_policyNames.emplace_back(std::forward<PolicyNamesT>(value));
    return *this;
  }
  ///@}
 private:
  int m_instancePort{0};

  Aws::Vector<Aws::String> m_policyNames;
  bool m_instancePortHasBeenSet = false;
  bool m_policyNamesHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElasticLoadBalancing
}  // namespace Aws
