/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageBitmapOptions.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ImageBitmapOptions>> convertDictionary<ImageBitmapOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ImageBitmapOptions result;
    JSValue colorSpaceConversionValue;
    if (isNullOrUndefined)
        colorSpaceConversionValue = jsUndefined();
    else {
        colorSpaceConversionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorSpaceConversion"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto colorSpaceConversionConversionResult = convertOptionalWithDefault<IDLEnumeration<ImageBitmapOptions::ColorSpaceConversion>>(lexicalGlobalObject, colorSpaceConversionValue, [&]() -> ConversionResult<IDLEnumeration<ImageBitmapOptions::ColorSpaceConversion>> { return Converter<IDLEnumeration<ImageBitmapOptions::ColorSpaceConversion>>::ReturnType { ImageBitmapOptions::ColorSpaceConversion::Default }; });
    if (colorSpaceConversionConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.colorSpaceConversion = colorSpaceConversionConversionResult.releaseReturnValue();
    JSValue imageOrientationValue;
    if (isNullOrUndefined)
        imageOrientationValue = jsUndefined();
    else {
        imageOrientationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "imageOrientation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto orientationConversionResult = convertOptionalWithDefault<IDLEnumeration<ImageBitmapOptions::Orientation>>(lexicalGlobalObject, imageOrientationValue, [&]() -> ConversionResult<IDLEnumeration<ImageBitmapOptions::Orientation>> { return Converter<IDLEnumeration<ImageBitmapOptions::Orientation>>::ReturnType { ImageBitmapOptions::Orientation::FromImage }; });
    if (orientationConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.orientation = orientationConversionResult.releaseReturnValue();
    JSValue premultiplyAlphaValue;
    if (isNullOrUndefined)
        premultiplyAlphaValue = jsUndefined();
    else {
        premultiplyAlphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "premultiplyAlpha"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto premultiplyAlphaConversionResult = convertOptionalWithDefault<IDLEnumeration<ImageBitmapOptions::PremultiplyAlpha>>(lexicalGlobalObject, premultiplyAlphaValue, [&]() -> ConversionResult<IDLEnumeration<ImageBitmapOptions::PremultiplyAlpha>> { return Converter<IDLEnumeration<ImageBitmapOptions::PremultiplyAlpha>>::ReturnType { ImageBitmapOptions::PremultiplyAlpha::Default }; });
    if (premultiplyAlphaConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.premultiplyAlpha = premultiplyAlphaConversionResult.releaseReturnValue();
    JSValue resizeHeightValue;
    if (isNullOrUndefined)
        resizeHeightValue = jsUndefined();
    else {
        resizeHeightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resizeHeight"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!resizeHeightValue.isUndefined()) {
        auto resizeHeightConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, resizeHeightValue);
        if (resizeHeightConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.resizeHeight = resizeHeightConversionResult.releaseReturnValue();
    }
    JSValue resizeQualityValue;
    if (isNullOrUndefined)
        resizeQualityValue = jsUndefined();
    else {
        resizeQualityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resizeQuality"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto resizeQualityConversionResult = convertOptionalWithDefault<IDLEnumeration<ImageBitmapOptions::ResizeQuality>>(lexicalGlobalObject, resizeQualityValue, [&]() -> ConversionResult<IDLEnumeration<ImageBitmapOptions::ResizeQuality>> { return Converter<IDLEnumeration<ImageBitmapOptions::ResizeQuality>>::ReturnType { ImageBitmapOptions::ResizeQuality::Low }; });
    if (resizeQualityConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.resizeQuality = resizeQualityConversionResult.releaseReturnValue();
    JSValue resizeWidthValue;
    if (isNullOrUndefined)
        resizeWidthValue = jsUndefined();
    else {
        resizeWidthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "resizeWidth"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!resizeWidthValue.isUndefined()) {
        auto resizeWidthConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, resizeWidthValue);
        if (resizeWidthConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.resizeWidth = resizeWidthConversionResult.releaseReturnValue();
    }
    return result;
}

String convertEnumerationToString(ImageBitmapOptions::Orientation enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("from-image"),
        MAKE_STATIC_STRING_IMPL("flipY"),
        MAKE_STATIC_STRING_IMPL("none"),
    };
    static_assert(static_cast<size_t>(ImageBitmapOptions::Orientation::FromImage) == 0, "ImageBitmapOptions::Orientation::FromImage is not 0 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::Orientation::FlipY) == 1, "ImageBitmapOptions::Orientation::FlipY is not 1 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::Orientation::None) == 2, "ImageBitmapOptions::Orientation::None is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageBitmapOptions::Orientation enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageBitmapOptions::Orientation> parseEnumerationFromString<ImageBitmapOptions::Orientation>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ImageBitmapOptions::Orientation>, 3> mappings {
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::Orientation> { "flipY"_s, ImageBitmapOptions::Orientation::FlipY },
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::Orientation> { "from-image"_s, ImageBitmapOptions::Orientation::FromImage },
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::Orientation> { "none"_s, ImageBitmapOptions::Orientation::None },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageBitmapOptions::Orientation> parseEnumeration<ImageBitmapOptions::Orientation>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageBitmapOptions::Orientation>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ImageBitmapOptions::Orientation>()
{
    return "\"from-image\", \"flipY\", \"none\""_s;
}

String convertEnumerationToString(ImageBitmapOptions::PremultiplyAlpha enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("premultiply"),
        MAKE_STATIC_STRING_IMPL("default"),
    };
    static_assert(static_cast<size_t>(ImageBitmapOptions::PremultiplyAlpha::None) == 0, "ImageBitmapOptions::PremultiplyAlpha::None is not 0 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::PremultiplyAlpha::Premultiply) == 1, "ImageBitmapOptions::PremultiplyAlpha::Premultiply is not 1 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::PremultiplyAlpha::Default) == 2, "ImageBitmapOptions::PremultiplyAlpha::Default is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageBitmapOptions::PremultiplyAlpha enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageBitmapOptions::PremultiplyAlpha> parseEnumerationFromString<ImageBitmapOptions::PremultiplyAlpha>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ImageBitmapOptions::PremultiplyAlpha>, 3> mappings {
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::PremultiplyAlpha> { "default"_s, ImageBitmapOptions::PremultiplyAlpha::Default },
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::PremultiplyAlpha> { "none"_s, ImageBitmapOptions::PremultiplyAlpha::None },
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::PremultiplyAlpha> { "premultiply"_s, ImageBitmapOptions::PremultiplyAlpha::Premultiply },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageBitmapOptions::PremultiplyAlpha> parseEnumeration<ImageBitmapOptions::PremultiplyAlpha>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageBitmapOptions::PremultiplyAlpha>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ImageBitmapOptions::PremultiplyAlpha>()
{
    return "\"none\", \"premultiply\", \"default\""_s;
}

String convertEnumerationToString(ImageBitmapOptions::ColorSpaceConversion enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("default"),
    };
    static_assert(static_cast<size_t>(ImageBitmapOptions::ColorSpaceConversion::None) == 0, "ImageBitmapOptions::ColorSpaceConversion::None is not 0 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::ColorSpaceConversion::Default) == 1, "ImageBitmapOptions::ColorSpaceConversion::Default is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageBitmapOptions::ColorSpaceConversion enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageBitmapOptions::ColorSpaceConversion> parseEnumerationFromString<ImageBitmapOptions::ColorSpaceConversion>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ImageBitmapOptions::ColorSpaceConversion>, 2> mappings {
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::ColorSpaceConversion> { "default"_s, ImageBitmapOptions::ColorSpaceConversion::Default },
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::ColorSpaceConversion> { "none"_s, ImageBitmapOptions::ColorSpaceConversion::None },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageBitmapOptions::ColorSpaceConversion> parseEnumeration<ImageBitmapOptions::ColorSpaceConversion>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageBitmapOptions::ColorSpaceConversion>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ImageBitmapOptions::ColorSpaceConversion>()
{
    return "\"none\", \"default\""_s;
}

String convertEnumerationToString(ImageBitmapOptions::ResizeQuality enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 4> values {
        MAKE_STATIC_STRING_IMPL("pixelated"),
        MAKE_STATIC_STRING_IMPL("low"),
        MAKE_STATIC_STRING_IMPL("medium"),
        MAKE_STATIC_STRING_IMPL("high"),
    };
    static_assert(static_cast<size_t>(ImageBitmapOptions::ResizeQuality::Pixelated) == 0, "ImageBitmapOptions::ResizeQuality::Pixelated is not 0 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::ResizeQuality::Low) == 1, "ImageBitmapOptions::ResizeQuality::Low is not 1 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::ResizeQuality::Medium) == 2, "ImageBitmapOptions::ResizeQuality::Medium is not 2 as expected");
    static_assert(static_cast<size_t>(ImageBitmapOptions::ResizeQuality::High) == 3, "ImageBitmapOptions::ResizeQuality::High is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ImageBitmapOptions::ResizeQuality enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ImageBitmapOptions::ResizeQuality> parseEnumerationFromString<ImageBitmapOptions::ResizeQuality>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ImageBitmapOptions::ResizeQuality>, 4> mappings {
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::ResizeQuality> { "high"_s, ImageBitmapOptions::ResizeQuality::High },
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::ResizeQuality> { "low"_s, ImageBitmapOptions::ResizeQuality::Low },
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::ResizeQuality> { "medium"_s, ImageBitmapOptions::ResizeQuality::Medium },
        std::pair<ComparableASCIILiteral, ImageBitmapOptions::ResizeQuality> { "pixelated"_s, ImageBitmapOptions::ResizeQuality::Pixelated },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ImageBitmapOptions::ResizeQuality> parseEnumeration<ImageBitmapOptions::ResizeQuality>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ImageBitmapOptions::ResizeQuality>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ImageBitmapOptions::ResizeQuality>()
{
    return "\"pixelated\", \"low\", \"medium\", \"high\""_s;
}

} // namespace WebCore

