/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCustomAnimationOptions.h"

#include "JSAnimationFrameRatePreset.h"
#include "JSCSSNumericValue.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSFillMode.h"
#include "JSPlaybackDirection.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CustomAnimationOptions>> convertDictionary<CustomAnimationOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CustomAnimationOptions result;
    JSValue delayValue;
    if (isNullOrUndefined)
        delayValue = jsUndefined();
    else {
        delayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delay"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto delayConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, delayValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (delayConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.delay = delayConversionResult.releaseReturnValue();
    JSValue directionValue;
    if (isNullOrUndefined)
        directionValue = jsUndefined();
    else {
        directionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "direction"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto directionConversionResult = convertOptionalWithDefault<IDLEnumeration<PlaybackDirection>>(lexicalGlobalObject, directionValue, [&]() -> ConversionResult<IDLEnumeration<PlaybackDirection>> { return Converter<IDLEnumeration<PlaybackDirection>>::ReturnType { PlaybackDirection::Normal }; });
    if (directionConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.direction = directionConversionResult.releaseReturnValue();
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto durationConversionResult = convertOptionalWithDefault<IDLUnion<IDLUnrestrictedDouble, IDLInterface<CSSNumericValue>, IDLDOMString>>(lexicalGlobalObject, durationValue, [&]() -> ConversionResult<IDLUnion<IDLUnrestrictedDouble, IDLInterface<CSSNumericValue>, IDLDOMString>> { return Converter<IDLUnion<IDLUnrestrictedDouble, IDLInterface<CSSNumericValue>, IDLDOMString>>::ReturnType { "auto"_s }; });
    if (durationConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.duration = durationConversionResult.releaseReturnValue();
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto easingConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, easingValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { "linear"_s }; });
    if (easingConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.easing = easingConversionResult.releaseReturnValue();
    JSValue endDelayValue;
    if (isNullOrUndefined)
        endDelayValue = jsUndefined();
    else {
        endDelayValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "endDelay"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto endDelayConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, endDelayValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0 }; });
    if (endDelayConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.endDelay = endDelayConversionResult.releaseReturnValue();
    JSValue fillValue;
    if (isNullOrUndefined)
        fillValue = jsUndefined();
    else {
        fillValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fill"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto fillConversionResult = convertOptionalWithDefault<IDLEnumeration<FillMode>>(lexicalGlobalObject, fillValue, [&]() -> ConversionResult<IDLEnumeration<FillMode>> { return Converter<IDLEnumeration<FillMode>>::ReturnType { FillMode::Auto }; });
    if (fillConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.fill = fillConversionResult.releaseReturnValue();
    JSValue iterationStartValue;
    if (isNullOrUndefined)
        iterationStartValue = jsUndefined();
    else {
        iterationStartValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterationStart"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto iterationStartConversionResult = convertOptionalWithDefault<IDLDouble>(lexicalGlobalObject, iterationStartValue, [&]() -> ConversionResult<IDLDouble> { return Converter<IDLDouble>::ReturnType { 0.0 }; });
    if (iterationStartConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.iterationStart = iterationStartConversionResult.releaseReturnValue();
    JSValue iterationsValue;
    if (isNullOrUndefined)
        iterationsValue = jsUndefined();
    else {
        iterationsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "iterations"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto iterationsConversionResult = convertOptionalWithDefault<IDLUnrestrictedDouble>(lexicalGlobalObject, iterationsValue, [&]() -> ConversionResult<IDLUnrestrictedDouble> { return Converter<IDLUnrestrictedDouble>::ReturnType { 1.0 }; });
    if (iterationsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.iterations = iterationsConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().webAnimationsCustomFrameRateEnabled) {
        JSValue frameRateValue;
        if (isNullOrUndefined)
            frameRateValue = jsUndefined();
        else {
            frameRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "frameRate"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto frameRateConversionResult = convertOptionalWithDefault<IDLUnion<IDLUnsignedLong, IDLEnumeration<AnimationFrameRatePreset>>>(lexicalGlobalObject, frameRateValue, [&]() -> ConversionResult<IDLUnion<IDLUnsignedLong, IDLEnumeration<AnimationFrameRatePreset>>> { return Converter<IDLUnion<IDLUnsignedLong, IDLEnumeration<AnimationFrameRatePreset>>>::ReturnType { AnimationFrameRatePreset::Auto }; });
        if (frameRateConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.frameRate = frameRateConversionResult.releaseReturnValue();
    }
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto idConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, idValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (idConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.id = idConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

