/* Generated by wayland-scanner 1.24.0 */

#ifndef WPE_AUDIO_SERVER_PROTOCOL_H
#define WPE_AUDIO_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_wpe_audio The wpe_audio protocol
 * @section page_ifaces_wpe_audio Interfaces
 * - @subpage page_iface_wpe_audio - 
 * - @subpage page_iface_wpe_audio_packet_export - 
 * @section page_copyright_wpe_audio Copyright
 * <pre>
 *
 * Copyright © 2020 Igalia S.L.
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct wpe_audio;
struct wpe_audio_packet_export;

#ifndef WPE_AUDIO_INTERFACE
#define WPE_AUDIO_INTERFACE
/**
 * @page page_iface_wpe_audio wpe_audio
 * @section page_iface_wpe_audio_api API
 * See @ref iface_wpe_audio.
 */
/**
 * @defgroup iface_wpe_audio The wpe_audio interface
 */
extern const struct wl_interface wpe_audio_interface;
#endif
#ifndef WPE_AUDIO_PACKET_EXPORT_INTERFACE
#define WPE_AUDIO_PACKET_EXPORT_INTERFACE
/**
 * @page page_iface_wpe_audio_packet_export wpe_audio_packet_export
 * @section page_iface_wpe_audio_packet_export_api API
 * See @ref iface_wpe_audio_packet_export.
 */
/**
 * @defgroup iface_wpe_audio_packet_export The wpe_audio_packet_export interface
 */
extern const struct wl_interface wpe_audio_packet_export_interface;
#endif

/**
 * @ingroup iface_wpe_audio
 * @struct wpe_audio_interface
 */
struct wpe_audio_interface {
	/**
	 * @param id audio stream unique identifier
	 * @param channels number of positional audio channels
	 * @param layout audio format
	 * @param samplerate sample rate
	 */
	void (*stream_started)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t id,
			       int32_t channels,
			       const char *layout,
			       int32_t samplerate);
	/**
	 * @param audio_stream_id audio stream unique identifier
	 * @param fd PCM audio data
	 * @param size packet size in bytes
	 */
	void (*stream_packet)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t id,
			      uint32_t audio_stream_id,
			      int32_t fd,
			      uint32_t size);
	/**
	 * @param id audio stream unique identifier
	 */
	void (*stream_stopped)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t id);
	/**
	 * @param id audio stream unique identifier
	 */
	void (*stream_paused)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t id);
	/**
	 * @param id audio stream unique identifier
	 */
	void (*stream_resumed)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t id);
};


/**
 * @ingroup iface_wpe_audio
 */
#define WPE_AUDIO_STREAM_STARTED_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_audio
 */
#define WPE_AUDIO_STREAM_PACKET_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_audio
 */
#define WPE_AUDIO_STREAM_STOPPED_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_audio
 */
#define WPE_AUDIO_STREAM_PAUSED_SINCE_VERSION 1
/**
 * @ingroup iface_wpe_audio
 */
#define WPE_AUDIO_STREAM_RESUMED_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_audio_packet_export
 * @struct wpe_audio_packet_export_interface
 */
struct wpe_audio_packet_export_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define WPE_AUDIO_PACKET_EXPORT_RELEASE 0

/**
 * @ingroup iface_wpe_audio_packet_export
 */
#define WPE_AUDIO_PACKET_EXPORT_RELEASE_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_audio_packet_export
 */
#define WPE_AUDIO_PACKET_EXPORT_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_wpe_audio_packet_export
 * Sends an release event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
wpe_audio_packet_export_send_release(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, WPE_AUDIO_PACKET_EXPORT_RELEASE);
}

#ifdef  __cplusplus
}
#endif

#endif
