/* Indicator.c generated by valac 0.56.18, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*
 * Copyright (c) 2017 elementary LLC. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 */

#include "nightlight.h"
#include <gtk/gtk.h>
#include <wingpanel.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NIGHTLIGHT_INDICATOR_0_PROPERTY,
	NIGHTLIGHT_INDICATOR_NIGHTLIGHT_STATE_PROPERTY,
	NIGHTLIGHT_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* nightlight_indicator_properties[NIGHTLIGHT_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _NightlightIndicatorPrivate {
	GtkSpinner* indicator_icon;
	GtkStyleContext* style_context;
	NightlightWidgetsPopoverWidget* popover_widget;
};

struct _Block1Data {
	int _ref_count_;
	NightlightIndicator* self;
	NightLightManager* nightlight_manager;
};

static gint NightlightIndicator_private_offset;
static gpointer nightlight_indicator_parent_class = NULL;

static GtkWidget* nightlight_indicator_real_get_display_widget (WingpanelIndicator* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean ___lambda7_ (NightlightIndicator* self,
                      GdkEventButton* e);
static gboolean ____lambda7__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void ___lambda8_ (Block1Data* _data1_);
static void nightlight_indicator_update_tooltip (NightlightIndicator* self,
                                          gboolean snoozed);
static void ____lambda8__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void ___lambda9_ (Block1Data* _data1_);
static void ____lambda9__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static GtkWidget* nightlight_indicator_real_get_widget (WingpanelIndicator* base);
static void nightlight_indicator_real_opened (WingpanelIndicator* base);
static void nightlight_indicator_real_closed (WingpanelIndicator* base);
static void nightlight_indicator_finalize (GObject * obj);
static GType nightlight_indicator_get_type_once (void);
static void _vala_nightlight_indicator_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
nightlight_indicator_get_instance_private (NightlightIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, NightlightIndicator_private_offset);
}

NightlightIndicator*
nightlight_indicator_construct (GType object_type)
{
	NightlightIndicator * self = NULL;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	self = (NightlightIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_NIGHT_LIGHT, NULL);
	return self;
}

NightlightIndicator*
nightlight_indicator_new (void)
{
	return nightlight_indicator_construct (NIGHTLIGHT_TYPE_INDICATOR);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		NightlightIndicator* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->nightlight_manager);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
___lambda7_ (NightlightIndicator* self,
             GdkEventButton* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if (e->button == ((guint) GDK_BUTTON_MIDDLE)) {
		NightLightManager* _tmp0_;
		NightLightManager* _tmp1_;
		_tmp0_ = night_light_manager_get_instance ();
		_tmp1_ = _tmp0_;
		night_light_manager_toggle_snooze (_tmp1_);
		_g_object_unref0 (_tmp1_);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
____lambda7__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = ___lambda7_ ((NightlightIndicator*) self, event);
	return result;
}

static void
___lambda8_ (Block1Data* _data1_)
{
	NightlightIndicator* self;
	gboolean snoozed = FALSE;
	NightLightManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	NightlightWidgetsPopoverWidget* _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->nightlight_manager;
	_tmp1_ = night_light_manager_get_snoozed (_tmp0_);
	_tmp2_ = _tmp1_;
	snoozed = _tmp2_;
	nightlight_indicator_set_nightlight_state (self, !snoozed);
	_tmp3_ = self->priv->popover_widget;
	if (_tmp3_ != NULL) {
		NightlightWidgetsPopoverWidget* _tmp4_;
		_tmp4_ = self->priv->popover_widget;
		nightlight_widgets_popover_widget_set_snoozed (_tmp4_, snoozed);
	}
	nightlight_indicator_update_tooltip (self, snoozed);
}

static void
____lambda8__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda8_ (self);
}

static void
___lambda9_ (Block1Data* _data1_)
{
	NightlightIndicator* self;
	NightLightManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data1_->self;
	_tmp0_ = _data1_->nightlight_manager;
	_tmp1_ = night_light_manager_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	wingpanel_indicator_set_visible ((WingpanelIndicator*) self, _tmp2_);
}

static void
____lambda9__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	___lambda9_ (self);
}

static GtkWidget*
nightlight_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	NightlightIndicator * self;
	GtkSpinner* _tmp0_;
	GtkSpinner* _tmp24_;
	GtkWidget* _tmp25_;
	GtkWidget* result;
	self = (NightlightIndicator*) base;
	_tmp0_ = self->priv->indicator_icon;
	if (_tmp0_ == NULL) {
		Block1Data* _data1_;
		GtkSpinner* _tmp1_;
		GtkIconTheme* _tmp2_;
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp3_;
		GtkCssProvider* _tmp4_;
		GtkSpinner* _tmp5_;
		GtkStyleContext* _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkStyleContext* _tmp8_;
		GtkStyleContext* _tmp9_;
		GtkCssProvider* _tmp10_;
		GtkSpinner* _tmp11_;
		NightLightManager* _tmp12_;
		NightLightManager* _tmp13_;
		NightLightManager* _tmp14_;
		NightLightManager* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		NightLightManager* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		NightLightManager* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_data1_->self = g_object_ref (self);
		_tmp1_ = (GtkSpinner*) gtk_spinner_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->indicator_icon);
		self->priv->indicator_icon = _tmp1_;
		_tmp2_ = gtk_icon_theme_get_default ();
		gtk_icon_theme_add_resource_path (_tmp2_, "/org/elementary/wingpanel/icons");
		_tmp3_ = gtk_css_provider_new ();
		provider = _tmp3_;
		_tmp4_ = provider;
		gtk_css_provider_load_from_resource (_tmp4_, "io/elementary/wingpanel/nightlight/indicator.css");
		_tmp5_ = self->priv->indicator_icon;
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (self->priv->style_context);
		self->priv->style_context = _tmp7_;
		_tmp8_ = self->priv->style_context;
		gtk_style_context_add_class (_tmp8_, "night-light-icon");
		_tmp9_ = self->priv->style_context;
		_tmp10_ = provider;
		gtk_style_context_add_provider (_tmp9_, (GtkStyleProvider*) _tmp10_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		_tmp11_ = self->priv->indicator_icon;
		g_signal_connect_object ((GtkWidget*) _tmp11_, "button-press-event", (GCallback) ____lambda7__gtk_widget_button_press_event, self, 0);
		_tmp12_ = night_light_manager_get_instance ();
		_data1_->nightlight_manager = _tmp12_;
		_tmp13_ = _data1_->nightlight_manager;
		g_signal_connect_data ((GObject*) _tmp13_, "notify::snoozed", (GCallback) ____lambda8__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_tmp14_ = _data1_->nightlight_manager;
		g_signal_connect_data ((GObject*) _tmp14_, "notify::active", (GCallback) ____lambda9__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
		_tmp15_ = _data1_->nightlight_manager;
		_tmp16_ = night_light_manager_get_snoozed (_tmp15_);
		_tmp17_ = _tmp16_;
		nightlight_indicator_set_nightlight_state (self, !_tmp17_);
		_tmp18_ = _data1_->nightlight_manager;
		_tmp19_ = night_light_manager_get_active (_tmp18_);
		_tmp20_ = _tmp19_;
		wingpanel_indicator_set_visible ((WingpanelIndicator*) self, _tmp20_);
		_tmp21_ = _data1_->nightlight_manager;
		_tmp22_ = night_light_manager_get_snoozed (_tmp21_);
		_tmp23_ = _tmp22_;
		nightlight_indicator_update_tooltip (self, _tmp23_);
		_g_object_unref0 (provider);
		block1_data_unref (_data1_);
		_data1_ = NULL;
	}
	_tmp24_ = self->priv->indicator_icon;
	_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
	result = _tmp25_;
	return result;
}

static GtkWidget*
nightlight_indicator_real_get_widget (WingpanelIndicator* base)
{
	NightlightIndicator * self;
	NightlightWidgetsPopoverWidget* _tmp0_;
	NightlightWidgetsPopoverWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* result;
	self = (NightlightIndicator*) base;
	_tmp0_ = self->priv->popover_widget;
	if (_tmp0_ == NULL) {
		GSettings* settings = NULL;
		GSettings* _tmp1_;
		GSettings* _tmp2_;
		NightlightWidgetsPopoverWidget* _tmp3_;
		_tmp1_ = g_settings_new ("org.gnome.settings-daemon.plugins.color");
		settings = _tmp1_;
		_tmp2_ = settings;
		_tmp3_ = nightlight_widgets_popover_widget_new (self, _tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->popover_widget);
		self->priv->popover_widget = _tmp3_;
		_g_object_unref0 (settings);
	}
	_tmp4_ = self->priv->popover_widget;
	_tmp5_ = _g_object_ref0 ((GtkWidget*) _tmp4_);
	result = _tmp5_;
	return result;
}

static void
nightlight_indicator_real_opened (WingpanelIndicator* base)
{
	NightlightIndicator * self;
	self = (NightlightIndicator*) base;
}

static void
nightlight_indicator_real_closed (WingpanelIndicator* base)
{
	NightlightIndicator * self;
	self = (NightlightIndicator*) base;
}

static void
nightlight_indicator_update_tooltip (NightlightIndicator* self,
                                     gboolean snoozed)
{
	gchar* primary_text = NULL;
	gchar* _tmp0_;
	gchar* secondary_text = NULL;
	gchar* _tmp1_;
	GtkSpinner* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Night Light is on"));
	primary_text = _tmp0_;
	_tmp1_ = g_strdup (_ ("Middle-click to snooze"));
	secondary_text = _tmp1_;
	if (snoozed) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = g_strdup (_ ("Night Light is snoozed"));
		_g_free0 (primary_text);
		primary_text = _tmp2_;
		_tmp3_ = g_strdup (_ ("Middle-click to enable"));
		_g_free0 (secondary_text);
		secondary_text = _tmp3_;
	}
	_tmp4_ = self->priv->indicator_icon;
	_tmp5_ = primary_text;
	_tmp6_ = secondary_text;
	_tmp7_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("%s\n%s", _tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (secondary_text);
	_g_free0 (primary_text);
}

void
nightlight_indicator_set_nightlight_state (NightlightIndicator* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = self->priv->style_context;
		gtk_style_context_remove_class (_tmp0_, "disabled");
	} else {
		GtkStyleContext* _tmp1_;
		_tmp1_ = self->priv->style_context;
		gtk_style_context_add_class (_tmp1_, "disabled");
	}
	g_object_notify_by_pspec ((GObject *) self, nightlight_indicator_properties[NIGHTLIGHT_INDICATOR_NIGHTLIGHT_STATE_PROPERTY]);
}

static void
nightlight_indicator_class_init (NightlightIndicatorClass * klass,
                                 gpointer klass_data)
{
	nightlight_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NightlightIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) nightlight_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) nightlight_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) nightlight_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) nightlight_indicator_real_closed;
	G_OBJECT_CLASS (klass)->set_property = _vala_nightlight_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = nightlight_indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIGHTLIGHT_INDICATOR_NIGHTLIGHT_STATE_PROPERTY, nightlight_indicator_properties[NIGHTLIGHT_INDICATOR_NIGHTLIGHT_STATE_PROPERTY] = g_param_spec_boolean ("nightlight-state", "nightlight-state", "nightlight-state", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
}

static void
nightlight_indicator_instance_init (NightlightIndicator * self,
                                    gpointer klass)
{
	self->priv = nightlight_indicator_get_instance_private (self);
	self->priv->indicator_icon = NULL;
	self->priv->popover_widget = NULL;
}

static void
nightlight_indicator_finalize (GObject * obj)
{
	NightlightIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIGHTLIGHT_TYPE_INDICATOR, NightlightIndicator);
	_g_object_unref0 (self->priv->indicator_icon);
	_g_object_unref0 (self->priv->style_context);
	_g_object_unref0 (self->priv->popover_widget);
	G_OBJECT_CLASS (nightlight_indicator_parent_class)->finalize (obj);
}

static GType
nightlight_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NightlightIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nightlight_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NightlightIndicator), 0, (GInstanceInitFunc) nightlight_indicator_instance_init, NULL };
	GType nightlight_indicator_type_id;
	nightlight_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "NightlightIndicator", &g_define_type_info, 0);
	NightlightIndicator_private_offset = g_type_add_instance_private (nightlight_indicator_type_id, sizeof (NightlightIndicatorPrivate));
	return nightlight_indicator_type_id;
}

GType
nightlight_indicator_get_type (void)
{
	static volatile gsize nightlight_indicator_type_id__once = 0;
	if (g_once_init_enter (&nightlight_indicator_type_id__once)) {
		GType nightlight_indicator_type_id;
		nightlight_indicator_type_id = nightlight_indicator_get_type_once ();
		g_once_init_leave (&nightlight_indicator_type_id__once, nightlight_indicator_type_id);
	}
	return nightlight_indicator_type_id__once;
}

static void
_vala_nightlight_indicator_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	NightlightIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NIGHTLIGHT_TYPE_INDICATOR, NightlightIndicator);
	switch (property_id) {
		case NIGHTLIGHT_INDICATOR_NIGHTLIGHT_STATE_PROPERTY:
		nightlight_indicator_set_nightlight_state (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	GSettingsSchema* interface_settings_schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettingsSchema* _tmp3_;
	NightlightIndicator* indicator = NULL;
	NightlightIndicator* _tmp5_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:119: Activating Nightlight Indicator");
	if (server_type != WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION) {
		g_debug ("Indicator.vala:122: Wingpanel is not in session, not loading nightligh" \
"t");
		result = NULL;
		return result;
	}
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "org.gnome.settings-daemon.plugins.color", TRUE);
	interface_settings_schema = _tmp1_;
	_tmp3_ = interface_settings_schema;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		GSettingsSchema* _tmp4_;
		_tmp4_ = interface_settings_schema;
		_tmp2_ = !g_settings_schema_has_key (_tmp4_, "night-light-enabled");
	}
	if (_tmp2_) {
		g_debug ("Indicator.vala:128: No night-light schema found");
		result = NULL;
		_g_settings_schema_unref0 (interface_settings_schema);
		return result;
	}
	_tmp5_ = nightlight_indicator_new ();
	indicator = _tmp5_;
	result = (WingpanelIndicator*) indicator;
	_g_settings_schema_unref0 (interface_settings_schema);
	return result;
}

