/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPublicKeyCredentialRequestOptions.h"

#include "JSDOMGlobalObject.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>

#if ENABLE(WEB_AUTHN)
#include "JSAuthenticationExtensionsClientInputs.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSPublicKeyCredentialDescriptor.h"
#include "JSUserVerificationRequirement.h"
#include <JavaScriptCore/JSArray.h>
#include <wtf/Variant.h>
#endif



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PublicKeyCredentialRequestOptions>> convertDictionary<PublicKeyCredentialRequestOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PublicKeyCredentialRequestOptions result;
#if ENABLE(WEB_AUTHN)
    JSValue allowCredentialsValue;
    if (isNullOrUndefined)
        allowCredentialsValue = jsUndefined();
    else {
        allowCredentialsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "allowCredentials"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto allowCredentialsConversionResult = convertOptionalWithDefault<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>(lexicalGlobalObject, allowCredentialsValue, [&]() -> ConversionResult<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>> { return Converter<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>::ReturnType { }; });
    if (allowCredentialsConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.allowCredentials = allowCredentialsConversionResult.releaseReturnValue();
#endif
#if ENABLE(WEB_AUTHN)
    JSValue challengeValue;
    if (isNullOrUndefined)
        challengeValue = jsUndefined();
    else {
        challengeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "challenge"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (challengeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "challenge"_s, "PublicKeyCredentialRequestOptions"_s, "(ArrayBufferView or ArrayBuffer)"_s);
        return ConversionResultException { };
    }
    auto challengeConversionResult = convert<IDLBufferSource>(lexicalGlobalObject, challengeValue);
    if (challengeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.challenge = challengeConversionResult.releaseReturnValue();
#endif
#if ENABLE(WEB_AUTHN)
    JSValue extensionsValue;
    if (isNullOrUndefined)
        extensionsValue = jsUndefined();
    else {
        extensionsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "extensions"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!extensionsValue.isUndefined()) {
        auto extensionsConversionResult = convert<IDLDictionary<AuthenticationExtensionsClientInputs>>(lexicalGlobalObject, extensionsValue);
        if (extensionsConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.extensions = extensionsConversionResult.releaseReturnValue();
    }
#endif
#if ENABLE(WEB_AUTHN)
    JSValue rpIdValue;
    if (isNullOrUndefined)
        rpIdValue = jsUndefined();
    else {
        rpIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rpId"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!rpIdValue.isUndefined()) {
        auto rpIdConversionResult = convert<IDLDOMString>(lexicalGlobalObject, rpIdValue);
        if (rpIdConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.rpId = rpIdConversionResult.releaseReturnValue();
    }
#endif
#if ENABLE(WEB_AUTHN)
    JSValue timeoutValue;
    if (isNullOrUndefined)
        timeoutValue = jsUndefined();
    else {
        timeoutValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "timeout"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!timeoutValue.isUndefined()) {
        auto timeoutConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, timeoutValue);
        if (timeoutConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.timeout = timeoutConversionResult.releaseReturnValue();
    }
#endif
#if ENABLE(WEB_AUTHN)
    JSValue userVerificationValue;
    if (isNullOrUndefined)
        userVerificationValue = jsUndefined();
    else {
        userVerificationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "userVerification"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto userVerificationConversionResult = convertOptionalWithDefault<IDLEnumeration<UserVerificationRequirement>>(lexicalGlobalObject, userVerificationValue, [&]() -> ConversionResult<IDLEnumeration<UserVerificationRequirement>> { return Converter<IDLEnumeration<UserVerificationRequirement>>::ReturnType { UserVerificationRequirement::Preferred }; });
    if (userVerificationConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.userVerification = userVerificationConversionResult.releaseReturnValue();
#endif
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const PublicKeyCredentialRequestOptions& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

#if ENABLE(WEB_AUTHN)
    auto allowCredentialsValue = toJS<IDLSequence<IDLDictionary<PublicKeyCredentialDescriptor>>>(lexicalGlobalObject, globalObject, throwScope, dictionary.allowCredentials);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "allowCredentials"_s), allowCredentialsValue);
#endif
#if ENABLE(WEB_AUTHN)
    auto challengeValue = toJS<IDLBufferSource>(lexicalGlobalObject, throwScope, dictionary.challenge);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "challenge"_s), challengeValue);
#endif
#if ENABLE(WEB_AUTHN)
    if (!IDLDictionary<AuthenticationExtensionsClientInputs>::isNullValue(dictionary.extensions)) {
        auto extensionsValue = toJS<IDLDictionary<AuthenticationExtensionsClientInputs>>(lexicalGlobalObject, globalObject, throwScope, IDLDictionary<AuthenticationExtensionsClientInputs>::extractValueFromNullable(dictionary.extensions));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "extensions"_s), extensionsValue);
    }
#endif
#if ENABLE(WEB_AUTHN)
    if (!IDLDOMString::isNullValue(dictionary.rpId)) {
        auto rpIdValue = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, IDLDOMString::extractValueFromNullable(dictionary.rpId));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "rpId"_s), rpIdValue);
    }
#endif
#if ENABLE(WEB_AUTHN)
    if (!IDLUnsignedLong::isNullValue(dictionary.timeout)) {
        auto timeoutValue = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, IDLUnsignedLong::extractValueFromNullable(dictionary.timeout));
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "timeout"_s), timeoutValue);
    }
#endif
#if ENABLE(WEB_AUTHN)
    auto userVerificationValue = toJS<IDLEnumeration<UserVerificationRequirement>>(lexicalGlobalObject, throwScope, dictionary.userVerification);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "userVerification"_s), userVerificationValue);
#endif
    UNUSED_PARAM(dictionary);
    UNUSED_VARIABLE(throwScope);

    return result;
}

} // namespace WebCore

