/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigateEvent.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSAbortSignal.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMFormData.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSNavigationDestination.h"
#include "JSNavigationInterceptHandler.h"
#include "JSNavigationNavigationType.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(NavigateEvent::NavigationFocusReset enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("after-transition"),
        MAKE_STATIC_STRING_IMPL("manual"),
    };
    static_assert(static_cast<size_t>(NavigateEvent::NavigationFocusReset::AfterTransition) == 0, "NavigateEvent::NavigationFocusReset::AfterTransition is not 0 as expected");
    static_assert(static_cast<size_t>(NavigateEvent::NavigationFocusReset::Manual) == 1, "NavigateEvent::NavigationFocusReset::Manual is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, NavigateEvent::NavigationFocusReset enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<NavigateEvent::NavigationFocusReset> parseEnumerationFromString<NavigateEvent::NavigationFocusReset>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, NavigateEvent::NavigationFocusReset>, 2> mappings {
        std::pair<ComparableASCIILiteral, NavigateEvent::NavigationFocusReset> { "after-transition"_s, NavigateEvent::NavigationFocusReset::AfterTransition },
        std::pair<ComparableASCIILiteral, NavigateEvent::NavigationFocusReset> { "manual"_s, NavigateEvent::NavigationFocusReset::Manual },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<NavigateEvent::NavigationFocusReset> parseEnumeration<NavigateEvent::NavigationFocusReset>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<NavigateEvent::NavigationFocusReset>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<NavigateEvent::NavigationFocusReset>()
{
    return "\"after-transition\", \"manual\""_s;
}

String convertEnumerationToString(NavigateEvent::NavigationScrollBehavior enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("after-transition"),
        MAKE_STATIC_STRING_IMPL("manual"),
    };
    static_assert(static_cast<size_t>(NavigateEvent::NavigationScrollBehavior::AfterTransition) == 0, "NavigateEvent::NavigationScrollBehavior::AfterTransition is not 0 as expected");
    static_assert(static_cast<size_t>(NavigateEvent::NavigationScrollBehavior::Manual) == 1, "NavigateEvent::NavigationScrollBehavior::Manual is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, NavigateEvent::NavigationScrollBehavior enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<NavigateEvent::NavigationScrollBehavior> parseEnumerationFromString<NavigateEvent::NavigationScrollBehavior>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, NavigateEvent::NavigationScrollBehavior>, 2> mappings {
        std::pair<ComparableASCIILiteral, NavigateEvent::NavigationScrollBehavior> { "after-transition"_s, NavigateEvent::NavigationScrollBehavior::AfterTransition },
        std::pair<ComparableASCIILiteral, NavigateEvent::NavigationScrollBehavior> { "manual"_s, NavigateEvent::NavigationScrollBehavior::Manual },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<NavigateEvent::NavigationScrollBehavior> parseEnumeration<NavigateEvent::NavigationScrollBehavior>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<NavigateEvent::NavigationScrollBehavior>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<NavigateEvent::NavigationScrollBehavior>()
{
    return "\"after-transition\", \"manual\""_s;
}

template<> ConversionResult<IDLDictionary<NavigateEvent::Init>> convertDictionary<NavigateEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    NavigateEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (bubblesConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (cancelableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (composedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue canInterceptValue;
    if (isNullOrUndefined)
        canInterceptValue = jsUndefined();
    else {
        canInterceptValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "canIntercept"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto canInterceptConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, canInterceptValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (canInterceptConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.canIntercept = canInterceptConversionResult.releaseReturnValue();
    JSValue destinationValue;
    if (isNullOrUndefined)
        destinationValue = jsUndefined();
    else {
        destinationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "destination"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (destinationValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "destination"_s, "NavigateEventInit"_s, "NavigationDestination"_s);
        return ConversionResultException { };
    }
    auto destinationConversionResult = convert<IDLInterface<NavigationDestination>>(lexicalGlobalObject, destinationValue);
    if (destinationConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.destination = destinationConversionResult.releaseReturnValue();
    JSValue downloadRequestValue;
    if (isNullOrUndefined)
        downloadRequestValue = jsUndefined();
    else {
        downloadRequestValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "downloadRequest"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto downloadRequestConversionResult = convertOptionalWithDefault<IDLNullable<IDLDOMString>>(lexicalGlobalObject, downloadRequestValue, [&]() -> ConversionResult<IDLNullable<IDLDOMString>> { return typename Converter<IDLNullable<IDLDOMString>>::ReturnType { String() }; });
    if (downloadRequestConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.downloadRequest = downloadRequestConversionResult.releaseReturnValue();
    JSValue formDataValue;
    if (isNullOrUndefined)
        formDataValue = jsUndefined();
    else {
        formDataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "formData"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto formDataConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<DOMFormData>>>(lexicalGlobalObject, formDataValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<DOMFormData>>> { return typename Converter<IDLNullable<IDLInterface<DOMFormData>>>::ReturnType { nullptr }; });
    if (formDataConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.formData = formDataConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().uAVisualTransitionDetectionEnabled) {
        JSValue hasUAVisualTransitionValue;
        if (isNullOrUndefined)
            hasUAVisualTransitionValue = jsUndefined();
        else {
            hasUAVisualTransitionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hasUAVisualTransition"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto hasUAVisualTransitionConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, hasUAVisualTransitionValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
        if (hasUAVisualTransitionConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.hasUAVisualTransition = hasUAVisualTransitionConversionResult.releaseReturnValue();
    }
    JSValue hashChangeValue;
    if (isNullOrUndefined)
        hashChangeValue = jsUndefined();
    else {
        hashChangeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hashChange"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto hashChangeConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, hashChangeValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (hashChangeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.hashChange = hashChangeConversionResult.releaseReturnValue();
    JSValue infoValue;
    if (isNullOrUndefined)
        infoValue = jsUndefined();
    else {
        infoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "info"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto infoConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, infoValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (infoConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.info = infoConversionResult.releaseReturnValue();
    JSValue navigationTypeValue;
    if (isNullOrUndefined)
        navigationTypeValue = jsUndefined();
    else {
        navigationTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "navigationType"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto navigationTypeConversionResult = convertOptionalWithDefault<IDLEnumeration<NavigationNavigationType>>(lexicalGlobalObject, navigationTypeValue, [&]() -> ConversionResult<IDLEnumeration<NavigationNavigationType>> { return Converter<IDLEnumeration<NavigationNavigationType>>::ReturnType { NavigationNavigationType::Push }; });
    if (navigationTypeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.navigationType = navigationTypeConversionResult.releaseReturnValue();
    JSValue signalValue;
    if (isNullOrUndefined)
        signalValue = jsUndefined();
    else {
        signalValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "signal"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (signalValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "signal"_s, "NavigateEventInit"_s, "AbortSignal"_s);
        return ConversionResultException { };
    }
    auto signalConversionResult = convert<IDLInterface<AbortSignal>>(lexicalGlobalObject, signalValue);
    if (signalConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.signal = signalConversionResult.releaseReturnValue();
    JSValue sourceElementValue;
    if (isNullOrUndefined)
        sourceElementValue = jsUndefined();
    else {
        sourceElementValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sourceElement"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sourceElementConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, sourceElementValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<Element>>> { return typename Converter<IDLNullable<IDLInterface<Element>>>::ReturnType { nullptr }; });
    if (sourceElementConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.sourceElement = sourceElementConversionResult.releaseReturnValue();
    JSValue userInitiatedValue;
    if (isNullOrUndefined)
        userInitiatedValue = jsUndefined();
    else {
        userInitiatedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "userInitiated"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto userInitiatedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, userInitiatedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (userInitiatedConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.userInitiated = userInitiatedConversionResult.releaseReturnValue();
    return result;
}

template<> ConversionResult<IDLDictionary<NavigateEvent::NavigationInterceptOptions>> convertDictionary<NavigateEvent::NavigationInterceptOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    NavigateEvent::NavigationInterceptOptions result;
    JSValue focusResetValue;
    if (isNullOrUndefined)
        focusResetValue = jsUndefined();
    else {
        focusResetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "focusReset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!focusResetValue.isUndefined()) {
        auto focusResetConversionResult = convert<IDLEnumeration<NavigateEvent::NavigationFocusReset>>(lexicalGlobalObject, focusResetValue);
        if (focusResetConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.focusReset = focusResetConversionResult.releaseReturnValue();
    }
    JSValue handlerValue;
    if (isNullOrUndefined)
        handlerValue = jsUndefined();
    else {
        handlerValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "handler"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!handlerValue.isUndefined()) {
        auto handlerConversionResult = convert<IDLCallbackFunction<JSNavigationInterceptHandler>>(lexicalGlobalObject, handlerValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        if (handlerConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.handler = handlerConversionResult.releaseReturnValue();
    }
    JSValue scrollValue;
    if (isNullOrUndefined)
        scrollValue = jsUndefined();
    else {
        scrollValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "scroll"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!scrollValue.isUndefined()) {
        auto scrollConversionResult = convert<IDLEnumeration<NavigateEvent::NavigationScrollBehavior>>(lexicalGlobalObject, scrollValue);
        if (scrollConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.scroll = scrollConversionResult.releaseReturnValue();
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNavigateEventPrototypeFunction_intercept);
static JSC_DECLARE_HOST_FUNCTION(jsNavigateEventPrototypeFunction_scroll);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_navigationType);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_destination);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_canIntercept);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_userInitiated);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_hashChange);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_signal);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_formData);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_downloadRequest);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_info);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_sourceElement);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigateEvent_hasUAVisualTransition);

class JSNavigateEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigateEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigateEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigateEventPrototype>(vm)) JSNavigateEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigateEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigateEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigateEventPrototype, JSNavigateEventPrototype::Base);

using JSNavigateEventDOMConstructor = JSDOMConstructor<JSNavigateEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSNavigateEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSNavigateEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<NavigateEvent::Init>>(*lexicalGlobalObject, argument1.value());
    if (eventInitDictConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = NavigateEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<NavigateEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<NavigateEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSNavigateEventDOMConstructorConstruct, JSNavigateEventDOMConstructor::construct);

template<> const ClassInfo JSNavigateEventDOMConstructor::s_info = { "NavigateEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigateEventDOMConstructor) };

template<> JSValue JSNavigateEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSNavigateEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(2), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "NavigateEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigateEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 14> JSNavigateEventPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEventConstructor, 0 } },
    HashTableValue { "navigationType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_navigationType, 0 } },
    HashTableValue { "destination"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_destination, 0 } },
    HashTableValue { "canIntercept"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_canIntercept, 0 } },
    HashTableValue { "userInitiated"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_userInitiated, 0 } },
    HashTableValue { "hashChange"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_hashChange, 0 } },
    HashTableValue { "signal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_signal, 0 } },
    HashTableValue { "formData"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_formData, 0 } },
    HashTableValue { "downloadRequest"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_downloadRequest, 0 } },
    HashTableValue { "info"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_info, 0 } },
    HashTableValue { "sourceElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_sourceElement, 0 } },
    HashTableValue { "hasUAVisualTransition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigateEvent_hasUAVisualTransition, 0 } },
    HashTableValue { "intercept"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigateEventPrototypeFunction_intercept, 0 } },
    HashTableValue { "scroll"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigateEventPrototypeFunction_scroll, 0 } },
};

const ClassInfo JSNavigateEventPrototype::s_info = { "NavigateEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigateEventPrototype) };

void JSNavigateEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigateEvent::info(), JSNavigateEventPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().uAVisualTransitionDetectionEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "hasUAVisualTransition"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigateEvent::s_info = { "NavigateEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigateEvent) };

JSNavigateEvent::JSNavigateEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<NavigateEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<NavigateEvent> JSNavigateEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, NavigateEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigateEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigateEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSNavigateEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigateEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigateEvent>(vm, globalObject);
}

JSValue JSNavigateEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigateEventDOMConstructor, DOMConstructorID::NavigateEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigateEventPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigateEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsNavigateEvent_navigationTypeGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<NavigationNavigationType>>(lexicalGlobalObject, throwScope, impl.navigationType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_navigationType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_navigationTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_destinationGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<NavigationDestination>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.destination())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_destination, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_destinationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_canInterceptGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.canIntercept())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_canIntercept, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_canInterceptGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_userInitiatedGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.userInitiated())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_userInitiated, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_userInitiatedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_hashChangeGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hashChange())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_hashChange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_hashChangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_signalGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AbortSignal>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.signal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_signal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_signalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_formDataGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<DOMFormData>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.formData())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_formData, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_formDataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_downloadRequestGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.downloadRequest())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_downloadRequest, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_downloadRequestGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_infoGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAny>(lexicalGlobalObject, throwScope, impl.info())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_info, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_infoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_sourceElementGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sourceElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_sourceElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_sourceElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigateEvent_hasUAVisualTransitionGetter(JSGlobalObject& lexicalGlobalObject, JSNavigateEvent& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasUAVisualTransition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigateEvent_hasUAVisualTransition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigateEvent>::get<jsNavigateEvent_hasUAVisualTransitionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsNavigateEventPrototypeFunction_interceptBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigateEvent>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RefPtr context = (*castedThis).globalObject()->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<NavigateEvent::NavigationInterceptOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.intercept(document.get(), optionsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigateEventPrototypeFunction_intercept, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigateEvent>::call<jsNavigateEventPrototypeFunction_interceptBody>(*lexicalGlobalObject, *callFrame, "intercept");
}

static inline JSC::EncodedJSValue jsNavigateEventPrototypeFunction_scrollBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigateEvent>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RefPtr context = (*castedThis).globalObject()->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.scroll(document.get()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigateEventPrototypeFunction_scroll, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigateEvent>::call<jsNavigateEventPrototypeFunction_scrollBody>(*lexicalGlobalObject, *callFrame, "scroll");
}

JSC::GCClient::IsoSubspace* JSNavigateEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigateEvent, UseCustomHeapCellType::No>(vm, "JSNavigateEvent"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigateEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigateEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigateEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigateEvent = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSNavigateEvent::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSNavigateEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSNavigateEvent);

template<typename Visitor>
void JSNavigateEvent::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSNavigateEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSNavigateEvent::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSNavigateEvent::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSNavigateEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigateEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSNavigateEventOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsNavigateEvent = jsCast<JSNavigateEvent*>(handle.slot()->asCell());
    NavigateEvent* owner = &jsNavigateEvent->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from NavigateEvent"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSNavigateEventOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNavigateEvent = static_cast<JSNavigateEvent*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNavigateEvent->protectedWrapped().ptr(), jsNavigateEvent);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7NavigateEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13NavigateEventE[]; }
#endif
template<std::same_as<NavigateEvent> T>
static inline void verifyVTable(NavigateEvent* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7NavigateEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13NavigateEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // NavigateEvent has subclasses. If NavigateEvent has subclasses that get passed
        // to toJS() we currently require NavigateEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<NavigateEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<NavigateEvent>(impl.ptr());
#endif
    return createWrapper<NavigateEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, NavigateEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
