/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_RECORDER)

#include "JSMediaRecorder.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "Document.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSMediaStream.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaRecorder::RecordingState enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("inactive"),
        MAKE_STATIC_STRING_IMPL("recording"),
        MAKE_STATIC_STRING_IMPL("paused"),
    };
    static_assert(static_cast<size_t>(MediaRecorder::RecordingState::Inactive) == 0, "MediaRecorder::RecordingState::Inactive is not 0 as expected");
    static_assert(static_cast<size_t>(MediaRecorder::RecordingState::Recording) == 1, "MediaRecorder::RecordingState::Recording is not 1 as expected");
    static_assert(static_cast<size_t>(MediaRecorder::RecordingState::Paused) == 2, "MediaRecorder::RecordingState::Paused is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, MediaRecorder::RecordingState enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<MediaRecorder::RecordingState> parseEnumerationFromString<MediaRecorder::RecordingState>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, MediaRecorder::RecordingState>, 3> mappings {
        std::pair<ComparableASCIILiteral, MediaRecorder::RecordingState> { "inactive"_s, MediaRecorder::RecordingState::Inactive },
        std::pair<ComparableASCIILiteral, MediaRecorder::RecordingState> { "paused"_s, MediaRecorder::RecordingState::Paused },
        std::pair<ComparableASCIILiteral, MediaRecorder::RecordingState> { "recording"_s, MediaRecorder::RecordingState::Recording },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<MediaRecorder::RecordingState> parseEnumeration<MediaRecorder::RecordingState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<MediaRecorder::RecordingState>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<MediaRecorder::RecordingState>()
{
    return "\"inactive\", \"recording\", \"paused\""_s;
}

template<> ConversionResult<IDLDictionary<MediaRecorder::Options>> convertDictionary<MediaRecorder::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    MediaRecorder::Options result;
    JSValue audioBitsPerSecondValue;
    if (isNullOrUndefined)
        audioBitsPerSecondValue = jsUndefined();
    else {
        audioBitsPerSecondValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audioBitsPerSecond"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!audioBitsPerSecondValue.isUndefined()) {
        auto audioBitsPerSecondConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, audioBitsPerSecondValue);
        if (audioBitsPerSecondConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.audioBitsPerSecond = audioBitsPerSecondConversionResult.releaseReturnValue();
    }
    JSValue bitsPerSecondValue;
    if (isNullOrUndefined)
        bitsPerSecondValue = jsUndefined();
    else {
        bitsPerSecondValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitsPerSecond"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bitsPerSecondValue.isUndefined()) {
        auto bitsPerSecondConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, bitsPerSecondValue);
        if (bitsPerSecondConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.bitsPerSecond = bitsPerSecondConversionResult.releaseReturnValue();
    }
    JSValue mimeTypeValue;
    if (isNullOrUndefined)
        mimeTypeValue = jsUndefined();
    else {
        mimeTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mimeType"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!mimeTypeValue.isUndefined()) {
        auto mimeTypeConversionResult = convert<IDLDOMString>(lexicalGlobalObject, mimeTypeValue);
        if (mimeTypeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.mimeType = mimeTypeConversionResult.releaseReturnValue();
    }
    JSValue videoBitsPerSecondValue;
    if (isNullOrUndefined)
        videoBitsPerSecondValue = jsUndefined();
    else {
        videoBitsPerSecondValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "videoBitsPerSecond"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!videoBitsPerSecondValue.isUndefined()) {
        auto videoBitsPerSecondConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, videoBitsPerSecondValue);
        if (videoBitsPerSecondConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.videoBitsPerSecond = videoBitsPerSecondConversionResult.releaseReturnValue();
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_start);
static JSC_DECLARE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_stop);
static JSC_DECLARE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_pause);
static JSC_DECLARE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_resume);
static JSC_DECLARE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_requestData);
static JSC_DECLARE_HOST_FUNCTION(jsMediaRecorderConstructorFunction_isTypeSupported);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorderConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_stream);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_mimeType);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_state);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_onstart);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaRecorder_onstart);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_onstop);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaRecorder_onstop);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_ondataavailable);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaRecorder_ondataavailable);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_onpause);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaRecorder_onpause);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_onresume);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaRecorder_onresume);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_onerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSMediaRecorder_onerror);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_videoBitsPerSecond);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaRecorder_audioBitsPerSecond);

class JSMediaRecorderPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaRecorderPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaRecorderPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaRecorderPrototype>(vm)) JSMediaRecorderPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaRecorderPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaRecorderPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaRecorderPrototype, JSMediaRecorderPrototype::Base);

using JSMediaRecorderDOMConstructor = JSDOMConstructor<JSMediaRecorder>;

/* Hash table for constructor */

static const std::array<HashTableValue, 1> JSMediaRecorderConstructorTableValues {
    HashTableValue { "isTypeSupported"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaRecorderConstructorFunction_isTypeSupported, 1 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSMediaRecorderDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSMediaRecorderDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    RefPtr context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaRecorder"_s);
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto streamConversionResult = convert<IDLInterface<MediaStream>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "stream"_s, "MediaRecorder"_s, nullptr, "MediaStream"_s); });
    if (streamConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<MediaRecorder::Options>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = MediaRecorder::create(document.get(), *streamConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<MediaRecorder>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<MediaRecorder>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSMediaRecorderDOMConstructorConstruct, JSMediaRecorderDOMConstructor::construct);

template<> const ClassInfo JSMediaRecorderDOMConstructor::s_info = { "MediaRecorder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRecorderDOMConstructor) };

template<> JSValue JSMediaRecorderDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaRecorderDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaRecorder"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaRecorder::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSMediaRecorder::info(), JSMediaRecorderConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 17> JSMediaRecorderPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorderConstructor, 0 } },
    HashTableValue { "stream"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_stream, 0 } },
    HashTableValue { "mimeType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_mimeType, 0 } },
    HashTableValue { "state"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_state, 0 } },
    HashTableValue { "onstart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_onstart, setJSMediaRecorder_onstart } },
    HashTableValue { "onstop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_onstop, setJSMediaRecorder_onstop } },
    HashTableValue { "ondataavailable"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_ondataavailable, setJSMediaRecorder_ondataavailable } },
    HashTableValue { "onpause"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_onpause, setJSMediaRecorder_onpause } },
    HashTableValue { "onresume"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_onresume, setJSMediaRecorder_onresume } },
    HashTableValue { "onerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_onerror, setJSMediaRecorder_onerror } },
    HashTableValue { "videoBitsPerSecond"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_videoBitsPerSecond, 0 } },
    HashTableValue { "audioBitsPerSecond"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaRecorder_audioBitsPerSecond, 0 } },
    HashTableValue { "start"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaRecorderPrototypeFunction_start, 0 } },
    HashTableValue { "stop"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaRecorderPrototypeFunction_stop, 0 } },
    HashTableValue { "pause"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaRecorderPrototypeFunction_pause, 0 } },
    HashTableValue { "resume"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaRecorderPrototypeFunction_resume, 0 } },
    HashTableValue { "requestData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMediaRecorderPrototypeFunction_requestData, 0 } },
};

const ClassInfo JSMediaRecorderPrototype::s_info = { "MediaRecorder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRecorderPrototype) };

void JSMediaRecorderPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaRecorder::info(), JSMediaRecorderPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaRecorder::s_info = { "MediaRecorder"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRecorder) };

JSMediaRecorder::JSMediaRecorder(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaRecorder>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<MediaRecorder> JSMediaRecorder::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, MediaRecorder>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSMediaRecorder::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaRecorderPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMediaRecorderPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaRecorder::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaRecorder>(vm, globalObject);
}

JSValue JSMediaRecorder::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaRecorderDOMConstructor, DOMConstructorID::MediaRecorder>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorderConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaRecorderPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaRecorder::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMediaRecorder_streamGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<MediaStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.stream())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_stream, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_streamGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaRecorder_mimeTypeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.mimeType())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_mimeType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_mimeTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaRecorder_stateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<MediaRecorder::RecordingState>>(lexicalGlobalObject, throwScope, impl.state())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_state, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_stateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaRecorder_onstartGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().startEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_onstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_onstartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaRecorder_onstartSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().startEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaRecorder_onstart, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorder_onstartSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaRecorder_onstopGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().stopEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_onstop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_onstopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaRecorder_onstopSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().stopEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaRecorder_onstop, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorder_onstopSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaRecorder_ondataavailableGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().dataavailableEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_ondataavailable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_ondataavailableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaRecorder_ondataavailableSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().dataavailableEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaRecorder_ondataavailable, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorder_ondataavailableSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaRecorder_onpauseGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().pauseEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_onpauseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaRecorder_onpauseSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().pauseEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaRecorder_onpause, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorder_onpauseSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaRecorder_onresumeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().resumeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_onresume, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_onresumeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaRecorder_onresumeSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().resumeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaRecorder_onresume, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorder_onresumeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaRecorder_onerrorGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().errorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_onerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSMediaRecorder_onerrorSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().errorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSMediaRecorder_onerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::set<setJSMediaRecorder_onerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsMediaRecorder_videoBitsPerSecondGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.videoBitsPerSecond())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_videoBitsPerSecond, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_videoBitsPerSecondGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaRecorder_audioBitsPerSecondGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRecorder& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.audioBitsPerSecond())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaRecorder_audioBitsPerSecond, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaRecorder>::get<jsMediaRecorder_audioBitsPerSecondGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsMediaRecorderPrototypeFunction_startBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaRecorder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto timesliceConversionResult = convert<IDLOptional<IDLUnsignedLong>>(*lexicalGlobalObject, argument0.value());
    if (timesliceConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.startRecording(timesliceConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_start, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaRecorder>::call<jsMediaRecorderPrototypeFunction_startBody>(*lexicalGlobalObject, *callFrame, "start");
}

static inline JSC::EncodedJSValue jsMediaRecorderPrototypeFunction_stopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaRecorder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stopRecording(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_stop, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaRecorder>::call<jsMediaRecorderPrototypeFunction_stopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

static inline JSC::EncodedJSValue jsMediaRecorderPrototypeFunction_pauseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaRecorder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.pauseRecording(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_pause, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaRecorder>::call<jsMediaRecorderPrototypeFunction_pauseBody>(*lexicalGlobalObject, *callFrame, "pause");
}

static inline JSC::EncodedJSValue jsMediaRecorderPrototypeFunction_resumeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaRecorder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.resumeRecording(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_resume, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaRecorder>::call<jsMediaRecorderPrototypeFunction_resumeBody>(*lexicalGlobalObject, *callFrame, "resume");
}

static inline JSC::EncodedJSValue jsMediaRecorderPrototypeFunction_requestDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaRecorder>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.requestData(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaRecorderPrototypeFunction_requestData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaRecorder>::call<jsMediaRecorderPrototypeFunction_requestDataBody>(*lexicalGlobalObject, *callFrame, "requestData");
}

static inline JSC::EncodedJSValue jsMediaRecorderConstructorFunction_isTypeSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    RefPtr context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    Ref document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (typeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, MediaRecorder::isTypeSupported(document.get(), typeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsMediaRecorderConstructorFunction_isTypeSupported, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMediaRecorder>::callStatic<jsMediaRecorderConstructorFunction_isTypeSupportedBody>(*lexicalGlobalObject, *callFrame, "isTypeSupported");
}

JSC::GCClient::IsoSubspace* JSMediaRecorder::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaRecorder, UseCustomHeapCellType::No>(vm, "JSMediaRecorder"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaRecorder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaRecorder = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaRecorder.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaRecorder = std::forward<decltype(space)>(space); }
    );
}

void JSMediaRecorder::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaRecorder*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaRecorderOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsMediaRecorder = jsCast<JSMediaRecorder*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsMediaRecorder->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaRecorderOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaRecorder = static_cast<JSMediaRecorder*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaRecorder->protectedWrapped().ptr(), jsMediaRecorder);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaRecorder@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13MediaRecorderE[]; }
#endif
template<std::same_as<MediaRecorder> T>
static inline void verifyVTable(MediaRecorder* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaRecorder@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13MediaRecorderE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaRecorder has subclasses. If MediaRecorder has subclasses that get passed
        // to toJS() we currently require MediaRecorder you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaRecorder>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<MediaRecorder>(impl.ptr());
#endif
    return createWrapper<MediaRecorder>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaRecorder& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaRecorder* JSMediaRecorder::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaRecorder*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_RECORDER)
