/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLVideoElement.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DocumentInlines.h"
#include "ElementInlines.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSVideoPlaybackQuality.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

#if ENABLE(PICTURE_IN_PICTURE_API)
#include "DOMPromiseProxy.h"
#include "HTMLVideoElementPictureInPicture.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSEventListener.h"
#include "JSPictureInPictureWindow.h"
#endif

#if ENABLE(VIDEO)
#include "JSDOMConvertCallbacks.h"
#include "JSVideoFrameRequestCallback.h"
#endif

namespace WebCore {
using namespace JSC;

#if ENABLE(VIDEO_PRESENTATION_MODE)

String convertEnumerationToString(HTMLVideoElement::VideoPresentationMode enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("inline"),
        MAKE_STATIC_STRING_IMPL("fullscreen"),
        MAKE_STATIC_STRING_IMPL("picture-in-picture"),
    };
    static_assert(static_cast<size_t>(HTMLVideoElement::VideoPresentationMode::Inline) == 0, "HTMLVideoElement::VideoPresentationMode::Inline is not 0 as expected");
    static_assert(static_cast<size_t>(HTMLVideoElement::VideoPresentationMode::Fullscreen) == 1, "HTMLVideoElement::VideoPresentationMode::Fullscreen is not 1 as expected");
    static_assert(static_cast<size_t>(HTMLVideoElement::VideoPresentationMode::PictureInPicture) == 2, "HTMLVideoElement::VideoPresentationMode::PictureInPicture is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, HTMLVideoElement::VideoPresentationMode enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<HTMLVideoElement::VideoPresentationMode> parseEnumerationFromString<HTMLVideoElement::VideoPresentationMode>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, HTMLVideoElement::VideoPresentationMode>, 3> mappings {
        std::pair<ComparableASCIILiteral, HTMLVideoElement::VideoPresentationMode> { "fullscreen"_s, HTMLVideoElement::VideoPresentationMode::Fullscreen },
        std::pair<ComparableASCIILiteral, HTMLVideoElement::VideoPresentationMode> { "inline"_s, HTMLVideoElement::VideoPresentationMode::Inline },
        std::pair<ComparableASCIILiteral, HTMLVideoElement::VideoPresentationMode> { "picture-in-picture"_s, HTMLVideoElement::VideoPresentationMode::PictureInPicture },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<HTMLVideoElement::VideoPresentationMode> parseEnumeration<HTMLVideoElement::VideoPresentationMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<HTMLVideoElement::VideoPresentationMode>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<HTMLVideoElement::VideoPresentationMode>()
{
    return "\"inline\", \"fullscreen\", \"picture-in-picture\""_s;
}

#endif

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitEnterFullscreen);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitExitFullscreen);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitEnterFullScreen);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitExitFullScreen);
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_getVideoPlaybackQuality);
#if ENABLE(VIDEO_PRESENTATION_MODE)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitSupportsPresentationMode);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitSetPresentationMode);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_requestPictureInPicture);
#endif
#if ENABLE(VIDEO)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_requestVideoFrameCallback);
#endif
#if ENABLE(VIDEO)
static JSC_DECLARE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_cancelVideoFrameCallback);
#endif

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_width);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_height);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_height);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_videoWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_videoHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_poster);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_poster);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_playsInline);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_playsInline);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_webkitSupportsFullscreen);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_webkitDisplayingFullscreen);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_webkitWirelessVideoPlaybackDisabled);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_webkitWirelessVideoPlaybackDisabled);
#endif
#if ENABLE(MEDIA_STATISTICS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_webkitDecodedFrameCount);
#endif
#if ENABLE(MEDIA_STATISTICS)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_webkitDroppedFrameCount);
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_webkitPresentationMode);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_onenterpictureinpicture);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_onenterpictureinpicture);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_onleavepictureinpicture);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_onleavepictureinpicture);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_autoPictureInPicture);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_autoPictureInPicture);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLVideoElement_disablePictureInPicture);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLVideoElement_disablePictureInPicture);
#endif

class JSHTMLVideoElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLVideoElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLVideoElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLVideoElementPrototype>(vm)) JSHTMLVideoElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLVideoElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLVideoElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLVideoElementPrototype, JSHTMLVideoElementPrototype::Base);

using JSHTMLVideoElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLVideoElement>;

template<> const ClassInfo JSHTMLVideoElementDOMConstructor::s_info = { "HTMLVideoElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLVideoElementDOMConstructor) };

template<> JSValue JSHTMLVideoElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLMediaElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLVideoElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLVideoElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLVideoElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 27> JSHTMLVideoElementPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElementConstructor, 0 } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_width, setJSHTMLVideoElement_width } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_height, setJSHTMLVideoElement_height } },
    HashTableValue { "videoWidth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_videoWidth, 0 } },
    HashTableValue { "videoHeight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_videoHeight, 0 } },
    HashTableValue { "poster"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_poster, setJSHTMLVideoElement_poster } },
    HashTableValue { "playsInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_playsInline, setJSHTMLVideoElement_playsInline } },
    HashTableValue { "webkitSupportsFullscreen"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_webkitSupportsFullscreen, 0 } },
    HashTableValue { "webkitDisplayingFullscreen"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_webkitDisplayingFullscreen, 0 } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    HashTableValue { "webkitWirelessVideoPlaybackDisabled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_webkitWirelessVideoPlaybackDisabled, setJSHTMLVideoElement_webkitWirelessVideoPlaybackDisabled } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    HashTableValue { "webkitDecodedFrameCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_webkitDecodedFrameCount, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    HashTableValue { "webkitDroppedFrameCount"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_webkitDroppedFrameCount, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    HashTableValue { "webkitPresentationMode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_webkitPresentationMode, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    HashTableValue { "onenterpictureinpicture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_onenterpictureinpicture, setJSHTMLVideoElement_onenterpictureinpicture } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    HashTableValue { "onleavepictureinpicture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_onleavepictureinpicture, setJSHTMLVideoElement_onleavepictureinpicture } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    HashTableValue { "autoPictureInPicture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_autoPictureInPicture, setJSHTMLVideoElement_autoPictureInPicture } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    HashTableValue { "disablePictureInPicture"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLVideoElement_disablePictureInPicture, setJSHTMLVideoElement_disablePictureInPicture } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    HashTableValue { "webkitEnterFullscreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_webkitEnterFullscreen, 0 } },
    HashTableValue { "webkitExitFullscreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_webkitExitFullscreen, 0 } },
    HashTableValue { "webkitEnterFullScreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_webkitEnterFullScreen, 0 } },
    HashTableValue { "webkitExitFullScreen"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_webkitExitFullScreen, 0 } },
    HashTableValue { "getVideoPlaybackQuality"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_getVideoPlaybackQuality, 0 } },
#if ENABLE(VIDEO_PRESENTATION_MODE)
    HashTableValue { "webkitSupportsPresentationMode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_webkitSupportsPresentationMode, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    HashTableValue { "webkitSetPresentationMode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_webkitSetPresentationMode, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    HashTableValue { "requestPictureInPicture"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_requestPictureInPicture, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(VIDEO)
    HashTableValue { "requestVideoFrameCallback"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_requestVideoFrameCallback, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
#if ENABLE(VIDEO)
    HashTableValue { "cancelVideoFrameCallback"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLVideoElementPrototypeFunction_cancelVideoFrameCallback, 1 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSHTMLVideoElementPrototype::s_info = { "HTMLVideoElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLVideoElementPrototype) };

void JSHTMLVideoElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLVideoElement::info(), JSHTMLVideoElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(VIDEO_PRESENTATION_MODE)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().videoPresentationModeAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitSupportsPresentationMode"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().videoPresentationModeAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitSetPresentationMode"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "requestPictureInPicture"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(VIDEO)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().requestVideoFrameCallbackEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "requestVideoFrameCallback"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(VIDEO)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().requestVideoFrameCallbackEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cancelVideoFrameCallback"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(VIDEO_PRESENTATION_MODE)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().videoPresentationModeAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "webkitPresentationMode"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onenterpictureinpicture"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "onleavepictureinpicture"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "autoPictureInPicture"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().pictureInPictureAPIEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "disablePictureInPicture"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLVideoElement::s_info = { "HTMLVideoElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLVideoElement) };

JSHTMLVideoElement::JSHTMLVideoElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLVideoElement>&& impl)
    : JSHTMLMediaElement(structure, globalObject, WTFMove(impl))
{
}

Ref<HTMLVideoElement> JSHTMLVideoElement::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, HTMLVideoElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSHTMLVideoElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLVideoElementPrototype::createStructure(vm, &globalObject, JSHTMLMediaElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLVideoElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLVideoElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLVideoElement>(vm, globalObject);
}

JSValue JSHTMLVideoElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLVideoElementDOMConstructor, DOMConstructorID::HTMLVideoElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLVideoElementPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLVideoElement::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsHTMLVideoElement_widthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.integralAttribute(WebCore::HTMLNames::widthAttr)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLVideoElement_widthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLVideoElement_heightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.integralAttribute(WebCore::HTMLNames::heightAttr)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLVideoElement_heightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_heightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLVideoElement_videoWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.videoWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_videoWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_videoWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLVideoElement_videoHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.videoHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_videoHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_videoHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLVideoElement_posterGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::posterAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_poster, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_posterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLVideoElement_posterSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::posterAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_poster, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_posterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLVideoElement_playsInlineGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::playsinlineAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_playsInline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_playsInlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLVideoElement_playsInlineSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::playsinlineAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_playsInline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_playsInlineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLVideoElement_webkitSupportsFullscreenGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitSupportsFullscreen())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_webkitSupportsFullscreen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_webkitSupportsFullscreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLVideoElement_webkitDisplayingFullscreenGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitDisplayingFullscreen())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_webkitDisplayingFullscreen, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_webkitDisplayingFullscreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSValue jsHTMLVideoElement_webkitWirelessVideoPlaybackDisabledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitWirelessVideoPlaybackDisabled())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_webkitWirelessVideoPlaybackDisabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_webkitWirelessVideoPlaybackDisabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline bool setJSHTMLVideoElement_webkitWirelessVideoPlaybackDisabledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::webkitwirelessvideoplaybackdisabledAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_webkitWirelessVideoPlaybackDisabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_webkitWirelessVideoPlaybackDisabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLVideoElement_webkitDecodedFrameCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitDecodedFrameCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_webkitDecodedFrameCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_webkitDecodedFrameCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLVideoElement_webkitDroppedFrameCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitDroppedFrameCount())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_webkitDroppedFrameCount, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_webkitDroppedFrameCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
static inline JSValue jsHTMLVideoElement_webkitPresentationModeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<HTMLVideoElement::VideoPresentationMode>>(lexicalGlobalObject, throwScope, impl.webkitPresentationModeForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_webkitPresentationMode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_webkitPresentationModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsHTMLVideoElement_onenterpictureinpictureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().enterpictureinpictureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_onenterpictureinpicture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_onenterpictureinpictureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSHTMLVideoElement_onenterpictureinpictureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().enterpictureinpictureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_onenterpictureinpicture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_onenterpictureinpictureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsHTMLVideoElement_onleavepictureinpictureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().leavepictureinpictureEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_onleavepictureinpicture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_onleavepictureinpictureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSHTMLVideoElement_onleavepictureinpictureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().leavepictureinpictureEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_onleavepictureinpicture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_onleavepictureinpictureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsHTMLVideoElement_autoPictureInPictureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autopictureinpictureAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_autoPictureInPicture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_autoPictureInPictureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSHTMLVideoElement_autoPictureInPictureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autopictureinpictureAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_autoPictureInPicture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_autoPictureInPictureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSValue jsHTMLVideoElement_disablePictureInPictureGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::disablepictureinpictureAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLVideoElement_disablePictureInPicture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::get<jsHTMLVideoElement_disablePictureInPictureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline bool setJSHTMLVideoElement_disablePictureInPictureSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLVideoElement& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::disablepictureinpictureAttr, nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLVideoElement_disablePictureInPicture, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLVideoElement>::set<setJSHTMLVideoElement_disablePictureInPictureSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#endif

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_webkitEnterFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitEnterFullscreen(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitEnterFullscreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_webkitEnterFullscreenBody>(*lexicalGlobalObject, *callFrame, "webkitEnterFullscreen");
}

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_webkitExitFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitExitFullscreen(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitExitFullscreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_webkitExitFullscreenBody>(*lexicalGlobalObject, *callFrame, "webkitExitFullscreen");
}

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_webkitEnterFullScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitEnterFullscreen(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitEnterFullScreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_webkitEnterFullScreenBody>(*lexicalGlobalObject, *callFrame, "webkitEnterFullScreen");
}

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_webkitExitFullScreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitExitFullscreen(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitExitFullScreen, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_webkitExitFullScreenBody>(*lexicalGlobalObject, *callFrame, "webkitExitFullScreen");
}

static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_getVideoPlaybackQualityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<VideoPlaybackQuality>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getVideoPlaybackQuality())));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_getVideoPlaybackQuality, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_getVideoPlaybackQualityBody>(*lexicalGlobalObject, *callFrame, "getVideoPlaybackQuality");
}

#if ENABLE(VIDEO_PRESENTATION_MODE)
static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_webkitSupportsPresentationModeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto modeConversionResult = convert<IDLEnumeration<HTMLVideoElement::VideoPresentationMode>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "mode"_s, "HTMLVideoElement"_s, "webkitSupportsPresentationMode"_s, expectedEnumerationValues<HTMLVideoElement::VideoPresentationMode>()); });
    if (modeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.webkitSupportsPresentationMode(modeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitSupportsPresentationMode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_webkitSupportsPresentationModeBody>(*lexicalGlobalObject, *callFrame, "webkitSupportsPresentationMode");
}

#endif

#if ENABLE(VIDEO_PRESENTATION_MODE)
static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_webkitSetPresentationModeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto modeConversionResult = convert<IDLEnumeration<HTMLVideoElement::VideoPresentationMode>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "mode"_s, "HTMLVideoElement"_s, "webkitSetPresentationMode"_s, expectedEnumerationValues<HTMLVideoElement::VideoPresentationMode>()); });
    if (modeConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.webkitSetPresentationMode(modeConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_webkitSetPresentationMode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_webkitSetPresentationModeBody>(*lexicalGlobalObject, *callFrame, "webkitSetPresentationMode");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_requestPictureInPictureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLVideoElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLInterface<PictureInPictureWindow>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return WebCore::HTMLVideoElementPictureInPicture::requestPictureInPicture(impl, WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_requestPictureInPicture, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_requestPictureInPictureBody>(*lexicalGlobalObject, *callFrame, "requestPictureInPicture");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_requestVideoFrameCallbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto callbackConversionResult = convert<IDLCallbackFunction<JSVideoFrameRequestCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback"_s, "HTMLVideoElement"_s, "requestVideoFrameCallback"_s); });
    if (callbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.requestVideoFrameCallback(callbackConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_requestVideoFrameCallback, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_requestVideoFrameCallbackBody>(*lexicalGlobalObject, *callFrame, "requestVideoFrameCallback");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsHTMLVideoElementPrototypeFunction_cancelVideoFrameCallbackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLVideoElement>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto handleConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (handleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.cancelVideoFrameCallback(handleConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLVideoElementPrototypeFunction_cancelVideoFrameCallback, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSHTMLVideoElement>::call<jsHTMLVideoElementPrototypeFunction_cancelVideoFrameCallbackBody>(*lexicalGlobalObject, *callFrame, "cancelVideoFrameCallback");
}

#endif

JSC::GCClient::IsoSubspace* JSHTMLVideoElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLVideoElement, UseCustomHeapCellType::No>(vm, "JSHTMLVideoElement"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLVideoElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLVideoElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLVideoElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLVideoElement = std::forward<decltype(space)>(space); }
    );
}

void JSHTMLVideoElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLVideoElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLVideoElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsHTMLVideoElement = jsCast<JSHTMLVideoElement*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsHTMLVideoElement->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLVideoElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLVideoElement = static_cast<JSHTMLVideoElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsHTMLVideoElement->protectedWrapped().ptr(), jsHTMLVideoElement);
}

HTMLVideoElement* JSHTMLVideoElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLVideoElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
