/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFontFaceSet.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMIterator.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSFontFace.h"
#include "JSFontFaceSet.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(FontFaceSet::LoadStatus enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 2> values {
        MAKE_STATIC_STRING_IMPL("loading"),
        MAKE_STATIC_STRING_IMPL("loaded"),
    };
    static_assert(static_cast<size_t>(FontFaceSet::LoadStatus::Loading) == 0, "FontFaceSet::LoadStatus::Loading is not 0 as expected");
    static_assert(static_cast<size_t>(FontFaceSet::LoadStatus::Loaded) == 1, "FontFaceSet::LoadStatus::Loaded is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, FontFaceSet::LoadStatus enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<FontFaceSet::LoadStatus> parseEnumerationFromString<FontFaceSet::LoadStatus>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, FontFaceSet::LoadStatus>, 2> mappings {
        std::pair<ComparableASCIILiteral, FontFaceSet::LoadStatus> { "loaded"_s, FontFaceSet::LoadStatus::Loaded },
        std::pair<ComparableASCIILiteral, FontFaceSet::LoadStatus> { "loading"_s, FontFaceSet::LoadStatus::Loading },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<FontFaceSet::LoadStatus> parseEnumeration<FontFaceSet::LoadStatus>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<FontFaceSet::LoadStatus>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<FontFaceSet::LoadStatus>()
{
    return "\"loading\", \"loaded\""_s;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_has);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_add);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_delete);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_clear);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_load);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_check);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_entries);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_keys);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_values);
static JSC_DECLARE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_forEach);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFontFaceSetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFaceSet_size);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFaceSet_onloading);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFaceSet_onloading);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFaceSet_onloadingdone);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFaceSet_onloadingdone);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFaceSet_onloadingerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSFontFaceSet_onloadingerror);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFaceSet_ready);
static JSC_DECLARE_CUSTOM_GETTER(jsFontFaceSet_status);

class JSFontFaceSetPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFontFaceSetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFontFaceSetPrototype* ptr = new (NotNull, JSC::allocateCell<JSFontFaceSetPrototype>(vm)) JSFontFaceSetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFontFaceSetPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFontFaceSetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFontFaceSetPrototype, JSFontFaceSetPrototype::Base);

using JSFontFaceSetDOMConstructor = JSDOMConstructor<JSFontFaceSet>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSFontFaceSetDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSFontFaceSetDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (!context) [[unlikely]]
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "FontFaceSet"_s);
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto initialFacesConversionResult = convert<IDLSequence<IDLInterface<FontFace>>>(*lexicalGlobalObject, argument0.value());
    if (initialFacesConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    auto object = FontFaceSet::create(*context, initialFacesConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<FontFaceSet>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<FontFaceSet>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSFontFaceSetDOMConstructorConstruct, JSFontFaceSetDOMConstructor::construct);

template<> const ClassInfo JSFontFaceSetDOMConstructor::s_info = { "FontFaceSet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFaceSetDOMConstructor) };

template<> JSValue JSFontFaceSetDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSFontFaceSetDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FontFaceSet"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFontFaceSet::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 17> JSFontFaceSetPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFaceSetConstructor, 0 } },
    HashTableValue { "size"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFaceSet_size, 0 } },
    HashTableValue { "onloading"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFaceSet_onloading, setJSFontFaceSet_onloading } },
    HashTableValue { "onloadingdone"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFaceSet_onloadingdone, setJSFontFaceSet_onloadingdone } },
    HashTableValue { "onloadingerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFaceSet_onloadingerror, setJSFontFaceSet_onloadingerror } },
    HashTableValue { "ready"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFaceSet_ready, 0 } },
    HashTableValue { "status"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsFontFaceSet_status, 0 } },
    HashTableValue { "has"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_has, 1 } },
    HashTableValue { "add"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_add, 1 } },
    HashTableValue { "delete"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_delete, 1 } },
    HashTableValue { "clear"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_clear, 0 } },
    HashTableValue { "load"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_load, 1 } },
    HashTableValue { "check"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_check, 1 } },
    HashTableValue { "entries"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_entries, 0 } },
    HashTableValue { "keys"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_keys, 0 } },
    HashTableValue { "values"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_values, 0 } },
    HashTableValue { "forEach"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFontFaceSetPrototypeFunction_forEach, 1 } },
};

const ClassInfo JSFontFaceSetPrototype::s_info = { "FontFaceSet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFaceSetPrototype) };

void JSFontFaceSetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFontFaceSet::info(), JSFontFaceSetPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, getDirect(vm, vm.propertyNames->builtinNames().entriesPublicName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFontFaceSet::s_info = { "FontFaceSet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFontFaceSet) };

JSFontFaceSet::JSFontFaceSet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FontFaceSet>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<FontFaceSet> JSFontFaceSet::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, FontFaceSet>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFontFaceSet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFontFaceSetPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSFontFaceSetPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFontFaceSet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFontFaceSet>(vm, globalObject);
}

JSValue JSFontFaceSet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFontFaceSetDOMConstructor, DOMConstructorID::FontFaceSet>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFaceSetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFontFaceSetPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFontFaceSet::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsFontFaceSet_sizeGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.size())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFaceSet_size, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSet_sizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFontFaceSet_onloadingGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadingEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFaceSet_onloading, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSet_onloadingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFaceSet_onloadingSetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadingEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFaceSet_onloading, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::set<setJSFontFaceSet_onloadingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFaceSet_onloadingdoneGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadingdoneEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFaceSet_onloadingdone, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSet_onloadingdoneGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFaceSet_onloadingdoneSetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadingdoneEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFaceSet_onloadingdone, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::set<setJSFontFaceSet_onloadingdoneSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFaceSet_onloadingerrorGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().loadingerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFaceSet_onloadingerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSet_onloadingerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSFontFaceSet_onloadingerrorSetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().loadingerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSFontFaceSet_onloadingerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::set<setJSFontFaceSet_onloadingerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsFontFaceSet_readyGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLPromise<IDLInterface<FontFaceSet>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, [&]() -> decltype(auto) { return impl.ready(); })));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFaceSet_ready, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSet_readyGetter, CastedThisErrorBehavior::RejectPromise>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsFontFaceSet_statusGetter(JSGlobalObject& lexicalGlobalObject, JSFontFaceSet& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<FontFaceSet::LoadStatus>>(lexicalGlobalObject, throwScope, impl.status())));
}

JSC_DEFINE_CUSTOM_GETTER(jsFontFaceSet_status, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSFontFaceSet>::get<jsFontFaceSet_statusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunction_hasBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto fontConversionResult = convert<IDLInterface<FontFace>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "font"_s, "FontFaceSet"_s, "has"_s, "FontFace"_s); });
    if (fontConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.has(*fontConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_has, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_hasBody>(*lexicalGlobalObject, *callFrame, "has");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunction_addBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto fontConversionResult = convert<IDLInterface<FontFace>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "font"_s, "FontFaceSet"_s, "add"_s, "FontFace"_s); });
    if (fontConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<FontFaceSet>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.add(*fontConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_add, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_addBody>(*lexicalGlobalObject, *callFrame, "add");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunction_deleteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto fontConversionResult = convert<IDLInterface<FontFace>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "font"_s, "FontFaceSet"_s, "delete"_s, "FontFace"_s); });
    if (fontConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.remove(*fontConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_delete, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_deleteBody>(*lexicalGlobalObject, *callFrame, "delete");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunction_clearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clear(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_clear, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_clearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunction_loadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFontFaceSet>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto fontConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (fontConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto textConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { " "_s }; });
    if (textConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLSequence<IDLInterface<FontFace>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.load(*context, fontConversionResult.releaseReturnValue(), textConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_load, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_loadBody>(*lexicalGlobalObject, *callFrame, "load");
}

static inline JSC::EncodedJSValue jsFontFaceSetPrototypeFunction_checkBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFontFaceSet>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto fontConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (fontConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto textConversionResult = convertOptionalWithDefault<IDLDOMString>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { " "_s }; });
    if (textConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.check(*context, fontConversionResult.releaseReturnValue(), textConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_check, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_checkBody>(*lexicalGlobalObject, *callFrame, "check");
}

struct FontFaceSetIteratorTraits {
    static constexpr JSDOMIteratorType type = JSDOMIteratorType::Set;
    using KeyType = void;
    using ValueType = IDLInterface<FontFace>;
};

using FontFaceSetIteratorBase = JSDOMIteratorBase<JSFontFaceSet, FontFaceSetIteratorTraits>;
class FontFaceSetIterator final : public FontFaceSetIteratorBase {
public:
    using Base = FontFaceSetIteratorBase;
    DECLARE_INFO;

    template<typename, SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return WebCore::subspaceForImpl<FontFaceSetIterator, UseCustomHeapCellType::No>(vm, "FontFaceSetIterator"_s,
            [] (auto& spaces) { return spaces.m_clientSubspaceForFontFaceSetIterator.get(); },
            [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFontFaceSetIterator = std::forward<decltype(space)>(space); },
            [] (auto& spaces) { return spaces.m_subspaceForFontFaceSetIterator.get(); },
            [] (auto& spaces, auto&& space) { spaces.m_subspaceForFontFaceSetIterator = std::forward<decltype(space)>(space); }
        );
    }

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static FontFaceSetIterator* create(JSC::VM& vm, JSC::Structure* structure, JSFontFaceSet& iteratedObject, IterationKind kind)
    {
        auto* instance = new (NotNull, JSC::allocateCell<FontFaceSetIterator>(vm)) FontFaceSetIterator(structure, iteratedObject, kind);
        instance->finishCreation(vm);
        return instance;
    }
private:
    FontFaceSetIterator(JSC::Structure* structure, JSFontFaceSet& iteratedObject, IterationKind kind)
        : Base(structure, iteratedObject, kind)
    {
    }
};

using FontFaceSetIteratorPrototype = JSDOMIteratorPrototype<JSFontFaceSet, FontFaceSetIteratorTraits>;
JSC_ANNOTATE_HOST_FUNCTION(FontFaceSetIteratorPrototypeNext, FontFaceSetIteratorPrototype::next);

template<>
const JSC::ClassInfo FontFaceSetIteratorBase::s_info = { "FontFaceSetBase Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(FontFaceSetIteratorBase) };
const JSC::ClassInfo FontFaceSetIterator::s_info = { "FontFaceSet Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(FontFaceSetIterator) };

template<>
const JSC::ClassInfo FontFaceSetIteratorPrototype::s_info = { "FontFaceSet Iterator"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(FontFaceSetIteratorPrototype) };

static inline EncodedJSValue jsFontFaceSetPrototypeFunction_entriesCaller(JSGlobalObject*, CallFrame*, JSFontFaceSet* thisObject)
{
    return JSValue::encode(iteratorCreate<FontFaceSetIterator>(*thisObject, IterationKind::Values));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_entries, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_entriesCaller>(*lexicalGlobalObject, *callFrame, "entries");
}

static inline EncodedJSValue jsFontFaceSetPrototypeFunction_keysCaller(JSGlobalObject*, CallFrame*, JSFontFaceSet* thisObject)
{
    return JSValue::encode(iteratorCreate<FontFaceSetIterator>(*thisObject, IterationKind::Keys));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_keys, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_keysCaller>(*lexicalGlobalObject, *callFrame, "keys");
}

static inline EncodedJSValue jsFontFaceSetPrototypeFunction_valuesCaller(JSGlobalObject*, CallFrame*, JSFontFaceSet* thisObject)
{
    return JSValue::encode(iteratorCreate<FontFaceSetIterator>(*thisObject, IterationKind::Values));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_values, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_valuesCaller>(*lexicalGlobalObject, *callFrame, "values");
}

static inline EncodedJSValue jsFontFaceSetPrototypeFunction_forEachCaller(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame, JSFontFaceSet* thisObject)
{
    return JSValue::encode(iteratorForEach<FontFaceSetIterator>(*lexicalGlobalObject, *callFrame, *thisObject));
}

JSC_DEFINE_HOST_FUNCTION(jsFontFaceSetPrototypeFunction_forEach, (JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame))
{
    return IDLOperation<JSFontFaceSet>::call<jsFontFaceSetPrototypeFunction_forEachCaller>(*lexicalGlobalObject, *callFrame, "forEach");
}

JSC::GCClient::IsoSubspace* JSFontFaceSet::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFontFaceSet, UseCustomHeapCellType::No>(vm, "JSFontFaceSet"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFontFaceSet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFontFaceSet = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFontFaceSet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFontFaceSet = std::forward<decltype(space)>(space); }
    );
}

void JSFontFaceSet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFontFaceSet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFontFaceSetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFontFaceSet = jsCast<JSFontFaceSet*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsFontFaceSet->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFontFaceSetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFontFaceSet = static_cast<JSFontFaceSet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFontFaceSet->protectedWrapped().ptr(), jsFontFaceSet);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7FontFaceSet@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11FontFaceSetE[]; }
#endif
template<std::same_as<FontFaceSet> T>
static inline void verifyVTable(FontFaceSet* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7FontFaceSet@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11FontFaceSetE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // FontFaceSet has subclasses. If FontFaceSet has subclasses that get passed
        // to toJS() we currently require FontFaceSet you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<FontFaceSet>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<FontFaceSet>(impl.ptr());
#endif
    return createWrapper<FontFaceSet>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, FontFaceSet& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

FontFaceSet* JSFontFaceSet::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSFontFaceSet*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
