/*
 * Copyright (C) 2021-2023 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "ViewGestureController.h"

#include "Decoder.h" // NOLINT
#include "HandleMessage.h" // NOLINT
#include "ViewGestureControllerMessages.h" // NOLINT
#if PLATFORM(MAC)
#include <WebCore/FloatPoint.h> // NOLINT
#endif
#if !PLATFORM(IOS_FAMILY) || PLATFORM(MAC)
#include <WebCore/FloatRect.h> // NOLINT
#endif

#if ENABLE(IPC_TESTING_API)
#include "JSIPCBinding.h"
#endif

namespace WebKit {

void ViewGestureController::didReceiveMessage(IPC::Connection& connection, IPC::Decoder& decoder)
{
    Ref protectedThis { *this };
#if PLATFORM(MAC)
    if (decoder.messageName() == Messages::ViewGestureController::DidCollectGeometryForSmartMagnificationGesture::name())
        return IPC::handleMessage<Messages::ViewGestureController::DidCollectGeometryForSmartMagnificationGesture>(connection, decoder, this, &ViewGestureController::didCollectGeometryForSmartMagnificationGesture);
#endif
#if !PLATFORM(IOS_FAMILY)
    if (decoder.messageName() == Messages::ViewGestureController::DidCollectGeometryForMagnificationGesture::name())
        return IPC::handleMessage<Messages::ViewGestureController::DidCollectGeometryForMagnificationGesture>(connection, decoder, this, &ViewGestureController::didCollectGeometryForMagnificationGesture);
    if (decoder.messageName() == Messages::ViewGestureController::DidHitRenderTreeSizeThreshold::name())
        return IPC::handleMessage<Messages::ViewGestureController::DidHitRenderTreeSizeThreshold>(connection, decoder, this, &ViewGestureController::didHitRenderTreeSizeThreshold);
#endif
    UNUSED_PARAM(connection);
    RELEASE_LOG_ERROR(IPC, "Unhandled message %s to %" PRIu64, IPC::description(decoder.messageName()).characters(), decoder.destinationID());
    decoder.markInvalid();
}

} // namespace WebKit

#if ENABLE(IPC_TESTING_API)

namespace IPC {

#if PLATFORM(MAC)
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ViewGestureController_DidCollectGeometryForSmartMagnificationGesture>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ViewGestureController::DidCollectGeometryForSmartMagnificationGesture::Arguments>(globalObject, decoder);
}
#endif
#if !PLATFORM(IOS_FAMILY)
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ViewGestureController_DidCollectGeometryForMagnificationGesture>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ViewGestureController::DidCollectGeometryForMagnificationGesture::Arguments>(globalObject, decoder);
}
template<> std::optional<JSC::JSValue> jsValueForDecodedMessage<MessageName::ViewGestureController_DidHitRenderTreeSizeThreshold>(JSC::JSGlobalObject* globalObject, Decoder& decoder)
{
    return jsValueForDecodedArguments<Messages::ViewGestureController::DidHitRenderTreeSizeThreshold::Arguments>(globalObject, decoder);
}
#endif

}

#endif

