#include <wayland-server-protocol.hpp>

using namespace wayland;
using namespace wayland::detail;
using namespace wayland::server;
using namespace wayland::server::detail;

const wl_interface* display_interface_sync_request_server[1] = {
  &callback_interface,
};

const wl_interface* display_interface_get_registry_request_server[1] = {
  &registry_interface,
};

const wl_interface* display_interface_error_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* display_interface_delete_id_event_server[1] = {
  nullptr,
};

const wl_message display_interface_requests_server[2] = {
  {
    "sync",
    "n",
    display_interface_sync_request_server,
  },
  {
    "get_registry",
    "n",
    display_interface_get_registry_request_server,
  },
};

const wl_message display_interface_events_server[2] = {
  {
    "error",
    "ous",
    display_interface_error_event_server,
  },
  {
    "delete_id",
    "u",
    display_interface_delete_id_event_server,
  },
};

const wl_interface wayland::server::detail::display_interface =
  {
    "wl_display",
    1,
    2,
    display_interface_requests_server,
    2,
    display_interface_events_server,
  };

const wl_interface* registry_interface_bind_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* registry_interface_global_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* registry_interface_global_remove_event_server[1] = {
  nullptr,
};

const wl_message registry_interface_requests_server[1] = {
  {
    "bind",
    "usun",
    registry_interface_bind_request_server,
  },
};

const wl_message registry_interface_events_server[2] = {
  {
    "global",
    "usu",
    registry_interface_global_event_server,
  },
  {
    "global_remove",
    "u",
    registry_interface_global_remove_event_server,
  },
};

const wl_interface wayland::server::detail::registry_interface =
  {
    "wl_registry",
    1,
    1,
    registry_interface_requests_server,
    2,
    registry_interface_events_server,
  };

const wl_interface* callback_interface_done_event_server[1] = {
  nullptr,
};

const wl_message callback_interface_requests_server[0] = {
};

const wl_message callback_interface_events_server[1] = {
  {
    "done",
    "u",
    callback_interface_done_event_server,
  },
};

const wl_interface wayland::server::detail::callback_interface =
  {
    "wl_callback",
    1,
    0,
    callback_interface_requests_server,
    1,
    callback_interface_events_server,
  };

const wl_interface* compositor_interface_create_surface_request_server[1] = {
  &surface_interface,
};

const wl_interface* compositor_interface_create_region_request_server[1] = {
  &region_interface,
};

const wl_message compositor_interface_requests_server[2] = {
  {
    "create_surface",
    "n",
    compositor_interface_create_surface_request_server,
  },
  {
    "create_region",
    "n",
    compositor_interface_create_region_request_server,
  },
};

const wl_message compositor_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::compositor_interface =
  {
    "wl_compositor",
    5,
    2,
    compositor_interface_requests_server,
    0,
    compositor_interface_events_server,
  };

const wl_interface* shm_pool_interface_create_buffer_request_server[6] = {
  &buffer_interface,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* shm_pool_interface_destroy_request_server[0] = {
};

const wl_interface* shm_pool_interface_resize_request_server[1] = {
  nullptr,
};

const wl_message shm_pool_interface_requests_server[3] = {
  {
    "create_buffer",
    "niiiiu",
    shm_pool_interface_create_buffer_request_server,
  },
  {
    "destroy",
    "",
    shm_pool_interface_destroy_request_server,
  },
  {
    "resize",
    "i",
    shm_pool_interface_resize_request_server,
  },
};

const wl_message shm_pool_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::shm_pool_interface =
  {
    "wl_shm_pool",
    1,
    3,
    shm_pool_interface_requests_server,
    0,
    shm_pool_interface_events_server,
  };

const wl_interface* shm_interface_create_pool_request_server[3] = {
  &shm_pool_interface,
  nullptr,
  nullptr,
};

const wl_interface* shm_interface_format_event_server[1] = {
  nullptr,
};

const wl_message shm_interface_requests_server[1] = {
  {
    "create_pool",
    "nhi",
    shm_interface_create_pool_request_server,
  },
};

const wl_message shm_interface_events_server[1] = {
  {
    "format",
    "u",
    shm_interface_format_event_server,
  },
};

const wl_interface wayland::server::detail::shm_interface =
  {
    "wl_shm",
    1,
    1,
    shm_interface_requests_server,
    1,
    shm_interface_events_server,
  };

const wl_interface* buffer_interface_destroy_request_server[0] = {
};

const wl_interface* buffer_interface_release_event_server[0] = {
};

const wl_message buffer_interface_requests_server[1] = {
  {
    "destroy",
    "",
    buffer_interface_destroy_request_server,
  },
};

const wl_message buffer_interface_events_server[1] = {
  {
    "release",
    "",
    buffer_interface_release_event_server,
  },
};

const wl_interface wayland::server::detail::buffer_interface =
  {
    "wl_buffer",
    1,
    1,
    buffer_interface_requests_server,
    1,
    buffer_interface_events_server,
  };

const wl_interface* data_offer_interface_accept_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* data_offer_interface_receive_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* data_offer_interface_destroy_request_server[0] = {
};

const wl_interface* data_offer_interface_finish_request_server[0] = {
};

const wl_interface* data_offer_interface_set_actions_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* data_offer_interface_offer_event_server[1] = {
  nullptr,
};

const wl_interface* data_offer_interface_source_actions_event_server[1] = {
  nullptr,
};

const wl_interface* data_offer_interface_action_event_server[1] = {
  nullptr,
};

const wl_message data_offer_interface_requests_server[5] = {
  {
    "accept",
    "u?s",
    data_offer_interface_accept_request_server,
  },
  {
    "receive",
    "sh",
    data_offer_interface_receive_request_server,
  },
  {
    "destroy",
    "",
    data_offer_interface_destroy_request_server,
  },
  {
    "finish",
    "3",
    data_offer_interface_finish_request_server,
  },
  {
    "set_actions",
    "3uu",
    data_offer_interface_set_actions_request_server,
  },
};

const wl_message data_offer_interface_events_server[3] = {
  {
    "offer",
    "s",
    data_offer_interface_offer_event_server,
  },
  {
    "source_actions",
    "3u",
    data_offer_interface_source_actions_event_server,
  },
  {
    "action",
    "3u",
    data_offer_interface_action_event_server,
  },
};

const wl_interface wayland::server::detail::data_offer_interface =
  {
    "wl_data_offer",
    3,
    5,
    data_offer_interface_requests_server,
    3,
    data_offer_interface_events_server,
  };

const wl_interface* data_source_interface_offer_request_server[1] = {
  nullptr,
};

const wl_interface* data_source_interface_destroy_request_server[0] = {
};

const wl_interface* data_source_interface_set_actions_request_server[1] = {
  nullptr,
};

const wl_interface* data_source_interface_target_event_server[1] = {
  nullptr,
};

const wl_interface* data_source_interface_send_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* data_source_interface_cancelled_event_server[0] = {
};

const wl_interface* data_source_interface_dnd_drop_performed_event_server[0] = {
};

const wl_interface* data_source_interface_dnd_finished_event_server[0] = {
};

const wl_interface* data_source_interface_action_event_server[1] = {
  nullptr,
};

const wl_message data_source_interface_requests_server[3] = {
  {
    "offer",
    "s",
    data_source_interface_offer_request_server,
  },
  {
    "destroy",
    "",
    data_source_interface_destroy_request_server,
  },
  {
    "set_actions",
    "3u",
    data_source_interface_set_actions_request_server,
  },
};

const wl_message data_source_interface_events_server[6] = {
  {
    "target",
    "?s",
    data_source_interface_target_event_server,
  },
  {
    "send",
    "sh",
    data_source_interface_send_event_server,
  },
  {
    "cancelled",
    "",
    data_source_interface_cancelled_event_server,
  },
  {
    "dnd_drop_performed",
    "3",
    data_source_interface_dnd_drop_performed_event_server,
  },
  {
    "dnd_finished",
    "3",
    data_source_interface_dnd_finished_event_server,
  },
  {
    "action",
    "3u",
    data_source_interface_action_event_server,
  },
};

const wl_interface wayland::server::detail::data_source_interface =
  {
    "wl_data_source",
    3,
    3,
    data_source_interface_requests_server,
    6,
    data_source_interface_events_server,
  };

const wl_interface* data_device_interface_start_drag_request_server[4] = {
  &data_source_interface,
  &surface_interface,
  &surface_interface,
  nullptr,
};

const wl_interface* data_device_interface_set_selection_request_server[2] = {
  &data_source_interface,
  nullptr,
};

const wl_interface* data_device_interface_release_request_server[0] = {
};

const wl_interface* data_device_interface_data_offer_event_server[1] = {
  &data_offer_interface,
};

const wl_interface* data_device_interface_enter_event_server[5] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
  &data_offer_interface,
};

const wl_interface* data_device_interface_leave_event_server[0] = {
};

const wl_interface* data_device_interface_motion_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* data_device_interface_drop_event_server[0] = {
};

const wl_interface* data_device_interface_selection_event_server[1] = {
  &data_offer_interface,
};

const wl_message data_device_interface_requests_server[3] = {
  {
    "start_drag",
    "?oo?ou",
    data_device_interface_start_drag_request_server,
  },
  {
    "set_selection",
    "?ou",
    data_device_interface_set_selection_request_server,
  },
  {
    "release",
    "2",
    data_device_interface_release_request_server,
  },
};

const wl_message data_device_interface_events_server[6] = {
  {
    "data_offer",
    "n",
    data_device_interface_data_offer_event_server,
  },
  {
    "enter",
    "uoff?o",
    data_device_interface_enter_event_server,
  },
  {
    "leave",
    "",
    data_device_interface_leave_event_server,
  },
  {
    "motion",
    "uff",
    data_device_interface_motion_event_server,
  },
  {
    "drop",
    "",
    data_device_interface_drop_event_server,
  },
  {
    "selection",
    "?o",
    data_device_interface_selection_event_server,
  },
};

const wl_interface wayland::server::detail::data_device_interface =
  {
    "wl_data_device",
    3,
    3,
    data_device_interface_requests_server,
    6,
    data_device_interface_events_server,
  };

const wl_interface* data_device_manager_interface_create_data_source_request_server[1] = {
  &data_source_interface,
};

const wl_interface* data_device_manager_interface_get_data_device_request_server[2] = {
  &data_device_interface,
  &seat_interface,
};

const wl_message data_device_manager_interface_requests_server[2] = {
  {
    "create_data_source",
    "n",
    data_device_manager_interface_create_data_source_request_server,
  },
  {
    "get_data_device",
    "no",
    data_device_manager_interface_get_data_device_request_server,
  },
};

const wl_message data_device_manager_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::data_device_manager_interface =
  {
    "wl_data_device_manager",
    3,
    2,
    data_device_manager_interface_requests_server,
    0,
    data_device_manager_interface_events_server,
  };

const wl_interface* shell_interface_get_shell_surface_request_server[2] = {
  &shell_surface_interface,
  &surface_interface,
};

const wl_message shell_interface_requests_server[1] = {
  {
    "get_shell_surface",
    "no",
    shell_interface_get_shell_surface_request_server,
  },
};

const wl_message shell_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::shell_interface =
  {
    "wl_shell",
    1,
    1,
    shell_interface_requests_server,
    0,
    shell_interface_events_server,
  };

const wl_interface* shell_surface_interface_pong_request_server[1] = {
  nullptr,
};

const wl_interface* shell_surface_interface_move_request_server[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* shell_surface_interface_resize_request_server[3] = {
  &seat_interface,
  nullptr,
  nullptr,
};

const wl_interface* shell_surface_interface_set_toplevel_request_server[0] = {
};

const wl_interface* shell_surface_interface_set_transient_request_server[4] = {
  &surface_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* shell_surface_interface_set_fullscreen_request_server[3] = {
  nullptr,
  nullptr,
  &output_interface,
};

const wl_interface* shell_surface_interface_set_popup_request_server[6] = {
  &seat_interface,
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* shell_surface_interface_set_maximized_request_server[1] = {
  &output_interface,
};

const wl_interface* shell_surface_interface_set_title_request_server[1] = {
  nullptr,
};

const wl_interface* shell_surface_interface_set_class_request_server[1] = {
  nullptr,
};

const wl_interface* shell_surface_interface_ping_event_server[1] = {
  nullptr,
};

const wl_interface* shell_surface_interface_configure_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* shell_surface_interface_popup_done_event_server[0] = {
};

const wl_message shell_surface_interface_requests_server[10] = {
  {
    "pong",
    "u",
    shell_surface_interface_pong_request_server,
  },
  {
    "move",
    "ou",
    shell_surface_interface_move_request_server,
  },
  {
    "resize",
    "ouu",
    shell_surface_interface_resize_request_server,
  },
  {
    "set_toplevel",
    "",
    shell_surface_interface_set_toplevel_request_server,
  },
  {
    "set_transient",
    "oiiu",
    shell_surface_interface_set_transient_request_server,
  },
  {
    "set_fullscreen",
    "uu?o",
    shell_surface_interface_set_fullscreen_request_server,
  },
  {
    "set_popup",
    "ouoiiu",
    shell_surface_interface_set_popup_request_server,
  },
  {
    "set_maximized",
    "?o",
    shell_surface_interface_set_maximized_request_server,
  },
  {
    "set_title",
    "s",
    shell_surface_interface_set_title_request_server,
  },
  {
    "set_class",
    "s",
    shell_surface_interface_set_class_request_server,
  },
};

const wl_message shell_surface_interface_events_server[3] = {
  {
    "ping",
    "u",
    shell_surface_interface_ping_event_server,
  },
  {
    "configure",
    "uii",
    shell_surface_interface_configure_event_server,
  },
  {
    "popup_done",
    "",
    shell_surface_interface_popup_done_event_server,
  },
};

const wl_interface wayland::server::detail::shell_surface_interface =
  {
    "wl_shell_surface",
    1,
    10,
    shell_surface_interface_requests_server,
    3,
    shell_surface_interface_events_server,
  };

const wl_interface* surface_interface_destroy_request_server[0] = {
};

const wl_interface* surface_interface_attach_request_server[3] = {
  &buffer_interface,
  nullptr,
  nullptr,
};

const wl_interface* surface_interface_damage_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* surface_interface_frame_request_server[1] = {
  &callback_interface,
};

const wl_interface* surface_interface_set_opaque_region_request_server[1] = {
  &region_interface,
};

const wl_interface* surface_interface_set_input_region_request_server[1] = {
  &region_interface,
};

const wl_interface* surface_interface_commit_request_server[0] = {
};

const wl_interface* surface_interface_set_buffer_transform_request_server[1] = {
  nullptr,
};

const wl_interface* surface_interface_set_buffer_scale_request_server[1] = {
  nullptr,
};

const wl_interface* surface_interface_damage_buffer_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* surface_interface_offset_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* surface_interface_enter_event_server[1] = {
  &output_interface,
};

const wl_interface* surface_interface_leave_event_server[1] = {
  &output_interface,
};

const wl_message surface_interface_requests_server[11] = {
  {
    "destroy",
    "",
    surface_interface_destroy_request_server,
  },
  {
    "attach",
    "?oii",
    surface_interface_attach_request_server,
  },
  {
    "damage",
    "iiii",
    surface_interface_damage_request_server,
  },
  {
    "frame",
    "n",
    surface_interface_frame_request_server,
  },
  {
    "set_opaque_region",
    "?o",
    surface_interface_set_opaque_region_request_server,
  },
  {
    "set_input_region",
    "?o",
    surface_interface_set_input_region_request_server,
  },
  {
    "commit",
    "",
    surface_interface_commit_request_server,
  },
  {
    "set_buffer_transform",
    "2i",
    surface_interface_set_buffer_transform_request_server,
  },
  {
    "set_buffer_scale",
    "3i",
    surface_interface_set_buffer_scale_request_server,
  },
  {
    "damage_buffer",
    "4iiii",
    surface_interface_damage_buffer_request_server,
  },
  {
    "offset",
    "5ii",
    surface_interface_offset_request_server,
  },
};

const wl_message surface_interface_events_server[2] = {
  {
    "enter",
    "o",
    surface_interface_enter_event_server,
  },
  {
    "leave",
    "o",
    surface_interface_leave_event_server,
  },
};

const wl_interface wayland::server::detail::surface_interface =
  {
    "wl_surface",
    5,
    11,
    surface_interface_requests_server,
    2,
    surface_interface_events_server,
  };

const wl_interface* seat_interface_get_pointer_request_server[1] = {
  &pointer_interface,
};

const wl_interface* seat_interface_get_keyboard_request_server[1] = {
  &keyboard_interface,
};

const wl_interface* seat_interface_get_touch_request_server[1] = {
  &touch_interface,
};

const wl_interface* seat_interface_release_request_server[0] = {
};

const wl_interface* seat_interface_capabilities_event_server[1] = {
  nullptr,
};

const wl_interface* seat_interface_name_event_server[1] = {
  nullptr,
};

const wl_message seat_interface_requests_server[4] = {
  {
    "get_pointer",
    "n",
    seat_interface_get_pointer_request_server,
  },
  {
    "get_keyboard",
    "n",
    seat_interface_get_keyboard_request_server,
  },
  {
    "get_touch",
    "n",
    seat_interface_get_touch_request_server,
  },
  {
    "release",
    "5",
    seat_interface_release_request_server,
  },
};

const wl_message seat_interface_events_server[2] = {
  {
    "capabilities",
    "u",
    seat_interface_capabilities_event_server,
  },
  {
    "name",
    "2s",
    seat_interface_name_event_server,
  },
};

const wl_interface wayland::server::detail::seat_interface =
  {
    "wl_seat",
    8,
    4,
    seat_interface_requests_server,
    2,
    seat_interface_events_server,
  };

const wl_interface* pointer_interface_set_cursor_request_server[4] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_release_request_server[0] = {
};

const wl_interface* pointer_interface_enter_event_server[4] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_leave_event_server[2] = {
  nullptr,
  &surface_interface,
};

const wl_interface* pointer_interface_motion_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_button_event_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_axis_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_frame_event_server[0] = {
};

const wl_interface* pointer_interface_axis_source_event_server[1] = {
  nullptr,
};

const wl_interface* pointer_interface_axis_stop_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_axis_discrete_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_axis_value120_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_message pointer_interface_requests_server[2] = {
  {
    "set_cursor",
    "u?oii",
    pointer_interface_set_cursor_request_server,
  },
  {
    "release",
    "3",
    pointer_interface_release_request_server,
  },
};

const wl_message pointer_interface_events_server[10] = {
  {
    "enter",
    "uoff",
    pointer_interface_enter_event_server,
  },
  {
    "leave",
    "uo",
    pointer_interface_leave_event_server,
  },
  {
    "motion",
    "uff",
    pointer_interface_motion_event_server,
  },
  {
    "button",
    "uuuu",
    pointer_interface_button_event_server,
  },
  {
    "axis",
    "uuf",
    pointer_interface_axis_event_server,
  },
  {
    "frame",
    "5",
    pointer_interface_frame_event_server,
  },
  {
    "axis_source",
    "5u",
    pointer_interface_axis_source_event_server,
  },
  {
    "axis_stop",
    "5uu",
    pointer_interface_axis_stop_event_server,
  },
  {
    "axis_discrete",
    "5ui",
    pointer_interface_axis_discrete_event_server,
  },
  {
    "axis_value120",
    "8ui",
    pointer_interface_axis_value120_event_server,
  },
};

const wl_interface wayland::server::detail::pointer_interface =
  {
    "wl_pointer",
    8,
    2,
    pointer_interface_requests_server,
    10,
    pointer_interface_events_server,
  };

const wl_interface* keyboard_interface_release_request_server[0] = {
};

const wl_interface* keyboard_interface_keymap_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* keyboard_interface_enter_event_server[3] = {
  nullptr,
  &surface_interface,
  nullptr,
};

const wl_interface* keyboard_interface_leave_event_server[2] = {
  nullptr,
  &surface_interface,
};

const wl_interface* keyboard_interface_key_event_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* keyboard_interface_modifiers_event_server[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* keyboard_interface_repeat_info_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_message keyboard_interface_requests_server[1] = {
  {
    "release",
    "3",
    keyboard_interface_release_request_server,
  },
};

const wl_message keyboard_interface_events_server[6] = {
  {
    "keymap",
    "uhu",
    keyboard_interface_keymap_event_server,
  },
  {
    "enter",
    "uoa",
    keyboard_interface_enter_event_server,
  },
  {
    "leave",
    "uo",
    keyboard_interface_leave_event_server,
  },
  {
    "key",
    "uuuu",
    keyboard_interface_key_event_server,
  },
  {
    "modifiers",
    "uuuuu",
    keyboard_interface_modifiers_event_server,
  },
  {
    "repeat_info",
    "4ii",
    keyboard_interface_repeat_info_event_server,
  },
};

const wl_interface wayland::server::detail::keyboard_interface =
  {
    "wl_keyboard",
    8,
    1,
    keyboard_interface_requests_server,
    6,
    keyboard_interface_events_server,
  };

const wl_interface* touch_interface_release_request_server[0] = {
};

const wl_interface* touch_interface_down_event_server[6] = {
  nullptr,
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* touch_interface_up_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* touch_interface_motion_event_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* touch_interface_frame_event_server[0] = {
};

const wl_interface* touch_interface_cancel_event_server[0] = {
};

const wl_interface* touch_interface_shape_event_server[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* touch_interface_orientation_event_server[2] = {
  nullptr,
  nullptr,
};

const wl_message touch_interface_requests_server[1] = {
  {
    "release",
    "3",
    touch_interface_release_request_server,
  },
};

const wl_message touch_interface_events_server[7] = {
  {
    "down",
    "uuoiff",
    touch_interface_down_event_server,
  },
  {
    "up",
    "uui",
    touch_interface_up_event_server,
  },
  {
    "motion",
    "uiff",
    touch_interface_motion_event_server,
  },
  {
    "frame",
    "",
    touch_interface_frame_event_server,
  },
  {
    "cancel",
    "",
    touch_interface_cancel_event_server,
  },
  {
    "shape",
    "6iff",
    touch_interface_shape_event_server,
  },
  {
    "orientation",
    "6if",
    touch_interface_orientation_event_server,
  },
};

const wl_interface wayland::server::detail::touch_interface =
  {
    "wl_touch",
    8,
    1,
    touch_interface_requests_server,
    7,
    touch_interface_events_server,
  };

const wl_interface* output_interface_release_request_server[0] = {
};

const wl_interface* output_interface_geometry_event_server[8] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* output_interface_mode_event_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* output_interface_done_event_server[0] = {
};

const wl_interface* output_interface_scale_event_server[1] = {
  nullptr,
};

const wl_interface* output_interface_name_event_server[1] = {
  nullptr,
};

const wl_interface* output_interface_description_event_server[1] = {
  nullptr,
};

const wl_message output_interface_requests_server[1] = {
  {
    "release",
    "3",
    output_interface_release_request_server,
  },
};

const wl_message output_interface_events_server[6] = {
  {
    "geometry",
    "iiiiissi",
    output_interface_geometry_event_server,
  },
  {
    "mode",
    "uiii",
    output_interface_mode_event_server,
  },
  {
    "done",
    "2",
    output_interface_done_event_server,
  },
  {
    "scale",
    "2i",
    output_interface_scale_event_server,
  },
  {
    "name",
    "4s",
    output_interface_name_event_server,
  },
  {
    "description",
    "4s",
    output_interface_description_event_server,
  },
};

const wl_interface wayland::server::detail::output_interface =
  {
    "wl_output",
    4,
    1,
    output_interface_requests_server,
    6,
    output_interface_events_server,
  };

const wl_interface* region_interface_destroy_request_server[0] = {
};

const wl_interface* region_interface_add_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* region_interface_subtract_request_server[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_message region_interface_requests_server[3] = {
  {
    "destroy",
    "",
    region_interface_destroy_request_server,
  },
  {
    "add",
    "iiii",
    region_interface_add_request_server,
  },
  {
    "subtract",
    "iiii",
    region_interface_subtract_request_server,
  },
};

const wl_message region_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::region_interface =
  {
    "wl_region",
    1,
    3,
    region_interface_requests_server,
    0,
    region_interface_events_server,
  };

const wl_interface* subcompositor_interface_destroy_request_server[0] = {
};

const wl_interface* subcompositor_interface_get_subsurface_request_server[3] = {
  &subsurface_interface,
  &surface_interface,
  &surface_interface,
};

const wl_message subcompositor_interface_requests_server[2] = {
  {
    "destroy",
    "",
    subcompositor_interface_destroy_request_server,
  },
  {
    "get_subsurface",
    "noo",
    subcompositor_interface_get_subsurface_request_server,
  },
};

const wl_message subcompositor_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::subcompositor_interface =
  {
    "wl_subcompositor",
    1,
    2,
    subcompositor_interface_requests_server,
    0,
    subcompositor_interface_events_server,
  };

const wl_interface* subsurface_interface_destroy_request_server[0] = {
};

const wl_interface* subsurface_interface_set_position_request_server[2] = {
  nullptr,
  nullptr,
};

const wl_interface* subsurface_interface_place_above_request_server[1] = {
  &surface_interface,
};

const wl_interface* subsurface_interface_place_below_request_server[1] = {
  &surface_interface,
};

const wl_interface* subsurface_interface_set_sync_request_server[0] = {
};

const wl_interface* subsurface_interface_set_desync_request_server[0] = {
};

const wl_message subsurface_interface_requests_server[6] = {
  {
    "destroy",
    "",
    subsurface_interface_destroy_request_server,
  },
  {
    "set_position",
    "ii",
    subsurface_interface_set_position_request_server,
  },
  {
    "place_above",
    "o",
    subsurface_interface_place_above_request_server,
  },
  {
    "place_below",
    "o",
    subsurface_interface_place_below_request_server,
  },
  {
    "set_sync",
    "",
    subsurface_interface_set_sync_request_server,
  },
  {
    "set_desync",
    "",
    subsurface_interface_set_desync_request_server,
  },
};

const wl_message subsurface_interface_events_server[0] = {
};

const wl_interface wayland::server::detail::subsurface_interface =
  {
    "wl_subsurface",
    1,
    6,
    subsurface_interface_requests_server,
    0,
    subsurface_interface_events_server,
  };

registry_t::registry_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::registry_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

registry_t::registry_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string registry_t::interface_name = "wl_registry";

registry_t::operator wl_registry*() const
{
  return reinterpret_cast<wl_registry*> (c_ptr());
}

std::function<void(uint32_t, resource_t)> &registry_t::on_bind()
{
  return std::static_pointer_cast<events_t>(get_events())->bind;
}


void registry_t::global(uint32_t name, std::string const& interface, uint32_t version, bool post)
{
  send_event(post, 0, name, interface, version);
}

void registry_t::global_remove(uint32_t name, bool post)
{
  send_event(post, 1, name);
}

int registry_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->bind) events->bind(args[0].get<uint32_t>(), args[1].get<resource_t>());
      break;
    }
  return 0;
}

callback_t::callback_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::callback_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

callback_t::callback_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string callback_t::interface_name = "wl_callback";

callback_t::operator wl_callback*() const
{
  return reinterpret_cast<wl_callback*> (c_ptr());
}

void callback_t::done(uint32_t callback_data, bool post)
{
  send_event(post, 0, callback_data);
}

int callback_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  return 0;
}

compositor_t::compositor_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::compositor_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

compositor_t::compositor_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string compositor_t::interface_name = "wl_compositor";

compositor_t::operator wl_compositor*() const
{
  return reinterpret_cast<wl_compositor*> (c_ptr());
}

std::function<void(surface_t)> &compositor_t::on_create_surface()
{
  return std::static_pointer_cast<events_t>(get_events())->create_surface;
}


std::function<void(region_t)> &compositor_t::on_create_region()
{
  return std::static_pointer_cast<events_t>(get_events())->create_region;
}


int compositor_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->create_surface) events->create_surface(surface_t(args[0].get<resource_t>()));
      break;
    case 1:
      if(events->create_region) events->create_region(region_t(args[0].get<resource_t>()));
      break;
    }
  return 0;
}

shm_pool_t::shm_pool_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::shm_pool_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

shm_pool_t::shm_pool_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string shm_pool_t::interface_name = "wl_shm_pool";

shm_pool_t::operator wl_shm_pool*() const
{
  return reinterpret_cast<wl_shm_pool*> (c_ptr());
}

std::function<void(buffer_t, int32_t, int32_t, int32_t, int32_t, shm_format)> &shm_pool_t::on_create_buffer()
{
  return std::static_pointer_cast<events_t>(get_events())->create_buffer;
}


std::function<void()> &shm_pool_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(int32_t)> &shm_pool_t::on_resize()
{
  return std::static_pointer_cast<events_t>(get_events())->resize;
}


int shm_pool_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->create_buffer) events->create_buffer(buffer_t(args[0].get<resource_t>()), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>(), args[4].get<int32_t>(), shm_format(args[5].get<uint32_t>()));
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    case 2:
      if(events->resize) events->resize(args[0].get<int32_t>());
      break;
    }
  return 0;
}

shm_t::shm_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::shm_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

shm_t::shm_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string shm_t::interface_name = "wl_shm";

shm_t::operator wl_shm*() const
{
  return reinterpret_cast<wl_shm*> (c_ptr());
}

std::function<void(shm_pool_t, int, int32_t)> &shm_t::on_create_pool()
{
  return std::static_pointer_cast<events_t>(get_events())->create_pool;
}


void shm_t::format(shm_format const& format, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(format));
}

void shm_t::post_invalid_format(std::string const& msg)
{
  post_error(static_cast<uint32_t>(shm_error::invalid_format), msg);
}

void shm_t::post_invalid_stride(std::string const& msg)
{
  post_error(static_cast<uint32_t>(shm_error::invalid_stride), msg);
}

void shm_t::post_invalid_fd(std::string const& msg)
{
  post_error(static_cast<uint32_t>(shm_error::invalid_fd), msg);
}

int shm_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->create_pool) events->create_pool(shm_pool_t(args[0].get<resource_t>()), args[1].get<int>(), args[2].get<int32_t>());
      break;
    }
  return 0;
}



buffer_t::buffer_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::buffer_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

buffer_t::buffer_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string buffer_t::interface_name = "wl_buffer";

buffer_t::operator wl_buffer*() const
{
  return reinterpret_cast<wl_buffer*> (c_ptr());
}

std::function<void()> &buffer_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


void buffer_t::release(bool post)
{
  send_event(post, 0);
}

int buffer_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    }
  return 0;
}

data_offer_t::data_offer_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::data_offer_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

data_offer_t::data_offer_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string data_offer_t::interface_name = "wl_data_offer";

data_offer_t::operator wl_data_offer*() const
{
  return reinterpret_cast<wl_data_offer*> (c_ptr());
}

std::function<void(uint32_t, std::string)> &data_offer_t::on_accept()
{
  return std::static_pointer_cast<events_t>(get_events())->accept;
}


std::function<void(std::string, int)> &data_offer_t::on_receive()
{
  return std::static_pointer_cast<events_t>(get_events())->receive;
}


std::function<void()> &data_offer_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void()> &data_offer_t::on_finish()
{
  return std::static_pointer_cast<events_t>(get_events())->finish;
}


std::function<void(data_device_manager_dnd_action, data_device_manager_dnd_action)> &data_offer_t::on_set_actions()
{
  return std::static_pointer_cast<events_t>(get_events())->set_actions;
}


void data_offer_t::offer(std::string const& mime_type, bool post)
{
  send_event(post, 0, mime_type);
}

void data_offer_t::source_actions(data_device_manager_dnd_action const& source_actions, bool post)
{
  send_event(post, 1, static_cast<uint32_t>(source_actions));
}

bool data_offer_t::can_source_actions() const
{
  return (get_version() >= source_actions_since_version);
}

void data_offer_t::action(data_device_manager_dnd_action const& dnd_action, bool post)
{
  send_event(post, 2, static_cast<uint32_t>(dnd_action));
}

bool data_offer_t::can_action() const
{
  return (get_version() >= action_since_version);
}

void data_offer_t::post_invalid_finish(std::string const& msg)
{
  post_error(static_cast<uint32_t>(data_offer_error::invalid_finish), msg);
}

void data_offer_t::post_invalid_action_mask(std::string const& msg)
{
  post_error(static_cast<uint32_t>(data_offer_error::invalid_action_mask), msg);
}

void data_offer_t::post_invalid_action(std::string const& msg)
{
  post_error(static_cast<uint32_t>(data_offer_error::invalid_action), msg);
}

void data_offer_t::post_invalid_offer(std::string const& msg)
{
  post_error(static_cast<uint32_t>(data_offer_error::invalid_offer), msg);
}

int data_offer_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->accept) events->accept(args[0].get<uint32_t>(), args[1].get<std::string>());
      break;
    case 1:
      if(events->receive) events->receive(args[0].get<std::string>(), args[1].get<int>());
      break;
    case 2:
      if(events->destroy) events->destroy();
      break;
    case 3:
      if(events->finish) events->finish();
      break;
    case 4:
      if(events->set_actions) events->set_actions(data_device_manager_dnd_action(args[0].get<uint32_t>()), data_device_manager_dnd_action(args[1].get<uint32_t>()));
      break;
    }
  return 0;
}


data_source_t::data_source_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::data_source_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

data_source_t::data_source_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string data_source_t::interface_name = "wl_data_source";

data_source_t::operator wl_data_source*() const
{
  return reinterpret_cast<wl_data_source*> (c_ptr());
}

std::function<void(std::string)> &data_source_t::on_offer()
{
  return std::static_pointer_cast<events_t>(get_events())->offer;
}


std::function<void()> &data_source_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(data_device_manager_dnd_action)> &data_source_t::on_set_actions()
{
  return std::static_pointer_cast<events_t>(get_events())->set_actions;
}


void data_source_t::target(std::string const& mime_type, bool post)
{
  send_event(post, 0, mime_type);
}

void data_source_t::send(std::string const& mime_type, int fd, bool post)
{
  send_event(post, 1, mime_type, argument_t::fd(fd));
}

void data_source_t::cancelled(bool post)
{
  send_event(post, 2);
}

void data_source_t::dnd_drop_performed(bool post)
{
  send_event(post, 3);
}

bool data_source_t::can_dnd_drop_performed() const
{
  return (get_version() >= dnd_drop_performed_since_version);
}

void data_source_t::dnd_finished(bool post)
{
  send_event(post, 4);
}

bool data_source_t::can_dnd_finished() const
{
  return (get_version() >= dnd_finished_since_version);
}

void data_source_t::action(data_device_manager_dnd_action const& dnd_action, bool post)
{
  send_event(post, 5, static_cast<uint32_t>(dnd_action));
}

bool data_source_t::can_action() const
{
  return (get_version() >= action_since_version);
}

void data_source_t::post_invalid_action_mask(std::string const& msg)
{
  post_error(static_cast<uint32_t>(data_source_error::invalid_action_mask), msg);
}

void data_source_t::post_invalid_source(std::string const& msg)
{
  post_error(static_cast<uint32_t>(data_source_error::invalid_source), msg);
}

int data_source_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->offer) events->offer(args[0].get<std::string>());
      break;
    case 1:
      if(events->destroy) events->destroy();
      break;
    case 2:
      if(events->set_actions) events->set_actions(data_device_manager_dnd_action(args[0].get<uint32_t>()));
      break;
    }
  return 0;
}


data_device_t::data_device_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::data_device_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

data_device_t::data_device_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string data_device_t::interface_name = "wl_data_device";

data_device_t::operator wl_data_device*() const
{
  return reinterpret_cast<wl_data_device*> (c_ptr());
}

std::function<void(data_source_t, surface_t, surface_t, uint32_t)> &data_device_t::on_start_drag()
{
  return std::static_pointer_cast<events_t>(get_events())->start_drag;
}


std::function<void(data_source_t, uint32_t)> &data_device_t::on_set_selection()
{
  return std::static_pointer_cast<events_t>(get_events())->set_selection;
}


std::function<void()> &data_device_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}


void data_device_t::data_offer(bool post)
{
  send_event(post, 0, nullptr);
}

void data_device_t::enter(uint32_t serial, surface_t const& surface, double x, double y, data_offer_t const& id, bool post)
{
  send_event(post, 1, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, x, y, id.proxy_has_object() ? reinterpret_cast<wl_object*>(id.c_ptr()) : nullptr);
}

void data_device_t::leave(bool post)
{
  send_event(post, 2);
}

void data_device_t::motion(uint32_t time, double x, double y, bool post)
{
  send_event(post, 3, time, x, y);
}

void data_device_t::drop(bool post)
{
  send_event(post, 4);
}

void data_device_t::selection(data_offer_t const& id, bool post)
{
  send_event(post, 5, id.proxy_has_object() ? reinterpret_cast<wl_object*>(id.c_ptr()) : nullptr);
}

void data_device_t::post_role(std::string const& msg)
{
  post_error(static_cast<uint32_t>(data_device_error::role), msg);
}

int data_device_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->start_drag) events->start_drag(data_source_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()), surface_t(args[2].get<resource_t>()), args[3].get<uint32_t>());
      break;
    case 1:
      if(events->set_selection) events->set_selection(data_source_t(args[0].get<resource_t>()), args[1].get<uint32_t>());
      break;
    case 2:
      if(events->release) events->release();
      break;
    }
  return 0;
}


data_device_manager_t::data_device_manager_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::data_device_manager_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

data_device_manager_t::data_device_manager_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string data_device_manager_t::interface_name = "wl_data_device_manager";

data_device_manager_t::operator wl_data_device_manager*() const
{
  return reinterpret_cast<wl_data_device_manager*> (c_ptr());
}

std::function<void(data_source_t)> &data_device_manager_t::on_create_data_source()
{
  return std::static_pointer_cast<events_t>(get_events())->create_data_source;
}


std::function<void(data_device_t, seat_t)> &data_device_manager_t::on_get_data_device()
{
  return std::static_pointer_cast<events_t>(get_events())->get_data_device;
}


int data_device_manager_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->create_data_source) events->create_data_source(data_source_t(args[0].get<resource_t>()));
      break;
    case 1:
      if(events->get_data_device) events->get_data_device(data_device_t(args[0].get<resource_t>()), seat_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}
const bitfield<3, 6> data_device_manager_dnd_action::none{0};
const bitfield<3, 6> data_device_manager_dnd_action::copy{1};
const bitfield<3, 6> data_device_manager_dnd_action::move{2};
const bitfield<3, 6> data_device_manager_dnd_action::ask{4};


shell_t::shell_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::shell_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

shell_t::shell_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string shell_t::interface_name = "wl_shell";

shell_t::operator wl_shell*() const
{
  return reinterpret_cast<wl_shell*> (c_ptr());
}

std::function<void(shell_surface_t, surface_t)> &shell_t::on_get_shell_surface()
{
  return std::static_pointer_cast<events_t>(get_events())->get_shell_surface;
}


void shell_t::post_role(std::string const& msg)
{
  post_error(static_cast<uint32_t>(shell_error::role), msg);
}

int shell_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->get_shell_surface) events->get_shell_surface(shell_surface_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()));
      break;
    }
  return 0;
}


shell_surface_t::shell_surface_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::shell_surface_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

shell_surface_t::shell_surface_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string shell_surface_t::interface_name = "wl_shell_surface";

shell_surface_t::operator wl_shell_surface*() const
{
  return reinterpret_cast<wl_shell_surface*> (c_ptr());
}

std::function<void(uint32_t)> &shell_surface_t::on_pong()
{
  return std::static_pointer_cast<events_t>(get_events())->pong;
}


std::function<void(seat_t, uint32_t)> &shell_surface_t::on_move()
{
  return std::static_pointer_cast<events_t>(get_events())->move;
}


std::function<void(seat_t, uint32_t, shell_surface_resize)> &shell_surface_t::on_resize()
{
  return std::static_pointer_cast<events_t>(get_events())->resize;
}


std::function<void()> &shell_surface_t::on_set_toplevel()
{
  return std::static_pointer_cast<events_t>(get_events())->set_toplevel;
}


std::function<void(surface_t, int32_t, int32_t, shell_surface_transient)> &shell_surface_t::on_set_transient()
{
  return std::static_pointer_cast<events_t>(get_events())->set_transient;
}


std::function<void(shell_surface_fullscreen_method, uint32_t, output_t)> &shell_surface_t::on_set_fullscreen()
{
  return std::static_pointer_cast<events_t>(get_events())->set_fullscreen;
}


std::function<void(seat_t, uint32_t, surface_t, int32_t, int32_t, shell_surface_transient)> &shell_surface_t::on_set_popup()
{
  return std::static_pointer_cast<events_t>(get_events())->set_popup;
}


std::function<void(output_t)> &shell_surface_t::on_set_maximized()
{
  return std::static_pointer_cast<events_t>(get_events())->set_maximized;
}


std::function<void(std::string)> &shell_surface_t::on_set_title()
{
  return std::static_pointer_cast<events_t>(get_events())->set_title;
}


std::function<void(std::string)> &shell_surface_t::on_set_class()
{
  return std::static_pointer_cast<events_t>(get_events())->set_class;
}


void shell_surface_t::ping(uint32_t serial, bool post)
{
  send_event(post, 0, serial);
}

void shell_surface_t::configure(shell_surface_resize const& edges, int32_t width, int32_t height, bool post)
{
  send_event(post, 1, static_cast<uint32_t>(edges), width, height);
}

void shell_surface_t::popup_done(bool post)
{
  send_event(post, 2);
}

int shell_surface_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->pong) events->pong(args[0].get<uint32_t>());
      break;
    case 1:
      if(events->move) events->move(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>());
      break;
    case 2:
      if(events->resize) events->resize(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>(), shell_surface_resize(args[2].get<uint32_t>()));
      break;
    case 3:
      if(events->set_toplevel) events->set_toplevel();
      break;
    case 4:
      if(events->set_transient) events->set_transient(surface_t(args[0].get<resource_t>()), args[1].get<int32_t>(), args[2].get<int32_t>(), shell_surface_transient(args[3].get<uint32_t>()));
      break;
    case 5:
      if(events->set_fullscreen) events->set_fullscreen(shell_surface_fullscreen_method(args[0].get<uint32_t>()), args[1].get<uint32_t>(), output_t(args[2].get<resource_t>()));
      break;
    case 6:
      if(events->set_popup) events->set_popup(seat_t(args[0].get<resource_t>()), args[1].get<uint32_t>(), surface_t(args[2].get<resource_t>()), args[3].get<int32_t>(), args[4].get<int32_t>(), shell_surface_transient(args[5].get<uint32_t>()));
      break;
    case 7:
      if(events->set_maximized) events->set_maximized(output_t(args[0].get<resource_t>()));
      break;
    case 8:
      if(events->set_title) events->set_title(args[0].get<std::string>());
      break;
    case 9:
      if(events->set_class) events->set_class(args[0].get<std::string>());
      break;
    }
  return 0;
}
const bitfield<4, 8> shell_surface_resize::none{0};
const bitfield<4, 8> shell_surface_resize::top{1};
const bitfield<4, 8> shell_surface_resize::bottom{2};
const bitfield<4, 8> shell_surface_resize::left{4};
const bitfield<4, 8> shell_surface_resize::top_left{5};
const bitfield<4, 8> shell_surface_resize::bottom_left{6};
const bitfield<4, 8> shell_surface_resize::right{8};
const bitfield<4, 8> shell_surface_resize::top_right{9};
const bitfield<4, 8> shell_surface_resize::bottom_right{10};

const bitfield<1, 9> shell_surface_transient::inactive{0x1};



surface_t::surface_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::surface_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

surface_t::surface_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string surface_t::interface_name = "wl_surface";

surface_t::operator wl_surface*() const
{
  return reinterpret_cast<wl_surface*> (c_ptr());
}

std::function<void()> &surface_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(buffer_t, int32_t, int32_t)> &surface_t::on_attach()
{
  return std::static_pointer_cast<events_t>(get_events())->attach;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &surface_t::on_damage()
{
  return std::static_pointer_cast<events_t>(get_events())->damage;
}


std::function<void(callback_t)> &surface_t::on_frame()
{
  return std::static_pointer_cast<events_t>(get_events())->frame;
}


std::function<void(region_t)> &surface_t::on_set_opaque_region()
{
  return std::static_pointer_cast<events_t>(get_events())->set_opaque_region;
}


std::function<void(region_t)> &surface_t::on_set_input_region()
{
  return std::static_pointer_cast<events_t>(get_events())->set_input_region;
}


std::function<void()> &surface_t::on_commit()
{
  return std::static_pointer_cast<events_t>(get_events())->commit;
}


std::function<void(output_transform)> &surface_t::on_set_buffer_transform()
{
  return std::static_pointer_cast<events_t>(get_events())->set_buffer_transform;
}


std::function<void(int32_t)> &surface_t::on_set_buffer_scale()
{
  return std::static_pointer_cast<events_t>(get_events())->set_buffer_scale;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &surface_t::on_damage_buffer()
{
  return std::static_pointer_cast<events_t>(get_events())->damage_buffer;
}


std::function<void(int32_t, int32_t)> &surface_t::on_offset()
{
  return std::static_pointer_cast<events_t>(get_events())->offset;
}


void surface_t::enter(output_t const& output, bool post)
{
  send_event(post, 0, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
}

void surface_t::leave(output_t const& output, bool post)
{
  send_event(post, 1, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
}

void surface_t::post_invalid_scale(std::string const& msg)
{
  post_error(static_cast<uint32_t>(surface_error::invalid_scale), msg);
}

void surface_t::post_invalid_transform(std::string const& msg)
{
  post_error(static_cast<uint32_t>(surface_error::invalid_transform), msg);
}

void surface_t::post_invalid_size(std::string const& msg)
{
  post_error(static_cast<uint32_t>(surface_error::invalid_size), msg);
}

void surface_t::post_invalid_offset(std::string const& msg)
{
  post_error(static_cast<uint32_t>(surface_error::invalid_offset), msg);
}

int surface_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->attach) events->attach(buffer_t(args[0].get<resource_t>()), args[1].get<int32_t>(), args[2].get<int32_t>());
      break;
    case 2:
      if(events->damage) events->damage(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 3:
      if(events->frame) events->frame(callback_t(args[0].get<resource_t>()));
      break;
    case 4:
      if(events->set_opaque_region) events->set_opaque_region(region_t(args[0].get<resource_t>()));
      break;
    case 5:
      if(events->set_input_region) events->set_input_region(region_t(args[0].get<resource_t>()));
      break;
    case 6:
      if(events->commit) events->commit();
      break;
    case 7:
      if(events->set_buffer_transform) events->set_buffer_transform(output_transform(args[0].get<int32_t>()));
      break;
    case 8:
      if(events->set_buffer_scale) events->set_buffer_scale(args[0].get<int32_t>());
      break;
    case 9:
      if(events->damage_buffer) events->damage_buffer(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 10:
      if(events->offset) events->offset(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    }
  return 0;
}


seat_t::seat_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::seat_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

seat_t::seat_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string seat_t::interface_name = "wl_seat";

seat_t::operator wl_seat*() const
{
  return reinterpret_cast<wl_seat*> (c_ptr());
}

std::function<void(pointer_t)> &seat_t::on_get_pointer()
{
  return std::static_pointer_cast<events_t>(get_events())->get_pointer;
}


std::function<void(keyboard_t)> &seat_t::on_get_keyboard()
{
  return std::static_pointer_cast<events_t>(get_events())->get_keyboard;
}


std::function<void(touch_t)> &seat_t::on_get_touch()
{
  return std::static_pointer_cast<events_t>(get_events())->get_touch;
}


std::function<void()> &seat_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}


void seat_t::capabilities(seat_capability const& capabilities, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(capabilities));
}

void seat_t::name(std::string const& name, bool post)
{
  send_event(post, 1, name);
}

bool seat_t::can_name() const
{
  return (get_version() >= name_since_version);
}

void seat_t::post_missing_capability(std::string const& msg)
{
  post_error(static_cast<uint32_t>(seat_error::missing_capability), msg);
}

int seat_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->get_pointer) events->get_pointer(pointer_t(args[0].get<resource_t>()));
      break;
    case 1:
      if(events->get_keyboard) events->get_keyboard(keyboard_t(args[0].get<resource_t>()));
      break;
    case 2:
      if(events->get_touch) events->get_touch(touch_t(args[0].get<resource_t>()));
      break;
    case 3:
      if(events->release) events->release();
      break;
    }
  return 0;
}
const bitfield<3, 12> seat_capability::pointer{1};
const bitfield<3, 12> seat_capability::keyboard{2};
const bitfield<3, 12> seat_capability::touch{4};



pointer_t::pointer_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::pointer_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

pointer_t::pointer_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string pointer_t::interface_name = "wl_pointer";

pointer_t::operator wl_pointer*() const
{
  return reinterpret_cast<wl_pointer*> (c_ptr());
}

std::function<void(uint32_t, surface_t, int32_t, int32_t)> &pointer_t::on_set_cursor()
{
  return std::static_pointer_cast<events_t>(get_events())->set_cursor;
}


std::function<void()> &pointer_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}


void pointer_t::enter(uint32_t serial, surface_t const& surface, double surface_x, double surface_y, bool post)
{
  send_event(post, 0, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, surface_x, surface_y);
}

void pointer_t::leave(uint32_t serial, surface_t const& surface, bool post)
{
  send_event(post, 1, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void pointer_t::motion(uint32_t time, double surface_x, double surface_y, bool post)
{
  send_event(post, 2, time, surface_x, surface_y);
}

void pointer_t::button(uint32_t serial, uint32_t time, uint32_t button, pointer_button_state const& state, bool post)
{
  send_event(post, 3, serial, time, button, static_cast<uint32_t>(state));
}

void pointer_t::axis(uint32_t time, pointer_axis const& axis, double value, bool post)
{
  send_event(post, 4, time, static_cast<uint32_t>(axis), value);
}

void pointer_t::frame(bool post)
{
  send_event(post, 5);
}

bool pointer_t::can_frame() const
{
  return (get_version() >= frame_since_version);
}

void pointer_t::axis_source(pointer_axis_source const& axis_source, bool post)
{
  send_event(post, 6, static_cast<uint32_t>(axis_source));
}

bool pointer_t::can_axis_source() const
{
  return (get_version() >= axis_source_since_version);
}

void pointer_t::axis_stop(uint32_t time, pointer_axis const& axis, bool post)
{
  send_event(post, 7, time, static_cast<uint32_t>(axis));
}

bool pointer_t::can_axis_stop() const
{
  return (get_version() >= axis_stop_since_version);
}

void pointer_t::axis_discrete(pointer_axis const& axis, int32_t discrete, bool post)
{
  send_event(post, 8, static_cast<uint32_t>(axis), discrete);
}

bool pointer_t::can_axis_discrete() const
{
  return (get_version() >= axis_discrete_since_version);
}

void pointer_t::axis_value120(pointer_axis const& axis, int32_t value120, bool post)
{
  send_event(post, 9, static_cast<uint32_t>(axis), value120);
}

bool pointer_t::can_axis_value120() const
{
  return (get_version() >= axis_value120_since_version);
}

void pointer_t::post_role(std::string const& msg)
{
  post_error(static_cast<uint32_t>(pointer_error::role), msg);
}

int pointer_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->set_cursor) events->set_cursor(args[0].get<uint32_t>(), surface_t(args[1].get<resource_t>()), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 1:
      if(events->release) events->release();
      break;
    }
  return 0;
}





keyboard_t::keyboard_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::keyboard_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

keyboard_t::keyboard_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string keyboard_t::interface_name = "wl_keyboard";

keyboard_t::operator wl_keyboard*() const
{
  return reinterpret_cast<wl_keyboard*> (c_ptr());
}

std::function<void()> &keyboard_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}


void keyboard_t::keymap(keyboard_keymap_format const& format, int fd, uint32_t size, bool post)
{
  send_event(post, 0, static_cast<uint32_t>(format), argument_t::fd(fd), size);
}

void keyboard_t::enter(uint32_t serial, surface_t const& surface, array_t const& keys, bool post)
{
  send_event(post, 1, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, keys);
}

void keyboard_t::leave(uint32_t serial, surface_t const& surface, bool post)
{
  send_event(post, 2, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
}

void keyboard_t::key(uint32_t serial, uint32_t time, uint32_t key, keyboard_key_state const& state, bool post)
{
  send_event(post, 3, serial, time, key, static_cast<uint32_t>(state));
}

void keyboard_t::modifiers(uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group, bool post)
{
  send_event(post, 4, serial, mods_depressed, mods_latched, mods_locked, group);
}

void keyboard_t::repeat_info(int32_t rate, int32_t delay, bool post)
{
  send_event(post, 5, rate, delay);
}

bool keyboard_t::can_repeat_info() const
{
  return (get_version() >= repeat_info_since_version);
}

int keyboard_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->release) events->release();
      break;
    }
  return 0;
}



touch_t::touch_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::touch_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

touch_t::touch_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string touch_t::interface_name = "wl_touch";

touch_t::operator wl_touch*() const
{
  return reinterpret_cast<wl_touch*> (c_ptr());
}

std::function<void()> &touch_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}


void touch_t::down(uint32_t serial, uint32_t time, surface_t const& surface, int32_t id, double x, double y, bool post)
{
  send_event(post, 0, serial, time, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, id, x, y);
}

void touch_t::up(uint32_t serial, uint32_t time, int32_t id, bool post)
{
  send_event(post, 1, serial, time, id);
}

void touch_t::motion(uint32_t time, int32_t id, double x, double y, bool post)
{
  send_event(post, 2, time, id, x, y);
}

void touch_t::frame(bool post)
{
  send_event(post, 3);
}

void touch_t::cancel(bool post)
{
  send_event(post, 4);
}

void touch_t::shape(int32_t id, double major, double minor, bool post)
{
  send_event(post, 5, id, major, minor);
}

bool touch_t::can_shape() const
{
  return (get_version() >= shape_since_version);
}

void touch_t::orientation(int32_t id, double orientation, bool post)
{
  send_event(post, 6, id, orientation);
}

bool touch_t::can_orientation() const
{
  return (get_version() >= orientation_since_version);
}

int touch_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->release) events->release();
      break;
    }
  return 0;
}

output_t::output_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::output_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

output_t::output_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string output_t::interface_name = "wl_output";

output_t::operator wl_output*() const
{
  return reinterpret_cast<wl_output*> (c_ptr());
}

std::function<void()> &output_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}


void output_t::geometry(int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, output_subpixel const& subpixel, std::string const& make, std::string const& model, output_transform const& transform, bool post)
{
  send_event(post, 0, x, y, physical_width, physical_height, static_cast<int32_t>(subpixel), make, model, static_cast<int32_t>(transform));
}

void output_t::mode(output_mode const& flags, int32_t width, int32_t height, int32_t refresh, bool post)
{
  send_event(post, 1, static_cast<uint32_t>(flags), width, height, refresh);
}

void output_t::done(bool post)
{
  send_event(post, 2);
}

bool output_t::can_done() const
{
  return (get_version() >= done_since_version);
}

void output_t::scale(int32_t factor, bool post)
{
  send_event(post, 3, factor);
}

bool output_t::can_scale() const
{
  return (get_version() >= scale_since_version);
}

void output_t::name(std::string const& name, bool post)
{
  send_event(post, 4, name);
}

bool output_t::can_name() const
{
  return (get_version() >= name_since_version);
}

void output_t::description(std::string const& description, bool post)
{
  send_event(post, 5, description);
}

bool output_t::can_description() const
{
  return (get_version() >= description_since_version);
}

int output_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->release) events->release();
      break;
    }
  return 0;
}

const bitfield<3, 21> output_transform::normal{0};
const bitfield<3, 21> output_transform::_90{1};
const bitfield<3, 21> output_transform::_180{2};
const bitfield<3, 21> output_transform::_270{3};
const bitfield<3, 21> output_transform::flipped{4};
const bitfield<3, 21> output_transform::flipped_90{5};
const bitfield<3, 21> output_transform::flipped_180{6};
const bitfield<3, 21> output_transform::flipped_270{7};

const bitfield<2, 22> output_mode::current{0x1};
const bitfield<2, 22> output_mode::preferred{0x2};


region_t::region_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::region_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

region_t::region_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string region_t::interface_name = "wl_region";

region_t::operator wl_region*() const
{
  return reinterpret_cast<wl_region*> (c_ptr());
}

std::function<void()> &region_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &region_t::on_add()
{
  return std::static_pointer_cast<events_t>(get_events())->add;
}


std::function<void(int32_t, int32_t, int32_t, int32_t)> &region_t::on_subtract()
{
  return std::static_pointer_cast<events_t>(get_events())->subtract;
}


int region_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->add) events->add(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 2:
      if(events->subtract) events->subtract(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    }
  return 0;
}

subcompositor_t::subcompositor_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::subcompositor_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

subcompositor_t::subcompositor_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string subcompositor_t::interface_name = "wl_subcompositor";

subcompositor_t::operator wl_subcompositor*() const
{
  return reinterpret_cast<wl_subcompositor*> (c_ptr());
}

std::function<void()> &subcompositor_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(subsurface_t, surface_t, surface_t)> &subcompositor_t::on_get_subsurface()
{
  return std::static_pointer_cast<events_t>(get_events())->get_subsurface;
}


void subcompositor_t::post_bad_surface(std::string const& msg)
{
  post_error(static_cast<uint32_t>(subcompositor_error::bad_surface), msg);
}

int subcompositor_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->get_subsurface) events->get_subsurface(subsurface_t(args[0].get<resource_t>()), surface_t(args[1].get<resource_t>()), surface_t(args[2].get<resource_t>()));
      break;
    }
  return 0;
}


subsurface_t::subsurface_t(const client_t& client, uint32_t id, int version)
  : resource_t(client, &server::detail::subsurface_interface, id, version)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

subsurface_t::subsurface_t(const resource_t &resource)
  : resource_t(resource)
{
  set_events(std::shared_ptr<resource_t::events_base_t>(new events_t), dispatcher);
}

const std::string subsurface_t::interface_name = "wl_subsurface";

subsurface_t::operator wl_subsurface*() const
{
  return reinterpret_cast<wl_subsurface*> (c_ptr());
}

std::function<void()> &subsurface_t::on_destroy()
{
  return std::static_pointer_cast<events_t>(get_events())->destroy;
}


std::function<void(int32_t, int32_t)> &subsurface_t::on_set_position()
{
  return std::static_pointer_cast<events_t>(get_events())->set_position;
}


std::function<void(surface_t)> &subsurface_t::on_place_above()
{
  return std::static_pointer_cast<events_t>(get_events())->place_above;
}


std::function<void(surface_t)> &subsurface_t::on_place_below()
{
  return std::static_pointer_cast<events_t>(get_events())->place_below;
}


std::function<void()> &subsurface_t::on_set_sync()
{
  return std::static_pointer_cast<events_t>(get_events())->set_sync;
}


std::function<void()> &subsurface_t::on_set_desync()
{
  return std::static_pointer_cast<events_t>(get_events())->set_desync;
}


void subsurface_t::post_bad_surface(std::string const& msg)
{
  post_error(static_cast<uint32_t>(subsurface_error::bad_surface), msg);
}

int subsurface_t::dispatcher(int opcode, const std::vector<any>& args, const std::shared_ptr<resource_t::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->destroy) events->destroy();
      break;
    case 1:
      if(events->set_position) events->set_position(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    case 2:
      if(events->place_above) events->place_above(surface_t(args[0].get<resource_t>()));
      break;
    case 3:
      if(events->place_below) events->place_below(surface_t(args[0].get<resource_t>()));
      break;
    case 4:
      if(events->set_sync) events->set_sync();
      break;
    case 5:
      if(events->set_desync) events->set_desync();
      break;
    }
  return 0;
}



