// python wrapper for ttkGridLayout
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkGridLayout.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkGridLayout(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkGridLayout_ClassNew(); }


static PyObject *
PyttkGridLayout_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkGridLayout::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkGridLayout::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkGridLayout *tempr = ttkGridLayout::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkGridLayout *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkGridLayout::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkGridLayout::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkGridLayout::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_SetColAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColAxis(temp0);
    }
    else
    {
      op->ttkGridLayout::SetColAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_GetColAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetColAxis() :
      op->ttkGridLayout::GetColAxis());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_SetRowAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRowAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRowAxis(temp0);
    }
    else
    {
      op->ttkGridLayout::SetRowAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_GetRowAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRowAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRowAxis() :
      op->ttkGridLayout::GetRowAxis());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_SetColGap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColGap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColGap(temp0);
    }
    else
    {
      op->ttkGridLayout::SetColGap(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_GetColGap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColGap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetColGap() :
      op->ttkGridLayout::GetColGap());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_SetRowGap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRowGap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRowGap(temp0);
    }
    else
    {
      op->ttkGridLayout::SetRowGap(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_GetRowGap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRowGap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetRowGap() :
      op->ttkGridLayout::GetRowGap());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_SetNumberOfRows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfRows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfRows(temp0);
    }
    else
    {
      op->ttkGridLayout::SetNumberOfRows(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkGridLayout_GetNumberOfRows(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfRows");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkGridLayout *op = static_cast<ttkGridLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfRows() :
      op->ttkGridLayout::GetNumberOfRows());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkGridLayout_Methods[] = {
  {"IsTypeOf", PyttkGridLayout_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkGridLayout_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkGridLayout_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkGridLayout\nC++: static ttkGridLayout *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkGridLayout_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkGridLayout\nC++: ttkGridLayout *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkGridLayout_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkGridLayout_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetColAxis", PyttkGridLayout_SetColAxis, METH_VARARGS,
   "SetColAxis(self, _arg:int) -> None\nC++: virtual void SetColAxis(int _arg)\n\n"},
  {"GetColAxis", PyttkGridLayout_GetColAxis, METH_VARARGS,
   "GetColAxis(self) -> int\nC++: virtual int GetColAxis()\n\n"},
  {"SetRowAxis", PyttkGridLayout_SetRowAxis, METH_VARARGS,
   "SetRowAxis(self, _arg:int) -> None\nC++: virtual void SetRowAxis(int _arg)\n\n"},
  {"GetRowAxis", PyttkGridLayout_GetRowAxis, METH_VARARGS,
   "GetRowAxis(self) -> int\nC++: virtual int GetRowAxis()\n\n"},
  {"SetColGap", PyttkGridLayout_SetColGap, METH_VARARGS,
   "SetColGap(self, _arg:float) -> None\nC++: virtual void SetColGap(double _arg)\n\n"},
  {"GetColGap", PyttkGridLayout_GetColGap, METH_VARARGS,
   "GetColGap(self) -> float\nC++: virtual double GetColGap()\n\n"},
  {"SetRowGap", PyttkGridLayout_SetRowGap, METH_VARARGS,
   "SetRowGap(self, _arg:float) -> None\nC++: virtual void SetRowGap(double _arg)\n\n"},
  {"GetRowGap", PyttkGridLayout_GetRowGap, METH_VARARGS,
   "GetRowGap(self) -> float\nC++: virtual double GetRowGap()\n\n"},
  {"SetNumberOfRows", PyttkGridLayout_SetNumberOfRows, METH_VARARGS,
   "SetNumberOfRows(self, _arg:int) -> None\nC++: virtual void SetNumberOfRows(int _arg)\n\n"},
  {"GetNumberOfRows", PyttkGridLayout_GetNumberOfRows, METH_VARARGS,
   "GetNumberOfRows(self) -> int\nC++: virtual int GetNumberOfRows()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkGridLayout_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("col_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGridLayout_GetColAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGridLayout_SetColAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGridLayout_SetColAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetColAxis/SetColAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("row_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGridLayout_GetRowAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGridLayout_SetRowAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGridLayout_SetRowAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRowAxis/SetRowAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("col_gap"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGridLayout_GetColGap(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGridLayout_SetColGap(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGridLayout_SetColGap(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetColGap/SetColGap\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("row_gap"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGridLayout_GetRowGap(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGridLayout_SetRowGap(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGridLayout_SetRowGap(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRowGap/SetRowGap\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_rows"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkGridLayout_GetNumberOfRows(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkGridLayout_SetNumberOfRows(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkGridLayout_SetNumberOfRows(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfRows/SetNumberOfRows\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkGridLayout_Doc =
  "ttkGridLayout - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 01.10.2018\n\n"
  "TTK VTK-filter that arranges vtkDataSets on a grid.\n\n"
  "This filter arranges vtkDataSets which are stored in a\n"
  "vtkMultiBlockDataSet on a grid.\n\n"
  "\\param Input vtkMultiBlockDataSet\n"
  "\\param Output vtkMultiBlockDataSet\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/cinemaIO/\">Cinema\n"
  "   IO example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/contourTreeAlignment/\"\n"
  "  >Contour Tree Alignment example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkGridLayout_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkGridLayout.ttkGridLayout", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkGridLayout_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkGridLayout_StaticNew()
{
  return ttkGridLayout::New();
}

PyObject *PyttkGridLayout_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkGridLayout_Type, PyttkGridLayout_Methods,
    "ttkGridLayout",
 &PyttkGridLayout_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkGridLayout_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkGridLayout(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkGridLayout_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkGridLayout", o) != 0)
  {
    Py_DECREF(o);
  }

}

