/* MainView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MainView.vala, do not modify */

/*
* SPDX-License-Identifier: LGPL-3.0-or-later
* SPDX-FileCopyrightText: 2016-2025 elementary, Inc. (https://elementary.io)
*
* Authored by: Corentin Noël <corentin@elementary.io>
*              Oleksandr Lynok <oleksandr.lynok@gmail.com>
*/

#include "bluetooth.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BLUETOOTH_MAIN_VIEW_0_PROPERTY,
	BLUETOOTH_MAIN_VIEW_NUM_PROPERTIES
};
static GParamSpec* bluetooth_main_view_properties[BLUETOOTH_MAIN_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BLUETOOTH_MAIN_VIEW_QUIT_PLUG_SIGNAL,
	BLUETOOTH_MAIN_VIEW_NUM_SIGNALS
};
static guint bluetooth_main_view_signals[BLUETOOTH_MAIN_VIEW_NUM_SIGNALS] = {0};

struct _BluetoothMainViewPrivate {
	GtkSortListModel* nearby_model;
	GtkSortListModel* paired_model;
	GListStore* device_model;
	GtkSpinner* discovery_spinner;
	BluetoothServicesObjectManager* manager;
};

static gint BluetoothMainView_private_offset;
static gpointer bluetooth_main_view_parent_class = NULL;

static void bluetooth_main_view_complete_setup (BluetoothMainView* self);
static void bluetooth_main_view_on_device_added (BluetoothMainView* self,
                                          BluetoothServicesDevice* device);
static void bluetooth_main_view_update_description (BluetoothMainView* self);
static void _bluetooth_main_view_on_device_added_bluetooth_services_object_manager_device_added (BluetoothServicesObjectManager* _sender,
                                                                                          BluetoothServicesDevice* device,
                                                                                          gpointer self);
static void bluetooth_main_view_on_device_removed (BluetoothMainView* self,
                                            BluetoothServicesDevice* device);
static void _bluetooth_main_view_on_device_removed_bluetooth_services_object_manager_device_removed (BluetoothServicesObjectManager* _sender,
                                                                                              BluetoothServicesDevice* device,
                                                                                              gpointer self);
static void __lambda25_ (BluetoothMainView* self,
                  BluetoothServicesAdapter* adapter);
static void ___lambda25__bluetooth_services_object_manager_adapter_added (BluetoothServicesObjectManager* _sender,
                                                                   BluetoothServicesAdapter* adapter,
                                                                   gpointer self);
static void __lambda26_ (BluetoothMainView* self,
                  BluetoothServicesAdapter* adapter);
static void ___lambda26__bluetooth_services_object_manager_adapter_removed (BluetoothServicesObjectManager* _sender,
                                                                     BluetoothServicesAdapter* adapter,
                                                                     gpointer self);
static void __lambda27_ (BluetoothMainView* self);
static void ___lambda27__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda28_ (BluetoothMainView* self);
static void ___lambda28__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void bluetooth_main_view_on_device_changed (BluetoothMainView* self,
                                            GVariant* changed,
                                            gchar** invalidated,
                                            gint invalidated_length1);
static void _bluetooth_main_view_on_device_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                               GVariant* changed_properties,
                                                                               gchar** invalidated_properties,
                                                                               gpointer self);
static GtkWidget* bluetooth_main_view_create_widget_func (BluetoothMainView* self,
                                                   GObject* obj);
static GObject * bluetooth_main_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static gboolean _bluetooth_main_view___lambda33_ (BluetoothMainView* self,
                                           GObject* obj);
static gboolean __bluetooth_main_view___lambda33__gtk_custom_filter_func (GObject* item,
                                                                   gpointer self);
static gboolean _bluetooth_main_view___lambda34_ (BluetoothMainView* self,
                                           GObject* obj);
static gboolean __bluetooth_main_view___lambda34__gtk_custom_filter_func (GObject* item,
                                                                   gpointer self);
static GtkWidget* _bluetooth_main_view_create_widget_func_gtk_list_box_create_widget_func (GObject* item,
                                                                                    gpointer self);
static void _bluetooth_main_view_complete_setup_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _bluetooth_main_view___lambda35_ (BluetoothMainView* self,
                                       GtkListBoxRow* row);
static void __bluetooth_main_view___lambda35__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self);
static void _bluetooth_main_view___lambda36_ (BluetoothMainView* self);
static void __bluetooth_main_view___lambda36__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void bluetooth_main_view_finalize (GObject * obj);
static GType bluetooth_main_view_get_type_once (void);
static gssize _vala_array_length (gpointer array);

static inline gpointer
bluetooth_main_view_get_instance_private (BluetoothMainView* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothMainView_private_offset);
}

BluetoothMainView*
bluetooth_main_view_construct (GType object_type)
{
	BluetoothMainView * self = NULL;
	self = (BluetoothMainView*) g_object_new (object_type, "title", _ ("Bluetooth"), "activatable", TRUE, NULL);
	return self;
}

BluetoothMainView*
bluetooth_main_view_new (void)
{
	return bluetooth_main_view_construct (BLUETOOTH_TYPE_MAIN_VIEW);
}

static void
_bluetooth_main_view_on_device_added_bluetooth_services_object_manager_device_added (BluetoothServicesObjectManager* _sender,
                                                                                     BluetoothServicesDevice* device,
                                                                                     gpointer self)
{
	bluetooth_main_view_on_device_added ((BluetoothMainView*) self, device);
}

static void
_bluetooth_main_view_on_device_removed_bluetooth_services_object_manager_device_removed (BluetoothServicesObjectManager* _sender,
                                                                                         BluetoothServicesDevice* device,
                                                                                         gpointer self)
{
	bluetooth_main_view_on_device_removed ((BluetoothMainView*) self, device);
}

static void
__lambda25_ (BluetoothMainView* self,
             BluetoothServicesAdapter* adapter)
{
	g_return_if_fail (adapter != NULL);
	bluetooth_main_view_update_description (self);
}

static void
___lambda25__bluetooth_services_object_manager_adapter_added (BluetoothServicesObjectManager* _sender,
                                                              BluetoothServicesAdapter* adapter,
                                                              gpointer self)
{
	__lambda25_ ((BluetoothMainView*) self, adapter);
}

static void
__lambda26_ (BluetoothMainView* self,
             BluetoothServicesAdapter* adapter)
{
	BluetoothServicesObjectManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (adapter != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = bluetooth_services_object_manager_get_has_object (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		g_signal_emit (self, bluetooth_main_view_signals[BLUETOOTH_MAIN_VIEW_QUIT_PLUG_SIGNAL], 0);
	} else {
		bluetooth_main_view_update_description (self);
	}
}

static void
___lambda26__bluetooth_services_object_manager_adapter_removed (BluetoothServicesObjectManager* _sender,
                                                                BluetoothServicesAdapter* adapter,
                                                                gpointer self)
{
	__lambda26_ ((BluetoothMainView*) self, adapter);
}

static void
__lambda27_ (BluetoothMainView* self)
{
	bluetooth_main_view_update_description (self);
}

static void
___lambda27__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda27_ ((BluetoothMainView*) self);
}

static void
__lambda28_ (BluetoothMainView* self)
{
	bluetooth_main_view_update_description (self);
}

static void
___lambda28__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda28_ ((BluetoothMainView*) self);
}

static void
bluetooth_main_view_complete_setup (BluetoothMainView* self)
{
	GtkSwitch* _tmp9_;
	GtkSwitch* _tmp10_;
	BluetoothServicesObjectManager* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	BluetoothServicesObjectManager* _tmp14_;
	BluetoothServicesObjectManager* _tmp15_;
	BluetoothServicesObjectManager* _tmp16_;
	BluetoothServicesObjectManager* _tmp17_;
	BluetoothServicesObjectManager* _tmp18_;
	BluetoothServicesObjectManager* _tmp19_;
	BluetoothServicesObjectManager* _tmp20_;
	GtkSpinner* _tmp21_;
	BluetoothServicesObjectManager* _tmp22_;
	GtkSwitch* _tmp23_;
	GtkSwitch* _tmp24_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _device_it = NULL;
		BluetoothServicesObjectManager* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->manager;
		_tmp1_ = bluetooth_services_object_manager_get_devices (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_device_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			BluetoothServicesDevice* device = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			BluetoothServicesDevice* _tmp8_;
			_tmp5_ = _device_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _device_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			device = (BluetoothServicesDevice*) _tmp7_;
			_tmp8_ = device;
			bluetooth_main_view_on_device_added (self, _tmp8_);
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
	bluetooth_main_view_update_description (self);
	_tmp9_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->manager;
	_tmp12_ = bluetooth_services_object_manager_get_is_powered (_tmp11_);
	_tmp13_ = _tmp12_;
	gtk_switch_set_active (_tmp10_, _tmp13_);
	_tmp14_ = self->priv->manager;
	g_signal_connect_object (_tmp14_, "device-added", (GCallback) _bluetooth_main_view_on_device_added_bluetooth_services_object_manager_device_added, self, 0);
	_tmp15_ = self->priv->manager;
	g_signal_connect_object (_tmp15_, "device-removed", (GCallback) _bluetooth_main_view_on_device_removed_bluetooth_services_object_manager_device_removed, self, G_CONNECT_AFTER);
	_tmp16_ = self->priv->manager;
	g_signal_connect_object (_tmp16_, "adapter-added", (GCallback) ___lambda25__bluetooth_services_object_manager_adapter_added, self, 0);
	_tmp17_ = self->priv->manager;
	g_signal_connect_object (_tmp17_, "adapter-removed", (GCallback) ___lambda26__bluetooth_services_object_manager_adapter_removed, self, 0);
	_tmp18_ = self->priv->manager;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::discoverable", (GCallback) ___lambda27__g_object_notify, self, 0);
	_tmp19_ = self->priv->manager;
	g_signal_connect_object ((GObject*) _tmp19_, "notify::is-powered", (GCallback) ___lambda28__g_object_notify, self, 0);
	_tmp20_ = self->priv->manager;
	_tmp21_ = self->priv->discovery_spinner;
	g_object_bind_property_with_closures ((GObject*) _tmp20_, "is-discovering", (GObject*) _tmp21_, "spinning", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp22_ = self->priv->manager;
	_tmp23_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp24_ = _tmp23_;
	g_object_bind_property_with_closures ((GObject*) _tmp22_, "is-powered", (GObject*) _tmp24_, "active", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
}

static void
_bluetooth_main_view_on_device_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                          GVariant* changed_properties,
                                                                          gchar** invalidated_properties,
                                                                          gpointer self)
{
	bluetooth_main_view_on_device_changed ((BluetoothMainView*) self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}

static void
bluetooth_main_view_on_device_added (BluetoothMainView* self,
                                     BluetoothServicesDevice* device)
{
	guint pos = 0U;
	GListStore* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	GListStore* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	pos = (guint) -1;
	_tmp0_ = self->priv->device_model;
	_tmp2_ = g_list_store_find (_tmp0_, (GObject*) device, &_tmp1_);
	pos = _tmp1_;
	if (_tmp2_) {
		return;
	}
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (device, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _bluetooth_main_view_on_device_changed_g_dbus_proxy_g_properties_changed, self, 0);
	_tmp3_ = self->priv->device_model;
	g_list_store_append (_tmp3_, (GObject*) device);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bluetooth_main_view_on_device_changed (BluetoothMainView* self,
                                       GVariant* changed,
                                       gchar** invalidated,
                                       gint invalidated_length1)
{
	GVariant* paired = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* connected = NULL;
	GVariantType* _tmp22_;
	GVariantType* _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariant* name = NULL;
	GVariantType* _tmp30_;
	GVariantType* _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("b");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "Paired", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	paired = _tmp3_;
	_tmp4_ = paired;
	if (_tmp4_ != NULL) {
		GtkFilter* nearby_filter = NULL;
		GtkSortListModel* _tmp5_;
		GListModel* _tmp6_;
		GListModel* _tmp7_;
		GtkFilter* _tmp8_;
		GtkFilter* _tmp9_;
		GtkFilter* _tmp10_;
		GtkFilter* paired_filter = NULL;
		GtkSortListModel* _tmp11_;
		GListModel* _tmp12_;
		GListModel* _tmp13_;
		GtkFilter* _tmp14_;
		GtkFilter* _tmp15_;
		GtkFilter* _tmp16_;
		GVariant* _tmp17_;
		_tmp5_ = self->priv->nearby_model;
		_tmp6_ = gtk_sort_list_model_get_model (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gtk_filter_list_model_get_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_filter_list_model_get_type (), GtkFilterListModel));
		_tmp9_ = _tmp8_;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		nearby_filter = _tmp10_;
		_tmp11_ = self->priv->paired_model;
		_tmp12_ = gtk_sort_list_model_get_model (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gtk_filter_list_model_get_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_filter_list_model_get_type (), GtkFilterListModel));
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		paired_filter = _tmp16_;
		_tmp17_ = paired;
		if (g_variant_get_boolean (_tmp17_)) {
			GtkFilter* _tmp18_;
			GtkFilter* _tmp19_;
			_tmp18_ = nearby_filter;
			gtk_filter_changed (_tmp18_, GTK_FILTER_CHANGE_MORE_STRICT);
			_tmp19_ = paired_filter;
			gtk_filter_changed (_tmp19_, GTK_FILTER_CHANGE_LESS_STRICT);
		} else {
			GtkFilter* _tmp20_;
			GtkFilter* _tmp21_;
			_tmp20_ = nearby_filter;
			gtk_filter_changed (_tmp20_, GTK_FILTER_CHANGE_LESS_STRICT);
			_tmp21_ = paired_filter;
			gtk_filter_changed (_tmp21_, GTK_FILTER_CHANGE_MORE_STRICT);
		}
		_g_object_unref0 (paired_filter);
		_g_object_unref0 (nearby_filter);
		_g_variant_unref0 (paired);
		return;
	}
	_tmp22_ = g_variant_type_new ("b");
	_tmp23_ = _tmp22_;
	_tmp24_ = g_variant_lookup_value (changed, "Connected", _tmp23_);
	_tmp25_ = _tmp24_;
	_g_variant_type_free0 (_tmp23_);
	connected = _tmp25_;
	_tmp26_ = connected;
	if (_tmp26_ != NULL) {
		GtkSortListModel* _tmp27_;
		GtkSorter* _tmp28_;
		GtkSorter* _tmp29_;
		_tmp27_ = self->priv->paired_model;
		_tmp28_ = gtk_sort_list_model_get_sorter (_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_sorter_changed (_tmp29_, GTK_SORTER_CHANGE_DIFFERENT);
		_g_variant_unref0 (connected);
		_g_variant_unref0 (paired);
		return;
	}
	_tmp30_ = g_variant_type_new ("s");
	_tmp31_ = _tmp30_;
	_tmp32_ = g_variant_lookup_value (changed, "Name", _tmp31_);
	_tmp33_ = _tmp32_;
	_g_variant_type_free0 (_tmp31_);
	name = _tmp33_;
	_tmp34_ = name;
	if (_tmp34_ != NULL) {
		GtkSortListModel* _tmp35_;
		GtkSorter* _tmp36_;
		GtkSorter* _tmp37_;
		_tmp35_ = self->priv->paired_model;
		_tmp36_ = gtk_sort_list_model_get_sorter (_tmp35_);
		_tmp37_ = _tmp36_;
		gtk_sorter_changed (_tmp37_, GTK_SORTER_CHANGE_DIFFERENT);
	}
	_g_variant_unref0 (name);
	_g_variant_unref0 (connected);
	_g_variant_unref0 (paired);
}

static void
bluetooth_main_view_on_device_removed (BluetoothMainView* self,
                                       BluetoothServicesDevice* device)
{
	guint pos = 0U;
	GListStore* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	guint _tmp3_;
	GListStore* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	pos = (guint) -1;
	_tmp0_ = self->priv->device_model;
	_tmp2_ = g_list_store_find (_tmp0_, (GObject*) device, &_tmp1_);
	pos = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	g_signal_parse_name ("g-properties-changed", g_dbus_proxy_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (device, g_dbus_proxy_get_type (), GDBusProxy), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _bluetooth_main_view_on_device_changed_g_dbus_proxy_g_properties_changed, self);
	_tmp4_ = self->priv->device_model;
	g_list_store_remove (_tmp4_, pos);
}

static void
bluetooth_main_view_update_description (BluetoothMainView* self)
{
	gchar* name = NULL;
	BluetoothServicesObjectManager* _tmp0_;
	gchar* _tmp1_;
	gboolean powered = FALSE;
	BluetoothServicesObjectManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = bluetooth_services_object_manager_get_name (_tmp0_);
	name = _tmp1_;
	_tmp2_ = self->priv->manager;
	_tmp3_ = bluetooth_services_object_manager_get_is_powered (_tmp2_);
	_tmp4_ = _tmp3_;
	powered = _tmp4_;
	if (powered) {
		BluetoothServicesObjectManager* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->manager;
		_tmp7_ = bluetooth_services_object_manager_get_discoverable (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = name;
		_tmp9_ = _tmp10_;
		if (_tmp9_ == NULL) {
			_tmp9_ = _ ("Unknown");
		}
		_tmp11_ = g_strdup_printf (_ ("Now discoverable as \"%s\". Not discoverable when this page is closed"), _tmp9_);
		_tmp12_ = _tmp11_;
		switchboard_settings_page_set_description ((SwitchboardSettingsPage*) self, _tmp12_);
		_g_free0 (_tmp12_);
	} else {
		if (!powered) {
			switchboard_settings_page_set_description ((SwitchboardSettingsPage*) self, _ ("Not discoverable while Bluetooth is powered off"));
		} else {
			switchboard_settings_page_set_description ((SwitchboardSettingsPage*) self, _ ("Not discoverable"));
		}
	}
	if (powered) {
		GThemedIcon* _tmp13_;
		GThemedIcon* _tmp14_;
		_tmp13_ = (GThemedIcon*) g_themed_icon_new ("bluetooth");
		_tmp14_ = _tmp13_;
		switchboard_settings_page_set_icon ((SwitchboardSettingsPage*) self, (GIcon*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	} else {
		GThemedIcon* _tmp15_;
		GThemedIcon* _tmp16_;
		_tmp15_ = (GThemedIcon*) g_themed_icon_new ("bluetooth-disabled");
		_tmp16_ = _tmp15_;
		switchboard_settings_page_set_icon ((SwitchboardSettingsPage*) self, (GIcon*) _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	_g_free0 (name);
}

static GtkWidget*
bluetooth_main_view_create_widget_func (BluetoothMainView* self,
                                        GObject* obj)
{
	BluetoothDeviceRow* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (obj != NULL, NULL);
	_tmp0_ = bluetooth_device_row_new (G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_SERVICES_TYPE_DEVICE, BluetoothServicesDevice));
	g_object_ref_sink (_tmp0_);
	result = (GtkWidget*) _tmp0_;
	return result;
}

static gboolean
_bluetooth_main_view___lambda33_ (BluetoothMainView* self,
                                  GObject* obj)
{
	BluetoothServicesDevice* device = NULL;
	BluetoothServicesDevice* _tmp0_;
	BluetoothServicesDevice* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (obj != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_SERVICES_TYPE_DEVICE, BluetoothServicesDevice));
	device = _tmp0_;
	_tmp1_ = device;
	_tmp2_ = bluetooth_services_device_get_paired (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	_g_object_unref0 (device);
	return result;
}

static gboolean
__bluetooth_main_view___lambda33__gtk_custom_filter_func (GObject* item,
                                                          gpointer self)
{
	gboolean result;
	result = _bluetooth_main_view___lambda33_ ((BluetoothMainView*) self, item);
	return result;
}

static gboolean
_bluetooth_main_view___lambda34_ (BluetoothMainView* self,
                                  GObject* obj)
{
	BluetoothServicesDevice* device = NULL;
	BluetoothServicesDevice* _tmp0_;
	gboolean _tmp1_ = FALSE;
	BluetoothServicesDevice* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	BluetoothServicesDevice* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean result;
	g_return_val_if_fail (obj != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_SERVICES_TYPE_DEVICE, BluetoothServicesDevice));
	device = _tmp0_;
	_tmp2_ = device;
	_tmp3_ = bluetooth_services_device_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ == NULL;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		BluetoothServicesDevice* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = device;
		_tmp8_ = bluetooth_services_device_get_icon (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp1_ = _tmp10_ == NULL;
		_g_free0 (_tmp10_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_object_unref0 (device);
		return result;
	}
	_tmp11_ = device;
	_tmp12_ = bluetooth_services_device_get_paired (_tmp11_);
	_tmp13_ = _tmp12_;
	result = !_tmp13_;
	_g_object_unref0 (device);
	return result;
}

static gboolean
__bluetooth_main_view___lambda34__gtk_custom_filter_func (GObject* item,
                                                          gpointer self)
{
	gboolean result;
	result = _bluetooth_main_view___lambda34_ ((BluetoothMainView*) self, item);
	return result;
}

static GtkWidget*
_bluetooth_main_view_create_widget_func_gtk_list_box_create_widget_func (GObject* item,
                                                                         gpointer self)
{
	GtkWidget* result;
	result = bluetooth_main_view_create_widget_func ((BluetoothMainView*) self, item);
	return result;
}

static void
_bluetooth_main_view_complete_setup_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	bluetooth_main_view_complete_setup ((BluetoothMainView*) self);
}

static void
_bluetooth_main_view___lambda35_ (BluetoothMainView* self,
                                  GtkListBoxRow* row)
{
	g_return_if_fail (row != NULL);
	bluetooth_device_row_on_activate (G_TYPE_CHECK_INSTANCE_CAST (row, BLUETOOTH_TYPE_DEVICE_ROW, BluetoothDeviceRow), NULL, NULL);
}

static void
__bluetooth_main_view___lambda35__gtk_list_box_row_activated (GtkListBox* _sender,
                                                              GtkListBoxRow* row,
                                                              gpointer self)
{
	_bluetooth_main_view___lambda35_ ((BluetoothMainView*) self, row);
}

static void
_bluetooth_main_view___lambda36_ (BluetoothMainView* self)
{
	BluetoothServicesObjectManager* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	_tmp0_ = self->priv->manager;
	_tmp1_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_switch_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	bluetooth_services_object_manager_set_global_state (_tmp0_, _tmp4_, NULL, NULL);
}

static void
__bluetooth_main_view___lambda36__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_bluetooth_main_view___lambda36_ ((BluetoothMainView*) self);
}

static GObject *
bluetooth_main_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothMainView * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	GListModel* _tmp2_;
	GtkCustomFilter* _tmp3_;
	GtkFilterListModel* _tmp4_;
	GtkCustomSorter* _tmp5_;
	GtkSortListModel* _tmp6_;
	GListStore* _tmp7_;
	GListModel* _tmp8_;
	GtkCustomFilter* _tmp9_;
	GtkFilterListModel* _tmp10_;
	GtkCustomSorter* _tmp11_;
	GtkSortListModel* _tmp12_;
	GranitePlaceholder* paired_placeholder = NULL;
	gchar* _tmp13_;
	GranitePlaceholder* _tmp14_ = NULL;
	GtkListBox* paired_list = NULL;
	GtkListBox* _tmp15_ = NULL;
	GtkListBox* _tmp16_;
	GtkListBox* _tmp17_;
	GtkListBox* _tmp18_;
	GtkListBox* _tmp19_;
	GtkSortListModel* _tmp20_;
	GtkListBox* _tmp21_;
	GranitePlaceholder* _tmp22_;
	GranitePlaceholder* empty_alert = NULL;
	gchar* _tmp23_;
	GranitePlaceholder* _tmp24_ = NULL;
	GtkListBox* list_box = NULL;
	GtkListBox* _tmp25_ = NULL;
	GtkListBox* _tmp26_;
	GtkListBox* _tmp27_;
	GtkListBox* _tmp28_;
	GtkListBox* _tmp29_;
	GtkSortListModel* _tmp30_;
	GtkListBox* _tmp31_;
	GranitePlaceholder* _tmp32_;
	GraniteHeaderLabel* paired_header = NULL;
	GtkListBox* _tmp33_;
	GtkWidget* _tmp34_;
	GraniteHeaderLabel* _tmp35_ = NULL;
	GraniteHeaderLabel* nearby_header = NULL;
	GtkListBox* _tmp36_;
	GtkWidget* _tmp37_;
	GraniteHeaderLabel* _tmp38_ = NULL;
	GtkSpinner* _tmp39_;
	GtkBox* nearby_box = NULL;
	GtkBox* _tmp40_ = NULL;
	GtkBox* _tmp41_;
	GraniteHeaderLabel* _tmp42_;
	GtkBox* _tmp43_;
	GtkSpinner* _tmp44_;
	GtkBox* box = NULL;
	GtkBox* _tmp45_;
	GtkBox* _tmp46_;
	GraniteHeaderLabel* _tmp47_;
	GtkBox* _tmp48_;
	GtkListBox* _tmp49_;
	GtkBox* _tmp50_;
	GtkBox* _tmp51_;
	GtkBox* _tmp52_;
	GtkListBox* _tmp53_;
	GtkBox* _tmp54_;
	BluetoothServicesObjectManager* _tmp55_;
	BluetoothServicesObjectManager* _tmp56_;
	BluetoothServicesObjectManager* _tmp57_;
	gboolean _tmp58_;
	gboolean _tmp59_;
	GtkListBox* _tmp61_;
	GtkSwitch* _tmp62_;
	GtkSwitch* _tmp63_;
	parent_class = G_OBJECT_CLASS (bluetooth_main_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_TYPE_MAIN_VIEW, BluetoothMainView);
	_tmp0_ = g_list_store_new (BLUETOOTH_SERVICES_TYPE_DEVICE);
	_g_object_unref0 (self->priv->device_model);
	self->priv->device_model = _tmp0_;
	_tmp1_ = self->priv->device_model;
	_tmp2_ = _g_object_ref0 ((GListModel*) _tmp1_);
	_tmp3_ = gtk_custom_filter_new (__bluetooth_main_view___lambda33__gtk_custom_filter_func, g_object_ref (self), g_object_unref);
	_tmp4_ = gtk_filter_list_model_new (_tmp2_, (GtkFilter*) _tmp3_);
	_tmp5_ = gtk_custom_sorter_new ((GCompareDataFunc) bluetooth_services_device_compare, NULL, NULL);
	_tmp6_ = gtk_sort_list_model_new ((GListModel*) _tmp4_, (GtkSorter*) _tmp5_);
	_g_object_unref0 (self->priv->paired_model);
	self->priv->paired_model = _tmp6_;
	_tmp7_ = self->priv->device_model;
	_tmp8_ = _g_object_ref0 ((GListModel*) _tmp7_);
	_tmp9_ = gtk_custom_filter_new (__bluetooth_main_view___lambda34__gtk_custom_filter_func, g_object_ref (self), g_object_unref);
	_tmp10_ = gtk_filter_list_model_new (_tmp8_, (GtkFilter*) _tmp9_);
	_tmp11_ = gtk_custom_sorter_new ((GCompareDataFunc) bluetooth_services_device_compare, NULL, NULL);
	_tmp12_ = gtk_sort_list_model_new ((GListModel*) _tmp10_, (GtkSorter*) _tmp11_);
	_g_object_unref0 (self->priv->nearby_model);
	self->priv->nearby_model = _tmp12_;
	_tmp13_ = g_strdup (_ ("Bluetooth devices will appear here when paired with this device."));
	_tmp14_ = granite_placeholder_new (_ ("No Paired Devices"));
	granite_placeholder_set_description (_tmp14_, _tmp13_);
	_g_free0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	paired_placeholder = _tmp14_;
	_tmp15_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp15_, FALSE);
	gtk_widget_set_overflow ((GtkWidget*) _tmp15_, GTK_OVERFLOW_HIDDEN);
	gtk_list_box_set_selection_mode (_tmp15_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp15_);
	paired_list = _tmp15_;
	_tmp16_ = paired_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp16_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp17_ = paired_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp17_, GRANITE_STYLE_CLASS_CARD);
	_tmp18_ = paired_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp18_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp19_ = paired_list;
	_tmp20_ = self->priv->paired_model;
	gtk_list_box_bind_model (_tmp19_, (GListModel*) _tmp20_, _bluetooth_main_view_create_widget_func_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp21_ = paired_list;
	_tmp22_ = paired_placeholder;
	gtk_list_box_set_placeholder (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = g_strdup (_ ("Please ensure that your devices are visible and ready for pairing."));
	_tmp24_ = granite_placeholder_new (_ ("No Devices Found"));
	granite_placeholder_set_description (_tmp24_, _tmp23_);
	_g_free0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	empty_alert = _tmp24_;
	_tmp25_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp25_, FALSE);
	gtk_widget_set_overflow ((GtkWidget*) _tmp25_, GTK_OVERFLOW_HIDDEN);
	gtk_list_box_set_selection_mode (_tmp25_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp25_);
	list_box = _tmp25_;
	_tmp26_ = list_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp26_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp27_ = list_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp27_, GRANITE_STYLE_CLASS_CARD);
	_tmp28_ = list_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp28_, GRANITE_STYLE_CLASS_ROUNDED);
	_tmp29_ = list_box;
	_tmp30_ = self->priv->nearby_model;
	gtk_list_box_bind_model (_tmp29_, (GListModel*) _tmp30_, _bluetooth_main_view_create_widget_func_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp31_ = list_box;
	_tmp32_ = empty_alert;
	gtk_list_box_set_placeholder (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = paired_list;
	_tmp34_ = _g_object_ref0 ((GtkWidget*) _tmp33_);
	_tmp35_ = granite_header_label_new (_ ("Paired Devices"));
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp35_, 6);
	granite_header_label_set_mnemonic_widget (_tmp35_, _tmp34_);
	_g_object_unref0 (_tmp34_);
	g_object_ref_sink (_tmp35_);
	paired_header = _tmp35_;
	_tmp36_ = list_box;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	_tmp38_ = granite_header_label_new (_ ("Nearby Devices"));
	granite_header_label_set_mnemonic_widget (_tmp38_, _tmp37_);
	_g_object_unref0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	nearby_header = _tmp38_;
	_tmp39_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->discovery_spinner);
	self->priv->discovery_spinner = _tmp39_;
	_tmp40_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp40_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp40_, 6);
	g_object_ref_sink (_tmp40_);
	nearby_box = _tmp40_;
	_tmp41_ = nearby_box;
	_tmp42_ = nearby_header;
	gtk_box_append (_tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = nearby_box;
	_tmp44_ = self->priv->discovery_spinner;
	gtk_box_append (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp45_);
	box = _tmp45_;
	_tmp46_ = box;
	_tmp47_ = paired_header;
	gtk_box_append (_tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = box;
	_tmp49_ = paired_list;
	gtk_box_append (_tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = box;
	_tmp51_ = nearby_box;
	gtk_box_append (_tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = box;
	_tmp53_ = list_box;
	gtk_box_append (_tmp52_, (GtkWidget*) _tmp53_);
	_tmp54_ = box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp54_);
	_tmp55_ = bluetooth_services_object_manager_get_default ();
	_tmp56_ = _g_object_ref0 (_tmp55_);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp56_;
	_tmp57_ = self->priv->manager;
	_tmp58_ = bluetooth_services_object_manager_get_retrieve_finished (_tmp57_);
	_tmp59_ = _tmp58_;
	if (_tmp59_) {
		bluetooth_main_view_complete_setup (self);
	} else {
		BluetoothServicesObjectManager* _tmp60_;
		_tmp60_ = self->priv->manager;
		g_signal_connect_object ((GObject*) _tmp60_, "notify::retrieve-finished", (GCallback) _bluetooth_main_view_complete_setup_g_object_notify, self, 0);
	}
	_tmp61_ = list_box;
	g_signal_connect_object (_tmp61_, "row-activated", (GCallback) __bluetooth_main_view___lambda35__gtk_list_box_row_activated, self, 0);
	_tmp62_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp63_ = _tmp62_;
	g_signal_connect_object ((GObject*) _tmp63_, "notify::active", (GCallback) __bluetooth_main_view___lambda36__g_object_notify, self, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (nearby_box);
	_g_object_unref0 (nearby_header);
	_g_object_unref0 (paired_header);
	_g_object_unref0 (list_box);
	_g_object_unref0 (empty_alert);
	_g_object_unref0 (paired_list);
	_g_object_unref0 (paired_placeholder);
	return obj;
}

static void
bluetooth_main_view_class_init (BluetoothMainViewClass * klass,
                                gpointer klass_data)
{
	bluetooth_main_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothMainView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = bluetooth_main_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_main_view_finalize;
	bluetooth_main_view_signals[BLUETOOTH_MAIN_VIEW_QUIT_PLUG_SIGNAL] = g_signal_new ("quit-plug", BLUETOOTH_TYPE_MAIN_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
bluetooth_main_view_instance_init (BluetoothMainView * self,
                                   gpointer klass)
{
	self->priv = bluetooth_main_view_get_instance_private (self);
}

static void
bluetooth_main_view_finalize (GObject * obj)
{
	BluetoothMainView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_TYPE_MAIN_VIEW, BluetoothMainView);
	_g_object_unref0 (self->priv->nearby_model);
	_g_object_unref0 (self->priv->paired_model);
	_g_object_unref0 (self->priv->device_model);
	_g_object_unref0 (self->priv->discovery_spinner);
	_g_object_unref0 (self->priv->manager);
	G_OBJECT_CLASS (bluetooth_main_view_parent_class)->finalize (obj);
}

static GType
bluetooth_main_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothMainViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_main_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothMainView), 0, (GInstanceInitFunc) bluetooth_main_view_instance_init, NULL };
	GType bluetooth_main_view_type_id;
	bluetooth_main_view_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "BluetoothMainView", &g_define_type_info, 0);
	BluetoothMainView_private_offset = g_type_add_instance_private (bluetooth_main_view_type_id, sizeof (BluetoothMainViewPrivate));
	return bluetooth_main_view_type_id;
}

GType
bluetooth_main_view_get_type (void)
{
	static volatile gsize bluetooth_main_view_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_main_view_type_id__once)) {
		GType bluetooth_main_view_type_id;
		bluetooth_main_view_type_id = bluetooth_main_view_get_type_once ();
		g_once_init_leave (&bluetooth_main_view_type_id__once, bluetooth_main_view_type_id);
	}
	return bluetooth_main_view_type_id__once;
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

