/* Utils.c generated by valac 0.56.18, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
* Copyright (c) 2016-2017 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <json-glib/json-glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_UTILS (spice_utils_get_type ())
#define SPICE_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_UTILS, SpiceUtils))
#define SPICE_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_UTILS, SpiceUtilsClass))
#define SPICE_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_UTILS))
#define SPICE_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_UTILS))
#define SPICE_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_UTILS, SpiceUtilsClass))

typedef struct _SpiceUtils SpiceUtils;
typedef struct _SpiceUtilsClass SpiceUtilsClass;
typedef struct _SpiceUtilsPrivate SpiceUtilsPrivate;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define SPICE_TYPE_CANVAS (spice_canvas_get_type ())
#define SPICE_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS, SpiceCanvas))
#define SPICE_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS, SpiceCanvasClass))
#define SPICE_IS_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS))
#define SPICE_IS_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS))
#define SPICE_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS, SpiceCanvasClass))

typedef struct _SpiceCanvas SpiceCanvas;
typedef struct _SpiceCanvasClass SpiceCanvasClass;

#define SPICE_TYPE_CANVAS_ITEM (spice_canvas_item_get_type ())
#define SPICE_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItem))
#define SPICE_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))
#define SPICE_IS_CANVAS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_IS_CANVAS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_CANVAS_ITEM))
#define SPICE_CANVAS_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_CANVAS_ITEM, SpiceCanvasItemClass))

typedef struct _SpiceCanvasItem SpiceCanvasItem;
typedef struct _SpiceCanvasItemClass SpiceCanvasItemClass;

#define SPICE_TYPE_TEXT_ITEM (spice_text_item_get_type ())
#define SPICE_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_TEXT_ITEM, SpiceTextItem))
#define SPICE_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_TEXT_ITEM, SpiceTextItemClass))
#define SPICE_IS_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_TEXT_ITEM))
#define SPICE_IS_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_TEXT_ITEM))
#define SPICE_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_TEXT_ITEM, SpiceTextItemClass))

typedef struct _SpiceTextItem SpiceTextItem;
typedef struct _SpiceTextItemClass SpiceTextItemClass;

#define SPICE_TYPE_COLOR_ITEM (spice_color_item_get_type ())
#define SPICE_COLOR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_COLOR_ITEM, SpiceColorItem))
#define SPICE_COLOR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_COLOR_ITEM, SpiceColorItemClass))
#define SPICE_IS_COLOR_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_COLOR_ITEM))
#define SPICE_IS_COLOR_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_COLOR_ITEM))
#define SPICE_COLOR_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_COLOR_ITEM, SpiceColorItemClass))

typedef struct _SpiceColorItem SpiceColorItem;
typedef struct _SpiceColorItemClass SpiceColorItemClass;

#define SPICE_TYPE_IMAGE_ITEM (spice_image_item_get_type ())
#define SPICE_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItem))
#define SPICE_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))
#define SPICE_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_IMAGE_ITEM))
#define SPICE_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_IMAGE_ITEM, SpiceImageItemClass))

typedef struct _SpiceImageItem SpiceImageItem;
typedef struct _SpiceImageItemClass SpiceImageItemClass;

#define SPICE_TYPE_SLIDE_MANAGER (spice_slide_manager_get_type ())
#define SPICE_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager))
#define SPICE_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))
#define SPICE_IS_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_IS_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_SLIDE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))

typedef struct _SpiceSlideManager SpiceSlideManager;
typedef struct _SpiceSlideManagerClass SpiceSlideManagerClass;
typedef struct _SpiceSlideManagerPrivate SpiceSlideManagerPrivate;

#define SPICE_TYPE_SLIDE (spice_slide_get_type ())
#define SPICE_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE, SpiceSlide))
#define SPICE_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE, SpiceSlideClass))
#define SPICE_IS_SLIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE))
#define SPICE_IS_SLIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE))
#define SPICE_SLIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE, SpiceSlideClass))

typedef struct _SpiceSlide SpiceSlide;
typedef struct _SpiceSlideClass SpiceSlideClass;

#define SPICE_TYPE_APPLICATION (spice_application_get_type ())
#define SPICE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_APPLICATION, SpiceApplication))
#define SPICE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_APPLICATION, SpiceApplicationClass))
#define SPICE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_APPLICATION))
#define SPICE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_APPLICATION))
#define SPICE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_APPLICATION, SpiceApplicationClass))

typedef struct _SpiceApplication SpiceApplication;
typedef struct _SpiceApplicationClass SpiceApplicationClass;
typedef struct _SpiceParamSpecUtils SpiceParamSpecUtils;
typedef enum  {
	SPICE_ASPECT_RATIO_ASPECT_4_3 = 1,
	SPICE_ASPECT_RATIO_ASPECT_16_9 = 2,
	SPICE_ASPECT_RATIO_ASPECT_16_10 = 3,
	SPICE_ASPECT_RATIO_ASPECT_3_2 = 4,
	SPICE_ASPECT_RATIO_ASPECT_5_4 = 5
} SpiceAspectRatio;

#define SPICE_TYPE_ASPECT_RATIO (spice_aspect_ratio_get_type ())

struct _SpiceUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SpiceUtilsPrivate * priv;
};

struct _SpiceUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (SpiceUtils *self);
};

struct _Block7Data {
	int _ref_count_;
	GArray* data_raw;
};

struct _SpiceSlideManager {
	GObject parent_instance;
	SpiceSlideManagerPrivate * priv;
	gboolean making_new_slide;
	SpiceSlide* end_presentation_slide;
	SpiceSlide* preview_slide_;
	SpiceSlide* checkpoint;
};

struct _SpiceSlideManagerClass {
	GObjectClass parent_class;
};

struct _SpiceParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer spice_utils_parent_class = NULL;

VALA_EXTERN gpointer spice_utils_ref (gpointer instance);
VALA_EXTERN void spice_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* spice_param_spec_utils (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void spice_value_set_utils (GValue* value,
                            gpointer v_object);
VALA_EXTERN void spice_value_take_utils (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer spice_value_get_utils (const GValue* value);
VALA_EXTERN GType spice_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceUtils, spice_utils_unref)
VALA_EXTERN gchar* spice_utils_get_thumbnail_data (const gchar* raw_json);
VALA_EXTERN JsonObject* spice_utils_get_json_object (const gchar* raw_json);
VALA_EXTERN gint spice_utils_get_aspect_ratio (const gchar* raw_json);
VALA_EXTERN GdkPixbuf* spice_utils_base64_to_pixbuf (const gchar* base64);
VALA_EXTERN gchar* spice_utils_pixbuf_to_base64 (GdkPixbuf* pixbuf);
VALA_EXTERN gchar* spice_utils_surface_to_base64 (cairo_surface_t* surface);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static cairo_status_t __lambda13_ (Block7Data* _data7_,
                            guchar* raw,
                            gint raw_length1);
static cairo_status_t ___lambda13__cairo_write_func_t (gpointer self,
                                                guchar* data,
                                                gint data_length1);
VALA_EXTERN gboolean spice_utils_is_valid_image (GFile* file);
VALA_EXTERN void spice_utils_set_style (GtkWidget* widget,
                            const gchar* css);
VALA_EXTERN void spice_utils_set_cursor (const gchar* cursor_type);
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN SpiceWindow* spice_application_get_active_spice_window (void);
VALA_EXTERN GType spice_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvas, g_object_unref)
VALA_EXTERN GType spice_canvas_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceCanvasItem, g_object_unref)
VALA_EXTERN SpiceCanvasItem* spice_utils_canvas_item_from_data (JsonObject* data,
                                                    SpiceCanvas* canvas);
VALA_EXTERN SpiceTextItem* spice_text_item_new (SpiceCanvas* _canvas,
                                    JsonObject* _save_data);
VALA_EXTERN SpiceTextItem* spice_text_item_construct (GType object_type,
                                          SpiceCanvas* _canvas,
                                          JsonObject* _save_data);
VALA_EXTERN GType spice_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceTextItem, g_object_unref)
VALA_EXTERN SpiceColorItem* spice_color_item_new (SpiceCanvas* _canvas,
                                      JsonObject* _save_data);
VALA_EXTERN SpiceColorItem* spice_color_item_construct (GType object_type,
                                            SpiceCanvas* _canvas,
                                            JsonObject* _save_data);
VALA_EXTERN GType spice_color_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceColorItem, g_object_unref)
VALA_EXTERN SpiceImageItem* spice_image_item_new (SpiceCanvas* _canvas,
                                      JsonObject* _save_data);
VALA_EXTERN SpiceImageItem* spice_image_item_construct (GType object_type,
                                            SpiceCanvas* _canvas,
                                            JsonObject* _save_data);
VALA_EXTERN GType spice_image_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceImageItem, g_object_unref)
VALA_EXTERN GType spice_slide_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideManager, g_object_unref)
VALA_EXTERN void spice_utils_new_slide (SpiceSlideManager* manager);
VALA_EXTERN GType spice_slide_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlide, g_object_unref)
VALA_EXTERN SpiceSlide* spice_slide_manager_new_slide (SpiceSlideManager* self,
                                           JsonObject* save_data,
                                           gboolean undoable_action);
VALA_EXTERN void spice_slide_reload_preview_data (SpiceSlide* self);
VALA_EXTERN void spice_slide_manager_set_current_slide (SpiceSlideManager* self,
                                            SpiceSlide* value);
VALA_EXTERN void spice_utils_set_action_enabled (const gchar* action_name,
                                     GSimpleActionGroup* action_group,
                                     gboolean enabled);
VALA_EXTERN gchar* spice_utils_get_accel_tooltip (const gchar* action_name,
                                      const gchar* description);
VALA_EXTERN GType spice_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceApplication, g_object_unref)
VALA_EXTERN SpiceApplication* spice_application_get_instance (void);
VALA_EXTERN SpiceUtils* spice_utils_new (void);
VALA_EXTERN SpiceUtils* spice_utils_construct (GType object_type);
static void spice_utils_finalize (SpiceUtils * obj);
static GType spice_utils_get_type_once (void);
VALA_EXTERN GType spice_aspect_ratio_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SpiceAspectRatio spice_aspect_ratio_get_mode (gint* value);
VALA_EXTERN gfloat spice_aspect_ratio_get_ratio_value (SpiceAspectRatio value);
VALA_EXTERN gint spice_aspect_ratio_get_width_value (SpiceAspectRatio value);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* SPICE_UTILS_ACCEPTED_TYPES[5] = {"image/jpeg", "image/png", "image/tiff", "image/svg+xml", "image/gif"};

static gpointer
_json_array_ref0 (gpointer self)
{
#line 34 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return self ? json_array_ref (self) : NULL;
#line 317 "Utils.c"
}

gchar*
spice_utils_get_thumbnail_data (const gchar* raw_json)
{
	JsonObject* root_object = NULL;
	JsonObject* _tmp0_;
	JsonArray* slides_array = NULL;
	JsonObject* _tmp1_;
	JsonArray* _tmp2_;
	JsonArray* _tmp3_;
	gint preview_index = 0;
	JsonObject* _tmp4_;
	GList* slides = NULL;
	JsonArray* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	gchar* _tmp16_;
	gchar* result;
#line 32 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (raw_json != NULL, NULL);
#line 33 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = spice_utils_get_json_object (raw_json);
#line 33 "../Spice-up-1.9.1/src/Services/Utils.vala"
	root_object = _tmp0_;
#line 34 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp1_ = root_object;
#line 34 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp2_ = json_object_get_array_member (_tmp1_, "slides");
#line 34 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp3_ = _json_array_ref0 (_tmp2_);
#line 34 "../Spice-up-1.9.1/src/Services/Utils.vala"
	slides_array = _tmp3_;
#line 35 "../Spice-up-1.9.1/src/Services/Utils.vala"
	preview_index = 0;
#line 37 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp4_ = root_object;
#line 37 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (json_object_has_member (_tmp4_, "preview-slide")) {
#line 358 "Utils.c"
		JsonObject* _tmp5_;
#line 38 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp5_ = root_object;
#line 38 "../Spice-up-1.9.1/src/Services/Utils.vala"
		preview_index = (gint) json_object_get_int_member (_tmp5_, "preview-slide");
#line 364 "Utils.c"
	}
#line 41 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp6_ = slides_array;
#line 41 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp7_ = json_array_get_elements (_tmp6_);
#line 41 "../Spice-up-1.9.1/src/Services/Utils.vala"
	slides = _tmp7_;
#line 42 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp8_ = slides;
#line 42 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (((guint) preview_index) > g_list_length (_tmp8_)) {
#line 42 "../Spice-up-1.9.1/src/Services/Utils.vala"
		preview_index = 0;
#line 378 "Utils.c"
	}
#line 44 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp9_ = slides;
#line 44 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (g_list_length (_tmp9_) > ((guint) 0)) {
#line 384 "Utils.c"
		gchar* preview_data = NULL;
		GList* _tmp10_;
		gconstpointer _tmp11_;
		JsonObject* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
#line 46 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp10_ = slides;
#line 46 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp11_ = g_list_nth_data (_tmp10_, (guint) preview_index);
#line 46 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp12_ = json_node_get_object ((JsonNode*) _tmp11_);
#line 46 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp13_ = json_object_get_string_member (_tmp12_, "preview");
#line 46 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 46 "../Spice-up-1.9.1/src/Services/Utils.vala"
		preview_data = _tmp14_;
#line 48 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp15_ = preview_data;
#line 48 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (_tmp15_ != NULL) {
#line 49 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = preview_data;
#line 49 "../Spice-up-1.9.1/src/Services/Utils.vala"
			(slides == NULL) ? NULL : (slides = (g_list_free (slides), NULL));
#line 49 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_json_array_unref0 (slides_array);
#line 49 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_json_object_unref0 (root_object);
#line 49 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 418 "Utils.c"
		}
#line 44 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_free0 (preview_data);
#line 422 "Utils.c"
	}
#line 53 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp16_ = g_strdup ("");
#line 53 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = _tmp16_;
#line 53 "../Spice-up-1.9.1/src/Services/Utils.vala"
	(slides == NULL) ? NULL : (slides = (g_list_free (slides), NULL));
#line 53 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_json_array_unref0 (slides_array);
#line 53 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_json_object_unref0 (root_object);
#line 53 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 436 "Utils.c"
}

gint
spice_utils_get_aspect_ratio (const gchar* raw_json)
{
	JsonObject* root_object = NULL;
	JsonObject* _tmp0_;
	gint result;
#line 56 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (raw_json != NULL, 0);
#line 57 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = spice_utils_get_json_object (raw_json);
#line 57 "../Spice-up-1.9.1/src/Services/Utils.vala"
	root_object = _tmp0_;
#line 58 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = (gint) json_object_get_int_member (root_object, "aspect-ratio");
#line 58 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_json_object_unref0 (root_object);
#line 58 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 457 "Utils.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 66 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return self ? json_object_ref (self) : NULL;
#line 465 "Utils.c"
}

JsonObject*
spice_utils_get_json_object (const gchar* raw_json)
{
	GError* _inner_error0_ = NULL;
	JsonObject* result;
#line 61 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (raw_json != NULL, NULL);
#line 475 "Utils.c"
	{
		JsonParser* parser = NULL;
		JsonParser* _tmp0_;
		JsonObject* root_object = NULL;
		JsonNode* _tmp1_;
		JsonObject* _tmp2_;
		JsonObject* _tmp3_;
#line 63 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp0_ = json_parser_new ();
#line 63 "../Spice-up-1.9.1/src/Services/Utils.vala"
		parser = _tmp0_;
#line 64 "../Spice-up-1.9.1/src/Services/Utils.vala"
		json_parser_load_from_data (parser, raw_json, (gssize) -1, &_inner_error0_);
#line 64 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 64 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_object_unref0 (parser);
#line 493 "Utils.c"
			goto __catch0_g_error;
		}
#line 66 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp1_ = json_parser_get_root (parser);
#line 66 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp2_ = json_node_get_object (_tmp1_);
#line 66 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp3_ = _json_object_ref0 (_tmp2_);
#line 66 "../Spice-up-1.9.1/src/Services/Utils.vala"
		root_object = _tmp3_;
#line 68 "../Spice-up-1.9.1/src/Services/Utils.vala"
		result = root_object;
#line 68 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_object_unref0 (parser);
#line 68 "../Spice-up-1.9.1/src/Services/Utils.vala"
		return result;
#line 510 "Utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 62 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 70 "../Spice-up-1.9.1/src/Services/Utils.vala"
		result = NULL;
#line 70 "../Spice-up-1.9.1/src/Services/Utils.vala"
		return result;
#line 521 "Utils.c"
	}
	__finally0:
#line 62 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 62 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_clear_error (&_inner_error0_);
#line 62 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return NULL;
#line 530 "Utils.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 85 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 538 "Utils.c"
}

GdkPixbuf*
spice_utils_base64_to_pixbuf (const gchar* base64)
{
	guchar* raw_data = NULL;
	gsize _tmp0_ = 0;
	guchar* _tmp1_;
	gint raw_data_length1;
	gint _raw_data_size_;
	GdkPixbufLoader* loader = NULL;
	GdkPixbufLoader* _tmp2_;
	GdkPixbufLoader* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
#line 74 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (base64 != NULL, NULL);
#line 75 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp1_ = g_base64_decode (base64, &_tmp0_);
#line 75 "../Spice-up-1.9.1/src/Services/Utils.vala"
	raw_data = _tmp1_;
#line 75 "../Spice-up-1.9.1/src/Services/Utils.vala"
	raw_data_length1 = _tmp0_;
#line 75 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_raw_data_size_ = raw_data_length1;
#line 76 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp2_ = gdk_pixbuf_loader_new ();
#line 76 "../Spice-up-1.9.1/src/Services/Utils.vala"
	loader = _tmp2_;
#line 570 "Utils.c"
	{
		GdkPixbufLoader* _tmp3_;
		guchar* _tmp4_;
		gint _tmp4__length1;
		GdkPixbufLoader* _tmp5_;
#line 79 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp3_ = loader;
#line 79 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp4_ = raw_data;
#line 79 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp4__length1 = raw_data_length1;
#line 79 "../Spice-up-1.9.1/src/Services/Utils.vala"
		gdk_pixbuf_loader_write (_tmp3_, _tmp4_, (gsize) _tmp4__length1, &_inner_error0_);
#line 79 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 586 "Utils.c"
			goto __catch0_g_error;
		}
#line 80 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp5_ = loader;
#line 80 "../Spice-up-1.9.1/src/Services/Utils.vala"
		gdk_pixbuf_loader_close (_tmp5_, &_inner_error0_);
#line 80 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 595 "Utils.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
		e = _inner_error0_;
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_inner_error0_ = NULL;
#line 82 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp6_ = e;
#line 82 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp7_ = _tmp6_->message;
#line 82 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_warning ("Utils.vala:82: Loading image failed: %s", _tmp7_);
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_error_free0 (e);
#line 617 "Utils.c"
	}
	__finally0:
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_object_unref0 (loader);
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
		raw_data = (g_free (raw_data), NULL);
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 78 "../Spice-up-1.9.1/src/Services/Utils.vala"
		return NULL;
#line 632 "Utils.c"
	}
#line 85 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp8_ = loader;
#line 85 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp9_ = gdk_pixbuf_loader_get_pixbuf (_tmp8_);
#line 85 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 85 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = _tmp10_;
#line 85 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_g_object_unref0 (loader);
#line 85 "../Spice-up-1.9.1/src/Services/Utils.vala"
	raw_data = (g_free (raw_data), NULL);
#line 85 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 648 "Utils.c"
}

gchar*
spice_utils_pixbuf_to_base64 (GdkPixbuf* pixbuf)
{
	gint w = 0;
	gint h = 0;
	GraniteDrawingBufferSurface* surface = NULL;
	GraniteDrawingBufferSurface* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
#line 88 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (pixbuf != NULL, NULL);
#line 89 "../Spice-up-1.9.1/src/Services/Utils.vala"
	w = gdk_pixbuf_get_width (pixbuf);
#line 90 "../Spice-up-1.9.1/src/Services/Utils.vala"
	h = gdk_pixbuf_get_height (pixbuf);
#line 92 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = granite_drawing_buffer_surface_new (w, h);
#line 92 "../Spice-up-1.9.1/src/Services/Utils.vala"
	surface = _tmp0_;
#line 93 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp1_ = granite_drawing_buffer_surface_get_context (surface);
#line 93 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp2_ = _tmp1_;
#line 93 "../Spice-up-1.9.1/src/Services/Utils.vala"
	gdk_cairo_set_source_pixbuf (_tmp2_, pixbuf, (gdouble) 0, (gdouble) 0);
#line 94 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp3_ = granite_drawing_buffer_surface_get_context (surface);
#line 94 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp4_ = _tmp3_;
#line 94 "../Spice-up-1.9.1/src/Services/Utils.vala"
	cairo_paint (_tmp4_);
#line 96 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp5_ = granite_drawing_buffer_surface_get_surface (surface);
#line 96 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp6_ = _tmp5_;
#line 96 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp7_ = spice_utils_surface_to_base64 (_tmp6_);
#line 96 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = _tmp7_;
#line 96 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_g_object_unref0 (surface);
#line 96 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 700 "Utils.c"
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 99 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 99 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return _data7_;
#line 710 "Utils.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 99 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 99 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_array_unref0 (_data7_->data_raw);
#line 99 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_slice_free (Block7Data, _data7_);
#line 724 "Utils.c"
	}
}

static cairo_status_t
__lambda13_ (Block7Data* _data7_,
             guchar* raw,
             gint raw_length1)
{
	cairo_status_t result;
#line 102 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_array_append_vals (_data7_->data_raw, raw, (guint) raw_length1);
#line 103 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = CAIRO_STATUS_SUCCESS;
#line 103 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 740 "Utils.c"
}

static cairo_status_t
___lambda13__cairo_write_func_t (gpointer self,
                                 guchar* data,
                                 gint data_length1)
{
	cairo_status_t result;
	result = __lambda13_ (self, data, data_length1);
#line 101 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 752 "Utils.c"
}

gchar*
spice_utils_surface_to_base64 (cairo_surface_t* surface)
{
	Block7Data* _data7_;
	GArray* _tmp0_;
	gpointer* _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar* result;
#line 99 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (surface != NULL, NULL);
#line 99 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 99 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_data7_->_ref_count_ = 1;
#line 100 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (guchar));
#line 100 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_data7_->data_raw = _tmp0_;
#line 101 "../Spice-up-1.9.1/src/Services/Utils.vala"
	cairo_surface_write_to_png_stream (surface, ___lambda13__cairo_write_func_t, _data7_);
#line 106 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp1_ = _data7_->data_raw->data;
#line 106 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp1__length1 = _data7_->data_raw->len;
#line 106 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp2_ = g_base64_encode (_tmp1_, (gint) _tmp1__length1);
#line 106 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = _tmp2_;
#line 106 "../Spice-up-1.9.1/src/Services/Utils.vala"
	block7_data_unref (_data7_);
#line 106 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_data7_ = NULL;
#line 106 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 790 "Utils.c"
}

gboolean
spice_utils_is_valid_image (GFile* file)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 110 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 800 "Utils.c"
	{
		GFileInfo* file_info = NULL;
		GFileInfo* _tmp0_;
		GFileInfo* _tmp1_;
#line 112 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp0_ = g_file_query_info (file, "standard::*", 0, NULL, &_inner_error0_);
#line 112 "../Spice-up-1.9.1/src/Services/Utils.vala"
		file_info = _tmp0_;
#line 112 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 811 "Utils.c"
			goto __catch0_g_error;
		}
#line 115 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp1_ = file_info;
#line 115 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (g_file_info_get_file_type (_tmp1_) != G_FILE_TYPE_REGULAR) {
#line 116 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = FALSE;
#line 116 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_object_unref0 (file_info);
#line 116 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 824 "Utils.c"
		}
		{
			GdkPixbuf* pixbuf = NULL;
			gchar* _tmp2_;
			gchar* _tmp3_;
			GdkPixbuf* _tmp4_;
			GdkPixbuf* _tmp5_;
			gint width = 0;
			GdkPixbuf* _tmp6_;
			gint height = 0;
			GdkPixbuf* _tmp7_;
			gboolean _tmp8_ = FALSE;
#line 119 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_tmp2_ = g_file_get_path (file);
#line 119 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_tmp3_ = _tmp2_;
#line 119 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_tmp4_ = gdk_pixbuf_new_from_file (_tmp3_, &_inner_error0_);
#line 119 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_tmp5_ = _tmp4_;
#line 119 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_free0 (_tmp3_);
#line 119 "../Spice-up-1.9.1/src/Services/Utils.vala"
			pixbuf = _tmp5_;
#line 119 "../Spice-up-1.9.1/src/Services/Utils.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 851 "Utils.c"
				goto __catch1_g_error;
			}
#line 120 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_tmp6_ = pixbuf;
#line 120 "../Spice-up-1.9.1/src/Services/Utils.vala"
			width = gdk_pixbuf_get_width (_tmp6_);
#line 121 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_tmp7_ = pixbuf;
#line 121 "../Spice-up-1.9.1/src/Services/Utils.vala"
			height = gdk_pixbuf_get_height (_tmp7_);
#line 123 "../Spice-up-1.9.1/src/Services/Utils.vala"
			if (width < 1) {
#line 123 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_tmp8_ = TRUE;
#line 866 "Utils.c"
			} else {
#line 123 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_tmp8_ = height < 1;
#line 870 "Utils.c"
			}
#line 123 "../Spice-up-1.9.1/src/Services/Utils.vala"
			if (_tmp8_) {
#line 123 "../Spice-up-1.9.1/src/Services/Utils.vala"
				result = FALSE;
#line 123 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_g_object_unref0 (pixbuf);
#line 123 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_g_object_unref0 (file_info);
#line 123 "../Spice-up-1.9.1/src/Services/Utils.vala"
				return result;
#line 882 "Utils.c"
			}
#line 118 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_object_unref0 (pixbuf);
#line 886 "Utils.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
#line 118 "../Spice-up-1.9.1/src/Services/Utils.vala"
			e = _inner_error0_;
#line 118 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_inner_error0_ = NULL;
#line 125 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_tmp9_ = e;
#line 125 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_tmp10_ = _tmp9_->message;
#line 125 "../Spice-up-1.9.1/src/Services/Utils.vala"
			g_warning ("Utils.vala:125: Invalid image loaded: %s", _tmp10_);
#line 126 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = FALSE;
#line 126 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_error_free0 (e);
#line 126 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_object_unref0 (file_info);
#line 126 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 912 "Utils.c"
		}
		__finally1:
#line 118 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 118 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_object_unref0 (file_info);
#line 919 "Utils.c"
			goto __catch0_g_error;
		}
		{
			const gchar** type_collection = NULL;
			gint type_collection_length1 = 0;
			gint _type_collection_size_ = 0;
			gint type_it = 0;
#line 129 "../Spice-up-1.9.1/src/Services/Utils.vala"
			type_collection = SPICE_UTILS_ACCEPTED_TYPES;
#line 129 "../Spice-up-1.9.1/src/Services/Utils.vala"
			type_collection_length1 = G_N_ELEMENTS (SPICE_UTILS_ACCEPTED_TYPES);
#line 129 "../Spice-up-1.9.1/src/Services/Utils.vala"
			for (type_it = 0; type_it < type_collection_length1; type_it = type_it + 1) {
#line 933 "Utils.c"
				const gchar* type = NULL;
#line 129 "../Spice-up-1.9.1/src/Services/Utils.vala"
				type = type_collection[type_it];
#line 937 "Utils.c"
				{
					GFileInfo* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
#line 130 "../Spice-up-1.9.1/src/Services/Utils.vala"
					_tmp11_ = file_info;
#line 130 "../Spice-up-1.9.1/src/Services/Utils.vala"
					_tmp12_ = g_file_info_get_content_type (_tmp11_);
#line 130 "../Spice-up-1.9.1/src/Services/Utils.vala"
					_tmp13_ = type;
#line 130 "../Spice-up-1.9.1/src/Services/Utils.vala"
					if (g_content_type_equals (_tmp12_, _tmp13_)) {
#line 131 "../Spice-up-1.9.1/src/Services/Utils.vala"
						result = TRUE;
#line 131 "../Spice-up-1.9.1/src/Services/Utils.vala"
						_g_object_unref0 (file_info);
#line 131 "../Spice-up-1.9.1/src/Services/Utils.vala"
						return result;
#line 956 "Utils.c"
					}
				}
			}
		}
#line 111 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_object_unref0 (file_info);
#line 963 "Utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
#line 111 "../Spice-up-1.9.1/src/Services/Utils.vala"
		e = _inner_error0_;
#line 111 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_inner_error0_ = NULL;
#line 135 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp14_ = e;
#line 135 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp15_ = _tmp14_->message;
#line 135 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_warning ("Utils.vala:135: Could not get file info: %s", _tmp15_);
#line 111 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_error_free0 (e);
#line 983 "Utils.c"
	}
	__finally0:
#line 111 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 988 "Utils.c"
		gboolean _tmp16_ = FALSE;
#line 111 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 111 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 111 "../Spice-up-1.9.1/src/Services/Utils.vala"
		return _tmp16_;
#line 996 "Utils.c"
	}
#line 138 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = FALSE;
#line 138 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 1002 "Utils.c"
}

void
spice_utils_set_style (GtkWidget* widget,
                       const gchar* css)
{
	GError* _inner_error0_ = NULL;
#line 141 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_if_fail (widget != NULL);
#line 141 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_if_fail (css != NULL);
#line 1014 "Utils.c"
	{
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp0_;
		GtkStyleContext* context = NULL;
		GtkStyleContext* _tmp1_;
		GtkStyleContext* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 143 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp0_ = gtk_css_provider_new ();
#line 143 "../Spice-up-1.9.1/src/Services/Utils.vala"
		provider = _tmp0_;
#line 144 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp1_ = gtk_widget_get_style_context (widget);
#line 144 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 144 "../Spice-up-1.9.1/src/Services/Utils.vala"
		context = _tmp2_;
#line 146 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp3_ = strlen (css);
#line 146 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp4_ = _tmp3_;
#line 146 "../Spice-up-1.9.1/src/Services/Utils.vala"
		gtk_css_provider_load_from_data (provider, css, (gssize) _tmp4_, &_inner_error0_);
#line 146 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 146 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_object_unref0 (context);
#line 146 "../Spice-up-1.9.1/src/Services/Utils.vala"
			_g_object_unref0 (provider);
#line 1045 "Utils.c"
			goto __catch0_g_error;
		}
#line 148 "../Spice-up-1.9.1/src/Services/Utils.vala"
		gtk_style_context_add_provider (context, (GtkStyleProvider*) provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_object_unref0 (context);
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_object_unref0 (provider);
#line 1054 "Utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
		e = _inner_error0_;
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_inner_error0_ = NULL;
#line 150 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp5_ = e;
#line 150 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp6_ = _tmp5_->message;
#line 150 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_warning ("Utils.vala:150: Style error: %s", _tmp6_);
#line 151 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp7_ = gtk_widget_get_name (widget);
#line 151 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_tmp8_ = _tmp7_;
#line 151 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_debug ("Utils.vala:151: %s %s\n", _tmp8_, css);
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
		_g_error_free0 (e);
#line 1082 "Utils.c"
	}
	__finally0:
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_clear_error (&_inner_error0_);
#line 142 "../Spice-up-1.9.1/src/Services/Utils.vala"
		return;
#line 1093 "Utils.c"
	}
}

void
spice_utils_set_cursor (const gchar* cursor_type)
{
	GdkCursor* cursor = NULL;
	GdkDisplay* _tmp0_;
	GdkCursor* _tmp1_;
	SpiceWindow* _tmp2_;
	GdkScreen* _tmp3_;
	GdkWindow* _tmp4_;
	GdkWindow* _tmp5_;
#line 155 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_if_fail (cursor_type != NULL);
#line 156 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = gdk_display_get_default ();
#line 156 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp1_ = gdk_cursor_new_from_name (_tmp0_, cursor_type);
#line 156 "../Spice-up-1.9.1/src/Services/Utils.vala"
	cursor = _tmp1_;
#line 157 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp2_ = spice_application_get_active_spice_window ();
#line 157 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp3_ = gtk_window_get_screen ((GtkWindow*) _tmp2_);
#line 157 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp4_ = gdk_screen_get_active_window (_tmp3_);
#line 157 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp5_ = _tmp4_;
#line 157 "../Spice-up-1.9.1/src/Services/Utils.vala"
	gdk_window_set_cursor (_tmp5_, cursor);
#line 157 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_g_object_unref0 (_tmp5_);
#line 155 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_g_object_unref0 (cursor);
#line 1129 "Utils.c"
}

SpiceCanvasItem*
spice_utils_canvas_item_from_data (JsonObject* data,
                                   SpiceCanvas* canvas)
{
	gchar* type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	SpiceCanvasItem* item = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
	static GQuark _tmp4_label0 = 0;
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
	static GQuark _tmp4_label1 = 0;
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
	static GQuark _tmp4_label2 = 0;
#line 1149 "Utils.c"
	SpiceCanvasItem* result;
#line 160 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 161 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = json_object_get_string_member (data, "type");
#line 161 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 161 "../Spice-up-1.9.1/src/Services/Utils.vala"
	type = _tmp1_;
#line 162 "../Spice-up-1.9.1/src/Services/Utils.vala"
	item = NULL;
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp2_ = type;
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp3_ = _tmp2_;
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("text")))) {
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
		switch (0) {
#line 1171 "Utils.c"
			default:
			{
				SpiceTextItem* _tmp6_;
#line 166 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_tmp6_ = spice_text_item_new (canvas, data);
#line 166 "../Spice-up-1.9.1/src/Services/Utils.vala"
				g_object_ref_sink (_tmp6_);
#line 166 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_g_object_unref0 (item);
#line 166 "../Spice-up-1.9.1/src/Services/Utils.vala"
				item = (SpiceCanvasItem*) _tmp6_;
#line 167 "../Spice-up-1.9.1/src/Services/Utils.vala"
				break;
#line 1185 "Utils.c"
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("color")))) {
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
		switch (0) {
#line 1191 "Utils.c"
			default:
			{
				SpiceColorItem* _tmp7_;
#line 169 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_tmp7_ = spice_color_item_new (canvas, data);
#line 169 "../Spice-up-1.9.1/src/Services/Utils.vala"
				g_object_ref_sink (_tmp7_);
#line 169 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_g_object_unref0 (item);
#line 169 "../Spice-up-1.9.1/src/Services/Utils.vala"
				item = (SpiceCanvasItem*) _tmp7_;
#line 170 "../Spice-up-1.9.1/src/Services/Utils.vala"
				break;
#line 1205 "Utils.c"
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("image")))) {
#line 164 "../Spice-up-1.9.1/src/Services/Utils.vala"
		switch (0) {
#line 1211 "Utils.c"
			default:
			{
				SpiceImageItem* _tmp8_;
#line 172 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_tmp8_ = spice_image_item_new (canvas, data);
#line 172 "../Spice-up-1.9.1/src/Services/Utils.vala"
				g_object_ref_sink (_tmp8_);
#line 172 "../Spice-up-1.9.1/src/Services/Utils.vala"
				_g_object_unref0 (item);
#line 172 "../Spice-up-1.9.1/src/Services/Utils.vala"
				item = (SpiceCanvasItem*) _tmp8_;
#line 173 "../Spice-up-1.9.1/src/Services/Utils.vala"
				break;
#line 1225 "Utils.c"
			}
		}
	}
#line 176 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = item;
#line 176 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_g_free0 (type);
#line 176 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 1235 "Utils.c"
}

void
spice_utils_new_slide (SpiceSlideManager* manager)
{
	SpiceSlide* slide = NULL;
	SpiceSlide* _tmp0_;
#line 179 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_if_fail (manager != NULL);
#line 180 "../Spice-up-1.9.1/src/Services/Utils.vala"
	manager->making_new_slide = TRUE;
#line 182 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = spice_slide_manager_new_slide (manager, NULL, TRUE);
#line 182 "../Spice-up-1.9.1/src/Services/Utils.vala"
	slide = _tmp0_;
#line 183 "../Spice-up-1.9.1/src/Services/Utils.vala"
	spice_slide_reload_preview_data (slide);
#line 184 "../Spice-up-1.9.1/src/Services/Utils.vala"
	spice_slide_manager_set_current_slide (manager, slide);
#line 186 "../Spice-up-1.9.1/src/Services/Utils.vala"
	manager->making_new_slide = FALSE;
#line 179 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_g_object_unref0 (slide);
#line 1259 "Utils.c"
}

void
spice_utils_set_action_enabled (const gchar* action_name,
                                GSimpleActionGroup* action_group,
                                gboolean enabled)
{
	GAction* _tmp0_;
#line 189 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_if_fail (action_name != NULL);
#line 189 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_if_fail (action_group != NULL);
#line 190 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) action_group, action_name);
#line 190 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction), enabled);
#line 1276 "Utils.c"
}

gchar*
spice_utils_get_accel_tooltip (const gchar* action_name,
                               const gchar* description)
{
	SpiceApplication* _tmp0_;
	SpiceApplication* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
#line 193 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (action_name != NULL, NULL);
#line 193 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (description != NULL, NULL);
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp0_ = spice_application_get_instance ();
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp1_ = _tmp0_;
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp2_ = g_strconcat ("win.", action_name, NULL);
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp3_ = _tmp2_;
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp5_ = _tmp4_ = gtk_application_get_accels_for_action ((GtkApplication*) _tmp1_, _tmp3_);
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp6_ = _tmp5_;
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp6__length1 = _vala_array_length (_tmp4_);
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp7_ = granite_markup_accel_tooltip (_tmp6_, (gint) _vala_array_length (_tmp4_), description);
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp8_ = _tmp7_;
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	_g_free0 (_tmp3_);
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = _tmp8_;
#line 194 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 1324 "Utils.c"
}

SpiceUtils*
spice_utils_construct (GType object_type)
{
	SpiceUtils* self = NULL;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	self = (SpiceUtils*) g_type_create_instance (object_type);
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return self;
#line 1335 "Utils.c"
}

SpiceUtils*
spice_utils_new (void)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return spice_utils_construct (SPICE_TYPE_UTILS);
#line 1343 "Utils.c"
}

static void
spice_value_utils_init (GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	value->data[0].v_pointer = NULL;
#line 1351 "Utils.c"
}

static void
spice_value_utils_free_value (GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		spice_utils_unref (value->data[0].v_pointer);
#line 1361 "Utils.c"
	}
}

static void
spice_value_utils_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		dest_value->data[0].v_pointer = spice_utils_ref (src_value->data[0].v_pointer);
#line 1373 "Utils.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1377 "Utils.c"
	}
}

static gpointer
spice_value_utils_peek_pointer (const GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return value->data[0].v_pointer;
#line 1386 "Utils.c"
}

static gchar*
spice_value_utils_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (collect_values[0].v_pointer) {
#line 1397 "Utils.c"
		SpiceUtils * object;
		object = collect_values[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1404 "Utils.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1408 "Utils.c"
		}
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		value->data[0].v_pointer = spice_utils_ref (object);
#line 1412 "Utils.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 1416 "Utils.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return NULL;
#line 1420 "Utils.c"
}

static gchar*
spice_value_utils_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	SpiceUtils ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (!object_p) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1435 "Utils.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		*object_p = NULL;
#line 1441 "Utils.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		*object_p = value->data[0].v_pointer;
#line 1445 "Utils.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		*object_p = spice_utils_ref (value->data[0].v_pointer);
#line 1449 "Utils.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return NULL;
#line 1453 "Utils.c"
}

GParamSpec*
spice_param_spec_utils (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	SpiceParamSpecUtils* spec;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SPICE_TYPE_UTILS), NULL);
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return G_PARAM_SPEC (spec);
#line 1472 "Utils.c"
}

gpointer
spice_value_get_utils (const GValue* value)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_TYPE_UTILS), NULL);
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return value->data[0].v_pointer;
#line 1482 "Utils.c"
}

void
spice_value_set_utils (GValue* value,
                       gpointer v_object)
{
	SpiceUtils * old;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_TYPE_UTILS));
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	old = value->data[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (v_object) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPICE_TYPE_UTILS));
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		spice_utils_ref (value->data[0].v_pointer);
#line 1504 "Utils.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 1508 "Utils.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (old) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		spice_utils_unref (old);
#line 1514 "Utils.c"
	}
}

void
spice_value_take_utils (GValue* value,
                        gpointer v_object)
{
	SpiceUtils * old;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SPICE_TYPE_UTILS));
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	old = value->data[0].v_pointer;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (v_object) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SPICE_TYPE_UTILS));
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		value->data[0].v_pointer = v_object;
#line 1535 "Utils.c"
	} else {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		value->data[0].v_pointer = NULL;
#line 1539 "Utils.c"
	}
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (old) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		spice_utils_unref (old);
#line 1545 "Utils.c"
	}
}

static void
spice_utils_class_init (SpiceUtilsClass * klass,
                        gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	spice_utils_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	((SpiceUtilsClass *) klass)->finalize = spice_utils_finalize;
#line 1557 "Utils.c"
}

static void
spice_utils_instance_init (SpiceUtils * self,
                           gpointer klass)
{
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	self->ref_count = 1;
#line 1566 "Utils.c"
}

static void
spice_utils_finalize (SpiceUtils * obj)
{
	SpiceUtils * self;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_UTILS, SpiceUtils);
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_signal_handlers_destroy (self);
#line 1577 "Utils.c"
}

static GType
spice_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { spice_value_utils_init, spice_value_utils_free_value, spice_value_utils_copy_value, spice_value_utils_peek_pointer, "p", spice_value_utils_collect_value, "p", spice_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SpiceUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceUtils), 0, (GInstanceInitFunc) spice_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType spice_utils_type_id;
	spice_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SpiceUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return spice_utils_type_id;
}

GType
spice_utils_get_type (void)
{
	static volatile gsize spice_utils_type_id__once = 0;
	if (g_once_init_enter (&spice_utils_type_id__once)) {
		GType spice_utils_type_id;
		spice_utils_type_id = spice_utils_get_type_once ();
		g_once_init_leave (&spice_utils_type_id__once, spice_utils_type_id);
	}
	return spice_utils_type_id__once;
}

gpointer
spice_utils_ref (gpointer instance)
{
	SpiceUtils * self;
	self = instance;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return instance;
#line 1612 "Utils.c"
}

void
spice_utils_unref (gpointer instance)
{
	SpiceUtils * self;
	self = instance;
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		SPICE_UTILS_GET_CLASS (self)->finalize (self);
#line 22 "../Spice-up-1.9.1/src/Services/Utils.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1626 "Utils.c"
	}
}

SpiceAspectRatio
spice_aspect_ratio_get_mode (gint* value)
{
	gint h = 0;
	gint w = 0;
	gint ratio = 0;
	SpiceAspectRatio result;
#line 206 "../Spice-up-1.9.1/src/Services/Utils.vala"
	switch (*value) {
#line 206 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 1:
#line 1641 "Utils.c"
		{
#line 207 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_4_3;
#line 207 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1647 "Utils.c"
		}
#line 206 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 2:
#line 1651 "Utils.c"
		{
#line 208 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_16_9;
#line 208 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1657 "Utils.c"
		}
#line 206 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 3:
#line 1661 "Utils.c"
		{
#line 209 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_16_10;
#line 209 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1667 "Utils.c"
		}
#line 206 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 4:
#line 1671 "Utils.c"
		{
#line 210 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_3_2;
#line 210 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1677 "Utils.c"
		}
#line 206 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 5:
#line 1681 "Utils.c"
		{
#line 211 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_5_4;
#line 211 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1687 "Utils.c"
		}
		default:
#line 206 "../Spice-up-1.9.1/src/Services/Utils.vala"
		break;
#line 1692 "Utils.c"
	}
#line 215 "../Spice-up-1.9.1/src/Services/Utils.vala"
	h = gdk_screen_height ();
#line 216 "../Spice-up-1.9.1/src/Services/Utils.vala"
	w = gdk_screen_width ();
#line 218 "../Spice-up-1.9.1/src/Services/Utils.vala"
	ratio = (gint) ((((gdouble) w) / h) * 10);
#line 220 "../Spice-up-1.9.1/src/Services/Utils.vala"
	switch (ratio) {
#line 220 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 12:
#line 1704 "Utils.c"
		{
#line 221 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_5_4;
#line 221 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1710 "Utils.c"
		}
#line 220 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 13:
#line 1714 "Utils.c"
		{
#line 222 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_4_3;
#line 222 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1720 "Utils.c"
		}
#line 220 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 14:
#line 1724 "Utils.c"
		{
#line 223 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_3_2;
#line 223 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1730 "Utils.c"
		}
#line 220 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 16:
#line 1734 "Utils.c"
		{
#line 224 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_16_10;
#line 224 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1740 "Utils.c"
		}
#line 220 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case 17:
#line 1744 "Utils.c"
		{
#line 225 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = SPICE_ASPECT_RATIO_ASPECT_16_9;
#line 225 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1750 "Utils.c"
		}
		default:
#line 220 "../Spice-up-1.9.1/src/Services/Utils.vala"
		break;
#line 1755 "Utils.c"
	}
#line 228 "../Spice-up-1.9.1/src/Services/Utils.vala"
	result = SPICE_ASPECT_RATIO_ASPECT_16_9;
#line 228 "../Spice-up-1.9.1/src/Services/Utils.vala"
	return result;
#line 1761 "Utils.c"
}

gfloat
spice_aspect_ratio_get_ratio_value (SpiceAspectRatio value)
{
	gfloat result;
#line 232 "../Spice-up-1.9.1/src/Services/Utils.vala"
	switch (value) {
#line 232 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_4_3:
#line 1772 "Utils.c"
		{
#line 233 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 1.3333f;
#line 233 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1778 "Utils.c"
		}
#line 232 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_16_9:
#line 1782 "Utils.c"
		{
#line 234 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 1.7777f;
#line 234 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1788 "Utils.c"
		}
#line 232 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_16_10:
#line 1792 "Utils.c"
		{
#line 235 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 1.6666f;
#line 235 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1798 "Utils.c"
		}
#line 232 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_3_2:
#line 1802 "Utils.c"
		{
#line 236 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 1.5f;
#line 236 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1808 "Utils.c"
		}
#line 232 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_5_4:
#line 1812 "Utils.c"
		{
#line 237 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 1.25f;
#line 237 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1818 "Utils.c"
		}
		default:
#line 232 "../Spice-up-1.9.1/src/Services/Utils.vala"
		break;
#line 1823 "Utils.c"
	}
#line 239 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_assert_not_reached ();
#line 1827 "Utils.c"
}

gint
spice_aspect_ratio_get_width_value (SpiceAspectRatio value)
{
	gint result;
#line 243 "../Spice-up-1.9.1/src/Services/Utils.vala"
	switch (value) {
#line 243 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_4_3:
#line 1838 "Utils.c"
		{
#line 244 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 200;
#line 244 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1844 "Utils.c"
		}
#line 243 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_16_9:
#line 1848 "Utils.c"
		{
#line 245 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 267;
#line 245 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1854 "Utils.c"
		}
#line 243 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_16_10:
#line 1858 "Utils.c"
		{
#line 246 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 250;
#line 246 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1864 "Utils.c"
		}
#line 243 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_3_2:
#line 1868 "Utils.c"
		{
#line 247 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 225;
#line 247 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1874 "Utils.c"
		}
#line 243 "../Spice-up-1.9.1/src/Services/Utils.vala"
		case SPICE_ASPECT_RATIO_ASPECT_5_4:
#line 1878 "Utils.c"
		{
#line 248 "../Spice-up-1.9.1/src/Services/Utils.vala"
			result = 187;
#line 248 "../Spice-up-1.9.1/src/Services/Utils.vala"
			return result;
#line 1884 "Utils.c"
		}
		default:
#line 243 "../Spice-up-1.9.1/src/Services/Utils.vala"
		break;
#line 1889 "Utils.c"
	}
#line 250 "../Spice-up-1.9.1/src/Services/Utils.vala"
	g_assert_not_reached ();
#line 1893 "Utils.c"
}

static GType
spice_aspect_ratio_get_type_once (void)
{
	static const GEnumValue values[] = {{SPICE_ASPECT_RATIO_ASPECT_4_3, "SPICE_ASPECT_RATIO_ASPECT_4_3", "aspect-4-3"}, {SPICE_ASPECT_RATIO_ASPECT_16_9, "SPICE_ASPECT_RATIO_ASPECT_16_9", "aspect-16-9"}, {SPICE_ASPECT_RATIO_ASPECT_16_10, "SPICE_ASPECT_RATIO_ASPECT_16_10", "aspect-16-10"}, {SPICE_ASPECT_RATIO_ASPECT_3_2, "SPICE_ASPECT_RATIO_ASPECT_3_2", "aspect-3-2"}, {SPICE_ASPECT_RATIO_ASPECT_5_4, "SPICE_ASPECT_RATIO_ASPECT_5_4", "aspect-5-4"}, {0, NULL, NULL}};
	GType spice_aspect_ratio_type_id;
	spice_aspect_ratio_type_id = g_enum_register_static ("SpiceAspectRatio", values);
	return spice_aspect_ratio_type_id;
}

GType
spice_aspect_ratio_get_type (void)
{
	static volatile gsize spice_aspect_ratio_type_id__once = 0;
	if (g_once_init_enter (&spice_aspect_ratio_type_id__once)) {
		GType spice_aspect_ratio_type_id;
		spice_aspect_ratio_type_id = spice_aspect_ratio_get_type_once ();
		g_once_init_leave (&spice_aspect_ratio_type_id__once, spice_aspect_ratio_type_id);
	}
	return spice_aspect_ratio_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

