// Code generated by smithy-go-codegen DO NOT EDIT.

package ecr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ecr/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Transitions an image between storage classes. You can transition images from
// Amazon ECR standard storage class to Amazon ECR archival storage class for
// long-term storage, or restore archived images back to Amazon ECR standard.
func (c *Client) UpdateImageStorageClass(ctx context.Context, params *UpdateImageStorageClassInput, optFns ...func(*Options)) (*UpdateImageStorageClassOutput, error) {
	if params == nil {
		params = &UpdateImageStorageClassInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateImageStorageClass", params, optFns, c.addOperationUpdateImageStorageClassMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateImageStorageClassOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateImageStorageClassInput struct {

	// An object with identifying information for an image in an Amazon ECR repository.
	//
	// This member is required.
	ImageId *types.ImageIdentifier

	// The name of the repository that contains the image to transition.
	//
	// This member is required.
	RepositoryName *string

	// The target storage class for the image.
	//
	// This member is required.
	TargetStorageClass types.TargetStorageClass

	// The Amazon Web Services account ID associated with the registry that contains
	// the image to transition. If you do not specify a registry, the default registry
	// is assumed.
	RegistryId *string

	noSmithyDocumentSerde
}

type UpdateImageStorageClassOutput struct {

	// An object with identifying information for an image in an Amazon ECR repository.
	ImageId *types.ImageIdentifier

	// The current status of the image after the call to UpdateImageStorageClass is
	// complete. Valid values are ACTIVE , ARCHIVED , and ACTIVATING .
	ImageStatus types.ImageStatus

	// The registry ID associated with the request.
	RegistryId *string

	// The repository name associated with the request.
	RepositoryName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateImageStorageClassMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateImageStorageClass{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateImageStorageClass{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateImageStorageClass"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateImageStorageClassValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateImageStorageClass(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateImageStorageClass(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateImageStorageClass",
	}
}
