/* key-properties.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from key-properties.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2005 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include "seahorse-common.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEAHORSE_SSH_KEY_PROPERTIES_0_PROPERTY,
	SEAHORSE_SSH_KEY_PROPERTIES_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_key_properties_properties[SEAHORSE_SSH_KEY_PROPERTIES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

struct _SeahorseSshKeyPropertiesPrivate {
	SeahorseSshKey* key;
	gboolean updating_ui;
	GtkEntry* comment_entry;
	GtkSwitch* trust_check;
	GtkButton* passphrase_button;
	GtkButton* export_button;
	GtkButton* copy_button;
	GtkLabel* fingerprint_label;
	GtkLabel* algo_label;
	GtkLabel* location_label;
	GtkLabel* pubkey_label;
	GtkLabel* key_length_label;
};

struct _Block2Data {
	int _ref_count_;
	SeahorseSshKeyProperties* self;
	SeahorseSshRenameOperation* op;
	GtkEntry* entry;
};

struct _Block3Data {
	int _ref_count_;
	SeahorseSshKeyProperties* self;
	SeahorseSshSource* source;
};

struct _Block4Data {
	int _ref_count_;
	SeahorseSshKeyProperties* self;
	SeahorseSshChangePassphraseOperation* op;
	GtkButton* button;
};

struct _Block5Data {
	int _ref_count_;
	SeahorseSshKeyProperties* self;
	SeahorseDeleter* deleter;
};

struct _Block6Data {
	int _ref_count_;
	SeahorseSshKeyProperties* self;
	SeahorseExporter* exporter;
};

static gint SeahorseSshKeyProperties_private_offset;
static gpointer seahorse_ssh_key_properties_parent_class = NULL;

static void seahorse_ssh_key_properties_update_ui (SeahorseSshKeyProperties* self);
static void __lambda4_ (SeahorseSshKeyProperties* self);
static void ___lambda4__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void seahorse_ssh_key_properties_real_response (GtkDialog* base,
                                                gint response);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda5_ (Block2Data* _data2_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _seahorse_ssh_key_properties_on_ssh_comment_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                              gpointer self);
static gboolean seahorse_ssh_key_properties_on_ssh_comment_focus_out (SeahorseSshKeyProperties* self,
                                                               GtkWidget* widget,
                                                               GdkEventFocus* event);
static gboolean _seahorse_ssh_key_properties_on_ssh_comment_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                           GdkEventFocus* event,
                                                                                           gpointer self);
static void seahorse_ssh_key_properties_on_ssh_trust_changed (SeahorseSshKeyProperties* self,
                                                       GObject* button,
                                                       GParamSpec* p);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _seahorse_ssh_key_properties_on_ssh_trust_changed_g_object_notify (GObject* _sender,
                                                                        GParamSpec* pspec,
                                                                        gpointer self);
static void seahorse_ssh_key_properties_on_ssh_passphrase_button_clicked (SeahorseSshKeyProperties* self,
                                                                   GtkButton* button);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda8_ (Block4Data* _data4_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _seahorse_ssh_key_properties_on_ssh_passphrase_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                       gpointer self);
static void seahorse_ssh_key_properties_on_delete_clicked (SeahorseSshKeyProperties* self,
                                                    GtkButton* button);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda9_ (Block5Data* _data5_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void _seahorse_ssh_key_properties_on_delete_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self);
static void seahorse_ssh_key_properties_on_ssh_export_button_clicked (SeahorseSshKeyProperties* self,
                                                               GtkWidget* widget);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void ___lambda10_ (Block6Data* _data6_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda10__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _seahorse_ssh_key_properties_on_ssh_export_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                   gpointer self);
static void seahorse_ssh_key_properties_on_ssh_copy_button_clicked (SeahorseSshKeyProperties* self,
                                                             GtkWidget* widget);
static void _seahorse_ssh_key_properties_on_ssh_copy_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                 gpointer self);
static void seahorse_ssh_key_properties_finalize (GObject * obj);
static GType seahorse_ssh_key_properties_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_key_properties_get_instance_private (SeahorseSshKeyProperties* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshKeyProperties_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda4_ (SeahorseSshKeyProperties* self)
{
	seahorse_ssh_key_properties_update_ui (self);
}

static void
___lambda4__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda4_ ((SeahorseSshKeyProperties*) self);
}

SeahorseSshKeyProperties*
seahorse_ssh_key_properties_construct (GType object_type,
                                       SeahorseSshKey* key,
                                       GtkWindow* parent)
{
	SeahorseSshKeyProperties * self = NULL;
	SeahorseSshKey* _tmp0_;
	SeahorseUsage _tmp1_;
	SeahorseUsage _tmp2_;
	SeahorseSshKey* _tmp6_;
	g_return_val_if_fail (key != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	self = (SeahorseSshKeyProperties*) g_object_new (object_type, "use-header-bar", 1, "transient-for", parent, NULL);
	_tmp0_ = _g_object_ref0 (key);
	_g_object_unref0 (self->priv->key);
	self->priv->key = _tmp0_;
	seahorse_ssh_key_properties_update_ui (self);
	_tmp1_ = seahorse_object_get_usage ((SeahorseObject*) key);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != SEAHORSE_USAGE_PRIVATE_KEY) {
		GtkButton* _tmp3_;
		GtkButton* _tmp4_;
		GtkButton* _tmp5_;
		_tmp3_ = self->priv->passphrase_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->export_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
		_tmp5_ = self->priv->copy_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
	}
	_tmp6_ = self->priv->key;
	g_signal_connect_object ((GObject*) _tmp6_, "notify", (GCallback) ___lambda4__g_object_notify, self, 0);
	return self;
}

SeahorseSshKeyProperties*
seahorse_ssh_key_properties_new (SeahorseSshKey* key,
                                 GtkWindow* parent)
{
	return seahorse_ssh_key_properties_construct (SEAHORSE_SSH_TYPE_KEY_PROPERTIES, key, parent);
}

static void
seahorse_ssh_key_properties_update_ui (SeahorseSshKeyProperties* self)
{
	GtkEntry* _tmp0_;
	SeahorseSshKey* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GtkSwitch* _tmp4_;
	SeahorseSshKey* _tmp5_;
	SeahorseValidity _tmp6_;
	SeahorseValidity _tmp7_;
	GtkLabel* _tmp8_;
	SeahorseSshKey* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	SeahorseSshKey* _tmp13_;
	gchar* _tmp14_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	SeahorseSshKey* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkLabel* _tmp21_;
	SeahorseSshKey* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkLabel* _tmp25_;
	SeahorseSshKey* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	g_return_if_fail (self != NULL);
	self->priv->updating_ui = TRUE;
	_tmp0_ = self->priv->comment_entry;
	_tmp1_ = self->priv->key;
	_tmp2_ = seahorse_object_get_label ((SeahorseObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_entry_set_text (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->trust_check;
	_tmp5_ = self->priv->key;
	_tmp6_ = seahorse_ssh_key_get_trust (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_switch_set_active (_tmp4_, _tmp7_ >= SEAHORSE_VALIDITY_FULL);
	_tmp8_ = self->priv->fingerprint_label;
	_tmp9_ = self->priv->key;
	_tmp10_ = seahorse_ssh_key_get_fingerprint (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp8_, _tmp11_);
	_tmp13_ = self->priv->key;
	_tmp14_ = seahorse_ssh_algorithm_to_string (seahorse_ssh_key_get_algo (_tmp13_));
	_tmp12_ = _tmp14_;
	if (_tmp12_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = g_strdup (_ ("Unknown type"));
		_g_free0 (_tmp12_);
		_tmp12_ = _tmp15_;
	}
	_tmp16_ = self->priv->algo_label;
	gtk_label_set_label (_tmp16_, _tmp12_);
	_tmp17_ = self->priv->location_label;
	_tmp18_ = self->priv->key;
	_tmp19_ = seahorse_ssh_key_get_location (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_label_set_label (_tmp17_, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->key_length_label;
	_tmp22_ = self->priv->key;
	_tmp23_ = g_strdup_printf ("%u", seahorse_ssh_key_get_strength (_tmp22_));
	_tmp24_ = _tmp23_;
	gtk_label_set_label (_tmp21_, _tmp24_);
	_g_free0 (_tmp24_);
	_tmp25_ = self->priv->pubkey_label;
	_tmp26_ = self->priv->key;
	_tmp27_ = seahorse_ssh_key_get_pubkey (_tmp26_);
	_tmp28_ = _tmp27_;
	gtk_label_set_label (_tmp25_, _tmp28_);
	self->priv->updating_ui = FALSE;
	_g_free0 (_tmp12_);
}

static void
seahorse_ssh_key_properties_real_response (GtkDialog* base,
                                           gint response)
{
	SeahorseSshKeyProperties * self;
	self = (SeahorseSshKeyProperties*) base;
	gtk_widget_destroy ((GtkWidget*) self);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SeahorseSshKeyProperties* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->op);
		_g_object_unref0 (_data2_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda5_ (Block2Data* _data2_,
            GObject* obj,
            GAsyncResult* res)
{
	SeahorseSshKeyProperties* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseSshRenameOperation* _tmp0_;
		_tmp0_ = _data2_->op;
		seahorse_ssh_rename_operation_rename_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		SeahorseSshKey* _tmp4_;
		SeahorseSshKeyData* _tmp5_;
		SeahorseSshKeyData* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t rename key."), _tmp2_);
		_tmp4_ = self->priv->key;
		_tmp5_ = seahorse_ssh_key_get_key_data (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = seahorse_ssh_key_data_get_comment (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp3_ = _tmp8_;
		if (_tmp3_ == NULL) {
			_tmp3_ = "";
		}
		gtk_entry_set_text (_data2_->entry, _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_widget_set_sensitive ((GtkWidget*) _data2_->entry, TRUE);
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda5_ (self, source_object, res);
	block2_data_unref (self);
}

void
seahorse_ssh_key_properties_on_ssh_comment_activate (SeahorseSshKeyProperties* self,
                                                     GtkEntry* entry)
{
	Block2Data* _data2_;
	GtkEntry* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SeahorseSshKey* _tmp2_;
	SeahorseSshKeyData* _tmp3_;
	SeahorseSshKeyData* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	SeahorseSshRenameOperation* _tmp14_;
	SeahorseSshRenameOperation* _tmp15_;
	SeahorseSshKey* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (entry);
	_g_object_unref0 (_data2_->entry);
	_data2_->entry = _tmp0_;
	_tmp2_ = self->priv->key;
	_tmp3_ = seahorse_ssh_key_get_key_data (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = seahorse_ssh_key_data_get_comment (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		SeahorseSshKey* _tmp9_;
		SeahorseSshKeyData* _tmp10_;
		SeahorseSshKeyData* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp7_ = gtk_entry_get_text (_data2_->entry);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->key;
		_tmp10_ = seahorse_ssh_key_get_key_data (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = seahorse_ssh_key_data_get_comment (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp1_ = g_strcmp0 (_tmp8_, _tmp13_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	gtk_widget_set_sensitive ((GtkWidget*) _data2_->entry, FALSE);
	_tmp14_ = seahorse_ssh_rename_operation_new ();
	_data2_->op = _tmp14_;
	_tmp15_ = _data2_->op;
	_tmp16_ = self->priv->key;
	_tmp17_ = gtk_entry_get_text (_data2_->entry);
	_tmp18_ = _tmp17_;
	seahorse_ssh_rename_operation_rename_async (_tmp15_, _tmp16_, _tmp18_, (GtkWindow*) self, ___lambda5__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
_seahorse_ssh_key_properties_on_ssh_comment_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                         gpointer self)
{
	seahorse_ssh_key_properties_on_ssh_comment_activate ((SeahorseSshKeyProperties*) self, _sender);
}

static gboolean
seahorse_ssh_key_properties_on_ssh_comment_focus_out (SeahorseSshKeyProperties* self,
                                                      GtkWidget* widget,
                                                      GdkEventFocus* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	seahorse_ssh_key_properties_on_ssh_comment_activate (self, G_TYPE_CHECK_INSTANCE_CAST (widget, gtk_entry_get_type (), GtkEntry));
	result = FALSE;
	return result;
}

static gboolean
_seahorse_ssh_key_properties_on_ssh_comment_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                  GdkEventFocus* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = seahorse_ssh_key_properties_on_ssh_comment_focus_out ((SeahorseSshKeyProperties*) self, _sender, event);
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SeahorseSshKeyProperties* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->source);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda7_ (Block3Data* _data3_,
            GObject* obj,
            GAsyncResult* res)
{
	SeahorseSshKeyProperties* self;
	GtkSwitch* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseSshSource* _tmp0_;
		_tmp0_ = _data3_->source;
		seahorse_ssh_source_authorize_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t change authorization for key."), _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->trust_check;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda7_ (self, source_object, res);
	block3_data_unref (self);
}

static void
seahorse_ssh_key_properties_on_ssh_trust_changed (SeahorseSshKeyProperties* self,
                                                  GObject* button,
                                                  GParamSpec* p)
{
	Block3Data* _data3_;
	GtkSwitch* _tmp0_;
	SeahorseSshKey* _tmp1_;
	SeahorsePlace* _tmp2_;
	SeahorsePlace* _tmp3_;
	SeahorseSshSource* _tmp4_;
	SeahorseSshSource* _tmp5_;
	SeahorseSshKey* _tmp6_;
	GtkSwitch* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_return_if_fail (p != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	if (self->priv->updating_ui) {
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return;
	}
	_tmp0_ = self->priv->trust_check;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->key;
	_tmp2_ = seahorse_object_get_place ((SeahorseObject*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSource));
	_data3_->source = _tmp4_;
	_tmp5_ = _data3_->source;
	_tmp6_ = self->priv->key;
	_tmp7_ = self->priv->trust_check;
	_tmp8_ = gtk_switch_get_active (_tmp7_);
	_tmp9_ = _tmp8_;
	seahorse_ssh_source_authorize_async (_tmp5_, _tmp6_, _tmp9_, ___lambda7__gasync_ready_callback, block3_data_ref (_data3_));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
_seahorse_ssh_key_properties_on_ssh_trust_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self)
{
	seahorse_ssh_key_properties_on_ssh_trust_changed ((SeahorseSshKeyProperties*) self, _sender, pspec);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		SeahorseSshKeyProperties* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->op);
		_g_object_unref0 (_data4_->button);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda8_ (Block4Data* _data4_,
            GObject* obj,
            GAsyncResult* res)
{
	SeahorseSshKeyProperties* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		seahorse_ssh_change_passphrase_operation_change_passphrase_finish (_data4_->op, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t change passphrase for key."), _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_widget_set_sensitive ((GtkWidget*) _data4_->button, TRUE);
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda8_ (self, source_object, res);
	block4_data_unref (self);
}

static void
seahorse_ssh_key_properties_on_ssh_passphrase_button_clicked (SeahorseSshKeyProperties* self,
                                                              GtkButton* button)
{
	Block4Data* _data4_;
	GtkButton* _tmp0_;
	SeahorseSshChangePassphraseOperation* _tmp1_;
	SeahorseSshKey* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (button);
	_g_object_unref0 (_data4_->button);
	_data4_->button = _tmp0_;
	gtk_widget_set_sensitive ((GtkWidget*) _data4_->button, FALSE);
	_tmp1_ = seahorse_ssh_change_passphrase_operation_new ();
	_data4_->op = _tmp1_;
	_tmp2_ = self->priv->key;
	seahorse_ssh_change_passphrase_operation_change_passphrase_async (_data4_->op, _tmp2_, NULL, ___lambda8__gasync_ready_callback, block4_data_ref (_data4_));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
_seahorse_ssh_key_properties_on_ssh_passphrase_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self)
{
	seahorse_ssh_key_properties_on_ssh_passphrase_button_clicked ((SeahorseSshKeyProperties*) self, _sender);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		SeahorseSshKeyProperties* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->deleter);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda9_ (Block5Data* _data5_,
            GObject* obj,
            GAsyncResult* res)
{
	SeahorseSshKeyProperties* self;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseDeleter* _tmp0_;
		_tmp0_ = _data5_->deleter;
		seahorse_deleter_delete_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		gtk_widget_destroy ((GtkWidget*) self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GtkMessageDialog* dialog = NULL;
		GtkMessageDialog* _tmp1_;
		GtkMessageDialog* _tmp2_;
		GtkMessageDialog* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _ ("Error deleting the SSH key."));
		g_object_ref_sink (_tmp1_);
		dialog = _tmp1_;
		_tmp2_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp2_);
		_tmp3_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp3_);
		_g_object_unref0 (dialog);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda9__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda9_ (self, source_object, res);
	block5_data_unref (self);
}

static void
seahorse_ssh_key_properties_on_delete_clicked (SeahorseSshKeyProperties* self,
                                               GtkButton* button)
{
	Block5Data* _data5_;
	SeahorseSshKey* _tmp0_;
	SeahorseDeleter* _tmp1_;
	gboolean ret = FALSE;
	SeahorseDeleter* _tmp2_;
	SeahorseDeleter* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->key;
	_tmp1_ = seahorse_deletable_create_deleter ((SeahorseDeletable*) _tmp0_);
	_data5_->deleter = _tmp1_;
	_tmp2_ = _data5_->deleter;
	ret = seahorse_deleter_prompt (_tmp2_, (GtkWindow*) self);
	if (!ret) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp3_ = _data5_->deleter;
	seahorse_deleter_delete (_tmp3_, NULL, ___lambda9__gasync_ready_callback, block5_data_ref (_data5_));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
_seahorse_ssh_key_properties_on_delete_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self)
{
	seahorse_ssh_key_properties_on_delete_clicked ((SeahorseSshKeyProperties*) self, _sender);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		SeahorseSshKeyProperties* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->exporter);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
___lambda10_ (Block6Data* _data6_,
              GObject* obj,
              GAsyncResult* res)
{
	SeahorseSshKeyProperties* self;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		SeahorseExporter* _tmp0_;
		_tmp0_ = _data6_->exporter;
		seahorse_exporter_export_to_file_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		seahorse_util_show_error ((GtkWidget*) self, _ ("Couldn’t export key"), _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda10__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda10_ (self, source_object, res);
	block6_data_unref (self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
seahorse_ssh_key_properties_on_ssh_export_button_clicked (SeahorseSshKeyProperties* self,
                                                          GtkWidget* widget)
{
	Block6Data* _data6_;
	GList* exporters = NULL;
	SeahorseSshKey* _tmp0_;
	SeahorseSshExporter* _tmp1_;
	gchar* directory = NULL;
	GFile* file = NULL;
	GList* _tmp2_;
	GFile* _tmp3_ = NULL;
	SeahorseExporter* _tmp4_ = NULL;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	exporters = NULL;
	_tmp0_ = self->priv->key;
	_tmp1_ = seahorse_ssh_exporter_new (_tmp0_, TRUE);
	exporters = g_list_append (exporters, _tmp1_);
	directory = NULL;
	_tmp2_ = exporters;
	_tmp5_ = seahorse_exportable_prompt (_tmp2_, (GtkWindow*) self, &directory, &_tmp3_, &_tmp4_);
	_g_object_unref0 (file);
	file = _tmp3_;
	_g_object_unref0 (_data6_->exporter);
	_data6_->exporter = _tmp4_;
	if (_tmp5_) {
		SeahorseExporter* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = _data6_->exporter;
		_tmp7_ = file;
		seahorse_exporter_export_to_file (_tmp6_, _tmp7_, TRUE, NULL, ____lambda10__gasync_ready_callback, block6_data_ref (_data6_));
	}
	_g_object_unref0 (file);
	_g_free0 (directory);
	(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
_seahorse_ssh_key_properties_on_ssh_export_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self)
{
	seahorse_ssh_key_properties_on_ssh_export_button_clicked ((SeahorseSshKeyProperties*) self, _sender);
}

static void
seahorse_ssh_key_properties_on_ssh_copy_button_clicked (SeahorseSshKeyProperties* self,
                                                        GtkWidget* widget)
{
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp0_;
	GdkDisplay* _tmp1_;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	SeahorseSshKey* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = gtk_widget_get_display (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp2_ = gtk_clipboard_get_for_display (display, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = self->priv->key;
	_tmp5_ = seahorse_ssh_key_get_pubkey (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_clipboard_set_text (clipboard, _tmp6_, -1);
	_g_object_unref0 (clipboard);
	_g_object_unref0 (display);
}

static void
_seahorse_ssh_key_properties_on_ssh_copy_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self)
{
	seahorse_ssh_key_properties_on_ssh_copy_button_clicked ((SeahorseSshKeyProperties*) self, _sender);
}

static void
seahorse_ssh_key_properties_class_init (SeahorseSshKeyPropertiesClass * klass,
                                        gpointer klass_data)
{
	seahorse_ssh_key_properties_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshKeyProperties_private_offset);
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog*, gint)) seahorse_ssh_key_properties_real_response;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_key_properties_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-ssh-key-properties.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "comment_entry", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, comment_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "trust_check", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, trust_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "passphrase_button", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, passphrase_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "export_button", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, export_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "copy_button", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, copy_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fingerprint_label", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, fingerprint_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "algo_label", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, algo_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "location_label", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, location_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pubkey_label", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, pubkey_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "key_length_label", FALSE, SeahorseSshKeyProperties_private_offset + G_STRUCT_OFFSET (SeahorseSshKeyPropertiesPrivate, key_length_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_ssh_comment_activate", G_CALLBACK(_seahorse_ssh_key_properties_on_ssh_comment_activate_gtk_entry_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_ssh_comment_focus_out", G_CALLBACK(_seahorse_ssh_key_properties_on_ssh_comment_focus_out_gtk_widget_focus_out_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_ssh_trust_changed", G_CALLBACK(_seahorse_ssh_key_properties_on_ssh_trust_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_ssh_passphrase_button_clicked", G_CALLBACK(_seahorse_ssh_key_properties_on_ssh_passphrase_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete_clicked", G_CALLBACK(_seahorse_ssh_key_properties_on_delete_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_ssh_export_button_clicked", G_CALLBACK(_seahorse_ssh_key_properties_on_ssh_export_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_ssh_copy_button_clicked", G_CALLBACK(_seahorse_ssh_key_properties_on_ssh_copy_button_clicked_gtk_button_clicked));
}

static void
seahorse_ssh_key_properties_instance_init (SeahorseSshKeyProperties * self,
                                           gpointer klass)
{
	self->priv = seahorse_ssh_key_properties_get_instance_private (self);
	self->priv->updating_ui = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_ssh_key_properties_finalize (GObject * obj)
{
	SeahorseSshKeyProperties * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_KEY_PROPERTIES, SeahorseSshKeyProperties);
	_g_object_unref0 (self->priv->key);
	G_OBJECT_CLASS (seahorse_ssh_key_properties_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_key_properties_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshKeyPropertiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_key_properties_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshKeyProperties), 0, (GInstanceInitFunc) seahorse_ssh_key_properties_instance_init, NULL };
	GType seahorse_ssh_key_properties_type_id;
	seahorse_ssh_key_properties_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorseSshKeyProperties", &g_define_type_info, 0);
	SeahorseSshKeyProperties_private_offset = g_type_add_instance_private (seahorse_ssh_key_properties_type_id, sizeof (SeahorseSshKeyPropertiesPrivate));
	return seahorse_ssh_key_properties_type_id;
}

GType
seahorse_ssh_key_properties_get_type (void)
{
	static volatile gsize seahorse_ssh_key_properties_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_key_properties_type_id__once)) {
		GType seahorse_ssh_key_properties_type_id;
		seahorse_ssh_key_properties_type_id = seahorse_ssh_key_properties_get_type_once ();
		g_once_init_leave (&seahorse_ssh_key_properties_type_id__once, seahorse_ssh_key_properties_type_id);
	}
	return seahorse_ssh_key_properties_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

