/* pkcs11-generate.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from pkcs11-generate.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */
/* FIXME: damn broken bindings*/

#include <gcr/gcr-base.h>
#include <ui/gcr-ui.h>
#include "seahorse-pkcs11.h"
#include <gtk/gtk.h>
#include <gck/gck.h>
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include "seahorse-common.h"
#include "libseahorse/seahorse-progress.h"
#include "pkcs11/seahorse-pkcs11-backend.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SEAHORSE_PKCS11_GENERATE_0_PROPERTY,
	SEAHORSE_PKCS11_GENERATE_NUM_PROPERTIES
};
static GParamSpec* seahorse_pkcs11_generate_properties[SEAHORSE_PKCS11_GENERATE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _gck_attributes_unref0(var) ((var == NULL) ? NULL : (var = (gck_attributes_unref (var), NULL)))
typedef enum  {
	SEAHORSE_PKCS11_GENERATE_COLUMN_LABEL,
	SEAHORSE_PKCS11_GENERATE_COLUMN_TYPE,
	SEAHORSE_PKCS11_GENERATE_COLUMN_N_COLS
} SeahorsePkcs11GenerateColumn;

#define SEAHORSE_PKCS11_GENERATE_TYPE_COLUMN (seahorse_pkcs11_generate_column_get_type ())

#define SEAHORSE_PKCS11_GENERATE_TYPE_MECHANISM (seahorse_pkcs11_generate_mechanism_get_type ())
typedef struct _SeahorsePkcs11GenerateMechanism SeahorsePkcs11GenerateMechanism;
#define __vala_GckMechanismInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckMechanismInfo_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorsePkcs11GenerateGenerateData SeahorsePkcs11GenerateGenerateData;
#define __vala_GckBuilder_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckBuilder_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorsePkcs11GeneratePrivate {
	GtkEntry* label_entry;
	SeahorsePkcs11Token* token;
	GtkComboBox* token_box;
	GcrCollectionModel* token_model;
	GckMechanism* mechanism;
	GtkListStore* mechanism_store;
	GtkComboBox* mechanism_box;
	GtkSpinButton* key_bits;
	GCancellable* cancellable;
	GckAttributes* pub_attrs;
	GckAttributes* prv_attrs;
};

struct _SeahorsePkcs11GenerateMechanism {
	gulong mechanism_type;
	const gchar* label;
};

struct _SeahorsePkcs11GenerateGenerateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorsePkcs11Generate* self;
	SeahorsePkcs11Token* _tmp0_;
	GTlsInteraction* interaction;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	SeahorseInteraction* _tmp3_;
	GCancellable* _tmp4_;
	GckSession* session;
	SeahorsePkcs11Token* _tmp5_;
	GckSlot* _tmp6_;
	GckSlot* _tmp7_;
	GTlsInteraction* _tmp8_;
	GCancellable* _tmp9_;
	GckSession* _tmp10_;
	GckObject* pub;
	GckObject* priv;
	GckSession* _tmp11_;
	GckMechanism* _tmp12_;
	GckAttributes* _tmp13_;
	GckAttributes* _tmp14_;
	GCancellable* _tmp15_;
	GckMechanism _tmp16_;
	GckObject* _tmp17_;
	GckObject* _tmp18_;
	SeahorsePkcs11Token* _tmp19_;
	GCancellable* _tmp20_;
	GckAttributes* _tmp21_;
	GckAttributes* _tmp22_;
	GError* e;
	GError* _tmp23_;
	const gchar* _tmp24_;
	GError* _inner_error0_;
};

static gint SeahorsePkcs11Generate_private_offset;
static gpointer seahorse_pkcs11_generate_parent_class = NULL;

GcrCollectionModel* gcr_collection_model_new (GcrCollection* collection,
                                              GcrCollectionModelMode mode,
                                              ...);
static GType seahorse_pkcs11_generate_column_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType seahorse_pkcs11_generate_mechanism_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SeahorsePkcs11GenerateMechanism* seahorse_pkcs11_generate_mechanism_dup (const SeahorsePkcs11GenerateMechanism* self);
static void seahorse_pkcs11_generate_mechanism_free (SeahorsePkcs11GenerateMechanism* self);
static void seahorse_pkcs11_generate_update_response (SeahorsePkcs11Generate* self);
static const gchar* seahorse_pkcs11_generate_get_available_mechanism_label (SeahorsePkcs11Generate* self,
                                                                     gulong type);
static void seahorse_pkcs11_generate_on_token_changed (SeahorsePkcs11Generate* self,
                                                GtkComboBox* combo_box);
static void seahorse_pkcs11_generate_on_mechanism_changed (SeahorsePkcs11Generate* self,
                                                    GtkComboBox* widget);
static GckMechanism* _gck_mechanism_dup (GckMechanism* self);
static void _vala_GckMechanismInfo_free (GckMechanismInfo* self);
static gint seahorse_pkcs11_generate_on_mechanism_sort (SeahorsePkcs11Generate* self,
                                                 GtkTreeModel* model,
                                                 GtkTreeIter* a,
                                                 GtkTreeIter* b);
static void seahorse_pkcs11_generate_real_response (GtkDialog* base,
                                             gint response_id);
static void seahorse_pkcs11_generate_generate (SeahorsePkcs11Generate* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void seahorse_pkcs11_generate_generate_finish (SeahorsePkcs11Generate* self,
                                               GAsyncResult* _res_);
static void seahorse_pkcs11_generate_generate_data_free (gpointer _data);
static gboolean seahorse_pkcs11_generate_generate_co (SeahorsePkcs11GenerateGenerateData* _data_);
static void seahorse_pkcs11_generate_prepare_generate (SeahorsePkcs11Generate* self);
static void seahorse_pkcs11_generate_generate_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void _vala_GckBuilder_free (GckBuilder* self);
static GObject * seahorse_pkcs11_generate_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static gint _seahorse_pkcs11_generate_on_mechanism_sort_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                             GtkTreeIter* a,
                                                                             GtkTreeIter* b,
                                                                             gpointer self);
static void _seahorse_pkcs11_generate_on_mechanism_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                           gpointer self);
static void _seahorse_pkcs11_generate_on_token_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                       gpointer self);
static void seahorse_pkcs11_generate_finalize (GObject * obj);
static GType seahorse_pkcs11_generate_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const SeahorsePkcs11GenerateMechanism SEAHORSE_PKCS11_GENERATE_AVAILABLE_MECHANISMS[1] = {{(gulong) CKM_RSA_PKCS_KEY_PAIR_GEN, N_ ("RSA")}};

static inline gpointer
seahorse_pkcs11_generate_get_instance_private (SeahorsePkcs11Generate* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorsePkcs11Generate_private_offset);
}

static gpointer
_gck_attributes_ref0 (gpointer self)
{
	return self ? gck_attributes_ref (self) : NULL;
}

 G_GNUC_NO_INLINE static GType
seahorse_pkcs11_generate_column_get_type_once (void)
{
	static const GEnumValue values[] = {{SEAHORSE_PKCS11_GENERATE_COLUMN_LABEL, "SEAHORSE_PKCS11_GENERATE_COLUMN_LABEL", "label"}, {SEAHORSE_PKCS11_GENERATE_COLUMN_TYPE, "SEAHORSE_PKCS11_GENERATE_COLUMN_TYPE", "type"}, {SEAHORSE_PKCS11_GENERATE_COLUMN_N_COLS, "SEAHORSE_PKCS11_GENERATE_COLUMN_N_COLS", "n-cols"}, {0, NULL, NULL}};
	GType seahorse_pkcs11_generate_column_type_id;
	seahorse_pkcs11_generate_column_type_id = g_enum_register_static ("SeahorsePkcs11GenerateColumn", values);
	return seahorse_pkcs11_generate_column_type_id;
}

static GType
seahorse_pkcs11_generate_column_get_type (void)
{
	static volatile gsize seahorse_pkcs11_generate_column_type_id__once = 0;
	if (g_once_init_enter (&seahorse_pkcs11_generate_column_type_id__once)) {
		GType seahorse_pkcs11_generate_column_type_id;
		seahorse_pkcs11_generate_column_type_id = seahorse_pkcs11_generate_column_get_type_once ();
		g_once_init_leave (&seahorse_pkcs11_generate_column_type_id__once, seahorse_pkcs11_generate_column_type_id);
	}
	return seahorse_pkcs11_generate_column_type_id__once;
}

SeahorsePkcs11Generate*
seahorse_pkcs11_generate_construct (GType object_type,
                                    GtkWindow* parent)
{
	SeahorsePkcs11Generate * self = NULL;
	self = (SeahorsePkcs11Generate*) g_object_new (object_type, "transient-for", parent, NULL);
	return self;
}

SeahorsePkcs11Generate*
seahorse_pkcs11_generate_new (GtkWindow* parent)
{
	return seahorse_pkcs11_generate_construct (SEAHORSE_PKCS11_TYPE_GENERATE, parent);
}

static void
seahorse_pkcs11_generate_update_response (SeahorsePkcs11Generate* self)
{
	gboolean _tmp0_ = FALSE;
	SeahorsePkcs11Token* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->token;
	if (_tmp1_ != NULL) {
		GckMechanism* _tmp2_;
		_tmp2_ = self->priv->mechanism;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	gtk_dialog_set_response_sensitive ((GtkDialog*) self, (gint) GTK_RESPONSE_OK, _tmp0_);
}

static const gchar*
seahorse_pkcs11_generate_get_available_mechanism_label (SeahorsePkcs11Generate* self,
                                                        gulong type)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		SeahorsePkcs11GenerateMechanism* mechanism_collection = NULL;
		gint mechanism_collection_length1 = 0;
		gint _mechanism_collection_size_ = 0;
		gint mechanism_it = 0;
		mechanism_collection = SEAHORSE_PKCS11_GENERATE_AVAILABLE_MECHANISMS;
		mechanism_collection_length1 = G_N_ELEMENTS (SEAHORSE_PKCS11_GENERATE_AVAILABLE_MECHANISMS);
		for (mechanism_it = 0; mechanism_it < mechanism_collection_length1; mechanism_it = mechanism_it + 1) {
			SeahorsePkcs11GenerateMechanism mechanism = {0};
			mechanism = mechanism_collection[mechanism_it];
			{
				SeahorsePkcs11GenerateMechanism _tmp0_;
				_tmp0_ = mechanism;
				if (_tmp0_.mechanism_type == type) {
					SeahorsePkcs11GenerateMechanism _tmp1_;
					const gchar* _tmp2_;
					_tmp1_ = mechanism;
					_tmp2_ = _tmp1_.label;
					result = _tmp2_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
seahorse_pkcs11_generate_on_token_changed (SeahorsePkcs11Generate* self,
                                           GtkComboBox* combo_box)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gboolean valid = FALSE;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	gboolean _tmp8_;
	SeahorsePkcs11Token* _tmp9_;
	GtkComboBox* _tmp34_;
	GtkTreeIter _tmp35_ = {0};
	gboolean _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo_box != NULL);
	_g_object_unref0 (self->priv->token);
	self->priv->token = NULL;
	_tmp1_ = gtk_combo_box_get_active_iter (combo_box, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		GcrCollectionModel* _tmp2_;
		GtkTreeIter _tmp3_;
		GObject* _tmp4_;
		SeahorsePkcs11Token* _tmp5_;
		_tmp2_ = self->priv->token_model;
		_tmp3_ = iter;
		_tmp4_ = gcr_collection_model_object_for_iter (_tmp2_, &_tmp3_);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token));
		_g_object_unref0 (self->priv->token);
		self->priv->token = _tmp5_;
	}
	_tmp6_ = self->priv->mechanism_store;
	_tmp8_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp6_, &_tmp7_);
	iter = _tmp7_;
	valid = _tmp8_;
	_tmp9_ = self->priv->token;
	if (_tmp9_ != NULL) {
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					SeahorsePkcs11Token* _tmp12_;
					GArray* _tmp13_;
					GArray* _tmp14_;
					gulong type = 0UL;
					SeahorsePkcs11Token* _tmp15_;
					GArray* _tmp16_;
					GArray* _tmp17_;
					const gchar* label = NULL;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					GtkListStore* _tmp27_;
					GtkTreeIter _tmp28_;
					const gchar* _tmp29_;
					GtkListStore* _tmp30_;
					gboolean _tmp31_;
					if (!_tmp10_) {
						guint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = self->priv->token;
					_tmp13_ = seahorse_pkcs11_token_get_mechanisms (_tmp12_);
					_tmp14_ = _tmp13_;
					if (!(i < _tmp14_->len)) {
						break;
					}
					_tmp15_ = self->priv->token;
					_tmp16_ = seahorse_pkcs11_token_get_mechanisms (_tmp15_);
					_tmp17_ = _tmp16_;
					type = g_array_index (_tmp17_, gulong, i);
					_tmp18_ = seahorse_pkcs11_generate_get_available_mechanism_label (self, type);
					label = _tmp18_;
					_tmp19_ = label;
					if (_tmp19_ == NULL) {
						continue;
					}
					while (TRUE) {
						gulong otype = 0UL;
						GtkListStore* _tmp20_;
						GtkTreeIter _tmp21_;
						gulong _tmp22_ = 0UL;
						GtkListStore* _tmp23_;
						gboolean _tmp24_;
						if (!valid) {
							break;
						}
						_tmp20_ = self->priv->mechanism_store;
						_tmp21_ = iter;
						gtk_tree_model_get ((GtkTreeModel*) _tmp20_, &_tmp21_, SEAHORSE_PKCS11_GENERATE_COLUMN_TYPE, &_tmp22_, -1);
						otype = _tmp22_;
						if (otype == type) {
							break;
						}
						_tmp23_ = self->priv->mechanism_store;
						_tmp24_ = gtk_list_store_remove (_tmp23_, &iter);
						valid = _tmp24_;
					}
					if (!valid) {
						GtkListStore* _tmp25_;
						GtkTreeIter _tmp26_ = {0};
						_tmp25_ = self->priv->mechanism_store;
						gtk_list_store_append (_tmp25_, &_tmp26_);
						iter = _tmp26_;
					}
					_tmp27_ = self->priv->mechanism_store;
					_tmp28_ = iter;
					_tmp29_ = label;
					gtk_list_store_set (_tmp27_, &_tmp28_, SEAHORSE_PKCS11_GENERATE_COLUMN_TYPE, type, SEAHORSE_PKCS11_GENERATE_COLUMN_LABEL, _tmp29_, -1);
					_tmp30_ = self->priv->mechanism_store;
					_tmp31_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp30_, &iter);
					valid = _tmp31_;
				}
			}
		}
	}
	while (TRUE) {
		GtkListStore* _tmp32_;
		gboolean _tmp33_;
		if (!valid) {
			break;
		}
		_tmp32_ = self->priv->mechanism_store;
		_tmp33_ = gtk_list_store_remove (_tmp32_, &iter);
		valid = _tmp33_;
	}
	_tmp34_ = self->priv->mechanism_box;
	_tmp36_ = gtk_combo_box_get_active_iter (_tmp34_, &_tmp35_);
	iter = _tmp35_;
	if (!_tmp36_) {
		GtkListStore* _tmp37_;
		GtkTreeIter _tmp38_ = {0};
		gboolean _tmp39_;
		_tmp37_ = self->priv->mechanism_store;
		_tmp39_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp37_, &_tmp38_);
		iter = _tmp38_;
		if (_tmp39_) {
			GtkComboBox* _tmp40_;
			GtkTreeIter _tmp41_;
			_tmp40_ = self->priv->mechanism_box;
			_tmp41_ = iter;
			gtk_combo_box_set_active_iter (_tmp40_, &_tmp41_);
		}
	}
	seahorse_pkcs11_generate_update_response (self);
}

static GckMechanism*
_gck_mechanism_dup (GckMechanism* self)
{
	GckMechanism* dup;
	dup = g_new0 (GckMechanism, 1);
	memcpy (dup, self, sizeof (GckMechanism));
	return dup;
}

static gpointer
__gck_mechanism_dup0 (gpointer self)
{
	return self ? _gck_mechanism_dup (self) : NULL;
}

static void
_vala_GckMechanismInfo_free (GckMechanismInfo* self)
{
	g_boxed_free (gck_mechanism_info_get_type (), self);
}

static void
seahorse_pkcs11_generate_on_mechanism_changed (SeahorsePkcs11Generate* self,
                                               GtkComboBox* widget)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkSpinButton* _tmp20_;
	GckMechanism* _tmp21_;
	g_return_if_fail (self != NULL);
	_g_free0 (self->priv->mechanism);
	self->priv->mechanism = NULL;
	_tmp1_ = gtk_combo_box_get_active_iter (widget, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_) {
		GckMechanism _tmp2_ = {0};
		GckMechanism* _tmp3_;
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		GckMechanism* _tmp6_;
		gulong _tmp7_ = 0UL;
		GckSlot* slot = NULL;
		SeahorsePkcs11Token* _tmp8_;
		GckSlot* _tmp9_;
		GckSlot* _tmp10_;
		GckSlot* _tmp11_;
		GckMechanismInfo* info = NULL;
		GckSlot* _tmp12_;
		GckMechanism* _tmp13_;
		GckMechanismInfo* _tmp14_;
		gulong min = 0UL;
		GckMechanismInfo* _tmp15_;
		gulong max = 0UL;
		GckMechanismInfo* _tmp16_;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		GtkSpinButton* _tmp19_;
		memset (&_tmp2_, 0, sizeof (GckMechanism));
		_tmp3_ = __gck_mechanism_dup0 (&_tmp2_);
		_g_free0 (self->priv->mechanism);
		self->priv->mechanism = _tmp3_;
		_tmp4_ = self->priv->mechanism_store;
		_tmp5_ = iter;
		_tmp6_ = self->priv->mechanism;
		gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, SEAHORSE_PKCS11_GENERATE_COLUMN_TYPE, &_tmp7_, -1);
		(*_tmp6_).type = _tmp7_;
		_tmp8_ = self->priv->token;
		_tmp9_ = seahorse_pkcs11_token_get_slot (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		slot = _tmp11_;
		_tmp12_ = slot;
		_tmp13_ = self->priv->mechanism;
		_tmp14_ = gck_slot_get_mechanism_info (_tmp12_, (*_tmp13_).type);
		info = _tmp14_;
		_tmp15_ = info;
		min = _tmp15_->min_key_size;
		_tmp16_ = info;
		max = _tmp16_->max_key_size;
		if (min < ((gulong) 512)) {
			_tmp17_ = max >= ((gulong) 512);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			min = (gulong) 512;
		}
		if (max > ((gulong) 16384)) {
			_tmp18_ = min <= ((gulong) 16384);
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			max = (gulong) 16384;
		}
		_tmp19_ = self->priv->key_bits;
		gtk_spin_button_set_range (_tmp19_, (gdouble) min, (gdouble) max);
		__vala_GckMechanismInfo_free0 (info);
		_g_object_unref0 (slot);
	}
	_tmp20_ = self->priv->key_bits;
	_tmp21_ = self->priv->mechanism;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, _tmp21_ != NULL);
	seahorse_pkcs11_generate_update_response (self);
}

static gint
seahorse_pkcs11_generate_on_mechanism_sort (SeahorsePkcs11Generate* self,
                                            GtkTreeModel* model,
                                            GtkTreeIter* a,
                                            GtkTreeIter* b)
{
	gchar* label_a = NULL;
	gchar* label_b = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	GtkTreeIter _tmp2_;
	gchar* _tmp3_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = *a;
	gtk_tree_model_get (model, &_tmp0_, SEAHORSE_PKCS11_GENERATE_COLUMN_LABEL, &_tmp1_, -1);
	_g_free0 (label_a);
	label_a = _tmp1_;
	_tmp2_ = *b;
	gtk_tree_model_get (model, &_tmp2_, SEAHORSE_PKCS11_GENERATE_COLUMN_LABEL, &_tmp3_, -1);
	_g_free0 (label_b);
	label_b = _tmp3_;
	result = g_utf8_collate (label_a, label_b);
	_g_free0 (label_b);
	_g_free0 (label_a);
	return result;
}

static void
seahorse_pkcs11_generate_real_response (GtkDialog* base,
                                        gint response_id)
{
	SeahorsePkcs11Generate * self;
	self = (SeahorsePkcs11Generate*) base;
	if (response_id == ((gint) GTK_RESPONSE_OK)) {
		seahorse_pkcs11_generate_generate (self, NULL, NULL);
	}
	gtk_widget_hide ((GtkWidget*) self);
}

static void
seahorse_pkcs11_generate_generate_data_free (gpointer _data)
{
	SeahorsePkcs11GenerateGenerateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorsePkcs11GenerateGenerateData, _data_);
}

static void
seahorse_pkcs11_generate_generate (SeahorsePkcs11Generate* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	SeahorsePkcs11GenerateGenerateData* _data_;
	SeahorsePkcs11Generate* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SeahorsePkcs11GenerateGenerateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_pkcs11_generate_generate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	seahorse_pkcs11_generate_generate_co (_data_);
}

static void
seahorse_pkcs11_generate_generate_finish (SeahorsePkcs11Generate* self,
                                          GAsyncResult* _res_)
{
	SeahorsePkcs11GenerateGenerateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
seahorse_pkcs11_generate_generate_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	SeahorsePkcs11GenerateGenerateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_pkcs11_generate_generate_co (_data_);
}

static gboolean
seahorse_pkcs11_generate_generate_co (SeahorsePkcs11GenerateGenerateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->token;
	_vala_assert (_data_->_tmp0_ != NULL, "this.token != null");
	seahorse_pkcs11_generate_prepare_generate (_data_->self);
	_data_->_tmp1_ = gtk_window_get_transient_for ((GtkWindow*) _data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = seahorse_interaction_new (_data_->_tmp2_);
	_data_->interaction = (GTlsInteraction*) _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->cancellable;
	seahorse_progress_show (_data_->_tmp4_, _ ("Generating key"), FALSE);
	{
		_data_->_tmp5_ = _data_->self->priv->token;
		_data_->_tmp6_ = seahorse_pkcs11_token_get_slot (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->interaction;
		_data_->_tmp9_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		gck_session_open_async (_data_->_tmp7_, GCK_SESSION_READ_WRITE | GCK_SESSION_LOGIN_USER, _data_->_tmp8_, _data_->_tmp9_, seahorse_pkcs11_generate_generate_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = gck_session_open_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->session = _data_->_tmp10_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp11_ = _data_->session;
		_data_->_tmp12_ = _data_->self->priv->mechanism;
		_data_->_tmp13_ = _data_->self->priv->pub_attrs;
		_data_->_tmp14_ = _data_->self->priv->prv_attrs;
		_data_->_tmp15_ = _data_->self->priv->cancellable;
		_data_->_tmp16_ = *_data_->_tmp12_;
		_data_->_tmp17_ = NULL;
		_data_->_tmp18_ = NULL;
		_data_->_state_ = 2;
		gck_session_generate_key_pair_async (_data_->_tmp11_, &_data_->_tmp16_, _data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_, seahorse_pkcs11_generate_generate_ready, _data_);
		return FALSE;
		_state_2:
		gck_session_generate_key_pair_finish (_data_->_tmp11_, _data_->_res_, &_data_->_tmp17_, &_data_->_tmp18_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->pub);
		_data_->pub = _data_->_tmp17_;
		_g_object_unref0 (_data_->priv);
		_data_->priv = _data_->_tmp18_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->priv);
			_g_object_unref0 (_data_->pub);
			_g_object_unref0 (_data_->session);
			goto __catch0_g_error;
		}
		_data_->_tmp19_ = _data_->self->priv->token;
		_data_->_tmp20_ = _data_->self->priv->cancellable;
		_data_->_state_ = 3;
		seahorse_place_load ((SeahorsePlace*) _data_->_tmp19_, _data_->_tmp20_, seahorse_pkcs11_generate_generate_ready, _data_);
		return FALSE;
		_state_3:
		seahorse_place_load_finish ((SeahorsePlace*) _data_->_tmp19_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->priv);
			_g_object_unref0 (_data_->pub);
			_g_object_unref0 (_data_->session);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->self->priv->cancellable);
		_data_->self->priv->cancellable = NULL;
		_gck_attributes_unref0 (_data_->self->priv->prv_attrs);
		_data_->self->priv->prv_attrs = NULL;
		_data_->_tmp21_ = _data_->self->priv->prv_attrs;
		_data_->_tmp22_ = _gck_attributes_ref0 (_data_->_tmp21_);
		_gck_attributes_unref0 (_data_->self->priv->pub_attrs);
		_data_->self->priv->pub_attrs = _data_->_tmp22_;
		_g_object_unref0 (_data_->priv);
		_g_object_unref0 (_data_->pub);
		_g_object_unref0 (_data_->session);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp23_ = _data_->e;
		_data_->_tmp24_ = _data_->_tmp23_->message;
		seahorse_util_show_error (NULL, _ ("Couldn’t generate private key"), _data_->_tmp24_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->interaction);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->interaction);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_GckBuilder_free (GckBuilder* self)
{
	g_boxed_free (gck_builder_get_type (), self);
}

static void
seahorse_pkcs11_generate_prepare_generate (SeahorsePkcs11Generate* self)
{
	static const guchar rsa_public_exponent[3] = {(guchar) 0x01, (guchar) 0x00, (guchar) 0x01};
	GckBuilder* publi = NULL;
	GckBuilder* _tmp0_;
	GckBuilder* priva = NULL;
	GckBuilder* _tmp1_;
	GCancellable* _tmp2_;
	GckMechanism* _tmp3_;
	GckBuilder* _tmp4_;
	GckBuilder* _tmp5_;
	GckBuilder* _tmp6_;
	GckBuilder* _tmp7_;
	GckBuilder* _tmp8_;
	GckBuilder* _tmp9_;
	gchar* label = NULL;
	GtkEntry* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GckBuilder* _tmp14_;
	const gchar* _tmp15_;
	GckBuilder* _tmp16_;
	const gchar* _tmp17_;
	GckMechanism* _tmp18_;
	GckBuilder* _tmp28_;
	GckAttributes* _tmp29_;
	GckBuilder* _tmp30_;
	GckAttributes* _tmp31_;
	GckBuilder* _tmp32_;
	GckBuilder* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gck_builder_new (GCK_BUILDER_SECURE_MEMORY);
	publi = _tmp0_;
	_tmp1_ = gck_builder_new (GCK_BUILDER_SECURE_MEMORY);
	priva = _tmp1_;
	_tmp2_ = self->priv->cancellable;
	_vala_assert (_tmp2_ == NULL, "this.cancellable == null");
	_tmp3_ = self->priv->mechanism;
	_vala_assert (_tmp3_ != NULL, "this.mechanism != null");
	_tmp4_ = publi;
	gck_builder_add_ulong (_tmp4_, (gulong) CKA_CLASS, (gulong) CKO_PUBLIC_KEY);
	_tmp5_ = priva;
	gck_builder_add_ulong (_tmp5_, (gulong) CKA_CLASS, (gulong) CKO_PRIVATE_KEY);
	_tmp6_ = publi;
	gck_builder_add_boolean (_tmp6_, (gulong) CKA_TOKEN, TRUE);
	_tmp7_ = priva;
	gck_builder_add_boolean (_tmp7_, (gulong) CKA_TOKEN, TRUE);
	_tmp8_ = priva;
	gck_builder_add_boolean (_tmp8_, (gulong) CKA_PRIVATE, TRUE);
	_tmp9_ = priva;
	gck_builder_add_boolean (_tmp9_, (gulong) CKA_SENSITIVE, TRUE);
	_tmp10_ = self->priv->label_entry;
	_tmp11_ = gtk_entry_get_text (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	label = _tmp13_;
	_tmp14_ = publi;
	_tmp15_ = label;
	gck_builder_add_string (_tmp14_, (gulong) CKA_LABEL, _tmp15_);
	_tmp16_ = priva;
	_tmp17_ = label;
	gck_builder_add_string (_tmp16_, (gulong) CKA_LABEL, _tmp17_);
	_tmp18_ = self->priv->mechanism;
	if ((*_tmp18_).type == ((gulong) CKM_RSA_PKCS_KEY_PAIR_GEN)) {
		GckBuilder* _tmp19_;
		GckBuilder* _tmp20_;
		GckBuilder* _tmp21_;
		GckBuilder* _tmp22_;
		GckBuilder* _tmp23_;
		GckBuilder* _tmp24_;
		GckBuilder* _tmp25_;
		GckBuilder* _tmp26_;
		GtkSpinButton* _tmp27_;
		_tmp19_ = publi;
		gck_builder_add_boolean (_tmp19_, (gulong) CKA_ENCRYPT, TRUE);
		_tmp20_ = publi;
		gck_builder_add_boolean (_tmp20_, (gulong) CKA_VERIFY, TRUE);
		_tmp21_ = publi;
		gck_builder_add_boolean (_tmp21_, (gulong) CKA_WRAP, TRUE);
		_tmp22_ = priva;
		gck_builder_add_boolean (_tmp22_, (gulong) CKA_DECRYPT, TRUE);
		_tmp23_ = priva;
		gck_builder_add_boolean (_tmp23_, (gulong) CKA_SIGN, TRUE);
		_tmp24_ = priva;
		gck_builder_add_boolean (_tmp24_, (gulong) CKA_UNWRAP, TRUE);
		_tmp25_ = publi;
		gck_builder_add_data (_tmp25_, (gulong) CKA_PUBLIC_EXPONENT, rsa_public_exponent, (gsize) G_N_ELEMENTS (rsa_public_exponent));
		_tmp26_ = publi;
		_tmp27_ = self->priv->key_bits;
		gck_builder_add_ulong (_tmp26_, (gulong) CKA_MODULUS_BITS, (gulong) gtk_spin_button_get_value_as_int (_tmp27_));
	} else {
		g_warning ("pkcs11-generate.vala:267: currently no support for this mechanism");
	}
	_tmp28_ = priva;
	_tmp29_ = gck_builder_steal (_tmp28_);
	_gck_attributes_unref0 (self->priv->prv_attrs);
	self->priv->prv_attrs = _tmp29_;
	_tmp30_ = publi;
	_tmp31_ = gck_builder_steal (_tmp30_);
	_gck_attributes_unref0 (self->priv->pub_attrs);
	self->priv->pub_attrs = _tmp31_;
	_tmp32_ = publi;
	gck_builder_clear (_tmp32_);
	_tmp33_ = priva;
	gck_builder_clear (_tmp33_);
	_g_free0 (label);
	__vala_GckBuilder_free0 (priva);
	__vala_GckBuilder_free0 (publi);
}

static SeahorsePkcs11GenerateMechanism*
seahorse_pkcs11_generate_mechanism_dup (const SeahorsePkcs11GenerateMechanism* self)
{
	SeahorsePkcs11GenerateMechanism* dup;
	dup = g_new0 (SeahorsePkcs11GenerateMechanism, 1);
	memcpy (dup, self, sizeof (SeahorsePkcs11GenerateMechanism));
	return dup;
}

static void
seahorse_pkcs11_generate_mechanism_free (SeahorsePkcs11GenerateMechanism* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
seahorse_pkcs11_generate_mechanism_get_type_once (void)
{
	GType seahorse_pkcs11_generate_mechanism_type_id;
	seahorse_pkcs11_generate_mechanism_type_id = g_boxed_type_register_static ("SeahorsePkcs11GenerateMechanism", (GBoxedCopyFunc) seahorse_pkcs11_generate_mechanism_dup, (GBoxedFreeFunc) seahorse_pkcs11_generate_mechanism_free);
	return seahorse_pkcs11_generate_mechanism_type_id;
}

static GType
seahorse_pkcs11_generate_mechanism_get_type (void)
{
	static volatile gsize seahorse_pkcs11_generate_mechanism_type_id__once = 0;
	if (g_once_init_enter (&seahorse_pkcs11_generate_mechanism_type_id__once)) {
		GType seahorse_pkcs11_generate_mechanism_type_id;
		seahorse_pkcs11_generate_mechanism_type_id = seahorse_pkcs11_generate_mechanism_get_type_once ();
		g_once_init_leave (&seahorse_pkcs11_generate_mechanism_type_id__once, seahorse_pkcs11_generate_mechanism_type_id);
	}
	return seahorse_pkcs11_generate_mechanism_type_id__once;
}

static gint
_seahorse_pkcs11_generate_on_mechanism_sort_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                        GtkTreeIter* a,
                                                                        GtkTreeIter* b,
                                                                        gpointer self)
{
	gint result;
	result = seahorse_pkcs11_generate_on_mechanism_sort ((SeahorsePkcs11Generate*) self, model, a, b);
	return result;
}

static void
_seahorse_pkcs11_generate_on_mechanism_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                      gpointer self)
{
	seahorse_pkcs11_generate_on_mechanism_changed ((SeahorsePkcs11Generate*) self, _sender);
}

static void
_seahorse_pkcs11_generate_on_token_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                  gpointer self)
{
	seahorse_pkcs11_generate_on_token_changed ((SeahorsePkcs11Generate*) self, _sender);
}

static GObject *
seahorse_pkcs11_generate_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorsePkcs11Generate * self;
	GtkSpinButton* _tmp0_;
	GtkSpinButton* _tmp1_;
	GtkSpinButton* _tmp2_;
	GtkListStore* _tmp3_;
	GtkListStore* _tmp4_;
	GtkListStore* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkListStore* _tmp7_;
	GtkCellRenderer* renderer = NULL;
	GtkCellRendererText* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRenderer* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkCellRenderer* _tmp12_;
	GtkComboBox* _tmp13_;
	GcrCollection* collection = NULL;
	GcrCollection* _tmp14_;
	GcrCollection* _tmp15_;
	GcrCollectionModel* _tmp16_;
	GcrCollectionModel* _tmp17_;
	GtkComboBox* _tmp18_;
	GcrCollectionModel* _tmp19_;
	GtkCellRendererPixbuf* icon_renderer = NULL;
	GtkCellRendererPixbuf* _tmp20_;
	GtkCellRendererPixbuf* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkCellRendererPixbuf* _tmp23_;
	GtkComboBox* _tmp24_;
	GtkCellRendererPixbuf* _tmp25_;
	GtkCellRendererText* _tmp26_;
	GtkComboBox* _tmp27_;
	GtkCellRenderer* _tmp28_;
	GtkComboBox* _tmp29_;
	GtkCellRenderer* _tmp30_;
	GtkComboBox* _tmp31_;
	GcrCollection* _tmp32_;
	parent_class = G_OBJECT_CLASS (seahorse_pkcs11_generate_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_GENERATE, SeahorsePkcs11Generate);
	g_object_set ((GtkDialog*) self, "use-header-bar", 1, NULL);
	_tmp0_ = self->priv->key_bits;
	gtk_spin_button_set_range (_tmp0_, (gdouble) 0, (gdouble) G_MAXINT);
	_tmp1_ = self->priv->key_bits;
	gtk_spin_button_set_increments (_tmp1_, (gdouble) 128, (gdouble) 128);
	_tmp2_ = self->priv->key_bits;
	gtk_spin_button_set_value (_tmp2_, (gdouble) 2048);
	_tmp3_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_ULONG, -1);
	_g_object_unref0 (self->priv->mechanism_store);
	self->priv->mechanism_store = _tmp3_;
	_tmp4_ = self->priv->mechanism_store;
	gtk_tree_sortable_set_default_sort_func ((GtkTreeSortable*) _tmp4_, _seahorse_pkcs11_generate_on_mechanism_sort_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	_tmp5_ = self->priv->mechanism_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp5_, GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, GTK_SORT_ASCENDING);
	_tmp6_ = self->priv->mechanism_box;
	_tmp7_ = self->priv->mechanism_store;
	gtk_combo_box_set_model (_tmp6_, (GtkTreeModel*) _tmp7_);
	_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp8_);
	renderer = (GtkCellRenderer*) _tmp8_;
	_tmp9_ = self->priv->mechanism_box;
	_tmp10_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp9_, _tmp10_, TRUE);
	_tmp11_ = self->priv->mechanism_box;
	_tmp12_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp11_, _tmp12_, "markup", (gint) SEAHORSE_PKCS11_GENERATE_COLUMN_LABEL);
	_tmp13_ = self->priv->mechanism_box;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) _seahorse_pkcs11_generate_on_mechanism_changed_gtk_combo_box_changed, self, 0);
	_tmp14_ = seahorse_pkcs11_backend_get_writable_tokens (NULL, (gulong) CKM_RSA_PKCS_KEY_PAIR_GEN);
	collection = _tmp14_;
	_tmp15_ = collection;
	_tmp16_ = gcr_collection_model_new (_tmp15_, GCR_COLLECTION_MODEL_LIST, "icon", g_icon_get_type (), "label", G_TYPE_STRING, NULL, NULL);
	_g_object_unref0 (self->priv->token_model);
	self->priv->token_model = _tmp16_;
	_tmp17_ = self->priv->token_model;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp17_, 1, GTK_SORT_ASCENDING);
	_tmp18_ = self->priv->token_box;
	_tmp19_ = self->priv->token_model;
	gtk_combo_box_set_model (_tmp18_, (GtkTreeModel*) _tmp19_);
	_tmp20_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp20_);
	icon_renderer = _tmp20_;
	_tmp21_ = icon_renderer;
	g_object_set (_tmp21_, "stock-size", (guint) GTK_ICON_SIZE_BUTTON, NULL);
	_tmp22_ = self->priv->token_box;
	_tmp23_ = icon_renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp22_, (GtkCellRenderer*) _tmp23_, FALSE);
	_tmp24_ = self->priv->token_box;
	_tmp25_ = icon_renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp24_, (GtkCellRenderer*) _tmp25_, "gicon", 0);
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp26_);
	_g_object_unref0 (renderer);
	renderer = (GtkCellRenderer*) _tmp26_;
	_tmp27_ = self->priv->token_box;
	_tmp28_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, _tmp28_, TRUE);
	_tmp29_ = self->priv->token_box;
	_tmp30_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp29_, _tmp30_, "text", 1);
	_tmp31_ = self->priv->token_box;
	g_signal_connect_object (_tmp31_, "changed", (GCallback) _seahorse_pkcs11_generate_on_token_changed_gtk_combo_box_changed, self, 0);
	_tmp32_ = collection;
	if (gcr_collection_get_length (_tmp32_) > ((guint) 0)) {
		GtkComboBox* _tmp33_;
		_tmp33_ = self->priv->token_box;
		gtk_combo_box_set_active (_tmp33_, 0);
	}
	gtk_dialog_set_default_response ((GtkDialog*) self, (gint) GTK_RESPONSE_OK);
	seahorse_pkcs11_generate_update_response (self);
	_g_object_unref0 (icon_renderer);
	_g_object_unref0 (collection);
	_g_object_unref0 (renderer);
	return obj;
}

static void
seahorse_pkcs11_generate_class_init (SeahorsePkcs11GenerateClass * klass,
                                     gpointer klass_data)
{
	seahorse_pkcs11_generate_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorsePkcs11Generate_private_offset);
	((GtkDialogClass *) klass)->response = (void (*) (GtkDialog*, gint)) seahorse_pkcs11_generate_real_response;
	G_OBJECT_CLASS (klass)->constructor = seahorse_pkcs11_generate_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_pkcs11_generate_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Seahorse/seahorse-pkcs11-generate.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_entry", FALSE, SeahorsePkcs11Generate_private_offset + G_STRUCT_OFFSET (SeahorsePkcs11GeneratePrivate, label_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "token_box", FALSE, SeahorsePkcs11Generate_private_offset + G_STRUCT_OFFSET (SeahorsePkcs11GeneratePrivate, token_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mechanism_box", FALSE, SeahorsePkcs11Generate_private_offset + G_STRUCT_OFFSET (SeahorsePkcs11GeneratePrivate, mechanism_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "key_bits", FALSE, SeahorsePkcs11Generate_private_offset + G_STRUCT_OFFSET (SeahorsePkcs11GeneratePrivate, key_bits));
}

static void
seahorse_pkcs11_generate_instance_init (SeahorsePkcs11Generate * self,
                                        gpointer klass)
{
	self->priv = seahorse_pkcs11_generate_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
seahorse_pkcs11_generate_finalize (GObject * obj)
{
	SeahorsePkcs11Generate * self;
	GckAttributes* _tmp0_;
	GckAttributes* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_GENERATE, SeahorsePkcs11Generate);
	_g_object_unref0 (self->priv->token);
	self->priv->token = NULL;
	_g_object_unref0 (self->priv->token_model);
	self->priv->token_model = NULL;
	_g_free0 (self->priv->mechanism);
	self->priv->mechanism = NULL;
	_g_object_unref0 (self->priv->mechanism_store);
	self->priv->mechanism_store = NULL;
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = NULL;
	_gck_attributes_unref0 (self->priv->prv_attrs);
	self->priv->prv_attrs = NULL;
	_tmp0_ = self->priv->prv_attrs;
	_tmp1_ = _gck_attributes_ref0 (_tmp0_);
	_gck_attributes_unref0 (self->priv->pub_attrs);
	self->priv->pub_attrs = _tmp1_;
	_g_object_unref0 (self->priv->token);
	_g_object_unref0 (self->priv->token_model);
	_g_free0 (self->priv->mechanism);
	_g_object_unref0 (self->priv->mechanism_store);
	_g_object_unref0 (self->priv->cancellable);
	_gck_attributes_unref0 (self->priv->pub_attrs);
	_gck_attributes_unref0 (self->priv->prv_attrs);
	G_OBJECT_CLASS (seahorse_pkcs11_generate_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_pkcs11_generate_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorsePkcs11GenerateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pkcs11_generate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePkcs11Generate), 0, (GInstanceInitFunc) seahorse_pkcs11_generate_instance_init, NULL };
	GType seahorse_pkcs11_generate_type_id;
	seahorse_pkcs11_generate_type_id = g_type_register_static (gtk_dialog_get_type (), "SeahorsePkcs11Generate", &g_define_type_info, 0);
	SeahorsePkcs11Generate_private_offset = g_type_add_instance_private (seahorse_pkcs11_generate_type_id, sizeof (SeahorsePkcs11GeneratePrivate));
	return seahorse_pkcs11_generate_type_id;
}

GType
seahorse_pkcs11_generate_get_type (void)
{
	static volatile gsize seahorse_pkcs11_generate_type_id__once = 0;
	if (g_once_init_enter (&seahorse_pkcs11_generate_type_id__once)) {
		GType seahorse_pkcs11_generate_type_id;
		seahorse_pkcs11_generate_type_id = seahorse_pkcs11_generate_get_type_once ();
		g_once_init_leave (&seahorse_pkcs11_generate_type_id__once, seahorse_pkcs11_generate_type_id);
	}
	return seahorse_pkcs11_generate_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

