/* exportable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from exportable.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2004,2005 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2012 Stefan Walter
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#include "seahorse-common.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef struct _Block2Data Block2Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block5Data Block5Data;

struct _Block2Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* _result_;
};

struct _Block3Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* _result_;
};

struct _Block4Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* _result_;
};

struct _Block5Data {
	int _ref_count_;
	GtkFileChooserNative* chooser;
	GHashTable* filters;
};

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda4_ (Block2Data* _data2_,
                   GObject* obj,
                   GAsyncResult* res);
static void _____lambda4__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda5_ (Block3Data* _data3_,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda5__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ____lambda7_ (Block4Data* _data4_,
                   GObject* obj,
                   GAsyncResult* res);
static void _____lambda7__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gchar* seahorse_exportable_calculate_basename (GFile* file,
                                               const gchar* extension);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda6_ (Block5Data* _data5_,
                 GObject* obj,
                 GParamSpec* prop);
static void ___lambda6__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static GType seahorse_exportable_get_type_once (void);

GList*
seahorse_exportable_create_exporters (SeahorseExportable* self,
                                      SeahorseExporterType type)
{
	SeahorseExportableIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = SEAHORSE_EXPORTABLE_GET_INTERFACE (self);
	if (_iface_->create_exporters) {
		return _iface_->create_exporters (self, type);
	}
	return NULL;
}

gboolean
seahorse_exportable_can_export (GObject* object)
{
	gboolean result;
	g_return_val_if_fail (object != NULL, FALSE);
	if (SEAHORSE_IS_EXPORTABLE (object)) {
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = seahorse_exportable_get_exportable (G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable));
		_tmp1_ = _tmp0_;
		result = _tmp1_;
		return result;
	}
	result = FALSE;
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->_result_);
		_g_main_loop_unref0 (_data2_->loop);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
____lambda4_ (Block2Data* _data2_,
              GObject* obj,
              GAsyncResult* res)
{
	GAsyncResult* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data2_->_result_);
	_data2_->_result_ = _tmp0_;
	_tmp1_ = _data2_->loop;
	g_main_loop_quit (_tmp1_);
}

static void
_____lambda4__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	____lambda4_ (self, source_object, res);
	block2_data_unref (self);
}

gint
seahorse_exportable_export_to_directory_wait (GList* objects,
                                              const gchar* directory,
                                              GError** error)
{
	Block2Data* _data2_;
	GMainLoop* _tmp0_;
	gint count = 0;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (directory != NULL, 0);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data2_->loop = _tmp0_;
	_data2_->_result_ = NULL;
	count = 0;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = objects;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp1_;
			GObject* object = NULL;
			_tmp1_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp1_;
			{
				GObject* _tmp2_;
				GList* exporters = NULL;
				GObject* _tmp3_;
				GList* _tmp4_;
				GList* _tmp5_;
				SeahorseExporter* exporter = NULL;
				GList* _tmp6_;
				gconstpointer _tmp7_;
				SeahorseExporter* _tmp8_;
				gchar* filename = NULL;
				SeahorseExporter* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				GFile* file = NULL;
				const gchar* _tmp15_;
				GFile* _tmp16_;
				SeahorseExporter* _tmp17_;
				GFile* _tmp18_;
				GMainLoop* _tmp19_;
				SeahorseExporter* _tmp20_;
				GAsyncResult* _tmp21_;
				gint _tmp23_;
				_tmp2_ = object;
				if (!seahorse_exportable_can_export (_tmp2_)) {
					_g_object_unref0 (object);
					continue;
				}
				_tmp3_ = object;
				_tmp4_ = seahorse_exportable_create_exporters (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable), SEAHORSE_EXPORTER_TYPE_ANY);
				exporters = _tmp4_;
				_tmp5_ = exporters;
				if (_tmp5_ == NULL) {
					(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
					_g_object_unref0 (object);
					continue;
				}
				_tmp6_ = exporters;
				_tmp7_ = _tmp6_->data;
				_tmp8_ = _g_object_ref0 ((SeahorseExporter*) _tmp7_);
				exporter = _tmp8_;
				_tmp9_ = exporter;
				_tmp10_ = seahorse_exporter_get_filename (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_tmp13_ = g_build_filename (directory, _tmp12_, NULL, NULL);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				filename = _tmp14_;
				_tmp15_ = filename;
				_tmp16_ = g_file_new_for_uri (_tmp15_);
				file = _tmp16_;
				_tmp17_ = exporter;
				_tmp18_ = file;
				seahorse_exporter_export_to_file (_tmp17_, _tmp18_, FALSE, NULL, _____lambda4__gasync_ready_callback, block2_data_ref (_data2_));
				_tmp19_ = _data2_->loop;
				g_main_loop_run (_tmp19_);
				_tmp20_ = exporter;
				_tmp21_ = _data2_->_result_;
				seahorse_exporter_export_to_file_finish (_tmp20_, _tmp21_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gint _tmp22_ = -1;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (file);
					_g_free0 (filename);
					_g_object_unref0 (exporter);
					(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
					_g_object_unref0 (object);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return _tmp22_;
				}
				_tmp23_ = count;
				count = _tmp23_ + 1;
				_g_object_unref0 (file);
				_g_free0 (filename);
				_g_object_unref0 (exporter);
				(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
				_g_object_unref0 (object);
			}
		}
	}
	result = count;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->_result_);
		_g_main_loop_unref0 (_data3_->loop);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda5_ (Block3Data* _data3_,
             GObject* obj,
             GAsyncResult* res)
{
	GAsyncResult* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data3_->_result_);
	_data3_->_result_ = _tmp0_;
	_tmp1_ = _data3_->loop;
	g_main_loop_quit (_tmp1_);
}

static void
____lambda5__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda5_ (self, source_object, res);
	block3_data_unref (self);
}

guint
seahorse_exportable_export_to_text_wait (GList* objects,
                                         guint8** output,
                                         size_t* output_length1,
                                         GError** error)
{
	guint8* _vala_output = NULL;
	size_t _vala_output_length1 = 0;
	GList* exporters = NULL;
	SeahorseExporter* chosen = NULL;
	guint total = 0U;
	GList* _tmp9_;
	SeahorseExporter* _tmp15_;
	guint8* _tmp26_;
	GError* _inner_error0_ = NULL;
	guint result;
	exporters = NULL;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = objects;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp0_;
			GObject* object = NULL;
			_tmp0_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp0_;
			{
				GObject* _tmp1_;
				GList* _tmp2_;
				_tmp1_ = object;
				if (!seahorse_exportable_can_export (_tmp1_)) {
					_g_object_unref0 (object);
					continue;
				}
				_tmp2_ = exporters;
				if (_tmp2_ != NULL) {
					GList* _tmp3_;
					_tmp3_ = exporters;
					{
						GList* exporter_collection = NULL;
						GList* exporter_it = NULL;
						exporter_collection = _tmp3_;
						for (exporter_it = exporter_collection; exporter_it != NULL; exporter_it = exporter_it->next) {
							SeahorseExporter* _tmp4_;
							SeahorseExporter* exporter = NULL;
							_tmp4_ = _g_object_ref0 ((SeahorseExporter*) exporter_it->data);
							exporter = _tmp4_;
							{
								SeahorseExporter* _tmp5_;
								GObject* _tmp6_;
								_tmp5_ = exporter;
								_tmp6_ = object;
								seahorse_exporter_add_object (_tmp5_, _tmp6_);
								_g_object_unref0 (exporter);
							}
						}
					}
				} else {
					GObject* _tmp7_;
					GList* _tmp8_;
					_tmp7_ = object;
					_tmp8_ = seahorse_exportable_create_exporters (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable), SEAHORSE_EXPORTER_TYPE_TEXTUAL);
					(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
					exporters = _tmp8_;
				}
				_g_object_unref0 (object);
			}
		}
	}
	chosen = NULL;
	total = (guint) 0;
	_tmp9_ = exporters;
	{
		GList* exporter_collection = NULL;
		GList* exporter_it = NULL;
		exporter_collection = _tmp9_;
		for (exporter_it = exporter_collection; exporter_it != NULL; exporter_it = exporter_it->next) {
			SeahorseExporter* _tmp10_;
			SeahorseExporter* exporter = NULL;
			_tmp10_ = _g_object_ref0 ((SeahorseExporter*) exporter_it->data);
			exporter = _tmp10_;
			{
				guint count = 0U;
				SeahorseExporter* _tmp11_;
				GList* _tmp12_;
				_tmp11_ = exporter;
				_tmp12_ = seahorse_exporter_get_objects (_tmp11_);
				count = g_list_length (_tmp12_);
				if (count > total) {
					SeahorseExporter* _tmp13_;
					SeahorseExporter* _tmp14_;
					total = count;
					_tmp13_ = exporter;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_g_object_unref0 (chosen);
					chosen = _tmp14_;
				}
				_g_object_unref0 (exporter);
			}
		}
	}
	_tmp15_ = chosen;
	if (_tmp15_ != NULL) {
		Block3Data* _data3_;
		GMainLoop* _tmp16_;
		SeahorseExporter* _tmp17_;
		GMainLoop* _tmp18_;
		guint8* _tmp19_ = NULL;
		SeahorseExporter* _tmp20_;
		GAsyncResult* _tmp21_;
		size_t _tmp22_ = 0;
		guint8* _tmp23_;
		gint _tmp19__length1;
		gint __tmp19__size_;
		guint8* _tmp25_;
		gint _tmp25__length1;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_tmp16_ = g_main_loop_new (NULL, FALSE);
		_data3_->loop = _tmp16_;
		_data3_->_result_ = NULL;
		_tmp17_ = chosen;
		seahorse_exporter_export (_tmp17_, NULL, ____lambda5__gasync_ready_callback, block3_data_ref (_data3_));
		_tmp18_ = _data3_->loop;
		g_main_loop_run (_tmp18_);
		_tmp20_ = chosen;
		_tmp21_ = _data3_->_result_;
		_tmp23_ = seahorse_exporter_export_finish (_tmp20_, _tmp21_, &_tmp22_, &_inner_error0_);
		_tmp19_ = _tmp23_;
		_tmp19__length1 = _tmp22_;
		__tmp19__size_ = _tmp19__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint _tmp24_ = 0U;
			g_propagate_error (error, _inner_error0_);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			_g_object_unref0 (chosen);
			(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
			_vala_output = (g_free (_vala_output), NULL);
			return _tmp24_;
		}
		_tmp25_ = _tmp19_;
		_tmp25__length1 = _tmp19__length1;
		_tmp19_ = NULL;
		_tmp19__length1 = 0;
		_vala_output = (g_free (_vala_output), NULL);
		_vala_output = _tmp25_;
		_vala_output_length1 = _tmp25__length1;
		result = total;
		_tmp19_ = (g_free (_tmp19_), NULL);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		_g_object_unref0 (chosen);
		(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
		if (output) {
			*output = _vala_output;
		} else {
			_vala_output = (g_free (_vala_output), NULL);
		}
		if (output_length1) {
			*output_length1 = _vala_output_length1;
		}
		return result;
	}
	_tmp26_ = g_new0 (guint8, 0);
	_vala_output = (g_free (_vala_output), NULL);
	_vala_output = _tmp26_;
	_vala_output_length1 = 0;
	result = (guint) 0;
	_g_object_unref0 (chosen);
	(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
	if (output) {
		*output = _vala_output;
	} else {
		_vala_output = (g_free (_vala_output), NULL);
	}
	if (output_length1) {
		*output_length1 = _vala_output_length1;
	}
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->_result_);
		_g_main_loop_unref0 (_data4_->loop);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
____lambda7_ (Block4Data* _data4_,
              GObject* obj,
              GAsyncResult* res)
{
	GAsyncResult* _tmp0_;
	GMainLoop* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data4_->_result_);
	_data4_->_result_ = _tmp0_;
	_tmp1_ = _data4_->loop;
	g_main_loop_quit (_tmp1_);
}

static void
_____lambda7__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	____lambda7_ (self, source_object, res);
	block4_data_unref (self);
}

gint
seahorse_exportable_export_to_prompt_wait (GList* objects,
                                           GtkWindow* parent,
                                           GError** error)
{
	gint count = 0;
	GHashTable* pending = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GError* _inner_error0_ = NULL;
	gint result;
	count = 0;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, NULL);
	pending = _tmp2_;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = objects;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp3_;
			GObject* object = NULL;
			_tmp3_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp3_;
			{
				GHashTable* _tmp4_;
				GObject* _tmp5_;
				_tmp4_ = pending;
				_tmp5_ = object;
				g_hash_table_add (_tmp4_, _tmp5_);
				_g_object_unref0 (object);
			}
		}
	}
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = objects;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp6_;
			GObject* object = NULL;
			_tmp6_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp6_;
			{
				Block4Data* _data4_;
				GHashTable* _tmp7_;
				GObject* _tmp8_;
				GObject* _tmp9_;
				GList* exporters = NULL;
				GObject* _tmp12_;
				GList* _tmp13_;
				GList* _tmp14_;
				gchar* directory = NULL;
				GFile* file = NULL;
				SeahorseExporter* exporter = NULL;
				gboolean ret = FALSE;
				GList* _tmp24_;
				GFile* _tmp25_ = NULL;
				SeahorseExporter* _tmp26_ = NULL;
				gboolean _tmp27_;
				GMainLoop* _tmp28_;
				SeahorseExporter* _tmp29_;
				GFile* _tmp30_;
				GMainLoop* _tmp31_;
				SeahorseExporter* _tmp32_;
				GAsyncResult* _tmp33_;
				SeahorseExporter* _tmp35_;
				GList* _tmp36_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_tmp7_ = pending;
				_tmp8_ = object;
				if (!g_hash_table_contains (_tmp7_, _tmp8_)) {
					_g_object_unref0 (object);
					block4_data_unref (_data4_);
					_data4_ = NULL;
					continue;
				}
				_tmp9_ = object;
				if (!seahorse_exportable_can_export (_tmp9_)) {
					GHashTable* _tmp10_;
					GObject* _tmp11_;
					_tmp10_ = pending;
					_tmp11_ = object;
					g_hash_table_remove (_tmp10_, _tmp11_);
					_g_object_unref0 (object);
					block4_data_unref (_data4_);
					_data4_ = NULL;
					continue;
				}
				_tmp12_ = object;
				_tmp13_ = seahorse_exportable_create_exporters (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, SEAHORSE_TYPE_EXPORTABLE, SeahorseExportable), SEAHORSE_EXPORTER_TYPE_ANY);
				exporters = _tmp13_;
				_tmp14_ = exporters;
				if (_tmp14_ == NULL) {
					(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
					_g_object_unref0 (object);
					block4_data_unref (_data4_);
					_data4_ = NULL;
					continue;
				}
				{
					GList* x_collection = NULL;
					GList* x_it = NULL;
					x_collection = objects;
					for (x_it = x_collection; x_it != NULL; x_it = x_it->next) {
						GObject* _tmp15_;
						GObject* x = NULL;
						_tmp15_ = _g_object_ref0 ((GObject*) x_it->data);
						x = _tmp15_;
						{
							GObject* _tmp16_;
							GObject* _tmp17_;
							GHashTable* _tmp18_;
							GObject* _tmp19_;
							_tmp16_ = x;
							_tmp17_ = object;
							if (_tmp16_ == _tmp17_) {
								_g_object_unref0 (x);
								continue;
							}
							_tmp18_ = pending;
							_tmp19_ = x;
							if (g_hash_table_contains (_tmp18_, _tmp19_)) {
								GList* _tmp20_;
								_tmp20_ = exporters;
								{
									GList* exporter_collection = NULL;
									GList* exporter_it = NULL;
									exporter_collection = _tmp20_;
									for (exporter_it = exporter_collection; exporter_it != NULL; exporter_it = exporter_it->next) {
										SeahorseExporter* _tmp21_;
										SeahorseExporter* exporter = NULL;
										_tmp21_ = _g_object_ref0 ((SeahorseExporter*) exporter_it->data);
										exporter = _tmp21_;
										{
											SeahorseExporter* _tmp22_;
											GObject* _tmp23_;
											_tmp22_ = exporter;
											_tmp23_ = x;
											seahorse_exporter_add_object (_tmp22_, _tmp23_);
											_g_object_unref0 (exporter);
										}
									}
								}
							}
							_g_object_unref0 (x);
						}
					}
				}
				directory = NULL;
				_tmp24_ = exporters;
				_tmp27_ = seahorse_exportable_prompt (_tmp24_, parent, &directory, &_tmp25_, &_tmp26_);
				_g_object_unref0 (file);
				file = _tmp25_;
				_g_object_unref0 (exporter);
				exporter = _tmp26_;
				ret = _tmp27_;
				if (!ret) {
					_g_object_unref0 (exporter);
					_g_object_unref0 (file);
					_g_free0 (directory);
					(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
					_g_object_unref0 (object);
					block4_data_unref (_data4_);
					_data4_ = NULL;
					break;
				}
				_tmp28_ = g_main_loop_new (NULL, FALSE);
				_data4_->loop = _tmp28_;
				_data4_->_result_ = NULL;
				_tmp29_ = exporter;
				_tmp30_ = file;
				seahorse_exporter_export_to_file (_tmp29_, _tmp30_, TRUE, NULL, _____lambda7__gasync_ready_callback, block4_data_ref (_data4_));
				_tmp31_ = _data4_->loop;
				g_main_loop_run (_tmp31_);
				_tmp32_ = exporter;
				_tmp33_ = _data4_->_result_;
				seahorse_exporter_export_to_file_finish (_tmp32_, _tmp33_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gint _tmp34_ = -1;
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (exporter);
					_g_object_unref0 (file);
					_g_free0 (directory);
					(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
					_g_object_unref0 (object);
					block4_data_unref (_data4_);
					_data4_ = NULL;
					_g_hash_table_unref0 (pending);
					return _tmp34_;
				}
				_tmp35_ = exporter;
				_tmp36_ = seahorse_exporter_get_objects (_tmp35_);
				{
					GList* e_collection = NULL;
					GList* e_it = NULL;
					e_collection = _tmp36_;
					for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
						GObject* _tmp37_;
						GObject* e = NULL;
						_tmp37_ = _g_object_ref0 ((GObject*) e_it->data);
						e = _tmp37_;
						{
							GHashTable* _tmp38_;
							GObject* _tmp39_;
							gint _tmp40_;
							_tmp38_ = pending;
							_tmp39_ = e;
							g_hash_table_remove (_tmp38_, _tmp39_);
							_tmp40_ = count;
							count = _tmp40_ + 1;
							_g_object_unref0 (e);
						}
					}
				}
				_g_object_unref0 (exporter);
				_g_object_unref0 (file);
				_g_free0 (directory);
				(exporters == NULL) ? NULL : (exporters = (_g_list_free__g_object_unref0_ (exporters), NULL));
				_g_object_unref0 (object);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	result = count;
	_g_hash_table_unref0 (pending);
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
seahorse_exportable_calculate_basename (GFile* file,
                                        const gchar* extension)
{
	gchar* basename = NULL;
	gchar* _tmp0_;
	gint dot = 0;
	const gchar* _tmp1_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = g_file_get_basename (file);
	basename = _tmp0_;
	_tmp1_ = basename;
	dot = string_last_index_of_char (_tmp1_, (gunichar) '.', 0);
	if (dot != -1) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = basename;
		_tmp3_ = string_substring (_tmp2_, (glong) 0, (glong) dot);
		_g_free0 (basename);
		basename = _tmp3_;
	}
	_tmp4_ = basename;
	_tmp5_ = g_strdup_printf ("%s%s", _tmp4_, extension);
	result = _tmp5_;
	_g_free0 (basename);
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_hash_table_unref0 (_data5_->filters);
		_g_object_unref0 (_data5_->chooser);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda6_ (Block5Data* _data5_,
            GObject* obj,
            GParamSpec* prop)
{
	SeahorseExporter* exporter = NULL;
	GHashTable* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileFilter* _tmp2_;
	gconstpointer _tmp3_;
	SeahorseExporter* _tmp4_;
	gchar* name = NULL;
	SeahorseExporter* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint dot = 0;
	const gchar* _tmp8_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = _data5_->filters;
	_tmp1_ = _data5_->chooser;
	_tmp2_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp1_);
	_tmp3_ = g_hash_table_lookup (_tmp0_, _tmp2_);
	_tmp4_ = _g_object_ref0 ((SeahorseExporter*) _tmp3_);
	exporter = _tmp4_;
	_tmp5_ = exporter;
	_tmp6_ = seahorse_exporter_get_filename (_tmp5_);
	_tmp7_ = _tmp6_;
	name = _tmp7_;
	_tmp8_ = name;
	dot = string_last_index_of_char (_tmp8_, (gunichar) '.', 0);
	if (dot != -1) {
		GFile* file = NULL;
		GtkFileChooserNative* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp9_ = _data5_->chooser;
		_tmp10_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp9_);
		file = _tmp10_;
		_tmp11_ = file;
		if (_tmp11_ != NULL) {
			gchar* basename = NULL;
			GFile* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			GtkFileChooserNative* _tmp18_;
			const gchar* _tmp19_;
			_tmp12_ = file;
			_tmp13_ = name;
			_tmp14_ = string_substring (_tmp13_, (glong) dot, (glong) -1);
			_tmp15_ = _tmp14_;
			_tmp16_ = seahorse_exportable_calculate_basename (_tmp12_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp15_);
			basename = _tmp17_;
			_tmp18_ = _data5_->chooser;
			_tmp19_ = basename;
			gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp18_, _tmp19_);
			_g_free0 (basename);
		} else {
			GtkFileChooserNative* _tmp20_;
			const gchar* _tmp21_;
			_tmp20_ = _data5_->chooser;
			_tmp21_ = name;
			gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp20_, _tmp21_);
		}
		_g_object_unref0 (file);
	}
	_g_free0 (name);
	_g_object_unref0 (exporter);
}

static void
___lambda6__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda6_ (self, _sender, pspec);
}

gboolean
seahorse_exportable_prompt (GList* exporters,
                            GtkWindow* parent,
                            gchar** directory,
                            GFile** chosen_file,
                            SeahorseExporter** chosen_exporter)
{
	GFile* _vala_chosen_file = NULL;
	SeahorseExporter* _vala_chosen_exporter = NULL;
	Block5Data* _data5_;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GtkFileFilter* first = NULL;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GtkFileChooserNative* _tmp22_;
	GtkFileChooserNative* _tmp23_;
	GtkFileFilter* _tmp24_;
	GtkFileChooserNative* _tmp25_;
	GtkFileChooserNative* _tmp36_;
	gboolean result;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = gtk_file_chooser_native_new (NULL, parent, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("Export"), _ ("_Cancel"));
	_data5_->chooser = _tmp0_;
	_tmp1_ = _data5_->chooser;
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp1_, FALSE);
	_tmp2_ = _data5_->chooser;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp2_, TRUE);
	if ((*directory) != NULL) {
		GtkFileChooserNative* _tmp3_;
		_tmp3_ = _data5_->chooser;
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp3_, *directory);
	}
	first = NULL;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_object_unref0_, _g_object_unref0_);
	_data5_->filters = _tmp6_;
	{
		GList* exporter_collection = NULL;
		GList* exporter_it = NULL;
		exporter_collection = exporters;
		for (exporter_it = exporter_collection; exporter_it != NULL; exporter_it = exporter_it->next) {
			SeahorseExporter* _tmp7_;
			SeahorseExporter* exporter = NULL;
			_tmp7_ = _g_object_ref0 ((SeahorseExporter*) exporter_it->data);
			exporter = _tmp7_;
			{
				GtkFileFilter* filter = NULL;
				SeahorseExporter* _tmp8_;
				GtkFileFilter* _tmp9_;
				GtkFileFilter* _tmp10_;
				GHashTable* _tmp11_;
				GtkFileFilter* _tmp12_;
				GtkFileFilter* _tmp13_;
				SeahorseExporter* _tmp14_;
				SeahorseExporter* _tmp15_;
				GtkFileChooserNative* _tmp16_;
				GtkFileFilter* _tmp17_;
				GtkFileFilter* _tmp18_;
				GtkFileFilter* _tmp19_;
				_tmp8_ = exporter;
				_tmp9_ = seahorse_exporter_get_file_filter (_tmp8_);
				_tmp10_ = _tmp9_;
				filter = _tmp10_;
				_tmp11_ = _data5_->filters;
				_tmp12_ = filter;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_tmp14_ = exporter;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				g_hash_table_replace (_tmp11_, _tmp13_, _tmp15_);
				_tmp16_ = _data5_->chooser;
				_tmp17_ = filter;
				_tmp18_ = _g_object_ref0 (_tmp17_);
				gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp16_, _tmp18_);
				_tmp19_ = first;
				if (_tmp19_ == NULL) {
					GtkFileFilter* _tmp20_;
					GtkFileFilter* _tmp21_;
					_tmp20_ = filter;
					_tmp21_ = _g_object_ref0 (_tmp20_);
					_g_object_unref0 (first);
					first = _tmp21_;
				}
				_g_object_unref0 (filter);
				_g_object_unref0 (exporter);
			}
		}
	}
	_tmp22_ = _data5_->chooser;
	g_signal_connect_data ((GObject*) _tmp22_, "notify", (GCallback) ___lambda6__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp23_ = _data5_->chooser;
	_tmp24_ = first;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp23_, _tmp24_);
	_tmp25_ = _data5_->chooser;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp25_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp26_;
		GFile* _tmp27_;
		GHashTable* _tmp28_;
		GtkFileChooserNative* _tmp29_;
		GtkFileFilter* _tmp30_;
		gconstpointer _tmp31_;
		SeahorseExporter* _tmp32_;
		GtkFileChooserNative* _tmp33_;
		gchar* _tmp34_;
		GtkFileChooserNative* _tmp35_;
		_tmp26_ = _data5_->chooser;
		_tmp27_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp26_);
		_g_object_unref0 (_vala_chosen_file);
		_vala_chosen_file = _tmp27_;
		_tmp28_ = _data5_->filters;
		_tmp29_ = _data5_->chooser;
		_tmp30_ = gtk_file_chooser_get_filter ((GtkFileChooser*) _tmp29_);
		_tmp31_ = g_hash_table_lookup (_tmp28_, _tmp30_);
		_tmp32_ = _g_object_ref0 ((SeahorseExporter*) _tmp31_);
		_g_object_unref0 (_vala_chosen_exporter);
		_vala_chosen_exporter = _tmp32_;
		_tmp33_ = _data5_->chooser;
		_tmp34_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp33_);
		_g_free0 (*directory);
		*directory = _tmp34_;
		_tmp35_ = _data5_->chooser;
		gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp35_);
		result = TRUE;
		_g_object_unref0 (first);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		if (chosen_file) {
			*chosen_file = _vala_chosen_file;
		} else {
			_g_object_unref0 (_vala_chosen_file);
		}
		if (chosen_exporter) {
			*chosen_exporter = _vala_chosen_exporter;
		} else {
			_g_object_unref0 (_vala_chosen_exporter);
		}
		return result;
	}
	_g_object_unref0 (_vala_chosen_file);
	_vala_chosen_file = NULL;
	_g_object_unref0 (_vala_chosen_exporter);
	_vala_chosen_exporter = NULL;
	_tmp36_ = _data5_->chooser;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp36_);
	result = FALSE;
	_g_object_unref0 (first);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	if (chosen_file) {
		*chosen_file = _vala_chosen_file;
	} else {
		_g_object_unref0 (_vala_chosen_file);
	}
	if (chosen_exporter) {
		*chosen_exporter = _vala_chosen_exporter;
	} else {
		_g_object_unref0 (_vala_chosen_exporter);
	}
	return result;
}

gboolean
seahorse_exportable_get_exportable (SeahorseExportable* self)
{
	SeahorseExportableIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = SEAHORSE_EXPORTABLE_GET_INTERFACE (self);
	if (_iface_->get_exportable) {
		return _iface_->get_exportable (self);
	}
	return FALSE;
}

static void
seahorse_exportable_default_init (SeahorseExportableIface * iface,
                                  gpointer iface_data)
{
	g_object_interface_install_property (iface, g_param_spec_boolean ("exportable", "exportable", "exportable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

 G_GNUC_NO_INLINE static GType
seahorse_exportable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseExportableIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_exportable_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType seahorse_exportable_type_id;
	seahorse_exportable_type_id = g_type_register_static (G_TYPE_INTERFACE, "SeahorseExportable", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (seahorse_exportable_type_id, G_TYPE_OBJECT);
	return seahorse_exportable_type_id;
}

GType
seahorse_exportable_get_type (void)
{
	static volatile gsize seahorse_exportable_type_id__once = 0;
	if (g_once_init_enter (&seahorse_exportable_type_id__once)) {
		GType seahorse_exportable_type_id;
		seahorse_exportable_type_id = seahorse_exportable_get_type_once ();
		g_once_init_leave (&seahorse_exportable_type_id__once, seahorse_exportable_type_id);
	}
	return seahorse_exportable_type_id__once;
}

