/* Generated by wayland-scanner 1.24.0 */

#ifndef HYPRLAND_SURFACE_V1_CLIENT_PROTOCOL_H
#define HYPRLAND_SURFACE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_hyprland_surface_v1 The hyprland_surface_v1 protocol
 * hyprland-specific wl_surface extensions
 *
 * @section page_desc_hyprland_surface_v1 Description
 *
 * This protocol exposes hyprland-specific wl_surface properties.
 *
 * @section page_ifaces_hyprland_surface_v1 Interfaces
 * - @subpage page_iface_hyprland_surface_manager_v1 - manager for hyprland surface objects
 * - @subpage page_iface_hyprland_surface_v1 - hyprland-specific wl_surface properties
 * @section page_copyright_hyprland_surface_v1 Copyright
 * <pre>
 *
 * Copyright © 2025 outfoxxed
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 */
struct hyprland_surface_manager_v1;
struct hyprland_surface_v1;
struct wl_region;
struct wl_surface;

#ifndef HYPRLAND_SURFACE_MANAGER_V1_INTERFACE
#define HYPRLAND_SURFACE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_hyprland_surface_manager_v1 hyprland_surface_manager_v1
 * @section page_iface_hyprland_surface_manager_v1_desc Description
 *
 * This interface allows a client to create hyprland surface objects.
 * @section page_iface_hyprland_surface_manager_v1_api API
 * See @ref iface_hyprland_surface_manager_v1.
 */
/**
 * @defgroup iface_hyprland_surface_manager_v1 The hyprland_surface_manager_v1 interface
 *
 * This interface allows a client to create hyprland surface objects.
 */
extern const struct wl_interface hyprland_surface_manager_v1_interface;
#endif
#ifndef HYPRLAND_SURFACE_V1_INTERFACE
#define HYPRLAND_SURFACE_V1_INTERFACE
/**
 * @page page_iface_hyprland_surface_v1 hyprland_surface_v1
 * @section page_iface_hyprland_surface_v1_desc Description
 *
 * This interface allows access to hyprland-specific properties of a wl_surface.
 *
 * Once the wl_surface has been destroyed, the hyprland surface object must be
 * destroyed as well. All other operations are a protocol error.
 * @section page_iface_hyprland_surface_v1_api API
 * See @ref iface_hyprland_surface_v1.
 */
/**
 * @defgroup iface_hyprland_surface_v1 The hyprland_surface_v1 interface
 *
 * This interface allows access to hyprland-specific properties of a wl_surface.
 *
 * Once the wl_surface has been destroyed, the hyprland surface object must be
 * destroyed as well. All other operations are a protocol error.
 */
extern const struct wl_interface hyprland_surface_v1_interface;
#endif

#ifndef HYPRLAND_SURFACE_MANAGER_V1_ERROR_ENUM
#define HYPRLAND_SURFACE_MANAGER_V1_ERROR_ENUM
enum hyprland_surface_manager_v1_error {
	/**
	 * wl_surface already has a hyprland surface object
	 */
	HYPRLAND_SURFACE_MANAGER_V1_ERROR_ALREADY_CONSTRUCTED = 0,
};
#endif /* HYPRLAND_SURFACE_MANAGER_V1_ERROR_ENUM */

#define HYPRLAND_SURFACE_MANAGER_V1_GET_HYPRLAND_SURFACE 0
#define HYPRLAND_SURFACE_MANAGER_V1_DESTROY 1


/**
 * @ingroup iface_hyprland_surface_manager_v1
 */
#define HYPRLAND_SURFACE_MANAGER_V1_GET_HYPRLAND_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_surface_manager_v1
 */
#define HYPRLAND_SURFACE_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_hyprland_surface_manager_v1 */
static inline void
hyprland_surface_manager_v1_set_user_data(struct hyprland_surface_manager_v1 *hyprland_surface_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_surface_manager_v1, user_data);
}

/** @ingroup iface_hyprland_surface_manager_v1 */
static inline void *
hyprland_surface_manager_v1_get_user_data(struct hyprland_surface_manager_v1 *hyprland_surface_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_surface_manager_v1);
}

static inline uint32_t
hyprland_surface_manager_v1_get_version(struct hyprland_surface_manager_v1 *hyprland_surface_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_surface_manager_v1);
}

/**
 * @ingroup iface_hyprland_surface_manager_v1
 *
 * Create a hyprland surface object for the given wayland surface.
 *
 * If the wl_surface already has an associated hyprland_surface_v1 object,
 * even from a different manager, creation is a protocol error.
 */
static inline struct hyprland_surface_v1 *
hyprland_surface_manager_v1_get_hyprland_surface(struct hyprland_surface_manager_v1 *hyprland_surface_manager_v1, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) hyprland_surface_manager_v1,
			 HYPRLAND_SURFACE_MANAGER_V1_GET_HYPRLAND_SURFACE, &hyprland_surface_v1_interface, wl_proxy_get_version((struct wl_proxy *) hyprland_surface_manager_v1), 0, NULL, surface);

	return (struct hyprland_surface_v1 *) id;
}

/**
 * @ingroup iface_hyprland_surface_manager_v1
 *
 * Destroy the surface manager.
 * This does not destroy existing surface objects.
 */
static inline void
hyprland_surface_manager_v1_destroy(struct hyprland_surface_manager_v1 *hyprland_surface_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_surface_manager_v1,
			 HYPRLAND_SURFACE_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_surface_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef HYPRLAND_SURFACE_V1_ERROR_ENUM
#define HYPRLAND_SURFACE_V1_ERROR_ENUM
enum hyprland_surface_v1_error {
	/**
	 * wl_surface was destroyed
	 */
	HYPRLAND_SURFACE_V1_ERROR_NO_SURFACE = 0,
	/**
	 * given opacity was not in the range 0.0 - 1.0 (inclusive)
	 */
	HYPRLAND_SURFACE_V1_ERROR_OUT_OF_RANGE = 1,
};
#endif /* HYPRLAND_SURFACE_V1_ERROR_ENUM */

#define HYPRLAND_SURFACE_V1_SET_OPACITY 0
#define HYPRLAND_SURFACE_V1_DESTROY 1
#define HYPRLAND_SURFACE_V1_SET_VISIBLE_REGION 2


/**
 * @ingroup iface_hyprland_surface_v1
 */
#define HYPRLAND_SURFACE_V1_SET_OPACITY_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_surface_v1
 */
#define HYPRLAND_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_surface_v1
 */
#define HYPRLAND_SURFACE_V1_SET_VISIBLE_REGION_SINCE_VERSION 2

/** @ingroup iface_hyprland_surface_v1 */
static inline void
hyprland_surface_v1_set_user_data(struct hyprland_surface_v1 *hyprland_surface_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_surface_v1, user_data);
}

/** @ingroup iface_hyprland_surface_v1 */
static inline void *
hyprland_surface_v1_get_user_data(struct hyprland_surface_v1 *hyprland_surface_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_surface_v1);
}

static inline uint32_t
hyprland_surface_v1_get_version(struct hyprland_surface_v1 *hyprland_surface_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_surface_v1);
}

/**
 * @ingroup iface_hyprland_surface_v1
 *
 * Sets a multiplier for the overall opacity of the surface.
 * This multiplier applies to visual effects such as blur behind the surface
 * in addition to the surface's content.
 *
 * The default value is 1.0.
 * Setting a value outside of the range 0.0 - 1.0 (inclusive) is a protocol error.
 * Does not take effect until wl_surface.commit is called.
 */
static inline void
hyprland_surface_v1_set_opacity(struct hyprland_surface_v1 *hyprland_surface_v1, wl_fixed_t opacity)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_surface_v1,
			 HYPRLAND_SURFACE_V1_SET_OPACITY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_surface_v1), 0, opacity);
}

/**
 * @ingroup iface_hyprland_surface_v1
 *
 * Destroy the hyprland surface object, resetting properties provided
 * by this interface to their default values on the next wl_surface.commit.
 */
static inline void
hyprland_surface_v1_destroy(struct hyprland_surface_v1 *hyprland_surface_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_surface_v1,
			 HYPRLAND_SURFACE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_surface_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_hyprland_surface_v1
 *
 * This request sets the region of the surface that contains visible content.
 * Visible content refers to content that has an alpha value greater than zero.
 *
 * The visible region is an optimization hint for the compositor that lets it
 * avoid drawing parts of the surface that are not visible. Setting a visible region
 * that does not contain all content in the surface may result in missing content
 * not being drawn.
 *
 * The visible region is specified in buffer-local coordinates.
 *
 * The compositor ignores the parts of the visible region that fall outside of the surface.
 * When all parts of the region fall outside of the buffer geometry, the compositor may
 * avoid rendering the surface entirely.
 *
 * The initial value for the visible region is empty. Setting the
 * visible region has copy semantics, and the wl_region object can be destroyed immediately.
 * A NULL wl_region causes the visible region to be set to empty.
 *
 * Does not take effect until wl_surface.commit is called.
 */
static inline void
hyprland_surface_v1_set_visible_region(struct hyprland_surface_v1 *hyprland_surface_v1, struct wl_region *region)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_surface_v1,
			 HYPRLAND_SURFACE_V1_SET_VISIBLE_REGION, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_surface_v1), 0, region);
}

#ifdef  __cplusplus
}
#endif

#endif
