/* Generated by wayland-scanner 1.24.0 */

#ifndef HYPRLAND_FOCUS_GRAB_V1_CLIENT_PROTOCOL_H
#define HYPRLAND_FOCUS_GRAB_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_hyprland_focus_grab_v1 The hyprland_focus_grab_v1 protocol
 * limit input focus to a set of surfaces
 *
 * @section page_desc_hyprland_focus_grab_v1 Description
 *
 * This protocol allows clients to limit input focus to a specific set
 * of surfaces and receive a notification when the limiter is removed as
 * detailed below.
 *
 * @section page_ifaces_hyprland_focus_grab_v1 Interfaces
 * - @subpage page_iface_hyprland_focus_grab_manager_v1 - manager for focus grab objects
 * - @subpage page_iface_hyprland_focus_grab_v1 - input focus limiter
 * @section page_copyright_hyprland_focus_grab_v1 Copyright
 * <pre>
 *
 * Copyright © 2024 outfoxxed
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * </pre>
 */
struct hyprland_focus_grab_manager_v1;
struct hyprland_focus_grab_v1;
struct wl_surface;

#ifndef HYPRLAND_FOCUS_GRAB_MANAGER_V1_INTERFACE
#define HYPRLAND_FOCUS_GRAB_MANAGER_V1_INTERFACE
/**
 * @page page_iface_hyprland_focus_grab_manager_v1 hyprland_focus_grab_manager_v1
 * @section page_iface_hyprland_focus_grab_manager_v1_desc Description
 *
 * This interface allows a client to create surface grab objects.
 * @section page_iface_hyprland_focus_grab_manager_v1_api API
 * See @ref iface_hyprland_focus_grab_manager_v1.
 */
/**
 * @defgroup iface_hyprland_focus_grab_manager_v1 The hyprland_focus_grab_manager_v1 interface
 *
 * This interface allows a client to create surface grab objects.
 */
extern const struct wl_interface hyprland_focus_grab_manager_v1_interface;
#endif
#ifndef HYPRLAND_FOCUS_GRAB_V1_INTERFACE
#define HYPRLAND_FOCUS_GRAB_V1_INTERFACE
/**
 * @page page_iface_hyprland_focus_grab_v1 hyprland_focus_grab_v1
 * @section page_iface_hyprland_focus_grab_v1_desc Description
 *
 * This interface restricts input focus to a specified whitelist of
 * surfaces as long as the focus grab object exists and has at least
 * one comitted surface.
 *
 * Mouse and touch events inside a whitelisted surface will be passed
 * to the surface normally, while events outside of a whitelisted surface
 * will clear the grab object. Keyboard events will be passed to the client
 * and a compositor-picked surface in the whitelist will receive a
 * wl_keyboard::enter event if a whitelisted surface is not already entered.
 *
 * Upon meeting implementation-defined criteria usually meaning a mouse or
 * touch input outside of any whitelisted surfaces, the compositor will
 * clear the whitelist, rendering the grab inert and sending the cleared
 * event. The same will happen if another focus grab or similar action
 * is started at the compositor's discretion.
 * @section page_iface_hyprland_focus_grab_v1_api API
 * See @ref iface_hyprland_focus_grab_v1.
 */
/**
 * @defgroup iface_hyprland_focus_grab_v1 The hyprland_focus_grab_v1 interface
 *
 * This interface restricts input focus to a specified whitelist of
 * surfaces as long as the focus grab object exists and has at least
 * one comitted surface.
 *
 * Mouse and touch events inside a whitelisted surface will be passed
 * to the surface normally, while events outside of a whitelisted surface
 * will clear the grab object. Keyboard events will be passed to the client
 * and a compositor-picked surface in the whitelist will receive a
 * wl_keyboard::enter event if a whitelisted surface is not already entered.
 *
 * Upon meeting implementation-defined criteria usually meaning a mouse or
 * touch input outside of any whitelisted surfaces, the compositor will
 * clear the whitelist, rendering the grab inert and sending the cleared
 * event. The same will happen if another focus grab or similar action
 * is started at the compositor's discretion.
 */
extern const struct wl_interface hyprland_focus_grab_v1_interface;
#endif

#define HYPRLAND_FOCUS_GRAB_MANAGER_V1_CREATE_GRAB 0
#define HYPRLAND_FOCUS_GRAB_MANAGER_V1_DESTROY 1


/**
 * @ingroup iface_hyprland_focus_grab_manager_v1
 */
#define HYPRLAND_FOCUS_GRAB_MANAGER_V1_CREATE_GRAB_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_focus_grab_manager_v1
 */
#define HYPRLAND_FOCUS_GRAB_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_hyprland_focus_grab_manager_v1 */
static inline void
hyprland_focus_grab_manager_v1_set_user_data(struct hyprland_focus_grab_manager_v1 *hyprland_focus_grab_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_focus_grab_manager_v1, user_data);
}

/** @ingroup iface_hyprland_focus_grab_manager_v1 */
static inline void *
hyprland_focus_grab_manager_v1_get_user_data(struct hyprland_focus_grab_manager_v1 *hyprland_focus_grab_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_focus_grab_manager_v1);
}

static inline uint32_t
hyprland_focus_grab_manager_v1_get_version(struct hyprland_focus_grab_manager_v1 *hyprland_focus_grab_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_focus_grab_manager_v1);
}

/**
 * @ingroup iface_hyprland_focus_grab_manager_v1
 *
 * Create a surface grab object.
 */
static inline struct hyprland_focus_grab_v1 *
hyprland_focus_grab_manager_v1_create_grab(struct hyprland_focus_grab_manager_v1 *hyprland_focus_grab_manager_v1)
{
	struct wl_proxy *grab;

	grab = wl_proxy_marshal_flags((struct wl_proxy *) hyprland_focus_grab_manager_v1,
			 HYPRLAND_FOCUS_GRAB_MANAGER_V1_CREATE_GRAB, &hyprland_focus_grab_v1_interface, wl_proxy_get_version((struct wl_proxy *) hyprland_focus_grab_manager_v1), 0, NULL);

	return (struct hyprland_focus_grab_v1 *) grab;
}

/**
 * @ingroup iface_hyprland_focus_grab_manager_v1
 *
 * Destroy the focus grab manager.
 * This doesn't destroy existing focus grab objects.
 */
static inline void
hyprland_focus_grab_manager_v1_destroy(struct hyprland_focus_grab_manager_v1 *hyprland_focus_grab_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_focus_grab_manager_v1,
			 HYPRLAND_FOCUS_GRAB_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_focus_grab_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_hyprland_focus_grab_v1
 * @struct hyprland_focus_grab_v1_listener
 */
struct hyprland_focus_grab_v1_listener {
	/**
	 * the focus grab was cleared
	 *
	 * Sent when an active grab is cancelled by the compositor,
	 * regardless of cause.
	 */
	void (*cleared)(void *data,
			struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1);
};

/**
 * @ingroup iface_hyprland_focus_grab_v1
 */
static inline int
hyprland_focus_grab_v1_add_listener(struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1,
				    const struct hyprland_focus_grab_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) hyprland_focus_grab_v1,
				     (void (**)(void)) listener, data);
}

#define HYPRLAND_FOCUS_GRAB_V1_ADD_SURFACE 0
#define HYPRLAND_FOCUS_GRAB_V1_REMOVE_SURFACE 1
#define HYPRLAND_FOCUS_GRAB_V1_COMMIT 2
#define HYPRLAND_FOCUS_GRAB_V1_DESTROY 3

/**
 * @ingroup iface_hyprland_focus_grab_v1
 */
#define HYPRLAND_FOCUS_GRAB_V1_CLEARED_SINCE_VERSION 1

/**
 * @ingroup iface_hyprland_focus_grab_v1
 */
#define HYPRLAND_FOCUS_GRAB_V1_ADD_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_focus_grab_v1
 */
#define HYPRLAND_FOCUS_GRAB_V1_REMOVE_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_focus_grab_v1
 */
#define HYPRLAND_FOCUS_GRAB_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_hyprland_focus_grab_v1
 */
#define HYPRLAND_FOCUS_GRAB_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_hyprland_focus_grab_v1 */
static inline void
hyprland_focus_grab_v1_set_user_data(struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) hyprland_focus_grab_v1, user_data);
}

/** @ingroup iface_hyprland_focus_grab_v1 */
static inline void *
hyprland_focus_grab_v1_get_user_data(struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) hyprland_focus_grab_v1);
}

static inline uint32_t
hyprland_focus_grab_v1_get_version(struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) hyprland_focus_grab_v1);
}

/**
 * @ingroup iface_hyprland_focus_grab_v1
 *
 * Add a surface to the whitelist. Destroying the surface is treated the
 * same as an explicit call to remove_surface and duplicate additions are
 * ignored.
 *
 * Does not take effect until commit is called.
 */
static inline void
hyprland_focus_grab_v1_add_surface(struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_focus_grab_v1,
			 HYPRLAND_FOCUS_GRAB_V1_ADD_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_focus_grab_v1), 0, surface);
}

/**
 * @ingroup iface_hyprland_focus_grab_v1
 *
 * Remove a surface from the whitelist. Destroying the surface is treated
 * the same as an explicit call to this function.
 *
 * If the grab was active and the removed surface was entered by the
 * keyboard, another surface will be entered on commit.
 *
 * Does not take effect until commit is called.
 */
static inline void
hyprland_focus_grab_v1_remove_surface(struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_focus_grab_v1,
			 HYPRLAND_FOCUS_GRAB_V1_REMOVE_SURFACE, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_focus_grab_v1), 0, surface);
}

/**
 * @ingroup iface_hyprland_focus_grab_v1
 *
 * Commit pending changes to the surface whitelist.
 *
 * If the list previously had no entries and now has at least one, the grab
 * will start. If it previously had entries and now has none, the grab will
 * become inert.
 */
static inline void
hyprland_focus_grab_v1_commit(struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_focus_grab_v1,
			 HYPRLAND_FOCUS_GRAB_V1_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_focus_grab_v1), 0);
}

/**
 * @ingroup iface_hyprland_focus_grab_v1
 *
 * Destroy the grab object and remove the grab if active.
 */
static inline void
hyprland_focus_grab_v1_destroy(struct hyprland_focus_grab_v1 *hyprland_focus_grab_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) hyprland_focus_grab_v1,
			 HYPRLAND_FOCUS_GRAB_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) hyprland_focus_grab_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
