// third_party/blink/public/mojom/frame/find_in_page.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/frame/find_in_page.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/frame/find_in_page.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* StopFindActionToStringHelper(StopFindAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case StopFindAction::kStopFindActionClearSelection:
      return "kStopFindActionClearSelection";
    case StopFindAction::kStopFindActionKeepSelection:
      return "kStopFindActionKeepSelection";
    case StopFindAction::kStopFindActionActivateSelection:
      return "kStopFindActionActivateSelection";
    default:
      return nullptr;
  }
}

std::string StopFindActionToString(StopFindAction value) {
  const char *str = StopFindActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown StopFindAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, StopFindAction value) {
  return os << StopFindActionToString(value);
}

NOINLINE static const char* FindMatchUpdateTypeToStringHelper(FindMatchUpdateType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FindMatchUpdateType::kFinalUpdate:
      return "kFinalUpdate";
    case FindMatchUpdateType::kMoreUpdatesComing:
      return "kMoreUpdatesComing";
    default:
      return nullptr;
  }
}

std::string FindMatchUpdateTypeToString(FindMatchUpdateType value) {
  const char *str = FindMatchUpdateTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FindMatchUpdateType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FindMatchUpdateType value) {
  return os << FindMatchUpdateTypeToString(value);
}

namespace internal {


// static
bool FindOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindOptions_Data* object =
      static_cast<const FindOptions_Data*>(data);

  return true;
}

FindOptions_Data::FindOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindInPage_Find_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindInPage_Find_Params_Data* object =
      static_cast<const FindInPage_Find_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->search_text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& search_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->search_text, validation_context,
                                         &search_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

FindInPage_Find_Params_Data::FindInPage_Find_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindInPage_StopFinding_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindInPage_StopFinding_Params_Data* object =
      static_cast<const FindInPage_StopFinding_Params_Data*>(data);


  if (!::blink::mojom::internal::StopFindAction_Data
        ::Validate(object->action, validation_context))
    return false;

  return true;
}

FindInPage_StopFinding_Params_Data::FindInPage_StopFinding_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindInPage_ClearActiveFindMatch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindInPage_ClearActiveFindMatch_Params_Data* object =
      static_cast<const FindInPage_ClearActiveFindMatch_Params_Data*>(data);

  return true;
}

FindInPage_ClearActiveFindMatch_Params_Data::FindInPage_ClearActiveFindMatch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindInPage_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindInPage_SetClient_Params_Data* object =
      static_cast<const FindInPage_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

FindInPage_SetClient_Params_Data::FindInPage_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindInPageClient_SetNumberOfMatches_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindInPageClient_SetNumberOfMatches_Params_Data* object =
      static_cast<const FindInPageClient_SetNumberOfMatches_Params_Data*>(data);


  if (!::blink::mojom::internal::FindMatchUpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;

  return true;
}

FindInPageClient_SetNumberOfMatches_Params_Data::FindInPageClient_SetNumberOfMatches_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FindInPageClient_SetActiveMatch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FindInPageClient_SetActiveMatch_Params_Data* object =
      static_cast<const FindInPageClient_SetActiveMatch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->active_match_rect, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->active_match_rect, validation_context))
    return false;


  if (!::blink::mojom::internal::FindMatchUpdateType_Data
        ::Validate(object->update_type, validation_context))
    return false;

  return true;
}

FindInPageClient_SetActiveMatch_Params_Data::FindInPageClient_SetActiveMatch_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::StopFindAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::StopFindAction value) {
  return std::move(context).WriteString(::blink::mojom::StopFindActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::FindMatchUpdateType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::FindMatchUpdateType value) {
  return std::move(context).WriteString(::blink::mojom::FindMatchUpdateTypeToString(value));
}

} // namespace perfetto