// services/network/public/mojom/link_header.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/link_header.mojom-shared-internal.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"







namespace network::mojom {
class LinkHeaderDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::LinkHeaderDataView> {
  using Data = ::network::mojom::internal::LinkHeader_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class LinkRelAttribute : int32_t {
  
  kDnsPrefetch = 0,
  
  kPreconnect = 1,
  
  kPreload = 2,
  
  kModulePreload = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, LinkRelAttribute value);
inline bool IsKnownEnumValue(LinkRelAttribute value) {
  return internal::LinkRelAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class LinkAsAttribute : int32_t {
  
  kUnspecified = 0,
  
  kFont = 1,
  
  kImage = 2,
  
  kScript = 3,
  
  kStyleSheet = 4,
  
  kFetch = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, LinkAsAttribute value);
inline bool IsKnownEnumValue(LinkAsAttribute value) {
  return internal::LinkAsAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CrossOriginAttribute : int32_t {
  
  kUnspecified = 0,
  
  kAnonymous = 1,
  
  kUseCredentials = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CrossOriginAttribute value);
inline bool IsKnownEnumValue(CrossOriginAttribute value) {
  return internal::CrossOriginAttribute_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class LinkHeaderDataView {
 public:
  LinkHeaderDataView() = default;

  LinkHeaderDataView(
      internal::LinkHeader_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHrefDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHref(UserType* output) {
    
    auto* pointer = data_->href.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRel(UserType* output) const {
    auto data_value = data_->rel;
    return mojo::internal::Deserialize<::network::mojom::LinkRelAttribute>(
        data_value, output);
  }
  LinkRelAttribute rel() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::LinkRelAttribute>(data_->rel));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAs(UserType* output) const {
    auto data_value = data_->as;
    return mojo::internal::Deserialize<::network::mojom::LinkAsAttribute>(
        data_value, output);
  }
  LinkAsAttribute as() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::LinkAsAttribute>(data_->as));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCrossOrigin(UserType* output) const {
    auto data_value = data_->cross_origin;
    return mojo::internal::Deserialize<::network::mojom::CrossOriginAttribute>(
        data_value, output);
  }
  CrossOriginAttribute cross_origin() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CrossOriginAttribute>(data_->cross_origin));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFetchPriority(UserType* output) const {
    auto data_value = data_->fetch_priority;
    return mojo::internal::Deserialize<::network::mojom::FetchPriorityAttribute>(
        data_value, output);
  }
  ::network::mojom::FetchPriorityAttribute fetch_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::FetchPriorityAttribute>(data_->fetch_priority));
  }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `mime_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMimeType` instead "
    "of `ReadMimeType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LinkHeader_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::LinkRelAttribute>
    : public mojo::internal::EnumHashImpl<::network::mojom::LinkRelAttribute> {};

template <>
struct hash<::network::mojom::LinkAsAttribute>
    : public mojo::internal::EnumHashImpl<::network::mojom::LinkAsAttribute> {};

template <>
struct hash<::network::mojom::CrossOriginAttribute>
    : public mojo::internal::EnumHashImpl<::network::mojom::CrossOriginAttribute> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LinkRelAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::LinkRelAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::LinkRelAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LinkAsAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::LinkAsAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::LinkAsAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CrossOriginAttribute, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CrossOriginAttribute, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CrossOriginAttribute>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LinkHeaderDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::LinkHeaderDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::LinkHeader_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::href(input)) in_href = Traits::href(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->href)::BaseType> href_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_href, href_fragment);
    fragment->href.Set(
        href_fragment.is_null() ? nullptr : href_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->href.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null href in LinkHeader struct");
    mojo::internal::Serialize<::network::mojom::LinkRelAttribute>(
        Traits::rel(input), &fragment->rel);
    mojo::internal::Serialize<::network::mojom::LinkAsAttribute>(
        Traits::as(input), &fragment->as);
    mojo::internal::Serialize<::network::mojom::CrossOriginAttribute>(
        Traits::cross_origin(input), &fragment->cross_origin);
    mojo::internal::Serialize<::network::mojom::FetchPriorityAttribute>(
        Traits::fetch_priority(input), &fragment->fetch_priority);
    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mime_type, mime_type_fragment);
    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::LinkHeader_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::LinkHeaderDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void LinkHeaderDataView::GetHrefDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->href.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void LinkHeaderDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::LinkRelAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::LinkRelAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::LinkAsAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::LinkAsAttribute value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CrossOriginAttribute> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CrossOriginAttribute value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LINK_HEADER_MOJOM_SHARED_H_