// content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_SHARED_H_
#define CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/services/auction_worklet/public/mojom/bidder_worklet.mojom-shared-internal.h"
#include "content/services/auction_worklet/public/mojom/private_aggregation_request.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/real_time_reporting.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/reject_reason.mojom-shared.h"
#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace auction_worklet::mojom {
class KAnonKeyDataView;

class BidderWorkletNonSharedParamsDataView;

class BidderWorkletBidDataView;

class PrioritySignalsDoubleDataView;

class GenerateBidDependencyLatenciesDataView;

class BidderTimingMetricsDataView;



}  // auction_worklet::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::auction_worklet::mojom::KAnonKeyDataView> {
  using Data = ::auction_worklet::mojom::internal::KAnonKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView> {
  using Data = ::auction_worklet::mojom::internal::BidderWorkletNonSharedParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BidderWorkletBidDataView> {
  using Data = ::auction_worklet::mojom::internal::BidderWorkletBid_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::PrioritySignalsDoubleDataView> {
  using Data = ::auction_worklet::mojom::internal::PrioritySignalsDouble_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView> {
  using Data = ::auction_worklet::mojom::internal::GenerateBidDependencyLatencies_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::auction_worklet::mojom::BidderTimingMetricsDataView> {
  using Data = ::auction_worklet::mojom::internal::BidderTimingMetrics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace auction_worklet::mojom {


enum class KAnonymityBidMode : int32_t {
  
  kNone = 0,
  
  kSimulate = 1,
  
  kEnforce = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, KAnonymityBidMode value);
inline bool IsKnownEnumValue(KAnonymityBidMode value) {
  return internal::KAnonymityBidMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BidRole : int32_t {
  
  kUnenforcedKAnon = 0,
  
  kEnforcedKAnon = 1,
  
  kBothKAnonModes = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, BidRole value);
inline bool IsKnownEnumValue(BidRole value) {
  return internal::BidRole_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ReportingIdField : int32_t {
  
  kNone = 0,
  
  kInterestGroupName = 1,
  
  kBuyerReportingId = 2,
  
  kBuyerAndSellerReportingId = 3,
  
  kSelectedBuyerAndSellerReportingId = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ReportingIdField value);
inline bool IsKnownEnumValue(ReportingIdField value) {
  return internal::ReportingIdField_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class GenerateBidClientInterfaceBase {};

using GenerateBidClientPtrDataView =
    mojo::InterfacePtrDataView<GenerateBidClientInterfaceBase>;
using GenerateBidClientRequestDataView =
    mojo::InterfaceRequestDataView<GenerateBidClientInterfaceBase>;
using GenerateBidClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GenerateBidClientInterfaceBase>;
using GenerateBidClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GenerateBidClientInterfaceBase>;
class GenerateBidFinalizerInterfaceBase {};

using GenerateBidFinalizerPtrDataView =
    mojo::InterfacePtrDataView<GenerateBidFinalizerInterfaceBase>;
using GenerateBidFinalizerRequestDataView =
    mojo::InterfaceRequestDataView<GenerateBidFinalizerInterfaceBase>;
using GenerateBidFinalizerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GenerateBidFinalizerInterfaceBase>;
using GenerateBidFinalizerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GenerateBidFinalizerInterfaceBase>;
class BidderWorkletInterfaceBase {};

using BidderWorkletPtrDataView =
    mojo::InterfacePtrDataView<BidderWorkletInterfaceBase>;
using BidderWorkletRequestDataView =
    mojo::InterfaceRequestDataView<BidderWorkletInterfaceBase>;
using BidderWorkletAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BidderWorkletInterfaceBase>;
using BidderWorkletAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BidderWorkletInterfaceBase>;


class KAnonKeyDataView {
 public:
  KAnonKeyDataView() = default;

  KAnonKeyDataView(
      internal::KAnonKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::KAnonKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderWorkletNonSharedParamsDataView {
 public:
  BidderWorkletNonSharedParamsDataView() = default;

  BidderWorkletNonSharedParamsDataView(
      internal::BidderWorkletNonSharedParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsSlotSizeMode(UserType* output) const {
    auto data_value = data_->trusted_bidding_signals_slot_size_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(
        data_value, output);
  }
  ::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode trusted_bidding_signals_slot_size_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(data_->trusted_bidding_signals_slot_size_mode));
  }
  bool enable_bidding_signals_prioritization() const {
    return data_->enable_bidding_signals_prioritization;
  }
  inline void GetPriorityVectorDataView(
      mojo::MapDataView<mojo::StringDataView, double>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPriorityVector(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, double>, UserType>(),
    "Attempting to read the optional `priority_vector` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPriorityVector` instead "
    "of `ReadPriorityVector if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->priority_vector.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, double>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadExecutionMode(UserType* output) const {
    auto data_value = data_->execution_mode;
    return mojo::internal::Deserialize<::blink::mojom::InterestGroup_ExecutionMode>(
        data_value, output);
  }
  ::blink::mojom::InterestGroup_ExecutionMode execution_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::InterestGroup_ExecutionMode>(data_->execution_mode));
  }
  inline void GetUpdateUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUpdateUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `update_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUpdateUrl` instead "
    "of `ReadUpdateUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->update_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedBiddingSignalsKeysDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsKeys(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_keys` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsKeys` instead "
    "of `ReadTrustedBiddingSignalsKeys if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  int32_t max_trusted_bidding_signals_url_length() const {
    return data_->max_trusted_bidding_signals_url_length;
  }
  inline void GetUserBiddingSignalsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserBiddingSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `user_bidding_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserBiddingSignals` instead "
    "of `ReadUserBiddingSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_bidding_signals.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdsDataView(
      mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, UserType>(),
    "Attempting to read the optional `ads` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAds` instead "
    "of `ReadAds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ads.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        pointer, output, message_);
  }
  inline void GetAdComponentsDataView(
      mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdComponents(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>, UserType>(),
    "Attempting to read the optional `ad_components` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdComponents` instead "
    "of `ReadAdComponents if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_components.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        pointer, output, message_);
  }
  inline void GetKanonKeysDataView(
      mojo::ArrayDataView<KAnonKeyDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKanonKeys(UserType* output) {
    
    auto* pointer = data_->kanon_keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::auction_worklet::mojom::KAnonKeyDataView>>(
        pointer, output, message_);
  }
 private:
  internal::BidderWorkletNonSharedParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderWorkletBidDataView {
 public:
  BidderWorkletBidDataView() = default;

  BidderWorkletBidDataView(
      internal::BidderWorkletBid_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadBidRole(UserType* output) const {
    auto data_value = data_->bid_role;
    return mojo::internal::Deserialize<::auction_worklet::mojom::BidRole>(
        data_value, output);
  }
  BidRole bid_role() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::auction_worklet::mojom::BidRole>(data_->bid_role));
  }
  inline void GetAdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAd(UserType* output) {
    
    auto* pointer = data_->ad.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  double bid() const {
    return data_->bid;
  }
  inline void GetBidCurrencyDataView(
      ::blink::mojom::AdCurrencyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBidCurrency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::AdCurrencyDataView, UserType>(),
    "Attempting to read the optional `bid_currency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBidCurrency` instead "
    "of `ReadBidCurrency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bid_currency.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdCurrencyDataView>(
        pointer, output, message_);
  }
  std::optional<double> ad_cost() const {

    return data_->ad_cost_$flag
        ? std::make_optional(data_->ad_cost_$value)
        : std::nullopt;
  }
  inline void GetAdDescriptorDataView(
      ::blink::mojom::AdDescriptorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdDescriptor(UserType* output) {
    
    auto* pointer = data_->ad_descriptor.Get();
    return mojo::internal::Deserialize<::blink::mojom::AdDescriptorDataView>(
        pointer, output, message_);
  }
  inline void GetSelectedBuyerAndSellerReportingIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSelectedBuyerAndSellerReportingId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `selected_buyer_and_seller_reporting_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSelectedBuyerAndSellerReportingId` instead "
    "of `ReadSelectedBuyerAndSellerReportingId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->selected_buyer_and_seller_reporting_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAdComponentDescriptorsDataView(
      mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdComponentDescriptors(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>, UserType>(),
    "Attempting to read the optional `ad_component_descriptors` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAdComponentDescriptors` instead "
    "of `ReadAdComponentDescriptors if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ad_component_descriptors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>>(
        pointer, output, message_);
  }
  std::optional<uint16_t> modeling_signals() const {

    return data_->modeling_signals_$flag
        ? std::make_optional(data_->modeling_signals_$value)
        : std::nullopt;
  }
  inline void GetAggregateWinSignalsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAggregateWinSignals(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `aggregate_win_signals` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAggregateWinSignals` instead "
    "of `ReadAggregateWinSignals if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->aggregate_win_signals.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBidDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBidDuration(UserType* output) {
    
    auto* pointer = data_->bid_duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::BidderWorkletBid_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrioritySignalsDoubleDataView {
 public:
  PrioritySignalsDoubleDataView() = default;

  PrioritySignalsDoubleDataView(
      internal::PrioritySignalsDouble_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double value() const {
    return data_->value;
  }
 private:
  internal::PrioritySignalsDouble_Data* data_ = nullptr;
};


class GenerateBidDependencyLatenciesDataView {
 public:
  GenerateBidDependencyLatenciesDataView() = default;

  GenerateBidDependencyLatenciesDataView(
      internal::GenerateBidDependencyLatencies_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeReadyLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodeReadyLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `code_ready_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCodeReadyLatency` instead "
    "of `ReadCodeReadyLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->code_ready_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetConfigPromisesLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfigPromisesLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `config_promises_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConfigPromisesLatency` instead "
    "of `ReadConfigPromisesLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->config_promises_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDirectFromSellerSignalsLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDirectFromSellerSignalsLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `direct_from_seller_signals_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDirectFromSellerSignalsLatency` instead "
    "of `ReadDirectFromSellerSignalsLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->direct_from_seller_signals_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetTrustedBiddingSignalsLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedBiddingSignalsLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `trusted_bidding_signals_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedBiddingSignalsLatency` instead "
    "of `ReadTrustedBiddingSignalsLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_bidding_signals_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetDepsWaitStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepsWaitStartTime(UserType* output) {
    
    auto* pointer = data_->deps_wait_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetGenerateBidStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerateBidStartTime(UserType* output) {
    
    auto* pointer = data_->generate_bid_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetGenerateBidFinishTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGenerateBidFinishTime(UserType* output) {
    
    auto* pointer = data_->generate_bid_finish_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::GenerateBidDependencyLatencies_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BidderTimingMetricsDataView {
 public:
  BidderTimingMetricsDataView() = default;

  BidderTimingMetricsDataView(
      internal::BidderTimingMetrics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetJsFetchLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadJsFetchLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `js_fetch_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadJsFetchLatency` instead "
    "of `ReadJsFetchLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->js_fetch_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetWasmFetchLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWasmFetchLatency(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `wasm_fetch_latency` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWasmFetchLatency` instead "
    "of `ReadWasmFetchLatency if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->wasm_fetch_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetScriptLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScriptLatency(UserType* output) {
    
    auto* pointer = data_->script_latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool script_timed_out() const {
    return data_->script_timed_out;
  }
 private:
  internal::BidderTimingMetrics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // auction_worklet::mojom

namespace std {

template <>
struct hash<::auction_worklet::mojom::KAnonymityBidMode>
    : public mojo::internal::EnumHashImpl<::auction_worklet::mojom::KAnonymityBidMode> {};

template <>
struct hash<::auction_worklet::mojom::BidRole>
    : public mojo::internal::EnumHashImpl<::auction_worklet::mojom::BidRole> {};

template <>
struct hash<::auction_worklet::mojom::ReportingIdField>
    : public mojo::internal::EnumHashImpl<::auction_worklet::mojom::ReportingIdField> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::KAnonymityBidMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::auction_worklet::mojom::KAnonymityBidMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::KAnonymityBidMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BidRole, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::auction_worklet::mojom::BidRole, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::BidRole>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::ReportingIdField, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::auction_worklet::mojom::ReportingIdField, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::auction_worklet::mojom::ReportingIdField>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::KAnonKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::KAnonKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::KAnonKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_data, data_fragment);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in KAnonKey struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::KAnonKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::KAnonKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BidderWorkletNonSharedParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in BidderWorkletNonSharedParams struct");
    mojo::internal::Serialize<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>(
        Traits::trusted_bidding_signals_slot_size_mode(input), &fragment->trusted_bidding_signals_slot_size_mode);
    fragment->enable_bidding_signals_prioritization = Traits::enable_bidding_signals_prioritization(input);
    decltype(Traits::priority_vector(input)) in_priority_vector = Traits::priority_vector(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->priority_vector)::BaseType>
        priority_vector_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& priority_vector_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, double>>(
        in_priority_vector, priority_vector_fragment, &priority_vector_validate_params);
    fragment->priority_vector.Set(
        priority_vector_fragment.is_null() ? nullptr : priority_vector_fragment.data());
    mojo::internal::Serialize<::blink::mojom::InterestGroup_ExecutionMode>(
        Traits::execution_mode(input), &fragment->execution_mode);
    decltype(Traits::update_url(input)) in_update_url = Traits::update_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->update_url)::BaseType> update_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_update_url, update_url_fragment);
    fragment->update_url.Set(
        update_url_fragment.is_null() ? nullptr : update_url_fragment.data());
    decltype(Traits::trusted_bidding_signals_keys(input)) in_trusted_bidding_signals_keys = Traits::trusted_bidding_signals_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_bidding_signals_keys)::BaseType>
        trusted_bidding_signals_keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trusted_bidding_signals_keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_trusted_bidding_signals_keys, trusted_bidding_signals_keys_fragment, &trusted_bidding_signals_keys_validate_params);
    fragment->trusted_bidding_signals_keys.Set(
        trusted_bidding_signals_keys_fragment.is_null() ? nullptr : trusted_bidding_signals_keys_fragment.data());
    fragment->max_trusted_bidding_signals_url_length = Traits::max_trusted_bidding_signals_url_length(input);
    decltype(Traits::user_bidding_signals(input)) in_user_bidding_signals = Traits::user_bidding_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_bidding_signals)::BaseType> user_bidding_signals_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_user_bidding_signals, user_bidding_signals_fragment);
    fragment->user_bidding_signals.Set(
        user_bidding_signals_fragment.is_null() ? nullptr : user_bidding_signals_fragment.data());
    decltype(Traits::ads(input)) in_ads = Traits::ads(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ads)::BaseType>
        ads_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ads_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        in_ads, ads_fragment, &ads_validate_params);
    fragment->ads.Set(
        ads_fragment.is_null() ? nullptr : ads_fragment.data());
    decltype(Traits::ad_components(input)) in_ad_components = Traits::ad_components(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_components)::BaseType>
        ad_components_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ad_components_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>>(
        in_ad_components, ad_components_fragment, &ad_components_validate_params);
    fragment->ad_components.Set(
        ad_components_fragment.is_null() ? nullptr : ad_components_fragment.data());
    decltype(Traits::kanon_keys(input)) in_kanon_keys = Traits::kanon_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->kanon_keys)::BaseType>
        kanon_keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& kanon_keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::auction_worklet::mojom::KAnonKeyDataView>>(
        in_kanon_keys, kanon_keys_fragment, &kanon_keys_validate_params);
    fragment->kanon_keys.Set(
        kanon_keys_fragment.is_null() ? nullptr : kanon_keys_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->kanon_keys.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null kanon_keys in BidderWorkletNonSharedParams struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::BidderWorkletNonSharedParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::BidderWorkletNonSharedParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BidderWorkletBidDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BidderWorkletBidDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BidderWorkletBid_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::auction_worklet::mojom::BidRole>(
        Traits::bid_role(input), &fragment->bid_role);
    decltype(Traits::ad(input)) in_ad = Traits::ad(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad)::BaseType> ad_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_ad, ad_fragment);
    fragment->ad.Set(
        ad_fragment.is_null() ? nullptr : ad_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->ad.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ad in BidderWorkletBid struct");
    fragment->bid = Traits::bid(input);
    decltype(Traits::bid_currency(input)) in_bid_currency = Traits::bid_currency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bid_currency)::BaseType> bid_currency_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AdCurrencyDataView>(
        in_bid_currency, bid_currency_fragment);
    fragment->bid_currency.Set(
        bid_currency_fragment.is_null() ? nullptr : bid_currency_fragment.data());
    fragment->ad_cost_$flag = Traits::ad_cost(input).has_value();
    if (Traits::ad_cost(input).has_value()) {
      fragment->ad_cost_$value = Traits::ad_cost(input).value();
    }
    decltype(Traits::ad_descriptor(input)) in_ad_descriptor = Traits::ad_descriptor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_descriptor)::BaseType> ad_descriptor_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::AdDescriptorDataView>(
        in_ad_descriptor, ad_descriptor_fragment);
    fragment->ad_descriptor.Set(
        ad_descriptor_fragment.is_null() ? nullptr : ad_descriptor_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->ad_descriptor.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ad_descriptor in BidderWorkletBid struct");
    decltype(Traits::selected_buyer_and_seller_reporting_id(input)) in_selected_buyer_and_seller_reporting_id = Traits::selected_buyer_and_seller_reporting_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->selected_buyer_and_seller_reporting_id)::BaseType> selected_buyer_and_seller_reporting_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_selected_buyer_and_seller_reporting_id, selected_buyer_and_seller_reporting_id_fragment);
    fragment->selected_buyer_and_seller_reporting_id.Set(
        selected_buyer_and_seller_reporting_id_fragment.is_null() ? nullptr : selected_buyer_and_seller_reporting_id_fragment.data());
    decltype(Traits::ad_component_descriptors(input)) in_ad_component_descriptors = Traits::ad_component_descriptors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ad_component_descriptors)::BaseType>
        ad_component_descriptors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ad_component_descriptors_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>>(
        in_ad_component_descriptors, ad_component_descriptors_fragment, &ad_component_descriptors_validate_params);
    fragment->ad_component_descriptors.Set(
        ad_component_descriptors_fragment.is_null() ? nullptr : ad_component_descriptors_fragment.data());
    fragment->modeling_signals_$flag = Traits::modeling_signals(input).has_value();
    if (Traits::modeling_signals(input).has_value()) {
      fragment->modeling_signals_$value = Traits::modeling_signals(input).value();
    }
    decltype(Traits::aggregate_win_signals(input)) in_aggregate_win_signals = Traits::aggregate_win_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aggregate_win_signals)::BaseType> aggregate_win_signals_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_aggregate_win_signals, aggregate_win_signals_fragment);
    fragment->aggregate_win_signals.Set(
        aggregate_win_signals_fragment.is_null() ? nullptr : aggregate_win_signals_fragment.data());
    decltype(Traits::bid_duration(input)) in_bid_duration = Traits::bid_duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bid_duration)::BaseType> bid_duration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_bid_duration, bid_duration_fragment);
    fragment->bid_duration.Set(
        bid_duration_fragment.is_null() ? nullptr : bid_duration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bid_duration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bid_duration in BidderWorkletBid struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::BidderWorkletBid_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::BidderWorkletBidDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::PrioritySignalsDoubleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::PrioritySignalsDoubleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::PrioritySignalsDouble_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::PrioritySignalsDouble_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::PrioritySignalsDoubleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::GenerateBidDependencyLatencies_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::code_ready_latency(input)) in_code_ready_latency = Traits::code_ready_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->code_ready_latency)::BaseType> code_ready_latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_code_ready_latency, code_ready_latency_fragment);
    fragment->code_ready_latency.Set(
        code_ready_latency_fragment.is_null() ? nullptr : code_ready_latency_fragment.data());
    decltype(Traits::config_promises_latency(input)) in_config_promises_latency = Traits::config_promises_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->config_promises_latency)::BaseType> config_promises_latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_config_promises_latency, config_promises_latency_fragment);
    fragment->config_promises_latency.Set(
        config_promises_latency_fragment.is_null() ? nullptr : config_promises_latency_fragment.data());
    decltype(Traits::direct_from_seller_signals_latency(input)) in_direct_from_seller_signals_latency = Traits::direct_from_seller_signals_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->direct_from_seller_signals_latency)::BaseType> direct_from_seller_signals_latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_direct_from_seller_signals_latency, direct_from_seller_signals_latency_fragment);
    fragment->direct_from_seller_signals_latency.Set(
        direct_from_seller_signals_latency_fragment.is_null() ? nullptr : direct_from_seller_signals_latency_fragment.data());
    decltype(Traits::trusted_bidding_signals_latency(input)) in_trusted_bidding_signals_latency = Traits::trusted_bidding_signals_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_bidding_signals_latency)::BaseType> trusted_bidding_signals_latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_trusted_bidding_signals_latency, trusted_bidding_signals_latency_fragment);
    fragment->trusted_bidding_signals_latency.Set(
        trusted_bidding_signals_latency_fragment.is_null() ? nullptr : trusted_bidding_signals_latency_fragment.data());
    decltype(Traits::deps_wait_start_time(input)) in_deps_wait_start_time = Traits::deps_wait_start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->deps_wait_start_time)::BaseType> deps_wait_start_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_deps_wait_start_time, deps_wait_start_time_fragment);
    fragment->deps_wait_start_time.Set(
        deps_wait_start_time_fragment.is_null() ? nullptr : deps_wait_start_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->deps_wait_start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null deps_wait_start_time in GenerateBidDependencyLatencies struct");
    decltype(Traits::generate_bid_start_time(input)) in_generate_bid_start_time = Traits::generate_bid_start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->generate_bid_start_time)::BaseType> generate_bid_start_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_generate_bid_start_time, generate_bid_start_time_fragment);
    fragment->generate_bid_start_time.Set(
        generate_bid_start_time_fragment.is_null() ? nullptr : generate_bid_start_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->generate_bid_start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null generate_bid_start_time in GenerateBidDependencyLatencies struct");
    decltype(Traits::generate_bid_finish_time(input)) in_generate_bid_finish_time = Traits::generate_bid_finish_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->generate_bid_finish_time)::BaseType> generate_bid_finish_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_generate_bid_finish_time, generate_bid_finish_time_fragment);
    fragment->generate_bid_finish_time.Set(
        generate_bid_finish_time_fragment.is_null() ? nullptr : generate_bid_finish_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->generate_bid_finish_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null generate_bid_finish_time in GenerateBidDependencyLatencies struct");
  }

  static bool Deserialize(::auction_worklet::mojom::internal::GenerateBidDependencyLatencies_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::GenerateBidDependencyLatenciesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::auction_worklet::mojom::BidderTimingMetricsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::auction_worklet::mojom::BidderTimingMetricsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::auction_worklet::mojom::internal::BidderTimingMetrics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::js_fetch_latency(input)) in_js_fetch_latency = Traits::js_fetch_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->js_fetch_latency)::BaseType> js_fetch_latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_js_fetch_latency, js_fetch_latency_fragment);
    fragment->js_fetch_latency.Set(
        js_fetch_latency_fragment.is_null() ? nullptr : js_fetch_latency_fragment.data());
    decltype(Traits::wasm_fetch_latency(input)) in_wasm_fetch_latency = Traits::wasm_fetch_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->wasm_fetch_latency)::BaseType> wasm_fetch_latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_wasm_fetch_latency, wasm_fetch_latency_fragment);
    fragment->wasm_fetch_latency.Set(
        wasm_fetch_latency_fragment.is_null() ? nullptr : wasm_fetch_latency_fragment.data());
    decltype(Traits::script_latency(input)) in_script_latency = Traits::script_latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script_latency)::BaseType> script_latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_script_latency, script_latency_fragment);
    fragment->script_latency.Set(
        script_latency_fragment.is_null() ? nullptr : script_latency_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->script_latency.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null script_latency in BidderTimingMetrics struct");
    fragment->script_timed_out = Traits::script_timed_out(input);
  }

  static bool Deserialize(::auction_worklet::mojom::internal::BidderTimingMetrics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::auction_worklet::mojom::BidderTimingMetricsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace auction_worklet::mojom {

inline void KAnonKeyDataView::GetDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->data.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BidderWorkletNonSharedParamsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorkletNonSharedParamsDataView::GetPriorityVectorDataView(
    mojo::MapDataView<mojo::StringDataView, double>* output) {
  auto pointer = data_->priority_vector.Get();
  *output = mojo::MapDataView<mojo::StringDataView, double>(pointer, message_);
}
inline void BidderWorkletNonSharedParamsDataView::GetUpdateUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->update_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BidderWorkletNonSharedParamsDataView::GetTrustedBiddingSignalsKeysDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->trusted_bidding_signals_keys.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void BidderWorkletNonSharedParamsDataView::GetUserBiddingSignalsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_bidding_signals.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorkletNonSharedParamsDataView::GetAdsDataView(
    mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>* output) {
  auto pointer = data_->ads.Get();
  *output = mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>(pointer, message_);
}
inline void BidderWorkletNonSharedParamsDataView::GetAdComponentsDataView(
    mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>* output) {
  auto pointer = data_->ad_components.Get();
  *output = mojo::ArrayDataView<::blink::mojom::InterestGroupAdDataView>(pointer, message_);
}
inline void BidderWorkletNonSharedParamsDataView::GetKanonKeysDataView(
    mojo::ArrayDataView<KAnonKeyDataView>* output) {
  auto pointer = data_->kanon_keys.Get();
  *output = mojo::ArrayDataView<KAnonKeyDataView>(pointer, message_);
}


inline void BidderWorkletBidDataView::GetAdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->ad.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorkletBidDataView::GetBidCurrencyDataView(
    ::blink::mojom::AdCurrencyDataView* output) {
  auto pointer = data_->bid_currency.Get();
  *output = ::blink::mojom::AdCurrencyDataView(pointer, message_);
}
inline void BidderWorkletBidDataView::GetAdDescriptorDataView(
    ::blink::mojom::AdDescriptorDataView* output) {
  auto pointer = data_->ad_descriptor.Get();
  *output = ::blink::mojom::AdDescriptorDataView(pointer, message_);
}
inline void BidderWorkletBidDataView::GetSelectedBuyerAndSellerReportingIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->selected_buyer_and_seller_reporting_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorkletBidDataView::GetAdComponentDescriptorsDataView(
    mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>* output) {
  auto pointer = data_->ad_component_descriptors.Get();
  *output = mojo::ArrayDataView<::blink::mojom::AdDescriptorDataView>(pointer, message_);
}
inline void BidderWorkletBidDataView::GetAggregateWinSignalsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->aggregate_win_signals.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BidderWorkletBidDataView::GetBidDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->bid_duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}




inline void GenerateBidDependencyLatenciesDataView::GetCodeReadyLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->code_ready_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void GenerateBidDependencyLatenciesDataView::GetConfigPromisesLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->config_promises_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void GenerateBidDependencyLatenciesDataView::GetDirectFromSellerSignalsLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->direct_from_seller_signals_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void GenerateBidDependencyLatenciesDataView::GetTrustedBiddingSignalsLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->trusted_bidding_signals_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void GenerateBidDependencyLatenciesDataView::GetDepsWaitStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->deps_wait_start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void GenerateBidDependencyLatenciesDataView::GetGenerateBidStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->generate_bid_start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void GenerateBidDependencyLatenciesDataView::GetGenerateBidFinishTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->generate_bid_finish_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void BidderTimingMetricsDataView::GetJsFetchLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->js_fetch_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void BidderTimingMetricsDataView::GetWasmFetchLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->wasm_fetch_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void BidderTimingMetricsDataView::GetScriptLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->script_latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // auction_worklet::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::auction_worklet::mojom::KAnonymityBidMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::auction_worklet::mojom::KAnonymityBidMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::auction_worklet::mojom::BidRole> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::auction_worklet::mojom::BidRole value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::auction_worklet::mojom::ReportingIdField> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::auction_worklet::mojom::ReportingIdField value);
};

} // namespace perfetto

#endif  // CONTENT_SERVICES_AUCTION_WORKLET_PUBLIC_MOJOM_BIDDER_WORKLET_MOJOM_SHARED_H_