// Copyright (c) 2026 Proton AG
//
// This file is part of Proton Mail Bridge.
//
// Proton Mail Bridge is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Proton Mail Bridge is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Proton Mail Bridge. If not, see <https://www.gnu.org/licenses/>.

package versioner

import (
	"os"
	"runtime"

	"github.com/ProtonMail/proton-bridge/v3/internal/platform"
)

// fileExists returns whether the given file exists.
func fileExists(path string) bool {
	_, err := os.Stat(path)
	return err == nil
}

// fileIsExecutable returns the given filepath and true if it exists.
func fileIsExecutable(path string) bool {
	if runtime.GOOS == platform.WINDOWS {
		return true
	}

	info, err := os.Stat(path)
	if err != nil {
		return false
	}

	return info.Mode()&0o111 != 0
}
