/* Document.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Document.vala, do not modify */

/* Document.vala
 *
 * Copyright 2023-2024 Diego Iván <diegoivan.mae@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <poppler.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <exempi/xmp.h>
#include <exempi/xmpconsts.h>
#include <glib/gi18n-lib.h>

#define PAPER_CLIP_DOCUMENT_PDF_NS "http://ns.adobe.com/pdf/1.3/"
#define PAPER_CLIP_DOCUMENT_XMP_NS "http://ns.adobe.com/xap/1.0/"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PAPER_CLIP_TYPE_DOCUMENT (paper_clip_document_get_type ())
#define PAPER_CLIP_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocument))
#define PAPER_CLIP_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocumentClass))
#define PAPER_CLIP_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_DOCUMENT))
#define PAPER_CLIP_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_DOCUMENT))
#define PAPER_CLIP_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocumentClass))

typedef struct _PaperClipDocument PaperClipDocument;
typedef struct _PaperClipDocumentClass PaperClipDocumentClass;
typedef struct _PaperClipDocumentPrivate PaperClipDocumentPrivate;
enum  {
	PAPER_CLIP_DOCUMENT_0_PROPERTY,
	PAPER_CLIP_DOCUMENT_ORIGINAL_FILE_PROPERTY,
	PAPER_CLIP_DOCUMENT_CACHED_FILE_PROPERTY,
	PAPER_CLIP_DOCUMENT_HAS_XMP_PROPERTY,
	PAPER_CLIP_DOCUMENT_AUTHOR_PROPERTY,
	PAPER_CLIP_DOCUMENT_CREATOR_PROPERTY,
	PAPER_CLIP_DOCUMENT_SUBJECT_PROPERTY,
	PAPER_CLIP_DOCUMENT_TITLE_PROPERTY,
	PAPER_CLIP_DOCUMENT_PRODUCER_PROPERTY,
	PAPER_CLIP_DOCUMENT_CREATION_DATE_PROPERTY,
	PAPER_CLIP_DOCUMENT_MODIFICATION_DATE_PROPERTY,
	PAPER_CLIP_DOCUMENT_KEYWORDS_PROPERTY,
	PAPER_CLIP_DOCUMENT_FORMAT_PROPERTY,
	PAPER_CLIP_DOCUMENT_LAYOUT_PROPERTY,
	PAPER_CLIP_DOCUMENT_PRINT_DUPLEX_PROPERTY,
	PAPER_CLIP_DOCUMENT_SUBTYPE_PROPERTY,
	PAPER_CLIP_DOCUMENT_VIEWER_PREFERENCES_PROPERTY,
	PAPER_CLIP_DOCUMENT_PERMISSIONS_PROPERTY,
	PAPER_CLIP_DOCUMENT_CONTAINS_ATTACHMENTS_PROPERTY,
	PAPER_CLIP_DOCUMENT_CONTAINS_JAVASCRIPT_PROPERTY,
	PAPER_CLIP_DOCUMENT_N_PAGES_PROPERTY,
	PAPER_CLIP_DOCUMENT_NUM_PROPERTIES
};
static GParamSpec* paper_clip_document_properties[PAPER_CLIP_DOCUMENT_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PAPER_CLIP_TYPE_STRING_OBJECT (paper_clip_string_object_get_type ())
#define PAPER_CLIP_STRING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PAPER_CLIP_TYPE_STRING_OBJECT, PaperClipStringObject))
#define PAPER_CLIP_STRING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PAPER_CLIP_TYPE_STRING_OBJECT, PaperClipStringObjectClass))
#define PAPER_CLIP_IS_STRING_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PAPER_CLIP_TYPE_STRING_OBJECT))
#define PAPER_CLIP_IS_STRING_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PAPER_CLIP_TYPE_STRING_OBJECT))
#define PAPER_CLIP_STRING_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PAPER_CLIP_TYPE_STRING_OBJECT, PaperClipStringObjectClass))

typedef struct _PaperClipStringObject PaperClipStringObject;
typedef struct _PaperClipStringObjectClass PaperClipStringObjectClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef gpointer (*ThreadManagerThreadFunc) (gpointer user_data, GError** error);
typedef struct _PaperClipDocumentNewData PaperClipDocumentNewData;
#define _xmp_files_free0(var) ((var == NULL) ? NULL : (var = (xmp_files_free (var), NULL)))
#define _xmp_free0(var) ((var == NULL) ? NULL : (var = (xmp_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _PaperClipDocumentSaveData PaperClipDocumentSaveData;

#define PAPER_CLIP_TYPE_XMP_ERROR (paper_clip_xmp_error_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _PaperClipDocumentLoadDocumentData PaperClipDocumentLoadDocumentData;
typedef struct _PaperClipDocumentCreateCopyFromOriginalData PaperClipDocumentCreateCopyFromOriginalData;
enum  {
	PAPER_CLIP_DOCUMENT_KEYWORD_CHANGED_SIGNAL,
	PAPER_CLIP_DOCUMENT_NUM_SIGNALS
};
static guint paper_clip_document_signals[PAPER_CLIP_DOCUMENT_NUM_SIGNALS] = {0};
typedef struct _PaperClipStringObjectPrivate PaperClipStringObjectPrivate;
enum  {
	PAPER_CLIP_STRING_OBJECT_0_PROPERTY,
	PAPER_CLIP_STRING_OBJECT_STR_PROPERTY,
	PAPER_CLIP_STRING_OBJECT_NUM_PROPERTIES
};
static GParamSpec* paper_clip_string_object_properties[PAPER_CLIP_STRING_OBJECT_NUM_PROPERTIES];

struct _PaperClipDocument {
	GObject parent_instance;
	PaperClipDocumentPrivate * priv;
};

struct _PaperClipDocumentClass {
	GObjectClass parent_class;
};

struct _PaperClipDocumentPrivate {
	GListStore* keyword_list;
	PopplerDocument* _document;
	GFile* _original_file;
	GFile* _cached_file;
	gboolean _has_xmp;
	GRecMutex __lock_document;
};

struct _PaperClipDocumentNewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GType object_type;
	PaperClipDocument* self;
	GFile* original_file;
	gchar* password;
	gboolean _tmp0_;
	gpointer _tmp1_;
	GError* e;
	GError* _tmp2_;
	const gchar* _tmp3_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	PaperClipDocument* self;
	gchar* uri;
	gpointer _async_data_;
};

struct _PaperClipDocumentSaveData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipDocument* self;
	gchar* uri;
	Block1Data* _data1_;
	GError* e;
	GError* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_;
};

typedef enum  {
	PAPER_CLIP_XMP_ERROR_NO_XMP,
	PAPER_CLIP_XMP_ERROR_FAILED_TO_OPEN
} PaperClipXmpError;
#define PAPER_CLIP_XMP_ERROR paper_clip_xmp_error_quark ()

struct _PaperClipDocumentLoadDocumentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipDocument* self;
	gchar* password;
	GFile* _tmp0_;
	GFile* _tmp1_;
	PopplerDocument* _tmp2_;
	GFile* _tmp3_;
	PopplerDocument* _tmp4_;
	GError* _inner_error0_;
};

struct _PaperClipDocumentCreateCopyFromOriginalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PaperClipDocument* self;
	GFile* result;
	GFile* tmp_file;
	GFileIOStream* stream;
	GFile* _tmp0_;
	GFileIOStream* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GError* _vala1_e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	GError* _inner_error0_;
};

struct _PaperClipStringObject {
	GObject parent_instance;
	PaperClipStringObjectPrivate * priv;
};

struct _PaperClipStringObjectClass {
	GObjectClass parent_class;
};

struct _PaperClipStringObjectPrivate {
	gchar* _str;
};

static gint PaperClipDocument_private_offset;
static gpointer paper_clip_document_parent_class = NULL;
static gint PaperClipStringObject_private_offset;
static gpointer paper_clip_string_object_parent_class = NULL;

VALA_EXTERN GType paper_clip_document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipDocument, g_object_unref)
VALA_EXTERN GFile* paper_clip_document_get_cached_file (PaperClipDocument* self);
VALA_EXTERN GType paper_clip_string_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PaperClipStringObject, g_object_unref)
static void paper_clip_document_construct_data_free (gpointer _data);
VALA_EXTERN void paper_clip_document_new (GFile* original_file,
                              const gchar* password,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_);
VALA_EXTERN PaperClipDocument* paper_clip_document_new_finish (GAsyncResult* _res_,
                                                   GError** error);
VALA_EXTERN void paper_clip_document_construct (GType object_type,
                                    GFile* original_file,
                                    const gchar* password,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN PaperClipDocument* paper_clip_document_construct_finish (GAsyncResult* _res_,
                                                         GError** error);
static gboolean paper_clip_document_construct_co (PaperClipDocumentNewData* _data_);
static void paper_clip_document_load_document (PaperClipDocument* self,
                                        const gchar* password,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void paper_clip_document_load_document_finish (PaperClipDocument* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void paper_clip_document_new_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
VALA_EXTERN void thread_manager_run_in_thread (GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   ThreadManagerThreadFunc thread_func,
                                   gpointer thread_func_target,
                                   GDestroyNotify thread_func_target_destroy_notify,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN gpointer thread_manager_run_in_thread_finish (GAsyncResult* _res_,
                                              GError** error);
static gboolean paper_clip_document_load_xmp (PaperClipDocument* self,
                                       GError** error);
static gpointer _paper_clip_document_load_xmp_thread_manager_thread_func (gpointer self,
                                                                   GError** error);
static void paper_clip_document_set_has_xmp (PaperClipDocument* self,
                                      gboolean value);
VALA_EXTERN GFile* paper_clip_document_get_original_file (PaperClipDocument* self);
static gboolean* _bool_dup (gboolean* self);
static void paper_clip_document_save_data_free (gpointer _data);
VALA_EXTERN void paper_clip_document_save (PaperClipDocument* self,
                               const gchar* uri,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void paper_clip_document_save_finish (PaperClipDocument* self,
                                      GAsyncResult* _res_);
static gboolean paper_clip_document_save_co (PaperClipDocumentSaveData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda6_ (Block1Data* _data1_,
                  GError** error);
static void paper_clip_document_save_thread (PaperClipDocument* self,
                                      const gchar* uri,
                                      GError** error);
static gpointer ____lambda6__thread_manager_thread_func (gpointer self,
                                                  GError** error);
static void paper_clip_document_save_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_);
static PopplerDocument* paper_clip_document_get_document (PaperClipDocument* self);
static gchar* paper_clip_document_serialize_keywords (PaperClipDocument* self);
VALA_EXTERN gboolean paper_clip_document_get_has_xmp (PaperClipDocument* self);
VALA_EXTERN GQuark paper_clip_xmp_error_quark (void);
VALA_EXTERN GType paper_clip_xmp_error_get_type (void) G_GNUC_CONST ;
static void paper_clip_document_save_xmp (PaperClipDocument* self,
                                   const gchar* uri,
                                   GError** error);
VALA_EXTERN gchar* paper_clip_document_get_producer (PaperClipDocument* self);
VALA_EXTERN gchar* paper_clip_document_get_creator (PaperClipDocument* self);
VALA_EXTERN gchar* paper_clip_document_get_title (PaperClipDocument* self);
VALA_EXTERN GDateTime* paper_clip_document_get_creation_date (PaperClipDocument* self);
VALA_EXTERN GDateTime* paper_clip_document_get_modification_date (PaperClipDocument* self);
VALA_EXTERN void paper_clip_document_add_keyword (PaperClipDocument* self,
                                      const gchar* keyword);
VALA_EXTERN PaperClipStringObject* paper_clip_string_object_new (const gchar* str);
VALA_EXTERN PaperClipStringObject* paper_clip_string_object_construct (GType object_type,
                                                           const gchar* str);
static void __lambda4_ (PaperClipDocument* self);
static void ___lambda4__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
VALA_EXTERN gboolean paper_clip_document_remove_keyword (PaperClipDocument* self,
                                             const gchar* keyword);
VALA_EXTERN const gchar* paper_clip_string_object_get_str (PaperClipStringObject* self);
VALA_EXTERN PopplerPage* paper_clip_document_get_page_for_index (PaperClipDocument* self,
                                                     gint index);
static void paper_clip_document_deserialize_keywords (PaperClipDocument* self);
VALA_EXTERN GListModel* paper_clip_document_get_keywords (PaperClipDocument* self);
static gchar* paper_clip_document_layout_to_string (PaperClipDocument* self);
static gchar** paper_clip_document_viewer_preferences_to_string_array (PaperClipDocument* self,
                                                                gint* result_length1);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add9 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar** paper_clip_document_permissions_to_string_array (PaperClipDocument* self,
                                                         gint* result_length1);
static void _vala_array_add10 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add11 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add12 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add13 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add14 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add15 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add16 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add17 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gchar* paper_clip_document_print_duplex_to_string (PaperClipDocument* self);
static gchar* paper_clip_document_subtype_to_string (PaperClipDocument* self);
static void paper_clip_document_load_document_data_free (gpointer _data);
static gboolean paper_clip_document_load_document_co (PaperClipDocumentLoadDocumentData* _data_);
static void paper_clip_document_create_copy_from_original (PaperClipDocument* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static GFile* paper_clip_document_create_copy_from_original_finish (PaperClipDocument* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static void paper_clip_document_load_document_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void paper_clip_document_set_cached_file (PaperClipDocument* self,
                                          GFile* value);
static void paper_clip_document_set_document (PaperClipDocument* self,
                                       PopplerDocument* value);
static void paper_clip_document_create_copy_from_original_data_free (gpointer _data);
static gboolean paper_clip_document_create_copy_from_original_co (PaperClipDocumentCreateCopyFromOriginalData* _data_);
static void paper_clip_document_create_copy_from_original_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void paper_clip_document_set_original_file (PaperClipDocument* self,
                                            GFile* value);
VALA_EXTERN gchar* paper_clip_document_get_author (PaperClipDocument* self);
VALA_EXTERN void paper_clip_document_set_author (PaperClipDocument* self,
                                     const gchar* value);
VALA_EXTERN void paper_clip_document_set_creator (PaperClipDocument* self,
                                      const gchar* value);
VALA_EXTERN gchar* paper_clip_document_get_subject (PaperClipDocument* self);
VALA_EXTERN void paper_clip_document_set_subject (PaperClipDocument* self,
                                      const gchar* value);
VALA_EXTERN void paper_clip_document_set_title (PaperClipDocument* self,
                                    const gchar* value);
VALA_EXTERN void paper_clip_document_set_producer (PaperClipDocument* self,
                                       const gchar* value);
VALA_EXTERN void paper_clip_document_set_creation_date (PaperClipDocument* self,
                                            GDateTime* value);
VALA_EXTERN void paper_clip_document_set_modification_date (PaperClipDocument* self,
                                                GDateTime* value);
VALA_EXTERN gchar* paper_clip_document_get_format (PaperClipDocument* self);
VALA_EXTERN gchar* paper_clip_document_get_layout (PaperClipDocument* self);
VALA_EXTERN gchar* paper_clip_document_get_print_duplex (PaperClipDocument* self);
VALA_EXTERN gchar* paper_clip_document_get_subtype (PaperClipDocument* self);
VALA_EXTERN gchar** paper_clip_document_get_viewer_preferences (PaperClipDocument* self,
                                                    gint* result_length1);
VALA_EXTERN gchar** paper_clip_document_get_permissions (PaperClipDocument* self,
                                             gint* result_length1);
VALA_EXTERN gboolean paper_clip_document_get_contains_attachments (PaperClipDocument* self);
VALA_EXTERN gboolean paper_clip_document_get_contains_javascript (PaperClipDocument* self);
VALA_EXTERN gint paper_clip_document_get_n_pages (PaperClipDocument* self);
static void paper_clip_document_finalize (GObject * obj);
static GType paper_clip_document_get_type_once (void);
static void _vala_paper_clip_document_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_paper_clip_document_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
VALA_EXTERN void paper_clip_string_object_set_str (PaperClipStringObject* self,
                                       const gchar* value);
static void paper_clip_string_object_finalize (GObject * obj);
static GType paper_clip_string_object_get_type_once (void);
static void _vala_paper_clip_string_object_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_paper_clip_string_object_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
paper_clip_document_get_instance_private (PaperClipDocument* self)
{
	return G_STRUCT_MEMBER_P (self, PaperClipDocument_private_offset);
}

static void
paper_clip_document_construct_data_free (gpointer _data)
{
	PaperClipDocumentNewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->original_file);
	_g_free0 (_data_->password);
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipDocumentNewData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
paper_clip_document_construct (GType object_type,
                               GFile* original_file,
                               const gchar* password,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	PaperClipDocumentNewData* _data_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (original_file != NULL);
	_data_ = g_slice_new0 (PaperClipDocumentNewData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_document_construct_data_free);
	_data_->object_type = object_type;
	_tmp0_ = _g_object_ref0 (original_file);
	_g_object_unref0 (_data_->original_file);
	_data_->original_file = _tmp0_;
	_tmp1_ = g_strdup (password);
	_g_free0 (_data_->password);
	_data_->password = _tmp1_;
	paper_clip_document_construct_co (_data_);
}

PaperClipDocument*
paper_clip_document_construct_finish (GAsyncResult* _res_,
                                      GError** error)
{
	PaperClipDocument* result;
	PaperClipDocumentNewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->self;
	_data_->self = NULL;
	return result;
}

static void
paper_clip_document_new_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	PaperClipDocumentNewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_document_construct_co (_data_);
}

static gpointer
_paper_clip_document_load_xmp_thread_manager_thread_func (gpointer self,
                                                          GError** error)
{
	gpointer result;
	result = (gpointer) ((gintptr) paper_clip_document_load_xmp ((PaperClipDocument*) self, error));
	return result;
}

static gboolean
paper_clip_document_construct_co (PaperClipDocumentNewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self = (PaperClipDocument*) g_object_new (_data_->object_type, "original-file", _data_->original_file, NULL);
	_data_->_state_ = 1;
	paper_clip_document_load_document (_data_->self, _data_->password, paper_clip_document_new_ready, _data_);
	return FALSE;
	_state_1:
	paper_clip_document_load_document_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_state_ = 2;
		thread_manager_run_in_thread (G_TYPE_BOOLEAN, NULL, NULL, _paper_clip_document_load_xmp_thread_manager_thread_func, g_object_ref (_data_->self), g_object_unref, paper_clip_document_new_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp1_ = thread_manager_run_in_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = (gboolean) ((gintptr) _data_->_tmp1_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		paper_clip_document_set_has_xmp (_data_->self, _data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->e;
		_data_->_tmp3_ = _data_->_tmp2_->message;
		g_critical ("Document.vala:186: %s", _data_->_tmp3_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
paper_clip_document_new (GFile* original_file,
                         const gchar* password,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	paper_clip_document_construct (PAPER_CLIP_TYPE_DOCUMENT, original_file, password, _callback_, _user_data_);
}

PaperClipDocument*
paper_clip_document_new_finish (GAsyncResult* _res_,
                                GError** error)
{
	return paper_clip_document_construct_finish (_res_, error);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gboolean
paper_clip_document_load_xmp (PaperClipDocument* self,
                              GError** error)
{
	gboolean success = FALSE;
	struct _XmpFile* xmp_file = NULL;
	struct _XmpFile* _tmp0_;
	gboolean opened_file = FALSE;
	struct _XmpFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	struct _Xmp* xmp_meta = NULL;
	struct _Xmp* _tmp6_;
	struct _XmpFile* _tmp7_;
	struct _Xmp* _tmp8_;
	struct _XmpFile* _tmp9_ = NULL;
	struct _XmpFile* _tmp10_;
	gboolean* _tmp11_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	success = FALSE;
	_tmp0_ = xmp_files_new ();
	xmp_file = _tmp0_;
	_tmp1_ = xmp_file;
	_tmp2_ = self->priv->_original_file;
	_tmp3_ = g_file_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = xmp_files_open (_tmp1_, _tmp4_, (XMP_OPEN_READ | XMP_OPEN_INBACKGROUND) | XMP_OPEN_ONLYXMP);
	_g_free0 (_tmp4_);
	opened_file = _tmp5_;
	if (!opened_file) {
		g_debug ("Document.vala:205: Failed to open file with XMP");
		result = FALSE;
		_xmp_files_free0 (xmp_file);
		return result;
	}
	_tmp6_ = xmp_new_empty ();
	xmp_meta = _tmp6_;
	_tmp7_ = xmp_file;
	_tmp8_ = xmp_meta;
	success = xmp_files_get_xmp (_tmp7_, _tmp8_);
	if (!success) {
		g_debug ("Document.vala:211: File does not have XMP metadata");
	}
	_tmp10_ = xmp_file;
	_tmp9_ = _tmp10_;
	_tmp11_ = NULL;
	if (_tmp9_ != NULL) {
		gboolean _tmp12_;
		gboolean* _tmp13_;
		_tmp12_ = xmp_files_close (_tmp9_, XMP_CLOSE_NOOPTION);
		_tmp13_ = __bool_dup0 (&_tmp12_);
		_g_free0 (_tmp11_);
		_tmp11_ = _tmp13_;
	}
	result = success;
	_g_free0 (_tmp11_);
	_xmp_free0 (xmp_meta);
	_xmp_files_free0 (xmp_file);
	return result;
}

static void
paper_clip_document_save_data_free (gpointer _data)
{
	PaperClipDocumentSaveData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipDocumentSaveData, _data_);
}

void
paper_clip_document_save (PaperClipDocument* self,
                          const gchar* uri,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	PaperClipDocumentSaveData* _data_;
	PaperClipDocument* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (PaperClipDocumentSaveData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_document_save_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	paper_clip_document_save_co (_data_);
}

void
paper_clip_document_save_finish (PaperClipDocument* self,
                                 GAsyncResult* _res_)
{
	PaperClipDocumentSaveData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PaperClipDocument* self;
		self = _data1_->self;
		_g_free0 (_data1_->uri);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda6_ (Block1Data* _data1_,
             GError** error)
{
	PaperClipDocument* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	paper_clip_document_save_thread (self, _data1_->uri, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gpointer
____lambda6__thread_manager_thread_func (gpointer self,
                                         GError** error)
{
	gpointer result;
	___lambda6_ (self, error);
	result = NULL;
	return result;
}

static void
paper_clip_document_save_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_)
{
	PaperClipDocumentSaveData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_document_save_co (_data_);
}

static gboolean
paper_clip_document_save_co (PaperClipDocumentSaveData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data1_->uri);
	_data_->_data1_->uri = _data_->uri;
	_data_->_data1_->_async_data_ = _data_;
	{
		_data_->_state_ = 1;
		thread_manager_run_in_thread (G_TYPE_NONE, NULL, NULL, ____lambda6__thread_manager_thread_func, block1_data_ref (_data_->_data1_), block1_data_unref, paper_clip_document_save_ready, _data_);
		return FALSE;
		_state_1:
		thread_manager_run_in_thread_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp0_ = _data_->e;
		_data_->_tmp1_ = _data_->_tmp0_->message;
		g_critical ("Document.vala:221: %s", _data_->_tmp1_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_document_save_thread (PaperClipDocument* self,
                                 const gchar* uri,
                                 GError** error)
{
	gboolean _tmp11_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	{
		PopplerDocument* _tmp0_;
		PopplerDocument* _tmp1_;
		_tmp0_ = paper_clip_document_get_document (self);
		_tmp1_ = _tmp0_;
		g_rec_mutex_lock (&self->priv->__lock_document);
		{
			PopplerDocument* _tmp2_;
			PopplerDocument* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			PopplerDocument* _tmp6_;
			PopplerDocument* _tmp7_;
			_tmp2_ = paper_clip_document_get_document (self);
			_tmp3_ = _tmp2_;
			_tmp4_ = paper_clip_document_serialize_keywords (self);
			_tmp5_ = _tmp4_;
			poppler_document_set_keywords (_tmp3_, _tmp5_);
			_g_free0 (_tmp5_);
			_tmp6_ = paper_clip_document_get_document (self);
			_tmp7_ = _tmp6_;
			poppler_document_save (_tmp7_, uri, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp8_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp8_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			PopplerDocument* _tmp9_;
			PopplerDocument* _tmp10_;
			_tmp9_ = paper_clip_document_get_document (self);
			_tmp10_ = _tmp9_;
			g_rec_mutex_unlock (&self->priv->__lock_document);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	_tmp11_ = self->priv->_has_xmp;
	if (_tmp11_) {
		paper_clip_document_save_xmp (self, uri, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
__vala_xmp_set_property_date (struct _Xmp* self,
                              const gchar* schema,
                              const gchar* name,
                              GDateTime* value,
                              guint32 option_bits)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (schema != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = g_date_time_format_iso8601 (value);
	_tmp1_ = _tmp0_;
	_tmp2_ = xmp_set_property (self, schema, name, _tmp1_, option_bits);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
paper_clip_document_save_xmp (PaperClipDocument* self,
                              const gchar* uri,
                              GError** error)
{
	struct _XmpFile* xmp_file = NULL;
	struct _XmpFile* _tmp0_;
	XmpOpenFileOptions options = 0U;
	GFile* file = NULL;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gboolean success = FALSE;
	struct _XmpFile* _tmp4_;
	const gchar* _tmp5_;
	struct _Xmp* xmp_meta = NULL;
	struct _Xmp* _tmp14_;
	gboolean has_meta = FALSE;
	struct _XmpFile* _tmp15_;
	struct _Xmp* _tmp16_;
	struct _Xmp* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	struct _Xmp* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	struct _Xmp* _tmp31_;
	PopplerDocument* _tmp32_;
	PopplerDocument* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	struct _Xmp* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GDateTime* _tmp41_;
	GDateTime* _tmp42_;
	GDateTime* _tmp43_;
	gboolean _tmp44_;
	GDateTime* _tmp50_;
	GDateTime* _tmp51_;
	GDateTime* _tmp52_;
	gboolean _tmp53_;
	GDateTime* metadata_date = NULL;
	GDateTime* _tmp59_;
	struct _Xmp* _tmp60_;
	GDateTime* _tmp61_;
	struct _XmpFile* _tmp62_;
	struct _Xmp* _tmp63_;
	struct _XmpFile* _tmp66_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = xmp_files_new ();
	xmp_file = _tmp0_;
	options = XMP_OPEN_FORUPDATE | XMP_OPEN_INBACKGROUND;
	_tmp1_ = g_file_new_for_uri (uri);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_path (_tmp2_);
	path = _tmp3_;
	_tmp4_ = xmp_file;
	_tmp5_ = path;
	success = xmp_files_open (_tmp4_, _tmp5_, options);
	if (!success) {
		gint _error_ = 0;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_error_ = xmp_get_error ();
		_tmp6_ = path;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strdup_printf ("%i", _error_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Failed to open ", _tmp7_, " XMP metadata. Error: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (PAPER_CLIP_XMP_ERROR, PAPER_CLIP_XMP_ERROR_FAILED_TO_OPEN, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_inner_error0_ = _tmp13_;
		if (_inner_error0_->domain == PAPER_CLIP_XMP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (path);
			_g_object_unref0 (file);
			_xmp_files_free0 (xmp_file);
			return;
		} else {
			_g_free0 (path);
			_g_object_unref0 (file);
			_xmp_files_free0 (xmp_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp14_ = xmp_new_empty ();
	xmp_meta = _tmp14_;
	_tmp15_ = xmp_file;
	_tmp16_ = xmp_meta;
	has_meta = xmp_files_get_xmp (_tmp15_, _tmp16_);
	if (!has_meta) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		GError* _tmp21_;
		GError* _tmp22_;
		_tmp17_ = path;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat (_tmp18_, " has no XMP Metadata", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new_literal (PAPER_CLIP_XMP_ERROR, PAPER_CLIP_XMP_ERROR_NO_XMP, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_inner_error0_ = _tmp22_;
		if (_inner_error0_->domain == PAPER_CLIP_XMP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_xmp_free0 (xmp_meta);
			_g_free0 (path);
			_g_object_unref0 (file);
			_xmp_files_free0 (xmp_file);
			return;
		} else {
			_xmp_free0 (xmp_meta);
			_g_free0 (path);
			_g_object_unref0 (file);
			_xmp_files_free0 (xmp_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp23_ = xmp_meta;
	_tmp24_ = paper_clip_document_get_producer (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	xmp_set_property (_tmp23_, NS_PDF, "Producer", _tmp26_, (guint32) 0x0);
	_g_free0 (_tmp26_);
	_tmp27_ = xmp_meta;
	_tmp28_ = paper_clip_document_get_creator (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp29_;
	xmp_set_property (_tmp27_, NS_XAP, "CreatorTool", _tmp30_, (guint32) 0x0);
	_g_free0 (_tmp30_);
	_tmp31_ = xmp_meta;
	_tmp32_ = paper_clip_document_get_document (self);
	_tmp33_ = _tmp32_;
	_tmp34_ = poppler_document_get_keywords (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	xmp_set_property (_tmp31_, NS_PDF, "Keywords", _tmp36_, (guint32) 0x0);
	_g_free0 (_tmp36_);
	_tmp37_ = xmp_meta;
	_tmp38_ = paper_clip_document_get_title (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_;
	xmp_set_localized_text (_tmp37_, NS_DC, "title", "x", "x-default", _tmp40_, (guint32) 0x0);
	_g_free0 (_tmp40_);
	_tmp41_ = paper_clip_document_get_creation_date (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_ == NULL;
	_g_date_time_unref0 (_tmp43_);
	if (_tmp44_) {
		struct _Xmp* _tmp45_;
		_tmp45_ = xmp_meta;
		xmp_delete_property (_tmp45_, NS_XAP, "CreateDate");
	} else {
		struct _Xmp* _tmp46_;
		GDateTime* _tmp47_;
		GDateTime* _tmp48_;
		GDateTime* _tmp49_;
		_tmp46_ = xmp_meta;
		_tmp47_ = paper_clip_document_get_creation_date (self);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_;
		__vala_xmp_set_property_date (_tmp46_, NS_XAP, "CreateDate", _tmp49_, (guint32) 0x0);
		_g_date_time_unref0 (_tmp49_);
	}
	_tmp50_ = paper_clip_document_get_modification_date (self);
	_tmp51_ = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp53_ = _tmp52_ == NULL;
	_g_date_time_unref0 (_tmp52_);
	if (_tmp53_) {
		struct _Xmp* _tmp54_;
		_tmp54_ = xmp_meta;
		xmp_delete_property (_tmp54_, NS_XAP, "ModifyDate");
	} else {
		struct _Xmp* _tmp55_;
		GDateTime* _tmp56_;
		GDateTime* _tmp57_;
		GDateTime* _tmp58_;
		_tmp55_ = xmp_meta;
		_tmp56_ = paper_clip_document_get_modification_date (self);
		_tmp57_ = _tmp56_;
		_tmp58_ = _tmp57_;
		__vala_xmp_set_property_date (_tmp55_, NS_XAP, "ModifyDate", _tmp58_, (guint32) 0x0);
		_g_date_time_unref0 (_tmp58_);
	}
	_tmp59_ = g_date_time_new_now_local ();
	metadata_date = _tmp59_;
	_tmp60_ = xmp_meta;
	_tmp61_ = metadata_date;
	__vala_xmp_set_property_date (_tmp60_, NS_XAP, "MetadataDate", _tmp61_, (guint32) 0x0);
	_tmp62_ = xmp_file;
	_tmp63_ = xmp_meta;
	if (xmp_files_can_put_xmp (_tmp62_, _tmp63_)) {
		struct _XmpFile* _tmp64_;
		struct _Xmp* _tmp65_;
		g_debug ("Document.vala:275: Writing XMP Metadata");
		_tmp64_ = xmp_file;
		_tmp65_ = xmp_meta;
		xmp_files_put_xmp (_tmp64_, _tmp65_);
	}
	_tmp66_ = xmp_file;
	xmp_files_close (_tmp66_, XMP_CLOSE_SAFEUPDATE);
	_g_date_time_unref0 (metadata_date);
	_xmp_free0 (xmp_meta);
	_g_free0 (path);
	_g_object_unref0 (file);
	_xmp_files_free0 (xmp_file);
}

static void
__lambda4_ (PaperClipDocument* self)
{
	g_signal_emit (self, paper_clip_document_signals[PAPER_CLIP_DOCUMENT_KEYWORD_CHANGED_SIGNAL], 0);
}

static void
___lambda4__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda4_ ((PaperClipDocument*) self);
}

void
paper_clip_document_add_keyword (PaperClipDocument* self,
                                 const gchar* keyword)
{
	PaperClipStringObject* keyword_object = NULL;
	PaperClipStringObject* _tmp0_;
	GListStore* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keyword != NULL);
	_tmp0_ = paper_clip_string_object_new (keyword);
	keyword_object = _tmp0_;
	g_signal_connect_object ((GObject*) keyword_object, "notify::str", (GCallback) ___lambda4__g_object_notify, self, 0);
	_tmp1_ = self->priv->keyword_list;
	g_list_store_append (_tmp1_, (GObject*) keyword_object);
	_g_object_unref0 (keyword_object);
}

gboolean
paper_clip_document_remove_keyword (PaperClipDocument* self,
                                    const gchar* keyword)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keyword != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				PaperClipStringObject* item = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				PaperClipStringObject* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->keyword_list;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->keyword_list;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, PAPER_CLIP_TYPE_STRING_OBJECT, PaperClipStringObject);
				_tmp5_ = item;
				_tmp6_ = paper_clip_string_object_get_str (_tmp5_);
				_tmp7_ = _tmp6_;
				if (g_strcmp0 (keyword, _tmp7_) == 0) {
					GListStore* _tmp8_;
					_tmp8_ = self->priv->keyword_list;
					g_list_store_remove (_tmp8_, (guint) i);
					result = TRUE;
					_g_object_unref0 (item);
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	return result;
}

PopplerPage*
paper_clip_document_get_page_for_index (PaperClipDocument* self,
                                        gint index)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	PopplerPage* _tmp2_;
	PopplerPage* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = poppler_document_get_page (_tmp1_, index);
	result = _tmp2_;
	return result;
}

static void
paper_clip_document_deserialize_keywords (PaperClipDocument* self)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar** keyword_array = NULL;
	PopplerDocument* _tmp6_;
	PopplerDocument* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint keyword_array_length1;
	gint _keyword_array_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = poppler_document_get_keywords (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		return;
	}
	_tmp6_ = paper_clip_document_get_document (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = poppler_document_get_keywords (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, ",", 0);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _vala_array_length (_tmp11_);
	_g_free0 (_tmp10_);
	keyword_array = _tmp13_;
	keyword_array_length1 = _tmp13__length1;
	_keyword_array_size_ = keyword_array_length1;
	_tmp14_ = keyword_array;
	_tmp14__length1 = keyword_array_length1;
	{
		gchar** keyword_collection = NULL;
		gint keyword_collection_length1 = 0;
		gint _keyword_collection_size_ = 0;
		gint keyword_it = 0;
		keyword_collection = _tmp14_;
		keyword_collection_length1 = _tmp14__length1;
		for (keyword_it = 0; keyword_it < keyword_collection_length1; keyword_it = keyword_it + 1) {
			gchar* _tmp15_;
			gchar* keyword = NULL;
			_tmp15_ = g_strdup (keyword_collection[keyword_it]);
			keyword = _tmp15_;
			{
				const gchar* _tmp16_;
				_tmp16_ = keyword;
				paper_clip_document_add_keyword (self, _tmp16_);
				_g_free0 (keyword);
			}
		}
	}
	keyword_array = (_vala_array_free (keyword_array, keyword_array_length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
paper_clip_document_serialize_keywords (PaperClipDocument* self)
{
	gchar* format = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	format = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GListStore* _tmp3_;
				PaperClipStringObject* item = NULL;
				GListStore* _tmp4_;
				GObject* _tmp5_;
				const gchar* _tmp6_;
				PaperClipStringObject* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GListModel* _tmp13_;
				GListModel* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->keyword_list;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					break;
				}
				_tmp4_ = self->priv->keyword_list;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, PAPER_CLIP_TYPE_STRING_OBJECT, PaperClipStringObject);
				_tmp6_ = format;
				_tmp7_ = item;
				_tmp8_ = paper_clip_string_object_get_str (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strdup_printf ("%s", _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
				_g_free0 (format);
				format = _tmp12_;
				_g_free0 (_tmp11_);
				_tmp13_ = paper_clip_document_get_keywords (self);
				_tmp14_ = _tmp13_;
				if (((guint) i) == (g_list_model_get_n_items (_tmp14_) - 1)) {
					_g_object_unref0 (item);
					break;
				}
				_tmp15_ = format;
				_tmp16_ = g_strconcat (_tmp15_, ",", NULL);
				_g_free0 (format);
				format = _tmp16_;
				_g_object_unref0 (item);
			}
		}
	}
	result = format;
	return result;
}

static gchar*
paper_clip_document_layout_to_string (PaperClipDocument* self)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	PopplerPageLayout _tmp2_;
	PopplerPageLayout _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = poppler_document_get_page_layout (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case POPPLER_PAGE_LAYOUT_ONE_COLUMN:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Pages in one column"));
			result = _tmp4_;
			return result;
		}
		case POPPLER_PAGE_LAYOUT_SINGLE_PAGE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("One page at a time"));
			result = _tmp5_;
			return result;
		}
		case POPPLER_PAGE_LAYOUT_TWO_COLUMN_LEFT:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Odd numbered pages on the left"));
			result = _tmp6_;
			return result;
		}
		case POPPLER_PAGE_LAYOUT_TWO_COLUMN_RIGHT:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Odd numbered pages on the right"));
			result = _tmp7_;
			return result;
		}
		case POPPLER_PAGE_LAYOUT_TWO_PAGE_LEFT:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Two odd numbered pages on the left"));
			result = _tmp8_;
			return result;
		}
		case POPPLER_PAGE_LAYOUT_TWO_PAGE_RIGHT:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Two odd numbered pages on the right"));
			result = _tmp9_;
			return result;
		}
		default:
		case POPPLER_PAGE_LAYOUT_UNSET:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup (_ ("No specific layout"));
			result = _tmp10_;
			return result;
		}
	}
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add9 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
paper_clip_document_viewer_preferences_to_string_array (PaperClipDocument* self,
                                                        gint* result_length1)
{
	gchar** preferences_array = NULL;
	gchar** _tmp0_;
	gint preferences_array_length1;
	gint _preferences_array_size_;
	PopplerViewerPreferences preferences = 0U;
	PopplerDocument* _tmp1_;
	PopplerDocument* _tmp2_;
	PopplerViewerPreferences _tmp3_;
	PopplerViewerPreferences _tmp4_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	preferences_array = _tmp0_;
	preferences_array_length1 = 0;
	_preferences_array_size_ = preferences_array_length1;
	_tmp1_ = paper_clip_document_get_document (self);
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "viewer-preferences", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	preferences = _tmp4_;
	if ((preferences & POPPLER_VIEWER_PREFERENCES_CENTER_WINDOW) == POPPLER_VIEWER_PREFERENCES_CENTER_WINDOW) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Center document's window"));
		_vala_array_add2 (&preferences_array, &preferences_array_length1, &_preferences_array_size_, _tmp5_);
	}
	if ((preferences & POPPLER_VIEWER_PREFERENCES_DIRECTION_RTL) == POPPLER_VIEWER_PREFERENCES_DIRECTION_RTL) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (_ ("Reading order is right to left"));
		_vala_array_add3 (&preferences_array, &preferences_array_length1, &_preferences_array_size_, _tmp6_);
	}
	if ((preferences & POPPLER_VIEWER_PREFERENCES_DISPLAY_DOC_TITLE) == POPPLER_VIEWER_PREFERENCES_DISPLAY_DOC_TITLE) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (_ ("Display document's title"));
		_vala_array_add4 (&preferences_array, &preferences_array_length1, &_preferences_array_size_, _tmp7_);
	}
	if ((preferences & POPPLER_VIEWER_PREFERENCES_FIT_WINDOW) == POPPLER_VIEWER_PREFERENCES_FIT_WINDOW) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (_ ("Fit document to window"));
		_vala_array_add5 (&preferences_array, &preferences_array_length1, &_preferences_array_size_, _tmp8_);
	}
	if ((preferences & POPPLER_VIEWER_PREFERENCES_HIDE_MENUBAR) == POPPLER_VIEWER_PREFERENCES_HIDE_MENUBAR) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (_ ("Hide window menubar"));
		_vala_array_add6 (&preferences_array, &preferences_array_length1, &_preferences_array_size_, _tmp9_);
	}
	if ((preferences & POPPLER_VIEWER_PREFERENCES_HIDE_TOOLBAR) == POPPLER_VIEWER_PREFERENCES_HIDE_TOOLBAR) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (_ ("Hide window toolbars"));
		_vala_array_add7 (&preferences_array, &preferences_array_length1, &_preferences_array_size_, _tmp10_);
	}
	if ((preferences & POPPLER_VIEWER_PREFERENCES_HIDE_WINDOWUI) == POPPLER_VIEWER_PREFERENCES_HIDE_WINDOWUI) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup (_ ("Hide UI elements"));
		_vala_array_add8 (&preferences_array, &preferences_array_length1, &_preferences_array_size_, _tmp11_);
	}
	if ((preferences & POPPLER_VIEWER_PREFERENCES_UNSET) == POPPLER_VIEWER_PREFERENCES_UNSET) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup (_ ("No preferences"));
		_vala_array_add9 (&preferences_array, &preferences_array_length1, &_preferences_array_size_, _tmp12_);
	}
	_tmp13_ = preferences_array;
	_tmp13__length1 = preferences_array_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	return result;
}

static void
_vala_array_add10 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add11 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add12 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add13 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add14 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add15 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add16 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add17 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
paper_clip_document_permissions_to_string_array (PaperClipDocument* self,
                                                 gint* result_length1)
{
	gchar** permission_array = NULL;
	gchar** _tmp0_;
	gint permission_array_length1;
	gint _permission_array_size_;
	PopplerPermissions permission_flags = 0U;
	PopplerDocument* _tmp1_;
	PopplerDocument* _tmp2_;
	PopplerPermissions _tmp3_;
	PopplerPermissions _tmp4_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	permission_array = _tmp0_;
	permission_array_length1 = 0;
	_permission_array_size_ = permission_array_length1;
	_tmp1_ = paper_clip_document_get_document (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = poppler_document_get_permissions (_tmp2_);
	_tmp4_ = _tmp3_;
	permission_flags = _tmp4_;
	if ((permission_flags & POPPLER_PERMISSIONS_OK_TO_ADD_NOTES) == POPPLER_PERMISSIONS_OK_TO_ADD_NOTES) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Adding notes"));
		_vala_array_add10 (&permission_array, &permission_array_length1, &_permission_array_size_, _tmp5_);
	}
	if ((permission_flags & POPPLER_PERMISSIONS_OK_TO_ASSEMBLE) == POPPLER_PERMISSIONS_OK_TO_ASSEMBLE) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (_ ("Inserting elements"));
		_vala_array_add11 (&permission_array, &permission_array_length1, &_permission_array_size_, _tmp6_);
	}
	if ((permission_flags & POPPLER_PERMISSIONS_OK_TO_COPY) == POPPLER_PERMISSIONS_OK_TO_COPY) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (_ ("Copying"));
		_vala_array_add12 (&permission_array, &permission_array_length1, &_permission_array_size_, _tmp7_);
	}
	if ((permission_flags & POPPLER_PERMISSIONS_OK_TO_EXTRACT_CONTENTS) == POPPLER_PERMISSIONS_OK_TO_EXTRACT_CONTENTS) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (_ ("Extracting contents"));
		_vala_array_add13 (&permission_array, &permission_array_length1, &_permission_array_size_, _tmp8_);
	}
	if ((permission_flags & POPPLER_PERMISSIONS_OK_TO_FILL_FORM) == POPPLER_PERMISSIONS_OK_TO_FILL_FORM) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (_ ("Filling interactive forms"));
		_vala_array_add14 (&permission_array, &permission_array_length1, &_permission_array_size_, _tmp9_);
	}
	if ((permission_flags & POPPLER_PERMISSIONS_OK_TO_MODIFY) == POPPLER_PERMISSIONS_OK_TO_MODIFY) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (_ ("Modifying"));
		_vala_array_add15 (&permission_array, &permission_array_length1, &_permission_array_size_, _tmp10_);
	}
	if ((permission_flags & POPPLER_PERMISSIONS_OK_TO_PRINT) == POPPLER_PERMISSIONS_OK_TO_PRINT) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup (_ ("Printing"));
		_vala_array_add16 (&permission_array, &permission_array_length1, &_permission_array_size_, _tmp11_);
	}
	if ((permission_flags & POPPLER_PERMISSIONS_OK_TO_PRINT_HIGH_RESOLUTION) == POPPLER_PERMISSIONS_OK_TO_PRINT_HIGH_RESOLUTION) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup (_ ("Printing in high resolution"));
		_vala_array_add17 (&permission_array, &permission_array_length1, &_permission_array_size_, _tmp12_);
	}
	_tmp13_ = permission_array;
	_tmp13__length1 = permission_array_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	return result;
}

static gchar*
paper_clip_document_print_duplex_to_string (PaperClipDocument* self)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	PopplerPrintDuplex _tmp2_;
	PopplerPrintDuplex _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = poppler_document_get_print_duplex (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_LONG_EDGE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Flip on the long edge"));
			result = _tmp4_;
			return result;
		}
		case POPPLER_PRINT_DUPLEX_DUPLEX_FLIP_SHORT_EDGE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Flip on the short edge"));
			result = _tmp5_;
			return result;
		}
		case POPPLER_PRINT_DUPLEX_SIMPLEX:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("Only single sided"));
			result = _tmp6_;
			return result;
		}
		default:
		case POPPLER_PRINT_DUPLEX_NONE:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("No preference"));
			result = _tmp7_;
			return result;
		}
	}
}

static gchar*
paper_clip_document_subtype_to_string (PaperClipDocument* self)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	PopplerPDFSubtype _tmp2_;
	PopplerPDFSubtype _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "subtype", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case POPPLER_PDF_SUBTYPE_PDF_A:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("ISO 19005");
			result = _tmp4_;
			return result;
		}
		case POPPLER_PDF_SUBTYPE_PDF_E:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("ISO 24517");
			result = _tmp5_;
			return result;
		}
		case POPPLER_PDF_SUBTYPE_PDF_UA:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("ISO 14289");
			result = _tmp6_;
			return result;
		}
		case POPPLER_PDF_SUBTYPE_PDF_VT:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("ISO 16612");
			result = _tmp7_;
			return result;
		}
		case POPPLER_PDF_SUBTYPE_PDF_X:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup ("ISO 15930");
			result = _tmp8_;
			return result;
		}
		default:
		case POPPLER_PDF_SUBTYPE_UNSET:
		case POPPLER_PDF_SUBTYPE_NONE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Not compliant"));
			result = _tmp9_;
			return result;
		}
	}
}

static void
paper_clip_document_load_document_data_free (gpointer _data)
{
	PaperClipDocumentLoadDocumentData* _data_;
	_data_ = _data;
	_g_free0 (_data_->password);
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipDocumentLoadDocumentData, _data_);
}

static void
paper_clip_document_load_document (PaperClipDocument* self,
                                   const gchar* password,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	PaperClipDocumentLoadDocumentData* _data_;
	PaperClipDocument* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipDocumentLoadDocumentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_document_load_document_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (password);
	_g_free0 (_data_->password);
	_data_->password = _tmp1_;
	paper_clip_document_load_document_co (_data_);
}

static void
paper_clip_document_load_document_finish (PaperClipDocument* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	PaperClipDocumentLoadDocumentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
paper_clip_document_load_document_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	PaperClipDocumentLoadDocumentData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_document_load_document_co (_data_);
}

static gboolean
paper_clip_document_load_document_co (PaperClipDocumentLoadDocumentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	paper_clip_document_create_copy_from_original (_data_->self, paper_clip_document_load_document_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = paper_clip_document_create_copy_from_original_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	paper_clip_document_set_cached_file (_data_->self, _data_->_tmp0_);
	_data_->_tmp3_ = _data_->self->priv->_cached_file;
	_data_->_tmp4_ = poppler_document_new_from_gfile (_data_->_tmp3_, _data_->password, NULL, &_data_->_inner_error0_);
	_data_->_tmp2_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	paper_clip_document_set_document (_data_->self, _data_->_tmp2_);
	_g_object_unref0 (_data_->_tmp2_);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
paper_clip_document_create_copy_from_original_data_free (gpointer _data)
{
	PaperClipDocumentCreateCopyFromOriginalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PaperClipDocumentCreateCopyFromOriginalData, _data_);
}

static void
paper_clip_document_create_copy_from_original (PaperClipDocument* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	PaperClipDocumentCreateCopyFromOriginalData* _data_;
	PaperClipDocument* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PaperClipDocumentCreateCopyFromOriginalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, paper_clip_document_create_copy_from_original_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	paper_clip_document_create_copy_from_original_co (_data_);
}

static GFile*
paper_clip_document_create_copy_from_original_finish (PaperClipDocument* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	GFile* result;
	PaperClipDocumentCreateCopyFromOriginalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
paper_clip_document_create_copy_from_original_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	PaperClipDocumentCreateCopyFromOriginalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	paper_clip_document_create_copy_from_original_co (_data_);
}

static gboolean
paper_clip_document_create_copy_from_original_co (PaperClipDocumentCreateCopyFromOriginalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp2_ = g_file_new_tmp ("pdf-metadata-editor-XXXXXX.pdf", &_data_->_tmp1_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->stream);
		_data_->stream = _data_->_tmp1_;
		_data_->_tmp0_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->tmp_file);
		_data_->tmp_file = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		_data_->_tmp6_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to create temporary file: %s", _data_->_tmp5_);
		_data_->_inner_error0_ = _data_->_tmp6_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stream);
		_g_object_unref0 (_data_->tmp_file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = _data_->self->priv->_original_file;
		_data_->_tmp8_ = _data_->tmp_file;
		_data_->_state_ = 1;
		g_file_copy_async (_data_->_tmp7_, _data_->_tmp8_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, NULL, NULL, paper_clip_document_create_copy_from_original_ready, _data_);
		return FALSE;
		_state_1:
		g_file_copy_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = _data_->_vala1_e;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		_data_->_tmp11_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to copy file to temporary location: %s", _data_->_tmp10_);
		_data_->_inner_error0_ = _data_->_tmp11_;
		_g_error_free0 (_data_->_vala1_e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->stream);
		_g_object_unref0 (_data_->tmp_file);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->tmp_file;
	_g_object_unref0 (_data_->stream);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static PopplerDocument*
paper_clip_document_get_document (PaperClipDocument* self)
{
	PopplerDocument* result;
	PopplerDocument* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_document;
	result = _tmp0_;
	return result;
}

static void
paper_clip_document_set_document (PaperClipDocument* self,
                                  PopplerDocument* value)
{
	PopplerDocument* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_document);
	self->priv->_document = _tmp0_;
	paper_clip_document_deserialize_keywords (self);
}

GFile*
paper_clip_document_get_original_file (PaperClipDocument* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_original_file;
	result = _tmp0_;
	return result;
}

static void
paper_clip_document_set_original_file (PaperClipDocument* self,
                                       GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = paper_clip_document_get_original_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_original_file);
		self->priv->_original_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_ORIGINAL_FILE_PROPERTY]);
	}
}

GFile*
paper_clip_document_get_cached_file (PaperClipDocument* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cached_file;
	result = _tmp0_;
	return result;
}

static void
paper_clip_document_set_cached_file (PaperClipDocument* self,
                                     GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = paper_clip_document_get_cached_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cached_file);
		self->priv->_cached_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_CACHED_FILE_PROPERTY]);
	}
}

gboolean
paper_clip_document_get_has_xmp (PaperClipDocument* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_xmp;
	return result;
}

static void
paper_clip_document_set_has_xmp (PaperClipDocument* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_xmp = value;
}

gchar*
paper_clip_document_get_author (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	PopplerDocument* _tmp1_;
	PopplerDocument* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = paper_clip_document_get_document (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = poppler_document_get_author (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}

void
paper_clip_document_set_author (PaperClipDocument* self,
                                const gchar* value)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	poppler_document_set_author (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_AUTHOR_PROPERTY]);
}

gchar*
paper_clip_document_get_creator (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	PopplerDocument* _tmp1_;
	PopplerDocument* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = paper_clip_document_get_document (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = poppler_document_get_creator (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}

void
paper_clip_document_set_creator (PaperClipDocument* self,
                                 const gchar* value)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	poppler_document_set_creator (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_CREATOR_PROPERTY]);
}

gchar*
paper_clip_document_get_subject (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	PopplerDocument* _tmp1_;
	PopplerDocument* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = paper_clip_document_get_document (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = poppler_document_get_subject (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}

void
paper_clip_document_set_subject (PaperClipDocument* self,
                                 const gchar* value)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	poppler_document_set_subject (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_SUBJECT_PROPERTY]);
}

gchar*
paper_clip_document_get_title (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	PopplerDocument* _tmp1_;
	PopplerDocument* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = paper_clip_document_get_document (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = poppler_document_get_title (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}

void
paper_clip_document_set_title (PaperClipDocument* self,
                               const gchar* value)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	poppler_document_set_title (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_TITLE_PROPERTY]);
}

gchar*
paper_clip_document_get_producer (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	PopplerDocument* _tmp1_;
	PopplerDocument* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = paper_clip_document_get_document (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = poppler_document_get_producer (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}

void
paper_clip_document_set_producer (PaperClipDocument* self,
                                  const gchar* value)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	poppler_document_set_producer (_tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_PRODUCER_PROPERTY]);
}

GDateTime*
paper_clip_document_get_creation_date (PaperClipDocument* self)
{
	GDateTime* result;
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "creation-datetime", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

void
paper_clip_document_set_creation_date (PaperClipDocument* self,
                                       GDateTime* value)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	g_object_set (_tmp1_, "creation-datetime", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_CREATION_DATE_PROPERTY]);
}

GDateTime*
paper_clip_document_get_modification_date (PaperClipDocument* self)
{
	GDateTime* result;
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "mod-datetime", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

void
paper_clip_document_set_modification_date (PaperClipDocument* self,
                                           GDateTime* value)
{
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	g_object_set (_tmp1_, "mod-datetime", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_MODIFICATION_DATE_PROPERTY]);
}

GListModel*
paper_clip_document_get_keywords (PaperClipDocument* self)
{
	GListModel* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->keyword_list;
	result = (GListModel*) _tmp0_;
	return result;
}

gchar*
paper_clip_document_get_format (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_ = NULL;
	PopplerDocument* _tmp1_;
	PopplerDocument* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = paper_clip_document_get_document (self);
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "format", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Unknown"));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}

gchar*
paper_clip_document_get_layout (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_layout_to_string (self);
	result = _tmp0_;
	return result;
}

gchar*
paper_clip_document_get_print_duplex (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_print_duplex_to_string (self);
	result = _tmp0_;
	return result;
}

gchar*
paper_clip_document_get_subtype (PaperClipDocument* self)
{
	gchar* result;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = paper_clip_document_subtype_to_string (self);
	result = _tmp0_;
	return result;
}

gchar**
paper_clip_document_get_viewer_preferences (PaperClipDocument* self,
                                            gint* result_length1)
{
	gchar** result;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = paper_clip_document_viewer_preferences_to_string_array (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar**
paper_clip_document_get_permissions (PaperClipDocument* self,
                                     gint* result_length1)
{
	gchar** result;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = paper_clip_document_permissions_to_string_array (self, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gboolean
paper_clip_document_get_contains_attachments (PaperClipDocument* self)
{
	gboolean result;
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	result = poppler_document_has_attachments (_tmp1_);
	return result;
}

gboolean
paper_clip_document_get_contains_javascript (PaperClipDocument* self)
{
	gboolean result;
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	result = poppler_document_has_javascript (_tmp1_);
	return result;
}

gint
paper_clip_document_get_n_pages (PaperClipDocument* self)
{
	gint result;
	PopplerDocument* _tmp0_;
	PopplerDocument* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = paper_clip_document_get_document (self);
	_tmp1_ = _tmp0_;
	result = poppler_document_get_n_pages (_tmp1_);
	return result;
}

static void
paper_clip_document_class_init (PaperClipDocumentClass * klass,
                                gpointer klass_data)
{
	paper_clip_document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PaperClipDocument_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_paper_clip_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_paper_clip_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = paper_clip_document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_ORIGINAL_FILE_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_ORIGINAL_FILE_PROPERTY] = g_param_spec_object ("original-file", "original-file", "original-file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_CACHED_FILE_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_CACHED_FILE_PROPERTY] = g_param_spec_object ("cached-file", "cached-file", "cached-file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_HAS_XMP_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_HAS_XMP_PROPERTY] = g_param_spec_boolean ("has-xmp", "has-xmp", "has-xmp", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_AUTHOR_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_AUTHOR_PROPERTY] = g_param_spec_string ("author", "author", "author", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_CREATOR_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_CREATOR_PROPERTY] = g_param_spec_string ("creator", "creator", "creator", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_SUBJECT_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_SUBJECT_PROPERTY] = g_param_spec_string ("subject", "subject", "subject", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_TITLE_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_PRODUCER_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_PRODUCER_PROPERTY] = g_param_spec_string ("producer", "producer", "producer", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_CREATION_DATE_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_CREATION_DATE_PROPERTY] = g_param_spec_boxed ("creation-date", "creation-date", "creation-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_MODIFICATION_DATE_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_MODIFICATION_DATE_PROPERTY] = g_param_spec_boxed ("modification-date", "modification-date", "modification-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_KEYWORDS_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_KEYWORDS_PROPERTY] = g_param_spec_object ("keywords", "keywords", "keywords", g_list_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_FORMAT_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_FORMAT_PROPERTY] = g_param_spec_string ("format", "format", "format", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_LAYOUT_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_LAYOUT_PROPERTY] = g_param_spec_string ("layout", "layout", "layout", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_PRINT_DUPLEX_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_PRINT_DUPLEX_PROPERTY] = g_param_spec_string ("print-duplex", "print-duplex", "print-duplex", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_SUBTYPE_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_SUBTYPE_PROPERTY] = g_param_spec_string ("subtype", "subtype", "subtype", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_VIEWER_PREFERENCES_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_VIEWER_PREFERENCES_PROPERTY] = g_param_spec_boxed ("viewer-preferences", "viewer-preferences", "viewer-preferences", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_PERMISSIONS_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_PERMISSIONS_PROPERTY] = g_param_spec_boxed ("permissions", "permissions", "permissions", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_CONTAINS_ATTACHMENTS_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_CONTAINS_ATTACHMENTS_PROPERTY] = g_param_spec_boolean ("contains-attachments", "contains-attachments", "contains-attachments", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_CONTAINS_JAVASCRIPT_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_CONTAINS_JAVASCRIPT_PROPERTY] = g_param_spec_boolean ("contains-javascript", "contains-javascript", "contains-javascript", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_DOCUMENT_N_PAGES_PROPERTY, paper_clip_document_properties[PAPER_CLIP_DOCUMENT_N_PAGES_PROPERTY] = g_param_spec_int ("n-pages", "n-pages", "n-pages", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	paper_clip_document_signals[PAPER_CLIP_DOCUMENT_KEYWORD_CHANGED_SIGNAL] = g_signal_new ("keyword-changed", PAPER_CLIP_TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
paper_clip_document_instance_init (PaperClipDocument * self,
                                   gpointer klass)
{
	GListStore* _tmp0_;
	self->priv = paper_clip_document_get_instance_private (self);
	_tmp0_ = g_list_store_new (PAPER_CLIP_TYPE_STRING_OBJECT);
	self->priv->keyword_list = _tmp0_;
	self->priv->_has_xmp = FALSE;
	g_rec_mutex_init (&self->priv->__lock_document);
}

static void
paper_clip_document_finalize (GObject * obj)
{
	PaperClipDocument * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocument);
	{
		GFile* _tmp0_;
		_tmp0_ = self->priv->_cached_file;
		g_file_delete (_tmp0_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("Document.vala:194: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_object_unref0 (self->priv->keyword_list);
	_g_object_unref0 (self->priv->_document);
	_g_object_unref0 (self->priv->_original_file);
	_g_object_unref0 (self->priv->_cached_file);
	g_rec_mutex_clear (&self->priv->__lock_document);
	G_OBJECT_CLASS (paper_clip_document_parent_class)->finalize (obj);
}

static GType
paper_clip_document_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PaperClipDocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paper_clip_document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaperClipDocument), 0, (GInstanceInitFunc) paper_clip_document_instance_init, NULL };
	GType paper_clip_document_type_id;
	paper_clip_document_type_id = g_type_register_static (G_TYPE_OBJECT, "PaperClipDocument", &g_define_type_info, 0);
	PaperClipDocument_private_offset = g_type_add_instance_private (paper_clip_document_type_id, sizeof (PaperClipDocumentPrivate));
	return paper_clip_document_type_id;
}

GType
paper_clip_document_get_type (void)
{
	static volatile gsize paper_clip_document_type_id__once = 0;
	if (g_once_init_enter (&paper_clip_document_type_id__once)) {
		GType paper_clip_document_type_id;
		paper_clip_document_type_id = paper_clip_document_get_type_once ();
		g_once_init_leave (&paper_clip_document_type_id__once, paper_clip_document_type_id);
	}
	return paper_clip_document_type_id__once;
}

static void
_vala_paper_clip_document_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PaperClipDocument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocument);
	switch (property_id) {
		case PAPER_CLIP_DOCUMENT_ORIGINAL_FILE_PROPERTY:
		g_value_set_object (value, paper_clip_document_get_original_file (self));
		break;
		case PAPER_CLIP_DOCUMENT_CACHED_FILE_PROPERTY:
		g_value_set_object (value, paper_clip_document_get_cached_file (self));
		break;
		case PAPER_CLIP_DOCUMENT_HAS_XMP_PROPERTY:
		g_value_set_boolean (value, paper_clip_document_get_has_xmp (self));
		break;
		case PAPER_CLIP_DOCUMENT_AUTHOR_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_author (self));
		break;
		case PAPER_CLIP_DOCUMENT_CREATOR_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_creator (self));
		break;
		case PAPER_CLIP_DOCUMENT_SUBJECT_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_subject (self));
		break;
		case PAPER_CLIP_DOCUMENT_TITLE_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_title (self));
		break;
		case PAPER_CLIP_DOCUMENT_PRODUCER_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_producer (self));
		break;
		case PAPER_CLIP_DOCUMENT_CREATION_DATE_PROPERTY:
		g_value_take_boxed (value, paper_clip_document_get_creation_date (self));
		break;
		case PAPER_CLIP_DOCUMENT_MODIFICATION_DATE_PROPERTY:
		g_value_take_boxed (value, paper_clip_document_get_modification_date (self));
		break;
		case PAPER_CLIP_DOCUMENT_KEYWORDS_PROPERTY:
		g_value_set_object (value, paper_clip_document_get_keywords (self));
		break;
		case PAPER_CLIP_DOCUMENT_FORMAT_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_format (self));
		break;
		case PAPER_CLIP_DOCUMENT_LAYOUT_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_layout (self));
		break;
		case PAPER_CLIP_DOCUMENT_PRINT_DUPLEX_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_print_duplex (self));
		break;
		case PAPER_CLIP_DOCUMENT_SUBTYPE_PROPERTY:
		g_value_take_string (value, paper_clip_document_get_subtype (self));
		break;
		case PAPER_CLIP_DOCUMENT_VIEWER_PREFERENCES_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, paper_clip_document_get_viewer_preferences (self, &length));
		}
		break;
		case PAPER_CLIP_DOCUMENT_PERMISSIONS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, paper_clip_document_get_permissions (self, &length));
		}
		break;
		case PAPER_CLIP_DOCUMENT_CONTAINS_ATTACHMENTS_PROPERTY:
		g_value_set_boolean (value, paper_clip_document_get_contains_attachments (self));
		break;
		case PAPER_CLIP_DOCUMENT_CONTAINS_JAVASCRIPT_PROPERTY:
		g_value_set_boolean (value, paper_clip_document_get_contains_javascript (self));
		break;
		case PAPER_CLIP_DOCUMENT_N_PAGES_PROPERTY:
		g_value_set_int (value, paper_clip_document_get_n_pages (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_paper_clip_document_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PaperClipDocument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAPER_CLIP_TYPE_DOCUMENT, PaperClipDocument);
	switch (property_id) {
		case PAPER_CLIP_DOCUMENT_ORIGINAL_FILE_PROPERTY:
		paper_clip_document_set_original_file (self, g_value_get_object (value));
		break;
		case PAPER_CLIP_DOCUMENT_CACHED_FILE_PROPERTY:
		paper_clip_document_set_cached_file (self, g_value_get_object (value));
		break;
		case PAPER_CLIP_DOCUMENT_HAS_XMP_PROPERTY:
		paper_clip_document_set_has_xmp (self, g_value_get_boolean (value));
		break;
		case PAPER_CLIP_DOCUMENT_AUTHOR_PROPERTY:
		paper_clip_document_set_author (self, g_value_get_string (value));
		break;
		case PAPER_CLIP_DOCUMENT_CREATOR_PROPERTY:
		paper_clip_document_set_creator (self, g_value_get_string (value));
		break;
		case PAPER_CLIP_DOCUMENT_SUBJECT_PROPERTY:
		paper_clip_document_set_subject (self, g_value_get_string (value));
		break;
		case PAPER_CLIP_DOCUMENT_TITLE_PROPERTY:
		paper_clip_document_set_title (self, g_value_get_string (value));
		break;
		case PAPER_CLIP_DOCUMENT_PRODUCER_PROPERTY:
		paper_clip_document_set_producer (self, g_value_get_string (value));
		break;
		case PAPER_CLIP_DOCUMENT_CREATION_DATE_PROPERTY:
		paper_clip_document_set_creation_date (self, g_value_get_boxed (value));
		break;
		case PAPER_CLIP_DOCUMENT_MODIFICATION_DATE_PROPERTY:
		paper_clip_document_set_modification_date (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
paper_clip_string_object_get_instance_private (PaperClipStringObject* self)
{
	return G_STRUCT_MEMBER_P (self, PaperClipStringObject_private_offset);
}

PaperClipStringObject*
paper_clip_string_object_construct (GType object_type,
                                    const gchar* str)
{
	PaperClipStringObject * self = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	self = (PaperClipStringObject*) g_object_new (object_type, "str", str, NULL);
	return self;
}

PaperClipStringObject*
paper_clip_string_object_new (const gchar* str)
{
	return paper_clip_string_object_construct (PAPER_CLIP_TYPE_STRING_OBJECT, str);
}

const gchar*
paper_clip_string_object_get_str (PaperClipStringObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_str;
	result = _tmp0_;
	return result;
}

void
paper_clip_string_object_set_str (PaperClipStringObject* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = paper_clip_string_object_get_str (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_str);
		self->priv->_str = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, paper_clip_string_object_properties[PAPER_CLIP_STRING_OBJECT_STR_PROPERTY]);
	}
}

static void
paper_clip_string_object_class_init (PaperClipStringObjectClass * klass,
                                     gpointer klass_data)
{
	paper_clip_string_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PaperClipStringObject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_paper_clip_string_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_paper_clip_string_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = paper_clip_string_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PAPER_CLIP_STRING_OBJECT_STR_PROPERTY, paper_clip_string_object_properties[PAPER_CLIP_STRING_OBJECT_STR_PROPERTY] = g_param_spec_string ("str", "str", "str", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
paper_clip_string_object_instance_init (PaperClipStringObject * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	self->priv = paper_clip_string_object_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_str = _tmp0_;
}

static void
paper_clip_string_object_finalize (GObject * obj)
{
	PaperClipStringObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PAPER_CLIP_TYPE_STRING_OBJECT, PaperClipStringObject);
	_g_free0 (self->priv->_str);
	G_OBJECT_CLASS (paper_clip_string_object_parent_class)->finalize (obj);
}

static GType
paper_clip_string_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PaperClipStringObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) paper_clip_string_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PaperClipStringObject), 0, (GInstanceInitFunc) paper_clip_string_object_instance_init, NULL };
	GType paper_clip_string_object_type_id;
	paper_clip_string_object_type_id = g_type_register_static (G_TYPE_OBJECT, "PaperClipStringObject", &g_define_type_info, 0);
	PaperClipStringObject_private_offset = g_type_add_instance_private (paper_clip_string_object_type_id, sizeof (PaperClipStringObjectPrivate));
	return paper_clip_string_object_type_id;
}

GType
paper_clip_string_object_get_type (void)
{
	static volatile gsize paper_clip_string_object_type_id__once = 0;
	if (g_once_init_enter (&paper_clip_string_object_type_id__once)) {
		GType paper_clip_string_object_type_id;
		paper_clip_string_object_type_id = paper_clip_string_object_get_type_once ();
		g_once_init_leave (&paper_clip_string_object_type_id__once, paper_clip_string_object_type_id);
	}
	return paper_clip_string_object_type_id__once;
}

static void
_vala_paper_clip_string_object_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	PaperClipStringObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAPER_CLIP_TYPE_STRING_OBJECT, PaperClipStringObject);
	switch (property_id) {
		case PAPER_CLIP_STRING_OBJECT_STR_PROPERTY:
		g_value_set_string (value, paper_clip_string_object_get_str (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_paper_clip_string_object_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	PaperClipStringObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PAPER_CLIP_TYPE_STRING_OBJECT, PaperClipStringObject);
	switch (property_id) {
		case PAPER_CLIP_STRING_OBJECT_STR_PROPERTY:
		paper_clip_string_object_set_str (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GQuark
paper_clip_xmp_error_quark (void)
{
	return g_quark_from_static_string ("paper-clip-xmp-error-quark");
}

static GType
paper_clip_xmp_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PAPER_CLIP_XMP_ERROR_NO_XMP, "PAPER_CLIP_XMP_ERROR_NO_XMP", "no-xmp"}, {PAPER_CLIP_XMP_ERROR_FAILED_TO_OPEN, "PAPER_CLIP_XMP_ERROR_FAILED_TO_OPEN", "failed-to-open"}, {0, NULL, NULL}};
	GType paper_clip_xmp_error_type_id;
	paper_clip_xmp_error_type_id = g_enum_register_static ("PaperClipXmpError", values);
	return paper_clip_xmp_error_type_id;
}

GType
paper_clip_xmp_error_get_type (void)
{
	static volatile gsize paper_clip_xmp_error_type_id__once = 0;
	if (g_once_init_enter (&paper_clip_xmp_error_type_id__once)) {
		GType paper_clip_xmp_error_type_id;
		paper_clip_xmp_error_type_id = paper_clip_xmp_error_get_type_once ();
		g_once_init_leave (&paper_clip_xmp_error_type_id__once, paper_clip_xmp_error_type_id);
	}
	return paper_clip_xmp_error_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

