/* file-item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from file-item.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. <https://elementary.io>
 *
 * Authored by: Marvin Ahlgrimm
 *              Colin Kiama <colinkiama@gmail.com>
 */

#include "fuzzy-search.h"
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILE_ITEM_0_PROPERTY,
	FILE_ITEM_FILEPATH_PROPERTY,
	FILE_ITEM_NUM_PROPERTIES
};
static GParamSpec* file_item_properties[FILE_ITEM_NUM_PROPERTIES];
#define _search_result_unref0(var) ((var == NULL) ? NULL : (var = (search_result_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FileItemPrivate {
	SearchResult* result;
};

static gint FileItem_private_offset;
static gpointer file_item_parent_class = NULL;
static GType file_item_type_id = 0;

static void file_item_finalize (GObject * obj);
static void _vala_file_item_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
file_item_get_instance_private (FileItem* self)
{
	return G_STRUCT_MEMBER_P (self, FileItem_private_offset);
}

static gpointer
_search_result_ref0 (gpointer self)
{
	return self ? search_result_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

FileItem*
file_item_construct (GType object_type,
                     SearchResult* res,
                     gboolean should_distinguish_project)
{
	FileItem * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	SearchResult* _tmp2_;
	GIcon* icon = NULL;
	GtkBox* path_box = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	gchar* _tmp5_ = NULL;
	GtkLabel* path_label = NULL;
	const gchar* _tmp10_;
	SearchResult* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* filename_label = NULL;
	SearchResult* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkImage* image = NULL;
	GIcon* _tmp31_;
	GtkImage* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkBox* container_box = NULL;
	GtkBox* _tmp36_ = NULL;
	GtkBox* _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (res != NULL, NULL);
	self = (FileItem*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "fuzzy-item");
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "flat");
	_tmp2_ = _search_result_ref0 (res);
	_search_result_unref0 (self->priv->result);
	self->priv->result = _tmp2_;
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 1);
	g_object_ref_sink (_tmp3_);
	path_box = _tmp3_;
	_tmp4_ = path_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	if (should_distinguish_project) {
		SearchResult* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->result;
		_tmp7_ = _tmp6_->project;
		_tmp8_ = g_strconcat (_tmp7_, " • ", NULL);
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp5_);
		_tmp5_ = _tmp9_;
	}
	_tmp10_ = string_to_string (_tmp5_);
	_tmp11_ = self->priv->result;
	_tmp12_ = _tmp11_->relative_path;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = g_strconcat (_tmp10_, _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = (GtkLabel*) gtk_label_new (_tmp15_);
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	path_label = _tmp17_;
	gtk_widget_set_halign ((GtkWidget*) path_label, GTK_ALIGN_START);
	_tmp18_ = self->priv->result;
	_tmp19_ = _tmp18_->relative_path;
	_tmp20_ = g_path_get_basename (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	filename_label = _tmp23_;
	gtk_widget_set_halign ((GtkWidget*) filename_label, GTK_ALIGN_START);
	{
		GFile* fi = NULL;
		SearchResult* _tmp24_;
		const gchar* _tmp25_;
		GFile* _tmp26_;
		GFileInfo* info = NULL;
		GFileInfo* _tmp27_;
		const gchar* _tmp28_;
		GIcon* _tmp29_;
		_tmp24_ = self->priv->result;
		_tmp25_ = _tmp24_->full_path;
		_tmp26_ = g_file_new_for_path (_tmp25_);
		fi = _tmp26_;
		_tmp27_ = g_file_query_info (fi, "standard::*", 0, NULL, &_inner_error0_);
		info = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (fi);
			goto __catch0_g_error;
		}
		_tmp28_ = g_file_info_get_content_type (info);
		_tmp29_ = g_content_type_get_icon (_tmp28_);
		_g_object_unref0 (icon);
		icon = _tmp29_;
		_g_object_unref0 (info);
		_g_object_unref0 (fi);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GIcon* _tmp30_;
		g_clear_error (&_inner_error0_);
		_tmp30_ = g_content_type_get_icon ("text/plain");
		_g_object_unref0 (icon);
		icon = _tmp30_;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (filename_label);
		_g_object_unref0 (path_label);
		_g_free0 (_tmp5_);
		_g_object_unref0 (path_box);
		_g_object_unref0 (icon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp31_ = icon;
	_tmp32_ = (GtkImage*) gtk_image_new_from_gicon (_tmp31_, (GtkIconSize) GTK_ICON_SIZE_DND);
	g_object_ref_sink (_tmp32_);
	image = _tmp32_;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) image);
	gtk_style_context_add_class (_tmp33_, "fuzzy-file-icon");
	_tmp34_ = path_box;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) filename_label);
	_tmp35_ = path_box;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) path_label);
	_tmp36_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 1);
	gtk_widget_set_valign ((GtkWidget*) _tmp36_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp36_);
	container_box = _tmp36_;
	gtk_container_add ((GtkContainer*) container_box, (GtkWidget*) image);
	_tmp37_ = path_box;
	gtk_container_add ((GtkContainer*) container_box, (GtkWidget*) _tmp37_);
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) container_box, NULL);
	_g_object_unref0 (container_box);
	_g_object_unref0 (image);
	_g_object_unref0 (filename_label);
	_g_object_unref0 (path_label);
	_g_free0 (_tmp5_);
	_g_object_unref0 (path_box);
	_g_object_unref0 (icon);
	return self;
}

FileItem*
file_item_new (SearchResult* res,
               gboolean should_distinguish_project)
{
	return file_item_construct (TYPE_FILE_ITEM, res, should_distinguish_project);
}

const gchar*
file_item_get_filepath (FileItem* self)
{
	const gchar* result;
	SearchResult* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->result;
	_tmp1_ = _tmp0_->full_path;
	result = _tmp1_;
	return result;
}

static void
file_item_class_init (FileItemClass * klass,
                      gpointer klass_data)
{
	file_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FileItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_file_item_get_property;
	G_OBJECT_CLASS (klass)->finalize = file_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILE_ITEM_FILEPATH_PROPERTY, file_item_properties[FILE_ITEM_FILEPATH_PROPERTY] = g_param_spec_string ("filepath", "filepath", "filepath", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
file_item_instance_init (FileItem * self,
                         gpointer klass)
{
	self->priv = file_item_get_instance_private (self);
}

static void
file_item_finalize (GObject * obj)
{
	FileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_ITEM, FileItem);
	_search_result_unref0 (self->priv->result);
	G_OBJECT_CLASS (file_item_parent_class)->finalize (obj);
}

GType
file_item_get_type (void)
{
	return file_item_type_id;
}

GType
file_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileItem), 0, (GInstanceInitFunc) file_item_instance_init, NULL };
	file_item_type_id = g_type_module_register_type (module, gtk_list_box_row_get_type (), "FileItem", &g_define_type_info, 0);
	FileItem_private_offset = sizeof (FileItemPrivate);
	return file_item_type_id;
}

static void
_vala_file_item_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	FileItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILE_ITEM, FileItem);
	switch (property_id) {
		case FILE_ITEM_FILEPATH_PROPERTY:
		g_value_set_string (value, file_item_get_filepath (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

