/* Generated by nsgenbind
 *
 * nsgenbind is published under the MIT Licence.
 * nsgenbind is similar to a compiler is a purely transformative tool which
 * explicitly makes no copyright claim on this generated output
 */

/* DukTape JavaScript bindings for NetSurf browser
 *
 * Copyright 2015 Vincent Sanders <vince@netsurf-browser.org>
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 * Released under the terms of the MIT License,
 *        http://www.opensource.org/licenses/mit-license
 */

#include <dom/dom.h>

#include "utils/log.h"
#include "utils/nsurl.h"

#include "javascript/duktape/duktape.h"

struct browser_window;
struct html_content;
struct dom_node;
struct dom_element;
struct dom_document;
struct dom_html_element;
struct dom_node_character_data;
struct dom_node_text;
struct dom_node_list;
struct dom_node_comment;
struct dom_html_collection;
struct dom_html_br_element;


#include "build/Linux-gtk3/duktape/binding.h"
#include "build/Linux-gtk3/duktape/private.h"
#include "build/Linux-gtk3/duktape/prototype.h"

#include "javascript/duktape/dukky.h"

void dukky_dom_token_list___init(duk_context *ctx, dom_token_list_private_t *priv, struct dom_tokenlist *tokens)
{
#line 16 "DOMTokenList.bnd"

	priv->tokens = tokens;
	dom_tokenlist_ref(tokens);
#line 50 "dom_token_list.c"
}

void dukky_dom_token_list___fini(duk_context *ctx, dom_token_list_private_t *priv)
{

	dom_tokenlist_unref(priv->tokens);
}

static duk_ret_t dukky_dom_token_list___constructor(duk_context *ctx)
{
	/* create private data and attach to instance */
	dom_token_list_private_t *priv = calloc(1, sizeof(*priv));
	if (priv == NULL) return 0;
	duk_push_pointer(ctx, priv);
	duk_put_prop_string(ctx, 0, dukky_magic_string_private);

	dukky_dom_token_list___init(ctx, priv, duk_get_pointer(ctx, 1));
	duk_set_top(ctx, 1);
	return 1;
}

static duk_ret_t dukky_dom_token_list___destructor(duk_context *ctx)
{
	dom_token_list_private_t *priv;
	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);
	if (priv == NULL) return 0;

	dukky_dom_token_list___fini(ctx, priv);
	free(priv);
	return 0;
}

static duk_ret_t dukky_dom_token_list_item(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_number(ctx, 0)) {
			return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_number_type, 0, "index");
		}
	}
	/* Get private data for method */
	dom_token_list_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 41 "DOMTokenList.bnd"

	unsigned long i = duk_to_uint(ctx, 0);
	dom_exception err;
	dom_string *value;

	err = dom_tokenlist_item(priv->tokens, i, &value);

	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

    if (value == NULL) {
        duk_push_null(ctx);
        return 1;
    }

    duk_push_lstring(ctx, dom_string_data(value), dom_string_length(value));
	dom_string_unref(value);

	return 1;
#line 132 "dom_token_list.c"
}

static duk_ret_t dukky_dom_token_list_contains(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	dom_token_list_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 108 "DOMTokenList.bnd"

	dom_exception exc;
	dom_string *value;
	duk_size_t slen;
	const char *s = duk_safe_to_lstring(ctx, 0, &slen);
	bool present = false;

	exc = dom_string_create_interned((const uint8_t *)s, slen, &value);
	if (exc != DOM_NO_ERR) return 0;

	exc = dom_tokenlist_contains(priv->tokens, value, &present);
	dom_string_unref(value);
	if (exc != DOM_NO_ERR) return 0;

	duk_push_boolean(ctx, present);
	
	return 1;
#line 181 "dom_token_list.c"
}

static duk_ret_t dukky_dom_token_list_add(duk_context *ctx)
{
	/* Get private data for method */
	dom_token_list_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 62 "DOMTokenList.bnd"

	dom_exception exc;
	dom_string *value;
	duk_size_t slen;
	const char *s;
	duk_idx_t spos;

	for (spos = 0; spos < duk_get_top(ctx); ++spos) {
		s = duk_safe_to_lstring(ctx, spos, &slen);

		duk_safe_to_lstring(ctx, 0, &slen);

		exc = dom_string_create_interned((const uint8_t *)s, slen, &value);
		if (exc != DOM_NO_ERR) return 0;

		exc = dom_tokenlist_add(priv->tokens, value);
		dom_string_unref(value);
	}
	
	return 0;
#line 217 "dom_token_list.c"
}

static duk_ret_t dukky_dom_token_list_remove(duk_context *ctx)
{
	/* Get private data for method */
	dom_token_list_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 85 "DOMTokenList.bnd"

	dom_exception exc;
	dom_string *value;
	duk_size_t slen;
	const char *s;
	duk_idx_t spos;

	for (spos = 0; spos < duk_get_top(ctx); ++spos) {
		s = duk_safe_to_lstring(ctx, spos, &slen);

		duk_safe_to_lstring(ctx, 0, &slen);

		exc = dom_string_create_interned((const uint8_t *)s, slen, &value);
		if (exc != DOM_NO_ERR) return 0;

		exc = dom_tokenlist_remove(priv->tokens, value);
		dom_string_unref(value);
	}
	
	return 0;
#line 253 "dom_token_list.c"
}

static duk_ret_t dukky_dom_token_list_toggle(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc == 1) {
		/* 1 optional arguments need adding */
		duk_push_undefined(ctx);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	if (dukky_argc > 1) {
		if (!duk_is_boolean(ctx, 1)) {
			if (duk_is_number(ctx, 1)) {
				duk_to_boolean(ctx, 1);
			} else {
				return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 1, "force");
			}
		}
	}
	/* Get private data for method */
	dom_token_list_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 128 "DOMTokenList.bnd"

	dom_exception exc;
	dom_string *value;
	duk_size_t slen;
	const char *s = duk_require_lstring(ctx, 0, &slen);
	bool toggle_set = duk_get_top(ctx) > 1;
	bool toggle = duk_opt_boolean(ctx, 1, 0);
	bool present;

	exc = dom_string_create_interned((const uint8_t *)s, slen, &value);
	if (exc != DOM_NO_ERR) return 0;

	exc = dom_tokenlist_contains(priv->tokens, value, &present);
	if (exc != DOM_NO_ERR) {
		dom_string_unref(value);
		return 0;
	}

	/* Decision matrix is based on present, toggle_set, and toggle */
	if (toggle_set) {
		if (toggle) {
			exc = dom_tokenlist_add(priv->tokens, value);
		} else {
			exc = dom_tokenlist_remove(priv->tokens, value);
		}
	} else {
		if (present) {
			exc = dom_tokenlist_add(priv->tokens, value);
		} else {
			exc = dom_tokenlist_remove(priv->tokens, value);
		}
	}
	dom_string_unref(value);

	return 0;
#line 332 "dom_token_list.c"
}

static duk_ret_t dukky_dom_token_list_length_getter(duk_context *ctx)
{
	/* Get private data for method */
	dom_token_list_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 27 "DOMTokenList.bnd"

	dom_exception err;
	uint32_t len;

	err = dom_tokenlist_get_length(priv->tokens, &len);

	if (err != DOM_NO_ERR) return 0; /* coerced to undefined */

	duk_push_uint(ctx, (duk_uint_t)len);

	return 1;
#line 359 "dom_token_list.c"
}

duk_ret_t dukky_dom_token_list___proto(duk_context *ctx, void *udata)
{
	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "item");
	duk_push_c_function(ctx, dukky_dom_token_list_item, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "contains");
	duk_push_c_function(ctx, dukky_dom_token_list_contains, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "add");
	duk_push_c_function(ctx, dukky_dom_token_list_add, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "remove");
	duk_push_c_function(ctx, dukky_dom_token_list_remove, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "toggle");
	duk_push_c_function(ctx, dukky_dom_token_list_toggle, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "length");
	duk_push_c_function(ctx, dukky_dom_token_list_length_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Set the destructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_dom_token_list___destructor, 1);
	duk_set_finalizer(ctx, -2);
	duk_pop(ctx);

	/* Set the constructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_dom_token_list___constructor, 2);
	duk_put_prop_string(ctx, -2, "\xFF\xFFNETSURF_DUKTAPE_INIT");
	duk_pop(ctx);

	return 1; /* The prototype object */
}


