  #include "nvim/ex_docmd.h"
  #include "nvim/ex_getln.h"
  #include "nvim/insexpand.h"
  #include "nvim/mapping.h"
  #include "nvim/ops.h"
  #include "nvim/option.h"
  #include "nvim/optionstr.h"
  #include "nvim/quickfix.h"
  #include "nvim/runtime.h"
  #include "nvim/tag.h"
  #include "nvim/window.h"

  static vimoption_T options[] = {
  [0]={
    .fullname="aleph",
    .shortname="al",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptAleph,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[0].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 224L },
  },
  [1]={
    .fullname="allowrevins",
    .shortname="ari",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptAllowrevins,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ari,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [2]={
    .fullname="ambiwidth",
    .shortname="ambw",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrAll|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptAmbiwidth,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_ambw_values,
    .values_len=2,
    .flags_var=NULL,
    .var=&p_ambw,
    .immutable=false,
    .opt_did_set_cb=did_set_ambiwidth,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "single", .size = sizeof("single") - 1 } },
  },
  [3]={
    .fullname="arabic",
    .shortname="arab",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagCurswant,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptArabic
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_arabic,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [4]={
    .fullname="arabicshape",
    .shortname="arshape",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrAll|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptArabicshape,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_arshape,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [5]={
    .fullname="autochdir",
    .shortname="acd",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptAutochdir,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_acd,
    .immutable=false,
    .opt_did_set_cb=did_set_autochdir,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [6]={
    .fullname="autoindent",
    .shortname="ai",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptAutoindent,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ai,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [7]={
    .fullname="autoread",
    .shortname="ar",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptAutoread,
      [kOptScopeBuf] = kBufOptAutoread,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ar,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [8]={
    .fullname="autowrite",
    .shortname="aw",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptAutowrite,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_aw,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [9]={
    .fullname="autowriteall",
    .shortname="awa",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptAutowriteall,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_awa,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [10]={
    .fullname="background",
    .shortname="bg",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBackground,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_bg_values,
    .values_len=2,
    .flags_var=NULL,
    .var=&p_bg,
    .immutable=false,
    .opt_did_set_cb=did_set_background,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "dark", .size = sizeof("dark") - 1 } },
  },
  [11]={
    .fullname="backspace",
    .shortname="bs",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBackspace,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_bs_values,
    .values_len=4,
    .flags_var=NULL,
    .var=&p_bs,
    .immutable=false,
    .opt_did_set_cb=did_set_backspace,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "indent,eol,start", .size = sizeof("indent,eol,start") - 1 } },
  },
  [12]={
    .fullname="backup",
    .shortname="bk",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBackup,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_bk,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [13]={
    .fullname="backupcopy",
    .shortname="bkc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBackupcopy,
      [kOptScopeBuf] = kBufOptBackupcopy,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_bkc_values,
    .values_len=5,
    .flags_var=&bkc_flags,
    .var=&p_bkc,
    .immutable=false,
    .opt_did_set_cb=did_set_backupcopy,
    .opt_expand_cb=expand_set_str_generic,
#if defined(UNIX)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "auto", .size = sizeof("auto") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "auto", .size = sizeof("auto") - 1 } },
#endif
  },
  [14]={
    .fullname="backupdir",
    .shortname="bdir",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagNoDefExp|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBackupdir,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_bdir,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [15]={
    .fullname="backupext",
    .shortname="bex",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNFname,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBackupext,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_bex,
    .immutable=false,
    .opt_did_set_cb=did_set_backupext_or_patchmode,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "~", .size = sizeof("~") - 1 } },
  },
  [16]={
    .fullname="backupskip",
    .shortname="bsk",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBackupskip,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_bsk,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [17]={
    .fullname="belloff",
    .shortname="bo",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBelloff,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_bo_values,
    .values_len=20,
    .flags_var=&bo_flags,
    .var=&p_bo,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "all", .size = sizeof("all") - 1 } },
  },
  [18]={
    .fullname="binary",
    .shortname="bin",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptBinary,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_bin,
    .immutable=false,
    .opt_did_set_cb=did_set_binary,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [19]={
    .fullname="bomb",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptBomb,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_bomb,
    .immutable=false,
    .opt_did_set_cb=did_set_eof_eol_fixeol_bomb,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [20]={
    .fullname="breakat",
    .shortname="brk",
    .type=kOptValTypeString,
    .flags=0|kOptFlagFlagList|kOptFlagRedrAll,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBreakat,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_breakat,
    .immutable=false,
    .opt_did_set_cb=did_set_breakat,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = " \t!@*-+;:,./?", .size = sizeof(" \t!@*-+;:,./?") - 1 } },
  },
  [21]={
    .fullname="breakindent",
    .shortname="bri",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptBreakindent
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [22]={
    .fullname="breakindentopt",
    .shortname="briopt",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrBuf|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptBreakindentopt
    },
    .values=opt_briopt_values,
    .values_len=5,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_breakindentopt,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [23]={
    .fullname="browsedir",
    .shortname="bsdir",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptBrowsedir,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[23].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [24]={
    .fullname="bufhidden",
    .shortname="bh",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNoGlob,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptBufhidden,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_bh_values,
    .values_len=5,
    .flags_var=NULL,
    .var=&p_bh,
    .immutable=false,
    .opt_did_set_cb=did_set_bufhidden,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [25]={
    .fullname="buflisted",
    .shortname="bl",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagNoGlob,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptBuflisted,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_bl,
    .immutable=false,
    .opt_did_set_cb=did_set_buflisted,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [26]={
    .fullname="buftype",
    .shortname="bt",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNoGlob,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptBuftype,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_bt_values,
    .values_len=8,
    .flags_var=NULL,
    .var=&p_bt,
    .immutable=false,
    .opt_did_set_cb=did_set_buftype,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [27]={
    .fullname="casemap",
    .shortname="cmp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCasemap,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_cmp_values,
    .values_len=2,
    .flags_var=&cmp_flags,
    .var=&p_cmp,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "internal,keepascii", .size = sizeof("internal,keepascii") - 1 } },
  },
  [28]={
    .fullname="cdhome",
    .shortname="cdh",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCdhome,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cdh,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [29]={
    .fullname="cdpath",
    .shortname="cd",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagExpand|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCdpath,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cdpath,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ",,", .size = sizeof(",,") - 1 } },
  },
  [30]={
    .fullname="cedit",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCedit,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cedit,
    .immutable=false,
    .opt_did_set_cb=did_set_cedit,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = CTRL_F_STR, .size = sizeof(CTRL_F_STR) - 1 } },
  },
  [31]={
    .fullname="channel",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagNoDefault|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptChannel,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_channel,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [32]={
    .fullname="charconvert",
    .shortname="ccv",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCharconvert,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ccv,
    .immutable=false,
    .opt_did_set_cb=did_set_optexpr,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [33]={
    .fullname="cindent",
    .shortname="cin",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCindent,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cin,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [34]={
    .fullname="cinkeys",
    .shortname="cink",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCinkeys,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cink,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "0{,0},0),0],:,0#,!^F,o,O,e", .size = sizeof("0{,0},0),0],:,0#,!^F,o,O,e") - 1 } },
  },
  [35]={
    .fullname="cinoptions",
    .shortname="cino",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCinoptions,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cino,
    .immutable=false,
    .opt_did_set_cb=did_set_cinoptions,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [36]={
    .fullname="cinscopedecls",
    .shortname="cinsd",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCinscopedecls,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cinsd,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "public,protected,private", .size = sizeof("public,protected,private") - 1 } },
  },
  [37]={
    .fullname="cinwords",
    .shortname="cinw",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCinwords,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cinw,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "if,else,while,do,for,switch", .size = sizeof("if,else,while,do,for,switch") - 1 } },
  },
  [38]={
    .fullname="clipboard",
    .shortname="cb",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptClipboard,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_cb_values,
    .values_len=2,
    .flags_var=&cb_flags,
    .var=&p_cb,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [39]={
    .fullname="cmdheight",
    .shortname="ch",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrAll,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCmdheight,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ch,
    .immutable=false,
    .opt_did_set_cb=did_set_cmdheight,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1L },
  },
  [40]={
    .fullname="cmdwinheight",
    .shortname="cwh",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCmdwinheight,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cwh,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 7L },
  },
  [41]={
    .fullname="colorcolumn",
    .shortname="cc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrWin|kOptFlagHLOnly|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptColorcolumn
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_colorcolumn,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [42]={
    .fullname="columns",
    .shortname="co",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptColumns,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_columns,
    .immutable=false,
    .opt_did_set_cb=did_set_lines_or_columns,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = DFLT_COLS },
  },
  [43]={
    .fullname="comments",
    .shortname="com",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptComments,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_com,
    .immutable=false,
    .opt_did_set_cb=did_set_comments,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "s1:/*,mb:*,ex:*/,://,b:#,:%,:XCOMM,n:>,fb:-,fb:•", .size = sizeof("s1:/*,mb:*,ex:*/,://,b:#,:%,:XCOMM,n:>,fb:-,fb:•") - 1 } },
  },
  [44]={
    .fullname="commentstring",
    .shortname="cms",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCommentstring,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cms,
    .immutable=false,
    .opt_did_set_cb=did_set_commentstring,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [45]={
    .fullname="compatible",
    .shortname="cp",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCompatible,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[45].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [46]={
    .fullname="complete",
    .shortname="cpt",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptComplete,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_cpt_values,
    .values_len=13,
    .flags_var=NULL,
    .var=&p_cpt,
    .immutable=false,
    .opt_did_set_cb=did_set_complete,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ".,w,b,u,t", .size = sizeof(".,w,b,u,t") - 1 } },
  },
  [47]={
    .fullname="completefunc",
    .shortname="cfu",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure|kOptFlagFunc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCompletefunc,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cfu,
    .immutable=false,
    .opt_did_set_cb=did_set_completefunc,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [48]={
    .fullname="completeitemalign",
    .shortname="cia",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCompleteitemalign,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cia,
    .immutable=false,
    .opt_did_set_cb=did_set_completeitemalign,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "abbr,kind,menu", .size = sizeof("abbr,kind,menu") - 1 } },
  },
  [49]={
    .fullname="completeopt",
    .shortname="cot",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCompleteopt,
      [kOptScopeBuf] = kBufOptCompleteopt,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_cot_values,
    .values_len=10,
    .flags_var=&cot_flags,
    .var=&p_cot,
    .immutable=false,
    .opt_did_set_cb=did_set_completeopt,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "menu,popup", .size = sizeof("menu,popup") - 1 } },
  },
  [50]={
    .fullname="completeslash",
    .shortname="csl",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCompleteslash,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_csl_values,
    .values_len=3,
    .flags_var=NULL,
#if defined(BACKSLASH_IN_FILENAME)
    .var=&p_csl,
    .immutable=false,
    .opt_did_set_cb=did_set_completeslash,
    .opt_expand_cb=expand_set_str_generic,
#else
    .var=&options[50].def_val.data,
    .immutable=true,
#endif
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [51]={
    .fullname="concealcursor",
    .shortname="cocu",
    .type=kOptValTypeString,
    .flags=0|kOptFlagFlagList|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptConcealcursor
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_concealcursor,
    .opt_expand_cb=expand_set_concealcursor,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [52]={
    .fullname="conceallevel",
    .shortname="cole",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptConceallevel
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [53]={
    .fullname="confirm",
    .shortname="cf",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptConfirm,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_confirm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [54]={
    .fullname="copyindent",
    .shortname="ci",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptCopyindent,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ci,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [55]={
    .fullname="cpoptions",
    .shortname="cpo",
    .type=kOptValTypeString,
    .flags=0|kOptFlagFlagList|kOptFlagRedrAll,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptCpoptions,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_cpo,
    .immutable=false,
    .opt_did_set_cb=did_set_cpoptions,
    .opt_expand_cb=expand_set_cpoptions,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = CPO_VIM, .size = sizeof(CPO_VIM) - 1 } },
  },
  [56]={
    .fullname="cursorbind",
    .shortname="crb",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptCursorbind
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [57]={
    .fullname="cursorcolumn",
    .shortname="cuc",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin|kOptFlagHLOnly,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptCursorcolumn
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [58]={
    .fullname="cursorline",
    .shortname="cul",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin|kOptFlagHLOnly,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptCursorline
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [59]={
    .fullname="cursorlineopt",
    .shortname="culopt",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrWin|kOptFlagHLOnly|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptCursorlineopt
    },
    .values=opt_culopt_values,
    .values_len=4,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_cursorlineopt,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "both", .size = sizeof("both") - 1 } },
  },
  [60]={
    .fullname="debug",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDebug,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_debug_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_debug,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [61]={
    .fullname="define",
    .shortname="def",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDefine,
      [kOptScopeBuf] = kBufOptDefine,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_def,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [62]={
    .fullname="delcombine",
    .shortname="deco",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDelcombine,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_deco,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [63]={
    .fullname="dictionary",
    .shortname="dict",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagNDname|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDictionary,
      [kOptScopeBuf] = kBufOptDictionary,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_dict,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [64]={
    .fullname="diff",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin|kOptFlagNoGlob,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptDiff
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_diff,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [65]={
    .fullname="diffexpr",
    .shortname="dex",
    .type=kOptValTypeString,
    .flags=0|kOptFlagCurswant|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDiffexpr,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_dex,
    .immutable=false,
    .opt_did_set_cb=did_set_optexpr,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [66]={
    .fullname="diffopt",
    .shortname="dip",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagColon|kOptFlagRedrWin|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDiffopt,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_dip_values,
    .values_len=17,
    .flags_var=NULL,
    .var=&p_dip,
    .immutable=false,
    .opt_did_set_cb=did_set_diffopt,
    .opt_expand_cb=expand_set_diffopt,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "internal,filler,closeoff,linematch:40", .size = sizeof("internal,filler,closeoff,linematch:40") - 1 } },
  },
  [67]={
    .fullname="digraph",
    .shortname="dg",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDigraph,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_dg,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [68]={
    .fullname="directory",
    .shortname="dir",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagNoDefExp|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDirectory,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_dir,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [69]={
    .fullname="display",
    .shortname="dy",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrAll|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptDisplay,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_dy_values,
    .values_len=4,
    .flags_var=&dy_flags,
    .var=&p_dy,
    .immutable=false,
    .opt_did_set_cb=did_set_display,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "lastline", .size = sizeof("lastline") - 1 } },
  },
  [70]={
    .fullname="eadirection",
    .shortname="ead",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptEadirection,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_ead_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_ead,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "both", .size = sizeof("both") - 1 } },
  },
  [71]={
    .fullname="edcompatible",
    .shortname="ed",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptEdcompatible,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[71].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [72]={
    .fullname="emoji",
    .shortname="emo",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrAll|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptEmoji,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_emoji,
    .immutable=false,
    .opt_did_set_cb=did_set_emoji,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [73]={
    .fullname="encoding",
    .shortname="enc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNoML,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptEncoding,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_enc,
    .immutable=false,
    .opt_did_set_cb=did_set_encoding,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ENC_DFLT, .size = sizeof(ENC_DFLT) - 1 } },
  },
  [74]={
    .fullname="endoffile",
    .shortname="eof",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptEndoffile,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_eof,
    .immutable=false,
    .opt_did_set_cb=did_set_eof_eol_fixeol_bomb,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [75]={
    .fullname="endofline",
    .shortname="eol",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptEndofline,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_eol,
    .immutable=false,
    .opt_did_set_cb=did_set_eof_eol_fixeol_bomb,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [76]={
    .fullname="equalalways",
    .shortname="ea",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptEqualalways,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ea,
    .immutable=false,
    .opt_did_set_cb=did_set_equalalways,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [77]={
    .fullname="equalprg",
    .shortname="ep",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptEqualprg,
      [kOptScopeBuf] = kBufOptEqualprg,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ep,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [78]={
    .fullname="errorbells",
    .shortname="eb",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptErrorbells,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_eb,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [79]={
    .fullname="errorfile",
    .shortname="ef",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptErrorfile,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ef,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = DFLT_ERRORFILE, .size = sizeof(DFLT_ERRORFILE) - 1 } },
  },
  [80]={
    .fullname="errorformat",
    .shortname="efm",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptErrorformat,
      [kOptScopeBuf] = kBufOptErrorformat,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_efm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = DFLT_EFM, .size = sizeof(DFLT_EFM) - 1 } },
  },
  [81]={
    .fullname="eventignore",
    .shortname="ei",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptEventignore,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ei,
    .immutable=false,
    .opt_did_set_cb=did_set_eventignore,
    .opt_expand_cb=expand_set_eventignore,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [82]={
    .fullname="eventignorewin",
    .shortname="eiw",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptEventignorewin
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_eventignore,
    .opt_expand_cb=expand_set_eventignore,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [83]={
    .fullname="expandtab",
    .shortname="et",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptExpandtab,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_et,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [84]={
    .fullname="exrc",
    .shortname="ex",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptExrc,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_exrc,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [85]={
    .fullname="fileencoding",
    .shortname="fenc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrStat|kOptFlagRedrBuf|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptFileencoding,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fenc,
    .immutable=false,
    .opt_did_set_cb=did_set_encoding,
    .opt_expand_cb=expand_set_encoding,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [86]={
    .fullname="fileencodings",
    .shortname="fencs",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFileencodings,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fencs,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=expand_set_encoding,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "ucs-bom,utf-8,default,latin1", .size = sizeof("ucs-bom,utf-8,default,latin1") - 1 } },
  },
  [87]={
    .fullname="fileformat",
    .shortname="ff",
    .type=kOptValTypeString,
    .flags=0|kOptFlagCurswant|kOptFlagRedrStat|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptFileformat,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_ff_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_ff,
    .immutable=false,
    .opt_did_set_cb=did_set_fileformat,
    .opt_expand_cb=expand_set_str_generic,
#if defined(USE_CRNL)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "dos", .size = sizeof("dos") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "unix", .size = sizeof("unix") - 1 } },
#endif
  },
  [88]={
    .fullname="fileformats",
    .shortname="ffs",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFileformats,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ffs,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
#if defined(USE_CRNL)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "dos,unix", .size = sizeof("dos,unix") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "unix,dos", .size = sizeof("unix,dos") - 1 } },
#endif
  },
  [89]={
    .fullname="fileignorecase",
    .shortname="fic",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFileignorecase,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fic,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
#if defined(CASE_INSENSITIVE_FILENAME)
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
#endif
  },
  [90]={
    .fullname="filetype",
    .shortname="ft",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNoGlob|kOptFlagNFname,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptFiletype,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ft,
    .immutable=false,
    .opt_did_set_cb=did_set_filetype_or_syntax,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [91]={
    .fullname="fillchars",
    .shortname="fcs",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrWin|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFillchars,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFillchars
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fcs,
    .immutable=false,
    .opt_did_set_cb=did_set_chars_option,
    .opt_expand_cb=expand_set_chars_option,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [92]={
    .fullname="findfunc",
    .shortname="ffu",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure|kOptFlagFunc,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFindfunc,
      [kOptScopeBuf] = kBufOptFindfunc,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ffu,
    .immutable=false,
    .opt_did_set_cb=did_set_findfunc,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [93]={
    .fullname="fixendofline",
    .shortname="fixeol",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptFixendofline,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fixeol,
    .immutable=false,
    .opt_did_set_cb=did_set_eof_eol_fixeol_bomb,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [94]={
    .fullname="foldclose",
    .shortname="fcl",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrWin|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFoldclose,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_fcl_values,
    .values_len=1,
    .flags_var=NULL,
    .var=&p_fcl,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [95]={
    .fullname="foldcolumn",
    .shortname="fdc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldcolumn
    },
    .values=opt_fdc_values,
    .values_len=20,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "0", .size = sizeof("0") - 1 } },
  },
  [96]={
    .fullname="foldenable",
    .shortname="fen",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldenable
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [97]={
    .fullname="foldexpr",
    .shortname="fde",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldexpr
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_foldexpr,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "0", .size = sizeof("0") - 1 } },
  },
  [98]={
    .fullname="foldignore",
    .shortname="fdi",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldignore
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_foldignore,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "#", .size = sizeof("#") - 1 } },
  },
  [99]={
    .fullname="foldlevel",
    .shortname="fdl",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldlevel
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_foldlevel,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [100]={
    .fullname="foldlevelstart",
    .shortname="fdls",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagCurswant,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFoldlevelstart,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fdls,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = -1L },
  },
  [101]={
    .fullname="foldmarker",
    .shortname="fmr",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrWin|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldmarker
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_foldmarker,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "{{{,}}}", .size = sizeof("{{{,}}}") - 1 } },
  },
  [102]={
    .fullname="foldmethod",
    .shortname="fdm",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldmethod
    },
    .values=opt_fdm_values,
    .values_len=6,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_foldmethod,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "manual", .size = sizeof("manual") - 1 } },
  },
  [103]={
    .fullname="foldminlines",
    .shortname="fml",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldminlines
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_foldminlines,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1L },
  },
  [104]={
    .fullname="foldnestmax",
    .shortname="fdn",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldnestmax
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_foldnestmax,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 20L },
  },
  [105]={
    .fullname="foldopen",
    .shortname="fdo",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagCurswant|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFoldopen,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_fdo_values,
    .values_len=11,
    .flags_var=&fdo_flags,
    .var=&p_fdo,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "block,hor,mark,percent,quickfix,search,tag,undo", .size = sizeof("block,hor,mark,percent,quickfix,search,tag,undo") - 1 } },
  },
  [106]={
    .fullname="foldtext",
    .shortname="fdt",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptFoldtext
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_optexpr,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "foldtext()", .size = sizeof("foldtext()") - 1 } },
  },
  [107]={
    .fullname="formatexpr",
    .shortname="fex",
    .type=kOptValTypeString,
    .flags=0|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptFormatexpr,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fex,
    .immutable=false,
    .opt_did_set_cb=did_set_optexpr,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [108]={
    .fullname="formatlistpat",
    .shortname="flp",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptFormatlistpat,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_flp,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "^\\s*\\d\\+[\\]:.)}\\t ]\\s*", .size = sizeof("^\\s*\\d\\+[\\]:.)}\\t ]\\s*") - 1 } },
  },
  [109]={
    .fullname="formatoptions",
    .shortname="fo",
    .type=kOptValTypeString,
    .flags=0|kOptFlagFlagList,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptFormatoptions,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fo,
    .immutable=false,
    .opt_did_set_cb=did_set_formatoptions,
    .opt_expand_cb=expand_set_formatoptions,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = DFLT_FO_VIM, .size = sizeof(DFLT_FO_VIM) - 1 } },
  },
  [110]={
    .fullname="formatprg",
    .shortname="fp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFormatprg,
      [kOptScopeBuf] = kBufOptFormatprg,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fp,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [111]={
    .fullname="fsync",
    .shortname="fs",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptFsync,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_fs,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [112]={
    .fullname="gdefault",
    .shortname="gd",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGdefault,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_gd,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [113]={
    .fullname="grepformat",
    .shortname="gfm",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGrepformat,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_gefm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = DFLT_GREPFORMAT, .size = sizeof(DFLT_GREPFORMAT) - 1 } },
  },
  [114]={
    .fullname="grepprg",
    .shortname="gp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGrepprg,
      [kOptScopeBuf] = kBufOptGrepprg,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_gp,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "findstr /n $* nul", .size = sizeof("findstr /n $* nul") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "grep -HIn $* /dev/null", .size = sizeof("grep -HIn $* /dev/null") - 1 } },
#endif
  },
  [115]={
    .fullname="guicursor",
    .shortname="gcr",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGuicursor,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_guicursor,
    .immutable=false,
    .opt_did_set_cb=did_set_guicursor,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "n-v-c-sm:block,i-ci-ve:ver25,r-cr-o:hor20,t:block-blinkon500-blinkoff500-TermCursor", .size = sizeof("n-v-c-sm:block,i-ci-ve:ver25,r-cr-o:hor20,t:block-blinkon500-blinkoff500-TermCursor") - 1 } },
  },
  [116]={
    .fullname="guifont",
    .shortname="gfn",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagUIOption|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGuifont,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_guifont,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [117]={
    .fullname="guifontwide",
    .shortname="gfw",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagUIOption|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGuifontwide,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_guifontwide,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [118]={
    .fullname="guioptions",
    .shortname="go",
    .type=kOptValTypeString,
    .flags=0|kOptFlagFlagList,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGuioptions,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[118].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [119]={
    .fullname="guitablabel",
    .shortname="gtl",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGuitablabel,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[119].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [120]={
    .fullname="guitabtooltip",
    .shortname="gtt",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptGuitabtooltip,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[120].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [121]={
    .fullname="helpfile",
    .shortname="hf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHelpfile,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_hf,
    .immutable=false,
    .opt_did_set_cb=did_set_helpfile,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = DFLT_HELPFILE, .size = sizeof(DFLT_HELPFILE) - 1 } },
  },
  [122]={
    .fullname="helpheight",
    .shortname="hh",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHelpheight,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_hh,
    .immutable=false,
    .opt_did_set_cb=did_set_helpheight,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 20L },
  },
  [123]={
    .fullname="helplang",
    .shortname="hlg",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHelplang,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_hlg,
    .immutable=false,
    .opt_did_set_cb=did_set_helplang,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [124]={
    .fullname="hidden",
    .shortname="hid",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHidden,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_hid,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [125]={
    .fullname="highlight",
    .shortname="hl",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHighlight,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_hl,
    .immutable=false,
    .opt_did_set_cb=did_set_highlight,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = HIGHLIGHT_INIT, .size = sizeof(HIGHLIGHT_INIT) - 1 } },
  },
  [126]={
    .fullname="history",
    .shortname="hi",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHistory,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_hi,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 10000L },
  },
  [127]={
    .fullname="hkmap",
    .shortname="hk",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHkmap,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[127].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [128]={
    .fullname="hkmapp",
    .shortname="hkp",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHkmapp,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[128].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [129]={
    .fullname="hlsearch",
    .shortname="hls",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrAll|kOptFlagHLOnly,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptHlsearch,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_hls,
    .immutable=false,
    .opt_did_set_cb=did_set_hlsearch,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [130]={
    .fullname="icon",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptIcon,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_icon,
    .immutable=false,
    .opt_did_set_cb=did_set_title_icon,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [131]={
    .fullname="iconstring",
    .type=kOptValTypeString,
    .flags=0|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptIconstring,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_iconstring,
    .immutable=false,
    .opt_did_set_cb=did_set_iconstring,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [132]={
    .fullname="ignorecase",
    .shortname="ic",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptIgnorecase,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ic,
    .immutable=false,
    .opt_did_set_cb=did_set_ignorecase,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [133]={
    .fullname="imcmdline",
    .shortname="imc",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptImcmdline,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[133].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [134]={
    .fullname="imdisable",
    .shortname="imd",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptImdisable,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[134].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [135]={
    .fullname="iminsert",
    .shortname="imi",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptIminsert,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_iminsert,
    .immutable=false,
    .opt_did_set_cb=did_set_iminsert,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = B_IMODE_NONE },
  },
  [136]={
    .fullname="imsearch",
    .shortname="ims",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptImsearch,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_imsearch,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = B_IMODE_USE_INSERT },
  },
  [137]={
    .fullname="inccommand",
    .shortname="icm",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInccommand,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_icm_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_icm,
    .immutable=false,
    .opt_did_set_cb=did_set_inccommand,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "nosplit", .size = sizeof("nosplit") - 1 } },
  },
  [138]={
    .fullname="include",
    .shortname="inc",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInclude,
      [kOptScopeBuf] = kBufOptInclude,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_inc,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [139]={
    .fullname="includeexpr",
    .shortname="inex",
    .type=kOptValTypeString,
    .flags=0|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptIncludeexpr,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_inex,
    .immutable=false,
    .opt_did_set_cb=did_set_optexpr,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [140]={
    .fullname="incsearch",
    .shortname="is",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptIncsearch,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_is,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [141]={
    .fullname="indentexpr",
    .shortname="inde",
    .type=kOptValTypeString,
    .flags=0|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptIndentexpr,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_inde,
    .immutable=false,
    .opt_did_set_cb=did_set_optexpr,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [142]={
    .fullname="indentkeys",
    .shortname="indk",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptIndentkeys,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_indk,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "0{,0},0),0],:,0#,!^F,o,O,e", .size = sizeof("0{,0},0),0],:,0#,!^F,o,O,e") - 1 } },
  },
  [143]={
    .fullname="infercase",
    .shortname="inf",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInfercase,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_inf,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [144]={
    .fullname="insertmode",
    .shortname="im",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInsertmode,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[144].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [145]={
    .fullname="isfname",
    .shortname="isf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptIsfname,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_isf,
    .immutable=false,
    .opt_did_set_cb=did_set_isopt,
    .opt_expand_cb=NULL,
#if defined(BACKSLASH_IN_FILENAME)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "@,48-57,/,\\,.,-,_,+,,,#,$,%,{,},[,],@-@,!,~,=", .size = sizeof("@,48-57,/,\\,.,-,_,+,,,#,$,%,{,},[,],@-@,!,~,=") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "@,48-57,/,.,-,_,+,,,#,$,%,~,=", .size = sizeof("@,48-57,/,.,-,_,+,,,#,$,%,~,=") - 1 } },
#endif
  },
  [146]={
    .fullname="isident",
    .shortname="isi",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptIsident,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_isi,
    .immutable=false,
    .opt_did_set_cb=did_set_isopt,
    .opt_expand_cb=NULL,
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "@,48-57,_,128-167,224-235", .size = sizeof("@,48-57,_,128-167,224-235") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "@,48-57,_,192-255", .size = sizeof("@,48-57,_,192-255") - 1 } },
#endif
  },
  [147]={
    .fullname="iskeyword",
    .shortname="isk",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptIskeyword,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_isk,
    .immutable=false,
    .opt_did_set_cb=did_set_iskeyword,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "@,48-57,_,192-255", .size = sizeof("@,48-57,_,192-255") - 1 } },
  },
  [148]={
    .fullname="isprint",
    .shortname="isp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagRedrAll|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptIsprint,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_isp,
    .immutable=false,
    .opt_did_set_cb=did_set_isopt,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "@,161-255", .size = sizeof("@,161-255") - 1 } },
  },
  [149]={
    .fullname="joinspaces",
    .shortname="js",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptJoinspaces,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_js,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [150]={
    .fullname="jumpoptions",
    .shortname="jop",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptJumpoptions,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_jop_values,
    .values_len=3,
    .flags_var=&jop_flags,
    .var=&p_jop,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "clean", .size = sizeof("clean") - 1 } },
  },
  [151]={
    .fullname="keymap",
    .shortname="kmp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrStat|kOptFlagRedrBuf|kOptFlagNFname|kOptFlagPriMkrc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptKeymap,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_keymap,
    .immutable=false,
    .opt_did_set_cb=did_set_keymap,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [152]={
    .fullname="keymodel",
    .shortname="km",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptKeymodel,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_km_values,
    .values_len=2,
    .flags_var=NULL,
    .var=&p_km,
    .immutable=false,
    .opt_did_set_cb=did_set_keymodel,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [153]={
    .fullname="keywordprg",
    .shortname="kp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptKeywordprg,
      [kOptScopeBuf] = kBufOptKeywordprg,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_kp,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ":help", .size = sizeof(":help") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ":Man", .size = sizeof(":Man") - 1 } },
#endif
  },
  [154]={
    .fullname="langmap",
    .shortname="lmap",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLangmap,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_langmap,
    .immutable=false,
    .opt_did_set_cb=did_set_langmap,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [155]={
    .fullname="langmenu",
    .shortname="lm",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNFname,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLangmenu,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [156]={
    .fullname="langnoremap",
    .shortname="lnr",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLangnoremap,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lnr,
    .immutable=false,
    .opt_did_set_cb=did_set_langnoremap,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [157]={
    .fullname="langremap",
    .shortname="lrm",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLangremap,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lrm,
    .immutable=false,
    .opt_did_set_cb=did_set_langremap,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [158]={
    .fullname="laststatus",
    .shortname="ls",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrAll,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLaststatus,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ls,
    .immutable=false,
    .opt_did_set_cb=did_set_laststatus,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 2L },
  },
  [159]={
    .fullname="lazyredraw",
    .shortname="lz",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLazyredraw,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lz,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [160]={
    .fullname="linebreak",
    .shortname="lbr",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptLinebreak
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [161]={
    .fullname="lines",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLines,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lines,
    .immutable=false,
    .opt_did_set_cb=did_set_lines_or_columns,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = DFLT_ROWS },
  },
  [162]={
    .fullname="linespace",
    .shortname="lsp",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLinespace,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_linespace,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [163]={
    .fullname="lisp",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptLisp,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lisp,
    .immutable=false,
    .opt_did_set_cb=did_set_lisp,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [164]={
    .fullname="lispoptions",
    .shortname="lop",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptLispoptions,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_lop_values,
    .values_len=2,
    .flags_var=NULL,
    .var=&p_lop,
    .immutable=false,
    .opt_did_set_cb=did_set_lispoptions,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [165]={
    .fullname="lispwords",
    .shortname="lw",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLispwords,
      [kOptScopeBuf] = kBufOptLispwords,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lispwords,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = LISPWORD_VALUE, .size = sizeof(LISPWORD_VALUE) - 1 } },
  },
  [166]={
    .fullname="list",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptList
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [167]={
    .fullname="listchars",
    .shortname="lcs",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrWin|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptListchars,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptListchars
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lcs,
    .immutable=false,
    .opt_did_set_cb=did_set_chars_option,
    .opt_expand_cb=expand_set_chars_option,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "tab:> ,trail:-,nbsp:+", .size = sizeof("tab:> ,trail:-,nbsp:+") - 1 } },
  },
  [168]={
    .fullname="loadplugins",
    .shortname="lpl",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptLoadplugins,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_lpl,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [169]={
    .fullname="magic",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMagic,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_magic,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [170]={
    .fullname="makeef",
    .shortname="mef",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMakeef,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mef,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [171]={
    .fullname="makeencoding",
    .shortname="menc",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMakeencoding,
      [kOptScopeBuf] = kBufOptMakeencoding,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_menc,
    .immutable=false,
    .opt_did_set_cb=did_set_encoding,
    .opt_expand_cb=expand_set_encoding,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [172]={
    .fullname="makeprg",
    .shortname="mp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMakeprg,
      [kOptScopeBuf] = kBufOptMakeprg,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mp,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "make", .size = sizeof("make") - 1 } },
  },
  [173]={
    .fullname="matchpairs",
    .shortname="mps",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptMatchpairs,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mps,
    .immutable=false,
    .opt_did_set_cb=did_set_matchpairs,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "(:),{:},[:]", .size = sizeof("(:),{:},[:]") - 1 } },
  },
  [174]={
    .fullname="matchtime",
    .shortname="mat",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMatchtime,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mat,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 5L },
  },
  [175]={
    .fullname="maxcombine",
    .shortname="mco",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMaxcombine,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mco,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = MAX_MCO },
  },
  [176]={
    .fullname="maxfuncdepth",
    .shortname="mfd",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMaxfuncdepth,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mfd,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 100L },
  },
  [177]={
    .fullname="maxmapdepth",
    .shortname="mmd",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMaxmapdepth,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mmd,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1000L },
  },
  [178]={
    .fullname="maxmempattern",
    .shortname="mmp",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMaxmempattern,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mmp,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1000L },
  },
  [179]={
    .fullname="menuitems",
    .shortname="mis",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMenuitems,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mis,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 25L },
  },
  [180]={
    .fullname="messagesopt",
    .shortname="mopt",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagColon|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMessagesopt,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_mopt_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_mopt,
    .immutable=false,
    .opt_did_set_cb=did_set_messagesopt,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "hit-enter,history:500", .size = sizeof("hit-enter,history:500") - 1 } },
  },
  [181]={
    .fullname="mkspellmem",
    .shortname="msm",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMkspellmem,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_msm,
    .immutable=false,
    .opt_did_set_cb=did_set_mkspellmem,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "460000,2000,500", .size = sizeof("460000,2000,500") - 1 } },
  },
  [182]={
    .fullname="modeline",
    .shortname="ml",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptModeline,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ml,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [183]={
    .fullname="modelineexpr",
    .shortname="mle",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptModelineexpr,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mle,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [184]={
    .fullname="modelines",
    .shortname="mls",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptModelines,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mls,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 5L },
  },
  [185]={
    .fullname="modifiable",
    .shortname="ma",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagNoGlob,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptModifiable,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ma,
    .immutable=false,
    .opt_did_set_cb=did_set_modifiable,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [186]={
    .fullname="modified",
    .shortname="mod",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptModified,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mod,
    .immutable=false,
    .opt_did_set_cb=did_set_modified,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [187]={
    .fullname="more",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMore,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_more,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [188]={
    .fullname="mouse",
    .type=kOptValTypeString,
    .flags=0|kOptFlagFlagList,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMouse,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mouse,
    .immutable=false,
    .opt_did_set_cb=did_set_mouse,
    .opt_expand_cb=expand_set_mouse,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "nvi", .size = sizeof("nvi") - 1 } },
  },
  [189]={
    .fullname="mousefocus",
    .shortname="mousef",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMousefocus,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mousef,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [190]={
    .fullname="mousehide",
    .shortname="mh",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMousehide,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mh,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [191]={
    .fullname="mousemodel",
    .shortname="mousem",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMousemodel,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_mousem_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_mousem,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "popup_setpos", .size = sizeof("popup_setpos") - 1 } },
  },
  [192]={
    .fullname="mousemoveevent",
    .shortname="mousemev",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMousemoveevent,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mousemev,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [193]={
    .fullname="mousescroll",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMousescroll,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_mousescroll_values,
    .values_len=2,
    .flags_var=NULL,
    .var=&p_mousescroll,
    .immutable=false,
    .opt_did_set_cb=did_set_mousescroll,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "ver:3,hor:6", .size = sizeof("ver:3,hor:6") - 1 } },
  },
  [194]={
    .fullname="mouseshape",
    .shortname="mouses",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMouseshape,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[194].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [195]={
    .fullname="mousetime",
    .shortname="mouset",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptMousetime,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_mouset,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 500L },
  },
  [196]={
    .fullname="nrformats",
    .shortname="nf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptNrformats,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_nf_values,
    .values_len=6,
    .flags_var=NULL,
    .var=&p_nf,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "bin,hex", .size = sizeof("bin,hex") - 1 } },
  },
  [197]={
    .fullname="number",
    .shortname="nu",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptNumber
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_number_relativenumber,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [198]={
    .fullname="numberwidth",
    .shortname="nuw",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptNumberwidth
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_numberwidth,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 4L },
  },
  [199]={
    .fullname="omnifunc",
    .shortname="ofu",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure|kOptFlagFunc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptOmnifunc,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ofu,
    .immutable=false,
    .opt_did_set_cb=did_set_omnifunc,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [200]={
    .fullname="opendevice",
    .shortname="odev",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptOpendevice,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[200].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [201]={
    .fullname="operatorfunc",
    .shortname="opfunc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure|kOptFlagFunc,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptOperatorfunc,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_opfunc,
    .immutable=false,
    .opt_did_set_cb=did_set_operatorfunc,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [202]={
    .fullname="packpath",
    .shortname="pp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPackpath,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_pp,
    .immutable=false,
    .opt_did_set_cb=did_set_runtimepackpath,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [203]={
    .fullname="paragraphs",
    .shortname="para",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptParagraphs,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_para,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "IPLPPPQPP TPHPLIPpLpItpplpipbp", .size = sizeof("IPLPPPQPP TPHPLIPpLpItpplpipbp") - 1 } },
  },
  [204]={
    .fullname="paste",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagPriMkrc,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPaste,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_paste,
    .immutable=false,
    .opt_did_set_cb=did_set_paste,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [205]={
    .fullname="pastetoggle",
    .shortname="pt",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPastetoggle,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[205].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [206]={
    .fullname="patchexpr",
    .shortname="pex",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPatchexpr,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_pex,
    .immutable=false,
    .opt_did_set_cb=did_set_optexpr,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [207]={
    .fullname="patchmode",
    .shortname="pm",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNFname,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPatchmode,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_pm,
    .immutable=false,
    .opt_did_set_cb=did_set_backupext_or_patchmode,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [208]={
    .fullname="path",
    .shortname="pa",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagExpand|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPath,
      [kOptScopeBuf] = kBufOptPath,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_path,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ".,,", .size = sizeof(".,,") - 1 } },
  },
  [209]={
    .fullname="preserveindent",
    .shortname="pi",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptPreserveindent,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_pi,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [210]={
    .fullname="previewheight",
    .shortname="pvh",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPreviewheight,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_pvh,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 12L },
  },
  [211]={
    .fullname="previewwindow",
    .shortname="pvw",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat|kOptFlagNoGlob,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptPreviewwindow
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_previewwindow,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [212]={
    .fullname="prompt",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPrompt,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[212].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [213]={
    .fullname="pumblend",
    .shortname="pb",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPumblend,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_pb,
    .immutable=false,
    .opt_did_set_cb=did_set_pumblend,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [214]={
    .fullname="pumheight",
    .shortname="ph",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPumheight,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ph,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [215]={
    .fullname="pumwidth",
    .shortname="pw",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPumwidth,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_pw,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 15L },
  },
  [216]={
    .fullname="pyxversion",
    .shortname="pyx",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptPyxversion,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_pyx,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 3L },
  },
  [217]={
    .fullname="quickfixtextfunc",
    .shortname="qftf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure|kOptFlagFunc,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptQuickfixtextfunc,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_qftf,
    .immutable=false,
    .opt_did_set_cb=did_set_quickfixtextfunc,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [218]={
    .fullname="quoteescape",
    .shortname="qe",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptQuoteescape,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_qe,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "\\", .size = sizeof("\\") - 1 } },
  },
  [219]={
    .fullname="readonly",
    .shortname="ro",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat|kOptFlagNoGlob,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptReadonly,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ro,
    .immutable=false,
    .opt_did_set_cb=did_set_readonly,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [220]={
    .fullname="redrawdebug",
    .shortname="rdb",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptRedrawdebug,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_rdb_values,
    .values_len=6,
    .flags_var=&rdb_flags,
    .var=&p_rdb,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [221]={
    .fullname="redrawtime",
    .shortname="rdt",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptRedrawtime,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_rdt,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 2000L },
  },
  [222]={
    .fullname="regexpengine",
    .shortname="re",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptRegexpengine,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_re,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [223]={
    .fullname="relativenumber",
    .shortname="rnu",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptRelativenumber
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_number_relativenumber,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [224]={
    .fullname="remap",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptRemap,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[224].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [225]={
    .fullname="report",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptReport,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_report,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 2L },
  },
  [226]={
    .fullname="revins",
    .shortname="ri",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptRevins,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ri,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [227]={
    .fullname="rightleft",
    .shortname="rl",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptRightleft
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [228]={
    .fullname="rightleftcmd",
    .shortname="rlc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptRightleftcmd
    },
    .values=opt_rlc_values,
    .values_len=1,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "search", .size = sizeof("search") - 1 } },
  },
  [229]={
    .fullname="ruler",
    .shortname="ru",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptRuler,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ru,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [230]={
    .fullname="rulerformat",
    .shortname="ruf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrStat|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptRulerformat,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ruf,
    .immutable=false,
    .opt_did_set_cb=did_set_rulerformat,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [231]={
    .fullname="runtimepath",
    .shortname="rtp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagNoDefExp|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptRuntimepath,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_rtp,
    .immutable=false,
    .opt_did_set_cb=did_set_runtimepackpath,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [232]={
    .fullname="scroll",
    .shortname="scr",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptScroll
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [233]={
    .fullname="scrollback",
    .shortname="scbk",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrBuf,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptScrollback,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_scbk,
    .immutable=false,
    .opt_did_set_cb=did_set_scrollback,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = -1L },
  },
  [234]={
    .fullname="scrollbind",
    .shortname="scb",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptScrollbind
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_scrollbind,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [235]={
    .fullname="scrolljump",
    .shortname="sj",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptScrolljump,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sj,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1L },
  },
  [236]={
    .fullname="scrolloff",
    .shortname="so",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptScrolloff,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptScrolloff
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_so,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [237]={
    .fullname="scrollopt",
    .shortname="sbo",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptScrollopt,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_sbo_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_sbo,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "ver,jump", .size = sizeof("ver,jump") - 1 } },
  },
  [238]={
    .fullname="sections",
    .shortname="sect",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSections,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sections,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "SHNHH HUnhsh", .size = sizeof("SHNHH HUnhsh") - 1 } },
  },
  [239]={
    .fullname="secure",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSecure,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_secure,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [240]={
    .fullname="selection",
    .shortname="sel",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSelection,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_sel_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_sel,
    .immutable=false,
    .opt_did_set_cb=did_set_selection,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "inclusive", .size = sizeof("inclusive") - 1 } },
  },
  [241]={
    .fullname="selectmode",
    .shortname="slm",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSelectmode,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_slm_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_slm,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [242]={
    .fullname="sessionoptions",
    .shortname="ssop",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSessionoptions,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_ssop_values,
    .values_len=18,
    .flags_var=&ssop_flags,
    .var=&p_ssop,
    .immutable=false,
    .opt_did_set_cb=did_set_sessionoptions,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "blank,buffers,curdir,folds,help,tabpages,winsize,terminal", .size = sizeof("blank,buffers,curdir,folds,help,tabpages,winsize,terminal") - 1 } },
  },
  [243]={
    .fullname="shada",
    .shortname="sd",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShada,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_shada,
    .immutable=false,
    .opt_did_set_cb=did_set_shada,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "!,'100,<50,s10,h", .size = sizeof("!,'100,<50,s10,h") - 1 } },
  },
  [244]={
    .fullname="shadafile",
    .shortname="sdf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShadafile,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_shadafile,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [245]={
    .fullname="shell",
    .shortname="sh",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShell,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sh,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "cmd.exe", .size = sizeof("cmd.exe") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "sh", .size = sizeof("sh") - 1 } },
#endif
  },
  [246]={
    .fullname="shellcmdflag",
    .shortname="shcf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShellcmdflag,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_shcf,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "/s /c", .size = sizeof("/s /c") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "-c", .size = sizeof("-c") - 1 } },
#endif
  },
  [247]={
    .fullname="shellpipe",
    .shortname="sp",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShellpipe,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sp,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "2>&1| tee", .size = sizeof("2>&1| tee") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "| tee", .size = sizeof("| tee") - 1 } },
#endif
  },
  [248]={
    .fullname="shellquote",
    .shortname="shq",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShellquote,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_shq,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [249]={
    .fullname="shellredir",
    .shortname="srr",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShellredir,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_srr,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ">%s 2>&1", .size = sizeof(">%s 2>&1") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ">", .size = sizeof(">") - 1 } },
#endif
  },
  [250]={
    .fullname="shellslash",
    .shortname="ssl",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShellslash,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
#if defined(BACKSLASH_IN_FILENAME)
    .var=&p_ssl,
    .immutable=false,
    .opt_did_set_cb=did_set_shellslash,
    .opt_expand_cb=NULL,
#else
    .var=&options[250].def_val.data,
    .immutable=true,
#endif
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
#else
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
#endif
  },
  [251]={
    .fullname="shelltemp",
    .shortname="stmp",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShelltemp,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_stmp,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [252]={
    .fullname="shellxescape",
    .shortname="sxe",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShellxescape,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sxe,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [253]={
    .fullname="shellxquote",
    .shortname="sxq",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShellxquote,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sxq,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
#if defined(MSWIN)
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "\"", .size = sizeof("\"") - 1 } },
#else
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
#endif
  },
  [254]={
    .fullname="shiftround",
    .shortname="sr",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShiftround,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sr,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [255]={
    .fullname="shiftwidth",
    .shortname="sw",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptShiftwidth,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sw,
    .immutable=false,
    .opt_did_set_cb=did_set_shiftwidth_tabstop,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 8L },
  },
  [256]={
    .fullname="shortmess",
    .shortname="shm",
    .type=kOptValTypeString,
    .flags=0|kOptFlagFlagList,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShortmess,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_shm,
    .immutable=false,
    .opt_did_set_cb=did_set_shortmess,
    .opt_expand_cb=expand_set_shortmess,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "ltToOCF", .size = sizeof("ltToOCF") - 1 } },
  },
  [257]={
    .fullname="showbreak",
    .shortname="sbr",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrAll,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShowbreak,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptShowbreak
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sbr,
    .immutable=false,
    .opt_did_set_cb=did_set_showbreak,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [258]={
    .fullname="showcmd",
    .shortname="sc",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShowcmd,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sc,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [259]={
    .fullname="showcmdloc",
    .shortname="sloc",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShowcmdloc,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_sloc_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_sloc,
    .immutable=false,
    .opt_did_set_cb=did_set_showcmdloc,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "last", .size = sizeof("last") - 1 } },
  },
  [260]={
    .fullname="showfulltag",
    .shortname="sft",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShowfulltag,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sft,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [261]={
    .fullname="showmatch",
    .shortname="sm",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShowmatch,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [262]={
    .fullname="showmode",
    .shortname="smd",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShowmode,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_smd,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [263]={
    .fullname="showtabline",
    .shortname="stal",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrAll|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptShowtabline,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_stal,
    .immutable=false,
    .opt_did_set_cb=did_set_showtabline,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1L },
  },
  [264]={
    .fullname="sidescroll",
    .shortname="ss",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSidescroll,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ss,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1L },
  },
  [265]={
    .fullname="sidescrolloff",
    .shortname="siso",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSidescrolloff,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptSidescrolloff
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_siso,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [266]={
    .fullname="signcolumn",
    .shortname="scl",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptSigncolumn
    },
    .values=opt_scl_values,
    .values_len=22,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_signcolumn,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "auto", .size = sizeof("auto") - 1 } },
  },
  [267]={
    .fullname="smartcase",
    .shortname="scs",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSmartcase,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_scs,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [268]={
    .fullname="smartindent",
    .shortname="si",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSmartindent,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_si,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [269]={
    .fullname="smarttab",
    .shortname="sta",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSmarttab,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sta,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [270]={
    .fullname="smoothscroll",
    .shortname="sms",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptSmoothscroll
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_smoothscroll,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [271]={
    .fullname="softtabstop",
    .shortname="sts",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSofttabstop,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sts,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [272]={
    .fullname="spell",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin|kOptFlagHLOnly,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptSpell
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_spell,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [273]={
    .fullname="spellcapcheck",
    .shortname="spc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrBuf|kOptFlagHLOnly,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSpellcapcheck,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_spc,
    .immutable=false,
    .opt_did_set_cb=did_set_spellcapcheck,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "[.?!]\\_[\\])'\"\\t ]\\+", .size = sizeof("[.?!]\\_[\\])'\"\\t ]\\+") - 1 } },
  },
  [274]={
    .fullname="spellfile",
    .shortname="spf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSpellfile,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_spf,
    .immutable=false,
    .opt_did_set_cb=did_set_spellfile,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [275]={
    .fullname="spelllang",
    .shortname="spl",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrBuf|kOptFlagHLOnly|kOptFlagExpand|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSpelllang,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_spl,
    .immutable=false,
    .opt_did_set_cb=did_set_spelllang,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "en", .size = sizeof("en") - 1 } },
  },
  [276]={
    .fullname="spelloptions",
    .shortname="spo",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagRedrBuf|kOptFlagHLOnly|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSpelloptions,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_spo_values,
    .values_len=2,
    .flags_var=NULL,
    .var=&p_spo,
    .immutable=false,
    .opt_did_set_cb=did_set_spelloptions,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [277]={
    .fullname="spellsuggest",
    .shortname="sps",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSpellsuggest,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_sps_values,
    .values_len=6,
    .flags_var=NULL,
    .var=&p_sps,
    .immutable=false,
    .opt_did_set_cb=did_set_spellsuggest,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "best", .size = sizeof("best") - 1 } },
  },
  [278]={
    .fullname="splitbelow",
    .shortname="sb",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSplitbelow,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sb,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [279]={
    .fullname="splitkeep",
    .shortname="spk",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSplitkeep,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_spk_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_spk,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "cursor", .size = sizeof("cursor") - 1 } },
  },
  [280]={
    .fullname="splitright",
    .shortname="spr",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSplitright,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_spr,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [281]={
    .fullname="startofline",
    .shortname="sol",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptStartofline,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sol,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [282]={
    .fullname="statuscolumn",
    .shortname="stc",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrWin|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptStatuscolumn
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_statuscolumn,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [283]={
    .fullname="statusline",
    .shortname="stl",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrStat|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptStatusline,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptStatusline
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_stl,
    .immutable=false,
    .opt_did_set_cb=did_set_statusline,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [284]={
    .fullname="suffixes",
    .shortname="su",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSuffixes,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_su,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = ".bak,~,.o,.h,.info,.swp,.obj", .size = sizeof(".bak,~,.o,.h,.info,.swp,.obj") - 1 } },
  },
  [285]={
    .fullname="suffixesadd",
    .shortname="sua",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSuffixesadd,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_sua,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [286]={
    .fullname="swapfile",
    .shortname="swf",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSwapfile,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_swf,
    .immutable=false,
    .opt_did_set_cb=did_set_swapfile,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [287]={
    .fullname="switchbuf",
    .shortname="swb",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptSwitchbuf,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_swb_values,
    .values_len=6,
    .flags_var=&swb_flags,
    .var=&p_swb,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "uselast", .size = sizeof("uselast") - 1 } },
  },
  [288]={
    .fullname="synmaxcol",
    .shortname="smc",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrBuf,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSynmaxcol,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_smc,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 3000L },
  },
  [289]={
    .fullname="syntax",
    .shortname="syn",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNoGlob|kOptFlagNFname,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptSyntax,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_syn,
    .immutable=false,
    .opt_did_set_cb=did_set_filetype_or_syntax,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [290]={
    .fullname="tabclose",
    .shortname="tcl",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTabclose,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_tcl_values,
    .values_len=2,
    .flags_var=&tcl_flags,
    .var=&p_tcl,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [291]={
    .fullname="tabline",
    .shortname="tal",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrTabl|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTabline,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tal,
    .immutable=false,
    .opt_did_set_cb=did_set_tabline,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [292]={
    .fullname="tabpagemax",
    .shortname="tpm",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTabpagemax,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tpm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 50L },
  },
  [293]={
    .fullname="tabstop",
    .shortname="ts",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrBuf,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptTabstop,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ts,
    .immutable=false,
    .opt_did_set_cb=did_set_shiftwidth_tabstop,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 8L },
  },
  [294]={
    .fullname="tagbsearch",
    .shortname="tbs",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTagbsearch,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tbs,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [295]={
    .fullname="tagcase",
    .shortname="tc",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTagcase,
      [kOptScopeBuf] = kBufOptTagcase,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_tc_values,
    .values_len=5,
    .flags_var=&tc_flags,
    .var=&p_tc,
    .immutable=false,
    .opt_did_set_cb=did_set_tagcase,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "followic", .size = sizeof("followic") - 1 } },
  },
  [296]={
    .fullname="tagfunc",
    .shortname="tfu",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure|kOptFlagFunc,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptTagfunc,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tfu,
    .immutable=false,
    .opt_did_set_cb=did_set_tagfunc,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [297]={
    .fullname="taglength",
    .shortname="tl",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTaglength,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tl,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [298]={
    .fullname="tagrelative",
    .shortname="tr",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTagrelative,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tr,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [299]={
    .fullname="tags",
    .shortname="tag",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTags,
      [kOptScopeBuf] = kBufOptTags,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tags,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "./tags;,tags", .size = sizeof("./tags;,tags") - 1 } },
  },
  [300]={
    .fullname="tagstack",
    .shortname="tgst",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTagstack,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tgst,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [301]={
    .fullname="termbidi",
    .shortname="tbidi",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTermbidi,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tbidi,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [302]={
    .fullname="termencoding",
    .shortname="tenc",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTermencoding,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[302].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [303]={
    .fullname="termguicolors",
    .shortname="tgc",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTermguicolors,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tgc,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [304]={
    .fullname="termpastefilter",
    .shortname="tpf",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTermpastefilter,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_tpf_values,
    .values_len=7,
    .flags_var=&tpf_flags,
    .var=&p_tpf,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "BS,HT,ESC,DEL", .size = sizeof("BS,HT,ESC,DEL") - 1 } },
  },
  [305]={
    .fullname="termsync",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTermsync,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_termsync,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [306]={
    .fullname="terse",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTerse,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[306].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [307]={
    .fullname="textwidth",
    .shortname="tw",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrBuf|kOptFlagHLOnly,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptTextwidth,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tw,
    .immutable=false,
    .opt_did_set_cb=did_set_textwidth,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [308]={
    .fullname="thesaurus",
    .shortname="tsr",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagNDname|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptThesaurus,
      [kOptScopeBuf] = kBufOptThesaurus,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tsr,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [309]={
    .fullname="thesaurusfunc",
    .shortname="tsrfu",
    .type=kOptValTypeString,
    .flags=0|kOptFlagSecure|kOptFlagFunc,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptThesaurusfunc,
      [kOptScopeBuf] = kBufOptThesaurusfunc,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tsrfu,
    .immutable=false,
    .opt_did_set_cb=did_set_thesaurusfunc,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [310]={
    .fullname="tildeop",
    .shortname="top",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTildeop,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_to,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [311]={
    .fullname="timeout",
    .shortname="to",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTimeout,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_timeout,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [312]={
    .fullname="timeoutlen",
    .shortname="tm",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTimeoutlen,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_tm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1000L },
  },
  [313]={
    .fullname="title",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTitle,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_title,
    .immutable=false,
    .opt_did_set_cb=did_set_title_icon,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [314]={
    .fullname="titlelen",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTitlelen,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_titlelen,
    .immutable=false,
    .opt_did_set_cb=did_set_titlelen,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 85L },
  },
  [315]={
    .fullname="titleold",
    .type=kOptValTypeString,
    .flags=0|kOptFlagNoMkrc|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTitleold,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_titleold,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [316]={
    .fullname="titlestring",
    .type=kOptValTypeString,
    .flags=0|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTitlestring,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_titlestring,
    .immutable=false,
    .opt_did_set_cb=did_set_titlestring,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [317]={
    .fullname="ttimeout",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTtimeout,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ttimeout,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [318]={
    .fullname="ttimeoutlen",
    .shortname="ttm",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTtimeoutlen,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ttm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 50L },
  },
  [319]={
    .fullname="ttyfast",
    .shortname="tf",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagNoMkrc,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptTtyfast,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&options[319].def_val.data,
    .immutable=true,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [320]={
    .fullname="undodir",
    .shortname="udir",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagExpand|kOptFlagNoDefExp|kOptFlagSecure|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptUndodir,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_udir,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [321]={
    .fullname="undofile",
    .shortname="udf",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptUndofile,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_udf,
    .immutable=false,
    .opt_did_set_cb=did_set_undofile,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [322]={
    .fullname="undolevels",
    .shortname="ul",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptUndolevels,
      [kOptScopeBuf] = kBufOptUndolevels,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ul,
    .immutable=false,
    .opt_did_set_cb=did_set_undolevels,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1000L },
  },
  [323]={
    .fullname="undoreload",
    .shortname="ur",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptUndoreload,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ur,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 10000L },
  },
  [324]={
    .fullname="updatecount",
    .shortname="uc",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptUpdatecount,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_uc,
    .immutable=false,
    .opt_did_set_cb=did_set_updatecount,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 200L },
  },
  [325]={
    .fullname="updatetime",
    .shortname="ut",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptUpdatetime,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ut,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 4000L },
  },
  [326]={
    .fullname="varsofttabstop",
    .shortname="vsts",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptVarsofttabstop,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_vsts,
    .immutable=false,
    .opt_did_set_cb=did_set_varsofttabstop,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [327]={
    .fullname="vartabstop",
    .shortname="vts",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagRedrBuf,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptVartabstop,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_vts,
    .immutable=false,
    .opt_did_set_cb=did_set_vartabstop,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [328]={
    .fullname="verbose",
    .shortname="vbs",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagUIOption,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptVerbose,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_verbose,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [329]={
    .fullname="verbosefile",
    .shortname="vfile",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptVerbosefile,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_vfile,
    .immutable=false,
    .opt_did_set_cb=did_set_verbosefile,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [330]={
    .fullname="viewdir",
    .shortname="vdir",
    .type=kOptValTypeString,
    .flags=0|kOptFlagExpand|kOptFlagNoDefExp|kOptFlagSecure,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptViewdir,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_vdir,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [331]={
    .fullname="viewoptions",
    .shortname="vop",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptViewoptions,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=&vop_flags,
    .var=&p_vop,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "folds,cursor,curdir", .size = sizeof("folds,cursor,curdir") - 1 } },
  },
  [332]={
    .fullname="virtualedit",
    .shortname="ve",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagCurswant|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptVirtualedit,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptVirtualedit
    },
    .values=opt_ve_values,
    .values_len=6,
    .flags_var=&ve_flags,
    .var=&p_ve,
    .immutable=false,
    .opt_did_set_cb=did_set_virtualedit,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [333]={
    .fullname="visualbell",
    .shortname="vb",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptVisualbell,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_vb,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [334]={
    .fullname="warn",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWarn,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_warn,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [335]={
    .fullname="whichwrap",
    .shortname="ww",
    .type=kOptValTypeString,
    .flags=0|kOptFlagComma|kOptFlagFlagList,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWhichwrap,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ww,
    .immutable=false,
    .opt_did_set_cb=did_set_whichwrap,
    .opt_expand_cb=expand_set_whichwrap,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "b,s", .size = sizeof("b,s") - 1 } },
  },
  [336]={
    .fullname="wildchar",
    .shortname="wc",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWildchar,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wc,
    .immutable=false,
    .opt_did_set_cb=did_set_wildchar,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = TAB },
  },
  [337]={
    .fullname="wildcharm",
    .shortname="wcm",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWildcharm,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wcm,
    .immutable=false,
    .opt_did_set_cb=did_set_wildchar,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [338]={
    .fullname="wildignore",
    .shortname="wig",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWildignore,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wig,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [339]={
    .fullname="wildignorecase",
    .shortname="wic",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWildignorecase,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wic,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [340]={
    .fullname="wildmenu",
    .shortname="wmnu",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWildmenu,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wmnu,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [341]={
    .fullname="wildmode",
    .shortname="wim",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagColon,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWildmode,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_wim_values,
    .values_len=5,
    .flags_var=NULL,
    .var=&p_wim,
    .immutable=false,
    .opt_did_set_cb=did_set_wildmode,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "full", .size = sizeof("full") - 1 } },
  },
  [342]={
    .fullname="wildoptions",
    .shortname="wop",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWildoptions,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_wop_values,
    .values_len=3,
    .flags_var=&wop_flags,
    .var=&p_wop,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "pum,tagfile", .size = sizeof("pum,tagfile") - 1 } },
  },
  [343]={
    .fullname="winaltkeys",
    .shortname="wak",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWinaltkeys,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_wak_values,
    .values_len=3,
    .flags_var=NULL,
    .var=&p_wak,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "menu", .size = sizeof("menu") - 1 } },
  },
  [344]={
    .fullname="winbar",
    .shortname="wbr",
    .type=kOptValTypeString,
    .flags=0|kOptFlagRedrStat|kOptFlagMLE,
    .scope_flags=0 | (1 << kOptScopeGlobal) | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWinbar,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptWinbar
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wbr,
    .immutable=false,
    .opt_did_set_cb=did_set_winbar,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [345]={
    .fullname="winblend",
    .shortname="winbl",
    .type=kOptValTypeNumber,
    .flags=0|kOptFlagRedrWin|kOptFlagHLOnly,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptWinblend
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_winblend,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [346]={
    .fullname="winborder",
    .type=kOptValTypeString,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWinborder,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=opt_winborder_values,
    .values_len=8,
    .flags_var=NULL,
    .var=&p_winborder,
    .immutable=false,
    .opt_did_set_cb=did_set_str_generic,
    .opt_expand_cb=expand_set_str_generic,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [347]={
    .fullname="window",
    .shortname="wi",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWindow,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_window,
    .immutable=false,
    .opt_did_set_cb=did_set_window,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [348]={
    .fullname="winfixbuf",
    .shortname="wfb",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptWinfixbuf
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [349]={
    .fullname="winfixheight",
    .shortname="wfh",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptWinfixheight
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [350]={
    .fullname="winfixwidth",
    .shortname="wfw",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrStat,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptWinfixwidth
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [351]={
    .fullname="winheight",
    .shortname="wh",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWinheight,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wh,
    .immutable=false,
    .opt_did_set_cb=did_set_winheight,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1L },
  },
  [352]={
    .fullname="winhighlight",
    .shortname="winhl",
    .type=kOptValTypeString,
    .flags=0|kOptFlagOneComma|kOptFlagColon|kOptFlagRedrWin|kOptFlagHLOnly|kOptFlagNoDup,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptWinhighlight
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_winhighlight,
    .opt_expand_cb=expand_set_winhighlight,
    .def_val={ .type = kOptValTypeString, .data.string = { .data = "", .size = sizeof("") - 1 } },
  },
  [353]={
    .fullname="winminheight",
    .shortname="wmh",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWinminheight,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wmh,
    .immutable=false,
    .opt_did_set_cb=did_set_winminheight,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1L },
  },
  [354]={
    .fullname="winminwidth",
    .shortname="wmw",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWinminwidth,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wmw,
    .immutable=false,
    .opt_did_set_cb=did_set_winminwidth,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 1L },
  },
  [355]={
    .fullname="winwidth",
    .shortname="wiw",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWinwidth,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wiw,
    .immutable=false,
    .opt_did_set_cb=did_set_winwidth,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 20L },
  },
  [356]={
    .fullname="wrap",
    .type=kOptValTypeBoolean,
    .flags=0|kOptFlagRedrWin,
    .scope_flags=0 | (1 << kOptScopeWin),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptWrap
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=NULL,
    .immutable=false,
    .opt_did_set_cb=did_set_wrap,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [357]={
    .fullname="wrapmargin",
    .shortname="wm",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeBuf),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptInvalid,
      [kOptScopeBuf] = kBufOptWrapmargin,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wm,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
  [358]={
    .fullname="wrapscan",
    .shortname="ws",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWrapscan,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_ws,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [359]={
    .fullname="write",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWrite,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_write,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [360]={
    .fullname="writeany",
    .shortname="wa",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWriteany,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wa,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = false },
  },
  [361]={
    .fullname="writebackup",
    .shortname="wb",
    .type=kOptValTypeBoolean,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWritebackup,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wb,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeBoolean, .data.boolean = true },
  },
  [362]={
    .fullname="writedelay",
    .shortname="wd",
    .type=kOptValTypeNumber,
    .flags=0,
    .scope_flags=0 | (1 << kOptScopeGlobal),
    .scope_idx={
      [kOptScopeGlobal] = kGlobalOptWritedelay,
      [kOptScopeBuf] = kBufOptInvalid,
      [kOptScopeWin] = kWinOptInvalid
    },
    .values=NULL,
    .values_len=0,
    .flags_var=NULL,
    .var=&p_wd,
    .immutable=false,
    .opt_did_set_cb=NULL,
    .opt_expand_cb=NULL,
    .def_val={ .type = kOptValTypeNumber, .data.number = 0L },
  },
};
