// Code generated by ndpgen. DO NOT EDIT.

package host

import (
	"context"
	"encoding/json"

	extism "github.com/extism/go-sdk"
)

// SchedulerScheduleOneTimeRequest is the request type for Scheduler.ScheduleOneTime.
type SchedulerScheduleOneTimeRequest struct {
	DelaySeconds int32  `json:"delaySeconds"`
	Payload      string `json:"payload"`
	ScheduleID   string `json:"scheduleId"`
}

// SchedulerScheduleOneTimeResponse is the response type for Scheduler.ScheduleOneTime.
type SchedulerScheduleOneTimeResponse struct {
	NewScheduleID string `json:"newScheduleId,omitempty"`
	Error         string `json:"error,omitempty"`
}

// SchedulerScheduleRecurringRequest is the request type for Scheduler.ScheduleRecurring.
type SchedulerScheduleRecurringRequest struct {
	CronExpression string `json:"cronExpression"`
	Payload        string `json:"payload"`
	ScheduleID     string `json:"scheduleId"`
}

// SchedulerScheduleRecurringResponse is the response type for Scheduler.ScheduleRecurring.
type SchedulerScheduleRecurringResponse struct {
	NewScheduleID string `json:"newScheduleId,omitempty"`
	Error         string `json:"error,omitempty"`
}

// SchedulerCancelScheduleRequest is the request type for Scheduler.CancelSchedule.
type SchedulerCancelScheduleRequest struct {
	ScheduleID string `json:"scheduleId"`
}

// SchedulerCancelScheduleResponse is the response type for Scheduler.CancelSchedule.
type SchedulerCancelScheduleResponse struct {
	Error string `json:"error,omitempty"`
}

// RegisterSchedulerHostFunctions registers Scheduler service host functions.
// The returned host functions should be added to the plugin's configuration.
func RegisterSchedulerHostFunctions(service SchedulerService) []extism.HostFunction {
	return []extism.HostFunction{
		newSchedulerScheduleOneTimeHostFunction(service),
		newSchedulerScheduleRecurringHostFunction(service),
		newSchedulerCancelScheduleHostFunction(service),
	}
}

func newSchedulerScheduleOneTimeHostFunction(service SchedulerService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"scheduler_scheduleonetime",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				schedulerWriteError(p, stack, err)
				return
			}
			var req SchedulerScheduleOneTimeRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				schedulerWriteError(p, stack, err)
				return
			}

			// Call the service method
			newscheduleid, svcErr := service.ScheduleOneTime(ctx, req.DelaySeconds, req.Payload, req.ScheduleID)
			if svcErr != nil {
				schedulerWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := SchedulerScheduleOneTimeResponse{
				NewScheduleID: newscheduleid,
			}
			schedulerWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newSchedulerScheduleRecurringHostFunction(service SchedulerService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"scheduler_schedulerecurring",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				schedulerWriteError(p, stack, err)
				return
			}
			var req SchedulerScheduleRecurringRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				schedulerWriteError(p, stack, err)
				return
			}

			// Call the service method
			newscheduleid, svcErr := service.ScheduleRecurring(ctx, req.CronExpression, req.Payload, req.ScheduleID)
			if svcErr != nil {
				schedulerWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := SchedulerScheduleRecurringResponse{
				NewScheduleID: newscheduleid,
			}
			schedulerWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

func newSchedulerCancelScheduleHostFunction(service SchedulerService) extism.HostFunction {
	return extism.NewHostFunctionWithStack(
		"scheduler_cancelschedule",
		func(ctx context.Context, p *extism.CurrentPlugin, stack []uint64) {
			// Read JSON request from plugin memory
			reqBytes, err := p.ReadBytes(stack[0])
			if err != nil {
				schedulerWriteError(p, stack, err)
				return
			}
			var req SchedulerCancelScheduleRequest
			if err := json.Unmarshal(reqBytes, &req); err != nil {
				schedulerWriteError(p, stack, err)
				return
			}

			// Call the service method
			if svcErr := service.CancelSchedule(ctx, req.ScheduleID); svcErr != nil {
				schedulerWriteError(p, stack, svcErr)
				return
			}

			// Write JSON response to plugin memory
			resp := SchedulerCancelScheduleResponse{}
			schedulerWriteResponse(p, stack, resp)
		},
		[]extism.ValueType{extism.ValueTypePTR},
		[]extism.ValueType{extism.ValueTypePTR},
	)
}

// schedulerWriteResponse writes a JSON response to plugin memory.
func schedulerWriteResponse(p *extism.CurrentPlugin, stack []uint64, resp any) {
	respBytes, err := json.Marshal(resp)
	if err != nil {
		schedulerWriteError(p, stack, err)
		return
	}
	respPtr, err := p.WriteBytes(respBytes)
	if err != nil {
		stack[0] = 0
		return
	}
	stack[0] = respPtr
}

// schedulerWriteError writes an error response to plugin memory.
func schedulerWriteError(p *extism.CurrentPlugin, stack []uint64, err error) {
	errResp := struct {
		Error string `json:"error"`
	}{Error: err.Error()}
	respBytes, _ := json.Marshal(errResp)
	respPtr, _ := p.WriteBytes(respBytes)
	stack[0] = respPtr
}
