/* UndoBuffer.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoBuffer.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;
typedef struct _UndoBufferPrivate UndoBufferPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;
enum  {
	UNDO_BUFFER_0_PROPERTY,
	UNDO_BUFFER_NUM_PROPERTIES
};
static GParamSpec* undo_buffer_properties[UNDO_BUFFER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	UNDO_BUFFER_BUFFER_CHANGED_SIGNAL,
	UNDO_BUFFER_NUM_SIGNALS
};
static guint undo_buffer_signals[UNDO_BUFFER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UndoBuffer {
	GObject parent_instance;
	UndoBufferPrivate * priv;
	DrawArea* _da;
	GArray* _undo_buffer;
	GArray* _redo_buffer;
};

struct _UndoBufferClass {
	GObjectClass parent_class;
	void (*undo) (UndoBuffer* self);
	void (*redo) (UndoBuffer* self);
};

struct _UndoBufferPrivate {
	gboolean _debug;
};

static gint UndoBuffer_private_offset;
static gpointer undo_buffer_parent_class = NULL;
static gint undo_buffer__current_id;
static gint undo_buffer__current_id = 0;

VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN void undo_buffer_undo (UndoBuffer* self);
VALA_EXTERN void undo_buffer_redo (UndoBuffer* self);
VALA_EXTERN UndoBuffer* undo_buffer_new (DrawArea* da);
VALA_EXTERN UndoBuffer* undo_buffer_construct (GType object_type,
                                   DrawArea* da);
static void _g_object_unref0_ (gpointer var);
static void _vala_UndoItem_free_function_content_of (gpointer data);
VALA_EXTERN void undo_buffer_clear (UndoBuffer* self);
VALA_EXTERN gboolean undo_buffer_undoable (UndoBuffer* self);
VALA_EXTERN gboolean undo_buffer_redoable (UndoBuffer* self);
static void undo_buffer_real_undo (UndoBuffer* self);
VALA_EXTERN void undo_item_undo (UndoItem* self,
                     DrawArea* da);
VALA_EXTERN void undo_buffer_output (UndoBuffer* self,
                         const gchar* msg);
static void undo_buffer_real_redo (UndoBuffer* self);
VALA_EXTERN void undo_item_redo (UndoItem* self,
                     DrawArea* da);
VALA_EXTERN gchar* undo_buffer_undo_tooltip (UndoBuffer* self);
VALA_EXTERN const gchar* undo_item_get_name (UndoItem* self);
VALA_EXTERN gchar* undo_buffer_redo_tooltip (UndoBuffer* self);
VALA_EXTERN void undo_buffer_add_item (UndoBuffer* self,
                           UndoItem* item);
VALA_EXTERN void undo_item_set_id (UndoItem* self,
                       gint value);
VALA_EXTERN void undo_buffer_replace_item (UndoBuffer* self,
                               UndoItem* item);
VALA_EXTERN gboolean undo_item_matches (UndoItem* self,
                            UndoItem* item);
VALA_EXTERN void undo_item_replace_with_item (UndoItem* self,
                                  UndoItem* item);
VALA_EXTERN gchar* undo_item_to_string (UndoItem* self);
static void undo_buffer_finalize (GObject * obj);
static GType undo_buffer_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
undo_buffer_get_instance_private (UndoBuffer* self)
{
	return G_STRUCT_MEMBER_P (self, UndoBuffer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_UndoItem_free_function_content_of (gpointer data)
{
	UndoItem* self;
	self = *((UndoItem**) data);
	_g_object_unref0_ (self);
}

UndoBuffer*
undo_buffer_construct (GType object_type,
                       DrawArea* da)
{
	UndoBuffer * self = NULL;
	DrawArea* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (UndoBuffer*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->_da);
	self->_da = _tmp0_;
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (UndoItem*));
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_UndoItem_free_function_content_of);
	_g_array_unref0 (self->_undo_buffer);
	self->_undo_buffer = _tmp1_;
	_tmp2_ = g_array_new (TRUE, TRUE, sizeof (UndoItem*));
	g_array_set_clear_func (_tmp2_, (GDestroyNotify) _vala_UndoItem_free_function_content_of);
	_g_array_unref0 (self->_redo_buffer);
	self->_redo_buffer = _tmp2_;
	return self;
}

UndoBuffer*
undo_buffer_new (DrawArea* da)
{
	return undo_buffer_construct (TYPE_UNDO_BUFFER, da);
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
undo_buffer_clear (UndoBuffer* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	UndoItem** _tmp4_;
	gint _tmp4__length1;
	GArray* _tmp5_;
	GArray* _tmp6_;
	gint _tmp7_ = 0;
	gpointer* _tmp8_;
	UndoItem** _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->_undo_buffer;
	_tmp1_ = self->_undo_buffer;
	_tmp3_ = vala_g_array_remove_range (_tmp0_, (guint) 0, _tmp1_->len, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp5_ = self->_redo_buffer;
	_tmp6_ = self->_redo_buffer;
	_tmp8_ = vala_g_array_remove_range (_tmp5_, (guint) 0, _tmp6_->len, &_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp7_;
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_object_unref), NULL);
	g_signal_emit (self, undo_buffer_signals[UNDO_BUFFER_BUFFER_CHANGED_SIGNAL], 0, self);
}

gboolean
undo_buffer_undoable (UndoBuffer* self)
{
	GArray* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->_undo_buffer;
	result = _tmp0_->len > ((guint) 0);
	return result;
}

gboolean
undo_buffer_redoable (UndoBuffer* self)
{
	GArray* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->_redo_buffer;
	result = _tmp0_->len > ((guint) 0);
	return result;
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

static void
undo_buffer_real_undo (UndoBuffer* self)
{
	if (undo_buffer_undoable (self)) {
		UndoItem* item = NULL;
		GArray* _tmp0_;
		GArray* _tmp1_;
		UndoItem* _tmp2_;
		UndoItem* _tmp3_;
		UndoItem* _tmp4_;
		DrawArea* _tmp5_;
		GArray* _tmp6_;
		GArray* _tmp7_;
		UndoItem* _tmp8_;
		UndoItem* _tmp9_;
		GArray* _tmp10_;
		UndoItem* _tmp11_;
		UndoItem* _tmp12_;
		_tmp0_ = self->_undo_buffer;
		_tmp1_ = self->_undo_buffer;
		_tmp2_ = g_array_index (_tmp0_, UndoItem*, _tmp1_->len - 1);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		item = _tmp3_;
		_tmp4_ = item;
		_tmp5_ = self->_da;
		undo_item_undo (_tmp4_, _tmp5_);
		_tmp6_ = self->_undo_buffer;
		_tmp7_ = self->_undo_buffer;
		_tmp8_ = vala_g_array_remove_index (_tmp6_, _tmp7_->len - 1);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp9_);
		_tmp10_ = self->_redo_buffer;
		_tmp11_ = item;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		g_array_append_val (_tmp10_, _tmp12_);
		g_signal_emit (self, undo_buffer_signals[UNDO_BUFFER_BUFFER_CHANGED_SIGNAL], 0, self);
		_g_object_unref0 (item);
	}
	undo_buffer_output (self, "AFTER UNDO");
}

void
undo_buffer_undo (UndoBuffer* self)
{
	UndoBufferClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = UNDO_BUFFER_GET_CLASS (self);
	if (_klass_->undo) {
		_klass_->undo (self);
	}
}

static void
undo_buffer_real_redo (UndoBuffer* self)
{
	if (undo_buffer_redoable (self)) {
		UndoItem* item = NULL;
		GArray* _tmp0_;
		GArray* _tmp1_;
		UndoItem* _tmp2_;
		UndoItem* _tmp3_;
		UndoItem* _tmp4_;
		DrawArea* _tmp5_;
		GArray* _tmp6_;
		GArray* _tmp7_;
		UndoItem* _tmp8_;
		UndoItem* _tmp9_;
		GArray* _tmp10_;
		UndoItem* _tmp11_;
		UndoItem* _tmp12_;
		_tmp0_ = self->_redo_buffer;
		_tmp1_ = self->_redo_buffer;
		_tmp2_ = g_array_index (_tmp0_, UndoItem*, _tmp1_->len - 1);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		item = _tmp3_;
		_tmp4_ = item;
		_tmp5_ = self->_da;
		undo_item_redo (_tmp4_, _tmp5_);
		_tmp6_ = self->_redo_buffer;
		_tmp7_ = self->_redo_buffer;
		_tmp8_ = vala_g_array_remove_index (_tmp6_, _tmp7_->len - 1);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp9_);
		_tmp10_ = self->_undo_buffer;
		_tmp11_ = item;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		g_array_append_val (_tmp10_, _tmp12_);
		g_signal_emit (self, undo_buffer_signals[UNDO_BUFFER_BUFFER_CHANGED_SIGNAL], 0, self);
		_g_object_unref0 (item);
	}
	undo_buffer_output (self, "AFTER REDO");
}

void
undo_buffer_redo (UndoBuffer* self)
{
	UndoBufferClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = UNDO_BUFFER_GET_CLASS (self);
	if (_klass_->redo) {
		_klass_->redo (self);
	}
}

gchar*
undo_buffer_undo_tooltip (UndoBuffer* self)
{
	GArray* _tmp0_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	UndoItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_undo_buffer;
	if (_tmp0_->len == ((guint) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (_ ("Undo"));
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->_undo_buffer;
	_tmp3_ = self->_undo_buffer;
	_tmp4_ = g_array_index (_tmp2_, UndoItem*, _tmp3_->len - 1);
	_tmp5_ = undo_item_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_ ("Undo "), _tmp6_, NULL);
	result = _tmp7_;
	return result;
}

gchar*
undo_buffer_redo_tooltip (UndoBuffer* self)
{
	GArray* _tmp0_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	UndoItem* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_redo_buffer;
	if (_tmp0_->len == ((guint) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (_ ("Redo"));
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->_redo_buffer;
	_tmp3_ = self->_redo_buffer;
	_tmp4_ = g_array_index (_tmp2_, UndoItem*, _tmp3_->len - 1);
	_tmp5_ = undo_item_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_ ("Redo "), _tmp6_, NULL);
	result = _tmp7_;
	return result;
}

void
undo_buffer_add_item (UndoBuffer* self,
                      UndoItem* item)
{
	gint _tmp0_;
	GArray* _tmp1_;
	UndoItem* _tmp2_;
	GArray* _tmp3_;
	GArray* _tmp4_;
	gint _tmp5_ = 0;
	gpointer* _tmp6_;
	UndoItem** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = undo_buffer__current_id;
	undo_buffer__current_id = _tmp0_ + 1;
	undo_item_set_id (item, _tmp0_);
	_tmp1_ = self->_undo_buffer;
	_tmp2_ = _g_object_ref0 (item);
	g_array_append_val (_tmp1_, _tmp2_);
	_tmp3_ = self->_redo_buffer;
	_tmp4_ = self->_redo_buffer;
	_tmp6_ = vala_g_array_remove_range (_tmp3_, (guint) 0, _tmp4_->len, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_object_unref), NULL);
	g_signal_emit (self, undo_buffer_signals[UNDO_BUFFER_BUFFER_CHANGED_SIGNAL], 0, self);
	undo_buffer_output (self, "ITEM ADDED");
}

void
undo_buffer_replace_item (UndoBuffer* self,
                          UndoItem* item)
{
	gint _tmp0_;
	GArray* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = undo_buffer__current_id;
	undo_buffer__current_id = _tmp0_ + 1;
	undo_item_set_id (item, _tmp0_);
	_tmp1_ = self->_undo_buffer;
	if (_tmp1_->len > ((guint) 0)) {
		UndoItem* last = NULL;
		GArray* _tmp2_;
		GArray* _tmp3_;
		UndoItem* _tmp4_;
		UndoItem* _tmp5_;
		gboolean _tmp6_ = FALSE;
		UndoItem* _tmp7_;
		_tmp2_ = self->_undo_buffer;
		_tmp3_ = self->_undo_buffer;
		_tmp4_ = g_array_index (_tmp2_, UndoItem*, _tmp3_->len - 1);
		_tmp5_ = _g_object_ref0 (_tmp4_);
		last = _tmp5_;
		_tmp7_ = last;
		if (G_TYPE_FROM_INSTANCE ((GObject*) _tmp7_) == G_TYPE_FROM_INSTANCE ((GObject*) item)) {
			UndoItem* _tmp8_;
			_tmp8_ = last;
			_tmp6_ = undo_item_matches (_tmp8_, item);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			UndoItem* _tmp9_;
			_tmp9_ = last;
			undo_item_replace_with_item (_tmp9_, item);
			g_signal_emit (self, undo_buffer_signals[UNDO_BUFFER_BUFFER_CHANGED_SIGNAL], 0, self);
			undo_buffer_output (self, "ITEM REPLACED");
			_g_object_unref0 (last);
			return;
		}
		_g_object_unref0 (last);
	}
	undo_buffer_add_item (self, item);
}

void
undo_buffer_output (UndoBuffer* self,
                    const gchar* msg)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	if (self->priv->_debug) {
		FILE* _tmp0_;
		FILE* _tmp9_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "%s\n  Undo Buffer\n-----------\n", msg);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GArray* _tmp3_;
					FILE* _tmp4_;
					GArray* _tmp5_;
					UndoItem* _tmp6_;
					gchar* _tmp7_;
					gchar* _tmp8_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = self->_undo_buffer;
					if (!(((guint) i) < _tmp3_->len)) {
						break;
					}
					_tmp4_ = stdout;
					_tmp5_ = self->_undo_buffer;
					_tmp6_ = g_array_index (_tmp5_, UndoItem*, (guint) i);
					_tmp7_ = undo_item_to_string (_tmp6_);
					_tmp8_ = _tmp7_;
					fprintf (_tmp4_, "    %s\n", _tmp8_);
					_g_free0 (_tmp8_);
				}
			}
		}
		_tmp9_ = stdout;
		fprintf (_tmp9_, "  Redo Buffer\n-----------\n");
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp10_ = FALSE;
				_tmp10_ = TRUE;
				while (TRUE) {
					GArray* _tmp12_;
					FILE* _tmp13_;
					GArray* _tmp14_;
					UndoItem* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					if (!_tmp10_) {
						gint _tmp11_;
						_tmp11_ = i;
						i = _tmp11_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp12_ = self->_redo_buffer;
					if (!(((guint) i) < _tmp12_->len)) {
						break;
					}
					_tmp13_ = stdout;
					_tmp14_ = self->_redo_buffer;
					_tmp15_ = g_array_index (_tmp14_, UndoItem*, (guint) i);
					_tmp16_ = undo_item_to_string (_tmp15_);
					_tmp17_ = _tmp16_;
					fprintf (_tmp13_, "    %s\n", _tmp17_);
					_g_free0 (_tmp17_);
				}
			}
		}
	}
}

static void
undo_buffer_class_init (UndoBufferClass * klass,
                        gpointer klass_data)
{
	undo_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoBuffer_private_offset);
	((UndoBufferClass *) klass)->undo = (void (*) (UndoBuffer*)) undo_buffer_real_undo;
	((UndoBufferClass *) klass)->redo = (void (*) (UndoBuffer*)) undo_buffer_real_redo;
	G_OBJECT_CLASS (klass)->finalize = undo_buffer_finalize;
	undo_buffer_signals[UNDO_BUFFER_BUFFER_CHANGED_SIGNAL] = g_signal_new ("buffer-changed", TYPE_UNDO_BUFFER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_UNDO_BUFFER);
}

static void
undo_buffer_instance_init (UndoBuffer * self,
                           gpointer klass)
{
	self->priv = undo_buffer_get_instance_private (self);
	self->priv->_debug = FALSE;
}

static void
undo_buffer_finalize (GObject * obj)
{
	UndoBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_BUFFER, UndoBuffer);
	_g_object_unref0 (self->_da);
	_g_array_unref0 (self->_undo_buffer);
	_g_array_unref0 (self->_redo_buffer);
	G_OBJECT_CLASS (undo_buffer_parent_class)->finalize (obj);
}

static GType
undo_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoBuffer), 0, (GInstanceInitFunc) undo_buffer_instance_init, NULL };
	GType undo_buffer_type_id;
	undo_buffer_type_id = g_type_register_static (G_TYPE_OBJECT, "UndoBuffer", &g_define_type_info, 0);
	UndoBuffer_private_offset = g_type_add_instance_private (undo_buffer_type_id, sizeof (UndoBufferPrivate));
	return undo_buffer_type_id;
}

GType
undo_buffer_get_type (void)
{
	static volatile gsize undo_buffer_type_id__once = 0;
	if (g_once_init_enter (&undo_buffer_type_id__once)) {
		GType undo_buffer_type_id;
		undo_buffer_type_id = undo_buffer_get_type_once ();
		g_once_init_leave (&undo_buffer_type_id__once, undo_buffer_type_id);
	}
	return undo_buffer_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

