/* NodeImage.c generated by valac 0.56.18, the Vala compiler
 * generated from NodeImage.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <libxml/tree.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#define NODE_IMAGE_EDIT_WIDTH 600
#define NODE_IMAGE_EDIT_HEIGHT 600
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NODE_IMAGE (node_image_get_type ())
#define NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_IMAGE, NodeImage))
#define NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_IMAGE, NodeImageClass))
#define IS_NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_IMAGE))
#define IS_NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_IMAGE))
#define NODE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_IMAGE, NodeImageClass))

typedef struct _NodeImage NodeImage;
typedef struct _NodeImageClass NodeImageClass;
typedef struct _NodeImagePrivate NodeImagePrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecNodeImage ParamSpecNodeImage;

struct _NodeImage {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NodeImagePrivate * priv;
};

struct _NodeImageClass {
	GTypeClass parent_class;
	void (*finalize) (NodeImage *self);
	void (*save) (NodeImage* self, xmlNode* parent);
};

struct _NodeImagePrivate {
	cairo_surface_t* _surface;
	GdkPixbuf* _buf;
	gint _id;
	gboolean _valid;
	gint _crop_x;
	gint _crop_y;
	gint _crop_w;
	gint _crop_h;
	gboolean _resizable;
};

struct _ParamSpecNodeImage {
	GParamSpec parent_instance;
};

static gint NodeImage_private_offset;
static gpointer node_image_parent_class = NULL;

VALA_EXTERN gpointer node_image_ref (gpointer instance);
VALA_EXTERN void node_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_image (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_image (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_image (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_image (const GValue* value);
VALA_EXTERN GType node_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeImage, node_image_unref)
VALA_EXTERN void node_image_save (NodeImage* self,
                      xmlNode* parent);
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN NodeImage* node_image_new (ImageManager* im,
                           gint id,
                           gint width);
VALA_EXTERN NodeImage* node_image_construct (GType object_type,
                                 ImageManager* im,
                                 gint id,
                                 gint width);
static gboolean node_image_load (NodeImage* self,
                          ImageManager* im,
                          gint id,
                          gboolean init);
VALA_EXTERN void node_image_set_width (NodeImage* self,
                           gint width);
VALA_EXTERN NodeImage* node_image_new_from_uri (ImageManager* im,
                                    const gchar* uri,
                                    gint width);
VALA_EXTERN NodeImage* node_image_construct_from_uri (GType object_type,
                                          ImageManager* im,
                                          const gchar* uri,
                                          gint width);
VALA_EXTERN gint image_manager_add_image (ImageManager* self,
                              const gchar* uri,
                              gint* orig_id);
VALA_EXTERN void image_manager_set_valid (ImageManager* self,
                              gint id,
                              gboolean value);
VALA_EXTERN NodeImage* node_image_new_from_pixbuf (ImageManager* im,
                                       GdkPixbuf* buf,
                                       gint width);
VALA_EXTERN NodeImage* node_image_construct_from_pixbuf (GType object_type,
                                             ImageManager* im,
                                             GdkPixbuf* buf,
                                             gint width);
VALA_EXTERN gint image_manager_add_pixbuf (ImageManager* self,
                               GdkPixbuf* buf,
                               gint* orig_id);
VALA_EXTERN NodeImage* node_image_new_from_node_image (ImageManager* im,
                                           NodeImage* ni,
                                           gint width);
VALA_EXTERN NodeImage* node_image_construct_from_node_image (GType object_type,
                                                 ImageManager* im,
                                                 NodeImage* ni,
                                                 gint width);
VALA_EXTERN gchar* image_manager_get_uri (ImageManager* self,
                              gint id);
VALA_EXTERN gint node_image_get_id (NodeImage* self);
VALA_EXTERN gint node_image_get_crop_x (NodeImage* self);
VALA_EXTERN void node_image_set_crop_x (NodeImage* self,
                            gint value);
VALA_EXTERN gint node_image_get_crop_y (NodeImage* self);
VALA_EXTERN void node_image_set_crop_y (NodeImage* self,
                            gint value);
VALA_EXTERN gint node_image_get_crop_w (NodeImage* self);
VALA_EXTERN void node_image_set_crop_w (NodeImage* self,
                            gint value);
VALA_EXTERN gint node_image_get_crop_h (NodeImage* self);
VALA_EXTERN void node_image_set_crop_h (NodeImage* self,
                            gint value);
VALA_EXTERN NodeImage* node_image_new_from_xml (ImageManager* im,
                                    xmlNode* n,
                                    gint width);
VALA_EXTERN NodeImage* node_image_construct_from_xml (GType object_type,
                                          ImageManager* im,
                                          xmlNode* n,
                                          gint width);
VALA_EXTERN gint image_manager_get_id (ImageManager* self,
                           gint id);
VALA_EXTERN void node_image_set_id (NodeImage* self,
                        gint value);
VALA_EXTERN void node_image_set_resizable (NodeImage* self,
                               gboolean value);
static void node_image_set_valid (NodeImage* self,
                           gboolean value);
VALA_EXTERN gchar* image_manager_get_file (ImageManager* self,
                               gint id);
VALA_EXTERN gboolean node_image_get_valid (NodeImage* self);
VALA_EXTERN gboolean node_image_get_resizable (NodeImage* self);
VALA_EXTERN cairo_surface_t* node_image_get_surface (NodeImage* self);
VALA_EXTERN GdkPixbuf* node_image_get_pixbuf (NodeImage* self);
VALA_EXTERN void node_image_draw (NodeImage* self,
                      cairo_t* ctx,
                      gdouble x,
                      gdouble y,
                      gdouble opacity);
VALA_EXTERN void node_image_set_image (NodeImage* self,
                           GtkImage* img);
static void node_image_real_save (NodeImage* self,
                           xmlNode* parent);
VALA_EXTERN gint node_image_get_width (NodeImage* self);
VALA_EXTERN gint node_image_get_height (NodeImage* self);
static void node_image_finalize (NodeImage * obj);
static GType node_image_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
node_image_get_instance_private (NodeImage* self)
{
	return G_STRUCT_MEMBER_P (self, NodeImage_private_offset);
}

NodeImage*
node_image_construct (GType object_type,
                      ImageManager* im,
                      gint id,
                      gint width)
{
	NodeImage* self = NULL;
	g_return_val_if_fail (im != NULL, NULL);
	self = (NodeImage*) g_type_create_instance (object_type);
	if (node_image_load (self, im, id, TRUE)) {
		node_image_set_width (self, width);
	}
	return self;
}

NodeImage*
node_image_new (ImageManager* im,
                gint id,
                gint width)
{
	return node_image_construct (TYPE_NODE_IMAGE, im, id, width);
}

NodeImage*
node_image_construct_from_uri (GType object_type,
                               ImageManager* im,
                               const gchar* uri,
                               gint width)
{
	NodeImage* self = NULL;
	gint id = 0;
	g_return_val_if_fail (im != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (NodeImage*) g_type_create_instance (object_type);
	id = image_manager_add_image (im, uri, NULL);
	if (id != -1) {
		if (node_image_load (self, im, id, TRUE)) {
			node_image_set_width (self, width);
		} else {
			image_manager_set_valid (im, id, FALSE);
		}
	}
	return self;
}

NodeImage*
node_image_new_from_uri (ImageManager* im,
                         const gchar* uri,
                         gint width)
{
	return node_image_construct_from_uri (TYPE_NODE_IMAGE, im, uri, width);
}

NodeImage*
node_image_construct_from_pixbuf (GType object_type,
                                  ImageManager* im,
                                  GdkPixbuf* buf,
                                  gint width)
{
	NodeImage* self = NULL;
	gint id = 0;
	g_return_val_if_fail (im != NULL, NULL);
	g_return_val_if_fail (buf != NULL, NULL);
	self = (NodeImage*) g_type_create_instance (object_type);
	id = image_manager_add_pixbuf (im, buf, NULL);
	if (id != -1) {
		if (node_image_load (self, im, id, TRUE)) {
			node_image_set_width (self, width);
		} else {
			image_manager_set_valid (im, id, FALSE);
		}
	}
	return self;
}

NodeImage*
node_image_new_from_pixbuf (ImageManager* im,
                            GdkPixbuf* buf,
                            gint width)
{
	return node_image_construct_from_pixbuf (TYPE_NODE_IMAGE, im, buf, width);
}

NodeImage*
node_image_construct_from_node_image (GType object_type,
                                      ImageManager* im,
                                      NodeImage* ni,
                                      gint width)
{
	NodeImage* self = NULL;
	gchar* uri = NULL;
	gint _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (im != NULL, NULL);
	g_return_val_if_fail (ni != NULL, NULL);
	self = (NodeImage*) g_type_create_instance (object_type);
	_tmp0_ = ni->priv->_id;
	_tmp1_ = image_manager_get_uri (im, _tmp0_);
	uri = _tmp1_;
	_tmp2_ = uri;
	if (g_strcmp0 (_tmp2_, "") != 0) {
		gint id = 0;
		const gchar* _tmp3_;
		_tmp3_ = uri;
		id = image_manager_add_image (im, _tmp3_, NULL);
		if (id != -1) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp4_ = ni->priv->_crop_x;
			node_image_set_crop_x (self, _tmp4_);
			_tmp5_ = ni->priv->_crop_y;
			node_image_set_crop_y (self, _tmp5_);
			_tmp6_ = ni->priv->_crop_w;
			node_image_set_crop_w (self, _tmp6_);
			_tmp7_ = ni->priv->_crop_h;
			node_image_set_crop_h (self, _tmp7_);
			if (node_image_load (self, im, id, FALSE)) {
				node_image_set_width (self, width);
			} else {
				image_manager_set_valid (im, id, FALSE);
			}
		}
	}
	_g_free0 (uri);
	return self;
}

NodeImage*
node_image_new_from_node_image (ImageManager* im,
                                NodeImage* ni,
                                gint width)
{
	return node_image_construct_from_node_image (TYPE_NODE_IMAGE, im, ni, width);
}

NodeImage*
node_image_construct_from_xml (GType object_type,
                               ImageManager* im,
                               xmlNode* n,
                               gint width)
{
	NodeImage* self = NULL;
	gboolean resize = FALSE;
	gchar* i = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* x = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* y = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* w = NULL;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* h = NULL;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* s = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp18_;
	g_return_val_if_fail (im != NULL, NULL);
	self = (NodeImage*) g_type_create_instance (object_type);
	resize = FALSE;
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "id");
	i = _tmp0_;
	_tmp1_ = i;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = i;
		node_image_set_id (self, image_manager_get_id (im, atoi (_tmp2_)));
	}
	_tmp3_ = (gchar*) xmlGetProp (n, (xmlChar*) "x");
	x = _tmp3_;
	_tmp4_ = x;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = x;
		node_image_set_crop_x (self, atoi (_tmp5_));
	}
	_tmp6_ = (gchar*) xmlGetProp (n, (xmlChar*) "y");
	y = _tmp6_;
	_tmp7_ = y;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = y;
		node_image_set_crop_y (self, atoi (_tmp8_));
	}
	_tmp9_ = (gchar*) xmlGetProp (n, (xmlChar*) "w");
	w = _tmp9_;
	_tmp10_ = w;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		_tmp11_ = w;
		node_image_set_crop_w (self, atoi (_tmp11_));
	}
	_tmp12_ = (gchar*) xmlGetProp (n, (xmlChar*) "h");
	h = _tmp12_;
	_tmp13_ = h;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = h;
		node_image_set_crop_h (self, atoi (_tmp14_));
	}
	_tmp15_ = (gchar*) xmlGetProp (n, (xmlChar*) "size");
	s = _tmp15_;
	_tmp16_ = s;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		resize = TRUE;
		_tmp17_ = s;
		width = atoi (_tmp17_);
	}
	_tmp18_ = self->priv->_id;
	if (_tmp18_ != -1) {
		gint _tmp19_;
		_tmp19_ = self->priv->_id;
		if (node_image_load (self, im, _tmp19_, FALSE)) {
			node_image_set_width (self, width);
		}
	}
	node_image_set_resizable (self, resize);
	_g_free0 (s);
	_g_free0 (h);
	_g_free0 (w);
	_g_free0 (y);
	_g_free0 (x);
	_g_free0 (i);
	return self;
}

NodeImage*
node_image_new_from_xml (ImageManager* im,
                         xmlNode* n,
                         gint width)
{
	return node_image_construct_from_xml (TYPE_NODE_IMAGE, im, n, width);
}

static gboolean
node_image_load (NodeImage* self,
                 ImageManager* im,
                 gint id,
                 gboolean init)
{
	gboolean _tmp9_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (im != NULL, FALSE);
	node_image_set_id (self, id);
	node_image_set_valid (self, TRUE);
	{
		gchar* fname = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		GdkPixbuf* buf = NULL;
		const gchar* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		cairo_surface_t* _tmp5_;
		_tmp0_ = image_manager_get_file (im, id);
		fname = _tmp0_;
		_tmp1_ = fname;
		if (_tmp1_ == NULL) {
			node_image_set_valid (self, FALSE);
			result = FALSE;
			_g_free0 (fname);
			return result;
		}
		_tmp2_ = fname;
		_tmp3_ = gdk_pixbuf_new_from_file_at_size (_tmp2_, NODE_IMAGE_EDIT_WIDTH, NODE_IMAGE_EDIT_HEIGHT, &_inner_error0_);
		buf = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (fname);
			goto __catch0_g_error;
		}
		_tmp4_ = buf;
		_tmp5_ = gdk_cairo_surface_create_from_pixbuf (_tmp4_, 1, NULL);
		_cairo_surface_destroy0 (self->priv->_surface);
		self->priv->_surface = (cairo_surface_t*) _tmp5_;
		if (init) {
			cairo_surface_t* _tmp6_;
			cairo_surface_t* _tmp7_;
			node_image_set_crop_x (self, 0);
			node_image_set_crop_y (self, 0);
			_tmp6_ = self->priv->_surface;
			node_image_set_crop_w (self, cairo_image_surface_get_width (_tmp6_));
			_tmp7_ = self->priv->_surface;
			node_image_set_crop_h (self, cairo_image_surface_get_height (_tmp7_));
		}
		_g_object_unref0 (buf);
		_g_free0 (fname);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		node_image_set_valid (self, FALSE);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp8_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp9_ = self->priv->_valid;
	result = _tmp9_;
	return result;
}

void
node_image_set_width (NodeImage* self,
                      gint width)
{
	gboolean _tmp0_;
	gdouble scale = 0.0;
	gint _tmp1_;
	GdkPixbuf* buf = NULL;
	cairo_surface_t* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GdkPixbuf* _tmp7_;
	gint int_crop_h = 0;
	gint _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_resizable;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_crop_w;
	scale = (width * 1.0) / _tmp1_;
	_tmp2_ = self->priv->_surface;
	_tmp3_ = self->priv->_crop_x;
	_tmp4_ = self->priv->_crop_y;
	_tmp5_ = self->priv->_crop_w;
	_tmp6_ = self->priv->_crop_h;
	_tmp7_ = gdk_pixbuf_get_from_surface (_tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	buf = _tmp7_;
	_tmp8_ = self->priv->_crop_h;
	int_crop_h = (gint) (_tmp8_ * scale);
	_tmp9_ = buf;
	_tmp10_ = gdk_pixbuf_scale_simple (_tmp9_, width, int_crop_h, GDK_INTERP_BILINEAR);
	_g_object_unref0 (self->priv->_buf);
	self->priv->_buf = _tmp10_;
	_g_object_unref0 (buf);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

cairo_surface_t*
node_image_get_surface (NodeImage* self)
{
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_surface;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GdkPixbuf*
node_image_get_pixbuf (NodeImage* self)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buf;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
node_image_draw (NodeImage* self,
                 cairo_t* ctx,
                 gdouble x,
                 gdouble y,
                 gdouble opacity)
{
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	_tmp0_ = self->priv->_buf;
	gdk_cairo_set_source_pixbuf (ctx, _tmp0_, x, y);
	cairo_paint_with_alpha (ctx, opacity);
}

void
node_image_set_image (NodeImage* self,
                      GtkImage* img)
{
	gdouble scale_width = 0.0;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble scale_height = 0.0;
	GdkPixbuf* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint w = 0;
	gint h = 0;
	GdkPixbuf* buf = NULL;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (img != NULL);
	_tmp0_ = self->priv->_buf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	scale_width = 300.0 / _tmp2_;
	_tmp3_ = self->priv->_buf;
	_tmp4_ = gdk_pixbuf_get_height (_tmp3_);
	_tmp5_ = _tmp4_;
	scale_height = 300.0 / _tmp5_;
	w = 300;
	h = 300;
	if (scale_width < scale_height) {
		GdkPixbuf* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->_buf;
		_tmp7_ = gdk_pixbuf_get_height (_tmp6_);
		_tmp8_ = _tmp7_;
		h = (gint) (scale_width * _tmp8_);
	} else {
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = self->priv->_buf;
		_tmp10_ = gdk_pixbuf_get_width (_tmp9_);
		_tmp11_ = _tmp10_;
		w = (gint) (scale_height * _tmp11_);
	}
	_tmp12_ = self->priv->_buf;
	_tmp13_ = gdk_pixbuf_scale_simple (_tmp12_, w, h, GDK_INTERP_BILINEAR);
	buf = _tmp13_;
	gtk_image_set_from_pixbuf (img, buf);
	_g_object_unref0 (buf);
}

static void
node_image_real_save (NodeImage* self,
                      xmlNode* parent)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	xmlNode* _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	xmlNode* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	xmlNode* _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	xmlNode* _tmp17_;
	gint _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	xmlNode* _tmp28_;
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "nodeimage");
	n = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = self->priv->_id;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	xmlNewProp (_tmp1_, (xmlChar*) "id", (xmlChar*) _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = n;
	_tmp6_ = self->priv->_crop_x;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	xmlNewProp (_tmp5_, (xmlChar*) "x", (xmlChar*) _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = n;
	_tmp10_ = self->priv->_crop_y;
	_tmp11_ = g_strdup_printf ("%i", _tmp10_);
	_tmp12_ = _tmp11_;
	xmlNewProp (_tmp9_, (xmlChar*) "y", (xmlChar*) _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = n;
	_tmp14_ = self->priv->_crop_w;
	_tmp15_ = g_strdup_printf ("%i", _tmp14_);
	_tmp16_ = _tmp15_;
	xmlNewProp (_tmp13_, (xmlChar*) "w", (xmlChar*) _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = n;
	_tmp18_ = self->priv->_crop_h;
	_tmp19_ = g_strdup_printf ("%i", _tmp18_);
	_tmp20_ = _tmp19_;
	xmlNewProp (_tmp17_, (xmlChar*) "h", (xmlChar*) _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = self->priv->_resizable;
	if (!_tmp21_) {
		xmlNode* _tmp22_;
		GdkPixbuf* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp22_ = n;
		_tmp23_ = self->priv->_buf;
		_tmp24_ = gdk_pixbuf_get_width (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strdup_printf ("%i", _tmp25_);
		_tmp27_ = _tmp26_;
		xmlNewProp (_tmp22_, (xmlChar*) "size", (xmlChar*) _tmp27_);
		_g_free0 (_tmp27_);
	}
	_tmp28_ = n;
	xmlAddChild (parent, _tmp28_);
}

void
node_image_save (NodeImage* self,
                 xmlNode* parent)
{
	NodeImageClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NODE_IMAGE_GET_CLASS (self);
	if (_klass_->save) {
		_klass_->save (self, parent);
	}
}

gint
node_image_get_id (NodeImage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_id;
	return result;
}

void
node_image_set_id (NodeImage* self,
                   gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_id = value;
}

gboolean
node_image_get_valid (NodeImage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_valid;
	return result;
}

static void
node_image_set_valid (NodeImage* self,
                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_valid = value;
}

gint
node_image_get_crop_x (NodeImage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_crop_x;
	return result;
}

void
node_image_set_crop_x (NodeImage* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_crop_x = value;
}

gint
node_image_get_crop_y (NodeImage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_crop_y;
	return result;
}

void
node_image_set_crop_y (NodeImage* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_crop_y = value;
}

gint
node_image_get_crop_w (NodeImage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_crop_w;
	return result;
}

void
node_image_set_crop_w (NodeImage* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_crop_w = value;
}

gint
node_image_get_crop_h (NodeImage* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_crop_h;
	return result;
}

void
node_image_set_crop_h (NodeImage* self,
                       gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_crop_h = value;
}

gint
node_image_get_width (NodeImage* self)
{
	gint result;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_buf;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gint
node_image_get_height (NodeImage* self)
{
	gint result;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_buf;
	_tmp1_ = gdk_pixbuf_get_height (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
node_image_get_resizable (NodeImage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_resizable;
	return result;
}

void
node_image_set_resizable (NodeImage* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_resizable = value;
}

static void
value_node_image_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_node_image_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		node_image_unref (value->data[0].v_pointer);
	}
}

static void
value_node_image_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = node_image_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_node_image_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_node_image_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NodeImage * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = node_image_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_node_image_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	NodeImage ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = node_image_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_node_image (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecNodeImage* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NODE_IMAGE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_node_image (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_IMAGE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_node_image (GValue* value,
                      gpointer v_object)
{
	NodeImage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		node_image_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_image_unref (old);
	}
}

void
value_take_node_image (GValue* value,
                       gpointer v_object)
{
	NodeImage * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_IMAGE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE_IMAGE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_image_unref (old);
	}
}

static void
node_image_class_init (NodeImageClass * klass,
                       gpointer klass_data)
{
	node_image_parent_class = g_type_class_peek_parent (klass);
	((NodeImageClass *) klass)->finalize = node_image_finalize;
	g_type_class_adjust_private_offset (klass, &NodeImage_private_offset);
	((NodeImageClass *) klass)->save = (void (*) (NodeImage*, xmlNode*)) node_image_real_save;
}

static void
node_image_instance_init (NodeImage * self,
                          gpointer klass)
{
	self->priv = node_image_get_instance_private (self);
	self->priv->_id = -1;
	self->priv->_valid = FALSE;
	self->priv->_crop_x = 0;
	self->priv->_crop_y = 0;
	self->priv->_crop_w = 0;
	self->priv->_crop_h = 0;
	self->priv->_resizable = TRUE;
	self->ref_count = 1;
}

static void
node_image_finalize (NodeImage * obj)
{
	NodeImage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NODE_IMAGE, NodeImage);
	g_signal_handlers_destroy (self);
	_cairo_surface_destroy0 (self->priv->_surface);
	_g_object_unref0 (self->priv->_buf);
}

static GType
node_image_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_node_image_init, value_node_image_free_value, value_node_image_copy_value, value_node_image_peek_pointer, "p", value_node_image_collect_value, "p", value_node_image_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NodeImageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) node_image_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NodeImage), 0, (GInstanceInitFunc) node_image_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType node_image_type_id;
	node_image_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NodeImage", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NodeImage_private_offset = g_type_add_instance_private (node_image_type_id, sizeof (NodeImagePrivate));
	return node_image_type_id;
}

GType
node_image_get_type (void)
{
	static volatile gsize node_image_type_id__once = 0;
	if (g_once_init_enter (&node_image_type_id__once)) {
		GType node_image_type_id;
		node_image_type_id = node_image_get_type_once ();
		g_once_init_leave (&node_image_type_id__once, node_image_type_id);
	}
	return node_image_type_id__once;
}

gpointer
node_image_ref (gpointer instance)
{
	NodeImage * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
node_image_unref (gpointer instance)
{
	NodeImage * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NODE_IMAGE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

