
#include "nir.h"
#include "nir_builder.h"
#include "nir_search.h"
#include "nir_search_helpers.h"

/* What follows is NIR algebraic transform code for the following 2755
 * transforms:
 *    ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b'))
 *    ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b'))
 *    ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a'))
 *    ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a')))
 *    ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul', 'a@8', 128) => ('ishl', 'a', 7)
 *    ('imul', 'a@16', 32768) => ('ishl', 'a', 15)
 *    ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31)
 *    ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63)
 *    ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b'))
 *    ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b')))
 *    ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b')
 *    ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b'))
 *    ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b'))
 *    ('udiv', 'a', 1) => a
 *    ('idiv', 'a', 1) => a
 *    ('umod', 'a', 1) => 0
 *    ('imod', 'a', 1) => 0
 *    ('imod', 'a', -1) => 0
 *    ('irem', 'a', 1) => 0
 *    ('irem', 'a', -1) => 0
 *    ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b'))
 *    ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b')))
 *    ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b')))))
 *    ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1))
 *    ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b'))
 *    ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b')))
 *    ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b'))
 *    ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5)))
 *    ('~fneg', ('fneg', 'a')) => a
 *    ('ineg', ('ineg', 'a')) => a
 *    ('fabs', ('fneg', 'a')) => ('fabs', 'a')
 *    ('fabs', ('u2f', 'a')) => ('u2f', 'a')
 *    ('iabs', ('iabs', 'a')) => ('iabs', 'a')
 *    ('iabs', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fadd', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float,nsz)', 'a', 0.0) => a
 *    ('fadd(is_only_used_as_float)', 'a', '#b(is_negative_zero)') => a
 *    ('fadd', ('fneg', 'a'), '#b(is_negative_zero)') => ('fneg', 'a')
 *    ('iadd', 'a', 0) => a
 *    ('iadd_sat', 'a', 0) => a
 *    ('isub_sat', 'a', 0) => a
 *    ('uadd_sat', 'a', 0) => a
 *    ('usub_sat', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', 0) => a
 *    ('usadd_4x8_vc4', 'a', -1) => -1
 *    ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd'))
 *    ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c'))
 *    ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd')
 *    ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd'))
 *    ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c'))
 *    ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a')
 *    ('iand', ('iand', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', ('iand', 'a', 'b'), 'c')
 *    ('ior', ('ior', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', ('ior', 'a', 'b'), 'c')
 *    ('iand', ('ior(is_used_once)', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c'))
 *    ('ior', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c'))
 *    ('ior', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', 'c')
 *    ('iand', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('iand', 'a', 'b')
 *    ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0)
 *    ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0)
 *    ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b'))
 *    ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b'))
 *    ('~fadd', ('fneg', 'a'), 'a') => 0.0
 *    ('iadd', ('ineg', 'a'), 'a') => 0
 *    ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b
 *    ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b
 *    ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b
 *    ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b
 *    ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a'))
 *    ('fadd', 'a', 'a') => ('fmul', 'a', 2.0)
 *    ('fadd(contract)', 'a', ('fadd(is_used_once)', 'a', 'b')) => ('fadd', 'b', ('fmul', 'a', 2.0))
 *    ('~fmul', 'a', 0.0) => 0.0
 *    ('fmul(nsz,nnan)', 'a', 0.0) => 0.0
 *    ('fmulz', 'a', 0.0) => 0.0
 *    ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b')
 *    ('fmulz', 'a', 'a') => ('fmul', 'a', 'a')
 *    ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b')
 *    ('imul', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', 0) => 0
 *    ('umul_unorm_4x8_vc4', 'a', -1) => a
 *    ('~fmul', 'a', 1.0) => a
 *    ('~fmulz', 'a', 1.0) => a
 *    ('fmul(is_only_used_as_float)', 'a', 1.0) => a
 *    ('imul', 'a', 1) => a
 *    ('fmul', 'a', -1.0) => ('fneg', 'a')
 *    ('imul', 'a', -1) => ('ineg', 'a')
 *    ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a')
 *    ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a')
 *    ('~ffma', 0.0, 'a', 'b') => b
 *    ('ffma(is_only_used_as_float,nsz,nnan,ninf)', 0.0, 'a', 'b') => b
 *    ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b')
 *    ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b')
 *    ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b')
 *    ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b')
 *    ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b')
 *    ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~flrp', 'a', 'b', 0.0) => a
 *    ('~flrp', 'a', 'b', 1.0) => b
 *    ('~flrp', 'a', 'a', 'b') => a
 *    ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b')
 *    ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('sdot_4x8_iadd', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd', 'a', 0, 'b') => b
 *    ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_4x8_uadd_sat', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd', 'a', 0, 'b') => b
 *    ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b
 *    ('udot_2x16_uadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd', 0, 'a', 'b') => b
 *    ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b
 *    ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b
 *    ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd'))
 *    ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c')
 *    ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c')
 *    ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c')
 *    ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), 'a', 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'b')), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fabs', 'b'), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fabs', 'b'), 0.0)) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), 'a', 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', 'a', 'b')
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), 'b')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', 'a'), ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b'))
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', 'a'), 'b')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', 'a', 'b')) => ('fmulz', 'a', 'b')
 *    ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b')
 *    ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b')
 *    ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b')
 *    ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c')
 *    ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c')
 *    ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b')))
 *    ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b'))
 *    ('iand(is_only_used_as_float)', 'a@16', 32767) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@16', 32768) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@16', 32768) => ('fneg', ('fabs', 'a'))
 *    ('iand(is_only_used_as_float)', 'a@32', 2147483647) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', ('fabs', 'a'))
 *    ('iand(is_only_used_as_float)', 'a@64', 9223372036854775807) => ('fabs', 'a')
 *    ('ixor(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', 'a')
 *    ('ior(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', ('fabs', 'a'))
 *    ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c')
 *    ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c')
 *    ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c')
 *    ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c')
 *    ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c')
 *    ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c')
 *    ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c')
 *    ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a')
 *    ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a')
 *    ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c'))
 *    ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c')
 *    ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a')
 *    ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b'))
 *    ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a')
 *    ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a')
 *    ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a')
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('iand', ('flt', 'a', 0), ('flt', ('fneg', ('ffract', 'a')), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('inot', ('fge', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a')))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd', ('ffloor', 'a'), ('b2f', ('flt', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0))
 *    ('fadd(nnan,nsz)', 'a', ('ffract', ('fneg', 'a'))) => ('fceil', 'a')
 *    ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a')))
 *    ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a'))
 *    ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a'))
 *    ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a'))
 *    ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a'))
 *    ('fadd@16(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@32(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('fadd@64(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a')
 *    ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a'))
 *    ('fadd@16', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a')
 *    ('fadd@32', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a')
 *    ('fadd@64', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a')
 *    ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a')))
 *    ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('ffma@16(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@32(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffma@64(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c')
 *    ('ffmaz(contract)', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c')
 *    ('~fmul', ('fadd', ('bcsel', 'a', ('fmul', 'b', 'c'), 0), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e'))
 *    ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b')
 *    ('fdot4', 'a', 0.0) => 0.0
 *    ('fdot3', 'a', 0.0) => 0.0
 *    ('fdot2', 'a', 0.0) => 0.0
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd')
 *    ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c')
 *    ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b')
 *    ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y')
 *    ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a')))
 *    ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd'))
 *    ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c'))
 *    ('imul', ('ishl', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'c', 'b'))
 *    ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7))
 *    ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15))
 *    ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31))
 *    ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0)
 *    ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63))
 *    ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b'))
 *    ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b'))
 *    ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b'))
 *    ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b'))
 *    ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b'))
 *    ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b'))
 *    ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b'))
 *    ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b'))
 *    ('iand@32', ('ushr@32(is_used_once)', 'a', 'b'), '#c(is_const_bitmask)') => ('ubfe', 'a', 'b', ('bit_count', 'c'))
 *    ('iand@32', ('ushr@32', 'a', 'b'), ('bfm', 'c', 0)) => ('ubfe', 'a', 'b', 'c')
 *    ('ushr', ('iand', 'a', ('bfm', 'c', 'b')), 'b') => ('ubfe', 'a', 'b', 'c')
 *    ('ushr@32', ('iand(is_used_once)', 'a', '#b(is_const_bfm)'), '#c') => ('bcsel', ('ilt', ('find_lsb', 'b'), ('iand', 'c', 31)), ('ushr', ('ubfe', 'a', ('find_lsb', 'b'), ('bit_count', 'b')), ('isub', 'c', ('find_lsb', 'b'))), ('ishl', ('ubfe', 'a', ('find_lsb', 'b'), ('bit_count', 'b')), ('isub', ('find_lsb', 'b'), 'c')))
 *    ('ubfe', ('ubfe', 'a', '#b', '#c'), '#d', '#e') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 'e', 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0))))
 *    ('ushr@32', ('ubfe', 'a', '#b', '#c'), '#d(is_5lsb_not_zero)') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 31, 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0))))
 *    ('iand', 'a(is_unsigned_multiple_of_4)', -4) => a
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b')
 *    ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b')
 *    ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1)
 *    ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1)
 *    ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1)
 *    ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2)
 *    ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2)
 *    ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2)
 *    ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16)
 *    ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16)
 *    ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16)
 *    ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24)
 *    ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24)
 *    ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24)
 *    ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c'))
 *    ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd'))
 *    ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd'))
 *    ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b')
 *    ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b')
 *    ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b')
 *    ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b')
 *    ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b')
 *    ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b')
 *    ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b')
 *    ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b')
 *    ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b')
 *    ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False
 *    ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False
 *    ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False
 *    ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False
 *    ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False
 *    ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a')
 *    ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a')
 *    ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a')
 *    ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a')
 *    ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a')
 *    ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b'))
 *    ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a')
 *    ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b'))
 *    ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a')
 *    ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b'))
 *    ('flt', 'a', '#b(is_negative_zero)') => ('flt', 'a', 0.0)
 *    ('flt', '#b(is_negative_zero)', 'a') => ('flt', 0.0, 'a')
 *    ('fge', 'a', '#b(is_negative_zero)') => ('fge', 'a', 0.0)
 *    ('fge', '#b(is_negative_zero)', 'a') => ('fge', 0.0, 'a')
 *    ('fneu', 'a', '#b(is_negative_zero)') => ('fneu', 0.0, 'a')
 *    ('feq', '#b(is_negative_zero)', 'a') => ('feq', 'a', 0.0)
 *    ('ieq', ('ineg', 'a(is_not_const)'), '#b') => ('ieq', 'a', ('ineg', 'b'))
 *    ('ine', ('ineg', 'a(is_not_const)'), '#b') => ('ine', 'a', ('ineg', 'b'))
 *    ('ieq', ('inot', 'a(is_not_const)'), '#b') => ('ieq', 'a', ('inot', 'b'))
 *    ('ine', ('inot', 'a(is_not_const)'), '#b') => ('ine', 'a', ('inot', 'b'))
 *    ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0)
 *    ('ieq', ('bit_count(is_used_once)', 'a'), 0) => ('ieq', 'a', 0)
 *    ('ine', ('bit_count(is_used_once)', 'a'), 0) => ('ine', 'a', 0)
 *    ('ieq', ('ineg', 'a'), ('ineg', 'b')) => ('ieq', 'a', 'b')
 *    ('ine', ('ineg', 'a'), ('ineg', 'b')) => ('ine', 'a', 'b')
 *    ('ieq', ('inot', 'a'), ('inot', 'b')) => ('ieq', 'a', 'b')
 *    ('ine', ('inot', 'a'), ('inot', 'b')) => ('ine', 'a', 'b')
 *    ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0)
 *    ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0)
 *    ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a')
 *    ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a')
 *    ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a')
 *    ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b')
 *    ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b')
 *    ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b')
 *    ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0)
 *    ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a')
 *    ('bcsel(is_only_used_as_float)', ('feq', 'a', 'b(is_not_zero)'), 'b', 'a') => a
 *    ('bcsel(is_only_used_as_float)', ('fneu', 'a', 'b(is_not_zero)'), 'a', 'b') => a
 *    ('bcsel', ('feq', 'a', 0, 'ignore_exact'), 0, ('fsat', ('fmul', 'a', 'b(is_a_number)'))) => ('!fsat', ('fmul', 'a', 'b'))
 *    ('bcsel', ('fneu', 'a', 0, 'ignore_exact'), ('fsat', ('fmul', 'a', 'b(is_a_number)')), 0) => ('!fsat', ('fmul', 'a', 'b'))
 *    ('bcsel', ('feq', 'a', 0, 'ignore_exact'), 'b', ('fadd', 'a', 'b(is_not_zero)')) => ('fadd', 'a', 'b')
 *    ('bcsel', ('fneu', 'a', 0, 'ignore_exact'), ('fadd', 'a', 'b(is_not_zero)'), 'b') => ('fadd', 'a', 'b')
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b')
 *    ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b')
 *    ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b')
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b')
 *    ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b')
 *    ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b')
 *    ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b')
 *    ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b')
 *    ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b'))
 *    ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0)
 *    ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0)
 *    ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b'))
 *    ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0)
 *    ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0)
 *    ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0)
 *    ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0)
 *    ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b')))
 *    ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a')
 *    ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0)
 *    ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0)
 *    ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a')
 *    ('flt', 0.0, ('b2f', 'a@1')) => a
 *    ('ieq', 'a@1', False) => ('inot', 'a')
 *    ('ieq', 'a@1', True) => a
 *    ('ine', 'a@1', False) => a
 *    ('ine', 'a@1', True) => ('inot', 'a')
 *    ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('u2f', 'a'), 0.0) => True
 *    ('fge', 0.0, ('u2f', 'a')) => ('ieq', 0, 'a')
 *    ('flt', ('u2f', 'a'), 0.0) => False
 *    ('flt', 0.0, ('u2f', 'a')) => ('ine', 0, 'a')
 *    ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0)
 *    ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0)
 *    ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0)
 *    ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a')
 *    ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0)
 *    ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a')
 *    ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0)
 *    ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0)
 *    ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0)
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a'))
 *    ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b'))
 *    ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b')))
 *    ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b')))
 *    ('bcsel', 'a', ('b2f', 'b@1'), 0) => ('b2f', ('bcsel', 'a', 'b', False))
 *    ('bcsel', 'a', ('b2f', 'b@1'), 1.0) => ('b2f', ('bcsel', 'a', 'b', True))
 *    ('bcsel', 'a', 0, ('b2f', 'b@1')) => ('b2f', ('bcsel', 'a', False, 'b'))
 *    ('bcsel', 'a', 1.0, ('b2f', 'b@1')) => ('b2f', ('bcsel', 'a', True, 'b'))
 *    ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0))
 *    ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b')
 *    ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0)
 *    ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b')
 *    ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b')
 *    ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b')
 *    ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd')
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b')
 *    ('bcsel', 'a', 'b', True) => ('ior', ('inot', 'a'), 'b')
 *    ('bcsel', 'a', False, 'b') => ('iand', ('inot', 'a'), 'b')
 *    ('fmin', 'a@64', 'a') => a
 *    ('fmin', 'a@32', 'a') => a
 *    ('fmin', 'a@16', 'a') => a
 *    ('fmax', 'a@64', 'a') => a
 *    ('fmax', 'a@32', 'a') => a
 *    ('fmax', 'a@16', 'a') => a
 *    ('imin', 'a', 'a') => a
 *    ('imax', 'a', 'a') => a
 *    ('umin', 'a', 'a') => a
 *    ('umin', 'a', 0) => 0
 *    ('umin', 'a', -1) => a
 *    ('umax', 'a', 'a') => a
 *    ('umax', 'a', 0) => a
 *    ('umax', 'a', -1) => -1
 *    ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b')
 *    ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b')
 *    ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b')
 *    ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b')
 *    ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b')
 *    ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b')
 *    ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c')
 *    ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c')
 *    ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c')
 *    ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c')
 *    ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c')
 *    ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c')
 *    ('fmin', ('fmax', 'a(is_finite)', 'b'), 'a') => ('fmul', 1.0, 'a')
 *    ('fmax', ('fmin', 'a(is_finite)', 'b'), 'a') => ('fmul', 1.0, 'a')
 *    ('umin', ('umax', 'a', 'b'), 'a') => a
 *    ('umax', ('umin', 'a', 'b'), 'a') => a
 *    ('imin', ('imax', 'a', 'b'), 'a') => a
 *    ('imax', ('imin', 'a', 'b'), 'a') => a
 *    ('fmax(nsz)', 'a(is_a_number_not_negative)', 'b(is_not_positive)') => ('fmul', 'a', 1.0)
 *    ('fmin(nsz)', 'a(is_a_number_not_positive)', 'b(is_not_negative)') => ('fmul', 'a', 1.0)
 *    ('fmax', 'a(is_a_number_not_negative)', 'b(is_lt_zero)') => ('fmul', 'a', 1.0)
 *    ('fmin', 'a(is_a_number_not_positive)', 'b(is_gt_zero)') => ('fmul', 'a', 1.0)
 *    ('fneg', ('fmax(is_used_once)', ('fneg', 'a'), ('fneg', 'b'))) => ('fmin', 'a', 'b')
 *    ('fneg', ('fmin(is_used_once)', ('fneg', 'a'), ('fneg', 'b'))) => ('fmax', 'a', 'b')
 *    ('fneg', ('fmax(is_used_once)', ('fneg', 'a'), '#b')) => ('fmin', 'a', ('fneg', 'b'))
 *    ('fneg', ('fmin(is_used_once)', ('fneg', 'a'), '#b')) => ('fmax', 'a', ('fneg', 'b'))
 *    ('fmin(nsz)', 'a', '#b(is_negative_zero)') => ('fmin', 'a', 0.0)
 *    ('fmax(nsz)', 'a', '#b(is_negative_zero)') => ('fmax', 'a', 0.0)
 *    ('ine', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('ine', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('ine', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c'))
 *    ('ine', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c'))
 *    ('ieq', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ieq', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ieq', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c'))
 *    ('ieq', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c'))
 *    ('ilt', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ilt', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ige', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('ult', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('uge', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('bitz', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('bitz', 'b', 'd'), ('bitz', 'c', 'd'))
 *    ('bitz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('bitz', 'b', 'd'), ('bitz', 'c', 'd'))
 *    ('bitz', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('bitz', 'd', 'b'), ('bitz', 'd', 'c'))
 *    ('bitz', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('bitz', 'd', 'b'), ('bitz', 'd', 'c'))
 *    ('bitnz', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('bitnz', 'b', 'd'), ('bitnz', 'c', 'd'))
 *    ('bitnz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('bitnz', 'b', 'd'), ('bitnz', 'c', 'd'))
 *    ('bitnz', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('bitnz', 'd', 'b'), ('bitnz', 'd', 'c'))
 *    ('bitnz', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('bitnz', 'd', 'b'), ('bitnz', 'd', 'c'))
 *    ('fneu', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('fneu', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('fneu', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fneu', 'd', 'b'), ('fneu', 'd', 'c'))
 *    ('fneu', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fneu', 'd', 'b'), ('fneu', 'd', 'c'))
 *    ('feq', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('feq', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('feq', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c'))
 *    ('feq', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c'))
 *    ('flt', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('flt', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('fge', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('fneo', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fneo', 'b', 'd'), ('fneo', 'c', 'd'))
 *    ('fneo', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fneo', 'b', 'd'), ('fneo', 'c', 'd'))
 *    ('fneo', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fneo', 'd', 'b'), ('fneo', 'd', 'c'))
 *    ('fneo', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fneo', 'd', 'b'), ('fneo', 'd', 'c'))
 *    ('fequ', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fequ', 'b', 'd'), ('fequ', 'c', 'd'))
 *    ('fequ', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fequ', 'b', 'd'), ('fequ', 'c', 'd'))
 *    ('fequ', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fequ', 'd', 'b'), ('fequ', 'd', 'c'))
 *    ('fequ', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fequ', 'd', 'b'), ('fequ', 'd', 'c'))
 *    ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b')
 *    ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b')
 *    ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b')
 *    ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b')
 *    ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 128) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@8', 128), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@8', 128), 128) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@8', 7), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@8', 7), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@8', 7), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@8', 7), -1) => ('ige', 'a', 0)
 *    ('iand@16', 'a', ('inot', ('ishr', 'a', 15))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 32768) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@16', 32768), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@16', 32768), 32768) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@16', 15), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@16', 15), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@16', 15), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@16', 15), -1) => ('ige', 'a', 0)
 *    ('iand@32', 'a', ('inot', ('ishr', 'a', 31))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 2147483648) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@32', 2147483648), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@32', 2147483648), 2147483648) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@32', 31), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@32', 31), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@32', 31), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@32', 31), -1) => ('ige', 'a', 0)
 *    ('iand@64', 'a', ('inot', ('ishr', 'a', 63))) => ('imax', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 0) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ige', 'a', 0)
 *    ('ine', ('iand', 'a@64', 9223372036854775808), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('iand', 'a@64', 9223372036854775808), 9223372036854775808) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ushr', 'a@64', 63), 1) => ('ilt', 'a', 0)
 *    ('ine', ('ushr', 'a@64', 63), 1) => ('ige', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), 0) => ('ilt', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), 0) => ('ige', 'a', 0)
 *    ('ieq', ('ishr', 'a@64', 63), -1) => ('ilt', 'a', 0)
 *    ('ine', ('ishr', 'a@64', 63), -1) => ('ige', 'a', 0)
 *    ('fmin', 'a', ('fneg', 'a')) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', 'a')) => ('ineg', ('iabs', 'a'))
 *    ('fmin', 'a', ('fneg', ('fabs', 'a'))) => ('fneg', ('fabs', 'a'))
 *    ('imin', 'a', ('ineg', ('iabs', 'a'))) => ('ineg', ('iabs', 'a'))
 *    ('~fmin', 'a', ('fabs', 'a')) => a
 *    ('imin', 'a', ('iabs', 'a')) => a
 *    ('~fmax', 'a', ('fneg', ('fabs', 'a'))) => a
 *    ('imax', 'a', ('ineg', ('iabs', 'a'))) => a
 *    ('fmax', 'a', ('fabs', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('iabs', 'a')) => ('iabs', 'a')
 *    ('fmax', 'a', ('fneg', 'a')) => ('fabs', 'a')
 *    ('imax', 'a', ('ineg', 'a')) => ('iabs', 'a')
 *    ('~fmax', ('fabs', 'a'), 0.0) => ('fabs', 'a')
 *    ('fmin', ('fmax', 'a', 0.0), 1.0) => ('fsat', 'a')
 *    ('~fmax', ('fmin', 'a', 1.0), 0.0) => ('fsat', 'a')
 *    ('~fmin', ('fmax', 'a', -1.0), 0.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('~fmax', ('fmin', 'a', 0.0), -1.0) => ('fneg', ('fsat', ('fneg', 'a')))
 *    ('fsat', ('fsign', 'a')) => ('b2f', ('!flt', 0.0, 'a'))
 *    ('fsat', ('b2f', 'a')) => ('b2f', 'a')
 *    ('fsat', 'a') => ('fmin', ('fmax', 'a', 0.0), 1.0)
 *    ('fsat', ('fsat', 'a')) => ('fsat', 'a')
 *    ('fsat', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', 'b'))) => ('fsat', ('fadd', ('fneg', 'a'), ('fneg', 'b')))
 *    ('fsat', ('fneg(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fneg', 'a'), 'b'))
 *    ('fsat(nsz)', ('fneg(is_used_once)', ('fmulz(is_used_once)', 'a', 'b'))) => ('fsat', ('fmulz', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fabs(is_used_once)', ('fmul(is_used_once)', 'a', 'b'))) => ('fsat', ('fmul', ('fabs', 'a'), ('fabs', 'b')))
 *    ('fmin', ('fmax', ('fmin', ('fmax', 'a', 'b'), 'c'), 'b'), 'c') => ('fmin', ('fmax', 'a', 'b'), 'c')
 *    ('imin', ('imax', ('imin', ('imax', 'a', 'b'), 'c'), 'b'), 'c') => ('imin', ('imax', 'a', 'b'), 'c')
 *    ('umin', ('umax', ('umin', ('umax', 'a', 'b'), 'c'), 'b'), 'c') => ('umin', ('umax', 'a', 'b'), 'c')
 *    ('fmax', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmax', 'a', 'b'))
 *    ('fmax', ('fsat(is_used_once)', 'a'), ('fsat(is_used_once)', 'b')) => ('fsat', ('fmax', 'a', 'b'))
 *    ('~fmin', ('fsat', 'a'), '#b(is_zero_to_one)') => ('fsat', ('fmin', 'a', 'b'))
 *    ('~fsat', ('fadd', 1.0, 'a(is_not_negative)')) => 1.0
 *    ('fsat', ('fadd', 1.0, 'a(is_a_number_not_negative)')) => 1.0
 *    ('fneg', ('bcsel(is_used_once)', 'a', '#b', '#c')) => ('bcsel', 'a', ('fneg', 'b'), ('fneg', 'c'))
 *    ('fmax', ('fneg', ('fmin', 'b', 'a')), 'b') => ('fmax', ('fabs', 'b'), ('fneg', 'a'))
 *    ('fmin', ('fneg', ('fmax', 'b', 'a')), 'b') => ('fmin', ('fneg', ('fabs', 'b')), ('fneg', 'a'))
 *    ('fmax', ('fadd(is_used_once)', 'a(is_not_positive)', '#b(is_zero_to_one)'), 0.0) => ('fsat', ('fadd', 'a', 'b'))
 *    ('fmax', ('ffma(is_used_once)', 'a(is_not_positive)', 'b(is_not_negative)', '#c(is_zero_to_one)'), 0.0) => ('fsat', ('ffma', 'a', 'b', 'c'))
 *    ('fmax', ('ffma(is_used_once)', 'a', ('fneg', 'a'), '#b(is_zero_to_one)'), 0.0) => ('fsat', ('ffma', 'a', ('fneg', 'a'), 'b'))
 *    ('fsat', ('fmax', 'a', 'b(is_not_positive)')) => ('fsat', 'a')
 *    ('fsat', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fsat', 'b'), ('fsat', 'c'))
 *    ('fsat', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fsat', 'b'), ('fsat', 'c'))
 *    ('extract_u8', ('imin', ('imax', 'a', 0), 255), 0) => ('imin', ('imax', 'a', 0), 255)
 *    ('ior', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('ior', ('flt', 'a', '#b'), ('flt', 'a', '#c')) => ('flt', 'a', ('!fmax', 'b', 'c'))
 *    ('ior', ('flt', '#a', 'c'), ('flt', '#b', 'c')) => ('flt', ('!fmin', 'a', 'b'), 'c')
 *    ('ior', ('fge', 'a', '#b'), ('fge', 'a', '#c')) => ('fge', 'a', ('!fmin', 'b', 'c'))
 *    ('ior', ('fge', '#a', 'c'), ('fge', '#b', 'c')) => ('fge', ('!fmax', 'a', 'b'), 'c')
 *    ('~iand', ('flt(is_used_once)', 'a', 'b'), ('flt', 'a', 'c')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('~iand', ('flt(is_used_once)', 'a', 'c'), ('flt', 'b', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('~iand', ('fge(is_used_once)', 'a', 'b'), ('fge', 'a', 'c')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('~iand', ('fge(is_used_once)', 'a', 'c'), ('fge', 'b', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('iand', ('flt', 'a', '#b(is_a_number)'), ('flt', 'a', '#c(is_a_number)')) => ('flt', 'a', ('fmin', 'b', 'c'))
 *    ('iand', ('flt', '#a(is_a_number)', 'c'), ('flt', '#b(is_a_number)', 'c')) => ('flt', ('fmax', 'a', 'b'), 'c')
 *    ('iand', ('fge', 'a', '#b(is_a_number)'), ('fge', 'a', '#c(is_a_number)')) => ('fge', 'a', ('fmax', 'b', 'c'))
 *    ('iand', ('fge', '#a(is_a_number)', 'c'), ('fge', '#b(is_a_number)', 'c')) => ('fge', ('fmin', 'a', 'b'), 'c')
 *    ('ior', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imax', 'b', 'c'))
 *    ('ior', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imin', 'a', 'b'), 'c')
 *    ('ior', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imin', 'b', 'c'))
 *    ('ior', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imax', 'a', 'b'), 'c')
 *    ('ior', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umax', 'b', 'c'))
 *    ('ior', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umin', 'a', 'b'), 'c')
 *    ('ior', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umin', 'b', 'c'))
 *    ('ior', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('ilt(is_used_once)', 'a', 'b'), ('ilt', 'a', 'c')) => ('ilt', 'a', ('imin', 'b', 'c'))
 *    ('iand', ('ilt(is_used_once)', 'a', 'c'), ('ilt', 'b', 'c')) => ('ilt', ('imax', 'a', 'b'), 'c')
 *    ('iand', ('ige(is_used_once)', 'a', 'b'), ('ige', 'a', 'c')) => ('ige', 'a', ('imax', 'b', 'c'))
 *    ('iand', ('ige(is_used_once)', 'a', 'c'), ('ige', 'b', 'c')) => ('ige', ('imin', 'a', 'b'), 'c')
 *    ('iand', ('ult(is_used_once)', 'a', 'b'), ('ult', 'a', 'c')) => ('ult', 'a', ('umin', 'b', 'c'))
 *    ('iand', ('ult(is_used_once)', 'a', 'c'), ('ult', 'b', 'c')) => ('ult', ('umax', 'a', 'b'), 'c')
 *    ('iand', ('uge(is_used_once)', 'a', 'b'), ('uge', 'a', 'c')) => ('uge', 'a', ('umax', 'b', 'c'))
 *    ('iand', ('uge(is_used_once)', 'a', 'c'), ('uge', 'b', 'c')) => ('uge', ('umin', 'a', 'b'), 'c')
 *    ('iand', ('uge', 'a', 'b'), ('ult', 'a', 'b')) => False
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'c'), 'd'), ('flt', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'c'), 'd'), ('flt(is_used_once)', 'b', 'c')) => ('ior', ('flt', ('!fmin', 'a', 'b'), 'c'), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt(is_used_once)', 'a', 'b'), 'd'), ('flt', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('ior(is_used_once)', ('flt', 'a', 'b'), 'd'), ('flt(is_used_once)', 'a', 'c')) => ('ior', ('flt', 'a', ('!fmax', 'b', 'c')), 'd')
 *    ('ior', ('flt', 'a(is_a_number)', 'b(is_a_number)'), ('flt', 'b', 'a')) => ('fneu', 'a', 'b')
 *    ('umin', ('iand', 'a', '#b(is_pos_power_of_two)'), ('iand', 'c', 'b')) => ('iand', ('iand', 'a', 'b'), ('iand', 'c', 'b'))
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@16'), ('flt', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@16'), ('flt(is_used_once)', 'b@16', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@16'), ('fge', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@16'), ('fge(is_used_once)', 'b@16', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@16', 0.0), ('feq', 'b@16', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@16', 0.0), ('fneu', 'b@16', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@16', ('feq', 'a', 0.0), 1.0, ('i2f16', ('iadd', ('b2i16', ('flt', 0.0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0.0)))))) => ('i2f16', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('fmul', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')), ('i2f', ('iadd', ('b2i', ('flt', 0.0, 'a')), ('ineg', ('b2i', ('flt', 'a', 0.0)))))) => ('bcsel', ('!flt', 'a', 0.0), ('fneg', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b'))), ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@16'), ('b2f', 'c@16')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f16', ('f2i', 'a@16')) => ('ftrunc', 'a')
 *    ('~f2i16', ('i2f', 'a@16')) => a
 *    ('~f2i16', ('u2f', 'a@16')) => a
 *    ('~f2u16', ('i2f', 'a@16')) => a
 *    ('~f2u16', ('u2f', 'a@16')) => a
 *    ('fadd', ('b2f16', ('flt', 0.0, 'a@16')), ('fneg', ('b2f16', ('flt', 'a@16', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i16', ('flt', 0, 'a@16')), ('ineg', ('b2i16', ('flt', 'a@16', 0)))) => ('f2i16', ('fsign', 'a'))
 *    ('~f2f16', ('f2f', 'a')) => ('f2f16', 'a')
 *    ('~f2f16', ('u2f', 'a')) => ('u2f16', 'a')
 *    ('~f2f16', ('i2f', 'a')) => ('i2f16', 'a')
 *    ('~f2u16', ('f2f', 'a')) => ('f2u16', 'a')
 *    ('~f2i16', ('f2f', 'a')) => ('f2i16', 'a')
 *    ('i2f16', ('f2i', ('fsign', 'a@16'))) => ('fsign', 'a')
 *    ('~f2f16', ('f2f32', 'a@16')) => a
 *    ('f2u32', ('f2f32', 'a@16')) => ('f2u32', 'a')
 *    ('f2i32', ('f2f32', 'a@16')) => ('f2i32', 'a')
 *    ('f2f16', ('u2f32', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f32', 'a')) => ('i2f16', 'a')
 *    ('~f2f16', ('f2f64', 'a@16')) => a
 *    ('f2u64', ('f2f64', 'a@16')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@16')) => ('f2i64', 'a')
 *    ('f2f16', ('u2f64', 'a')) => ('u2f16', 'a')
 *    ('f2f16', ('i2f64', 'a')) => ('i2f16', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@32'), ('flt', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@32'), ('flt(is_used_once)', 'b@32', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@32'), ('fge', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@32'), ('fge(is_used_once)', 'b@32', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@32', 0.0), ('feq', 'b@32', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@32', 0.0), ('fneu', 'b@32', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@32', ('feq', 'a', 0.0), 1.0, ('i2f32', ('iadd', ('b2i32', ('flt', 0.0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0.0)))))) => ('i2f32', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('fmul', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')), ('i2f', ('iadd', ('b2i', ('flt', 0.0, 'a')), ('ineg', ('b2i', ('flt', 'a', 0.0)))))) => ('bcsel', ('!flt', 'a', 0.0), ('fneg', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b'))), ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@32'), ('b2f', 'c@32')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f32', ('f2i', 'a@32')) => ('ftrunc', 'a')
 *    ('~f2i32', ('i2f', 'a@32')) => a
 *    ('~f2i32', ('u2f', 'a@32')) => a
 *    ('~f2u32', ('i2f', 'a@32')) => a
 *    ('~f2u32', ('u2f', 'a@32')) => a
 *    ('fadd', ('b2f32', ('flt', 0.0, 'a@32')), ('fneg', ('b2f32', ('flt', 'a@32', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i32', ('flt', 0, 'a@32')), ('ineg', ('b2i32', ('flt', 'a@32', 0)))) => ('f2i32', ('fsign', 'a'))
 *    ('~f2f32', ('f2f', 'a')) => ('f2f32', 'a')
 *    ('~f2f32', ('u2f', 'a')) => ('u2f32', 'a')
 *    ('~f2f32', ('i2f', 'a')) => ('i2f32', 'a')
 *    ('~f2u32', ('f2f', 'a')) => ('f2u32', 'a')
 *    ('~f2i32', ('f2f', 'a')) => ('f2i32', 'a')
 *    ('i2f32', ('f2i', ('fsign', 'a@32'))) => ('fsign', 'a')
 *    ('~f2f32', ('f2f64', 'a@32')) => a
 *    ('f2u64', ('f2f64', 'a@32')) => ('f2u64', 'a')
 *    ('f2i64', ('f2f64', 'a@32')) => ('f2i64', 'a')
 *    ('f2f32', ('u2f64', 'a')) => ('u2f32', 'a')
 *    ('f2f32', ('i2f64', 'a')) => ('i2f32', 'a')
 *    ('ior', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('ior', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt(is_used_once)', 0.0, 'a@64'), ('flt', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('flt', 0.0, 'a@64'), ('flt(is_used_once)', 'b@64', 0.0)) => ('flt', 0.0, ('fmin', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge(is_used_once)', 0.0, 'a@64'), ('fge', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('~iand', ('fge', 0.0, 'a@64'), ('fge(is_used_once)', 'b@64', 0.0)) => ('fge', 0.0, ('fmax', 'a', ('fneg', 'b')))
 *    ('ior', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('ior', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('feq(is_used_once)', 'a@64', 0.0), ('feq', 'b@64', 0.0)) => ('feq', ('fadd', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('iand', ('fneu(is_used_once)', 'a@64', 0.0), ('fneu', 'b@64', 0.0)) => ('fneu', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0)
 *    ('bcsel@64', ('feq', 'a', 0.0), 1.0, ('i2f64', ('iadd', ('b2i64', ('flt', 0.0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0.0)))))) => ('i2f64', ('iadd', ('b2i32', ('!fge', 'a', 0.0)), ('ineg', ('b2i32', ('!flt', 'a', 0.0)))))
 *    ('fmul', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')), ('i2f', ('iadd', ('b2i', ('flt', 0.0, 'a')), ('ineg', ('b2i', ('flt', 'a', 0.0)))))) => ('bcsel', ('!flt', 'a', 0.0), ('fneg', ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b'))), ('fexp2', ('fmul', ('flog2', ('fabs', 'a')), 'b')))
 *    ('bcsel', 'a', ('b2f(is_used_once)', 'b@64'), ('b2f', 'c@64')) => ('b2f', ('bcsel', 'a', 'b', 'c'))
 *    ('~i2f64', ('f2i', 'a@64')) => ('ftrunc', 'a')
 *    ('~f2i64', ('i2f', 'a@64')) => a
 *    ('~f2i64', ('u2f', 'a@64')) => a
 *    ('~f2u64', ('i2f', 'a@64')) => a
 *    ('~f2u64', ('u2f', 'a@64')) => a
 *    ('fadd', ('b2f64', ('flt', 0.0, 'a@64')), ('fneg', ('b2f64', ('flt', 'a@64', 0.0)))) => ('fsign', 'a')
 *    ('iadd', ('b2i64', ('flt', 0, 'a@64')), ('ineg', ('b2i64', ('flt', 'a@64', 0)))) => ('f2i64', ('fsign', 'a'))
 *    ('~f2f64', ('f2f', 'a')) => ('f2f64', 'a')
 *    ('~f2f64', ('u2f', 'a')) => ('u2f64', 'a')
 *    ('~f2f64', ('i2f', 'a')) => ('i2f64', 'a')
 *    ('~f2u64', ('f2f', 'a')) => ('f2u64', 'a')
 *    ('~f2i64', ('f2f', 'a')) => ('f2i64', 'a')
 *    ('i2f64', ('f2i', ('fsign', 'a@64'))) => ('fsign', 'a')
 *    ('i2i1', ('i2i8', 'a@1')) => a
 *    ('u2u1', ('u2u8', 'a@1')) => a
 *    ('i2i1', ('i2i16', 'a@1')) => a
 *    ('u2u1', ('u2u16', 'a@1')) => a
 *    ('u2f16', ('u2u8', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i8', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u16', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@1')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@1')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@1')) => ('i2f16', 'a')
 *    ('i2i1', ('i2i32', 'a@1')) => a
 *    ('u2u1', ('u2u32', 'a@1')) => a
 *    ('u2f32', ('u2u8', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i8', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u16', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@1')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@1')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@1')) => ('i2f32', 'a')
 *    ('i2i1', ('i2i64', 'a@1')) => a
 *    ('u2u1', ('u2u64', 'a@1')) => a
 *    ('u2f64', ('u2u8', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i8', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u16', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@1')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@1')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@1')) => ('i2f64', 'a')
 *    ('i2i8', ('i2i16', 'a@8')) => a
 *    ('u2u8', ('u2u16', 'a@8')) => a
 *    ('u2f16', ('u2u16', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i16', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u32', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i32', 'a@8')) => ('i2f16', 'a')
 *    ('u2f16', ('u2u64', 'a@8')) => ('u2f16', 'a')
 *    ('i2f16', ('i2i64', 'a@8')) => ('i2f16', 'a')
 *    ('i2i8', ('i2i32', 'a@8')) => a
 *    ('u2u8', ('u2u32', 'a@8')) => a
 *    ('u2f32', ('u2u16', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i16', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u32', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@8')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@8')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@8')) => ('i2f32', 'a')
 *    ('i2i8', ('i2i64', 'a@8')) => a
 *    ('u2u8', ('u2u64', 'a@8')) => a
 *    ('u2f64', ('u2u16', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i16', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u32', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@8')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@8')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@8')) => ('i2f64', 'a')
 *    ('i2i16', ('i2i32', 'a@16')) => a
 *    ('u2u16', ('u2u32', 'a@16')) => a
 *    ('u2f32', ('u2u32', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i32', 'a@16')) => ('i2f32', 'a')
 *    ('u2f32', ('u2u64', 'a@16')) => ('u2f32', 'a')
 *    ('i2f32', ('i2i64', 'a@16')) => ('i2f32', 'a')
 *    ('i2i16', ('i2i64', 'a@16')) => a
 *    ('u2u16', ('u2u64', 'a@16')) => a
 *    ('u2f64', ('u2u32', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i32', 'a@16')) => ('i2f64', 'a')
 *    ('u2f64', ('u2u64', 'a@16')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@16')) => ('i2f64', 'a')
 *    ('i2i32', ('i2i64', 'a@32')) => a
 *    ('u2u32', ('u2u64', 'a@32')) => a
 *    ('u2f64', ('u2u64', 'a@32')) => ('u2f64', 'a')
 *    ('i2f64', ('i2i64', 'a@32')) => ('i2f64', 'a')
 *    ('f2fmp', ('u2f32', 'a@32')) => ('u2fmp', 'a')
 *    ('f2fmp', ('i2f32', 'a@32')) => ('i2fmp', 'a')
 *    ('f2u16', ('f2fmp', 'a@32')) => ('f2u16', 'a')
 *    ('f2i16', ('f2fmp', 'a@32')) => ('f2i16', 'a')
 *    ('i2imp', ('f2u32', 'a@32')) => ('f2ump', 'a')
 *    ('i2imp', ('f2i32', 'a@32')) => ('f2imp', 'a')
 *    ('u2f16', ('i2imp', 'a@32')) => ('u2f16', 'a')
 *    ('i2f16', ('i2imp', 'a@32')) => ('i2f16', 'a')
 *    ('iand', ('u2u16', ('u2u8', 'a@16')), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u16', ('u2u8(is_used_once)', ('iand', 'a@16', '#b'))) => ('iand', 'a', ('iand', 'b', 255))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('u2u8', ('iand', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('iand', 'a', 'b'))
 *    ('iand', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('iand', 'a', 'c'), 'b')
 *    ('iand', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('iand', 'a', 'c'), 'b')
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('u2u8', ('ior', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ior', 'a', 'b'))
 *    ('ior', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ior', 'a', 'c'), 'b')
 *    ('ior', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ior', 'a', 'c'), 'b')
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@16')), ('u2u16', ('u2u8', 'b@16')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('u2u8', ('ixor', ('u2u16', ('u2u8', 'a@32')), ('u2u16', ('u2u8', 'b@32')))) => ('u2u8', ('ixor', 'a', 'b'))
 *    ('ixor', ('extract_i8', 'a', '#b'), ('extract_i8', 'c', 'b')) => ('extract_i8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u8', 'a', '#b'), ('extract_u8', 'c', 'b')) => ('extract_u8', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_i16', 'a', '#b'), ('extract_i16', 'c', 'b')) => ('extract_i16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('extract_u16', 'a', '#b'), ('extract_u16', 'c', 'b')) => ('extract_u16', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ushr(is_used_once)', 'a', '#b'), ('ushr', 'c', 'b')) => ('ushr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishr(is_used_once)', 'a', '#b'), ('ishr', 'c', 'b')) => ('ishr', ('ixor', 'a', 'c'), 'b')
 *    ('ixor', ('ishl(is_used_once)', 'a', '#b'), ('ishl', 'c', 'b')) => ('ishl', ('ixor', 'a', 'c'), 'b')
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@8', 0), ('ieq', 'b@8', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@8', 0), ('ine', 'b@8', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@8', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@8', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@8', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@8', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@8', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@8', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@8', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@8', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i8', 'a@8')) => a
 *    ('ishl', 'a@8', ('iand', 7, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@8', ('iand', 7, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@8', ('iand', 7, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 1), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('ushr', 'a@8', ('ishl(is_used_once)', ('iand', 'b', 3), 1)) => ('ushr', 'a', ('ishl', 'b', 1))
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@16', 0), ('ieq', 'b@16', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@16', 0), ('ine', 'b@16', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@16', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@16', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@16', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@16', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@16', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@16', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@16', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@16', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i16', 'a@16')) => a
 *    ('ishl', 'a@16', ('iand', 15, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@16', ('iand', 15, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@16', ('iand', 15, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 1), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('ushr', 'a@16', ('ishl(is_used_once)', ('iand', 'b', 3), 2)) => ('ushr', 'a', ('ishl', 'b', 2))
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@32', 0), ('ieq', 'b@32', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@32', 0), ('ine', 'b@32', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@32', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@32', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@32', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@32', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@32', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@32', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@32', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@32', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i32', 'a@32')) => a
 *    ('ishl', 'a@32', ('iand', 31, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@32', ('iand', 31, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@32', ('iand', 31, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 1), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('ushr', 'a@32', ('ishl(is_used_once)', ('iand', 'b', 3), 3)) => ('ushr', 'a', ('ishl', 'b', 3))
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('ior', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('ior', 'a', 'b'), 0)
 *    ('iand', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umax', 'a', 'b'), 0)
 *    ('ior', ('ieq', 'a@64', 0), ('ieq', 'b@64', 0)) => ('ieq', ('umin', 'a', 'b'), 0)
 *    ('iand', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umin', 'a', 'b'), 0)
 *    ('ior', ('ine', 'a@64', 0), ('ine', 'b@64', 0)) => ('ine', ('umax', 'a', 'b'), 0)
 *    ('bcsel', ('ult', 'b@64', 'a'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('ult', 'a@64', 'b'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('uge', 'a@64', 'b'), 'b', 'a') => ('umin', 'a', 'b')
 *    ('bcsel', ('uge', 'b@64', 'a'), 'b', 'a') => ('umax', 'a', 'b')
 *    ('bcsel', ('ilt', 'b@64', 'a'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ilt', 'a@64', 'b'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('bcsel', ('ige', 'a@64', 'b'), 'b', 'a') => ('imin', 'a', 'b')
 *    ('bcsel', ('ige', 'b@64', 'a'), 'b', 'a') => ('imax', 'a', 'b')
 *    ('ineg', ('b2i64', 'a@64')) => a
 *    ('ishl', 'a@64', ('iand', 63, 'b')) => ('ishl', 'a', 'b')
 *    ('ishr', 'a@64', ('iand', 63, 'b')) => ('ishr', 'a', 'b')
 *    ('ushr', 'a@64', ('iand', 63, 'b')) => ('ushr', 'a', 'b')
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 1), 5)) => ('ushr', 'a', ('ishl', 'b', 5))
 *    ('ushr', 'a@64', ('ishl(is_used_once)', ('iand', 'b', 3), 4)) => ('ushr', 'a', ('ishl', 'b', 4))
 *    ('ior', ('ieq', 'a', 0), ('ieq', 'a', 1)) => ('uge', 1, 'a')
 *    ('ior', ('uge', 1, 'a'), ('ieq', 'a', 2)) => ('uge', 2, 'a')
 *    ('ior', ('uge', 2, 'a'), ('ieq', 'a', 3)) => ('uge', 3, 'a')
 *    ('ior', ('ieq', 'a', 0), ('ior', ('ieq', 'a', 1), 'b')) => ('ior', ('uge', 1, 'a'), 'b')
 *    ('ior', ('uge', 1, 'a'), ('ior', ('ieq', 'a', 2), 'b')) => ('ior', ('uge', 2, 'a'), 'b')
 *    ('ior', ('uge', 2, 'a'), ('ior', ('ieq', 'a', 3), 'b')) => ('ior', ('uge', 3, 'a'), 'b')
 *    ('ior', 'a', ('ieq', 'a', False)) => True
 *    ('uge', 'a', 1) => ('ine', 'a', 0)
 *    ('ult', 'a', 1) => ('ieq', 'a', 0)
 *    ('uge', 0, 'a') => ('ieq', 'a', 0)
 *    ('ult', 0, 'a') => ('ine', 'a', 0)
 *    ('b2i', ('ine', 'a@1', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('ishl', ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)), '#c') => ('bcsel', ('ige', ('iand', 'c', 31), ('find_lsb', 'b')), ('ishl', ('iand', 'a', 'b'), ('iadd', ('iand', 'c', 31), ('ineg', ('find_lsb', 'b')))), ('ushr', ('iand', 'a', 'b'), ('iadd', ('ineg', ('iand', 'c', 31)), ('find_lsb', 'b'))))
 *    ('b2i32', ('ine', ('iand', 'a@32', '#b(is_pos_power_of_two)'), 0)) => ('ushr', ('iand', 'a', 'b'), ('find_lsb', 'b'))
 *    ('ior', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('ior', ('b2i', 'a'), 'b'), 1)
 *    ('iand', ('b2i', 'a'), ('iand', 'b', 1)) => ('iand', ('b2i', 'a'), 'b')
 *    ('iand', ('inot', ('iand', ('ior', ('ieq', 'a', 0), 'b'), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', 'b', 'c')), ('ilt', 'a', 0))
 *    ('iand', ('inot', ('iand', ('ieq', ('umin', 'a', 'b'), 0), 'c')), ('ilt', 'a', 0)) => ('iand', ('inot', ('iand', ('ieq', 'b', 0), 'c')), ('ilt', 'a', 0))
 *    ('flt', 'a', ('fmax', 'b', 'a')) => ('flt', 'a', 'b')
 *    ('flt', ('fmin', 'a', 'b'), 'a') => ('flt', 'b', 'a')
 *    ('~fge', 'a', ('fmin', 'b', 'a')) => True
 *    ('~fge', ('fmax', 'a', 'b'), 'a') => True
 *    ('flt', 'a', ('fmin', 'b', 'a')) => False
 *    ('flt', ('fmax', 'a', 'b'), 'a') => False
 *    ('~fge', 'a', ('fmax', 'b', 'a')) => ('fge', 'a', 'b')
 *    ('~fge', ('fmin', 'a', 'b'), 'a') => ('fge', 'b', 'a')
 *    ('ilt', 'a', ('imax', 'b', 'a')) => ('ilt', 'a', 'b')
 *    ('ilt', ('imin', 'a', 'b'), 'a') => ('ilt', 'b', 'a')
 *    ('ige', 'a', ('imin', 'b', 'a')) => True
 *    ('ige', ('imax', 'a', 'b'), 'a') => True
 *    ('ult', 'a', ('umax', 'b', 'a')) => ('ult', 'a', 'b')
 *    ('ult', ('umin', 'a', 'b'), 'a') => ('ult', 'b', 'a')
 *    ('uge', 'a', ('umin', 'b', 'a')) => True
 *    ('uge', ('umax', 'a', 'b'), 'a') => True
 *    ('ilt', 'a', ('imin', 'b', 'a')) => False
 *    ('ilt', ('imax', 'a', 'b'), 'a') => False
 *    ('ige', 'a', ('imax', 'b', 'a')) => ('ige', 'a', 'b')
 *    ('ige', ('imin', 'a', 'b'), 'a') => ('ige', 'b', 'a')
 *    ('ult', 'a', ('umin', 'b', 'a')) => False
 *    ('ult', ('umax', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('umax', 'b', 'a')) => ('uge', 'a', 'b')
 *    ('uge', ('umin', 'a', 'b'), 'a') => ('uge', 'b', 'a')
 *    ('ult', 'a', ('iand', 'b', 'a')) => False
 *    ('ult', ('ior', 'a', 'b'), 'a') => False
 *    ('uge', 'a', ('iand', 'b', 'a')) => True
 *    ('uge', ('ior', 'a', 'b'), 'a') => True
 *    ('ilt', '#a', ('imax', '#b', 'c')) => ('ior', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imin', '#a', 'b'), '#c') => ('ior', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imin', '#b', 'c')) => ('ior', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imax', '#a', 'b'), '#c') => ('ior', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umax', '#b', 'c')) => ('ior', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umin', '#a', 'b'), '#c') => ('ior', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umin', '#b', 'c')) => ('ior', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umax', '#a', 'b'), '#c') => ('ior', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ilt', '#a', ('imin', '#b', 'c')) => ('iand', ('ilt', 'a', 'b'), ('ilt', 'a', 'c'))
 *    ('ilt', ('imax', '#a', 'b'), '#c') => ('iand', ('ilt', 'a', 'c'), ('ilt', 'b', 'c'))
 *    ('ige', '#a', ('imax', '#b', 'c')) => ('iand', ('ige', 'a', 'b'), ('ige', 'a', 'c'))
 *    ('ige', ('imin', '#a', 'b'), '#c') => ('iand', ('ige', 'a', 'c'), ('ige', 'b', 'c'))
 *    ('ult', '#a', ('umin', '#b', 'c')) => ('iand', ('ult', 'a', 'b'), ('ult', 'a', 'c'))
 *    ('ult', ('umax', '#a', 'b'), '#c') => ('iand', ('ult', 'a', 'c'), ('ult', 'b', 'c'))
 *    ('uge', '#a', ('umax', '#b', 'c')) => ('iand', ('uge', 'a', 'b'), ('uge', 'a', 'c'))
 *    ('uge', ('umin', '#a', 'b'), '#c') => ('iand', ('uge', 'a', 'c'), ('uge', 'b', 'c'))
 *    ('ieq', ('umin', '#a', 'b'), 0) => ('ior', ('ieq', 'a', 0), ('ieq', 'b', 0))
 *    ('ine', ('umax', '#a', 'b'), 0) => ('ior', ('ine', 'a', 0), ('ine', 'b', 0))
 *    ('ieq', ('umax', '#a', 'b'), 0) => ('iand', ('ieq', 'a', 0), ('ieq', 'b', 0))
 *    ('ine', ('umin', '#a', 'b'), 0) => ('iand', ('ine', 'a', 0), ('ine', 'b', 0))
 *    ('bcsel', ('ilt', 'a', 0), ('ineg', ('ishr', 'a', 'b')), ('ishr', 'a', 'b')) => ('iabs', ('ishr', 'a', 'b'))
 *    ('iabs', ('ishr', ('iabs', 'a'), 'b')) => ('ushr', ('iabs', 'a'), 'b')
 *    ('iabs', ('ushr', ('iabs', 'a'), 'b')) => ('ushr', ('iabs', 'a'), 'b')
 *    ('fabs', ('slt', 'a', 'b')) => ('slt', 'a', 'b')
 *    ('fabs', ('sge', 'a', 'b')) => ('sge', 'a', 'b')
 *    ('fabs', ('seq', 'a', 'b')) => ('seq', 'a', 'b')
 *    ('fabs', ('sne', 'a', 'b')) => ('sne', 'a', 'b')
 *    ('slt', 'a', 'b') => ('b2f', ('flt', 'a', 'b'))
 *    ('sge', 'a', 'b') => ('b2f', ('fge', 'a', 'b'))
 *    ('seq', 'a', 'b') => ('b2f', ('feq', 'a', 'b'))
 *    ('sne', 'a', 'b') => ('b2f', ('fneu', 'a', 'b'))
 *    ('seq', ('seq', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('seq', 'a', 'b'), 0.0) => ('sne', 'a', 'b')
 *    ('seq', ('sne', 'a', 'b'), 0.0) => ('seq', 'a', 'b')
 *    ('seq', ('slt', 'a', 'b'), 0.0) => ('sge', 'a', 'b')
 *    ('seq', ('sge', 'a', 'b'), 0.0) => ('slt', 'a', 'b')
 *    ('sne', ('seq', 'a', 'b'), 1.0) => ('sne', 'a', 'b')
 *    ('sne', ('sne', 'a', 'b'), 1.0) => ('seq', 'a', 'b')
 *    ('sne', ('slt', 'a', 'b'), 1.0) => ('sge', 'a', 'b')
 *    ('sne', ('sge', 'a', 'b'), 1.0) => ('slt', 'a', 'b')
 *    ('fall_equal2', 'a', 'b') => ('fmin', ('seq', 'a.x', 'b.x'), ('seq', 'a.y', 'b.y'))
 *    ('fall_equal3', 'a', 'b') => ('seq', ('fany_nequal3', 'a', 'b'), 0.0)
 *    ('fall_equal4', 'a', 'b') => ('seq', ('fany_nequal4', 'a', 'b'), 0.0)
 *    ('fall_equal8', 'a', 'b') => ('seq', ('fany_nequal8', 'a', 'b'), 0.0)
 *    ('fall_equal16', 'a', 'b') => ('seq', ('fany_nequal16', 'a', 'b'), 0.0)
 *    ('fany_nequal2', 'a', 'b') => ('fmax', ('sne', 'a.x', 'b.x'), ('sne', 'a.y', 'b.y'))
 *    ('fany_nequal3', 'a', 'b') => ('fsat', ('fdot3', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal4', 'a', 'b') => ('fsat', ('fdot4', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal8', 'a', 'b') => ('fsat', ('fdot8', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('fany_nequal16', 'a', 'b') => ('fsat', ('fdot16', ('sne', 'a', 'b'), ('sne', 'a', 'b')))
 *    ('f2bf', 'a') => ('bcsel', ('!fneu', 'a', 'a'), -1, ('unpack_32_2x16_split_y', 'a'))
 *    ('bf2f', 'a') => ('pack_32_2x16', ('vec2', 0, 'a'))
 *    ('ball_iequal2', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y'))
 *    ('ball_iequal3', 'a', 'b') => ('iand', ('ieq', 'a.x', 'b.x'), ('iand', ('ieq', 'a.y', 'b.y'), ('ieq', 'a.z', 'b.z')))
 *    ('ball_iequal4', 'a', 'b') => ('iand', ('iand', ('ieq', 'a.x', 'b.x'), ('ieq', 'a.y', 'b.y')), ('iand', ('ieq', 'a.z', 'b.z'), ('ieq', 'a.w', 'b.w')))
 *    ('ball_iequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h'))))
 *    ('ball_iequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('ieq', 'a.a', 'b.a'), ('ieq', 'a.b', 'b.b')), ('iand', ('ieq', 'a.c', 'b.c'), ('ieq', 'a.d', 'b.d'))), ('iand', ('iand', ('ieq', 'a.e', 'b.e'), ('ieq', 'a.f', 'b.f')), ('iand', ('ieq', 'a.g', 'b.g'), ('ieq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('ieq', 'a.i', 'b.i'), ('ieq', 'a.j', 'b.j')), ('iand', ('ieq', 'a.k', 'b.k'), ('ieq', 'a.l', 'b.l'))), ('iand', ('iand', ('ieq', 'a.m', 'b.m'), ('ieq', 'a.n', 'b.n')), ('iand', ('ieq', 'a.o', 'b.o'), ('ieq', 'a.p', 'b.p')))))
 *    ('ball_fequal2', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y'))
 *    ('ball_fequal3', 'a', 'b') => ('iand', ('feq', 'a.x', 'b.x'), ('iand', ('feq', 'a.y', 'b.y'), ('feq', 'a.z', 'b.z')))
 *    ('ball_fequal4', 'a', 'b') => ('iand', ('iand', ('feq', 'a.x', 'b.x'), ('feq', 'a.y', 'b.y')), ('iand', ('feq', 'a.z', 'b.z'), ('feq', 'a.w', 'b.w')))
 *    ('ball_fequal8', 'a', 'b') => ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h'))))
 *    ('ball_fequal16', 'a', 'b') => ('iand', ('iand', ('iand', ('iand', ('feq', 'a.a', 'b.a'), ('feq', 'a.b', 'b.b')), ('iand', ('feq', 'a.c', 'b.c'), ('feq', 'a.d', 'b.d'))), ('iand', ('iand', ('feq', 'a.e', 'b.e'), ('feq', 'a.f', 'b.f')), ('iand', ('feq', 'a.g', 'b.g'), ('feq', 'a.h', 'b.h')))), ('iand', ('iand', ('iand', ('feq', 'a.i', 'b.i'), ('feq', 'a.j', 'b.j')), ('iand', ('feq', 'a.k', 'b.k'), ('feq', 'a.l', 'b.l'))), ('iand', ('iand', ('feq', 'a.m', 'b.m'), ('feq', 'a.n', 'b.n')), ('iand', ('feq', 'a.o', 'b.o'), ('feq', 'a.p', 'b.p')))))
 *    ('bany_inequal2', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y'))
 *    ('bany_inequal3', 'a', 'b') => ('ior', ('ine', 'a.x', 'b.x'), ('ior', ('ine', 'a.y', 'b.y'), ('ine', 'a.z', 'b.z')))
 *    ('bany_inequal4', 'a', 'b') => ('ior', ('ior', ('ine', 'a.x', 'b.x'), ('ine', 'a.y', 'b.y')), ('ior', ('ine', 'a.z', 'b.z'), ('ine', 'a.w', 'b.w')))
 *    ('bany_inequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h'))))
 *    ('bany_inequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('ine', 'a.a', 'b.a'), ('ine', 'a.b', 'b.b')), ('ior', ('ine', 'a.c', 'b.c'), ('ine', 'a.d', 'b.d'))), ('ior', ('ior', ('ine', 'a.e', 'b.e'), ('ine', 'a.f', 'b.f')), ('ior', ('ine', 'a.g', 'b.g'), ('ine', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('ine', 'a.i', 'b.i'), ('ine', 'a.j', 'b.j')), ('ior', ('ine', 'a.k', 'b.k'), ('ine', 'a.l', 'b.l'))), ('ior', ('ior', ('ine', 'a.m', 'b.m'), ('ine', 'a.n', 'b.n')), ('ior', ('ine', 'a.o', 'b.o'), ('ine', 'a.p', 'b.p')))))
 *    ('bany_fnequal2', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y'))
 *    ('bany_fnequal3', 'a', 'b') => ('ior', ('fneu', 'a.x', 'b.x'), ('ior', ('fneu', 'a.y', 'b.y'), ('fneu', 'a.z', 'b.z')))
 *    ('bany_fnequal4', 'a', 'b') => ('ior', ('ior', ('fneu', 'a.x', 'b.x'), ('fneu', 'a.y', 'b.y')), ('ior', ('fneu', 'a.z', 'b.z'), ('fneu', 'a.w', 'b.w')))
 *    ('bany_fnequal8', 'a', 'b') => ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h'))))
 *    ('bany_fnequal16', 'a', 'b') => ('ior', ('ior', ('ior', ('ior', ('fneu', 'a.a', 'b.a'), ('fneu', 'a.b', 'b.b')), ('ior', ('fneu', 'a.c', 'b.c'), ('fneu', 'a.d', 'b.d'))), ('ior', ('ior', ('fneu', 'a.e', 'b.e'), ('fneu', 'a.f', 'b.f')), ('ior', ('fneu', 'a.g', 'b.g'), ('fneu', 'a.h', 'b.h')))), ('ior', ('ior', ('ior', ('fneu', 'a.i', 'b.i'), ('fneu', 'a.j', 'b.j')), ('ior', ('fneu', 'a.k', 'b.k'), ('fneu', 'a.l', 'b.l'))), ('ior', ('ior', ('fneu', 'a.m', 'b.m'), ('fneu', 'a.n', 'b.n')), ('ior', ('fneu', 'a.o', 'b.o'), ('fneu', 'a.p', 'b.p')))))
 *    ('bcsel@8', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel@8', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel@8', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel@8', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel@16', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel@16', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel@16', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel@32', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel@32', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1, 0) => ('ineg', ('b2i', 'a@1'))
 *    ('bcsel@64', 'a', 0, -1) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1, 0) => ('b2i', 'a@1')
 *    ('bcsel@64', 'a', 0, 1) => ('b2i', ('inot', 'a'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), 'b') => ('bcsel', 'a', 'b', 0)
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('ige', ('ineg', ('b2i', 'a@1')), 0) => ('inot', 'a')
 *    ('ilt', ('ineg', ('b2i', 'a@1')), 0) => a
 *    ('bcsel', 'a', ('b2i', 'b@1'), ('b2i', 'c@1')) => ('b2i', ('bcsel', 'a', 'b', 'c'))
 *    ('bcsel', 'a', ('b2i', 'b@1'), 0) => ('b2i', ('bcsel', 'a', 'b', False))
 *    ('bcsel', 'a', ('b2i', 'b@1'), 1) => ('b2i', ('bcsel', 'a', 'b', True))
 *    ('bcsel', 'a', 0, ('b2i', 'b@1')) => ('b2i', ('bcsel', 'a', False, 'b'))
 *    ('bcsel', 'a', 1, ('b2i', 'b@1')) => ('b2i', ('bcsel', 'a', True, 'b'))
 *    ('bcsel', 'a', ('ineg', ('b2i', 'b@1')), ('ineg', ('b2i', 'c@1'))) => ('ineg', ('b2i', ('bcsel', 'a', 'b', 'c')))
 *    ('bcsel', 'a', ('ineg', ('b2i', 'b@1')), 0) => ('ineg', ('b2i', ('bcsel', 'a', 'b', False)))
 *    ('bcsel', 'a', ('ineg', ('b2i', 'b@1')), -1) => ('ineg', ('b2i', ('bcsel', 'a', 'b', True)))
 *    ('bcsel', 'a', 0, ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('bcsel', 'a', False, 'b')))
 *    ('bcsel', 'a', -1, ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('bcsel', 'a', True, 'b')))
 *    ('inot', ('ineg', ('b2i', 'a'))) => ('ineg', ('b2i', ('inot', 'a')))
 *    ('ishl', ('ineg', ('b2i', 'a')), '#b') => ('iand', ('ishl', -1, 'b'), ('ineg', ('b2i', 'a')))
 *    ('ushr', ('ineg', ('b2i', 'a')), '#b') => ('iand', ('ushr', -1, 'b'), ('ineg', ('b2i', 'a')))
 *    ('ine', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))) => ('ior', 'a', 'b')
 *    ('ieq', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('ior', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('iand', ('ior', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))), 1) => ('b2i', ('ior', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('iand', ('iand', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))), 1) => ('b2i', ('iand', 'a', 'b'))
 *    ('ixor', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ixor', 'a', 'b'))
 *    ('ixor', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ixor', 'a', 'b')))
 *    ('iand', ('ixor', ('b2i', 'a@1'), ('ineg', ('b2i', 'b@1'))), 1) => ('b2i', ('ixor', 'a', 'b'))
 *    ('feq', ('seq', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('seq', 'a', 'b'), 0.0) => ('fneu', 'a', 'b')
 *    ('feq', ('sne', 'a', 'b'), 0.0) => ('feq', 'a', 'b')
 *    ('feq', ('slt', 'a', 'b'), 0.0) => ('fge', 'a', 'b')
 *    ('feq', ('sge', 'a', 'b'), 0.0) => ('flt', 'a', 'b')
 *    ('fneu', ('seq', 'a', 'b'), 1.0) => ('fneu', 'a', 'b')
 *    ('fneu', ('sne', 'a', 'b'), 1.0) => ('feq', 'a', 'b')
 *    ('fneu', ('slt', 'a', 'b'), 1.0) => ('fge', 'a', 'b')
 *    ('fneu', ('sge', 'a', 'b'), 1.0) => ('flt', 'a', 'b')
 *    ('fneu', ('fneg', 'a'), 'a') => ('fneu', 'a', 0.0)
 *    ('feq', ('fneg', 'a'), 'a') => ('feq', 'a', 0.0)
 *    ('imul', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('ior', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('fmul', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b'))
 *    ('ffma', ('b2f', 'a@1'), ('b2f', 'b@1'), 'c') => ('fadd', ('b2f', ('iand', 'a', 'b')), 'c')
 *    ('fmul', ('b2f', ('fneu', 'a', 0)), 'a') => ('fmul', 1.0, 'a')
 *    ('ffma', ('b2f', ('fneu', 'a', 0)), 'a', 'b') => ('fadd', 'a', 'b')
 *    ('fsat', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('b2f', ('ior', 'a', 'b'))
 *    ('iand', 'a@bool16', 1.0) => ('b2f', 'a')
 *    ('iand', 'a@bool32', 1.0) => ('b2f', 'a')
 *    ('flt', ('fneg', ('b2f', 'a@1')), 0) => a
 *    ('ilt', 'a', 'a') => False
 *    ('ige', 'a', 'a') => True
 *    ('ieq', 'a', 'a') => True
 *    ('ine', 'a', 'a') => False
 *    ('ult', 'a', 'a') => False
 *    ('uge', 'a', 'a') => True
 *    ('flt', 'a', 'a') => False
 *    ('fge', 'a(is_a_number)', 'a') => True
 *    ('feq', 'a(is_a_number)', 'a') => True
 *    ('fneu', 'a(is_a_number)', 'a') => False
 *    ('iand', 'a', 'a') => a
 *    ('iand', 'a', 0) => 0
 *    ('iand', 'a', -1) => a
 *    ('iand', 'a', ('inot', 'a')) => 0
 *    ('ior', 'a', 'a') => a
 *    ('ior', 'a', 0) => a
 *    ('ior', 'a', -1) => -1
 *    ('ior', 'a', ('inot', 'a')) => -1
 *    ('ixor', 'a', 'a') => 0
 *    ('ixor', 'a', 0) => a
 *    ('ixor', 'a', ('ixor', 'a', 'b')) => b
 *    ('ixor', 'a', -1) => ('inot', 'a')
 *    ('inot', ('inot', 'a')) => a
 *    ('ior', ('iand', 'a', 'b'), 'b') => b
 *    ('ior', ('ior', 'a', 'b'), 'b') => ('ior', 'a', 'b')
 *    ('iand', ('ior', 'a', 'b'), 'b') => b
 *    ('iand', ('iand', 'a', 'b'), 'b') => ('iand', 'a', 'b')
 *    ('iand', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('iand', 'b', 'c'))
 *    ('iand@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', 0, ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), 0)
 *    ('iand@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('iand', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('iand@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('iand', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('ior@64', 'a', '#b(is_lower_half_negative_one)') => ('pack_64_2x32_split', -1, ('ior', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ior@64', 'a', '#b(is_upper_half_negative_one)') => ('pack_64_2x32_split', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), -1)
 *    ('ixor@64', 'a', '#b(is_lower_half_zero)') => ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('ixor', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')))
 *    ('ixor@64', 'a', '#b(is_upper_half_zero)') => ('pack_64_2x32_split', ('ixor', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_x', 'b')), ('unpack_64_2x32_split_y', 'a'))
 *    ('iand', ('inot', 'a'), ('inot', 'b')) => ('inot', ('ior', 'a', 'b'))
 *    ('ior', ('inot', 'a'), ('inot', 'b')) => ('inot', ('iand', 'a', 'b'))
 *    ('ishl', 0, 'a') => 0
 *    ('ishl', 'a', 0) => a
 *    ('ishr', 0, 'a') => 0
 *    ('ishr', -1, 'a') => -1
 *    ('ishr', 'a', 0) => a
 *    ('ushr', 0, 'a') => 0
 *    ('ushr', 'a', 0) => a
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ushr', 'a', 'b')) => ('ushr', 'a', 'b')
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ishr', 'a', 'b')) => ('ishr', 'a', 'b')
 *    ('bcsel', ('ieq', 'b', 0), 'a', ('ishl', 'a', 'b')) => ('ishl', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ushr', 'a', 'b'), 'a') => ('ushr', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ishr', 'a', 'b'), 'a') => ('ishr', 'a', 'b')
 *    ('bcsel', ('ine', 'b', 0), ('ishl', 'a', 'b'), 'a') => ('ishl', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@16', 'a', 'b'), ('ushr@16', 'a', ('isub', 16, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('urol', 'a', 'b')
 *    ('ior', ('ishl@32', 'a', 'b'), ('ushr@32', 'a', ('isub', 32, 'b'))) => ('urol', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('iadd', 16, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@16', 'a', 'b'), ('ishl@16', 'a', ('isub', 16, 'b'))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('iadd', 32, ('ineg', 'b')))) => ('uror', 'a', 'b')
 *    ('ior', ('ushr@32', 'a', 'b'), ('ishl@32', 'a', ('isub', 32, 'b'))) => ('uror', 'a', 'b')
 *    ('urol@8', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 8, 'b')))
 *    ('urol@16', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 16, 'b')))
 *    ('urol@32', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 32, 'b')))
 *    ('urol@64', 'a', 'b') => ('ior', ('ishl', 'a', 'b'), ('ushr', 'a', ('isub', 64, 'b')))
 *    ('uror@8', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 8, 'b')))
 *    ('uror@16', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 16, 'b')))
 *    ('uror@32', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 32, 'b')))
 *    ('uror@64', 'a', 'b') => ('ior', ('ushr', 'a', 'b'), ('ishl', 'a', ('isub', 64, 'b')))
 *    ('bitfield_select', 4278190080, ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('bitfield_select', 4294901760, ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('bitfield_select', 4294967040, ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('ior', ('ishl', 'b@32', 24), ('ushr', 'a', 8)) => ('shfr', 'b', 'a', 8)
 *    ('ior', ('ishl', 'b@32', 16), ('extract_u16', 'a', 1)) => ('shfr', 'b', 'a', 16)
 *    ('ior', ('ishl', 'b@32', 8), ('extract_u8', 'a', 3)) => ('shfr', 'b', 'a', 24)
 *    ('bcsel', ('ieq', 'c', 0), 'a', ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c'))) => ('shfr', 'b', 'a', 'c')
 *    ('bcsel', ('ine', 'c', 0), ('ior', ('ishl', 'b@32', ('iadd', 32, ('ineg', 'c'))), ('ushr@32', 'a', 'c')), 'a') => ('shfr', 'b', 'a', 'c')
 *    ('ior', ('ishl', 'a@32', ('iadd', 32, ('ineg', 'b'))), ('ushr@32', 'a', 'b')) => ('shfr', 'a', 'a', 'b')
 *    ('bfi', 4294967295, 'a', 'b') => a
 *    ('bfi', 0, 'a', 'b') => b
 *    ('bfi', ('ineg', ('b2i', 'a@1')), 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('bfi', 'a', 0, 'b') => ('iand', ('inot', 'a'), 'b')
 *    ('bfi', '#a(is_odd)', 'b', 'b') => b
 *    ('bfi', '#a(is_odd)', 'a', 'b') => ('ior', 'a', 'b')
 *    ('bfi', '#a(is_odd)', 'b', 0) => ('iand', 'a', 'b')
 *    ('bfi', '#a(is_odd)', 'b', 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('u2f32', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), ('iand', 'b', 1), ('u2f', 'a'))
 *    ('u2f', ('bfi', '#a(is_pos_power_of_two)', 'b', 0)) => ('bcsel', ('ieq', ('iand', 'b', 1), 0), 0, ('u2f', 'a'))
 *    ('~fexp2', ('flog2', 'a')) => a
 *    ('~flog2', ('fexp2', 'a')) => a
 *    ('fpow@32', 'a', 'b') => ('fexp2', ('fmulz', ('flog2', 'a'), 'b'))
 *    ('fpow', 'a', 'b') => ('fexp2', ('fmul', ('flog2', 'a'), 'b'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 'b')) => ('fpow', 'a', 'b')
 *    ('~fexp2', ('fadd', ('fmul', ('flog2', 'a'), 'b'), ('fmul', ('flog2', 'c'), 'd'))) => ('~fmul', ('fpow', 'a', 'b'), ('fpow', 'c', 'd'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 0.5)) => ('fsqrt', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 2.0)) => ('fmul', 'a', 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 3.0)) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 4.0)) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 5.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), 'a')
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 6.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', 'a', 'a'))
 *    ('~fexp2', ('fmul', ('flog2', 'a'), 8.0)) => ('fmul', ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')), ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a')))
 *    ('~fpow', 'a', 1.0) => a
 *    ('~fpow', 'a', 2.0) => ('fmul', 'a', 'a')
 *    ('~fpow', 'a', 3.0) => ('fmul', ('fmul', 'a', 'a'), 'a')
 *    ('~fpow', 'a', 4.0) => ('fmul', ('fmul', 'a', 'a'), ('fmul', 'a', 'a'))
 *    ('~fpow', 2.0, 'a') => ('fexp2', 'a')
 *    ('~fpow', ('fpow', 'a', 2.2), 0.454545) => a
 *    ('~fpow', ('fabs', ('fpow', 'a', 2.2)), 0.454545) => ('fabs', 'a')
 *    ('~fsqrt', ('fexp2', 'a')) => ('fexp2', ('fmul', 0.5, 'a'))
 *    ('~frcp', ('fexp2', 'a')) => ('fexp2', ('fneg', 'a'))
 *    ('~frsq', ('fexp2', 'a')) => ('fexp2', ('fmul', -0.5, 'a'))
 *    ('~flog2', ('fsqrt', 'a')) => ('fmul', 0.5, ('flog2', 'a'))
 *    ('~flog2', ('frcp', 'a')) => ('fneg', ('flog2', 'a'))
 *    ('~flog2', ('frsq', 'a')) => ('fmul', -0.5, ('flog2', 'a'))
 *    ('~flog2', ('fpow', 'a', 'b')) => ('fmul', 'b', ('flog2', 'a'))
 *    ('~fmul', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('fadd', 'a', 'b'))
 *    ('bcsel', ('flt', 'a', 0.0), 0.0, ('fsqrt', 'a')) => ('fsqrt', ('fmax', 'a', 0.0))
 *    ('~fmul', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fmulz', ('fsqrt', 'a'), ('fsqrt', 'a')) => ('fabs', 'a')
 *    ('~fdiv', 1.0, 'a') => ('frcp', 'a')
 *    ('fdiv', 'a', 'b') => ('fmul', 'a', ('frcp', 'b'))
 *    ('~frcp', ('frcp', 'a')) => a
 *    ('~frcp', ('fsqrt', 'a')) => ('frsq', 'a')
 *    ('fsqrt', 'a') => ('frcp', ('frsq', 'a'))
 *    ('~frcp', ('frsq', 'a')) => ('fsqrt', 'a')
 *    ('fsin', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.5))), 1.0)))), 4.0))
 *    ('fcos', 'a') => ('ffma', ('ffma', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0), ('fabs', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0)), ('fneg', ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))), 0.225, ('fmul', ('fsub', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fmul', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0), ('fabs', ('fsub', ('fmul', 2.0, ('ffract', ('fadd', ('fmul', 0.15915494309189535, 'a'), 0.75))), 1.0)))), 4.0))
 *    ('ieq', 'a', True) => a
 *    ('ine(is_not_used_by_if)', 'a', True) => ('inot', 'a')
 *    ('ine', 'a', False) => a
 *    ('ieq(is_not_used_by_if)', 'a', False) => ('inot', 'a')
 *    ('bcsel', 'a', True, False) => a
 *    ('bcsel', 'a', False, True) => ('inot', 'a')
 *    ('bcsel', True, 'b', 'c') => b
 *    ('bcsel', False, 'b', 'c') => c
 *    ('bcsel@16', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@16', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@16', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@16', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@32', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@32', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@32', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@32', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel@64', 'a', 1.0, 0.0) => ('b2f', 'a')
 *    ('bcsel@64', 'a', 0.0, 1.0) => ('b2f', ('inot', 'a'))
 *    ('bcsel@64', 'a', -1.0, -0.0) => ('fneg', ('b2f', 'a'))
 *    ('bcsel@64', 'a', -0.0, -1.0) => ('fneg', ('b2f', ('inot', 'a')))
 *    ('bcsel', 'a', 'b', 'b') => b
 *    ('~fcsel', 'a', 'b', 'b') => b
 *    ('imax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('imin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umax', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('ior', 'a', 'b')))
 *    ('umin', ('ineg', ('b2i', 'a@1')), ('ineg', ('b2i', 'b@1'))) => ('ineg', ('b2i', ('iand', 'a', 'b')))
 *    ('umax', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('ior', 'a', 'b'))
 *    ('umin', ('b2i', 'a@1'), ('b2i', 'b@1')) => ('b2i', ('iand', 'a', 'b'))
 *    ('iand', ('b2i', 'a'), 1) => ('b2i', 'a')
 *    ('ine', ('umin', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('iand', 'a', ('ine', 'b', 0))
 *    ('ine', ('umax', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('ior', 'a', ('ine', 'b', 0))
 *    ('ine', ('umin', ('b2i', 'a@1'), 'b'), 0) => ('iand', 'a', ('ine', 'b', 0))
 *    ('ine', ('umax', ('b2i', 'a@1'), 'b'), 0) => ('ior', 'a', ('ine', 'b', 0))
 *    ('ieq', ('umin', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('ior', ('inot', 'a'), ('ieq', 'b', 0))
 *    ('ieq', ('umax', ('ineg', ('b2i', 'a@1')), 'b'), 0) => ('iand', ('inot', 'a'), ('ieq', 'b', 0))
 *    ('ieq', ('umin', ('b2i', 'a@1'), 'b'), 0) => ('ior', ('inot', 'a'), ('ieq', 'b', 0))
 *    ('ieq', ('umax', ('b2i', 'a@1'), 'b'), 0) => ('iand', ('inot', 'a'), ('ieq', 'b', 0))
 *    ('f2i', ('ftrunc', 'a')) => ('f2i', 'a')
 *    ('f2u', ('ftrunc', 'a(is_not_negative)')) => ('f2u', 'a')
 *    ('f2i', ('ffloor', 'a(is_not_negative)')) => ('f2i', 'a')
 *    ('f2u', ('ffloor', 'a')) => ('f2u', 'a')
 *    ('f2u', 'a(is_not_positive)') => 0
 *    ('f2fmp', ('f2f32', 'a@16')) => a
 *    ('i2imp', ('i2i32', 'a@16')) => a
 *    ('i2imp', ('u2u32', 'a@16')) => a
 *    ('f2imp', ('f2f32', 'a@16')) => ('f2i16', 'a')
 *    ('f2ump', ('f2f32', 'a@16')) => ('f2u16', 'a')
 *    ('i2fmp', ('i2i32', 'a@16')) => ('i2f16', 'a')
 *    ('u2fmp', ('u2u32', 'a@16')) => ('u2f16', 'a')
 *    ('f2fmp', ('b2f32', 'a@1')) => ('b2f16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('i2imp', ('b2i32', 'a@1')) => ('b2i16', 'a')
 *    ('f2imp', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('f2ump', ('b2f32', 'a@1')) => ('b2i16', 'a')
 *    ('i2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('u2fmp', ('b2i32', 'a@1')) => ('b2f16', 'a')
 *    ('f2f32', ('f2fmp', 'a@32')) => a
 *    ('i2i32', ('i2imp', 'a@32')) => a
 *    ('u2u32', ('i2imp', 'a@32')) => a
 *    ('i2i32', ('f2imp', 'a@32')) => ('f2i32', 'a')
 *    ('u2u32', ('f2ump', 'a@32')) => ('f2u32', 'a')
 *    ('f2f32', ('i2fmp', 'a@32')) => ('i2f32', 'a')
 *    ('f2f32', ('u2fmp', 'a@32')) => ('u2f32', 'a')
 *    ('f2i32', ('f2fmp', 'a@32')) => ('f2i32', 'a')
 *    ('f2u32', ('f2fmp', 'a@32')) => ('f2u32', 'a')
 *    ('i2f32', ('i2imp', 'a@32')) => ('i2f32', 'a')
 *    ('ffloor', 'a(is_integral)') => a
 *    ('fceil', 'a(is_integral)') => a
 *    ('ftrunc', 'a(is_integral)') => a
 *    ('fround_even', 'a(is_integral)') => a
 *    ('~ffract', 'a(is_integral)') => 0.0
 *    ('ffract', ('ffract', 'a')) => ('ffract', 'a')
 *    ('fabs', 'a(is_not_negative)') => a
 *    ('iabs', 'a(is_not_negative)') => a
 *    ('fsat', 'a(is_not_positive)') => 0.0
 *    ('~fmin', 'a(is_not_negative)', 1.0) => ('fsat', 'a')
 *    ('fmin', 'a(is_a_number_not_negative)', 1.0) => ('fsat', 'a')
 *    ('flt', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('flt', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => False
 *    ('fmax', ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fmul', ('fsat', 'a'), ('fneg', ('fsat', 'a'))), 1.0)
 *    ('fmax', ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0), 0.0) => ('fadd', ('fneg', ('fmul', ('fsat', 'a'), ('fsat', 'a'))), 1.0)
 *    ('fneu', 'a(is_not_zero)', 0.0) => True
 *    ('feq', 'a(is_not_zero)', 0.0) => False
 *    ('fge', 'a(is_a_number_not_negative)', 'b(is_a_number_not_positive)') => True
 *    ('fge', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('fge', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('flt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('flt', 'a(is_a_number_not_positive)', 'b(is_a_number_gt_zero)') => True
 *    ('flt', 'a(is_a_number_lt_zero)', 'b(is_a_number_not_negative)') => True
 *    ('ine', 'a(is_not_zero)', 0) => True
 *    ('ieq', 'a(is_not_zero)', 0) => False
 *    ('ige', 'a(is_not_negative)', 'b(is_not_positive)') => True
 *    ('ige', 'a(is_not_positive)', 'b(is_gt_zero)') => False
 *    ('ige', 'a(is_lt_zero)', 'b(is_not_negative)') => False
 *    ('ilt', 'a(is_not_negative)', 'b(is_not_positive)') => False
 *    ('ilt', 'a(is_not_positive)', 'b(is_gt_zero)') => True
 *    ('ilt', 'a(is_lt_zero)', 'b(is_not_negative)') => True
 *    ('ult', 0, 'a(is_gt_zero)') => True
 *    ('ult', 'a', 0) => False
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32_split', 'a', 'b')) => a
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32_split', 'a', 'b')) => b
 *    ('unpack_64_2x32_split_x', ('pack_64_2x32', 'a')) => a.x
 *    ('unpack_64_2x32_split_y', ('pack_64_2x32', 'a')) => a.y
 *    ('unpack_64_2x32_split_x', ('u2u64', 'a@32')) => a
 *    ('unpack_64_2x32_split_x', ('i2i64', 'a@32')) => a
 *    ('unpack_64_2x32_split_y', ('i2i64(is_used_once)', 'a@32')) => ('ishr', 'a', 31)
 *    ('unpack_64_2x32', ('pack_64_2x32_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_64_2x32', ('pack_64_2x32', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')) => a
 *    ('pack_64_2x32_split', ('unpack_64_2x32', 'a'), ('unpack_64_2x32.y', 'a')) => a
 *    ('pack_64_2x32', ('vec2', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a'))) => a
 *    ('pack_64_2x32', ('unpack_64_2x32', 'a')) => a
 *    ('unpack_32_2x16_split_x', ('pack_32_2x16_split', 'a', 'b')) => a
 *    ('unpack_32_2x16_split_y', ('pack_32_2x16_split', 'a', 'b')) => b
 *    ('unpack_32_2x16_split_x', ('pack_32_2x16', 'a')) => a.x
 *    ('unpack_32_2x16_split_y', ('pack_32_2x16', 'a')) => a.y
 *    ('unpack_32_2x16_split_x', ('u2u32', 'a@16')) => a
 *    ('unpack_32_2x16_split_x', ('i2i32', 'a@16')) => a
 *    ('unpack_32_2x16_split_y', ('i2i32(is_used_once)', 'a@16')) => ('ishr', 'a', 15)
 *    ('unpack_32_2x16', ('pack_32_2x16_split', 'a', 'b')) => ('vec2', 'a', 'b')
 *    ('unpack_32_2x16', ('pack_32_2x16', 'a')) => a
 *    ('pack_32_2x16_split', ('unpack_32_2x16_split_x', 'a'), ('unpack_32_2x16_split_y', 'a')) => a
 *    ('pack_32_2x16_split', ('unpack_32_2x16', 'a'), ('unpack_32_2x16.y', 'a')) => a
 *    ('pack_32_2x16', ('vec2', ('unpack_32_2x16_split_x', 'a'), ('unpack_32_2x16_split_y', 'a'))) => a
 *    ('pack_32_2x16', ('unpack_32_2x16', 'a')) => a
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a@1')) => 0
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a@8')) => 0
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a@16')) => 0
 *    ('unpack_64_2x32_split_y', ('u2u64', 'a@32')) => 0
 *    ('unpack_double_2x32_dxil', ('pack_double_2x32_dxil', 'a')) => a
 *    ('pack_double_2x32_dxil', ('unpack_double_2x32_dxil', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_4x16', 'a')) => a
 *    ('pack_64_4x16', ('unpack_64_4x16', 'a')) => a
 *    ('unpack_32_4x8', ('pack_32_4x8', 'a')) => a
 *    ('pack_32_4x8', ('unpack_32_4x8', 'a')) => a
 *    ('unpack_64_4x16', ('pack_64_2x32', ('vec2', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd')))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('unpack_64_4x16', ('pack_64_2x32_split', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd'))) => ('vec4', 'a', 'b', 'c', 'd')
 *    ('pack_64_2x32_split', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd')) => ('pack_64_4x16', ('vec4', 'a', 'b', 'c', 'd'))
 *    ('pack_64_2x32', ('vec2', ('pack_32_2x16_split', 'a', 'b'), ('pack_32_2x16_split', 'c', 'd'))) => ('pack_64_4x16', ('vec4', 'a', 'b', 'c', 'd'))
 *    ('pack_64_2x32', ('vec2', ('pack_32_2x16', ('vec2', 'a', 'b')), ('pack_32_2x16', ('vec2', 'c', 'd')))) => ('pack_64_4x16', ('vec4', 'a', 'b', 'c', 'd'))
 *    ('iand', ('ieq', ('unpack_32_2x16_split_x', 'a'), '#b'), ('ieq', ('unpack_32_2x16_split_y', 'a'), '#c')) => ('ieq', 'a', ('pack_32_2x16_split', 'b', 'c'))
 *    ('ushr', 'a@16', 8) => ('extract_u8', 'a', 1)
 *    ('ushr', 'a@32', 24) => ('extract_u8', 'a', 3)
 *    ('ushr', 'a@64', 56) => ('extract_u8', 'a', 7)
 *    ('ishr', 'a@16', 8) => ('extract_i8', 'a', 1)
 *    ('ishr', 'a@32', 24) => ('extract_i8', 'a', 3)
 *    ('ishr', 'a@64', 56) => ('extract_i8', 'a', 7)
 *    ('iand', 255, 'a') => ('extract_u8', 'a', 0)
 *    ('ishr', ('iand', 'a@32', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a@64', 65280), 8) => ('extract_u8', 'a', 1)
 *    ('ishr', ('iand', 'a', 16711680), 16) => ('extract_u8', 'a', 2)
 *    ('u2u8', ('extract_u16', 'a', 1)) => ('u2u8', ('extract_u8', 'a', 2))
 *    ('u2u8', ('ushr', 'a', 8)) => ('u2u8', ('extract_u8', 'a', 1))
 *    ('i2i16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('i2i16', ('extract_i8', 'a', 'b'))
 *    ('u2u16', ('u2u8', ('extract_u8', 'a', 'b'))) => ('u2u16', ('extract_u8', 'a', 'b'))
 *    ('ubfe', 'a', 0, 8) => ('extract_u8', 'a', 0)
 *    ('ubfe', 'a', 8, 8) => ('extract_u8', 'a', 1)
 *    ('ubfe', 'a', 16, 8) => ('extract_u8', 'a', 2)
 *    ('ubfe', 'a', 24, 8) => ('extract_u8', 'a', 3)
 *    ('ibfe', 'a', 0, 8) => ('extract_i8', 'a', 0)
 *    ('ibfe', 'a', 8, 8) => ('extract_i8', 'a', 1)
 *    ('ibfe', 'a', 16, 8) => ('extract_i8', 'a', 2)
 *    ('ibfe', 'a', 24, 8) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_u8', ('extract_u8', 'a', 'b'), 0) => ('extract_u8', 'a', 'b')
 *    ('extract_i8', ('iand', 'a', 65280), 1) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('iand', 'a', 16711680), 2) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('iand', 'a', 4278190080), 3) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('iand', 'a', 65280), 1) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('iand', 'a', 16711680), 2) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('iand', 'a', 4278190080), 3) => ('extract_u8', 'a', 3)
 *    ('ior', ('bcsel', ('ieq', ('iand', 'a', 128), 0), 0, -256), ('extract_u8', 'a', 0)) => ('extract_i8', 'a', 0)
 *    ('ior', ('bcsel', ('ieq', ('iand', 'a', 32768), 0), 0, -256), ('extract_u8', 'a', 1)) => ('extract_i8', 'a', 1)
 *    ('ior', ('bcsel', ('ieq', ('iand', 'a', 8388608), 0), 0, -256), ('extract_u8', 'a', 2)) => ('extract_i8', 'a', 2)
 *    ('ior', ('bcsel', ('ige', 'a@32', 0), 0, -256), ('extract_u8', 'a', 3)) => ('extract_i8', 'a', 3)
 *    ('ior', ('bcsel', ('ine', ('iand', 'a', 128), 0), -256, 0), ('extract_u8', 'a', 0)) => ('extract_i8', 'a', 0)
 *    ('ior', ('bcsel', ('ine', ('iand', 'a', 32768), 0), -256, 0), ('extract_u8', 'a', 1)) => ('extract_i8', 'a', 1)
 *    ('ior', ('bcsel', ('ine', ('iand', 'a', 8388608), 0), -256, 0), ('extract_u8', 'a', 2)) => ('extract_i8', 'a', 2)
 *    ('ior', ('bcsel', ('ilt', 'a@32', 0), -256, 0), ('extract_u8', 'a', 3)) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ushr', 'a', 8), 0) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ushr', 'a', 8), 1) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ushr', 'a', 8), 2) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a', 8), 1) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a', 8), 2) => ('extract_u8', 'a', 3)
 *    ('extract_i8', ('extract_i16', 'a', 1), 0) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('extract_i16', 'a', 1), 1) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('extract_u16', 'a', 1), 0) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('extract_u16', 'a', 1), 1) => ('extract_i8', 'a', 3)
 *    ('extract_u8', ('extract_i16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('extract_i16', 'a', 1), 1) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('extract_u16', 'a', 1), 1) => ('extract_u8', 'a', 3)
 *    ('iand', ('extract_u8', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 255))
 *    ('iand', ('extract_u16', 'a', 0), '#b') => ('iand', 'a', ('iand', 'b', 65535))
 *    ('ieq', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ine', ('iand', ('extract_u8', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 255), ('imul', ('i2i32', 'b'), 8))), 0)
 *    ('ieq', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ine', ('iand', ('extract_u16(is_used_once)', 'a', '#b'), '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('iand', 'c', 65535), ('imul', ('i2i32', 'b'), 16))), 0)
 *    ('ushr', ('ishl', 'a@32', 16), 16) => ('extract_u16', 'a', 0)
 *    ('ushr', 'a@32', 16) => ('extract_u16', 'a', 1)
 *    ('ishr', ('ishl', 'a@32', 16), 16) => ('extract_i16', 'a', 0)
 *    ('ishr', 'a@32', 16) => ('extract_i16', 'a', 1)
 *    ('iand', 65535, 'a') => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 0, 16) => ('extract_u16', 'a', 0)
 *    ('ubfe', 'a', 16, 16) => ('extract_u16', 'a', 1)
 *    ('ibfe', 'a', 0, 16) => ('extract_i16', 'a', 0)
 *    ('ibfe', 'a', 16, 16) => ('extract_i16', 'a', 1)
 *    ('ior', ('ishl', ('u2u32', 'a@8'), 24), ('ior', ('ishl', ('u2u32', 'b@8'), 16), ('ior', ('ishl', ('u2u32', 'c@8'), 8), ('u2u32', 'd@8')))) => ('pack_32_4x8', ('vec4', 'd', 'c', 'b', 'a'))
 *    ('ior', ('u2u16', ('unpack_32_4x8', 'a')), ('ishl', ('u2u16', ('unpack_32_4x8.y', 'a')), 8)) => ('unpack_32_2x16_split_x', 'a')
 *    ('ior', ('u2u16', ('unpack_32_4x8.z', 'a')), ('ishl', ('u2u16', ('unpack_32_4x8.w', 'a')), 8)) => ('unpack_32_2x16_split_y', 'a')
 *    ('i2i16', ('unpack_32_4x8(xz_components_unused).y', 'a')) => ('extract_i8', ('unpack_32_2x16.x', 'a'), 1)
 *    ('i2i16', ('unpack_32_4x8(xz_components_unused).w', 'a')) => ('extract_i8', ('unpack_32_2x16.y', 'a'), 1)
 *    ('extract_u16', ('extract_i16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_u16', ('extract_u16', 'a', 'b'), 0) => ('extract_u16', 'a', 'b')
 *    ('extract_i16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('extract_u16', ('iand', 'a', 16711680), 1) => ('extract_u8', 'a', 2)
 *    ('pack_64_2x32_split', 'a', 'b') => ('ior', ('u2u64', 'a'), ('ishl', ('u2u64', 'b'), 32))
 *    ('pack_32_2x16_split', 'a', 'b') => ('ior', ('u2u32', 'a'), ('ishl', ('u2u32', 'b'), 16))
 *    ('pack_half_2x16_split', 'a', 'b') => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('unpack_64_2x32_split_x', 'a') => ('u2u32', 'a')
 *    ('unpack_64_2x32_split_y', 'a') => ('u2u32', ('ushr', 'a', 32))
 *    ('unpack_32_2x16_split_x', 'a') => ('u2u16', 'a')
 *    ('unpack_32_2x16_split_y', 'a') => ('u2u16', ('ushr', 'a', 16))
 *    ('unpack_64_2x32_split_x', ('ushr', 'a', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('u2u32', ('ushr', 'a@64', 32)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('iand', 'a', 65535)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_64_2x32_split_x', ('iand', 'a', 4294967295)) => ('unpack_64_2x32_split_x', 'a')
 *    ('unpack_half_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_y', ('iand', 'a', 4294901760)) => ('unpack_32_2x16_split_y', 'a')
 *    ('unpack_64_2x32_split_y', ('iand', 'a', 18446744069414584320)) => ('unpack_64_2x32_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_half_2x16_split_x', 'a')
 *    ('unpack_half_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_half_2x16_split_x', ('ushr', 'a', 16)) => ('unpack_half_2x16_split_y', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 0)) => ('unpack_32_2x16_split_x', 'a')
 *    ('unpack_32_2x16_split_x', ('extract_u16', 'a', 1)) => ('unpack_32_2x16_split_y', 'a')
 *    ('ishl', ('pack_half_2x16', ('vec2', 'a', 0)), 16) => ('pack_half_2x16', ('vec2', 0, 'a'))
 *    ('ushr', ('pack_half_2x16', ('vec2', 0, 'a')), 16) => ('pack_half_2x16', ('vec2', 'a', 0))
 *    ('iadd', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ior', ('pack_half_2x16', ('vec2', 'a', 0)), ('pack_half_2x16', ('vec2', 0, 'b'))) => ('pack_half_2x16', ('vec2', 'a', 'b'))
 *    ('ishl', ('pack_half_2x16_split', 'a', 0), 16) => ('pack_half_2x16_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_split', 0, 'a'), 16) => ('pack_half_2x16_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_split', 0, 'a'), 1) => ('pack_half_2x16_split', 'a', 0)
 *    ('ishl', ('pack_half_2x16_rtz_split', 'a', 0), 16) => ('pack_half_2x16_rtz_split', 0, 'a')
 *    ('ushr', ('pack_half_2x16_rtz_split', 0, 'a'), 16) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('extract_u16', ('pack_half_2x16_rtz_split', 0, 'a'), 1) => ('pack_half_2x16_rtz_split', 'a', 0)
 *    ('iadd', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_split', 'a', 0), ('pack_half_2x16_split', 0, 'b')) => ('pack_half_2x16_split', 'a', 'b')
 *    ('iadd', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('ior', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 0, 'b')) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('pack_uint_2x16', ('vec2', ('pack_half_2x16_rtz_split', 'a', 0), ('pack_half_2x16_rtz_split', 'b', 0))) => ('pack_half_2x16_rtz_split', 'a', 'b')
 *    ('bfi', 4294901760, ('pack_half_2x16_split', 'a', 'b'), ('pack_half_2x16_split', 'c', 'd')) => ('pack_half_2x16_split', 'c', 'a')
 *    ('iand', ('bfi', 15, '#a', 'b'), 4294967292) => ('bfi', 15, ('iand', 'a', 4294967292), 'b')
 *    ('iand', ('bfi', 7, '#a', 'b'), 4294967292) => ('bfi', 7, ('iand', 'a', 4294967292), 'b')
 *    ('umin', ('ishl', ('iand', 'a', 15), 3), 120) => ('ishl', ('iand', 'a', 15), 3)
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('i2i', 'a')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('i2i', 'b')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('i2i', 'c')
 *    ('extract_i8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('i2i', 'd')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 0) => ('u2u', 'a')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 1) => ('u2u', 'b')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 2) => ('u2u', 'c')
 *    ('extract_u8', ('pack_32_4x8_split', 'a', 'b', 'c', 'd'), 3) => ('u2u', 'd')
 *    ('u2u32', ('iadd(is_used_once)', 'a@64', 'b')) => ('iadd', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2u32', ('imul(is_used_once)', 'a@64', 'b')) => ('imul', ('u2u32', 'a'), ('u2u32', 'b'))
 *    ('u2f32', ('u2u64', 'a@32')) => ('u2f32', 'a')
 *    ('ult', 4294967295, 'a@64') => ('ine', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('i2i16', ('u2u8', ('iand', 'a@16', 1))) => ('iand', 'a@16', 1)
 *    ('u2u16', ('u2u8', ('iand', 'a@16', 1))) => ('iand', 'a@16', 1)
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@8')), 32)) => ('u2u32', 'a')
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@16')), 32)) => ('u2u32', 'a')
 *    ('u2u32', ('ushr', ('ior', ('ishl', 'a', 32), ('u2u64', 'b@32')), 32)) => ('u2u32', 'a')
 *    ('u2u16', ('ushr', ('ior', ('ishl', 'a', 16), ('u2u32', 'b@8')), 16)) => ('u2u16', 'a')
 *    ('u2u16', ('ushr', ('ior', ('ishl', 'a', 16), ('u2u32', 'b@16')), 16)) => ('u2u16', 'a')
 *    ('extract_u8', ('ushr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ushr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ushr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ushr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ushr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ushr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ushr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('ishr', 'a@16', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@32', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@32', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 8), 0) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishr', 'a@64', 16), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishr', 'a@64', 24), 0) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishr', 'a@64', 32), 0) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishr', 'a@64', 40), 0) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishr', 'a@64', 48), 0) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishr', 'a@64', 56), 0) => ('extract_u8', 'a', 7)
 *    ('extract_u8', ('extract_u16', 'a', 1), 0) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@16', 8), 1) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@32', 8), 3) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@32', 16), 3) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@32', 24), 3) => ('extract_u8', 'a', 0)
 *    ('extract_u8', ('ishl', 'a@64', 8), 7) => ('extract_u8', 'a', 6)
 *    ('extract_u8', ('ishl', 'a@64', 16), 7) => ('extract_u8', 'a', 5)
 *    ('extract_u8', ('ishl', 'a@64', 24), 7) => ('extract_u8', 'a', 4)
 *    ('extract_u8', ('ishl', 'a@64', 32), 7) => ('extract_u8', 'a', 3)
 *    ('extract_u8', ('ishl', 'a@64', 40), 7) => ('extract_u8', 'a', 2)
 *    ('extract_u8', ('ishl', 'a@64', 48), 7) => ('extract_u8', 'a', 1)
 *    ('extract_u8', ('ishl', 'a@64', 56), 7) => ('extract_u8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@16', 8), 1) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@32', 8), 3) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@32', 16), 3) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@32', 24), 3) => ('extract_i8', 'a', 0)
 *    ('extract_i8', ('ishl', 'a@64', 8), 7) => ('extract_i8', 'a', 6)
 *    ('extract_i8', ('ishl', 'a@64', 16), 7) => ('extract_i8', 'a', 5)
 *    ('extract_i8', ('ishl', 'a@64', 24), 7) => ('extract_i8', 'a', 4)
 *    ('extract_i8', ('ishl', 'a@64', 32), 7) => ('extract_i8', 'a', 3)
 *    ('extract_i8', ('ishl', 'a@64', 40), 7) => ('extract_i8', 'a', 2)
 *    ('extract_i8', ('ishl', 'a@64', 48), 7) => ('extract_i8', 'a', 1)
 *    ('extract_i8', ('ishl', 'a@64', 56), 7) => ('extract_i8', 'a', 0)
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ieq', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ieq', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ieq', 'a', 'b')
 *    ('ieq', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ieq', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ieq', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ieq', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ine', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ine', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ine', 'a', 'b')
 *    ('ine', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ine', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ine', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ine', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ult', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ult', 'a', 'b')
 *    ('ult', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ult', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ult', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('ult', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('ult', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ilt', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('ult', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ilt', 'a', 'b')
 *    ('ilt', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ilt', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ilt', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('uge', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('uge', 'a', 'b')
 *    ('uge', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('uge', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('uge', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), ('pack_64_2x32_split', 'b', 0)) => ('uge', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 'a', 0), '#b(is_upper_half_zero)') => ('uge', 'a', ('unpack_64_2x32_split_x', 'b'))
 *    ('ige', '#a(is_upper_half_zero)', ('pack_64_2x32_split', 'b', 0)) => ('uge', ('unpack_64_2x32_split_x', 'a'), 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), ('pack_64_2x32_split', 0, 'b')) => ('ige', 'a', 'b')
 *    ('ige', ('pack_64_2x32_split', 0, 'a'), '#b(is_lower_half_zero)') => ('ige', 'a', ('unpack_64_2x32_split_y', 'b'))
 *    ('ige', '#a(is_lower_half_zero)', ('pack_64_2x32_split', 0, 'b')) => ('ige', ('unpack_64_2x32_split_y', 'a'), 'b')
 *    ('ussub_4x8_vc4', 'a', 0) => a
 *    ('ussub_4x8_vc4', 'a', -1) => 0
 *    ('fsub', 'a', 'b') => ('fadd', 'a', ('fneg', 'b'))
 *    ('isub', 'a', 'b') => ('iadd', 'a', ('ineg', 'b'))
 *    ('uabs_usub', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('uabs_isub', 'a', 'b') => ('bcsel', ('ilt', 'a', 'b'), ('ineg', ('isub', 'a', 'b')), ('isub', 'a', 'b'))
 *    ('bitz', 'a', 'b') => ('inot', ('bitnz', 'a', 'b'))
 *    ('fmul(is_used_by_non_fsat)', ('fneg', 'a'), 'b') => ('fneg', ('fmul', 'a', 'b'))
 *    ('fmulz(is_used_by_non_fsat,nsz)', ('fneg', 'a'), 'b') => ('fneg', ('fmulz', 'a', 'b'))
 *    ('ffma', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffma', 'a', 'b', 'c')
 *    ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') => ('ffmaz', 'a', 'b', 'c')
 *    ('imul', ('ineg', 'a'), 'b') => ('ineg', ('imul', 'a', 'b'))
 *    ('~fmul(is_used_once)', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul(is_used_once)', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)') => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('imul(is_used_once)', ('imul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~ffma', ('fmul(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c', 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffma', ('fmulz(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c(is_finite_not_zero)', 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_fmul)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('fadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd(is_used_once)', ('ffma(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffma', 'a', 'b', 'd'), 'c')
 *    ('~fadd(is_used_once)', ('ffmaz(is_used_once)', 'a(is_not_const)', 'b', 'c(is_not_const)'), '#d') => ('fadd', ('ffmaz', 'a', 'b', 'd'), 'c')
 *    ('iadd(is_used_once)', ('iadd(is_used_once)', 'a(is_not_const)', 'b(is_not_const)'), '#c') => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('~fmul', '#a', ('fmul', 'b(is_not_const)', '#c')) => ('fmul', ('fmul', 'a', 'c'), 'b')
 *    ('~fmulz', '#a', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmulz', 'a', 'c'), 'b')
 *    ('~fmul', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c')) => ('fmulz', ('fmul', 'a', 'c'), 'b')
 *    ('~ffma', '#a', ('fmul', 'b(is_not_const)', '#c'), 'd') => ('ffma', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmulz', 'a', 'c'), 'b', 'd')
 *    ('~ffmaz', '#a(is_finite_not_zero)', ('fmulz', 'b(is_not_const)', '#c'), 'd') => ('ffmaz', ('fmul', 'a', 'c'), 'b', 'd')
 *    ('imul', '#a', ('imul', 'b(is_not_const)', '#c')) => ('imul', ('imul', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fadd', 'b(is_not_const)', '#c')) => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('~fadd', '#a', ('fneg', ('fadd', 'b(is_not_const)', '#c'))) => ('fadd', ('fadd', 'a', ('fneg', 'c')), ('fneg', 'b'))
 *    ('~fadd', '#a', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffma', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffma', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffma', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('~fadd', '#a', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d')) => ('ffmaz', 'b', 'c', ('fadd', 'a', 'd'))
 *    ('~fadd', '#a', ('fneg', ('ffmaz', 'b(is_not_const)', 'c(is_not_const)', '#d'))) => ('ffmaz', ('fneg', 'b'), 'c', ('fadd', 'a', ('fneg', 'd')))
 *    ('iadd', '#a', ('iadd', 'b(is_not_const)', '#c')) => ('iadd', ('iadd', 'a', 'c'), 'b')
 *    ('iand', '#a', ('iand', 'b(is_not_const)', '#c')) => ('iand', ('iand', 'a', 'c'), 'b')
 *    ('ior', '#a', ('ior', 'b(is_not_const)', '#c')) => ('ior', ('ior', 'a', 'c'), 'b')
 *    ('ixor', '#a', ('ixor', 'b(is_not_const)', '#c')) => ('ixor', ('ixor', 'a', 'c'), 'b')
 *    ('ior', ('iand', 'a', '#c'), ('ior', 'b', ('iand', 'a', '#d'))) => ('ior', 'b', ('iand', 'a', ('ior', 'c', 'd')))
 *    ('~fadd', ('fadd(is_used_once)', 'a(is_fmul)', 'b(is_fmul)'), 'c(is_not_fmul)') => ('fadd', ('fadd', 'a', 'c'), 'b')
 *    ('idiv', ('imul(no_signed_wrap)', 'a', 'b'), 'b') => a
 *    ('bcsel', ('ige', ('find_lsb', 'a'), 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb', 'a'), 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ige', ('ufind_msb', 'a'), 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ige', ('ifind_msb_rev', 'a'), 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ige', ('ufind_msb_rev', 'a'), 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('find_lsb', 'a'), -1) => ('find_lsb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb', 'a'), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', 0), ('ufind_msb_rev', 'a'), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb', 'a'), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', 'a', -1), ('ifind_msb_rev', 'a'), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), -1) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb', 'a'))), ('ifind_msb', 'a')) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ufind_msb', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb', 'a@32'), -1), ('ifind_msb', 'a'), ('iadd', 31, ('ineg', ('ifind_msb', 'a')))) => ('ifind_msb_rev', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb', 'a@32'), -1), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), -1) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb', 'a'))), ('ufind_msb', 'a')) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb', 'a'), ('iadd', 31, ('ineg', ('ufind_msb', 'a')))) => ('ufind_msb_rev', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), -1) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', ('ifind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a'))), ('ifind_msb_rev', 'a')) => ('ifind_msb', 'a')
 *    ('bcsel', ('ine', ('ufind_msb_rev', 'a@32'), -1), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', ('ifind_msb_rev', 'a@32'), -1), ('ifind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ifind_msb_rev', 'a')))) => ('ifind_msb', 'a')
 *    ('bcsel', ('ieq', ('ufind_msb_rev', 'a@32'), -1), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), -1) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), -1, ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('bcsel', ('ine', 'a@32', 0), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a'))), ('ufind_msb_rev', 'a')) => ('ufind_msb', 'a')
 *    ('bcsel', ('ieq', 'a@32', 0), ('ufind_msb_rev', 'a'), ('iadd', 31, ('ineg', ('ufind_msb_rev', 'a')))) => ('ufind_msb', 'a')
 *    ('iand', 'a', ('inot', ('ishl', 1, ('find_lsb', 'a')))) => ('iand', 'a', ('inot', ('ineg', 'a')))
 *    ('find_lsb', ('bitfield_reverse', 'a@32')) => ('ufind_msb_rev', 'a')
 *    ('ufind_msb_rev', ('bitfield_reverse', 'a@32')) => ('find_lsb', 'a')
 *    ('ifind_msb', ('f2i32(is_used_once)', 'a')) => ('ufind_msb', ('f2i32', ('fabs', 'a')))
 *    ('ifind_msb', ('extract_u8', 'a', 'b')) => ('ufind_msb', ('extract_u8', 'a', 'b'))
 *    ('ifind_msb', ('extract_u16', 'a', 'b')) => ('ufind_msb', ('extract_u16', 'a', 'b'))
 *    ('ifind_msb', ('imax', 'a', 1)) => ('ufind_msb', ('imax', 'a', 1))
 *    ('~fmul', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmul', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', -1.0, 1.0), 'b') => ('bcsel', 'c', ('fneg', 'b'), 'b')
 *    ('~fmulz', ('bcsel(is_used_once)', 'c', 1.0, -1.0), 'b') => ('bcsel', 'c', 'b', ('fneg', 'b'))
 *    ('fabs', ('bcsel(is_used_once)', 'b', ('fneg', 'a'), 'a')) => ('fabs', 'a')
 *    ('fabs', ('bcsel(is_used_once)', 'b', 'a', ('fneg', 'a'))) => ('fabs', 'a')
 *    ('~bcsel', ('flt', 'a', 0.0), ('fneg', 'a'), 'a') => ('fabs', 'a')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), 'd') => ('bcsel', ('iand', 'a', 'b'), 'c', 'd')
 *    ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'd', 'c'), 'd') => ('bcsel', ('iand', 'a', ('inot', 'b')), 'c', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel(is_used_once)', 'c', 'b', 'd')) => ('bcsel', ('ior', 'a', 'c'), 'b', 'd')
 *    ('bcsel', 'a', 'b', ('bcsel(is_used_once)', 'c', 'd', 'b')) => ('bcsel', ('iand', 'c', ('inot', 'a')), 'd', 'b')
 *    ('fmod', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ffloor', ('fdiv', 'a', 'b'))))
 *    ('frem', 'a', 'b') => ('fsub', 'a', ('fmul', 'b', ('ftrunc', ('fdiv', 'a', 'b'))))
 *    ('uadd_carry', 'a', 'b') => ('b2i', ('ult', ('iadd', 'a', 'b'), 'a'))
 *    ('usub_borrow', 'a', 'b') => ('b2i', ('ult', 'a', 'b'))
 *    ('ihadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('ihadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('uhadd@64', 'a', 'b') => ('iadd', ('iand', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('irhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ishr', ('ixor', 'a', 'b'), 1))
 *    ('urhadd@64', 'a', 'b') => ('isub', ('ior', 'a', 'b'), ('ushr', ('ixor', 'a', 'b'), 1))
 *    ('imul_32x16', 'a', 'b') => ('imul', 'a', ('extract_i16', 'b', 0))
 *    ('umul_32x16', 'a', 'b') => ('imul', 'a', ('extract_u16', 'b', 0))
 *    ('uadd_sat@64', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('uadd_sat', 'a', 'b') => ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd', 'a', 'b'))
 *    ('usub_sat', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('usub_sat@64', 'a', 'b') => ('bcsel', ('ult', 'a', 'b'), 0, ('isub', 'a', 'b'))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ilt', 'b', 0)), ('ige', ('iadd', 'a', 'b'), 0)), ('iadd', 'a', 'b'), 9223372036854775807))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('iand', ('iand', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), 9223372036854775808, ('bcsel', ('ior', ('ior', ('ilt', 'a', 0), ('ige', 'b', 0)), ('ige', ('isub', 'a', 'b'), 0)), ('isub', 'a', 'b'), 9223372036854775807))
 *    ('ilt', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ilt', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imax(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imax', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ige', ('imin(is_used_once)', 'a@64', 'b@64'), 0) => ('ige', ('imin', ('unpack_64_2x32_split_y', 'a'), ('unpack_64_2x32_split_y', 'b')), 0)
 *    ('ilt', 'a@64', 0) => ('ilt', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ige', 'a@64', 0) => ('ige', ('unpack_64_2x32_split_y', 'a'), 0)
 *    ('ine', 'a@64', 0) => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ieq', 'a@64', 0) => ('ieq', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ult', 0, 'a@64') => ('ine', ('ior', ('unpack_64_2x32_split_x', 'a'), ('unpack_64_2x32_split_y', 'a')), 0)
 *    ('ibitfield_extract', 'value@32', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ibfe', 'value', 'offset', 'bits'))
 *    ('ubitfield_extract', 'value@32', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'value', ('ubfe', 'value', 'offset', 'bits'))
 *    ('bitfield_select', 'a', 'b', 0) => ('iand', 'a', 'b')
 *    ('bitfield_select', 'a', 0, 'b') => ('iand', ('inot', 'a'), 'b')
 *    ('bitfield_select', 0, 'a', 'b') => b
 *    ('bitfield_select', 'a', 'b', -1) => ('ior', ('inot', 'a'), 'b')
 *    ('bitfield_select', 'a', -1, 'b') => ('ior', 'a', 'b')
 *    ('bitfield_select', -1, 'a', 'b') => a
 *    ('bitfield_select', 'a', 'b', 'b') => b
 *    ('bitfield_select', 'a', ('inot', 'b'), 'b') => ('ixor', 'a', 'b')
 *    ('bitfield_select', 'a', 'b', ('inot', 'b')) => ('inot', ('ixor', 'a', 'b'))
 *    ('bitfield_select', 'a', ('iand', 'a', 'b'), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('bitfield_select', 'a', 'b', ('iand', ('inot', 'a'), 'c')) => ('bitfield_select', 'a', 'b', 'c')
 *    ('bitfield_select', ('inot', 'a'), 'b', 'c') => ('bitfield_select', 'a', 'c', 'b')
 *    ('bitfield_select', ('ineg', ('b2i', 'a@1')), 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('ior', ('iand', 'a', 'b'), ('iand', ('inot', 'a'), 'c')) => ('bitfield_select', 'a', 'b', 'c')
 *    ('iadd', ('iand', 'a', 'b'), ('iand', ('inot', 'a'), 'c')) => ('bitfield_select', 'a', 'b', 'c')
 *    ('ixor', ('iand', 'a', 'b'), ('iand', ('inot', 'a'), 'c')) => ('bitfield_select', 'a', 'b', 'c')
 *    ('ixor', ('iand', 'a', ('ixor', 'b', 'c')), 'c') => ('bitfield_select', 'a', 'b', 'c')
 *    ('bitfield_select@1', 'a', 'b', 'c') => ('bcsel', 'a', 'b', 'c')
 *    ('ubfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ubfe', 'value', 'offset', 'bits')
 *    ('ubfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ubfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', 'offset', ('iand', 31, 'bits')) => ('ibfe', 'value', 'offset', 'bits')
 *    ('ibfe', 'value', ('iand', 31, 'offset'), 'bits') => ('ibfe', 'value', 'offset', 'bits')
 *    ('bfm', 'bits', ('iand', 31, 'offset')) => ('bfm', 'bits', 'offset')
 *    ('bfm', ('iand', 31, 'bits'), 'offset') => ('bfm', 'bits', 'offset')
 *    ('ult', 'a', ('umin', ('iand', 'a', 'b'), 'c')) => False
 *    ('ult', 31, ('umin', '#bits(is_ult_32)', 'a')) => False
 *    ('ubfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ubfe', 'value', 'offset', 'width')
 *    ('ibfe', 'value', 'offset', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset'))))) => ('ibfe', 'value', 'offset', 'width')
 *    ('bfm', ('umin', 'width', ('iadd', 32, ('ineg', ('iand', 31, 'offset')))), 'offset') => ('bfm', 'width', 'offset')
 *    ('iadd@32', ('ishl', 1, 'a'), -1) => ('bfm', 'a', 0)
 *    ('ishl', ('bfm', 'a', 0), 'b') => ('bfm', 'a', 'b')
 *    ('ubfe', 'a', 'b', 0) => 0
 *    ('ibfe', 'a', 'b', 0) => 0
 *    ('ubfe', 'a', 0, '#b') => ('iand', 'a', ('ushr', 4294967295, ('ineg', 'b')))
 *    ('b2i32', ('ine', ('ubfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('b2i32', ('ine', ('ibfe', 'a', 'b', 1), 0)) => ('ubfe', 'a', 'b', 1)
 *    ('ine', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ibfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ine', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ine', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ieq', ('ubfe(is_used_once)', 'a', '#b', '#c'), 0) => ('ieq', ('iand', 'a', ('ishl', ('ushr', 4294967295, ('ineg', 'c')), 'b')), 0)
 *    ('ifind_msb', 'value') => ('ufind_msb', ('bcsel', ('ilt', 'value', 0), ('inot', 'value'), 'value'))
 *    ('ifind_msb', 'value') => ('bcsel', ('ige', ('ifind_msb_rev', 'value'), 0), ('isub', 31, ('ifind_msb_rev', 'value')), ('ifind_msb_rev', 'value'))
 *    ('ifind_msb', 'value') => ('isub', 31, ('uclz', ('ixor', 'value', ('ishr', 'value', 31))))
 *    ('ufind_msb', 'value@32') => ('bcsel', ('ige', ('ufind_msb_rev', 'value'), 0), ('isub', 31, ('ufind_msb_rev', 'value')), ('ufind_msb_rev', 'value'))
 *    ('ufind_msb', 'value@32') => ('isub', 31, ('uclz', 'value'))
 *    ('uclz', 'a') => ('umin', 32, ('ufind_msb_rev', 'a'))
 *    ('find_lsb', 'value@64') => ('ufind_msb', ('iand', 'value', ('ineg', 'value')))
 *    ('find_lsb', 'value') => ('ufind_msb', ('u2u32', ('iand', 'value', ('ineg', 'value'))))
 *    ('extract_i8', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 3, 'b'), 8)), 24)
 *    ('extract_u8', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 8)), 255)
 *    ('extract_i16', 'a', 'b@32') => ('ishr', ('ishl', 'a', ('imul', ('isub', 1, 'b'), 16)), 16)
 *    ('extract_u16', 'a', 'b@32') => ('iand', ('ushr', 'a', ('imul', 'b', 16)), 65535)
 *    ('pack_unorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 65535.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2u32', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_unorm_4x8', 'v') => ('pack_32_4x8', ('f2u8', ('fround_even', ('fmul', ('fsat', 'v'), 255.0))))
 *    ('pack_snorm_2x16', 'v') => ('pack_uvec2_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 32767.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_uvec4_to_uint', ('f2i32', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('pack_snorm_4x8', 'v') => ('pack_32_4x8', ('f2i8', ('fround_even', ('fmul', ('fmin', 1.0, ('fmax', -1.0, 'v')), 127.0))))
 *    ('unpack_unorm_2x16', 'v') => ('fdiv', ('u2f32', ('vec2', ('extract_u16', 'v', 0), ('extract_u16', 'v', 1))), 65535.0)
 *    ('unpack_unorm_4x8', 'v') => ('fdiv', ('u2f32', ('vec4', ('extract_u8', 'v', 0), ('extract_u8', 'v', 1), ('extract_u8', 'v', 2), ('extract_u8', 'v', 3))), 255.0)
 *    ('unpack_snorm_2x16', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec2', ('extract_i16', 'v', 0), ('extract_i16', 'v', 1))), 32767.0)))
 *    ('unpack_snorm_4x8', 'v') => ('fmin', 1.0, ('fmax', -1.0, ('fdiv', ('i2f', ('vec4', ('extract_i8', 'v', 0), ('extract_i8', 'v', 1), ('extract_i8', 'v', 2), ('extract_i8', 'v', 3))), 127.0)))
 *    ('pack_half_2x16_split', 'a@32', 'b@32') => ('ior', ('ishl', ('u2u32', ('f2f16', 'b')), 16), ('u2u32', ('f2f16', 'a')))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('u2u16', 'a'))
 *    ('unpack_half_2x16_split_x', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', 'a')))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('u2u16', ('ushr', 'a', 16)))
 *    ('unpack_half_2x16_split_y', 'a@32') => ('f2f32', ('fmul', 1.0, ('u2u16', ('ushr', 'a', 16))))
 *    ('isign', 'a') => ('imin', ('imax', 'a', -1), 1)
 *    ('imin', ('imax', 'a', -1), 1) => ('isign', 'a')
 *    ('imax', ('imin', 'a', 1), -1) => ('isign', 'a')
 *    ('fsign', 'a') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('fsign', 'a@64') => ('fsub', ('b2f', ('!flt', 0.0, 'a')), ('b2f', ('!flt', 'a', 0.0)))
 *    ('amul', 'a', 'b') => ('imul', 'a', 'b')
 *    ('amul', ('udiv_aligned_4', 'a'), 4) => a
 *    ('imul', ('udiv_aligned_4', 'a'), 4) => a
 *    ('umul24', 'a', 'b') => ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215))
 *    ('umad24', 'a', 'b', 'c') => ('iadd', ('imul', ('iand', 'a', 16777215), ('iand', 'b', 16777215)), 'c')
 *    ('imul24_relaxed', 'a', 'b') => ('imul24', 'a', 'b')
 *    ('imul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('umad24', 'a', 'b', 'c')
 *    ('umad24_relaxed', 'a', 'b', 'c') => ('iadd', ('umul24_relaxed', 'a', 'b'), 'c')
 *    ('umul24_relaxed', 'a', 'b') => ('umul24', 'a', 'b')
 *    ('umul24_relaxed', 'a', 'b') => ('imul', 'a', 'b')
 *    ('imad24_ir3', 'a', 'b', 0) => ('imul24', 'a', 'b')
 *    ('imad24_ir3', 'a', 0, 'c') => c
 *    ('imad24_ir3', 'a', 1, 'c') => ('iadd', 'a', 'c')
 *    ('imad24_ir3', '#a', '#b', 'c') => ('iadd', ('imul', 'a', 'b'), 'c')
 *    ('imul24', 'a', '#b@32(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b'))
 *    ('imul24', 'a', '#b@32(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b'))))
 *    ('imul24', 'a', 0) => 0
 *    ('imul_high@16', 'a', 'b') => ('i2i16', ('ishr', ('imul24_relaxed', ('i2i32', 'a'), ('i2i32', 'b')), 16))
 *    ('umul_high@16', 'a', 'b') => ('u2u16', ('ushr', ('umul24_relaxed', ('u2u32', 'a'), ('u2u32', 'b')), 16))
 *    ('b2i16', ('vec2', ('ult', 'a@16', 'b'), ('ult', 'c@16', 'd'))) => ('umin', 1, ('usub_sat', ('vec2', 'b', 'd'), ('vec2', 'a', 'c')))
 *    ('b2i16', ('vec2', ('uge', 'a@16', '#b(is_not_zero)'), ('uge', 'c@16', '#d(is_not_zero)'))) => ('umin', 1, ('usub_sat', ('vec2', 'a', 'c'), ('iadd', ('vec2', 'b', 'd'), -1)))
 *    ('b2i16', ('vec2', ('uge', '#a(is_not_uint_max)', 'b@16'), ('uge', '#c(is_not_uint_max)', 'd@16'))) => ('umin', 1, ('usub_sat', ('iadd', ('vec2', 'a', 'c'), 1), ('vec2', 'b', 'd')))
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@8', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@8', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@16', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@16', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@32', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@32', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ult', ('iadd', 'a', 'b'), 'a'), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('uge', ('iadd', 'a', 'b'), 'a'), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('uadd_carry', 'a', 'b'), 0), ('iadd@64', 'a', 'b'), -1) => ('uadd_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('uadd_carry', 'a', 'b'), 0), -1, ('iadd@64', 'a', 'b')) => ('uadd_sat', 'a', 'b')
 *    ('bitfield_insert', 'base@32', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bitfield_select', ('bfm', 'bits', 'offset'), ('ishl', 'insert', 'offset'), 'base'))
 *    ('bitfield_insert', 'base@32', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('bfi', ('bfm', 'bits', 'offset'), 'insert', 'base'))
 *    ('ibitfield_extract', 'value@8', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 8, 'bits'), 'offset')), ('isub', 8, 'bits')))
 *    ('ubitfield_extract', 'value@8', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 8), -1, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ibitfield_extract', 'value@16', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 16, 'bits'), 'offset')), ('isub', 16, 'bits')))
 *    ('ubitfield_extract', 'value@16', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 16), -1, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('ibitfield_extract', 'value@32', 'offset', 'bits') => ('bcsel', ('ieq', 0, 'bits'), 0, ('ishr', ('ishl', 'value', ('isub', ('isub', 32, 'bits'), 'offset')), ('isub', 32, 'bits')))
 *    ('ubitfield_extract', 'value@32', 'offset', 'bits') => ('iand', ('ushr', 'value', 'offset'), ('bcsel', ('ieq', 'bits', 32), -1, ('isub', ('ishl', 1, 'bits'), 1)))
 *    ('bitfield_insert', 'base@8', 'insert', 'offset', 'bits') => ('bitfield_select', ('u2u8', ('bfm', 'bits', 'offset')), ('ishl', 'insert', 'offset'), 'base')
 *    ('bitfield_insert', 'base@8', 'insert', 'offset', 'bits') => ('u2u8', ('bfi', ('bfm', 'bits', 'offset'), ('u2u32', 'insert'), ('u2u32', 'base')))
 *    ('bitfield_insert', 'base@8', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 7, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base@16', 'insert', 'offset', 'bits') => ('bitfield_select', ('u2u16', ('bfm', 'bits', 'offset')), ('ishl', 'insert', 'offset'), 'base')
 *    ('bitfield_insert', 'base@16', 'insert', 'offset', 'bits') => ('u2u16', ('bfi', ('bfm', 'bits', 'offset'), ('u2u32', 'insert'), ('u2u32', 'base')))
 *    ('bitfield_insert', 'base@16', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 15, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base@32', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 31, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bitfield_insert', 'base@64', 'insert', 'offset', 'bits') => ('bcsel', ('ult', 63, 'bits'), 'insert', ('ior', ('iand', 'base', ('inot', ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))), ('iand', ('ishl', 'insert', 'offset'), ('ishl', ('isub', ('ishl', 1, 'bits'), 1), 'offset'))))
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@8', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@8', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@16', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@16', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@32', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@32', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ult', 'a', 'b'), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('uge', 'a', 'b'), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ieq', ('usub_borrow', 'a', 'b'), 0), ('iadd@64', 'a', ('ineg', 'b')), 0) => ('usub_sat', 'a', 'b')
 *    ('bcsel', ('ine', ('usub_borrow', 'a', 'b'), 0), 0, ('iadd@64', 'a', ('ineg', 'b'))) => ('usub_sat', 'a', 'b')
 *    ('iadd_sat@8', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 127, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 128, ('iadd', 'a', 'b')))
 *    ('isub_sat@8', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 127, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 128, ('isub', 'a', 'b')))
 *    ('iadd_sat@16', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 32767, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 32768, ('iadd', 'a', 'b')))
 *    ('isub_sat@16', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 32767, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 32768, ('isub', 'a', 'b')))
 *    ('iadd_sat@32', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 2147483647, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 2147483648, ('iadd', 'a', 'b')))
 *    ('isub_sat@32', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 2147483647, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 2147483648, ('isub', 'a', 'b')))
 *    ('iadd_sat@64', 'a', 'b') => ('bcsel', ('ige', 'b', 1), ('bcsel', ('ilt', ('iadd', 'a', 'b'), 'a'), 9223372036854775807, ('iadd', 'a', 'b')), ('bcsel', ('ilt', 'a', ('iadd', 'a', 'b')), 9223372036854775808, ('iadd', 'a', 'b')))
 *    ('isub_sat@64', 'a', 'b') => ('bcsel', ('ilt', 'b', 0), ('bcsel', ('ilt', ('isub', 'a', 'b'), 'a'), 9223372036854775807, ('isub', 'a', 'b')), ('bcsel', ('ilt', 'a', ('isub', 'a', 'b')), 9223372036854775808, ('isub', 'a', 'b')))
 *    ('inot', ('ior(is_used_once)', ('feq(is_used_once)', 'a', 'b'), ('feq(is_used_once)', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq(is_used_once)', 'a', 'b'), ('feq(is_used_once)', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('fneu', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('feq(is_used_once)', 'a', 'b'), ('fneu(is_used_once)', 'c', 'd'))) => ('iand', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('feq(is_used_once)', 'a', 'b'), ('fneu(is_used_once)', 'c', 'd'))) => ('ior', ('fneu', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('ior(is_used_once)', ('fneu(is_used_once)', 'a', 'b'), ('fneu(is_used_once)', 'c', 'd'))) => ('iand', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('inot', ('iand(is_used_once)', ('fneu(is_used_once)', 'a', 'b'), ('fneu(is_used_once)', 'c', 'd'))) => ('ior', ('feq', 'a', 'b'), ('feq', 'c', 'd'))
 *    ('f2f', ('b2f', 'a')) => ('b2f', 'a')
 *    ('f2u', ('b2f', 'a')) => ('b2i', 'a')
 *    ('f2i', ('b2f', 'a')) => ('b2i', 'a')
 *    ('u2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('u2u', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2f', ('b2i', 'a')) => ('b2f', 'a')
 *    ('i2i', ('b2i', 'a')) => ('b2i', 'a')
 *    ('i2i1', 'a@1') => a
 *    ('i2i8', 'a@8') => a
 *    ('i2i16', 'a@16') => a
 *    ('i2i32', 'a@32') => a
 *    ('i2i64', 'a@64') => a
 *    ('u2u1', 'a@1') => a
 *    ('u2u8', 'a@8') => a
 *    ('u2u16', 'a@16') => a
 *    ('u2u32', 'a@32') => a
 *    ('u2u64', 'a@64') => a
 *    ('f2f16', 'a@16') => a
 *    ('f2f32', 'a@32') => a
 *    ('f2f64', 'a@64') => a
 *    ('b2b1', 'a@1') => a
 *    ('b2b8', 'a@8') => a
 *    ('b2b16', 'a@16') => a
 *    ('b2b32', 'a@32') => a
 *    ('i2i1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i8', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u8', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i16', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u16', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i32', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u32', 'a')) => ('u2u1', 'a')
 *    ('i2i1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('i2i1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('u2u1', ('i2i64', 'a')) => ('i2i1', 'a')
 *    ('u2u1', ('u2u64', 'a')) => ('u2u1', 'a')
 *    ('i2i8', ('i2i1', 'a@1')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u1', 'a@1')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i16', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u16', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i32', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u32', 'a')) => ('u2u8', 'a')
 *    ('i2i8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('i2i8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('u2u8', ('i2i64', 'a')) => ('i2i8', 'a')
 *    ('u2u8', ('u2u64', 'a')) => ('u2u8', 'a')
 *    ('i2i16', ('i2i1', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u1', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@1')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@1')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i8', 'a@8')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u8', 'a@8')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i32', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u32', 'a')) => ('u2u16', 'a')
 *    ('i2i16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('i2i16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('u2u16', ('i2i64', 'a')) => ('i2i16', 'a')
 *    ('u2u16', ('u2u64', 'a')) => ('u2u16', 'a')
 *    ('i2i32', ('i2i1', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u1', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i8', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u8', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@1')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@1')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@8')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@8')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i16', 'a@16')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u16', 'a@16')) => ('u2u32', 'a')
 *    ('i2i32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('i2i32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('u2u32', ('i2i64', 'a')) => ('i2i32', 'a')
 *    ('u2u32', ('u2u64', 'a')) => ('u2u32', 'a')
 *    ('i2i64', ('i2i1', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u1', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i8', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u8', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i16', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u16', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@1')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@1')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@8')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@8')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@16')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@16')) => ('u2u64', 'a')
 *    ('i2i64', ('i2i32', 'a@32')) => ('i2i64', 'a')
 *    ('u2u64', ('u2u32', 'a@32')) => ('u2u64', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i8', ('pack_64_2x32_split', 'a', 'b')) => ('i2i8', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i16', ('pack_64_2x32_split', 'a', 'b')) => ('i2i16', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('i2i32', ('pack_64_2x32_split', 'a', 'b')) => ('i2i32', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u8', ('pack_64_2x32_split', 'a', 'b')) => ('u2u8', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u16', ('pack_64_2x32_split', 'a', 'b')) => ('u2u16', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('u2u32', ('pack_64_2x32_split', 'a', 'b')) => ('u2u32', 'a')
 *    ('ieq', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i16', 'a@8'), ('i2i16', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i16', 'b@8'), ('i2i16', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i16', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i16', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i16', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i16', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i16', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i32', 'a@8'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i32', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i8', 'b'))
 *    ('ine', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i8', 'b'))
 *    ('ilt', ('i2i64', 'a@8'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i8', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ige', ('i2i8', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@8')) => ('ilt', ('i2i8', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('i2i8', 'b')), ('ieq', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('i2i8', 'b')), ('ine', ('i2i64', ('i2i8', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@8'), '#b') => ('iand', ('ilt', -128, 'b'), ('ior', ('ilt', 127, 'b'), ('ilt', 'a', ('i2i8', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@8')) => ('iand', ('ilt', 'a', 127), ('ior', ('ilt', 'a', -128), ('ilt', ('i2i8', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@8'), '#b') => ('iand', ('ige', 127, 'b'), ('ior', ('ige', -128, 'b'), ('ige', 'a', ('i2i8', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@8')) => ('iand', ('ige', 'a', -128), ('ior', ('ige', 'a', 127), ('ige', ('i2i8', 'a'), 'b')))
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@8'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i32', 'a@16'), ('i2i32', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i32', 'b@16'), ('i2i32', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i32', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i32', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i32', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i32', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i32', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i16', 'b'))
 *    ('ine', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i16', 'b'))
 *    ('ilt', ('i2i64', 'a@16'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i16', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ige', ('i2i16', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@16')) => ('ilt', ('i2i16', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('i2i16', 'b')), ('ieq', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('i2i16', 'b')), ('ine', ('i2i64', ('i2i16', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@16'), '#b') => ('iand', ('ilt', -32768, 'b'), ('ior', ('ilt', 32767, 'b'), ('ilt', 'a', ('i2i16', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@16')) => ('iand', ('ilt', 'a', 32767), ('ior', ('ilt', 'a', -32768), ('ilt', ('i2i16', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@16'), '#b') => ('iand', ('ige', 32767, 'b'), ('ior', ('ige', -32768, 'b'), ('ige', 'a', ('i2i16', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@16')) => ('iand', ('ige', 'a', -32768), ('ior', ('ige', 'a', 32767), ('ige', ('i2i16', 'a'), 'b')))
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@8')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@8'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@16')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@16'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ieq', 'a', ('i2i32', 'b'))
 *    ('ine', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ine', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ige', 'a', ('i2i32', 'b'))
 *    ('ilt', ('i2i64', 'a@32'), ('i2i64', 'b@32')) => ('ilt', 'a', ('i2i32', 'b'))
 *    ('ige', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ige', ('i2i32', 'b'), 'a')
 *    ('ilt', ('i2i64', 'b@32'), ('i2i64', 'a@32')) => ('ilt', ('i2i32', 'b'), 'a')
 *    ('ieq', ('i2i64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('i2i32', 'b')), ('ieq', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ine', ('i2i64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('i2i32', 'b')), ('ine', ('i2i64', ('i2i32', 'b')), 'b'))
 *    ('ilt', ('i2i64', 'a@32'), '#b') => ('iand', ('ilt', -2147483648, 'b'), ('ior', ('ilt', 2147483647, 'b'), ('ilt', 'a', ('i2i32', 'b'))))
 *    ('ilt', '#a', ('i2i64', 'b@32')) => ('iand', ('ilt', 'a', 2147483647), ('ior', ('ilt', 'a', -2147483648), ('ilt', ('i2i32', 'a'), 'b')))
 *    ('ige', ('i2i64', 'a@32'), '#b') => ('iand', ('ige', 2147483647, 'b'), ('ior', ('ige', -2147483648, 'b'), ('ige', 'a', ('i2i32', 'b'))))
 *    ('ige', '#a', ('i2i64', 'b@32')) => ('iand', ('ige', 'a', -2147483648), ('ior', ('ige', 'a', 2147483647), ('ige', ('i2i32', 'a'), 'b')))
 *    ('ieq', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u16', 'a@8'), ('u2u16', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u16', 'b@8'), ('u2u16', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u16', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u16', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u16', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u16', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u16', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u16', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u16', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u32', 'a@8'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u32', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u8', 'b'))
 *    ('ine', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u8', 'b'))
 *    ('ult', ('u2u64', 'a@8'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u8', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('uge', ('u2u8', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@8')) => ('ult', ('u2u8', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@8'), '#b') => ('iand', ('ieq', 'a', ('u2u8', 'b')), ('ieq', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@8'), '#b') => ('ior', ('ine', 'a', ('u2u8', 'b')), ('ine', ('u2u64', ('u2u8', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@8'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 255, 'b'), ('ult', 'a', ('u2u8', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@8')) => ('iand', ('ult', 'a', 255), ('ior', ('ult', 'a', 0), ('ult', ('u2u8', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@8'), '#b') => ('iand', ('uge', 255, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u8', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@8')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 255), ('uge', ('u2u8', 'a'), 'b')))
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@8'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u32', 'a@16'), ('u2u32', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u32', 'b@16'), ('u2u32', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u32', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u32', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u32', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u32', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u32', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u32', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u32', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u16', 'b'))
 *    ('ine', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u16', 'b'))
 *    ('ult', ('u2u64', 'a@16'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u16', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('uge', ('u2u16', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@16')) => ('ult', ('u2u16', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@16'), '#b') => ('iand', ('ieq', 'a', ('u2u16', 'b')), ('ieq', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@16'), '#b') => ('ior', ('ine', 'a', ('u2u16', 'b')), ('ine', ('u2u64', ('u2u16', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@16'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 65535, 'b'), ('ult', 'a', ('u2u16', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@16')) => ('iand', ('ult', 'a', 65535), ('ior', ('ult', 'a', 0), ('ult', ('u2u16', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@16'), '#b') => ('iand', ('uge', 65535, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u16', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@16')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 65535), ('uge', ('u2u16', 'a'), 'b')))
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@8')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@8'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@16')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@16'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ieq', 'a', ('u2u32', 'b'))
 *    ('ine', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ine', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('uge', 'a', ('u2u32', 'b'))
 *    ('ult', ('u2u64', 'a@32'), ('u2u64', 'b@32')) => ('ult', 'a', ('u2u32', 'b'))
 *    ('uge', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('uge', ('u2u32', 'b'), 'a')
 *    ('ult', ('u2u64', 'b@32'), ('u2u64', 'a@32')) => ('ult', ('u2u32', 'b'), 'a')
 *    ('ieq', ('u2u64', 'a@32'), '#b') => ('iand', ('ieq', 'a', ('u2u32', 'b')), ('ieq', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ine', ('u2u64', 'a@32'), '#b') => ('ior', ('ine', 'a', ('u2u32', 'b')), ('ine', ('u2u64', ('u2u32', 'b')), 'b'))
 *    ('ult', ('u2u64', 'a@32'), '#b') => ('iand', ('ult', 0, 'b'), ('ior', ('ult', 4294967295, 'b'), ('ult', 'a', ('u2u32', 'b'))))
 *    ('ult', '#a', ('u2u64', 'b@32')) => ('iand', ('ult', 'a', 4294967295), ('ior', ('ult', 'a', 0), ('ult', ('u2u32', 'a'), 'b')))
 *    ('uge', ('u2u64', 'a@32'), '#b') => ('iand', ('uge', 4294967295, 'b'), ('ior', ('uge', 0, 'b'), ('uge', 'a', ('u2u32', 'b'))))
 *    ('uge', '#a', ('u2u64', 'b@32')) => ('iand', ('uge', 'a', 0), ('ior', ('uge', 'a', 4294967295), ('uge', ('u2u32', 'a'), 'b')))
 *    ('feq', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f32', 'a@16'), ('f2f32', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f32', 'b@16'), ('f2f32', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f16', 'b'))
 *    ('fneu', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f16', 'b'))
 *    ('flt', ('f2f64', 'a@16'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f16', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('fge', ('f2f16', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@16')) => ('flt', ('f2f16', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@16')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@16'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('feq', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('feq', 'a', ('f2f32', 'b'))
 *    ('fneu', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fneu', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('fge', 'a', ('f2f32', 'b'))
 *    ('flt', ('f2f64', 'a@32'), ('f2f64', 'b@32')) => ('flt', 'a', ('f2f32', 'b'))
 *    ('fge', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('fge', ('f2f32', 'b'), 'a')
 *    ('flt', ('f2f64', 'b@32'), ('f2f64', 'a@32')) => ('flt', ('f2f32', 'b'), 'a')
 *    ('i2i32', ('iand', 'a@64', 4294967295)) => ('u2u32', 'a')
 *    ('i2i16', ('iand', 'a@32', 65535)) => ('u2u16', 'a')
 *    ('i2i16', ('iand', 'a@64', 65535)) => ('u2u16', 'a')
 *    ('i2i8', ('iand', 'a@16', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@32', 255)) => ('u2u8', 'a')
 *    ('i2i8', ('iand', 'a@64', 255)) => ('u2u8', 'a')
 *    ('f2f16', ('fmax(is_used_once)', 'a', '#b')) => ('fmax', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2f16', ('fmin(is_used_once)', 'a', '#b')) => ('fmin', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2f16', ('vec2(is_used_once)', ('fmax(is_used_once)', 'a', '#b'), ('fmax(is_used_once)', 'c', '#d'))) => ('fmax', ('f2f16', ('vec2', 'a', 'c')), ('f2f16', ('vec2', 'b', 'd')))
 *    ('f2f16', ('vec2(is_used_once)', ('fmin(is_used_once)', 'a', '#b'), ('fmin(is_used_once)', 'c', '#d'))) => ('fmin', ('f2f16', ('vec2', 'a', 'c')), ('f2f16', ('vec2', 'b', 'd')))
 *    ('pack_half_2x16_rtz_split', ('fmax(is_used_once)', 'a', '#b'), ('fmax(is_used_once)', 'c', '#d')) => ('pack_32_2x16', ('fmax', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'a', 'c')), ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'b', 'd'))))
 *    ('pack_half_2x16_rtz_split', ('fmin(is_used_once)', 'a', '#b'), ('fmin(is_used_once)', 'c', '#d')) => ('pack_32_2x16', ('fmin', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'a', 'c')), ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'b', 'd'))))
 *    ('pack_half_2x16_rtz_split', ('fneg(is_used_once)', ('fmax(is_used_once)', 'a', '#b')), ('fneg(is_used_once)', ('fmax(is_used_once)', 'c', '#d'))) => ('pack_32_2x16', ('fmin', ('fneg', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'a', 'c'))), ('fneg', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'b', 'd')))))
 *    ('pack_half_2x16_rtz_split', ('fneg(is_used_once)', ('fmin(is_used_once)', 'a', '#b')), ('fneg(is_used_once)', ('fmin(is_used_once)', 'c', '#d'))) => ('pack_32_2x16', ('fmax', ('fneg', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'a', 'c'))), ('fneg', ('unpack_32_2x16', ('pack_half_2x16_rtz_split', 'b', 'd')))))
 *    ('pack_half_2x16_rtz_split', ('bcsel(is_used_once)', 'a', 'b', '#c'), ('bcsel(is_used_once)', 'a', 'd', '#e')) => ('bcsel', 'a', ('pack_half_2x16_rtz_split', 'b', 'd'), ('pack_half_2x16_rtz_split', 'c', 'e'))
 *    ('pack_half_2x16_rtz_split', ('bcsel(is_used_once)', 'a', '#b', 'c'), ('bcsel(is_used_once)', 'a', '#d', 'e')) => ('bcsel', 'a', ('pack_half_2x16_rtz_split', 'b', 'd'), ('pack_half_2x16_rtz_split', 'c', 'e'))
 *    ('pack_half_2x16_rtz_split', ('b2f', 'a@1'), ('b2f', 'a')) => ('bcsel', 'a', 1006648320, 0)
 *    ('u2u16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i16(only_lower_8_bits_used)', ('u2u8', 'a@16')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@16', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('u2u8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i16', ('i2i8', 'a@16')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@16', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('u2u8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i16', ('i2i8', 'a@16')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@16', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_u8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('u2u32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_u8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('u2u32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_u8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_8_bits_used)', ('u2u8', 'a@32')) => a
 *    ('extract_i8(only_lower_8_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('u2u8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('i2i32', ('i2i8', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_8_bits_used)', 'c', ('extract_i8', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('u2u8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('i2i32', ('i2i8', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_8_bits_used)', ('extract_i8', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('u2u32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_u16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('u2u32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_u16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('u2u32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_u16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('i2i32(only_lower_16_bits_used)', ('u2u16', 'a@32')) => a
 *    ('extract_i16(only_lower_16_bits_used)', 'a@32', 0) => a
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('u2u16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('i2i32', ('i2i16', 'a@32')), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('bcsel(only_lower_16_bits_used)', 'c', ('extract_i16', 'a@32', 0), 'b') => ('bcsel', 'c', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iadd', 'a', 'b')
 *    ('iadd(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iadd', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('imul', 'a', 'b')
 *    ('imul(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('imul', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('iand', 'a', 'b')
 *    ('iand(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('iand', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ior', 'a', 'b')
 *    ('ior(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ior', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('u2u16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('i2i32', ('i2i16', 'a@32')), 'b') => ('ixor', 'a', 'b')
 *    ('ixor(only_lower_16_bits_used)', ('extract_i16', 'a@32', 0), 'b') => ('ixor', 'a', 'b')
 *    ('ldexp@16', 'x', 'exp') => ('!fmul', ('!fmul', 'x', ('i2i16', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -30), 30), 1), 15), 10))), ('i2i16', ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -30), 30), ('ishr', ('imin', ('imax', 'exp', -30), 30), 1)), 15), 10)))
 *    ('ldexp@32', 'x', 'exp') => ('!fmul', ('!fmul', 'x', ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -254), 254), 1), 127), 23)), ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -254), 254), ('ishr', ('imin', ('imax', 'exp', -254), 254), 1)), 127), 23))
 *    ('ldexp@64', 'x', 'exp') => ('!fmul', ('!fmul', 'x', ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1), 1023), 20))), ('pack_64_2x32_split', 0, ('ishl', ('iadd', ('isub', ('imin', ('imax', 'exp', -2046), 2046), ('ishr', ('imin', ('imax', 'exp', -2046), 2046), 1)), 1023), 20)))
 *    ('iadd(many-comm-expr)', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('iadd', ('iand', ('ishl', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('iadd', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 1431655765), 1), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 858993459), 2), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 252645135), 4), ('ushr', ('iand', ('ior', ('ishl', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 16711935), 8), ('ushr', ('iand', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 4278255360), 8)), 4042322160), 4)), 3435973836), 2)), 2863311530), 1)) => ('bitfield_reverse', 'x')
 *    ('ior(many-comm-expr)', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 4278255360), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 4042322160), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 3435973836), ('iand', ('ushr', ('ior', ('iand', ('ishl', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 2863311530), ('iand', ('ushr', ('ior', ('ishl', 'x@32', 16), ('ushr', 'x@32', 16)), 1), 1431655765)), 2), 858993459)), 4), 252645135)), 8), 16711935)) => ('bitfield_reverse', 'x')
 *    ('bcsel', ('iand', ('fneu', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('fneu', 'x', 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0), 4294967295), ('pack_half_2x16_rtz_split', 'x(is_not_negative)', 0)) => ('pack_half_2x16_rtz_split', 'x', 0)
 *    ('bcsel', ('iand', ('fneu', ('fabs', 'x'), 2139095040), ('ieq', ('iand', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 32767), 31744)), ('iadd', ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0), 4294967295), ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)) => ('pack_half_2x16_rtz_split', ('fneg', 'x'), 0)
 *    ('iadd(many-comm-expr)', ('iadd', ('iadd', ('bcsel', ('ieq', ('extract_u8', 'a@32', 0), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 0), ('ineg', ('extract_u8', 'b@32', 0))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 1), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 1), ('ineg', ('extract_u8', 'b@32', 1)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 2), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 2), ('ineg', ('extract_u8', 'b@32', 2)))))), ('bcsel', ('ieq', ('extract_u8', 'a@32', 3), 0), 0, ('iabs', ('iadd', ('extract_u8', 'a@32', 3), ('ineg', ('extract_u8', 'b@32', 3)))))) => ('msad_4x8', 'a', 'b', 0)
 *    ('iadd', ('msad_4x8', 'a', 'b', 0), 'c') => ('msad_4x8', 'a', 'b', 'c')
 *    ('f2e4m3fn_sat', ('bcsel', ('feq', ('fabs', 'a'), inf), '#b(is_nan)', 'a')) => ('f2e4m3fn_satfn', 'a')
 *    ('f2e4m3fn_sat', ('bcsel', ('feq', 'a(is_not_negative)', inf), '#b(is_nan)', 'a')) => ('f2e4m3fn_satfn', 'a')
 *    ('f2e4m3fn_sat', ('bcsel', ('feq', 'a(is_not_positive)', -inf), '#b(is_nan)', 'a')) => ('f2e4m3fn_satfn', 'a')
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', ('fabs', 'a'), inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', ('fabs', 'c'), inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', ('fabs', 'a'), inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_negative)', inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', ('fabs', 'a'), inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_positive)', -inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_negative)', inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', ('fabs', 'c'), inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_negative)', inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_negative)', inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_negative)', inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_positive)', -inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_positive)', -inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', ('fabs', 'c'), inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_positive)', -inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_negative)', inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('f2e4m3fn_sat', ('vec2', ('bcsel', ('feq', 'a(is_not_positive)', -inf), '#b(is_nan)', 'a'), ('bcsel', ('feq', 'c(is_not_positive)', -inf), '#d(is_nan)', 'c'))) => ('f2e4m3fn_satfn', ('vec2', 'a', 'c'))
 *    ('ball_iequal2', ('ieq', 'a', 'b'), -1) => ('ball_iequal2', 'a', 'b')
 *    ('ball_iequal2', ('feq', 'a', 'b'), -1) => ('ball_fequal2', 'a', 'b')
 *    ('bany_inequal2', ('ine', 'a', 'b'), 0) => ('bany_inequal2', 'a', 'b')
 *    ('bany_inequal2', ('fneu', 'a', 'b'), 0) => ('bany_fnequal2', 'a', 'b')
 *    ('ball_iequal3', ('ieq', 'a', 'b'), -1) => ('ball_iequal3', 'a', 'b')
 *    ('ball_iequal3', ('feq', 'a', 'b'), -1) => ('ball_fequal3', 'a', 'b')
 *    ('bany_inequal3', ('ine', 'a', 'b'), 0) => ('bany_inequal3', 'a', 'b')
 *    ('bany_inequal3', ('fneu', 'a', 'b'), 0) => ('bany_fnequal3', 'a', 'b')
 *    ('ball_iequal4', ('ieq', 'a', 'b'), -1) => ('ball_iequal4', 'a', 'b')
 *    ('ball_iequal4', ('feq', 'a', 'b'), -1) => ('ball_fequal4', 'a', 'b')
 *    ('bany_inequal4', ('ine', 'a', 'b'), 0) => ('bany_inequal4', 'a', 'b')
 *    ('bany_inequal4', ('fneu', 'a', 'b'), 0) => ('bany_fnequal4', 'a', 'b')
 *    ('ball_iequal8', ('ieq', 'a', 'b'), -1) => ('ball_iequal8', 'a', 'b')
 *    ('ball_iequal8', ('feq', 'a', 'b'), -1) => ('ball_fequal8', 'a', 'b')
 *    ('bany_inequal8', ('ine', 'a', 'b'), 0) => ('bany_inequal8', 'a', 'b')
 *    ('bany_inequal8', ('fneu', 'a', 'b'), 0) => ('bany_fnequal8', 'a', 'b')
 *    ('ball_iequal16', ('ieq', 'a', 'b'), -1) => ('ball_iequal16', 'a', 'b')
 *    ('ball_iequal16', ('feq', 'a', 'b'), -1) => ('ball_fequal16', 'a', 'b')
 *    ('bany_inequal16', ('ine', 'a', 'b'), 0) => ('bany_inequal16', 'a', 'b')
 *    ('bany_inequal16', ('fneu', 'a', 'b'), 0) => ('bany_fnequal16', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'a', 'b')) => ('!flt', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('flt', 'b', 'a')) => ('!flt', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'a', 'b')) => ('!fge', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('fge', 'b', 'a')) => ('!fge', 'b', 'a')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'a', 'b')) => ('!feq', 'a', 'b')
 *    ('iand', ('feq', 'a', 'a'), ('feq', 'b', 'a')) => ('!feq', 'b', 'a')
 *    ('feq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd'))
 *    ('fneu', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd'))
 *    ('ieq', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd'))
 *    ('ine', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd'))
 *    ('flt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd'))
 *    ('flt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c'))
 *    ('fge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd'))
 *    ('fge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c'))
 *    ('ilt', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd'))
 *    ('ilt', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c'))
 *    ('ige', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd'))
 *    ('ige', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c'))
 *    ('ult', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd'))
 *    ('ult', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c'))
 *    ('uge', ('bcsel', 'a', '#b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd'))
 *    ('uge', '#d', ('bcsel', 'a', '#b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c'))
 *    ('fadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fadd', 'b', 'd'), ('fadd', 'c', 'd'))
 *    ('fmul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmul', 'b', 'd'), ('fmul', 'c', 'd'))
 *    ('fmulz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fmulz', 'b', 'd'), ('fmulz', 'c', 'd'))
 *    ('iadd', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('iadd', 'b', 'd'), ('iadd', 'c', 'd'))
 *    ('imul', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('imul', 'b', 'd'), ('imul', 'c', 'd'))
 *    ('umul_16x16', '#a(is_lower_half_zero)', 'b') => 0
 *    ('imadsh_mix16', '#a@32(is_lower_half_zero)', 'b@32', 'c@32') => c
 *    ('imadsh_mix16', 'a@32', '#b@32(is_upper_half_zero)', 'c@32') => c
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'c', 'e')) => ('flrp', 'b', 'c', ('bcsel', 'a', 'd', 'e'))
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'b', 'e', 'd')) => ('flrp', 'b', ('bcsel', 'a', 'c', 'e'), 'd')
 *    ('bcsel', 'a', ('flrp(is_used_once)', 'b', 'c', 'd'), ('flrp', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('flrp', 'b', 'c', 'd'), ('flrp(is_used_once)', 'e', 'c', 'd')) => ('flrp', ('bcsel', 'a', 'b', 'e'), 'c', 'd')
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz(is_used_once)', 'b', 'c(is_not_const)'), ('fmulz', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c(is_not_const)'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmulz', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd(is_not_const)')) => ('fmulz', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul(is_used_once)', 'b', 'c(is_not_const)'), ('fmul', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c(is_not_const)'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmul', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd(is_not_const)')) => ('fmul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c'), ('iadd', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd(is_used_once)', 'b', 'c(is_not_const)'), ('iadd', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c(is_not_const)'), ('iadd(is_used_once)', 'b', 'd')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iadd', 'b', 'c'), ('iadd(is_used_once)', 'b', 'd(is_not_const)')) => ('iadd', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c'), ('imul', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul(is_used_once)', 'b', 'c(is_not_const)'), ('imul', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c(is_not_const)'), ('imul(is_used_once)', 'b', 'd')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imul', 'b', 'c'), ('imul(is_used_once)', 'b', 'd(is_not_const)')) => ('imul', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c'), ('iand', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand(is_used_once)', 'b', 'c(is_not_const)'), ('iand', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c(is_not_const)'), ('iand(is_used_once)', 'b', 'd')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('iand', 'b', 'c'), ('iand(is_used_once)', 'b', 'd(is_not_const)')) => ('iand', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c'), ('ior', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior(is_used_once)', 'b', 'c(is_not_const)'), ('ior', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c(is_not_const)'), ('ior(is_used_once)', 'b', 'd')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ior', 'b', 'c'), ('ior(is_used_once)', 'b', 'd(is_not_const)')) => ('ior', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c'), ('ixor', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor(is_used_once)', 'b', 'c(is_not_const)'), ('ixor', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c(is_not_const)'), ('ixor(is_used_once)', 'b', 'd')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('ixor', 'b', 'c'), ('ixor(is_used_once)', 'b', 'd(is_not_const)')) => ('ixor', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c'), ('fmin', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin(is_used_once)', 'b', 'c(is_not_const)'), ('fmin', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c(is_not_const)'), ('fmin(is_used_once)', 'b', 'd')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmin', 'b', 'c'), ('fmin(is_used_once)', 'b', 'd(is_not_const)')) => ('fmin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c'), ('fmax', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax(is_used_once)', 'b', 'c(is_not_const)'), ('fmax', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c(is_not_const)'), ('fmax(is_used_once)', 'b', 'd')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fmax', 'b', 'c'), ('fmax(is_used_once)', 'b', 'd(is_not_const)')) => ('fmax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c'), ('imin', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin(is_used_once)', 'b', 'c(is_not_const)'), ('imin', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c(is_not_const)'), ('imin(is_used_once)', 'b', 'd')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imin', 'b', 'c'), ('imin(is_used_once)', 'b', 'd(is_not_const)')) => ('imin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c'), ('imax', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax(is_used_once)', 'b', 'c(is_not_const)'), ('imax', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c(is_not_const)'), ('imax(is_used_once)', 'b', 'd')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('imax', 'b', 'c'), ('imax(is_used_once)', 'b', 'd(is_not_const)')) => ('imax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c'), ('umin', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin(is_used_once)', 'b', 'c(is_not_const)'), ('umin', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c(is_not_const)'), ('umin(is_used_once)', 'b', 'd')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umin', 'b', 'c'), ('umin(is_used_once)', 'b', 'd(is_not_const)')) => ('umin', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c'), ('umax', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax(is_used_once)', 'b', 'c(is_not_const)'), ('umax', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c(is_not_const)'), ('umax(is_used_once)', 'b', 'd')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('umax', 'b', 'c'), ('umax(is_used_once)', 'b', 'd(is_not_const)')) => ('umax', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'b', 'd')) => ('fpow', 'b', ('bcsel', 'a', 'c', 'd'))
 *    ('bcsel', 'a', ('fpow(is_used_once)', 'b', 'c'), ('fpow', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'a', ('fpow', 'b', 'c'), ('fpow(is_used_once)', 'd', 'c')) => ('fpow', ('bcsel', 'a', 'b', 'd'), 'c')
 *    ('bcsel', 'c', ('frcp(is_used_once)', 'a'), ('frcp(is_used_once)', 'b')) => ('frcp', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('frsq(is_used_once)', 'a'), ('frsq(is_used_once)', 'b')) => ('frsq', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsqrt(is_used_once)', 'a'), ('fsqrt(is_used_once)', 'b')) => ('fsqrt', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fexp2(is_used_once)', 'a'), ('fexp2(is_used_once)', 'b')) => ('fexp2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('flog2(is_used_once)', 'a'), ('flog2(is_used_once)', 'b')) => ('flog2', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin(is_used_once)', 'a'), ('fsin(is_used_once)', 'b')) => ('fsin', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos(is_used_once)', 'a'), ('fcos(is_used_once)', 'b')) => ('fcos', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_amd(is_used_once)', 'a'), ('fsin_amd(is_used_once)', 'b')) => ('fsin_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_amd(is_used_once)', 'a'), ('fcos_amd(is_used_once)', 'b')) => ('fcos_amd', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_mdg(is_used_once)', 'a'), ('fsin_mdg(is_used_once)', 'b')) => ('fsin_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fcos_mdg(is_used_once)', 'a'), ('fcos_mdg(is_used_once)', 'b')) => ('fcos_mdg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsin_agx(is_used_once)', 'a'), ('fsin_agx(is_used_once)', 'b')) => ('fsin_agx', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fneg(is_used_once)', 'a'), ('fneg(is_used_once)', 'b')) => ('fneg', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fabs(is_used_once)', 'a'), ('fabs(is_used_once)', 'b')) => ('fabs', ('bcsel', 'c', 'a', 'b'))
 *    ('bcsel', 'c', ('fsign(is_used_once)', 'a'), ('fsign(is_used_once)', 'b')) => ('fsign', ('bcsel', 'c', 'a', 'b'))
 *    ('ineg', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('ineg', 'a'), ('ineg', 'b'))
 *    ('iabs', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('iabs', 'a'), ('iabs', 'b'))
 *    ('inot', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('inot', 'a'), ('inot', 'b'))
 *    ('isign', ('bcsel', 'c', '#a', '#b')) => ('bcsel', 'c', ('isign', 'a'), ('isign', 'b'))
 *    ('fisnormal', 'a@16') => ('ult', 4095, ('iadd', ('ishl', 'a', 1), 2048))
 *    ('fisnormal', 'a@32') => ('ult', 33554431, ('iadd', ('ishl', 'a', 1), 16777216))
 *    ('fisnormal', 'a@64') => ('ult', 18014398509481983, ('iadd', ('ishl', 'a', 1), 9007199254740992))
 *    ('fquantize2f16', 'a@32') => ('bcsel', ('!flt', ('!fabs', 'a'), 6.103515625e-05), ('iand', 'a', 2147483648), ('!f2f32', ('!f2f16_rtne', 'a')))
 *    ('bfi', 4294967295, 'a', '#b') => ('iadd', ('ishl', 'a', 0), ('iand', 'b', -4294967296))
 *    ('bfi', 8589934590, 'a', '#b') => ('iadd', ('ishl', 'a', 1), ('iand', 'b', -8589934591))
 *    ('bfi', 17179869180, 'a', '#b') => ('iadd', ('ishl', 'a', 2), ('iand', 'b', -17179869181))
 *    ('bfi', 34359738360, 'a', '#b') => ('iadd', ('ishl', 'a', 3), ('iand', 'b', -34359738361))
 *    ('bfi', 68719476720, 'a', '#b') => ('iadd', ('ishl', 'a', 4), ('iand', 'b', -68719476721))
 *    ('bfi', 137438953440, 'a', '#b') => ('iadd', ('ishl', 'a', 5), ('iand', 'b', -137438953441))
 *    ('bfi', 274877906880, 'a', '#b') => ('iadd', ('ishl', 'a', 6), ('iand', 'b', -274877906881))
 *    ('bfi', 549755813760, 'a', '#b') => ('iadd', ('ishl', 'a', 7), ('iand', 'b', -549755813761))
 *    ('bfi', 1099511627520, 'a', '#b') => ('iadd', ('ishl', 'a', 8), ('iand', 'b', -1099511627521))
 *    ('bfi', 2199023255040, 'a', '#b') => ('iadd', ('ishl', 'a', 9), ('iand', 'b', -2199023255041))
 *    ('bfi', 4398046510080, 'a', '#b') => ('iadd', ('ishl', 'a', 10), ('iand', 'b', -4398046510081))
 *    ('bfi', 8796093020160, 'a', '#b') => ('iadd', ('ishl', 'a', 11), ('iand', 'b', -8796093020161))
 *    ('bfi', 17592186040320, 'a', '#b') => ('iadd', ('ishl', 'a', 12), ('iand', 'b', -17592186040321))
 *    ('bfi', 35184372080640, 'a', '#b') => ('iadd', ('ishl', 'a', 13), ('iand', 'b', -35184372080641))
 *    ('bfi', 70368744161280, 'a', '#b') => ('iadd', ('ishl', 'a', 14), ('iand', 'b', -70368744161281))
 *    ('bfi', 140737488322560, 'a', '#b') => ('iadd', ('ishl', 'a', 15), ('iand', 'b', -140737488322561))
 *    ('bfi', 281474976645120, 'a', '#b') => ('iadd', ('ishl', 'a', 16), ('iand', 'b', -281474976645121))
 *    ('bfi', 562949953290240, 'a', '#b') => ('iadd', ('ishl', 'a', 17), ('iand', 'b', -562949953290241))
 *    ('bfi', 1125899906580480, 'a', '#b') => ('iadd', ('ishl', 'a', 18), ('iand', 'b', -1125899906580481))
 *    ('bfi', 2251799813160960, 'a', '#b') => ('iadd', ('ishl', 'a', 19), ('iand', 'b', -2251799813160961))
 *    ('bfi', 4503599626321920, 'a', '#b') => ('iadd', ('ishl', 'a', 20), ('iand', 'b', -4503599626321921))
 *    ('bfi', 9007199252643840, 'a', '#b') => ('iadd', ('ishl', 'a', 21), ('iand', 'b', -9007199252643841))
 *    ('bfi', 18014398505287680, 'a', '#b') => ('iadd', ('ishl', 'a', 22), ('iand', 'b', -18014398505287681))
 *    ('bfi', 36028797010575360, 'a', '#b') => ('iadd', ('ishl', 'a', 23), ('iand', 'b', -36028797010575361))
 *    ('bfi', 72057594021150720, 'a', '#b') => ('iadd', ('ishl', 'a', 24), ('iand', 'b', -72057594021150721))
 *    ('bfi', 144115188042301440, 'a', '#b') => ('iadd', ('ishl', 'a', 25), ('iand', 'b', -144115188042301441))
 *    ('bfi', 288230376084602880, 'a', '#b') => ('iadd', ('ishl', 'a', 26), ('iand', 'b', -288230376084602881))
 *    ('bfi', 576460752169205760, 'a', '#b') => ('iadd', ('ishl', 'a', 27), ('iand', 'b', -576460752169205761))
 *    ('bfi', 1152921504338411520, 'a', '#b') => ('iadd', ('ishl', 'a', 28), ('iand', 'b', -1152921504338411521))
 *    ('bfi', 2305843008676823040, 'a', '#b') => ('iadd', ('ishl', 'a', 29), ('iand', 'b', -2305843008676823041))
 *    ('bfi', 4611686017353646080, 'a', '#b') => ('iadd', ('ishl', 'a', 30), ('iand', 'b', -4611686017353646081))
 *    ('fadd', '#a(is_nan)', 'b') => nan
 *    ('fadd', 'a', '#b(is_nan)') => nan
 *    ('fdiv', '#a(is_nan)', 'b') => nan
 *    ('fdiv', 'a', '#b(is_nan)') => nan
 *    ('fmod', '#a(is_nan)', 'b') => nan
 *    ('fmod', 'a', '#b(is_nan)') => nan
 *    ('fmul', '#a(is_nan)', 'b') => nan
 *    ('fmul', 'a', '#b(is_nan)') => nan
 *    ('fpow', '#a(is_nan)', 'b') => nan
 *    ('fpow', 'a', '#b(is_nan)') => nan
 *    ('frem', '#a(is_nan)', 'b') => nan
 *    ('frem', 'a', '#b(is_nan)') => nan
 *    ('fsub', '#a(is_nan)', 'b') => nan
 *    ('fsub', 'a', '#b(is_nan)') => nan
 *    ('ffma', '#a(is_nan)', 'b', 'c') => nan
 *    ('ffma', 'a', '#b(is_nan)', 'c') => nan
 *    ('ffma', 'a', 'b', '#c(is_nan)') => nan
 *    ('flrp', '#a(is_nan)', 'b', 'c') => nan
 *    ('flrp', 'a', '#b(is_nan)', 'c') => nan
 *    ('flrp', 'a', 'b', '#c(is_nan)') => nan
 *    ('fmin', '#a(is_nan)', 'b') => b
 *    ('fmax', '#a(is_nan)', 'b') => b
 *    ('ldexp', '#a(is_nan)', 'b') => nan
 *    ('fdot2', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot3', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot4', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot5', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot8', '#a(is_any_comp_nan)', 'b') => nan
 *    ('fdot16', '#a(is_any_comp_nan)', 'b') => nan
 *    ('feq', '#a(is_nan)', 'b') => False
 *    ('feq', 'a', '#b(is_nan)') => False
 *    ('fge', '#a(is_nan)', 'b') => False
 *    ('fge', 'a', '#b(is_nan)') => False
 *    ('flt', '#a(is_nan)', 'b') => False
 *    ('flt', 'a', '#b(is_nan)') => False
 *    ('fneu', '#a(is_nan)', 'b') => True
 *    ('seq', '#a(is_nan)', 'b') => 0.0
 *    ('seq', 'a', '#b(is_nan)') => 0.0
 *    ('sge', '#a(is_nan)', 'b') => 0.0
 *    ('sge', 'a', '#b(is_nan)') => 0.0
 *    ('slt', '#a(is_nan)', 'b') => 0.0
 *    ('slt', 'a', '#b(is_nan)') => 0.0
 *    ('sne', '#a(is_nan)', 'b') => 1.0
 *    ('f2f16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2f16', 'a'), ('f2f16', 'b'))
 *    ('f2fmp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('f2fmp', 'a'), ('f2fmp', 'b'))
 *    ('u2u16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('u2u16', 'a'), ('u2u16', 'b'))
 *    ('i2i16', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2i16', 'a'), ('i2i16', 'b'))
 *    ('i2imp', ('vec2', 'a@32', 'b@32')) => ('vec2', ('i2imp', 'a'), ('i2imp', 'b'))
 *    ('f2f16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'))
 *    ('f2fmp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'))
 *    ('u2u16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'))
 *    ('i2i16', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'))
 *    ('i2imp', ('vec3', 'a@32', 'b@32', 'c@32')) => ('vec3', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'))
 *    ('f2f16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2f16', 'a'), ('f2f16', 'b'), ('f2f16', 'c'), ('f2f16', 'd'))
 *    ('f2fmp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('f2fmp', 'a'), ('f2fmp', 'b'), ('f2fmp', 'c'), ('f2fmp', 'd'))
 *    ('u2u16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('u2u16', 'a'), ('u2u16', 'b'), ('u2u16', 'c'), ('u2u16', 'd'))
 *    ('i2i16', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2i16', 'a'), ('i2i16', 'b'), ('i2i16', 'c'), ('i2i16', 'd'))
 *    ('i2imp', ('vec4', 'a@32', 'b@32', 'c@32', 'd@32')) => ('vec4', ('i2imp', 'a'), ('i2imp', 'b'), ('i2imp', 'c'), ('i2imp', 'd'))
 *    ('ieq', ('b2i', 'a@1'), 0) => ('inot', 'a')
 *    ('ieq', ('b2i', 'a@1'), 1) => a
 *    ('ine', ('b2i', 'a@1'), 0) => a
 *    ('ine', ('b2i', 'a@1'), 1) => ('inot', 'a')
 *    ('ieq', ('b2i', 'a@1'), '#b') => ('bcsel', ('ieq', 'b', 0), ('inot', 'a'), ('bcsel', ('ieq', 'b', 1), 'a', False))
 *    ('ine', ('b2i', 'a@1'), '#b') => ('bcsel', ('ieq', 'b', 0), 'a', ('bcsel', ('ieq', 'b', 1), ('inot', 'a'), True))
 *    ('feq', ('b2f', 'a@1'), 0.0) => ('inot', 'a')
 *    ('feq', ('b2f', 'a@1'), 1.0) => a
 *    ('fneu', ('b2f', 'a@1'), 0.0) => a
 *    ('fneu', ('b2f', 'a@1'), 1.0) => ('inot', 'a')
 *    ('feq', ('b2f', 'a@1'), '#b') => ('bcsel', ('feq', 'b', 0.0), ('inot', 'a'), ('bcsel', ('feq', 'b', 1.0), 'a', False))
 *    ('fneu', ('b2f', 'a@1'), '#b') => ('bcsel', ('feq', 'b', 0.0), 'a', ('bcsel', ('feq', 'b', 1.0), ('inot', 'a'), True))
 */


static const nir_search_value_union nir_opt_algebraic_values[] = {
   /* ('fgeu', 'a', 'b') => ('inot', ('flt', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fgeu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace0_0_0 -> 0 in the cache */
   /* replace0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 3 },
      -1,
   } },

   /* ('fltu', 'a', 'b') => ('inot', ('fge', 'a', 'b')) */
   /* search1_0 -> 0 in the cache */
   /* search1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fltu,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* replace1_0_0 -> 0 in the cache */
   /* replace1_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 6 },
      -1,
   } },

   /* ('fneo', 0.0, 'a') => ('flt', 0.0, ('fabs', 'a')) */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace2_0 -> 8 in the cache */
   /* replace2_1_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* ('fequ', 0.0, 'a') => ('inot', ('flt', 0.0, ('fabs', 'a'))) */
   /* search3_0 -> 8 in the cache */
   /* search3_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      0, 1,
      { 8, 9 },
      -1,
   } },

   /* replace3_0_0 -> 8 in the cache */
   /* replace3_0_1_0 -> 9 in the cache */
   /* replace3_0_1 -> 11 in the cache */
   /* replace3_0 -> 12 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 12 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_pos_power_of_two)') => ('ishl', 'a', ('find_lsb', 'b')) */
   /* search4_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      0,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 15 },
      -1,
   } },

   /* replace4_0 -> 0 in the cache */
   /* replace4_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_find_lsb,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('imul', 'a@8', 128) => ('ishl', 'a', 7) */
   { .variable = {
      { nir_search_value_variable, 8 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x80ull /* 128 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 19, 20 },
      -1,
   } },

   /* replace5_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7ull /* 7 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 19, 22 },
      -1,
   } },

   /* ('imul', 'a@16', 32768) => ('ishl', 'a', 15) */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x8000ull /* 32768 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 24, 25 },
      -1,
   } },

   /* replace6_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfull /* 15 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 24, 27 },
      -1,
   } },

   /* ('imul', 'a@32', 2147483648) => ('ishl', 'a', 31) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x80000000ull /* 2147483648 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 29, 30 },
      -1,
   } },

   /* replace7_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1full /* 31 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 32 },
      -1,
   } },

   /* ('imul', 'a@64', 9223372036854775808) => ('ishl', 'a', 63) */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x8000000000000000ull /* 9223372036854775808 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 34, 35 },
      -1,
   } },

   /* replace8_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3full /* 63 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 34, 37 },
      -1,
   } },

   /* ('imul', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('ishl', 'a', ('find_lsb', ('iabs', 'b')))) */
   /* search9_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 39 },
      -1,
   } },

   /* replace9_0_0 -> 0 in the cache */
   /* replace9_0_1_0_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_find_lsb,
      -1, 0,
      { 41 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 0, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 43 },
      -1,
   } },

   /* ('ishl', 'a', '#b') => ('imul', 'a', ('ishl', 1, 'b')) */
   /* search10_0 -> 9 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 9, 45 },
      -1,
   } },

   /* replace10_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 47, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 9, 49 },
      -1,
   } },

   /* ('imul@64', 'a', '#b(is_bitcount2)') => ('iadd', ('ishl', 'a', ('ufind_msb', 'b')), ('ishl', 'a', ('find_lsb', 'b'))) */
   /* search11_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      true,
      nir_type_invalid,
      2,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 34, 51 },
      -1,
   } },

   /* replace11_0_0 -> 34 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ufind_msb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 34, 54 },
      -1,
   } },
   /* replace11_1_0 -> 34 in the cache */
   /* replace11_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_find_lsb,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 34, 56 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 55, 57 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('imul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search12_0_0 -> 29 in the cache */
   /* search12_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 59 },
      -1,
   } },

   /* replace12_0 -> 29 in the cache */
   /* replace12_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('unpack_64_2x32_split_x', ('umul_2x32_64(is_used_once)', 'a', 'b')) => ('imul', 'a', 'b') */
   /* search13_0_0 -> 29 in the cache */
   /* search13_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_unpack_64_2x32_split_x,
      -1, 1,
      { 62 },
      -1,
   } },

   /* replace13_0 -> 29 in the cache */
   /* replace13_1 -> 48 in the cache */
   /* replace13 -> 61 in the cache */

   /* ('imul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('imul_high', 'a', 'b')) */
   /* search14_0 -> 29 in the cache */
   /* search14_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace14_0_0 -> 29 in the cache */
   /* replace14_0_1 -> 48 in the cache */
   /* replace14_0 -> 61 in the cache */
   /* replace14_1_0 -> 29 in the cache */
   /* replace14_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 65 },
      -1,
   } },

   /* ('umul_2x32_64', 'a', 'b') => ('pack_64_2x32_split', ('imul', 'a', 'b'), ('umul_high', 'a', 'b')) */
   /* search15_0 -> 29 in the cache */
   /* search15_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umul_2x32_64,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* replace15_0_0 -> 29 in the cache */
   /* replace15_0_1 -> 48 in the cache */
   /* replace15_0 -> 61 in the cache */
   /* replace15_1_0 -> 29 in the cache */
   /* replace15_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umul_high,
      1, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_pack_64_2x32_split,
      -1, 2,
      { 61, 68 },
      -1,
   } },

   /* ('udiv', 'a', 1) => a */
   /* search16_0 -> 9 in the cache */
   /* search16_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace16 -> 9 in the cache */

   /* ('idiv', 'a', 1) => a */
   /* search17_0 -> 9 in the cache */
   /* search17_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_idiv,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace17 -> 9 in the cache */

   /* ('umod', 'a', 1) => 0 */
   /* search18_0 -> 9 in the cache */
   /* search18_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },

   /* ('imod', 'a', 1) => 0 */
   /* search19_0 -> 9 in the cache */
   /* search19_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imod,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace19 -> 73 in the cache */

   /* ('imod', 'a', -1) => 0 */
   /* search20_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imod,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace20 -> 73 in the cache */

   /* ('irem', 'a', 1) => 0 */
   /* search21_0 -> 9 in the cache */
   /* search21_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_irem,
      -1, 0,
      { 9, 47 },
      -1,
   } },

   /* replace21 -> 73 in the cache */

   /* ('irem', 'a', -1) => 0 */
   /* search22_0 -> 9 in the cache */
   /* search22_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_irem,
      -1, 0,
      { 9, 75 },
      -1,
   } },

   /* replace22 -> 73 in the cache */

   /* ('udiv', 'a', '#b(is_pos_power_of_two)') => ('ushr', 'a', ('find_lsb', 'b')) */
   /* search23_0 -> 0 in the cache */
   /* search23_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace23_0 -> 0 in the cache */
   /* replace23_1_0 -> 1 in the cache */
   /* replace23_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 0, 17 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_pos_power_of_two)') => ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', 'b'))) */
   /* search24_0 -> 0 in the cache */
   /* search24_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_idiv,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace24_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isign,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 0 },
      -1,
   } },
   /* replace24_1_1_0 -> 1 in the cache */
   /* replace24_1_1 -> 17 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 83, 17 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 82, 84 },
      -1,
   } },

   /* ('idiv', 'a', '#b(is_neg_power_of_two)') => ('ineg', ('imul', ('isign', 'a'), ('ushr', ('iabs', 'a'), ('find_lsb', ('iabs', 'b'))))) */
   /* search25_0 -> 0 in the cache */
   /* search25_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_idiv,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace25_0_0_0 -> 0 in the cache */
   /* replace25_0_0 -> 82 in the cache */
   /* replace25_0_1_0_0 -> 0 in the cache */
   /* replace25_0_1_0 -> 83 in the cache */
   /* replace25_0_1_1_0_0 -> 1 in the cache */
   /* replace25_0_1_1_0 -> 41 in the cache */
   /* replace25_0_1_1 -> 42 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 83, 42 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 82, 87 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 1,
      { 88 },
      -1,
   } },

   /* ('umod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search26_0 -> 0 in the cache */
   /* search26_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace26_0 -> 0 in the cache */
   /* replace26_1_0 -> 1 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_isub,
      -1, 0,
      { 1, 91 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 0, 92 },
      -1,
   } },

   /* ('imod', 'a', '#b(is_pos_power_of_two)') => ('iand', 'a', ('isub', 'b', 1)) */
   /* search27_0 -> 0 in the cache */
   /* search27_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imod,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace27_0 -> 0 in the cache */
   /* replace27_1_0 -> 1 in the cache */
   /* replace27_1_1 -> 91 in the cache */
   /* replace27_1 -> 92 in the cache */
   /* replace27 -> 93 in the cache */

   /* ('imod', 'a', '#b(is_neg_power_of_two)') => ('bcsel', ('ieq', ('ior', 'a', 'b'), 'b'), 0, ('ior', 'a', 'b')) */
   /* search28_0 -> 0 in the cache */
   /* search28_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imod,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace28_0_0_0 -> 0 in the cache */
   /* replace28_0_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace28_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 2,
      { 96, 1 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   /* replace28_2_0 -> 0 in the cache */
   /* replace28_2_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 97, 98, 99 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_pos_power_of_two)') => ('isub', 'a', ('iand', ('bcsel', ('ilt', 'a', 0), ('iadd', 'a', ('isub', 'b', 1)), 'a'), ('ineg', 'b'))) */
   /* search29_0 -> 0 in the cache */
   /* search29_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_irem,
      -1, 0,
      { 0, 15 },
      -1,
   } },

   /* replace29_0 -> 0 in the cache */
   /* replace29_1_0_0_0 -> 0 in the cache */
   /* replace29_1_0_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ilt,
      -1, 0,
      { 0, 98 },
      -1,
   } },
   /* replace29_1_0_1_0 -> 0 in the cache */
   /* replace29_1_0_1_1_0 -> 1 in the cache */
   /* replace29_1_0_1_1_1 -> 91 in the cache */
   /* replace29_1_0_1_1 -> 92 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 0, 92 },
      -1,
   } },
   /* replace29_1_0_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 102, 103, 0 },
      -1,
   } },
   /* replace29_1_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 2,
      { 104, 105 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 2,
      { 0, 106 },
      -1,
   } },

   /* ('irem', 'a', '#b(is_neg_power_of_two)') => ('irem', 'a', ('iabs', 'b')) */
   /* search30_0 -> 0 in the cache */
   /* search30_1 -> 39 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_irem,
      -1, 0,
      { 0, 39 },
      -1,
   } },

   /* replace30_0 -> 0 in the cache */
   /* replace30_1_0 -> 1 in the cache */
   /* replace30_1 -> 41 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_irem,
      -1, 0,
      { 0, 41 },
      -1,
   } },

   /* ('~fmul', ('fsign', 'a'), ('ffloor', ('fadd', ('fabs', 'a'), 0.5))) => ('ftrunc', ('fadd', 'a', ('fmul', ('fsign', 'a'), 0.5))) */
   /* search31_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsign,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search31_1_0_0_0 -> 9 in the cache */
   /* search31_1_0_0 -> 11 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3fe0000000000000ull /* 0.5 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      1, 1,
      { 11, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 1,
      { 112 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 110, 113 },
      -1,
   } },

   /* replace31_0_0 -> 9 in the cache */
   /* replace31_0_1_0_0 -> 9 in the cache */
   /* replace31_0_1_0 -> 110 in the cache */
   /* replace31_0_1_1 -> 111 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      1, 1,
      { 110, 111 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 9, 115 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 2,
      { 116 },
      -1,
   } },

   /* ('~fneg', ('fneg', 'a')) => a */
   /* search32_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace32 -> 9 in the cache */

   /* ('ineg', ('ineg', 'a')) => a */
   /* search33_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 120 },
      -1,
   } },

   /* replace33 -> 9 in the cache */

   /* ('fabs', ('fneg', 'a')) => ('fabs', 'a') */
   /* search34_0_0 -> 9 in the cache */
   /* search34_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 118 },
      -1,
   } },

   /* replace34_0 -> 9 in the cache */
   /* replace34 -> 11 in the cache */

   /* ('fabs', ('u2f', 'a')) => ('u2f', 'a') */
   /* search35_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_u2f,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 123 },
      -1,
   } },

   /* replace35_0 -> 9 in the cache */
   /* replace35 -> 123 in the cache */

   /* ('iabs', ('iabs', 'a')) => ('iabs', 'a') */
   /* search36_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 125 },
      -1,
   } },

   /* replace36_0 -> 9 in the cache */
   /* replace36 -> 125 in the cache */

   /* ('iabs', ('ineg', 'a')) => ('iabs', 'a') */
   /* search37_0_0 -> 9 in the cache */
   /* search37_0 -> 120 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iabs,
      -1, 0,
      { 120 },
      -1,
   } },

   /* replace37_0 -> 9 in the cache */
   /* replace37 -> 125 in the cache */

   /* ('~fadd', 'a', 0.0) => a */
   /* search38_0 -> 9 in the cache */
   /* search38_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace38 -> 9 in the cache */

   /* ('fadd(is_only_used_as_float,nsz)', 'a', 0.0) => a */
   /* search39_0 -> 9 in the cache */
   /* search39_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      0, 1,
      { 9, 8 },
      1,
   } },

   /* replace39 -> 9 in the cache */

   /* ('fadd(is_only_used_as_float)', 'a', '#b(is_negative_zero)') => a */
   /* search40_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 0, 130 },
      1,
   } },

   /* replace40 -> 0 in the cache */

   /* ('fadd', ('fneg', 'a'), '#b(is_negative_zero)') => ('fneg', 'a') */
   /* search41_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search41_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 132, 130 },
      -1,
   } },

   /* replace41_0 -> 0 in the cache */
   /* replace41 -> 132 in the cache */

   /* ('iadd', 'a', 0) => a */
   /* search42_0 -> 9 in the cache */
   /* search42_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iadd,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace42 -> 9 in the cache */

   /* ('iadd_sat', 'a', 0) => a */
   /* search43_0 -> 9 in the cache */
   /* search43_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace43 -> 9 in the cache */

   /* ('isub_sat', 'a', 0) => a */
   /* search44_0 -> 9 in the cache */
   /* search44_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_isub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace44 -> 9 in the cache */

   /* ('uadd_sat', 'a', 0) => a */
   /* search45_0 -> 9 in the cache */
   /* search45_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_uadd_sat,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace45 -> 9 in the cache */

   /* ('usub_sat', 'a', 0) => a */
   /* search46_0 -> 9 in the cache */
   /* search46_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_usub_sat,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* replace46 -> 9 in the cache */

   /* ('usadd_4x8_vc4', 'a', 0) => a */
   /* search47_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* replace47 -> 29 in the cache */

   /* ('usadd_4x8_vc4', 'a', -1) => -1 */
   /* search48_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffffffffffull /* -1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_usadd_4x8_vc4,
      0, 1,
      { 29, 141 },
      -1,
   } },

   /* replace48 -> 141 in the cache */

   /* ('~fadd', ('fmul', 'a', 'b'), ('fmul', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search49_1_0 -> 143 in the cache */
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 145, 147 },
      -1,
   } },

   /* replace49_0 -> 143 in the cache */
   /* replace49_1_0 -> 144 in the cache */
   /* replace49_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 143, 149 },
      -1,
   } },

   /* ('~fadd', ('fmulz', 'a', 'b'), ('fmulz', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search50_0_0 -> 29 in the cache */
   /* search50_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* search50_1_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      2, 1,
      { 29, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 151, 153 },
      -1,
   } },

   /* replace50_0 -> 29 in the cache */
   /* replace50_1_0 -> 48 in the cache */
   /* replace50_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 48, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 2,
      { 29, 155 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search51_0 -> 0 in the cache */
   /* search51_1 -> 1 in the cache */
   /* search51_2_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 0, 157, 158 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 0, 1, 159 },
      -1,
   } },

   /* replace51_0 -> 0 in the cache */
   /* replace51_1_0 -> 1 in the cache */
   /* replace51_1_1 -> 157 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 1, 157 },
      -1,
   } },
   /* replace51_2 -> 158 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 0, 161, 158 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', ('fmul(is_used_once)', 'a', 'c')) => ('fmul', 'a', ('fadd', 'b', 'c')) */
   /* search52_0 -> 0 in the cache */
   /* search52_1 -> 1 in the cache */
   /* search52_2_0 -> 0 in the cache */
   /* search52_2_1 -> 157 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 0, 157 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 0, 1, 163 },
      -1,
   } },

   /* replace52_0 -> 0 in the cache */
   /* replace52_1_0 -> 1 in the cache */
   /* replace52_1_1 -> 157 in the cache */
   /* replace52_1 -> 161 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 0, 161 },
      -1,
   } },

   /* ('~fadd', ('fmul(is_used_once)', 'a', 'b'), ('ffma(is_used_once)', 'a', 'c', 'd')) => ('ffma', 'a', ('fadd', 'b', 'c'), 'd') */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 166, 167 },
      0,
   } },
   /* search53_1_0 -> 166 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      2, 1,
      { 166, 169, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 168, 171 },
      -1,
   } },

   /* replace53_0 -> 166 in the cache */
   /* replace53_1_0 -> 167 in the cache */
   /* replace53_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 167, 169 },
      -1,
   } },
   /* replace53_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 166, 173, 170 },
      -1,
   } },

   /* ('~ffma', 'a', ('fmul(is_used_once)', 'b', 'c'), ('fmul(is_used_once)', 'b', 'd')) => ('fmul', 'b', ('ffma', 'a', 'c', 'd')) */
   /* search54_0 -> 166 in the cache */
   /* search54_1_0 -> 167 in the cache */
   /* search54_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 167, 169 },
      0,
   } },
   /* search54_2_0 -> 167 in the cache */
   /* search54_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 167, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 166, 175, 176 },
      -1,
   } },

   /* replace54_0 -> 167 in the cache */
   /* replace54_1_0 -> 166 in the cache */
   /* replace54_1_1 -> 169 in the cache */
   /* replace54_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 166, 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 167, 178 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search55_0 -> 29 in the cache */
   /* search55_1 -> 48 in the cache */
   /* search55_2_0 -> 29 in the cache */
   /* search55_2_1 -> 152 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      1, 1,
      { 29, 152, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 181 },
      -1,
   } },

   /* replace55_0 -> 29 in the cache */
   /* replace55_1_0 -> 48 in the cache */
   /* replace55_1_1 -> 152 in the cache */
   /* replace55_1 -> 155 in the cache */
   /* replace55_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 2,
      { 29, 155, 180 },
      -1,
   } },

   /* ('~ffmaz', 'a', 'b', ('fmulz(is_used_once)', 'a', 'c')) => ('fmulz', 'a', ('fadd', 'b', 'c')) */
   /* search56_0 -> 29 in the cache */
   /* search56_1 -> 48 in the cache */
   /* search56_2_0 -> 29 in the cache */
   /* search56_2_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 29, 152 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 2,
      { 29, 48, 184 },
      -1,
   } },

   /* replace56_0 -> 29 in the cache */
   /* replace56_1_0 -> 48 in the cache */
   /* replace56_1_1 -> 152 in the cache */
   /* replace56_1 -> 155 in the cache */
   /* replace56 -> 156 in the cache */

   /* ('~fadd', ('fmulz(is_used_once)', 'a', 'b'), ('ffmaz(is_used_once)', 'a', 'c', 'd')) => ('ffmaz', 'a', ('fadd', 'b', 'c'), 'd') */
   /* search57_0_0 -> 29 in the cache */
   /* search57_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 29, 48 },
      0,
   } },
   /* search57_1_0 -> 29 in the cache */
   /* search57_1_1 -> 152 in the cache */
   /* search57_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      2, 1,
      { 29, 152, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 186, 187 },
      -1,
   } },

   /* replace57_0 -> 29 in the cache */
   /* replace57_1_0 -> 48 in the cache */
   /* replace57_1_1 -> 152 in the cache */
   /* replace57_1 -> 155 in the cache */
   /* replace57_2 -> 180 in the cache */
   /* replace57 -> 183 in the cache */

   /* ('~ffmaz', 'a', ('fmulz(is_used_once)', 'b', 'c'), ('fmulz(is_used_once)', 'b', 'd')) => ('fmulz', 'b', ('ffmaz', 'a', 'c', 'd')) */
   /* search58_0 -> 29 in the cache */
   /* search58_1_0 -> 48 in the cache */
   /* search58_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 48, 152 },
      0,
   } },
   /* search58_2_0 -> 48 in the cache */
   /* search58_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      2, 1,
      { 48, 180 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 3,
      { 29, 189, 190 },
      -1,
   } },

   /* replace58_0 -> 48 in the cache */
   /* replace58_1_0 -> 29 in the cache */
   /* replace58_1_1 -> 152 in the cache */
   /* replace58_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      1, 1,
      { 29, 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 2,
      { 48, 192 },
      -1,
   } },

   /* ('iadd', ('imul', 'a', 'b'), ('imul', 'a', 'c')) => ('imul', 'a', ('iadd', 'b', 'c')) */
   /* search59_0_0 -> 143 in the cache */
   /* search59_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search59_1_0 -> 143 in the cache */
   /* search59_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 194, 195 },
      -1,
   } },

   /* replace59_0 -> 143 in the cache */
   /* replace59_1_0 -> 144 in the cache */
   /* replace59_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 2,
      { 143, 197 },
      -1,
   } },

   /* ('iadd', ('ishl', 'b', 'a'), ('ishl', 'c', 'a')) => ('ishl', ('iadd', 'b', 'c'), 'a') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 199, 200 },
      -1,
   } },
   /* search60_1_0 -> 146 in the cache */
   /* search60_1_1 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 146, 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 201, 202 },
      -1,
   } },

   /* replace60_0_0 -> 199 in the cache */
   /* replace60_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 199, 146 },
      -1,
   } },
   /* replace60_1 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 204, 200 },
      -1,
   } },

   /* ('iand', ('iand', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', ('iand', 'a', 'b'), 'c') */
   /* search61_0_0 -> 143 in the cache */
   /* search61_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search61_1_0 -> 143 in the cache */
   /* search61_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      2, 1,
      { 143, 146 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 206, 207 },
      -1,
   } },

   /* replace61_0_0 -> 143 in the cache */
   /* replace61_0_1 -> 144 in the cache */
   /* replace61_0 -> 206 in the cache */
   /* replace61_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 2,
      { 206, 146 },
      -1,
   } },

   /* ('ior', ('ior', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', ('ior', 'a', 'b'), 'c') */
   /* search62_0_0 -> 143 in the cache */
   /* search62_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* search62_1_0 -> 143 in the cache */
   /* search62_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      2, 1,
      { 143, 146 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 3,
      { 210, 211 },
      -1,
   } },

   /* replace62_0_0 -> 143 in the cache */
   /* replace62_0_1 -> 144 in the cache */
   /* replace62_0 -> 210 in the cache */
   /* replace62_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 2,
      { 210, 146 },
      -1,
   } },

   /* ('iand', ('ior(is_used_once)', 'a', 'b'), ('ior(is_used_once)', 'a', 'c')) => ('ior', 'a', ('iand', 'b', 'c')) */
   /* search63_0_0 -> 143 in the cache */
   /* search63_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 143, 144 },
      0,
   } },
   /* search63_1_0 -> 143 in the cache */
   /* search63_1_1 -> 146 in the cache */
   /* search63_1 -> 211 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 214, 211 },
      -1,
   } },

   /* replace63_0 -> 143 in the cache */
   /* replace63_1_0 -> 144 in the cache */
   /* replace63_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 2,
      { 143, 216 },
      -1,
   } },

   /* ('ior', ('iand(is_used_once)', 'a', 'b'), ('iand(is_used_once)', 'a', 'c')) => ('iand', 'a', ('ior', 'b', 'c')) */
   /* search64_0_0 -> 143 in the cache */
   /* search64_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 143, 144 },
      0,
   } },
   /* search64_1_0 -> 143 in the cache */
   /* search64_1_1 -> 146 in the cache */
   /* search64_1 -> 207 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 3,
      { 218, 207 },
      -1,
   } },

   /* replace64_0 -> 143 in the cache */
   /* replace64_1_0 -> 144 in the cache */
   /* replace64_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 2,
      { 143, 220 },
      -1,
   } },

   /* ('ior', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('ior', 'a', 'c') */
   /* search65_0_0 -> 143 in the cache */
   /* search65_0_1 -> 144 in the cache */
   /* search65_0 -> 206 in the cache */
   /* search65_1_0 -> 143 in the cache */
   /* search65_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      2, 1,
      { 143, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 3,
      { 206, 222 },
      -1,
   } },

   /* replace65_0 -> 143 in the cache */
   /* replace65_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 143, 146 },
      -1,
   } },

   /* ('iand', ('iand', 'a', 'b'), ('ior', 'a', 'c')) => ('iand', 'a', 'b') */
   /* search66_0_0 -> 143 in the cache */
   /* search66_0_1 -> 144 in the cache */
   /* search66_0 -> 206 in the cache */
   /* search66_1_0 -> 143 in the cache */
   /* search66_1_1 -> 146 in the cache */
   /* search66_1 -> 222 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 206, 222 },
      -1,
   } },

   /* replace66_0 -> 143 in the cache */
   /* replace66_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 143, 144 },
      -1,
   } },

   /* ('ieq', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ine', ('iand', 'a', 'b'), 0) */
   /* search67_0_0 -> 0 in the cache */
   /* search67_0_1 -> 15 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 0, 15 },
      -1,
   } },
   /* search67_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 2,
      { 227, 1 },
      -1,
   } },

   /* replace67_0_0 -> 0 in the cache */
   /* replace67_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* replace67_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 2,
      { 229, 98 },
      -1,
   } },

   /* ('ine', ('iand', 'a', '#b(is_pos_power_of_two)'), 'b') => ('ieq', ('iand', 'a', 'b'), 0) */
   /* search68_0_0 -> 0 in the cache */
   /* search68_0_1 -> 15 in the cache */
   /* search68_0 -> 227 in the cache */
   /* search68_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 2,
      { 227, 1 },
      -1,
   } },

   /* replace68_0_0 -> 0 in the cache */
   /* replace68_0_1 -> 1 in the cache */
   /* replace68_0 -> 229 in the cache */
   /* replace68_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 2,
      { 229, 98 },
      -1,
   } },

   /* ('ieq', ('ushr(is_used_once)', 'a', '#b'), 0) => ('ult', 'a', ('ishl', 1, 'b')) */
   /* search69_0_0 -> 9 in the cache */
   /* search69_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 9, 45 },
      0,
   } },
   /* search69_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 233, 73 },
      -1,
   } },

   /* replace69_0 -> 9 in the cache */
   /* replace69_1_0 -> 47 in the cache */
   /* replace69_1_1 -> 48 in the cache */
   /* replace69_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('ine', ('ushr(is_used_once)', 'a', '#b'), 0) => ('uge', 'a', ('ishl', 1, 'b')) */
   /* search70_0_0 -> 9 in the cache */
   /* search70_0_1 -> 45 in the cache */
   /* search70_0 -> 233 in the cache */
   /* search70_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 233, 73 },
      -1,
   } },

   /* replace70_0 -> 9 in the cache */
   /* replace70_1_0 -> 47 in the cache */
   /* replace70_1_1 -> 48 in the cache */
   /* replace70_1 -> 49 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 9, 49 },
      -1,
   } },

   /* ('~fadd', ('fneg', 'a'), 'a') => 0.0 */
   /* search71_0_0 -> 9 in the cache */
   /* search71_0 -> 118 in the cache */
   /* search71_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 118, 9 },
      -1,
   } },

   /* replace71 -> 8 in the cache */

   /* ('iadd', ('ineg', 'a'), 'a') => 0 */
   /* search72_0_0 -> 9 in the cache */
   /* search72_0 -> 120 in the cache */
   /* search72_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 120, 9 },
      -1,
   } },

   /* replace72 -> 73 in the cache */

   /* ('iadd', ('ineg', 'a'), ('iadd', 'a', 'b')) => b */
   /* search73_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search73_1_0 -> 0 in the cache */
   /* search73_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 240, 241 },
      -1,
   } },

   /* replace73 -> 1 in the cache */

   /* ('iadd', 'a', ('iadd', ('ineg', 'a'), 'b')) => b */
   /* search74_0 -> 0 in the cache */
   /* search74_1_0_0 -> 0 in the cache */
   /* search74_1_0 -> 240 in the cache */
   /* search74_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 240, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 0, 243 },
      -1,
   } },

   /* replace74 -> 1 in the cache */

   /* ('~fadd', ('fneg', 'a'), ('fadd', 'a', 'b')) => b */
   /* search75_0_0 -> 0 in the cache */
   /* search75_0 -> 132 in the cache */
   /* search75_1_0 -> 0 in the cache */
   /* search75_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 132, 245 },
      -1,
   } },

   /* replace75 -> 1 in the cache */

   /* ('~fadd', 'a', ('fadd', ('fneg', 'a'), 'b')) => b */
   /* search76_0 -> 0 in the cache */
   /* search76_1_0_0 -> 0 in the cache */
   /* search76_1_0 -> 132 in the cache */
   /* search76_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 132, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 0, 247 },
      -1,
   } },

   /* replace76 -> 1 in the cache */

   /* ('fadd', ('fsat', 'a'), ('fsat', ('fneg', 'a'))) => ('fsat', ('fabs', 'a')) */
   /* search77_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search77_1_0_0 -> 9 in the cache */
   /* search77_1_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 249, 250 },
      -1,
   } },

   /* replace77_0_0 -> 9 in the cache */
   /* replace77_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 11 },
      -1,
   } },

   /* ('fadd', 'a', 'a') => ('fmul', 'a', 2.0) */
   /* search78_0 -> 9 in the cache */
   /* search78_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace78_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x4000000000000000ull /* 2.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 254 },
      -1,
   } },

   /* ('fadd(contract)', 'a', ('fadd(is_used_once)', 'a', 'b')) => ('fadd', 'b', ('fmul', 'a', 2.0)) */
   /* search79_0 -> 0 in the cache */
   /* search79_1_0 -> 0 in the cache */
   /* search79_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 0, 256 },
      -1,
   } },

   /* replace79_0 -> 1 in the cache */
   /* replace79_1_0 -> 0 in the cache */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x4000000000000000ull /* 2.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      1, 1,
      { 0, 258 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 1, 259 },
      -1,
   } },

   /* ('~fmul', 'a', 0.0) => 0.0 */
   /* search80_0 -> 9 in the cache */
   /* search80_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace80 -> 8 in the cache */

   /* ('fmul(nsz,nnan)', 'a', 0.0) => 0.0 */
   /* search81_0 -> 9 in the cache */
   /* search81_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace81 -> 8 in the cache */

   /* ('fmulz', 'a', 0.0) => 0.0 */
   /* search82_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmulz,
      0, 1,
      { 29, 263 },
      -1,
   } },

   /* replace82 -> 263 in the cache */

   /* ('fmulz(nsz)', 'a', 'b(is_finite_not_zero)') => ('fmul', 'a', 'b') */
   /* search83_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      4,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 29, 265 },
      -1,
   } },

   /* replace83_0 -> 29 in the cache */
   /* replace83_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('fmulz', 'a(is_finite)', 'b(is_finite)') => ('fmul', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 268, 269 },
      -1,
   } },

   /* replace84_0 -> 29 in the cache */
   /* replace84_1 -> 48 in the cache */
   /* replace84 -> 267 in the cache */

   /* ('fmulz', 'a', 'a') => ('fmul', 'a', 'a') */
   /* search85_0 -> 29 in the cache */
   /* search85_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* replace85_0 -> 29 in the cache */
   /* replace85_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* ('ffmaz(nsz)', 'a', 'b(is_finite_not_zero)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search86_0 -> 29 in the cache */
   /* search86_1 -> 265 in the cache */
   /* search86_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 265, 152 },
      -1,
   } },

   /* replace86_0 -> 29 in the cache */
   /* replace86_1 -> 48 in the cache */
   /* replace86_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('ffmaz', 'a(is_finite)', 'b(is_finite)', 'c') => ('ffma', 'a', 'b', 'c') */
   /* search87_0 -> 268 in the cache */
   /* search87_1 -> 269 in the cache */
   /* search87_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 268, 269, 152 },
      -1,
   } },

   /* replace87_0 -> 29 in the cache */
   /* replace87_1 -> 48 in the cache */
   /* replace87_2 -> 152 in the cache */
   /* replace87 -> 274 in the cache */

   /* ('ffmaz', 'a', 'a', 'b') => ('ffma', 'a', 'a', 'b') */
   /* search88_0 -> 29 in the cache */
   /* search88_1 -> 29 in the cache */
   /* search88_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* replace88_0 -> 29 in the cache */
   /* replace88_1 -> 29 in the cache */
   /* replace88_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      -1, 0,
      { 29, 29, 48 },
      -1,
   } },

   /* ('imul', 'a', 0) => 0 */
   /* search89_0 -> 9 in the cache */
   /* search89_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace89 -> 73 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', 0) => 0 */
   /* search90_0 -> 29 in the cache */
   /* search90_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 139 },
      -1,
   } },

   /* replace90 -> 139 in the cache */

   /* ('umul_unorm_4x8_vc4', 'a', -1) => a */
   /* search91_0 -> 29 in the cache */
   /* search91_1 -> 141 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umul_unorm_4x8_vc4,
      0, 1,
      { 29, 141 },
      -1,
   } },

   /* replace91 -> 29 in the cache */

   /* ('~fmul', 'a', 1.0) => a */
   /* search92_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 281 },
      -1,
   } },

   /* replace92 -> 9 in the cache */

   /* ('~fmulz', 'a', 1.0) => a */
   /* search93_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmulz,
      0, 1,
      { 29, 283 },
      -1,
   } },

   /* replace93 -> 29 in the cache */

   /* ('fmul(is_only_used_as_float)', 'a', 1.0) => a */
   /* search94_0 -> 9 in the cache */
   /* search94_1 -> 281 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 281 },
      1,
   } },

   /* replace94 -> 9 in the cache */

   /* ('imul', 'a', 1) => a */
   /* search95_0 -> 9 in the cache */
   /* search95_1 -> 47 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 9, 47 },
      -1,
   } },

   /* replace95 -> 9 in the cache */

   /* ('fmul', 'a', -1.0) => ('fneg', 'a') */
   /* search96_0 -> 9 in the cache */
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 9, 287 },
      -1,
   } },

   /* replace96_0 -> 9 in the cache */
   /* replace96 -> 118 in the cache */

   /* ('imul', 'a', -1) => ('ineg', 'a') */
   /* search97_0 -> 9 in the cache */
   /* search97_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imul,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace97_0 -> 9 in the cache */
   /* replace97 -> 120 in the cache */

   /* ('fmul', ('fsign', 'a'), ('fmul', 'a', 'a')) => ('fmul', ('fabs', 'a'), 'a') */
   /* search98_0_0 -> 9 in the cache */
   /* search98_0 -> 110 in the cache */
   /* search98_1_0 -> 9 in the cache */
   /* search98_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      -1, 0,
      { 9, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 110, 290 },
      -1,
   } },

   /* replace98_0_0 -> 9 in the cache */
   /* replace98_0 -> 11 in the cache */
   /* replace98_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 11, 9 },
      -1,
   } },

   /* ('fmul', ('fmul', ('fsign', 'a'), 'a'), 'a') => ('fmul', ('fabs', 'a'), 'a') */
   /* search99_0_0_0 -> 9 in the cache */
   /* search99_0_0 -> 110 in the cache */
   /* search99_0_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 110, 9 },
      -1,
   } },
   /* search99_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 293, 9 },
      -1,
   } },

   /* replace99_0_0 -> 9 in the cache */
   /* replace99_0 -> 11 in the cache */
   /* replace99_1 -> 9 in the cache */
   /* replace99 -> 292 in the cache */

   /* ('~ffma', 0.0, 'a', 'b') => b */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search100_1 -> 0 in the cache */
   /* search100_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 295, 0, 1 },
      -1,
   } },

   /* replace100 -> 1 in the cache */

   /* ('ffma(is_only_used_as_float,nsz,nnan,ninf)', 0.0, 'a', 'b') => b */
   /* search101_0 -> 295 in the cache */
   /* search101_1 -> 0 in the cache */
   /* search101_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 295, 0, 1 },
      1,
   } },

   /* replace101 -> 1 in the cache */

   /* ('ffmaz', 0.0, 'a', 'b') => ('fadd', 0.0, 'b') */
   /* search102_0 -> 263 in the cache */
   /* search102_1 -> 29 in the cache */
   /* search102_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 263, 29, 48 },
      -1,
   } },

   /* replace102_0 -> 263 in the cache */
   /* replace102_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 263, 48 },
      -1,
   } },

   /* ('~ffma', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search103_0 -> 0 in the cache */
   /* search103_1 -> 1 in the cache */
   /* search103_2 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 0, 1, 295 },
      -1,
   } },

   /* replace103_0 -> 0 in the cache */
   /* replace103_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffma(nsz)', 'a', 'b', 0.0) => ('fmul', 'a', 'b') */
   /* search104_0 -> 0 in the cache */
   /* search104_1 -> 1 in the cache */
   /* search104_2 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 0, 1, 295 },
      -1,
   } },

   /* replace104_0 -> 0 in the cache */
   /* replace104_1 -> 1 in the cache */
   /* replace104 -> 301 in the cache */

   /* ('ffmaz(nsz)', 'a', 'b', 0.0) => ('fmulz', 'a', 'b') */
   /* search105_0 -> 29 in the cache */
   /* search105_1 -> 48 in the cache */
   /* search105_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 263 },
      -1,
   } },

   /* replace105_0 -> 29 in the cache */
   /* replace105_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* search106_1 -> 0 in the cache */
   /* search106_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 305, 0, 1 },
      -1,
   } },

   /* replace106_0 -> 0 in the cache */
   /* replace106_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', 1.0, 'a', 'b') => ('fadd', 'a', 'b') */
   /* search107_0 -> 283 in the cache */
   /* search107_1 -> 29 in the cache */
   /* search107_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 283, 29, 48 },
      -1,
   } },

   /* replace107_0 -> 29 in the cache */
   /* replace107_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      -1,
   } },

   /* ('ffma', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, -2 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search108_1 -> 0 in the cache */
   /* search108_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 310, 0, 1 },
      -1,
   } },

   /* replace108_0_0 -> 0 in the cache */
   /* replace108_0 -> 132 in the cache */
   /* replace108_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 132, 1 },
      -1,
   } },

   /* ('ffmaz(nsz)', -1.0, 'a', 'b') => ('fadd', ('fneg', 'a'), 'b') */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_float, { 0xbff0000000000000ull /* -1.0 */ },
   } },
   /* search109_1 -> 29 in the cache */
   /* search109_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 313, 29, 48 },
      -1,
   } },

   /* replace109_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 29 },
      -1,
   } },
   /* replace109_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 315, 48 },
      -1,
   } },

   /* ('~ffma', '#a', '#b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, -3 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search110_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 317, 318, 146 },
      -1,
   } },

   /* replace110_0_0 -> 143 in the cache */
   /* replace110_0_1 -> 144 in the cache */
   /* replace110_0 -> 145 in the cache */
   /* replace110_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 145, 146 },
      -1,
   } },

   /* ('~ffmaz', '#a', '#b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search111_1 -> 45 in the cache */
   /* search111_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 321, 45, 152 },
      -1,
   } },

   /* replace111_0_0 -> 29 in the cache */
   /* replace111_0_1 -> 48 in the cache */
   /* replace111_0 -> 151 in the cache */
   /* replace111_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 151, 152 },
      -1,
   } },

   /* ('~flrp', 'a', 'b', 0.0) => a */
   /* search112_0 -> 0 in the cache */
   /* search112_1 -> 1 in the cache */
   /* search112_2 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 295 },
      -1,
   } },

   /* replace112 -> 0 in the cache */

   /* ('~flrp', 'a', 'b', 1.0) => b */
   /* search113_0 -> 0 in the cache */
   /* search113_1 -> 1 in the cache */
   /* search113_2 -> 305 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 1, 305 },
      -1,
   } },

   /* replace113 -> 1 in the cache */

   /* ('~flrp', 'a', 'a', 'b') => a */
   /* search114_0 -> 0 in the cache */
   /* search114_1 -> 0 in the cache */
   /* search114_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 0, 1 },
      -1,
   } },

   /* replace114 -> 0 in the cache */

   /* ('~flrp', 0.0, 'a', 'b') => ('fmul', 'a', 'b') */
   /* search115_0 -> 295 in the cache */
   /* search115_1 -> 0 in the cache */
   /* search115_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 295, 0, 1 },
      -1,
   } },

   /* replace115_0 -> 0 in the cache */
   /* replace115_1 -> 1 in the cache */
   /* replace115 -> 301 in the cache */

   /* ('~flrp', 'a', ('fadd(is_used_once)', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search116_0 -> 143 in the cache */
   /* search116_1_0 -> 143 in the cache */
   /* search116_1_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 143, 144 },
      0,
   } },
   /* search116_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 143, 328, 146 },
      -1,
   } },

   /* replace116_0_0 -> 144 in the cache */
   /* replace116_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 144, 146 },
      -1,
   } },
   /* replace116_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 330, 143 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 0, 'b') => b */
   /* search117_0 -> 29 in the cache */
   /* search117_1 -> 139 in the cache */
   /* search117_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace117 -> 48 in the cache */

   /* ('udot_4x8_uadd', 'a', 0, 'b') => b */
   /* search118_0 -> 29 in the cache */
   /* search118_1 -> 139 in the cache */
   /* search118_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace118 -> 48 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search119_0 -> 29 in the cache */
   /* search119_1 -> 139 in the cache */
   /* search119_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace119 -> 48 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 0, 'b') => b */
   /* search120_0 -> 29 in the cache */
   /* search120_1 -> 139 in the cache */
   /* search120_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace120 -> 48 in the cache */

   /* ('sdot_2x16_iadd', 'a', 0, 'b') => b */
   /* search121_0 -> 29 in the cache */
   /* search121_1 -> 139 in the cache */
   /* search121_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace121 -> 48 in the cache */

   /* ('udot_2x16_uadd', 'a', 0, 'b') => b */
   /* search122_0 -> 29 in the cache */
   /* search122_1 -> 139 in the cache */
   /* search122_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace122 -> 48 in the cache */

   /* ('sdot_2x16_iadd_sat', 'a', 0, 'b') => b */
   /* search123_0 -> 29 in the cache */
   /* search123_1 -> 139 in the cache */
   /* search123_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace123 -> 48 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 0, 'b') => b */
   /* search124_0 -> 29 in the cache */
   /* search124_1 -> 139 in the cache */
   /* search124_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 139, 48 },
      -1,
   } },

   /* replace124 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 'a', 0, 'b') => b */
   /* search125_0 -> 29 in the cache */
   /* search125_1 -> 139 in the cache */
   /* search125_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 139, 48 },
      -1,
   } },

   /* replace125 -> 48 in the cache */

   /* ('sudot_4x8_iadd', 0, 'a', 'b') => b */
   /* search126_0 -> 139 in the cache */
   /* search126_1 -> 29 in the cache */
   /* search126_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 139, 29, 48 },
      -1,
   } },

   /* replace126 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 0, 'b') => b */
   /* search127_0 -> 29 in the cache */
   /* search127_1 -> 139 in the cache */
   /* search127_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 139, 48 },
      -1,
   } },

   /* replace127 -> 48 in the cache */

   /* ('sudot_4x8_iadd_sat', 0, 'a', 'b') => b */
   /* search128_0 -> 139 in the cache */
   /* search128_1 -> 29 in the cache */
   /* search128_2 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 139, 29, 48 },
      -1,
   } },

   /* replace128 -> 48 in the cache */

   /* ('iadd', ('sdot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search129_0_0 -> 29 in the cache */
   /* search129_0_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 344 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 345, 346 },
      -1,
   } },

   /* replace129_0 -> 29 in the cache */
   /* replace129_1 -> 48 in the cache */
   /* replace129_2_0 -> 152 in the cache */
   /* replace129_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      0, 2,
      { 29, 48, 348 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_4x8_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search130_0_0 -> 29 in the cache */
   /* search130_0_1 -> 48 in the cache */
   /* search130_0_2 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 344 },
      0,
   } },
   /* search130_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 350, 346 },
      -1,
   } },

   /* replace130_0 -> 29 in the cache */
   /* replace130_1 -> 48 in the cache */
   /* replace130_2_0 -> 152 in the cache */
   /* replace130_2_1 -> 180 in the cache */
   /* replace130_2 -> 348 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      0, 2,
      { 29, 48, 348 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sudot_4x8_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search131_0_0 -> 29 in the cache */
   /* search131_0_1 -> 48 in the cache */
   /* search131_0_2 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 344 },
      0,
   } },
   /* search131_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 353, 346 },
      -1,
   } },

   /* replace131_0 -> 29 in the cache */
   /* replace131_1 -> 48 in the cache */
   /* replace131_2_0 -> 152 in the cache */
   /* replace131_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 152, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 1,
      { 29, 48, 355 },
      -1,
   } },

   /* ('iadd', ('sdot_2x16_iadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('sdot_2x16_iadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search132_0_0 -> 29 in the cache */
   /* search132_0_1 -> 48 in the cache */
   /* search132_0_2 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 344 },
      0,
   } },
   /* search132_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 357, 346 },
      -1,
   } },

   /* replace132_0 -> 29 in the cache */
   /* replace132_1 -> 48 in the cache */
   /* replace132_2_0 -> 152 in the cache */
   /* replace132_2_1 -> 180 in the cache */
   /* replace132_2 -> 348 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      0, 2,
      { 29, 48, 348 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd(is_used_once)', 'a', 'b', '#c'), '#d') => ('udot_2x16_uadd', 'a', 'b', ('iadd', 'c', 'd')) */
   /* search133_0_0 -> 29 in the cache */
   /* search133_0_1 -> 48 in the cache */
   /* search133_0_2 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 344 },
      0,
   } },
   /* search133_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 360, 346 },
      -1,
   } },

   /* replace133_0 -> 29 in the cache */
   /* replace133_1 -> 48 in the cache */
   /* replace133_2_0 -> 152 in the cache */
   /* replace133_2_1 -> 180 in the cache */
   /* replace133_2 -> 348 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      0, 2,
      { 29, 48, 348 },
      -1,
   } },

   /* ('iadd', ('sdot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_4x8_iadd', 'a', 'b', 'c') */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search134_0_1 -> 48 in the cache */
   /* search134_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 363, 48, 139 },
      -1,
   } },
   /* search134_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 364, 152 },
      -1,
   } },

   /* replace134_0 -> 29 in the cache */
   /* replace134_1 -> 48 in the cache */
   /* replace134_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('udot_4x8_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search135_0_0 -> 363 in the cache */
   /* search135_0_1 -> 48 in the cache */
   /* search135_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 363, 48, 139 },
      -1,
   } },
   /* search135_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 367, 152 },
      -1,
   } },

   /* replace135_0 -> 29 in the cache */
   /* replace135_1 -> 48 in the cache */
   /* replace135_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search136_0_0 -> 363 in the cache */
   /* search136_0_1 -> 48 in the cache */
   /* search136_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 363, 48, 139 },
      -1,
   } },
   /* search136_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 370, 152 },
      -1,
   } },

   /* replace136_0 -> 29 in the cache */
   /* replace136_1 -> 48 in the cache */
   /* replace136_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('sudot_4x8_iadd', 'a', 'b(is_not_const)', 0), 'c') => ('sudot_4x8_iadd', 'a', 'b', 'c') */
   /* search137_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search137_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 373, 139 },
      -1,
   } },
   /* search137_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 374, 152 },
      -1,
   } },

   /* replace137_0 -> 29 in the cache */
   /* replace137_1 -> 48 in the cache */
   /* replace137_2 -> 152 in the cache */
   /* replace137 -> 372 in the cache */

   /* ('iadd', ('sdot_2x16_iadd', 'a(is_not_const)', 'b', 0), 'c') => ('sdot_2x16_iadd', 'a', 'b', 'c') */
   /* search138_0_0 -> 363 in the cache */
   /* search138_0_1 -> 48 in the cache */
   /* search138_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 363, 48, 139 },
      -1,
   } },
   /* search138_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 376, 152 },
      -1,
   } },

   /* replace138_0 -> 29 in the cache */
   /* replace138_1 -> 48 in the cache */
   /* replace138_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('iadd', ('udot_2x16_uadd', 'a(is_not_const)', 'b', 0), 'c') => ('udot_2x16_uadd', 'a', 'b', 'c') */
   /* search139_0_0 -> 363 in the cache */
   /* search139_0_1 -> 48 in the cache */
   /* search139_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 363, 48, 139 },
      -1,
   } },
   /* search139_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 379, 152 },
      -1,
   } },

   /* replace139_0 -> 29 in the cache */
   /* replace139_1 -> 48 in the cache */
   /* replace139_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('sdot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search140_0 -> 321 in the cache */
   /* search140_1 -> 45 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      0, 1,
      { 321, 45, 382 },
      -1,
   } },

   /* replace140_0_0 -> 29 in the cache */
   /* replace140_0_1 -> 48 in the cache */
   /* replace140_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace140_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 384, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search141_0 -> 321 in the cache */
   /* search141_1 -> 45 in the cache */
   /* search141_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      0, 1,
      { 321, 45, 382 },
      -1,
   } },

   /* replace141_0_0 -> 29 in the cache */
   /* replace141_0_1 -> 48 in the cache */
   /* replace141_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace141_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 387, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search142_0 -> 321 in the cache */
   /* search142_1 -> 45 in the cache */
   /* search142_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 321, 45, 382 },
      -1,
   } },

   /* replace142_0_0 -> 29 in the cache */
   /* replace142_0_1 -> 48 in the cache */
   /* replace142_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd,
      -1, 0,
      { 29, 48, 139 },
      -1,
   } },
   /* replace142_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 390, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search143_0 -> 321 in the cache */
   /* search143_1 -> 45 in the cache */
   /* search143_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      0, 1,
      { 321, 45, 382 },
      -1,
   } },

   /* replace143_0_0 -> 29 in the cache */
   /* replace143_0_1 -> 48 in the cache */
   /* replace143_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace143_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 393, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd', '#a', '#b', 'c(is_not_const)') => ('iadd', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search144_0 -> 321 in the cache */
   /* search144_1 -> 45 in the cache */
   /* search144_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      0, 1,
      { 321, 45, 382 },
      -1,
   } },

   /* replace144_0_0 -> 29 in the cache */
   /* replace144_0_1 -> 48 in the cache */
   /* replace144_0_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd,
      1, 1,
      { 29, 48, 139 },
      -1,
   } },
   /* replace144_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 396, 152 },
      -1,
   } },

   /* ('sdot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search145_0 -> 321 in the cache */
   /* search145_1 -> 45 in the cache */
   /* search145_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 321, 45, 382 },
      -1,
   } },

   /* replace145_0_0 -> 29 in the cache */
   /* replace145_0_1 -> 48 in the cache */
   /* replace145_0_2 -> 139 in the cache */
   /* replace145_0 -> 384 in the cache */
   /* replace145_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd_sat,
      0, 2,
      { 384, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search146_0 -> 321 in the cache */
   /* search146_1 -> 45 in the cache */
   /* search146_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 321, 45, 382 },
      -1,
   } },

   /* replace146_0_0 -> 29 in the cache */
   /* replace146_0_1 -> 48 in the cache */
   /* replace146_0_2 -> 139 in the cache */
   /* replace146_0 -> 387 in the cache */
   /* replace146_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uadd_sat,
      0, 2,
      { 387, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search147_0 -> 321 in the cache */
   /* search147_1 -> 45 in the cache */
   /* search147_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 321, 45, 382 },
      -1,
   } },

   /* replace147_0_0 -> 29 in the cache */
   /* replace147_0_1 -> 48 in the cache */
   /* replace147_0_2 -> 139 in the cache */
   /* replace147_0 -> 390 in the cache */
   /* replace147_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd_sat,
      0, 1,
      { 390, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', '#a', '#b', 'c(is_not_const)') => ('iadd_sat', ('sdot_2x16_iadd', 'a', 'b', 0), 'c') */
   /* search148_0 -> 321 in the cache */
   /* search148_1 -> 45 in the cache */
   /* search148_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 321, 45, 382 },
      -1,
   } },

   /* replace148_0_0 -> 29 in the cache */
   /* replace148_0_1 -> 48 in the cache */
   /* replace148_0_2 -> 139 in the cache */
   /* replace148_0 -> 393 in the cache */
   /* replace148_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd_sat,
      0, 2,
      { 393, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd_sat', '#a', '#b', 'c(is_not_const)') => ('uadd_sat', ('udot_2x16_uadd', 'a', 'b', 0), 'c') */
   /* search149_0 -> 321 in the cache */
   /* search149_1 -> 45 in the cache */
   /* search149_2 -> 382 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 321, 45, 382 },
      -1,
   } },

   /* replace149_0_0 -> 29 in the cache */
   /* replace149_0_1 -> 48 in the cache */
   /* replace149_0_2 -> 139 in the cache */
   /* replace149_0 -> 396 in the cache */
   /* replace149_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uadd_sat,
      0, 2,
      { 396, 152 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   { .variable = {
      { nir_search_value_variable, 32 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search150_0_0_1 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      1, 1,
      { 408, 263 },
      -1,
   } },
   /* search150_0_1 -> 263 in the cache */
   /* search150_0_2_0_0 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 410 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 409, 263, 411 },
      -1,
   } },
   /* search150_1_0_0 -> 200 in the cache */
   /* search150_1_0_1 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      2, 1,
      { 200, 263 },
      -1,
   } },
   /* search150_1_1 -> 263 in the cache */
   /* search150_1_2_0_0 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 413, 263, 415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 412, 416 },
      -1,
   } },

   /* replace150_0_0_0 -> 200 in the cache */
   /* replace150_0_0 -> 410 in the cache */
   /* replace150_0 -> 411 in the cache */
   /* replace150_1_0_0 -> 408 in the cache */
   /* replace150_1_0 -> 414 in the cache */
   /* replace150_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 411, 415 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search151_0_0_0 -> 408 in the cache */
   /* search151_0_0_1 -> 263 in the cache */
   /* search151_0_0 -> 409 in the cache */
   /* search151_0_1 -> 263 in the cache */
   /* search151_0_2_0_0 -> 200 in the cache */
   /* search151_0_2_0 -> 410 in the cache */
   /* search151_0_2 -> 411 in the cache */
   /* search151_0 -> 412 in the cache */
   /* search151_1_0_0 -> 200 in the cache */
   /* search151_1_0_1 -> 263 in the cache */
   /* search151_1_0 -> 413 in the cache */
   /* search151_1_1 -> 263 in the cache */
   /* search151_1_2_0 -> 408 in the cache */
   /* search151_1_2 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 413, 263, 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 412, 419 },
      -1,
   } },

   /* replace151_0_0_0 -> 200 in the cache */
   /* replace151_0_0 -> 410 in the cache */
   /* replace151_0 -> 411 in the cache */
   /* replace151_1_0 -> 408 in the cache */
   /* replace151_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 411, 414 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search152_0_0_0 -> 408 in the cache */
   /* search152_0_0_1 -> 263 in the cache */
   /* search152_0_0 -> 409 in the cache */
   /* search152_0_1 -> 263 in the cache */
   /* search152_0_2_0_0 -> 200 in the cache */
   /* search152_0_2_0 -> 410 in the cache */
   /* search152_0_2 -> 411 in the cache */
   /* search152_0 -> 412 in the cache */
   /* search152_1_0_0 -> 200 in the cache */
   /* search152_1_0_1 -> 263 in the cache */
   /* search152_1_0 -> 413 in the cache */
   /* search152_1_1 -> 263 in the cache */
   /* search152_1_2_0 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 413, 263, 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 412, 423 },
      -1,
   } },

   /* replace152_0_0_0 -> 200 in the cache */
   /* replace152_0_0 -> 410 in the cache */
   /* replace152_0 -> 411 in the cache */
   /* replace152_1_0 -> 408 in the cache */
   /* replace152_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 411, 422 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search153_0_0_0 -> 408 in the cache */
   /* search153_0_0_1 -> 263 in the cache */
   /* search153_0_0 -> 409 in the cache */
   /* search153_0_1 -> 263 in the cache */
   /* search153_0_2_0_0 -> 200 in the cache */
   /* search153_0_2_0 -> 410 in the cache */
   /* search153_0_2 -> 411 in the cache */
   /* search153_0 -> 412 in the cache */
   /* search153_1_0_0 -> 200 in the cache */
   /* search153_1_0_1 -> 263 in the cache */
   /* search153_1_0 -> 413 in the cache */
   /* search153_1_1 -> 263 in the cache */
   /* search153_1_2 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 413, 263, 408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 412, 426 },
      -1,
   } },

   /* replace153_0_0_0 -> 200 in the cache */
   /* replace153_0_0 -> 410 in the cache */
   /* replace153_0 -> 411 in the cache */
   /* replace153_1 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 411, 408 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search154_0_0_0 -> 408 in the cache */
   /* search154_0_0_1 -> 263 in the cache */
   /* search154_0_0 -> 409 in the cache */
   /* search154_0_1 -> 263 in the cache */
   /* search154_0_2_0 -> 200 in the cache */
   /* search154_0_2 -> 410 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 409, 263, 410 },
      -1,
   } },
   /* search154_1_0_0 -> 200 in the cache */
   /* search154_1_0_1 -> 263 in the cache */
   /* search154_1_0 -> 413 in the cache */
   /* search154_1_1 -> 263 in the cache */
   /* search154_1_2_0 -> 408 in the cache */
   /* search154_1_2 -> 414 in the cache */
   /* search154_1 -> 419 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 429, 419 },
      -1,
   } },

   /* replace154_0_0 -> 200 in the cache */
   /* replace154_0 -> 410 in the cache */
   /* replace154_1_0 -> 408 in the cache */
   /* replace154_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 410, 414 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search155_0_0_0 -> 408 in the cache */
   /* search155_0_0_1 -> 263 in the cache */
   /* search155_0_0 -> 409 in the cache */
   /* search155_0_1 -> 263 in the cache */
   /* search155_0_2_0 -> 200 in the cache */
   /* search155_0_2 -> 410 in the cache */
   /* search155_0 -> 429 in the cache */
   /* search155_1_0_0 -> 200 in the cache */
   /* search155_1_0_1 -> 263 in the cache */
   /* search155_1_0 -> 413 in the cache */
   /* search155_1_1 -> 263 in the cache */
   /* search155_1_2_0 -> 408 in the cache */
   /* search155_1_2 -> 422 in the cache */
   /* search155_1 -> 423 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 429, 423 },
      -1,
   } },

   /* replace155_0_0 -> 200 in the cache */
   /* replace155_0 -> 410 in the cache */
   /* replace155_1_0 -> 408 in the cache */
   /* replace155_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 410, 422 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search156_0_0_0 -> 408 in the cache */
   /* search156_0_0_1 -> 263 in the cache */
   /* search156_0_0 -> 409 in the cache */
   /* search156_0_1 -> 263 in the cache */
   /* search156_0_2_0 -> 200 in the cache */
   /* search156_0_2 -> 410 in the cache */
   /* search156_0 -> 429 in the cache */
   /* search156_1_0_0 -> 200 in the cache */
   /* search156_1_0_1 -> 263 in the cache */
   /* search156_1_0 -> 413 in the cache */
   /* search156_1_1 -> 263 in the cache */
   /* search156_1_2 -> 408 in the cache */
   /* search156_1 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 429, 426 },
      -1,
   } },

   /* replace156_0_0 -> 200 in the cache */
   /* replace156_0 -> 410 in the cache */
   /* replace156_1 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 410, 408 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search157_0_0_0 -> 408 in the cache */
   /* search157_0_0_1 -> 263 in the cache */
   /* search157_0_0 -> 409 in the cache */
   /* search157_0_1 -> 263 in the cache */
   /* search157_0_2_0 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 200 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 409, 263, 436 },
      -1,
   } },
   /* search157_1_0_0 -> 200 in the cache */
   /* search157_1_0_1 -> 263 in the cache */
   /* search157_1_0 -> 413 in the cache */
   /* search157_1_1 -> 263 in the cache */
   /* search157_1_2_0 -> 408 in the cache */
   /* search157_1_2 -> 422 in the cache */
   /* search157_1 -> 423 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 437, 423 },
      -1,
   } },

   /* replace157_0_0 -> 200 in the cache */
   /* replace157_0 -> 436 in the cache */
   /* replace157_1_0 -> 408 in the cache */
   /* replace157_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 436, 422 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search158_0_0_0 -> 408 in the cache */
   /* search158_0_0_1 -> 263 in the cache */
   /* search158_0_0 -> 409 in the cache */
   /* search158_0_1 -> 263 in the cache */
   /* search158_0_2_0 -> 200 in the cache */
   /* search158_0_2 -> 436 in the cache */
   /* search158_0 -> 437 in the cache */
   /* search158_1_0_0 -> 200 in the cache */
   /* search158_1_0_1 -> 263 in the cache */
   /* search158_1_0 -> 413 in the cache */
   /* search158_1_1 -> 263 in the cache */
   /* search158_1_2 -> 408 in the cache */
   /* search158_1 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 437, 426 },
      -1,
   } },

   /* replace158_0_0 -> 200 in the cache */
   /* replace158_0 -> 436 in the cache */
   /* replace158_1 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 436, 408 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   /* search159_0_0_0 -> 408 in the cache */
   /* search159_0_0_1 -> 263 in the cache */
   /* search159_0_0 -> 409 in the cache */
   /* search159_0_1 -> 263 in the cache */
   /* search159_0_2 -> 200 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 409, 263, 200 },
      -1,
   } },
   /* search159_1_0_0 -> 200 in the cache */
   /* search159_1_0_1 -> 263 in the cache */
   /* search159_1_0 -> 413 in the cache */
   /* search159_1_1 -> 263 in the cache */
   /* search159_1_2 -> 408 in the cache */
   /* search159_1 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 442, 426 },
      -1,
   } },

   /* replace159_0 -> 200 in the cache */
   /* replace159_1 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 200, 408 },
      -1,
   } },

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   /* search160_0_0_0 -> 408 in the cache */
   /* search160_0_0_1 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      1, 1,
      { 408, 263 },
      -1,
   } },
   /* search160_0_1_0_0 -> 200 in the cache */
   /* search160_0_1_0 -> 410 in the cache */
   /* search160_0_1 -> 411 in the cache */
   /* search160_0_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 445, 411, 263 },
      -1,
   } },
   /* search160_1_0_0 -> 200 in the cache */
   /* search160_1_0_1 -> 263 in the cache */
   /* search160_1_0 -> 413 in the cache */
   /* search160_1_1 -> 263 in the cache */
   /* search160_1_2_0_0 -> 408 in the cache */
   /* search160_1_2_0 -> 414 in the cache */
   /* search160_1_2 -> 415 in the cache */
   /* search160_1 -> 416 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 446, 416 },
      -1,
   } },

   /* replace160_0_0_0 -> 200 in the cache */
   /* replace160_0_0 -> 410 in the cache */
   /* replace160_0 -> 411 in the cache */
   /* replace160_1_0_0 -> 408 in the cache */
   /* replace160_1_0 -> 414 in the cache */
   /* replace160_1 -> 415 in the cache */
   /* replace160 -> 418 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search161_0_0_0 -> 408 in the cache */
   /* search161_0_0_1 -> 263 in the cache */
   /* search161_0_0 -> 445 in the cache */
   /* search161_0_1_0_0 -> 200 in the cache */
   /* search161_0_1_0 -> 410 in the cache */
   /* search161_0_1 -> 411 in the cache */
   /* search161_0_2 -> 263 in the cache */
   /* search161_0 -> 446 in the cache */
   /* search161_1_0_0 -> 200 in the cache */
   /* search161_1_0_1 -> 263 in the cache */
   /* search161_1_0 -> 413 in the cache */
   /* search161_1_1 -> 263 in the cache */
   /* search161_1_2_0 -> 408 in the cache */
   /* search161_1_2 -> 414 in the cache */
   /* search161_1 -> 419 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 446, 419 },
      -1,
   } },

   /* replace161_0_0_0 -> 200 in the cache */
   /* replace161_0_0 -> 410 in the cache */
   /* replace161_0 -> 411 in the cache */
   /* replace161_1_0 -> 408 in the cache */
   /* replace161_1 -> 414 in the cache */
   /* replace161 -> 421 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search162_0_0_0 -> 408 in the cache */
   /* search162_0_0_1 -> 263 in the cache */
   /* search162_0_0 -> 445 in the cache */
   /* search162_0_1_0_0 -> 200 in the cache */
   /* search162_0_1_0 -> 410 in the cache */
   /* search162_0_1 -> 411 in the cache */
   /* search162_0_2 -> 263 in the cache */
   /* search162_0 -> 446 in the cache */
   /* search162_1_0_0 -> 200 in the cache */
   /* search162_1_0_1 -> 263 in the cache */
   /* search162_1_0 -> 413 in the cache */
   /* search162_1_1 -> 263 in the cache */
   /* search162_1_2_0 -> 408 in the cache */
   /* search162_1_2 -> 422 in the cache */
   /* search162_1 -> 423 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 446, 423 },
      -1,
   } },

   /* replace162_0_0_0 -> 200 in the cache */
   /* replace162_0_0 -> 410 in the cache */
   /* replace162_0 -> 411 in the cache */
   /* replace162_1_0 -> 408 in the cache */
   /* replace162_1 -> 422 in the cache */
   /* replace162 -> 425 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search163_0_0_0 -> 408 in the cache */
   /* search163_0_0_1 -> 263 in the cache */
   /* search163_0_0 -> 445 in the cache */
   /* search163_0_1_0_0 -> 200 in the cache */
   /* search163_0_1_0 -> 410 in the cache */
   /* search163_0_1 -> 411 in the cache */
   /* search163_0_2 -> 263 in the cache */
   /* search163_0 -> 446 in the cache */
   /* search163_1_0_0 -> 200 in the cache */
   /* search163_1_0_1 -> 263 in the cache */
   /* search163_1_0 -> 413 in the cache */
   /* search163_1_1 -> 263 in the cache */
   /* search163_1_2 -> 408 in the cache */
   /* search163_1 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 446, 426 },
      -1,
   } },

   /* replace163_0_0_0 -> 200 in the cache */
   /* replace163_0_0 -> 410 in the cache */
   /* replace163_0 -> 411 in the cache */
   /* replace163_1 -> 408 in the cache */
   /* replace163 -> 428 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search164_0_0_0 -> 408 in the cache */
   /* search164_0_0_1 -> 263 in the cache */
   /* search164_0_0 -> 445 in the cache */
   /* search164_0_1_0 -> 200 in the cache */
   /* search164_0_1 -> 410 in the cache */
   /* search164_0_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 445, 410, 263 },
      -1,
   } },
   /* search164_1_0_0 -> 200 in the cache */
   /* search164_1_0_1 -> 263 in the cache */
   /* search164_1_0 -> 413 in the cache */
   /* search164_1_1 -> 263 in the cache */
   /* search164_1_2_0 -> 408 in the cache */
   /* search164_1_2 -> 414 in the cache */
   /* search164_1 -> 419 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 451, 419 },
      -1,
   } },

   /* replace164_0_0 -> 200 in the cache */
   /* replace164_0 -> 410 in the cache */
   /* replace164_1_0 -> 408 in the cache */
   /* replace164_1 -> 414 in the cache */
   /* replace164 -> 431 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search165_0_0_0 -> 408 in the cache */
   /* search165_0_0_1 -> 263 in the cache */
   /* search165_0_0 -> 445 in the cache */
   /* search165_0_1_0 -> 200 in the cache */
   /* search165_0_1 -> 410 in the cache */
   /* search165_0_2 -> 263 in the cache */
   /* search165_0 -> 451 in the cache */
   /* search165_1_0_0 -> 200 in the cache */
   /* search165_1_0_1 -> 263 in the cache */
   /* search165_1_0 -> 413 in the cache */
   /* search165_1_1 -> 263 in the cache */
   /* search165_1_2_0 -> 408 in the cache */
   /* search165_1_2 -> 422 in the cache */
   /* search165_1 -> 423 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 451, 423 },
      -1,
   } },

   /* replace165_0_0 -> 200 in the cache */
   /* replace165_0 -> 410 in the cache */
   /* replace165_1_0 -> 408 in the cache */
   /* replace165_1 -> 422 in the cache */
   /* replace165 -> 433 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search166_0_0_0 -> 408 in the cache */
   /* search166_0_0_1 -> 263 in the cache */
   /* search166_0_0 -> 445 in the cache */
   /* search166_0_1_0 -> 200 in the cache */
   /* search166_0_1 -> 410 in the cache */
   /* search166_0_2 -> 263 in the cache */
   /* search166_0 -> 451 in the cache */
   /* search166_1_0_0 -> 200 in the cache */
   /* search166_1_0_1 -> 263 in the cache */
   /* search166_1_0 -> 413 in the cache */
   /* search166_1_1 -> 263 in the cache */
   /* search166_1_2 -> 408 in the cache */
   /* search166_1 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 451, 426 },
      -1,
   } },

   /* replace166_0_0 -> 200 in the cache */
   /* replace166_0 -> 410 in the cache */
   /* replace166_1 -> 408 in the cache */
   /* replace166 -> 435 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search167_0_0_0 -> 408 in the cache */
   /* search167_0_0_1 -> 263 in the cache */
   /* search167_0_0 -> 445 in the cache */
   /* search167_0_1_0 -> 200 in the cache */
   /* search167_0_1 -> 436 in the cache */
   /* search167_0_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 445, 436, 263 },
      -1,
   } },
   /* search167_1_0_0 -> 200 in the cache */
   /* search167_1_0_1 -> 263 in the cache */
   /* search167_1_0 -> 413 in the cache */
   /* search167_1_1 -> 263 in the cache */
   /* search167_1_2_0 -> 408 in the cache */
   /* search167_1_2 -> 422 in the cache */
   /* search167_1 -> 423 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 455, 423 },
      -1,
   } },

   /* replace167_0_0 -> 200 in the cache */
   /* replace167_0 -> 436 in the cache */
   /* replace167_1_0 -> 408 in the cache */
   /* replace167_1 -> 422 in the cache */
   /* replace167 -> 439 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search168_0_0_0 -> 408 in the cache */
   /* search168_0_0_1 -> 263 in the cache */
   /* search168_0_0 -> 445 in the cache */
   /* search168_0_1_0 -> 200 in the cache */
   /* search168_0_1 -> 436 in the cache */
   /* search168_0_2 -> 263 in the cache */
   /* search168_0 -> 455 in the cache */
   /* search168_1_0_0 -> 200 in the cache */
   /* search168_1_0_1 -> 263 in the cache */
   /* search168_1_0 -> 413 in the cache */
   /* search168_1_1 -> 263 in the cache */
   /* search168_1_2 -> 408 in the cache */
   /* search168_1 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 455, 426 },
      -1,
   } },

   /* replace168_0_0 -> 200 in the cache */
   /* replace168_0 -> 436 in the cache */
   /* replace168_1 -> 408 in the cache */
   /* replace168 -> 441 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), 'a', 0.0), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b')) => ('fmulz', 'a', 'b') */
   /* search169_0_0_0 -> 408 in the cache */
   /* search169_0_0_1 -> 263 in the cache */
   /* search169_0_0 -> 445 in the cache */
   /* search169_0_1 -> 200 in the cache */
   /* search169_0_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 445, 200, 263 },
      -1,
   } },
   /* search169_1_0_0 -> 200 in the cache */
   /* search169_1_0_1 -> 263 in the cache */
   /* search169_1_0 -> 413 in the cache */
   /* search169_1_1 -> 263 in the cache */
   /* search169_1_2 -> 408 in the cache */
   /* search169_1 -> 426 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 458, 426 },
      -1,
   } },

   /* replace169_0 -> 200 in the cache */
   /* replace169_1 -> 408 in the cache */
   /* replace169 -> 444 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'b')), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   /* search170_0_0_0 -> 408 in the cache */
   /* search170_0_0_1 -> 263 in the cache */
   /* search170_0_0 -> 445 in the cache */
   /* search170_0_1_0_0 -> 200 in the cache */
   /* search170_0_1_0 -> 410 in the cache */
   /* search170_0_1 -> 411 in the cache */
   /* search170_0_2 -> 263 in the cache */
   /* search170_0 -> 446 in the cache */
   /* search170_1_0_0 -> 200 in the cache */
   /* search170_1_0_1 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      2, 1,
      { 200, 263 },
      -1,
   } },
   /* search170_1_1_0_0 -> 408 in the cache */
   /* search170_1_1_0 -> 414 in the cache */
   /* search170_1_1 -> 415 in the cache */
   /* search170_1_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 460, 415, 263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 446, 461 },
      -1,
   } },

   /* replace170_0_0_0 -> 200 in the cache */
   /* replace170_0_0 -> 410 in the cache */
   /* replace170_0 -> 411 in the cache */
   /* replace170_1_0_0 -> 408 in the cache */
   /* replace170_1_0 -> 414 in the cache */
   /* replace170_1 -> 415 in the cache */
   /* replace170 -> 418 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fabs', 'b'), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search171_0_0_0 -> 408 in the cache */
   /* search171_0_0_1 -> 263 in the cache */
   /* search171_0_0 -> 445 in the cache */
   /* search171_0_1_0_0 -> 200 in the cache */
   /* search171_0_1_0 -> 410 in the cache */
   /* search171_0_1 -> 411 in the cache */
   /* search171_0_2 -> 263 in the cache */
   /* search171_0 -> 446 in the cache */
   /* search171_1_0_0 -> 200 in the cache */
   /* search171_1_0_1 -> 263 in the cache */
   /* search171_1_0 -> 460 in the cache */
   /* search171_1_1_0 -> 408 in the cache */
   /* search171_1_1 -> 414 in the cache */
   /* search171_1_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 460, 414, 263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 446, 463 },
      -1,
   } },

   /* replace171_0_0_0 -> 200 in the cache */
   /* replace171_0_0 -> 410 in the cache */
   /* replace171_0 -> 411 in the cache */
   /* replace171_1_0 -> 408 in the cache */
   /* replace171_1 -> 414 in the cache */
   /* replace171 -> 421 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search172_0_0_0 -> 408 in the cache */
   /* search172_0_0_1 -> 263 in the cache */
   /* search172_0_0 -> 445 in the cache */
   /* search172_0_1_0_0 -> 200 in the cache */
   /* search172_0_1_0 -> 410 in the cache */
   /* search172_0_1 -> 411 in the cache */
   /* search172_0_2 -> 263 in the cache */
   /* search172_0 -> 446 in the cache */
   /* search172_1_0_0 -> 200 in the cache */
   /* search172_1_0_1 -> 263 in the cache */
   /* search172_1_0 -> 460 in the cache */
   /* search172_1_1_0 -> 408 in the cache */
   /* search172_1_1 -> 422 in the cache */
   /* search172_1_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 460, 422, 263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 446, 465 },
      -1,
   } },

   /* replace172_0_0_0 -> 200 in the cache */
   /* replace172_0_0 -> 410 in the cache */
   /* replace172_0 -> 411 in the cache */
   /* replace172_1_0 -> 408 in the cache */
   /* replace172_1 -> 422 in the cache */
   /* replace172 -> 425 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', ('fabs', 'a')), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search173_0_0_0 -> 408 in the cache */
   /* search173_0_0_1 -> 263 in the cache */
   /* search173_0_0 -> 445 in the cache */
   /* search173_0_1_0_0 -> 200 in the cache */
   /* search173_0_1_0 -> 410 in the cache */
   /* search173_0_1 -> 411 in the cache */
   /* search173_0_2 -> 263 in the cache */
   /* search173_0 -> 446 in the cache */
   /* search173_1_0_0 -> 200 in the cache */
   /* search173_1_0_1 -> 263 in the cache */
   /* search173_1_0 -> 460 in the cache */
   /* search173_1_1 -> 408 in the cache */
   /* search173_1_2 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 460, 408, 263 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 446, 467 },
      -1,
   } },

   /* replace173_0_0_0 -> 200 in the cache */
   /* replace173_0_0 -> 410 in the cache */
   /* replace173_0 -> 411 in the cache */
   /* replace173_1 -> 408 in the cache */
   /* replace173 -> 428 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fabs', 'b'), 0.0)) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search174_0_0_0 -> 408 in the cache */
   /* search174_0_0_1 -> 263 in the cache */
   /* search174_0_0 -> 445 in the cache */
   /* search174_0_1_0 -> 200 in the cache */
   /* search174_0_1 -> 410 in the cache */
   /* search174_0_2 -> 263 in the cache */
   /* search174_0 -> 451 in the cache */
   /* search174_1_0_0 -> 200 in the cache */
   /* search174_1_0_1 -> 263 in the cache */
   /* search174_1_0 -> 460 in the cache */
   /* search174_1_1_0 -> 408 in the cache */
   /* search174_1_1 -> 414 in the cache */
   /* search174_1_2 -> 263 in the cache */
   /* search174_1 -> 463 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 451, 463 },
      -1,
   } },

   /* replace174_0_0 -> 200 in the cache */
   /* replace174_0 -> 410 in the cache */
   /* replace174_1_0 -> 408 in the cache */
   /* replace174_1 -> 414 in the cache */
   /* replace174 -> 431 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search175_0_0_0 -> 408 in the cache */
   /* search175_0_0_1 -> 263 in the cache */
   /* search175_0_0 -> 445 in the cache */
   /* search175_0_1_0 -> 200 in the cache */
   /* search175_0_1 -> 410 in the cache */
   /* search175_0_2 -> 263 in the cache */
   /* search175_0 -> 451 in the cache */
   /* search175_1_0_0 -> 200 in the cache */
   /* search175_1_0_1 -> 263 in the cache */
   /* search175_1_0 -> 460 in the cache */
   /* search175_1_1_0 -> 408 in the cache */
   /* search175_1_1 -> 422 in the cache */
   /* search175_1_2 -> 263 in the cache */
   /* search175_1 -> 465 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 451, 465 },
      -1,
   } },

   /* replace175_0_0 -> 200 in the cache */
   /* replace175_0 -> 410 in the cache */
   /* replace175_1_0 -> 408 in the cache */
   /* replace175_1 -> 422 in the cache */
   /* replace175 -> 433 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fabs', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search176_0_0_0 -> 408 in the cache */
   /* search176_0_0_1 -> 263 in the cache */
   /* search176_0_0 -> 445 in the cache */
   /* search176_0_1_0 -> 200 in the cache */
   /* search176_0_1 -> 410 in the cache */
   /* search176_0_2 -> 263 in the cache */
   /* search176_0 -> 451 in the cache */
   /* search176_1_0_0 -> 200 in the cache */
   /* search176_1_0_1 -> 263 in the cache */
   /* search176_1_0 -> 460 in the cache */
   /* search176_1_1 -> 408 in the cache */
   /* search176_1_2 -> 263 in the cache */
   /* search176_1 -> 467 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 451, 467 },
      -1,
   } },

   /* replace176_0_0 -> 200 in the cache */
   /* replace176_0 -> 410 in the cache */
   /* replace176_1 -> 408 in the cache */
   /* replace176 -> 435 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), ('fneg', 'b'), 0.0)) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search177_0_0_0 -> 408 in the cache */
   /* search177_0_0_1 -> 263 in the cache */
   /* search177_0_0 -> 445 in the cache */
   /* search177_0_1_0 -> 200 in the cache */
   /* search177_0_1 -> 436 in the cache */
   /* search177_0_2 -> 263 in the cache */
   /* search177_0 -> 455 in the cache */
   /* search177_1_0_0 -> 200 in the cache */
   /* search177_1_0_1 -> 263 in the cache */
   /* search177_1_0 -> 460 in the cache */
   /* search177_1_1_0 -> 408 in the cache */
   /* search177_1_1 -> 422 in the cache */
   /* search177_1_2 -> 263 in the cache */
   /* search177_1 -> 465 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 455, 465 },
      -1,
   } },

   /* replace177_0_0 -> 200 in the cache */
   /* replace177_0 -> 436 in the cache */
   /* replace177_1_0 -> 408 in the cache */
   /* replace177_1 -> 422 in the cache */
   /* replace177 -> 439 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), ('fneg', 'a'), 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search178_0_0_0 -> 408 in the cache */
   /* search178_0_0_1 -> 263 in the cache */
   /* search178_0_0 -> 445 in the cache */
   /* search178_0_1_0 -> 200 in the cache */
   /* search178_0_1 -> 436 in the cache */
   /* search178_0_2 -> 263 in the cache */
   /* search178_0 -> 455 in the cache */
   /* search178_1_0_0 -> 200 in the cache */
   /* search178_1_0_1 -> 263 in the cache */
   /* search178_1_0 -> 460 in the cache */
   /* search178_1_1 -> 408 in the cache */
   /* search178_1_2 -> 263 in the cache */
   /* search178_1 -> 467 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 455, 467 },
      -1,
   } },

   /* replace178_0_0 -> 200 in the cache */
   /* replace178_0 -> 436 in the cache */
   /* replace178_1 -> 408 in the cache */
   /* replace178 -> 441 in the cache */

   /* ('fmul@32(nsz)', ('bcsel', ('fneu', 'b', 0.0, 'ignore_exact'), 'a', 0.0), ('bcsel', ('fneu', 'a', 0.0, 'ignore_exact'), 'b', 0.0)) => ('fmulz', 'a', 'b') */
   /* search179_0_0_0 -> 408 in the cache */
   /* search179_0_0_1 -> 263 in the cache */
   /* search179_0_0 -> 445 in the cache */
   /* search179_0_1 -> 200 in the cache */
   /* search179_0_2 -> 263 in the cache */
   /* search179_0 -> 458 in the cache */
   /* search179_1_0_0 -> 200 in the cache */
   /* search179_1_0_1 -> 263 in the cache */
   /* search179_1_0 -> 460 in the cache */
   /* search179_1_1 -> 408 in the cache */
   /* search179_1_2 -> 263 in the cache */
   /* search179_1 -> 467 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 458, 467 },
      -1,
   } },

   /* replace179_0 -> 200 in the cache */
   /* replace179_1 -> 408 in the cache */
   /* replace179 -> 444 in the cache */

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b'))) */
   /* search180_0_0_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 29 },
      -1,
   } },
   /* search180_0_0_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 475, 476 },
      -1,
   } },
   /* search180_0_1 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 2,
      { 477, 263 },
      -1,
   } },
   /* search180_1 -> 263 in the cache */
   /* search180_2_0_0_0 -> 29 in the cache */
   /* search180_2_0_0 -> 475 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 475 },
      -1,
   } },
   /* search180_2_1_0_0 -> 48 in the cache */
   /* search180_2_1_0 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 479, 480 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 481 },
      -1,
   } },

   /* replace180_0_0_0 -> 29 in the cache */
   /* replace180_0_0 -> 475 in the cache */
   /* replace180_0 -> 479 in the cache */
   /* replace180_1_0_0 -> 48 in the cache */
   /* replace180_1_0 -> 476 in the cache */
   /* replace180_1 -> 480 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 479, 480 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fabs', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fabs', 'b')) */
   /* search181_0_0_0_0 -> 29 in the cache */
   /* search181_0_0_0 -> 475 in the cache */
   /* search181_0_0_1_0 -> 48 in the cache */
   /* search181_0_0_1 -> 476 in the cache */
   /* search181_0_0 -> 477 in the cache */
   /* search181_0_1 -> 263 in the cache */
   /* search181_0 -> 478 in the cache */
   /* search181_1 -> 263 in the cache */
   /* search181_2_0_0_0 -> 29 in the cache */
   /* search181_2_0_0 -> 475 in the cache */
   /* search181_2_0 -> 479 in the cache */
   /* search181_2_1_0 -> 48 in the cache */
   /* search181_2_1 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 479, 476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 484 },
      -1,
   } },

   /* replace181_0_0_0 -> 29 in the cache */
   /* replace181_0_0 -> 475 in the cache */
   /* replace181_0 -> 479 in the cache */
   /* replace181_1_0 -> 48 in the cache */
   /* replace181_1 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 479, 476 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), ('fneg', 'b'))) => ('fmulz', ('fneg', ('fabs', 'a')), ('fneg', 'b')) */
   /* search182_0_0_0_0 -> 29 in the cache */
   /* search182_0_0_0 -> 475 in the cache */
   /* search182_0_0_1_0 -> 48 in the cache */
   /* search182_0_0_1 -> 476 in the cache */
   /* search182_0_0 -> 477 in the cache */
   /* search182_0_1 -> 263 in the cache */
   /* search182_0 -> 478 in the cache */
   /* search182_1 -> 263 in the cache */
   /* search182_2_0_0_0 -> 29 in the cache */
   /* search182_2_0_0 -> 475 in the cache */
   /* search182_2_0 -> 479 in the cache */
   /* search182_2_1_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 479, 487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 488 },
      -1,
   } },

   /* replace182_0_0_0 -> 29 in the cache */
   /* replace182_0_0 -> 475 in the cache */
   /* replace182_0 -> 479 in the cache */
   /* replace182_1_0 -> 48 in the cache */
   /* replace182_1 -> 487 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 479, 487 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', ('fabs', 'a')), 'b')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search183_0_0_0_0 -> 29 in the cache */
   /* search183_0_0_0 -> 475 in the cache */
   /* search183_0_0_1_0 -> 48 in the cache */
   /* search183_0_0_1 -> 476 in the cache */
   /* search183_0_0 -> 477 in the cache */
   /* search183_0_1 -> 263 in the cache */
   /* search183_0 -> 478 in the cache */
   /* search183_1 -> 263 in the cache */
   /* search183_2_0_0_0 -> 29 in the cache */
   /* search183_2_0_0 -> 475 in the cache */
   /* search183_2_0 -> 479 in the cache */
   /* search183_2_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 479, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 491 },
      -1,
   } },

   /* replace183_0_0_0 -> 29 in the cache */
   /* replace183_0_0 -> 475 in the cache */
   /* replace183_0 -> 479 in the cache */
   /* replace183_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 479, 48 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), ('fabs', 'b'))) => ('fmulz', ('fabs', 'a'), ('fabs', 'b')) */
   /* search184_0_0_0_0 -> 29 in the cache */
   /* search184_0_0_0 -> 475 in the cache */
   /* search184_0_0_1_0 -> 48 in the cache */
   /* search184_0_0_1 -> 476 in the cache */
   /* search184_0_0 -> 477 in the cache */
   /* search184_0_1 -> 263 in the cache */
   /* search184_0 -> 478 in the cache */
   /* search184_1 -> 263 in the cache */
   /* search184_2_0_0 -> 29 in the cache */
   /* search184_2_0 -> 475 in the cache */
   /* search184_2_1_0 -> 48 in the cache */
   /* search184_2_1 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 475, 476 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 494 },
      -1,
   } },

   /* replace184_0_0 -> 29 in the cache */
   /* replace184_0 -> 475 in the cache */
   /* replace184_1_0 -> 48 in the cache */
   /* replace184_1 -> 476 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 475, 476 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), ('fneg', 'b'))) => ('fmulz', ('fabs', 'a'), ('fneg', 'b')) */
   /* search185_0_0_0_0 -> 29 in the cache */
   /* search185_0_0_0 -> 475 in the cache */
   /* search185_0_0_1_0 -> 48 in the cache */
   /* search185_0_0_1 -> 476 in the cache */
   /* search185_0_0 -> 477 in the cache */
   /* search185_0_1 -> 263 in the cache */
   /* search185_0 -> 478 in the cache */
   /* search185_1 -> 263 in the cache */
   /* search185_2_0_0 -> 29 in the cache */
   /* search185_2_0 -> 475 in the cache */
   /* search185_2_1_0 -> 48 in the cache */
   /* search185_2_1 -> 487 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 475, 487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 497 },
      -1,
   } },

   /* replace185_0_0 -> 29 in the cache */
   /* replace185_0 -> 475 in the cache */
   /* replace185_1_0 -> 48 in the cache */
   /* replace185_1 -> 487 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 475, 487 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fabs', 'a'), 'b')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search186_0_0_0_0 -> 29 in the cache */
   /* search186_0_0_0 -> 475 in the cache */
   /* search186_0_0_1_0 -> 48 in the cache */
   /* search186_0_0_1 -> 476 in the cache */
   /* search186_0_0 -> 477 in the cache */
   /* search186_0_1 -> 263 in the cache */
   /* search186_0 -> 478 in the cache */
   /* search186_1 -> 263 in the cache */
   /* search186_2_0_0 -> 29 in the cache */
   /* search186_2_0 -> 475 in the cache */
   /* search186_2_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 475, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 500 },
      -1,
   } },

   /* replace186_0_0 -> 29 in the cache */
   /* replace186_0 -> 475 in the cache */
   /* replace186_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 475, 48 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', 'a'), ('fneg', 'b'))) => ('fmulz', ('fneg', 'a'), ('fneg', 'b')) */
   /* search187_0_0_0_0 -> 29 in the cache */
   /* search187_0_0_0 -> 475 in the cache */
   /* search187_0_0_1_0 -> 48 in the cache */
   /* search187_0_0_1 -> 476 in the cache */
   /* search187_0_0 -> 477 in the cache */
   /* search187_0_1 -> 263 in the cache */
   /* search187_0 -> 478 in the cache */
   /* search187_1 -> 263 in the cache */
   /* search187_2_0_0 -> 29 in the cache */
   /* search187_2_0 -> 315 in the cache */
   /* search187_2_1_0 -> 48 in the cache */
   /* search187_2_1 -> 487 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 315, 487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 503 },
      -1,
   } },

   /* replace187_0_0 -> 29 in the cache */
   /* replace187_0 -> 315 in the cache */
   /* replace187_1_0 -> 48 in the cache */
   /* replace187_1 -> 487 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 315, 487 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', ('fneg', 'a'), 'b')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search188_0_0_0_0 -> 29 in the cache */
   /* search188_0_0_0 -> 475 in the cache */
   /* search188_0_0_1_0 -> 48 in the cache */
   /* search188_0_0_1 -> 476 in the cache */
   /* search188_0_0 -> 477 in the cache */
   /* search188_0_1 -> 263 in the cache */
   /* search188_0 -> 478 in the cache */
   /* search188_1 -> 263 in the cache */
   /* search188_2_0_0 -> 29 in the cache */
   /* search188_2_0 -> 315 in the cache */
   /* search188_2_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 315, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 506 },
      -1,
   } },

   /* replace188_0_0 -> 29 in the cache */
   /* replace188_0 -> 315 in the cache */
   /* replace188_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 315, 48 },
      -1,
   } },

   /* ('bcsel', ('feq', ('fmin', ('fabs', 'a'), ('fabs', 'b')), 0.0), 0.0, ('fmul@32', 'a', 'b')) => ('fmulz', 'a', 'b') */
   /* search189_0_0_0_0 -> 29 in the cache */
   /* search189_0_0_0 -> 475 in the cache */
   /* search189_0_0_1_0 -> 48 in the cache */
   /* search189_0_0_1 -> 476 in the cache */
   /* search189_0_0 -> 477 in the cache */
   /* search189_0_1 -> 263 in the cache */
   /* search189_0 -> 478 in the cache */
   /* search189_1 -> 263 in the cache */
   /* search189_2_0 -> 29 in the cache */
   /* search189_2_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 29, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 3,
      { 478, 263, 509 },
      -1,
   } },

   /* replace189_0 -> 29 in the cache */
   /* replace189_1 -> 48 in the cache */
   /* replace189 -> 304 in the cache */

   /* ('fmul@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', ('fabs', 'a')), 'b') */
   /* search190_0_0_0 -> 29 in the cache */
   /* search190_0_0 -> 475 in the cache */
   /* search190_0 -> 479 in the cache */
   /* search190_1_0_0 -> 29 in the cache */
   /* search190_1_0_1 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      1, 1,
      { 29, 263 },
      -1,
   } },
   /* search190_1_1 -> 263 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      7,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 511, 263, 512 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 479, 513 },
      -1,
   } },

   /* replace190_0_0_0 -> 29 in the cache */
   /* replace190_0_0 -> 475 in the cache */
   /* replace190_0 -> 479 in the cache */
   /* replace190_1 -> 48 in the cache */
   /* replace190 -> 493 in the cache */

   /* ('fmul@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fabs', 'a'), 'b') */
   /* search191_0_0 -> 29 in the cache */
   /* search191_0 -> 475 in the cache */
   /* search191_1_0_0 -> 29 in the cache */
   /* search191_1_0_1 -> 263 in the cache */
   /* search191_1_0 -> 511 in the cache */
   /* search191_1_1 -> 263 in the cache */
   /* search191_1_2 -> 512 in the cache */
   /* search191_1 -> 513 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 475, 513 },
      -1,
   } },

   /* replace191_0_0 -> 29 in the cache */
   /* replace191_0 -> 475 in the cache */
   /* replace191_1 -> 48 in the cache */
   /* replace191 -> 502 in the cache */

   /* ('fmul@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', ('fneg', 'a'), 'b') */
   /* search192_0_0 -> 29 in the cache */
   /* search192_0 -> 315 in the cache */
   /* search192_1_0_0 -> 29 in the cache */
   /* search192_1_0_1 -> 263 in the cache */
   /* search192_1_0 -> 511 in the cache */
   /* search192_1_1 -> 263 in the cache */
   /* search192_1_2 -> 512 in the cache */
   /* search192_1 -> 513 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 315, 513 },
      -1,
   } },

   /* replace192_0_0 -> 29 in the cache */
   /* replace192_0 -> 315 in the cache */
   /* replace192_1 -> 48 in the cache */
   /* replace192 -> 508 in the cache */

   /* ('fmul@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)')) => ('fmulz', 'a', 'b') */
   /* search193_0 -> 29 in the cache */
   /* search193_1_0_0 -> 29 in the cache */
   /* search193_1_0_1 -> 263 in the cache */
   /* search193_1_0 -> 511 in the cache */
   /* search193_1_1 -> 263 in the cache */
   /* search193_1_2 -> 512 in the cache */
   /* search193_1 -> 513 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 2,
      { 29, 513 },
      -1,
   } },

   /* replace193_0 -> 29 in the cache */
   /* replace193_1 -> 48 in the cache */
   /* replace193 -> 304 in the cache */

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'b'))), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', ('fabs', 'b')), 'c') */
   /* search194_0_0_0 -> 408 in the cache */
   /* search194_0_0_1 -> 263 in the cache */
   /* search194_0_0 -> 409 in the cache */
   /* search194_0_1 -> 263 in the cache */
   /* search194_0_2_0_0 -> 200 in the cache */
   /* search194_0_2_0 -> 410 in the cache */
   /* search194_0_2 -> 411 in the cache */
   /* search194_0 -> 412 in the cache */
   /* search194_1_0_0 -> 200 in the cache */
   /* search194_1_0_1 -> 263 in the cache */
   /* search194_1_0 -> 413 in the cache */
   /* search194_1_1 -> 263 in the cache */
   /* search194_1_2_0_0 -> 408 in the cache */
   /* search194_1_2_0 -> 414 in the cache */
   /* search194_1_2 -> 415 in the cache */
   /* search194_1 -> 416 in the cache */
   /* search194_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 412, 416, 152 },
      -1,
   } },

   /* replace194_0_0_0 -> 200 in the cache */
   /* replace194_0_0 -> 410 in the cache */
   /* replace194_0 -> 411 in the cache */
   /* replace194_1_0_0 -> 408 in the cache */
   /* replace194_1_0 -> 414 in the cache */
   /* replace194_1 -> 415 in the cache */
   /* replace194_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 411, 415, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fabs', 'b'), 'c') */
   /* search195_0_0_0 -> 408 in the cache */
   /* search195_0_0_1 -> 263 in the cache */
   /* search195_0_0 -> 409 in the cache */
   /* search195_0_1 -> 263 in the cache */
   /* search195_0_2_0_0 -> 200 in the cache */
   /* search195_0_2_0 -> 410 in the cache */
   /* search195_0_2 -> 411 in the cache */
   /* search195_0 -> 412 in the cache */
   /* search195_1_0_0 -> 200 in the cache */
   /* search195_1_0_1 -> 263 in the cache */
   /* search195_1_0 -> 413 in the cache */
   /* search195_1_1 -> 263 in the cache */
   /* search195_1_2_0 -> 408 in the cache */
   /* search195_1_2 -> 414 in the cache */
   /* search195_1 -> 419 in the cache */
   /* search195_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 412, 419, 152 },
      -1,
   } },

   /* replace195_0_0_0 -> 200 in the cache */
   /* replace195_0_0 -> 410 in the cache */
   /* replace195_0 -> 411 in the cache */
   /* replace195_1_0 -> 408 in the cache */
   /* replace195_1 -> 414 in the cache */
   /* replace195_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 411, 414, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), ('fneg', 'b'), 'c') */
   /* search196_0_0_0 -> 408 in the cache */
   /* search196_0_0_1 -> 263 in the cache */
   /* search196_0_0 -> 409 in the cache */
   /* search196_0_1 -> 263 in the cache */
   /* search196_0_2_0_0 -> 200 in the cache */
   /* search196_0_2_0 -> 410 in the cache */
   /* search196_0_2 -> 411 in the cache */
   /* search196_0 -> 412 in the cache */
   /* search196_1_0_0 -> 200 in the cache */
   /* search196_1_0_1 -> 263 in the cache */
   /* search196_1_0 -> 413 in the cache */
   /* search196_1_1 -> 263 in the cache */
   /* search196_1_2_0 -> 408 in the cache */
   /* search196_1_2 -> 422 in the cache */
   /* search196_1 -> 423 in the cache */
   /* search196_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 412, 423, 152 },
      -1,
   } },

   /* replace196_0_0_0 -> 200 in the cache */
   /* replace196_0_0 -> 410 in the cache */
   /* replace196_0 -> 411 in the cache */
   /* replace196_1_0 -> 408 in the cache */
   /* replace196_1 -> 422 in the cache */
   /* replace196_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 411, 422, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', ('fabs', 'a'))), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search197_0_0_0 -> 408 in the cache */
   /* search197_0_0_1 -> 263 in the cache */
   /* search197_0_0 -> 409 in the cache */
   /* search197_0_1 -> 263 in the cache */
   /* search197_0_2_0_0 -> 200 in the cache */
   /* search197_0_2_0 -> 410 in the cache */
   /* search197_0_2 -> 411 in the cache */
   /* search197_0 -> 412 in the cache */
   /* search197_1_0_0 -> 200 in the cache */
   /* search197_1_0_1 -> 263 in the cache */
   /* search197_1_0 -> 413 in the cache */
   /* search197_1_1 -> 263 in the cache */
   /* search197_1_2 -> 408 in the cache */
   /* search197_1 -> 426 in the cache */
   /* search197_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 412, 426, 152 },
      -1,
   } },

   /* replace197_0_0_0 -> 200 in the cache */
   /* replace197_0_0 -> 410 in the cache */
   /* replace197_0 -> 411 in the cache */
   /* replace197_1 -> 408 in the cache */
   /* replace197_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 411, 408, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fabs', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fabs', 'b'), 'c') */
   /* search198_0_0_0 -> 408 in the cache */
   /* search198_0_0_1 -> 263 in the cache */
   /* search198_0_0 -> 409 in the cache */
   /* search198_0_1 -> 263 in the cache */
   /* search198_0_2_0 -> 200 in the cache */
   /* search198_0_2 -> 410 in the cache */
   /* search198_0 -> 429 in the cache */
   /* search198_1_0_0 -> 200 in the cache */
   /* search198_1_0_1 -> 263 in the cache */
   /* search198_1_0 -> 413 in the cache */
   /* search198_1_1 -> 263 in the cache */
   /* search198_1_2_0 -> 408 in the cache */
   /* search198_1_2 -> 414 in the cache */
   /* search198_1 -> 419 in the cache */
   /* search198_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 429, 419, 152 },
      -1,
   } },

   /* replace198_0_0 -> 200 in the cache */
   /* replace198_0 -> 410 in the cache */
   /* replace198_1_0 -> 408 in the cache */
   /* replace198_1 -> 414 in the cache */
   /* replace198_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 410, 414, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fabs', 'a'), ('fneg', 'b'), 'c') */
   /* search199_0_0_0 -> 408 in the cache */
   /* search199_0_0_1 -> 263 in the cache */
   /* search199_0_0 -> 409 in the cache */
   /* search199_0_1 -> 263 in the cache */
   /* search199_0_2_0 -> 200 in the cache */
   /* search199_0_2 -> 410 in the cache */
   /* search199_0 -> 429 in the cache */
   /* search199_1_0_0 -> 200 in the cache */
   /* search199_1_0_1 -> 263 in the cache */
   /* search199_1_0 -> 413 in the cache */
   /* search199_1_1 -> 263 in the cache */
   /* search199_1_2_0 -> 408 in the cache */
   /* search199_1_2 -> 422 in the cache */
   /* search199_1 -> 423 in the cache */
   /* search199_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 429, 423, 152 },
      -1,
   } },

   /* replace199_0_0 -> 200 in the cache */
   /* replace199_0 -> 410 in the cache */
   /* replace199_1_0 -> 408 in the cache */
   /* replace199_1 -> 422 in the cache */
   /* replace199_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 410, 422, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search200_0_0_0 -> 408 in the cache */
   /* search200_0_0_1 -> 263 in the cache */
   /* search200_0_0 -> 409 in the cache */
   /* search200_0_1 -> 263 in the cache */
   /* search200_0_2_0 -> 200 in the cache */
   /* search200_0_2 -> 410 in the cache */
   /* search200_0 -> 429 in the cache */
   /* search200_1_0_0 -> 200 in the cache */
   /* search200_1_0_1 -> 263 in the cache */
   /* search200_1_0 -> 413 in the cache */
   /* search200_1_1 -> 263 in the cache */
   /* search200_1_2 -> 408 in the cache */
   /* search200_1 -> 426 in the cache */
   /* search200_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 429, 426, 152 },
      -1,
   } },

   /* replace200_0_0 -> 200 in the cache */
   /* replace200_0 -> 410 in the cache */
   /* replace200_1 -> 408 in the cache */
   /* replace200_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 410, 408, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, ('fneg', 'b')), 'c') => ('ffmaz', ('fneg', 'a'), ('fneg', 'b'), 'c') */
   /* search201_0_0_0 -> 408 in the cache */
   /* search201_0_0_1 -> 263 in the cache */
   /* search201_0_0 -> 409 in the cache */
   /* search201_0_1 -> 263 in the cache */
   /* search201_0_2_0 -> 200 in the cache */
   /* search201_0_2 -> 436 in the cache */
   /* search201_0 -> 437 in the cache */
   /* search201_1_0_0 -> 200 in the cache */
   /* search201_1_0_1 -> 263 in the cache */
   /* search201_1_0 -> 413 in the cache */
   /* search201_1_1 -> 263 in the cache */
   /* search201_1_2_0 -> 408 in the cache */
   /* search201_1_2 -> 422 in the cache */
   /* search201_1 -> 423 in the cache */
   /* search201_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 437, 423, 152 },
      -1,
   } },

   /* replace201_0_0 -> 200 in the cache */
   /* replace201_0 -> 436 in the cache */
   /* replace201_1_0 -> 408 in the cache */
   /* replace201_1 -> 422 in the cache */
   /* replace201_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 436, 422, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, ('fneg', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search202_0_0_0 -> 408 in the cache */
   /* search202_0_0_1 -> 263 in the cache */
   /* search202_0_0 -> 409 in the cache */
   /* search202_0_1 -> 263 in the cache */
   /* search202_0_2_0 -> 200 in the cache */
   /* search202_0_2 -> 436 in the cache */
   /* search202_0 -> 437 in the cache */
   /* search202_1_0_0 -> 200 in the cache */
   /* search202_1_0_1 -> 263 in the cache */
   /* search202_1_0 -> 413 in the cache */
   /* search202_1_1 -> 263 in the cache */
   /* search202_1_2 -> 408 in the cache */
   /* search202_1 -> 426 in the cache */
   /* search202_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 437, 426, 152 },
      -1,
   } },

   /* replace202_0_0 -> 200 in the cache */
   /* replace202_0 -> 436 in the cache */
   /* replace202_1 -> 408 in the cache */
   /* replace202_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 436, 408, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 0.0, 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, 'b'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search203_0_0_0 -> 408 in the cache */
   /* search203_0_0_1 -> 263 in the cache */
   /* search203_0_0 -> 409 in the cache */
   /* search203_0_1 -> 263 in the cache */
   /* search203_0_2 -> 200 in the cache */
   /* search203_0 -> 442 in the cache */
   /* search203_1_0_0 -> 200 in the cache */
   /* search203_1_0_1 -> 263 in the cache */
   /* search203_1_0 -> 413 in the cache */
   /* search203_1_1 -> 263 in the cache */
   /* search203_1_2 -> 408 in the cache */
   /* search203_1 -> 426 in the cache */
   /* search203_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 442, 426, 152 },
      -1,
   } },

   /* replace203_0 -> 200 in the cache */
   /* replace203_1 -> 408 in the cache */
   /* replace203_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 200, 408, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', ('fabs', 'a')), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', ('fabs', 'a')), 'b', 'c') */
   /* search204_0_0_0 -> 29 in the cache */
   /* search204_0_0 -> 475 in the cache */
   /* search204_0 -> 479 in the cache */
   /* search204_1_0_0 -> 29 in the cache */
   /* search204_1_0_1 -> 263 in the cache */
   /* search204_1_0 -> 511 in the cache */
   /* search204_1_1 -> 263 in the cache */
   /* search204_1_2 -> 512 in the cache */
   /* search204_1 -> 513 in the cache */
   /* search204_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 479, 513, 152 },
      -1,
   } },

   /* replace204_0_0_0 -> 29 in the cache */
   /* replace204_0_0 -> 475 in the cache */
   /* replace204_0 -> 479 in the cache */
   /* replace204_1 -> 48 in the cache */
   /* replace204_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 479, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fabs', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fabs', 'a'), 'b', 'c') */
   /* search205_0_0 -> 29 in the cache */
   /* search205_0 -> 475 in the cache */
   /* search205_1_0_0 -> 29 in the cache */
   /* search205_1_0_1 -> 263 in the cache */
   /* search205_1_0 -> 511 in the cache */
   /* search205_1_1 -> 263 in the cache */
   /* search205_1_2 -> 512 in the cache */
   /* search205_1 -> 513 in the cache */
   /* search205_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 475, 513, 152 },
      -1,
   } },

   /* replace205_0_0 -> 29 in the cache */
   /* replace205_0 -> 475 in the cache */
   /* replace205_1 -> 48 in the cache */
   /* replace205_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 475, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', ('fneg', 'a'), ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', ('fneg', 'a'), 'b', 'c') */
   /* search206_0_0 -> 29 in the cache */
   /* search206_0 -> 315 in the cache */
   /* search206_1_0_0 -> 29 in the cache */
   /* search206_1_0_1 -> 263 in the cache */
   /* search206_1_0 -> 511 in the cache */
   /* search206_1_1 -> 263 in the cache */
   /* search206_1_2 -> 512 in the cache */
   /* search206_1 -> 513 in the cache */
   /* search206_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 315, 513, 152 },
      -1,
   } },

   /* replace206_0_0 -> 29 in the cache */
   /* replace206_0 -> 315 in the cache */
   /* replace206_1 -> 48 in the cache */
   /* replace206_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 315, 48, 152 },
      -1,
   } },

   /* ('ffma@32(nsz)', 'a', ('bcsel', ('feq', 'a', 0.0, 'ignore_exact'), 0.0, '#b(is_not_const_zero)'), 'c') => ('ffmaz', 'a', 'b', 'c') */
   /* search207_0 -> 29 in the cache */
   /* search207_1_0_0 -> 29 in the cache */
   /* search207_1_0_1 -> 263 in the cache */
   /* search207_1_0 -> 511 in the cache */
   /* search207_1_1 -> 263 in the cache */
   /* search207_1_2 -> 512 in the cache */
   /* search207_1 -> 513 in the cache */
   /* search207_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 29, 513, 152 },
      -1,
   } },

   /* replace207_0 -> 29 in the cache */
   /* replace207_1 -> 48 in the cache */
   /* replace207_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search208_0_0 -> 408 in the cache */
   /* search208_0_1 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 408, 263 },
      -1,
   } },
   /* search208_1 -> 283 in the cache */
   /* search208_2_0_0 -> 200 in the cache */
   /* search208_2_0_1_0_0 -> 408 in the cache */
   /* search208_2_0_1_0 -> 414 in the cache */
   /* search208_2_0_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 200, 415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 547 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 546, 283, 548 },
      -1,
   } },

   /* replace208_0_0 -> 200 in the cache */
   /* replace208_0_1_0_0 -> 408 in the cache */
   /* replace208_0_1_0 -> 414 in the cache */
   /* replace208_0_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 200, 415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 550 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search209_0_0 -> 408 in the cache */
   /* search209_0_1 -> 263 in the cache */
   /* search209_0 -> 546 in the cache */
   /* search209_1 -> 283 in the cache */
   /* search209_2_0_0 -> 200 in the cache */
   /* search209_2_0_1_0 -> 408 in the cache */
   /* search209_2_0_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 200, 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 552 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 546, 283, 553 },
      -1,
   } },

   /* replace209_0_0 -> 200 in the cache */
   /* replace209_0_1_0 -> 408 in the cache */
   /* replace209_0_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 200, 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 555 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search210_0_0 -> 408 in the cache */
   /* search210_0_1 -> 263 in the cache */
   /* search210_0 -> 546 in the cache */
   /* search210_1 -> 283 in the cache */
   /* search210_2_0_0 -> 200 in the cache */
   /* search210_2_0_1_0 -> 408 in the cache */
   /* search210_2_0_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 200, 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 557 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 546, 283, 558 },
      -1,
   } },

   /* replace210_0_0 -> 200 in the cache */
   /* replace210_0_1_0 -> 408 in the cache */
   /* replace210_0_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      0, 1,
      { 200, 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 560 },
      -1,
   } },

   /* ('bcsel(nsz,nnan,ninf)', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmul@32', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search211_0_0 -> 408 in the cache */
   /* search211_0_1 -> 263 in the cache */
   /* search211_0 -> 546 in the cache */
   /* search211_1 -> 283 in the cache */
   /* search211_2_0_0 -> 200 in the cache */
   /* search211_2_0_1 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 200, 408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 562 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      true,
      true,
      true,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 546, 283, 563 },
      -1,
   } },

   /* replace211_0_0 -> 200 in the cache */
   /* replace211_0_1 -> 408 in the cache */
   /* replace211_0 -> 444 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 444 },
      -1,
   } },

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b'))))) => ('fexp2', ('fmulz', 'a', ('fneg', ('fabs', 'b')))) */
   /* search212_0_0 -> 408 in the cache */
   /* search212_0_1 -> 263 in the cache */
   /* search212_0 -> 546 in the cache */
   /* search212_1 -> 283 in the cache */
   /* search212_2_0_0 -> 200 in the cache */
   /* search212_2_0_1_0_0 -> 408 in the cache */
   /* search212_2_0_1_0 -> 414 in the cache */
   /* search212_2_0_1 -> 415 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 200, 415 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 566 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 546, 283, 567 },
      -1,
   } },

   /* replace212_0_0 -> 200 in the cache */
   /* replace212_0_1_0_0 -> 408 in the cache */
   /* replace212_0_1_0 -> 414 in the cache */
   /* replace212_0_1 -> 415 in the cache */
   /* replace212_0 -> 550 in the cache */
   /* replace212 -> 551 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fabs', 'b')))) => ('fexp2', ('fmulz', 'a', ('fabs', 'b'))) */
   /* search213_0_0 -> 408 in the cache */
   /* search213_0_1 -> 263 in the cache */
   /* search213_0 -> 546 in the cache */
   /* search213_1 -> 283 in the cache */
   /* search213_2_0_0 -> 200 in the cache */
   /* search213_2_0_1_0 -> 408 in the cache */
   /* search213_2_0_1 -> 414 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 200, 414 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 569 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 546, 283, 570 },
      -1,
   } },

   /* replace213_0_0 -> 200 in the cache */
   /* replace213_0_1_0 -> 408 in the cache */
   /* replace213_0_1 -> 414 in the cache */
   /* replace213_0 -> 555 in the cache */
   /* replace213 -> 556 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', ('fneg', 'b')))) => ('fexp2', ('fmulz', 'a', ('fneg', 'b'))) */
   /* search214_0_0 -> 408 in the cache */
   /* search214_0_1 -> 263 in the cache */
   /* search214_0 -> 546 in the cache */
   /* search214_1 -> 283 in the cache */
   /* search214_2_0_0 -> 200 in the cache */
   /* search214_2_0_1_0 -> 408 in the cache */
   /* search214_2_0_1 -> 422 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 200, 422 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 572 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 546, 283, 573 },
      -1,
   } },

   /* replace214_0_0 -> 200 in the cache */
   /* replace214_0_1_0 -> 408 in the cache */
   /* replace214_0_1 -> 422 in the cache */
   /* replace214_0 -> 560 in the cache */
   /* replace214 -> 561 in the cache */

   /* ('bcsel', ('feq', 'b', 0.0, 'ignore_exact'), 1.0, ('fexp2', ('fmulz', 'a', 'b'))) => ('fexp2', ('fmulz', 'a', 'b')) */
   /* search215_0_0 -> 408 in the cache */
   /* search215_0_1 -> 263 in the cache */
   /* search215_0 -> 546 in the cache */
   /* search215_1 -> 283 in the cache */
   /* search215_2_0_0 -> 200 in the cache */
   /* search215_2_0_1 -> 408 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmulz,
      1, 1,
      { 200, 408 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fexp2,
      -1, 1,
      { 575 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 546, 283, 576 },
      -1,
   } },

   /* replace215_0_0 -> 200 in the cache */
   /* replace215_0_1 -> 408 in the cache */
   /* replace215_0 -> 444 in the cache */
   /* replace215 -> 565 in the cache */

   /* ('iand(is_only_used_as_float)', 'a@16', 32767) => ('fabs', 'a') */
   /* search216_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x7fffull /* 32767 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 24, 578 },
      1,
   } },

   /* replace216_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('ixor(is_only_used_as_float)', 'a@16', 32768) => ('fneg', 'a') */
   /* search217_0 -> 24 in the cache */
   /* search217_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ixor,
      0, 1,
      { 24, 25 },
      1,
   } },

   /* replace217_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 24 },
      -1,
   } },

   /* ('ior(is_only_used_as_float)', 'a@16', 32768) => ('fneg', ('fabs', 'a')) */
   /* search218_0 -> 24 in the cache */
   /* search218_1 -> 25 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ior,
      0, 1,
      { 24, 25 },
      1,
   } },

   /* replace218_0_0 -> 24 in the cache */
   /* replace218_0 -> 580 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 580 },
      -1,
   } },

   /* ('iand(is_only_used_as_float)', 'a@32', 2147483647) => ('fabs', 'a') */
   /* search219_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x7fffffffull /* 2147483647 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 585 },
      1,
   } },

   /* replace219_0 -> 29 in the cache */
   /* replace219 -> 475 in the cache */

   /* ('ixor(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', 'a') */
   /* search220_0 -> 29 in the cache */
   /* search220_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ixor,
      0, 1,
      { 29, 30 },
      1,
   } },

   /* replace220_0 -> 29 in the cache */
   /* replace220 -> 315 in the cache */

   /* ('ior(is_only_used_as_float)', 'a@32', 2147483648) => ('fneg', ('fabs', 'a')) */
   /* search221_0 -> 29 in the cache */
   /* search221_1 -> 30 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ior,
      0, 1,
      { 29, 30 },
      1,
   } },

   /* replace221_0_0 -> 29 in the cache */
   /* replace221_0 -> 475 in the cache */
   /* replace221 -> 479 in the cache */

   /* ('iand(is_only_used_as_float)', 'a@64', 9223372036854775807) => ('fabs', 'a') */
   /* search222_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x7fffffffffffffffull /* 9223372036854775807 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 34, 589 },
      1,
   } },

   /* replace222_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fabs,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('ixor(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', 'a') */
   /* search223_0 -> 34 in the cache */
   /* search223_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ixor,
      0, 1,
      { 34, 35 },
      1,
   } },

   /* replace223_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 34 },
      -1,
   } },

   /* ('ior(is_only_used_as_float)', 'a@64', 9223372036854775808) => ('fneg', ('fabs', 'a')) */
   /* search224_0 -> 34 in the cache */
   /* search224_1 -> 35 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ior,
      0, 1,
      { 34, 35 },
      1,
   } },

   /* replace224_0_0 -> 34 in the cache */
   /* replace224_0 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 591 },
      -1,
   } },

   /* ('sdot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_i8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_i8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_i8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_i8', 'b', 3)))), 'c') */
   /* search225_0 -> 29 in the cache */
   /* search225_1 -> 48 in the cache */
   /* search225_2 -> 152 in the cache */
   /* search225 -> 366 in the cache */

   /* replace225_0_0_0_0_0 -> 29 in the cache */
   /* replace225_0_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace225_0_0_0_1_0 -> 48 in the cache */
   /* replace225_0_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 596, 597 },
      -1,
   } },
   /* replace225_0_0_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x1ull /* 1 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 29, 599 },
      -1,
   } },
   /* replace225_0_0_1_1_0 -> 48 in the cache */
   /* replace225_0_0_1_1_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 48, 599 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      4, 1,
      { 600, 601 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 3,
      { 598, 602 },
      -1,
   } },
   /* replace225_0_1_0_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x2ull /* 2 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 29, 604 },
      -1,
   } },
   /* replace225_0_1_0_1_0 -> 48 in the cache */
   /* replace225_0_1_0_1_1 -> 604 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 48, 604 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      6, 1,
      { 605, 606 },
      -1,
   } },
   /* replace225_0_1_1_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3ull /* 3 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 29, 608 },
      -1,
   } },
   /* replace225_0_1_1_1_0 -> 48 in the cache */
   /* replace225_0_1_1_1_1 -> 608 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i8,
      -1, 0,
      { 48, 608 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      7, 1,
      { 609, 610 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      5, 3,
      { 607, 611 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 7,
      { 603, 612 },
      -1,
   } },
   /* replace225_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 8,
      { 613, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_u8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_u8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_u8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_u8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search226_0 -> 29 in the cache */
   /* search226_1 -> 48 in the cache */
   /* search226_2 -> 152 in the cache */
   /* search226 -> 369 in the cache */

   /* replace226_0_0_0_0_0 -> 29 in the cache */
   /* replace226_0_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace226_0_0_0_1_0 -> 48 in the cache */
   /* replace226_0_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 615, 616 },
      -1,
   } },
   /* replace226_0_0_1_0_0 -> 29 in the cache */
   /* replace226_0_0_1_0_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 29, 599 },
      -1,
   } },
   /* replace226_0_0_1_1_0 -> 48 in the cache */
   /* replace226_0_0_1_1_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 48, 599 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      4, 1,
      { 618, 619 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 3,
      { 617, 620 },
      -1,
   } },
   /* replace226_0_1_0_0_0 -> 29 in the cache */
   /* replace226_0_1_0_0_1 -> 604 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 29, 604 },
      -1,
   } },
   /* replace226_0_1_0_1_0 -> 48 in the cache */
   /* replace226_0_1_0_1_1 -> 604 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 48, 604 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      6, 1,
      { 622, 623 },
      -1,
   } },
   /* replace226_0_1_1_0_0 -> 29 in the cache */
   /* replace226_0_1_1_0_1 -> 608 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 29, 608 },
      -1,
   } },
   /* replace226_0_1_1_1_0 -> 48 in the cache */
   /* replace226_0_1_1_1_1 -> 608 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u8,
      -1, 0,
      { 48, 608 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      7, 1,
      { 625, 626 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      5, 3,
      { 624, 627 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 7,
      { 621, 628 },
      -1,
   } },
   /* replace226_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 8,
      { 629, 152 },
      -1,
   } },

   /* ('sudot_4x8_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('iadd', ('imul', ('extract_i8', 'a', 0), ('extract_u8', 'b', 0)), ('imul', ('extract_i8', 'a', 1), ('extract_u8', 'b', 1))), ('iadd', ('imul', ('extract_i8', 'a', 2), ('extract_u8', 'b', 2)), ('imul', ('extract_i8', 'a', 3), ('extract_u8', 'b', 3)))), 'c') */
   /* search227_0 -> 29 in the cache */
   /* search227_1 -> 48 in the cache */
   /* search227_2 -> 152 in the cache */
   /* search227 -> 372 in the cache */

   /* replace227_0_0_0_0_0 -> 29 in the cache */
   /* replace227_0_0_0_0_1 -> 139 in the cache */
   /* replace227_0_0_0_0 -> 596 in the cache */
   /* replace227_0_0_0_1_0 -> 48 in the cache */
   /* replace227_0_0_0_1_1 -> 139 in the cache */
   /* replace227_0_0_0_1 -> 616 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 596, 616 },
      -1,
   } },
   /* replace227_0_0_1_0_0 -> 29 in the cache */
   /* replace227_0_0_1_0_1 -> 599 in the cache */
   /* replace227_0_0_1_0 -> 600 in the cache */
   /* replace227_0_0_1_1_0 -> 48 in the cache */
   /* replace227_0_0_1_1_1 -> 599 in the cache */
   /* replace227_0_0_1_1 -> 619 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      4, 1,
      { 600, 619 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 3,
      { 631, 632 },
      -1,
   } },
   /* replace227_0_1_0_0_0 -> 29 in the cache */
   /* replace227_0_1_0_0_1 -> 604 in the cache */
   /* replace227_0_1_0_0 -> 605 in the cache */
   /* replace227_0_1_0_1_0 -> 48 in the cache */
   /* replace227_0_1_0_1_1 -> 604 in the cache */
   /* replace227_0_1_0_1 -> 623 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      6, 1,
      { 605, 623 },
      -1,
   } },
   /* replace227_0_1_1_0_0 -> 29 in the cache */
   /* replace227_0_1_1_0_1 -> 608 in the cache */
   /* replace227_0_1_1_0 -> 609 in the cache */
   /* replace227_0_1_1_1_0 -> 48 in the cache */
   /* replace227_0_1_1_1_1 -> 608 in the cache */
   /* replace227_0_1_1_1 -> 626 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      7, 1,
      { 609, 626 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      5, 3,
      { 634, 635 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 7,
      { 633, 636 },
      -1,
   } },
   /* replace227_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 8,
      { 637, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search228_0 -> 29 in the cache */
   /* search228_1 -> 48 in the cache */
   /* search228_2 -> 152 in the cache */
   /* search228 -> 378 in the cache */

   /* replace228_0_0_0_0 -> 29 in the cache */
   /* replace228_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace228_0_0_1_0 -> 48 in the cache */
   /* replace228_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 639, 640 },
      -1,
   } },
   /* replace228_0_1_0_0 -> 29 in the cache */
   /* replace228_0_1_0_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 29, 599 },
      -1,
   } },
   /* replace228_0_1_1_0 -> 48 in the cache */
   /* replace228_0_1_1_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_i16,
      -1, 0,
      { 48, 599 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 642, 643 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 641, 644 },
      -1,
   } },
   /* replace228_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 645, 152 },
      -1,
   } },

   /* ('udot_2x16_uadd', 'a', 'b', 'c') => ('iadd', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search229_0 -> 29 in the cache */
   /* search229_1 -> 48 in the cache */
   /* search229_2 -> 152 in the cache */
   /* search229 -> 381 in the cache */

   /* replace229_0_0_0_0 -> 29 in the cache */
   /* replace229_0_0_0_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 29, 139 },
      -1,
   } },
   /* replace229_0_0_1_0 -> 48 in the cache */
   /* replace229_0_0_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 48, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 647, 648 },
      -1,
   } },
   /* replace229_0_1_0_0 -> 29 in the cache */
   /* replace229_0_1_0_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 29, 599 },
      -1,
   } },
   /* replace229_0_1_1_0 -> 48 in the cache */
   /* replace229_0_1_1_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_extract_u16,
      -1, 0,
      { 48, 599 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 650, 651 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 649, 652 },
      -1,
   } },
   /* replace229_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 653, 152 },
      -1,
   } },

   /* ('udot_4x8_uadd_sat', 'a', 'b', '#c(is_ult_0xfffc07fc)') => ('udot_4x8_uadd', 'a', 'b', 'c') */
   /* search230_0 -> 29 in the cache */
   /* search230_1 -> 48 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      8,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 655 },
      -1,
   } },

   /* replace230_0 -> 29 in the cache */
   /* replace230_1 -> 48 in the cache */
   /* replace230_2 -> 152 in the cache */
   /* replace230 -> 369 in the cache */

   /* ('udot_4x8_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('udot_4x8_uadd', 'a', 'b', 0), 'c') */
   /* search231_0 -> 29 in the cache */
   /* search231_1 -> 48 in the cache */
   /* search231_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_4x8_uadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace231_0_0 -> 29 in the cache */
   /* replace231_0_1 -> 48 in the cache */
   /* replace231_0_2 -> 139 in the cache */
   /* replace231_0 -> 387 in the cache */
   /* replace231_1 -> 152 in the cache */
   /* replace231 -> 401 in the cache */

   /* ('sdot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sdot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search232_0 -> 29 in the cache */
   /* search232_1 -> 48 in the cache */
   /* search232_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_4x8_iadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace232_0_0 -> 29 in the cache */
   /* replace232_0_1 -> 48 in the cache */
   /* replace232_0_2 -> 139 in the cache */
   /* replace232_0 -> 384 in the cache */
   /* replace232_1 -> 152 in the cache */
   /* replace232 -> 399 in the cache */

   /* ('sudot_4x8_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('sudot_4x8_iadd', 'a', 'b', 0), 'c') */
   /* search233_0 -> 29 in the cache */
   /* search233_1 -> 48 in the cache */
   /* search233_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sudot_4x8_iadd_sat,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* replace233_0_0 -> 29 in the cache */
   /* replace233_0_1 -> 48 in the cache */
   /* replace233_0_2 -> 139 in the cache */
   /* replace233_0 -> 390 in the cache */
   /* replace233_1 -> 152 in the cache */
   /* replace233 -> 403 in the cache */

   /* ('udot_2x16_uadd_sat', 'a', 'b', 'c') => ('uadd_sat', ('iadd', ('imul', ('extract_u16', 'a', 0), ('extract_u16', 'b', 0)), ('imul', ('extract_u16', 'a', 1), ('extract_u16', 'b', 1))), 'c') */
   /* search234_0 -> 29 in the cache */
   /* search234_1 -> 48 in the cache */
   /* search234_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_udot_2x16_uadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace234_0_0_0_0 -> 29 in the cache */
   /* replace234_0_0_0_1 -> 139 in the cache */
   /* replace234_0_0_0 -> 647 in the cache */
   /* replace234_0_0_1_0 -> 48 in the cache */
   /* replace234_0_0_1_1 -> 139 in the cache */
   /* replace234_0_0_1 -> 648 in the cache */
   /* replace234_0_0 -> 649 in the cache */
   /* replace234_0_1_0_0 -> 29 in the cache */
   /* replace234_0_1_0_1 -> 599 in the cache */
   /* replace234_0_1_0 -> 650 in the cache */
   /* replace234_0_1_1_0 -> 48 in the cache */
   /* replace234_0_1_1_1 -> 599 in the cache */
   /* replace234_0_1_1 -> 651 in the cache */
   /* replace234_0_1 -> 652 in the cache */
   /* replace234_0 -> 653 in the cache */
   /* replace234_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uadd_sat,
      0, 4,
      { 653, 152 },
      -1,
   } },

   /* ('sdot_2x16_iadd_sat', 'a', 'b', 'c') => ('iadd_sat', ('iadd', ('imul', ('extract_i16', 'a', 0), ('extract_i16', 'b', 0)), ('imul', ('extract_i16', 'a', 1), ('extract_i16', 'b', 1))), 'c') */
   /* search235_0 -> 29 in the cache */
   /* search235_1 -> 48 in the cache */
   /* search235_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_sdot_2x16_iadd_sat,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace235_0_0_0_0 -> 29 in the cache */
   /* replace235_0_0_0_1 -> 139 in the cache */
   /* replace235_0_0_0 -> 639 in the cache */
   /* replace235_0_0_1_0 -> 48 in the cache */
   /* replace235_0_0_1_1 -> 139 in the cache */
   /* replace235_0_0_1 -> 640 in the cache */
   /* replace235_0_0 -> 641 in the cache */
   /* replace235_0_1_0_0 -> 29 in the cache */
   /* replace235_0_1_0_1 -> 599 in the cache */
   /* replace235_0_1_0 -> 642 in the cache */
   /* replace235_0_1_1_0 -> 48 in the cache */
   /* replace235_0_1_1_1 -> 599 in the cache */
   /* replace235_0_1_1 -> 643 in the cache */
   /* replace235_0_1 -> 644 in the cache */
   /* replace235_0 -> 645 in the cache */
   /* replace235_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd_sat,
      0, 4,
      { 645, 152 },
      -1,
   } },

   /* ('~flrp@16', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search236_0 -> 24 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 24, 664, 666 },
      -1,
   } },

   /* replace236_0 -> 665 in the cache */
   /* replace236_1 -> 664 in the cache */
   /* replace236_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 665, 664, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search237_0 -> 24 in the cache */
   /* search237_1_0 -> 24 in the cache */
   /* search237_1_1 -> 664 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 24, 664 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 24, 669, 670 },
      -1,
   } },

   /* replace237_0_0 -> 664 in the cache */
   /* replace237_0_1 -> 670 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 664, 670 },
      -1,
   } },
   /* replace237_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 672, 24 },
      -1,
   } },

   /* ('~flrp@16', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search238_0_0 -> 24 in the cache */
   /* search238_0_1 -> 664 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 24, 664 },
      0,
   } },
   /* search238_1_0 -> 24 in the cache */
   /* search238_1_1 -> 670 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 24, 670 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 2,
      { 674, 675, 676 },
      -1,
   } },

   /* replace238_0_0 -> 664 in the cache */
   /* replace238_0_1 -> 670 in the cache */
   /* replace238_0_2 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 664, 670, 676 },
      -1,
   } },
   /* replace238_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 678, 24 },
      -1,
   } },

   /* ('~flrp@16', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search239_0 -> 24 in the cache */
   /* search239_1_0 -> 24 in the cache */
   /* search239_1_1 -> 664 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 24, 664 },
      0,
   } },
   /* search239_2 -> 670 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 24, 680, 670 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace239_0_1 -> 664 in the cache */
   /* replace239_0_2 -> 670 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 682, 664, 670 },
      -1,
   } },
   /* replace239_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 683, 24 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search240_0_0 -> 24 in the cache */
   /* search240_0_1_0 -> 682 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 685 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 682, 686 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 24, 687 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search240_1_1 -> 685 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 689, 685 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 688, 690 },
      -1,
   } },

   /* replace240_0 -> 24 in the cache */
   /* replace240_1 -> 689 in the cache */
   /* replace240_2 -> 685 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 24, 689, 685 },
      -1,
   } },

   /* ('~fadd@16', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search241_0_0 -> 24 in the cache */
   /* search241_0_1_0_0 -> 682 in the cache */
   /* search241_0_1_0_1_0 -> 685 in the cache */
   /* search241_0_1_0_1 -> 686 in the cache */
   /* search241_0_1_0 -> 687 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 687 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 24, 693 },
      -1,
   } },
   /* search241_1_0 -> 689 in the cache */
   /* search241_1_1_0 -> 685 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 685 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 689, 695 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 694, 696 },
      -1,
   } },

   /* replace241_0 -> 24 in the cache */
   /* replace241_1 -> 689 in the cache */
   /* replace241_2_0 -> 685 in the cache */
   /* replace241_2 -> 695 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 24, 689, 695 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search242_0 -> 24 in the cache */
   /* search242_1_0 -> 685 in the cache */
   /* search242_1_1_0 -> 689 in the cache */
   /* search242_1_1_1_0 -> 24 in the cache */
   /* search242_1_1_1 -> 582 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 689, 582 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 685, 699 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 24, 700 },
      -1,
   } },

   /* replace242_0 -> 24 in the cache */
   /* replace242_1 -> 689 in the cache */
   /* replace242_2 -> 685 in the cache */
   /* replace242 -> 692 in the cache */

   /* ('~fadd@16', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search243_0_0 -> 24 in the cache */
   /* search243_0_1_0 -> 682 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 682, 704 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 24, 705 },
      -1,
   } },
   /* search243_1_0 -> 689 in the cache */
   /* search243_1_1_0 -> 702 in the cache */
   /* search243_1_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 689, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 706, 707 },
      -1,
   } },

   /* replace243_0 -> 702 in the cache */
   /* replace243_1 -> 689 in the cache */
   /* replace243_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 702, 689, 24 },
      -1,
   } },

   /* ('~fadd@16', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search244_0 -> 24 in the cache */
   /* search244_1_0_0 -> 702 in the cache */
   /* search244_1_0 -> 703 in the cache */
   /* search244_1_1_0 -> 689 in the cache */
   /* search244_1_1_1_0 -> 24 in the cache */
   /* search244_1_1_1 -> 582 in the cache */
   /* search244_1_1 -> 699 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 703, 699 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 24, 710 },
      -1,
   } },

   /* replace244_0 -> 702 in the cache */
   /* replace244_1 -> 689 in the cache */
   /* replace244_2 -> 24 in the cache */
   /* replace244 -> 709 in the cache */

   /* ('~ffma@16', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search245_0 -> 24 in the cache */
   /* search245_1_0 -> 682 in the cache */
   /* search245_1_1_0_0 -> 702 in the cache */
   /* search245_1_1_0 -> 703 in the cache */
   /* search245_1_1 -> 704 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 682, 704 },
      -1,
   } },
   /* search245_2_0 -> 689 in the cache */
   /* search245_2_1_0 -> 702 in the cache */
   /* search245_2_1 -> 703 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 689, 703 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 24, 712, 713 },
      -1,
   } },

   /* replace245_0 -> 702 in the cache */
   /* replace245_1 -> 689 in the cache */
   /* replace245_2 -> 24 in the cache */
   /* replace245 -> 709 in the cache */

   /* ('~ffma@16', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 16 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search246_1_0 -> 702 in the cache */
   /* search246_1 -> 703 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 716 },
      -1,
   } },
   /* search246_2_1_0 -> 702 in the cache */
   /* search246_2_1 -> 703 in the cache */
   /* search246_2_2 -> 716 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 717, 703, 716 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 715, 703, 718 },
      -1,
   } },

   /* replace246_0 -> 702 in the cache */
   /* replace246_1 -> 715 in the cache */
   /* replace246_2 -> 716 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 702, 715, 716 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 721 },
      -1,
   } },
   /* search247_1_0 -> 664 in the cache */
   /* search247_1_1_0 -> 716 in the cache */
   /* search247_1_1 -> 717 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 664, 717 },
      -1,
   } },
   /* search247_2 -> 716 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 722, 723, 716 },
      -1,
   } },

   /* replace247_0 -> 721 in the cache */
   /* replace247_1 -> 664 in the cache */
   /* replace247_2 -> 716 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 721, 664, 716 },
      -1,
   } },

   /* ('~ffma@16', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search248_0_0 -> 721 in the cache */
   /* search248_0 -> 722 in the cache */
   { .variable = {
      { nir_search_value_variable, 16 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 726 },
      -1,
   } },
   /* search248_1_1 -> 689 in the cache */
   /* search248_1_2 -> 676 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 727, 689, 676 },
      -1,
   } },
   /* search248_2_0 -> 726 in the cache */
   /* search248_2_1 -> 689 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 726, 689 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 722, 728, 729 },
      -1,
   } },

   /* replace248_0 -> 721 in the cache */
   /* replace248_1 -> 676 in the cache */
   /* replace248_2_0 -> 726 in the cache */
   /* replace248_2_1 -> 689 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 726, 689 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 721, 676, 731 },
      -1,
   } },

   /* ('~fadd@16', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search249_0 -> 682 in the cache */
   /* search249_1_0_0_0 -> 682 in the cache */
   /* search249_1_0_0_1_0 -> 24 in the cache */
   /* search249_1_0_0_1 -> 582 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 682, 582 },
      -1,
   } },
   /* search249_1_0_1_0 -> 682 in the cache */
   /* search249_1_0_1_1_0 -> 664 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 664 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      3, 1,
      { 682, 734 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 3,
      { 733, 735 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 3,
      { 736 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 682, 737 },
      -1,
   } },

   /* replace249_0 -> 664 in the cache */
   /* replace249_1 -> 682 in the cache */
   /* replace249_2 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flrp,
      -1, 0,
      { 664, 682, 24 },
      -1,
   } },

   /* ('~flrp@32', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search250_0 -> 29 in the cache */
   /* search250_1 -> 48 in the cache */
   /* search250_2_0 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 29, 48, 740 },
      -1,
   } },

   /* replace250_0 -> 665 in the cache */
   /* replace250_1 -> 48 in the cache */
   /* replace250_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 665, 48, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search251_0 -> 29 in the cache */
   /* search251_1_0 -> 29 in the cache */
   /* search251_1_1 -> 48 in the cache */
   /* search251_1 -> 309 in the cache */
   /* search251_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 29, 309, 152 },
      -1,
   } },

   /* replace251_0_0 -> 48 in the cache */
   /* replace251_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 48, 152 },
      -1,
   } },
   /* replace251_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 744, 29 },
      -1,
   } },

   /* ('~flrp@32', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search252_0_0 -> 29 in the cache */
   /* search252_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search252_1_0 -> 29 in the cache */
   /* search252_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 29, 152 },
      0,
   } },
   /* search252_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 2,
      { 746, 747, 180 },
      -1,
   } },

   /* replace252_0_0 -> 48 in the cache */
   /* replace252_0_1 -> 152 in the cache */
   /* replace252_0_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 48, 152, 180 },
      -1,
   } },
   /* replace252_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 749, 29 },
      -1,
   } },

   /* ('~flrp@32', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search253_0 -> 29 in the cache */
   /* search253_1_0 -> 29 in the cache */
   /* search253_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 29, 48 },
      0,
   } },
   /* search253_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 29, 751, 152 },
      -1,
   } },

   /* replace253_0_0 -> 283 in the cache */
   /* replace253_0_1 -> 48 in the cache */
   /* replace253_0_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 283, 48, 152 },
      -1,
   } },
   /* replace253_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 753, 29 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search254_0_0 -> 29 in the cache */
   /* search254_0_1_0 -> 283 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 283, 756 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 29, 757 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search254_1_1 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 759, 755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 758, 760 },
      -1,
   } },

   /* replace254_0 -> 29 in the cache */
   /* replace254_1 -> 759 in the cache */
   /* replace254_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 29, 759, 755 },
      -1,
   } },

   /* ('~fadd@32', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search255_0_0 -> 29 in the cache */
   /* search255_0_1_0_0 -> 283 in the cache */
   /* search255_0_1_0_1_0 -> 755 in the cache */
   /* search255_0_1_0_1 -> 756 in the cache */
   /* search255_0_1_0 -> 757 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 757 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 29, 763 },
      -1,
   } },
   /* search255_1_0 -> 759 in the cache */
   /* search255_1_1_0 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 755 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 759, 765 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 764, 766 },
      -1,
   } },

   /* replace255_0 -> 29 in the cache */
   /* replace255_1 -> 759 in the cache */
   /* replace255_2_0 -> 755 in the cache */
   /* replace255_2 -> 765 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 29, 759, 765 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search256_0 -> 29 in the cache */
   /* search256_1_0 -> 755 in the cache */
   /* search256_1_1_0 -> 759 in the cache */
   /* search256_1_1_1_0 -> 29 in the cache */
   /* search256_1_1_1 -> 315 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 759, 315 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 755, 769 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 29, 770 },
      -1,
   } },

   /* replace256_0 -> 29 in the cache */
   /* replace256_1 -> 759 in the cache */
   /* replace256_2 -> 755 in the cache */
   /* replace256 -> 762 in the cache */

   /* ('~fadd@32', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search257_0_0 -> 29 in the cache */
   /* search257_0_1_0 -> 283 in the cache */
   /* search257_0_1_1_0_0 -> 702 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 283, 773 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 29, 774 },
      -1,
   } },
   /* search257_1_0 -> 759 in the cache */
   /* search257_1_1_0 -> 702 in the cache */
   /* search257_1_1 -> 772 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 759, 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 775, 776 },
      -1,
   } },

   /* replace257_0 -> 702 in the cache */
   /* replace257_1 -> 759 in the cache */
   /* replace257_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 702, 759, 29 },
      -1,
   } },

   /* ('~fadd@32', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search258_0 -> 29 in the cache */
   /* search258_1_0_0 -> 702 in the cache */
   /* search258_1_0 -> 772 in the cache */
   /* search258_1_1_0 -> 759 in the cache */
   /* search258_1_1_1_0 -> 29 in the cache */
   /* search258_1_1_1 -> 315 in the cache */
   /* search258_1_1 -> 769 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 772, 769 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 29, 779 },
      -1,
   } },

   /* replace258_0 -> 702 in the cache */
   /* replace258_1 -> 759 in the cache */
   /* replace258_2 -> 29 in the cache */
   /* replace258 -> 778 in the cache */

   /* ('~ffma@32', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search259_0 -> 29 in the cache */
   /* search259_1_0 -> 283 in the cache */
   /* search259_1_1_0_0 -> 702 in the cache */
   /* search259_1_1_0 -> 772 in the cache */
   /* search259_1_1 -> 773 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 283, 773 },
      -1,
   } },
   /* search259_2_0 -> 759 in the cache */
   /* search259_2_1_0 -> 702 in the cache */
   /* search259_2_1 -> 772 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 759, 772 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 29, 781, 782 },
      -1,
   } },

   /* replace259_0 -> 702 in the cache */
   /* replace259_1 -> 759 in the cache */
   /* replace259_2 -> 29 in the cache */
   /* replace259 -> 778 in the cache */

   /* ('~ffma@32', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   /* search260_0 -> 408 in the cache */
   /* search260_1_0 -> 702 in the cache */
   /* search260_1 -> 772 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 784 },
      -1,
   } },
   /* search260_2_1_0 -> 702 in the cache */
   /* search260_2_1 -> 772 in the cache */
   /* search260_2_2 -> 784 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 785, 772, 784 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 408, 772, 786 },
      -1,
   } },

   /* replace260_0 -> 702 in the cache */
   /* replace260_1 -> 408 in the cache */
   /* replace260_2 -> 784 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 702, 408, 784 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search261_0_0 -> 721 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 721 },
      -1,
   } },
   /* search261_1_0 -> 48 in the cache */
   /* search261_1_1_0 -> 784 in the cache */
   /* search261_1_1 -> 785 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 48, 785 },
      -1,
   } },
   /* search261_2 -> 784 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 789, 790, 784 },
      -1,
   } },

   /* replace261_0 -> 721 in the cache */
   /* replace261_1 -> 48 in the cache */
   /* replace261_2 -> 784 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 721, 48, 784 },
      -1,
   } },

   /* ('~ffma@32', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search262_0_0 -> 721 in the cache */
   /* search262_0 -> 789 in the cache */
   /* search262_1_0_0 -> 200 in the cache */
   /* search262_1_0 -> 436 in the cache */
   /* search262_1_1 -> 759 in the cache */
   /* search262_1_2 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 436, 759, 180 },
      -1,
   } },
   /* search262_2_0 -> 200 in the cache */
   /* search262_2_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 200, 759 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 789, 793, 794 },
      -1,
   } },

   /* replace262_0 -> 721 in the cache */
   /* replace262_1 -> 180 in the cache */
   /* replace262_2_0 -> 200 in the cache */
   /* replace262_2_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 200, 759 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 721, 180, 796 },
      -1,
   } },

   /* ('~fadd@32', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search263_0 -> 283 in the cache */
   /* search263_1_0_0_0 -> 283 in the cache */
   /* search263_1_0_0_1_0 -> 29 in the cache */
   /* search263_1_0_0_1 -> 315 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 283, 315 },
      -1,
   } },
   /* search263_1_0_1_0 -> 283 in the cache */
   /* search263_1_0_1_1_0 -> 48 in the cache */
   /* search263_1_0_1_1 -> 487 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      3, 1,
      { 283, 487 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 3,
      { 798, 799 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 3,
      { 800 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 283, 801 },
      -1,
   } },

   /* replace263_0 -> 48 in the cache */
   /* replace263_1 -> 283 in the cache */
   /* replace263_2 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flrp,
      -1, 0,
      { 48, 283, 29 },
      -1,
   } },

   /* ('~flrp@64', 'a', 'b', ('b2f', 'c@1')) => ('bcsel', 'c', 'b', 'a') */
   /* search264_0 -> 34 in the cache */
   /* search264_1 -> 53 in the cache */
   /* search264_2_0 -> 665 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 665 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 34, 53, 804 },
      -1,
   } },

   /* replace264_0 -> 665 in the cache */
   /* replace264_1 -> 53 in the cache */
   /* replace264_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 665, 53, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fadd', 'a', 'b'), 'c') => ('fadd', ('fmul', 'b', 'c'), 'a') */
   /* search265_0 -> 34 in the cache */
   /* search265_1_0 -> 34 in the cache */
   /* search265_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 34, 807, 808 },
      -1,
   } },

   /* replace265_0_0 -> 53 in the cache */
   /* replace265_0_1 -> 808 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 53, 808 },
      -1,
   } },
   /* replace265_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 810, 34 },
      -1,
   } },

   /* ('~flrp@64', ('fadd(is_used_once)', 'a', 'b'), ('fadd(is_used_once)', 'a', 'c'), 'd') => ('fadd', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search266_0_0 -> 34 in the cache */
   /* search266_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search266_1_0 -> 34 in the cache */
   /* search266_1_1 -> 808 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 34, 808 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 2,
      { 812, 813, 814 },
      -1,
   } },

   /* replace266_0_0 -> 53 in the cache */
   /* replace266_0_1 -> 808 in the cache */
   /* replace266_0_2 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 53, 808, 814 },
      -1,
   } },
   /* replace266_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 816, 34 },
      -1,
   } },

   /* ('~flrp@64', 'a', ('fmul(is_used_once)', 'a', 'b'), 'c') => ('fmul', ('flrp', 1.0, 'b', 'c'), 'a') */
   /* search267_0 -> 34 in the cache */
   /* search267_1_0 -> 34 in the cache */
   /* search267_1_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 34, 53 },
      0,
   } },
   /* search267_2 -> 808 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 1,
      { 34, 818, 808 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   /* replace267_0_1 -> 53 in the cache */
   /* replace267_0_2 -> 808 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 820, 53, 808 },
      -1,
   } },
   /* replace267_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 821, 34 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', 'c'))), ('fmul', 'b', 'c')) => ('flrp', 'a', 'b', 'c') */
   /* search268_0_0 -> 34 in the cache */
   /* search268_0_1_0 -> 820 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 823 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 820, 824 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 34, 825 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search268_1_1 -> 823 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 827, 823 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 826, 828 },
      -1,
   } },

   /* replace268_0 -> 34 in the cache */
   /* replace268_1 -> 827 in the cache */
   /* replace268_2 -> 823 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 34, 827, 823 },
      -1,
   } },

   /* ('~fadd@64', ('fmul', 'a', ('fsat', ('fadd', 1.0, ('fneg', 'c')))), ('fmul', 'b', ('fsat', 'c'))) => ('flrp', 'a', 'b', ('fsat', 'c')) */
   /* search269_0_0 -> 34 in the cache */
   /* search269_0_1_0_0 -> 820 in the cache */
   /* search269_0_1_0_1_0 -> 823 in the cache */
   /* search269_0_1_0_1 -> 824 in the cache */
   /* search269_0_1_0 -> 825 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 825 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 34, 831 },
      -1,
   } },
   /* search269_1_0 -> 827 in the cache */
   /* search269_1_1_0 -> 823 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 823 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 827, 833 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 832, 834 },
      -1,
   } },

   /* replace269_0 -> 34 in the cache */
   /* replace269_1 -> 827 in the cache */
   /* replace269_2_0 -> 823 in the cache */
   /* replace269_2 -> 833 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 34, 827, 833 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', 'c', ('fadd', 'b', ('fneg', 'a')))) => ('flrp', 'a', 'b', 'c') */
   /* search270_0 -> 34 in the cache */
   /* search270_1_0 -> 823 in the cache */
   /* search270_1_1_0 -> 827 in the cache */
   /* search270_1_1_1_0 -> 34 in the cache */
   /* search270_1_1_1 -> 593 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 827, 593 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 823, 837 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 34, 838 },
      -1,
   } },

   /* replace270_0 -> 34 in the cache */
   /* replace270_1 -> 827 in the cache */
   /* replace270_2 -> 823 in the cache */
   /* replace270 -> 830 in the cache */

   /* ('~fadd@64', ('fmul', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1')))), ('fmul', 'b', ('b2f', 'c'))) => ('bcsel', 'c', 'b', 'a') */
   /* search271_0_0 -> 34 in the cache */
   /* search271_0_1_0 -> 820 in the cache */
   /* search271_0_1_1_0_0 -> 702 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 702 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 840 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 820, 841 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 34, 842 },
      -1,
   } },
   /* search271_1_0 -> 827 in the cache */
   /* search271_1_1_0 -> 702 in the cache */
   /* search271_1_1 -> 840 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 827, 840 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 843, 844 },
      -1,
   } },

   /* replace271_0 -> 702 in the cache */
   /* replace271_1 -> 827 in the cache */
   /* replace271_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 702, 827, 34 },
      -1,
   } },

   /* ('~fadd@64', 'a', ('fmul', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')))) => ('bcsel', 'c', 'b', 'a') */
   /* search272_0 -> 34 in the cache */
   /* search272_1_0_0 -> 702 in the cache */
   /* search272_1_0 -> 840 in the cache */
   /* search272_1_1_0 -> 827 in the cache */
   /* search272_1_1_1_0 -> 34 in the cache */
   /* search272_1_1_1 -> 593 in the cache */
   /* search272_1_1 -> 837 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 2,
      { 840, 837 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 3,
      { 34, 847 },
      -1,
   } },

   /* replace272_0 -> 702 in the cache */
   /* replace272_1 -> 827 in the cache */
   /* replace272_2 -> 34 in the cache */
   /* replace272 -> 846 in the cache */

   /* ('~ffma@64', 'a', ('fadd', 1.0, ('fneg', ('b2f', 'c@1'))), ('fmul', 'b', ('b2f', 'c@1'))) => ('bcsel', 'c', 'b', 'a') */
   /* search273_0 -> 34 in the cache */
   /* search273_1_0 -> 820 in the cache */
   /* search273_1_1_0_0 -> 702 in the cache */
   /* search273_1_1_0 -> 840 in the cache */
   /* search273_1_1 -> 841 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 820, 841 },
      -1,
   } },
   /* search273_2_0 -> 827 in the cache */
   /* search273_2_1_0 -> 702 in the cache */
   /* search273_2_1 -> 840 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 827, 840 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 34, 849, 850 },
      -1,
   } },

   /* replace273_0 -> 702 in the cache */
   /* replace273_1 -> 827 in the cache */
   /* replace273_2 -> 34 in the cache */
   /* replace273 -> 846 in the cache */

   /* ('~ffma@64', 'b', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), ('b2f', 'c@1'), 'a')) => ('bcsel', 'c', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, 64 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search274_1_0 -> 702 in the cache */
   /* search274_1 -> 840 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      2, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 853 },
      -1,
   } },
   /* search274_2_1_0 -> 702 in the cache */
   /* search274_2_1 -> 840 in the cache */
   /* search274_2_2 -> 853 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 854, 840, 853 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 852, 840, 855 },
      -1,
   } },

   /* replace274_0 -> 702 in the cache */
   /* replace274_1 -> 852 in the cache */
   /* replace274_2 -> 853 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 702, 852, 853 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('fadd', 'b', ('fneg', 'a')), 'a') => ('bcsel', 'c', 'b', 'a') */
   /* search275_0_0 -> 721 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 721 },
      -1,
   } },
   /* search275_1_0 -> 53 in the cache */
   /* search275_1_1_0 -> 853 in the cache */
   /* search275_1_1 -> 854 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 53, 854 },
      -1,
   } },
   /* search275_2 -> 853 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 2,
      { 858, 859, 853 },
      -1,
   } },

   /* replace275_0 -> 721 in the cache */
   /* replace275_1 -> 53 in the cache */
   /* replace275_2 -> 853 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 721, 53, 853 },
      -1,
   } },

   /* ('~ffma@64', ('b2f', 'c@1'), ('ffma', ('fneg', 'a'), 'b', 'd'), ('fmul', 'a', 'b')) => ('bcsel', 'c', 'd', ('fmul', 'a', 'b')) */
   /* search276_0_0 -> 721 in the cache */
   /* search276_0 -> 858 in the cache */
   { .variable = {
      { nir_search_value_variable, 64 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 862 },
      -1,
   } },
   /* search276_1_1 -> 827 in the cache */
   /* search276_1_2 -> 814 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      1, 1,
      { 863, 827, 814 },
      -1,
   } },
   /* search276_2_0 -> 862 in the cache */
   /* search276_2_1 -> 827 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 862, 827 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 3,
      { 858, 864, 865 },
      -1,
   } },

   /* replace276_0 -> 721 in the cache */
   /* replace276_1 -> 814 in the cache */
   /* replace276_2_0 -> 862 in the cache */
   /* replace276_2_1 -> 827 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 862, 827 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 721, 814, 867 },
      -1,
   } },

   /* ('~fadd@64', 1.0, ('fneg', ('fmul', ('fadd', 1.0, ('fneg', 'a')), ('fadd', 1.0, ('fneg', 'b'))))) => ('flrp', 'b', 1.0, 'a') */
   /* search277_0 -> 820 in the cache */
   /* search277_1_0_0_0 -> 820 in the cache */
   /* search277_1_0_0_1_0 -> 34 in the cache */
   /* search277_1_0_0_1 -> 593 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      2, 1,
      { 820, 593 },
      -1,
   } },
   /* search277_1_0_1_0 -> 820 in the cache */
   /* search277_1_0_1_1_0 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 53 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      3, 1,
      { 820, 870 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 3,
      { 869, 871 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 3,
      { 872 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 4,
      { 820, 873 },
      -1,
   } },

   /* replace277_0 -> 53 in the cache */
   /* replace277_1 -> 820 in the cache */
   /* replace277_2 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flrp,
      -1, 0,
      { 53, 820, 34 },
      -1,
   } },

   /* ('~flrp', ('fmul(is_used_once)', 'a', 'b'), ('fmul(is_used_once)', 'a', 'c'), 'd') => ('fmul', ('flrp', 'b', 'c', 'd'), 'a') */
   /* search278_0_0 -> 166 in the cache */
   /* search278_0_1 -> 167 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 166, 167 },
      0,
   } },
   /* search278_1_0 -> 166 in the cache */
   /* search278_1_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 166, 169 },
      0,
   } },
   /* search278_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 2,
      { 876, 877, 170 },
      -1,
   } },

   /* replace278_0_0 -> 167 in the cache */
   /* replace278_0_1 -> 169 in the cache */
   /* replace278_0_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flrp,
      -1, 0,
      { 167, 169, 170 },
      -1,
   } },
   /* replace278_1 -> 166 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 879, 166 },
      -1,
   } },

   /* ('~flrp', 'a', 0.0, 'c') => ('fadd', ('fmul', ('fneg', 'a'), 'c'), 'a') */
   /* search279_0 -> 0 in the cache */
   /* search279_1 -> 295 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flrp,
      -1, 0,
      { 0, 295, 881 },
      -1,
   } },

   /* replace279_0_0_0 -> 0 in the cache */
   /* replace279_0_0 -> 132 in the cache */
   /* replace279_0_1 -> 881 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 132, 881 },
      -1,
   } },
   /* replace279_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 883, 0 },
      -1,
   } },

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('iand', ('flt', 'a', 0), ('flt', ('fneg', ('ffract', 'a')), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search280_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search280_1_0_0_0 -> 9 in the cache */
   /* search280_1_0_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 9, 73 },
      -1,
   } },
   /* search280_1_0_1_0_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 887 },
      -1,
   } },
   /* search280_1_0_1_1_0 -> 9 in the cache */
   /* search280_1_0_1_1 -> 887 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 888, 887 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      1, 1,
      { 886, 889 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 890 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 885, 891 },
      -1,
   } },

   /* replace280_0_0 -> 9 in the cache */
   /* replace280_0_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      0, 1,
      { 9, 73 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 1,
      { 893 },
      -1,
   } },

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('inot', ('fge', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a')))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search281_0_0 -> 9 in the cache */
   /* search281_0 -> 885 in the cache */
   /* search281_1_0_0_0 -> 73 in the cache */
   /* search281_1_0_0_1_0_0 -> 9 in the cache */
   /* search281_1_0_0_1_0 -> 118 in the cache */
   /* search281_1_0_0_1_1_0 -> 9 in the cache */
   /* search281_1_0_0_1_1 -> 887 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 118, 887 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 73, 895 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 896 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 897 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 885, 898 },
      -1,
   } },

   /* replace281_0_0 -> 9 in the cache */
   /* replace281_0_1 -> 73 in the cache */
   /* replace281_0 -> 893 in the cache */
   /* replace281 -> 894 in the cache */

   /* ('fadd', ('ffloor', 'a'), ('b2f', ('flt', 0, ('fmin', ('fneg', 'a'), ('ffract', 'a'))))) => ('ftrunc', ('fadd', 'a', 0)) */
   /* search282_0_0 -> 9 in the cache */
   /* search282_0 -> 885 in the cache */
   /* search282_1_0_0 -> 73 in the cache */
   /* search282_1_0_1_0_0 -> 9 in the cache */
   /* search282_1_0_1_0 -> 118 in the cache */
   /* search282_1_0_1_1_0 -> 9 in the cache */
   /* search282_1_0_1_1 -> 887 in the cache */
   /* search282_1_0_1 -> 895 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 73, 895 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 900 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 885, 901 },
      -1,
   } },

   /* replace282_0_0 -> 9 in the cache */
   /* replace282_0_1 -> 73 in the cache */
   /* replace282_0 -> 893 in the cache */
   /* replace282 -> 894 in the cache */

   /* ('fadd(nnan,nsz)', 'a', ('ffract', ('fneg', 'a'))) => ('fceil', 'a') */
   /* search283_0 -> 9 in the cache */
   /* search283_1_0_0 -> 9 in the cache */
   /* search283_1_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      true,
      true,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 9, 903 },
      -1,
   } },

   /* replace283_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fceil,
      -1, 0,
      { 9 },
      -1,
   } },

   /* ('ftrunc@16', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search284_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace284_0_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 24, 907 },
      -1,
   } },
   /* replace284_1_0_0_0 -> 24 in the cache */
   /* replace284_1_0_0 -> 580 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 580 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 909 },
      -1,
   } },
   /* replace284_2_0_0 -> 24 in the cache */
   /* replace284_2_0 -> 580 in the cache */
   /* replace284_2 -> 909 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 908, 910, 909 },
      -1,
   } },

   /* ('ftrunc@32', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search285_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace285_0_0 -> 29 in the cache */
   /* replace285_0_1 -> 263 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 29, 263 },
      -1,
   } },
   /* replace285_1_0_0_0 -> 29 in the cache */
   /* replace285_1_0_0 -> 475 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 475 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 914 },
      -1,
   } },
   /* replace285_2_0_0 -> 29 in the cache */
   /* replace285_2_0 -> 475 in the cache */
   /* replace285_2 -> 914 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 913, 915, 914 },
      -1,
   } },

   /* ('ftrunc@64', 'a') => ('bcsel', ('flt', 'a', 0.0), ('fneg', ('ffloor', ('fabs', 'a'))), ('ffloor', ('fabs', 'a'))) */
   /* search286_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ftrunc,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace286_0_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 34, 918 },
      -1,
   } },
   /* replace286_1_0_0_0 -> 34 in the cache */
   /* replace286_1_0_0 -> 591 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 591 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 920 },
      -1,
   } },
   /* replace286_2_0_0 -> 34 in the cache */
   /* replace286_2_0 -> 591 in the cache */
   /* replace286_2 -> 920 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 919, 921, 920 },
      -1,
   } },

   /* ('ffloor@16', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search287_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 24 },
      -1,
   } },

   /* replace287_0 -> 24 in the cache */
   /* replace287_1_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 24 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 24, 924 },
      -1,
   } },

   /* ('ffloor@32', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search288_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 29 },
      -1,
   } },

   /* replace288_0 -> 29 in the cache */
   /* replace288_1_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 29 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 29, 927 },
      -1,
   } },

   /* ('ffloor@64', 'a') => ('fsub', 'a', ('ffract', 'a')) */
   /* search289_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 34 },
      -1,
   } },

   /* replace289_0 -> 34 in the cache */
   /* replace289_1_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffract,
      -1, 0,
      { 34 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 34, 930 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fadd@16', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@16', 'b', ('ffloor', 'a')) */
   /* search290_0 -> 24 in the cache */
   /* search290_1_0 -> 664 in the cache */
   /* search290_1_1_0_0 -> 24 in the cache */
   /* search290_1_1_0 -> 924 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 924 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 664, 932 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 24, 933 },
      -1,
   } },

   /* replace290_0 -> 664 in the cache */
   /* replace290_1_0 -> 24 in the cache */
   /* replace290_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 664, 923 },
      -1,
   } },

   /* ('fadd@32', 'a', ('fadd@32', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@32', 'b', ('ffloor', 'a')) */
   /* search291_0 -> 29 in the cache */
   /* search291_1_0 -> 48 in the cache */
   /* search291_1_1_0_0 -> 29 in the cache */
   /* search291_1_1_0 -> 927 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 927 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 48, 936 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 29, 937 },
      -1,
   } },

   /* replace291_0 -> 48 in the cache */
   /* replace291_1_0 -> 29 in the cache */
   /* replace291_1 -> 926 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 48, 926 },
      -1,
   } },

   /* ('fadd@64', 'a', ('fadd@64', 'b', ('fneg', ('ffract', 'a')))) => ('fadd@64', 'b', ('ffloor', 'a')) */
   /* search292_0 -> 34 in the cache */
   /* search292_1_0 -> 53 in the cache */
   /* search292_1_1_0_0 -> 34 in the cache */
   /* search292_1_1_0 -> 930 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 930 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 53, 940 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 34, 941 },
      -1,
   } },

   /* replace292_0 -> 53 in the cache */
   /* replace292_1_0 -> 34 in the cache */
   /* replace292_1 -> 929 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 53, 929 },
      -1,
   } },

   /* ('fadd@16(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search293_0 -> 24 in the cache */
   /* search293_1_0_0 -> 24 in the cache */
   /* search293_1_0 -> 924 in the cache */
   /* search293_1 -> 932 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 24, 932 },
      -1,
   } },

   /* replace293_0 -> 24 in the cache */
   /* replace293 -> 923 in the cache */

   /* ('fadd@32(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search294_0 -> 29 in the cache */
   /* search294_1_0_0 -> 29 in the cache */
   /* search294_1_0 -> 927 in the cache */
   /* search294_1 -> 936 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 29, 936 },
      -1,
   } },

   /* replace294_0 -> 29 in the cache */
   /* replace294 -> 926 in the cache */

   /* ('fadd@64(nnan)', 'a', ('fneg', ('ffract', 'a'))) => ('ffloor', 'a') */
   /* search295_0 -> 34 in the cache */
   /* search295_1_0_0 -> 34 in the cache */
   /* search295_1_0 -> 930 in the cache */
   /* search295_1 -> 940 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 34, 940 },
      -1,
   } },

   /* replace295_0 -> 34 in the cache */
   /* replace295 -> 929 in the cache */

   /* ('ffract@16', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search296_0 -> 24 in the cache */
   /* search296 -> 924 in the cache */

   /* replace296_0 -> 24 in the cache */
   /* replace296_1_0 -> 24 in the cache */
   /* replace296_1 -> 923 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 24, 923 },
      -1,
   } },

   /* ('ffract@32', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search297_0 -> 29 in the cache */
   /* search297 -> 927 in the cache */

   /* replace297_0 -> 29 in the cache */
   /* replace297_1_0 -> 29 in the cache */
   /* replace297_1 -> 926 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 29, 926 },
      -1,
   } },

   /* ('ffract@64', 'a') => ('fsub', 'a', ('ffloor', 'a')) */
   /* search298_0 -> 34 in the cache */
   /* search298 -> 930 in the cache */

   /* replace298_0 -> 34 in the cache */
   /* replace298_1_0 -> 34 in the cache */
   /* replace298_1 -> 929 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsub,
      -1, 0,
      { 34, 929 },
      -1,
   } },

   /* ('fadd@16', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a') */
   /* search299_0 -> 24 in the cache */
   /* search299_1_0_0 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 24 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 950 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 24, 951 },
      -1,
   } },

   /* replace299_0 -> 24 in the cache */
   /* replace299 -> 924 in the cache */

   /* ('fadd@32', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a') */
   /* search300_0 -> 29 in the cache */
   /* search300_1_0_0 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 29 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 953 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 29, 954 },
      -1,
   } },

   /* replace300_0 -> 29 in the cache */
   /* replace300 -> 927 in the cache */

   /* ('fadd@64', 'a', ('fneg(is_used_once)', ('ffloor(is_used_once)', 'a'))) => ('ffract', 'a') */
   /* search301_0 -> 34 in the cache */
   /* search301_1_0_0 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 34 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 956 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 34, 957 },
      -1,
   } },

   /* replace301_0 -> 34 in the cache */
   /* replace301 -> 930 in the cache */

   /* ('fceil', 'a') => ('fneg', ('ffloor', ('fneg', 'a'))) */
   /* search302_0 -> 9 in the cache */
   /* search302 -> 905 in the cache */

   /* replace302_0_0_0 -> 9 in the cache */
   /* replace302_0_0 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffloor,
      -1, 0,
      { 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 959 },
      -1,
   } },

   /* ('ffma@16', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search303_0 -> 24 in the cache */
   /* search303_1 -> 664 in the cache */
   /* search303_2 -> 670 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 24, 664, 670 },
      -1,
   } },

   /* replace303_0_0 -> 24 in the cache */
   /* replace303_0_1 -> 664 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 24, 664 },
      -1,
   } },
   /* replace303_1 -> 670 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 962, 670 },
      -1,
   } },

   /* ('ffma@32', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search304_0 -> 29 in the cache */
   /* search304_1 -> 48 in the cache */
   /* search304_2 -> 152 in the cache */
   /* search304 -> 274 in the cache */

   /* replace304_0_0 -> 29 in the cache */
   /* replace304_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 29, 48 },
      -1,
   } },
   /* replace304_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 964, 152 },
      -1,
   } },

   /* ('ffma@64', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search305_0 -> 34 in the cache */
   /* search305_1 -> 53 in the cache */
   /* search305_2 -> 808 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 34, 53, 808 },
      -1,
   } },

   /* replace305_0_0 -> 34 in the cache */
   /* replace305_0_1 -> 53 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 34, 53 },
      -1,
   } },
   /* replace305_1 -> 808 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 2,
      { 967, 808 },
      -1,
   } },

   /* ('ffmaz', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search306_0 -> 29 in the cache */
   /* search306_1 -> 48 in the cache */
   /* search306_2 -> 152 in the cache */
   /* search306 -> 545 in the cache */

   /* replace306_0_0 -> 29 in the cache */
   /* replace306_0_1 -> 48 in the cache */
   /* replace306_0 -> 151 in the cache */
   /* replace306_1 -> 152 in the cache */
   /* replace306 -> 323 in the cache */

   /* ('ffma@16(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search307_0 -> 24 in the cache */
   /* search307_1 -> 664 in the cache */
   /* search307_2 -> 670 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 24, 664, 670 },
      -1,
   } },

   /* replace307_0_0 -> 24 in the cache */
   /* replace307_0_1 -> 664 in the cache */
   /* replace307_0 -> 962 in the cache */
   /* replace307_1 -> 670 in the cache */
   /* replace307 -> 963 in the cache */

   /* ('ffma@32(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search308_0 -> 29 in the cache */
   /* search308_1 -> 48 in the cache */
   /* search308_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace308_0_0 -> 29 in the cache */
   /* replace308_0_1 -> 48 in the cache */
   /* replace308_0 -> 964 in the cache */
   /* replace308_1 -> 152 in the cache */
   /* replace308 -> 965 in the cache */

   /* ('ffma@64(contract)', 'a', 'b', 'c') => ('fadd', ('fmul', 'a', 'b'), 'c') */
   /* search309_0 -> 34 in the cache */
   /* search309_1 -> 53 in the cache */
   /* search309_2 -> 808 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_ffma,
      0, 1,
      { 34, 53, 808 },
      -1,
   } },

   /* replace309_0_0 -> 34 in the cache */
   /* replace309_0_1 -> 53 in the cache */
   /* replace309_0 -> 967 in the cache */
   /* replace309_1 -> 808 in the cache */
   /* replace309 -> 968 in the cache */

   /* ('ffmaz(contract)', 'a', 'b', 'c') => ('fadd', ('fmulz', 'a', 'b'), 'c') */
   /* search310_0 -> 29 in the cache */
   /* search310_1 -> 48 in the cache */
   /* search310_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      false,
      -1,
      nir_op_ffmaz,
      0, 1,
      { 29, 48, 152 },
      -1,
   } },

   /* replace310_0_0 -> 29 in the cache */
   /* replace310_0_1 -> 48 in the cache */
   /* replace310_0 -> 151 in the cache */
   /* replace310_1 -> 152 in the cache */
   /* replace310 -> 323 in the cache */

   /* ('~fmul', ('fadd', ('bcsel', 'a', ('fmul', 'b', 'c'), 0), '#d'), '#e') => ('bcsel', 'a', ('fmul', ('fadd', ('fmul', 'b', 'c'), 'd'), 'e'), ('fmul', 'd', 'e')) */
   { .variable = {
      { nir_search_value_variable, 1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      2, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      2, 1,
      { 974, 975 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, -5 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 973, 976, 977 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 2,
      { 978, 979 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 980, 981 },
      -1,
   } },

   /* replace311_0 -> 973 in the cache */
   /* replace311_1_0_0_0 -> 974 in the cache */
   /* replace311_1_0_0_1 -> 975 in the cache */
   /* replace311_1_0_0 -> 976 in the cache */
   { .variable = {
      { nir_search_value_variable, -5 },
      3, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 2,
      { 976, 983 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -5 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 3,
      { 984, 985 },
      -1,
   } },
   /* replace311_2_0 -> 983 in the cache */
   /* replace311_2_1 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      3, 1,
      { 983, 985 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 973, 986, 987 },
      -1,
   } },

   /* ('fdph', 'a', 'b') => ('fdot4', ('vec4', 'a.x', 'a.y', 'a.z', 1.0), 'b') */
   /* search312_0 -> 0 in the cache */
   /* search312_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdph,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {2},
   } },
   /* replace312_0_3 -> 305 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec4,
      -1, 0,
      { 990, 991, 992, 305 },
      -1,
   } },
   /* replace312_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 993, 1 },
      -1,
   } },

   /* ('fdot4', 'a', 0.0) => 0.0 */
   /* search313_0 -> 9 in the cache */
   /* search313_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fdot4,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace313 -> 8 in the cache */

   /* ('fdot3', 'a', 0.0) => 0.0 */
   /* search314_0 -> 9 in the cache */
   /* search314_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fdot3,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace314 -> 8 in the cache */

   /* ('fdot2', 'a', 0.0) => 0.0 */
   /* search315_0 -> 9 in the cache */
   /* search315_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fdot2,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* replace315 -> 8 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 1.0), 'd') => ('fdph', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search316_0_0 -> 166 in the cache */
   /* search316_0_1 -> 167 in the cache */
   /* search316_0_2 -> 169 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec4,
      -1, 0,
      { 166, 167, 169, 998 },
      -1,
   } },
   /* search316_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 999, 170 },
      -1,
   } },

   /* replace316_0_0 -> 166 in the cache */
   /* replace316_0_1 -> 167 in the cache */
   /* replace316_0_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec3,
      -1, 0,
      { 166, 167, 169 },
      -1,
   } },
   /* replace316_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdph,
      -1, 0,
      { 1001, 170 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 0.0, 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search317_0_0 -> 0 in the cache */
   /* search317_0_1 -> 295 in the cache */
   /* search317_0_2 -> 295 in the cache */
   /* search317_0_3 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_vec4,
      -1, 0,
      { 0, 295, 295, 295 },
      -1,
   } },
   /* search317_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1003, 1 },
      -1,
   } },

   /* replace317_0 -> 0 in the cache */
   /* replace317_1 -> 1 in the cache */
   /* replace317 -> 301 in the cache */

   /* ('fdot4', ('vec4', 'a', 'b', 0.0, 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search318_0_0 -> 143 in the cache */
   /* search318_0_1 -> 144 in the cache */
   { .constant = {
      { nir_search_value_constant, -3 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search318_0_3 -> 1005 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec4,
      -1, 0,
      { 143, 144, 1005, 1005 },
      -1,
   } },
   /* search318_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1006, 146 },
      -1,
   } },

   /* replace318_0_0 -> 143 in the cache */
   /* replace318_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec2,
      -1, 0,
      { 143, 144 },
      -1,
   } },
   /* replace318_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1008, 146 },
      -1,
   } },

   /* ('fdot4', ('vec4', 'a', 'b', 'c', 0.0), 'd') => ('fdot3', ('vec3', 'a', 'b', 'c'), 'd') */
   /* search319_0_0 -> 166 in the cache */
   /* search319_0_1 -> 167 in the cache */
   /* search319_0_2 -> 169 in the cache */
   { .constant = {
      { nir_search_value_constant, -4 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec4,
      -1, 0,
      { 166, 167, 169, 1010 },
      -1,
   } },
   /* search319_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot4,
      0, 1,
      { 1011, 170 },
      -1,
   } },

   /* replace319_0_0 -> 166 in the cache */
   /* replace319_0_1 -> 167 in the cache */
   /* replace319_0_2 -> 169 in the cache */
   /* replace319_0 -> 1001 in the cache */
   /* replace319_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1001, 170 },
      -1,
   } },

   /* ('fdot3', ('vec3', 'a', 0.0, 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search320_0_0 -> 0 in the cache */
   /* search320_0_1 -> 295 in the cache */
   /* search320_0_2 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_vec3,
      -1, 0,
      { 0, 295, 295 },
      -1,
   } },
   /* search320_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1014, 1 },
      -1,
   } },

   /* replace320_0 -> 0 in the cache */
   /* replace320_1 -> 1 in the cache */
   /* replace320 -> 301 in the cache */

   /* ('fdot3', ('vec3', 'a', 'b', 0.0), 'c') => ('fdot2', ('vec2', 'a', 'b'), 'c') */
   /* search321_0_0 -> 143 in the cache */
   /* search321_0_1 -> 144 in the cache */
   /* search321_0_2 -> 1005 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_vec3,
      -1, 0,
      { 143, 144, 1005 },
      -1,
   } },
   /* search321_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot3,
      0, 1,
      { 1016, 146 },
      -1,
   } },

   /* replace321_0_0 -> 143 in the cache */
   /* replace321_0_1 -> 144 in the cache */
   /* replace321_0 -> 1008 in the cache */
   /* replace321_1 -> 146 in the cache */
   /* replace321 -> 1009 in the cache */

   /* ('fdot2', ('vec2', 'a', 0.0), 'b') => ('fmul', 'a', 'b') */
   /* search322_0_0 -> 0 in the cache */
   /* search322_0_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_vec2,
      -1, 0,
      { 0, 295 },
      -1,
   } },
   /* search322_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fdot2,
      0, 1,
      { 1018, 1 },
      -1,
   } },

   /* replace322_0 -> 0 in the cache */
   /* replace322_1 -> 1 in the cache */
   /* replace322 -> 301 in the cache */

   /* ('fdot2', 'a', 1.0) => ('fadd', 'a.x', 'a.y') */
   /* search323_0 -> 9 in the cache */
   /* search323_1 -> 281 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fdot2,
      0, 1,
      { 9, 281 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {0},
   } },
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      -1,
      {1},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      -1, 0,
      { 1021, 1022 },
      -1,
   } },

   /* ('~fadd', ('fneg(is_used_once)', ('fsat(is_used_once)', 'a(is_not_fmul)')), 1.0) => ('fsat', ('fadd', 1.0, ('fneg', 'a'))) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      9,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 1024 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1025 },
      0,
   } },
   /* search324_1 -> 281 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fadd,
      0, 1,
      { 1026, 281 },
      -1,
   } },

   /* replace324_0_0 -> 281 in the cache */
   /* replace324_0_1_0 -> 9 in the cache */
   /* replace324_0_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 281, 118 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 1028 },
      -1,
   } },

   /* ('ishl', ('iadd', ('imul', 'a', '#b'), '#c'), '#d') => ('iadd', ('imul', 'a', ('ishl', 'b', 'd')), ('ishl', 'c', 'd')) */
   /* search325_0_0_0 -> 143 in the cache */
   /* search325_0_0_1 -> 318 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 143, 318 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, -3 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1030, 1031 },
      -1,
   } },
   /* search325_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 2,
      { 1032, 346 },
      -1,
   } },

   /* replace325_0_0 -> 143 in the cache */
   /* replace325_0_1_0 -> 144 in the cache */
   /* replace325_0_1_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 144, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 143, 1034 },
      -1,
   } },
   /* replace325_1_0 -> 146 in the cache */
   /* replace325_1_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 146, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1035, 1036 },
      -1,
   } },

   /* ('ishl', ('imul', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'b', 'c')) */
   /* search326_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 1038 },
      -1,
   } },
   /* search326_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1039, 344 },
      -1,
   } },

   /* replace326_0 -> 0 in the cache */
   /* replace326_1_0 -> 1 in the cache */
   /* replace326_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 0, 1041 },
      -1,
   } },

   /* ('imul', ('ishl', 'a', '#b'), '#c') => ('imul', 'a', ('ishl', 'c', 'b')) */
   /* search327_0_0 -> 143 in the cache */
   /* search327_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 143, 45 },
      -1,
   } },
   /* search327_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 1043, 1031 },
      -1,
   } },

   /* replace327_0 -> 143 in the cache */
   /* replace327_1_0 -> 146 in the cache */
   /* replace327_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 146, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 1,
      { 143, 1045 },
      -1,
   } },

   /* ('ishl@8', ('ishl@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ishl@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search328_0_0 -> 19 in the cache */
   /* search328_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search328_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1047, 344 },
      -1,
   } },

   /* replace328_0_0_0_0 -> 48 in the cache */
   /* replace328_0_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 48, 22 },
      -1,
   } },
   /* replace328_0_0_1_0 -> 152 in the cache */
   /* replace328_0_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 152, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1049, 1050 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x8ull /* 8 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ult,
      -1, 3,
      { 1051, 1052 },
      -1,
   } },
   /* replace328_1_0 -> 19 in the cache */
   /* replace328_1_1_0 -> 48 in the cache */
   /* replace328_1_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      3, 1,
      { 48, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 19, 1054 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1053, 1055, 1056 },
      -1,
   } },

   /* ('ushr@8', ('ushr@8', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 8), ('ushr@8', 'a', ('iadd', 'b', 'c')), 0) */
   /* search329_0_0 -> 19 in the cache */
   /* search329_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search329_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1058, 344 },
      -1,
   } },

   /* replace329_0_0_0_0 -> 48 in the cache */
   /* replace329_0_0_0_1 -> 22 in the cache */
   /* replace329_0_0_0 -> 1049 in the cache */
   /* replace329_0_0_1_0 -> 152 in the cache */
   /* replace329_0_0_1_1 -> 22 in the cache */
   /* replace329_0_0_1 -> 1050 in the cache */
   /* replace329_0_0 -> 1051 in the cache */
   /* replace329_0_1 -> 1052 in the cache */
   /* replace329_0 -> 1053 in the cache */
   /* replace329_1_0 -> 19 in the cache */
   /* replace329_1_1_0 -> 48 in the cache */
   /* replace329_1_1_1 -> 152 in the cache */
   /* replace329_1_1 -> 1054 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 19, 1054 },
      -1,
   } },
   /* replace329_2 -> 1056 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1053, 1060, 1056 },
      -1,
   } },

   /* ('ishr@8', ('ishr@8', 'a', '#b'), '#c') => ('ishr@8', 'a', ('imin', ('iadd', ('iand', 'b', 7), ('iand', 'c', 7)), 7)) */
   /* search330_0_0 -> 19 in the cache */
   /* search330_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 19, 45 },
      -1,
   } },
   /* search330_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 1062, 344 },
      -1,
   } },

   /* replace330_0 -> 19 in the cache */
   /* replace330_1_0_0_0 -> 48 in the cache */
   /* replace330_1_0_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 48, 22 },
      -1,
   } },
   /* replace330_1_0_1_0 -> 152 in the cache */
   /* replace330_1_0_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      3, 1,
      { 152, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 1064, 1065 },
      -1,
   } },
   /* replace330_1_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imin,
      0, 4,
      { 1066, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 4,
      { 19, 1067 },
      -1,
   } },

   /* ('ishl@16', ('ishl@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ishl@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search331_0_0 -> 24 in the cache */
   /* search331_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search331_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1069, 344 },
      -1,
   } },

   /* replace331_0_0_0_0 -> 48 in the cache */
   /* replace331_0_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 48, 27 },
      -1,
   } },
   /* replace331_0_0_1_0 -> 152 in the cache */
   /* replace331_0_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 152, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1071, 1072 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x10ull /* 16 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ult,
      -1, 3,
      { 1073, 1074 },
      -1,
   } },
   /* replace331_1_0 -> 24 in the cache */
   /* replace331_1_1_0 -> 48 in the cache */
   /* replace331_1_1_1 -> 152 in the cache */
   /* replace331_1_1 -> 1054 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 24, 1054 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1075, 1076, 1077 },
      -1,
   } },

   /* ('ushr@16', ('ushr@16', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 16), ('ushr@16', 'a', ('iadd', 'b', 'c')), 0) */
   /* search332_0_0 -> 24 in the cache */
   /* search332_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search332_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1079, 344 },
      -1,
   } },

   /* replace332_0_0_0_0 -> 48 in the cache */
   /* replace332_0_0_0_1 -> 27 in the cache */
   /* replace332_0_0_0 -> 1071 in the cache */
   /* replace332_0_0_1_0 -> 152 in the cache */
   /* replace332_0_0_1_1 -> 27 in the cache */
   /* replace332_0_0_1 -> 1072 in the cache */
   /* replace332_0_0 -> 1073 in the cache */
   /* replace332_0_1 -> 1074 in the cache */
   /* replace332_0 -> 1075 in the cache */
   /* replace332_1_0 -> 24 in the cache */
   /* replace332_1_1_0 -> 48 in the cache */
   /* replace332_1_1_1 -> 152 in the cache */
   /* replace332_1_1 -> 1054 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 24, 1054 },
      -1,
   } },
   /* replace332_2 -> 1077 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1075, 1081, 1077 },
      -1,
   } },

   /* ('ishr@16', ('ishr@16', 'a', '#b'), '#c') => ('ishr@16', 'a', ('imin', ('iadd', ('iand', 'b', 15), ('iand', 'c', 15)), 15)) */
   /* search333_0_0 -> 24 in the cache */
   /* search333_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 24, 45 },
      -1,
   } },
   /* search333_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 1083, 344 },
      -1,
   } },

   /* replace333_0 -> 24 in the cache */
   /* replace333_1_0_0_0 -> 48 in the cache */
   /* replace333_1_0_0_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 48, 27 },
      -1,
   } },
   /* replace333_1_0_1_0 -> 152 in the cache */
   /* replace333_1_0_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      3, 1,
      { 152, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 1085, 1086 },
      -1,
   } },
   /* replace333_1_1 -> 27 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imin,
      0, 4,
      { 1087, 27 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 4,
      { 24, 1088 },
      -1,
   } },

   /* ('ishl@32', ('ishl@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ishl@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search334_0_0 -> 29 in the cache */
   /* search334_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search334_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1090, 344 },
      -1,
   } },

   /* replace334_0_0_0_0 -> 48 in the cache */
   /* replace334_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 48, 32 },
      -1,
   } },
   /* replace334_0_0_1_0 -> 152 in the cache */
   /* replace334_0_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 152, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1092, 1093 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x20ull /* 32 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ult,
      -1, 3,
      { 1094, 1095 },
      -1,
   } },
   /* replace334_1_0 -> 29 in the cache */
   /* replace334_1_1_0 -> 48 in the cache */
   /* replace334_1_1_1 -> 152 in the cache */
   /* replace334_1_1 -> 1054 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 29, 1054 },
      -1,
   } },
   /* replace334_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1096, 1097, 139 },
      -1,
   } },

   /* ('ushr@32', ('ushr@32', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 32), ('ushr@32', 'a', ('iadd', 'b', 'c')), 0) */
   /* search335_0_0 -> 29 in the cache */
   /* search335_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search335_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1099, 344 },
      -1,
   } },

   /* replace335_0_0_0_0 -> 48 in the cache */
   /* replace335_0_0_0_1 -> 32 in the cache */
   /* replace335_0_0_0 -> 1092 in the cache */
   /* replace335_0_0_1_0 -> 152 in the cache */
   /* replace335_0_0_1_1 -> 32 in the cache */
   /* replace335_0_0_1 -> 1093 in the cache */
   /* replace335_0_0 -> 1094 in the cache */
   /* replace335_0_1 -> 1095 in the cache */
   /* replace335_0 -> 1096 in the cache */
   /* replace335_1_0 -> 29 in the cache */
   /* replace335_1_1_0 -> 48 in the cache */
   /* replace335_1_1_1 -> 152 in the cache */
   /* replace335_1_1 -> 1054 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 29, 1054 },
      -1,
   } },
   /* replace335_2 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1096, 1101, 139 },
      -1,
   } },

   /* ('ishr@32', ('ishr@32', 'a', '#b'), '#c') => ('ishr@32', 'a', ('imin', ('iadd', ('iand', 'b', 31), ('iand', 'c', 31)), 31)) */
   /* search336_0_0 -> 29 in the cache */
   /* search336_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 29, 45 },
      -1,
   } },
   /* search336_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 1103, 344 },
      -1,
   } },

   /* replace336_0 -> 29 in the cache */
   /* replace336_1_0_0_0 -> 48 in the cache */
   /* replace336_1_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 48, 32 },
      -1,
   } },
   /* replace336_1_0_1_0 -> 152 in the cache */
   /* replace336_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      3, 1,
      { 152, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 1105, 1106 },
      -1,
   } },
   /* replace336_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imin,
      0, 4,
      { 1107, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 4,
      { 29, 1108 },
      -1,
   } },

   /* ('ishl@64', ('ishl@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ishl@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search337_0_0 -> 34 in the cache */
   /* search337_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search337_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1110, 344 },
      -1,
   } },

   /* replace337_0_0_0_0 -> 48 in the cache */
   /* replace337_0_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 48, 37 },
      -1,
   } },
   /* replace337_0_0_1_0 -> 152 in the cache */
   /* replace337_0_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 152, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1112, 1113 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x40ull /* 64 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ult,
      -1, 3,
      { 1114, 1115 },
      -1,
   } },
   /* replace337_1_0 -> 34 in the cache */
   /* replace337_1_1_0 -> 48 in the cache */
   /* replace337_1_1_1 -> 152 in the cache */
   /* replace337_1_1 -> 1054 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 34, 1054 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1116, 1117, 1118 },
      -1,
   } },

   /* ('ushr@64', ('ushr@64', 'a', '#b'), '#c') => ('bcsel', ('ult', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 64), ('ushr@64', 'a', ('iadd', 'b', 'c')), 0) */
   /* search338_0_0 -> 34 in the cache */
   /* search338_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search338_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1120, 344 },
      -1,
   } },

   /* replace338_0_0_0_0 -> 48 in the cache */
   /* replace338_0_0_0_1 -> 37 in the cache */
   /* replace338_0_0_0 -> 1112 in the cache */
   /* replace338_0_0_1_0 -> 152 in the cache */
   /* replace338_0_0_1_1 -> 37 in the cache */
   /* replace338_0_0_1 -> 1113 in the cache */
   /* replace338_0_0 -> 1114 in the cache */
   /* replace338_0_1 -> 1115 in the cache */
   /* replace338_0 -> 1116 in the cache */
   /* replace338_1_0 -> 34 in the cache */
   /* replace338_1_1_0 -> 48 in the cache */
   /* replace338_1_1_1 -> 152 in the cache */
   /* replace338_1_1 -> 1054 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 34, 1054 },
      -1,
   } },
   /* replace338_2 -> 1118 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 4,
      { 1116, 1122, 1118 },
      -1,
   } },

   /* ('ishr@64', ('ishr@64', 'a', '#b'), '#c') => ('ishr@64', 'a', ('imin', ('iadd', ('iand', 'b', 63), ('iand', 'c', 63)), 63)) */
   /* search339_0_0 -> 34 in the cache */
   /* search339_0_1 -> 45 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 34, 45 },
      -1,
   } },
   /* search339_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 0,
      { 1124, 344 },
      -1,
   } },

   /* replace339_0 -> 34 in the cache */
   /* replace339_1_0_0_0 -> 48 in the cache */
   /* replace339_1_0_0_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 48, 37 },
      -1,
   } },
   /* replace339_1_0_1_0 -> 152 in the cache */
   /* replace339_1_0_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      3, 1,
      { 152, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 3,
      { 1126, 1127 },
      -1,
   } },
   /* replace339_1_1 -> 37 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imin,
      0, 4,
      { 1128, 37 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishr,
      -1, 4,
      { 34, 1129 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search340_0_0 -> 19 in the cache */
   /* search340_0_1 -> 45 in the cache */
   /* search340_0 -> 1058 in the cache */
   /* search340_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1058, 48 },
      -1,
   } },

   /* replace340_0 -> 19 in the cache */
   { .constant = {
      { nir_search_value_constant, 8 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   /* replace340_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1132, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 19, 1133 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@8', '#b'), 'b') => ('iand', 'a', ('ishl', 255, 'b')) */
   /* search341_0_0 -> 19 in the cache */
   /* search341_0_1 -> 45 in the cache */
   /* search341_0 -> 1062 in the cache */
   /* search341_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1062, 48 },
      -1,
   } },

   /* replace341_0 -> 19 in the cache */
   /* replace341_1_0 -> 1132 in the cache */
   /* replace341_1_1 -> 48 in the cache */
   /* replace341_1 -> 1133 in the cache */
   /* replace341 -> 1134 in the cache */

   /* ('ushr', ('ishl', 'a@8', '#b'), 'b') => ('iand', 'a', ('ushr', 255, 'b')) */
   /* search342_0_0 -> 19 in the cache */
   /* search342_0_1 -> 45 in the cache */
   /* search342_0 -> 1047 in the cache */
   /* search342_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1047, 48 },
      -1,
   } },

   /* replace342_0 -> 19 in the cache */
   /* replace342_1_0 -> 1132 in the cache */
   /* replace342_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1132, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 19, 1137 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search343_0_0 -> 24 in the cache */
   /* search343_0_1 -> 45 in the cache */
   /* search343_0 -> 1079 in the cache */
   /* search343_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1079, 48 },
      -1,
   } },

   /* replace343_0 -> 24 in the cache */
   { .constant = {
      { nir_search_value_constant, 16 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   /* replace343_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1140, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 24, 1141 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@16', '#b'), 'b') => ('iand', 'a', ('ishl', 65535, 'b')) */
   /* search344_0_0 -> 24 in the cache */
   /* search344_0_1 -> 45 in the cache */
   /* search344_0 -> 1083 in the cache */
   /* search344_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1083, 48 },
      -1,
   } },

   /* replace344_0 -> 24 in the cache */
   /* replace344_1_0 -> 1140 in the cache */
   /* replace344_1_1 -> 48 in the cache */
   /* replace344_1 -> 1141 in the cache */
   /* replace344 -> 1142 in the cache */

   /* ('ushr', ('ishl', 'a@16', '#b'), 'b') => ('iand', 'a', ('ushr', 65535, 'b')) */
   /* search345_0_0 -> 24 in the cache */
   /* search345_0_1 -> 45 in the cache */
   /* search345_0 -> 1069 in the cache */
   /* search345_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1069, 48 },
      -1,
   } },

   /* replace345_0 -> 24 in the cache */
   /* replace345_1_0 -> 1140 in the cache */
   /* replace345_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1140, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 24, 1145 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search346_0_0 -> 29 in the cache */
   /* search346_0_1 -> 45 in the cache */
   /* search346_0 -> 1099 in the cache */
   /* search346_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1099, 48 },
      -1,
   } },

   /* replace346_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffffull /* 4294967295 */ },
   } },
   /* replace346_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1148, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1149 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@32', '#b'), 'b') => ('iand', 'a', ('ishl', 4294967295, 'b')) */
   /* search347_0_0 -> 29 in the cache */
   /* search347_0_1 -> 45 in the cache */
   /* search347_0 -> 1103 in the cache */
   /* search347_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1103, 48 },
      -1,
   } },

   /* replace347_0 -> 29 in the cache */
   /* replace347_1_0 -> 1148 in the cache */
   /* replace347_1_1 -> 48 in the cache */
   /* replace347_1 -> 1149 in the cache */
   /* replace347 -> 1150 in the cache */

   /* ('ushr', ('ishl', 'a@32', '#b'), 'b') => ('iand', 'a', ('ushr', 4294967295, 'b')) */
   /* search348_0_0 -> 29 in the cache */
   /* search348_0_1 -> 45 in the cache */
   /* search348_0 -> 1090 in the cache */
   /* search348_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1090, 48 },
      -1,
   } },

   /* replace348_0 -> 29 in the cache */
   /* replace348_1_0 -> 1148 in the cache */
   /* replace348_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1148, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1153 },
      -1,
   } },

   /* ('ishl', ('ushr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search349_0_0 -> 34 in the cache */
   /* search349_0_1 -> 45 in the cache */
   /* search349_0 -> 1120 in the cache */
   /* search349_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1120, 48 },
      -1,
   } },

   /* replace349_0 -> 34 in the cache */
   { .constant = {
      { nir_search_value_constant, 64 },
      nir_type_int, { 0xffffffffffffffffull /* 18446744073709551615 */ },
   } },
   /* replace349_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1156, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 34, 1157 },
      -1,
   } },

   /* ('ishl', ('ishr', 'a@64', '#b'), 'b') => ('iand', 'a', ('ishl', 18446744073709551615, 'b')) */
   /* search350_0_0 -> 34 in the cache */
   /* search350_0_1 -> 45 in the cache */
   /* search350_0 -> 1124 in the cache */
   /* search350_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1124, 48 },
      -1,
   } },

   /* replace350_0 -> 34 in the cache */
   /* replace350_1_0 -> 1156 in the cache */
   /* replace350_1_1 -> 48 in the cache */
   /* replace350_1 -> 1157 in the cache */
   /* replace350 -> 1158 in the cache */

   /* ('ushr', ('ishl', 'a@64', '#b'), 'b') => ('iand', 'a', ('ushr', 18446744073709551615, 'b')) */
   /* search351_0_0 -> 34 in the cache */
   /* search351_0_1 -> 45 in the cache */
   /* search351_0 -> 1110 in the cache */
   /* search351_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1110, 48 },
      -1,
   } },

   /* replace351_0 -> 34 in the cache */
   /* replace351_1_0 -> 1156 in the cache */
   /* replace351_1_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1156, 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 34, 1161 },
      -1,
   } },

   /* ('iand@32', ('ushr@32(is_used_once)', 'a', 'b'), '#c(is_const_bitmask)') => ('ubfe', 'a', 'b', ('bit_count', 'c')) */
   /* search352_0_0 -> 29 in the cache */
   /* search352_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 48 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* c */
      true,
      nir_type_invalid,
      10,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1163, 1164 },
      -1,
   } },

   /* replace352_0 -> 29 in the cache */
   /* replace352_1 -> 48 in the cache */
   /* replace352_2_0 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bit_count,
      -1, 0,
      { 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 48, 1166 },
      -1,
   } },

   /* ('iand@32', ('ushr@32', 'a', 'b'), ('bfm', 'c', 0)) => ('ubfe', 'a', 'b', 'c') */
   /* search353_0_0 -> 29 in the cache */
   /* search353_0_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 48 },
      -1,
   } },
   /* search353_1_0 -> 152 in the cache */
   /* search353_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bfm,
      -1, 0,
      { 152, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1168, 1169 },
      -1,
   } },

   /* replace353_0 -> 29 in the cache */
   /* replace353_1 -> 48 in the cache */
   /* replace353_2 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 48, 152 },
      -1,
   } },

   /* ('ushr', ('iand', 'a', ('bfm', 'c', 'b')), 'b') => ('ubfe', 'a', 'b', 'c') */
   /* search354_0_0 -> 29 in the cache */
   /* search354_0_1_0 -> 755 in the cache */
   /* search354_0_1_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bfm,
      -1, 0,
      { 755, 759 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1172 },
      -1,
   } },
   /* search354_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 1173, 759 },
      -1,
   } },

   /* replace354_0 -> 29 in the cache */
   /* replace354_1 -> 759 in the cache */
   /* replace354_2 -> 755 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 759, 755 },
      -1,
   } },

   /* ('ushr@32', ('iand(is_used_once)', 'a', '#b(is_const_bfm)'), '#c') => ('bcsel', ('ilt', ('find_lsb', 'b'), ('iand', 'c', 31)), ('ushr', ('ubfe', 'a', ('find_lsb', 'b'), ('bit_count', 'b')), ('isub', 'c', ('find_lsb', 'b'))), ('ishl', ('ubfe', 'a', ('find_lsb', 'b'), ('bit_count', 'b')), ('isub', ('find_lsb', 'b'), 'c'))) */
   /* search355_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      true,
      nir_type_invalid,
      11,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1176 },
      0,
   } },
   /* search355_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 1,
      { 1177, 344 },
      -1,
   } },

   /* replace355_0_0_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_find_lsb,
      -1, 0,
      { 48 },
      -1,
   } },
   /* replace355_0_1_0 -> 152 in the cache */
   /* replace355_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 152, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 1,
      { 1179, 1180 },
      -1,
   } },
   /* replace355_1_0_0 -> 29 in the cache */
   /* replace355_1_0_1_0 -> 48 in the cache */
   /* replace355_1_0_1 -> 1179 in the cache */
   /* replace355_1_0_2_0 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bit_count,
      -1, 0,
      { 48 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 1179, 1182 },
      -1,
   } },
   /* replace355_1_1_0 -> 152 in the cache */
   /* replace355_1_1_1_0 -> 48 in the cache */
   /* replace355_1_1_1 -> 1179 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 152, 1179 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1183, 1184 },
      -1,
   } },
   /* replace355_2_0_0 -> 29 in the cache */
   /* replace355_2_0_1_0 -> 48 in the cache */
   /* replace355_2_0_1 -> 1179 in the cache */
   /* replace355_2_0_2_0 -> 48 in the cache */
   /* replace355_2_0_2 -> 1182 in the cache */
   /* replace355_2_0 -> 1183 in the cache */
   /* replace355_2_1_0_0 -> 48 in the cache */
   /* replace355_2_1_0 -> 1179 in the cache */
   /* replace355_2_1_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 0,
      { 1179, 152 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 1183, 1186 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 1181, 1185, 1187 },
      -1,
   } },

   /* ('ubfe', ('ubfe', 'a', '#b', '#c'), '#d', '#e') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 'e', 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0)))) */
   /* search356_0_0 -> 29 in the cache */
   /* search356_0_1 -> 45 in the cache */
   /* search356_0_2 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 29, 45, 344 },
      -1,
   } },
   /* search356_1 -> 346 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      4, /* e */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 0,
      { 1189, 346, 1190 },
      -1,
   } },

   /* replace356_0_0 -> 32 in the cache */
   /* replace356_0_1_0_0 -> 48 in the cache */
   /* replace356_0_1_0_1 -> 32 in the cache */
   /* replace356_0_1_0 -> 1092 in the cache */
   /* replace356_0_1_1_0 -> 180 in the cache */
   /* replace356_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      2, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1092, 1192 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 3,
      { 32, 1193 },
      -1,
   } },
   /* replace356_1 -> 139 in the cache */
   /* replace356_2_0 -> 29 in the cache */
   /* replace356_2_1_0_0 -> 48 in the cache */
   /* replace356_2_1_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      4, 1,
      { 48, 32 },
      -1,
   } },
   /* replace356_2_1_1_0 -> 180 in the cache */
   /* replace356_2_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      5, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      3, 3,
      { 1195, 1196 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 32 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace356_2_2_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      7, 1,
      { 1198, 32 },
      -1,
   } },
   /* replace356_2_2_1_0_0_0_0 -> 152 in the cache */
   /* replace356_2_2_1_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      10, 1,
      { 152, 32 },
      -1,
   } },
   /* replace356_2_2_1_0_0_1_0 -> 1095 in the cache */
   /* replace356_2_2_1_0_0_1_1_0 -> 48 in the cache */
   /* replace356_2_2_1_0_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      11, 1,
      { 48, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 1,
      { 1095, 1201 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      9, 3,
      { 1200, 1202 },
      -1,
   } },
   /* replace356_2_2_1_0_1_0 -> 180 in the cache */
   /* replace356_2_2_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      12, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 4,
      { 1203, 1204 },
      -1,
   } },
   /* replace356_2_2_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imax,
      8, 5,
      { 1205, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      6, 7,
      { 1199, 1206 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 10,
      { 29, 1197, 1207 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 13,
      { 1194, 139, 1208 },
      -1,
   } },

   /* ('ushr@32', ('ubfe', 'a', '#b', '#c'), '#d(is_5lsb_not_zero)') => ('bcsel', ('ilt', 31, ('iadd', ('iand', 'b', 31), ('iand', 'd', 31))), 0, ('ubfe', 'a', ('iadd', ('iand', 'b', 31), ('iand', 'd', 31)), ('umin', ('iand', 31, 31), ('imax', ('isub', ('umin', ('iand', 'c', 31), ('isub', 32, ('iand', 'b', 31))), ('iand', 'd', 31)), 0)))) */
   /* search357_0_0 -> 29 in the cache */
   /* search357_0_1 -> 45 in the cache */
   /* search357_0_2 -> 344 in the cache */
   /* search357_0 -> 1189 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* d */
      true,
      nir_type_invalid,
      12,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ushr,
      -1, 0,
      { 1189, 1210 },
      -1,
   } },

   /* replace357_0_0 -> 32 in the cache */
   /* replace357_0_1_0_0 -> 48 in the cache */
   /* replace357_0_1_0_1 -> 32 in the cache */
   /* replace357_0_1_0 -> 1092 in the cache */
   /* replace357_0_1_1_0 -> 180 in the cache */
   /* replace357_0_1_1_1 -> 32 in the cache */
   /* replace357_0_1_1 -> 1192 in the cache */
   /* replace357_0_1 -> 1193 in the cache */
   /* replace357_0 -> 1194 in the cache */
   /* replace357_1 -> 139 in the cache */
   /* replace357_2_0 -> 29 in the cache */
   /* replace357_2_1_0_0 -> 48 in the cache */
   /* replace357_2_1_0_1 -> 32 in the cache */
   /* replace357_2_1_0 -> 1195 in the cache */
   /* replace357_2_1_1_0 -> 180 in the cache */
   /* replace357_2_1_1_1 -> 32 in the cache */
   /* replace357_2_1_1 -> 1196 in the cache */
   /* replace357_2_1 -> 1197 in the cache */
   /* replace357_2_2_0_0 -> 32 in the cache */
   /* replace357_2_2_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      -1, 0,
      { 32, 32 },
      -1,
   } },
   /* replace357_2_2_1_0_0_0_0 -> 152 in the cache */
   /* replace357_2_2_1_0_0_0_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      9, 1,
      { 152, 32 },
      -1,
   } },
   /* replace357_2_2_1_0_0_1_0 -> 1095 in the cache */
   /* replace357_2_2_1_0_0_1_1_0 -> 48 in the cache */
   /* replace357_2_2_1_0_0_1_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      10, 1,
      { 48, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 1,
      { 1095, 1214 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      8, 3,
      { 1213, 1215 },
      -1,
   } },
   /* replace357_2_2_1_0_1_0 -> 180 in the cache */
   /* replace357_2_2_1_0_1_1 -> 32 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      11, 1,
      { 180, 32 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_isub,
      -1, 4,
      { 1216, 1217 },
      -1,
   } },
   /* replace357_2_2_1_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_imax,
      7, 5,
      { 1218, 139 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      6, 6,
      { 1212, 1219 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ubfe,
      -1, 9,
      { 29, 1197, 1220 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 12,
      { 1194, 139, 1221 },
      -1,
   } },

   /* ('iand', 'a(is_unsigned_multiple_of_4)', -4) => a */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* a */
      false,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .constant = {
      { nir_search_value_constant, -1 },
      nir_type_int, { 0xfffffffffffffffcull /* -4 */ },
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1223, 1224 },
      -1,
   } },

   /* replace358 -> 9 in the cache */

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_2)'), 4294967294) => ('iadd', ('iand', 'a', 4294967294), 'b') */
   /* search359_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      14,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1226 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffeull /* 4294967294 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1227, 1228 },
      -1,
   } },

   /* replace359_0_0 -> 29 in the cache */
   /* replace359_0_1 -> 1228 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1228 },
      -1,
   } },
   /* replace359_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1230, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_4)'), 4294967292) => ('iadd', ('iand', 'a', 4294967292), 'b') */
   /* search360_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      13,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1232 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffffcull /* 4294967292 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1233, 1234 },
      -1,
   } },

   /* replace360_0_0 -> 29 in the cache */
   /* replace360_0_1 -> 1234 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1234 },
      -1,
   } },
   /* replace360_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1236, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_8)'), 4294967288) => ('iadd', ('iand', 'a', 4294967288), 'b') */
   /* search361_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      15,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1238 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff8ull /* 4294967288 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1239, 1240 },
      -1,
   } },

   /* replace361_0_0 -> 29 in the cache */
   /* replace361_0_1 -> 1240 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1240 },
      -1,
   } },
   /* replace361_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1242, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_16)'), 4294967280) => ('iadd', ('iand', 'a', 4294967280), 'b') */
   /* search362_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      16,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1244 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xfffffff0ull /* 4294967280 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1245, 1246 },
      -1,
   } },

   /* replace362_0_0 -> 29 in the cache */
   /* replace362_0_1 -> 1246 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1246 },
      -1,
   } },
   /* replace362_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1248, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_32)'), 4294967264) => ('iadd', ('iand', 'a', 4294967264), 'b') */
   /* search363_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      17,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1250 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffe0ull /* 4294967264 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1251, 1252 },
      -1,
   } },

   /* replace363_0_0 -> 29 in the cache */
   /* replace363_0_1 -> 1252 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1252 },
      -1,
   } },
   /* replace363_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1254, 48 },
      -1,
   } },

   /* ('iand@32', ('iadd@32', 'a', 'b(is_unsigned_multiple_of_64)'), 4294967232) => ('iadd', ('iand', 'a', 4294967232), 'b') */
   /* search364_0_0 -> 29 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      1, /* b */
      false,
      nir_type_invalid,
      18,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 29, 1256 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffffc0ull /* 4294967232 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 2,
      { 1257, 1258 },
      -1,
   } },

   /* replace364_0_0 -> 29 in the cache */
   /* replace364_0_1 -> 1258 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      1, 1,
      { 29, 1258 },
      -1,
   } },
   /* replace364_1 -> 48 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1260, 48 },
      -1,
   } },

   /* ('ishl@32', ('iand', 'a@32', 2147483647), 1) => ('ishl', 'a', 1) */
   /* search365_0_0 -> 29 in the cache */
   /* search365_0_1 -> 585 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 585 },
      -1,
   } },
   /* search365_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1262, 599 },
      -1,
   } },

   /* replace365_0 -> 29 in the cache */
   /* replace365_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 599 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 1), 4294967294) => ('ishl', 'a', 1) */
   /* search366_0_0 -> 29 in the cache */
   /* search366_0_1 -> 599 in the cache */
   /* search366_0 -> 1264 in the cache */
   /* search366_1 -> 1228 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1264, 1228 },
      -1,
   } },

   /* replace366_0 -> 29 in the cache */
   /* replace366_1 -> 599 in the cache */
   /* replace366 -> 1264 in the cache */

   /* ('iand', ('ushr', 'a@32', 1), 2147483647) => ('ushr', 'a', 1) */
   /* search367_0_0 -> 29 in the cache */
   /* search367_0_1 -> 599 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 599 },
      -1,
   } },
   /* search367_1 -> 585 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1266, 585 },
      -1,
   } },

   /* replace367_0 -> 29 in the cache */
   /* replace367_1 -> 599 in the cache */
   /* replace367 -> 1266 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 1073741823), 2) => ('ishl', 'a', 2) */
   /* search368_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x3fffffffull /* 1073741823 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1268 },
      -1,
   } },
   /* search368_1 -> 604 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1269, 604 },
      -1,
   } },

   /* replace368_0 -> 29 in the cache */
   /* replace368_1 -> 604 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 604 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 2), 4294967292) => ('ishl', 'a', 2) */
   /* search369_0_0 -> 29 in the cache */
   /* search369_0_1 -> 604 in the cache */
   /* search369_0 -> 1271 in the cache */
   /* search369_1 -> 1234 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1271, 1234 },
      -1,
   } },

   /* replace369_0 -> 29 in the cache */
   /* replace369_1 -> 604 in the cache */
   /* replace369 -> 1271 in the cache */

   /* ('iand', ('ushr', 'a@32', 2), 1073741823) => ('ushr', 'a', 2) */
   /* search370_0_0 -> 29 in the cache */
   /* search370_0_1 -> 604 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 604 },
      -1,
   } },
   /* search370_1 -> 1268 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1273, 1268 },
      -1,
   } },

   /* replace370_0 -> 29 in the cache */
   /* replace370_1 -> 604 in the cache */
   /* replace370 -> 1273 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 65535), 16) => ('ishl', 'a', 16) */
   /* search371_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffffull /* 65535 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1275 },
      -1,
   } },
   /* search371_1 -> 1074 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1276, 1074 },
      -1,
   } },

   /* replace371_0 -> 29 in the cache */
   /* replace371_1 -> 1074 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 1074 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 16), 4294901760) => ('ishl', 'a', 16) */
   /* search372_0_0 -> 29 in the cache */
   /* search372_0_1 -> 1074 in the cache */
   /* search372_0 -> 1278 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffff0000ull /* 4294901760 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1278, 1279 },
      -1,
   } },

   /* replace372_0 -> 29 in the cache */
   /* replace372_1 -> 1074 in the cache */
   /* replace372 -> 1278 in the cache */

   /* ('iand', ('ushr', 'a@32', 16), 65535) => ('ushr', 'a', 16) */
   /* search373_0_0 -> 29 in the cache */
   /* search373_0_1 -> 1074 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 1074 },
      -1,
   } },
   /* search373_1 -> 1275 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1281, 1275 },
      -1,
   } },

   /* replace373_0 -> 29 in the cache */
   /* replace373_1 -> 1074 in the cache */
   /* replace373 -> 1281 in the cache */

   /* ('ishl@32', ('iand', 'a@32', 255), 24) => ('ishl', 'a', 24) */
   /* search374_0_0 -> 29 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xffull /* 255 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 29, 1283 },
      -1,
   } },
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0x18ull /* 24 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1284, 1285 },
      -1,
   } },

   /* replace374_0 -> 29 in the cache */
   /* replace374_1 -> 1285 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishl,
      -1, 0,
      { 29, 1285 },
      -1,
   } },

   /* ('iand', ('ishl', 'a@32', 24), 4278190080) => ('ishl', 'a', 24) */
   /* search375_0_0 -> 29 in the cache */
   /* search375_0_1 -> 1285 in the cache */
   /* search375_0 -> 1287 in the cache */
   { .constant = {
      { nir_search_value_constant, 32 },
      nir_type_int, { 0xff000000ull /* 4278190080 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1287, 1288 },
      -1,
   } },

   /* replace375_0 -> 29 in the cache */
   /* replace375_1 -> 1285 in the cache */
   /* replace375 -> 1287 in the cache */

   /* ('iand', ('ushr', 'a@32', 24), 255) => ('ushr', 'a', 24) */
   /* search376_0_0 -> 29 in the cache */
   /* search376_0_1 -> 1285 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ushr,
      -1, 0,
      { 29, 1285 },
      -1,
   } },
   /* search376_1 -> 1283 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_iand,
      0, 1,
      { 1290, 1283 },
      -1,
   } },

   /* replace376_0 -> 29 in the cache */
   /* replace376_1 -> 1285 in the cache */
   /* replace376 -> 1290 in the cache */

   /* ('ishl', ('iadd', 'a', '#b'), '#c') => ('iadd', ('ishl', 'a', 'c'), ('ishl', 'b', 'c')) */
   /* search377_0_0 -> 0 in the cache */
   /* search377_0_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 0, 1038 },
      -1,
   } },
   /* search377_1 -> 344 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1292, 344 },
      -1,
   } },

   /* replace377_0_0 -> 0 in the cache */
   /* replace377_0_1 -> 152 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 0,
      { 0, 152 },
      -1,
   } },
   /* replace377_1_0 -> 1 in the cache */
   /* replace377_1_1 -> 152 in the cache */
   /* replace377_1 -> 1041 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 1,
      { 1294, 1041 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search378_0_0_0 -> 143 in the cache */
   /* search378_0_0_1 -> 318 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 143, 318 },
      -1,
   } },
   /* search378_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1296, 146 },
      0,
   } },
   /* search378_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 2,
      { 1297, 346 },
      -1,
   } },

   /* replace378_0_0_0 -> 143 in the cache */
   /* replace378_0_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 143, 146 },
      -1,
   } },
   /* replace378_0_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 1,
      { 1299, 180 },
      -1,
   } },
   /* replace378_1_0 -> 144 in the cache */
   /* replace378_1_1 -> 180 in the cache */
   /* replace378_1 -> 1034 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1300, 1034 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', 'a', '#b'), '#c') => ('iadd', ('imul', 'a', 'c'), ('imul', 'b', 'c')) */
   /* search379_0_0 -> 143 in the cache */
   /* search379_0_1 -> 318 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 1,
      { 143, 318 },
      0,
   } },
   /* search379_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 2,
      { 1302, 1031 },
      -1,
   } },

   /* replace379_0_0 -> 143 in the cache */
   /* replace379_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 1,
      { 143, 146 },
      -1,
   } },
   /* replace379_1_0 -> 144 in the cache */
   /* replace379_1_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      2, 1,
      { 144, 146 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 3,
      { 1304, 1305 },
      -1,
   } },

   /* ('imul', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('imul', ('iadd', 'a', 'c'), 'd'), ('imul', 'b', 'd')) */
   /* search380_0_0_0 -> 166 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      1, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 1,
      { 166, 1307 },
      0,
   } },
   /* search380_0_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      1, 2,
      { 1308, 169 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      0, 3,
      { 1309, 1310 },
      -1,
   } },

   /* replace380_0_0_0 -> 166 in the cache */
   /* replace380_0_0_1 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      2, 1,
      { 166, 169 },
      -1,
   } },
   /* replace380_0_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      1, 2,
      { 1312, 170 },
      -1,
   } },
   /* replace380_1_0 -> 167 in the cache */
   /* replace380_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imul,
      3, 1,
      { 167, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 4,
      { 1313, 1314 },
      -1,
   } },

   /* ('ishl', ('iadd(is_used_once)', ('iadd(is_used_once)', 'a', '#b'), 'c'), '#d') => ('iadd', ('ishl', ('iadd', 'a', 'c'), 'd'), ('ishl', 'b', 'd')) */
   /* search381_0_0_0 -> 143 in the cache */
   /* search381_0_0_1 -> 318 in the cache */
   /* search381_0_0 -> 1302 in the cache */
   /* search381_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iadd,
      0, 2,
      { 1302, 146 },
      0,
   } },
   /* search381_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ishl,
      -1, 2,
      { 1316, 346 },
      -1,
   } },

   /* replace381_0_0_0 -> 143 in the cache */
   /* replace381_0_0_1 -> 146 in the cache */
   /* replace381_0_0 -> 1299 in the cache */
   /* replace381_0_1 -> 180 in the cache */
   /* replace381_0 -> 1300 in the cache */
   /* replace381_1_0 -> 144 in the cache */
   /* replace381_1_1 -> 180 in the cache */
   /* replace381_1 -> 1034 in the cache */
   /* replace381 -> 1301 in the cache */

   /* ('inot', ('flt(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('fge', 'a', 'b') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      19,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1318, 1319 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1320 },
      -1,
   } },

   /* replace382_0 -> 0 in the cache */
   /* replace382_1 -> 1 in the cache */
   /* replace382 -> 6 in the cache */

   /* ('inot', ('fge(is_used_once)', 'a(is_a_number)', 'b(is_a_number)')) => ('flt', 'a', 'b') */
   /* search383_0_0 -> 1318 in the cache */
   /* search383_0_1 -> 1319 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1318, 1319 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1322 },
      -1,
   } },

   /* replace383_0 -> 0 in the cache */
   /* replace383_1 -> 1 in the cache */
   /* replace383 -> 3 in the cache */

   /* ('inot', ('feq(is_used_once)', 'a', 'b')) => ('fneu', 'a', 'b') */
   /* search384_0_0 -> 0 in the cache */
   /* search384_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1324 },
      -1,
   } },

   /* replace384_0 -> 0 in the cache */
   /* replace384_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('fneu(is_used_once)', 'a', 'b')) => ('feq', 'a', 'b') */
   /* search385_0_0 -> 0 in the cache */
   /* search385_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1327 },
      -1,
   } },

   /* replace385_0 -> 0 in the cache */
   /* replace385_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ilt(is_used_once)', 'a', 'b')) => ('ige', 'a', 'b') */
   /* search386_0_0 -> 0 in the cache */
   /* search386_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1330 },
      -1,
   } },

   /* replace386_0 -> 0 in the cache */
   /* replace386_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ult(is_used_once)', 'a', 'b')) => ('uge', 'a', 'b') */
   /* search387_0_0 -> 0 in the cache */
   /* search387_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1333 },
      -1,
   } },

   /* replace387_0 -> 0 in the cache */
   /* replace387_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ige(is_used_once)', 'a', 'b')) => ('ilt', 'a', 'b') */
   /* search388_0_0 -> 0 in the cache */
   /* search388_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1336 },
      -1,
   } },

   /* replace388_0 -> 0 in the cache */
   /* replace388_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('uge(is_used_once)', 'a', 'b')) => ('ult', 'a', 'b') */
   /* search389_0_0 -> 0 in the cache */
   /* search389_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1339 },
      -1,
   } },

   /* replace389_0 -> 0 in the cache */
   /* replace389_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ieq(is_used_once)', 'a', 'b')) => ('ine', 'a', 'b') */
   /* search390_0_0 -> 0 in the cache */
   /* search390_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1342 },
      -1,
   } },

   /* replace390_0 -> 0 in the cache */
   /* replace390_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('inot', ('ine(is_used_once)', 'a', 'b')) => ('ieq', 'a', 'b') */
   /* search391_0_0 -> 0 in the cache */
   /* search391_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 0, 1 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1345 },
      -1,
   } },

   /* replace391_0 -> 0 in the cache */
   /* replace391_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('iand', ('feq', 'a', 'b'), ('fneu', 'a', 'b')) => False */
   /* search392_0_0 -> 0 in the cache */
   /* search392_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search392_1_0 -> 0 in the cache */
   /* search392_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 1348, 1349 },
      -1,
   } },

   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_FALSE /* False */ },
   } },

   /* ('iand', ('flt', 'a', 'b'), ('flt', 'b', 'a')) => False */
   /* search393_0_0 -> 0 in the cache */
   /* search393_0_1 -> 1 in the cache */
   /* search393_0 -> 3 in the cache */
   /* search393_1_0 -> 1 in the cache */
   /* search393_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 3, 1352 },
      -1,
   } },

   /* replace393 -> 1351 in the cache */

   /* ('iand', ('ieq', 'a', 'b'), ('ine', 'a', 'b')) => False */
   /* search394_0_0 -> 0 in the cache */
   /* search394_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search394_1_0 -> 0 in the cache */
   /* search394_1_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      2, 1,
      { 0, 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 3,
      { 1354, 1355 },
      -1,
   } },

   /* replace394 -> 1351 in the cache */

   /* ('iand', ('ilt', 'a', 'b'), ('ilt', 'b', 'a')) => False */
   /* search395_0_0 -> 0 in the cache */
   /* search395_0_1 -> 1 in the cache */
   /* search395_0 -> 1338 in the cache */
   /* search395_1_0 -> 1 in the cache */
   /* search395_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1338, 1357 },
      -1,
   } },

   /* replace395 -> 1351 in the cache */

   /* ('iand', ('ult', 'a', 'b'), ('ult', 'b', 'a')) => False */
   /* search396_0_0 -> 0 in the cache */
   /* search396_0_1 -> 1 in the cache */
   /* search396_0 -> 1341 in the cache */
   /* search396_1_0 -> 1 in the cache */
   /* search396_1_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1, 0 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1341, 1359 },
      -1,
   } },

   /* replace396 -> 1351 in the cache */

   /* ('flt', ('fneg', 'a'), ('fneg', 'b')) => ('flt', 'b', 'a') */
   /* search397_0_0 -> 0 in the cache */
   /* search397_0 -> 132 in the cache */
   /* search397_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 132, 1361 },
      -1,
   } },

   /* replace397_0 -> 1 in the cache */
   /* replace397_1 -> 0 in the cache */
   /* replace397 -> 1352 in the cache */

   /* ('fge', ('fneg', 'a'), ('fneg', 'b')) => ('fge', 'b', 'a') */
   /* search398_0_0 -> 0 in the cache */
   /* search398_0 -> 132 in the cache */
   /* search398_1_0 -> 1 in the cache */
   /* search398_1 -> 1361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 132, 1361 },
      -1,
   } },

   /* replace398_0 -> 1 in the cache */
   /* replace398_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1, 0 },
      -1,
   } },

   /* ('feq', ('fneg', 'a'), ('fneg', 'b')) => ('feq', 'b', 'a') */
   /* search399_0_0 -> 0 in the cache */
   /* search399_0 -> 132 in the cache */
   /* search399_1_0 -> 1 in the cache */
   /* search399_1 -> 1361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 132, 1361 },
      -1,
   } },

   /* replace399_0 -> 1 in the cache */
   /* replace399_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a'), ('fneg', 'b')) => ('fneu', 'b', 'a') */
   /* search400_0_0 -> 0 in the cache */
   /* search400_0 -> 132 in the cache */
   /* search400_1_0 -> 1 in the cache */
   /* search400_1 -> 1361 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 132, 1361 },
      -1,
   } },

   /* replace400_0 -> 1 in the cache */
   /* replace400_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1, 0 },
      -1,
   } },

   /* ('flt', ('fneg', 'a(is_not_const)'), '#b') => ('flt', ('fneg', 'b'), 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1369 },
      -1,
   } },
   /* search401_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1370, 1038 },
      -1,
   } },

   /* replace401_0_0 -> 1 in the cache */
   /* replace401_0 -> 1361 in the cache */
   /* replace401_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1361, 0 },
      -1,
   } },

   /* ('flt', '#b', ('fneg', 'a(is_not_const)')) => ('flt', 'a', ('fneg', 'b')) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      6,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1374 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1373, 1375 },
      -1,
   } },

   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1378 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1377, 1379 },
      -1,
   } },

   /* ('fge', ('fneg', 'a(is_not_const)'), '#b') => ('fge', ('fneg', 'b'), 'a') */
   /* search403_0_0 -> 1369 in the cache */
   /* search403_0 -> 1370 in the cache */
   /* search403_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1370, 1038 },
      -1,
   } },

   /* replace403_0_0 -> 1 in the cache */
   /* replace403_0 -> 1361 in the cache */
   /* replace403_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1361, 0 },
      -1,
   } },

   /* ('fge', '#b', ('fneg', 'a(is_not_const)')) => ('fge', 'a', ('fneg', 'b')) */
   /* search404_0 -> 1373 in the cache */
   /* search404_1_0 -> 1374 in the cache */
   /* search404_1 -> 1375 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1373, 1375 },
      -1,
   } },

   /* replace404_0 -> 1377 in the cache */
   /* replace404_1_0 -> 1378 in the cache */
   /* replace404_1 -> 1379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1377, 1379 },
      -1,
   } },

   /* ('fneu', ('fneg', 'a(is_not_const)'), '#b') => ('fneu', ('fneg', 'b'), 'a') */
   /* search405_0_0 -> 1369 in the cache */
   /* search405_0 -> 1370 in the cache */
   /* search405_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1370, 1038 },
      -1,
   } },

   /* replace405_0_0 -> 1 in the cache */
   /* replace405_0 -> 1361 in the cache */
   /* replace405_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1361, 0 },
      -1,
   } },

   /* ('feq', '#b', ('fneg', 'a(is_not_const)')) => ('feq', 'a', ('fneg', 'b')) */
   /* search406_0 -> 1373 in the cache */
   /* search406_1_0 -> 1374 in the cache */
   /* search406_1 -> 1375 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1373, 1375 },
      -1,
   } },

   /* replace406_0 -> 1377 in the cache */
   /* replace406_1_0 -> 1378 in the cache */
   /* replace406_1 -> 1379 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1377, 1379 },
      -1,
   } },

   /* ('flt', 'a', '#b(is_negative_zero)') => ('flt', 'a', 0.0) */
   /* search407_0 -> 0 in the cache */
   /* search407_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 0, 130 },
      -1,
   } },

   /* replace407_0 -> 0 in the cache */
   /* replace407_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 0, 295 },
      -1,
   } },

   /* ('flt', '#b(is_negative_zero)', 'a') => ('flt', 0.0, 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      3,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search408_1 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1391, 1377 },
      -1,
   } },

   /* replace408_0 -> 295 in the cache */
   /* replace408_1 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 295, 1377 },
      -1,
   } },

   /* ('fge', 'a', '#b(is_negative_zero)') => ('fge', 'a', 0.0) */
   /* search409_0 -> 0 in the cache */
   /* search409_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 0, 130 },
      -1,
   } },

   /* replace409_0 -> 0 in the cache */
   /* replace409_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 0, 295 },
      -1,
   } },

   /* ('fge', '#b(is_negative_zero)', 'a') => ('fge', 0.0, 'a') */
   /* search410_0 -> 1391 in the cache */
   /* search410_1 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1391, 1377 },
      -1,
   } },

   /* replace410_0 -> 295 in the cache */
   /* replace410_1 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 295, 1377 },
      -1,
   } },

   /* ('fneu', 'a', '#b(is_negative_zero)') => ('fneu', 0.0, 'a') */
   /* search411_0 -> 0 in the cache */
   /* search411_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 130 },
      -1,
   } },

   /* replace411_0 -> 295 in the cache */
   /* replace411_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 295, 0 },
      -1,
   } },

   /* ('feq', '#b(is_negative_zero)', 'a') => ('feq', 'a', 0.0) */
   /* search412_0 -> 1391 in the cache */
   /* search412_1 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1391, 1377 },
      -1,
   } },

   /* replace412_0 -> 1377 in the cache */
   /* replace412_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 1377, 295 },
      -1,
   } },

   /* ('ieq', ('ineg', 'a(is_not_const)'), '#b') => ('ieq', 'a', ('ineg', 'b')) */
   /* search413_0_0 -> 1369 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ineg,
      -1, 0,
      { 1369 },
      -1,
   } },
   /* search413_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1402, 1038 },
      -1,
   } },

   /* replace413_0 -> 0 in the cache */
   /* replace413_1_0 -> 1 in the cache */
   /* replace413_1 -> 105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 0, 105 },
      -1,
   } },

   /* ('ine', ('ineg', 'a(is_not_const)'), '#b') => ('ine', 'a', ('ineg', 'b')) */
   /* search414_0_0 -> 1369 in the cache */
   /* search414_0 -> 1402 in the cache */
   /* search414_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1402, 1038 },
      -1,
   } },

   /* replace414_0 -> 0 in the cache */
   /* replace414_1_0 -> 1 in the cache */
   /* replace414_1 -> 105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 0, 105 },
      -1,
   } },

   /* ('ieq', ('inot', 'a(is_not_const)'), '#b') => ('ieq', 'a', ('inot', 'b')) */
   /* search415_0_0 -> 1369 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1369 },
      -1,
   } },
   /* search415_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1407, 1038 },
      -1,
   } },

   /* replace415_0 -> 0 in the cache */
   /* replace415_1_0 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 0, 1409 },
      -1,
   } },

   /* ('ine', ('inot', 'a(is_not_const)'), '#b') => ('ine', 'a', ('inot', 'b')) */
   /* search416_0_0 -> 1369 in the cache */
   /* search416_0 -> 1407 in the cache */
   /* search416_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1407, 1038 },
      -1,
   } },

   /* replace416_0 -> 0 in the cache */
   /* replace416_1_0 -> 1 in the cache */
   /* replace416_1 -> 1409 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 0, 1409 },
      -1,
   } },

   /* ('ieq', ('iabs', 'a'), 0) => ('ieq', 'a', 0) */
   /* search417_0_0 -> 9 in the cache */
   /* search417_0 -> 125 in the cache */
   /* search417_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 125, 73 },
      -1,
   } },

   /* replace417_0 -> 9 in the cache */
   /* replace417_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ine', ('iabs', 'a'), 0) => ('ine', 'a', 0) */
   /* search418_0_0 -> 9 in the cache */
   /* search418_0 -> 125 in the cache */
   /* search418_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 125, 73 },
      -1,
   } },

   /* replace418_0 -> 9 in the cache */
   /* replace418_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* ('ieq', ('bit_count(is_used_once)', 'a'), 0) => ('ieq', 'a', 0) */
   /* search419_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bit_count,
      -1, 0,
      { 9 },
      0,
   } },
   /* search419_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 1417, 139 },
      -1,
   } },

   /* replace419_0 -> 9 in the cache */
   /* replace419_1 -> 73 in the cache */
   /* replace419 -> 1414 in the cache */

   /* ('ine', ('bit_count(is_used_once)', 'a'), 0) => ('ine', 'a', 0) */
   /* search420_0_0 -> 9 in the cache */
   /* search420_0 -> 1417 in the cache */
   /* search420_1 -> 139 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 1417, 139 },
      -1,
   } },

   /* replace420_0 -> 9 in the cache */
   /* replace420_1 -> 73 in the cache */
   /* replace420 -> 1416 in the cache */

   /* ('ieq', ('ineg', 'a'), ('ineg', 'b')) => ('ieq', 'a', 'b') */
   /* search421_0_0 -> 0 in the cache */
   /* search421_0 -> 240 in the cache */
   /* search421_1_0 -> 1 in the cache */
   /* search421_1 -> 105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 240, 105 },
      -1,
   } },

   /* replace421_0 -> 0 in the cache */
   /* replace421_1 -> 1 in the cache */
   /* replace421 -> 1347 in the cache */

   /* ('ine', ('ineg', 'a'), ('ineg', 'b')) => ('ine', 'a', 'b') */
   /* search422_0_0 -> 0 in the cache */
   /* search422_0 -> 240 in the cache */
   /* search422_1_0 -> 1 in the cache */
   /* search422_1 -> 105 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 240, 105 },
      -1,
   } },

   /* replace422_0 -> 0 in the cache */
   /* replace422_1 -> 1 in the cache */
   /* replace422 -> 1344 in the cache */

   /* ('ieq', ('inot', 'a'), ('inot', 'b')) => ('ieq', 'a', 'b') */
   /* search423_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 0 },
      -1,
   } },
   /* search423_1_0 -> 1 in the cache */
   /* search423_1 -> 1409 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1422, 1409 },
      -1,
   } },

   /* replace423_0 -> 0 in the cache */
   /* replace423_1 -> 1 in the cache */
   /* replace423 -> 1347 in the cache */

   /* ('ine', ('inot', 'a'), ('inot', 'b')) => ('ine', 'a', 'b') */
   /* search424_0_0 -> 0 in the cache */
   /* search424_0 -> 1422 in the cache */
   /* search424_1_0 -> 1 in the cache */
   /* search424_1 -> 1409 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1422, 1409 },
      -1,
   } },

   /* replace424_0 -> 0 in the cache */
   /* replace424_1 -> 1 in the cache */
   /* replace424 -> 1344 in the cache */

   /* ('fneu', ('fabs', 'a'), 0.0) => ('fneu', 'a', 0.0) */
   /* search425_0_0 -> 9 in the cache */
   /* search425_0 -> 11 in the cache */
   /* search425_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace425_0 -> 9 in the cache */
   /* replace425_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), 0.0) => ('feq', 'a', 0.0) */
   /* search426_0_0 -> 9 in the cache */
   /* search426_0 -> 11 in the cache */
   /* search426_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 11, 8 },
      -1,
   } },

   /* replace426_0 -> 9 in the cache */
   /* replace426_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 9, 8 },
      -1,
   } },

   /* ('fneu', ('fabs', 'a'), ('fabs', 'a')) => ('fneu', 'a', 'a') */
   /* search427_0_0 -> 9 in the cache */
   /* search427_0 -> 11 in the cache */
   /* search427_1_0 -> 9 in the cache */
   /* search427_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace427_0 -> 9 in the cache */
   /* replace427_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('feq', ('fabs', 'a'), ('fabs', 'a')) => ('feq', 'a', 'a') */
   /* search428_0_0 -> 9 in the cache */
   /* search428_0 -> 11 in the cache */
   /* search428_1_0 -> 9 in the cache */
   /* search428_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      -1, 0,
      { 11, 11 },
      -1,
   } },

   /* replace428_0 -> 9 in the cache */
   /* replace428_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* ('flt', '#b(is_gt_0_and_lt_1)', ('fsat(is_used_once)', 'a')) => ('flt', 'b', 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* b */
      true,
      nir_type_invalid,
      20,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search429_1_0 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 1377 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1433, 1434 },
      -1,
   } },

   /* replace429_0 -> 1378 in the cache */
   /* replace429_1 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1378, 1377 },
      -1,
   } },

   /* ('fge', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fge', 'a', 'b') */
   /* search430_0_0 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 0 },
      0,
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      true,
      nir_type_invalid,
      20,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1437, 1438 },
      -1,
   } },

   /* replace430_0 -> 0 in the cache */
   /* replace430_1 -> 1 in the cache */
   /* replace430 -> 6 in the cache */

   /* ('feq', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('feq', 'a', 'b') */
   /* search431_0_0 -> 0 in the cache */
   /* search431_0 -> 1437 in the cache */
   /* search431_1 -> 1438 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1437, 1438 },
      -1,
   } },

   /* replace431_0 -> 0 in the cache */
   /* replace431_1 -> 1 in the cache */
   /* replace431 -> 1329 in the cache */

   /* ('fneu', ('fsat(is_used_once)', 'a'), '#b(is_gt_0_and_lt_1)') => ('fneu', 'a', 'b') */
   /* search432_0_0 -> 0 in the cache */
   /* search432_0 -> 1437 in the cache */
   /* search432_1 -> 1438 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1437, 1438 },
      -1,
   } },

   /* replace432_0 -> 0 in the cache */
   /* replace432_1 -> 1 in the cache */
   /* replace432 -> 1326 in the cache */

   /* ('fge', ('fsat(is_used_once)', 'a'), 1.0) => ('fge', 'a', 1.0) */
   /* search433_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 0,
      { 9 },
      0,
   } },
   /* search433_1 -> 281 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1442, 281 },
      -1,
   } },

   /* replace433_0 -> 9 in the cache */
   /* replace433_1 -> 281 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 9, 281 },
      -1,
   } },

   /* ('flt', 0.0, ('fsat(is_used_once)', 'a')) => ('flt', 0.0, 'a') */
   /* search434_0 -> 8 in the cache */
   /* search434_1_0 -> 9 in the cache */
   /* search434_1 -> 1442 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 8, 1442 },
      -1,
   } },

   /* replace434_0 -> 8 in the cache */
   /* replace434_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 8, 9 },
      -1,
   } },

   /* ('bcsel(is_only_used_as_float)', ('feq', 'a', 'b(is_not_zero)'), 'b', 'a') => a */
   /* search435_0_0 -> 0 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      21,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 0, 1447 },
      -1,
   } },
   /* search435_1 -> 1 in the cache */
   /* search435_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 1448, 1, 0 },
      1,
   } },

   /* replace435 -> 0 in the cache */

   /* ('bcsel(is_only_used_as_float)', ('fneu', 'a', 'b(is_not_zero)'), 'a', 'b') => a */
   /* search436_0_0 -> 0 in the cache */
   /* search436_0_1 -> 1447 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 1447 },
      -1,
   } },
   /* search436_1 -> 0 in the cache */
   /* search436_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 1,
      { 1450, 0, 1 },
      1,
   } },

   /* replace436 -> 0 in the cache */

   /* ('bcsel', ('feq', 'a', 0, 'ignore_exact'), 0, ('fsat', ('fmul', 'a', 'b(is_a_number)'))) => ('!fsat', ('fmul', 'a', 'b')) */
   /* search437_0_0 -> 0 in the cache */
   /* search437_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 0, 98 },
      -1,
   } },
   /* search437_1 -> 98 in the cache */
   /* search437_2_0_0 -> 0 in the cache */
   /* search437_2_0_1 -> 1319 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      1, 1,
      { 0, 1319 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 1453 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1452, 98, 1454 },
      -1,
   } },

   /* replace437_0_0 -> 0 in the cache */
   /* replace437_0_1 -> 1 in the cache */
   /* replace437_0 -> 301 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fsat,
      -1, 1,
      { 301 },
      -1,
   } },

   /* ('bcsel', ('fneu', 'a', 0, 'ignore_exact'), ('fsat', ('fmul', 'a', 'b(is_a_number)')), 0) => ('!fsat', ('fmul', 'a', 'b')) */
   /* search438_0_0 -> 0 in the cache */
   /* search438_0_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 0, 98 },
      -1,
   } },
   /* search438_1_0_0 -> 0 in the cache */
   /* search438_1_0_1 -> 1319 in the cache */
   /* search438_1_0 -> 1453 in the cache */
   /* search438_1 -> 1454 in the cache */
   /* search438_2 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1457, 1454, 98 },
      -1,
   } },

   /* replace438_0_0 -> 0 in the cache */
   /* replace438_0_1 -> 1 in the cache */
   /* replace438_0 -> 301 in the cache */
   /* replace438 -> 1456 in the cache */

   /* ('bcsel', ('feq', 'a', 0, 'ignore_exact'), 'b', ('fadd', 'a', 'b(is_not_zero)')) => ('fadd', 'a', 'b') */
   /* search439_0_0 -> 0 in the cache */
   /* search439_0_1 -> 98 in the cache */
   /* search439_0 -> 1452 in the cache */
   /* search439_1 -> 1 in the cache */
   /* search439_2_0 -> 0 in the cache */
   /* search439_2_1 -> 1447 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 0, 1447 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1452, 1, 1459 },
      -1,
   } },

   /* replace439_0 -> 0 in the cache */
   /* replace439_1 -> 1 in the cache */
   /* replace439 -> 307 in the cache */

   /* ('bcsel', ('fneu', 'a', 0, 'ignore_exact'), ('fadd', 'a', 'b(is_not_zero)'), 'b') => ('fadd', 'a', 'b') */
   /* search440_0_0 -> 0 in the cache */
   /* search440_0_1 -> 98 in the cache */
   /* search440_0 -> 1457 in the cache */
   /* search440_1_0 -> 0 in the cache */
   /* search440_1_1 -> 1447 in the cache */
   /* search440_1 -> 1459 in the cache */
   /* search440_2 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1457, 1459, 1 },
      -1,
   } },

   /* replace440_0 -> 0 in the cache */
   /* replace440_1 -> 1 in the cache */
   /* replace440 -> 307 in the cache */

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x0ull /* 0.0 */ },
   } },
   /* search441_1_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 973 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1462, 1463 },
      -1,
   } },

   /* replace441_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 973 },
      -1,
   } },

   /* ('fge', ('fneg', ('b2f', 'a@1')), 0.0) => ('inot', 'a') */
   /* search442_0_0_0 -> 973 in the cache */
   /* search442_0_0 -> 1463 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1463 },
      -1,
   } },
   /* search442_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1466, 1462 },
      -1,
   } },

   /* replace442_0 -> 973 in the cache */
   /* replace442 -> 1465 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('ior', 'a', 'b') */
   /* search443_0_0_0 -> 973 in the cache */
   /* search443_0_0 -> 1463 in the cache */
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 1463, 1469 },
      -1,
   } },
   /* search443_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 2,
      { 1470, 1462 },
      -1,
   } },

   /* replace443_0 -> 973 in the cache */
   /* replace443_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 973, 1468 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search444_0_0 -> 973 in the cache */
   /* search444_0 -> 1463 in the cache */
   /* search444_1_0_0 -> 1468 in the cache */
   /* search444_1_0 -> 1469 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1463, 1473 },
      -1,
   } },

   /* replace444_0 -> 973 in the cache */
   /* replace444_1 -> 1468 in the cache */
   /* replace444 -> 1472 in the cache */

   /* ('fneu', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ixor', 'a', 'b') */
   /* search445_0_0_0 -> 973 in the cache */
   /* search445_0_0 -> 1463 in the cache */
   /* search445_0_1_0_0 -> 1468 in the cache */
   /* search445_0_1_0 -> 1469 in the cache */
   /* search445_0_1 -> 1473 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 1463, 1473 },
      -1,
   } },
   /* search445_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 2,
      { 1475, 1462 },
      -1,
   } },

   /* replace445_0 -> 973 in the cache */
   /* replace445_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ixor,
      0, 1,
      { 973, 1468 },
      -1,
   } },

   /* ('fneu', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ixor', 'a', 'b') */
   /* search446_0_0 -> 973 in the cache */
   /* search446_0 -> 1463 in the cache */
   /* search446_1_0 -> 1468 in the cache */
   /* search446_1 -> 1469 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1463, 1469 },
      -1,
   } },

   /* replace446_0 -> 973 in the cache */
   /* replace446_1 -> 1468 in the cache */
   /* replace446 -> 1477 in the cache */

   /* ('fneu', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ixor', 'a', 'b') */
   /* search447_0_0_0 -> 973 in the cache */
   /* search447_0_0 -> 1463 in the cache */
   /* search447_0 -> 1466 in the cache */
   /* search447_1_0_0 -> 1468 in the cache */
   /* search447_1_0 -> 1469 in the cache */
   /* search447_1 -> 1473 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1466, 1473 },
      -1,
   } },

   /* replace447_0 -> 973 in the cache */
   /* replace447_1 -> 1468 in the cache */
   /* replace447 -> 1477 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search448_0_0_0 -> 973 in the cache */
   /* search448_0_0 -> 1463 in the cache */
   /* search448_0_1_0 -> 1468 in the cache */
   /* search448_0_1 -> 1469 in the cache */
   /* search448_0 -> 1470 in the cache */
   /* search448_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 2,
      { 1470, 1462 },
      -1,
   } },

   /* replace448_0_0 -> 973 in the cache */
   /* replace448_0_1 -> 1468 in the cache */
   /* replace448_0 -> 1472 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 1,
      { 1472 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search449_0_0 -> 973 in the cache */
   /* search449_0 -> 1463 in the cache */
   /* search449_1_0_0 -> 1468 in the cache */
   /* search449_1_0 -> 1469 in the cache */
   /* search449_1 -> 1473 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1463, 1473 },
      -1,
   } },

   /* replace449_0_0 -> 973 in the cache */
   /* replace449_0_1 -> 1468 in the cache */
   /* replace449_0 -> 1472 in the cache */
   /* replace449 -> 1481 in the cache */

   /* ('feq', ('fadd', ('b2f', 'a@1'), ('fneg', ('b2f', 'b@1'))), 0.0) => ('ieq', 'a', 'b') */
   /* search450_0_0_0 -> 973 in the cache */
   /* search450_0_0 -> 1463 in the cache */
   /* search450_0_1_0_0 -> 1468 in the cache */
   /* search450_0_1_0 -> 1469 in the cache */
   /* search450_0_1 -> 1473 in the cache */
   /* search450_0 -> 1475 in the cache */
   /* search450_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 2,
      { 1475, 1462 },
      -1,
   } },

   /* replace450_0 -> 973 in the cache */
   /* replace450_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 973, 1468 },
      -1,
   } },

   /* ('feq', ('b2f', 'a@1'), ('b2f', 'b@1')) => ('ieq', 'a', 'b') */
   /* search451_0_0 -> 973 in the cache */
   /* search451_0 -> 1463 in the cache */
   /* search451_1_0 -> 1468 in the cache */
   /* search451_1 -> 1469 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1463, 1469 },
      -1,
   } },

   /* replace451_0 -> 973 in the cache */
   /* replace451_1 -> 1468 in the cache */
   /* replace451 -> 1484 in the cache */

   /* ('feq', ('fneg', ('b2f', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('ieq', 'a', 'b') */
   /* search452_0_0_0 -> 973 in the cache */
   /* search452_0_0 -> 1463 in the cache */
   /* search452_0 -> 1466 in the cache */
   /* search452_1_0_0 -> 1468 in the cache */
   /* search452_1_0 -> 1469 in the cache */
   /* search452_1 -> 1473 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1466, 1473 },
      -1,
   } },

   /* replace452_0 -> 973 in the cache */
   /* replace452_1 -> 1468 in the cache */
   /* replace452 -> 1484 in the cache */

   /* ('flt', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('ior', 'a', 'b') */
   /* search453_0_0_0_0 -> 973 in the cache */
   /* search453_0_0_0 -> 1463 in the cache */
   /* search453_0_0_1_0 -> 1468 in the cache */
   /* search453_0_0_1 -> 1469 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 1463, 1469 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1487 },
      -1,
   } },
   /* search453_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 1,
      { 1488, 1462 },
      -1,
   } },

   /* replace453_0 -> 973 in the cache */
   /* replace453_1 -> 1468 in the cache */
   /* replace453 -> 1472 in the cache */

   /* ('flt', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('ior', 'a', 'b') */
   /* search454_0 -> 1462 in the cache */
   /* search454_1_0_0 -> 973 in the cache */
   /* search454_1_0 -> 1463 in the cache */
   /* search454_1_1_0 -> 1468 in the cache */
   /* search454_1_1 -> 1469 in the cache */
   /* search454_1 -> 1487 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 1462, 1487 },
      -1,
   } },

   /* replace454_0 -> 973 in the cache */
   /* replace454_1 -> 1468 in the cache */
   /* replace454 -> 1472 in the cache */

   /* ('fge', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))), 0.0) => ('inot', ('ior', 'a', 'b')) */
   /* search455_0_0_0_0 -> 973 in the cache */
   /* search455_0_0_0 -> 1463 in the cache */
   /* search455_0_0_1_0 -> 1468 in the cache */
   /* search455_0_0_1 -> 1469 in the cache */
   /* search455_0_0 -> 1487 in the cache */
   /* search455_0 -> 1488 in the cache */
   /* search455_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 1,
      { 1488, 1462 },
      -1,
   } },

   /* replace455_0_0 -> 973 in the cache */
   /* replace455_0_1 -> 1468 in the cache */
   /* replace455_0 -> 1472 in the cache */
   /* replace455 -> 1481 in the cache */

   /* ('fge', 0.0, ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1'))) => ('inot', ('ior', 'a', 'b')) */
   /* search456_0 -> 1462 in the cache */
   /* search456_1_0_0 -> 973 in the cache */
   /* search456_1_0 -> 1463 in the cache */
   /* search456_1_1_0 -> 1468 in the cache */
   /* search456_1_1 -> 1469 in the cache */
   /* search456_1 -> 1487 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 1462, 1487 },
      -1,
   } },

   /* replace456_0_0 -> 973 in the cache */
   /* replace456_0_1 -> 1468 in the cache */
   /* replace456_0 -> 1472 in the cache */
   /* replace456 -> 1481 in the cache */

   /* ('flt', 'a', ('fneg', 'a')) => ('flt', 'a', 0.0) */
   /* search457_0 -> 9 in the cache */
   /* search457_1_0 -> 9 in the cache */
   /* search457_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace457_0 -> 9 in the cache */
   /* replace457_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('fge', 'a', ('fneg', 'a')) => ('fge', 'a', 0.0) */
   /* search458_0 -> 9 in the cache */
   /* search458_1_0 -> 9 in the cache */
   /* search458_1 -> 118 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 9, 118 },
      -1,
   } },

   /* replace458_0 -> 9 in the cache */
   /* replace458_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 9, 8 },
      -1,
   } },

   /* ('flt', ('fmin', 'c', ('fneg', ('fadd', ('b2f', 'a@1'), ('b2f', 'b@1')))), 0.0) => ('ior', ('flt', 'c', 0.0), ('ior', 'a', 'b')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      1, /* a */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1498 },
      -1,
   } },
   { .variable = {
      { nir_search_value_variable, 1 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1500 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 1499, 1501 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1502 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 2,
      { 1497, 1503 },
      -1,
   } },
   /* search459_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 2,
      { 1504, 8 },
      -1,
   } },

   /* replace459_0_0 -> 1497 in the cache */
   /* replace459_0_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 1497, 8 },
      -1,
   } },
   /* replace459_1_0 -> 1498 in the cache */
   /* replace459_1_1 -> 1500 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      1, 1,
      { 1498, 1500 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 2,
      { 1506, 1507 },
      -1,
   } },

   /* ('~flt', ('fadd', 'a', 'b'), 'a') => ('flt', 'b', 0.0) */
   /* search460_0_0 -> 0 in the cache */
   /* search460_0_1 -> 1 in the cache */
   /* search460_0 -> 307 in the cache */
   /* search460_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 307, 0 },
      -1,
   } },

   /* replace460_0 -> 1 in the cache */
   /* replace460_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 1, 295 },
      -1,
   } },

   /* ('~fge', ('fadd', 'a', 'b'), 'a') => ('fge', 'b', 0.0) */
   /* search461_0_0 -> 0 in the cache */
   /* search461_0_1 -> 1 in the cache */
   /* search461_0 -> 307 in the cache */
   /* search461_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 307, 0 },
      -1,
   } },

   /* replace461_0 -> 1 in the cache */
   /* replace461_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1, 295 },
      -1,
   } },

   /* ('~feq', ('fadd', 'a', 'b'), 'a') => ('feq', 'b', 0.0) */
   /* search462_0_0 -> 0 in the cache */
   /* search462_0_1 -> 1 in the cache */
   /* search462_0 -> 245 in the cache */
   /* search462_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 245, 0 },
      -1,
   } },

   /* replace462_0 -> 1 in the cache */
   /* replace462_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 1, 295 },
      -1,
   } },

   /* ('~fneu', ('fadd', 'a', 'b'), 'a') => ('fneu', 'b', 0.0) */
   /* search463_0_0 -> 0 in the cache */
   /* search463_0_1 -> 1 in the cache */
   /* search463_0 -> 245 in the cache */
   /* search463_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 245, 0 },
      -1,
   } },

   /* replace463_0 -> 1 in the cache */
   /* replace463_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 1, 295 },
      -1,
   } },

   /* ('~flt', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('flt', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search464_0_0 -> 143 in the cache */
   /* search464_0_1 -> 318 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 143, 318 },
      0,
   } },
   /* search464_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 1517, 1031 },
      -1,
   } },

   /* replace464_0 -> 143 in the cache */
   /* replace464_1_0 -> 146 in the cache */
   /* replace464_1_1_0 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 146, 1519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 143, 1520 },
      -1,
   } },

   /* ('~flt', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('flt', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search465_0_0_0 -> 143 in the cache */
   /* search465_0_0_1 -> 318 in the cache */
   /* search465_0_0 -> 1517 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1517 },
      0,
   } },
   /* search465_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 1522, 1031 },
      -1,
   } },

   /* replace465_0_0_0 -> 146 in the cache */
   /* replace465_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 146, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1524 },
      -1,
   } },
   /* replace465_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 1,
      { 1525, 143 },
      -1,
   } },

   /* ('~fge', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fge', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search466_0_0 -> 143 in the cache */
   /* search466_0_1 -> 318 in the cache */
   /* search466_0 -> 1517 in the cache */
   /* search466_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 1517, 1031 },
      -1,
   } },

   /* replace466_0 -> 143 in the cache */
   /* replace466_1_0 -> 146 in the cache */
   /* replace466_1_1_0 -> 144 in the cache */
   /* replace466_1_1 -> 1519 in the cache */
   /* replace466_1 -> 1520 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 143, 1520 },
      -1,
   } },

   /* ('~fge', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fge', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search467_0_0_0 -> 143 in the cache */
   /* search467_0_0_1 -> 318 in the cache */
   /* search467_0_0 -> 1517 in the cache */
   /* search467_0 -> 1522 in the cache */
   /* search467_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 1522, 1031 },
      -1,
   } },

   /* replace467_0_0_0 -> 146 in the cache */
   /* replace467_0_0_1 -> 144 in the cache */
   /* replace467_0_0 -> 1524 in the cache */
   /* replace467_0 -> 1525 in the cache */
   /* replace467_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 1,
      { 1525, 143 },
      -1,
   } },

   /* ('~feq', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('feq', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search468_0_0 -> 143 in the cache */
   /* search468_0_1 -> 318 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 143, 318 },
      0,
   } },
   /* search468_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 1531, 1031 },
      -1,
   } },

   /* replace468_0 -> 143 in the cache */
   /* replace468_1_0 -> 146 in the cache */
   /* replace468_1_1_0 -> 144 in the cache */
   /* replace468_1_1 -> 1519 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 146, 1519 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 143, 1533 },
      -1,
   } },

   /* ('~feq', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('feq', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search469_0_0_0 -> 143 in the cache */
   /* search469_0_0_1 -> 318 in the cache */
   /* search469_0_0 -> 1531 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1531 },
      0,
   } },
   /* search469_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 1535, 1031 },
      -1,
   } },

   /* replace469_0_0_0 -> 146 in the cache */
   /* replace469_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      1, 1,
      { 146, 144 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1537 },
      -1,
   } },
   /* replace469_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 2,
      { 1538, 143 },
      -1,
   } },

   /* ('~fneu', ('fadd(is_used_once)', 'a', '#b'), '#c') => ('fneu', 'a', ('fadd', 'c', ('fneg', 'b'))) */
   /* search470_0_0 -> 143 in the cache */
   /* search470_0_1 -> 318 in the cache */
   /* search470_0 -> 1531 in the cache */
   /* search470_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 1531, 1031 },
      -1,
   } },

   /* replace470_0 -> 143 in the cache */
   /* replace470_1_0 -> 146 in the cache */
   /* replace470_1_1_0 -> 144 in the cache */
   /* replace470_1_1 -> 1519 in the cache */
   /* replace470_1 -> 1533 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 143, 1533 },
      -1,
   } },

   /* ('~fneu', ('fneg(is_used_once)', ('fadd(is_used_once)', 'a', '#b')), '#c') => ('fneu', ('fneg', ('fadd', 'c', 'b')), 'a') */
   /* search471_0_0_0 -> 143 in the cache */
   /* search471_0_0_1 -> 318 in the cache */
   /* search471_0_0 -> 1531 in the cache */
   /* search471_0 -> 1535 in the cache */
   /* search471_1 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 1535, 1031 },
      -1,
   } },

   /* replace471_0_0_0 -> 146 in the cache */
   /* replace471_0_0_1 -> 144 in the cache */
   /* replace471_0_0 -> 1537 in the cache */
   /* replace471_0 -> 1538 in the cache */
   /* replace471_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 2,
      { 1538, 143 },
      -1,
   } },

   /* ('ieq', ('iadd', 'a', 'b'), 'a') => ('ieq', 'b', 0) */
   /* search472_0_0 -> 0 in the cache */
   /* search472_0_1 -> 1 in the cache */
   /* search472_0 -> 241 in the cache */
   /* search472_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 2,
      { 241, 0 },
      -1,
   } },

   /* replace472_0 -> 1 in the cache */
   /* replace472_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('ine', ('iadd', 'a', 'b'), 'a') => ('ine', 'b', 0) */
   /* search473_0_0 -> 0 in the cache */
   /* search473_0_1 -> 1 in the cache */
   /* search473_0 -> 241 in the cache */
   /* search473_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 2,
      { 241, 0 },
      -1,
   } },

   /* replace473_0 -> 1 in the cache */
   /* replace473_1 -> 98 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 1, 98 },
      -1,
   } },

   /* ('fge', 0.0, ('b2f', 'a@1')) => ('inot', 'a') */
   /* search474_0 -> 1462 in the cache */
   /* search474_1_0 -> 973 in the cache */
   /* search474_1 -> 1463 in the cache */
   /* search474 -> 1464 in the cache */

   /* replace474_0 -> 973 in the cache */
   /* replace474 -> 1465 in the cache */

   /* ('flt', 0.0, ('b2f', 'a@1')) => a */
   /* search475_0 -> 1462 in the cache */
   /* search475_1_0 -> 973 in the cache */
   /* search475_1 -> 1463 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1462, 1463 },
      -1,
   } },

   /* replace475 -> 973 in the cache */

   /* ('ieq', 'a@1', False) => ('inot', 'a') */
   /* search476_0 -> 973 in the cache */
   /* search476_1 -> 1351 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 973, 1351 },
      -1,
   } },

   /* replace476_0 -> 973 in the cache */
   /* replace476 -> 1465 in the cache */

   /* ('ieq', 'a@1', True) => a */
   /* search477_0 -> 973 in the cache */
   { .constant = {
      { nir_search_value_constant, 1 },
      nir_type_bool, { NIR_TRUE /* True */ },
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ieq,
      0, 1,
      { 973, 1550 },
      -1,
   } },

   /* replace477 -> 973 in the cache */

   /* ('ine', 'a@1', False) => a */
   /* search478_0 -> 973 in the cache */
   /* search478_1 -> 1351 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 973, 1351 },
      -1,
   } },

   /* replace478 -> 973 in the cache */

   /* ('ine', 'a@1', True) => ('inot', 'a') */
   /* search479_0 -> 973 in the cache */
   /* search479_1 -> 1550 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ine,
      0, 1,
      { 973, 1550 },
      -1,
   } },

   /* replace479_0 -> 973 in the cache */
   /* replace479 -> 1465 in the cache */

   /* ('fneu', ('u2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search480_0_0 -> 9 in the cache */
   /* search480_0 -> 123 in the cache */
   /* search480_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 123, 1462 },
      -1,
   } },

   /* replace480_0 -> 9 in the cache */
   /* replace480_1 -> 73 in the cache */
   /* replace480 -> 1416 in the cache */

   /* ('feq', ('u2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search481_0_0 -> 9 in the cache */
   /* search481_0 -> 123 in the cache */
   /* search481_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 123, 1462 },
      -1,
   } },

   /* replace481_0 -> 9 in the cache */
   /* replace481_1 -> 73 in the cache */
   /* replace481 -> 1414 in the cache */

   /* ('fge', ('u2f', 'a'), 0.0) => True */
   /* search482_0_0 -> 9 in the cache */
   /* search482_0 -> 123 in the cache */
   /* search482_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 123, 1462 },
      -1,
   } },

   /* replace482 -> 1550 in the cache */

   /* ('fge', 0.0, ('u2f', 'a')) => ('ieq', 0, 'a') */
   /* search483_0 -> 1462 in the cache */
   /* search483_1_0 -> 9 in the cache */
   /* search483_1 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1462, 123 },
      -1,
   } },

   /* replace483_0 -> 73 in the cache */
   /* replace483_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('u2f', 'a'), 0.0) => False */
   /* search484_0_0 -> 9 in the cache */
   /* search484_0 -> 123 in the cache */
   /* search484_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 123, 1462 },
      -1,
   } },

   /* replace484 -> 1351 in the cache */

   /* ('flt', 0.0, ('u2f', 'a')) => ('ine', 0, 'a') */
   /* search485_0 -> 1462 in the cache */
   /* search485_1_0 -> 9 in the cache */
   /* search485_1 -> 123 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1462, 123 },
      -1,
   } },

   /* replace485_0 -> 73 in the cache */
   /* replace485_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 73, 9 },
      -1,
   } },

   /* ('fneu', ('i2f', 'a'), 0.0) => ('ine', 'a', 0) */
   /* search486_0_0 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_i2f,
      -1, 0,
      { 9 },
      -1,
   } },
   /* search486_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fneu,
      0, 1,
      { 1562, 1462 },
      -1,
   } },

   /* replace486_0 -> 9 in the cache */
   /* replace486_1 -> 73 in the cache */
   /* replace486 -> 1416 in the cache */

   /* ('feq', ('i2f', 'a'), 0.0) => ('ieq', 'a', 0) */
   /* search487_0_0 -> 9 in the cache */
   /* search487_0 -> 1562 in the cache */
   /* search487_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_feq,
      0, 1,
      { 1562, 1462 },
      -1,
   } },

   /* replace487_0 -> 9 in the cache */
   /* replace487_1 -> 73 in the cache */
   /* replace487 -> 1414 in the cache */

   /* ('fge', ('i2f', 'a'), 0.0) => ('ige', 'a', 0) */
   /* search488_0_0 -> 9 in the cache */
   /* search488_0 -> 1562 in the cache */
   /* search488_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1562, 1462 },
      -1,
   } },

   /* replace488_0 -> 9 in the cache */
   /* replace488_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ige,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('fge', 0.0, ('i2f', 'a')) => ('ige', 0, 'a') */
   /* search489_0 -> 1462 in the cache */
   /* search489_1_0 -> 9 in the cache */
   /* search489_1 -> 1562 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1462, 1562 },
      -1,
   } },

   /* replace489_0 -> 73 in the cache */
   /* replace489_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('flt', ('i2f', 'a'), 0.0) => ('ilt', 'a', 0) */
   /* search490_0_0 -> 9 in the cache */
   /* search490_0 -> 1562 in the cache */
   /* search490_1 -> 1462 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 1562, 1462 },
      -1,
   } },

   /* replace490_0 -> 9 in the cache */
   /* replace490_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ilt,
      -1, 0,
      { 9, 73 },
      -1,
   } },

   /* ('flt', 0.0, ('i2f', 'a')) => ('ilt', 0, 'a') */
   /* search491_0 -> 1462 in the cache */
   /* search491_1_0 -> 9 in the cache */
   /* search491_1 -> 1562 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1462, 1562 },
      -1,
   } },

   /* replace491_0 -> 73 in the cache */
   /* replace491_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 73, 9 },
      -1,
   } },

   /* ('~flt', 0.0, ('fabs', 'a')) => ('fneu', 'a', 0.0) */
   /* search492_0 -> 8 in the cache */
   /* search492_1_0 -> 9 in the cache */
   /* search492_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace492_0 -> 9 in the cache */
   /* replace492_1 -> 8 in the cache */
   /* replace492 -> 1426 in the cache */

   /* ('~flt', ('fneg', ('fabs', 'a')), 0.0) => ('fneu', 'a', 0.0) */
   /* search493_0_0_0 -> 9 in the cache */
   /* search493_0_0 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 11 },
      -1,
   } },
   /* search493_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 0,
      { 1574, 8 },
      -1,
   } },

   /* replace493_0 -> 9 in the cache */
   /* replace493_1 -> 8 in the cache */
   /* replace493 -> 1426 in the cache */

   /* ('fge', 0.0, ('fabs', 'a')) => ('feq', 'a', 0.0) */
   /* search494_0 -> 8 in the cache */
   /* search494_1_0 -> 9 in the cache */
   /* search494_1 -> 11 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 8, 11 },
      -1,
   } },

   /* replace494_0 -> 9 in the cache */
   /* replace494_1 -> 8 in the cache */
   /* replace494 -> 1428 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search495_0_0_0 -> 9 in the cache */
   /* search495_0_0 -> 11 in the cache */
   /* search495_0 -> 1574 in the cache */
   /* search495_1 -> 8 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fge,
      -1, 0,
      { 1574, 8 },
      -1,
   } },

   /* replace495_0 -> 9 in the cache */
   /* replace495_1 -> 8 in the cache */
   /* replace495 -> 1428 in the cache */

   /* ('iand', ('fge', 'a', 0.0), ('fge', 1.0, 'a')) => ('feq', 'a', ('fsat', 'a')) */
   /* search496_0_0 -> 9 in the cache */
   /* search496_0_1 -> 8 in the cache */
   /* search496_0 -> 1496 in the cache */
   /* search496_1_0 -> 281 in the cache */
   /* search496_1_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 281, 9 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1496, 1578 },
      -1,
   } },

   /* replace496_0 -> 9 in the cache */
   /* replace496_1_0 -> 9 in the cache */
   /* replace496_1 -> 249 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 9, 249 },
      -1,
   } },

   /* ('fmax', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('ior', 'a', 'b')) */
   /* search497_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 973 },
      0,
   } },
   /* search497_1_0 -> 1468 in the cache */
   /* search497_1 -> 1469 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1581, 1469 },
      -1,
   } },

   /* replace497_0_0 -> 973 in the cache */
   /* replace497_0_1 -> 1468 in the cache */
   /* replace497_0 -> 1472 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 1472 },
      -1,
   } },

   /* ('fmax', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('iand', 'a', 'b'))) */
   /* search498_0_0_0 -> 973 in the cache */
   /* search498_0_0 -> 1581 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 0,
      { 1581 },
      0,
   } },
   /* search498_1_0_0 -> 1468 in the cache */
   /* search498_1_0 -> 1469 in the cache */
   /* search498_1 -> 1473 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1584, 1473 },
      -1,
   } },

   /* replace498_0_0_0 -> 973 in the cache */
   /* replace498_0_0_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 973, 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 1,
      { 1586 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1587 },
      -1,
   } },

   /* ('fmin', ('b2f(is_used_once)', 'a@1'), ('b2f', 'b@1')) => ('b2f', ('iand', 'a', 'b')) */
   /* search499_0_0 -> 973 in the cache */
   /* search499_0 -> 1581 in the cache */
   /* search499_1_0 -> 1468 in the cache */
   /* search499_1 -> 1469 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1581, 1469 },
      -1,
   } },

   /* replace499_0_0 -> 973 in the cache */
   /* replace499_0_1 -> 1468 in the cache */
   /* replace499_0 -> 1586 in the cache */
   /* replace499 -> 1587 in the cache */

   /* ('fmin', ('fneg(is_used_once)', ('b2f(is_used_once)', 'a@1')), ('fneg', ('b2f', 'b@1'))) => ('fneg', ('b2f', ('ior', 'a', 'b'))) */
   /* search500_0_0_0 -> 973 in the cache */
   /* search500_0_0 -> 1581 in the cache */
   /* search500_0 -> 1584 in the cache */
   /* search500_1_0_0 -> 1468 in the cache */
   /* search500_1_0 -> 1469 in the cache */
   /* search500_1 -> 1473 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1584, 1473 },
      -1,
   } },

   /* replace500_0_0_0 -> 973 in the cache */
   /* replace500_0_0_1 -> 1468 in the cache */
   /* replace500_0_0 -> 1472 in the cache */
   /* replace500_0 -> 1583 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1583 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f', 'b@1'), 0) => ('b2f', ('bcsel', 'a', 'b', False)) */
   /* search501_0 -> 973 in the cache */
   /* search501_1_0 -> 1468 in the cache */
   /* search501_1 -> 1469 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_int, { 0x0ull /* 0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1469, 1592 },
      -1,
   } },

   /* replace501_0_0 -> 973 in the cache */
   /* replace501_0_1 -> 1468 in the cache */
   /* replace501_0_2 -> 1351 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1468, 1351 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1594 },
      -1,
   } },

   /* ('bcsel', 'a', ('b2f', 'b@1'), 1.0) => ('b2f', ('bcsel', 'a', 'b', True)) */
   /* search502_0 -> 973 in the cache */
   /* search502_1_0 -> 1468 in the cache */
   /* search502_1 -> 1469 in the cache */
   { .constant = {
      { nir_search_value_constant, 0 },
      nir_type_float, { 0x3ff0000000000000ull /* 1.0 */ },
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1469, 1596 },
      -1,
   } },

   /* replace502_0_0 -> 973 in the cache */
   /* replace502_0_1 -> 1468 in the cache */
   /* replace502_0_2 -> 1550 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1468, 1550 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1598 },
      -1,
   } },

   /* ('bcsel', 'a', 0, ('b2f', 'b@1')) => ('b2f', ('bcsel', 'a', False, 'b')) */
   /* search503_0 -> 973 in the cache */
   /* search503_1 -> 1592 in the cache */
   /* search503_2_0 -> 1468 in the cache */
   /* search503_2 -> 1469 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1592, 1469 },
      -1,
   } },

   /* replace503_0_0 -> 973 in the cache */
   /* replace503_0_1 -> 1351 in the cache */
   /* replace503_0_2 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1351, 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1601 },
      -1,
   } },

   /* ('bcsel', 'a', 1.0, ('b2f', 'b@1')) => ('b2f', ('bcsel', 'a', True, 'b')) */
   /* search504_0 -> 973 in the cache */
   /* search504_1 -> 1596 in the cache */
   /* search504_2_0 -> 1468 in the cache */
   /* search504_2 -> 1469 in the cache */
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1596, 1469 },
      -1,
   } },

   /* replace504_0_0 -> 973 in the cache */
   /* replace504_0_1 -> 1550 in the cache */
   /* replace504_0_2 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1550, 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 0 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 1604 },
      -1,
   } },

   /* ('fmin', ('b2f', 'a@1'), '#b') => ('bcsel', 'a', ('fmin', 'b', 1.0), ('fmin', 'b', 0.0)) */
   /* search505_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_search_op_b2f,
      -1, 0,
      { 973 },
      -1,
   } },
   /* search505_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1606, 1038 },
      -1,
   } },

   /* replace505_0 -> 973 in the cache */
   /* replace505_1_0 -> 1 in the cache */
   /* replace505_1_1 -> 305 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmin,
      0, 1,
      { 1, 305 },
      -1,
   } },
   /* replace505_2_0 -> 1 in the cache */
   /* replace505_2_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmin,
      1, 1,
      { 1, 295 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 973, 1608, 1609 },
      -1,
   } },

   /* ('flt', ('fadd(is_used_once)', 'a', ('fneg', 'b')), 0.0) => ('flt', 'a', 'b') */
   /* search506_0_0 -> 0 in the cache */
   /* search506_0_1_0 -> 1 in the cache */
   /* search506_0_1 -> 1361 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fadd,
      0, 1,
      { 0, 1361 },
      0,
   } },
   /* search506_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_flt,
      -1, 1,
      { 1611, 295 },
      -1,
   } },

   /* replace506_0 -> 0 in the cache */
   /* replace506_1 -> 1 in the cache */
   /* replace506 -> 3 in the cache */

   /* ('fge', ('fneg', ('fabs', 'a')), 0.0) => ('feq', 'a', 0.0) */
   /* search507_0_0_0 -> 9 in the cache */
   /* search507_0_0 -> 11 in the cache */
   /* search507_0 -> 1574 in the cache */
   /* search507_1 -> 8 in the cache */
   /* search507 -> 1577 in the cache */

   /* replace507_0 -> 9 in the cache */
   /* replace507_1 -> 8 in the cache */
   /* replace507 -> 1428 in the cache */

   /* ('~bcsel', ('flt', 'b', 'a'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search508_0_0 -> 1378 in the cache */
   /* search508_0_1 -> 1377 in the cache */
   /* search508_0 -> 1436 in the cache */
   /* search508_1 -> 1378 in the cache */
   /* search508_2 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1436, 1378, 1377 },
      -1,
   } },

   /* replace508_0 -> 1377 in the cache */
   /* replace508_1 -> 1378 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1377, 1378 },
      -1,
   } },

   /* ('~bcsel', ('flt', 'a', 'b'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search509_0_0 -> 0 in the cache */
   /* search509_0_1 -> 1 in the cache */
   /* search509_0 -> 3 in the cache */
   /* search509_1 -> 1 in the cache */
   /* search509_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 3, 1, 0 },
      -1,
   } },

   /* replace509_0 -> 0 in the cache */
   /* replace509_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'a', 'b'), 'b', 'a') => ('fmin', 'a', 'b') */
   /* search510_0_0 -> 0 in the cache */
   /* search510_0_1 -> 1 in the cache */
   /* search510_0 -> 6 in the cache */
   /* search510_1 -> 1 in the cache */
   /* search510_2 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 6, 1, 0 },
      -1,
   } },

   /* replace510_0 -> 0 in the cache */
   /* replace510_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('~bcsel', ('fge', 'b', 'a'), 'b', 'a') => ('fmax', 'a', 'b') */
   /* search511_0_0 -> 1378 in the cache */
   /* search511_0_1 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1378, 1377 },
      -1,
   } },
   /* search511_1 -> 1378 in the cache */
   /* search511_2 -> 1377 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      true,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1619, 1378, 1377 },
      -1,
   } },

   /* replace511_0 -> 1377 in the cache */
   /* replace511_1 -> 1378 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1377, 1378 },
      -1,
   } },

   /* ('bcsel', ('inot', 'a'), 'b', 'c') => ('bcsel', 'a', 'c', 'b') */
   /* search512_0_0 -> 973 in the cache */
   /* search512_0 -> 1465 in the cache */
   /* search512_1 -> 144 in the cache */
   /* search512_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1465, 144, 146 },
      -1,
   } },

   /* replace512_0 -> 973 in the cache */
   /* replace512_1 -> 146 in the cache */
   /* replace512_2 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 146, 144 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel', 'a', 'b', 'c'), 'd') => ('bcsel', 'a', 'b', 'd') */
   /* search513_0 -> 973 in the cache */
   /* search513_1_0 -> 973 in the cache */
   /* search513_1_1 -> 167 in the cache */
   /* search513_1_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 167, 169 },
      -1,
   } },
   /* search513_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1624, 170 },
      -1,
   } },

   /* replace513_0 -> 973 in the cache */
   /* replace513_1 -> 167 in the cache */
   /* replace513_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 167, 170 },
      -1,
   } },

   /* ('bcsel', 'a', 'b', ('bcsel', 'a', 'c', 'd')) => ('bcsel', 'a', 'b', 'd') */
   /* search514_0 -> 973 in the cache */
   /* search514_1 -> 167 in the cache */
   /* search514_2_0 -> 973 in the cache */
   /* search514_2_1 -> 169 in the cache */
   /* search514_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 167, 1627 },
      -1,
   } },

   /* replace514_0 -> 973 in the cache */
   /* replace514_1 -> 167 in the cache */
   /* replace514_2 -> 170 in the cache */
   /* replace514 -> 1626 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search515_0 -> 973 in the cache */
   /* search515_1_0 -> 1468 in the cache */
   /* search515_1_1 -> 975 in the cache */
   /* search515_1_2 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 975, 983 },
      -1,
   } },
   /* search515_2_0 -> 1468 in the cache */
   /* search515_2_1 -> 975 in the cache */
   /* search515_2_2 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 975, 985 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1629, 1630 },
      -1,
   } },

   /* replace515_0 -> 1468 in the cache */
   /* replace515_1 -> 975 in the cache */
   /* replace515_2_0 -> 973 in the cache */
   /* replace515_2_1 -> 983 in the cache */
   /* replace515_2_2 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 983, 985 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 975, 1632 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'c', 'e')) => ('bcsel', 'b', 'c', ('bcsel', 'a', 'd', 'e')) */
   /* search516_0 -> 973 in the cache */
   /* search516_1_0 -> 1468 in the cache */
   /* search516_1_1 -> 975 in the cache */
   /* search516_1_2 -> 983 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 975, 983 },
      0,
   } },
   /* search516_2_0 -> 1468 in the cache */
   /* search516_2_1 -> 975 in the cache */
   /* search516_2_2 -> 985 in the cache */
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 975, 985 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -5 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1634, 1635 },
      -1,
   } },

   /* replace516_0 -> 1468 in the cache */
   /* replace516_1 -> 975 in the cache */
   /* replace516_2_0 -> 973 in the cache */
   /* replace516_2_1 -> 983 in the cache */
   /* replace516_2_2 -> 985 in the cache */
   /* replace516_2 -> 1632 in the cache */
   /* replace516 -> 1633 in the cache */

   /* ('bcsel', 'a', ('bcsel', 'b', 'c', 'd'), ('bcsel(is_used_once)', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search517_0 -> 973 in the cache */
   /* search517_1_0 -> 1468 in the cache */
   /* search517_1_1 -> 169 in the cache */
   /* search517_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 169, 170 },
      -1,
   } },
   /* search517_2_0 -> 1468 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      4, /* e */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search517_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 1638, 170 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1637, 1639 },
      -1,
   } },

   /* replace517_0 -> 1468 in the cache */
   /* replace517_1_0 -> 973 in the cache */
   /* replace517_1_1 -> 169 in the cache */
   /* replace517_1_2 -> 1638 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 169, 1638 },
      -1,
   } },
   /* replace517_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 1641, 170 },
      -1,
   } },

   /* ('bcsel', 'a', ('bcsel(is_used_once)', 'b', 'c', 'd'), ('bcsel', 'b', 'e', 'd')) => ('bcsel', 'b', ('bcsel', 'a', 'c', 'e'), 'd') */
   /* search518_0 -> 973 in the cache */
   /* search518_1_0 -> 1468 in the cache */
   /* search518_1_1 -> 169 in the cache */
   /* search518_1_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 169, 170 },
      0,
   } },
   /* search518_2_0 -> 1468 in the cache */
   /* search518_2_1 -> 1638 in the cache */
   /* search518_2_2 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1468, 1638, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1643, 1644 },
      -1,
   } },

   /* replace518_0 -> 1468 in the cache */
   /* replace518_1_0 -> 973 in the cache */
   /* replace518_1_1 -> 169 in the cache */
   /* replace518_1_2 -> 1638 in the cache */
   /* replace518_1 -> 1641 in the cache */
   /* replace518_2 -> 170 in the cache */
   /* replace518 -> 1642 in the cache */

   /* ('bcsel', 'a', True, 'b') => ('ior', 'a', 'b') */
   /* search519_0 -> 973 in the cache */
   /* search519_1 -> 1550 in the cache */
   /* search519_2 -> 1468 in the cache */
   /* search519 -> 1604 in the cache */

   /* replace519_0 -> 973 in the cache */
   /* replace519_1 -> 1468 in the cache */
   /* replace519 -> 1472 in the cache */

   /* ('bcsel', 'a', 'a', 'b') => ('ior', 'a', 'b') */
   /* search520_0 -> 973 in the cache */
   /* search520_1 -> 973 in the cache */
   /* search520_2 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 973, 1468 },
      -1,
   } },

   /* replace520_0 -> 973 in the cache */
   /* replace520_1 -> 1468 in the cache */
   /* replace520 -> 1472 in the cache */

   /* ('bcsel', 'a', 'b', False) => ('iand', 'a', 'b') */
   /* search521_0 -> 973 in the cache */
   /* search521_1 -> 1468 in the cache */
   /* search521_2 -> 1351 in the cache */
   /* search521 -> 1594 in the cache */

   /* replace521_0 -> 973 in the cache */
   /* replace521_1 -> 1468 in the cache */
   /* replace521 -> 1586 in the cache */

   /* ('bcsel', 'a', 'b', 'a') => ('iand', 'a', 'b') */
   /* search522_0 -> 973 in the cache */
   /* search522_1 -> 1468 in the cache */
   /* search522_2 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1468, 973 },
      -1,
   } },

   /* replace522_0 -> 973 in the cache */
   /* replace522_1 -> 1468 in the cache */
   /* replace522 -> 1586 in the cache */

   /* ('bcsel', 'a', 'b', True) => ('ior', ('inot', 'a'), 'b') */
   /* search523_0 -> 973 in the cache */
   /* search523_1 -> 1468 in the cache */
   /* search523_2 -> 1550 in the cache */
   /* search523 -> 1598 in the cache */

   /* replace523_0_0 -> 973 in the cache */
   /* replace523_0 -> 1465 in the cache */
   /* replace523_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ior,
      0, 1,
      { 1465, 1468 },
      -1,
   } },

   /* ('bcsel', 'a', False, 'b') => ('iand', ('inot', 'a'), 'b') */
   /* search524_0 -> 973 in the cache */
   /* search524_1 -> 1351 in the cache */
   /* search524_2 -> 1468 in the cache */
   /* search524 -> 1601 in the cache */

   /* replace524_0_0 -> 973 in the cache */
   /* replace524_0 -> 1465 in the cache */
   /* replace524_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_iand,
      0, 1,
      { 1465, 1468 },
      -1,
   } },

   /* ('fmin', 'a@64', 'a') => a */
   /* search525_0 -> 34 in the cache */
   /* search525_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      -1, 0,
      { 34, 34 },
      -1,
   } },

   /* replace525 -> 34 in the cache */

   /* ('fmin', 'a@32', 'a') => a */
   /* search526_0 -> 29 in the cache */
   /* search526_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* replace526 -> 29 in the cache */

   /* ('fmin', 'a@16', 'a') => a */
   /* search527_0 -> 24 in the cache */
   /* search527_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      -1, 0,
      { 24, 24 },
      -1,
   } },

   /* replace527 -> 24 in the cache */

   /* ('fmax', 'a@64', 'a') => a */
   /* search528_0 -> 34 in the cache */
   /* search528_1 -> 34 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      -1, 0,
      { 34, 34 },
      -1,
   } },

   /* replace528 -> 34 in the cache */

   /* ('fmax', 'a@32', 'a') => a */
   /* search529_0 -> 29 in the cache */
   /* search529_1 -> 29 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      -1, 0,
      { 29, 29 },
      -1,
   } },

   /* replace529 -> 29 in the cache */

   /* ('fmax', 'a@16', 'a') => a */
   /* search530_0 -> 24 in the cache */
   /* search530_1 -> 24 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      -1, 0,
      { 24, 24 },
      -1,
   } },

   /* replace530 -> 24 in the cache */

   /* ('imin', 'a', 'a') => a */
   /* search531_0 -> 9 in the cache */
   /* search531_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace531 -> 9 in the cache */

   /* ('imax', 'a', 'a') => a */
   /* search532_0 -> 9 in the cache */
   /* search532_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace532 -> 9 in the cache */

   /* ('umin', 'a', 'a') => a */
   /* search533_0 -> 9 in the cache */
   /* search533_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace533 -> 9 in the cache */

   /* ('umin', 'a', 0) => 0 */
   /* search534_0 -> 9 in the cache */
   /* search534_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umin,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace534 -> 73 in the cache */

   /* ('umin', 'a', -1) => a */
   /* search535_0 -> 9 in the cache */
   /* search535_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umin,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace535 -> 9 in the cache */

   /* ('umax', 'a', 'a') => a */
   /* search536_0 -> 9 in the cache */
   /* search536_1 -> 9 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      -1, 0,
      { 9, 9 },
      -1,
   } },

   /* replace536 -> 9 in the cache */

   /* ('umax', 'a', 0) => a */
   /* search537_0 -> 9 in the cache */
   /* search537_1 -> 73 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umax,
      0, 1,
      { 9, 73 },
      -1,
   } },

   /* replace537 -> 9 in the cache */

   /* ('umax', 'a', -1) => -1 */
   /* search538_0 -> 9 in the cache */
   /* search538_1 -> 75 in the cache */
   { .expression = {
      { nir_search_value_expression, -1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_umax,
      0, 1,
      { 9, 75 },
      -1,
   } },

   /* replace538 -> 75 in the cache */

   /* ('fmax', ('fmax', 'a', 'b'), 'b') => ('fmax', 'a', 'b') */
   /* search539_0_0 -> 0 in the cache */
   /* search539_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search539_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 2,
      { 1664, 1 },
      -1,
   } },

   /* replace539_0 -> 0 in the cache */
   /* replace539_1 -> 1 in the cache */
   /* replace539 -> 1616 in the cache */

   /* ('umax', ('umax', 'a', 'b'), 'b') => ('umax', 'a', 'b') */
   /* search540_0_0 -> 0 in the cache */
   /* search540_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search540_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 2,
      { 1666, 1 },
      -1,
   } },

   /* replace540_0 -> 0 in the cache */
   /* replace540_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imax', ('imax', 'a', 'b'), 'b') => ('imax', 'a', 'b') */
   /* search541_0_0 -> 0 in the cache */
   /* search541_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search541_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 2,
      { 1669, 1 },
      -1,
   } },

   /* replace541_0 -> 0 in the cache */
   /* replace541_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmin', ('fmin', 'a', 'b'), 'b') => ('fmin', 'a', 'b') */
   /* search542_0_0 -> 0 in the cache */
   /* search542_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search542_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 2,
      { 1672, 1 },
      -1,
   } },

   /* replace542_0 -> 0 in the cache */
   /* replace542_1 -> 1 in the cache */
   /* replace542 -> 1618 in the cache */

   /* ('umin', ('umin', 'a', 'b'), 'b') => ('umin', 'a', 'b') */
   /* search543_0_0 -> 0 in the cache */
   /* search543_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search543_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 2,
      { 1674, 1 },
      -1,
   } },

   /* replace543_0 -> 0 in the cache */
   /* replace543_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('imin', ('imin', 'a', 'b'), 'b') => ('imin', 'a', 'b') */
   /* search544_0_0 -> 0 in the cache */
   /* search544_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      1, 1,
      { 0, 1 },
      -1,
   } },
   /* search544_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 2,
      { 1677, 1 },
      -1,
   } },

   /* replace544_0 -> 0 in the cache */
   /* replace544_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 1,
      { 0, 1 },
      -1,
   } },

   /* ('fmax', ('fmax', ('fmax', 'a', 'b'), 'c'), 'a') => ('fmax', ('fmax', 'a', 'b'), 'c') */
   /* search545_0_0_0 -> 143 in the cache */
   /* search545_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search545_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      1, 2,
      { 1680, 146 },
      -1,
   } },
   /* search545_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 3,
      { 1681, 143 },
      -1,
   } },

   /* replace545_0_0 -> 143 in the cache */
   /* replace545_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace545_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 2,
      { 1683, 146 },
      -1,
   } },

   /* ('umax', ('umax', ('umax', 'a', 'b'), 'c'), 'a') => ('umax', ('umax', 'a', 'b'), 'c') */
   /* search546_0_0_0 -> 143 in the cache */
   /* search546_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search546_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      1, 2,
      { 1685, 146 },
      -1,
   } },
   /* search546_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 3,
      { 1686, 143 },
      -1,
   } },

   /* replace546_0_0 -> 143 in the cache */
   /* replace546_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace546_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 2,
      { 1688, 146 },
      -1,
   } },

   /* ('imax', ('imax', ('imax', 'a', 'b'), 'c'), 'a') => ('imax', ('imax', 'a', 'b'), 'c') */
   /* search547_0_0_0 -> 143 in the cache */
   /* search547_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search547_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      1, 2,
      { 1690, 146 },
      -1,
   } },
   /* search547_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 3,
      { 1691, 143 },
      -1,
   } },

   /* replace547_0_0 -> 143 in the cache */
   /* replace547_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace547_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 2,
      { 1693, 146 },
      -1,
   } },

   /* ('fmin', ('fmin', ('fmin', 'a', 'b'), 'c'), 'a') => ('fmin', ('fmin', 'a', 'b'), 'c') */
   /* search548_0_0_0 -> 143 in the cache */
   /* search548_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search548_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 2,
      { 1695, 146 },
      -1,
   } },
   /* search548_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 3,
      { 1696, 143 },
      -1,
   } },

   /* replace548_0_0 -> 143 in the cache */
   /* replace548_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace548_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 2,
      { 1698, 146 },
      -1,
   } },

   /* ('umin', ('umin', ('umin', 'a', 'b'), 'c'), 'a') => ('umin', ('umin', 'a', 'b'), 'c') */
   /* search549_0_0_0 -> 143 in the cache */
   /* search549_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search549_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      1, 2,
      { 1700, 146 },
      -1,
   } },
   /* search549_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 3,
      { 1701, 143 },
      -1,
   } },

   /* replace549_0_0 -> 143 in the cache */
   /* replace549_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace549_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 2,
      { 1703, 146 },
      -1,
   } },

   /* ('imin', ('imin', ('imin', 'a', 'b'), 'c'), 'a') => ('imin', ('imin', 'a', 'b'), 'c') */
   /* search550_0_0_0 -> 143 in the cache */
   /* search550_0_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      2, 1,
      { 143, 144 },
      -1,
   } },
   /* search550_0_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      1, 2,
      { 1705, 146 },
      -1,
   } },
   /* search550_1 -> 143 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 3,
      { 1706, 143 },
      -1,
   } },

   /* replace550_0_0 -> 143 in the cache */
   /* replace550_0_1 -> 144 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      1, 1,
      { 143, 144 },
      -1,
   } },
   /* replace550_1 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 2,
      { 1708, 146 },
      -1,
   } },

   /* ('fmin', ('fmax', 'a(is_finite)', 'b'), 'a') => ('fmul', 1.0, 'a') */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      5,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search551_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      1, 1,
      { 1710, 1 },
      -1,
   } },
   /* search551_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 2,
      { 1711, 0 },
      -1,
   } },

   /* replace551_0 -> 305 in the cache */
   /* replace551_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmul,
      0, 1,
      { 305, 0 },
      -1,
   } },

   /* ('fmax', ('fmin', 'a(is_finite)', 'b'), 'a') => ('fmul', 1.0, 'a') */
   /* search552_0_0 -> 1710 in the cache */
   /* search552_0_1 -> 1 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      1, 1,
      { 1710, 1 },
      -1,
   } },
   /* search552_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 2,
      { 1714, 0 },
      -1,
   } },

   /* replace552_0 -> 305 in the cache */
   /* replace552_1 -> 0 in the cache */
   /* replace552 -> 1713 in the cache */

   /* ('umin', ('umax', 'a', 'b'), 'a') => a */
   /* search553_0_0 -> 0 in the cache */
   /* search553_0_1 -> 1 in the cache */
   /* search553_0 -> 1666 in the cache */
   /* search553_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umin,
      0, 2,
      { 1666, 0 },
      -1,
   } },

   /* replace553 -> 0 in the cache */

   /* ('umax', ('umin', 'a', 'b'), 'a') => a */
   /* search554_0_0 -> 0 in the cache */
   /* search554_0_1 -> 1 in the cache */
   /* search554_0 -> 1674 in the cache */
   /* search554_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_umax,
      0, 2,
      { 1674, 0 },
      -1,
   } },

   /* replace554 -> 0 in the cache */

   /* ('imin', ('imax', 'a', 'b'), 'a') => a */
   /* search555_0_0 -> 0 in the cache */
   /* search555_0_1 -> 1 in the cache */
   /* search555_0 -> 1669 in the cache */
   /* search555_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imin,
      0, 2,
      { 1669, 0 },
      -1,
   } },

   /* replace555 -> 0 in the cache */

   /* ('imax', ('imin', 'a', 'b'), 'a') => a */
   /* search556_0_0 -> 0 in the cache */
   /* search556_0_1 -> 1 in the cache */
   /* search556_0 -> 1677 in the cache */
   /* search556_1 -> 0 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_imax,
      0, 2,
      { 1677, 0 },
      -1,
   } },

   /* replace556 -> 0 in the cache */

   /* ('fmax(nsz)', 'a(is_a_number_not_negative)', 'b(is_not_positive)') => ('fmul', 'a', 1.0) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      22,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      23,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1720, 1721 },
      -1,
   } },

   /* replace557_0 -> 0 in the cache */
   /* replace557_1 -> 305 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmul,
      0, 1,
      { 0, 305 },
      -1,
   } },

   /* ('fmin(nsz)', 'a(is_a_number_not_positive)', 'b(is_not_negative)') => ('fmul', 'a', 1.0) */
   { .variable = {
      { nir_search_value_variable, -2 },
      0, /* a */
      false,
      nir_type_invalid,
      24,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      25,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1724, 1725 },
      -1,
   } },

   /* replace558_0 -> 0 in the cache */
   /* replace558_1 -> 305 in the cache */
   /* replace558 -> 1723 in the cache */

   /* ('fmax', 'a(is_a_number_not_negative)', 'b(is_lt_zero)') => ('fmul', 'a', 1.0) */
   /* search559_0 -> 1720 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      26,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 1720, 1727 },
      -1,
   } },

   /* replace559_0 -> 0 in the cache */
   /* replace559_1 -> 305 in the cache */
   /* replace559 -> 1723 in the cache */

   /* ('fmin', 'a(is_a_number_not_positive)', 'b(is_gt_zero)') => ('fmul', 'a', 1.0) */
   /* search560_0 -> 1724 in the cache */
   { .variable = {
      { nir_search_value_variable, -2 },
      1, /* b */
      false,
      nir_type_invalid,
      27,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 1724, 1729 },
      -1,
   } },

   /* replace560_0 -> 0 in the cache */
   /* replace560_1 -> 305 in the cache */
   /* replace560 -> 1723 in the cache */

   /* ('fneg', ('fmax(is_used_once)', ('fneg', 'a'), ('fneg', 'b'))) => ('fmin', 'a', 'b') */
   /* search561_0_0_0 -> 0 in the cache */
   /* search561_0_0 -> 132 in the cache */
   /* search561_0_1_0 -> 1 in the cache */
   /* search561_0_1 -> 1361 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 132, 1361 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1731 },
      -1,
   } },

   /* replace561_0 -> 0 in the cache */
   /* replace561_1 -> 1 in the cache */
   /* replace561 -> 1618 in the cache */

   /* ('fneg', ('fmin(is_used_once)', ('fneg', 'a'), ('fneg', 'b'))) => ('fmax', 'a', 'b') */
   /* search562_0_0_0 -> 0 in the cache */
   /* search562_0_0 -> 132 in the cache */
   /* search562_0_1_0 -> 1 in the cache */
   /* search562_0_1 -> 1361 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 132, 1361 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1733 },
      -1,
   } },

   /* replace562_0 -> 0 in the cache */
   /* replace562_1 -> 1 in the cache */
   /* replace562 -> 1616 in the cache */

   /* ('fneg', ('fmax(is_used_once)', ('fneg', 'a'), '#b')) => ('fmin', 'a', ('fneg', 'b')) */
   /* search563_0_0_0 -> 0 in the cache */
   /* search563_0_0 -> 132 in the cache */
   /* search563_0_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 132, 1038 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1735 },
      -1,
   } },

   /* replace563_0 -> 0 in the cache */
   /* replace563_1_0 -> 1 in the cache */
   /* replace563_1 -> 1361 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 0, 1361 },
      -1,
   } },

   /* ('fneg', ('fmin(is_used_once)', ('fneg', 'a'), '#b')) => ('fmax', 'a', ('fneg', 'b')) */
   /* search564_0_0_0 -> 0 in the cache */
   /* search564_0_0 -> 132 in the cache */
   /* search564_0_1 -> 1038 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 132, 1038 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneg,
      -1, 1,
      { 1738 },
      -1,
   } },

   /* replace564_0 -> 0 in the cache */
   /* replace564_1_0 -> 1 in the cache */
   /* replace564_1 -> 1361 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 0, 1361 },
      -1,
   } },

   /* ('fmin(nsz)', 'a', '#b(is_negative_zero)') => ('fmin', 'a', 0.0) */
   /* search565_0 -> 0 in the cache */
   /* search565_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmin,
      0, 1,
      { 0, 130 },
      -1,
   } },

   /* replace565_0 -> 0 in the cache */
   /* replace565_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmin,
      0, 1,
      { 0, 295 },
      -1,
   } },

   /* ('fmax(nsz)', 'a', '#b(is_negative_zero)') => ('fmax', 'a', 0.0) */
   /* search566_0 -> 0 in the cache */
   /* search566_1 -> 130 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      true,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fmax,
      0, 1,
      { 0, 130 },
      -1,
   } },

   /* replace566_0 -> 0 in the cache */
   /* replace566_1 -> 295 in the cache */
   { .expression = {
      { nir_search_value_expression, -2 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_fmax,
      0, 1,
      { 0, 295 },
      -1,
   } },

   /* ('ine', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd')) */
   /* search567_0_0 -> 973 in the cache */
   /* search567_0_1 -> 167 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 167, 1745 },
      0,
   } },
   /* search567_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1746, 1310 },
      -1,
   } },

   /* replace567_0 -> 973 in the cache */
   /* replace567_1_0 -> 167 in the cache */
   /* replace567_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 167, 170 },
      -1,
   } },
   /* replace567_2_0 -> 169 in the cache */
   /* replace567_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      1, 1,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 973, 1748, 1749 },
      -1,
   } },

   /* ('ine', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ine', 'b', 'd'), ('ine', 'c', 'd')) */
   /* search568_0_0 -> 973 in the cache */
   /* search568_0_1 -> 1307 in the cache */
   /* search568_0_2 -> 169 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1307, 169 },
      0,
   } },
   /* search568_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1751, 1310 },
      -1,
   } },

   /* replace568_0 -> 973 in the cache */
   /* replace568_1_0 -> 167 in the cache */
   /* replace568_1_1 -> 170 in the cache */
   /* replace568_1 -> 1748 in the cache */
   /* replace568_2_0 -> 169 in the cache */
   /* replace568_2_1 -> 170 in the cache */
   /* replace568_2 -> 1749 in the cache */
   /* replace568 -> 1750 in the cache */

   /* ('ine', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c')) */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search569_1_0 -> 1498 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* b */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1754, 1755 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1753, 1756 },
      -1,
   } },

   /* replace569_0 -> 1498 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      0, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace569_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1758, 1754 },
      -1,
   } },
   /* replace569_2_0 -> 1758 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      1, 1,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1498, 1759, 1761 },
      -1,
   } },

   /* ('ine', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ine', 'd', 'b'), ('ine', 'd', 'c')) */
   /* search570_0 -> 1753 in the cache */
   /* search570_1_0 -> 1498 in the cache */
   { .variable = {
      { nir_search_value_variable, -4 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search570_1_2 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, -4 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1763, 1760 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1753, 1764 },
      -1,
   } },

   /* replace570_0 -> 1498 in the cache */
   /* replace570_1_0 -> 1758 in the cache */
   /* replace570_1_1 -> 1754 in the cache */
   /* replace570_1 -> 1759 in the cache */
   /* replace570_2_0 -> 1758 in the cache */
   /* replace570_2_1 -> 1760 in the cache */
   /* replace570_2 -> 1761 in the cache */
   /* replace570 -> 1762 in the cache */

   /* ('ieq', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd')) */
   /* search571_0_0 -> 973 in the cache */
   /* search571_0_1 -> 167 in the cache */
   /* search571_0_2 -> 1745 in the cache */
   /* search571_0 -> 1746 in the cache */
   /* search571_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1746, 1310 },
      -1,
   } },

   /* replace571_0 -> 973 in the cache */
   /* replace571_1_0 -> 167 in the cache */
   /* replace571_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 167, 170 },
      -1,
   } },
   /* replace571_2_0 -> 169 in the cache */
   /* replace571_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      1, 1,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 973, 1767, 1768 },
      -1,
   } },

   /* ('ieq', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ieq', 'b', 'd'), ('ieq', 'c', 'd')) */
   /* search572_0_0 -> 973 in the cache */
   /* search572_0_1 -> 1307 in the cache */
   /* search572_0_2 -> 169 in the cache */
   /* search572_0 -> 1751 in the cache */
   /* search572_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1751, 1310 },
      -1,
   } },

   /* replace572_0 -> 973 in the cache */
   /* replace572_1_0 -> 167 in the cache */
   /* replace572_1_1 -> 170 in the cache */
   /* replace572_1 -> 1767 in the cache */
   /* replace572_2_0 -> 169 in the cache */
   /* replace572_2_1 -> 170 in the cache */
   /* replace572_2 -> 1768 in the cache */
   /* replace572 -> 1769 in the cache */

   /* ('ieq', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c')) */
   /* search573_0 -> 1753 in the cache */
   /* search573_1_0 -> 1498 in the cache */
   /* search573_1_1 -> 1754 in the cache */
   /* search573_1_2 -> 1755 in the cache */
   /* search573_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1753, 1756 },
      -1,
   } },

   /* replace573_0 -> 1498 in the cache */
   /* replace573_1_0 -> 1758 in the cache */
   /* replace573_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1758, 1754 },
      -1,
   } },
   /* replace573_2_0 -> 1758 in the cache */
   /* replace573_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      1, 1,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1498, 1772, 1773 },
      -1,
   } },

   /* ('ieq', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ieq', 'd', 'b'), ('ieq', 'd', 'c')) */
   /* search574_0 -> 1753 in the cache */
   /* search574_1_0 -> 1498 in the cache */
   /* search574_1_1 -> 1763 in the cache */
   /* search574_1_2 -> 1760 in the cache */
   /* search574_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1753, 1764 },
      -1,
   } },

   /* replace574_0 -> 1498 in the cache */
   /* replace574_1_0 -> 1758 in the cache */
   /* replace574_1_1 -> 1754 in the cache */
   /* replace574_1 -> 1772 in the cache */
   /* replace574_2_0 -> 1758 in the cache */
   /* replace574_2_1 -> 1760 in the cache */
   /* replace574_2 -> 1773 in the cache */
   /* replace574 -> 1774 in the cache */

   /* ('ilt', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd')) */
   /* search575_0_0 -> 973 in the cache */
   /* search575_0_1 -> 167 in the cache */
   /* search575_0_2 -> 1745 in the cache */
   /* search575_0 -> 1746 in the cache */
   /* search575_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1746, 1310 },
      -1,
   } },

   /* replace575_0 -> 973 in the cache */
   /* replace575_1_0 -> 167 in the cache */
   /* replace575_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 167, 170 },
      -1,
   } },
   /* replace575_2_0 -> 169 in the cache */
   /* replace575_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1777, 1778 },
      -1,
   } },

   /* ('ilt', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ilt', 'b', 'd'), ('ilt', 'c', 'd')) */
   /* search576_0_0 -> 973 in the cache */
   /* search576_0_1 -> 1307 in the cache */
   /* search576_0_2 -> 169 in the cache */
   /* search576_0 -> 1751 in the cache */
   /* search576_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1751, 1310 },
      -1,
   } },

   /* replace576_0 -> 973 in the cache */
   /* replace576_1_0 -> 167 in the cache */
   /* replace576_1_1 -> 170 in the cache */
   /* replace576_1 -> 1777 in the cache */
   /* replace576_2_0 -> 169 in the cache */
   /* replace576_2_1 -> 170 in the cache */
   /* replace576_2 -> 1778 in the cache */
   /* replace576 -> 1779 in the cache */

   /* ('ilt', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c')) */
   /* search577_0 -> 1753 in the cache */
   /* search577_1_0 -> 1498 in the cache */
   /* search577_1_1 -> 1754 in the cache */
   /* search577_1_2 -> 1755 in the cache */
   /* search577_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1753, 1756 },
      -1,
   } },

   /* replace577_0 -> 1498 in the cache */
   /* replace577_1_0 -> 1758 in the cache */
   /* replace577_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1758, 1754 },
      -1,
   } },
   /* replace577_2_0 -> 1758 in the cache */
   /* replace577_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1782, 1783 },
      -1,
   } },

   /* ('ilt', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ilt', 'd', 'b'), ('ilt', 'd', 'c')) */
   /* search578_0 -> 1753 in the cache */
   /* search578_1_0 -> 1498 in the cache */
   /* search578_1_1 -> 1763 in the cache */
   /* search578_1_2 -> 1760 in the cache */
   /* search578_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ilt,
      -1, 0,
      { 1753, 1764 },
      -1,
   } },

   /* replace578_0 -> 1498 in the cache */
   /* replace578_1_0 -> 1758 in the cache */
   /* replace578_1_1 -> 1754 in the cache */
   /* replace578_1 -> 1782 in the cache */
   /* replace578_2_0 -> 1758 in the cache */
   /* replace578_2_1 -> 1760 in the cache */
   /* replace578_2 -> 1783 in the cache */
   /* replace578 -> 1784 in the cache */

   /* ('ige', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd')) */
   /* search579_0_0 -> 973 in the cache */
   /* search579_0_1 -> 167 in the cache */
   /* search579_0_2 -> 1745 in the cache */
   /* search579_0 -> 1746 in the cache */
   /* search579_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1746, 1310 },
      -1,
   } },

   /* replace579_0 -> 973 in the cache */
   /* replace579_1_0 -> 167 in the cache */
   /* replace579_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 167, 170 },
      -1,
   } },
   /* replace579_2_0 -> 169 in the cache */
   /* replace579_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1787, 1788 },
      -1,
   } },

   /* ('ige', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ige', 'b', 'd'), ('ige', 'c', 'd')) */
   /* search580_0_0 -> 973 in the cache */
   /* search580_0_1 -> 1307 in the cache */
   /* search580_0_2 -> 169 in the cache */
   /* search580_0 -> 1751 in the cache */
   /* search580_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1751, 1310 },
      -1,
   } },

   /* replace580_0 -> 973 in the cache */
   /* replace580_1_0 -> 167 in the cache */
   /* replace580_1_1 -> 170 in the cache */
   /* replace580_1 -> 1787 in the cache */
   /* replace580_2_0 -> 169 in the cache */
   /* replace580_2_1 -> 170 in the cache */
   /* replace580_2 -> 1788 in the cache */
   /* replace580 -> 1789 in the cache */

   /* ('ige', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c')) */
   /* search581_0 -> 1753 in the cache */
   /* search581_1_0 -> 1498 in the cache */
   /* search581_1_1 -> 1754 in the cache */
   /* search581_1_2 -> 1755 in the cache */
   /* search581_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1753, 1756 },
      -1,
   } },

   /* replace581_0 -> 1498 in the cache */
   /* replace581_1_0 -> 1758 in the cache */
   /* replace581_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1758, 1754 },
      -1,
   } },
   /* replace581_2_0 -> 1758 in the cache */
   /* replace581_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1792, 1793 },
      -1,
   } },

   /* ('ige', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ige', 'd', 'b'), ('ige', 'd', 'c')) */
   /* search582_0 -> 1753 in the cache */
   /* search582_1_0 -> 1498 in the cache */
   /* search582_1_1 -> 1763 in the cache */
   /* search582_1_2 -> 1760 in the cache */
   /* search582_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ige,
      -1, 0,
      { 1753, 1764 },
      -1,
   } },

   /* replace582_0 -> 1498 in the cache */
   /* replace582_1_0 -> 1758 in the cache */
   /* replace582_1_1 -> 1754 in the cache */
   /* replace582_1 -> 1792 in the cache */
   /* replace582_2_0 -> 1758 in the cache */
   /* replace582_2_1 -> 1760 in the cache */
   /* replace582_2 -> 1793 in the cache */
   /* replace582 -> 1794 in the cache */

   /* ('ult', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd')) */
   /* search583_0_0 -> 973 in the cache */
   /* search583_0_1 -> 167 in the cache */
   /* search583_0_2 -> 1745 in the cache */
   /* search583_0 -> 1746 in the cache */
   /* search583_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1746, 1310 },
      -1,
   } },

   /* replace583_0 -> 973 in the cache */
   /* replace583_1_0 -> 167 in the cache */
   /* replace583_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 167, 170 },
      -1,
   } },
   /* replace583_2_0 -> 169 in the cache */
   /* replace583_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1797, 1798 },
      -1,
   } },

   /* ('ult', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('ult', 'b', 'd'), ('ult', 'c', 'd')) */
   /* search584_0_0 -> 973 in the cache */
   /* search584_0_1 -> 1307 in the cache */
   /* search584_0_2 -> 169 in the cache */
   /* search584_0 -> 1751 in the cache */
   /* search584_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1751, 1310 },
      -1,
   } },

   /* replace584_0 -> 973 in the cache */
   /* replace584_1_0 -> 167 in the cache */
   /* replace584_1_1 -> 170 in the cache */
   /* replace584_1 -> 1797 in the cache */
   /* replace584_2_0 -> 169 in the cache */
   /* replace584_2_1 -> 170 in the cache */
   /* replace584_2 -> 1798 in the cache */
   /* replace584 -> 1799 in the cache */

   /* ('ult', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c')) */
   /* search585_0 -> 1753 in the cache */
   /* search585_1_0 -> 1498 in the cache */
   /* search585_1_1 -> 1754 in the cache */
   /* search585_1_2 -> 1755 in the cache */
   /* search585_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1753, 1756 },
      -1,
   } },

   /* replace585_0 -> 1498 in the cache */
   /* replace585_1_0 -> 1758 in the cache */
   /* replace585_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1758, 1754 },
      -1,
   } },
   /* replace585_2_0 -> 1758 in the cache */
   /* replace585_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1802, 1803 },
      -1,
   } },

   /* ('ult', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('ult', 'd', 'b'), ('ult', 'd', 'c')) */
   /* search586_0 -> 1753 in the cache */
   /* search586_1_0 -> 1498 in the cache */
   /* search586_1_1 -> 1763 in the cache */
   /* search586_1_2 -> 1760 in the cache */
   /* search586_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ult,
      -1, 0,
      { 1753, 1764 },
      -1,
   } },

   /* replace586_0 -> 1498 in the cache */
   /* replace586_1_0 -> 1758 in the cache */
   /* replace586_1_1 -> 1754 in the cache */
   /* replace586_1 -> 1802 in the cache */
   /* replace586_2_0 -> 1758 in the cache */
   /* replace586_2_1 -> 1760 in the cache */
   /* replace586_2 -> 1803 in the cache */
   /* replace586 -> 1804 in the cache */

   /* ('uge', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd')) */
   /* search587_0_0 -> 973 in the cache */
   /* search587_0_1 -> 167 in the cache */
   /* search587_0_2 -> 1745 in the cache */
   /* search587_0 -> 1746 in the cache */
   /* search587_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1746, 1310 },
      -1,
   } },

   /* replace587_0 -> 973 in the cache */
   /* replace587_1_0 -> 167 in the cache */
   /* replace587_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 167, 170 },
      -1,
   } },
   /* replace587_2_0 -> 169 in the cache */
   /* replace587_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1807, 1808 },
      -1,
   } },

   /* ('uge', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('uge', 'b', 'd'), ('uge', 'c', 'd')) */
   /* search588_0_0 -> 973 in the cache */
   /* search588_0_1 -> 1307 in the cache */
   /* search588_0_2 -> 169 in the cache */
   /* search588_0 -> 1751 in the cache */
   /* search588_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1751, 1310 },
      -1,
   } },

   /* replace588_0 -> 973 in the cache */
   /* replace588_1_0 -> 167 in the cache */
   /* replace588_1_1 -> 170 in the cache */
   /* replace588_1 -> 1807 in the cache */
   /* replace588_2_0 -> 169 in the cache */
   /* replace588_2_1 -> 170 in the cache */
   /* replace588_2 -> 1808 in the cache */
   /* replace588 -> 1809 in the cache */

   /* ('uge', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c')) */
   /* search589_0 -> 1753 in the cache */
   /* search589_1_0 -> 1498 in the cache */
   /* search589_1_1 -> 1754 in the cache */
   /* search589_1_2 -> 1755 in the cache */
   /* search589_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1753, 1756 },
      -1,
   } },

   /* replace589_0 -> 1498 in the cache */
   /* replace589_1_0 -> 1758 in the cache */
   /* replace589_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1758, 1754 },
      -1,
   } },
   /* replace589_2_0 -> 1758 in the cache */
   /* replace589_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1812, 1813 },
      -1,
   } },

   /* ('uge', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('uge', 'd', 'b'), ('uge', 'd', 'c')) */
   /* search590_0 -> 1753 in the cache */
   /* search590_1_0 -> 1498 in the cache */
   /* search590_1_1 -> 1763 in the cache */
   /* search590_1_2 -> 1760 in the cache */
   /* search590_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_uge,
      -1, 0,
      { 1753, 1764 },
      -1,
   } },

   /* replace590_0 -> 1498 in the cache */
   /* replace590_1_0 -> 1758 in the cache */
   /* replace590_1_1 -> 1754 in the cache */
   /* replace590_1 -> 1812 in the cache */
   /* replace590_2_0 -> 1758 in the cache */
   /* replace590_2_1 -> 1760 in the cache */
   /* replace590_2 -> 1813 in the cache */
   /* replace590 -> 1814 in the cache */

   /* ('bitz', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('bitz', 'b', 'd'), ('bitz', 'c', 'd')) */
   /* search591_0_0 -> 973 in the cache */
   /* search591_0_1 -> 144 in the cache */
   /* search591_0_2 -> 1031 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 144, 1031 },
      0,
   } },
   /* search591_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1816, 346 },
      -1,
   } },

   /* replace591_0 -> 973 in the cache */
   /* replace591_1_0 -> 144 in the cache */
   /* replace591_1_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 144, 180 },
      -1,
   } },
   /* replace591_2_0 -> 146 in the cache */
   /* replace591_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 146, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1818, 1819 },
      -1,
   } },

   /* ('bitz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('bitz', 'b', 'd'), ('bitz', 'c', 'd')) */
   /* search592_0_0 -> 973 in the cache */
   /* search592_0_1 -> 318 in the cache */
   /* search592_0_2 -> 146 in the cache */
   { .expression = {
      { nir_search_value_expression, -3 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 318, 146 },
      0,
   } },
   /* search592_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1821, 346 },
      -1,
   } },

   /* replace592_0 -> 973 in the cache */
   /* replace592_1_0 -> 144 in the cache */
   /* replace592_1_1 -> 180 in the cache */
   /* replace592_1 -> 1818 in the cache */
   /* replace592_2_0 -> 146 in the cache */
   /* replace592_2_1 -> 180 in the cache */
   /* replace592_2 -> 1819 in the cache */
   /* replace592 -> 1820 in the cache */

   /* ('bitz', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('bitz', 'd', 'b'), ('bitz', 'd', 'c')) */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* d */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search593_1_0 -> 1498 in the cache */
   /* search593_1_1 -> 759 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* c */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 759, 1824 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1823, 1825 },
      -1,
   } },

   /* replace593_0 -> 1498 in the cache */
   { .variable = {
      { nir_search_value_variable, -1 },
      0, /* d */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* replace593_1_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1827, 759 },
      -1,
   } },
   /* replace593_2_0 -> 1827 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      3, /* c */
      false,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1828, 1830 },
      -1,
   } },

   /* ('bitz', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('bitz', 'd', 'b'), ('bitz', 'd', 'c')) */
   /* search594_0 -> 1823 in the cache */
   /* search594_1_0 -> 1498 in the cache */
   { .variable = {
      { nir_search_value_variable, 32 },
      2, /* b */
      true,
      nir_type_invalid,
      -1,
      {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15},
   } },
   /* search594_1_2 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1832, 1829 },
      0,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitz,
      -1, 0,
      { 1823, 1833 },
      -1,
   } },

   /* replace594_0 -> 1498 in the cache */
   /* replace594_1_0 -> 1827 in the cache */
   /* replace594_1_1 -> 759 in the cache */
   /* replace594_1 -> 1828 in the cache */
   /* replace594_2_0 -> 1827 in the cache */
   /* replace594_2_1 -> 1829 in the cache */
   /* replace594_2 -> 1830 in the cache */
   /* replace594 -> 1831 in the cache */

   /* ('bitnz', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('bitnz', 'b', 'd'), ('bitnz', 'c', 'd')) */
   /* search595_0_0 -> 973 in the cache */
   /* search595_0_1 -> 144 in the cache */
   /* search595_0_2 -> 1031 in the cache */
   /* search595_0 -> 1816 in the cache */
   /* search595_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1816, 346 },
      -1,
   } },

   /* replace595_0 -> 973 in the cache */
   /* replace595_1_0 -> 144 in the cache */
   /* replace595_1_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 144, 180 },
      -1,
   } },
   /* replace595_2_0 -> 146 in the cache */
   /* replace595_2_1 -> 180 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 146, 180 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1836, 1837 },
      -1,
   } },

   /* ('bitnz', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('bitnz', 'b', 'd'), ('bitnz', 'c', 'd')) */
   /* search596_0_0 -> 973 in the cache */
   /* search596_0_1 -> 318 in the cache */
   /* search596_0_2 -> 146 in the cache */
   /* search596_0 -> 1821 in the cache */
   /* search596_1 -> 346 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1821, 346 },
      -1,
   } },

   /* replace596_0 -> 973 in the cache */
   /* replace596_1_0 -> 144 in the cache */
   /* replace596_1_1 -> 180 in the cache */
   /* replace596_1 -> 1836 in the cache */
   /* replace596_2_0 -> 146 in the cache */
   /* replace596_2_1 -> 180 in the cache */
   /* replace596_2 -> 1837 in the cache */
   /* replace596 -> 1838 in the cache */

   /* ('bitnz', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('bitnz', 'd', 'b'), ('bitnz', 'd', 'c')) */
   /* search597_0 -> 1823 in the cache */
   /* search597_1_0 -> 1498 in the cache */
   /* search597_1_1 -> 759 in the cache */
   /* search597_1_2 -> 1824 in the cache */
   /* search597_1 -> 1825 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1823, 1825 },
      -1,
   } },

   /* replace597_0 -> 1498 in the cache */
   /* replace597_1_0 -> 1827 in the cache */
   /* replace597_1_1 -> 759 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1827, 759 },
      -1,
   } },
   /* replace597_2_0 -> 1827 in the cache */
   /* replace597_2_1 -> 1829 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1827, 1829 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1841, 1842 },
      -1,
   } },

   /* ('bitnz', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('bitnz', 'd', 'b'), ('bitnz', 'd', 'c')) */
   /* search598_0 -> 1823 in the cache */
   /* search598_1_0 -> 1498 in the cache */
   /* search598_1_1 -> 1832 in the cache */
   /* search598_1_2 -> 1829 in the cache */
   /* search598_1 -> 1833 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bitnz,
      -1, 0,
      { 1823, 1833 },
      -1,
   } },

   /* replace598_0 -> 1498 in the cache */
   /* replace598_1_0 -> 1827 in the cache */
   /* replace598_1_1 -> 759 in the cache */
   /* replace598_1 -> 1841 in the cache */
   /* replace598_2_0 -> 1827 in the cache */
   /* replace598_2_1 -> 1829 in the cache */
   /* replace598_2 -> 1842 in the cache */
   /* replace598 -> 1843 in the cache */

   /* ('fneu', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd')) */
   /* search599_0_0 -> 973 in the cache */
   /* search599_0_1 -> 167 in the cache */
   /* search599_0_2 -> 1745 in the cache */
   /* search599_0 -> 1746 in the cache */
   /* search599_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1746, 1310 },
      -1,
   } },

   /* replace599_0 -> 973 in the cache */
   /* replace599_1_0 -> 167 in the cache */
   /* replace599_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 167, 170 },
      -1,
   } },
   /* replace599_2_0 -> 169 in the cache */
   /* replace599_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      1, 1,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 973, 1846, 1847 },
      -1,
   } },

   /* ('fneu', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fneu', 'b', 'd'), ('fneu', 'c', 'd')) */
   /* search600_0_0 -> 973 in the cache */
   /* search600_0_1 -> 1307 in the cache */
   /* search600_0_2 -> 169 in the cache */
   /* search600_0 -> 1751 in the cache */
   /* search600_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1751, 1310 },
      -1,
   } },

   /* replace600_0 -> 973 in the cache */
   /* replace600_1_0 -> 167 in the cache */
   /* replace600_1_1 -> 170 in the cache */
   /* replace600_1 -> 1846 in the cache */
   /* replace600_2_0 -> 169 in the cache */
   /* replace600_2_1 -> 170 in the cache */
   /* replace600_2 -> 1847 in the cache */
   /* replace600 -> 1848 in the cache */

   /* ('fneu', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fneu', 'd', 'b'), ('fneu', 'd', 'c')) */
   /* search601_0 -> 1753 in the cache */
   /* search601_1_0 -> 1498 in the cache */
   /* search601_1_1 -> 1754 in the cache */
   /* search601_1_2 -> 1755 in the cache */
   /* search601_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1753, 1756 },
      -1,
   } },

   /* replace601_0 -> 1498 in the cache */
   /* replace601_1_0 -> 1758 in the cache */
   /* replace601_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1758, 1754 },
      -1,
   } },
   /* replace601_2_0 -> 1758 in the cache */
   /* replace601_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      1, 1,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1498, 1851, 1852 },
      -1,
   } },

   /* ('fneu', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fneu', 'd', 'b'), ('fneu', 'd', 'c')) */
   /* search602_0 -> 1753 in the cache */
   /* search602_1_0 -> 1498 in the cache */
   /* search602_1_1 -> 1763 in the cache */
   /* search602_1_2 -> 1760 in the cache */
   /* search602_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1753, 1764 },
      -1,
   } },

   /* replace602_0 -> 1498 in the cache */
   /* replace602_1_0 -> 1758 in the cache */
   /* replace602_1_1 -> 1754 in the cache */
   /* replace602_1 -> 1851 in the cache */
   /* replace602_2_0 -> 1758 in the cache */
   /* replace602_2_1 -> 1760 in the cache */
   /* replace602_2 -> 1852 in the cache */
   /* replace602 -> 1853 in the cache */

   /* ('feq', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd')) */
   /* search603_0_0 -> 973 in the cache */
   /* search603_0_1 -> 167 in the cache */
   /* search603_0_2 -> 1745 in the cache */
   /* search603_0 -> 1746 in the cache */
   /* search603_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1746, 1310 },
      -1,
   } },

   /* replace603_0 -> 973 in the cache */
   /* replace603_1_0 -> 167 in the cache */
   /* replace603_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 167, 170 },
      -1,
   } },
   /* replace603_2_0 -> 169 in the cache */
   /* replace603_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      1, 1,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 973, 1856, 1857 },
      -1,
   } },

   /* ('feq', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('feq', 'b', 'd'), ('feq', 'c', 'd')) */
   /* search604_0_0 -> 973 in the cache */
   /* search604_0_1 -> 1307 in the cache */
   /* search604_0_2 -> 169 in the cache */
   /* search604_0 -> 1751 in the cache */
   /* search604_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1751, 1310 },
      -1,
   } },

   /* replace604_0 -> 973 in the cache */
   /* replace604_1_0 -> 167 in the cache */
   /* replace604_1_1 -> 170 in the cache */
   /* replace604_1 -> 1856 in the cache */
   /* replace604_2_0 -> 169 in the cache */
   /* replace604_2_1 -> 170 in the cache */
   /* replace604_2 -> 1857 in the cache */
   /* replace604 -> 1858 in the cache */

   /* ('feq', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c')) */
   /* search605_0 -> 1753 in the cache */
   /* search605_1_0 -> 1498 in the cache */
   /* search605_1_1 -> 1754 in the cache */
   /* search605_1_2 -> 1755 in the cache */
   /* search605_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1753, 1756 },
      -1,
   } },

   /* replace605_0 -> 1498 in the cache */
   /* replace605_1_0 -> 1758 in the cache */
   /* replace605_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1758, 1754 },
      -1,
   } },
   /* replace605_2_0 -> 1758 in the cache */
   /* replace605_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      1, 1,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1498, 1861, 1862 },
      -1,
   } },

   /* ('feq', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('feq', 'd', 'b'), ('feq', 'd', 'c')) */
   /* search606_0 -> 1753 in the cache */
   /* search606_1_0 -> 1498 in the cache */
   /* search606_1_1 -> 1763 in the cache */
   /* search606_1_2 -> 1760 in the cache */
   /* search606_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1753, 1764 },
      -1,
   } },

   /* replace606_0 -> 1498 in the cache */
   /* replace606_1_0 -> 1758 in the cache */
   /* replace606_1_1 -> 1754 in the cache */
   /* replace606_1 -> 1861 in the cache */
   /* replace606_2_0 -> 1758 in the cache */
   /* replace606_2_1 -> 1760 in the cache */
   /* replace606_2 -> 1862 in the cache */
   /* replace606 -> 1863 in the cache */

   /* ('flt', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd')) */
   /* search607_0_0 -> 973 in the cache */
   /* search607_0_1 -> 167 in the cache */
   /* search607_0_2 -> 1745 in the cache */
   /* search607_0 -> 1746 in the cache */
   /* search607_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1746, 1310 },
      -1,
   } },

   /* replace607_0 -> 973 in the cache */
   /* replace607_1_0 -> 167 in the cache */
   /* replace607_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 167, 170 },
      -1,
   } },
   /* replace607_2_0 -> 169 in the cache */
   /* replace607_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1866, 1867 },
      -1,
   } },

   /* ('flt', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('flt', 'b', 'd'), ('flt', 'c', 'd')) */
   /* search608_0_0 -> 973 in the cache */
   /* search608_0_1 -> 1307 in the cache */
   /* search608_0_2 -> 169 in the cache */
   /* search608_0 -> 1751 in the cache */
   /* search608_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1751, 1310 },
      -1,
   } },

   /* replace608_0 -> 973 in the cache */
   /* replace608_1_0 -> 167 in the cache */
   /* replace608_1_1 -> 170 in the cache */
   /* replace608_1 -> 1866 in the cache */
   /* replace608_2_0 -> 169 in the cache */
   /* replace608_2_1 -> 170 in the cache */
   /* replace608_2 -> 1867 in the cache */
   /* replace608 -> 1868 in the cache */

   /* ('flt', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c')) */
   /* search609_0 -> 1753 in the cache */
   /* search609_1_0 -> 1498 in the cache */
   /* search609_1_1 -> 1754 in the cache */
   /* search609_1_2 -> 1755 in the cache */
   /* search609_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1753, 1756 },
      -1,
   } },

   /* replace609_0 -> 1498 in the cache */
   /* replace609_1_0 -> 1758 in the cache */
   /* replace609_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1758, 1754 },
      -1,
   } },
   /* replace609_2_0 -> 1758 in the cache */
   /* replace609_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1871, 1872 },
      -1,
   } },

   /* ('flt', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('flt', 'd', 'b'), ('flt', 'd', 'c')) */
   /* search610_0 -> 1753 in the cache */
   /* search610_1_0 -> 1498 in the cache */
   /* search610_1_1 -> 1763 in the cache */
   /* search610_1_2 -> 1760 in the cache */
   /* search610_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_flt,
      -1, 0,
      { 1753, 1764 },
      -1,
   } },

   /* replace610_0 -> 1498 in the cache */
   /* replace610_1_0 -> 1758 in the cache */
   /* replace610_1_1 -> 1754 in the cache */
   /* replace610_1 -> 1871 in the cache */
   /* replace610_2_0 -> 1758 in the cache */
   /* replace610_2_1 -> 1760 in the cache */
   /* replace610_2 -> 1872 in the cache */
   /* replace610 -> 1873 in the cache */

   /* ('fge', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd')) */
   /* search611_0_0 -> 973 in the cache */
   /* search611_0_1 -> 167 in the cache */
   /* search611_0_2 -> 1745 in the cache */
   /* search611_0 -> 1746 in the cache */
   /* search611_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1746, 1310 },
      -1,
   } },

   /* replace611_0 -> 973 in the cache */
   /* replace611_1_0 -> 167 in the cache */
   /* replace611_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 167, 170 },
      -1,
   } },
   /* replace611_2_0 -> 169 in the cache */
   /* replace611_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 973, 1876, 1877 },
      -1,
   } },

   /* ('fge', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fge', 'b', 'd'), ('fge', 'c', 'd')) */
   /* search612_0_0 -> 973 in the cache */
   /* search612_0_1 -> 1307 in the cache */
   /* search612_0_2 -> 169 in the cache */
   /* search612_0 -> 1751 in the cache */
   /* search612_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1751, 1310 },
      -1,
   } },

   /* replace612_0 -> 973 in the cache */
   /* replace612_1_0 -> 167 in the cache */
   /* replace612_1_1 -> 170 in the cache */
   /* replace612_1 -> 1876 in the cache */
   /* replace612_2_0 -> 169 in the cache */
   /* replace612_2_1 -> 170 in the cache */
   /* replace612_2 -> 1877 in the cache */
   /* replace612 -> 1878 in the cache */

   /* ('fge', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c')) */
   /* search613_0 -> 1753 in the cache */
   /* search613_1_0 -> 1498 in the cache */
   /* search613_1_1 -> 1754 in the cache */
   /* search613_1_2 -> 1755 in the cache */
   /* search613_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1753, 1756 },
      -1,
   } },

   /* replace613_0 -> 1498 in the cache */
   /* replace613_1_0 -> 1758 in the cache */
   /* replace613_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1758, 1754 },
      -1,
   } },
   /* replace613_2_0 -> 1758 in the cache */
   /* replace613_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 0,
      { 1498, 1881, 1882 },
      -1,
   } },

   /* ('fge', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fge', 'd', 'b'), ('fge', 'd', 'c')) */
   /* search614_0 -> 1753 in the cache */
   /* search614_1_0 -> 1498 in the cache */
   /* search614_1_1 -> 1763 in the cache */
   /* search614_1_2 -> 1760 in the cache */
   /* search614_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fge,
      -1, 0,
      { 1753, 1764 },
      -1,
   } },

   /* replace614_0 -> 1498 in the cache */
   /* replace614_1_0 -> 1758 in the cache */
   /* replace614_1_1 -> 1754 in the cache */
   /* replace614_1 -> 1881 in the cache */
   /* replace614_2_0 -> 1758 in the cache */
   /* replace614_2_1 -> 1760 in the cache */
   /* replace614_2 -> 1882 in the cache */
   /* replace614 -> 1883 in the cache */

   /* ('fneo', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fneo', 'b', 'd'), ('fneo', 'c', 'd')) */
   /* search615_0_0 -> 973 in the cache */
   /* search615_0_1 -> 167 in the cache */
   /* search615_0_2 -> 1745 in the cache */
   /* search615_0 -> 1746 in the cache */
   /* search615_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      0, 1,
      { 1746, 1310 },
      -1,
   } },

   /* replace615_0 -> 973 in the cache */
   /* replace615_1_0 -> 167 in the cache */
   /* replace615_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      0, 1,
      { 167, 170 },
      -1,
   } },
   /* replace615_2_0 -> 169 in the cache */
   /* replace615_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      1, 1,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 973, 1886, 1887 },
      -1,
   } },

   /* ('fneo', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fneo', 'b', 'd'), ('fneo', 'c', 'd')) */
   /* search616_0_0 -> 973 in the cache */
   /* search616_0_1 -> 1307 in the cache */
   /* search616_0_2 -> 169 in the cache */
   /* search616_0 -> 1751 in the cache */
   /* search616_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      0, 1,
      { 1751, 1310 },
      -1,
   } },

   /* replace616_0 -> 973 in the cache */
   /* replace616_1_0 -> 167 in the cache */
   /* replace616_1_1 -> 170 in the cache */
   /* replace616_1 -> 1886 in the cache */
   /* replace616_2_0 -> 169 in the cache */
   /* replace616_2_1 -> 170 in the cache */
   /* replace616_2 -> 1887 in the cache */
   /* replace616 -> 1888 in the cache */

   /* ('fneo', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fneo', 'd', 'b'), ('fneo', 'd', 'c')) */
   /* search617_0 -> 1753 in the cache */
   /* search617_1_0 -> 1498 in the cache */
   /* search617_1_1 -> 1754 in the cache */
   /* search617_1_2 -> 1755 in the cache */
   /* search617_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      0, 1,
      { 1753, 1756 },
      -1,
   } },

   /* replace617_0 -> 1498 in the cache */
   /* replace617_1_0 -> 1758 in the cache */
   /* replace617_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      0, 1,
      { 1758, 1754 },
      -1,
   } },
   /* replace617_2_0 -> 1758 in the cache */
   /* replace617_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      1, 1,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1498, 1891, 1892 },
      -1,
   } },

   /* ('fneo', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fneo', 'd', 'b'), ('fneo', 'd', 'c')) */
   /* search618_0 -> 1753 in the cache */
   /* search618_1_0 -> 1498 in the cache */
   /* search618_1_1 -> 1763 in the cache */
   /* search618_1_2 -> 1760 in the cache */
   /* search618_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneo,
      0, 1,
      { 1753, 1764 },
      -1,
   } },

   /* replace618_0 -> 1498 in the cache */
   /* replace618_1_0 -> 1758 in the cache */
   /* replace618_1_1 -> 1754 in the cache */
   /* replace618_1 -> 1891 in the cache */
   /* replace618_2_0 -> 1758 in the cache */
   /* replace618_2_1 -> 1760 in the cache */
   /* replace618_2 -> 1892 in the cache */
   /* replace618 -> 1893 in the cache */

   /* ('fequ', ('bcsel(is_used_once)', 'a', 'b', '#c'), '#d') => ('bcsel', 'a', ('fequ', 'b', 'd'), ('fequ', 'c', 'd')) */
   /* search619_0_0 -> 973 in the cache */
   /* search619_0_1 -> 167 in the cache */
   /* search619_0_2 -> 1745 in the cache */
   /* search619_0 -> 1746 in the cache */
   /* search619_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      0, 1,
      { 1746, 1310 },
      -1,
   } },

   /* replace619_0 -> 973 in the cache */
   /* replace619_1_0 -> 167 in the cache */
   /* replace619_1_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      0, 1,
      { 167, 170 },
      -1,
   } },
   /* replace619_2_0 -> 169 in the cache */
   /* replace619_2_1 -> 170 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      1, 1,
      { 169, 170 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 973, 1896, 1897 },
      -1,
   } },

   /* ('fequ', ('bcsel(is_used_once)', 'a', '#b', 'c'), '#d') => ('bcsel', 'a', ('fequ', 'b', 'd'), ('fequ', 'c', 'd')) */
   /* search620_0_0 -> 973 in the cache */
   /* search620_0_1 -> 1307 in the cache */
   /* search620_0_2 -> 169 in the cache */
   /* search620_0 -> 1751 in the cache */
   /* search620_1 -> 1310 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      0, 1,
      { 1751, 1310 },
      -1,
   } },

   /* replace620_0 -> 973 in the cache */
   /* replace620_1_0 -> 167 in the cache */
   /* replace620_1_1 -> 170 in the cache */
   /* replace620_1 -> 1896 in the cache */
   /* replace620_2_0 -> 169 in the cache */
   /* replace620_2_1 -> 170 in the cache */
   /* replace620_2 -> 1897 in the cache */
   /* replace620 -> 1898 in the cache */

   /* ('fequ', '#d', ('bcsel(is_used_once)', 'a', 'b', '#c')) => ('bcsel', 'a', ('fequ', 'd', 'b'), ('fequ', 'd', 'c')) */
   /* search621_0 -> 1753 in the cache */
   /* search621_1_0 -> 1498 in the cache */
   /* search621_1_1 -> 1754 in the cache */
   /* search621_1_2 -> 1755 in the cache */
   /* search621_1 -> 1756 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      0, 1,
      { 1753, 1756 },
      -1,
   } },

   /* replace621_0 -> 1498 in the cache */
   /* replace621_1_0 -> 1758 in the cache */
   /* replace621_1_1 -> 1754 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      0, 1,
      { 1758, 1754 },
      -1,
   } },
   /* replace621_2_0 -> 1758 in the cache */
   /* replace621_2_1 -> 1760 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      1, 1,
      { 1758, 1760 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_bcsel,
      -1, 2,
      { 1498, 1901, 1902 },
      -1,
   } },

   /* ('fequ', '#d', ('bcsel(is_used_once)', 'a', '#b', 'c')) => ('bcsel', 'a', ('fequ', 'd', 'b'), ('fequ', 'd', 'c')) */
   /* search622_0 -> 1753 in the cache */
   /* search622_1_0 -> 1498 in the cache */
   /* search622_1_1 -> 1763 in the cache */
   /* search622_1_2 -> 1760 in the cache */
   /* search622_1 -> 1764 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fequ,
      0, 1,
      { 1753, 1764 },
      -1,
   } },

   /* replace622_0 -> 1498 in the cache */
   /* replace622_1_0 -> 1758 in the cache */
   /* replace622_1_1 -> 1754 in the cache */
   /* replace622_1 -> 1901 in the cache */
   /* replace622_2_0 -> 1758 in the cache */
   /* replace622_2_1 -> 1760 in the cache */
   /* replace622_2 -> 1902 in the cache */
   /* replace622 -> 1903 in the cache */

   /* ('ieq', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ieq', 'a', 'b') */
   /* search623_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i8,
      -1, 0,
      { 973 },
      -1,
   } },
   /* search623_1_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i8,
      -1, 0,
      { 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1905, 1906 },
      -1,
   } },

   /* replace623_0 -> 973 in the cache */
   /* replace623_1 -> 1468 in the cache */
   /* replace623 -> 1484 in the cache */

   /* ('ine', ('b2i8', 'a@1'), ('b2i8', 'b@1')) => ('ine', 'a', 'b') */
   /* search624_0_0 -> 973 in the cache */
   /* search624_0 -> 1905 in the cache */
   /* search624_1_0 -> 1468 in the cache */
   /* search624_1 -> 1906 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1905, 1906 },
      -1,
   } },

   /* replace624_0 -> 973 in the cache */
   /* replace624_1 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 973, 1468 },
      -1,
   } },

   /* ('ieq', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search625_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i16,
      -1, 0,
      { 973 },
      -1,
   } },
   /* search625_1_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i16,
      -1, 0,
      { 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1910, 1911 },
      -1,
   } },

   /* replace625_0 -> 973 in the cache */
   /* replace625_1 -> 1468 in the cache */
   /* replace625 -> 1484 in the cache */

   /* ('ine', ('b2i16', 'a@1'), ('b2i16', 'b@1')) => ('ine', 'a', 'b') */
   /* search626_0_0 -> 973 in the cache */
   /* search626_0 -> 1910 in the cache */
   /* search626_1_0 -> 1468 in the cache */
   /* search626_1 -> 1911 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1910, 1911 },
      -1,
   } },

   /* replace626_0 -> 973 in the cache */
   /* replace626_1 -> 1468 in the cache */
   /* replace626 -> 1909 in the cache */

   /* ('ieq', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search627_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i32,
      -1, 0,
      { 973 },
      -1,
   } },
   /* search627_1_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i32,
      -1, 0,
      { 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1914, 1915 },
      -1,
   } },

   /* replace627_0 -> 973 in the cache */
   /* replace627_1 -> 1468 in the cache */
   /* replace627 -> 1484 in the cache */

   /* ('ine', ('b2i32', 'a@1'), ('b2i32', 'b@1')) => ('ine', 'a', 'b') */
   /* search628_0_0 -> 973 in the cache */
   /* search628_0 -> 1914 in the cache */
   /* search628_1_0 -> 1468 in the cache */
   /* search628_1 -> 1915 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1914, 1915 },
      -1,
   } },

   /* replace628_0 -> 973 in the cache */
   /* replace628_1 -> 1468 in the cache */
   /* replace628 -> 1909 in the cache */

   /* ('ieq', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search629_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i64,
      -1, 0,
      { 973 },
      -1,
   } },
   /* search629_1_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2i64,
      -1, 0,
      { 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ieq,
      0, 1,
      { 1918, 1919 },
      -1,
   } },

   /* replace629_0 -> 973 in the cache */
   /* replace629_1 -> 1468 in the cache */
   /* replace629 -> 1484 in the cache */

   /* ('ine', ('b2i64', 'a@1'), ('b2i64', 'b@1')) => ('ine', 'a', 'b') */
   /* search630_0_0 -> 973 in the cache */
   /* search630_0 -> 1918 in the cache */
   /* search630_1_0 -> 1468 in the cache */
   /* search630_1 -> 1919 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_ine,
      0, 1,
      { 1918, 1919 },
      -1,
   } },

   /* replace630_0 -> 973 in the cache */
   /* replace630_1 -> 1468 in the cache */
   /* replace630 -> 1909 in the cache */

   /* ('feq', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ieq', 'a', 'b') */
   /* search631_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f16,
      -1, 0,
      { 973 },
      -1,
   } },
   /* search631_1_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 16 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f16,
      -1, 0,
      { 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1922, 1923 },
      -1,
   } },

   /* replace631_0 -> 973 in the cache */
   /* replace631_1 -> 1468 in the cache */
   /* replace631 -> 1484 in the cache */

   /* ('fneu', ('b2f16', 'a@1'), ('b2f16', 'b@1')) => ('ine', 'a', 'b') */
   /* search632_0_0 -> 973 in the cache */
   /* search632_0 -> 1922 in the cache */
   /* search632_1_0 -> 1468 in the cache */
   /* search632_1 -> 1923 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1922, 1923 },
      -1,
   } },

   /* replace632_0 -> 973 in the cache */
   /* replace632_1 -> 1468 in the cache */
   /* replace632 -> 1909 in the cache */

   /* ('feq', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ieq', 'a', 'b') */
   /* search633_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f32,
      -1, 0,
      { 973 },
      -1,
   } },
   /* search633_1_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 32 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f32,
      -1, 0,
      { 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1926, 1927 },
      -1,
   } },

   /* replace633_0 -> 973 in the cache */
   /* replace633_1 -> 1468 in the cache */
   /* replace633 -> 1484 in the cache */

   /* ('fneu', ('b2f32', 'a@1'), ('b2f32', 'b@1')) => ('ine', 'a', 'b') */
   /* search634_0_0 -> 973 in the cache */
   /* search634_0 -> 1926 in the cache */
   /* search634_1_0 -> 1468 in the cache */
   /* search634_1 -> 1927 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1926, 1927 },
      -1,
   } },

   /* replace634_0 -> 973 in the cache */
   /* replace634_1 -> 1468 in the cache */
   /* replace634 -> 1909 in the cache */

   /* ('feq', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ieq', 'a', 'b') */
   /* search635_0_0 -> 973 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f64,
      -1, 0,
      { 973 },
      -1,
   } },
   /* search635_1_0 -> 1468 in the cache */
   { .expression = {
      { nir_search_value_expression, 64 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_b2f64,
      -1, 0,
      { 1468 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_feq,
      0, 1,
      { 1930, 1931 },
      -1,
   } },

   /* replace635_0 -> 973 in the cache */
   /* replace635_1 -> 1468 in the cache */
   /* replace635 -> 1484 in the cache */

   /* ('fneu', ('b2f64', 'a@1'), ('b2f64', 'b@1')) => ('ine', 'a', 'b') */
   /* search636_0_0 -> 973 in the cache */
   /* search636_0 -> 1930 in the cache */
   /* search636_1_0 -> 1468 in the cache */
   /* search636_1 -> 1931 in the cache */
   { .expression = {
      { nir_search_value_expression, 1 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_fneu,
      0, 1,
      { 1930, 1931 },
      -1,
   } },

   /* replace636_0 -> 973 in the cache */
   /* replace636_1 -> 1468 in the cache */
   /* replace636 -> 1909 in the cache */

   /* ('iand@8', 'a', ('inot', ('ishr', 'a', 7))) => ('imax', 'a', 0) */
   /* search637_0 -> 19 in the cache */
   /* search637_1_0_0 -> 19 in the cache */
   /* search637_1_0_1 -> 22 in the cache */
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      true,
      -1,
      nir_op_ishr,
      -1, 0,
      { 19, 22 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      false,
      -1,
      nir_op_inot,
      -1, 0,
      { 1934 },
      -1,
   } },
   { .expression = {
      { nir_search_value_expression, 8 },
      false,
      false,
      false,
      false,
      false,
      false,
      false,
 