/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: RISCV.td                                                             *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  FeatureBitset ComputeAvailableFeatures(const FeatureBitset &FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands,
                       const SmallBitVector &OptionalOperandsMask,
                       ArrayRef<unsigned> DefaultsOffset);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                FeatureBitset &MissingFeatures,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0);
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo,
                                bool matchingInlineAsm,
                                unsigned VariantID = 0) {
    FeatureBitset MissingFeatures;
    return MatchInstructionImpl(Operands, Inst, ErrorInfo, MissingFeatures,
                                matchingInlineAsm, VariantID);
  }

  ParseStatus MatchOperandParserImpl(
    OperandVector &Operands,
    StringRef Mnemonic,
    bool ParseForAllFeatures = false);
  ParseStatus tryCustomParseOperand(
    OperandVector &Operands,
    unsigned MCK);

#endif // GET_ASSEMBLER_HEADER


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

  Match_InvalidBareSymbol,
  Match_InvalidCLUIImm,
  Match_InvalidCSRSystemRegister,
  Match_InvalidCallSymbol,
  Match_InvalidImmXLenLI,
  Match_InvalidImmXLenLI_Restricted,
  Match_InvalidImmZero,
  Match_InvalidLoadFPImm,
  Match_InvalidPseudoJumpSymbol,
  Match_InvalidRTZArg,
  Match_InvalidRegReg,
  Match_InvalidRlist,
  Match_InvalidRnumArg,
  Match_InvalidSImm10Lsb0000NonZero,
  Match_InvalidSImm12,
  Match_InvalidSImm12Lsb0,
  Match_InvalidSImm12Lsb00000,
  Match_InvalidSImm13Lsb0,
  Match_InvalidSImm21Lsb0JAL,
  Match_InvalidSImm26,
  Match_InvalidSImm5,
  Match_InvalidSImm5Plus1,
  Match_InvalidSImm6,
  Match_InvalidSImm6NonZero,
  Match_InvalidSImm9Lsb0,
  Match_InvalidStackAdj,
  Match_InvalidTLSDESCCallSymbol,
  Match_InvalidTPRelAddSymbol,
  Match_InvalidUImm1,
  Match_InvalidUImm10,
  Match_InvalidUImm10Lsb00NonZero,
  Match_InvalidUImm11,
  Match_InvalidUImm16,
  Match_InvalidUImm2,
  Match_InvalidUImm20,
  Match_InvalidUImm20AUIPC,
  Match_InvalidUImm20LUI,
  Match_InvalidUImm2Lsb0,
  Match_InvalidUImm3,
  Match_InvalidUImm32,
  Match_InvalidUImm4,
  Match_InvalidUImm48,
  Match_InvalidUImm5,
  Match_InvalidUImm5GT3,
  Match_InvalidUImm5Lsb0,
  Match_InvalidUImm5NonZero,
  Match_InvalidUImm6,
  Match_InvalidUImm64,
  Match_InvalidUImm6Lsb0,
  Match_InvalidUImm7,
  Match_InvalidUImm7Lsb00,
  Match_InvalidUImm7Lsb000,
  Match_InvalidUImm8,
  Match_InvalidUImm8GE32,
  Match_InvalidUImm8Lsb00,
  Match_InvalidUImm8Lsb000,
  Match_InvalidUImm9Lsb000,
  Match_InvalidUImmLog2XLen,
  Match_InvalidUImmLog2XLenNonZero,
  Match_InvalidVMaskCarryInRegister,
  Match_InvalidVMaskRegister,
  Match_InvalidVTypeI,
  END_OPERAND_DIAGNOSTIC_TYPES
#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtZicbomBit = 43,
  Feature_HasStdExtZicbopBit = 44,
  Feature_HasStdExtZicbozBit = 45,
  Feature_HasStdExtZicsrBit = 49,
  Feature_HasStdExtZicondBit = 48,
  Feature_HasStdExtZifenceiBit = 50,
  Feature_HasStdExtZihintpauseBit = 52,
  Feature_HasStdExtZihintntlBit = 51,
  Feature_HasStdExtZimopBit = 53,
  Feature_HasStdExtZicfilpBit = 46,
  Feature_NoStdExtZicfilpBit = 125,
  Feature_HasStdExtZicfissBit = 47,
  Feature_HasStdExtZmmulBit = 61,
  Feature_HasStdExtMBit = 11,
  Feature_HasStdExtZaamoBit = 15,
  Feature_HasStdExtZalrscBit = 19,
  Feature_HasStdExtABit = 2,
  Feature_HasStdExtZtsoBit = 62,
  Feature_HasStdExtZabhaBit = 16,
  Feature_HasStdExtZacasBit = 17,
  Feature_HasStdExtZalasrBit = 18,
  Feature_HasStdExtZawrsBit = 20,
  Feature_HasStdExtFBit = 8,
  Feature_HasStdExtDBit = 7,
  Feature_HasStdExtZfhminBit = 39,
  Feature_HasStdExtZfhBit = 37,
  Feature_HasStdExtZfbfminBit = 36,
  Feature_HasHalfFPLoadStoreMoveBit = 0,
  Feature_HasStdExtZfaBit = 35,
  Feature_HasStdExtZfinxBit = 40,
  Feature_HasStdExtFOrZfinxBit = 9,
  Feature_HasStdExtZdinxBit = 34,
  Feature_HasStdExtZhinxminBit = 42,
  Feature_HasStdExtZhinxBit = 41,
  Feature_HasStdExtCBit = 3,
  Feature_HasRVCHintsBit = 1,
  Feature_HasStdExtCOrZcaBit = 4,
  Feature_HasStdExtZcbBit = 30,
  Feature_HasStdExtCOrZcdBit = 5,
  Feature_HasStdExtZcmpBit = 32,
  Feature_HasStdExtZcmtBit = 33,
  Feature_HasStdExtCOrZcfOrZceBit = 6,
  Feature_HasStdExtZcmopBit = 31,
  Feature_HasStdExtZbaBit = 21,
  Feature_HasStdExtZbbBit = 22,
  Feature_NoStdExtZbbBit = 123,
  Feature_HasStdExtZbcBit = 24,
  Feature_HasStdExtZbsBit = 29,
  Feature_HasStdExtZbkbBit = 26,
  Feature_NoStdExtZbkbBit = 124,
  Feature_HasStdExtZbkxBit = 28,
  Feature_HasStdExtZbbOrZbkbBit = 23,
  Feature_HasStdExtZbkcBit = 27,
  Feature_HasStdExtZbcOrZbkcBit = 25,
  Feature_HasStdExtZkndBit = 54,
  Feature_HasStdExtZkneBit = 56,
  Feature_HasStdExtZkndOrZkneBit = 55,
  Feature_HasStdExtZknhBit = 57,
  Feature_HasStdExtZksedBit = 59,
  Feature_HasStdExtZkshBit = 60,
  Feature_HasStdExtZkrBit = 58,
  Feature_HasStdExtZvfbfminBit = 66,
  Feature_HasStdExtZvfbfwmaBit = 67,
  Feature_HasStdExtZfhOrZvfhBit = 38,
  Feature_HasStdExtZvkbBit = 68,
  Feature_HasStdExtZvbbBit = 63,
  Feature_HasStdExtZvbcBit = 64,
  Feature_HasStdExtZvbcOrZvbc32eBit = 65,
  Feature_HasStdExtZvkgBit = 69,
  Feature_HasStdExtZvkgsBit = 70,
  Feature_HasStdExtZvknedBit = 71,
  Feature_HasStdExtZvknhaBit = 72,
  Feature_HasStdExtZvknhbBit = 74,
  Feature_HasStdExtZvknhaOrZvknhbBit = 73,
  Feature_HasStdExtZvksedBit = 75,
  Feature_HasStdExtZvkshBit = 76,
  Feature_HasVInstructionsBit = 77,
  Feature_HasVInstructionsI64Bit = 80,
  Feature_HasVInstructionsAnyFBit = 78,
  Feature_HasVInstructionsF16MinimalBit = 79,
  Feature_HasStdExtHBit = 10,
  Feature_HasStdExtSmrnmiBit = 13,
  Feature_HasStdExtSvinvalBit = 14,
  Feature_HasStdExtSmctrOrSsctrBit = 12,
  Feature_HasVendorXVentanaCondOpsBit = 109,
  Feature_HasVendorXTHeadBaBit = 98,
  Feature_HasVendorXTHeadBbBit = 99,
  Feature_HasVendorXTHeadBsBit = 100,
  Feature_HasVendorXTHeadCondMovBit = 102,
  Feature_HasVendorXTHeadCmoBit = 101,
  Feature_HasVendorXTHeadFMemIdxBit = 103,
  Feature_HasVendorXTHeadMacBit = 104,
  Feature_HasVendorXTHeadMemIdxBit = 105,
  Feature_HasVendorXTHeadMemPairBit = 106,
  Feature_HasVendorXTHeadSyncBit = 107,
  Feature_HasVendorXTHeadVdotBit = 108,
  Feature_HasVendorXSfvcpBit = 91,
  Feature_HasVendorXSfvqmaccdodBit = 94,
  Feature_HasVendorXSfvqmaccqoqBit = 95,
  Feature_HasVendorXSfvfwmaccqqqBit = 93,
  Feature_HasVendorXSfvfnrclipxfqfBit = 92,
  Feature_HasVendorXSiFivecdiscarddloneBit = 96,
  Feature_HasVendorXSiFivecflushdloneBit = 97,
  Feature_HasVendorXSfceaseBit = 90,
  Feature_HasVendorXCVelwBit = 84,
  Feature_HasVendorXCVbitmanipBit = 83,
  Feature_HasVendorXCVmacBit = 85,
  Feature_HasVendorXCVmemBit = 86,
  Feature_HasVendorXCValuBit = 81,
  Feature_HasVendorXCVsimdBit = 87,
  Feature_HasVendorXCVbiBit = 82,
  Feature_HasVendorXMIPSCMoveBit = 88,
  Feature_HasVendorXMIPSLSPBit = 89,
  Feature_HasVendorXwchcBit = 120,
  Feature_HasVendorXqcicsrBit = 115,
  Feature_HasVendorXqcislsBit = 119,
  Feature_HasVendorXqciaBit = 110,
  Feature_HasVendorXqcicsBit = 114,
  Feature_HasVendorXqcilsmBit = 118,
  Feature_HasVendorXqciacBit = 111,
  Feature_HasVendorXqcicliBit = 112,
  Feature_HasVendorXqcicmBit = 113,
  Feature_HasVendorXqciintBit = 116,
  Feature_HasVendorXqciloBit = 117,
  Feature_IsRV64Bit = 122,
  Feature_IsRV32Bit = 121,
};

static MCRegister MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 1 string to match.
    if (Name[0] != '0')
      break;
    return RISCV::DUMMY_REG_PAIR_WITH_X0;	 // "0"
  case 2:	 // 174 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 30 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 3 strings to match.
        return RISCV::F0_D;	 // "f0"
      case '1':	 // 3 strings to match.
        return RISCV::F1_D;	 // "f1"
      case '2':	 // 3 strings to match.
        return RISCV::F2_D;	 // "f2"
      case '3':	 // 3 strings to match.
        return RISCV::F3_D;	 // "f3"
      case '4':	 // 3 strings to match.
        return RISCV::F4_D;	 // "f4"
      case '5':	 // 3 strings to match.
        return RISCV::F5_D;	 // "f5"
      case '6':	 // 3 strings to match.
        return RISCV::F6_D;	 // "f6"
      case '7':	 // 3 strings to match.
        return RISCV::F7_D;	 // "f7"
      case '8':	 // 3 strings to match.
        return RISCV::F8_D;	 // "f8"
      case '9':	 // 3 strings to match.
        return RISCV::F9_D;	 // "f9"
      }
      break;
    case 'v':	 // 109 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 15 strings to match.
        return RISCV::V0;	 // "v0"
      case '1':	 // 8 strings to match.
        return RISCV::V1;	 // "v1"
      case '2':	 // 12 strings to match.
        return RISCV::V2;	 // "v2"
      case '3':	 // 8 strings to match.
        return RISCV::V3;	 // "v3"
      case '4':	 // 14 strings to match.
        return RISCV::V4;	 // "v4"
      case '5':	 // 8 strings to match.
        return RISCV::V5;	 // "v5"
      case '6':	 // 12 strings to match.
        return RISCV::V6;	 // "v6"
      case '7':	 // 8 strings to match.
        return RISCV::V7;	 // "v7"
      case '8':	 // 15 strings to match.
        return RISCV::V8;	 // "v8"
      case '9':	 // 8 strings to match.
        return RISCV::V9;	 // "v9"
      case 'l':	 // 1 string to match.
        return RISCV::VL;	 // "vl"
      }
      break;
    case 'x':	 // 35 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::X0;	 // "x0"
      case '1':	 // 3 strings to match.
        return RISCV::X1;	 // "x1"
      case '2':	 // 4 strings to match.
        return RISCV::X2;	 // "x2"
      case '3':	 // 3 strings to match.
        return RISCV::X3;	 // "x3"
      case '4':	 // 4 strings to match.
        return RISCV::X4;	 // "x4"
      case '5':	 // 3 strings to match.
        return RISCV::X5;	 // "x5"
      case '6':	 // 4 strings to match.
        return RISCV::X6;	 // "x6"
      case '7':	 // 3 strings to match.
        return RISCV::X7;	 // "x7"
      case '8':	 // 4 strings to match.
        return RISCV::X8;	 // "x8"
      case '9':	 // 3 strings to match.
        return RISCV::X9;	 // "x9"
      }
      break;
    }
    break;
  case 3:	 // 342 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 67 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::F10_D;	 // "f10"
        case '1':	 // 3 strings to match.
          return RISCV::F11_D;	 // "f11"
        case '2':	 // 3 strings to match.
          return RISCV::F12_D;	 // "f12"
        case '3':	 // 3 strings to match.
          return RISCV::F13_D;	 // "f13"
        case '4':	 // 3 strings to match.
          return RISCV::F14_D;	 // "f14"
        case '5':	 // 3 strings to match.
          return RISCV::F15_D;	 // "f15"
        case '6':	 // 3 strings to match.
          return RISCV::F16_D;	 // "f16"
        case '7':	 // 3 strings to match.
          return RISCV::F17_D;	 // "f17"
        case '8':	 // 3 strings to match.
          return RISCV::F18_D;	 // "f18"
        case '9':	 // 3 strings to match.
          return RISCV::F19_D;	 // "f19"
        }
        break;
      case '2':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::F20_D;	 // "f20"
        case '1':	 // 3 strings to match.
          return RISCV::F21_D;	 // "f21"
        case '2':	 // 3 strings to match.
          return RISCV::F22_D;	 // "f22"
        case '3':	 // 3 strings to match.
          return RISCV::F23_D;	 // "f23"
        case '4':	 // 3 strings to match.
          return RISCV::F24_D;	 // "f24"
        case '5':	 // 3 strings to match.
          return RISCV::F25_D;	 // "f25"
        case '6':	 // 3 strings to match.
          return RISCV::F26_D;	 // "f26"
        case '7':	 // 3 strings to match.
          return RISCV::F27_D;	 // "f27"
        case '8':	 // 3 strings to match.
          return RISCV::F28_D;	 // "f28"
        case '9':	 // 3 strings to match.
          return RISCV::F29_D;	 // "f29"
        }
        break;
      case '3':	 // 6 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::F30_D;	 // "f30"
        case '1':	 // 3 strings to match.
          return RISCV::F31_D;	 // "f31"
        }
        break;
      case 'r':	 // 1 string to match.
        if (Name[2] != 'm')
          break;
        return RISCV::FRM;	 // "frm"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(Name.data()+1, "sp", 2) != 0)
        break;
      return RISCV::SSP;	 // "ssp"
    case 'v':	 // 197 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 105 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 12 strings to match.
          return RISCV::V10;	 // "v10"
        case '1':	 // 8 strings to match.
          return RISCV::V11;	 // "v11"
        case '2':	 // 14 strings to match.
          return RISCV::V12;	 // "v12"
        case '3':	 // 8 strings to match.
          return RISCV::V13;	 // "v13"
        case '4':	 // 12 strings to match.
          return RISCV::V14;	 // "v14"
        case '5':	 // 8 strings to match.
          return RISCV::V15;	 // "v15"
        case '6':	 // 15 strings to match.
          return RISCV::V16;	 // "v16"
        case '7':	 // 8 strings to match.
          return RISCV::V17;	 // "v17"
        case '8':	 // 12 strings to match.
          return RISCV::V18;	 // "v18"
        case '9':	 // 8 strings to match.
          return RISCV::V19;	 // "v19"
        }
        break;
      case '2':	 // 88 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 14 strings to match.
          return RISCV::V20;	 // "v20"
        case '1':	 // 8 strings to match.
          return RISCV::V21;	 // "v21"
        case '2':	 // 12 strings to match.
          return RISCV::V22;	 // "v22"
        case '3':	 // 8 strings to match.
          return RISCV::V23;	 // "v23"
        case '4':	 // 15 strings to match.
          return RISCV::V24;	 // "v24"
        case '5':	 // 7 strings to match.
          return RISCV::V25;	 // "v25"
        case '6':	 // 9 strings to match.
          return RISCV::V26;	 // "v26"
        case '7':	 // 5 strings to match.
          return RISCV::V27;	 // "v27"
        case '8':	 // 7 strings to match.
          return RISCV::V28;	 // "v28"
        case '9':	 // 3 strings to match.
          return RISCV::V29;	 // "v29"
        }
        break;
      case '3':	 // 4 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::V30;	 // "v30"
        case '1':	 // 1 string to match.
          return RISCV::V31;	 // "v31"
        }
        break;
      }
      break;
    case 'x':	 // 77 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 35 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::X10;	 // "x10"
        case '1':	 // 3 strings to match.
          return RISCV::X11;	 // "x11"
        case '2':	 // 4 strings to match.
          return RISCV::X12;	 // "x12"
        case '3':	 // 3 strings to match.
          return RISCV::X13;	 // "x13"
        case '4':	 // 4 strings to match.
          return RISCV::X14;	 // "x14"
        case '5':	 // 3 strings to match.
          return RISCV::X15;	 // "x15"
        case '6':	 // 4 strings to match.
          return RISCV::X16;	 // "x16"
        case '7':	 // 3 strings to match.
          return RISCV::X17;	 // "x17"
        case '8':	 // 4 strings to match.
          return RISCV::X18;	 // "x18"
        case '9':	 // 3 strings to match.
          return RISCV::X19;	 // "x19"
        }
        break;
      case '2':	 // 35 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::X20;	 // "x20"
        case '1':	 // 3 strings to match.
          return RISCV::X21;	 // "x21"
        case '2':	 // 4 strings to match.
          return RISCV::X22;	 // "x22"
        case '3':	 // 3 strings to match.
          return RISCV::X23;	 // "x23"
        case '4':	 // 4 strings to match.
          return RISCV::X24;	 // "x24"
        case '5':	 // 3 strings to match.
          return RISCV::X25;	 // "x25"
        case '6':	 // 4 strings to match.
          return RISCV::X26;	 // "x26"
        case '7':	 // 3 strings to match.
          return RISCV::X27;	 // "x27"
        case '8':	 // 4 strings to match.
          return RISCV::X28;	 // "x28"
        case '9':	 // 3 strings to match.
          return RISCV::X29;	 // "x29"
        }
        break;
      case '3':	 // 7 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 4 strings to match.
          return RISCV::X30;	 // "x30"
        case '1':	 // 3 strings to match.
          return RISCV::X31;	 // "x31"
        }
        break;
      }
      break;
    }
    break;
  case 4:	 // 1 string to match.
    if (memcmp(Name.data()+0, "vxrm", 4) != 0)
      break;
    return RISCV::VXRM;	 // "vxrm"
  case 5:	 // 3 strings to match.
    if (Name[0] != 'v')
      break;
    switch (Name[1]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(Name.data()+2, "enb", 3) != 0)
        break;
      return RISCV::VLENB;	 // "vlenb"
    case 't':	 // 1 string to match.
      if (memcmp(Name.data()+2, "ype", 3) != 0)
        break;
      return RISCV::VTYPE;	 // "vtype"
    case 'x':	 // 1 string to match.
      if (memcmp(Name.data()+2, "sat", 3) != 0)
        break;
      return RISCV::VXSAT;	 // "vxsat"
    }
    break;
  case 6:	 // 1 string to match.
    if (memcmp(Name.data()+0, "fflags", 6) != 0)
      break;
    return RISCV::FFLAGS;	 // "fflags"
  case 13:	 // 1 string to match.
    if (memcmp(Name.data()+0, "sf.vcix_state", 13) != 0)
      break;
    return RISCV::SF_VCIX_STATE;	 // "sf.vcix_state"
  }
  return RISCV::NoRegister;
}

static MCRegister MatchRegisterAltName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 105 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 28 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::X10;	 // "a0"
      case '1':	 // 3 strings to match.
        return RISCV::X11;	 // "a1"
      case '2':	 // 4 strings to match.
        return RISCV::X12;	 // "a2"
      case '3':	 // 3 strings to match.
        return RISCV::X13;	 // "a3"
      case '4':	 // 4 strings to match.
        return RISCV::X14;	 // "a4"
      case '5':	 // 3 strings to match.
        return RISCV::X15;	 // "a5"
      case '6':	 // 4 strings to match.
        return RISCV::X16;	 // "a6"
      case '7':	 // 3 strings to match.
        return RISCV::X17;	 // "a7"
      }
      break;
    case 'f':	 // 4 strings to match.
      if (Name[1] != 'p')
        break;
      return RISCV::X8;	 // "fp"
    case 'g':	 // 3 strings to match.
      if (Name[1] != 'p')
        break;
      return RISCV::X3;	 // "gp"
    case 'r':	 // 3 strings to match.
      if (Name[1] != 'a')
        break;
      return RISCV::X1;	 // "ra"
    case 's':	 // 39 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::X8;	 // "s0"
      case '1':	 // 3 strings to match.
        return RISCV::X9;	 // "s1"
      case '2':	 // 4 strings to match.
        return RISCV::X18;	 // "s2"
      case '3':	 // 3 strings to match.
        return RISCV::X19;	 // "s3"
      case '4':	 // 4 strings to match.
        return RISCV::X20;	 // "s4"
      case '5':	 // 3 strings to match.
        return RISCV::X21;	 // "s5"
      case '6':	 // 4 strings to match.
        return RISCV::X22;	 // "s6"
      case '7':	 // 3 strings to match.
        return RISCV::X23;	 // "s7"
      case '8':	 // 4 strings to match.
        return RISCV::X24;	 // "s8"
      case '9':	 // 3 strings to match.
        return RISCV::X25;	 // "s9"
      case 'p':	 // 4 strings to match.
        return RISCV::X2;	 // "sp"
      }
      break;
    case 't':	 // 28 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 3 strings to match.
        return RISCV::X5;	 // "t0"
      case '1':	 // 4 strings to match.
        return RISCV::X6;	 // "t1"
      case '2':	 // 3 strings to match.
        return RISCV::X7;	 // "t2"
      case '3':	 // 4 strings to match.
        return RISCV::X28;	 // "t3"
      case '4':	 // 3 strings to match.
        return RISCV::X29;	 // "t4"
      case '5':	 // 4 strings to match.
        return RISCV::X30;	 // "t5"
      case '6':	 // 3 strings to match.
        return RISCV::X31;	 // "t6"
      case 'p':	 // 4 strings to match.
        return RISCV::X4;	 // "tp"
      }
      break;
    }
    break;
  case 3:	 // 91 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 84 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 24 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::F10_D;	 // "fa0"
        case '1':	 // 3 strings to match.
          return RISCV::F11_D;	 // "fa1"
        case '2':	 // 3 strings to match.
          return RISCV::F12_D;	 // "fa2"
        case '3':	 // 3 strings to match.
          return RISCV::F13_D;	 // "fa3"
        case '4':	 // 3 strings to match.
          return RISCV::F14_D;	 // "fa4"
        case '5':	 // 3 strings to match.
          return RISCV::F15_D;	 // "fa5"
        case '6':	 // 3 strings to match.
          return RISCV::F16_D;	 // "fa6"
        case '7':	 // 3 strings to match.
          return RISCV::F17_D;	 // "fa7"
        }
        break;
      case 's':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::F8_D;	 // "fs0"
        case '1':	 // 3 strings to match.
          return RISCV::F9_D;	 // "fs1"
        case '2':	 // 3 strings to match.
          return RISCV::F18_D;	 // "fs2"
        case '3':	 // 3 strings to match.
          return RISCV::F19_D;	 // "fs3"
        case '4':	 // 3 strings to match.
          return RISCV::F20_D;	 // "fs4"
        case '5':	 // 3 strings to match.
          return RISCV::F21_D;	 // "fs5"
        case '6':	 // 3 strings to match.
          return RISCV::F22_D;	 // "fs6"
        case '7':	 // 3 strings to match.
          return RISCV::F23_D;	 // "fs7"
        case '8':	 // 3 strings to match.
          return RISCV::F24_D;	 // "fs8"
        case '9':	 // 3 strings to match.
          return RISCV::F25_D;	 // "fs9"
        }
        break;
      case 't':	 // 30 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::F0_D;	 // "ft0"
        case '1':	 // 3 strings to match.
          return RISCV::F1_D;	 // "ft1"
        case '2':	 // 3 strings to match.
          return RISCV::F2_D;	 // "ft2"
        case '3':	 // 3 strings to match.
          return RISCV::F3_D;	 // "ft3"
        case '4':	 // 3 strings to match.
          return RISCV::F4_D;	 // "ft4"
        case '5':	 // 3 strings to match.
          return RISCV::F5_D;	 // "ft5"
        case '6':	 // 3 strings to match.
          return RISCV::F6_D;	 // "ft6"
        case '7':	 // 3 strings to match.
          return RISCV::F7_D;	 // "ft7"
        case '8':	 // 3 strings to match.
          return RISCV::F28_D;	 // "ft8"
        case '9':	 // 3 strings to match.
          return RISCV::F29_D;	 // "ft9"
        }
        break;
      }
      break;
    case 's':	 // 7 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 4 strings to match.
        return RISCV::X26;	 // "s10"
      case '1':	 // 3 strings to match.
        return RISCV::X27;	 // "s11"
      }
      break;
    }
    break;
  case 4:	 // 16 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 12 strings to match.
      switch (Name[1]) {
      default: break;
      case 's':	 // 6 strings to match.
        if (Name[2] != '1')
          break;
        switch (Name[3]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::F26_D;	 // "fs10"
        case '1':	 // 3 strings to match.
          return RISCV::F27_D;	 // "fs11"
        }
        break;
      case 't':	 // 6 strings to match.
        if (Name[2] != '1')
          break;
        switch (Name[3]) {
        default: break;
        case '0':	 // 3 strings to match.
          return RISCV::F30_D;	 // "ft10"
        case '1':	 // 3 strings to match.
          return RISCV::F31_D;	 // "ft11"
        }
        break;
      }
      break;
    case 'z':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "ero", 3) != 0)
        break;
      return RISCV::X0;	 // "zero"
    }
    break;
  }
  return RISCV::NoRegister;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_HasStdExtZicbomBit: return "'Zicbom' (Cache-Block Management Instructions)";
  case Feature_HasStdExtZicbopBit: return "'Zicbop' (Cache-Block Prefetch Instructions)";
  case Feature_HasStdExtZicbozBit: return "'Zicboz' (Cache-Block Zero Instructions)";
  case Feature_HasStdExtZicsrBit: return "'Zicsr' (CSRs)";
  case Feature_HasStdExtZicondBit: return "(Integer Conditional Operations)";
  case Feature_HasStdExtZifenceiBit: return "'Zifencei' (fence.i)";
  case Feature_HasStdExtZihintpauseBit: return "'Zihintpause' (Pause Hint)";
  case Feature_HasStdExtZihintntlBit: return "'Zihintntl' (Non-Temporal Locality Hints)";
  case Feature_HasStdExtZimopBit: return "'Zimop' (May-Be-Operations)";
  case Feature_HasStdExtZicfilpBit: return "'Zicfilp' (Landing pad)";
  case Feature_NoStdExtZicfilpBit: return "";
  case Feature_HasStdExtZicfissBit: return "'Zicfiss' (Shadow stack)";
  case Feature_HasStdExtZmmulBit: return "'Zmmul' (Integer Multiplication)";
  case Feature_HasStdExtMBit: return "'M' (Integer Multiplication and Division)";
  case Feature_HasStdExtZaamoBit: return "'Zaamo' (Atomic Memory Operations)";
  case Feature_HasStdExtZalrscBit: return "'Zalrsc' (Load-Reserved/Store-Conditional)";
  case Feature_HasStdExtABit: return "'A' (Atomic Instructions)";
  case Feature_HasStdExtZtsoBit: return "'Ztso' (Memory Model - Total Store Order)";
  case Feature_HasStdExtZabhaBit: return "'Zabha' (Byte and Halfword Atomic Memory Operations)";
  case Feature_HasStdExtZacasBit: return "'Zacas' (Atomic Compare-And-Swap Instructions)";
  case Feature_HasStdExtZalasrBit: return "'Zalasr' (Load-Acquire and Store-Release Instructions)";
  case Feature_HasStdExtZawrsBit: return "'Zawrs' (Wait on Reservation Set)";
  case Feature_HasStdExtFBit: return "'F' (Single-Precision Floating-Point)";
  case Feature_HasStdExtDBit: return "'D' (Double-Precision Floating-Point)";
  case Feature_HasStdExtZfhminBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zfhmin' (Half-Precision Floating-Point Minimal)";
  case Feature_HasStdExtZfhBit: return "'Zfh' (Half-Precision Floating-Point)";
  case Feature_HasStdExtZfbfminBit: return "'Zfbfmin' (Scalar BF16 Converts)";
  case Feature_HasHalfFPLoadStoreMoveBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zfhmin' (Half-Precision Floating-Point Minimal) or 'Zfbfmin' (Scalar BF16 Converts)";
  case Feature_HasStdExtZfaBit: return "'Zfa' (Additional Floating-Point)";
  case Feature_HasStdExtZfinxBit: return "'Zfinx' (Float in Integer)";
  case Feature_HasStdExtFOrZfinxBit: return "'F' (Single-Precision Floating-Point) or 'Zfinx' (Float in Integer)";
  case Feature_HasStdExtZdinxBit: return "'Zdinx' (Double in Integer)";
  case Feature_HasStdExtZhinxminBit: return "'Zhinx' (Half Float in Integer) or 'Zhinxmin' (Half Float in Integer Minimal)";
  case Feature_HasStdExtZhinxBit: return "'Zhinx' (Half Float in Integer)";
  case Feature_HasStdExtCBit: return "'C' (Compressed Instructions)";
  case Feature_HasRVCHintsBit: return "RVC Hint Instructions";
  case Feature_HasStdExtCOrZcaBit: return "'C' (Compressed Instructions) or 'Zca' (part of the C extension, excluding compressed floating point loads/stores)";
  case Feature_HasStdExtZcbBit: return "'Zcb' (Compressed basic bit manipulation instructions)";
  case Feature_HasStdExtCOrZcdBit: return "'C' (Compressed Instructions) or 'Zcd' (Compressed Double-Precision Floating-Point Instructions)";
  case Feature_HasStdExtZcmpBit: return "'Zcmp' (sequenced instructions for code-size reduction)";
  case Feature_HasStdExtZcmtBit: return "'Zcmt' (table jump instructions for code-size reduction)";
  case Feature_HasStdExtCOrZcfOrZceBit: return "'C' (Compressed Instructions) or 'Zcf' (Compressed Single-Precision Floating-Point Instructions)";
  case Feature_HasStdExtZcmopBit: return "'Zcmop' (Compressed May-Be-Operations)";
  case Feature_HasStdExtZbaBit: return "'Zba' (Address Generation Instructions)";
  case Feature_HasStdExtZbbBit: return "'Zbb' (Basic Bit-Manipulation)";
  case Feature_NoStdExtZbbBit: return "";
  case Feature_HasStdExtZbcBit: return "'Zbc' (Carry-Less Multiplication)";
  case Feature_HasStdExtZbsBit: return "'Zbs' (Single-Bit Instructions)";
  case Feature_HasStdExtZbkbBit: return "'Zbkb' (Bitmanip instructions for Cryptography)";
  case Feature_NoStdExtZbkbBit: return "";
  case Feature_HasStdExtZbkxBit: return "'Zbkx' (Crossbar permutation instructions)";
  case Feature_HasStdExtZbbOrZbkbBit: return "'Zbb' (Basic Bit-Manipulation) or 'Zbkb' (Bitmanip instructions for Cryptography)";
  case Feature_HasStdExtZbkcBit: return "'Zbkc' (Carry-less multiply instructions for Cryptography)";
  case Feature_HasStdExtZbcOrZbkcBit: return "'Zbc' (Carry-Less Multiplication) or 'Zbkc' (Carry-less multiply instructions for Cryptography)";
  case Feature_HasStdExtZkndBit: return "'Zknd' (NIST Suite: AES Decryption)";
  case Feature_HasStdExtZkneBit: return "'Zkne' (NIST Suite: AES Encryption)";
  case Feature_HasStdExtZkndOrZkneBit: return "'Zknd' (NIST Suite: AES Decryption) or 'Zkne' (NIST Suite: AES Encryption)";
  case Feature_HasStdExtZknhBit: return "'Zknh' (NIST Suite: Hash Function Instructions)";
  case Feature_HasStdExtZksedBit: return "'Zksed' (ShangMi Suite: SM4 Block Cipher Instructions)";
  case Feature_HasStdExtZkshBit: return "'Zksh' (ShangMi Suite: SM3 Hash Function Instructions)";
  case Feature_HasStdExtZkrBit: return "'Zkr' (Entropy Source Extension)";
  case Feature_HasStdExtZvfbfminBit: return "'Zvfbfmin' (Vector BF16 Converts)";
  case Feature_HasStdExtZvfbfwmaBit: return "'Zvfbfwma' (Vector BF16 widening mul-add)";
  case Feature_HasStdExtZfhOrZvfhBit: return "'Zfh' (Half-Precision Floating-Point) or 'Zvfh' (Vector Half-Precision Floating-Point)";
  case Feature_HasStdExtZvkbBit: return "'Zvkb' (Vector Bit-manipulation used in Cryptography)";
  case Feature_HasStdExtZvbbBit: return "'Zvbb' (Vector basic bit-manipulation instructions)";
  case Feature_HasStdExtZvbcBit: return "'Zvbc' (Vector Carryless Multiplication)";
  case Feature_HasStdExtZvbcOrZvbc32eBit: return "'Zvbc' or 'Zvbc32e' (Vector Carryless Multiplication)";
  case Feature_HasStdExtZvkgBit: return "'Zvkg' (Vector GCM instructions for Cryptography)";
  case Feature_HasStdExtZvkgsBit: return "'Zvkgs' (Vector-Scalar GCM instructions for Cryptography)";
  case Feature_HasStdExtZvknedBit: return "'Zvkned' (Vector AES Encryption & Decryption (Single Round))";
  case Feature_HasStdExtZvknhaBit: return "'Zvknha' (Vector SHA-2 (SHA-256 only))";
  case Feature_HasStdExtZvknhbBit: return "'Zvknhb' (Vector SHA-2 (SHA-256 and SHA-512))";
  case Feature_HasStdExtZvknhaOrZvknhbBit: return "'Zvknha' or 'Zvknhb' (Vector SHA-2)";
  case Feature_HasStdExtZvksedBit: return "'Zvksed' (SM4 Block Cipher Instructions)";
  case Feature_HasStdExtZvkshBit: return "'Zvksh' (SM3 Hash Function Instructions)";
  case Feature_HasVInstructionsBit: return "'V' (Vector Extension for Application Processors), 'Zve32x' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsI64Bit: return "'V' (Vector Extension for Application Processors) or 'Zve64x' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsAnyFBit: return "'V' (Vector Extension for Application Processors), 'Zve32f' (Vector Extensions for Embedded Processors)";
  case Feature_HasVInstructionsF16MinimalBit: return "'Zvfhmin' (Vector Half-Precision Floating-Point Minimal) or 'Zvfh' (Vector Half-Precision Floating-Point)";
  case Feature_HasStdExtHBit: return "'H' (Hypervisor)";
  case Feature_HasStdExtSmrnmiBit: return "'Smrnmi' (Resumable Non-Maskable Interrupts)";
  case Feature_HasStdExtSvinvalBit: return "'Svinval' (Fine-Grained Address-Translation Cache Invalidation)";
  case Feature_HasStdExtSmctrOrSsctrBit: return "'Smctr' (Control Transfer Records Machine Level) or 'Ssctr' (Control Transfer Records Supervisor Level)";
  case Feature_HasVendorXVentanaCondOpsBit: return "'XVentanaCondOps' (Ventana Conditional Ops)";
  case Feature_HasVendorXTHeadBaBit: return "'XTHeadBa' (T-Head address calculation instructions)";
  case Feature_HasVendorXTHeadBbBit: return "'XTHeadBb' (T-Head basic bit-manipulation instructions)";
  case Feature_HasVendorXTHeadBsBit: return "'XTHeadBs' (T-Head single-bit instructions)";
  case Feature_HasVendorXTHeadCondMovBit: return "'XTHeadCondMov' (T-Head conditional move instructions)";
  case Feature_HasVendorXTHeadCmoBit: return "'XTHeadCmo' (T-Head cache management instructions)";
  case Feature_HasVendorXTHeadFMemIdxBit: return "'XTHeadFMemIdx' (T-Head FP Indexed Memory Operations)";
  case Feature_HasVendorXTHeadMacBit: return "'XTHeadMac' (T-Head Multiply-Accumulate Instructions)";
  case Feature_HasVendorXTHeadMemIdxBit: return "'XTHeadMemIdx' (T-Head Indexed Memory Operations)";
  case Feature_HasVendorXTHeadMemPairBit: return "'XTHeadMemPair' (T-Head two-GPR Memory Operations)";
  case Feature_HasVendorXTHeadSyncBit: return "'XTHeadSync' (T-Head multicore synchronization instructions)";
  case Feature_HasVendorXTHeadVdotBit: return "'XTHeadVdot' (T-Head Vector Extensions for Dot)";
  case Feature_HasVendorXSfvcpBit: return "'XSfvcp' (SiFive Custom Vector Coprocessor Interface Instructions)";
  case Feature_HasVendorXSfvqmaccdodBit: return "'XSfvqmaccdod' (SiFive Int8 Matrix Multiplication Instructions (2-by-8 and 8-by-2))";
  case Feature_HasVendorXSfvqmaccqoqBit: return "'XSfvqmaccqoq' (SiFive Int8 Matrix Multiplication Instructions (4-by-8 and 8-by-4))";
  case Feature_HasVendorXSfvfwmaccqqqBit: return "'XSfvfwmaccqqq' (SiFive Matrix Multiply Accumulate Instruction and 4-by-4))";
  case Feature_HasVendorXSfvfnrclipxfqfBit: return "'XSfvfnrclipxfqf' (SiFive FP32-to-int8 Ranged Clip Instructions)";
  case Feature_HasVendorXSiFivecdiscarddloneBit: return "'XSiFivecdiscarddlone' (SiFive sf.cdiscard.d.l1 Instruction)";
  case Feature_HasVendorXSiFivecflushdloneBit: return "'XSiFivecflushdlone' (SiFive sf.cflush.d.l1 Instruction)";
  case Feature_HasVendorXSfceaseBit: return "'XSfcease' (SiFive sf.cease Instruction)";
  case Feature_HasVendorXCVelwBit: return "'XCVelw' (CORE-V Event Load Word)";
  case Feature_HasVendorXCVbitmanipBit: return "'XCVbitmanip' (CORE-V Bit Manipulation)";
  case Feature_HasVendorXCVmacBit: return "'XCVmac' (CORE-V Multiply-Accumulate)";
  case Feature_HasVendorXCVmemBit: return "'XCVmem' (CORE-V Post-incrementing Load & Store)";
  case Feature_HasVendorXCValuBit: return "'XCValu' (CORE-V ALU Operations)";
  case Feature_HasVendorXCVsimdBit: return "'XCVsimd' (CORE-V SIMD ALU)";
  case Feature_HasVendorXCVbiBit: return "'XCVbi' (CORE-V Immediate Branching)";
  case Feature_HasVendorXMIPSCMoveBit: return "'Xmipscmove' ('mips.ccmov' instruction)";
  case Feature_HasVendorXMIPSLSPBit: return "'Xmipslsp' (load and store pair instructions)";
  case Feature_HasVendorXwchcBit: return "'Xwchc' (WCH/QingKe additional compressed opcodes)";
  case Feature_HasVendorXqcicsrBit: return "'Xqcicsr' (Qualcomm uC CSR Extension)";
  case Feature_HasVendorXqcislsBit: return "'Xqcisls' (Qualcomm uC Scaled Load Store Extension)";
  case Feature_HasVendorXqciaBit: return "'Xqcia' (Qualcomm uC Arithmetic Extension)";
  case Feature_HasVendorXqcicsBit: return "'Xqcics' (Qualcomm uC Conditional Select Extension)";
  case Feature_HasVendorXqcilsmBit: return "'Xqcilsm' (Qualcomm uC Load Store Multiple Extension)";
  case Feature_HasVendorXqciacBit: return "'Xqciac' (Qualcomm uC Load-Store Address Calculation Extension)";
  case Feature_HasVendorXqcicliBit: return "'Xqcicli' (Qualcomm uC Conditional Load Immediate Extension)";
  case Feature_HasVendorXqcicmBit: return "'Xqcicm' (Qualcomm uC Conditional Move Extension)";
  case Feature_HasVendorXqciintBit: return "'Xqciint' (Qualcomm uC Interrupts Extension)";
  case Feature_HasVendorXqciloBit: return "'Xqcilo' (Qualcomm uC Large Offset Load Store Extension)";
  case Feature_IsRV64Bit: return "RV64I Base Instruction Set";
  case Feature_IsRV32Bit: return "RV32I Base Instruction Set";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, const FeatureBitset &Features, unsigned VariantID) {
  switch (Mnemonic.size()) {
  default: break;
  case 4:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "move", 4) != 0)
      break;
    Mnemonic = "mv";	 // "move"
    return;
  case 5:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "scall", 5) != 0)
      break;
    Mnemonic = "ecall";	 // "scall"
    return;
  case 6:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "sbreak", 6) != 0)
      break;
    Mnemonic = "ebreak";	 // "sbreak"
    return;
  case 7:	 // 3 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "v.slet", 6) != 0)
        break;
      if (Features.test(Feature_HasVendorXCValuBit) && Features.test(Feature_IsRV32Bit))	 // "cv.slet"
        Mnemonic = "cv.sle";
      return;
    case 'f':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "mv.", 3) != 0)
        break;
      switch (Mnemonic[4]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, ".x", 2) != 0)
          break;
        if (Features.test(Feature_HasStdExtFBit))	 // "fmv.s.x"
          Mnemonic = "fmv.w.x";
        return;
      case 'x':	 // 1 string to match.
        if (memcmp(Mnemonic.data()+5, ".s", 2) != 0)
          break;
        if (Features.test(Feature_HasStdExtFBit))	 // "fmv.x.s"
          Mnemonic = "fmv.x.w";
        return;
      }
      break;
    }
    break;
  case 8:	 // 1 string to match.
    if (memcmp(Mnemonic.data()+0, "cv.sletu", 8) != 0)
      break;
    if (Features.test(Feature_HasVendorXCValuBit) && Features.test(Feature_IsRV32Bit))	 // "cv.sletu"
      Mnemonic = "cv.sleu";
    return;
  }
}

enum {
  Tie0_1_1,
  Tie0_2_2,
  Tie0_3_3,
  Tie1_3_3,
};

static const uint8_t TiedAsmOperandTable[][3] = {
  /* Tie0_1_1 */ { 0, 1, 1 },
  /* Tie0_2_2 */ { 0, 2, 2 },
  /* Tie0_3_3 */ { 0, 3, 3 },
  /* Tie1_3_3 */ { 1, 3, 3 },
};

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_95_addImmOperands,
  CVT_95_addRegOperands,
  CVT_imm_95_0,
  CVT_95_Reg,
  CVT_regX0,
  CVT_regX5,
  CVT_regX2,
  CVT_regX3,
  CVT_regX4,
  CVT_95_addRlistOperands,
  CVT_95_addSpimmOperands,
  CVT_95_addCSRSystemRegisterOperands,
  CVT_95_addRegRegOperands,
  CVT_95_addFRMArgOperands_95_defaultFRMArgOp,
  CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp,
  CVT_95_addFRMArgOperands,
  CVT_imm_95_15,
  CVT_95_addFenceArgOperands,
  CVT_95_addFPImmOperands,
  CVT_imm_95_3,
  CVT_imm_95_1,
  CVT_imm_95_2,
  CVT_regX1,
  CVT_imm_95__MINUS_1,
  CVT_imm_95_3072,
  CVT_imm_95_3200,
  CVT_imm_95_3074,
  CVT_imm_95_3202,
  CVT_imm_95_3073,
  CVT_imm_95_3201,
  CVT_95_addRegOperands_95_defaultMaskRegOp,
  CVT_reg0,
  CVT_95_addVTypeIOperands,
  CVT_imm_95_255,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4,
  Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3,
  Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_4__imm_95_0,
  Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3,
  Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_4__imm_95_0,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3,
  Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_4__imm_95_0,
  Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3,
  Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5,
  Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_4__imm_95_0,
  Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3,
  Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__SImm121_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Reg1_1__RnumArg1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1,
  Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1,
  Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1,
  Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1,
  Convert__Reg1_0__UImm20AUIPC1_1,
  Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2,
  Convert__Reg1_0__Reg1_1__SImm13Lsb01_2,
  Convert__Reg1_0__regX0__SImm13Lsb01_1,
  Convert__Reg1_1__Reg1_0__SImm13Lsb01_2,
  Convert__regX0__Reg1_0__SImm13Lsb01_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1,
  Convert__Reg1_0__imm_95_0__ImmZero1_1,
  Convert__SImm6NonZero1_1,
  Convert__Reg1_0__Tie0_1_1__ImmZero1_1,
  Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1,
  Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1,
  Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2,
  Convert__Reg1_0__Tie0_1_1__SImm61_1,
  Convert__Reg1_0__SImm9Lsb01_1,
  Convert_NoOperands,
  Convert__Reg1_0__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1,
  Convert__Reg1_0__Reg1_3__UImm7Lsb001_1,
  Convert__Reg1_0__Reg1_3__UImm8Lsb001_1,
  Convert__SImm12Lsb01_0,
  Convert__Reg1_0,
  Convert__Reg1_0__Reg1_3__UImm21_1,
  Convert__Reg1_0__Reg1_3__UImm2Lsb01_1,
  Convert__Reg1_0__SImm61_1,
  Convert__Reg1_0__CLUIImm1_1,
  Convert__SImm6NonZero1_0,
  Convert__Reg1_0__Tie0_1_1,
  Convert__regX0__Tie0_1_1__regX5,
  Convert__regX0__Tie0_1_1__regX2,
  Convert__regX0__Tie0_1_1__regX3,
  Convert__regX0__Tie0_1_1__regX4,
  Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1,
  Convert__CallSymbol1_0,
  Convert__Reg1_0__CallSymbol1_1,
  Convert__ZeroOffsetMemOpOperand1_0,
  Convert__UImm8GE321_0,
  Convert__UImm51_0,
  Convert__Rlist1_0__StackAdj1_1,
  Convert__Rlist1_0__NegStackAdj1_1,
  Convert__regX0__CSRSystemRegister1_0__Reg1_1,
  Convert__regX0__CSRSystemRegister1_0__UImm51_1,
  Convert__Reg1_0__CSRSystemRegister1_1__regX0,
  Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2,
  Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2,
  Convert__Reg1_0__Reg1_1__SImm61_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__UImm61_2,
  Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3,
  Convert__Reg1_0__SImm51_1__SImm13Lsb01_2,
  Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__UImm51_2,
  Convert__Reg1_0__Reg1_3__SImm121_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2,
  Convert__Reg1_0__RegReg2_1,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2,
  Convert__Reg1_0__Reg1_1__UImm31_2,
  Convert__Reg1_0__Reg1_1__UImm41_2,
  Convert__Reg1_0__Reg1_1__Reg1_1,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3,
  Convert__Reg1_0__GPRF64AsFPR1_1,
  Convert__Reg1_0__GPRPairAsFPR1_1,
  Convert__Reg1_0__GPRAsFPR161_1,
  Convert__Reg1_0__GPRAsFPR321_1,
  Convert__Reg1_0__Reg1_1__FRMArg1_2,
  Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRF64AsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2,
  Convert__GPRPairAsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2,
  Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2,
  Convert__GPRF64AsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2,
  Convert__GPRPairAsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2,
  Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2,
  Convert__GPRAsFPR161_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR161_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2,
  Convert__GPRAsFPR161_0__GPRAsFPR321_1__FRMArg1_2,
  Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2,
  Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2,
  Convert__GPRAsFPR321_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR321_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR321_0__GPRAsFPR161_1__FRMArgLegacy1_2,
  Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2,
  Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__Reg1_0__Reg1_1__RTZArg1_2,
  Convert__imm_95_15__imm_95_15,
  Convert__FenceArg1_0__FenceArg1_1,
  Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2,
  Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2,
  Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2,
  Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2,
  Convert__Reg1_0__Reg1_2__Reg1_1,
  Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1,
  Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1,
  Convert__Reg1_0__GPRAsFPR161_2__GPRAsFPR161_1,
  Convert__Reg1_0__GPRAsFPR321_2__GPRAsFPR321_1,
  Convert__Reg1_2__Reg1_0__BareSymbol1_1,
  Convert__Reg1_0__LoadFPImm1_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2,
  Convert__Reg1_0__imm_95_3__regX0,
  Convert__Reg1_0__imm_95_1__regX0,
  Convert__Reg1_0__imm_95_2__regX0,
  Convert__regX0__imm_95_3__Reg1_0,
  Convert__Reg1_0__imm_95_3__Reg1_1,
  Convert__regX0__imm_95_1__Reg1_0,
  Convert__Reg1_0__imm_95_1__Reg1_1,
  Convert__regX0__imm_95_1__UImm51_0,
  Convert__Reg1_0__imm_95_1__UImm51_1,
  Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2,
  Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2,
  Convert__GPRAsFPR161_0__GPRAsFPR161_1__FRMArg1_2,
  Convert__GPRAsFPR321_0__GPRAsFPR321_1__FRMArg1_2,
  Convert__regX0__imm_95_2__Reg1_0,
  Convert__Reg1_0__imm_95_2__Reg1_1,
  Convert__regX0__imm_95_2__UImm51_0,
  Convert__Reg1_0__imm_95_2__UImm51_1,
  Convert__regX0__regX0,
  Convert__Reg1_0__regX0,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1,
  Convert__regX0__SImm21Lsb0JAL1_0,
  Convert__regX1__SImm21Lsb0JAL1_0,
  Convert__Reg1_0__SImm21Lsb0JAL1_1,
  Convert__regX1__Reg1_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95_0,
  Convert__regX1__Reg1_0__SImm121_1,
  Convert__regX1__Reg1_1__imm_95_0,
  Convert__regX1__Reg1_2__SImm121_0,
  Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5,
  Convert__regX0__Reg1_0__imm_95_0,
  Convert__regX0__Reg1_0__SImm121_1,
  Convert__regX0__Reg1_1__imm_95_0,
  Convert__regX0__Reg1_2__SImm121_0,
  Convert__Reg1_1__PseudoJumpSymbol1_0,
  Convert__Reg1_0__BareSymbol1_1,
  Convert__Reg1_0__ImmXLenLI_Restricted1_1,
  Convert__Reg1_0__regX0__SImm121_1,
  Convert__Reg1_0__ImmXLenLI1_1,
  Convert__regX0__UImm201_0,
  Convert__Reg1_0__UImm20LUI1_1,
  Convert__Reg1_0__Reg1_2__Reg1_1__Reg1_3,
  Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb0001_2,
  Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb001_2,
  Convert__Reg1_0__regX0__Reg1_1,
  Convert__regX0__regX0__imm_95_0,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1,
  Convert__regX0__regX0__regX5,
  Convert__regX0__regX0__regX2,
  Convert__regX0__regX0__regX3,
  Convert__regX0__regX0__regX4,
  Convert__imm_95_1__imm_95_0,
  Convert__Reg1_2__SImm12Lsb000001_0,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2,
  Convert__UImm101_0,
  Convert__Reg1_0__UImm51_1__Reg1_2,
  Convert__Reg1_0__Reg1_3__SImm261_1,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__SImm51_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3,
  Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0,
  Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2,
  Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0,
  Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm121_2,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__UImm51_2__Reg1_3,
  Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__SImm51_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__UImm5GT31_3,
  Convert__Reg1_0__Reg1_1__UImm111_2,
  Convert__Reg1_0__Reg1_3__UImm51_1,
  Convert__Reg1_0__Reg1_3__UImm41_1,
  Convert__Reg1_0__Reg1_3__UImm6Lsb01_1,
  Convert__Reg1_0__Reg1_3__UImm5Lsb01_1,
  Convert__Reg1_0__imm_95_3072__regX0,
  Convert__Reg1_0__imm_95_3200__regX0,
  Convert__Reg1_0__imm_95_3074__regX0,
  Convert__Reg1_0__imm_95_3202__regX0,
  Convert__Reg1_0__imm_95_3073__regX0,
  Convert__Reg1_0__imm_95_3201__regX0,
  Convert__regX0__regX1__imm_95_0,
  Convert__ZeroOffsetMemOpOperand1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__imm_95_1,
  Convert__regX0,
  Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3,
  Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3,
  Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3,
  Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3,
  Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3,
  Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3,
  Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3,
  Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3,
  Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__regX0,
  Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3,
  Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5,
  Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6,
  Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5,
  Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__Reg1_1__reg0,
  Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__RVVMaskRegOpOperand1_1,
  Convert__Reg1_0__Reg1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm51_2,
  Convert__Reg1_0__Reg1_0__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__SImm51_1,
  Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__Reg1_1__regX0__reg0,
  Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0,
  Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2,
  Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3,
  Convert__Reg1_0__UImm51_1__VTypeI101_2,
  Convert__Reg1_0__Reg1_1__VTypeI111_2,
  Convert__Reg1_0__Reg1_1__imm_95_255,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][15] = {
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_4__imm_95_0
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_4__imm_95_0
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_4__imm_95_0
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3
  { CVT_95_addRegOperands, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2
  { CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addRegOperands, 6, CVT_Done },
  // Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6
  { CVT_95_addRegOperands, 4, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 5, CVT_95_addRegOperands, 6, CVT_95_addRegOperands, 7, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_4__imm_95_0
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 5, CVT_imm_95_0, 0, CVT_Done },
  // Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 6, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2
  { CVT_95_addRegOperands, 2, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm121_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RnumArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1
  { CVT_95_addRegOperands, 1, CVT_Tied, Tie0_1_1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__UImm20AUIPC1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__regX0__SImm13Lsb01_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_0__SImm13Lsb01_2
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__regX0__Reg1_0__SImm13Lsb01_1
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__imm_95_0__ImmZero1_1
  { CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm6NonZero1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__ImmZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm61_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm9Lsb01_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert_NoOperands
  { CVT_Done },
  // Convert__Reg1_0__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm7Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm8Lsb001_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm12Lsb01_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm21_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm2Lsb01_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__SImm61_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__CLUIImm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__SImm6NonZero1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX5
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX5, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX2
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX2, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX3
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX3, 0, CVT_Done },
  // Convert__regX0__Tie0_1_1__regX4
  { CVT_regX0, 0, CVT_Tied, Tie0_1_1, CVT_regX4, 0, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__CallSymbol1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__CallSymbol1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__ZeroOffsetMemOpOperand1_0
  { CVT_95_addRegOperands, 1, CVT_Done },
  // Convert__UImm8GE321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__UImm51_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Rlist1_0__StackAdj1_1
  { CVT_95_addRlistOperands, 1, CVT_95_addSpimmOperands, 2, CVT_Done },
  // Convert__Rlist1_0__NegStackAdj1_1
  { CVT_95_addRlistOperands, 1, CVT_95_addSpimmOperands, 2, CVT_Done },
  // Convert__regX0__CSRSystemRegister1_0__Reg1_1
  { CVT_regX0, 0, CVT_95_addCSRSystemRegisterOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__CSRSystemRegister1_0__UImm51_1
  { CVT_regX0, 0, CVT_95_addCSRSystemRegisterOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__regX0
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_95_addCSRSystemRegisterOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm61_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm61_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__SImm51_1__SImm13Lsb01_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm121_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__RegReg2_1
  { CVT_95_Reg, 1, CVT_95_addRegRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm31_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm41_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 4, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR161_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR321_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR321_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR161_1__FRMArgLegacy1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RTZArg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addFRMArgOperands, 3, CVT_Done },
  // Convert__imm_95_15__imm_95_15
  { CVT_imm_95_15, 0, CVT_imm_95_15, 0, CVT_Done },
  // Convert__FenceArg1_0__FenceArg1_1
  { CVT_95_addFenceArgOperands, 1, CVT_95_addFenceArgOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR161_2__GPRAsFPR161_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_0__GPRAsFPR321_2__GPRAsFPR321_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_0__BareSymbol1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__LoadFPImm1_1
  { CVT_95_Reg, 1, CVT_95_addFPImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_95_addRegOperands, 4, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 5, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands, 3, CVT_Done },
  // Convert__Reg1_0__imm_95_3__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_1__regX0
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_2__regX0
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_regX0, 0, CVT_Done },
  // Convert__regX0__imm_95_3__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_3, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_3__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_3, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_1__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_1, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_1__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_1__UImm51_0
  { CVT_regX0, 0, CVT_imm_95_1, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_1__UImm51_1
  { CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR161_0__GPRAsFPR161_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__GPRAsFPR321_0__GPRAsFPR321_1__FRMArg1_2
  { CVT_95_addRegOperands, 1, CVT_95_addRegOperands, 2, CVT_95_addFRMArgOperands_95_defaultFRMArgOp, 3, CVT_Done },
  // Convert__regX0__imm_95_2__Reg1_0
  { CVT_regX0, 0, CVT_imm_95_2, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_2__Reg1_1
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__imm_95_2__UImm51_0
  { CVT_regX0, 0, CVT_imm_95_2, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__imm_95_2__UImm51_1
  { CVT_95_Reg, 1, CVT_imm_95_2, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__regX0
  { CVT_regX0, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__regX0
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_Done },
  // Convert__regX0__SImm21Lsb0JAL1_0
  { CVT_regX0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regX1__SImm21Lsb0JAL1_0
  { CVT_regX1, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__SImm21Lsb0JAL1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX1__Reg1_0__imm_95_0
  { CVT_regX1, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX1__Reg1_0__SImm121_1
  { CVT_regX1, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX1__Reg1_1__imm_95_0
  { CVT_regX1, 0, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX1__Reg1_2__SImm121_0
  { CVT_regX1, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__regX0__Reg1_0__imm_95_0
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX0__Reg1_0__SImm121_1
  { CVT_regX0, 0, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__Reg1_1__imm_95_0
  { CVT_regX0, 0, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__regX0__Reg1_2__SImm121_0
  { CVT_regX0, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__PseudoJumpSymbol1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__BareSymbol1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmXLenLI_Restricted1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__regX0__SImm121_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmXLenLI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__regX0__UImm201_0
  { CVT_regX0, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__UImm20LUI1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb0001_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 5, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb001_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 5, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__regX0__Reg1_1
  { CVT_95_Reg, 1, CVT_regX0, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__regX0__regX0__imm_95_0
  { CVT_regX0, 0, CVT_regX0, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_Done },
  // Convert__regX0__regX0__regX5
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX5, 0, CVT_Done },
  // Convert__regX0__regX0__regX2
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX2, 0, CVT_Done },
  // Convert__regX0__regX0__regX3
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX3, 0, CVT_Done },
  // Convert__regX0__regX0__regX4
  { CVT_regX0, 0, CVT_regX0, 0, CVT_regX4, 0, CVT_Done },
  // Convert__imm_95_1__imm_95_0
  { CVT_imm_95_1, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__SImm12Lsb000001_0
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__UImm101_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__UImm51_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__SImm261_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__SImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2
  { CVT_95_Reg, 1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2
  { CVT_95_Reg, 1, CVT_95_Reg, 5, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm121_2
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__SImm51_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__UImm5GT31_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm111_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm51_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm41_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm6Lsb01_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_3__UImm5Lsb01_1
  { CVT_95_Reg, 1, CVT_95_Reg, 4, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__imm_95_3072__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3072, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3200__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3200, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3074__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3074, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3202__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3202, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3073__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3073, 0, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__imm_95_3201__regX0
  { CVT_95_Reg, 1, CVT_imm_95_3201, 0, CVT_regX0, 0, CVT_Done },
  // Convert__regX0__regX1__imm_95_0
  { CVT_regX0, 0, CVT_regX1, 0, CVT_imm_95_0, 0, CVT_Done },
  // Convert__ZeroOffsetMemOpOperand1_1__Reg1_0
  { CVT_95_addRegOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__regX0
  { CVT_regX0, 0, CVT_Done },
  // Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Tied, Tie0_2_2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3
  { CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, Tie1_3_3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addImmOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, Tie0_3_3, CVT_95_addImmOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_Tied, Tie0_1_1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__RVVMaskRegOpOperand1_1
  { CVT_95_Reg, 1, CVT_95_addRegOperands_95_defaultMaskRegOp, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_addRegOperands, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm51_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_0__Reg1_0
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__SImm51_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_regX0, 0, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_reg0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95__MINUS_1, 0, CVT_95_addRegOperands_95_defaultMaskRegOp, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addRegOperands_95_defaultMaskRegOp, 4, CVT_Done },
  // Convert__Reg1_0__UImm51_1__VTypeI101_2
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__VTypeI111_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addVTypeIOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__imm_95_255
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_imm_95_255, 0, CVT_Done },
};

void RISCVAsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands,
                const SmallBitVector &OptionalOperandsMask,
                ArrayRef<unsigned> DefaultsOffset) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p += 2) {
    unsigned OpIdx = *(p + 1) - DefaultsOffset[*(p + 1)];
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied: {
      assert(*(p + 1) < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned TiedResOpnd = TiedAsmOperandTable[*(p + 1)][0];
      if (TiedResOpnd != (uint8_t)-1)
        Inst.addOperand(Inst.getOperand(TiedResOpnd));
      break;
    }
    case CVT_95_addImmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addImmOperands(Inst, 1);
      break;
    case CVT_95_addRegOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_95_Reg:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      break;
    case CVT_regX0:
      Inst.addOperand(MCOperand::createReg(RISCV::X0));
      break;
    case CVT_regX5:
      Inst.addOperand(MCOperand::createReg(RISCV::X5));
      break;
    case CVT_regX2:
      Inst.addOperand(MCOperand::createReg(RISCV::X2));
      break;
    case CVT_regX3:
      Inst.addOperand(MCOperand::createReg(RISCV::X3));
      break;
    case CVT_regX4:
      Inst.addOperand(MCOperand::createReg(RISCV::X4));
      break;
    case CVT_95_addRlistOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRlistOperands(Inst, 1);
      break;
    case CVT_95_addSpimmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addSpimmOperands(Inst, 1);
      break;
    case CVT_95_addCSRSystemRegisterOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addCSRSystemRegisterOperands(Inst, 1);
      break;
    case CVT_95_addRegRegOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegRegOperands(Inst, 2);
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultFRMArgOp()->addFRMArgOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      }
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultFRMArgLegacyOp()->addFRMArgOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      }
      break;
    case CVT_95_addFRMArgOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFRMArgOperands(Inst, 1);
      break;
    case CVT_imm_95_15:
      Inst.addOperand(MCOperand::createImm(15));
      break;
    case CVT_95_addFenceArgOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFenceArgOperands(Inst, 1);
      break;
    case CVT_95_addFPImmOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addFPImmOperands(Inst, 1);
      break;
    case CVT_imm_95_3:
      Inst.addOperand(MCOperand::createImm(3));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_2:
      Inst.addOperand(MCOperand::createImm(2));
      break;
    case CVT_regX1:
      Inst.addOperand(MCOperand::createReg(RISCV::X1));
      break;
    case CVT_imm_95__MINUS_1:
      Inst.addOperand(MCOperand::createImm(-1));
      break;
    case CVT_imm_95_3072:
      Inst.addOperand(MCOperand::createImm(3072));
      break;
    case CVT_imm_95_3200:
      Inst.addOperand(MCOperand::createImm(3200));
      break;
    case CVT_imm_95_3074:
      Inst.addOperand(MCOperand::createImm(3074));
      break;
    case CVT_imm_95_3202:
      Inst.addOperand(MCOperand::createImm(3202));
      break;
    case CVT_imm_95_3073:
      Inst.addOperand(MCOperand::createImm(3073));
      break;
    case CVT_imm_95_3201:
      Inst.addOperand(MCOperand::createImm(3201));
      break;
    case CVT_95_addRegOperands_95_defaultMaskRegOp:
      if (OptionalOperandsMask[*(p + 1) - 1]) {
        defaultMaskRegOp()->addRegOperands(Inst, 1);
      } else {
        static_cast<RISCVOperand &>(*Operands[OpIdx]).addRegOperands(Inst, 1);
      }
      break;
    case CVT_reg0:
      Inst.addOperand(MCOperand::createReg(0));
      break;
    case CVT_95_addVTypeIOperands:
      static_cast<RISCVOperand &>(*Operands[OpIdx]).addVTypeIOperands(Inst, 1);
      break;
    case CVT_imm_95_255:
      Inst.addOperand(MCOperand::createImm(255));
      break;
    }
  }
}

void RISCVAsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_regX0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX5:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regX4:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addRlistOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addSpimmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addCSRSystemRegisterOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addRegRegOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands_95_defaultFRMArgLegacyOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFRMArgOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_15:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addFenceArgOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addFPImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_3:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_2:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_regX1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_imm_95__MINUS_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3072:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3200:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3074:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3202:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3073:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_3201:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addRegOperands_95_defaultMaskRegOp:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_reg0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addVTypeIOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_imm_95_255:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  OptionalMatchClass = 1,
  MCK__40_, // '('
  MCK__41_, // ')'
  MCK_LAST_TOKEN = MCK__41_,
  MCK_Reg91, // derived register class
  MCK_Reg88, // derived register class
  MCK_Reg85, // derived register class
  MCK_Reg82, // derived register class
  MCK_Reg79, // derived register class
  MCK_Reg76, // derived register class
  MCK_Reg73, // derived register class
  MCK_Reg70, // derived register class
  MCK_Reg67, // derived register class
  MCK_Reg64, // derived register class
  MCK_Reg61, // derived register class
  MCK_Reg54, // derived register class
  MCK_Reg51, // derived register class
  MCK_Reg48, // derived register class
  MCK_Reg33, // derived register class
  MCK_Reg30, // derived register class
  MCK_Reg28, // derived register class
  MCK_Reg26, // derived register class
  MCK_Reg24, // derived register class
  MCK_GPRX0, // register class 'GPRX0,X0'
  MCK_GPRX1, // register class 'GPRX1'
  MCK_GPRX5, // register class 'GPRX5'
  MCK_GPRX7, // register class 'GPRX7'
  MCK_SP, // register class 'SP'
  MCK_VMV0, // register class 'VMV0'
  MCK_anonymous_9027, // register class 'anonymous_9027'
  MCK_Reg20, // derived register class
  MCK_GPRX1X5, // register class 'GPRX1X5'
  MCK_Reg37, // derived register class
  MCK_VCSR, // register class 'VCSR'
  MCK_VRM8NoV0, // register class 'VRM8NoV0'
  MCK_Reg36, // derived register class
  MCK_GPRPairC, // register class 'GPRPairC'
  MCK_VRM8, // register class 'VRM8'
  MCK_Reg38, // derived register class
  MCK_Reg23, // derived register class
  MCK_VRN2M4NoV0, // register class 'VRN2M4NoV0'
  MCK_Reg32, // derived register class
  MCK_VRM4NoV0, // register class 'VRM4NoV0'
  MCK_VRN2M4, // register class 'VRN2M4'
  MCK_FPR16C, // register class 'FPR16C'
  MCK_FPR32C, // register class 'FPR32C'
  MCK_FPR64C, // register class 'FPR64C'
  MCK_GPRC, // register class 'GPRC'
  MCK_GPRF16C, // register class 'GPRF16C'
  MCK_GPRF32C, // register class 'GPRF32C'
  MCK_SR07, // register class 'SR07'
  MCK_VRM4, // register class 'VRM4'
  MCK_Reg35, // derived register class
  MCK_VRN4M2NoV0, // register class 'VRN4M2NoV0'
  MCK_Reg31, // derived register class
  MCK_GPRTCNonX7, // register class 'GPRTCNonX7'
  MCK_VRN3M2NoV0, // register class 'VRN3M2NoV0'
  MCK_VRN4M2, // register class 'VRN4M2'
  MCK_Reg29, // derived register class
  MCK_GPRTC, // register class 'GPRTC'
  MCK_VRN2M2NoV0, // register class 'VRN2M2NoV0'
  MCK_VRN3M2, // register class 'VRN3M2'
  MCK_GPRPairNoX0, // register class 'GPRPairNoX0'
  MCK_VRM2NoV0, // register class 'VRM2NoV0'
  MCK_VRN2M2, // register class 'VRN2M2'
  MCK_GPRPair, // register class 'GPRPair'
  MCK_VRM2, // register class 'VRM2'
  MCK_VRN8M1NoV0, // register class 'VRN8M1NoV0'
  MCK_GPRJALRNonX7, // register class 'GPRJALRNonX7'
  MCK_VRN7M1NoV0, // register class 'VRN7M1NoV0'
  MCK_VRN8M1, // register class 'VRN8M1'
  MCK_GPRJALR, // register class 'GPRJALR'
  MCK_VRN6M1NoV0, // register class 'VRN6M1NoV0'
  MCK_VRN7M1, // register class 'VRN7M1'
  MCK_VRN5M1NoV0, // register class 'VRN5M1NoV0'
  MCK_VRN6M1, // register class 'VRN6M1'
  MCK_VRN4M1NoV0, // register class 'VRN4M1NoV0'
  MCK_VRN5M1, // register class 'VRN5M1'
  MCK_VRN3M1NoV0, // register class 'VRN3M1NoV0'
  MCK_VRN4M1, // register class 'VRN4M1'
  MCK_GPRNoX0X2, // register class 'GPRNoX0X2'
  MCK_VRN2M1NoV0, // register class 'VRN2M1NoV0'
  MCK_VRN3M1, // register class 'VRN3M1'
  MCK_GPRF16NoX0, // register class 'GPRF16NoX0'
  MCK_GPRF32NoX0, // register class 'GPRF32NoX0'
  MCK_GPRNoX0, // register class 'GPRNoX0'
  MCK_VRN2M1, // register class 'VRN2M1'
  MCK_VRNoV0, // register class 'VRNoV0'
  MCK_FPR16, // register class 'FPR16'
  MCK_FPR32, // register class 'FPR32'
  MCK_FPR64, // register class 'FPR64'
  MCK_GPR, // register class 'GPR'
  MCK_GPRF16, // register class 'GPRF16'
  MCK_GPRF32, // register class 'GPRF32'
  MCK_VM, // register class 'VM,VR'
  MCK_GPRAll, // register class 'GPRAll'
  MCK_LAST_REGISTER = MCK_GPRAll,
  MCK_AnyRegCOperand, // user defined class 'AnyRegCOperand'
  MCK_AnyRegOperand, // user defined class 'AnyRegOperand'
  MCK_BareSymbol, // user defined class 'BareSymbol'
  MCK_CLUIImm, // user defined class 'CLUIImmAsmOperand'
  MCK_CSRSystemRegister, // user defined class 'CSRSystemRegister'
  MCK_RegReg, // user defined class 'CVrrAsmOperand'
  MCK_CallSymbol, // user defined class 'CallSymbol'
  MCK_FRMArg, // user defined class 'FRMArg'
  MCK_FRMArgLegacy, // user defined class 'FRMArgLegacy'
  MCK_FenceArg, // user defined class 'FenceArg'
  MCK_GPRAsFPR16, // user defined class 'GPRAsFPR16'
  MCK_GPRAsFPR32, // user defined class 'GPRAsFPR32'
  MCK_GPRF64AsFPR, // user defined class 'GPRF64AsFPR'
  MCK_GPRPairAsFPR, // user defined class 'GPRPairAsFPR'
  MCK_GPRPairRV32, // user defined class 'GPRPairRV32Operand'
  MCK_GPRPairRV64, // user defined class 'GPRPairRV64Operand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ImmZero, // user defined class 'ImmZeroAsmOperand'
  MCK_InsnCDirectiveOpcode, // user defined class 'InsnCDirectiveOpcode'
  MCK_InsnDirectiveOpcode, // user defined class 'InsnDirectiveOpcode'
  MCK_LoadFPImm, // user defined class 'LoadFPImmOperand'
  MCK_NegStackAdj, // user defined class 'NegStackAdjAsmOperand'
  MCK_PseudoJumpSymbol, // user defined class 'PseudoJumpSymbol'
  MCK_RTZArg, // user defined class 'RTZArg'
  MCK_Rlist, // user defined class 'RlistAsmOperand'
  MCK_RnumArg, // user defined class 'RnumArg'
  MCK_SImm21Lsb0JAL, // user defined class 'Simm21Lsb0JALAsmOperand'
  MCK_StackAdj, // user defined class 'StackAdjAsmOperand'
  MCK_TLSDESCCallSymbol, // user defined class 'TLSDESCCallSymbol'
  MCK_TPRelAddSymbol, // user defined class 'TPRelAddSymbol'
  MCK_UImmLog2XLen, // user defined class 'UImmLog2XLenAsmOperand'
  MCK_UImmLog2XLenNonZero, // user defined class 'UImmLog2XLenNonZeroAsmOperand'
  MCK_RVVMaskRegOpOperand, // user defined class 'VMaskAsmOperand'
  MCK_RVVMaskCarryInRegOpOperand, // user defined class 'VMaskCarryInAsmOperand'
  MCK_ZeroOffsetMemOpOperand, // user defined class 'ZeroOffsetMemOpOperand'
  MCK_VTypeI10, // user defined class 'anonymous_10843'
  MCK_VTypeI11, // user defined class 'anonymous_10844'
  MCK_SImm5, // user defined class 'anonymous_10845'
  MCK_SImm5Plus1, // user defined class 'anonymous_10846'
  MCK_SImm6, // user defined class 'anonymous_48859'
  MCK_SImm6NonZero, // user defined class 'anonymous_48860'
  MCK_UImm7Lsb00, // user defined class 'anonymous_48861'
  MCK_UImm8Lsb00, // user defined class 'anonymous_48862'
  MCK_UImm8Lsb000, // user defined class 'anonymous_48863'
  MCK_SImm9Lsb0, // user defined class 'anonymous_48864'
  MCK_UImm9Lsb000, // user defined class 'anonymous_48865'
  MCK_UImm10Lsb00NonZero, // user defined class 'anonymous_48866'
  MCK_SImm10Lsb0000NonZero, // user defined class 'anonymous_48867'
  MCK_SImm12Lsb0, // user defined class 'anonymous_48868'
  MCK_UImm2Lsb0, // user defined class 'anonymous_48958'
  MCK_UImm8GE32, // user defined class 'anonymous_48959'
  MCK_SImm12Lsb00000, // user defined class 'anonymous_49023'
  MCK_UImm5Lsb0, // user defined class 'anonymous_50713'
  MCK_UImm6Lsb0, // user defined class 'anonymous_50714'
  MCK_UImm5NonZero, // user defined class 'anonymous_50731'
  MCK_UImm5GT3, // user defined class 'anonymous_50732'
  MCK_UImm10, // user defined class 'anonymous_50733'
  MCK_UImm11, // user defined class 'anonymous_50734'
  MCK_SImm26, // user defined class 'anonymous_50735'
  MCK_UImm7Lsb000, // user defined class 'anonymous_50750'
  MCK_UImm1, // user defined class 'anonymous_9356'
  MCK_UImm2, // user defined class 'anonymous_9357'
  MCK_UImm3, // user defined class 'anonymous_9358'
  MCK_UImm4, // user defined class 'anonymous_9359'
  MCK_UImm5, // user defined class 'anonymous_9360'
  MCK_UImm6, // user defined class 'anonymous_9361'
  MCK_UImm7, // user defined class 'anonymous_9362'
  MCK_UImm8, // user defined class 'anonymous_9363'
  MCK_UImm16, // user defined class 'anonymous_9364'
  MCK_UImm32, // user defined class 'anonymous_9365'
  MCK_UImm48, // user defined class 'anonymous_9366'
  MCK_UImm64, // user defined class 'anonymous_9367'
  MCK_SImm12, // user defined class 'anonymous_9368'
  MCK_SImm13Lsb0, // user defined class 'anonymous_9369'
  MCK_UImm20, // user defined class 'anonymous_9370'
  MCK_UImm20LUI, // user defined class 'anonymous_9371'
  MCK_UImm20AUIPC, // user defined class 'anonymous_9372'
  MCK_ImmXLenLI, // user defined class 'anonymous_9373'
  MCK_ImmXLenLI_Restricted, // user defined class 'anonymous_9374'
  NumMatchClassKinds
};

} // end anonymous namespace

static unsigned getDiagKindFromRegisterClass(MatchClassKind RegisterClass) {
  return MCTargetAsmParser::Match_InvalidOperand;
}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 2 strings to match.
    switch (Name[0]) {
    default: break;
    case '(':	 // 1 string to match.
      return MCK__40_;	 // "("
    case ')':	 // 1 string to match.
      return MCK__41_;	 // ")"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  [[maybe_unused]] static constexpr struct {
    uint32_t Offset;
    uint16_t Start;
    uint16_t Length;
  } Table[] = {
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 0, 0},
    {0, 70, 1},
    {1, 73, 1},
    {2, 75, 1},
    {3, 77, 1},
    {4, 57, 1},
    {5, 79, 1},
    {6, 61, 1},
    {7, 82, 1},
    {8, 43, 1},
    {9, 64, 1},
    {10, 86, 1},
    {11, 37, 1},
    {12, 51, 1},
    {13, 66, 1},
    {14, 35, 31},
    {45, 41, 25},
    {70, 58, 8},
    {78, 62, 4},
    {82, 65, 1},
    {83, 91, 5},
    {88, 31, 65},
    {153, 31, 65},
    {218, 59, 37},
    {255, 85, 11},
    {266, 94, 1},
    {267, 0, 0},
    {267, 47, 49},
    {316, 80, 16},
    {332, 36, 30},
    {362, 0, 0},
    {362, 37, 1},
    {363, 52, 14},
    {377, 52, 14},
    {391, 0, 0},
    {391, 41, 25},
    {416, 47, 49},
    {465, 43, 1},
    {466, 54, 12},
    {478, 51, 1},
    {479, 0, 0},
    {479, 88, 1},
    {480, 89, 1},
    {481, 90, 1},
    {482, 68, 28},
    {510, 83, 10},
    {520, 84, 10},
    {530, 68, 28},
    {558, 0, 0},
    {558, 54, 12},
    {570, 57, 1},
    {571, 58, 8},
    {579, 59, 37},
    {616, 61, 1},
    {617, 0, 0},
    {617, 62, 4},
    {621, 71, 25},
    {646, 64, 1},
    {647, 0, 0},
    {647, 65, 1},
    {648, 66, 1},
    {649, 0, 0},
    {649, 0, 0},
    {649, 0, 0},
    {649, 70, 1},
    {650, 71, 25},
    {675, 73, 1},
    {676, 0, 0},
    {676, 80, 16},
    {692, 75, 1},
    {693, 0, 0},
    {693, 77, 1},
    {694, 0, 0},
    {694, 79, 1},
    {695, 0, 0},
    {695, 82, 1},
    {696, 0, 0},
    {696, 85, 11},
    {707, 86, 1},
    {708, 0, 0},
    {708, 92, 1},
    {709, 93, 1},
    {710, 91, 5},
    {715, 0, 0},
    {715, 94, 1},
    {716, 0, 0},
    {716, 0, 0},
    {716, 0, 0},
    {716, 95, 1},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 0, 0},
    {717, 1, 1},
    {718, 1, 1},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 0, 0},
    {719, 1, 1},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
    {720, 0, 0},
  };

  static constexpr uint8_t Data[] = {
    0xFF,
    0xFF,
    0x00,
    0x80,
    0x22,
    0x32,
    0x00,
    0x44,
    0x64,
    0x64,
    0x8E,
    0x01,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x42,
    0x10,
    0x03,
    0x00,
    0x00,
    0x00,
    0x00,
    0x00,
    0x84,
    0x20,
    0x06,
    0x40,
    0x80,
    0x10,
    0xC4,
    0x20,
    0x4E,
    0x00,
    0x00,
    0x09,
    0x10,
    0x82,
    0x18,
    0x82,
    0x58,
    0x02,
    0x50,
    0x44,
    0x2E,
    0x22,
    0x8B,
    0xC8,
    0x00,
    0x14,
    0x91,
    0x01,
    0x11,
    0x20,
    0x01,
    0x42,
    0x10,
    0x47,
    0xE4,
    0x27,
    0x40,
    0x08,
    0x62,
    0x80,
    0x01,
    0x26,
    0x40,
    0x08,
    0x62,
    0x44,
    0x8E,
    0x0C,
    0x90,
    0x00,
    0x21,
    0x88,
    0x33,
    0x40,
    0x08,
    0xE2,
    0x07,
    0x08,
    0x41,
    0x1C,
    0x82,
    0xF8,
    0x41,
    0x7C,
    0xFC,
  };

  auto &Entry = Table[A];
  unsigned Idx = B - Entry.Start;
  if (Idx >= Entry.Length)
    return false;
  Idx += Entry.Offset;
  return (Data[Idx / 8] >> (Idx % 8)) & 1;
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  RISCVOperand &Operand = (RISCVOperand &)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken() && Kind <= MCK_LAST_TOKEN)
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  switch (Kind) {
  default: break;
  case MCK_AnyRegCOperand: {
    DiagnosticPredicate DP(Operand.isAnyRegC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_AnyRegOperand: {
    DiagnosticPredicate DP(Operand.isAnyReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_BareSymbol: {
    DiagnosticPredicate DP(Operand.isBareSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidBareSymbol;
    break;
  }
  case MCK_CLUIImm: {
    DiagnosticPredicate DP(Operand.isCLUIImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCLUIImm;
    break;
  }
  case MCK_CSRSystemRegister: {
    DiagnosticPredicate DP(Operand.isCSRSystemRegister());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCSRSystemRegister;
    break;
  }
  case MCK_RegReg: {
    DiagnosticPredicate DP(Operand.isRegReg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRegReg;
    break;
  }
  case MCK_CallSymbol: {
    DiagnosticPredicate DP(Operand.isCallSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidCallSymbol;
    break;
  }
  case MCK_FRMArg: {
    DiagnosticPredicate DP(Operand.isFRMArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FRMArgLegacy: {
    DiagnosticPredicate DP(Operand.isFRMArgLegacy());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_FenceArg: {
    DiagnosticPredicate DP(Operand.isFenceArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRAsFPR16: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRAsFPR32: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRF64AsFPR: {
    DiagnosticPredicate DP(Operand.isGPRAsFPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRPairAsFPR: {
    DiagnosticPredicate DP(Operand.isGPRPairAsFPR64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRPairRV32: {
    DiagnosticPredicate DP(Operand.isGPRPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_GPRPairRV64: {
    DiagnosticPredicate DP(Operand.isGPRPair());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_Imm: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_ImmZero: {
    DiagnosticPredicate DP(Operand.isImmZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmZero;
    break;
  }
  case MCK_InsnCDirectiveOpcode: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_InsnDirectiveOpcode: {
    DiagnosticPredicate DP(Operand.isImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_LoadFPImm: {
    DiagnosticPredicate DP(Operand.isLoadFPImm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidLoadFPImm;
    break;
  }
  case MCK_NegStackAdj: {
    DiagnosticPredicate DP(Operand.isSpimm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidStackAdj;
    break;
  }
  case MCK_PseudoJumpSymbol: {
    DiagnosticPredicate DP(Operand.isPseudoJumpSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidPseudoJumpSymbol;
    break;
  }
  case MCK_RTZArg: {
    DiagnosticPredicate DP(Operand.isRTZArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRTZArg;
    break;
  }
  case MCK_Rlist: {
    DiagnosticPredicate DP(Operand.isRlist());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRlist;
    break;
  }
  case MCK_RnumArg: {
    DiagnosticPredicate DP(Operand.isRnumArg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidRnumArg;
    break;
  }
  case MCK_SImm21Lsb0JAL: {
    DiagnosticPredicate DP(Operand.isSImm21Lsb0JAL());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm21Lsb0JAL;
    break;
  }
  case MCK_StackAdj: {
    DiagnosticPredicate DP(Operand.isSpimm());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidStackAdj;
    break;
  }
  case MCK_TLSDESCCallSymbol: {
    DiagnosticPredicate DP(Operand.isTLSDESCCallSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidTLSDESCCallSymbol;
    break;
  }
  case MCK_TPRelAddSymbol: {
    DiagnosticPredicate DP(Operand.isTPRelAddSymbol());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidTPRelAddSymbol;
    break;
  }
  case MCK_UImmLog2XLen: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLen());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLen;
    break;
  }
  case MCK_UImmLog2XLenNonZero: {
    DiagnosticPredicate DP(Operand.isUImmLog2XLenNonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImmLog2XLenNonZero;
    break;
  }
  case MCK_RVVMaskRegOpOperand: {
    DiagnosticPredicate DP(Operand.isV0Reg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVMaskRegister;
    break;
  }
  case MCK_RVVMaskCarryInRegOpOperand: {
    DiagnosticPredicate DP(Operand.isV0Reg());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVMaskCarryInRegister;
    break;
  }
  case MCK_ZeroOffsetMemOpOperand: {
    DiagnosticPredicate DP(Operand.isGPR());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    break;
  }
  case MCK_VTypeI10: {
    DiagnosticPredicate DP(Operand.isVTypeI10());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVTypeI;
    break;
  }
  case MCK_VTypeI11: {
    DiagnosticPredicate DP(Operand.isVTypeI11());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidVTypeI;
    break;
  }
  case MCK_SImm5: {
    DiagnosticPredicate DP(Operand.isSImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5;
    break;
  }
  case MCK_SImm5Plus1: {
    DiagnosticPredicate DP(Operand.isSImm5Plus1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm5Plus1;
    break;
  }
  case MCK_SImm6: {
    DiagnosticPredicate DP(Operand.isSImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm6;
    break;
  }
  case MCK_SImm6NonZero: {
    DiagnosticPredicate DP(Operand.isSImm6NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm6NonZero;
    break;
  }
  case MCK_UImm7Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm7Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7Lsb00;
    break;
  }
  case MCK_UImm8Lsb00: {
    DiagnosticPredicate DP(Operand.isUImm8Lsb00());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8Lsb00;
    break;
  }
  case MCK_UImm8Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm8Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8Lsb000;
    break;
  }
  case MCK_SImm9Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm9Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm9Lsb0;
    break;
  }
  case MCK_UImm9Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm9Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm9Lsb000;
    break;
  }
  case MCK_UImm10Lsb00NonZero: {
    DiagnosticPredicate DP(Operand.isUImm10Lsb00NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm10Lsb00NonZero;
    break;
  }
  case MCK_SImm10Lsb0000NonZero: {
    DiagnosticPredicate DP(Operand.isSImm10Lsb0000NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm10Lsb0000NonZero;
    break;
  }
  case MCK_SImm12Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm12Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12Lsb0;
    break;
  }
  case MCK_UImm2Lsb0: {
    DiagnosticPredicate DP(Operand.isUImm2Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm2Lsb0;
    break;
  }
  case MCK_UImm8GE32: {
    DiagnosticPredicate DP(Operand.isUImm8GE32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8GE32;
    break;
  }
  case MCK_SImm12Lsb00000: {
    DiagnosticPredicate DP(Operand.isSImm12Lsb00000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12Lsb00000;
    break;
  }
  case MCK_UImm5Lsb0: {
    DiagnosticPredicate DP(Operand.isUImm5Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5Lsb0;
    break;
  }
  case MCK_UImm6Lsb0: {
    DiagnosticPredicate DP(Operand.isUImm6Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm6Lsb0;
    break;
  }
  case MCK_UImm5NonZero: {
    DiagnosticPredicate DP(Operand.isUImm5NonZero());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5NonZero;
    break;
  }
  case MCK_UImm5GT3: {
    DiagnosticPredicate DP(Operand.isUImm5GT3());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5GT3;
    break;
  }
  case MCK_UImm10: {
    DiagnosticPredicate DP(Operand.isUImm10());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm10;
    break;
  }
  case MCK_UImm11: {
    DiagnosticPredicate DP(Operand.isUImm11());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm11;
    break;
  }
  case MCK_SImm26: {
    DiagnosticPredicate DP(Operand.isSImm26());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm26;
    break;
  }
  case MCK_UImm7Lsb000: {
    DiagnosticPredicate DP(Operand.isUImm7Lsb000());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7Lsb000;
    break;
  }
  case MCK_UImm1: {
    DiagnosticPredicate DP(Operand.isUImm1());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm1;
    break;
  }
  case MCK_UImm2: {
    DiagnosticPredicate DP(Operand.isUImm2());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm2;
    break;
  }
  case MCK_UImm3: {
    DiagnosticPredicate DP(Operand.isUImm3());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm3;
    break;
  }
  case MCK_UImm4: {
    DiagnosticPredicate DP(Operand.isUImm4());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm4;
    break;
  }
  case MCK_UImm5: {
    DiagnosticPredicate DP(Operand.isUImm5());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm5;
    break;
  }
  case MCK_UImm6: {
    DiagnosticPredicate DP(Operand.isUImm6());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm6;
    break;
  }
  case MCK_UImm7: {
    DiagnosticPredicate DP(Operand.isUImm7());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm7;
    break;
  }
  case MCK_UImm8: {
    DiagnosticPredicate DP(Operand.isUImm8());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm8;
    break;
  }
  case MCK_UImm16: {
    DiagnosticPredicate DP(Operand.isUImm16());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm16;
    break;
  }
  case MCK_UImm32: {
    DiagnosticPredicate DP(Operand.isUImm32());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm32;
    break;
  }
  case MCK_UImm48: {
    DiagnosticPredicate DP(Operand.isUImm48());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm48;
    break;
  }
  case MCK_UImm64: {
    DiagnosticPredicate DP(Operand.isUImm64());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm64;
    break;
  }
  case MCK_SImm12: {
    DiagnosticPredicate DP(Operand.isSImm12());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm12;
    break;
  }
  case MCK_SImm13Lsb0: {
    DiagnosticPredicate DP(Operand.isSImm13Lsb0());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidSImm13Lsb0;
    break;
  }
  case MCK_UImm20: {
    DiagnosticPredicate DP(Operand.isUImm20());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20;
    break;
  }
  case MCK_UImm20LUI: {
    DiagnosticPredicate DP(Operand.isUImm20LUI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20LUI;
    break;
  }
  case MCK_UImm20AUIPC: {
    DiagnosticPredicate DP(Operand.isUImm20AUIPC());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidUImm20AUIPC;
    break;
  }
  case MCK_ImmXLenLI: {
    DiagnosticPredicate DP(Operand.isImmXLenLI());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmXLenLI;
    break;
  }
  case MCK_ImmXLenLI_Restricted: {
    DiagnosticPredicate DP(Operand.isImmXLenLI_Restricted());
    if (DP.isMatch())
      return MCTargetAsmParser::Match_Success;
    if (DP.isNearMatch())
      return RISCVAsmParser::Match_InvalidImmXLenLI_Restricted;
    break;
  }
  } // end switch (Kind)

  if (Operand.isReg()) {
    static constexpr uint16_t Table[RISCV::NUM_TARGET_REGS] = {
      InvalidMatchClass,
      InvalidMatchClass,
      InvalidMatchClass,
      MCK_anonymous_9027,
      InvalidMatchClass,
      MCK_VCSR,
      MCK_VCSR,
      MCK_VCSR,
      InvalidMatchClass,
      InvalidMatchClass,
      MCK_GPRAll,
      MCK_VMV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_VRNoV0,
      MCK_GPRX0,
      MCK_GPRX1,
      MCK_SP,
      MCK_GPRNoX0X2,
      MCK_GPRNoX0X2,
      MCK_GPRX5,
      MCK_GPRTCNonX7,
      MCK_GPRX7,
      MCK_Reg20,
      MCK_Reg20,
      MCK_Reg23,
      MCK_Reg23,
      MCK_Reg23,
      MCK_Reg23,
      MCK_Reg23,
      MCK_Reg23,
      MCK_GPRTCNonX7,
      MCK_GPRTCNonX7,
      MCK_SR07,
      MCK_SR07,
      MCK_SR07,
      MCK_SR07,
      MCK_SR07,
      MCK_SR07,
      MCK_GPRJALRNonX7,
      MCK_GPRJALRNonX7,
      MCK_GPRJALRNonX7,
      MCK_GPRJALRNonX7,
      MCK_GPRTCNonX7,
      MCK_GPRTCNonX7,
      MCK_GPRTCNonX7,
      MCK_GPRTCNonX7,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64C,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR64,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32C,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR32,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16C,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_FPR16,
      MCK_GPRF16,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16C,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_GPRF16NoX0,
      MCK_Reg24,
      MCK_GPRF32,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32C,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_GPRF32NoX0,
      MCK_Reg48,
      MCK_Reg51,
      MCK_Reg54,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM8NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM8NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM8NoV0,
      MCK_VRM2NoV0,
      MCK_VRM2NoV0,
      MCK_VRM4NoV0,
      MCK_VRM2NoV0,
      MCK_Reg26,
      MCK_Reg28,
      MCK_Reg30,
      MCK_Reg33,
      MCK_Reg37,
      MCK_Reg37,
      MCK_Reg37,
      MCK_Reg38,
      MCK_Reg36,
      MCK_Reg36,
      MCK_Reg36,
      MCK_Reg35,
      MCK_Reg35,
      MCK_Reg38,
      MCK_Reg38,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_VRN2M1NoV0,
      MCK_Reg61,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_VRN2M2NoV0,
      MCK_Reg64,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_VRN2M4NoV0,
      MCK_Reg67,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_VRN3M1NoV0,
      MCK_Reg70,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_VRN3M2NoV0,
      MCK_Reg73,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_VRN4M1NoV0,
      MCK_Reg76,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_VRN4M2NoV0,
      MCK_Reg79,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_VRN5M1NoV0,
      MCK_Reg82,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_VRN6M1NoV0,
      MCK_Reg85,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_VRN7M1NoV0,
      MCK_Reg88,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_VRN8M1NoV0,
      MCK_Reg91,
    };

    MCRegister Reg = Operand.getReg();
    MatchClassKind OpKind = Reg.isPhysical() ? (MatchClassKind)Table[Reg.id()] : InvalidMatchClass;
    return isSubclass(OpKind, Kind) ? (unsigned)MCTargetAsmParser::Match_Success :
                                      getDiagKindFromRegisterClass(Kind);
  }

  if (Kind > MCK_LAST_TOKEN && Kind <= MCK_LAST_REGISTER)
    return getDiagKindFromRegisterClass(Kind);

  return MCTargetAsmParser::Match_InvalidOperand;
}

#ifndef NDEBUG
const char *getMatchClassName(MatchClassKind Kind) {
  switch (Kind) {
  case InvalidMatchClass: return "InvalidMatchClass";
  case OptionalMatchClass: return "OptionalMatchClass";
  case MCK__40_: return "MCK__40_";
  case MCK__41_: return "MCK__41_";
  case MCK_Reg91: return "MCK_Reg91";
  case MCK_Reg88: return "MCK_Reg88";
  case MCK_Reg85: return "MCK_Reg85";
  case MCK_Reg82: return "MCK_Reg82";
  case MCK_Reg79: return "MCK_Reg79";
  case MCK_Reg76: return "MCK_Reg76";
  case MCK_Reg73: return "MCK_Reg73";
  case MCK_Reg70: return "MCK_Reg70";
  case MCK_Reg67: return "MCK_Reg67";
  case MCK_Reg64: return "MCK_Reg64";
  case MCK_Reg61: return "MCK_Reg61";
  case MCK_Reg54: return "MCK_Reg54";
  case MCK_Reg51: return "MCK_Reg51";
  case MCK_Reg48: return "MCK_Reg48";
  case MCK_Reg33: return "MCK_Reg33";
  case MCK_Reg30: return "MCK_Reg30";
  case MCK_Reg28: return "MCK_Reg28";
  case MCK_Reg26: return "MCK_Reg26";
  case MCK_Reg24: return "MCK_Reg24";
  case MCK_GPRX0: return "MCK_GPRX0";
  case MCK_GPRX1: return "MCK_GPRX1";
  case MCK_GPRX5: return "MCK_GPRX5";
  case MCK_GPRX7: return "MCK_GPRX7";
  case MCK_SP: return "MCK_SP";
  case MCK_VMV0: return "MCK_VMV0";
  case MCK_anonymous_9027: return "MCK_anonymous_9027";
  case MCK_Reg20: return "MCK_Reg20";
  case MCK_GPRX1X5: return "MCK_GPRX1X5";
  case MCK_Reg37: return "MCK_Reg37";
  case MCK_VCSR: return "MCK_VCSR";
  case MCK_VRM8NoV0: return "MCK_VRM8NoV0";
  case MCK_Reg36: return "MCK_Reg36";
  case MCK_GPRPairC: return "MCK_GPRPairC";
  case MCK_VRM8: return "MCK_VRM8";
  case MCK_Reg38: return "MCK_Reg38";
  case MCK_Reg23: return "MCK_Reg23";
  case MCK_VRN2M4NoV0: return "MCK_VRN2M4NoV0";
  case MCK_Reg32: return "MCK_Reg32";
  case MCK_VRM4NoV0: return "MCK_VRM4NoV0";
  case MCK_VRN2M4: return "MCK_VRN2M4";
  case MCK_FPR16C: return "MCK_FPR16C";
  case MCK_FPR32C: return "MCK_FPR32C";
  case MCK_FPR64C: return "MCK_FPR64C";
  case MCK_GPRC: return "MCK_GPRC";
  case MCK_GPRF16C: return "MCK_GPRF16C";
  case MCK_GPRF32C: return "MCK_GPRF32C";
  case MCK_SR07: return "MCK_SR07";
  case MCK_VRM4: return "MCK_VRM4";
  case MCK_Reg35: return "MCK_Reg35";
  case MCK_VRN4M2NoV0: return "MCK_VRN4M2NoV0";
  case MCK_Reg31: return "MCK_Reg31";
  case MCK_GPRTCNonX7: return "MCK_GPRTCNonX7";
  case MCK_VRN3M2NoV0: return "MCK_VRN3M2NoV0";
  case MCK_VRN4M2: return "MCK_VRN4M2";
  case MCK_Reg29: return "MCK_Reg29";
  case MCK_GPRTC: return "MCK_GPRTC";
  case MCK_VRN2M2NoV0: return "MCK_VRN2M2NoV0";
  case MCK_VRN3M2: return "MCK_VRN3M2";
  case MCK_GPRPairNoX0: return "MCK_GPRPairNoX0";
  case MCK_VRM2NoV0: return "MCK_VRM2NoV0";
  case MCK_VRN2M2: return "MCK_VRN2M2";
  case MCK_GPRPair: return "MCK_GPRPair";
  case MCK_VRM2: return "MCK_VRM2";
  case MCK_VRN8M1NoV0: return "MCK_VRN8M1NoV0";
  case MCK_GPRJALRNonX7: return "MCK_GPRJALRNonX7";
  case MCK_VRN7M1NoV0: return "MCK_VRN7M1NoV0";
  case MCK_VRN8M1: return "MCK_VRN8M1";
  case MCK_GPRJALR: return "MCK_GPRJALR";
  case MCK_VRN6M1NoV0: return "MCK_VRN6M1NoV0";
  case MCK_VRN7M1: return "MCK_VRN7M1";
  case MCK_VRN5M1NoV0: return "MCK_VRN5M1NoV0";
  case MCK_VRN6M1: return "MCK_VRN6M1";
  case MCK_VRN4M1NoV0: return "MCK_VRN4M1NoV0";
  case MCK_VRN5M1: return "MCK_VRN5M1";
  case MCK_VRN3M1NoV0: return "MCK_VRN3M1NoV0";
  case MCK_VRN4M1: return "MCK_VRN4M1";
  case MCK_GPRNoX0X2: return "MCK_GPRNoX0X2";
  case MCK_VRN2M1NoV0: return "MCK_VRN2M1NoV0";
  case MCK_VRN3M1: return "MCK_VRN3M1";
  case MCK_GPRF16NoX0: return "MCK_GPRF16NoX0";
  case MCK_GPRF32NoX0: return "MCK_GPRF32NoX0";
  case MCK_GPRNoX0: return "MCK_GPRNoX0";
  case MCK_VRN2M1: return "MCK_VRN2M1";
  case MCK_VRNoV0: return "MCK_VRNoV0";
  case MCK_FPR16: return "MCK_FPR16";
  case MCK_FPR32: return "MCK_FPR32";
  case MCK_FPR64: return "MCK_FPR64";
  case MCK_GPR: return "MCK_GPR";
  case MCK_GPRF16: return "MCK_GPRF16";
  case MCK_GPRF32: return "MCK_GPRF32";
  case MCK_VM: return "MCK_VM";
  case MCK_GPRAll: return "MCK_GPRAll";
  case MCK_AnyRegCOperand: return "MCK_AnyRegCOperand";
  case MCK_AnyRegOperand: return "MCK_AnyRegOperand";
  case MCK_BareSymbol: return "MCK_BareSymbol";
  case MCK_CLUIImm: return "MCK_CLUIImm";
  case MCK_CSRSystemRegister: return "MCK_CSRSystemRegister";
  case MCK_RegReg: return "MCK_RegReg";
  case MCK_CallSymbol: return "MCK_CallSymbol";
  case MCK_FRMArg: return "MCK_FRMArg";
  case MCK_FRMArgLegacy: return "MCK_FRMArgLegacy";
  case MCK_FenceArg: return "MCK_FenceArg";
  case MCK_GPRAsFPR16: return "MCK_GPRAsFPR16";
  case MCK_GPRAsFPR32: return "MCK_GPRAsFPR32";
  case MCK_GPRF64AsFPR: return "MCK_GPRF64AsFPR";
  case MCK_GPRPairAsFPR: return "MCK_GPRPairAsFPR";
  case MCK_GPRPairRV32: return "MCK_GPRPairRV32";
  case MCK_GPRPairRV64: return "MCK_GPRPairRV64";
  case MCK_Imm: return "MCK_Imm";
  case MCK_ImmZero: return "MCK_ImmZero";
  case MCK_InsnCDirectiveOpcode: return "MCK_InsnCDirectiveOpcode";
  case MCK_InsnDirectiveOpcode: return "MCK_InsnDirectiveOpcode";
  case MCK_LoadFPImm: return "MCK_LoadFPImm";
  case MCK_NegStackAdj: return "MCK_NegStackAdj";
  case MCK_PseudoJumpSymbol: return "MCK_PseudoJumpSymbol";
  case MCK_RTZArg: return "MCK_RTZArg";
  case MCK_Rlist: return "MCK_Rlist";
  case MCK_RnumArg: return "MCK_RnumArg";
  case MCK_SImm21Lsb0JAL: return "MCK_SImm21Lsb0JAL";
  case MCK_StackAdj: return "MCK_StackAdj";
  case MCK_TLSDESCCallSymbol: return "MCK_TLSDESCCallSymbol";
  case MCK_TPRelAddSymbol: return "MCK_TPRelAddSymbol";
  case MCK_UImmLog2XLen: return "MCK_UImmLog2XLen";
  case MCK_UImmLog2XLenNonZero: return "MCK_UImmLog2XLenNonZero";
  case MCK_RVVMaskRegOpOperand: return "MCK_RVVMaskRegOpOperand";
  case MCK_RVVMaskCarryInRegOpOperand: return "MCK_RVVMaskCarryInRegOpOperand";
  case MCK_ZeroOffsetMemOpOperand: return "MCK_ZeroOffsetMemOpOperand";
  case MCK_VTypeI10: return "MCK_VTypeI10";
  case MCK_VTypeI11: return "MCK_VTypeI11";
  case MCK_SImm5: return "MCK_SImm5";
  case MCK_SImm5Plus1: return "MCK_SImm5Plus1";
  case MCK_SImm6: return "MCK_SImm6";
  case MCK_SImm6NonZero: return "MCK_SImm6NonZero";
  case MCK_UImm7Lsb00: return "MCK_UImm7Lsb00";
  case MCK_UImm8Lsb00: return "MCK_UImm8Lsb00";
  case MCK_UImm8Lsb000: return "MCK_UImm8Lsb000";
  case MCK_SImm9Lsb0: return "MCK_SImm9Lsb0";
  case MCK_UImm9Lsb000: return "MCK_UImm9Lsb000";
  case MCK_UImm10Lsb00NonZero: return "MCK_UImm10Lsb00NonZero";
  case MCK_SImm10Lsb0000NonZero: return "MCK_SImm10Lsb0000NonZero";
  case MCK_SImm12Lsb0: return "MCK_SImm12Lsb0";
  case MCK_UImm2Lsb0: return "MCK_UImm2Lsb0";
  case MCK_UImm8GE32: return "MCK_UImm8GE32";
  case MCK_SImm12Lsb00000: return "MCK_SImm12Lsb00000";
  case MCK_UImm5Lsb0: return "MCK_UImm5Lsb0";
  case MCK_UImm6Lsb0: return "MCK_UImm6Lsb0";
  case MCK_UImm5NonZero: return "MCK_UImm5NonZero";
  case MCK_UImm5GT3: return "MCK_UImm5GT3";
  case MCK_UImm10: return "MCK_UImm10";
  case MCK_UImm11: return "MCK_UImm11";
  case MCK_SImm26: return "MCK_SImm26";
  case MCK_UImm7Lsb000: return "MCK_UImm7Lsb000";
  case MCK_UImm1: return "MCK_UImm1";
  case MCK_UImm2: return "MCK_UImm2";
  case MCK_UImm3: return "MCK_UImm3";
  case MCK_UImm4: return "MCK_UImm4";
  case MCK_UImm5: return "MCK_UImm5";
  case MCK_UImm6: return "MCK_UImm6";
  case MCK_UImm7: return "MCK_UImm7";
  case MCK_UImm8: return "MCK_UImm8";
  case MCK_UImm16: return "MCK_UImm16";
  case MCK_UImm32: return "MCK_UImm32";
  case MCK_UImm48: return "MCK_UImm48";
  case MCK_UImm64: return "MCK_UImm64";
  case MCK_SImm12: return "MCK_SImm12";
  case MCK_SImm13Lsb0: return "MCK_SImm13Lsb0";
  case MCK_UImm20: return "MCK_UImm20";
  case MCK_UImm20LUI: return "MCK_UImm20LUI";
  case MCK_UImm20AUIPC: return "MCK_UImm20AUIPC";
  case MCK_ImmXLenLI: return "MCK_ImmXLenLI";
  case MCK_ImmXLenLI_Restricted: return "MCK_ImmXLenLI_Restricted";
  case NumMatchClassKinds: return "NumMatchClassKinds";
  }
  llvm_unreachable("unhandled MatchClassKind!");
}

#endif // NDEBUG
FeatureBitset RISCVAsmParser::
ComputeAvailableFeatures(const FeatureBitset &FB) const {
  FeatureBitset Features;
  if (FB[RISCV::FeatureStdExtZicbom])
    Features.set(Feature_HasStdExtZicbomBit);
  if (FB[RISCV::FeatureStdExtZicbop])
    Features.set(Feature_HasStdExtZicbopBit);
  if (FB[RISCV::FeatureStdExtZicboz])
    Features.set(Feature_HasStdExtZicbozBit);
  if (FB[RISCV::FeatureStdExtZicsr])
    Features.set(Feature_HasStdExtZicsrBit);
  if (FB[RISCV::FeatureStdExtZicond])
    Features.set(Feature_HasStdExtZicondBit);
  if (FB[RISCV::FeatureStdExtZifencei])
    Features.set(Feature_HasStdExtZifenceiBit);
  if (FB[RISCV::FeatureStdExtZihintpause])
    Features.set(Feature_HasStdExtZihintpauseBit);
  if (FB[RISCV::FeatureStdExtZihintntl])
    Features.set(Feature_HasStdExtZihintntlBit);
  if (FB[RISCV::FeatureStdExtZimop])
    Features.set(Feature_HasStdExtZimopBit);
  if (FB[RISCV::FeatureStdExtZicfilp])
    Features.set(Feature_HasStdExtZicfilpBit);
  if (!FB[RISCV::FeatureStdExtZicfilp])
    Features.set(Feature_NoStdExtZicfilpBit);
  if (FB[RISCV::FeatureStdExtZicfiss])
    Features.set(Feature_HasStdExtZicfissBit);
  if (FB[RISCV::FeatureStdExtZmmul])
    Features.set(Feature_HasStdExtZmmulBit);
  if (FB[RISCV::FeatureStdExtM])
    Features.set(Feature_HasStdExtMBit);
  if (FB[RISCV::FeatureStdExtZaamo])
    Features.set(Feature_HasStdExtZaamoBit);
  if (FB[RISCV::FeatureStdExtZalrsc])
    Features.set(Feature_HasStdExtZalrscBit);
  if (FB[RISCV::FeatureStdExtA])
    Features.set(Feature_HasStdExtABit);
  if (FB[RISCV::FeatureStdExtZtso])
    Features.set(Feature_HasStdExtZtsoBit);
  if (FB[RISCV::FeatureStdExtZabha])
    Features.set(Feature_HasStdExtZabhaBit);
  if (FB[RISCV::FeatureStdExtZacas])
    Features.set(Feature_HasStdExtZacasBit);
  if (FB[RISCV::FeatureStdExtZalasr])
    Features.set(Feature_HasStdExtZalasrBit);
  if (FB[RISCV::FeatureStdExtZawrs])
    Features.set(Feature_HasStdExtZawrsBit);
  if (FB[RISCV::FeatureStdExtF])
    Features.set(Feature_HasStdExtFBit);
  if (FB[RISCV::FeatureStdExtD])
    Features.set(Feature_HasStdExtDBit);
  if (FB[RISCV::FeatureStdExtZfhmin])
    Features.set(Feature_HasStdExtZfhminBit);
  if (FB[RISCV::FeatureStdExtZfh])
    Features.set(Feature_HasStdExtZfhBit);
  if (FB[RISCV::FeatureStdExtZfbfmin])
    Features.set(Feature_HasStdExtZfbfminBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZfhmin] || FB[RISCV::FeatureStdExtZfbfmin])
    Features.set(Feature_HasHalfFPLoadStoreMoveBit);
  if (FB[RISCV::FeatureStdExtZfa])
    Features.set(Feature_HasStdExtZfaBit);
  if (FB[RISCV::FeatureStdExtZfinx])
    Features.set(Feature_HasStdExtZfinxBit);
  if (FB[RISCV::FeatureStdExtF] || FB[RISCV::FeatureStdExtZfinx])
    Features.set(Feature_HasStdExtFOrZfinxBit);
  if (FB[RISCV::FeatureStdExtZdinx])
    Features.set(Feature_HasStdExtZdinxBit);
  if (FB[RISCV::FeatureStdExtZhinxmin])
    Features.set(Feature_HasStdExtZhinxminBit);
  if (FB[RISCV::FeatureStdExtZhinx])
    Features.set(Feature_HasStdExtZhinxBit);
  if (FB[RISCV::FeatureStdExtC])
    Features.set(Feature_HasStdExtCBit);
  if (!FB[RISCV::FeatureNoRVCHints])
    Features.set(Feature_HasRVCHintsBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZca])
    Features.set(Feature_HasStdExtCOrZcaBit);
  if (FB[RISCV::FeatureStdExtZcb])
    Features.set(Feature_HasStdExtZcbBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZcd])
    Features.set(Feature_HasStdExtCOrZcdBit);
  if (FB[RISCV::FeatureStdExtZcmp])
    Features.set(Feature_HasStdExtZcmpBit);
  if (FB[RISCV::FeatureStdExtZcmt])
    Features.set(Feature_HasStdExtZcmtBit);
  if (FB[RISCV::FeatureStdExtC] || FB[RISCV::FeatureStdExtZcf] || FB[RISCV::FeatureStdExtZce])
    Features.set(Feature_HasStdExtCOrZcfOrZceBit);
  if (FB[RISCV::FeatureStdExtZcmop])
    Features.set(Feature_HasStdExtZcmopBit);
  if (FB[RISCV::FeatureStdExtZba])
    Features.set(Feature_HasStdExtZbaBit);
  if (FB[RISCV::FeatureStdExtZbb])
    Features.set(Feature_HasStdExtZbbBit);
  if (!FB[RISCV::FeatureStdExtZbb])
    Features.set(Feature_NoStdExtZbbBit);
  if (FB[RISCV::FeatureStdExtZbc])
    Features.set(Feature_HasStdExtZbcBit);
  if (FB[RISCV::FeatureStdExtZbs])
    Features.set(Feature_HasStdExtZbsBit);
  if (FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_HasStdExtZbkbBit);
  if (!FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_NoStdExtZbkbBit);
  if (FB[RISCV::FeatureStdExtZbkx])
    Features.set(Feature_HasStdExtZbkxBit);
  if (FB[RISCV::FeatureStdExtZbb] || FB[RISCV::FeatureStdExtZbkb])
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (FB[RISCV::FeatureStdExtZbkc])
    Features.set(Feature_HasStdExtZbkcBit);
  if (FB[RISCV::FeatureStdExtZbc] || FB[RISCV::FeatureStdExtZbkc])
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (FB[RISCV::FeatureStdExtZknd])
    Features.set(Feature_HasStdExtZkndBit);
  if (FB[RISCV::FeatureStdExtZkne])
    Features.set(Feature_HasStdExtZkneBit);
  if (FB[RISCV::FeatureStdExtZknd] || FB[RISCV::FeatureStdExtZkne])
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (FB[RISCV::FeatureStdExtZknh])
    Features.set(Feature_HasStdExtZknhBit);
  if (FB[RISCV::FeatureStdExtZksed])
    Features.set(Feature_HasStdExtZksedBit);
  if (FB[RISCV::FeatureStdExtZksh])
    Features.set(Feature_HasStdExtZkshBit);
  if (FB[RISCV::FeatureStdExtZkr])
    Features.set(Feature_HasStdExtZkrBit);
  if (FB[RISCV::FeatureStdExtZvfbfmin])
    Features.set(Feature_HasStdExtZvfbfminBit);
  if (FB[RISCV::FeatureStdExtZvfbfwma])
    Features.set(Feature_HasStdExtZvfbfwmaBit);
  if (FB[RISCV::FeatureStdExtZfh] || FB[RISCV::FeatureStdExtZvfh])
    Features.set(Feature_HasStdExtZfhOrZvfhBit);
  if (FB[RISCV::FeatureStdExtZvkb])
    Features.set(Feature_HasStdExtZvkbBit);
  if (FB[RISCV::FeatureStdExtZvbb])
    Features.set(Feature_HasStdExtZvbbBit);
  if (FB[RISCV::FeatureStdExtZvbc])
    Features.set(Feature_HasStdExtZvbcBit);
  if (FB[RISCV::FeatureStdExtZvbc] || FB[RISCV::FeatureStdExtZvbc32e])
    Features.set(Feature_HasStdExtZvbcOrZvbc32eBit);
  if (FB[RISCV::FeatureStdExtZvkg])
    Features.set(Feature_HasStdExtZvkgBit);
  if (FB[RISCV::FeatureStdExtZvkgs])
    Features.set(Feature_HasStdExtZvkgsBit);
  if (FB[RISCV::FeatureStdExtZvkned])
    Features.set(Feature_HasStdExtZvknedBit);
  if (FB[RISCV::FeatureStdExtZvknha])
    Features.set(Feature_HasStdExtZvknhaBit);
  if (FB[RISCV::FeatureStdExtZvknhb])
    Features.set(Feature_HasStdExtZvknhbBit);
  if (FB[RISCV::FeatureStdExtZvknha] || FB[RISCV::FeatureStdExtZvknhb])
    Features.set(Feature_HasStdExtZvknhaOrZvknhbBit);
  if (FB[RISCV::FeatureStdExtZvksed])
    Features.set(Feature_HasStdExtZvksedBit);
  if (FB[RISCV::FeatureStdExtZvksh])
    Features.set(Feature_HasStdExtZvkshBit);
  if (FB[RISCV::FeatureStdExtZve32x])
    Features.set(Feature_HasVInstructionsBit);
  if (FB[RISCV::FeatureStdExtZve64x])
    Features.set(Feature_HasVInstructionsI64Bit);
  if (FB[RISCV::FeatureStdExtZve32f])
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (FB[RISCV::FeatureStdExtZvfhmin] || FB[RISCV::FeatureStdExtZvfh])
    Features.set(Feature_HasVInstructionsF16MinimalBit);
  if (FB[RISCV::FeatureStdExtH])
    Features.set(Feature_HasStdExtHBit);
  if (FB[RISCV::FeatureStdExtSmrnmi])
    Features.set(Feature_HasStdExtSmrnmiBit);
  if (FB[RISCV::FeatureStdExtSvinval])
    Features.set(Feature_HasStdExtSvinvalBit);
  if (FB[RISCV::FeatureStdExtSmctr] || FB[RISCV::FeatureStdExtSsctr])
    Features.set(Feature_HasStdExtSmctrOrSsctrBit);
  if (FB[RISCV::FeatureVendorXVentanaCondOps])
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (FB[RISCV::FeatureVendorXTHeadBa])
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (FB[RISCV::FeatureVendorXTHeadBb])
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (FB[RISCV::FeatureVendorXTHeadBs])
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (FB[RISCV::FeatureVendorXTHeadCondMov])
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (FB[RISCV::FeatureVendorXTHeadCmo])
    Features.set(Feature_HasVendorXTHeadCmoBit);
  if (FB[RISCV::FeatureVendorXTHeadFMemIdx])
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (FB[RISCV::FeatureVendorXTHeadMac])
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (FB[RISCV::FeatureVendorXTHeadMemIdx])
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (FB[RISCV::FeatureVendorXTHeadMemPair])
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (FB[RISCV::FeatureVendorXTHeadSync])
    Features.set(Feature_HasVendorXTHeadSyncBit);
  if (FB[RISCV::FeatureVendorXTHeadVdot])
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (FB[RISCV::FeatureVendorXSfvcp])
    Features.set(Feature_HasVendorXSfvcpBit);
  if (FB[RISCV::FeatureVendorXSfvqmaccdod])
    Features.set(Feature_HasVendorXSfvqmaccdodBit);
  if (FB[RISCV::FeatureVendorXSfvqmaccqoq])
    Features.set(Feature_HasVendorXSfvqmaccqoqBit);
  if (FB[RISCV::FeatureVendorXSfvfwmaccqqq])
    Features.set(Feature_HasVendorXSfvfwmaccqqqBit);
  if (FB[RISCV::FeatureVendorXSfvfnrclipxfqf])
    Features.set(Feature_HasVendorXSfvfnrclipxfqfBit);
  if (FB[RISCV::FeatureVendorXSiFivecdiscarddlone])
    Features.set(Feature_HasVendorXSiFivecdiscarddloneBit);
  if (FB[RISCV::FeatureVendorXSiFivecflushdlone])
    Features.set(Feature_HasVendorXSiFivecflushdloneBit);
  if (FB[RISCV::FeatureVendorXSfcease])
    Features.set(Feature_HasVendorXSfceaseBit);
  if (FB[RISCV::FeatureVendorXCVelw])
    Features.set(Feature_HasVendorXCVelwBit);
  if (FB[RISCV::FeatureVendorXCVbitmanip])
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (FB[RISCV::FeatureVendorXCVmac])
    Features.set(Feature_HasVendorXCVmacBit);
  if (FB[RISCV::FeatureVendorXCVmem])
    Features.set(Feature_HasVendorXCVmemBit);
  if (FB[RISCV::FeatureVendorXCValu])
    Features.set(Feature_HasVendorXCValuBit);
  if (FB[RISCV::FeatureVendorXCVsimd])
    Features.set(Feature_HasVendorXCVsimdBit);
  if (FB[RISCV::FeatureVendorXCVbi])
    Features.set(Feature_HasVendorXCVbiBit);
  if (FB[RISCV::FeatureVendorXMIPSCMove])
    Features.set(Feature_HasVendorXMIPSCMoveBit);
  if (FB[RISCV::FeatureVendorXMIPSLSP])
    Features.set(Feature_HasVendorXMIPSLSPBit);
  if (FB[RISCV::FeatureVendorXwchc])
    Features.set(Feature_HasVendorXwchcBit);
  if (FB[RISCV::FeatureVendorXqcicsr])
    Features.set(Feature_HasVendorXqcicsrBit);
  if (FB[RISCV::FeatureVendorXqcisls])
    Features.set(Feature_HasVendorXqcislsBit);
  if (FB[RISCV::FeatureVendorXqcia])
    Features.set(Feature_HasVendorXqciaBit);
  if (FB[RISCV::FeatureVendorXqcics])
    Features.set(Feature_HasVendorXqcicsBit);
  if (FB[RISCV::FeatureVendorXqcilsm])
    Features.set(Feature_HasVendorXqcilsmBit);
  if (FB[RISCV::FeatureVendorXqciac])
    Features.set(Feature_HasVendorXqciacBit);
  if (FB[RISCV::FeatureVendorXqcicli])
    Features.set(Feature_HasVendorXqcicliBit);
  if (FB[RISCV::FeatureVendorXqcicm])
    Features.set(Feature_HasVendorXqcicmBit);
  if (FB[RISCV::FeatureVendorXqciint])
    Features.set(Feature_HasVendorXqciintBit);
  if (FB[RISCV::FeatureVendorXqcilo])
    Features.set(Feature_HasVendorXqciloBit);
  if (FB[RISCV::Feature64Bit])
    Features.set(Feature_IsRV64Bit);
  if (!FB[RISCV::Feature64Bit])
    Features.set(Feature_IsRV32Bit);
  return Features;
}

static bool checkAsmTiedOperandConstraints(const RISCVAsmParser&AsmParser,
                               unsigned Kind, const OperandVector &Operands,
                               ArrayRef<unsigned> DefaultsOffset,
                               uint64_t &ErrorInfo) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p += 2) {
    switch (*p) {
    case CVT_Tied: {
      unsigned OpIdx = *(p + 1);
      assert(OpIdx < (size_t)(std::end(TiedAsmOperandTable) -
                              std::begin(TiedAsmOperandTable)) &&
             "Tied operand not found");
      unsigned OpndNum1 = TiedAsmOperandTable[OpIdx][1];
      unsigned OpndNum2 = TiedAsmOperandTable[OpIdx][2];
      OpndNum1 = OpndNum1 - DefaultsOffset[OpndNum1];
      OpndNum2 = OpndNum2 - DefaultsOffset[OpndNum2];
      if (OpndNum1 != OpndNum2) {
        auto &SrcOp1 = Operands[OpndNum1];
        auto &SrcOp2 = Operands[OpndNum2];
        if (!AsmParser.areEqualRegs(*SrcOp1, *SrcOp2)) {
          ErrorInfo = OpndNum2;
          return false;
        }
      }
      break;
    }
    default:
      break;
    }
  }
  return true;
}

static const char MnemonicTable[] =
    "\000\007.insn_b\010.insn_ca\010.insn_cb\010.insn_ci\t.insn_ciw\010.insn"
    "_cj\010.insn_cl\010.insn_cr\010.insn_cs\t.insn_css\007.insn_i\007.insn_"
    "j\007.insn_r\010.insn_r4\007.insn_s\010.insn_sb\007.insn_u\010.insn_uj\003"
    "add\006add.uw\004addi\005addiw\004addw\010aes32dsi\taes32dsmi\010aes32e"
    "si\taes32esmi\007aes64ds\010aes64dsm\007aes64es\010aes64esm\007aes64im\t"
    "aes64ks1i\010aes64ks2\010amoadd.b\013amoadd.b.aq\015amoadd.b.aqrl\013am"
    "oadd.b.rl\010amoadd.d\013amoadd.d.aq\015amoadd.d.aqrl\013amoadd.d.rl\010"
    "amoadd.h\013amoadd.h.aq\015amoadd.h.aqrl\013amoadd.h.rl\010amoadd.w\013"
    "amoadd.w.aq\015amoadd.w.aqrl\013amoadd.w.rl\010amoand.b\013amoand.b.aq\015"
    "amoand.b.aqrl\013amoand.b.rl\010amoand.d\013amoand.d.aq\015amoand.d.aqr"
    "l\013amoand.d.rl\010amoand.h\013amoand.h.aq\015amoand.h.aqrl\013amoand."
    "h.rl\010amoand.w\013amoand.w.aq\015amoand.w.aqrl\013amoand.w.rl\010amoc"
    "as.b\013amocas.b.aq\015amocas.b.aqrl\013amocas.b.rl\010amocas.d\013amoc"
    "as.d.aq\015amocas.d.aqrl\013amocas.d.rl\010amocas.h\013amocas.h.aq\015a"
    "mocas.h.aqrl\013amocas.h.rl\010amocas.q\013amocas.q.aq\015amocas.q.aqrl"
    "\013amocas.q.rl\010amocas.w\013amocas.w.aq\015amocas.w.aqrl\013amocas.w"
    ".rl\010amomax.b\013amomax.b.aq\015amomax.b.aqrl\013amomax.b.rl\010amoma"
    "x.d\013amomax.d.aq\015amomax.d.aqrl\013amomax.d.rl\010amomax.h\013amoma"
    "x.h.aq\015amomax.h.aqrl\013amomax.h.rl\010amomax.w\013amomax.w.aq\015am"
    "omax.w.aqrl\013amomax.w.rl\tamomaxu.b\014amomaxu.b.aq\016amomaxu.b.aqrl"
    "\014amomaxu.b.rl\tamomaxu.d\014amomaxu.d.aq\016amomaxu.d.aqrl\014amomax"
    "u.d.rl\tamomaxu.h\014amomaxu.h.aq\016amomaxu.h.aqrl\014amomaxu.h.rl\tam"
    "omaxu.w\014amomaxu.w.aq\016amomaxu.w.aqrl\014amomaxu.w.rl\010amomin.b\013"
    "amomin.b.aq\015amomin.b.aqrl\013amomin.b.rl\010amomin.d\013amomin.d.aq\015"
    "amomin.d.aqrl\013amomin.d.rl\010amomin.h\013amomin.h.aq\015amomin.h.aqr"
    "l\013amomin.h.rl\010amomin.w\013amomin.w.aq\015amomin.w.aqrl\013amomin."
    "w.rl\tamominu.b\014amominu.b.aq\016amominu.b.aqrl\014amominu.b.rl\tamom"
    "inu.d\014amominu.d.aq\016amominu.d.aqrl\014amominu.d.rl\tamominu.h\014a"
    "mominu.h.aq\016amominu.h.aqrl\014amominu.h.rl\tamominu.w\014amominu.w.a"
    "q\016amominu.w.aqrl\014amominu.w.rl\007amoor.b\namoor.b.aq\014amoor.b.a"
    "qrl\namoor.b.rl\007amoor.d\namoor.d.aq\014amoor.d.aqrl\namoor.d.rl\007a"
    "moor.h\namoor.h.aq\014amoor.h.aqrl\namoor.h.rl\007amoor.w\namoor.w.aq\014"
    "amoor.w.aqrl\namoor.w.rl\tamoswap.b\014amoswap.b.aq\016amoswap.b.aqrl\014"
    "amoswap.b.rl\tamoswap.d\014amoswap.d.aq\016amoswap.d.aqrl\014amoswap.d."
    "rl\tamoswap.h\014amoswap.h.aq\016amoswap.h.aqrl\014amoswap.h.rl\tamoswa"
    "p.w\014amoswap.w.aq\016amoswap.w.aqrl\014amoswap.w.rl\010amoxor.b\013am"
    "oxor.b.aq\015amoxor.b.aqrl\013amoxor.b.rl\010amoxor.d\013amoxor.d.aq\015"
    "amoxor.d.aqrl\013amoxor.d.rl\010amoxor.h\013amoxor.h.aq\015amoxor.h.aqr"
    "l\013amoxor.h.rl\010amoxor.w\013amoxor.w.aq\015amoxor.w.aqrl\013amoxor."
    "w.rl\003and\004andi\004andn\005auipc\004bclr\005bclri\003beq\004beqz\004"
    "bext\005bexti\003bge\004bgeu\004bgez\003bgt\004bgtu\004bgtz\004binv\005"
    "binvi\003ble\004bleu\004blez\003blt\004bltu\004bltz\003bne\004bnez\005b"
    "rev8\004bset\005bseti\005c.add\006c.addi\nc.addi16sp\nc.addi4spn\007c.a"
    "ddiw\006c.addw\005c.and\006c.andi\006c.beqz\006c.bnez\010c.ebreak\005c."
    "fld\007c.fldsp\005c.flw\007c.flwsp\005c.fsd\007c.fsdsp\005c.fsw\007c.fs"
    "wsp\003c.j\005c.jal\006c.jalr\004c.jr\005c.lbu\004c.ld\006c.ldsp\004c.l"
    "h\005c.lhu\004c.li\005c.lui\004c.lw\006c.lwsp\007c.mop.1\010c.mop.11\010"
    "c.mop.13\010c.mop.15\007c.mop.3\007c.mop.5\007c.mop.7\007c.mop.9\005c.m"
    "ul\004c.mv\005c.nop\005c.not\tc.ntl.all\010c.ntl.p1\nc.ntl.pall\010c.nt"
    "l.s1\004c.or\004c.sb\004c.sd\006c.sdsp\010c.sext.b\010c.sext.h\004c.sh\006"
    "c.slli\010c.slli64\006c.srai\010c.srai64\006c.srli\010c.srli64\nc.sspop"
    "chk\010c.sspush\005c.sub\006c.subw\004c.sw\006c.swsp\007c.unimp\005c.xo"
    "r\010c.zext.b\010c.zext.h\010c.zext.w\004call\tcbo.clean\tcbo.flush\tcb"
    "o.inval\010cbo.zero\005clmul\006clmulh\006clmulr\003clz\004clzw\007cm.j"
    "alt\005cm.jt\tcm.mva01s\tcm.mvsa01\006cm.pop\tcm.popret\ncm.popretz\007"
    "cm.push\004cpop\005cpopw\004csrc\005csrci\004csrr\005csrrc\006csrrci\005"
    "csrrs\006csrrsi\005csrrw\006csrrwi\004csrs\005csrsi\004csrw\005csrwi\003"
    "ctz\004ctzw\006cv.abs\010cv.abs.b\010cv.abs.h\010cv.add.b\013cv.add.div"
    "2\013cv.add.div4\013cv.add.div8\010cv.add.h\013cv.add.sc.b\013cv.add.sc"
    ".h\014cv.add.sci.b\014cv.add.sci.h\007cv.addn\010cv.addnr\010cv.addrn\t"
    "cv.addrnr\010cv.addun\tcv.addunr\tcv.addurn\ncv.addurnr\010cv.and.b\010"
    "cv.and.h\013cv.and.sc.b\013cv.and.sc.h\014cv.and.sci.b\014cv.and.sci.h\010"
    "cv.avg.b\010cv.avg.h\013cv.avg.sc.b\013cv.avg.sc.h\014cv.avg.sci.b\014c"
    "v.avg.sci.h\tcv.avgu.b\tcv.avgu.h\014cv.avgu.sc.b\014cv.avgu.sc.h\015cv"
    ".avgu.sci.b\015cv.avgu.sci.h\007cv.bclr\010cv.bclrr\tcv.beqimm\tcv.bitr"
    "ev\tcv.bneimm\007cv.bset\010cv.bsetr\006cv.clb\007cv.clip\010cv.clipr\010"
    "cv.clipu\tcv.clipur\ncv.cmpeq.b\ncv.cmpeq.h\015cv.cmpeq.sc.b\015cv.cmpe"
    "q.sc.h\016cv.cmpeq.sci.b\016cv.cmpeq.sci.h\ncv.cmpge.b\ncv.cmpge.h\015c"
    "v.cmpge.sc.b\015cv.cmpge.sc.h\016cv.cmpge.sci.b\016cv.cmpge.sci.h\013cv"
    ".cmpgeu.b\013cv.cmpgeu.h\016cv.cmpgeu.sc.b\016cv.cmpgeu.sc.h\017cv.cmpg"
    "eu.sci.b\017cv.cmpgeu.sci.h\ncv.cmpgt.b\ncv.cmpgt.h\015cv.cmpgt.sc.b\015"
    "cv.cmpgt.sc.h\016cv.cmpgt.sci.b\016cv.cmpgt.sci.h\013cv.cmpgtu.b\013cv."
    "cmpgtu.h\016cv.cmpgtu.sc.b\016cv.cmpgtu.sc.h\017cv.cmpgtu.sci.b\017cv.c"
    "mpgtu.sci.h\ncv.cmple.b\ncv.cmple.h\015cv.cmple.sc.b\015cv.cmple.sc.h\016"
    "cv.cmple.sci.b\016cv.cmple.sci.h\013cv.cmpleu.b\013cv.cmpleu.h\016cv.cm"
    "pleu.sc.b\016cv.cmpleu.sc.h\017cv.cmpleu.sci.b\017cv.cmpleu.sci.h\ncv.c"
    "mplt.b\ncv.cmplt.h\015cv.cmplt.sc.b\015cv.cmplt.sc.h\016cv.cmplt.sci.b\016"
    "cv.cmplt.sci.h\013cv.cmpltu.b\013cv.cmpltu.h\016cv.cmpltu.sc.b\016cv.cm"
    "pltu.sc.h\017cv.cmpltu.sci.b\017cv.cmpltu.sci.h\ncv.cmpne.b\ncv.cmpne.h"
    "\015cv.cmpne.sc.b\015cv.cmpne.sc.h\016cv.cmpne.sci.b\016cv.cmpne.sci.h\006"
    "cv.cnt\013cv.cplxconj\014cv.cplxmul.i\021cv.cplxmul.i.div2\021cv.cplxmu"
    "l.i.div4\021cv.cplxmul.i.div8\014cv.cplxmul.r\021cv.cplxmul.r.div2\021c"
    "v.cplxmul.r.div4\021cv.cplxmul.r.div8\ncv.dotsp.b\ncv.dotsp.h\015cv.dot"
    "sp.sc.b\015cv.dotsp.sc.h\016cv.dotsp.sci.b\016cv.dotsp.sci.h\ncv.dotup."
    "b\ncv.dotup.h\015cv.dotup.sc.b\015cv.dotup.sc.h\016cv.dotup.sci.b\016cv"
    ".dotup.sci.h\013cv.dotusp.b\013cv.dotusp.h\016cv.dotusp.sc.b\016cv.dotu"
    "sp.sc.h\017cv.dotusp.sci.b\017cv.dotusp.sci.h\006cv.elw\010cv.extbs\010"
    "cv.extbz\010cv.exths\010cv.exthz\ncv.extract\014cv.extract.b\014cv.extr"
    "act.h\013cv.extractr\013cv.extractu\015cv.extractu.b\015cv.extractu.h\014"
    "cv.extractur\006cv.ff1\006cv.fl1\tcv.insert\013cv.insert.b\013cv.insert"
    ".h\ncv.insertr\005cv.lb\006cv.lbu\005cv.lh\006cv.lhu\005cv.lw\006cv.mac"
    "\ncv.machhsn\013cv.machhsrn\ncv.machhun\013cv.machhurn\010cv.macsn\tcv."
    "macsrn\010cv.macun\tcv.macurn\006cv.max\010cv.max.b\010cv.max.h\013cv.m"
    "ax.sc.b\013cv.max.sc.h\014cv.max.sci.b\014cv.max.sci.h\007cv.maxu\tcv.m"
    "axu.b\tcv.maxu.h\014cv.maxu.sc.b\014cv.maxu.sc.h\015cv.maxu.sci.b\015cv"
    ".maxu.sci.h\006cv.min\010cv.min.b\010cv.min.h\013cv.min.sc.b\013cv.min."
    "sc.h\014cv.min.sci.b\014cv.min.sci.h\007cv.minu\tcv.minu.b\tcv.minu.h\014"
    "cv.minu.sc.b\014cv.minu.sc.h\015cv.minu.sci.b\015cv.minu.sci.h\006cv.ms"
    "u\tcv.mulhhs\ncv.mulhhsn\013cv.mulhhsrn\tcv.mulhhu\ncv.mulhhun\013cv.mu"
    "lhhurn\007cv.muls\010cv.mulsn\tcv.mulsrn\007cv.mulu\010cv.mulun\tcv.mul"
    "urn\007cv.or.b\007cv.or.h\ncv.or.sc.b\ncv.or.sc.h\013cv.or.sci.b\013cv."
    "or.sci.h\007cv.pack\tcv.pack.h\013cv.packhi.b\013cv.packlo.b\006cv.ror\005"
    "cv.sb\013cv.sdotsp.b\013cv.sdotsp.h\016cv.sdotsp.sc.b\016cv.sdotsp.sc.h"
    "\017cv.sdotsp.sci.b\017cv.sdotsp.sci.h\013cv.sdotup.b\013cv.sdotup.h\016"
    "cv.sdotup.sc.b\016cv.sdotup.sc.h\017cv.sdotup.sci.b\017cv.sdotup.sci.h\014"
    "cv.sdotusp.b\014cv.sdotusp.h\017cv.sdotusp.sc.b\017cv.sdotusp.sc.h\020c"
    "v.sdotusp.sci.b\020cv.sdotusp.sci.h\005cv.sh\014cv.shuffle.b\014cv.shuf"
    "fle.h\020cv.shuffle.sci.h\015cv.shuffle2.b\015cv.shuffle2.h\022cv.shuff"
    "lei0.sci.b\022cv.shufflei1.sci.b\022cv.shufflei2.sci.b\022cv.shufflei3."
    "sci.b\006cv.sle\007cv.sleu\010cv.sll.b\010cv.sll.h\013cv.sll.sc.b\013cv"
    ".sll.sc.h\014cv.sll.sci.b\014cv.sll.sci.h\010cv.sra.b\010cv.sra.h\013cv"
    ".sra.sc.b\013cv.sra.sc.h\014cv.sra.sci.b\014cv.sra.sci.h\010cv.srl.b\010"
    "cv.srl.h\013cv.srl.sc.b\013cv.srl.sc.h\014cv.srl.sci.b\014cv.srl.sci.h\010"
    "cv.sub.b\013cv.sub.div2\013cv.sub.div4\013cv.sub.div8\010cv.sub.h\013cv"
    ".sub.sc.b\013cv.sub.sc.h\014cv.sub.sci.b\014cv.sub.sci.h\007cv.subn\010"
    "cv.subnr\010cv.subrn\tcv.subrnr\013cv.subrotmj\020cv.subrotmj.div2\020c"
    "v.subrotmj.div4\020cv.subrotmj.div8\010cv.subun\tcv.subunr\tcv.suburn\n"
    "cv.suburnr\005cv.sw\010cv.xor.b\010cv.xor.h\013cv.xor.sc.b\013cv.xor.sc"
    ".h\014cv.xor.sci.b\014cv.xor.sci.h\tczero.eqz\tczero.nez\003div\004divu"
    "\005divuw\004divw\004dret\006ebreak\005ecall\006fabs.d\006fabs.h\006fab"
    "s.s\006fadd.d\006fadd.h\006fadd.s\010fclass.d\010fclass.h\010fclass.s\013"
    "fcvt.bf16.s\010fcvt.d.h\010fcvt.d.l\tfcvt.d.lu\010fcvt.d.s\010fcvt.d.w\t"
    "fcvt.d.wu\010fcvt.h.d\010fcvt.h.l\tfcvt.h.lu\010fcvt.h.s\010fcvt.h.w\tf"
    "cvt.h.wu\010fcvt.l.d\010fcvt.l.h\010fcvt.l.s\tfcvt.lu.d\tfcvt.lu.h\tfcv"
    "t.lu.s\013fcvt.s.bf16\010fcvt.s.d\010fcvt.s.h\010fcvt.s.l\tfcvt.s.lu\010"
    "fcvt.s.w\tfcvt.s.wu\010fcvt.w.d\010fcvt.w.h\010fcvt.w.s\tfcvt.wu.d\tfcv"
    "t.wu.h\tfcvt.wu.s\013fcvtmod.w.d\006fdiv.d\006fdiv.h\006fdiv.s\005fence"
    "\007fence.i\tfence.tso\005feq.d\005feq.h\005feq.s\005fge.d\005fge.h\005"
    "fge.s\006fgeq.d\006fgeq.h\006fgeq.s\005fgt.d\005fgt.h\005fgt.s\006fgtq."
    "d\006fgtq.h\006fgtq.s\003fld\005fle.d\005fle.h\005fle.s\006fleq.d\006fl"
    "eq.h\006fleq.s\003flh\005fli.d\005fli.h\005fli.s\005flt.d\005flt.h\005f"
    "lt.s\006fltq.d\006fltq.h\006fltq.s\003flw\007fmadd.d\007fmadd.h\007fmad"
    "d.s\006fmax.d\006fmax.h\006fmax.s\007fmaxm.d\007fmaxm.h\007fmaxm.s\006f"
    "min.d\006fmin.h\006fmin.s\007fminm.d\007fminm.h\007fminm.s\007fmsub.d\007"
    "fmsub.h\007fmsub.s\006fmul.d\006fmul.h\006fmul.s\005fmv.d\007fmv.d.x\005"
    "fmv.h\007fmv.h.x\005fmv.s\007fmv.w.x\007fmv.x.d\007fmv.x.h\007fmv.x.w\010"
    "fmvh.x.d\010fmvp.d.x\006fneg.d\006fneg.h\006fneg.s\010fnmadd.d\010fnmad"
    "d.h\010fnmadd.s\010fnmsub.d\010fnmsub.h\010fnmsub.s\005frcsr\007frflags"
    "\010fround.d\010fround.h\010fround.s\nfroundnx.d\nfroundnx.h\nfroundnx."
    "s\004frrm\004frsr\005fscsr\003fsd\007fsflags\010fsflagsi\007fsgnj.d\007"
    "fsgnj.h\007fsgnj.s\010fsgnjn.d\010fsgnjn.h\010fsgnjn.s\010fsgnjx.d\010f"
    "sgnjx.h\010fsgnjx.s\003fsh\007fsqrt.d\007fsqrt.h\007fsqrt.s\004fsrm\005"
    "fsrmi\004fssr\006fsub.d\006fsub.h\006fsub.s\003fsw\013hfence.gvma\013hf"
    "ence.vvma\013hinval.gvma\013hinval.vvma\005hlv.b\006hlv.bu\005hlv.d\005"
    "hlv.h\006hlv.hu\005hlv.w\006hlv.wu\007hlvx.hu\007hlvx.wu\005hsv.b\005hs"
    "v.d\005hsv.h\005hsv.w\001j\003jal\004jalr\002jr\004jump\002la\tla.tls.g"
    "d\tla.tls.ie\nla.tlsdesc\002lb\005lb.aq\007lb.aqrl\003lbu\002ld\005ld.a"
    "q\007ld.aqrl\003lga\002lh\005lh.aq\007lh.aqrl\003lhu\002li\003lla\004lp"
    "ad\004lr.d\007lr.d.aq\tlr.d.aqrl\007lr.d.rl\004lr.w\007lr.w.aq\tlr.w.aq"
    "rl\007lr.w.rl\003lui\002lw\005lw.aq\007lw.aqrl\003lwu\003max\004maxu\003"
    "min\004minu\nmips.ccmov\010mips.ldp\010mips.lwp\010mips.sdp\010mips.swp"
    "\005mnret\007mop.r.0\007mop.r.1\010mop.r.10\010mop.r.11\010mop.r.12\010"
    "mop.r.13\010mop.r.14\010mop.r.15\010mop.r.16\010mop.r.17\010mop.r.18\010"
    "mop.r.19\007mop.r.2\010mop.r.20\010mop.r.21\010mop.r.22\010mop.r.23\010"
    "mop.r.24\010mop.r.25\010mop.r.26\010mop.r.27\010mop.r.28\010mop.r.29\007"
    "mop.r.3\010mop.r.30\010mop.r.31\007mop.r.4\007mop.r.5\007mop.r.6\007mop"
    ".r.7\007mop.r.8\007mop.r.9\010mop.rr.0\010mop.rr.1\010mop.rr.2\010mop.r"
    "r.3\010mop.rr.4\010mop.rr.5\010mop.rr.6\010mop.rr.7\004mret\003mul\004m"
    "ulh\006mulhsu\005mulhu\004mulw\002mv\003neg\004negw\003nop\003not\007nt"
    "l.all\006ntl.p1\010ntl.pall\006ntl.s1\002or\005orc.b\003ori\003orn\004p"
    "ack\005packh\005packw\005pause\nprefetch.i\nprefetch.r\nprefetch.w\tqc."
    "addsat\nqc.addusat\013qc.c.clrint\007qc.c.di\010qc.c.dir\007qc.c.ei\010"
    "qc.c.eir\014qc.c.mienter\021qc.c.mienter.nest\017qc.c.mileaveret\014qc."
    "c.muliadd\nqc.c.mveqz\013qc.c.setint\nqc.clrinti\tqc.csrrwr\nqc.csrrwri"
    "\007qc.e.lb\010qc.e.lbu\007qc.e.lh\010qc.e.lhu\007qc.e.lw\007qc.e.sb\007"
    "qc.e.sh\007qc.e.sw\007qc.lieq\010qc.lieqi\007qc.lige\010qc.ligei\010qc."
    "ligeu\tqc.ligeui\007qc.lilt\010qc.lilti\010qc.liltu\tqc.liltui\007qc.li"
    "ne\010qc.linei\006qc.lrb\007qc.lrbu\006qc.lrh\007qc.lrhu\006qc.lrw\006q"
    "c.lwm\007qc.lwmi\nqc.muliadd\007qc.mveq\010qc.mveqi\007qc.mvge\010qc.mv"
    "gei\010qc.mvgeu\tqc.mvgeui\007qc.mvlt\010qc.mvlti\010qc.mvltu\tqc.mvltu"
    "i\007qc.mvne\010qc.mvnei\007qc.norm\tqc.normeu\010qc.normu\014qc.select"
    "eqi\014qc.selectieq\015qc.selectieqi\015qc.selectiieq\015qc.selectiine\014"
    "qc.selectine\015qc.selectinei\014qc.selectnei\nqc.setinti\010qc.setwm\t"
    "qc.setwmi\tqc.shladd\tqc.slasat\tqc.sllsat\006qc.srb\006qc.srh\006qc.sr"
    "w\tqc.subsat\nqc.subusat\006qc.swm\007qc.swmi\007qc.wrap\010qc.wrapi\010"
    "qk.c.lbu\nqk.c.lbusp\010qk.c.lhu\nqk.c.lhusp\007qk.c.sb\tqk.c.sbsp\007q"
    "k.c.sh\tqk.c.shsp\007rdcycle\010rdcycleh\trdinstret\nrdinstreth\006rdti"
    "me\007rdtimeh\003rem\004remu\005remuw\004remw\003ret\004rev8\003rol\004"
    "rolw\003ror\004rori\005roriw\004rorw\002sb\007sb.aqrl\005sb.rl\004sc.d\007"
    "sc.d.aq\tsc.d.aqrl\007sc.d.rl\004sc.w\007sc.w.aq\tsc.w.aqrl\007sc.w.rl\007"
    "sctrclr\002sd\007sd.aqrl\005sd.rl\004seqz\006sext.b\006sext.h\006sext.w"
    "\020sf.cdiscard.d.l1\010sf.cease\016sf.cflush.d.l1\010sf.vc.fv\tsf.vc.f"
    "vv\tsf.vc.fvw\007sf.vc.i\010sf.vc.iv\tsf.vc.ivv\tsf.vc.ivw\nsf.vc.v.fv\013"
    "sf.vc.v.fvv\013sf.vc.v.fvw\tsf.vc.v.i\nsf.vc.v.iv\013sf.vc.v.ivv\013sf."
    "vc.v.ivw\nsf.vc.v.vv\013sf.vc.v.vvv\013sf.vc.v.vvw\tsf.vc.v.x\nsf.vc.v."
    "xv\013sf.vc.v.xvv\013sf.vc.v.xvw\010sf.vc.vv\tsf.vc.vvv\tsf.vc.vvw\007s"
    "f.vc.x\010sf.vc.xv\tsf.vc.xvv\tsf.vc.xvw\022sf.vfnrclip.x.f.qf\023sf.vf"
    "nrclip.xu.f.qf\020sf.vfwmacc.4x4x4\017sf.vqmacc.2x8x2\017sf.vqmacc.4x8x"
    "4\021sf.vqmaccsu.2x8x2\021sf.vqmaccsu.4x8x4\020sf.vqmaccu.2x8x2\020sf.v"
    "qmaccu.4x8x4\021sf.vqmaccus.2x8x2\021sf.vqmaccus.4x8x4\017sfence.inval."
    "ir\nsfence.vma\016sfence.w.inval\003sgt\004sgtu\004sgtz\002sh\007sh.aqr"
    "l\005sh.rl\006sh1add\tsh1add.uw\006sh2add\tsh2add.uw\006sh3add\tsh3add."
    "uw\nsha256sig0\nsha256sig1\nsha256sum0\nsha256sum1\nsha512sig0\013sha51"
    "2sig0h\013sha512sig0l\nsha512sig1\013sha512sig1h\013sha512sig1l\nsha512"
    "sum0\013sha512sum0r\nsha512sum1\013sha512sum1r\nsinval.vma\003sll\004sl"
    "li\007slli.uw\005slliw\004sllw\003slt\004slti\005sltiu\004sltu\004sltz\005"
    "sm3p0\005sm3p1\005sm4ed\005sm4ks\004snez\003sra\004srai\005sraiw\004sra"
    "w\004sret\003srl\004srli\005srliw\004srlw\013ssamoswap.d\016ssamoswap.d"
    ".aq\020ssamoswap.d.aqrl\016ssamoswap.d.rl\013ssamoswap.w\016ssamoswap.w"
    ".aq\020ssamoswap.w.aqrl\016ssamoswap.w.rl\010sspopchk\006sspush\005ssrd"
    "p\003sub\004subw\002sw\007sw.aqrl\005sw.rl\004tail\010th.addsl\016th.dc"
    "ache.call\017th.dcache.ciall\016th.dcache.cipa\016th.dcache.cisw\016th."
    "dcache.civa\015th.dcache.cpa\017th.dcache.cpal1\015th.dcache.csw\015th."
    "dcache.cva\017th.dcache.cval1\016th.dcache.iall\015th.dcache.ipa\015th."
    "dcache.isw\015th.dcache.iva\006th.ext\007th.extu\006th.ff0\006th.ff1\007"
    "th.flrd\007th.flrw\010th.flurd\010th.flurw\007th.fsrd\007th.fsrw\010th."
    "fsurd\010th.fsurw\016th.icache.iall\017th.icache.ialls\015th.icache.ipa"
    "\015th.icache.iva\017th.l2cache.call\020th.l2cache.ciall\017th.l2cache."
    "iall\007th.lbia\007th.lbib\010th.lbuia\010th.lbuib\006th.ldd\007th.ldia"
    "\007th.ldib\007th.lhia\007th.lhib\010th.lhuia\010th.lhuib\006th.lrb\007"
    "th.lrbu\006th.lrd\006th.lrh\007th.lrhu\006th.lrw\007th.lrwu\007th.lurb\010"
    "th.lurbu\007th.lurd\007th.lurh\010th.lurhu\007th.lurw\010th.lurwu\006th"
    ".lwd\007th.lwia\007th.lwib\007th.lwud\010th.lwuia\010th.lwuib\007th.mul"
    "a\010th.mulah\010th.mulaw\007th.muls\010th.mulsh\010th.mulsw\010th.mveq"
    "z\010th.mvnez\006th.rev\007th.revw\007th.sbia\007th.sbib\006th.sdd\007t"
    "h.sdia\007th.sdib\016th.sfence.vmas\007th.shia\007th.shib\006th.srb\006"
    "th.srd\006th.srh\007th.srri\010th.srriw\006th.srw\007th.surb\007th.surd"
    "\007th.surh\007th.surw\006th.swd\007th.swia\007th.swib\007th.sync\tth.s"
    "ync.i\nth.sync.is\tth.sync.s\006th.tst\tth.tstnbz\013th.vmaqa.vv\013th."
    "vmaqa.vx\015th.vmaqasu.vv\015th.vmaqasu.vx\014th.vmaqau.vv\014th.vmaqau"
    ".vx\015th.vmaqaus.vx\005unimp\005unzip\010vaadd.vv\010vaadd.vx\tvaaddu."
    "vv\tvaaddu.vx\010vadc.vim\010vadc.vvm\010vadc.vxm\007vadd.vi\007vadd.vv"
    "\007vadd.vx\tvaesdf.vs\tvaesdf.vv\tvaesdm.vs\tvaesdm.vv\tvaesef.vs\tvae"
    "sef.vv\tvaesem.vs\tvaesem.vv\nvaeskf1.vi\nvaeskf2.vi\010vaesz.vs\007van"
    "d.vi\007vand.vv\007vand.vx\010vandn.vv\010vandn.vx\010vasub.vv\010vasub"
    ".vx\tvasubu.vv\tvasubu.vx\007vbrev.v\010vbrev8.v\tvclmul.vv\tvclmul.vx\n"
    "vclmulh.vv\nvclmulh.vx\006vclz.v\014vcompress.vm\007vcpop.m\007vcpop.v\006"
    "vctz.v\007vdiv.vv\007vdiv.vx\010vdivu.vv\010vdivu.vx\007vfabs.v\010vfad"
    "d.vf\010vfadd.vv\tvfclass.v\013vfcvt.f.x.v\014vfcvt.f.xu.v\017vfcvt.rtz"
    ".x.f.v\020vfcvt.rtz.xu.f.v\013vfcvt.x.f.v\014vfcvt.xu.f.v\010vfdiv.vf\010"
    "vfdiv.vv\010vfirst.m\tvfmacc.vf\tvfmacc.vv\tvfmadd.vf\tvfmadd.vv\010vfm"
    "ax.vf\010vfmax.vv\013vfmerge.vfm\010vfmin.vf\010vfmin.vv\tvfmsac.vf\tvf"
    "msac.vv\tvfmsub.vf\tvfmsub.vv\010vfmul.vf\010vfmul.vv\010vfmv.f.s\010vf"
    "mv.s.f\010vfmv.v.f\014vfncvt.f.f.w\014vfncvt.f.x.w\015vfncvt.f.xu.w\020"
    "vfncvt.rod.f.f.w\020vfncvt.rtz.x.f.w\021vfncvt.rtz.xu.f.w\014vfncvt.x.f"
    ".w\015vfncvt.xu.f.w\020vfncvtbf16.f.f.w\007vfneg.v\nvfnmacc.vf\nvfnmacc"
    ".vv\nvfnmadd.vf\nvfnmadd.vv\nvfnmsac.vf\nvfnmsac.vv\nvfnmsub.vf\nvfnmsu"
    "b.vv\tvfrdiv.vf\010vfrec7.v\013vfredmax.vs\013vfredmin.vs\014vfredosum."
    "vs\013vfredsum.vs\014vfredusum.vs\nvfrsqrt7.v\tvfrsub.vf\tvfsgnj.vf\tvf"
    "sgnj.vv\nvfsgnjn.vf\nvfsgnjn.vv\nvfsgnjx.vf\nvfsgnjx.vv\017vfslide1down"
    ".vf\015vfslide1up.vf\010vfsqrt.v\010vfsub.vf\010vfsub.vv\tvfwadd.vf\tvf"
    "wadd.vv\tvfwadd.wf\tvfwadd.wv\014vfwcvt.f.f.v\014vfwcvt.f.x.v\015vfwcvt"
    ".f.xu.v\020vfwcvt.rtz.x.f.v\021vfwcvt.rtz.xu.f.v\014vfwcvt.x.f.v\015vfw"
    "cvt.xu.f.v\020vfwcvtbf16.f.f.v\nvfwmacc.vf\nvfwmacc.vv\016vfwmaccbf16.v"
    "f\016vfwmaccbf16.vv\nvfwmsac.vf\nvfwmsac.vv\tvfwmul.vf\tvfwmul.vv\013vf"
    "wnmacc.vf\013vfwnmacc.vv\013vfwnmsac.vf\013vfwnmsac.vv\015vfwredosum.vs"
    "\014vfwredsum.vs\015vfwredusum.vs\tvfwsub.vf\tvfwsub.vv\tvfwsub.wf\tvfw"
    "sub.wv\010vghsh.vs\010vghsh.vv\010vgmul.vs\010vgmul.vv\005vid.v\007viot"
    "a.m\006vl1r.v\tvl1re16.v\tvl1re32.v\tvl1re64.v\010vl1re8.v\006vl2r.v\tv"
    "l2re16.v\tvl2re32.v\tvl2re64.v\010vl2re8.v\006vl4r.v\tvl4re16.v\tvl4re3"
    "2.v\tvl4re64.v\010vl4re8.v\006vl8r.v\tvl8re16.v\tvl8re32.v\tvl8re64.v\010"
    "vl8re8.v\006vle1.v\007vle16.v\tvle16ff.v\007vle32.v\tvle32ff.v\007vle64"
    ".v\tvle64ff.v\006vle8.v\010vle8ff.v\005vlm.v\nvloxei16.v\nvloxei32.v\nv"
    "loxei64.v\tvloxei8.v\016vloxseg2ei16.v\016vloxseg2ei32.v\016vloxseg2ei6"
    "4.v\015vloxseg2ei8.v\016vloxseg3ei16.v\016vloxseg3ei32.v\016vloxseg3ei6"
    "4.v\015vloxseg3ei8.v\016vloxseg4ei16.v\016vloxseg4ei32.v\016vloxseg4ei6"
    "4.v\015vloxseg4ei8.v\016vloxseg5ei16.v\016vloxseg5ei32.v\016vloxseg5ei6"
    "4.v\015vloxseg5ei8.v\016vloxseg6ei16.v\016vloxseg6ei32.v\016vloxseg6ei6"
    "4.v\015vloxseg6ei8.v\016vloxseg7ei16.v\016vloxseg7ei32.v\016vloxseg7ei6"
    "4.v\015vloxseg7ei8.v\016vloxseg8ei16.v\016vloxseg8ei32.v\016vloxseg8ei6"
    "4.v\015vloxseg8ei8.v\010vlse16.v\010vlse32.v\010vlse64.v\007vlse8.v\013"
    "vlseg2e16.v\015vlseg2e16ff.v\013vlseg2e32.v\015vlseg2e32ff.v\013vlseg2e"
    "64.v\015vlseg2e64ff.v\nvlseg2e8.v\014vlseg2e8ff.v\013vlseg3e16.v\015vls"
    "eg3e16ff.v\013vlseg3e32.v\015vlseg3e32ff.v\013vlseg3e64.v\015vlseg3e64f"
    "f.v\nvlseg3e8.v\014vlseg3e8ff.v\013vlseg4e16.v\015vlseg4e16ff.v\013vlse"
    "g4e32.v\015vlseg4e32ff.v\013vlseg4e64.v\015vlseg4e64ff.v\nvlseg4e8.v\014"
    "vlseg4e8ff.v\013vlseg5e16.v\015vlseg5e16ff.v\013vlseg5e32.v\015vlseg5e3"
    "2ff.v\013vlseg5e64.v\015vlseg5e64ff.v\nvlseg5e8.v\014vlseg5e8ff.v\013vl"
    "seg6e16.v\015vlseg6e16ff.v\013vlseg6e32.v\015vlseg6e32ff.v\013vlseg6e64"
    ".v\015vlseg6e64ff.v\nvlseg6e8.v\014vlseg6e8ff.v\013vlseg7e16.v\015vlseg"
    "7e16ff.v\013vlseg7e32.v\015vlseg7e32ff.v\013vlseg7e64.v\015vlseg7e64ff."
    "v\nvlseg7e8.v\014vlseg7e8ff.v\013vlseg8e16.v\015vlseg8e16ff.v\013vlseg8"
    "e32.v\015vlseg8e32ff.v\013vlseg8e64.v\015vlseg8e64ff.v\nvlseg8e8.v\014v"
    "lseg8e8ff.v\014vlsseg2e16.v\014vlsseg2e32.v\014vlsseg2e64.v\013vlsseg2e"
    "8.v\014vlsseg3e16.v\014vlsseg3e32.v\014vlsseg3e64.v\013vlsseg3e8.v\014v"
    "lsseg4e16.v\014vlsseg4e32.v\014vlsseg4e64.v\013vlsseg4e8.v\014vlsseg5e1"
    "6.v\014vlsseg5e32.v\014vlsseg5e64.v\013vlsseg5e8.v\014vlsseg6e16.v\014v"
    "lsseg6e32.v\014vlsseg6e64.v\013vlsseg6e8.v\014vlsseg7e16.v\014vlsseg7e3"
    "2.v\014vlsseg7e64.v\013vlsseg7e8.v\014vlsseg8e16.v\014vlsseg8e32.v\014v"
    "lsseg8e64.v\013vlsseg8e8.v\nvluxei16.v\nvluxei32.v\nvluxei64.v\tvluxei8"
    ".v\016vluxseg2ei16.v\016vluxseg2ei32.v\016vluxseg2ei64.v\015vluxseg2ei8"
    ".v\016vluxseg3ei16.v\016vluxseg3ei32.v\016vluxseg3ei64.v\015vluxseg3ei8"
    ".v\016vluxseg4ei16.v\016vluxseg4ei32.v\016vluxseg4ei64.v\015vluxseg4ei8"
    ".v\016vluxseg5ei16.v\016vluxseg5ei32.v\016vluxseg5ei64.v\015vluxseg5ei8"
    ".v\016vluxseg6ei16.v\016vluxseg6ei32.v\016vluxseg6ei64.v\015vluxseg6ei8"
    ".v\016vluxseg7ei16.v\016vluxseg7ei32.v\016vluxseg7ei64.v\015vluxseg7ei8"
    ".v\016vluxseg8ei16.v\016vluxseg8ei32.v\016vluxseg8ei64.v\015vluxseg8ei8"
    ".v\010vmacc.vv\010vmacc.vx\010vmadc.vi\tvmadc.vim\010vmadc.vv\tvmadc.vv"
    "m\010vmadc.vx\tvmadc.vxm\010vmadd.vv\010vmadd.vx\010vmand.mm\tvmandn.mm"
    "\013vmandnot.mm\007vmax.vv\007vmax.vx\010vmaxu.vv\010vmaxu.vx\007vmclr."
    "m\nvmerge.vim\nvmerge.vvm\nvmerge.vxm\010vmfeq.vf\010vmfeq.vv\010vmfge."
    "vf\010vmfge.vv\010vmfgt.vf\010vmfgt.vv\010vmfle.vf\010vmfle.vv\010vmflt"
    ".vf\010vmflt.vv\010vmfne.vf\010vmfne.vv\007vmin.vv\007vmin.vx\010vminu."
    "vv\010vminu.vx\006vmmv.m\tvmnand.mm\010vmnor.mm\007vmnot.m\007vmor.mm\010"
    "vmorn.mm\nvmornot.mm\010vmsbc.vv\tvmsbc.vvm\010vmsbc.vx\tvmsbc.vxm\007v"
    "msbf.m\010vmseq.vi\010vmseq.vv\010vmseq.vx\007vmset.m\010vmsge.vi\010vm"
    "sge.vv\010vmsge.vx\tvmsgeu.vi\tvmsgeu.vv\tvmsgeu.vx\010vmsgt.vi\010vmsg"
    "t.vv\010vmsgt.vx\tvmsgtu.vi\tvmsgtu.vv\tvmsgtu.vx\007vmsif.m\010vmsle.v"
    "i\010vmsle.vv\010vmsle.vx\tvmsleu.vi\tvmsleu.vv\tvmsleu.vx\010vmslt.vi\010"
    "vmslt.vv\010vmslt.vx\tvmsltu.vi\tvmsltu.vv\tvmsltu.vx\010vmsne.vi\010vm"
    "sne.vv\010vmsne.vx\007vmsof.m\007vmul.vv\007vmul.vx\010vmulh.vv\010vmul"
    "h.vx\nvmulhsu.vv\nvmulhsu.vx\tvmulhu.vv\tvmulhu.vx\007vmv.s.x\007vmv.v."
    "i\007vmv.v.v\007vmv.v.x\007vmv.x.s\007vmv1r.v\007vmv2r.v\007vmv4r.v\007"
    "vmv8r.v\tvmxnor.mm\010vmxor.mm\tvnclip.wi\tvnclip.wv\tvnclip.wx\nvnclip"
    "u.wi\nvnclipu.wv\nvnclipu.wx\013vncvt.x.x.w\006vneg.v\tvnmsac.vv\tvnmsa"
    "c.vx\tvnmsub.vv\tvnmsub.vx\006vnot.v\010vnsra.wi\010vnsra.wv\010vnsra.w"
    "x\010vnsrl.wi\010vnsrl.wv\010vnsrl.wx\006vor.vi\006vor.vv\006vor.vx\007"
    "vpopc.m\nvredand.vs\nvredmax.vs\013vredmaxu.vs\nvredmin.vs\013vredminu."
    "vs\tvredor.vs\nvredsum.vs\nvredxor.vs\007vrem.vv\007vrem.vx\010vremu.vv"
    "\010vremu.vx\007vrev8.v\013vrgather.vi\013vrgather.vv\013vrgather.vx\017"
    "vrgatherei16.vv\007vrol.vv\007vrol.vx\007vror.vi\007vror.vv\007vror.vx\010"
    "vrsub.vi\010vrsub.vx\006vs1r.v\006vs2r.v\006vs4r.v\006vs8r.v\010vsadd.v"
    "i\010vsadd.vv\010vsadd.vx\tvsaddu.vi\tvsaddu.vv\tvsaddu.vx\010vsbc.vvm\010"
    "vsbc.vxm\006vse1.v\007vse16.v\007vse32.v\007vse64.v\006vse8.v\010vsetiv"
    "li\006vsetvl\007vsetvli\tvsext.vf2\tvsext.vf4\tvsext.vf8\nvsha2ch.vv\nv"
    "sha2cl.vv\nvsha2ms.vv\016vslide1down.vx\014vslide1up.vx\015vslidedown.v"
    "i\015vslidedown.vx\013vslideup.vi\013vslideup.vx\007vsll.vi\007vsll.vv\007"
    "vsll.vx\005vsm.v\010vsm3c.vi\tvsm3me.vv\010vsm4k.vi\010vsm4r.vs\010vsm4"
    "r.vv\010vsmul.vv\010vsmul.vx\nvsoxei16.v\nvsoxei32.v\nvsoxei64.v\tvsoxe"
    "i8.v\016vsoxseg2ei16.v\016vsoxseg2ei32.v\016vsoxseg2ei64.v\015vsoxseg2e"
    "i8.v\016vsoxseg3ei16.v\016vsoxseg3ei32.v\016vsoxseg3ei64.v\015vsoxseg3e"
    "i8.v\016vsoxseg4ei16.v\016vsoxseg4ei32.v\016vsoxseg4ei64.v\015vsoxseg4e"
    "i8.v\016vsoxseg5ei16.v\016vsoxseg5ei32.v\016vsoxseg5ei64.v\015vsoxseg5e"
    "i8.v\016vsoxseg6ei16.v\016vsoxseg6ei32.v\016vsoxseg6ei64.v\015vsoxseg6e"
    "i8.v\016vsoxseg7ei16.v\016vsoxseg7ei32.v\016vsoxseg7ei64.v\015vsoxseg7e"
    "i8.v\016vsoxseg8ei16.v\016vsoxseg8ei32.v\016vsoxseg8ei64.v\015vsoxseg8e"
    "i8.v\007vsra.vi\007vsra.vv\007vsra.vx\007vsrl.vi\007vsrl.vv\007vsrl.vx\010"
    "vsse16.v\010vsse32.v\010vsse64.v\007vsse8.v\013vsseg2e16.v\013vsseg2e32"
    ".v\013vsseg2e64.v\nvsseg2e8.v\013vsseg3e16.v\013vsseg3e32.v\013vsseg3e6"
    "4.v\nvsseg3e8.v\013vsseg4e16.v\013vsseg4e32.v\013vsseg4e64.v\nvsseg4e8."
    "v\013vsseg5e16.v\013vsseg5e32.v\013vsseg5e64.v\nvsseg5e8.v\013vsseg6e16"
    ".v\013vsseg6e32.v\013vsseg6e64.v\nvsseg6e8.v\013vsseg7e16.v\013vsseg7e3"
    "2.v\013vsseg7e64.v\nvsseg7e8.v\013vsseg8e16.v\013vsseg8e32.v\013vsseg8e"
    "64.v\nvsseg8e8.v\010vssra.vi\010vssra.vv\010vssra.vx\010vssrl.vi\010vss"
    "rl.vv\010vssrl.vx\014vssseg2e16.v\014vssseg2e32.v\014vssseg2e64.v\013vs"
    "sseg2e8.v\014vssseg3e16.v\014vssseg3e32.v\014vssseg3e64.v\013vssseg3e8."
    "v\014vssseg4e16.v\014vssseg4e32.v\014vssseg4e64.v\013vssseg4e8.v\014vss"
    "seg5e16.v\014vssseg5e32.v\014vssseg5e64.v\013vssseg5e8.v\014vssseg6e16."
    "v\014vssseg6e32.v\014vssseg6e64.v\013vssseg6e8.v\014vssseg7e16.v\014vss"
    "seg7e32.v\014vssseg7e64.v\013vssseg7e8.v\014vssseg8e16.v\014vssseg8e32."
    "v\014vssseg8e64.v\013vssseg8e8.v\010vssub.vv\010vssub.vx\tvssubu.vv\tvs"
    "subu.vx\007vsub.vv\007vsub.vx\nvsuxei16.v\nvsuxei32.v\nvsuxei64.v\tvsux"
    "ei8.v\016vsuxseg2ei16.v\016vsuxseg2ei32.v\016vsuxseg2ei64.v\015vsuxseg2"
    "ei8.v\016vsuxseg3ei16.v\016vsuxseg3ei32.v\016vsuxseg3ei64.v\015vsuxseg3"
    "ei8.v\016vsuxseg4ei16.v\016vsuxseg4ei32.v\016vsuxseg4ei64.v\015vsuxseg4"
    "ei8.v\016vsuxseg5ei16.v\016vsuxseg5ei32.v\016vsuxseg5ei64.v\015vsuxseg5"
    "ei8.v\016vsuxseg6ei16.v\016vsuxseg6ei32.v\016vsuxseg6ei64.v\015vsuxseg6"
    "ei8.v\016vsuxseg7ei16.v\016vsuxseg7ei32.v\016vsuxseg7ei64.v\015vsuxseg7"
    "ei8.v\016vsuxseg8ei16.v\016vsuxseg8ei32.v\016vsuxseg8ei64.v\015vsuxseg8"
    "ei8.v\010vt.maskc\tvt.maskcn\010vwadd.vv\010vwadd.vx\010vwadd.wv\010vwa"
    "dd.wx\tvwaddu.vv\tvwaddu.vx\tvwaddu.wv\tvwaddu.wx\013vwcvt.x.x.v\014vwc"
    "vtu.x.x.v\tvwmacc.vv\tvwmacc.vx\013vwmaccsu.vv\013vwmaccsu.vx\nvwmaccu."
    "vv\nvwmaccu.vx\013vwmaccus.vx\010vwmul.vv\010vwmul.vx\nvwmulsu.vv\nvwmu"
    "lsu.vx\tvwmulu.vv\tvwmulu.vx\013vwredsum.vs\014vwredsumu.vs\010vwsll.vi"
    "\010vwsll.vv\010vwsll.vx\010vwsub.vv\010vwsub.vx\010vwsub.wv\010vwsub.w"
    "x\tvwsubu.vv\tvwsubu.vx\tvwsubu.wv\tvwsubu.wx\007vxor.vi\007vxor.vv\007"
    "vxor.vx\tvzext.vf2\tvzext.vf4\tvzext.vf8\003wfi\007wrs.nto\007wrs.sto\004"
    "xnor\003xor\004xori\006xperm4\006xperm8\006zext.b\006zext.h\006zext.w\003"
    "zip";

// Feature bitsets.
enum : uint8_t {
  AMFBS_None,
  AMFBS_HasHalfFPLoadStoreMove,
  AMFBS_HasStdExtCOrZca,
  AMFBS_HasStdExtD,
  AMFBS_HasStdExtF,
  AMFBS_HasStdExtFOrZfinx,
  AMFBS_HasStdExtH,
  AMFBS_HasStdExtM,
  AMFBS_HasStdExtSmctrOrSsctr,
  AMFBS_HasStdExtSmrnmi,
  AMFBS_HasStdExtSvinval,
  AMFBS_HasStdExtZaamo,
  AMFBS_HasStdExtZabha,
  AMFBS_HasStdExtZacas,
  AMFBS_HasStdExtZalasr,
  AMFBS_HasStdExtZalrsc,
  AMFBS_HasStdExtZawrs,
  AMFBS_HasStdExtZba,
  AMFBS_HasStdExtZbb,
  AMFBS_HasStdExtZbbOrZbkb,
  AMFBS_HasStdExtZbc,
  AMFBS_HasStdExtZbcOrZbkc,
  AMFBS_HasStdExtZbkb,
  AMFBS_HasStdExtZbkx,
  AMFBS_HasStdExtZbs,
  AMFBS_HasStdExtZcb,
  AMFBS_HasStdExtZcmop,
  AMFBS_HasStdExtZcmp,
  AMFBS_HasStdExtZcmt,
  AMFBS_HasStdExtZfa,
  AMFBS_HasStdExtZfbfmin,
  AMFBS_HasStdExtZfh,
  AMFBS_HasStdExtZfhmin,
  AMFBS_HasStdExtZfinx,
  AMFBS_HasStdExtZhinx,
  AMFBS_HasStdExtZhinxmin,
  AMFBS_HasStdExtZicbom,
  AMFBS_HasStdExtZicbop,
  AMFBS_HasStdExtZicboz,
  AMFBS_HasStdExtZicfilp,
  AMFBS_HasStdExtZicfiss,
  AMFBS_HasStdExtZicond,
  AMFBS_HasStdExtZihintntl,
  AMFBS_HasStdExtZihintpause,
  AMFBS_HasStdExtZimop,
  AMFBS_HasStdExtZknh,
  AMFBS_HasStdExtZksed,
  AMFBS_HasStdExtZksh,
  AMFBS_HasStdExtZmmul,
  AMFBS_HasStdExtZvbb,
  AMFBS_HasStdExtZvbcOrZvbc32e,
  AMFBS_HasStdExtZvfbfmin,
  AMFBS_HasStdExtZvfbfwma,
  AMFBS_HasStdExtZvkb,
  AMFBS_HasStdExtZvkg,
  AMFBS_HasStdExtZvkgs,
  AMFBS_HasStdExtZvkned,
  AMFBS_HasStdExtZvknhaOrZvknhb,
  AMFBS_HasStdExtZvksed,
  AMFBS_HasStdExtZvksh,
  AMFBS_HasVInstructions,
  AMFBS_HasVInstructionsAnyF,
  AMFBS_HasVInstructionsI64,
  AMFBS_HasVendorXMIPSCMove,
  AMFBS_HasVendorXMIPSLSP,
  AMFBS_HasVendorXSfcease,
  AMFBS_HasVendorXSfvcp,
  AMFBS_HasVendorXSfvfnrclipxfqf,
  AMFBS_HasVendorXSfvfwmaccqqq,
  AMFBS_HasVendorXSfvqmaccdod,
  AMFBS_HasVendorXSfvqmaccqoq,
  AMFBS_HasVendorXSiFivecdiscarddlone,
  AMFBS_HasVendorXSiFivecflushdlone,
  AMFBS_HasVendorXTHeadBa,
  AMFBS_HasVendorXTHeadBb,
  AMFBS_HasVendorXTHeadBs,
  AMFBS_HasVendorXTHeadCmo,
  AMFBS_HasVendorXTHeadCondMov,
  AMFBS_HasVendorXTHeadMac,
  AMFBS_HasVendorXTHeadMemIdx,
  AMFBS_HasVendorXTHeadMemPair,
  AMFBS_HasVendorXTHeadSync,
  AMFBS_HasVendorXTHeadVdot,
  AMFBS_HasVendorXVentanaCondOps,
  AMFBS_HasVendorXwchc,
  AMFBS_IsRV32,
  AMFBS_IsRV64,
  AMFBS_HasStdExtCOrZca_HasRVCHints,
  AMFBS_HasStdExtCOrZca_IsRV32,
  AMFBS_HasStdExtCOrZca_IsRV64,
  AMFBS_HasStdExtCOrZcd_HasStdExtD,
  AMFBS_HasStdExtD_IsRV64,
  AMFBS_HasStdExtF_IsRV64,
  AMFBS_HasStdExtM_IsRV64,
  AMFBS_HasStdExtZaamo_IsRV64,
  AMFBS_HasStdExtZabha_HasStdExtZacas,
  AMFBS_HasStdExtZacas_IsRV32,
  AMFBS_HasStdExtZacas_IsRV64,
  AMFBS_HasStdExtZalasr_IsRV64,
  AMFBS_HasStdExtZalrsc_IsRV64,
  AMFBS_HasStdExtZba_IsRV64,
  AMFBS_HasStdExtZbb_IsRV32,
  AMFBS_HasStdExtZbb_IsRV64,
  AMFBS_HasStdExtZbbOrZbkb_IsRV32,
  AMFBS_HasStdExtZbbOrZbkb_IsRV64,
  AMFBS_HasStdExtZbkb_IsRV32,
  AMFBS_HasStdExtZbkb_IsRV64,
  AMFBS_HasStdExtZcb_HasStdExtZbb,
  AMFBS_HasStdExtZcb_HasStdExtZmmul,
  AMFBS_HasStdExtZdinx_IsRV32,
  AMFBS_HasStdExtZdinx_IsRV64,
  AMFBS_HasStdExtZfa_HasStdExtD,
  AMFBS_HasStdExtZfa_HasStdExtZfh,
  AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh,
  AMFBS_HasStdExtZfh_IsRV64,
  AMFBS_HasStdExtZfhmin_HasStdExtD,
  AMFBS_HasStdExtZfinx_IsRV64,
  AMFBS_HasStdExtZhinx_IsRV64,
  AMFBS_HasStdExtZicfiss_HasStdExtZcmop,
  AMFBS_HasStdExtZicfiss_IsRV64,
  AMFBS_HasStdExtZknd_IsRV32,
  AMFBS_HasStdExtZknd_IsRV64,
  AMFBS_HasStdExtZkndOrZkne_IsRV64,
  AMFBS_HasStdExtZkne_IsRV32,
  AMFBS_HasStdExtZkne_IsRV64,
  AMFBS_HasStdExtZknh_IsRV32,
  AMFBS_HasStdExtZknh_IsRV64,
  AMFBS_HasStdExtZmmul_IsRV64,
  AMFBS_HasVInstructionsI64_IsRV64,
  AMFBS_HasVendorXCValu_IsRV32,
  AMFBS_HasVendorXCVbi_IsRV32,
  AMFBS_HasVendorXCVbitmanip_IsRV32,
  AMFBS_HasVendorXCVelw_IsRV32,
  AMFBS_HasVendorXCVmac_IsRV32,
  AMFBS_HasVendorXCVmem_IsRV32,
  AMFBS_HasVendorXCVsimd_IsRV32,
  AMFBS_HasVendorXTHeadBb_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF,
  AMFBS_HasVendorXTHeadMac_IsRV64,
  AMFBS_HasVendorXTHeadMemIdx_IsRV64,
  AMFBS_HasVendorXTHeadMemPair_IsRV64,
  AMFBS_HasVendorXqcia_IsRV32,
  AMFBS_HasVendorXqciac_IsRV32,
  AMFBS_HasVendorXqcicli_IsRV32,
  AMFBS_HasVendorXqcicm_IsRV32,
  AMFBS_HasVendorXqcics_IsRV32,
  AMFBS_HasVendorXqcicsr_IsRV32,
  AMFBS_HasVendorXqciint_IsRV32,
  AMFBS_HasVendorXqcilo_IsRV32,
  AMFBS_HasVendorXqcilsm_IsRV32,
  AMFBS_HasVendorXqcisls_IsRV32,
  AMFBS_IsRV64_HasStdExtH,
  AMFBS_IsRV64_HasVInstructionsI64,
  AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl,
  AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32,
  AMFBS_HasStdExtZbkb_NoStdExtZbb_IsRV32,
  AMFBS_HasStdExtZbkb_NoStdExtZbb_IsRV64,
  AMFBS_HasStdExtZcb_HasStdExtZba_IsRV64,
  AMFBS_HasStdExtZdinx_IsRV64_IsRV64,
  AMFBS_HasStdExtZfa_HasStdExtD_IsRV32,
  AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32,
  AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64,
  AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64,
};

static constexpr FeatureBitset FeatureBitsets[] = {
  {}, // AMFBS_None
  {Feature_HasHalfFPLoadStoreMoveBit, },
  {Feature_HasStdExtCOrZcaBit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtFOrZfinxBit, },
  {Feature_HasStdExtHBit, },
  {Feature_HasStdExtMBit, },
  {Feature_HasStdExtSmctrOrSsctrBit, },
  {Feature_HasStdExtSmrnmiBit, },
  {Feature_HasStdExtSvinvalBit, },
  {Feature_HasStdExtZaamoBit, },
  {Feature_HasStdExtZabhaBit, },
  {Feature_HasStdExtZacasBit, },
  {Feature_HasStdExtZalasrBit, },
  {Feature_HasStdExtZalrscBit, },
  {Feature_HasStdExtZawrsBit, },
  {Feature_HasStdExtZbaBit, },
  {Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZbbOrZbkbBit, },
  {Feature_HasStdExtZbcBit, },
  {Feature_HasStdExtZbcOrZbkcBit, },
  {Feature_HasStdExtZbkbBit, },
  {Feature_HasStdExtZbkxBit, },
  {Feature_HasStdExtZbsBit, },
  {Feature_HasStdExtZcbBit, },
  {Feature_HasStdExtZcmopBit, },
  {Feature_HasStdExtZcmpBit, },
  {Feature_HasStdExtZcmtBit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfbfminBit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhminBit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxminBit, },
  {Feature_HasStdExtZicbomBit, },
  {Feature_HasStdExtZicbopBit, },
  {Feature_HasStdExtZicbozBit, },
  {Feature_HasStdExtZicfilpBit, },
  {Feature_HasStdExtZicfissBit, },
  {Feature_HasStdExtZicondBit, },
  {Feature_HasStdExtZihintntlBit, },
  {Feature_HasStdExtZihintpauseBit, },
  {Feature_HasStdExtZimopBit, },
  {Feature_HasStdExtZknhBit, },
  {Feature_HasStdExtZksedBit, },
  {Feature_HasStdExtZkshBit, },
  {Feature_HasStdExtZmmulBit, },
  {Feature_HasStdExtZvbbBit, },
  {Feature_HasStdExtZvbcOrZvbc32eBit, },
  {Feature_HasStdExtZvfbfminBit, },
  {Feature_HasStdExtZvfbfwmaBit, },
  {Feature_HasStdExtZvkbBit, },
  {Feature_HasStdExtZvkgBit, },
  {Feature_HasStdExtZvkgsBit, },
  {Feature_HasStdExtZvknedBit, },
  {Feature_HasStdExtZvknhaOrZvknhbBit, },
  {Feature_HasStdExtZvksedBit, },
  {Feature_HasStdExtZvkshBit, },
  {Feature_HasVInstructionsBit, },
  {Feature_HasVInstructionsAnyFBit, },
  {Feature_HasVInstructionsI64Bit, },
  {Feature_HasVendorXMIPSCMoveBit, },
  {Feature_HasVendorXMIPSLSPBit, },
  {Feature_HasVendorXSfceaseBit, },
  {Feature_HasVendorXSfvcpBit, },
  {Feature_HasVendorXSfvfnrclipxfqfBit, },
  {Feature_HasVendorXSfvfwmaccqqqBit, },
  {Feature_HasVendorXSfvqmaccdodBit, },
  {Feature_HasVendorXSfvqmaccqoqBit, },
  {Feature_HasVendorXSiFivecdiscarddloneBit, },
  {Feature_HasVendorXSiFivecflushdloneBit, },
  {Feature_HasVendorXTHeadBaBit, },
  {Feature_HasVendorXTHeadBbBit, },
  {Feature_HasVendorXTHeadBsBit, },
  {Feature_HasVendorXTHeadCmoBit, },
  {Feature_HasVendorXTHeadCondMovBit, },
  {Feature_HasVendorXTHeadMacBit, },
  {Feature_HasVendorXTHeadMemIdxBit, },
  {Feature_HasVendorXTHeadMemPairBit, },
  {Feature_HasVendorXTHeadSyncBit, },
  {Feature_HasVendorXTHeadVdotBit, },
  {Feature_HasVendorXVentanaCondOpsBit, },
  {Feature_HasVendorXwchcBit, },
  {Feature_IsRV32Bit, },
  {Feature_IsRV64Bit, },
  {Feature_HasStdExtCOrZcaBit, Feature_HasRVCHintsBit, },
  {Feature_HasStdExtCOrZcaBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtCOrZcaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtCOrZcdBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZaamoBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZalasrBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZalrscBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZbbBit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZmmulBit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhOrZvfhBit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HasStdExtDBit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZicfissBit, Feature_HasStdExtZcmopBit, },
  {Feature_HasStdExtZicfissBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_IsRV64Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVbiBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVelwBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVmacBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVmemBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXCVsimdBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtDBit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtFBit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadMemIdxBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadMemPairBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXqciaBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciacBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcicliBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcicmBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcicsBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcicsrBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciintBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqciloBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcilsmBit, Feature_IsRV32Bit, },
  {Feature_HasVendorXqcislsBit, Feature_IsRV32Bit, },
  {Feature_IsRV64Bit, Feature_HasStdExtHBit, },
  {Feature_IsRV64Bit, Feature_HasVInstructionsI64Bit, },
  {Feature_HasStdExtCBit, Feature_HasRVCHintsBit, Feature_HasStdExtZihintntlBit, },
  {Feature_HasStdExtCOrZcfOrZceBit, Feature_HasStdExtFBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbkbBit, Feature_NoStdExtZbbBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZbkbBit, Feature_NoStdExtZbbBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZcbBit, Feature_HasStdExtZbaBit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_IsRV64Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtDBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtDBit, Feature_IsRV64Bit, },
  {Feature_HasVendorXTHeadFMemIdxBit, Feature_HasStdExtFBit, Feature_IsRV64Bit, },
};

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint8_t RequiredFeaturesIdx;
    uint8_t Classes[7];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const MatchEntry MatchTable0[] = {
  { 1 /* .insn_b */, RISCV::InsnB, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm13Lsb0 }, },
  { 9 /* .insn_ca */, RISCV::InsnCA, Convert__AnyRegCOperand1_3__InsnCDirectiveOpcode1_0__UImm61_1__UImm21_2__AnyRegCOperand1_4, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm6, MCK_UImm2, MCK_AnyRegCOperand, MCK_AnyRegCOperand }, },
  { 18 /* .insn_cb */, RISCV::InsnCB, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__SImm9Lsb01_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_SImm9Lsb0 }, },
  { 27 /* .insn_ci */, RISCV::InsnCI, Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__SImm61_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm6 }, },
  { 36 /* .insn_ciw */, RISCV::InsnCIW, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__UImm81_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm8 }, },
  { 46 /* .insn_cj */, RISCV::InsnCJ, Convert__InsnCDirectiveOpcode1_0__UImm31_1__SImm12Lsb01_2, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_SImm12Lsb0 }, },
  { 55 /* .insn_cl */, RISCV::InsnCL, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_4__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 55 /* .insn_cl */, RISCV::InsnCL, Convert__AnyRegCOperand1_2__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_5__UImm51_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm5, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 64 /* .insn_cr */, RISCV::InsnCR, Convert__AnyRegOperand1_2__InsnCDirectiveOpcode1_0__UImm41_1__AnyRegOperand1_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm4, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 73 /* .insn_cs */, RISCV::InsnCS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_4__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 73 /* .insn_cs */, RISCV::InsnCS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegCOperand1_2__AnyRegCOperand1_5__UImm51_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegCOperand, MCK_UImm5, MCK__40_, MCK_AnyRegCOperand, MCK__41_ }, },
  { 82 /* .insn_css */, RISCV::InsnCSS, Convert__InsnCDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__UImm61_3, AMFBS_HasStdExtCOrZca, { MCK_InsnCDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_UImm6 }, },
  { 92 /* .insn_i */, RISCV::InsnI, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_3__SImm121_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm12 }, },
  { 92 /* .insn_i */, RISCV::InsnI_Mem, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_4__imm_95_0, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 92 /* .insn_i */, RISCV::InsnI_Mem, Convert__AnyRegOperand1_2__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_5__SImm121_3, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm12, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 100 /* .insn_j */, RISCV::InsnJ, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_SImm21Lsb0JAL }, },
  { 108 /* .insn_r */, RISCV::InsnR, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm71_2__AnyRegOperand1_4__AnyRegOperand1_5, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm7, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 108 /* .insn_r */, RISCV::InsnR4, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 116 /* .insn_r4 */, RISCV::InsnR4, Convert__AnyRegOperand1_3__InsnDirectiveOpcode1_0__UImm31_1__UImm21_2__AnyRegOperand1_4__AnyRegOperand1_5__AnyRegOperand1_6, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_UImm2, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_AnyRegOperand }, },
  { 125 /* .insn_s */, RISCV::InsnS, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_4__imm_95_0, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 125 /* .insn_s */, RISCV::InsnS, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_5__SImm121_3, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_SImm12, MCK__40_, MCK_AnyRegOperand, MCK__41_ }, },
  { 133 /* .insn_sb */, RISCV::InsnB, Convert__InsnDirectiveOpcode1_0__UImm31_1__AnyRegOperand1_2__AnyRegOperand1_3__SImm13Lsb01_4, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_UImm3, MCK_AnyRegOperand, MCK_AnyRegOperand, MCK_SImm13Lsb0 }, },
  { 142 /* .insn_u */, RISCV::InsnU, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__UImm20LUI1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_UImm20LUI }, },
  { 150 /* .insn_uj */, RISCV::InsnJ, Convert__AnyRegOperand1_1__InsnDirectiveOpcode1_0__SImm21Lsb0JAL1_2, AMFBS_None, { MCK_InsnDirectiveOpcode, MCK_AnyRegOperand, MCK_SImm21Lsb0JAL }, },
  { 159 /* add */, RISCV::ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 159 /* add */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 159 /* add */, RISCV::PseudoAddTPRel, Convert__Reg1_0__Reg1_1__Reg1_2__TPRelAddSymbol1_3, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_TPRelAddSymbol }, },
  { 163 /* add.uw */, RISCV::ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 170 /* addi */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 175 /* addiw */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 181 /* addw */, RISCV::ADDW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 181 /* addw */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 186 /* aes32dsi */, RISCV::AES32DSI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZknd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 195 /* aes32dsmi */, RISCV::AES32DSMI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZknd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 205 /* aes32esi */, RISCV::AES32ESI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZkne_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 214 /* aes32esmi */, RISCV::AES32ESMI, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZkne_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 224 /* aes64ds */, RISCV::AES64DS, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 232 /* aes64dsm */, RISCV::AES64DSM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 241 /* aes64es */, RISCV::AES64ES, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 249 /* aes64esm */, RISCV::AES64ESM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 258 /* aes64im */, RISCV::AES64IM, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknd_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 266 /* aes64ks1i */, RISCV::AES64KS1I, Convert__Reg1_0__Reg1_1__RnumArg1_2, AMFBS_HasStdExtZkndOrZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_RnumArg }, },
  { 276 /* aes64ks2 */, RISCV::AES64KS2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZkndOrZkne_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 285 /* amoadd.b */, RISCV::AMOADD_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 294 /* amoadd.b.aq */, RISCV::AMOADD_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 306 /* amoadd.b.aqrl */, RISCV::AMOADD_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 320 /* amoadd.b.rl */, RISCV::AMOADD_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 332 /* amoadd.d */, RISCV::AMOADD_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 341 /* amoadd.d.aq */, RISCV::AMOADD_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 353 /* amoadd.d.aqrl */, RISCV::AMOADD_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 367 /* amoadd.d.rl */, RISCV::AMOADD_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 379 /* amoadd.h */, RISCV::AMOADD_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 388 /* amoadd.h.aq */, RISCV::AMOADD_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 400 /* amoadd.h.aqrl */, RISCV::AMOADD_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 414 /* amoadd.h.rl */, RISCV::AMOADD_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 426 /* amoadd.w */, RISCV::AMOADD_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 435 /* amoadd.w.aq */, RISCV::AMOADD_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 447 /* amoadd.w.aqrl */, RISCV::AMOADD_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 461 /* amoadd.w.rl */, RISCV::AMOADD_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 473 /* amoand.b */, RISCV::AMOAND_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 482 /* amoand.b.aq */, RISCV::AMOAND_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 494 /* amoand.b.aqrl */, RISCV::AMOAND_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 508 /* amoand.b.rl */, RISCV::AMOAND_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 520 /* amoand.d */, RISCV::AMOAND_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 529 /* amoand.d.aq */, RISCV::AMOAND_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 541 /* amoand.d.aqrl */, RISCV::AMOAND_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 555 /* amoand.d.rl */, RISCV::AMOAND_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 567 /* amoand.h */, RISCV::AMOAND_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 576 /* amoand.h.aq */, RISCV::AMOAND_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 588 /* amoand.h.aqrl */, RISCV::AMOAND_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 602 /* amoand.h.rl */, RISCV::AMOAND_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 614 /* amoand.w */, RISCV::AMOAND_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 623 /* amoand.w.aq */, RISCV::AMOAND_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 635 /* amoand.w.aqrl */, RISCV::AMOAND_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 649 /* amoand.w.rl */, RISCV::AMOAND_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 661 /* amocas.b */, RISCV::AMOCAS_B, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 670 /* amocas.b.aq */, RISCV::AMOCAS_B_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 682 /* amocas.b.aqrl */, RISCV::AMOCAS_B_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 696 /* amocas.b.rl */, RISCV::AMOCAS_B_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 708 /* amocas.d */, RISCV::AMOCAS_D_RV64, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 708 /* amocas.d */, RISCV::AMOCAS_D_RV32, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 717 /* amocas.d.aq */, RISCV::AMOCAS_D_RV64_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 717 /* amocas.d.aq */, RISCV::AMOCAS_D_RV32_AQ, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 729 /* amocas.d.aqrl */, RISCV::AMOCAS_D_RV64_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 729 /* amocas.d.aqrl */, RISCV::AMOCAS_D_RV32_AQ_RL, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 743 /* amocas.d.rl */, RISCV::AMOCAS_D_RV64_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 743 /* amocas.d.rl */, RISCV::AMOCAS_D_RV32_RL, Convert__GPRPairRV321_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV321_1, AMFBS_HasStdExtZacas_IsRV32, { MCK_GPRPairRV32, MCK_GPRPairRV32, MCK_ZeroOffsetMemOpOperand }, },
  { 755 /* amocas.h */, RISCV::AMOCAS_H, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 764 /* amocas.h.aq */, RISCV::AMOCAS_H_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 776 /* amocas.h.aqrl */, RISCV::AMOCAS_H_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 790 /* amocas.h.rl */, RISCV::AMOCAS_H_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 802 /* amocas.q */, RISCV::AMOCAS_Q, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 811 /* amocas.q.aq */, RISCV::AMOCAS_Q_AQ, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 823 /* amocas.q.aqrl */, RISCV::AMOCAS_Q_AQ_RL, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 837 /* amocas.q.rl */, RISCV::AMOCAS_Q_RL, Convert__GPRPairRV641_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__GPRPairRV641_1, AMFBS_HasStdExtZacas_IsRV64, { MCK_GPRPairRV64, MCK_GPRPairRV64, MCK_ZeroOffsetMemOpOperand }, },
  { 849 /* amocas.w */, RISCV::AMOCAS_W, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 858 /* amocas.w.aq */, RISCV::AMOCAS_W_AQ, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 870 /* amocas.w.aqrl */, RISCV::AMOCAS_W_AQ_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 884 /* amocas.w.rl */, RISCV::AMOCAS_W_RL, Convert__Reg1_0__Tie0_1_1__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZacas, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 896 /* amomax.b */, RISCV::AMOMAX_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 905 /* amomax.b.aq */, RISCV::AMOMAX_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 917 /* amomax.b.aqrl */, RISCV::AMOMAX_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 931 /* amomax.b.rl */, RISCV::AMOMAX_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 943 /* amomax.d */, RISCV::AMOMAX_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 952 /* amomax.d.aq */, RISCV::AMOMAX_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 964 /* amomax.d.aqrl */, RISCV::AMOMAX_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 978 /* amomax.d.rl */, RISCV::AMOMAX_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 990 /* amomax.h */, RISCV::AMOMAX_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 999 /* amomax.h.aq */, RISCV::AMOMAX_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1011 /* amomax.h.aqrl */, RISCV::AMOMAX_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1025 /* amomax.h.rl */, RISCV::AMOMAX_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1037 /* amomax.w */, RISCV::AMOMAX_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1046 /* amomax.w.aq */, RISCV::AMOMAX_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1058 /* amomax.w.aqrl */, RISCV::AMOMAX_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1072 /* amomax.w.rl */, RISCV::AMOMAX_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1084 /* amomaxu.b */, RISCV::AMOMAXU_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1094 /* amomaxu.b.aq */, RISCV::AMOMAXU_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1107 /* amomaxu.b.aqrl */, RISCV::AMOMAXU_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1122 /* amomaxu.b.rl */, RISCV::AMOMAXU_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1135 /* amomaxu.d */, RISCV::AMOMAXU_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1145 /* amomaxu.d.aq */, RISCV::AMOMAXU_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1158 /* amomaxu.d.aqrl */, RISCV::AMOMAXU_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1173 /* amomaxu.d.rl */, RISCV::AMOMAXU_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1186 /* amomaxu.h */, RISCV::AMOMAXU_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1196 /* amomaxu.h.aq */, RISCV::AMOMAXU_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1209 /* amomaxu.h.aqrl */, RISCV::AMOMAXU_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1224 /* amomaxu.h.rl */, RISCV::AMOMAXU_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1237 /* amomaxu.w */, RISCV::AMOMAXU_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1247 /* amomaxu.w.aq */, RISCV::AMOMAXU_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1260 /* amomaxu.w.aqrl */, RISCV::AMOMAXU_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1275 /* amomaxu.w.rl */, RISCV::AMOMAXU_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1288 /* amomin.b */, RISCV::AMOMIN_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1297 /* amomin.b.aq */, RISCV::AMOMIN_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1309 /* amomin.b.aqrl */, RISCV::AMOMIN_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1323 /* amomin.b.rl */, RISCV::AMOMIN_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1335 /* amomin.d */, RISCV::AMOMIN_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1344 /* amomin.d.aq */, RISCV::AMOMIN_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1356 /* amomin.d.aqrl */, RISCV::AMOMIN_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1370 /* amomin.d.rl */, RISCV::AMOMIN_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1382 /* amomin.h */, RISCV::AMOMIN_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1391 /* amomin.h.aq */, RISCV::AMOMIN_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1403 /* amomin.h.aqrl */, RISCV::AMOMIN_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1417 /* amomin.h.rl */, RISCV::AMOMIN_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1429 /* amomin.w */, RISCV::AMOMIN_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1438 /* amomin.w.aq */, RISCV::AMOMIN_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1450 /* amomin.w.aqrl */, RISCV::AMOMIN_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1464 /* amomin.w.rl */, RISCV::AMOMIN_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1476 /* amominu.b */, RISCV::AMOMINU_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1486 /* amominu.b.aq */, RISCV::AMOMINU_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1499 /* amominu.b.aqrl */, RISCV::AMOMINU_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1514 /* amominu.b.rl */, RISCV::AMOMINU_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1527 /* amominu.d */, RISCV::AMOMINU_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1537 /* amominu.d.aq */, RISCV::AMOMINU_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1550 /* amominu.d.aqrl */, RISCV::AMOMINU_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1565 /* amominu.d.rl */, RISCV::AMOMINU_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1578 /* amominu.h */, RISCV::AMOMINU_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1588 /* amominu.h.aq */, RISCV::AMOMINU_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1601 /* amominu.h.aqrl */, RISCV::AMOMINU_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1616 /* amominu.h.rl */, RISCV::AMOMINU_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1629 /* amominu.w */, RISCV::AMOMINU_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1639 /* amominu.w.aq */, RISCV::AMOMINU_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1652 /* amominu.w.aqrl */, RISCV::AMOMINU_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1667 /* amominu.w.rl */, RISCV::AMOMINU_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1680 /* amoor.b */, RISCV::AMOOR_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1688 /* amoor.b.aq */, RISCV::AMOOR_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1699 /* amoor.b.aqrl */, RISCV::AMOOR_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1712 /* amoor.b.rl */, RISCV::AMOOR_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1723 /* amoor.d */, RISCV::AMOOR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1731 /* amoor.d.aq */, RISCV::AMOOR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1742 /* amoor.d.aqrl */, RISCV::AMOOR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1755 /* amoor.d.rl */, RISCV::AMOOR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1766 /* amoor.h */, RISCV::AMOOR_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1774 /* amoor.h.aq */, RISCV::AMOOR_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1785 /* amoor.h.aqrl */, RISCV::AMOOR_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1798 /* amoor.h.rl */, RISCV::AMOOR_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1809 /* amoor.w */, RISCV::AMOOR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1817 /* amoor.w.aq */, RISCV::AMOOR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1828 /* amoor.w.aqrl */, RISCV::AMOOR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1841 /* amoor.w.rl */, RISCV::AMOOR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1852 /* amoswap.b */, RISCV::AMOSWAP_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1862 /* amoswap.b.aq */, RISCV::AMOSWAP_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1875 /* amoswap.b.aqrl */, RISCV::AMOSWAP_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1890 /* amoswap.b.rl */, RISCV::AMOSWAP_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1903 /* amoswap.d */, RISCV::AMOSWAP_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1913 /* amoswap.d.aq */, RISCV::AMOSWAP_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1926 /* amoswap.d.aqrl */, RISCV::AMOSWAP_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1941 /* amoswap.d.rl */, RISCV::AMOSWAP_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1954 /* amoswap.h */, RISCV::AMOSWAP_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1964 /* amoswap.h.aq */, RISCV::AMOSWAP_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1977 /* amoswap.h.aqrl */, RISCV::AMOSWAP_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 1992 /* amoswap.h.rl */, RISCV::AMOSWAP_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2005 /* amoswap.w */, RISCV::AMOSWAP_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2015 /* amoswap.w.aq */, RISCV::AMOSWAP_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2028 /* amoswap.w.aqrl */, RISCV::AMOSWAP_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2043 /* amoswap.w.rl */, RISCV::AMOSWAP_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2056 /* amoxor.b */, RISCV::AMOXOR_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2065 /* amoxor.b.aq */, RISCV::AMOXOR_B_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2077 /* amoxor.b.aqrl */, RISCV::AMOXOR_B_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2091 /* amoxor.b.rl */, RISCV::AMOXOR_B_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2103 /* amoxor.d */, RISCV::AMOXOR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2112 /* amoxor.d.aq */, RISCV::AMOXOR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2124 /* amoxor.d.aqrl */, RISCV::AMOXOR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2138 /* amoxor.d.rl */, RISCV::AMOXOR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2150 /* amoxor.h */, RISCV::AMOXOR_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2159 /* amoxor.h.aq */, RISCV::AMOXOR_H_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2171 /* amoxor.h.aqrl */, RISCV::AMOXOR_H_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2185 /* amoxor.h.rl */, RISCV::AMOXOR_H_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZabha, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2197 /* amoxor.w */, RISCV::AMOXOR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2206 /* amoxor.w.aq */, RISCV::AMOXOR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2218 /* amoxor.w.aqrl */, RISCV::AMOXOR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2232 /* amoxor.w.rl */, RISCV::AMOXOR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZaamo, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 2244 /* and */, RISCV::AND, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2244 /* and */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 2248 /* andi */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 2253 /* andn */, RISCV::ANDN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2258 /* auipc */, RISCV::AUIPC, Convert__Reg1_0__UImm20AUIPC1_1, AMFBS_None, { MCK_GPR, MCK_UImm20AUIPC }, },
  { 2264 /* bclr */, RISCV::BCLR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2264 /* bclr */, RISCV::BCLRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2269 /* bclri */, RISCV::BCLRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2275 /* beq */, RISCV::BEQ, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2279 /* beqz */, RISCV::BEQ, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2284 /* bext */, RISCV::BEXT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2284 /* bext */, RISCV::BEXTI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2289 /* bexti */, RISCV::BEXTI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2295 /* bge */, RISCV::BGE, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2299 /* bgeu */, RISCV::BGEU, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2304 /* bgez */, RISCV::BGE, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2309 /* bgt */, RISCV::BLT, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2313 /* bgtu */, RISCV::BLTU, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2318 /* bgtz */, RISCV::BLT, Convert__regX0__Reg1_0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2323 /* binv */, RISCV::BINV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2323 /* binv */, RISCV::BINVI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2328 /* binvi */, RISCV::BINVI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2334 /* ble */, RISCV::BGE, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2338 /* bleu */, RISCV::BGEU, Convert__Reg1_1__Reg1_0__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2343 /* blez */, RISCV::BGE, Convert__regX0__Reg1_0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2348 /* blt */, RISCV::BLT, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2352 /* bltu */, RISCV::BLTU, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2357 /* bltz */, RISCV::BLT, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2362 /* bne */, RISCV::BNE, Convert__Reg1_0__Reg1_1__SImm13Lsb01_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2366 /* bnez */, RISCV::BNE, Convert__Reg1_0__regX0__SImm13Lsb01_1, AMFBS_None, { MCK_GPR, MCK_SImm13Lsb0 }, },
  { 2371 /* brev8 */, RISCV::BREV8, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR }, },
  { 2377 /* bset */, RISCV::BSET, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2377 /* bset */, RISCV::BSETI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2382 /* bseti */, RISCV::BSETI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 2388 /* c.add */, RISCV::C_ADD_HINT, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_GPRNoX0 }, },
  { 2388 /* c.add */, RISCV::C_ADD, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 2394 /* c.addi */, RISCV::PseudoC_ADDI_NOP, Convert__Reg1_0__imm_95_0__ImmZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRX0, MCK_ImmZero }, },
  { 2394 /* c.addi */, RISCV::C_NOP_HINT, Convert__SImm6NonZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_SImm6NonZero }, },
  { 2394 /* c.addi */, RISCV::C_ADDI_HINT_IMM_ZERO, Convert__Reg1_0__Tie0_1_1__ImmZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRNoX0, MCK_ImmZero }, },
  { 2394 /* c.addi */, RISCV::C_ADDI, Convert__Reg1_0__Tie0_1_1__SImm6NonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_SImm6NonZero }, },
  { 2401 /* c.addi16sp */, RISCV::C_ADDI16SP, Convert__Reg1_0__Tie0_1_1__SImm10Lsb0000NonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_SP, MCK_SImm10Lsb0000NonZero }, },
  { 2412 /* c.addi4spn */, RISCV::C_ADDI4SPN, Convert__Reg1_0__Reg1_1__UImm10Lsb00NonZero1_2, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SP, MCK_UImm10Lsb00NonZero }, },
  { 2423 /* c.addiw */, RISCV::C_ADDIW, Convert__Reg1_0__Tie0_1_1__SImm61_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRNoX0, MCK_SImm6 }, },
  { 2431 /* c.addw */, RISCV::C_ADDW, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_GPRC }, },
  { 2438 /* c.and */, RISCV::C_AND, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 2444 /* c.andi */, RISCV::C_ANDI, Convert__Reg1_0__Tie0_1_1__SImm61_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm6 }, },
  { 2451 /* c.beqz */, RISCV::C_BEQZ, Convert__Reg1_0__SImm9Lsb01_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm9Lsb0 }, },
  { 2458 /* c.bnez */, RISCV::C_BNEZ, Convert__Reg1_0__SImm9Lsb01_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_SImm9Lsb0 }, },
  { 2465 /* c.ebreak */, RISCV::C_EBREAK, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 2474 /* c.fld */, RISCV::C_FLD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2474 /* c.fld */, RISCV::C_FLD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2480 /* c.fldsp */, RISCV::C_FLDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2480 /* c.fldsp */, RISCV::C_FLDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2488 /* c.flw */, RISCV::C_FLW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2488 /* c.flw */, RISCV::C_FLW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2494 /* c.flwsp */, RISCV::C_FLWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2494 /* c.flwsp */, RISCV::C_FLWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2502 /* c.fsd */, RISCV::C_FSD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2502 /* c.fsd */, RISCV::C_FSD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64C, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2508 /* c.fsdsp */, RISCV::C_FSDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2508 /* c.fsdsp */, RISCV::C_FSDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZcd_HasStdExtD, { MCK_FPR64, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2516 /* c.fsw */, RISCV::C_FSW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2516 /* c.fsw */, RISCV::C_FSW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32C, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2522 /* c.fswsp */, RISCV::C_FSWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2522 /* c.fswsp */, RISCV::C_FSWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZcfOrZce_HasStdExtF_IsRV32, { MCK_FPR32, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2530 /* c.j */, RISCV::C_J, Convert__SImm12Lsb01_0, AMFBS_HasStdExtCOrZca, { MCK_SImm12Lsb0 }, },
  { 2534 /* c.jal */, RISCV::C_JAL, Convert__SImm12Lsb01_0, AMFBS_HasStdExtCOrZca_IsRV32, { MCK_SImm12Lsb0 }, },
  { 2540 /* c.jalr */, RISCV::C_JALR, Convert__Reg1_0, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0 }, },
  { 2547 /* c.jr */, RISCV::C_JR, Convert__Reg1_0, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0 }, },
  { 2552 /* c.lbu */, RISCV::C_LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2552 /* c.lbu */, RISCV::C_LBU, Convert__Reg1_0__Reg1_3__UImm21_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2558 /* c.ld */, RISCV::C_LD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2558 /* c.ld */, RISCV::C_LD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2563 /* c.ldsp */, RISCV::C_LDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRNoX0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2563 /* c.ldsp */, RISCV::C_LDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRNoX0, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2570 /* c.lh */, RISCV::C_LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2570 /* c.lh */, RISCV::C_LH, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2575 /* c.lhu */, RISCV::C_LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2575 /* c.lhu */, RISCV::C_LHU, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2581 /* c.li */, RISCV::C_LI_HINT, Convert__Reg1_0__SImm61_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_SImm6 }, },
  { 2581 /* c.li */, RISCV::C_LI, Convert__Reg1_0__SImm61_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_SImm6 }, },
  { 2586 /* c.lui */, RISCV::C_LUI_HINT, Convert__Reg1_0__CLUIImm1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_CLUIImm }, },
  { 2586 /* c.lui */, RISCV::C_LUI, Convert__Reg1_0__CLUIImm1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0X2, MCK_CLUIImm }, },
  { 2592 /* c.lw */, RISCV::C_LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2592 /* c.lw */, RISCV::C_LW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2597 /* c.lwsp */, RISCV::C_LWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2597 /* c.lwsp */, RISCV::C_LWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2604 /* c.mop.1 */, RISCV::C_MOP1, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2612 /* c.mop.11 */, RISCV::C_MOP11, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2621 /* c.mop.13 */, RISCV::C_MOP13, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2630 /* c.mop.15 */, RISCV::C_MOP15, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2639 /* c.mop.3 */, RISCV::C_MOP3, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2647 /* c.mop.5 */, RISCV::C_MOP5, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2655 /* c.mop.7 */, RISCV::C_MOP7, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2663 /* c.mop.9 */, RISCV::C_MOP9, Convert_NoOperands, AMFBS_HasStdExtZcmop, {  }, },
  { 2671 /* c.mul */, RISCV::C_MUL, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZcb_HasStdExtZmmul, { MCK_GPRC, MCK_GPRC }, },
  { 2677 /* c.mv */, RISCV::C_MV_HINT, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_GPRNoX0 }, },
  { 2677 /* c.mv */, RISCV::C_MV, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 2682 /* c.nop */, RISCV::C_NOP, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 2682 /* c.nop */, RISCV::C_NOP_HINT, Convert__SImm6NonZero1_0, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_SImm6NonZero }, },
  { 2688 /* c.not */, RISCV::C_NOT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb, { MCK_GPRC }, },
  { 2694 /* c.ntl.all */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX5, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 2704 /* c.ntl.p1 */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX2, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 2713 /* c.ntl.pall */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX3, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 2724 /* c.ntl.s1 */, RISCV::C_ADD_HINT, Convert__regX0__Tie0_1_1__regX4, AMFBS_HasStdExtC_HasRVCHints_HasStdExtZihintntl, {  }, },
  { 2733 /* c.or */, RISCV::C_OR, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 2738 /* c.sb */, RISCV::C_SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2738 /* c.sb */, RISCV::C_SB, Convert__Reg1_0__Reg1_3__UImm21_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2743 /* c.sd */, RISCV::C_SD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2743 /* c.sd */, RISCV::C_SD, Convert__Reg1_0__Reg1_3__UImm8Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_UImm8Lsb000, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2748 /* c.sdsp */, RISCV::C_SDSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRNoX0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2748 /* c.sdsp */, RISCV::C_SDSP, Convert__Reg1_0__Reg1_3__UImm9Lsb0001_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPR, MCK_UImm9Lsb000, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2755 /* c.sext.b */, RISCV::C_SEXT_B, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 2764 /* c.sext.h */, RISCV::C_SEXT_H, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 2773 /* c.sh */, RISCV::C_SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2773 /* c.sh */, RISCV::C_SH, Convert__Reg1_0__Reg1_3__UImm2Lsb01_1, AMFBS_HasStdExtZcb, { MCK_GPRC, MCK_UImm2Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2778 /* c.slli */, RISCV::C_SLLI_HINT, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRX0, MCK_UImmLog2XLenNonZero }, },
  { 2778 /* c.slli */, RISCV::C_SLLI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK_UImmLog2XLenNonZero }, },
  { 2785 /* c.slli64 */, RISCV::C_SLLI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPR }, },
  { 2794 /* c.srai */, RISCV::C_SRAI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 2801 /* c.srai64 */, RISCV::C_SRAI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRC }, },
  { 2810 /* c.srli */, RISCV::C_SRLI, Convert__Reg1_0__Tie0_1_1__UImmLog2XLenNonZero1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImmLog2XLenNonZero }, },
  { 2817 /* c.srli64 */, RISCV::C_SRLI64_HINT, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtCOrZca_HasRVCHints, { MCK_GPRC }, },
  { 2826 /* c.sspopchk */, RISCV::C_SSPOPCHK, Convert__Reg1_0, AMFBS_HasStdExtZicfiss_HasStdExtZcmop, { MCK_GPRX5 }, },
  { 2837 /* c.sspush */, RISCV::C_SSPUSH, Convert__Reg1_0, AMFBS_HasStdExtZicfiss_HasStdExtZcmop, { MCK_GPRX1 }, },
  { 2846 /* c.sub */, RISCV::C_SUB, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 2852 /* c.subw */, RISCV::C_SUBW, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca_IsRV64, { MCK_GPRC, MCK_GPRC }, },
  { 2859 /* c.sw */, RISCV::C_SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2859 /* c.sw */, RISCV::C_SW, Convert__Reg1_0__Reg1_3__UImm7Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_UImm7Lsb00, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 2864 /* c.swsp */, RISCV::C_SWSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtCOrZca, { MCK_GPRNoX0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2864 /* c.swsp */, RISCV::C_SWSP, Convert__Reg1_0__Reg1_3__UImm8Lsb001_1, AMFBS_HasStdExtCOrZca, { MCK_GPR, MCK_UImm8Lsb00, MCK__40_, MCK_SP, MCK__41_ }, },
  { 2871 /* c.unimp */, RISCV::C_UNIMP, Convert_NoOperands, AMFBS_HasStdExtCOrZca, {  }, },
  { 2879 /* c.xor */, RISCV::C_XOR, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtCOrZca, { MCK_GPRC, MCK_GPRC }, },
  { 2885 /* c.zext.b */, RISCV::C_ZEXT_B, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb, { MCK_GPRC }, },
  { 2894 /* c.zext.h */, RISCV::C_ZEXT_H, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZbb, { MCK_GPRC }, },
  { 2903 /* c.zext.w */, RISCV::C_ZEXT_W, Convert__Reg1_0__Tie0_1_1, AMFBS_HasStdExtZcb_HasStdExtZba_IsRV64, { MCK_GPRC }, },
  { 2912 /* call */, RISCV::PseudoCALL, Convert__CallSymbol1_0, AMFBS_None, { MCK_CallSymbol }, },
  { 2912 /* call */, RISCV::PseudoCALLReg, Convert__Reg1_0__CallSymbol1_1, AMFBS_None, { MCK_GPR, MCK_CallSymbol }, },
  { 2917 /* cbo.clean */, RISCV::CBO_CLEAN, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 2927 /* cbo.flush */, RISCV::CBO_FLUSH, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 2937 /* cbo.inval */, RISCV::CBO_INVAL, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicbom, { MCK_ZeroOffsetMemOpOperand }, },
  { 2947 /* cbo.zero */, RISCV::CBO_ZERO, Convert__ZeroOffsetMemOpOperand1_0, AMFBS_HasStdExtZicboz, { MCK_ZeroOffsetMemOpOperand }, },
  { 2956 /* clmul */, RISCV::CLMUL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbcOrZbkc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2962 /* clmulh */, RISCV::CLMULH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbcOrZbkc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2969 /* clmulr */, RISCV::CLMULR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbc, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 2976 /* clz */, RISCV::CLZ, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 2980 /* clzw */, RISCV::CLZW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 2985 /* cm.jalt */, RISCV::CM_JALT, Convert__UImm8GE321_0, AMFBS_HasStdExtZcmt, { MCK_UImm8GE32 }, },
  { 2993 /* cm.jt */, RISCV::CM_JT, Convert__UImm51_0, AMFBS_HasStdExtZcmt, { MCK_UImm5 }, },
  { 2999 /* cm.mva01s */, RISCV::CM_MVA01S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZcmp, { MCK_SR07, MCK_SR07 }, },
  { 3009 /* cm.mvsa01 */, RISCV::CM_MVSA01, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZcmp, { MCK_SR07, MCK_SR07 }, },
  { 3019 /* cm.pop */, RISCV::CM_POP, Convert__Rlist1_0__StackAdj1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_StackAdj }, },
  { 3026 /* cm.popret */, RISCV::CM_POPRET, Convert__Rlist1_0__StackAdj1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_StackAdj }, },
  { 3036 /* cm.popretz */, RISCV::CM_POPRETZ, Convert__Rlist1_0__StackAdj1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_StackAdj }, },
  { 3047 /* cm.push */, RISCV::CM_PUSH, Convert__Rlist1_0__NegStackAdj1_1, AMFBS_HasStdExtZcmp, { MCK_Rlist, MCK_NegStackAdj }, },
  { 3055 /* cpop */, RISCV::CPOP, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 3060 /* cpopw */, RISCV::CPOPW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 3066 /* csrc */, RISCV::CSRRC, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 3066 /* csrc */, RISCV::CSRRCI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3071 /* csrci */, RISCV::CSRRCI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3077 /* csrr */, RISCV::CSRRS, Convert__Reg1_0__CSRSystemRegister1_1__regX0, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister }, },
  { 3082 /* csrrc */, RISCV::CSRRC, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 3082 /* csrrc */, RISCV::CSRRCI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3088 /* csrrci */, RISCV::CSRRCI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3095 /* csrrs */, RISCV::CSRRS, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 3095 /* csrrs */, RISCV::CSRRSI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3101 /* csrrsi */, RISCV::CSRRSI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3108 /* csrrw */, RISCV::CSRRW, Convert__Reg1_0__CSRSystemRegister1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_GPR }, },
  { 3108 /* csrrw */, RISCV::CSRRWI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3114 /* csrrwi */, RISCV::CSRRWI, Convert__Reg1_0__CSRSystemRegister1_1__UImm51_2, AMFBS_None, { MCK_GPR, MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3121 /* csrs */, RISCV::CSRRS, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 3121 /* csrs */, RISCV::CSRRSI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3126 /* csrsi */, RISCV::CSRRSI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3132 /* csrw */, RISCV::CSRRW, Convert__regX0__CSRSystemRegister1_0__Reg1_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_GPR }, },
  { 3132 /* csrw */, RISCV::CSRRWI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3137 /* csrwi */, RISCV::CSRRWI, Convert__regX0__CSRSystemRegister1_0__UImm51_1, AMFBS_None, { MCK_CSRSystemRegister, MCK_UImm5 }, },
  { 3143 /* ctz */, RISCV::CTZ, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 3147 /* ctzw */, RISCV::CTZW, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 3152 /* cv.abs */, RISCV::CV_ABS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3159 /* cv.abs.b */, RISCV::CV_ABS_B, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3168 /* cv.abs.h */, RISCV::CV_ABS_H, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3177 /* cv.add.b */, RISCV::CV_ADD_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3186 /* cv.add.div2 */, RISCV::CV_ADD_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3198 /* cv.add.div4 */, RISCV::CV_ADD_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3210 /* cv.add.div8 */, RISCV::CV_ADD_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3222 /* cv.add.h */, RISCV::CV_ADD_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3231 /* cv.add.sc.b */, RISCV::CV_ADD_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3243 /* cv.add.sc.h */, RISCV::CV_ADD_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3255 /* cv.add.sci.b */, RISCV::CV_ADD_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3268 /* cv.add.sci.h */, RISCV::CV_ADD_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3281 /* cv.addn */, RISCV::CV_ADDN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3289 /* cv.addnr */, RISCV::CV_ADDNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3298 /* cv.addrn */, RISCV::CV_ADDRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3307 /* cv.addrnr */, RISCV::CV_ADDRNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3317 /* cv.addun */, RISCV::CV_ADDUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3326 /* cv.addunr */, RISCV::CV_ADDUNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3336 /* cv.addurn */, RISCV::CV_ADDURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3346 /* cv.addurnr */, RISCV::CV_ADDURNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3357 /* cv.and.b */, RISCV::CV_AND_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3366 /* cv.and.h */, RISCV::CV_AND_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3375 /* cv.and.sc.b */, RISCV::CV_AND_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3387 /* cv.and.sc.h */, RISCV::CV_AND_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3399 /* cv.and.sci.b */, RISCV::CV_AND_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3412 /* cv.and.sci.h */, RISCV::CV_AND_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3425 /* cv.avg.b */, RISCV::CV_AVG_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3434 /* cv.avg.h */, RISCV::CV_AVG_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3443 /* cv.avg.sc.b */, RISCV::CV_AVG_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3455 /* cv.avg.sc.h */, RISCV::CV_AVG_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3467 /* cv.avg.sci.b */, RISCV::CV_AVG_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3480 /* cv.avg.sci.h */, RISCV::CV_AVG_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3493 /* cv.avgu.b */, RISCV::CV_AVGU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3503 /* cv.avgu.h */, RISCV::CV_AVGU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3513 /* cv.avgu.sc.b */, RISCV::CV_AVGU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3526 /* cv.avgu.sc.h */, RISCV::CV_AVGU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3539 /* cv.avgu.sci.b */, RISCV::CV_AVGU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3553 /* cv.avgu.sci.h */, RISCV::CV_AVGU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3567 /* cv.bclr */, RISCV::CV_BCLR, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 3575 /* cv.bclrr */, RISCV::CV_BCLRR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3584 /* cv.beqimm */, RISCV::CV_BEQIMM, Convert__Reg1_0__SImm51_1__SImm13Lsb01_2, AMFBS_HasVendorXCVbi_IsRV32, { MCK_GPR, MCK_SImm5, MCK_SImm13Lsb0 }, },
  { 3594 /* cv.bitrev */, RISCV::CV_BITREV, Convert__Reg1_0__Reg1_1__UImm21_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm2, MCK_UImm5 }, },
  { 3604 /* cv.bneimm */, RISCV::CV_BNEIMM, Convert__Reg1_0__SImm51_1__SImm13Lsb01_2, AMFBS_HasVendorXCVbi_IsRV32, { MCK_GPR, MCK_SImm5, MCK_SImm13Lsb0 }, },
  { 3614 /* cv.bset */, RISCV::CV_BSET, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 3622 /* cv.bsetr */, RISCV::CV_BSETR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3631 /* cv.clb */, RISCV::CV_CLB, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 3638 /* cv.clip */, RISCV::CV_CLIP, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3646 /* cv.clipr */, RISCV::CV_CLIPR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3655 /* cv.clipu */, RISCV::CV_CLIPU, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 3664 /* cv.clipur */, RISCV::CV_CLIPUR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3674 /* cv.cmpeq.b */, RISCV::CV_CMPEQ_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3685 /* cv.cmpeq.h */, RISCV::CV_CMPEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3696 /* cv.cmpeq.sc.b */, RISCV::CV_CMPEQ_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3710 /* cv.cmpeq.sc.h */, RISCV::CV_CMPEQ_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3724 /* cv.cmpeq.sci.b */, RISCV::CV_CMPEQ_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3739 /* cv.cmpeq.sci.h */, RISCV::CV_CMPEQ_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3754 /* cv.cmpge.b */, RISCV::CV_CMPGE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3765 /* cv.cmpge.h */, RISCV::CV_CMPGE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3776 /* cv.cmpge.sc.b */, RISCV::CV_CMPGE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3790 /* cv.cmpge.sc.h */, RISCV::CV_CMPGE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3804 /* cv.cmpge.sci.b */, RISCV::CV_CMPGE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3819 /* cv.cmpge.sci.h */, RISCV::CV_CMPGE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3834 /* cv.cmpgeu.b */, RISCV::CV_CMPGEU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3846 /* cv.cmpgeu.h */, RISCV::CV_CMPGEU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3858 /* cv.cmpgeu.sc.b */, RISCV::CV_CMPGEU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3873 /* cv.cmpgeu.sc.h */, RISCV::CV_CMPGEU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3888 /* cv.cmpgeu.sci.b */, RISCV::CV_CMPGEU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3904 /* cv.cmpgeu.sci.h */, RISCV::CV_CMPGEU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 3920 /* cv.cmpgt.b */, RISCV::CV_CMPGT_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3931 /* cv.cmpgt.h */, RISCV::CV_CMPGT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3942 /* cv.cmpgt.sc.b */, RISCV::CV_CMPGT_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3956 /* cv.cmpgt.sc.h */, RISCV::CV_CMPGT_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 3970 /* cv.cmpgt.sci.b */, RISCV::CV_CMPGT_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 3985 /* cv.cmpgt.sci.h */, RISCV::CV_CMPGT_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4000 /* cv.cmpgtu.b */, RISCV::CV_CMPGTU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4012 /* cv.cmpgtu.h */, RISCV::CV_CMPGTU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4024 /* cv.cmpgtu.sc.b */, RISCV::CV_CMPGTU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4039 /* cv.cmpgtu.sc.h */, RISCV::CV_CMPGTU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4054 /* cv.cmpgtu.sci.b */, RISCV::CV_CMPGTU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4070 /* cv.cmpgtu.sci.h */, RISCV::CV_CMPGTU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4086 /* cv.cmple.b */, RISCV::CV_CMPLE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4097 /* cv.cmple.h */, RISCV::CV_CMPLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4108 /* cv.cmple.sc.b */, RISCV::CV_CMPLE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4122 /* cv.cmple.sc.h */, RISCV::CV_CMPLE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4136 /* cv.cmple.sci.b */, RISCV::CV_CMPLE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4151 /* cv.cmple.sci.h */, RISCV::CV_CMPLE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4166 /* cv.cmpleu.b */, RISCV::CV_CMPLEU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4178 /* cv.cmpleu.h */, RISCV::CV_CMPLEU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4190 /* cv.cmpleu.sc.b */, RISCV::CV_CMPLEU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4205 /* cv.cmpleu.sc.h */, RISCV::CV_CMPLEU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4220 /* cv.cmpleu.sci.b */, RISCV::CV_CMPLEU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4236 /* cv.cmpleu.sci.h */, RISCV::CV_CMPLEU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4252 /* cv.cmplt.b */, RISCV::CV_CMPLT_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4263 /* cv.cmplt.h */, RISCV::CV_CMPLT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4274 /* cv.cmplt.sc.b */, RISCV::CV_CMPLT_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4288 /* cv.cmplt.sc.h */, RISCV::CV_CMPLT_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4302 /* cv.cmplt.sci.b */, RISCV::CV_CMPLT_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4317 /* cv.cmplt.sci.h */, RISCV::CV_CMPLT_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4332 /* cv.cmpltu.b */, RISCV::CV_CMPLTU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4344 /* cv.cmpltu.h */, RISCV::CV_CMPLTU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4356 /* cv.cmpltu.sc.b */, RISCV::CV_CMPLTU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4371 /* cv.cmpltu.sc.h */, RISCV::CV_CMPLTU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4386 /* cv.cmpltu.sci.b */, RISCV::CV_CMPLTU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4402 /* cv.cmpltu.sci.h */, RISCV::CV_CMPLTU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4418 /* cv.cmpne.b */, RISCV::CV_CMPNE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4429 /* cv.cmpne.h */, RISCV::CV_CMPNE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4440 /* cv.cmpne.sc.b */, RISCV::CV_CMPNE_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4454 /* cv.cmpne.sc.h */, RISCV::CV_CMPNE_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4468 /* cv.cmpne.sci.b */, RISCV::CV_CMPNE_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4483 /* cv.cmpne.sci.h */, RISCV::CV_CMPNE_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4498 /* cv.cnt */, RISCV::CV_CNT, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4505 /* cv.cplxconj */, RISCV::CV_CPLXCONJ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4517 /* cv.cplxmul.i */, RISCV::CV_CPLXMUL_I, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4530 /* cv.cplxmul.i.div2 */, RISCV::CV_CPLXMUL_I_DIV2, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4548 /* cv.cplxmul.i.div4 */, RISCV::CV_CPLXMUL_I_DIV4, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4566 /* cv.cplxmul.i.div8 */, RISCV::CV_CPLXMUL_I_DIV8, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4584 /* cv.cplxmul.r */, RISCV::CV_CPLXMUL_R, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4597 /* cv.cplxmul.r.div2 */, RISCV::CV_CPLXMUL_R_DIV2, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4615 /* cv.cplxmul.r.div4 */, RISCV::CV_CPLXMUL_R_DIV4, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4633 /* cv.cplxmul.r.div8 */, RISCV::CV_CPLXMUL_R_DIV8, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4651 /* cv.dotsp.b */, RISCV::CV_DOTSP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4662 /* cv.dotsp.h */, RISCV::CV_DOTSP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4673 /* cv.dotsp.sc.b */, RISCV::CV_DOTSP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4687 /* cv.dotsp.sc.h */, RISCV::CV_DOTSP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4701 /* cv.dotsp.sci.b */, RISCV::CV_DOTSP_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4716 /* cv.dotsp.sci.h */, RISCV::CV_DOTSP_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4731 /* cv.dotup.b */, RISCV::CV_DOTUP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4742 /* cv.dotup.h */, RISCV::CV_DOTUP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4753 /* cv.dotup.sc.b */, RISCV::CV_DOTUP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4767 /* cv.dotup.sc.h */, RISCV::CV_DOTUP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4781 /* cv.dotup.sci.b */, RISCV::CV_DOTUP_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4796 /* cv.dotup.sci.h */, RISCV::CV_DOTUP_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4811 /* cv.dotusp.b */, RISCV::CV_DOTUSP_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4823 /* cv.dotusp.h */, RISCV::CV_DOTUSP_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4835 /* cv.dotusp.sc.b */, RISCV::CV_DOTUSP_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4850 /* cv.dotusp.sc.h */, RISCV::CV_DOTUSP_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4865 /* cv.dotusp.sci.b */, RISCV::CV_DOTUSP_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4881 /* cv.dotusp.sci.h */, RISCV::CV_DOTUSP_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 4897 /* cv.elw */, RISCV::CV_ELW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasVendorXCVelw_IsRV32, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 4904 /* cv.extbs */, RISCV::CV_EXTBS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4913 /* cv.extbz */, RISCV::CV_EXTBZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4922 /* cv.exths */, RISCV::CV_EXTHS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4931 /* cv.exthz */, RISCV::CV_EXTHZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 4940 /* cv.extract */, RISCV::CV_EXTRACT, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 4951 /* cv.extract.b */, RISCV::CV_EXTRACT_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4964 /* cv.extract.h */, RISCV::CV_EXTRACT_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 4977 /* cv.extractr */, RISCV::CV_EXTRACTR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 4989 /* cv.extractu */, RISCV::CV_EXTRACTU, Convert__Reg1_0__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 5001 /* cv.extractu.b */, RISCV::CV_EXTRACTU_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5015 /* cv.extractu.h */, RISCV::CV_EXTRACTU_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5029 /* cv.extractur */, RISCV::CV_EXTRACTUR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5042 /* cv.ff1 */, RISCV::CV_FF1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 5049 /* cv.fl1 */, RISCV::CV_FL1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 5056 /* cv.insert */, RISCV::CV_INSERT, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__UImm51_3, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm5, MCK_UImm5 }, },
  { 5066 /* cv.insert.b */, RISCV::CV_INSERT_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5078 /* cv.insert.h */, RISCV::CV_INSERT_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5090 /* cv.insertr */, RISCV::CV_INSERTR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5101 /* cv.lb */, RISCV::CV_LB_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5101 /* cv.lb */, RISCV::CV_LB_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5101 /* cv.lb */, RISCV::CV_LB_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5107 /* cv.lbu */, RISCV::CV_LBU_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5107 /* cv.lbu */, RISCV::CV_LBU_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5107 /* cv.lbu */, RISCV::CV_LBU_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5114 /* cv.lh */, RISCV::CV_LH_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5114 /* cv.lh */, RISCV::CV_LH_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5114 /* cv.lh */, RISCV::CV_LH_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5120 /* cv.lhu */, RISCV::CV_LHU_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5120 /* cv.lhu */, RISCV::CV_LHU_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5120 /* cv.lhu */, RISCV::CV_LHU_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5127 /* cv.lw */, RISCV::CV_LW_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5127 /* cv.lw */, RISCV::CV_LW_rr_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5127 /* cv.lw */, RISCV::CV_LW_ri_inc, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5133 /* cv.mac */, RISCV::CV_MAC, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5140 /* cv.machhsn */, RISCV::CV_MACHHSN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5151 /* cv.machhsrn */, RISCV::CV_MACHHSRN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5163 /* cv.machhun */, RISCV::CV_MACHHUN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5174 /* cv.machhurn */, RISCV::CV_MACHHURN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5186 /* cv.macsn */, RISCV::CV_MACSN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5195 /* cv.macsrn */, RISCV::CV_MACSRN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5205 /* cv.macun */, RISCV::CV_MACUN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5214 /* cv.macurn */, RISCV::CV_MACURN, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5224 /* cv.max */, RISCV::CV_MAX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5231 /* cv.max.b */, RISCV::CV_MAX_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5240 /* cv.max.h */, RISCV::CV_MAX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5249 /* cv.max.sc.b */, RISCV::CV_MAX_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5261 /* cv.max.sc.h */, RISCV::CV_MAX_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5273 /* cv.max.sci.b */, RISCV::CV_MAX_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5286 /* cv.max.sci.h */, RISCV::CV_MAX_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5299 /* cv.maxu */, RISCV::CV_MAXU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5307 /* cv.maxu.b */, RISCV::CV_MAXU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5317 /* cv.maxu.h */, RISCV::CV_MAXU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5327 /* cv.maxu.sc.b */, RISCV::CV_MAXU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5340 /* cv.maxu.sc.h */, RISCV::CV_MAXU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5353 /* cv.maxu.sci.b */, RISCV::CV_MAXU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5367 /* cv.maxu.sci.h */, RISCV::CV_MAXU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5381 /* cv.min */, RISCV::CV_MIN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5388 /* cv.min.b */, RISCV::CV_MIN_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5397 /* cv.min.h */, RISCV::CV_MIN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5406 /* cv.min.sc.b */, RISCV::CV_MIN_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5418 /* cv.min.sc.h */, RISCV::CV_MIN_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5430 /* cv.min.sci.b */, RISCV::CV_MIN_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5443 /* cv.min.sci.h */, RISCV::CV_MIN_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5456 /* cv.minu */, RISCV::CV_MINU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5464 /* cv.minu.b */, RISCV::CV_MINU_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5474 /* cv.minu.h */, RISCV::CV_MINU_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5484 /* cv.minu.sc.b */, RISCV::CV_MINU_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5497 /* cv.minu.sc.h */, RISCV::CV_MINU_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5510 /* cv.minu.sci.b */, RISCV::CV_MINU_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5524 /* cv.minu.sci.h */, RISCV::CV_MINU_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5538 /* cv.msu */, RISCV::CV_MSU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5545 /* cv.mulhhs */, RISCV::CV_MULHHSN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5555 /* cv.mulhhsn */, RISCV::CV_MULHHSN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5566 /* cv.mulhhsrn */, RISCV::CV_MULHHSRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5578 /* cv.mulhhu */, RISCV::CV_MULHHUN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5588 /* cv.mulhhun */, RISCV::CV_MULHHUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5599 /* cv.mulhhurn */, RISCV::CV_MULHHURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5611 /* cv.muls */, RISCV::CV_MULSN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5619 /* cv.mulsn */, RISCV::CV_MULSN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5628 /* cv.mulsrn */, RISCV::CV_MULSRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5638 /* cv.mulu */, RISCV::CV_MULUN, Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5646 /* cv.mulun */, RISCV::CV_MULUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5655 /* cv.mulurn */, RISCV::CV_MULURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCVmac_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 5665 /* cv.or.b */, RISCV::CV_OR_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5673 /* cv.or.h */, RISCV::CV_OR_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5681 /* cv.or.sc.b */, RISCV::CV_OR_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5692 /* cv.or.sc.h */, RISCV::CV_OR_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5703 /* cv.or.sci.b */, RISCV::CV_OR_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5715 /* cv.or.sci.h */, RISCV::CV_OR_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5727 /* cv.pack */, RISCV::CV_PACK, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5735 /* cv.pack.h */, RISCV::CV_PACK_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5745 /* cv.packhi.b */, RISCV::CV_PACKHI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5757 /* cv.packlo.b */, RISCV::CV_PACKLO_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5769 /* cv.ror */, RISCV::CV_ROR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVbitmanip_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5776 /* cv.sb */, RISCV::CV_SB_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 5776 /* cv.sb */, RISCV::CV_SB_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 5776 /* cv.sb */, RISCV::CV_SB_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 5782 /* cv.sdotsp.b */, RISCV::CV_SDOTSP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5794 /* cv.sdotsp.h */, RISCV::CV_SDOTSP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5806 /* cv.sdotsp.sc.b */, RISCV::CV_SDOTSP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5821 /* cv.sdotsp.sc.h */, RISCV::CV_SDOTSP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5836 /* cv.sdotsp.sci.b */, RISCV::CV_SDOTSP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5852 /* cv.sdotsp.sci.h */, RISCV::CV_SDOTSP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 5868 /* cv.sdotup.b */, RISCV::CV_SDOTUP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5880 /* cv.sdotup.h */, RISCV::CV_SDOTUP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5892 /* cv.sdotup.sc.b */, RISCV::CV_SDOTUP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5907 /* cv.sdotup.sc.h */, RISCV::CV_SDOTUP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5922 /* cv.sdotup.sci.b */, RISCV::CV_SDOTUP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5938 /* cv.sdotup.sci.h */, RISCV::CV_SDOTUP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 5954 /* cv.sdotusp.b */, RISCV::CV_SDOTUSP_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5967 /* cv.sdotusp.h */, RISCV::CV_SDOTUSP_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5980 /* cv.sdotusp.sc.b */, RISCV::CV_SDOTUSP_SC_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 5996 /* cv.sdotusp.sc.h */, RISCV::CV_SDOTUSP_SC_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6012 /* cv.sdotusp.sci.b */, RISCV::CV_SDOTUSP_SCI_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6029 /* cv.sdotusp.sci.h */, RISCV::CV_SDOTUSP_SCI_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6046 /* cv.sh */, RISCV::CV_SH_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 6046 /* cv.sh */, RISCV::CV_SH_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 6046 /* cv.sh */, RISCV::CV_SH_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 6052 /* cv.shuffle.b */, RISCV::CV_SHUFFLE_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6065 /* cv.shuffle.h */, RISCV::CV_SHUFFLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6078 /* cv.shuffle.sci.h */, RISCV::CV_SHUFFLE_SCI_H, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6095 /* cv.shuffle2.b */, RISCV::CV_SHUFFLE2_B, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6109 /* cv.shuffle2.h */, RISCV::CV_SHUFFLE2_H, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6123 /* cv.shufflei0.sci.b */, RISCV::CV_SHUFFLEI0_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6142 /* cv.shufflei1.sci.b */, RISCV::CV_SHUFFLEI1_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6161 /* cv.shufflei2.sci.b */, RISCV::CV_SHUFFLEI2_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6180 /* cv.shufflei3.sci.b */, RISCV::CV_SHUFFLEI3_SCI_B, Convert__Reg1_0__Reg1_1__UImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm6 }, },
  { 6199 /* cv.sle */, RISCV::CV_SLE, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6206 /* cv.sleu */, RISCV::CV_SLEU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6214 /* cv.sll.b */, RISCV::CV_SLL_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6223 /* cv.sll.h */, RISCV::CV_SLL_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6232 /* cv.sll.sc.b */, RISCV::CV_SLL_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6244 /* cv.sll.sc.h */, RISCV::CV_SLL_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6256 /* cv.sll.sci.b */, RISCV::CV_SLL_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 6269 /* cv.sll.sci.h */, RISCV::CV_SLL_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 6282 /* cv.sra.b */, RISCV::CV_SRA_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6291 /* cv.sra.h */, RISCV::CV_SRA_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6300 /* cv.sra.sc.b */, RISCV::CV_SRA_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6312 /* cv.sra.sc.h */, RISCV::CV_SRA_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6324 /* cv.sra.sci.b */, RISCV::CV_SRA_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 6337 /* cv.sra.sci.h */, RISCV::CV_SRA_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 6350 /* cv.srl.b */, RISCV::CV_SRL_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6359 /* cv.srl.h */, RISCV::CV_SRL_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6368 /* cv.srl.sc.b */, RISCV::CV_SRL_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6380 /* cv.srl.sc.h */, RISCV::CV_SRL_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6392 /* cv.srl.sci.b */, RISCV::CV_SRL_SCI_B, Convert__Reg1_0__Reg1_1__UImm31_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm3 }, },
  { 6405 /* cv.srl.sci.h */, RISCV::CV_SRL_SCI_H, Convert__Reg1_0__Reg1_1__UImm41_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_UImm4 }, },
  { 6418 /* cv.sub.b */, RISCV::CV_SUB_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6427 /* cv.sub.div2 */, RISCV::CV_SUB_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6439 /* cv.sub.div4 */, RISCV::CV_SUB_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6451 /* cv.sub.div8 */, RISCV::CV_SUB_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6463 /* cv.sub.h */, RISCV::CV_SUB_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6472 /* cv.sub.sc.b */, RISCV::CV_SUB_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6484 /* cv.sub.sc.h */, RISCV::CV_SUB_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6496 /* cv.sub.sci.b */, RISCV::CV_SUB_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6509 /* cv.sub.sci.h */, RISCV::CV_SUB_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6522 /* cv.subn */, RISCV::CV_SUBN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6530 /* cv.subnr */, RISCV::CV_SUBNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6539 /* cv.subrn */, RISCV::CV_SUBRN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6548 /* cv.subrnr */, RISCV::CV_SUBRNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6558 /* cv.subrotmj */, RISCV::CV_SUBROTMJ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6570 /* cv.subrotmj.div2 */, RISCV::CV_SUBROTMJ_DIV2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6587 /* cv.subrotmj.div4 */, RISCV::CV_SUBROTMJ_DIV4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6604 /* cv.subrotmj.div8 */, RISCV::CV_SUBROTMJ_DIV8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6621 /* cv.subun */, RISCV::CV_SUBUN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6630 /* cv.subunr */, RISCV::CV_SUBUNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6640 /* cv.suburn */, RISCV::CV_SUBURN, Convert__Reg1_0__Reg1_1__Reg1_2__UImm51_3, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 6650 /* cv.suburnr */, RISCV::CV_SUBURNR, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXCValu_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6661 /* cv.sw */, RISCV::CV_SW_rr, Convert__Reg1_0__RegReg2_1, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK_RegReg }, },
  { 6661 /* cv.sw */, RISCV::CV_SW_rr_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__Reg1_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_GPR }, },
  { 6661 /* cv.sw */, RISCV::CV_SW_ri_inc, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm121_4, AMFBS_HasVendorXCVmem_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm12 }, },
  { 6667 /* cv.xor.b */, RISCV::CV_XOR_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6676 /* cv.xor.h */, RISCV::CV_XOR_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6685 /* cv.xor.sc.b */, RISCV::CV_XOR_SC_B, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6697 /* cv.xor.sc.h */, RISCV::CV_XOR_SC_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6709 /* cv.xor.sci.b */, RISCV::CV_XOR_SCI_B, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6722 /* cv.xor.sci.h */, RISCV::CV_XOR_SCI_H, Convert__Reg1_0__Reg1_1__SImm61_2, AMFBS_HasVendorXCVsimd_IsRV32, { MCK_GPR, MCK_GPR, MCK_SImm6 }, },
  { 6735 /* czero.eqz */, RISCV::CZERO_EQZ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZicond, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6745 /* czero.nez */, RISCV::CZERO_NEZ, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZicond, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6755 /* div */, RISCV::DIV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6759 /* divu */, RISCV::DIVU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6764 /* divuw */, RISCV::DIVUW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6770 /* divw */, RISCV::DIVW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 6775 /* dret */, RISCV::DRET, Convert_NoOperands, AMFBS_None, {  }, },
  { 6780 /* ebreak */, RISCV::EBREAK, Convert_NoOperands, AMFBS_None, {  }, },
  { 6787 /* ecall */, RISCV::ECALL, Convert_NoOperands, AMFBS_None, {  }, },
  { 6793 /* fabs.d */, RISCV::FSGNJX_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 6793 /* fabs.d */, RISCV::FSGNJX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 6793 /* fabs.d */, RISCV::FSGNJX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 6800 /* fabs.h */, RISCV::FSGNJX_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 6800 /* fabs.h */, RISCV::FSGNJX_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 6807 /* fabs.s */, RISCV::FSGNJX_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 6807 /* fabs.s */, RISCV::FSGNJX_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 6814 /* fadd.d */, RISCV::FADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 6814 /* fadd.d */, RISCV::FADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6814 /* fadd.d */, RISCV::FADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6821 /* fadd.h */, RISCV::FADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 6821 /* fadd.h */, RISCV::FADD_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 6828 /* fadd.s */, RISCV::FADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 6828 /* fadd.s */, RISCV::FADD_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 6835 /* fclass.d */, RISCV::FCLASS_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64 }, },
  { 6835 /* fclass.d */, RISCV::FCLASS_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR }, },
  { 6835 /* fclass.d */, RISCV::FCLASS_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR }, },
  { 6844 /* fclass.h */, RISCV::FCLASS_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16 }, },
  { 6844 /* fclass.h */, RISCV::FCLASS_H_INX, Convert__Reg1_0__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16 }, },
  { 6853 /* fclass.s */, RISCV::FCLASS_S, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32 }, },
  { 6853 /* fclass.s */, RISCV::FCLASS_S_INX, Convert__Reg1_0__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32 }, },
  { 6862 /* fcvt.bf16.s */, RISCV::FCVT_BF16_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfbfmin, { MCK_FPR16, MCK_FPR32, MCK_FRMArg }, },
  { 6874 /* fcvt.d.h */, RISCV::FCVT_D_H, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZfhmin_HasStdExtD, { MCK_FPR64, MCK_FPR16, MCK_FRMArgLegacy }, },
  { 6874 /* fcvt.d.h */, RISCV::FCVT_D_H_INX, Convert__GPRF64AsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRAsFPR16, MCK_FRMArgLegacy }, },
  { 6874 /* fcvt.d.h */, RISCV::FCVT_D_H_IN32X, Convert__GPRPairAsFPR1_0__GPRAsFPR161_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRAsFPR16, MCK_FRMArgLegacy }, },
  { 6883 /* fcvt.d.l */, RISCV::FCVT_D_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_FRMArg }, },
  { 6883 /* fcvt.d.l */, RISCV::FCVT_D_L_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6892 /* fcvt.d.lu */, RISCV::FCVT_D_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_FRMArg }, },
  { 6892 /* fcvt.d.lu */, RISCV::FCVT_D_LU_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArg }, },
  { 6902 /* fcvt.d.s */, RISCV::FCVT_D_S, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR32, MCK_FRMArgLegacy }, },
  { 6902 /* fcvt.d.s */, RISCV::FCVT_D_S_INX, Convert__GPRF64AsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRAsFPR32, MCK_FRMArgLegacy }, },
  { 6902 /* fcvt.d.s */, RISCV::FCVT_D_S_IN32X, Convert__GPRPairAsFPR1_0__GPRAsFPR321_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRAsFPR32, MCK_FRMArgLegacy }, },
  { 6911 /* fcvt.d.w */, RISCV::FCVT_D_W, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_FRMArgLegacy }, },
  { 6911 /* fcvt.d.w */, RISCV::FCVT_D_W_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 6911 /* fcvt.d.w */, RISCV::FCVT_D_W_IN32X, Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 6920 /* fcvt.d.wu */, RISCV::FCVT_D_WU, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_FRMArgLegacy }, },
  { 6920 /* fcvt.d.wu */, RISCV::FCVT_D_WU_INX, Convert__GPRF64AsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 6920 /* fcvt.d.wu */, RISCV::FCVT_D_WU_IN32X, Convert__GPRPairAsFPR1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPR, MCK_FRMArgLegacy }, },
  { 6930 /* fcvt.h.d */, RISCV::FCVT_H_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfhmin_HasStdExtD, { MCK_FPR16, MCK_FPR64, MCK_FRMArg }, },
  { 6930 /* fcvt.h.d */, RISCV::FCVT_H_D_INX, Convert__GPRAsFPR161_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64, { MCK_GPRAsFPR16, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6930 /* fcvt.h.d */, RISCV::FCVT_H_D_IN32X, Convert__GPRAsFPR161_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32, { MCK_GPRAsFPR16, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 6939 /* fcvt.h.l */, RISCV::FCVT_H_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 6939 /* fcvt.h.l */, RISCV::FCVT_H_L_INX, Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPRAsFPR16, MCK_GPR, MCK_FRMArg }, },
  { 6948 /* fcvt.h.lu */, RISCV::FCVT_H_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 6948 /* fcvt.h.lu */, RISCV::FCVT_H_LU_INX, Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPRAsFPR16, MCK_GPR, MCK_FRMArg }, },
  { 6958 /* fcvt.h.s */, RISCV::FCVT_H_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK_FPR32, MCK_FRMArg }, },
  { 6958 /* fcvt.h.s */, RISCV::FCVT_H_S_INX, Convert__GPRAsFPR161_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZhinxmin, { MCK_GPRAsFPR16, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 6967 /* fcvt.h.w */, RISCV::FCVT_H_W, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 6967 /* fcvt.h.w */, RISCV::FCVT_H_W_INX, Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPR, MCK_FRMArg }, },
  { 6976 /* fcvt.h.wu */, RISCV::FCVT_H_WU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_GPR, MCK_FRMArg }, },
  { 6976 /* fcvt.h.wu */, RISCV::FCVT_H_WU_INX, Convert__GPRAsFPR161_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPR, MCK_FRMArg }, },
  { 6986 /* fcvt.l.d */, RISCV::FCVT_L_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 6986 /* fcvt.l.d */, RISCV::FCVT_L_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 6995 /* fcvt.l.h */, RISCV::FCVT_L_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 6995 /* fcvt.l.h */, RISCV::FCVT_L_H_INX, Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7004 /* fcvt.l.s */, RISCV::FCVT_L_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 7004 /* fcvt.l.s */, RISCV::FCVT_L_S_INX, Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7013 /* fcvt.lu.d */, RISCV::FCVT_LU_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 7013 /* fcvt.lu.d */, RISCV::FCVT_LU_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7023 /* fcvt.lu.h */, RISCV::FCVT_LU_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh_IsRV64, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 7023 /* fcvt.lu.h */, RISCV::FCVT_LU_H_INX, Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7033 /* fcvt.lu.s */, RISCV::FCVT_LU_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 7033 /* fcvt.lu.s */, RISCV::FCVT_LU_S_INX, Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPR, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7043 /* fcvt.s.bf16 */, RISCV::FCVT_S_BF16, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZfbfmin, { MCK_FPR32, MCK_FPR16, MCK_FRMArgLegacy }, },
  { 7055 /* fcvt.s.d */, RISCV::FCVT_S_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_FPR32, MCK_FPR64, MCK_FRMArg }, },
  { 7055 /* fcvt.s.d */, RISCV::FCVT_S_D_INX, Convert__GPRAsFPR321_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRAsFPR32, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7055 /* fcvt.s.d */, RISCV::FCVT_S_D_IN32X, Convert__GPRAsFPR321_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRAsFPR32, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7064 /* fcvt.s.h */, RISCV::FCVT_S_H, Convert__Reg1_0__Reg1_1__FRMArgLegacy1_2, AMFBS_HasStdExtZfhmin, { MCK_FPR32, MCK_FPR16, MCK_FRMArgLegacy }, },
  { 7064 /* fcvt.s.h */, RISCV::FCVT_S_H_INX, Convert__GPRAsFPR321_0__GPRAsFPR161_1__FRMArgLegacy1_2, AMFBS_HasStdExtZhinxmin, { MCK_GPRAsFPR32, MCK_GPRAsFPR16, MCK_FRMArgLegacy }, },
  { 7073 /* fcvt.s.l */, RISCV::FCVT_S_L, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 7073 /* fcvt.s.l */, RISCV::FCVT_S_L_INX, Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPRAsFPR32, MCK_GPR, MCK_FRMArg }, },
  { 7082 /* fcvt.s.lu */, RISCV::FCVT_S_LU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 7082 /* fcvt.s.lu */, RISCV::FCVT_S_LU_INX, Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx_IsRV64, { MCK_GPRAsFPR32, MCK_GPR, MCK_FRMArg }, },
  { 7092 /* fcvt.s.w */, RISCV::FCVT_S_W, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 7092 /* fcvt.s.w */, RISCV::FCVT_S_W_INX, Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPR, MCK_FRMArg }, },
  { 7101 /* fcvt.s.wu */, RISCV::FCVT_S_WU, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_FRMArg }, },
  { 7101 /* fcvt.s.wu */, RISCV::FCVT_S_WU_INX, Convert__GPRAsFPR321_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPR, MCK_FRMArg }, },
  { 7111 /* fcvt.w.d */, RISCV::FCVT_W_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 7111 /* fcvt.w.d */, RISCV::FCVT_W_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7111 /* fcvt.w.d */, RISCV::FCVT_W_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7120 /* fcvt.w.h */, RISCV::FCVT_W_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 7120 /* fcvt.w.h */, RISCV::FCVT_W_H_INX, Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7129 /* fcvt.w.s */, RISCV::FCVT_W_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 7129 /* fcvt.w.s */, RISCV::FCVT_W_S_INX, Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7138 /* fcvt.wu.d */, RISCV::FCVT_WU_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FRMArg }, },
  { 7138 /* fcvt.wu.d */, RISCV::FCVT_WU_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7138 /* fcvt.wu.d */, RISCV::FCVT_WU_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7148 /* fcvt.wu.h */, RISCV::FCVT_WU_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FRMArg }, },
  { 7148 /* fcvt.wu.h */, RISCV::FCVT_WU_H_INX, Convert__Reg1_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7158 /* fcvt.wu.s */, RISCV::FCVT_WU_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FRMArg }, },
  { 7158 /* fcvt.wu.s */, RISCV::FCVT_WU_S_INX, Convert__Reg1_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7168 /* fcvtmod.w.d */, RISCV::FCVTMOD_W_D, Convert__Reg1_0__Reg1_1__RTZArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_RTZArg }, },
  { 7180 /* fdiv.d */, RISCV::FDIV_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7180 /* fdiv.d */, RISCV::FDIV_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7180 /* fdiv.d */, RISCV::FDIV_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7187 /* fdiv.h */, RISCV::FDIV_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7187 /* fdiv.h */, RISCV::FDIV_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7194 /* fdiv.s */, RISCV::FDIV_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7194 /* fdiv.s */, RISCV::FDIV_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7201 /* fence */, RISCV::FENCE, Convert__imm_95_15__imm_95_15, AMFBS_None, {  }, },
  { 7201 /* fence */, RISCV::FENCE, Convert__FenceArg1_0__FenceArg1_1, AMFBS_None, { MCK_FenceArg, MCK_FenceArg }, },
  { 7207 /* fence.i */, RISCV::FENCE_I, Convert_NoOperands, AMFBS_None, {  }, },
  { 7215 /* fence.tso */, RISCV::FENCE_TSO, Convert_NoOperands, AMFBS_None, {  }, },
  { 7225 /* feq.d */, RISCV::FEQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7225 /* feq.d */, RISCV::FEQ_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7225 /* feq.d */, RISCV::FEQ_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7231 /* feq.h */, RISCV::FEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7231 /* feq.h */, RISCV::FEQ_H_INX, Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7237 /* feq.s */, RISCV::FEQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7237 /* feq.s */, RISCV::FEQ_S_INX, Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7243 /* fge.d */, RISCV::FLE_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7243 /* fge.d */, RISCV::FLE_D_INX, Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7243 /* fge.d */, RISCV::FLE_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7249 /* fge.h */, RISCV::FLE_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7249 /* fge.h */, RISCV::FLE_H_INX, Convert__Reg1_0__GPRAsFPR161_2__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7255 /* fge.s */, RISCV::FLE_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7255 /* fge.s */, RISCV::FLE_S_INX, Convert__Reg1_0__GPRAsFPR321_2__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7261 /* fgeq.d */, RISCV::FLEQ_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7268 /* fgeq.h */, RISCV::FLEQ_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7275 /* fgeq.s */, RISCV::FLEQ_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7282 /* fgt.d */, RISCV::FLT_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7282 /* fgt.d */, RISCV::FLT_D_INX, Convert__Reg1_0__GPRF64AsFPR1_2__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7282 /* fgt.d */, RISCV::FLT_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_2__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7288 /* fgt.h */, RISCV::FLT_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7288 /* fgt.h */, RISCV::FLT_H_INX, Convert__Reg1_0__GPRAsFPR161_2__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7294 /* fgt.s */, RISCV::FLT_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7294 /* fgt.s */, RISCV::FLT_S_INX, Convert__Reg1_0__GPRAsFPR321_2__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7300 /* fgtq.d */, RISCV::FLTQ_D, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7307 /* fgtq.h */, RISCV::FLTQ_H, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7314 /* fgtq.s */, RISCV::FLTQ_S, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7321 /* fld */, RISCV::PseudoFLD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_BareSymbol, MCK_GPR }, },
  { 7321 /* fld */, RISCV::FLD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7321 /* fld */, RISCV::FLD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7325 /* fle.d */, RISCV::FLE_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7325 /* fle.d */, RISCV::FLE_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7325 /* fle.d */, RISCV::FLE_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7331 /* fle.h */, RISCV::FLE_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7331 /* fle.h */, RISCV::FLE_H_INX, Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7337 /* fle.s */, RISCV::FLE_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7337 /* fle.s */, RISCV::FLE_S_INX, Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7343 /* fleq.d */, RISCV::FLEQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7350 /* fleq.h */, RISCV::FLEQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7357 /* fleq.s */, RISCV::FLEQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7364 /* flh */, RISCV::PseudoFLH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK_BareSymbol, MCK_GPR }, },
  { 7364 /* flh */, RISCV::FLH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7364 /* flh */, RISCV::FLH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7368 /* fli.d */, RISCV::FLI_D, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_LoadFPImm }, },
  { 7374 /* fli.h */, RISCV::FLI_H, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh, { MCK_FPR16, MCK_LoadFPImm }, },
  { 7380 /* fli.s */, RISCV::FLI_S, Convert__Reg1_0__LoadFPImm1_1, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_LoadFPImm }, },
  { 7386 /* flt.d */, RISCV::FLT_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7386 /* flt.d */, RISCV::FLT_D_INX, Convert__Reg1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7386 /* flt.d */, RISCV::FLT_D_IN32X, Convert__Reg1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7392 /* flt.h */, RISCV::FLT_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7392 /* flt.h */, RISCV::FLT_H_INX, Convert__Reg1_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPR, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7398 /* flt.s */, RISCV::FLT_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7398 /* flt.s */, RISCV::FLT_S_INX, Convert__Reg1_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPR, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7404 /* fltq.d */, RISCV::FLTQ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_GPR, MCK_FPR64, MCK_FPR64 }, },
  { 7411 /* fltq.h */, RISCV::FLTQ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_GPR, MCK_FPR16, MCK_FPR16 }, },
  { 7418 /* fltq.s */, RISCV::FLTQ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_GPR, MCK_FPR32, MCK_FPR32 }, },
  { 7425 /* flw */, RISCV::PseudoFLW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_BareSymbol, MCK_GPR }, },
  { 7425 /* flw */, RISCV::FLW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtF, { MCK_FPR32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7425 /* flw */, RISCV::FLW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7429 /* fmadd.d */, RISCV::FMADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7429 /* fmadd.d */, RISCV::FMADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7429 /* fmadd.d */, RISCV::FMADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7437 /* fmadd.h */, RISCV::FMADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7437 /* fmadd.h */, RISCV::FMADD_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7445 /* fmadd.s */, RISCV::FMADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7445 /* fmadd.s */, RISCV::FMADD_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7453 /* fmax.d */, RISCV::FMAX_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7453 /* fmax.d */, RISCV::FMAX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7453 /* fmax.d */, RISCV::FMAX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7460 /* fmax.h */, RISCV::FMAX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7460 /* fmax.h */, RISCV::FMAX_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7467 /* fmax.s */, RISCV::FMAX_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7467 /* fmax.s */, RISCV::FMAX_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7474 /* fmaxm.d */, RISCV::FMAXM_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7482 /* fmaxm.h */, RISCV::FMAXM_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7490 /* fmaxm.s */, RISCV::FMAXM_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7498 /* fmin.d */, RISCV::FMIN_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7498 /* fmin.d */, RISCV::FMIN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7498 /* fmin.d */, RISCV::FMIN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7505 /* fmin.h */, RISCV::FMIN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7505 /* fmin.h */, RISCV::FMIN_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7512 /* fmin.s */, RISCV::FMIN_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7512 /* fmin.s */, RISCV::FMIN_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7519 /* fminm.d */, RISCV::FMINM_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7527 /* fminm.h */, RISCV::FMINM_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7535 /* fminm.s */, RISCV::FMINM_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7543 /* fmsub.d */, RISCV::FMSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7543 /* fmsub.d */, RISCV::FMSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7543 /* fmsub.d */, RISCV::FMSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7551 /* fmsub.h */, RISCV::FMSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7551 /* fmsub.h */, RISCV::FMSUB_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7559 /* fmsub.s */, RISCV::FMSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7559 /* fmsub.s */, RISCV::FMSUB_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7567 /* fmul.d */, RISCV::FMUL_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7567 /* fmul.d */, RISCV::FMUL_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7567 /* fmul.d */, RISCV::FMUL_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7574 /* fmul.h */, RISCV::FMUL_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7574 /* fmul.h */, RISCV::FMUL_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7581 /* fmul.s */, RISCV::FMUL_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7581 /* fmul.s */, RISCV::FMUL_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7588 /* fmv.d */, RISCV::FSGNJ_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 7588 /* fmv.d */, RISCV::FSGNJ_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7588 /* fmv.d */, RISCV::FSGNJ_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7594 /* fmv.d.x */, RISCV::FMV_D_X, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR }, },
  { 7602 /* fmv.h */, RISCV::FSGNJ_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 7602 /* fmv.h */, RISCV::FSGNJ_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7608 /* fmv.h.x */, RISCV::FMV_H_X, Convert__Reg1_0__Reg1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_GPR }, },
  { 7616 /* fmv.s */, RISCV::FSGNJ_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 7616 /* fmv.s */, RISCV::FSGNJ_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7622 /* fmv.w.x */, RISCV::FMV_W_X, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_GPR }, },
  { 7630 /* fmv.x.d */, RISCV::FMV_X_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtD_IsRV64, { MCK_GPR, MCK_FPR64 }, },
  { 7638 /* fmv.x.h */, RISCV::FMV_X_H, Convert__Reg1_0__Reg1_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_GPR, MCK_FPR16 }, },
  { 7646 /* fmv.x.w */, RISCV::FMV_X_W, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtF, { MCK_GPR, MCK_FPR32 }, },
  { 7654 /* fmvh.x.d */, RISCV::FMVH_X_D, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZfa_HasStdExtD_IsRV32, { MCK_GPR, MCK_FPR64 }, },
  { 7663 /* fmvp.d.x */, RISCV::FMVP_D_X, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfa_HasStdExtD_IsRV32, { MCK_FPR64, MCK_GPR, MCK_GPR }, },
  { 7672 /* fneg.d */, RISCV::FSGNJN_D, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64 }, },
  { 7672 /* fneg.d */, RISCV::FSGNJN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_1, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7672 /* fneg.d */, RISCV::FSGNJN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_1, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7679 /* fneg.h */, RISCV::FSGNJN_H, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16 }, },
  { 7679 /* fneg.h */, RISCV::FSGNJN_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_1, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7686 /* fneg.s */, RISCV::FSGNJN_S, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32 }, },
  { 7686 /* fneg.s */, RISCV::FSGNJN_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_1, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7693 /* fnmadd.d */, RISCV::FNMADD_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7693 /* fnmadd.d */, RISCV::FNMADD_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7693 /* fnmadd.d */, RISCV::FNMADD_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7702 /* fnmadd.h */, RISCV::FNMADD_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7702 /* fnmadd.h */, RISCV::FNMADD_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7711 /* fnmadd.s */, RISCV::FNMADD_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7711 /* fnmadd.s */, RISCV::FNMADD_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7720 /* fnmsub.d */, RISCV::FNMSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7720 /* fnmsub.d */, RISCV::FNMSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__GPRF64AsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7720 /* fnmsub.d */, RISCV::FNMSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__GPRPairAsFPR1_3__FRMArg1_4, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7729 /* fnmsub.h */, RISCV::FNMSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7729 /* fnmsub.h */, RISCV::FNMSUB_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__GPRAsFPR161_3__FRMArg1_4, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7738 /* fnmsub.s */, RISCV::FNMSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__FRMArg1_4, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7738 /* fnmsub.s */, RISCV::FNMSUB_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__GPRAsFPR321_3__FRMArg1_4, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7747 /* frcsr */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3__regX0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 7753 /* frflags */, RISCV::CSRRS, Convert__Reg1_0__imm_95_1__regX0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 7761 /* fround.d */, RISCV::FROUND_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7770 /* fround.h */, RISCV::FROUND_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7779 /* fround.s */, RISCV::FROUND_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7788 /* froundnx.d */, RISCV::FROUNDNX_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7799 /* froundnx.h */, RISCV::FROUNDNX_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7810 /* froundnx.s */, RISCV::FROUNDNX_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfa, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7821 /* frrm */, RISCV::CSRRS, Convert__Reg1_0__imm_95_2__regX0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 7826 /* frsr */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3__regX0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 7831 /* fscsr */, RISCV::CSRRW, Convert__regX0__imm_95_3__Reg1_0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 7831 /* fscsr */, RISCV::CSRRW, Convert__Reg1_0__imm_95_3__Reg1_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_GPR }, },
  { 7837 /* fsd */, RISCV::PseudoFSD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_BareSymbol, MCK_GPR }, },
  { 7837 /* fsd */, RISCV::FSD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtD, { MCK_FPR64, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7837 /* fsd */, RISCV::FSD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtD, { MCK_FPR64, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7841 /* fsflags */, RISCV::CSRRW, Convert__regX0__imm_95_1__Reg1_0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 7841 /* fsflags */, RISCV::CSRRW, Convert__Reg1_0__imm_95_1__Reg1_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_GPR }, },
  { 7849 /* fsflagsi */, RISCV::CSRRWI, Convert__regX0__imm_95_1__UImm51_0, AMFBS_HasStdExtFOrZfinx, { MCK_UImm5 }, },
  { 7849 /* fsflagsi */, RISCV::CSRRWI, Convert__Reg1_0__imm_95_1__UImm51_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_UImm5 }, },
  { 7858 /* fsgnj.d */, RISCV::FSGNJ_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7858 /* fsgnj.d */, RISCV::FSGNJ_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7858 /* fsgnj.d */, RISCV::FSGNJ_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7866 /* fsgnj.h */, RISCV::FSGNJ_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7866 /* fsgnj.h */, RISCV::FSGNJ_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7874 /* fsgnj.s */, RISCV::FSGNJ_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7874 /* fsgnj.s */, RISCV::FSGNJ_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7882 /* fsgnjn.d */, RISCV::FSGNJN_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7882 /* fsgnjn.d */, RISCV::FSGNJN_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7882 /* fsgnjn.d */, RISCV::FSGNJN_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7891 /* fsgnjn.h */, RISCV::FSGNJN_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7891 /* fsgnjn.h */, RISCV::FSGNJN_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7900 /* fsgnjn.s */, RISCV::FSGNJN_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7900 /* fsgnjn.s */, RISCV::FSGNJN_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7909 /* fsgnjx.d */, RISCV::FSGNJX_D, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64 }, },
  { 7909 /* fsgnjx.d */, RISCV::FSGNJX_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR }, },
  { 7909 /* fsgnjx.d */, RISCV::FSGNJX_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR }, },
  { 7918 /* fsgnjx.h */, RISCV::FSGNJX_H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16 }, },
  { 7918 /* fsgnjx.h */, RISCV::FSGNJX_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16 }, },
  { 7927 /* fsgnjx.s */, RISCV::FSGNJX_S, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32 }, },
  { 7927 /* fsgnjx.s */, RISCV::FSGNJX_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32 }, },
  { 7936 /* fsh */, RISCV::PseudoFSH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK_BareSymbol, MCK_GPR }, },
  { 7936 /* fsh */, RISCV::FSH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtZfhmin, { MCK_FPR16, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7936 /* fsh */, RISCV::FSH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasHalfFPLoadStoreMove, { MCK_FPR16, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 7940 /* fsqrt.d */, RISCV::FSQRT_D, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7940 /* fsqrt.d */, RISCV::FSQRT_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7940 /* fsqrt.d */, RISCV::FSQRT_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__FRMArg1_2, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7948 /* fsqrt.h */, RISCV::FSQRT_H, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7948 /* fsqrt.h */, RISCV::FSQRT_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__FRMArg1_2, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7956 /* fsqrt.s */, RISCV::FSQRT_S, Convert__Reg1_0__Reg1_1__FRMArg1_2, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7956 /* fsqrt.s */, RISCV::FSQRT_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__FRMArg1_2, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 7964 /* fsrm */, RISCV::CSRRW, Convert__regX0__imm_95_2__Reg1_0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 7964 /* fsrm */, RISCV::CSRRW, Convert__Reg1_0__imm_95_2__Reg1_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_GPR }, },
  { 7969 /* fsrmi */, RISCV::CSRRWI, Convert__regX0__imm_95_2__UImm51_0, AMFBS_HasStdExtFOrZfinx, { MCK_UImm5 }, },
  { 7969 /* fsrmi */, RISCV::CSRRWI, Convert__Reg1_0__imm_95_2__UImm51_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_UImm5 }, },
  { 7975 /* fssr */, RISCV::CSRRW, Convert__regX0__imm_95_3__Reg1_0, AMFBS_HasStdExtFOrZfinx, { MCK_GPR }, },
  { 7975 /* fssr */, RISCV::CSRRW, Convert__Reg1_0__imm_95_3__Reg1_1, AMFBS_HasStdExtFOrZfinx, { MCK_GPR, MCK_GPR }, },
  { 7980 /* fsub.d */, RISCV::FSUB_D, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtD, { MCK_FPR64, MCK_FPR64, MCK_FPR64, MCK_FRMArg }, },
  { 7980 /* fsub.d */, RISCV::FSUB_D_INX, Convert__GPRF64AsFPR1_0__GPRF64AsFPR1_1__GPRF64AsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV64, { MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_GPRF64AsFPR, MCK_FRMArg }, },
  { 7980 /* fsub.d */, RISCV::FSUB_D_IN32X, Convert__GPRPairAsFPR1_0__GPRPairAsFPR1_1__GPRPairAsFPR1_2__FRMArg1_3, AMFBS_HasStdExtZdinx_IsRV32, { MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_GPRPairAsFPR, MCK_FRMArg }, },
  { 7987 /* fsub.h */, RISCV::FSUB_H, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtZfh, { MCK_FPR16, MCK_FPR16, MCK_FPR16, MCK_FRMArg }, },
  { 7987 /* fsub.h */, RISCV::FSUB_H_INX, Convert__GPRAsFPR161_0__GPRAsFPR161_1__GPRAsFPR161_2__FRMArg1_3, AMFBS_HasStdExtZhinx, { MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_GPRAsFPR16, MCK_FRMArg }, },
  { 7994 /* fsub.s */, RISCV::FSUB_S, Convert__Reg1_0__Reg1_1__Reg1_2__FRMArg1_3, AMFBS_HasStdExtF, { MCK_FPR32, MCK_FPR32, MCK_FPR32, MCK_FRMArg }, },
  { 7994 /* fsub.s */, RISCV::FSUB_S_INX, Convert__GPRAsFPR321_0__GPRAsFPR321_1__GPRAsFPR321_2__FRMArg1_3, AMFBS_HasStdExtZfinx, { MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_GPRAsFPR32, MCK_FRMArg }, },
  { 8001 /* fsw */, RISCV::PseudoFSW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_BareSymbol, MCK_GPR }, },
  { 8001 /* fsw */, RISCV::FSW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasStdExtF, { MCK_FPR32, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8001 /* fsw */, RISCV::FSW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_HasStdExtF, { MCK_FPR32, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8005 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 8005 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 8005 /* hfence.gvma */, RISCV::HFENCE_GVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_GPR }, },
  { 8017 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 8017 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 8017 /* hfence.vvma */, RISCV::HFENCE_VVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_GPR }, },
  { 8029 /* hinval.gvma */, RISCV::HINVAL_GVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 8041 /* hinval.vvma */, RISCV::HINVAL_VVMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 8053 /* hlv.b */, RISCV::HLV_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8059 /* hlv.bu */, RISCV::HLV_BU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8066 /* hlv.d */, RISCV::HLV_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8072 /* hlv.h */, RISCV::HLV_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8078 /* hlv.hu */, RISCV::HLV_HU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8085 /* hlv.w */, RISCV::HLV_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8091 /* hlv.wu */, RISCV::HLV_WU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8098 /* hlvx.hu */, RISCV::HLVX_HU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8106 /* hlvx.wu */, RISCV::HLVX_WU, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8114 /* hsv.b */, RISCV::HSV_B, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8120 /* hsv.d */, RISCV::HSV_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_IsRV64_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8126 /* hsv.h */, RISCV::HSV_H, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8132 /* hsv.w */, RISCV::HSV_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtH, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8138 /* j */, RISCV::JAL, Convert__regX0__SImm21Lsb0JAL1_0, AMFBS_None, { MCK_SImm21Lsb0JAL }, },
  { 8140 /* jal */, RISCV::JAL, Convert__regX1__SImm21Lsb0JAL1_0, AMFBS_None, { MCK_SImm21Lsb0JAL }, },
  { 8140 /* jal */, RISCV::JAL, Convert__Reg1_0__SImm21Lsb0JAL1_1, AMFBS_None, { MCK_GPR, MCK_SImm21Lsb0JAL }, },
  { 8144 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_0__imm_95_0, AMFBS_None, { MCK_GPR }, },
  { 8144 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8144 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 8144 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_1__imm_95_0, AMFBS_None, { MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8144 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 8144 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8144 /* jalr */, RISCV::JALR, Convert__regX1__Reg1_2__SImm121_0, AMFBS_None, { MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8144 /* jalr */, RISCV::JALR, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8144 /* jalr */, RISCV::PseudoTLSDESCCall, Convert__Reg1_0__Reg1_3__SImm121_1__TLSDESCCallSymbol1_5, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_, MCK_TLSDESCCallSymbol }, },
  { 8149 /* jr */, RISCV::JALR, Convert__regX0__Reg1_0__imm_95_0, AMFBS_None, { MCK_GPR }, },
  { 8149 /* jr */, RISCV::JALR, Convert__regX0__Reg1_0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 8149 /* jr */, RISCV::JALR, Convert__regX0__Reg1_1__imm_95_0, AMFBS_None, { MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8149 /* jr */, RISCV::JALR, Convert__regX0__Reg1_2__SImm121_0, AMFBS_None, { MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8152 /* jump */, RISCV::PseudoJump, Convert__Reg1_1__PseudoJumpSymbol1_0, AMFBS_None, { MCK_PseudoJumpSymbol, MCK_GPR }, },
  { 8157 /* la */, RISCV::PseudoLA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8157 /* la */, RISCV::PseudoLAImm, Convert__Reg1_0__ImmXLenLI_Restricted1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI_Restricted }, },
  { 8160 /* la.tls.gd */, RISCV::PseudoLA_TLS_GD, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8170 /* la.tls.ie */, RISCV::PseudoLA_TLS_IE, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8180 /* la.tlsdesc */, RISCV::PseudoLA_TLSDESC, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8191 /* lb */, RISCV::PseudoLB, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8191 /* lb */, RISCV::LB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8191 /* lb */, RISCV::LB, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8194 /* lb.aq */, RISCV::LB_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8200 /* lb.aqrl */, RISCV::LB_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8208 /* lbu */, RISCV::PseudoLBU, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8208 /* lbu */, RISCV::LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8208 /* lbu */, RISCV::LBU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8212 /* ld */, RISCV::PseudoLD, Convert__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol }, },
  { 8212 /* ld */, RISCV::LD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8212 /* ld */, RISCV::LD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8215 /* ld.aq */, RISCV::LD_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8221 /* ld.aqrl */, RISCV::LD_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8229 /* lga */, RISCV::PseudoLGA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8233 /* lh */, RISCV::PseudoLH, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8233 /* lh */, RISCV::LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8233 /* lh */, RISCV::LH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8236 /* lh.aq */, RISCV::LH_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8242 /* lh.aqrl */, RISCV::LH_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8250 /* lhu */, RISCV::PseudoLHU, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8250 /* lhu */, RISCV::LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8250 /* lhu */, RISCV::LHU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8254 /* li */, RISCV::ADDI, Convert__Reg1_0__regX0__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12 }, },
  { 8254 /* li */, RISCV::PseudoLI, Convert__Reg1_0__ImmXLenLI1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI }, },
  { 8257 /* lla */, RISCV::PseudoLLA, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8257 /* lla */, RISCV::PseudoLLAImm, Convert__Reg1_0__ImmXLenLI_Restricted1_1, AMFBS_None, { MCK_GPR, MCK_ImmXLenLI_Restricted }, },
  { 8261 /* lpad */, RISCV::AUIPC, Convert__regX0__UImm201_0, AMFBS_HasStdExtZicfilp, { MCK_UImm20 }, },
  { 8266 /* lr.d */, RISCV::LR_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8271 /* lr.d.aq */, RISCV::LR_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8279 /* lr.d.aqrl */, RISCV::LR_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8289 /* lr.d.rl */, RISCV::LR_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8297 /* lr.w */, RISCV::LR_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8302 /* lr.w.aq */, RISCV::LR_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8310 /* lr.w.aqrl */, RISCV::LR_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8320 /* lr.w.rl */, RISCV::LR_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8328 /* lui */, RISCV::LUI, Convert__Reg1_0__UImm20LUI1_1, AMFBS_None, { MCK_GPR, MCK_UImm20LUI }, },
  { 8332 /* lw */, RISCV::PseudoLW, Convert__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol }, },
  { 8332 /* lw */, RISCV::LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8332 /* lw */, RISCV::LW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8335 /* lw.aq */, RISCV::LW_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8341 /* lw.aqrl */, RISCV::LW_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 8349 /* lwu */, RISCV::PseudoLWU, Convert__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol }, },
  { 8349 /* lwu */, RISCV::LWU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8349 /* lwu */, RISCV::LWU, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8353 /* max */, RISCV::MAX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8357 /* maxu */, RISCV::MAXU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8362 /* min */, RISCV::MIN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8366 /* minu */, RISCV::MINU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8371 /* mips.ccmov */, RISCV::CCMOV, Convert__Reg1_0__Reg1_2__Reg1_1__Reg1_3, AMFBS_HasVendorXMIPSCMove, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8382 /* mips.ldp */, RISCV::LDP, Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb0001_2, AMFBS_HasVendorXMIPSLSP, { MCK_GPR, MCK_GPR, MCK_UImm7Lsb000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8391 /* mips.lwp */, RISCV::LWP, Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb001_2, AMFBS_HasVendorXMIPSLSP, { MCK_GPR, MCK_GPR, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8400 /* mips.sdp */, RISCV::SDP, Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb0001_2, AMFBS_HasVendorXMIPSLSP, { MCK_GPR, MCK_GPR, MCK_UImm7Lsb000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8409 /* mips.swp */, RISCV::SWP, Convert__Reg1_0__Reg1_1__Reg1_4__UImm7Lsb001_2, AMFBS_HasVendorXMIPSLSP, { MCK_GPR, MCK_GPR, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8418 /* mnret */, RISCV::MNRET, Convert_NoOperands, AMFBS_HasStdExtSmrnmi, {  }, },
  { 8424 /* mop.r.0 */, RISCV::MOPR0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8432 /* mop.r.1 */, RISCV::MOPR1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8440 /* mop.r.10 */, RISCV::MOPR10, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8449 /* mop.r.11 */, RISCV::MOPR11, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8458 /* mop.r.12 */, RISCV::MOPR12, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8467 /* mop.r.13 */, RISCV::MOPR13, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8476 /* mop.r.14 */, RISCV::MOPR14, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8485 /* mop.r.15 */, RISCV::MOPR15, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8494 /* mop.r.16 */, RISCV::MOPR16, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8503 /* mop.r.17 */, RISCV::MOPR17, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8512 /* mop.r.18 */, RISCV::MOPR18, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8521 /* mop.r.19 */, RISCV::MOPR19, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8530 /* mop.r.2 */, RISCV::MOPR2, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8538 /* mop.r.20 */, RISCV::MOPR20, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8547 /* mop.r.21 */, RISCV::MOPR21, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8556 /* mop.r.22 */, RISCV::MOPR22, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8565 /* mop.r.23 */, RISCV::MOPR23, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8574 /* mop.r.24 */, RISCV::MOPR24, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8583 /* mop.r.25 */, RISCV::MOPR25, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8592 /* mop.r.26 */, RISCV::MOPR26, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8601 /* mop.r.27 */, RISCV::MOPR27, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8610 /* mop.r.28 */, RISCV::MOPR28, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8619 /* mop.r.29 */, RISCV::MOPR29, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8628 /* mop.r.3 */, RISCV::MOPR3, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8636 /* mop.r.30 */, RISCV::MOPR30, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8645 /* mop.r.31 */, RISCV::MOPR31, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8654 /* mop.r.4 */, RISCV::MOPR4, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8662 /* mop.r.5 */, RISCV::MOPR5, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8670 /* mop.r.6 */, RISCV::MOPR6, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8678 /* mop.r.7 */, RISCV::MOPR7, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8686 /* mop.r.8 */, RISCV::MOPR8, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8694 /* mop.r.9 */, RISCV::MOPR9, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR }, },
  { 8702 /* mop.rr.0 */, RISCV::MOPRR0, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8711 /* mop.rr.1 */, RISCV::MOPRR1, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8720 /* mop.rr.2 */, RISCV::MOPRR2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8729 /* mop.rr.3 */, RISCV::MOPRR3, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8738 /* mop.rr.4 */, RISCV::MOPRR4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8747 /* mop.rr.5 */, RISCV::MOPRR5, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8756 /* mop.rr.6 */, RISCV::MOPRR6, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8765 /* mop.rr.7 */, RISCV::MOPRR7, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZimop, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8774 /* mret */, RISCV::MRET, Convert_NoOperands, AMFBS_None, {  }, },
  { 8779 /* mul */, RISCV::MUL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8783 /* mulh */, RISCV::MULH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8788 /* mulhsu */, RISCV::MULHSU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8795 /* mulhu */, RISCV::MULHU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8801 /* mulw */, RISCV::MULW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZmmul_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8806 /* mv */, RISCV::ADDI, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8809 /* neg */, RISCV::SUB, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8813 /* negw */, RISCV::SUBW, Convert__Reg1_0__regX0__Reg1_1, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 8818 /* nop */, RISCV::ADDI, Convert__regX0__regX0__imm_95_0, AMFBS_None, {  }, },
  { 8822 /* not */, RISCV::XORI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 8826 /* ntl.all */, RISCV::ADD, Convert__regX0__regX0__regX5, AMFBS_HasStdExtZihintntl, {  }, },
  { 8834 /* ntl.p1 */, RISCV::ADD, Convert__regX0__regX0__regX2, AMFBS_HasStdExtZihintntl, {  }, },
  { 8841 /* ntl.pall */, RISCV::ADD, Convert__regX0__regX0__regX3, AMFBS_HasStdExtZihintntl, {  }, },
  { 8850 /* ntl.s1 */, RISCV::ADD, Convert__regX0__regX0__regX4, AMFBS_HasStdExtZihintntl, {  }, },
  { 8857 /* or */, RISCV::OR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8857 /* or */, RISCV::ORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 8860 /* orc.b */, RISCV::ORC_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 8866 /* ori */, RISCV::ORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 8870 /* orn */, RISCV::ORN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8874 /* pack */, RISCV::PACK, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8879 /* packh */, RISCV::PACKH, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8885 /* packw */, RISCV::PACKW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 8891 /* pause */, RISCV::FENCE, Convert__imm_95_1__imm_95_0, AMFBS_HasStdExtZihintpause, {  }, },
  { 8897 /* prefetch.i */, RISCV::PREFETCH_I, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8908 /* prefetch.r */, RISCV::PREFETCH_R, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8919 /* prefetch.w */, RISCV::PREFETCH_W, Convert__Reg1_2__SImm12Lsb000001_0, AMFBS_HasStdExtZicbop, { MCK_SImm12Lsb00000, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 8930 /* qc.addsat */, RISCV::QC_ADDSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 8940 /* qc.addusat */, RISCV::QC_ADDUSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 8951 /* qc.c.clrint */, RISCV::QC_C_CLRINT, Convert__Reg1_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_GPRNoX0 }, },
  { 8963 /* qc.c.di */, RISCV::QC_C_DI, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 8971 /* qc.c.dir */, RISCV::QC_C_DIR, Convert__Reg1_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_GPRNoX0 }, },
  { 8980 /* qc.c.ei */, RISCV::QC_C_EI, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 8988 /* qc.c.eir */, RISCV::QC_C_EIR, Convert__Reg1_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_GPRNoX0 }, },
  { 8997 /* qc.c.mienter */, RISCV::QC_C_MIENTER, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 9010 /* qc.c.mienter.nest */, RISCV::QC_C_MIENTER_NEST, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 9028 /* qc.c.mileaveret */, RISCV::QC_C_MILEAVERET, Convert_NoOperands, AMFBS_HasVendorXqciint_IsRV32, {  }, },
  { 9044 /* qc.c.muliadd */, RISCV::QC_C_MULIADD, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2, AMFBS_HasVendorXqciac_IsRV32, { MCK_GPRC, MCK_GPRC, MCK_UImm5 }, },
  { 9057 /* qc.c.mveqz */, RISCV::QC_C_MVEQZ, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRC, MCK_GPRC }, },
  { 9068 /* qc.c.setint */, RISCV::QC_C_SETINT, Convert__Reg1_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_GPRNoX0 }, },
  { 9080 /* qc.clrinti */, RISCV::QC_CLRINTI, Convert__UImm101_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_UImm10 }, },
  { 9091 /* qc.csrrwr */, RISCV::QC_CSRRWR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcicsr_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0 }, },
  { 9101 /* qc.csrrwri */, RISCV::QC_CSRRWRI, Convert__Reg1_0__UImm51_1__Reg1_2, AMFBS_HasVendorXqcicsr_IsRV32, { MCK_GPR, MCK_UImm5, MCK_GPRNoX0 }, },
  { 9112 /* qc.e.lb */, RISCV::QC_E_LB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9112 /* qc.e.lb */, RISCV::QC_E_LB, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9120 /* qc.e.lbu */, RISCV::QC_E_LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9120 /* qc.e.lbu */, RISCV::QC_E_LBU, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9129 /* qc.e.lh */, RISCV::QC_E_LH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9129 /* qc.e.lh */, RISCV::QC_E_LH, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9137 /* qc.e.lhu */, RISCV::QC_E_LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9137 /* qc.e.lhu */, RISCV::QC_E_LHU, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9146 /* qc.e.lw */, RISCV::QC_E_LW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9146 /* qc.e.lw */, RISCV::QC_E_LW, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9154 /* qc.e.sb */, RISCV::QC_E_SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9154 /* qc.e.sb */, RISCV::QC_E_SB, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9162 /* qc.e.sh */, RISCV::QC_E_SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9162 /* qc.e.sh */, RISCV::QC_E_SH, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9170 /* qc.e.sw */, RISCV::QC_E_SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9170 /* qc.e.sw */, RISCV::QC_E_SW, Convert__Reg1_0__Reg1_3__SImm261_1, AMFBS_HasVendorXqcilo_IsRV32, { MCK_GPR, MCK_SImm26, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9178 /* qc.lieq */, RISCV::QC_LIEQ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9186 /* qc.lieqi */, RISCV::QC_LIEQI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 9195 /* qc.lige */, RISCV::QC_LIGE, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9203 /* qc.ligei */, RISCV::QC_LIGEI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 9212 /* qc.ligeu */, RISCV::QC_LIGEU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9221 /* qc.ligeui */, RISCV::QC_LIGEUI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5, MCK_SImm5 }, },
  { 9231 /* qc.lilt */, RISCV::QC_LILT, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9239 /* qc.lilti */, RISCV::QC_LILTI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 9248 /* qc.liltu */, RISCV::QC_LILTU, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9257 /* qc.liltui */, RISCV::QC_LILTUI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5, MCK_SImm5 }, },
  { 9267 /* qc.line */, RISCV::QC_LINE, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9275 /* qc.linei */, RISCV::QC_LINEI, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcicli_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 9284 /* qc.lrb */, RISCV::QC_LRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 9291 /* qc.lrbu */, RISCV::QC_LRBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 9299 /* qc.lrh */, RISCV::QC_LRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 9306 /* qc.lrhu */, RISCV::QC_LRHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 9314 /* qc.lrw */, RISCV::QC_LRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 9321 /* qc.lwm */, RISCV::QC_LWM, Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9321 /* qc.lwm */, RISCV::QC_LWM, Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9328 /* qc.lwmi */, RISCV::QC_LWMI, Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_UImm5NonZero, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9328 /* qc.lwmi */, RISCV::QC_LWMI, Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPRNoX0, MCK_UImm5NonZero, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9336 /* qc.muliadd */, RISCV::QC_MULIADD, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm121_2, AMFBS_HasVendorXqciac_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm12 }, },
  { 9347 /* qc.mveq */, RISCV::QC_MVEQ, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9355 /* qc.mveqi */, RISCV::QC_MVEQI, Convert__Reg1_0__Reg1_1__SImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0 }, },
  { 9364 /* qc.mvge */, RISCV::QC_MVGE, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9372 /* qc.mvgei */, RISCV::QC_MVGEI, Convert__Reg1_0__Reg1_1__SImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0 }, },
  { 9381 /* qc.mvgeu */, RISCV::QC_MVGEU, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9390 /* qc.mvgeui */, RISCV::QC_MVGEUI, Convert__Reg1_0__Reg1_1__UImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5, MCK_GPRNoX0 }, },
  { 9400 /* qc.mvlt */, RISCV::QC_MVLT, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9408 /* qc.mvlti */, RISCV::QC_MVLTI, Convert__Reg1_0__Reg1_1__SImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0 }, },
  { 9417 /* qc.mvltu */, RISCV::QC_MVLTU, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9426 /* qc.mvltui */, RISCV::QC_MVLTUI, Convert__Reg1_0__Reg1_1__UImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5, MCK_GPRNoX0 }, },
  { 9436 /* qc.mvne */, RISCV::QC_MVNE, Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9444 /* qc.mvnei */, RISCV::QC_MVNEI, Convert__Reg1_0__Reg1_1__SImm51_2__Reg1_3, AMFBS_HasVendorXqcicm_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0 }, },
  { 9453 /* qc.norm */, RISCV::QC_NORM, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9461 /* qc.normeu */, RISCV::QC_NORMEU, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9471 /* qc.normu */, RISCV::QC_NORMU, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9480 /* qc.selecteqi */, RISCV::QC_SELECTEQI, Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9493 /* qc.selectieq */, RISCV::QC_SELECTIEQ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9506 /* qc.selectieqi */, RISCV::QC_SELECTIEQI, Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9520 /* qc.selectiieq */, RISCV::QC_SELECTIIEQ, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 9534 /* qc.selectiine */, RISCV::QC_SELECTIINE, Convert__Reg1_0__Tie0_1_1__Reg1_1__SImm51_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5, MCK_SImm5 }, },
  { 9548 /* qc.selectine */, RISCV::QC_SELECTINE, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9561 /* qc.selectinei */, RISCV::QC_SELECTINEI, Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__SImm51_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0, MCK_SImm5 }, },
  { 9575 /* qc.selectnei */, RISCV::QC_SELECTNEI, Convert__Reg1_0__Tie0_1_1__SImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXqcics_IsRV32, { MCK_GPRNoX0, MCK_SImm5, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9588 /* qc.setinti */, RISCV::QC_SETINTI, Convert__UImm101_0, AMFBS_HasVendorXqciint_IsRV32, { MCK_UImm10 }, },
  { 9599 /* qc.setwm */, RISCV::QC_SETWM, Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_GPRNoX0, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9599 /* qc.setwm */, RISCV::QC_SETWM, Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_GPRNoX0, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9608 /* qc.setwmi */, RISCV::QC_SETWMI, Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_UImm5NonZero, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9608 /* qc.setwmi */, RISCV::QC_SETWMI, Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_UImm5NonZero, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9618 /* qc.shladd */, RISCV::QC_SHLADD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm5GT31_3, AMFBS_HasVendorXqciac_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm5GT3 }, },
  { 9628 /* qc.slasat */, RISCV::QC_SLASAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9638 /* qc.sllsat */, RISCV::QC_SLLSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9648 /* qc.srb */, RISCV::QC_SRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 9655 /* qc.srh */, RISCV::QC_SRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 9662 /* qc.srw */, RISCV::QC_SRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm31_3, AMFBS_HasVendorXqcisls_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPRNoX0, MCK_UImm3 }, },
  { 9669 /* qc.subsat */, RISCV::QC_SUBSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9679 /* qc.subusat */, RISCV::QC_SUBUSAT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_GPRNoX0 }, },
  { 9690 /* qc.swm */, RISCV::QC_SWM, Convert__Reg1_0__Reg1_3__Reg1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_GPRNoX0, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9690 /* qc.swm */, RISCV::QC_SWM, Convert__Reg1_0__Reg1_4__Reg1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_GPRNoX0, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9697 /* qc.swmi */, RISCV::QC_SWMI, Convert__Reg1_0__Reg1_3__UImm5NonZero1_1__imm_95_0, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_UImm5NonZero, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9697 /* qc.swmi */, RISCV::QC_SWMI, Convert__Reg1_0__Reg1_4__UImm5NonZero1_1__UImm7Lsb001_2, AMFBS_HasVendorXqcilsm_IsRV32, { MCK_GPR, MCK_UImm5NonZero, MCK_UImm7Lsb00, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9705 /* qc.wrap */, RISCV::QC_WRAP, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPR, MCK_GPRNoX0 }, },
  { 9713 /* qc.wrapi */, RISCV::QC_WRAPI, Convert__Reg1_0__Reg1_1__UImm111_2, AMFBS_HasVendorXqcia_IsRV32, { MCK_GPRNoX0, MCK_GPRNoX0, MCK_UImm11 }, },
  { 9722 /* qk.c.lbu */, RISCV::QK_C_LBU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 9722 /* qk.c.lbu */, RISCV::QK_C_LBU, Convert__Reg1_0__Reg1_3__UImm51_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm5, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 9731 /* qk.c.lbusp */, RISCV::QK_C_LBUSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 9731 /* qk.c.lbusp */, RISCV::QK_C_LBUSP, Convert__Reg1_0__Reg1_3__UImm41_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm4, MCK__40_, MCK_SP, MCK__41_ }, },
  { 9742 /* qk.c.lhu */, RISCV::QK_C_LHU, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 9742 /* qk.c.lhu */, RISCV::QK_C_LHU, Convert__Reg1_0__Reg1_3__UImm6Lsb01_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm6Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 9751 /* qk.c.lhusp */, RISCV::QK_C_LHUSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 9751 /* qk.c.lhusp */, RISCV::QK_C_LHUSP, Convert__Reg1_0__Reg1_3__UImm5Lsb01_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm5Lsb0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 9762 /* qk.c.sb */, RISCV::QK_C_SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 9762 /* qk.c.sb */, RISCV::QK_C_SB, Convert__Reg1_0__Reg1_3__UImm51_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm5, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 9770 /* qk.c.sbsp */, RISCV::QK_C_SBSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 9770 /* qk.c.sbsp */, RISCV::QK_C_SBSP, Convert__Reg1_0__Reg1_3__UImm41_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm4, MCK__40_, MCK_SP, MCK__41_ }, },
  { 9780 /* qk.c.sh */, RISCV::QK_C_SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 9780 /* qk.c.sh */, RISCV::QK_C_SH, Convert__Reg1_0__Reg1_3__UImm6Lsb01_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm6Lsb0, MCK__40_, MCK_GPRC, MCK__41_ }, },
  { 9788 /* qk.c.shsp */, RISCV::QK_C_SHSP, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK__40_, MCK_SP, MCK__41_ }, },
  { 9788 /* qk.c.shsp */, RISCV::QK_C_SHSP, Convert__Reg1_0__Reg1_3__UImm5Lsb01_1, AMFBS_HasVendorXwchc, { MCK_GPRC, MCK_UImm5Lsb0, MCK__40_, MCK_SP, MCK__41_ }, },
  { 9798 /* rdcycle */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3072__regX0, AMFBS_None, { MCK_GPR }, },
  { 9806 /* rdcycleh */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3200__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 9815 /* rdinstret */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3074__regX0, AMFBS_None, { MCK_GPR }, },
  { 9825 /* rdinstreth */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3202__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 9836 /* rdtime */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3073__regX0, AMFBS_None, { MCK_GPR }, },
  { 9843 /* rdtimeh */, RISCV::CSRRS, Convert__Reg1_0__imm_95_3201__regX0, AMFBS_IsRV32, { MCK_GPR }, },
  { 9851 /* rem */, RISCV::REM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9855 /* remu */, RISCV::REMU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9860 /* remuw */, RISCV::REMUW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9866 /* remw */, RISCV::REMW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtM_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9871 /* ret */, RISCV::JALR, Convert__regX0__regX1__imm_95_0, AMFBS_None, {  }, },
  { 9875 /* rev8 */, RISCV::REV8_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 9875 /* rev8 */, RISCV::REV8_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 9880 /* rol */, RISCV::ROL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9884 /* rolw */, RISCV::ROLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9889 /* ror */, RISCV::ROR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9889 /* ror */, RISCV::RORI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 9893 /* rori */, RISCV::RORI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 9898 /* roriw */, RISCV::RORIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 9904 /* rorw */, RISCV::RORW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 9904 /* rorw */, RISCV::RORIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 9909 /* sb */, RISCV::PseudoSB, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 9909 /* sb */, RISCV::SB, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9909 /* sb */, RISCV::SB, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9912 /* sb.aqrl */, RISCV::SB_AQ_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9920 /* sb.rl */, RISCV::SB_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9926 /* sc.d */, RISCV::SC_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9931 /* sc.d.aq */, RISCV::SC_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9939 /* sc.d.aqrl */, RISCV::SC_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9949 /* sc.d.rl */, RISCV::SC_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9957 /* sc.w */, RISCV::SC_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9962 /* sc.w.aq */, RISCV::SC_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9970 /* sc.w.aqrl */, RISCV::SC_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9980 /* sc.w.rl */, RISCV::SC_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZalrsc, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 9988 /* sctrclr */, RISCV::SCTRCLR, Convert_NoOperands, AMFBS_HasStdExtSmctrOrSsctr, {  }, },
  { 9996 /* sd */, RISCV::PseudoSD, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_IsRV64, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 9996 /* sd */, RISCV::SD, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9996 /* sd */, RISCV::SD, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_IsRV64, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 9999 /* sd.aqrl */, RISCV::SD_AQ_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 10007 /* sd.rl */, RISCV::SD_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr_IsRV64, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 10013 /* seqz */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__imm_95_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 10018 /* sext.b */, RISCV::SEXT_B, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 10018 /* sext.b */, RISCV::PseudoSEXT_B, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 10025 /* sext.h */, RISCV::SEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb, { MCK_GPR, MCK_GPR }, },
  { 10025 /* sext.h */, RISCV::PseudoSEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 10032 /* sext.w */, RISCV::ADDIW, Convert__Reg1_0__Reg1_1__imm_95_0, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 10039 /* sf.cdiscard.d.l1 */, RISCV::SF_CDISCARD_D_L1, Convert__regX0, AMFBS_HasVendorXSiFivecdiscarddlone, {  }, },
  { 10039 /* sf.cdiscard.d.l1 */, RISCV::SF_CDISCARD_D_L1, Convert__Reg1_0, AMFBS_HasVendorXSiFivecdiscarddlone, { MCK_GPR }, },
  { 10056 /* sf.cease */, RISCV::SF_CEASE, Convert_NoOperands, AMFBS_HasVendorXSfcease, {  }, },
  { 10065 /* sf.cflush.d.l1 */, RISCV::SF_CFLUSH_D_L1, Convert__regX0, AMFBS_HasVendorXSiFivecflushdlone, {  }, },
  { 10065 /* sf.cflush.d.l1 */, RISCV::SF_CFLUSH_D_L1, Convert__Reg1_0, AMFBS_HasVendorXSiFivecflushdlone, { MCK_GPR }, },
  { 10080 /* sf.vc.fv */, RISCV::VC_FV, Convert__UImm11_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_UImm5, MCK_VM, MCK_FPR32 }, },
  { 10089 /* sf.vc.fvv */, RISCV::VC_FVV, Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 10099 /* sf.vc.fvw */, RISCV::VC_FVW, Convert__UImm11_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 10109 /* sf.vc.i */, RISCV::VC_I, Convert__UImm21_0__UImm51_1__UImm51_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_UImm5, MCK_SImm5 }, },
  { 10117 /* sf.vc.iv */, RISCV::VC_IV, Convert__UImm21_0__UImm51_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_SImm5 }, },
  { 10126 /* sf.vc.ivv */, RISCV::VC_IVV, Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 10136 /* sf.vc.ivw */, RISCV::VC_IVW, Convert__UImm21_0__Reg1_1__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 10146 /* sf.vc.v.fv */, RISCV::VC_V_FV, Convert__Reg1_1__UImm11_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 10157 /* sf.vc.v.fvv */, RISCV::VC_V_FVV, Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 10169 /* sf.vc.v.fvw */, RISCV::VC_V_FVW, Convert__Reg1_1__UImm11_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm1, MCK_VM, MCK_VM, MCK_FPR32 }, },
  { 10181 /* sf.vc.v.i */, RISCV::VC_V_I, Convert__Reg1_2__UImm21_0__UImm51_1__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_SImm5 }, },
  { 10191 /* sf.vc.v.iv */, RISCV::VC_V_IV, Convert__Reg1_1__UImm21_0__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 10202 /* sf.vc.v.ivv */, RISCV::VC_V_IVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 10214 /* sf.vc.v.ivw */, RISCV::VC_V_IVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__SImm51_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 10226 /* sf.vc.v.vv */, RISCV::VC_V_VV, Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 10237 /* sf.vc.v.vvv */, RISCV::VC_V_VVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 10249 /* sf.vc.v.vvw */, RISCV::VC_V_VVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 10261 /* sf.vc.v.x */, RISCV::VC_V_X, Convert__Reg1_2__UImm21_0__UImm51_1__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_GPR }, },
  { 10271 /* sf.vc.v.xv */, RISCV::VC_V_XV, Convert__Reg1_1__UImm21_0__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 10282 /* sf.vc.v.xvv */, RISCV::VC_V_XVV, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 10294 /* sf.vc.v.xvw */, RISCV::VC_V_XVW, Convert__Reg1_1__UImm21_0__Tie0_2_2__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 10306 /* sf.vc.vv */, RISCV::VC_VV, Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_VM }, },
  { 10315 /* sf.vc.vvv */, RISCV::VC_VVV, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 10325 /* sf.vc.vvw */, RISCV::VC_VVW, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_VM }, },
  { 10335 /* sf.vc.x */, RISCV::VC_X, Convert__UImm21_0__UImm51_1__UImm51_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_UImm5, MCK_GPR }, },
  { 10343 /* sf.vc.xv */, RISCV::VC_XV, Convert__UImm21_0__UImm51_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_UImm5, MCK_VM, MCK_GPR }, },
  { 10352 /* sf.vc.xvv */, RISCV::VC_XVV, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 10362 /* sf.vc.xvw */, RISCV::VC_XVW, Convert__UImm21_0__Reg1_1__Reg1_2__Reg1_3, AMFBS_HasVendorXSfvcp, { MCK_UImm2, MCK_VM, MCK_VM, MCK_GPR }, },
  { 10372 /* sf.vfnrclip.x.f.qf */, RISCV::VFNRCLIP_X_F_QF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXSfvfnrclipxfqf, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10391 /* sf.vfnrclip.xu.f.qf */, RISCV::VFNRCLIP_XU_F_QF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXSfvfnrclipxfqf, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 10411 /* sf.vfwmacc.4x4x4 */, RISCV::VFWMACC_4x4x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvfwmaccqqq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10428 /* sf.vqmacc.2x8x2 */, RISCV::VQMACC_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10444 /* sf.vqmacc.4x8x4 */, RISCV::VQMACC_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10460 /* sf.vqmaccsu.2x8x2 */, RISCV::VQMACCSU_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10478 /* sf.vqmaccsu.4x8x4 */, RISCV::VQMACCSU_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10496 /* sf.vqmaccu.2x8x2 */, RISCV::VQMACCU_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10513 /* sf.vqmaccu.4x8x4 */, RISCV::VQMACCU_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10530 /* sf.vqmaccus.2x8x2 */, RISCV::VQMACCUS_2x8x2, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccdod, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10548 /* sf.vqmaccus.4x8x4 */, RISCV::VQMACCUS_4x8x4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXSfvqmaccqoq, { MCK_VM, MCK_VM, MCK_VM }, },
  { 10566 /* sfence.inval.ir */, RISCV::SFENCE_INVAL_IR, Convert_NoOperands, AMFBS_HasStdExtSvinval, {  }, },
  { 10582 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__regX0__regX0, AMFBS_None, {  }, },
  { 10582 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__Reg1_0__regX0, AMFBS_None, { MCK_GPR }, },
  { 10582 /* sfence.vma */, RISCV::SFENCE_VMA, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 10593 /* sfence.w.inval */, RISCV::SFENCE_W_INVAL, Convert_NoOperands, AMFBS_HasStdExtSvinval, {  }, },
  { 10608 /* sgt */, RISCV::SLT, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10612 /* sgtu */, RISCV::SLTU, Convert__Reg1_0__Reg1_2__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10617 /* sgtz */, RISCV::SLT, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 10622 /* sh */, RISCV::PseudoSH, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 10622 /* sh */, RISCV::SH, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10622 /* sh */, RISCV::SH, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 10625 /* sh.aqrl */, RISCV::SH_AQ_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 10633 /* sh.rl */, RISCV::SH_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 10639 /* sh1add */, RISCV::SH1ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10646 /* sh1add.uw */, RISCV::SH1ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10656 /* sh2add */, RISCV::SH2ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10663 /* sh2add.uw */, RISCV::SH2ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10673 /* sh3add */, RISCV::SH3ADD, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10680 /* sh3add.uw */, RISCV::SH3ADD_UW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10690 /* sha256sig0 */, RISCV::SHA256SIG0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 10701 /* sha256sig1 */, RISCV::SHA256SIG1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 10712 /* sha256sum0 */, RISCV::SHA256SUM0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 10723 /* sha256sum1 */, RISCV::SHA256SUM1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh, { MCK_GPR, MCK_GPR }, },
  { 10734 /* sha512sig0 */, RISCV::SHA512SIG0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 10745 /* sha512sig0h */, RISCV::SHA512SIG0H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10757 /* sha512sig0l */, RISCV::SHA512SIG0L, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10769 /* sha512sig1 */, RISCV::SHA512SIG1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 10780 /* sha512sig1h */, RISCV::SHA512SIG1H, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10792 /* sha512sig1l */, RISCV::SHA512SIG1L, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10804 /* sha512sum0 */, RISCV::SHA512SUM0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 10815 /* sha512sum0r */, RISCV::SHA512SUM0R, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10827 /* sha512sum1 */, RISCV::SHA512SUM1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZknh_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 10838 /* sha512sum1r */, RISCV::SHA512SUM1R, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZknh_IsRV32, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10850 /* sinval.vma */, RISCV::SINVAL_VMA, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtSvinval, { MCK_GPR, MCK_GPR }, },
  { 10861 /* sll */, RISCV::SLL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10861 /* sll */, RISCV::SLLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 10865 /* slli */, RISCV::SLLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 10870 /* slli.uw */, RISCV::SLLI_UW, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 10878 /* slliw */, RISCV::SLLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 10884 /* sllw */, RISCV::SLLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10884 /* sllw */, RISCV::SLLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 10889 /* slt */, RISCV::SLT, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10889 /* slt */, RISCV::SLTI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 10893 /* slti */, RISCV::SLTI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 10898 /* sltiu */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 10904 /* sltu */, RISCV::SLTU, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10904 /* sltu */, RISCV::SLTIU, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 10909 /* sltz */, RISCV::SLT, Convert__Reg1_0__Reg1_1__regX0, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 10914 /* sm3p0 */, RISCV::SM3P0, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZksh, { MCK_GPR, MCK_GPR }, },
  { 10920 /* sm3p1 */, RISCV::SM3P1, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZksh, { MCK_GPR, MCK_GPR }, },
  { 10926 /* sm4ed */, RISCV::SM4ED, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZksed, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 10932 /* sm4ks */, RISCV::SM4KS, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasStdExtZksed, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 10938 /* snez */, RISCV::SLTU, Convert__Reg1_0__regX0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 10943 /* sra */, RISCV::SRA, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10943 /* sra */, RISCV::SRAI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 10947 /* srai */, RISCV::SRAI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 10952 /* sraiw */, RISCV::SRAIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 10958 /* sraw */, RISCV::SRAW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10958 /* sraw */, RISCV::SRAIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 10963 /* sret */, RISCV::SRET, Convert_NoOperands, AMFBS_None, {  }, },
  { 10968 /* srl */, RISCV::SRL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10968 /* srl */, RISCV::SRLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 10972 /* srli */, RISCV::SRLI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 10977 /* srliw */, RISCV::SRLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 10983 /* srlw */, RISCV::SRLW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 10983 /* srlw */, RISCV::SRLIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 10988 /* ssamoswap.d */, RISCV::SSAMOSWAP_D, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11000 /* ssamoswap.d.aq */, RISCV::SSAMOSWAP_D_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11015 /* ssamoswap.d.aqrl */, RISCV::SSAMOSWAP_D_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11032 /* ssamoswap.d.rl */, RISCV::SSAMOSWAP_D_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss_IsRV64, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11047 /* ssamoswap.w */, RISCV::SSAMOSWAP_W, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11059 /* ssamoswap.w.aq */, RISCV::SSAMOSWAP_W_AQ, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11074 /* ssamoswap.w.aqrl */, RISCV::SSAMOSWAP_W_AQ_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11091 /* ssamoswap.w.rl */, RISCV::SSAMOSWAP_W_RL, Convert__Reg1_0__ZeroOffsetMemOpOperand1_2__Reg1_1, AMFBS_HasStdExtZicfiss, { MCK_GPR, MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11106 /* sspopchk */, RISCV::SSPOPCHK, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRX1X5 }, },
  { 11115 /* sspush */, RISCV::SSPUSH, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRX1X5 }, },
  { 11122 /* ssrdp */, RISCV::SSRDP, Convert__Reg1_0, AMFBS_HasStdExtZicfiss, { MCK_GPRNoX0 }, },
  { 11128 /* sub */, RISCV::SUB, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11132 /* subw */, RISCV::SUBW, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11137 /* sw */, RISCV::PseudoSW, Convert__Reg1_2__Reg1_0__BareSymbol1_1, AMFBS_None, { MCK_GPR, MCK_BareSymbol, MCK_GPR }, },
  { 11137 /* sw */, RISCV::SW, Convert__Reg1_0__Reg1_2__imm_95_0, AMFBS_None, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11137 /* sw */, RISCV::SW, Convert__Reg1_0__Reg1_3__SImm121_1, AMFBS_None, { MCK_GPR, MCK_SImm12, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 11140 /* sw.aqrl */, RISCV::SW_AQ_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11148 /* sw.rl */, RISCV::SW_RL, Convert__ZeroOffsetMemOpOperand1_1__Reg1_0, AMFBS_HasStdExtZalasr, { MCK_GPR, MCK_ZeroOffsetMemOpOperand }, },
  { 11154 /* tail */, RISCV::PseudoTAIL, Convert__CallSymbol1_0, AMFBS_None, { MCK_CallSymbol }, },
  { 11159 /* th.addsl */, RISCV::TH_ADDSL, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadBa, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11168 /* th.dcache.call */, RISCV::TH_DCACHE_CALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 11183 /* th.dcache.ciall */, RISCV::TH_DCACHE_CIALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 11199 /* th.dcache.cipa */, RISCV::TH_DCACHE_CIPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11214 /* th.dcache.cisw */, RISCV::TH_DCACHE_CISW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11229 /* th.dcache.civa */, RISCV::TH_DCACHE_CIVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11244 /* th.dcache.cpa */, RISCV::TH_DCACHE_CPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11258 /* th.dcache.cpal1 */, RISCV::TH_DCACHE_CPAL1, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11274 /* th.dcache.csw */, RISCV::TH_DCACHE_CSW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11288 /* th.dcache.cva */, RISCV::TH_DCACHE_CVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11302 /* th.dcache.cval1 */, RISCV::TH_DCACHE_CVAL1, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11318 /* th.dcache.iall */, RISCV::TH_DCACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 11333 /* th.dcache.ipa */, RISCV::TH_DCACHE_IPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11347 /* th.dcache.isw */, RISCV::TH_DCACHE_ISW, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11361 /* th.dcache.iva */, RISCV::TH_DCACHE_IVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11375 /* th.ext */, RISCV::TH_EXT, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 11382 /* th.extu */, RISCV::TH_EXTU, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2__UImmLog2XLen1_3, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen, MCK_UImmLog2XLen }, },
  { 11390 /* th.ff0 */, RISCV::TH_FF0, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 11397 /* th.ff1 */, RISCV::TH_FF1, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 11404 /* th.flrd */, RISCV::TH_FLRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11412 /* th.flrw */, RISCV::TH_FLRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11420 /* th.flurd */, RISCV::TH_FLURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11429 /* th.flurw */, RISCV::TH_FLURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11438 /* th.fsrd */, RISCV::TH_FSRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11446 /* th.fsrw */, RISCV::TH_FSRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11454 /* th.fsurd */, RISCV::TH_FSURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtD_IsRV64, { MCK_FPR64, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11463 /* th.fsurw */, RISCV::TH_FSURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadFMemIdx_HasStdExtF_IsRV64, { MCK_FPR32, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11472 /* th.icache.iall */, RISCV::TH_ICACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 11487 /* th.icache.ialls */, RISCV::TH_ICACHE_IALLS, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 11503 /* th.icache.ipa */, RISCV::TH_ICACHE_IPA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11517 /* th.icache.iva */, RISCV::TH_ICACHE_IVA, Convert__Reg1_0, AMFBS_HasVendorXTHeadCmo, { MCK_GPR }, },
  { 11531 /* th.l2cache.call */, RISCV::TH_L2CACHE_CALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 11547 /* th.l2cache.ciall */, RISCV::TH_L2CACHE_CIALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 11564 /* th.l2cache.iall */, RISCV::TH_L2CACHE_IALL, Convert_NoOperands, AMFBS_HasVendorXTHeadCmo, {  }, },
  { 11580 /* th.lbia */, RISCV::TH_LBIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11588 /* th.lbib */, RISCV::TH_LBIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11596 /* th.lbuia */, RISCV::TH_LBUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11605 /* th.lbuib */, RISCV::TH_LBUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11614 /* th.ldd */, RISCV::TH_LDD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair_IsRV64, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 11621 /* th.ldia */, RISCV::TH_LDIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11629 /* th.ldib */, RISCV::TH_LDIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11637 /* th.lhia */, RISCV::TH_LHIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11645 /* th.lhib */, RISCV::TH_LHIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11653 /* th.lhuia */, RISCV::TH_LHUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11662 /* th.lhuib */, RISCV::TH_LHUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11671 /* th.lrb */, RISCV::TH_LRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11678 /* th.lrbu */, RISCV::TH_LRBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11686 /* th.lrd */, RISCV::TH_LRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11693 /* th.lrh */, RISCV::TH_LRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11700 /* th.lrhu */, RISCV::TH_LRHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11708 /* th.lrw */, RISCV::TH_LRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11715 /* th.lrwu */, RISCV::TH_LRWU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11723 /* th.lurb */, RISCV::TH_LURB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11731 /* th.lurbu */, RISCV::TH_LURBU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11740 /* th.lurd */, RISCV::TH_LURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11748 /* th.lurh */, RISCV::TH_LURH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11756 /* th.lurhu */, RISCV::TH_LURHU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11765 /* th.lurw */, RISCV::TH_LURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11773 /* th.lurwu */, RISCV::TH_LURWU, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11782 /* th.lwd */, RISCV::TH_LWD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 11789 /* th.lwia */, RISCV::TH_LWIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11797 /* th.lwib */, RISCV::TH_LWIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11805 /* th.lwud */, RISCV::TH_LWUD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 11813 /* th.lwuia */, RISCV::TH_LWUIA, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11822 /* th.lwuib */, RISCV::TH_LWUIB, Convert__Reg1_0__Reg1_2__Tie1_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11831 /* th.mula */, RISCV::TH_MULA, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11839 /* th.mulah */, RISCV::TH_MULAH, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11848 /* th.mulaw */, RISCV::TH_MULAW, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11857 /* th.muls */, RISCV::TH_MULS, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11865 /* th.mulsh */, RISCV::TH_MULSH, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11874 /* th.mulsw */, RISCV::TH_MULSW, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadMac_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11883 /* th.mveqz */, RISCV::TH_MVEQZ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadCondMov, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11892 /* th.mvnez */, RISCV::TH_MVNEZ, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasVendorXTHeadCondMov, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 11901 /* th.rev */, RISCV::TH_REV, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 11908 /* th.revw */, RISCV::TH_REVW, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 11916 /* th.sbia */, RISCV::TH_SBIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11924 /* th.sbib */, RISCV::TH_SBIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11932 /* th.sdd */, RISCV::TH_SDD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair_IsRV64, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 11939 /* th.sdia */, RISCV::TH_SDIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11947 /* th.sdib */, RISCV::TH_SDIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11955 /* th.sfence.vmas */, RISCV::TH_SFENCE_VMAS, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadSync, { MCK_GPR, MCK_GPR }, },
  { 11970 /* th.shia */, RISCV::TH_SHIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11978 /* th.shib */, RISCV::TH_SHIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 11986 /* th.srb */, RISCV::TH_SRB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 11993 /* th.srd */, RISCV::TH_SRD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 12000 /* th.srh */, RISCV::TH_SRH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 12007 /* th.srri */, RISCV::TH_SRRI, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 12015 /* th.srriw */, RISCV::TH_SRRIW, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasVendorXTHeadBb_IsRV64, { MCK_GPR, MCK_GPR, MCK_UImm5 }, },
  { 12024 /* th.srw */, RISCV::TH_SRW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 12031 /* th.surb */, RISCV::TH_SURB, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 12039 /* th.surd */, RISCV::TH_SURD, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx_IsRV64, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 12047 /* th.surh */, RISCV::TH_SURH, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 12055 /* th.surw */, RISCV::TH_SURW, Convert__Reg1_0__Reg1_1__Reg1_2__UImm21_3, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK_GPR, MCK_GPR, MCK_UImm2 }, },
  { 12063 /* th.swd */, RISCV::TH_SWD, Convert__Reg1_0__Reg1_1__Reg1_3__UImm21_5__UImm71_6, AMFBS_HasVendorXTHeadMemPair, { MCK_GPR, MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_UImm2, MCK_UImm7 }, },
  { 12070 /* th.swia */, RISCV::TH_SWIA, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 12078 /* th.swib */, RISCV::TH_SWIB, Convert__Reg1_2__Reg1_0__Tie0_3_3__SImm51_4__UImm21_5, AMFBS_HasVendorXTHeadMemIdx, { MCK_GPR, MCK__40_, MCK_GPR, MCK__41_, MCK_SImm5, MCK_UImm2 }, },
  { 12086 /* th.sync */, RISCV::TH_SYNC, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 12094 /* th.sync.i */, RISCV::TH_SYNC_I, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 12104 /* th.sync.is */, RISCV::TH_SYNC_IS, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 12115 /* th.sync.s */, RISCV::TH_SYNC_S, Convert_NoOperands, AMFBS_HasVendorXTHeadSync, {  }, },
  { 12125 /* th.tst */, RISCV::TH_TST, Convert__Reg1_0__Reg1_1__UImmLog2XLen1_2, AMFBS_HasVendorXTHeadBs, { MCK_GPR, MCK_GPR, MCK_UImmLog2XLen }, },
  { 12132 /* th.tstnbz */, RISCV::TH_TSTNBZ, Convert__Reg1_0__Reg1_1, AMFBS_HasVendorXTHeadBb, { MCK_GPR, MCK_GPR }, },
  { 12142 /* th.vmaqa.vv */, RISCV::THVdotVMAQA_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12154 /* th.vmaqa.vx */, RISCV::THVdotVMAQA_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12166 /* th.vmaqasu.vv */, RISCV::THVdotVMAQASU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12180 /* th.vmaqasu.vx */, RISCV::THVdotVMAQASU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12194 /* th.vmaqau.vv */, RISCV::THVdotVMAQAU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12207 /* th.vmaqau.vx */, RISCV::THVdotVMAQAU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12220 /* th.vmaqaus.vx */, RISCV::THVdotVMAQAUS_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVendorXTHeadVdot, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12234 /* unimp */, RISCV::UNIMP, Convert_NoOperands, AMFBS_None, {  }, },
  { 12240 /* unzip */, RISCV::UNZIP_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 12246 /* vaadd.vv */, RISCV::VAADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12255 /* vaadd.vx */, RISCV::VAADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12264 /* vaaddu.vv */, RISCV::VAADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12274 /* vaaddu.vx */, RISCV::VAADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12284 /* vadc.vim */, RISCV::VADC_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskCarryInRegOpOperand }, },
  { 12293 /* vadc.vvm */, RISCV::VADC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 12302 /* vadc.vxm */, RISCV::VADC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 12311 /* vadd.vi */, RISCV::VADD_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 12319 /* vadd.vv */, RISCV::VADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12327 /* vadd.vx */, RISCV::VADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12335 /* vaesdf.vs */, RISCV::VAESDF_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12345 /* vaesdf.vv */, RISCV::VAESDF_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12355 /* vaesdm.vs */, RISCV::VAESDM_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12365 /* vaesdm.vv */, RISCV::VAESDM_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12375 /* vaesef.vs */, RISCV::VAESEF_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12385 /* vaesef.vv */, RISCV::VAESEF_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12395 /* vaesem.vs */, RISCV::VAESEM_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12405 /* vaesem.vv */, RISCV::VAESEM_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12415 /* vaeskf1.vi */, RISCV::VAESKF1_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 12426 /* vaeskf2.vi */, RISCV::VAESKF2_VI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 12437 /* vaesz.vs */, RISCV::VAESZ_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkned, { MCK_VM, MCK_VM }, },
  { 12446 /* vand.vi */, RISCV::VAND_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 12454 /* vand.vv */, RISCV::VAND_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12462 /* vand.vx */, RISCV::VAND_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12470 /* vandn.vv */, RISCV::VANDN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12479 /* vandn.vx */, RISCV::VANDN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12488 /* vasub.vv */, RISCV::VASUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12497 /* vasub.vx */, RISCV::VASUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12506 /* vasubu.vv */, RISCV::VASUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12516 /* vasubu.vx */, RISCV::VASUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12526 /* vbrev.v */, RISCV::VBREV_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12534 /* vbrev8.v */, RISCV::VBREV8_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12543 /* vclmul.vv */, RISCV::VCLMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbcOrZvbc32e, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12553 /* vclmul.vx */, RISCV::VCLMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbcOrZvbc32e, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12563 /* vclmulh.vv */, RISCV::VCLMULH_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbcOrZvbc32e, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12574 /* vclmulh.vx */, RISCV::VCLMULH_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbcOrZvbc32e, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12585 /* vclz.v */, RISCV::VCLZ_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12592 /* vcompress.vm */, RISCV::VCOMPRESS_VM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 12605 /* vcpop.m */, RISCV::VCPOP_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12613 /* vcpop.v */, RISCV::VCPOP_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12621 /* vctz.v */, RISCV::VCTZ_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12628 /* vdiv.vv */, RISCV::VDIV_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12636 /* vdiv.vx */, RISCV::VDIV_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12644 /* vdivu.vv */, RISCV::VDIVU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12653 /* vdivu.vx */, RISCV::VDIVU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 12662 /* vfabs.v */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_1__reg0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM }, },
  { 12662 /* vfabs.v */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12670 /* vfadd.vf */, RISCV::VFADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 12679 /* vfadd.vv */, RISCV::VFADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12688 /* vfclass.v */, RISCV::VFCLASS_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12698 /* vfcvt.f.x.v */, RISCV::VFCVT_F_X_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12710 /* vfcvt.f.xu.v */, RISCV::VFCVT_F_XU_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12723 /* vfcvt.rtz.x.f.v */, RISCV::VFCVT_RTZ_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12739 /* vfcvt.rtz.xu.f.v */, RISCV::VFCVT_RTZ_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12756 /* vfcvt.x.f.v */, RISCV::VFCVT_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12768 /* vfcvt.xu.f.v */, RISCV::VFCVT_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12781 /* vfdiv.vf */, RISCV::VFDIV_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 12790 /* vfdiv.vv */, RISCV::VFDIV_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12799 /* vfirst.m */, RISCV::VFIRST_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12808 /* vfmacc.vf */, RISCV::VFMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12818 /* vfmacc.vv */, RISCV::VFMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12828 /* vfmadd.vf */, RISCV::VFMADD_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12838 /* vfmadd.vv */, RISCV::VFMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12848 /* vfmax.vf */, RISCV::VFMAX_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 12857 /* vfmax.vv */, RISCV::VFMAX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12866 /* vfmerge.vfm */, RISCV::VFMERGE_VFM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskCarryInRegOpOperand }, },
  { 12878 /* vfmin.vf */, RISCV::VFMIN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 12887 /* vfmin.vv */, RISCV::VFMIN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12896 /* vfmsac.vf */, RISCV::VFMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12906 /* vfmsac.vv */, RISCV::VFMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12916 /* vfmsub.vf */, RISCV::VFMSUB_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12926 /* vfmsub.vv */, RISCV::VFMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12936 /* vfmul.vf */, RISCV::VFMUL_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 12945 /* vfmul.vv */, RISCV::VFMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12954 /* vfmv.f.s */, RISCV::VFMV_F_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_FPR32, MCK_VM }, },
  { 12963 /* vfmv.s.f */, RISCV::VFMV_S_F, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32 }, },
  { 12972 /* vfmv.v.f */, RISCV::VFMV_V_F, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32 }, },
  { 12981 /* vfncvt.f.f.w */, RISCV::VFNCVT_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 12994 /* vfncvt.f.x.w */, RISCV::VFNCVT_F_X_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13007 /* vfncvt.f.xu.w */, RISCV::VFNCVT_F_XU_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13021 /* vfncvt.rod.f.f.w */, RISCV::VFNCVT_ROD_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13038 /* vfncvt.rtz.x.f.w */, RISCV::VFNCVT_RTZ_X_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13055 /* vfncvt.rtz.xu.f.w */, RISCV::VFNCVT_RTZ_XU_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13073 /* vfncvt.x.f.w */, RISCV::VFNCVT_X_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13086 /* vfncvt.xu.f.w */, RISCV::VFNCVT_XU_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13100 /* vfncvtbf16.f.f.w */, RISCV::VFNCVTBF16_F_F_W, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvfbfmin, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13117 /* vfneg.v */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_1__reg0, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM }, },
  { 13117 /* vfneg.v */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13125 /* vfnmacc.vf */, RISCV::VFNMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13136 /* vfnmacc.vv */, RISCV::VFNMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13147 /* vfnmadd.vf */, RISCV::VFNMADD_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13158 /* vfnmadd.vv */, RISCV::VFNMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13169 /* vfnmsac.vf */, RISCV::VFNMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13180 /* vfnmsac.vv */, RISCV::VFNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13191 /* vfnmsub.vf */, RISCV::VFNMSUB_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13202 /* vfnmsub.vv */, RISCV::VFNMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13213 /* vfrdiv.vf */, RISCV::VFRDIV_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13223 /* vfrec7.v */, RISCV::VFREC7_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13232 /* vfredmax.vs */, RISCV::VFREDMAX_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13244 /* vfredmin.vs */, RISCV::VFREDMIN_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13256 /* vfredosum.vs */, RISCV::VFREDOSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13269 /* vfredsum.vs */, RISCV::VFREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13281 /* vfredusum.vs */, RISCV::VFREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13294 /* vfrsqrt7.v */, RISCV::VFRSQRT7_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13305 /* vfrsub.vf */, RISCV::VFRSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13315 /* vfsgnj.vf */, RISCV::VFSGNJ_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13325 /* vfsgnj.vv */, RISCV::VFSGNJ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13335 /* vfsgnjn.vf */, RISCV::VFSGNJN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13346 /* vfsgnjn.vv */, RISCV::VFSGNJN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13357 /* vfsgnjx.vf */, RISCV::VFSGNJX_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13368 /* vfsgnjx.vv */, RISCV::VFSGNJX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13379 /* vfslide1down.vf */, RISCV::VFSLIDE1DOWN_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13395 /* vfslide1up.vf */, RISCV::VFSLIDE1UP_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13409 /* vfsqrt.v */, RISCV::VFSQRT_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13418 /* vfsub.vf */, RISCV::VFSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13427 /* vfsub.vv */, RISCV::VFSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13436 /* vfwadd.vf */, RISCV::VFWADD_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13446 /* vfwadd.vv */, RISCV::VFWADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13456 /* vfwadd.wf */, RISCV::VFWADD_WF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13466 /* vfwadd.wv */, RISCV::VFWADD_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13476 /* vfwcvt.f.f.v */, RISCV::VFWCVT_F_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13489 /* vfwcvt.f.x.v */, RISCV::VFWCVT_F_X_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13502 /* vfwcvt.f.xu.v */, RISCV::VFWCVT_F_XU_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13516 /* vfwcvt.rtz.x.f.v */, RISCV::VFWCVT_RTZ_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13533 /* vfwcvt.rtz.xu.f.v */, RISCV::VFWCVT_RTZ_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13551 /* vfwcvt.x.f.v */, RISCV::VFWCVT_X_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13564 /* vfwcvt.xu.f.v */, RISCV::VFWCVT_XU_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13578 /* vfwcvtbf16.f.f.v */, RISCV::VFWCVTBF16_F_F_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvfbfmin, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13595 /* vfwmacc.vf */, RISCV::VFWMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13606 /* vfwmacc.vv */, RISCV::VFWMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13617 /* vfwmaccbf16.vf */, RISCV::VFWMACCBF16_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvfbfwma, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13632 /* vfwmaccbf16.vv */, RISCV::VFWMACCBF16_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvfbfwma, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13647 /* vfwmsac.vf */, RISCV::VFWMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13658 /* vfwmsac.vv */, RISCV::VFWMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13669 /* vfwmul.vf */, RISCV::VFWMUL_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13679 /* vfwmul.vv */, RISCV::VFWMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13689 /* vfwnmacc.vf */, RISCV::VFWNMACC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13701 /* vfwnmacc.vv */, RISCV::VFWNMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13713 /* vfwnmsac.vf */, RISCV::VFWNMSAC_VF, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_FPR32, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13725 /* vfwnmsac.vv */, RISCV::VFWNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13737 /* vfwredosum.vs */, RISCV::VFWREDOSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13751 /* vfwredsum.vs */, RISCV::VFWREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13764 /* vfwredusum.vs */, RISCV::VFWREDUSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13778 /* vfwsub.vf */, RISCV::VFWSUB_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13788 /* vfwsub.vv */, RISCV::VFWSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13798 /* vfwsub.wf */, RISCV::VFWSUB_WF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 13808 /* vfwsub.wv */, RISCV::VFWSUB_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13818 /* vghsh.vs */, RISCV::VGHSH_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvkgs, { MCK_VM, MCK_VM, MCK_VM }, },
  { 13827 /* vghsh.vv */, RISCV::VGHSH_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvkg, { MCK_VM, MCK_VM, MCK_VM }, },
  { 13836 /* vgmul.vs */, RISCV::VGMUL_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkgs, { MCK_VM, MCK_VM }, },
  { 13845 /* vgmul.vv */, RISCV::VGMUL_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvkg, { MCK_VM, MCK_VM }, },
  { 13854 /* vid.v */, RISCV::VID_V, Convert__Reg1_0__RVVMaskRegOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13860 /* viota.m */, RISCV::VIOTA_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 13868 /* vl1r.v */, RISCV::VL1RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 13875 /* vl1re16.v */, RISCV::VL1RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 13885 /* vl1re32.v */, RISCV::VL1RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 13895 /* vl1re64.v */, RISCV::VL1RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 13905 /* vl1re8.v */, RISCV::VL1RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 13914 /* vl2r.v */, RISCV::VL2RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM2, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 13921 /* vl2re16.v */, RISCV::VL2RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 13931 /* vl2re32.v */, RISCV::VL2RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 13941 /* vl2re64.v */, RISCV::VL2RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 13951 /* vl2re8.v */, RISCV::VL2RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 13960 /* vl4r.v */, RISCV::VL4RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM4, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 13967 /* vl4re16.v */, RISCV::VL4RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 13977 /* vl4re32.v */, RISCV::VL4RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 13987 /* vl4re64.v */, RISCV::VL4RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 13997 /* vl4re8.v */, RISCV::VL4RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 14006 /* vl8r.v */, RISCV::VL8RE8_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VRM8, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 14013 /* vl8re16.v */, RISCV::VL8RE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 14023 /* vl8re32.v */, RISCV::VL8RE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 14033 /* vl8re64.v */, RISCV::VL8RE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructionsI64, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 14043 /* vl8re8.v */, RISCV::VL8RE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 14052 /* vle1.v */, RISCV::VLM_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 14059 /* vle16.v */, RISCV::VLE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14067 /* vle16ff.v */, RISCV::VLE16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14077 /* vle32.v */, RISCV::VLE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14085 /* vle32ff.v */, RISCV::VLE32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14095 /* vle64.v */, RISCV::VLE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14103 /* vle64ff.v */, RISCV::VLE64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14113 /* vle8.v */, RISCV::VLE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14120 /* vle8ff.v */, RISCV::VLE8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14129 /* vlm.v */, RISCV::VLM_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 14135 /* vloxei16.v */, RISCV::VLOXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14146 /* vloxei32.v */, RISCV::VLOXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14157 /* vloxei64.v */, RISCV::VLOXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14168 /* vloxei8.v */, RISCV::VLOXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14178 /* vloxseg2ei16.v */, RISCV::VLOXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14193 /* vloxseg2ei32.v */, RISCV::VLOXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14208 /* vloxseg2ei64.v */, RISCV::VLOXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14223 /* vloxseg2ei8.v */, RISCV::VLOXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14237 /* vloxseg3ei16.v */, RISCV::VLOXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14252 /* vloxseg3ei32.v */, RISCV::VLOXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14267 /* vloxseg3ei64.v */, RISCV::VLOXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14282 /* vloxseg3ei8.v */, RISCV::VLOXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14296 /* vloxseg4ei16.v */, RISCV::VLOXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14311 /* vloxseg4ei32.v */, RISCV::VLOXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14326 /* vloxseg4ei64.v */, RISCV::VLOXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14341 /* vloxseg4ei8.v */, RISCV::VLOXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14355 /* vloxseg5ei16.v */, RISCV::VLOXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14370 /* vloxseg5ei32.v */, RISCV::VLOXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14385 /* vloxseg5ei64.v */, RISCV::VLOXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14400 /* vloxseg5ei8.v */, RISCV::VLOXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14414 /* vloxseg6ei16.v */, RISCV::VLOXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14429 /* vloxseg6ei32.v */, RISCV::VLOXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14444 /* vloxseg6ei64.v */, RISCV::VLOXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14459 /* vloxseg6ei8.v */, RISCV::VLOXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14473 /* vloxseg7ei16.v */, RISCV::VLOXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14488 /* vloxseg7ei32.v */, RISCV::VLOXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14503 /* vloxseg7ei64.v */, RISCV::VLOXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14518 /* vloxseg7ei8.v */, RISCV::VLOXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14532 /* vloxseg8ei16.v */, RISCV::VLOXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14547 /* vloxseg8ei32.v */, RISCV::VLOXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14562 /* vloxseg8ei64.v */, RISCV::VLOXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14577 /* vloxseg8ei8.v */, RISCV::VLOXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 14591 /* vlse16.v */, RISCV::VLSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14600 /* vlse32.v */, RISCV::VLSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14609 /* vlse64.v */, RISCV::VLSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14618 /* vlse8.v */, RISCV::VLSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 14626 /* vlseg2e16.v */, RISCV::VLSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14638 /* vlseg2e16ff.v */, RISCV::VLSEG2E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14652 /* vlseg2e32.v */, RISCV::VLSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14664 /* vlseg2e32ff.v */, RISCV::VLSEG2E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14678 /* vlseg2e64.v */, RISCV::VLSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14690 /* vlseg2e64ff.v */, RISCV::VLSEG2E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14704 /* vlseg2e8.v */, RISCV::VLSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14715 /* vlseg2e8ff.v */, RISCV::VLSEG2E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14728 /* vlseg3e16.v */, RISCV::VLSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14740 /* vlseg3e16ff.v */, RISCV::VLSEG3E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14754 /* vlseg3e32.v */, RISCV::VLSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14766 /* vlseg3e32ff.v */, RISCV::VLSEG3E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14780 /* vlseg3e64.v */, RISCV::VLSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14792 /* vlseg3e64ff.v */, RISCV::VLSEG3E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14806 /* vlseg3e8.v */, RISCV::VLSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14817 /* vlseg3e8ff.v */, RISCV::VLSEG3E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14830 /* vlseg4e16.v */, RISCV::VLSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14842 /* vlseg4e16ff.v */, RISCV::VLSEG4E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14856 /* vlseg4e32.v */, RISCV::VLSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14868 /* vlseg4e32ff.v */, RISCV::VLSEG4E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14882 /* vlseg4e64.v */, RISCV::VLSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14894 /* vlseg4e64ff.v */, RISCV::VLSEG4E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14908 /* vlseg4e8.v */, RISCV::VLSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14919 /* vlseg4e8ff.v */, RISCV::VLSEG4E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14932 /* vlseg5e16.v */, RISCV::VLSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14944 /* vlseg5e16ff.v */, RISCV::VLSEG5E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14958 /* vlseg5e32.v */, RISCV::VLSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14970 /* vlseg5e32ff.v */, RISCV::VLSEG5E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14984 /* vlseg5e64.v */, RISCV::VLSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 14996 /* vlseg5e64ff.v */, RISCV::VLSEG5E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15010 /* vlseg5e8.v */, RISCV::VLSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15021 /* vlseg5e8ff.v */, RISCV::VLSEG5E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15034 /* vlseg6e16.v */, RISCV::VLSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15046 /* vlseg6e16ff.v */, RISCV::VLSEG6E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15060 /* vlseg6e32.v */, RISCV::VLSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15072 /* vlseg6e32ff.v */, RISCV::VLSEG6E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15086 /* vlseg6e64.v */, RISCV::VLSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15098 /* vlseg6e64ff.v */, RISCV::VLSEG6E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15112 /* vlseg6e8.v */, RISCV::VLSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15123 /* vlseg6e8ff.v */, RISCV::VLSEG6E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15136 /* vlseg7e16.v */, RISCV::VLSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15148 /* vlseg7e16ff.v */, RISCV::VLSEG7E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15162 /* vlseg7e32.v */, RISCV::VLSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15174 /* vlseg7e32ff.v */, RISCV::VLSEG7E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15188 /* vlseg7e64.v */, RISCV::VLSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15200 /* vlseg7e64ff.v */, RISCV::VLSEG7E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15214 /* vlseg7e8.v */, RISCV::VLSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15225 /* vlseg7e8ff.v */, RISCV::VLSEG7E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15238 /* vlseg8e16.v */, RISCV::VLSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15250 /* vlseg8e16ff.v */, RISCV::VLSEG8E16FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15264 /* vlseg8e32.v */, RISCV::VLSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15276 /* vlseg8e32ff.v */, RISCV::VLSEG8E32FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15290 /* vlseg8e64.v */, RISCV::VLSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15302 /* vlseg8e64ff.v */, RISCV::VLSEG8E64FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15316 /* vlseg8e8.v */, RISCV::VLSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15327 /* vlseg8e8ff.v */, RISCV::VLSEG8E8FF_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 15340 /* vlsseg2e16.v */, RISCV::VLSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15353 /* vlsseg2e32.v */, RISCV::VLSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15366 /* vlsseg2e64.v */, RISCV::VLSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15379 /* vlsseg2e8.v */, RISCV::VLSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15391 /* vlsseg3e16.v */, RISCV::VLSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15404 /* vlsseg3e32.v */, RISCV::VLSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15417 /* vlsseg3e64.v */, RISCV::VLSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15430 /* vlsseg3e8.v */, RISCV::VLSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15442 /* vlsseg4e16.v */, RISCV::VLSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15455 /* vlsseg4e32.v */, RISCV::VLSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15468 /* vlsseg4e64.v */, RISCV::VLSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15481 /* vlsseg4e8.v */, RISCV::VLSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15493 /* vlsseg5e16.v */, RISCV::VLSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15506 /* vlsseg5e32.v */, RISCV::VLSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15519 /* vlsseg5e64.v */, RISCV::VLSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15532 /* vlsseg5e8.v */, RISCV::VLSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15544 /* vlsseg6e16.v */, RISCV::VLSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15557 /* vlsseg6e32.v */, RISCV::VLSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15570 /* vlsseg6e64.v */, RISCV::VLSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15583 /* vlsseg6e8.v */, RISCV::VLSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15595 /* vlsseg7e16.v */, RISCV::VLSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15608 /* vlsseg7e32.v */, RISCV::VLSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15621 /* vlsseg7e64.v */, RISCV::VLSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15634 /* vlsseg7e8.v */, RISCV::VLSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15646 /* vlsseg8e16.v */, RISCV::VLSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15659 /* vlsseg8e32.v */, RISCV::VLSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15672 /* vlsseg8e64.v */, RISCV::VLSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15685 /* vlsseg8e8.v */, RISCV::VLSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 15697 /* vluxei16.v */, RISCV::VLUXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15708 /* vluxei32.v */, RISCV::VLUXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15719 /* vluxei64.v */, RISCV::VLUXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15730 /* vluxei8.v */, RISCV::VLUXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15740 /* vluxseg2ei16.v */, RISCV::VLUXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15755 /* vluxseg2ei32.v */, RISCV::VLUXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15770 /* vluxseg2ei64.v */, RISCV::VLUXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15785 /* vluxseg2ei8.v */, RISCV::VLUXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15799 /* vluxseg3ei16.v */, RISCV::VLUXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15814 /* vluxseg3ei32.v */, RISCV::VLUXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15829 /* vluxseg3ei64.v */, RISCV::VLUXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15844 /* vluxseg3ei8.v */, RISCV::VLUXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15858 /* vluxseg4ei16.v */, RISCV::VLUXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15873 /* vluxseg4ei32.v */, RISCV::VLUXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15888 /* vluxseg4ei64.v */, RISCV::VLUXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15903 /* vluxseg4ei8.v */, RISCV::VLUXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15917 /* vluxseg5ei16.v */, RISCV::VLUXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15932 /* vluxseg5ei32.v */, RISCV::VLUXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15947 /* vluxseg5ei64.v */, RISCV::VLUXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15962 /* vluxseg5ei8.v */, RISCV::VLUXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15976 /* vluxseg6ei16.v */, RISCV::VLUXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 15991 /* vluxseg6ei32.v */, RISCV::VLUXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16006 /* vluxseg6ei64.v */, RISCV::VLUXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16021 /* vluxseg6ei8.v */, RISCV::VLUXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16035 /* vluxseg7ei16.v */, RISCV::VLUXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16050 /* vluxseg7ei32.v */, RISCV::VLUXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16065 /* vluxseg7ei64.v */, RISCV::VLUXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16080 /* vluxseg7ei8.v */, RISCV::VLUXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16094 /* vluxseg8ei16.v */, RISCV::VLUXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16109 /* vluxseg8ei32.v */, RISCV::VLUXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16124 /* vluxseg8ei64.v */, RISCV::VLUXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16139 /* vluxseg8ei8.v */, RISCV::VLUXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16153 /* vmacc.vv */, RISCV::VMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16162 /* vmacc.vx */, RISCV::VMACC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16171 /* vmadc.vi */, RISCV::VMADC_VI, Convert__Reg1_0__Reg1_1__SImm51_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5 }, },
  { 16180 /* vmadc.vim */, RISCV::VMADC_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskCarryInRegOpOperand }, },
  { 16190 /* vmadc.vv */, RISCV::VMADC_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16199 /* vmadc.vvm */, RISCV::VMADC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 16209 /* vmadc.vx */, RISCV::VMADC_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 16218 /* vmadc.vxm */, RISCV::VMADC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 16228 /* vmadd.vv */, RISCV::VMADD_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16237 /* vmadd.vx */, RISCV::VMADD_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16246 /* vmand.mm */, RISCV::VMAND_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16255 /* vmandn.mm */, RISCV::VMANDN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16265 /* vmandnot.mm */, RISCV::VMANDN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16277 /* vmax.vv */, RISCV::VMAX_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16285 /* vmax.vx */, RISCV::VMAX_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16293 /* vmaxu.vv */, RISCV::VMAXU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16302 /* vmaxu.vx */, RISCV::VMAXU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16311 /* vmclr.m */, RISCV::VMXOR_MM, Convert__Reg1_0__Reg1_0__Reg1_0, AMFBS_HasVInstructions, { MCK_VM }, },
  { 16319 /* vmerge.vim */, RISCV::VMERGE_VIM, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskCarryInRegOpOperand }, },
  { 16330 /* vmerge.vvm */, RISCV::VMERGE_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 16341 /* vmerge.vxm */, RISCV::VMERGE_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 16352 /* vmfeq.vf */, RISCV::VMFEQ_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 16361 /* vmfeq.vv */, RISCV::VMFEQ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16370 /* vmfge.vf */, RISCV::VMFGE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 16379 /* vmfge.vv */, RISCV::VMFLE_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16388 /* vmfgt.vf */, RISCV::VMFGT_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 16397 /* vmfgt.vv */, RISCV::VMFLT_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16406 /* vmfle.vf */, RISCV::VMFLE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 16415 /* vmfle.vv */, RISCV::VMFLE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16424 /* vmflt.vf */, RISCV::VMFLT_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 16433 /* vmflt.vv */, RISCV::VMFLT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16442 /* vmfne.vf */, RISCV::VMFNE_VF, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_FPR32, MCK_RVVMaskRegOpOperand }, },
  { 16451 /* vmfne.vv */, RISCV::VMFNE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsAnyF, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16460 /* vmin.vv */, RISCV::VMIN_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16468 /* vmin.vx */, RISCV::VMIN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16476 /* vminu.vv */, RISCV::VMINU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16485 /* vminu.vx */, RISCV::VMINU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16494 /* vmmv.m */, RISCV::VMAND_MM, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 16501 /* vmnand.mm */, RISCV::VMNAND_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16511 /* vmnor.mm */, RISCV::VMNOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16520 /* vmnot.m */, RISCV::VMNAND_MM, Convert__Reg1_0__Reg1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 16528 /* vmor.mm */, RISCV::VMOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16536 /* vmorn.mm */, RISCV::VMORN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16545 /* vmornot.mm */, RISCV::VMORN_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16556 /* vmsbc.vv */, RISCV::VMSBC_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 16565 /* vmsbc.vvm */, RISCV::VMSBC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 16575 /* vmsbc.vx */, RISCV::VMSBC_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 16584 /* vmsbc.vxm */, RISCV::VMSBC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 16594 /* vmsbf.m */, RISCV::VMSBF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16602 /* vmseq.vi */, RISCV::VMSEQ_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 16611 /* vmseq.vv */, RISCV::VMSEQ_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16620 /* vmseq.vx */, RISCV::VMSEQ_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16629 /* vmset.m */, RISCV::VMXNOR_MM, Convert__Reg1_0__Reg1_0__Reg1_0, AMFBS_HasVInstructions, { MCK_VM }, },
  { 16637 /* vmsge.vi */, RISCV::PseudoVMSGE_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 16646 /* vmsge.vv */, RISCV::VMSLE_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16655 /* vmsge.vx */, RISCV::PseudoVMSGE_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 16655 /* vmsge.vx */, RISCV::PseudoVMSGE_VX_M, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VRNoV0, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16655 /* vmsge.vx */, RISCV::PseudoVMSGE_VX_M_T, Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand, MCK_VRNoV0 }, },
  { 16664 /* vmsgeu.vi */, RISCV::PseudoVMSGEU_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 16674 /* vmsgeu.vv */, RISCV::VMSLEU_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16684 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR }, },
  { 16684 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX_M, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VRNoV0, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16684 /* vmsgeu.vx */, RISCV::PseudoVMSGEU_VX_M_T, Convert__Reg1_0__Reg1_4__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand, MCK_VRNoV0 }, },
  { 16694 /* vmsgt.vi */, RISCV::VMSGT_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 16703 /* vmsgt.vv */, RISCV::VMSLT_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16712 /* vmsgt.vx */, RISCV::VMSGT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16721 /* vmsgtu.vi */, RISCV::VMSGTU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 16731 /* vmsgtu.vv */, RISCV::VMSLTU_VV, Convert__Reg1_0__Reg1_2__Reg1_1__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16741 /* vmsgtu.vx */, RISCV::VMSGTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16751 /* vmsif.m */, RISCV::VMSIF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16759 /* vmsle.vi */, RISCV::VMSLE_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 16768 /* vmsle.vv */, RISCV::VMSLE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16777 /* vmsle.vx */, RISCV::VMSLE_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16786 /* vmsleu.vi */, RISCV::VMSLEU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 16796 /* vmsleu.vv */, RISCV::VMSLEU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16806 /* vmsleu.vx */, RISCV::VMSLEU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16816 /* vmslt.vi */, RISCV::PseudoVMSLT_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 16825 /* vmslt.vv */, RISCV::VMSLT_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16834 /* vmslt.vx */, RISCV::VMSLT_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16843 /* vmsltu.vi */, RISCV::PseudoVMSLTU_VI, Convert__Reg1_0__Reg1_1__SImm5Plus11_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5Plus1, MCK_RVVMaskRegOpOperand }, },
  { 16853 /* vmsltu.vv */, RISCV::VMSLTU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16863 /* vmsltu.vx */, RISCV::VMSLTU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16873 /* vmsne.vi */, RISCV::VMSNE_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 16882 /* vmsne.vv */, RISCV::VMSNE_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16891 /* vmsne.vx */, RISCV::VMSNE_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16900 /* vmsof.m */, RISCV::VMSOF_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16908 /* vmul.vv */, RISCV::VMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16916 /* vmul.vx */, RISCV::VMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16924 /* vmulh.vv */, RISCV::VMULH_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16933 /* vmulh.vx */, RISCV::VMULH_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16942 /* vmulhsu.vv */, RISCV::VMULHSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16953 /* vmulhsu.vx */, RISCV::VMULHSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16964 /* vmulhu.vv */, RISCV::VMULHU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 16974 /* vmulhu.vx */, RISCV::VMULHU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 16984 /* vmv.s.x */, RISCV::VMV_S_X, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR }, },
  { 16992 /* vmv.v.i */, RISCV::VMV_V_I, Convert__Reg1_0__SImm51_1, AMFBS_HasVInstructions, { MCK_VM, MCK_SImm5 }, },
  { 17000 /* vmv.v.v */, RISCV::VMV_V_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 17008 /* vmv.v.x */, RISCV::VMV_V_X, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR }, },
  { 17016 /* vmv.x.s */, RISCV::VMV_X_S, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM }, },
  { 17024 /* vmv1r.v */, RISCV::VMV1R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 17032 /* vmv2r.v */, RISCV::VMV2R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_VRM2 }, },
  { 17040 /* vmv4r.v */, RISCV::VMV4R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_VRM4 }, },
  { 17048 /* vmv8r.v */, RISCV::VMV8R_V, Convert__Reg1_0__Reg1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_VRM8 }, },
  { 17056 /* vmxnor.mm */, RISCV::VMXNOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 17066 /* vmxor.mm */, RISCV::VMXOR_MM, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM }, },
  { 17075 /* vnclip.wi */, RISCV::VNCLIP_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17085 /* vnclip.wv */, RISCV::VNCLIP_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17095 /* vnclip.wx */, RISCV::VNCLIP_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17105 /* vnclipu.wi */, RISCV::VNCLIPU_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17116 /* vnclipu.wv */, RISCV::VNCLIPU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17127 /* vnclipu.wx */, RISCV::VNCLIPU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17138 /* vncvt.x.x.w */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 17138 /* vncvt.x.x.w */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17150 /* vneg.v */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 17150 /* vneg.v */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17157 /* vnmsac.vv */, RISCV::VNMSAC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17167 /* vnmsac.vx */, RISCV::VNMSAC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17177 /* vnmsub.vv */, RISCV::VNMSUB_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17187 /* vnmsub.vx */, RISCV::VNMSUB_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17197 /* vnot.v */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 17197 /* vnot.v */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__imm_95__MINUS_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17204 /* vnsra.wi */, RISCV::VNSRA_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17213 /* vnsra.wv */, RISCV::VNSRA_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17222 /* vnsra.wx */, RISCV::VNSRA_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17231 /* vnsrl.wi */, RISCV::VNSRL_WI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17240 /* vnsrl.wv */, RISCV::VNSRL_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17249 /* vnsrl.wx */, RISCV::VNSRL_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17258 /* vor.vi */, RISCV::VOR_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 17265 /* vor.vv */, RISCV::VOR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17272 /* vor.vx */, RISCV::VOR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17279 /* vpopc.m */, RISCV::VCPOP_M, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17287 /* vredand.vs */, RISCV::VREDAND_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17298 /* vredmax.vs */, RISCV::VREDMAX_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17309 /* vredmaxu.vs */, RISCV::VREDMAXU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17321 /* vredmin.vs */, RISCV::VREDMIN_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17332 /* vredminu.vs */, RISCV::VREDMINU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17344 /* vredor.vs */, RISCV::VREDOR_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17354 /* vredsum.vs */, RISCV::VREDSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17365 /* vredxor.vs */, RISCV::VREDXOR_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17376 /* vrem.vv */, RISCV::VREM_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17384 /* vrem.vx */, RISCV::VREM_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17392 /* vremu.vv */, RISCV::VREMU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17401 /* vremu.vx */, RISCV::VREMU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17410 /* vrev8.v */, RISCV::VREV8_V, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17418 /* vrgather.vi */, RISCV::VRGATHER_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17430 /* vrgather.vv */, RISCV::VRGATHER_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17442 /* vrgather.vx */, RISCV::VRGATHER_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17454 /* vrgatherei16.vv */, RISCV::VRGATHEREI16_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17470 /* vrol.vv */, RISCV::VROL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17478 /* vrol.vx */, RISCV::VROL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17486 /* vror.vi */, RISCV::VROR_VI, Convert__Reg1_0__Reg1_1__UImm61_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_UImm6, MCK_RVVMaskRegOpOperand }, },
  { 17494 /* vror.vv */, RISCV::VROR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17502 /* vror.vx */, RISCV::VROR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvkb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17510 /* vrsub.vi */, RISCV::VRSUB_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 17519 /* vrsub.vx */, RISCV::VRSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17528 /* vs1r.v */, RISCV::VS1R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 17535 /* vs2r.v */, RISCV::VS2R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM2, MCK_ZeroOffsetMemOpOperand }, },
  { 17542 /* vs4r.v */, RISCV::VS4R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM4, MCK_ZeroOffsetMemOpOperand }, },
  { 17549 /* vs8r.v */, RISCV::VS8R_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VRM8, MCK_ZeroOffsetMemOpOperand }, },
  { 17556 /* vsadd.vi */, RISCV::VSADD_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 17565 /* vsadd.vv */, RISCV::VSADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17574 /* vsadd.vx */, RISCV::VSADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17583 /* vsaddu.vi */, RISCV::VSADDU_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 17593 /* vsaddu.vv */, RISCV::VSADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17603 /* vsaddu.vx */, RISCV::VSADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17613 /* vsbc.vvm */, RISCV::VSBC_VVM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskCarryInRegOpOperand }, },
  { 17622 /* vsbc.vxm */, RISCV::VSBC_VXM, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskCarryInRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskCarryInRegOpOperand }, },
  { 17631 /* vse1.v */, RISCV::VSM_V, Convert__Reg1_0__Reg1_2, AMFBS_HasVInstructions, { MCK_VM, MCK__40_, MCK_GPR, MCK__41_ }, },
  { 17638 /* vse16.v */, RISCV::VSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17646 /* vse32.v */, RISCV::VSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17654 /* vse64.v */, RISCV::VSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17662 /* vse8.v */, RISCV::VSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 17669 /* vsetivli */, RISCV::VSETIVLI, Convert__Reg1_0__UImm51_1__VTypeI101_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_UImm5, MCK_VTypeI10 }, },
  { 17678 /* vsetvl */, RISCV::VSETVL, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 17685 /* vsetvli */, RISCV::VSETVLI, Convert__Reg1_0__Reg1_1__VTypeI111_2, AMFBS_HasVInstructions, { MCK_GPR, MCK_GPR, MCK_VTypeI11 }, },
  { 17693 /* vsext.vf2 */, RISCV::VSEXT_VF2, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17703 /* vsext.vf4 */, RISCV::VSEXT_VF4, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17713 /* vsext.vf8 */, RISCV::VSEXT_VF8, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17723 /* vsha2ch.vv */, RISCV::VSHA2CH_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 17734 /* vsha2cl.vv */, RISCV::VSHA2CL_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 17745 /* vsha2ms.vv */, RISCV::VSHA2MS_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2, AMFBS_HasStdExtZvknhaOrZvknhb, { MCK_VM, MCK_VM, MCK_VM }, },
  { 17756 /* vslide1down.vx */, RISCV::VSLIDE1DOWN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17771 /* vslide1up.vx */, RISCV::VSLIDE1UP_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17784 /* vslidedown.vi */, RISCV::VSLIDEDOWN_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17798 /* vslidedown.vx */, RISCV::VSLIDEDOWN_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17812 /* vslideup.vi */, RISCV::VSLIDEUP_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17824 /* vslideup.vx */, RISCV::VSLIDEUP_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17836 /* vsll.vi */, RISCV::VSLL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 17844 /* vsll.vv */, RISCV::VSLL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17852 /* vsll.vx */, RISCV::VSLL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17860 /* vsm.v */, RISCV::VSM_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand }, },
  { 17866 /* vsm3c.vi */, RISCV::VSM3C_VI, Convert__Reg1_0__Tie0_1_1__Reg1_1__UImm51_2, AMFBS_HasStdExtZvksh, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 17875 /* vsm3me.vv */, RISCV::VSM3ME_VV, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZvksh, { MCK_VM, MCK_VM, MCK_VM }, },
  { 17885 /* vsm4k.vi */, RISCV::VSM4K_VI, Convert__Reg1_0__Reg1_1__UImm51_2, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM, MCK_UImm5 }, },
  { 17894 /* vsm4r.vs */, RISCV::VSM4R_VS, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM }, },
  { 17903 /* vsm4r.vv */, RISCV::VSM4R_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1, AMFBS_HasStdExtZvksed, { MCK_VM, MCK_VM }, },
  { 17912 /* vsmul.vv */, RISCV::VSMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17921 /* vsmul.vx */, RISCV::VSMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 17930 /* vsoxei16.v */, RISCV::VSOXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17941 /* vsoxei32.v */, RISCV::VSOXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17952 /* vsoxei64.v */, RISCV::VSOXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17963 /* vsoxei8.v */, RISCV::VSOXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17973 /* vsoxseg2ei16.v */, RISCV::VSOXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 17988 /* vsoxseg2ei32.v */, RISCV::VSOXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18003 /* vsoxseg2ei64.v */, RISCV::VSOXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18018 /* vsoxseg2ei8.v */, RISCV::VSOXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18032 /* vsoxseg3ei16.v */, RISCV::VSOXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18047 /* vsoxseg3ei32.v */, RISCV::VSOXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18062 /* vsoxseg3ei64.v */, RISCV::VSOXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18077 /* vsoxseg3ei8.v */, RISCV::VSOXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18091 /* vsoxseg4ei16.v */, RISCV::VSOXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18106 /* vsoxseg4ei32.v */, RISCV::VSOXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18121 /* vsoxseg4ei64.v */, RISCV::VSOXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18136 /* vsoxseg4ei8.v */, RISCV::VSOXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18150 /* vsoxseg5ei16.v */, RISCV::VSOXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18165 /* vsoxseg5ei32.v */, RISCV::VSOXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18180 /* vsoxseg5ei64.v */, RISCV::VSOXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18195 /* vsoxseg5ei8.v */, RISCV::VSOXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18209 /* vsoxseg6ei16.v */, RISCV::VSOXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18224 /* vsoxseg6ei32.v */, RISCV::VSOXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18239 /* vsoxseg6ei64.v */, RISCV::VSOXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18254 /* vsoxseg6ei8.v */, RISCV::VSOXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18268 /* vsoxseg7ei16.v */, RISCV::VSOXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18283 /* vsoxseg7ei32.v */, RISCV::VSOXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18298 /* vsoxseg7ei64.v */, RISCV::VSOXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18313 /* vsoxseg7ei8.v */, RISCV::VSOXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18327 /* vsoxseg8ei16.v */, RISCV::VSOXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18342 /* vsoxseg8ei32.v */, RISCV::VSOXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18357 /* vsoxseg8ei64.v */, RISCV::VSOXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18372 /* vsoxseg8ei8.v */, RISCV::VSOXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18386 /* vsra.vi */, RISCV::VSRA_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 18394 /* vsra.vv */, RISCV::VSRA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18402 /* vsra.vx */, RISCV::VSRA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18410 /* vsrl.vi */, RISCV::VSRL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 18418 /* vsrl.vv */, RISCV::VSRL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18426 /* vsrl.vx */, RISCV::VSRL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18434 /* vsse16.v */, RISCV::VSSE16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18443 /* vsse32.v */, RISCV::VSSE32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18452 /* vsse64.v */, RISCV::VSSE64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18461 /* vsse8.v */, RISCV::VSSE8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18469 /* vsseg2e16.v */, RISCV::VSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18481 /* vsseg2e32.v */, RISCV::VSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18493 /* vsseg2e64.v */, RISCV::VSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18505 /* vsseg2e8.v */, RISCV::VSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18516 /* vsseg3e16.v */, RISCV::VSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18528 /* vsseg3e32.v */, RISCV::VSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18540 /* vsseg3e64.v */, RISCV::VSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18552 /* vsseg3e8.v */, RISCV::VSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18563 /* vsseg4e16.v */, RISCV::VSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18575 /* vsseg4e32.v */, RISCV::VSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18587 /* vsseg4e64.v */, RISCV::VSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18599 /* vsseg4e8.v */, RISCV::VSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18610 /* vsseg5e16.v */, RISCV::VSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18622 /* vsseg5e32.v */, RISCV::VSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18634 /* vsseg5e64.v */, RISCV::VSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18646 /* vsseg5e8.v */, RISCV::VSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18657 /* vsseg6e16.v */, RISCV::VSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18669 /* vsseg6e32.v */, RISCV::VSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18681 /* vsseg6e64.v */, RISCV::VSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18693 /* vsseg6e8.v */, RISCV::VSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18704 /* vsseg7e16.v */, RISCV::VSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18716 /* vsseg7e32.v */, RISCV::VSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18728 /* vsseg7e64.v */, RISCV::VSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18740 /* vsseg7e8.v */, RISCV::VSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18751 /* vsseg8e16.v */, RISCV::VSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18763 /* vsseg8e32.v */, RISCV::VSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18775 /* vsseg8e64.v */, RISCV::VSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18787 /* vsseg8e8.v */, RISCV::VSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_RVVMaskRegOpOperand }, },
  { 18798 /* vssra.vi */, RISCV::VSSRA_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 18807 /* vssra.vv */, RISCV::VSSRA_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18816 /* vssra.vx */, RISCV::VSSRA_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18825 /* vssrl.vi */, RISCV::VSSRL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 18834 /* vssrl.vv */, RISCV::VSSRL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 18843 /* vssrl.vx */, RISCV::VSSRL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18852 /* vssseg2e16.v */, RISCV::VSSSEG2E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18865 /* vssseg2e32.v */, RISCV::VSSSEG2E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18878 /* vssseg2e64.v */, RISCV::VSSSEG2E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18891 /* vssseg2e8.v */, RISCV::VSSSEG2E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18903 /* vssseg3e16.v */, RISCV::VSSSEG3E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18916 /* vssseg3e32.v */, RISCV::VSSSEG3E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18929 /* vssseg3e64.v */, RISCV::VSSSEG3E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18942 /* vssseg3e8.v */, RISCV::VSSSEG3E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18954 /* vssseg4e16.v */, RISCV::VSSSEG4E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18967 /* vssseg4e32.v */, RISCV::VSSSEG4E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18980 /* vssseg4e64.v */, RISCV::VSSSEG4E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 18993 /* vssseg4e8.v */, RISCV::VSSSEG4E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19005 /* vssseg5e16.v */, RISCV::VSSSEG5E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19018 /* vssseg5e32.v */, RISCV::VSSSEG5E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19031 /* vssseg5e64.v */, RISCV::VSSSEG5E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19044 /* vssseg5e8.v */, RISCV::VSSSEG5E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19056 /* vssseg6e16.v */, RISCV::VSSSEG6E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19069 /* vssseg6e32.v */, RISCV::VSSSEG6E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19082 /* vssseg6e64.v */, RISCV::VSSSEG6E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19095 /* vssseg6e8.v */, RISCV::VSSSEG6E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19107 /* vssseg7e16.v */, RISCV::VSSSEG7E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19120 /* vssseg7e32.v */, RISCV::VSSSEG7E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19133 /* vssseg7e64.v */, RISCV::VSSSEG7E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19146 /* vssseg7e8.v */, RISCV::VSSSEG7E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19158 /* vssseg8e16.v */, RISCV::VSSSEG8E16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19171 /* vssseg8e32.v */, RISCV::VSSSEG8E32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19184 /* vssseg8e64.v */, RISCV::VSSSEG8E64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19197 /* vssseg8e8.v */, RISCV::VSSSEG8E8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19209 /* vssub.vv */, RISCV::VSSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19218 /* vssub.vx */, RISCV::VSSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19227 /* vssubu.vv */, RISCV::VSSUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19237 /* vssubu.vx */, RISCV::VSSUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19247 /* vsub.vv */, RISCV::VSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19255 /* vsub.vx */, RISCV::VSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19263 /* vsuxei16.v */, RISCV::VSUXEI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19274 /* vsuxei32.v */, RISCV::VSUXEI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19285 /* vsuxei64.v */, RISCV::VSUXEI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_IsRV64_HasVInstructionsI64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19296 /* vsuxei8.v */, RISCV::VSUXEI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19306 /* vsuxseg2ei16.v */, RISCV::VSUXSEG2EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19321 /* vsuxseg2ei32.v */, RISCV::VSUXSEG2EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19336 /* vsuxseg2ei64.v */, RISCV::VSUXSEG2EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19351 /* vsuxseg2ei8.v */, RISCV::VSUXSEG2EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19365 /* vsuxseg3ei16.v */, RISCV::VSUXSEG3EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19380 /* vsuxseg3ei32.v */, RISCV::VSUXSEG3EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19395 /* vsuxseg3ei64.v */, RISCV::VSUXSEG3EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19410 /* vsuxseg3ei8.v */, RISCV::VSUXSEG3EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19424 /* vsuxseg4ei16.v */, RISCV::VSUXSEG4EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19439 /* vsuxseg4ei32.v */, RISCV::VSUXSEG4EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19454 /* vsuxseg4ei64.v */, RISCV::VSUXSEG4EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19469 /* vsuxseg4ei8.v */, RISCV::VSUXSEG4EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19483 /* vsuxseg5ei16.v */, RISCV::VSUXSEG5EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19498 /* vsuxseg5ei32.v */, RISCV::VSUXSEG5EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19513 /* vsuxseg5ei64.v */, RISCV::VSUXSEG5EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19528 /* vsuxseg5ei8.v */, RISCV::VSUXSEG5EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19542 /* vsuxseg6ei16.v */, RISCV::VSUXSEG6EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19557 /* vsuxseg6ei32.v */, RISCV::VSUXSEG6EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19572 /* vsuxseg6ei64.v */, RISCV::VSUXSEG6EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19587 /* vsuxseg6ei8.v */, RISCV::VSUXSEG6EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19601 /* vsuxseg7ei16.v */, RISCV::VSUXSEG7EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19616 /* vsuxseg7ei32.v */, RISCV::VSUXSEG7EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19631 /* vsuxseg7ei64.v */, RISCV::VSUXSEG7EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19646 /* vsuxseg7ei8.v */, RISCV::VSUXSEG7EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19660 /* vsuxseg8ei16.v */, RISCV::VSUXSEG8EI16_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19675 /* vsuxseg8ei32.v */, RISCV::VSUXSEG8EI32_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19690 /* vsuxseg8ei64.v */, RISCV::VSUXSEG8EI64_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructionsI64_IsRV64, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19705 /* vsuxseg8ei8.v */, RISCV::VSUXSEG8EI8_V, Convert__Reg1_0__ZeroOffsetMemOpOperand1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_ZeroOffsetMemOpOperand, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19719 /* vt.maskc */, RISCV::VT_MASKC, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXVentanaCondOps, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 19728 /* vt.maskcn */, RISCV::VT_MASKCN, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasVendorXVentanaCondOps, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 19738 /* vwadd.vv */, RISCV::VWADD_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19747 /* vwadd.vx */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19756 /* vwadd.wv */, RISCV::VWADD_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19765 /* vwadd.wx */, RISCV::VWADD_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19774 /* vwaddu.vv */, RISCV::VWADDU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19784 /* vwaddu.vx */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19794 /* vwaddu.wv */, RISCV::VWADDU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19804 /* vwaddu.wx */, RISCV::VWADDU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19814 /* vwcvt.x.x.v */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 19814 /* vwcvt.x.x.v */, RISCV::VWADD_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19826 /* vwcvtu.x.x.v */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__regX0__reg0, AMFBS_HasVInstructions, { MCK_VM, MCK_VM }, },
  { 19826 /* vwcvtu.x.x.v */, RISCV::VWADDU_VX, Convert__Reg1_0__Reg1_1__regX0__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19839 /* vwmacc.vv */, RISCV::VWMACC_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19849 /* vwmacc.vx */, RISCV::VWMACC_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19859 /* vwmaccsu.vv */, RISCV::VWMACCSU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19871 /* vwmaccsu.vx */, RISCV::VWMACCSU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19883 /* vwmaccu.vv */, RISCV::VWMACCU_VV, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19894 /* vwmaccu.vx */, RISCV::VWMACCU_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19905 /* vwmaccus.vx */, RISCV::VWMACCUS_VX, Convert__Reg1_0__Tie0_1_1__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_GPR, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19917 /* vwmul.vv */, RISCV::VWMUL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19926 /* vwmul.vx */, RISCV::VWMUL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19935 /* vwmulsu.vv */, RISCV::VWMULSU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19946 /* vwmulsu.vx */, RISCV::VWMULSU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19957 /* vwmulu.vv */, RISCV::VWMULU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19967 /* vwmulu.vx */, RISCV::VWMULU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 19977 /* vwredsum.vs */, RISCV::VWREDSUM_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 19989 /* vwredsumu.vs */, RISCV::VWREDSUMU_VS, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20002 /* vwsll.vi */, RISCV::VWSLL_VI, Convert__Reg1_0__Reg1_1__UImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_UImm5, MCK_RVVMaskRegOpOperand }, },
  { 20011 /* vwsll.vv */, RISCV::VWSLL_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20020 /* vwsll.vx */, RISCV::VWSLL_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasStdExtZvbb, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20029 /* vwsub.vv */, RISCV::VWSUB_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20038 /* vwsub.vx */, RISCV::VWSUB_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20047 /* vwsub.wv */, RISCV::VWSUB_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20056 /* vwsub.wx */, RISCV::VWSUB_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20065 /* vwsubu.vv */, RISCV::VWSUBU_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20075 /* vwsubu.vx */, RISCV::VWSUBU_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20085 /* vwsubu.wv */, RISCV::VWSUBU_WV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20095 /* vwsubu.wx */, RISCV::VWSUBU_WX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20105 /* vxor.vi */, RISCV::VXOR_VI, Convert__Reg1_0__Reg1_1__SImm51_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_SImm5, MCK_RVVMaskRegOpOperand }, },
  { 20113 /* vxor.vv */, RISCV::VXOR_VV, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20121 /* vxor.vx */, RISCV::VXOR_VX, Convert__Reg1_0__Reg1_1__Reg1_2__RVVMaskRegOpOperand1_3, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_GPR, MCK_RVVMaskRegOpOperand }, },
  { 20129 /* vzext.vf2 */, RISCV::VZEXT_VF2, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20139 /* vzext.vf4 */, RISCV::VZEXT_VF4, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20149 /* vzext.vf8 */, RISCV::VZEXT_VF8, Convert__Reg1_0__Reg1_1__RVVMaskRegOpOperand1_2, AMFBS_HasVInstructions, { MCK_VM, MCK_VM, MCK_RVVMaskRegOpOperand }, },
  { 20159 /* wfi */, RISCV::WFI, Convert_NoOperands, AMFBS_None, {  }, },
  { 20163 /* wrs.nto */, RISCV::WRS_NTO, Convert_NoOperands, AMFBS_HasStdExtZawrs, {  }, },
  { 20171 /* wrs.sto */, RISCV::WRS_STO, Convert_NoOperands, AMFBS_HasStdExtZawrs, {  }, },
  { 20179 /* xnor */, RISCV::XNOR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbbOrZbkb, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 20184 /* xor */, RISCV::XOR, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 20184 /* xor */, RISCV::XORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 20188 /* xori */, RISCV::XORI, Convert__Reg1_0__Reg1_1__SImm121_2, AMFBS_None, { MCK_GPR, MCK_GPR, MCK_SImm12 }, },
  { 20193 /* xperm4 */, RISCV::XPERM4, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkx, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 20200 /* xperm8 */, RISCV::XPERM8, Convert__Reg1_0__Reg1_1__Reg1_2, AMFBS_HasStdExtZbkx, { MCK_GPR, MCK_GPR, MCK_GPR }, },
  { 20207 /* zext.b */, RISCV::ANDI, Convert__Reg1_0__Reg1_1__imm_95_255, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 20214 /* zext.h */, RISCV::PACK, Convert__Reg1_0__Reg1_1__regX0, AMFBS_HasStdExtZbkb_NoStdExtZbb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 20214 /* zext.h */, RISCV::PACKW, Convert__Reg1_0__Reg1_1__regX0, AMFBS_HasStdExtZbkb_NoStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 20214 /* zext.h */, RISCV::ZEXT_H_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV32, { MCK_GPR, MCK_GPR }, },
  { 20214 /* zext.h */, RISCV::ZEXT_H_RV64, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbb_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 20214 /* zext.h */, RISCV::PseudoZEXT_H, Convert__Reg1_0__Reg1_1, AMFBS_None, { MCK_GPR, MCK_GPR }, },
  { 20221 /* zext.w */, RISCV::ADD_UW, Convert__Reg1_0__Reg1_1__regX0, AMFBS_HasStdExtZba_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 20221 /* zext.w */, RISCV::PseudoZEXT_W, Convert__Reg1_0__Reg1_1, AMFBS_IsRV64, { MCK_GPR, MCK_GPR }, },
  { 20228 /* zip */, RISCV::ZIP_RV32, Convert__Reg1_0__Reg1_1, AMFBS_HasStdExtZbkb_IsRV32, { MCK_GPR, MCK_GPR }, },
};

#include "llvm/Support/Debug.h"
#include "llvm/Support/Format.h"

unsigned RISCVAsmParser::
MatchInstructionImpl(const OperandVector &Operands,
                     MCInst &Inst,
                     uint64_t &ErrorInfo,
                     FeatureBitset &MissingFeatures,
                     bool matchingInlineAsm, unsigned VariantID) {
  // Eliminate obvious mismatches.
  if (Operands.size() > 8) {
    ErrorInfo = 8;
    return Match_InvalidOperand;
  }

  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the instruction mnemonic, which is the first token.
  StringRef Mnemonic = ((RISCVOperand &)*Operands[0]).getToken();

  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Some state to try to produce better error messages.
  bool HadMatchOtherThanFeatures = false;
  bool HadMatchOtherThanPredicate = false;
  unsigned RetCode = Match_InvalidOperand;
  MissingFeatures.set();
  // Set ErrorInfo to the operand that mismatches if it is
  // wrong for all instances of the instruction.
  ErrorInfo = ~0ULL;
  SmallBitVector OptionalOperandsMask(7);
  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }
  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  DEBUG_WITH_TYPE("asm-matcher", dbgs() << "AsmMatcher: found " <<
  std::distance(MnemonicRange.first, MnemonicRange.second) <<
  " encodings with mnemonic '" << Mnemonic << "'\n");

  // Return a more specific error code if no mnemonics match.
  if (MnemonicRange.first == MnemonicRange.second)
    return Match_MnemonicFail;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    bool HasRequiredFeatures =
      (AvailableFeatures & RequiredFeatures) == RequiredFeatures;
    DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Trying to match opcode "
                                          << MII.getName(it->Opcode) << "\n");
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());
    bool OperandsValid = true;
    OptionalOperandsMask.reset(0, 7);
    for (unsigned FormalIdx = 0, ActualIdx = 1; FormalIdx != 7; ++FormalIdx) {
      auto Formal = static_cast<MatchClassKind>(it->Classes[FormalIdx]);
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "  Matching formal operand class " << getMatchClassName(Formal)
                             << " against actual operand at index " << ActualIdx);
      if (ActualIdx < Operands.size())
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << " (";
                        Operands[ActualIdx]->print(dbgs()); dbgs() << "): ");
      else
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << ": ");
      if (ActualIdx >= Operands.size()) {
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "actual operand index out of range\n");
        if (Formal == InvalidMatchClass) {
          OptionalOperandsMask.set(FormalIdx, 7);
          break;
        }
        if (isSubclass(Formal, OptionalMatchClass)) {
          OptionalOperandsMask.set(FormalIdx);
          continue;
        }
        OperandsValid = false;
        ErrorInfo = ActualIdx;
        break;
      }
      MCParsedAsmOperand &Actual = *Operands[ActualIdx];
      unsigned Diag = validateOperandClass(Actual, Formal);
      if (Diag == Match_Success) {
        DEBUG_WITH_TYPE("asm-matcher",
                        dbgs() << "match success using generic matcher\n");
        ++ActualIdx;
        continue;
      }
      // If the generic handler indicates an invalid operand
      // failure, check for a special case.
      if (Diag != Match_Success) {
        unsigned TargetDiag = validateTargetOperandClass(Actual, Formal);
        if (TargetDiag == Match_Success) {
          DEBUG_WITH_TYPE("asm-matcher",
                          dbgs() << "match success using target matcher\n");
          ++ActualIdx;
          continue;
        }
        // If the target matcher returned a specific error code use
        // that, else use the one from the generic matcher.
        if (TargetDiag != Match_InvalidOperand && HasRequiredFeatures)
          Diag = TargetDiag;
      }
      // If current formal operand wasn't matched and it is optional
      // then try to match next formal operand
      if (Diag == Match_InvalidOperand && isSubclass(Formal, OptionalMatchClass)) {
        OptionalOperandsMask.set(FormalIdx);
        DEBUG_WITH_TYPE("asm-matcher", dbgs() << "ignoring optional operand\n");
        continue;
      }
      // If this operand is broken for all of the instances of this
      // mnemonic, keep track of it so we can report loc info.
      // If we already had a match that only failed due to a
      // target predicate, that diagnostic is preferred.
      if (!HadMatchOtherThanPredicate &&
          (it == MnemonicRange.first || ErrorInfo <= ActualIdx)) {
        if (HasRequiredFeatures && (ErrorInfo != ActualIdx || Diag != Match_InvalidOperand))
          RetCode = Diag;
        ErrorInfo = ActualIdx;
      }
      // Otherwise, just reject this instance of the mnemonic.
      OperandsValid = false;
      break;
    }

    if (!OperandsValid) {
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Opcode result: multiple "
                                               "operand mismatches, ignoring "
                                               "this opcode\n");
      continue;
    }
    if (!HasRequiredFeatures) {
      HadMatchOtherThanFeatures = true;
      FeatureBitset NewMissingFeatures = RequiredFeatures & ~AvailableFeatures;
      DEBUG_WITH_TYPE("asm-matcher", dbgs() << "Missing target features:";
                      for (unsigned I = 0, E = NewMissingFeatures.size(); I != E; ++I)
                        if (NewMissingFeatures[I])
                          dbgs() << ' ' << I;
                      dbgs() << "\n");
      if (NewMissingFeatures.count() <=
          MissingFeatures.count())
        MissingFeatures = NewMissingFeatures;
      continue;
    }

    Inst.clear();

    Inst.setOpcode(it->Opcode);
    // We have a potential match but have not rendered the operands.
    // Check the target predicate to handle any context sensitive
    // constraints.
    // For example, Ties that are referenced multiple times must be
    // checked here to ensure the input is the same for each match
    // constraints. If we leave it any later the ties will have been
    // canonicalized
    unsigned MatchResult;
    if ((MatchResult = checkEarlyTargetMatchPredicate(Inst, Operands)) != Match_Success) {
      Inst.clear();
      DEBUG_WITH_TYPE(
          "asm-matcher",
          dbgs() << "Early target match predicate failed with diag code "
                 << MatchResult << "\n");
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    unsigned DefaultsOffset[8] = { 0 };
    assert(OptionalOperandsMask.size() == 7);
    for (unsigned i = 0, NumDefaults = 0; i < 7; ++i) {
      DefaultsOffset[i + 1] = NumDefaults;
      NumDefaults += (OptionalOperandsMask[i] ? 1 : 0);
    }

    if (matchingInlineAsm) {
      convertToMapAndConstraints(it->ConvertFn, Operands);
      if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                          DefaultsOffset, ErrorInfo))
        return Match_InvalidTiedOperand;

      return Match_Success;
    }

    // We have selected a definite instruction, convert the parsed
    // operands into the appropriate MCInst.
    convertToMCInst(it->ConvertFn, Inst, it->Opcode, Operands,
                    OptionalOperandsMask, DefaultsOffset);

    // We have a potential match. Check the target predicate to
    // handle any context sensitive constraints.
    if ((MatchResult = checkTargetMatchPredicate(Inst)) != Match_Success) {
      DEBUG_WITH_TYPE("asm-matcher",
                      dbgs() << "Target match predicate failed with diag code "
                             << MatchResult << "\n");
      Inst.clear();
      RetCode = MatchResult;
      HadMatchOtherThanPredicate = true;
      continue;
    }

    if (!checkAsmTiedOperandConstraints(*this, it->ConvertFn, Operands,
                                         DefaultsOffset, ErrorInfo))
      return Match_InvalidTiedOperand;

    DEBUG_WITH_TYPE(
        "asm-matcher",
        dbgs() << "Opcode result: complete match, selecting this opcode\n");
    return Match_Success;
  }

  // Okay, we had no match.  Try to return a useful error code.
  if (HadMatchOtherThanPredicate || !HadMatchOtherThanFeatures)
    return RetCode;

  ErrorInfo = 0;
  return Match_MissingFeature;
}

namespace {
  struct OperandMatchEntry {
    uint16_t Mnemonic;
    uint8_t OperandMask;
    uint8_t Class;
    uint8_t RequiredFeaturesIdx;

    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcodeOperand {
    bool operator()(const OperandMatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic()  < RHS;
    }
    bool operator()(StringRef LHS, const OperandMatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const OperandMatchEntry &LHS, const OperandMatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace

static const OperandMatchEntry OperandMatchTable[1541] = {
  /* Operand List Mnemonic, Mask, Operand Class, Features */
  { 1 /* .insn_b */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 9 /* .insn_ca */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 18 /* .insn_cb */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 27 /* .insn_ci */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 36 /* .insn_ciw */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 46 /* .insn_cj */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 55 /* .insn_cl */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 55 /* .insn_cl */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 64 /* .insn_cr */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 73 /* .insn_cs */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 73 /* .insn_cs */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 82 /* .insn_css */, 1 /* 0 */, MCK_InsnCDirectiveOpcode, AMFBS_HasStdExtCOrZca },
  { 92 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 92 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 92 /* .insn_i */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 100 /* .insn_j */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 100 /* .insn_j */, 4 /* 2 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 108 /* .insn_r */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 108 /* .insn_r */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 116 /* .insn_r4 */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 125 /* .insn_s */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 125 /* .insn_s */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 133 /* .insn_sb */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 142 /* .insn_u */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 150 /* .insn_uj */, 1 /* 0 */, MCK_InsnDirectiveOpcode, AMFBS_None },
  { 150 /* .insn_uj */, 4 /* 2 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 159 /* add */, 8 /* 3 */, MCK_TPRelAddSymbol, AMFBS_None },
  { 285 /* amoadd.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 294 /* amoadd.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 306 /* amoadd.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 320 /* amoadd.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 332 /* amoadd.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 341 /* amoadd.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 353 /* amoadd.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 367 /* amoadd.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 379 /* amoadd.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 388 /* amoadd.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 400 /* amoadd.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 414 /* amoadd.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 426 /* amoadd.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 435 /* amoadd.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 447 /* amoadd.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 461 /* amoadd.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 473 /* amoand.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 482 /* amoand.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 494 /* amoand.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 508 /* amoand.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 520 /* amoand.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 529 /* amoand.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 541 /* amoand.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 555 /* amoand.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 567 /* amoand.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 576 /* amoand.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 588 /* amoand.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 602 /* amoand.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 614 /* amoand.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 623 /* amoand.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 635 /* amoand.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 649 /* amoand.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 661 /* amocas.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 670 /* amocas.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 682 /* amocas.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 696 /* amocas.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 708 /* amocas.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 708 /* amocas.d */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 708 /* amocas.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 717 /* amocas.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 717 /* amocas.d.aq */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 717 /* amocas.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 729 /* amocas.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 729 /* amocas.d.aqrl */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 729 /* amocas.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 743 /* amocas.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 743 /* amocas.d.rl */, 3 /* 0, 1 */, MCK_GPRPairRV32, AMFBS_HasStdExtZacas_IsRV32 },
  { 743 /* amocas.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV32 },
  { 755 /* amocas.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 764 /* amocas.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 776 /* amocas.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 790 /* amocas.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha_HasStdExtZacas },
  { 802 /* amocas.q */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 802 /* amocas.q */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 811 /* amocas.q.aq */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 811 /* amocas.q.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 823 /* amocas.q.aqrl */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 823 /* amocas.q.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 837 /* amocas.q.rl */, 3 /* 0, 1 */, MCK_GPRPairRV64, AMFBS_HasStdExtZacas_IsRV64 },
  { 837 /* amocas.q.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas_IsRV64 },
  { 849 /* amocas.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 858 /* amocas.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 870 /* amocas.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 884 /* amocas.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZacas },
  { 896 /* amomax.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 905 /* amomax.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 917 /* amomax.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 931 /* amomax.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 943 /* amomax.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 952 /* amomax.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 964 /* amomax.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 978 /* amomax.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 990 /* amomax.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 999 /* amomax.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1011 /* amomax.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1025 /* amomax.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1037 /* amomax.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1046 /* amomax.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1058 /* amomax.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1072 /* amomax.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1084 /* amomaxu.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1094 /* amomaxu.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1107 /* amomaxu.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1122 /* amomaxu.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1135 /* amomaxu.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1145 /* amomaxu.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1158 /* amomaxu.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1173 /* amomaxu.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1186 /* amomaxu.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1196 /* amomaxu.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1209 /* amomaxu.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1224 /* amomaxu.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1237 /* amomaxu.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1247 /* amomaxu.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1260 /* amomaxu.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1275 /* amomaxu.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1288 /* amomin.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1297 /* amomin.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1309 /* amomin.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1323 /* amomin.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1335 /* amomin.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1344 /* amomin.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1356 /* amomin.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1370 /* amomin.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1382 /* amomin.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1391 /* amomin.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1403 /* amomin.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1417 /* amomin.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1429 /* amomin.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1438 /* amomin.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1450 /* amomin.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1464 /* amomin.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1476 /* amominu.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1486 /* amominu.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1499 /* amominu.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1514 /* amominu.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1527 /* amominu.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1537 /* amominu.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1550 /* amominu.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1565 /* amominu.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1578 /* amominu.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1588 /* amominu.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1601 /* amominu.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1616 /* amominu.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1629 /* amominu.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1639 /* amominu.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1652 /* amominu.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1667 /* amominu.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1680 /* amoor.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1688 /* amoor.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1699 /* amoor.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1712 /* amoor.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1723 /* amoor.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1731 /* amoor.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1742 /* amoor.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1755 /* amoor.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1766 /* amoor.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1774 /* amoor.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1785 /* amoor.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1798 /* amoor.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1809 /* amoor.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1817 /* amoor.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1828 /* amoor.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1841 /* amoor.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 1852 /* amoswap.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1862 /* amoswap.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1875 /* amoswap.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1890 /* amoswap.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1903 /* amoswap.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1913 /* amoswap.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1926 /* amoswap.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1941 /* amoswap.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 1954 /* amoswap.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1964 /* amoswap.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1977 /* amoswap.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 1992 /* amoswap.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2005 /* amoswap.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2015 /* amoswap.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2028 /* amoswap.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2043 /* amoswap.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2056 /* amoxor.b */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2065 /* amoxor.b.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2077 /* amoxor.b.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2091 /* amoxor.b.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2103 /* amoxor.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2112 /* amoxor.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2124 /* amoxor.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2138 /* amoxor.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo_IsRV64 },
  { 2150 /* amoxor.h */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2159 /* amoxor.h.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2171 /* amoxor.h.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2185 /* amoxor.h.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZabha },
  { 2197 /* amoxor.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2206 /* amoxor.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2218 /* amoxor.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2232 /* amoxor.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZaamo },
  { 2912 /* call */, 1 /* 0 */, MCK_CallSymbol, AMFBS_None },
  { 2912 /* call */, 2 /* 1 */, MCK_CallSymbol, AMFBS_None },
  { 2917 /* cbo.clean */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 2927 /* cbo.flush */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 2937 /* cbo.inval */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicbom },
  { 2947 /* cbo.zero */, 1 /* 0 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicboz },
  { 3019 /* cm.pop */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 3019 /* cm.pop */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasStdExtZcmp },
  { 3026 /* cm.popret */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 3026 /* cm.popret */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasStdExtZcmp },
  { 3036 /* cm.popretz */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 3036 /* cm.popretz */, 2 /* 1 */, MCK_StackAdj, AMFBS_HasStdExtZcmp },
  { 3047 /* cm.push */, 2 /* 1 */, MCK_NegStackAdj, AMFBS_HasStdExtZcmp },
  { 3047 /* cm.push */, 1 /* 0 */, MCK_Rlist, AMFBS_HasStdExtZcmp },
  { 3066 /* csrc */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3066 /* csrc */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3071 /* csrci */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3077 /* csrr */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3082 /* csrrc */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3082 /* csrrc */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3088 /* csrrci */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3095 /* csrrs */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3095 /* csrrs */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3101 /* csrrsi */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3108 /* csrrw */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3108 /* csrrw */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3114 /* csrrwi */, 2 /* 1 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3121 /* csrs */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3121 /* csrs */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3126 /* csrsi */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3132 /* csrw */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3132 /* csrw */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 3137 /* csrwi */, 1 /* 0 */, MCK_CSRSystemRegister, AMFBS_None },
  { 5101 /* cv.lb */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5107 /* cv.lbu */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5114 /* cv.lh */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5120 /* cv.lhu */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5127 /* cv.lw */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 5776 /* cv.sb */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 6046 /* cv.sh */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 6661 /* cv.sw */, 2 /* 1 */, MCK_RegReg, AMFBS_HasVendorXCVmem_IsRV32 },
  { 6793 /* fabs.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6793 /* fabs.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6800 /* fabs.h */, 3 /* 0, 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 6807 /* fabs.s */, 3 /* 0, 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 6814 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 6814 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6814 /* fadd.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6814 /* fadd.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6814 /* fadd.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6821 /* fadd.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6821 /* fadd.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6821 /* fadd.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 6828 /* fadd.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 6828 /* fadd.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 6828 /* fadd.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 6835 /* fclass.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6835 /* fclass.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6844 /* fclass.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 6853 /* fclass.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 6862 /* fcvt.bf16.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfbfmin },
  { 6874 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZfhmin_HasStdExtD },
  { 6874 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6874 /* fcvt.d.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6874 /* fcvt.d.h */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6874 /* fcvt.d.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6874 /* fcvt.d.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6874 /* fcvt.d.h */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6883 /* fcvt.d.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 6883 /* fcvt.d.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6883 /* fcvt.d.l */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6892 /* fcvt.d.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 6892 /* fcvt.d.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6892 /* fcvt.d.lu */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6902 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 6902 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6902 /* fcvt.d.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6902 /* fcvt.d.s */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6902 /* fcvt.d.s */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6902 /* fcvt.d.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6902 /* fcvt.d.s */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6911 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 6911 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6911 /* fcvt.d.w */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6911 /* fcvt.d.w */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6911 /* fcvt.d.w */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6920 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtD },
  { 6920 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6920 /* fcvt.d.wu */, 1 /* 0 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 6920 /* fcvt.d.wu */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6920 /* fcvt.d.wu */, 1 /* 0 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 6930 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfhmin_HasStdExtD },
  { 6930 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6930 /* fcvt.h.d */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6930 /* fcvt.h.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV64 },
  { 6930 /* fcvt.h.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6930 /* fcvt.h.d */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6930 /* fcvt.h.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZhinxmin_HasStdExtZdinx_IsRV32 },
  { 6939 /* fcvt.h.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 6939 /* fcvt.h.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6939 /* fcvt.h.l */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6948 /* fcvt.h.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 6948 /* fcvt.h.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6948 /* fcvt.h.lu */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6958 /* fcvt.h.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfhmin },
  { 6958 /* fcvt.h.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinxmin },
  { 6958 /* fcvt.h.s */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin },
  { 6958 /* fcvt.h.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZhinxmin },
  { 6967 /* fcvt.h.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6967 /* fcvt.h.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6967 /* fcvt.h.w */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 6976 /* fcvt.h.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 6976 /* fcvt.h.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 6976 /* fcvt.h.wu */, 1 /* 0 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 6986 /* fcvt.l.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 6986 /* fcvt.l.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6986 /* fcvt.l.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 6995 /* fcvt.l.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 6995 /* fcvt.l.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 6995 /* fcvt.l.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7004 /* fcvt.l.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 7004 /* fcvt.l.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7004 /* fcvt.l.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7013 /* fcvt.lu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD_IsRV64 },
  { 7013 /* fcvt.lu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 7013 /* fcvt.lu.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64_IsRV64 },
  { 7023 /* fcvt.lu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh_IsRV64 },
  { 7023 /* fcvt.lu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7023 /* fcvt.lu.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx_IsRV64 },
  { 7033 /* fcvt.lu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 7033 /* fcvt.lu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7033 /* fcvt.lu.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7043 /* fcvt.s.bf16 */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZfbfmin },
  { 7055 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7055 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7055 /* fcvt.s.d */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7055 /* fcvt.s.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7055 /* fcvt.s.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7055 /* fcvt.s.d */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7055 /* fcvt.s.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7064 /* fcvt.s.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZfhmin },
  { 7064 /* fcvt.s.h */, 4 /* 2 */, MCK_FRMArgLegacy, AMFBS_HasStdExtZhinxmin },
  { 7064 /* fcvt.s.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinxmin },
  { 7064 /* fcvt.s.h */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZhinxmin },
  { 7073 /* fcvt.s.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 7073 /* fcvt.s.l */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7073 /* fcvt.s.l */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7082 /* fcvt.s.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF_IsRV64 },
  { 7082 /* fcvt.s.lu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7082 /* fcvt.s.lu */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx_IsRV64 },
  { 7092 /* fcvt.s.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7092 /* fcvt.s.w */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7092 /* fcvt.s.w */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7101 /* fcvt.s.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7101 /* fcvt.s.wu */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7101 /* fcvt.s.wu */, 1 /* 0 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7111 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7111 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7111 /* fcvt.w.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7111 /* fcvt.w.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7111 /* fcvt.w.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7120 /* fcvt.w.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7120 /* fcvt.w.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7120 /* fcvt.w.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7129 /* fcvt.w.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7129 /* fcvt.w.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7129 /* fcvt.w.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7138 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7138 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7138 /* fcvt.wu.d */, 2 /* 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7138 /* fcvt.wu.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7138 /* fcvt.wu.d */, 2 /* 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7148 /* fcvt.wu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7148 /* fcvt.wu.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7148 /* fcvt.wu.h */, 2 /* 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7158 /* fcvt.wu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7158 /* fcvt.wu.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7158 /* fcvt.wu.s */, 2 /* 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7168 /* fcvtmod.w.d */, 4 /* 2 */, MCK_RTZArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 7180 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7180 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7180 /* fdiv.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7180 /* fdiv.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7180 /* fdiv.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7187 /* fdiv.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7187 /* fdiv.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7187 /* fdiv.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7194 /* fdiv.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7194 /* fdiv.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7194 /* fdiv.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7201 /* fence */, 3 /* 0, 1 */, MCK_FenceArg, AMFBS_None },
  { 7225 /* feq.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7225 /* feq.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7231 /* feq.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7237 /* feq.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7243 /* fge.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7243 /* fge.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7249 /* fge.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7255 /* fge.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7282 /* fgt.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7282 /* fgt.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7288 /* fgt.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7294 /* fgt.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7321 /* fld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtD },
  { 7325 /* fle.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7325 /* fle.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7331 /* fle.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7337 /* fle.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7364 /* flh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtZfhmin },
  { 7368 /* fli.d */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtD },
  { 7374 /* fli.h */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa_HasStdExtZfhOrZvfh },
  { 7380 /* fli.s */, 2 /* 1 */, MCK_LoadFPImm, AMFBS_HasStdExtZfa },
  { 7386 /* flt.d */, 6 /* 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7386 /* flt.d */, 6 /* 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7392 /* flt.h */, 6 /* 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7398 /* flt.s */, 6 /* 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7425 /* flw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtF },
  { 7429 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7429 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7429 /* fmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7429 /* fmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7429 /* fmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7437 /* fmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7437 /* fmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7437 /* fmadd.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7445 /* fmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7445 /* fmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7445 /* fmadd.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7453 /* fmax.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7453 /* fmax.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7460 /* fmax.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7467 /* fmax.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7498 /* fmin.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7498 /* fmin.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7505 /* fmin.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7512 /* fmin.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7543 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7543 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7543 /* fmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7543 /* fmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7543 /* fmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7551 /* fmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7551 /* fmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7551 /* fmsub.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7559 /* fmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7559 /* fmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7559 /* fmsub.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7567 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7567 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7567 /* fmul.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7567 /* fmul.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7567 /* fmul.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7574 /* fmul.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7574 /* fmul.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7574 /* fmul.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7581 /* fmul.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7581 /* fmul.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7581 /* fmul.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7588 /* fmv.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7588 /* fmv.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7602 /* fmv.h */, 3 /* 0, 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7616 /* fmv.s */, 3 /* 0, 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7672 /* fneg.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7672 /* fneg.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7679 /* fneg.h */, 3 /* 0, 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7686 /* fneg.s */, 3 /* 0, 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7693 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7693 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7693 /* fnmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7693 /* fnmadd.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7693 /* fnmadd.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7702 /* fnmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7702 /* fnmadd.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7702 /* fnmadd.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7711 /* fnmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7711 /* fnmadd.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7711 /* fnmadd.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7720 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7720 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7720 /* fnmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7720 /* fnmsub.d */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7720 /* fnmsub.d */, 15 /* 0, 1, 2, 3 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7729 /* fnmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7729 /* fnmsub.h */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7729 /* fnmsub.h */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7738 /* fnmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7738 /* fnmsub.s */, 16 /* 4 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7738 /* fnmsub.s */, 15 /* 0, 1, 2, 3 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7761 /* fround.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 7770 /* fround.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtZfh },
  { 7779 /* fround.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa },
  { 7788 /* froundnx.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtD },
  { 7799 /* froundnx.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa_HasStdExtZfh },
  { 7810 /* froundnx.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfa },
  { 7837 /* fsd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtD },
  { 7858 /* fsgnj.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7858 /* fsgnj.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7866 /* fsgnj.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7874 /* fsgnj.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7882 /* fsgnjn.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7882 /* fsgnjn.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7891 /* fsgnjn.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7900 /* fsgnjn.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7909 /* fsgnjx.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7909 /* fsgnjx.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7918 /* fsgnjx.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7927 /* fsgnjx.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7936 /* fsh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtZfhmin },
  { 7940 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7940 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7940 /* fsqrt.d */, 3 /* 0, 1 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7940 /* fsqrt.d */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7940 /* fsqrt.d */, 3 /* 0, 1 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7948 /* fsqrt.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7948 /* fsqrt.h */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7948 /* fsqrt.h */, 3 /* 0, 1 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7956 /* fsqrt.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7956 /* fsqrt.s */, 4 /* 2 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7956 /* fsqrt.s */, 3 /* 0, 1 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 7980 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtD },
  { 7980 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7980 /* fsub.d */, 7 /* 0, 1, 2 */, MCK_GPRF64AsFPR, AMFBS_HasStdExtZdinx_IsRV64 },
  { 7980 /* fsub.d */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7980 /* fsub.d */, 7 /* 0, 1, 2 */, MCK_GPRPairAsFPR, AMFBS_HasStdExtZdinx_IsRV32 },
  { 7987 /* fsub.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfh },
  { 7987 /* fsub.h */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZhinx },
  { 7987 /* fsub.h */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR16, AMFBS_HasStdExtZhinx },
  { 7994 /* fsub.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtF },
  { 7994 /* fsub.s */, 8 /* 3 */, MCK_FRMArg, AMFBS_HasStdExtZfinx },
  { 7994 /* fsub.s */, 7 /* 0, 1, 2 */, MCK_GPRAsFPR32, AMFBS_HasStdExtZfinx },
  { 8001 /* fsw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_HasStdExtF },
  { 8053 /* hlv.b */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8059 /* hlv.bu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8066 /* hlv.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 8072 /* hlv.h */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8078 /* hlv.hu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8085 /* hlv.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8091 /* hlv.wu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 8098 /* hlvx.hu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8106 /* hlvx.wu */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8114 /* hsv.b */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8120 /* hsv.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasStdExtH },
  { 8126 /* hsv.h */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8132 /* hsv.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtH },
  { 8138 /* j */, 1 /* 0 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 8140 /* jal */, 1 /* 0 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 8140 /* jal */, 2 /* 1 */, MCK_SImm21Lsb0JAL, AMFBS_None },
  { 8144 /* jalr */, 32 /* 5 */, MCK_TLSDESCCallSymbol, AMFBS_None },
  { 8152 /* jump */, 1 /* 0 */, MCK_PseudoJumpSymbol, AMFBS_None },
  { 8157 /* la */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8160 /* la.tls.gd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8170 /* la.tls.ie */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8180 /* la.tlsdesc */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8191 /* lb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8194 /* lb.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8200 /* lb.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8208 /* lbu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8212 /* ld */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 8215 /* ld.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr_IsRV64 },
  { 8221 /* ld.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr_IsRV64 },
  { 8229 /* lga */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8233 /* lh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8236 /* lh.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8242 /* lh.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8250 /* lhu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8257 /* lla */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8266 /* lr.d */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 8271 /* lr.d.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 8279 /* lr.d.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 8289 /* lr.d.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 8297 /* lr.w */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 8302 /* lr.w.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 8310 /* lr.w.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 8320 /* lr.w.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 8332 /* lw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 8335 /* lw.aq */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8341 /* lw.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 8349 /* lwu */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 9909 /* sb */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 9912 /* sb.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 9920 /* sb.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 9926 /* sc.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 9931 /* sc.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 9939 /* sc.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 9949 /* sc.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc_IsRV64 },
  { 9957 /* sc.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 9962 /* sc.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 9970 /* sc.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 9980 /* sc.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalrsc },
  { 9996 /* sd */, 2 /* 1 */, MCK_BareSymbol, AMFBS_IsRV64 },
  { 9999 /* sd.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr_IsRV64 },
  { 10007 /* sd.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr_IsRV64 },
  { 10372 /* sf.vfnrclip.x.f.qf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXSfvfnrclipxfqf },
  { 10391 /* sf.vfnrclip.xu.f.qf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXSfvfnrclipxfqf },
  { 10622 /* sh */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 10625 /* sh.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 10633 /* sh.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 10988 /* ssamoswap.d */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 11000 /* ssamoswap.d.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 11015 /* ssamoswap.d.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 11032 /* ssamoswap.d.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss_IsRV64 },
  { 11047 /* ssamoswap.w */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 11059 /* ssamoswap.w.aq */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 11074 /* ssamoswap.w.aqrl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 11091 /* ssamoswap.w.rl */, 4 /* 2 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZicfiss },
  { 11137 /* sw */, 2 /* 1 */, MCK_BareSymbol, AMFBS_None },
  { 11140 /* sw.aqrl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 11148 /* sw.rl */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasStdExtZalasr },
  { 11154 /* tail */, 1 /* 0 */, MCK_CallSymbol, AMFBS_None },
  { 12142 /* th.vmaqa.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 12154 /* th.vmaqa.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 12166 /* th.vmaqasu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 12180 /* th.vmaqasu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 12194 /* th.vmaqau.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 12207 /* th.vmaqau.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 12220 /* th.vmaqaus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVendorXTHeadVdot },
  { 12246 /* vaadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12255 /* vaadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12264 /* vaaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12274 /* vaaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12311 /* vadd.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12319 /* vadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12327 /* vadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12446 /* vand.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12454 /* vand.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12462 /* vand.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12470 /* vandn.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 12479 /* vandn.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 12488 /* vasub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12497 /* vasub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12506 /* vasubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12516 /* vasubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12526 /* vbrev.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 12534 /* vbrev8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 12543 /* vclmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbcOrZvbc32e },
  { 12553 /* vclmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbcOrZvbc32e },
  { 12563 /* vclmulh.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbcOrZvbc32e },
  { 12574 /* vclmulh.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbcOrZvbc32e },
  { 12585 /* vclz.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 12605 /* vcpop.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12613 /* vcpop.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 12621 /* vctz.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 12628 /* vdiv.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12636 /* vdiv.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12644 /* vdivu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12653 /* vdivu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12662 /* vfabs.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12670 /* vfadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12679 /* vfadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12688 /* vfclass.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12698 /* vfcvt.f.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12710 /* vfcvt.f.xu.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12723 /* vfcvt.rtz.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12739 /* vfcvt.rtz.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12756 /* vfcvt.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12768 /* vfcvt.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12781 /* vfdiv.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12790 /* vfdiv.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12799 /* vfirst.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 12808 /* vfmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12818 /* vfmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12828 /* vfmadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12838 /* vfmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12848 /* vfmax.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12857 /* vfmax.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12878 /* vfmin.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12887 /* vfmin.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12896 /* vfmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12906 /* vfmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12916 /* vfmsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12926 /* vfmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12936 /* vfmul.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12945 /* vfmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12981 /* vfncvt.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 12994 /* vfncvt.f.x.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13007 /* vfncvt.f.xu.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13021 /* vfncvt.rod.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13038 /* vfncvt.rtz.x.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13055 /* vfncvt.rtz.xu.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13073 /* vfncvt.x.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13086 /* vfncvt.xu.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13100 /* vfncvtbf16.f.f.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfmin },
  { 13117 /* vfneg.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13125 /* vfnmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13136 /* vfnmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13147 /* vfnmadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13158 /* vfnmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13169 /* vfnmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13180 /* vfnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13191 /* vfnmsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13202 /* vfnmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13213 /* vfrdiv.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13223 /* vfrec7.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13232 /* vfredmax.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13244 /* vfredmin.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13256 /* vfredosum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13269 /* vfredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13281 /* vfredusum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13294 /* vfrsqrt7.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13305 /* vfrsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13315 /* vfsgnj.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13325 /* vfsgnj.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13335 /* vfsgnjn.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13346 /* vfsgnjn.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13357 /* vfsgnjx.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13368 /* vfsgnjx.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13379 /* vfslide1down.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13395 /* vfslide1up.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13409 /* vfsqrt.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13418 /* vfsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13427 /* vfsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13436 /* vfwadd.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13446 /* vfwadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13456 /* vfwadd.wf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13466 /* vfwadd.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13476 /* vfwcvt.f.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13489 /* vfwcvt.f.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13502 /* vfwcvt.f.xu.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13516 /* vfwcvt.rtz.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13533 /* vfwcvt.rtz.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13551 /* vfwcvt.x.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13564 /* vfwcvt.xu.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13578 /* vfwcvtbf16.f.f.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfmin },
  { 13595 /* vfwmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13606 /* vfwmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13617 /* vfwmaccbf16.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfwma },
  { 13632 /* vfwmaccbf16.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvfbfwma },
  { 13647 /* vfwmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13658 /* vfwmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13669 /* vfwmul.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13679 /* vfwmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13689 /* vfwnmacc.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13701 /* vfwnmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13713 /* vfwnmsac.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13725 /* vfwnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13737 /* vfwredosum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13751 /* vfwredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13764 /* vfwredusum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13778 /* vfwsub.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13788 /* vfwsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13798 /* vfwsub.wf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13808 /* vfwsub.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 13854 /* vid.v */, 2 /* 1 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13860 /* viota.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 13875 /* vl1re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13885 /* vl1re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13895 /* vl1re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13905 /* vl1re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13921 /* vl2re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13931 /* vl2re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13941 /* vl2re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13951 /* vl2re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13967 /* vl4re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13977 /* vl4re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 13987 /* vl4re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 13997 /* vl4re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14013 /* vl8re16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14023 /* vl8re32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14033 /* vl8re64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14043 /* vl8re8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14059 /* vle16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14059 /* vle16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14067 /* vle16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14067 /* vle16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14077 /* vle32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14077 /* vle32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14085 /* vle32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14085 /* vle32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14095 /* vle64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14095 /* vle64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14103 /* vle64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14103 /* vle64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14113 /* vle8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14113 /* vle8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14120 /* vle8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14120 /* vle8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14129 /* vlm.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14135 /* vloxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14135 /* vloxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14146 /* vloxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14146 /* vloxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14157 /* vloxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 14157 /* vloxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 14168 /* vloxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14168 /* vloxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14178 /* vloxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14178 /* vloxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14193 /* vloxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14193 /* vloxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14208 /* vloxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14208 /* vloxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14223 /* vloxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14223 /* vloxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14237 /* vloxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14237 /* vloxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14252 /* vloxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14252 /* vloxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14267 /* vloxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14267 /* vloxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14282 /* vloxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14282 /* vloxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14296 /* vloxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14296 /* vloxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14311 /* vloxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14311 /* vloxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14326 /* vloxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14326 /* vloxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14341 /* vloxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14341 /* vloxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14355 /* vloxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14355 /* vloxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14370 /* vloxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14370 /* vloxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14385 /* vloxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14385 /* vloxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14400 /* vloxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14400 /* vloxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14414 /* vloxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14414 /* vloxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14429 /* vloxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14429 /* vloxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14444 /* vloxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14444 /* vloxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14459 /* vloxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14459 /* vloxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14473 /* vloxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14473 /* vloxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14488 /* vloxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14488 /* vloxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14503 /* vloxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14503 /* vloxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14518 /* vloxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14518 /* vloxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14532 /* vloxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14532 /* vloxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14547 /* vloxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14547 /* vloxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14562 /* vloxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14562 /* vloxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 14577 /* vloxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14577 /* vloxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14591 /* vlse16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14591 /* vlse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14600 /* vlse32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14600 /* vlse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14609 /* vlse64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14609 /* vlse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14618 /* vlse8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14618 /* vlse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14626 /* vlseg2e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14626 /* vlseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14638 /* vlseg2e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14638 /* vlseg2e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14652 /* vlseg2e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14652 /* vlseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14664 /* vlseg2e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14664 /* vlseg2e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14678 /* vlseg2e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14678 /* vlseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14690 /* vlseg2e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14690 /* vlseg2e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14704 /* vlseg2e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14704 /* vlseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14715 /* vlseg2e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14715 /* vlseg2e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14728 /* vlseg3e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14728 /* vlseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14740 /* vlseg3e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14740 /* vlseg3e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14754 /* vlseg3e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14754 /* vlseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14766 /* vlseg3e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14766 /* vlseg3e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14780 /* vlseg3e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14780 /* vlseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14792 /* vlseg3e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14792 /* vlseg3e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14806 /* vlseg3e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14806 /* vlseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14817 /* vlseg3e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14817 /* vlseg3e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14830 /* vlseg4e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14830 /* vlseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14842 /* vlseg4e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14842 /* vlseg4e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14856 /* vlseg4e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14856 /* vlseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14868 /* vlseg4e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14868 /* vlseg4e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14882 /* vlseg4e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14882 /* vlseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14894 /* vlseg4e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14894 /* vlseg4e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14908 /* vlseg4e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14908 /* vlseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14919 /* vlseg4e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14919 /* vlseg4e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14932 /* vlseg5e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14932 /* vlseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14944 /* vlseg5e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14944 /* vlseg5e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14958 /* vlseg5e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14958 /* vlseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14970 /* vlseg5e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 14970 /* vlseg5e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 14984 /* vlseg5e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14984 /* vlseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 14996 /* vlseg5e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 14996 /* vlseg5e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15010 /* vlseg5e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15010 /* vlseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15021 /* vlseg5e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15021 /* vlseg5e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15034 /* vlseg6e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15034 /* vlseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15046 /* vlseg6e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15046 /* vlseg6e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15060 /* vlseg6e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15060 /* vlseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15072 /* vlseg6e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15072 /* vlseg6e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15086 /* vlseg6e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15086 /* vlseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15098 /* vlseg6e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15098 /* vlseg6e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15112 /* vlseg6e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15112 /* vlseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15123 /* vlseg6e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15123 /* vlseg6e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15136 /* vlseg7e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15136 /* vlseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15148 /* vlseg7e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15148 /* vlseg7e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15162 /* vlseg7e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15162 /* vlseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15174 /* vlseg7e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15174 /* vlseg7e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15188 /* vlseg7e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15188 /* vlseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15200 /* vlseg7e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15200 /* vlseg7e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15214 /* vlseg7e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15214 /* vlseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15225 /* vlseg7e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15225 /* vlseg7e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15238 /* vlseg8e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15238 /* vlseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15250 /* vlseg8e16ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15250 /* vlseg8e16ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15264 /* vlseg8e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15264 /* vlseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15276 /* vlseg8e32ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15276 /* vlseg8e32ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15290 /* vlseg8e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15290 /* vlseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15302 /* vlseg8e64ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15302 /* vlseg8e64ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15316 /* vlseg8e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15316 /* vlseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15327 /* vlseg8e8ff.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15327 /* vlseg8e8ff.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15340 /* vlsseg2e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15340 /* vlsseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15353 /* vlsseg2e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15353 /* vlsseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15366 /* vlsseg2e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15366 /* vlsseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15379 /* vlsseg2e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15379 /* vlsseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15391 /* vlsseg3e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15391 /* vlsseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15404 /* vlsseg3e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15404 /* vlsseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15417 /* vlsseg3e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15417 /* vlsseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15430 /* vlsseg3e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15430 /* vlsseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15442 /* vlsseg4e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15442 /* vlsseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15455 /* vlsseg4e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15455 /* vlsseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15468 /* vlsseg4e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15468 /* vlsseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15481 /* vlsseg4e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15481 /* vlsseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15493 /* vlsseg5e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15493 /* vlsseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15506 /* vlsseg5e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15506 /* vlsseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15519 /* vlsseg5e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15519 /* vlsseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15532 /* vlsseg5e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15532 /* vlsseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15544 /* vlsseg6e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15544 /* vlsseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15557 /* vlsseg6e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15557 /* vlsseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15570 /* vlsseg6e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15570 /* vlsseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15583 /* vlsseg6e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15583 /* vlsseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15595 /* vlsseg7e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15595 /* vlsseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15608 /* vlsseg7e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15608 /* vlsseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15621 /* vlsseg7e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15621 /* vlsseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15634 /* vlsseg7e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15634 /* vlsseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15646 /* vlsseg8e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15646 /* vlsseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15659 /* vlsseg8e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15659 /* vlsseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15672 /* vlsseg8e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 15672 /* vlsseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 15685 /* vlsseg8e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15685 /* vlsseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15697 /* vluxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15697 /* vluxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15708 /* vluxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15708 /* vluxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15719 /* vluxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 15719 /* vluxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 15730 /* vluxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15730 /* vluxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15740 /* vluxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15740 /* vluxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15755 /* vluxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15755 /* vluxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15770 /* vluxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15770 /* vluxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15785 /* vluxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15785 /* vluxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15799 /* vluxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15799 /* vluxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15814 /* vluxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15814 /* vluxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15829 /* vluxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15829 /* vluxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15844 /* vluxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15844 /* vluxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15858 /* vluxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15858 /* vluxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15873 /* vluxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15873 /* vluxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15888 /* vluxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15888 /* vluxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15903 /* vluxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15903 /* vluxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15917 /* vluxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15917 /* vluxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15932 /* vluxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15932 /* vluxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15947 /* vluxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15947 /* vluxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 15962 /* vluxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15962 /* vluxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15976 /* vluxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15976 /* vluxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 15991 /* vluxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 15991 /* vluxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16006 /* vluxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16006 /* vluxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16021 /* vluxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16021 /* vluxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16035 /* vluxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16035 /* vluxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16050 /* vluxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16050 /* vluxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16065 /* vluxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16065 /* vluxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16080 /* vluxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16080 /* vluxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16094 /* vluxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16094 /* vluxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16109 /* vluxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16109 /* vluxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16124 /* vluxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16124 /* vluxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 16139 /* vluxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16139 /* vluxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 16153 /* vmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16162 /* vmacc.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16228 /* vmadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16237 /* vmadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16277 /* vmax.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16285 /* vmax.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16293 /* vmaxu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16302 /* vmaxu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16352 /* vmfeq.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16361 /* vmfeq.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16370 /* vmfge.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16379 /* vmfge.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16388 /* vmfgt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16397 /* vmfgt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16406 /* vmfle.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16415 /* vmfle.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16424 /* vmflt.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16433 /* vmflt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16442 /* vmfne.vf */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16451 /* vmfne.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsAnyF },
  { 16460 /* vmin.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16468 /* vmin.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16476 /* vminu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16485 /* vminu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16594 /* vmsbf.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16602 /* vmseq.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16611 /* vmseq.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16620 /* vmseq.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16637 /* vmsge.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16646 /* vmsge.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16655 /* vmsge.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16655 /* vmsge.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16664 /* vmsgeu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16674 /* vmsgeu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16684 /* vmsgeu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16684 /* vmsgeu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16694 /* vmsgt.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16703 /* vmsgt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16712 /* vmsgt.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16721 /* vmsgtu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16731 /* vmsgtu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16741 /* vmsgtu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16751 /* vmsif.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16759 /* vmsle.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16768 /* vmsle.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16777 /* vmsle.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16786 /* vmsleu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16796 /* vmsleu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16806 /* vmsleu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16816 /* vmslt.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16825 /* vmslt.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16834 /* vmslt.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16843 /* vmsltu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16853 /* vmsltu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16863 /* vmsltu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16873 /* vmsne.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16882 /* vmsne.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16891 /* vmsne.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16900 /* vmsof.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16908 /* vmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16916 /* vmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16924 /* vmulh.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16933 /* vmulh.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16942 /* vmulhsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16953 /* vmulhsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16964 /* vmulhu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 16974 /* vmulhu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17075 /* vnclip.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17085 /* vnclip.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17095 /* vnclip.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17105 /* vnclipu.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17116 /* vnclipu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17127 /* vnclipu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17138 /* vncvt.x.x.w */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17150 /* vneg.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17157 /* vnmsac.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17167 /* vnmsac.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17177 /* vnmsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17187 /* vnmsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17197 /* vnot.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17204 /* vnsra.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17213 /* vnsra.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17222 /* vnsra.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17231 /* vnsrl.wi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17240 /* vnsrl.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17249 /* vnsrl.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17258 /* vor.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17265 /* vor.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17272 /* vor.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17279 /* vpopc.m */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17287 /* vredand.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17298 /* vredmax.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17309 /* vredmaxu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17321 /* vredmin.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17332 /* vredminu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17344 /* vredor.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17354 /* vredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17365 /* vredxor.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17376 /* vrem.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17384 /* vrem.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17392 /* vremu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17401 /* vremu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17410 /* vrev8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 17418 /* vrgather.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17430 /* vrgather.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17442 /* vrgather.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17454 /* vrgatherei16.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17470 /* vrol.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 17478 /* vrol.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 17486 /* vror.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 17494 /* vror.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 17502 /* vror.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvkb },
  { 17510 /* vrsub.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17519 /* vrsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17528 /* vs1r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17535 /* vs2r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17542 /* vs4r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17549 /* vs8r.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17556 /* vsadd.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17565 /* vsadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17574 /* vsadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17583 /* vsaddu.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17593 /* vsaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17603 /* vsaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17638 /* vse16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17638 /* vse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17646 /* vse32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17646 /* vse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17654 /* vse64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 17654 /* vse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 17662 /* vse8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17662 /* vse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17669 /* vsetivli */, 4 /* 2 */, MCK_VTypeI10, AMFBS_HasVInstructions },
  { 17685 /* vsetvli */, 4 /* 2 */, MCK_VTypeI11, AMFBS_HasVInstructions },
  { 17693 /* vsext.vf2 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17703 /* vsext.vf4 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17713 /* vsext.vf8 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17756 /* vslide1down.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17771 /* vslide1up.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17784 /* vslidedown.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17798 /* vslidedown.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17812 /* vslideup.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17824 /* vslideup.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17836 /* vsll.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17844 /* vsll.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17852 /* vsll.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17860 /* vsm.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17912 /* vsmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17921 /* vsmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17930 /* vsoxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17930 /* vsoxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17941 /* vsoxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17941 /* vsoxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17952 /* vsoxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 17952 /* vsoxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 17963 /* vsoxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17963 /* vsoxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17973 /* vsoxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17973 /* vsoxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 17988 /* vsoxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 17988 /* vsoxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18003 /* vsoxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18003 /* vsoxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18018 /* vsoxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18018 /* vsoxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18032 /* vsoxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18032 /* vsoxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18047 /* vsoxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18047 /* vsoxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18062 /* vsoxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18062 /* vsoxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18077 /* vsoxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18077 /* vsoxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18091 /* vsoxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18091 /* vsoxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18106 /* vsoxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18106 /* vsoxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18121 /* vsoxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18121 /* vsoxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18136 /* vsoxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18136 /* vsoxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18150 /* vsoxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18150 /* vsoxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18165 /* vsoxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18165 /* vsoxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18180 /* vsoxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18180 /* vsoxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18195 /* vsoxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18195 /* vsoxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18209 /* vsoxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18209 /* vsoxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18224 /* vsoxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18224 /* vsoxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18239 /* vsoxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18239 /* vsoxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18254 /* vsoxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18254 /* vsoxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18268 /* vsoxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18268 /* vsoxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18283 /* vsoxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18283 /* vsoxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18298 /* vsoxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18298 /* vsoxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18313 /* vsoxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18313 /* vsoxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18327 /* vsoxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18327 /* vsoxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18342 /* vsoxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18342 /* vsoxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18357 /* vsoxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18357 /* vsoxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 18372 /* vsoxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18372 /* vsoxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18386 /* vsra.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18394 /* vsra.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18402 /* vsra.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18410 /* vsrl.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18418 /* vsrl.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18426 /* vsrl.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18434 /* vsse16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18434 /* vsse16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18443 /* vsse32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18443 /* vsse32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18452 /* vsse64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18452 /* vsse64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18461 /* vsse8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18461 /* vsse8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18469 /* vsseg2e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18469 /* vsseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18481 /* vsseg2e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18481 /* vsseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18493 /* vsseg2e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18493 /* vsseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18505 /* vsseg2e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18505 /* vsseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18516 /* vsseg3e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18516 /* vsseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18528 /* vsseg3e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18528 /* vsseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18540 /* vsseg3e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18540 /* vsseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18552 /* vsseg3e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18552 /* vsseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18563 /* vsseg4e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18563 /* vsseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18575 /* vsseg4e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18575 /* vsseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18587 /* vsseg4e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18587 /* vsseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18599 /* vsseg4e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18599 /* vsseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18610 /* vsseg5e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18610 /* vsseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18622 /* vsseg5e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18622 /* vsseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18634 /* vsseg5e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18634 /* vsseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18646 /* vsseg5e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18646 /* vsseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18657 /* vsseg6e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18657 /* vsseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18669 /* vsseg6e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18669 /* vsseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18681 /* vsseg6e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18681 /* vsseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18693 /* vsseg6e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18693 /* vsseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18704 /* vsseg7e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18704 /* vsseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18716 /* vsseg7e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18716 /* vsseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18728 /* vsseg7e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18728 /* vsseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18740 /* vsseg7e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18740 /* vsseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18751 /* vsseg8e16.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18751 /* vsseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18763 /* vsseg8e32.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18763 /* vsseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18775 /* vsseg8e64.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18775 /* vsseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18787 /* vsseg8e8.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18787 /* vsseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18798 /* vssra.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18807 /* vssra.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18816 /* vssra.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18825 /* vssrl.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18834 /* vssrl.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18843 /* vssrl.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18852 /* vssseg2e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18852 /* vssseg2e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18865 /* vssseg2e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18865 /* vssseg2e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18878 /* vssseg2e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18878 /* vssseg2e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18891 /* vssseg2e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18891 /* vssseg2e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18903 /* vssseg3e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18903 /* vssseg3e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18916 /* vssseg3e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18916 /* vssseg3e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18929 /* vssseg3e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18929 /* vssseg3e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18942 /* vssseg3e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18942 /* vssseg3e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18954 /* vssseg4e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18954 /* vssseg4e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18967 /* vssseg4e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18967 /* vssseg4e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 18980 /* vssseg4e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 18980 /* vssseg4e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 18993 /* vssseg4e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 18993 /* vssseg4e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19005 /* vssseg5e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19005 /* vssseg5e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19018 /* vssseg5e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19018 /* vssseg5e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19031 /* vssseg5e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 19031 /* vssseg5e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 19044 /* vssseg5e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19044 /* vssseg5e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19056 /* vssseg6e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19056 /* vssseg6e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19069 /* vssseg6e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19069 /* vssseg6e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19082 /* vssseg6e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 19082 /* vssseg6e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 19095 /* vssseg6e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19095 /* vssseg6e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19107 /* vssseg7e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19107 /* vssseg7e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19120 /* vssseg7e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19120 /* vssseg7e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19133 /* vssseg7e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 19133 /* vssseg7e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 19146 /* vssseg7e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19146 /* vssseg7e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19158 /* vssseg8e16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19158 /* vssseg8e16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19171 /* vssseg8e32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19171 /* vssseg8e32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19184 /* vssseg8e64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64 },
  { 19184 /* vssseg8e64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64 },
  { 19197 /* vssseg8e8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19197 /* vssseg8e8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19209 /* vssub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19218 /* vssub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19227 /* vssubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19237 /* vssubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19247 /* vsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19255 /* vsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19263 /* vsuxei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19263 /* vsuxei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19274 /* vsuxei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19274 /* vsuxei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19285 /* vsuxei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 19285 /* vsuxei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_IsRV64_HasVInstructionsI64 },
  { 19296 /* vsuxei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19296 /* vsuxei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19306 /* vsuxseg2ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19306 /* vsuxseg2ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19321 /* vsuxseg2ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19321 /* vsuxseg2ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19336 /* vsuxseg2ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19336 /* vsuxseg2ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19351 /* vsuxseg2ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19351 /* vsuxseg2ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19365 /* vsuxseg3ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19365 /* vsuxseg3ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19380 /* vsuxseg3ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19380 /* vsuxseg3ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19395 /* vsuxseg3ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19395 /* vsuxseg3ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19410 /* vsuxseg3ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19410 /* vsuxseg3ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19424 /* vsuxseg4ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19424 /* vsuxseg4ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19439 /* vsuxseg4ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19439 /* vsuxseg4ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19454 /* vsuxseg4ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19454 /* vsuxseg4ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19469 /* vsuxseg4ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19469 /* vsuxseg4ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19483 /* vsuxseg5ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19483 /* vsuxseg5ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19498 /* vsuxseg5ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19498 /* vsuxseg5ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19513 /* vsuxseg5ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19513 /* vsuxseg5ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19528 /* vsuxseg5ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19528 /* vsuxseg5ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19542 /* vsuxseg6ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19542 /* vsuxseg6ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19557 /* vsuxseg6ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19557 /* vsuxseg6ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19572 /* vsuxseg6ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19572 /* vsuxseg6ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19587 /* vsuxseg6ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19587 /* vsuxseg6ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19601 /* vsuxseg7ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19601 /* vsuxseg7ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19616 /* vsuxseg7ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19616 /* vsuxseg7ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19631 /* vsuxseg7ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19631 /* vsuxseg7ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19646 /* vsuxseg7ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19646 /* vsuxseg7ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19660 /* vsuxseg8ei16.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19660 /* vsuxseg8ei16.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19675 /* vsuxseg8ei32.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19675 /* vsuxseg8ei32.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19690 /* vsuxseg8ei64.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19690 /* vsuxseg8ei64.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructionsI64_IsRV64 },
  { 19705 /* vsuxseg8ei8.v */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19705 /* vsuxseg8ei8.v */, 2 /* 1 */, MCK_ZeroOffsetMemOpOperand, AMFBS_HasVInstructions },
  { 19738 /* vwadd.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19747 /* vwadd.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19756 /* vwadd.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19765 /* vwadd.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19774 /* vwaddu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19784 /* vwaddu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19794 /* vwaddu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19804 /* vwaddu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19814 /* vwcvt.x.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19826 /* vwcvtu.x.x.v */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19839 /* vwmacc.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19849 /* vwmacc.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19859 /* vwmaccsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19871 /* vwmaccsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19883 /* vwmaccu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19894 /* vwmaccu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19905 /* vwmaccus.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19917 /* vwmul.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19926 /* vwmul.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19935 /* vwmulsu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19946 /* vwmulsu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19957 /* vwmulu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19967 /* vwmulu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19977 /* vwredsum.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 19989 /* vwredsumu.vs */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20002 /* vwsll.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 20011 /* vwsll.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 20020 /* vwsll.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasStdExtZvbb },
  { 20029 /* vwsub.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20038 /* vwsub.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20047 /* vwsub.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20056 /* vwsub.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20065 /* vwsubu.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20075 /* vwsubu.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20085 /* vwsubu.wv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20095 /* vwsubu.wx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20105 /* vxor.vi */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20113 /* vxor.vv */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20121 /* vxor.vx */, 8 /* 3 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20129 /* vzext.vf2 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20139 /* vzext.vf4 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
  { 20149 /* vzext.vf8 */, 4 /* 2 */, MCK_RVVMaskRegOpOperand, AMFBS_HasVInstructions },
};

ParseStatus RISCVAsmParser::
tryCustomParseOperand(OperandVector &Operands,
                      unsigned MCK) {

  switch(MCK) {
  case MCK_BareSymbol:
    return parseBareSymbol(Operands);
  case MCK_CSRSystemRegister:
    return parseCSRSystemRegister(Operands);
  case MCK_RegReg:
    return parseRegReg(Operands);
  case MCK_CallSymbol:
    return parseCallSymbol(Operands);
  case MCK_FRMArg:
    return parseFRMArg(Operands);
  case MCK_FRMArgLegacy:
    return parseFRMArg(Operands);
  case MCK_FenceArg:
    return parseFenceArg(Operands);
  case MCK_GPRAsFPR16:
    return parseGPRAsFPR(Operands);
  case MCK_GPRAsFPR32:
    return parseGPRAsFPR(Operands);
  case MCK_GPRF64AsFPR:
    return parseGPRAsFPR64(Operands);
  case MCK_GPRPairAsFPR:
    return parseGPRPairAsFPR64(Operands);
  case MCK_GPRPairRV32:
    return parseGPRPair<false>(Operands);
  case MCK_GPRPairRV64:
    return parseGPRPair<true>(Operands);
  case MCK_InsnCDirectiveOpcode:
    return parseInsnCDirectiveOpcode(Operands);
  case MCK_InsnDirectiveOpcode:
    return parseInsnDirectiveOpcode(Operands);
  case MCK_LoadFPImm:
    return parseFPImm(Operands);
  case MCK_NegStackAdj:
    return parseZcmpNegStackAdj(Operands);
  case MCK_PseudoJumpSymbol:
    return parsePseudoJumpSymbol(Operands);
  case MCK_RTZArg:
    return parseFRMArg(Operands);
  case MCK_Rlist:
    return parseReglist(Operands);
  case MCK_SImm21Lsb0JAL:
    return parseJALOffset(Operands);
  case MCK_StackAdj:
    return parseZcmpStackAdj(Operands);
  case MCK_TLSDESCCallSymbol:
    return parseOperandWithModifier(Operands);
  case MCK_TPRelAddSymbol:
    return parseOperandWithModifier(Operands);
  case MCK_RVVMaskRegOpOperand:
    return parseMaskReg(Operands);
  case MCK_ZeroOffsetMemOpOperand:
    return parseZeroOffsetMemOp(Operands);
  case MCK_VTypeI10:
    return parseVTypeI(Operands);
  case MCK_VTypeI11:
    return parseVTypeI(Operands);
  default:
    return ParseStatus::NoMatch;
  }
  return ParseStatus::NoMatch;
}

ParseStatus RISCVAsmParser::
MatchOperandParserImpl(OperandVector &Operands,
                       StringRef Mnemonic,
                       bool ParseForAllFeatures) {
  // Get the current feature set.
  const FeatureBitset &AvailableFeatures = getAvailableFeatures();

  // Get the next operand index.
  unsigned NextOpNum = Operands.size() - 1;
  // Search the table.
  auto MnemonicRange =
    std::equal_range(std::begin(OperandMatchTable), std::end(OperandMatchTable),
                     Mnemonic, LessOpcodeOperand());

  if (MnemonicRange.first == MnemonicRange.second)
    return ParseStatus::NoMatch;

  for (const OperandMatchEntry *it = MnemonicRange.first,
       *ie = MnemonicRange.second; it != ie; ++it) {
    // equal_range guarantees that instruction mnemonic matches.
    assert(Mnemonic == it->getMnemonic());

    // check if the available features match
    const FeatureBitset &RequiredFeatures = FeatureBitsets[it->RequiredFeaturesIdx];
    if (!ParseForAllFeatures && (AvailableFeatures & RequiredFeatures) != RequiredFeatures)
      continue;

    // check if the operand in question has a custom parser.
    if (!(it->OperandMask & (1 << NextOpNum)))
      continue;

    // call custom parse method to handle the operand
    ParseStatus Result = tryCustomParseOperand(Operands, it->Class);
    if (!Result.isNoMatch())
      return Result;
  }

  // Okay, we had no match.
  return ParseStatus::NoMatch;
}

#endif // GET_MATCHER_IMPLEMENTATION


#ifdef GET_MNEMONIC_SPELL_CHECKER
#undef GET_MNEMONIC_SPELL_CHECKER

static std::string RISCVMnemonicSpellCheck(StringRef S, const FeatureBitset &FBS, unsigned VariantID) {
  const unsigned MaxEditDist = 2;
  std::vector<StringRef> Candidates;
  StringRef Prev = "";

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  for (auto I = Start; I < End; I++) {
    // Ignore unsupported instructions.
    const FeatureBitset &RequiredFeatures = FeatureBitsets[I->RequiredFeaturesIdx];
    if ((FBS & RequiredFeatures) != RequiredFeatures)
      continue;

    StringRef T = I->getMnemonic();
    // Avoid recomputing the edit distance for the same string.
    if (T == Prev)
      continue;

    Prev = T;
    unsigned Dist = S.edit_distance(T, false, MaxEditDist);
    if (Dist <= MaxEditDist)
      Candidates.push_back(T);
  }

  if (Candidates.empty())
    return "";

  std::string Res = ", did you mean: ";
  unsigned i = 0;
  for (; i < Candidates.size() - 1; i++)
    Res += Candidates[i].str() + ", ";
  return Res + Candidates[i].str() + "?";
}

#endif // GET_MNEMONIC_SPELL_CHECKER


#ifdef GET_MNEMONIC_CHECKER
#undef GET_MNEMONIC_CHECKER

static bool RISCVCheckMnemonic(StringRef Mnemonic,
                                const FeatureBitset &AvailableFeatures,
                                unsigned VariantID) {
  // Process all MnemonicAliases to remap the mnemonic.
  applyMnemonicAliases(Mnemonic, AvailableFeatures, VariantID);

  // Find the appropriate table for this asm variant.
  const MatchEntry *Start, *End;
  switch (VariantID) {
  default: llvm_unreachable("invalid variant!");
  case 0: Start = std::begin(MatchTable0); End = std::end(MatchTable0); break;
  }

  // Search the table.
  auto MnemonicRange = std::equal_range(Start, End, Mnemonic, LessOpcode());

  if (MnemonicRange.first == MnemonicRange.second)
    return false;

  for (const MatchEntry *it = MnemonicRange.first, *ie = MnemonicRange.second;
       it != ie; ++it) {
    const FeatureBitset &RequiredFeatures =
      FeatureBitsets[it->RequiredFeaturesIdx];
    if ((AvailableFeatures & RequiredFeatures) == RequiredFeatures)
      return true;
  }
  return false;
}

#endif // GET_MNEMONIC_CHECKER

