/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the BPF target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 10;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(BPFInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(BPFInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static BPFInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static BPFInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s32,
  GILLT_s64,
};
const static size_t NumTypeObjects = 2;
const static LLT TypeObjects[] = {
  LLT::scalar(32),
  LLT::scalar(64),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_BPFIsLittleEndianBit = 7,
  Feature_BPFIsBigEndianBit = 8,
  Feature_BPFHasALU32Bit = 5,
  Feature_BPFNoALU32Bit = 2,
  Feature_BPFHasLdsxBit = 4,
  Feature_BPFHasMovsxBit = 1,
  Feature_BPFHasBswapBit = 6,
  Feature_BPFHasSdivSmodBit = 0,
  Feature_BPFNoMovsxBit = 9,
  Feature_BPFHasStoreImmBit = 3,
};

PredicateBitset BPFInstructionSelector::
computeAvailableModuleFeatures(const BPFSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->isLittleEndian())
    Features.set(Feature_BPFIsLittleEndianBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_BPFIsBigEndianBit);
  if (Subtarget->getHasAlu32())
    Features.set(Feature_BPFHasALU32Bit);
  if (!Subtarget->getHasAlu32())
    Features.set(Feature_BPFNoALU32Bit);
  if (Subtarget->hasLdsx())
    Features.set(Feature_BPFHasLdsxBit);
  if (Subtarget->hasMovsx())
    Features.set(Feature_BPFHasMovsxBit);
  if (Subtarget->hasBswap())
    Features.set(Feature_BPFHasBswapBit);
  if (Subtarget->hasSdivSmod())
    Features.set(Feature_BPFHasSdivSmodBit);
  if (!Subtarget->hasMovsx())
    Features.set(Feature_BPFNoMovsxBit);
  if (Subtarget->hasStoreImm())
    Features.set(Feature_BPFHasStoreImmBit);
  return Features;
}

void BPFInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const BPFSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset BPFInstructionSelector::
computeAvailableFunctionFeatures(const BPFSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_BPFHasBswap,
  GIFBS_BPFHasMovsx,
  GIFBS_BPFHasSdivSmod,
  GIFBS_BPFIsBigEndian,
  GIFBS_BPFIsLittleEndian,
  GIFBS_BPFNoMovsx,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_BPFHasBswapBit, },
  {Feature_BPFHasMovsxBit, },
  {Feature_BPFHasSdivSmodBit, },
  {Feature_BPFIsBigEndianBit, },
  {Feature_BPFIsLittleEndianBit, },
  {Feature_BPFNoMovsxBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

BPFInstructionSelector::ComplexMatcherMemFn
BPFInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool BPFInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool BPFInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool BPFInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool BPFInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool BPFInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("BPFInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
BPFInstructionSelector::CustomRendererFn
BPFInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool BPFInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool BPFInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("BPFInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *BPFInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(51), GIMT_Encode2(237), /*)*//*default:*//*Label 21*/ GIMT_Encode4(2407),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(754),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(820),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(934),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(1000),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(1072),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(1138),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(1210), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(1276),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(1402),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(1468), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 10*/ GIMT_Encode4(1534), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 11*/ GIMT_Encode4(1598),
    /*TargetOpcode::G_TRUNC*//*Label 12*/ GIMT_Encode4(1661),
    /*TargetOpcode::G_CONSTANT*//*Label 13*/ GIMT_Encode4(1703), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 14*/ GIMT_Encode4(1726), GIMT_Encode4(0),
    /*TargetOpcode::G_ZEXT*//*Label 15*/ GIMT_Encode4(1842),
    /*TargetOpcode::G_SHL*//*Label 16*/ GIMT_Encode4(1869),
    /*TargetOpcode::G_LSHR*//*Label 17*/ GIMT_Encode4(1935),
    /*TargetOpcode::G_ASHR*//*Label 18*/ GIMT_Encode4(2259), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 19*/ GIMT_Encode4(2325), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BSWAP*//*Label 20*/ GIMT_Encode4(2341),
    // Label 0: @754
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 24*/ GIMT_Encode4(819),
    /*GILLT_s32*//*Label 22*/ GIMT_Encode4(773),
    /*GILLT_s64*//*Label 23*/ GIMT_Encode4(796),
    // Label 22: @773
    GIM_Try, /*On fail goto*//*Label 25*/ GIMT_Encode4(795), // Rule ID 46 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (ADD_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::ADD_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 46,
      GIR_Done,
    // Label 25: @795
    GIM_Reject,
    // Label 23: @796
    GIM_Try, /*On fail goto*//*Label 26*/ GIMT_Encode4(818), // Rule ID 44 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (ADD_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::ADD_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 44,
      GIR_Done,
    // Label 26: @818
    GIM_Reject,
    // Label 24: @819
    GIM_Reject,
    // Label 1: @820
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 29*/ GIMT_Encode4(933),
    /*GILLT_s32*//*Label 27*/ GIMT_Encode4(839),
    /*GILLT_s64*//*Label 28*/ GIMT_Encode4(886),
    // Label 27: @839
    GIM_Try, /*On fail goto*//*Label 30*/ GIMT_Encode4(885),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 31*/ GIMT_Encode4(872), // Rule ID 97 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, i32:{ *:[i32] }:$src)  =>  (NEG_32:{ *:[i32] } i32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::NEG_32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 97,
        GIR_EraseRootFromParent_Done,
      // Label 31: @872
      GIM_Try, /*On fail goto*//*Label 32*/ GIMT_Encode4(884), // Rule ID 50 //
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SUB_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SUB_rr_32),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 50,
        GIR_Done,
      // Label 32: @884
      GIM_Reject,
    // Label 30: @885
    GIM_Reject,
    // Label 28: @886
    GIM_Try, /*On fail goto*//*Label 33*/ GIMT_Encode4(932),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 34*/ GIMT_Encode4(919), // Rule ID 96 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, i64:{ *:[i64] }:$src)  =>  (NEG_64:{ *:[i64] } i64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::NEG_64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 96,
        GIR_EraseRootFromParent_Done,
      // Label 34: @919
      GIM_Try, /*On fail goto*//*Label 35*/ GIMT_Encode4(931), // Rule ID 48 //
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SUB_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SUB_rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 48,
        GIR_Done,
      // Label 35: @931
      GIM_Reject,
    // Label 33: @932
    GIM_Reject,
    // Label 29: @933
    GIM_Reject,
    // Label 2: @934
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 38*/ GIMT_Encode4(999),
    /*GILLT_s32*//*Label 36*/ GIMT_Encode4(953),
    /*GILLT_s64*//*Label 37*/ GIMT_Encode4(976),
    // Label 36: @953
    GIM_Try, /*On fail goto*//*Label 39*/ GIMT_Encode4(975), // Rule ID 78 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (mul:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (MUL_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MUL_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 78,
      GIR_Done,
    // Label 39: @975
    GIM_Reject,
    // Label 37: @976
    GIM_Try, /*On fail goto*//*Label 40*/ GIMT_Encode4(998), // Rule ID 76 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (mul:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (MUL_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MUL_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 76,
      GIR_Done,
    // Label 40: @998
    GIM_Reject,
    // Label 38: @999
    GIM_Reject,
    // Label 3: @1000
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 43*/ GIMT_Encode4(1071),
    /*GILLT_s32*//*Label 41*/ GIMT_Encode4(1019),
    /*GILLT_s64*//*Label 42*/ GIMT_Encode4(1045),
    // Label 41: @1019
    GIM_Try, /*On fail goto*//*Label 44*/ GIMT_Encode4(1044), // Rule ID 90 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasSdivSmod),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (sdiv:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SDIV_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SDIV_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 90,
      GIR_Done,
    // Label 44: @1044
    GIM_Reject,
    // Label 42: @1045
    GIM_Try, /*On fail goto*//*Label 45*/ GIMT_Encode4(1070), // Rule ID 88 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasSdivSmod),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (sdiv:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SDIV_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SDIV_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 88,
      GIR_Done,
    // Label 45: @1070
    GIM_Reject,
    // Label 43: @1071
    GIM_Reject,
    // Label 4: @1072
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 48*/ GIMT_Encode4(1137),
    /*GILLT_s32*//*Label 46*/ GIMT_Encode4(1091),
    /*GILLT_s64*//*Label 47*/ GIMT_Encode4(1114),
    // Label 46: @1091
    GIM_Try, /*On fail goto*//*Label 49*/ GIMT_Encode4(1113), // Rule ID 82 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (udiv:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (DIV_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::DIV_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 82,
      GIR_Done,
    // Label 49: @1113
    GIM_Reject,
    // Label 47: @1114
    GIM_Try, /*On fail goto*//*Label 50*/ GIMT_Encode4(1136), // Rule ID 80 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (udiv:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (DIV_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::DIV_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 80,
      GIR_Done,
    // Label 50: @1136
    GIM_Reject,
    // Label 48: @1137
    GIM_Reject,
    // Label 5: @1138
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 53*/ GIMT_Encode4(1209),
    /*GILLT_s32*//*Label 51*/ GIMT_Encode4(1157),
    /*GILLT_s64*//*Label 52*/ GIMT_Encode4(1183),
    // Label 51: @1157
    GIM_Try, /*On fail goto*//*Label 54*/ GIMT_Encode4(1182), // Rule ID 94 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasSdivSmod),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (srem:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SMOD_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SMOD_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 94,
      GIR_Done,
    // Label 54: @1182
    GIM_Reject,
    // Label 52: @1183
    GIM_Try, /*On fail goto*//*Label 55*/ GIMT_Encode4(1208), // Rule ID 92 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasSdivSmod),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (srem:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SMOD_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SMOD_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 92,
      GIR_Done,
    // Label 55: @1208
    GIM_Reject,
    // Label 53: @1209
    GIM_Reject,
    // Label 6: @1210
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 58*/ GIMT_Encode4(1275),
    /*GILLT_s32*//*Label 56*/ GIMT_Encode4(1229),
    /*GILLT_s64*//*Label 57*/ GIMT_Encode4(1252),
    // Label 56: @1229
    GIM_Try, /*On fail goto*//*Label 59*/ GIMT_Encode4(1251), // Rule ID 86 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (urem:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (MOD_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MOD_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 86,
      GIR_Done,
    // Label 59: @1251
    GIM_Reject,
    // Label 57: @1252
    GIM_Try, /*On fail goto*//*Label 60*/ GIMT_Encode4(1274), // Rule ID 84 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (urem:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (MOD_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MOD_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 84,
      GIR_Done,
    // Label 60: @1274
    GIM_Reject,
    // Label 58: @1275
    GIM_Reject,
    // Label 7: @1276
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 63*/ GIMT_Encode4(1401),
    /*GILLT_s32*//*Label 61*/ GIMT_Encode4(1295),
    /*GILLT_s64*//*Label 62*/ GIMT_Encode4(1318),
    // Label 61: @1295
    GIM_Try, /*On fail goto*//*Label 64*/ GIMT_Encode4(1317), // Rule ID 58 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (and:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (AND_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::AND_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 58,
      GIR_Done,
    // Label 64: @1317
    GIM_Reject,
    // Label 62: @1318
    GIM_Try, /*On fail goto*//*Label 65*/ GIMT_Encode4(1400),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 66*/ GIMT_Encode4(1387), // Rule ID 176 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294967295),
        // (and:{ *:[i64] } GPR:{ *:[i64] }:$src, 4294967295:{ *:[i64] })  =>  (SRL_ri:{ *:[i64] } (SLL_ri:{ *:[i64] } GPR:{ *:[i64] }:$src, 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(BPF::SLL_ri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::SRL_ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 176,
        GIR_EraseRootFromParent_Done,
      // Label 66: @1387
      GIM_Try, /*On fail goto*//*Label 67*/ GIMT_Encode4(1399), // Rule ID 56 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (AND_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::AND_rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 56,
        GIR_Done,
      // Label 67: @1399
      GIM_Reject,
    // Label 65: @1400
    GIM_Reject,
    // Label 63: @1401
    GIM_Reject,
    // Label 8: @1402
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 70*/ GIMT_Encode4(1467),
    /*GILLT_s32*//*Label 68*/ GIMT_Encode4(1421),
    /*GILLT_s64*//*Label 69*/ GIMT_Encode4(1444),
    // Label 68: @1421
    GIM_Try, /*On fail goto*//*Label 71*/ GIMT_Encode4(1443), // Rule ID 54 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (or:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (OR_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::OR_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 54,
      GIR_Done,
    // Label 71: @1443
    GIM_Reject,
    // Label 69: @1444
    GIM_Try, /*On fail goto*//*Label 72*/ GIMT_Encode4(1466), // Rule ID 52 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (or:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (OR_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::OR_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 52,
      GIR_Done,
    // Label 72: @1466
    GIM_Reject,
    // Label 70: @1467
    GIM_Reject,
    // Label 9: @1468
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 75*/ GIMT_Encode4(1533),
    /*GILLT_s32*//*Label 73*/ GIMT_Encode4(1487),
    /*GILLT_s64*//*Label 74*/ GIMT_Encode4(1510),
    // Label 73: @1487
    GIM_Try, /*On fail goto*//*Label 76*/ GIMT_Encode4(1509), // Rule ID 70 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (xor:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (XOR_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::XOR_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 70,
      GIR_Done,
    // Label 76: @1509
    GIM_Reject,
    // Label 74: @1510
    GIM_Try, /*On fail goto*//*Label 77*/ GIMT_Encode4(1532), // Rule ID 68 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (xor:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (XOR_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::XOR_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 68,
      GIR_Done,
    // Label 77: @1532
    GIM_Reject,
    // Label 75: @1533
    GIM_Reject,
    // Label 10: @1534
    GIM_Try, /*On fail goto*//*Label 78*/ GIMT_Encode4(1597), // Rule ID 107 //
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::bpf_pseudo),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      // MIs[1] Operand 1
      // No operand predicates
      GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/3, // MIs[2]
      GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
      // MIs[2] Operand 1
      // No operand predicates
      GIM_CheckIsSafeToFold, /*NumInsns*/2,
      // (intrinsic_w_chain:{ *:[i64] } 3628:{ *:[iPTR] }, (imm:{ *:[i64] }):$pseudo, (imm:{ *:[i64] }):$imm)  =>  (LD_pseudo:{ *:[i64] } (imm:{ *:[i64] }):$pseudo, (imm:{ *:[i64] }):$imm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::LD_pseudo),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // pseudo
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 107,
      GIR_EraseRootFromParent_Done,
    // Label 78: @1597
    GIM_Reject,
    // Label 11: @1598
    GIM_Try, /*On fail goto*//*Label 79*/ GIMT_Encode4(1660), // Rule ID 190 //
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (anyext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GPR32:{ *:[i32] }:$src, sub_32:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(BPF::GPRRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(BPF::GPRRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(BPF::GPR32RegClassID),
      // GIR_Coverage, 190,
      GIR_EraseRootFromParent_Done,
    // Label 79: @1660
    GIM_Reject,
    // Label 12: @1661
    GIM_Try, /*On fail goto*//*Label 80*/ GIMT_Encode4(1702), // Rule ID 189 //
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (trunc:{ *:[i32] } GPR:{ *:[i64] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i32] } GPR:{ *:[i64] }:$src, sub_32:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(BPF::GPR32RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(BPF::GPRRegClassID),
      // GIR_Coverage, 189,
      GIR_EraseRootFromParent_Done,
    // Label 80: @1702
    GIM_Reject,
    // Label 13: @1703
    GIM_Try, /*On fail goto*//*Label 81*/ GIMT_Encode4(1725), // Rule ID 98 //
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // MIs[0] Operand 1
      // No operand predicates
      // (imm:{ *:[i64] }):$imm  =>  (LD_imm64:{ *:[i64] } (imm:{ *:[i64] }):$imm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::LD_imm64),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/0, // imm
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 98,
      GIR_EraseRootFromParent_Done,
    // Label 81: @1725
    GIM_Reject,
    // Label 14: @1726
    GIM_Try, /*On fail goto*//*Label 82*/ GIMT_Encode4(1841),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 83*/ GIMT_Encode4(1804), // Rule ID 186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFNoMovsx),
        // (sext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (SRA_ri:{ *:[i64] } (SLL_ri:{ *:[i64] } (MOV_32_64:{ *:[i64] } GPR32:{ *:[i32] }:$src), 32:{ *:[i64] }), 32:{ *:[i64] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(BPF::MOV_32_64),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(BPF::SLL_ri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/32,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::SRA_ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/32,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 186,
        GIR_EraseRootFromParent_Done,
      // Label 83: @1804
      GIM_Try, /*On fail goto*//*Label 84*/ GIMT_Encode4(1840), // Rule ID 187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasMovsx),
        // (sext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (MOVSX_rr_32:{ *:[i64] } (MOV_32_64:{ *:[i64] } GPR32:{ *:[i32] }:$src))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(BPF::MOV_32_64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::MOVSX_rr_32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 187,
        GIR_EraseRootFromParent_Done,
      // Label 84: @1840
      GIM_Reject,
    // Label 82: @1841
    GIM_Reject,
    // Label 15: @1842
    GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(1868), // Rule ID 188 //
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (zext:{ *:[i64] } GPR32:{ *:[i32] }:$src)  =>  (MOV_32_64:{ *:[i64] } GPR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::MOV_32_64),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 188,
      GIR_Done,
    // Label 85: @1868
    GIM_Reject,
    // Label 16: @1869
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 88*/ GIMT_Encode4(1934),
    /*GILLT_s32*//*Label 86*/ GIMT_Encode4(1888),
    /*GILLT_s64*//*Label 87*/ GIMT_Encode4(1911),
    // Label 86: @1888
    GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1910), // Rule ID 62 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (shl:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SLL_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SLL_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 62,
      GIR_Done,
    // Label 89: @1910
    GIM_Reject,
    // Label 87: @1911
    GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1933), // Rule ID 60 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (shl:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SLL_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SLL_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 60,
      GIR_Done,
    // Label 90: @1933
    GIM_Reject,
    // Label 88: @1934
    GIM_Reject,
    // Label 17: @1935
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 93*/ GIMT_Encode4(2258),
    /*GILLT_s32*//*Label 91*/ GIMT_Encode4(1954),
    /*GILLT_s64*//*Label 92*/ GIMT_Encode4(1977),
    // Label 91: @1954
    GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1976), // Rule ID 66 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (srl:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SRL_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SRL_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 66,
      GIR_Done,
    // Label 94: @1976
    GIM_Reject,
    // Label 92: @1977
    GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(2257),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(2034), // Rule ID 148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasBswap),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 48,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 48:{ *:[i64] })  =>  (BSWAP16:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::BSWAP16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 148,
        GIR_EraseRootFromParent_Done,
      // Label 96: @2034
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(2076), // Rule ID 149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasBswap),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 32:{ *:[i64] })  =>  (BSWAP32:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::BSWAP32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 149,
        GIR_EraseRootFromParent_Done,
      // Label 97: @2076
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(2118), // Rule ID 151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsLittleEndian),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 48,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 48:{ *:[i64] })  =>  (BE16:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::BE16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 151,
        GIR_EraseRootFromParent_Done,
      // Label 98: @2118
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(2160), // Rule ID 152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsLittleEndian),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 32:{ *:[i64] })  =>  (BE32:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::BE32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 152,
        GIR_EraseRootFromParent_Done,
      // Label 99: @2160
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(2202), // Rule ID 154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsBigEndian),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 48,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 48:{ *:[i64] })  =>  (LE16:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::LE16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 154,
        GIR_EraseRootFromParent_Done,
      // Label 100: @2202
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(2244), // Rule ID 155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsBigEndian),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BSWAP),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (srl:{ *:[i64] } (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src), 32:{ *:[i64] })  =>  (LE32:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(BPF::LE32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 155,
        GIR_EraseRootFromParent_Done,
      // Label 101: @2244
      GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(2256), // Rule ID 64 //
        // (srl:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SRL_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SRL_rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 64,
        GIR_Done,
      // Label 102: @2256
      GIM_Reject,
    // Label 95: @2257
    GIM_Reject,
    // Label 93: @2258
    GIM_Reject,
    // Label 18: @2259
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(2), /*)*//*default:*//*Label 105*/ GIMT_Encode4(2324),
    /*GILLT_s32*//*Label 103*/ GIMT_Encode4(2278),
    /*GILLT_s64*//*Label 104*/ GIMT_Encode4(2301),
    // Label 103: @2278
    GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(2300), // Rule ID 74 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPR32RegClassID),
      // (sra:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)  =>  (SRA_rr_32:{ *:[i32] } i32:{ *:[i32] }:$src2, i32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SRA_rr_32),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 74,
      GIR_Done,
    // Label 106: @2300
    GIM_Reject,
    // Label 104: @2301
    GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(2323), // Rule ID 72 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      // (sra:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)  =>  (SRA_rr:{ *:[i64] } i64:{ *:[i64] }:$src2, i64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::SRA_rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 72,
      GIR_Done,
    // Label 107: @2323
    GIM_Reject,
    // Label 105: @2324
    GIM_Reject,
    // Label 19: @2325
    GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(2340), // Rule ID 123 //
      // MIs[0] BrDst
      GIM_CheckIsMBB, /*MI*/0, /*Op*/0,
      // (br (bb:{ *:[Other] }):$BrDst)  =>  (JMP (bb:{ *:[Other] }):$BrDst)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::JMP),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 123,
      GIR_Done,
    // Label 108: @2340
    GIM_Reject,
    // Label 20: @2341
    GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(2406),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(BPF::GPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(2375), // Rule ID 150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFHasBswap),
        // (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src)  =>  (BSWAP64:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::BSWAP64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 150,
        GIR_Done,
      // Label 110: @2375
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(2390), // Rule ID 153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsLittleEndian),
        // (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src)  =>  (BE64:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::BE64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 153,
        GIR_Done,
      // Label 111: @2390
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(2405), // Rule ID 156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_BPFIsBigEndian),
        // (bswap:{ *:[i64] } GPR:{ *:[i64] }:$src)  =>  (LE64:{ *:[i64] } GPR:{ *:[i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(BPF::LE64),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 156,
        GIR_Done,
      // Label 112: @2405
      GIM_Reject,
    // Label 109: @2406
    GIM_Reject,
    // Label 21: @2407
    GIM_Reject,
    }; // Size: 2408 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GLOBALISEL_IMPL

#ifdef GET_GLOBALISEL_PREDICATES_DECL
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const BPFSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const BPFSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GLOBALISEL_PREDICATES_DECL
#ifdef GET_GLOBALISEL_PREDICATES_INIT
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GLOBALISEL_PREDICATES_INIT
