/**
 * @file    LangSwedishModel.cpp
 * @brief   LangSwedishModel
 * @license GPL 2.0/LGPL 2.1
 */

#include "nsSBCharSetProber.h"

static const unsigned char swedish_WINDOWS_1252CharToOrderMap[] = 
{
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255, 31, 44, 47, 26, 33, 36, 38, 27, 40, 30, 42, 43, 29, 34, 35,
 45, 70, 46, 28, 37, 48, 32, 53, 61, 60, 57,255,255,255,255,255,
255,  1, 23, 21,  7,  2, 18, 11, 14,  9, 24, 13,  8, 12,  3, 10,
 22, 52,  5,  6,  4, 19, 16, 55, 41, 25, 54,255,255,255,255,255,
180,179,178,177, 66,176, 71,175,174,173,172,171,170,169,168,167,
166,165, 56, 59,164,163,162,161,160,159,158,157,156,155,154,153,
152,151,150, 69,149,148,147,146,145,144,143,142,141,140,139,138,
 72, 85, 77, 62,137,136,135,134,133,132,131, 39, 73, 68, 76,130,
129,128,127,126, 49, 50, 84,125,124, 81,123,122,121,120,119,118,
117,116,115,114,113,112, 58,111,110,109,108,107, 83,106,105,104,
 64,103, 80,102, 15, 17, 65, 74, 67, 51, 79, 78,101,100, 99, 98,
 97, 96, 95, 94, 82, 93, 20, 92, 91, 90, 89, 75, 63, 88, 87, 86,
};

static const PRUint8 swedishLangModel[] = 
{
2,2,3,3,3,3,3,3,2,2,3,3,3,2,1,3,2,3,3,0,3,3,3,2,2,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,2,1,2,0,0,2,0,0,0,0,0,
3,3,3,3,3,3,3,3,2,2,3,3,3,3,2,3,2,3,3,1,3,3,3,3,2,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,3,0,0,0,0,0,0,0,0,0,0,2,0,2,2,2,0,0,1,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,1,0,0,0,0,0,0,0,0,0,2,1,0,2,0,2,0,0,2,0,0,0,0,0,
3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,1,0,0,2,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,2,1,0,0,0,0,0,0,1,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,2,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,1,1,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,2,3,3,3,3,3,1,3,0,3,3,2,3,3,3,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,0,0,
3,2,3,3,3,3,3,3,2,2,3,3,3,3,2,3,2,3,3,2,3,3,3,3,2,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,2,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,2,0,0,
3,3,3,3,3,3,2,3,3,3,3,2,2,3,3,3,3,2,3,3,0,2,2,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,2,2,0,2,3,3,1,2,0,1,3,3,3,0,3,3,0,0,0,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,
1,2,3,3,3,3,3,3,0,1,3,3,3,2,2,3,0,3,0,0,3,3,2,2,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,2,2,2,2,3,2,3,2,3,2,1,2,3,2,2,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,3,3,3,3,3,3,3,0,1,3,2,3,2,2,3,2,2,0,1,0,2,2,2,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,3,3,3,2,3,3,3,2,2,2,2,3,3,3,3,3,3,0,2,2,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,0,
2,2,3,3,3,3,3,3,2,2,3,3,3,2,0,3,2,3,2,0,3,3,3,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,3,3,3,3,3,3,2,1,3,3,3,2,0,3,0,3,1,1,2,3,2,3,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
2,3,0,2,2,2,0,2,3,2,0,0,3,3,0,0,0,0,2,0,2,0,0,0,2,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,2,3,3,3,2,3,2,3,3,2,3,3,3,2,0,3,2,2,2,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,3,2,2,3,3,3,0,0,0,1,3,0,3,0,3,3,1,0,3,3,3,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
3,3,2,2,0,2,3,3,1,3,0,1,3,0,3,0,2,2,3,3,0,0,1,0,2,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,3,3,3,3,3,3,0,2,3,3,3,2,0,2,2,3,1,0,3,3,2,2,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,0,0,2,0,0,0,2,2,0,0,0,0,3,1,3,0,3,2,0,0,0,2,2,0,0,0,0,1,2,0,
2,0,1,0,0,0,0,1,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,0,0,0,0,0,0,2,3,0,2,0,0,3,3,2,0,3,3,0,0,0,2,2,0,0,0,0,0,2,0,
2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,3,0,1,0,2,3,3,0,2,3,0,2,3,3,0,2,2,3,2,0,2,2,0,0,2,0,2,2,0,
2,0,2,1,2,0,0,2,0,2,1,1,2,0,0,0,0,1,2,0,0,0,2,0,0,2,0,0,0,0,1,0,
3,3,0,0,0,0,0,0,3,3,0,0,0,0,3,0,3,0,2,2,0,0,0,2,2,0,0,0,0,0,2,0,
1,0,2,0,2,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,0,0,0,0,0,3,0,0,0,0,2,0,0,2,3,2,0,0,0,0,0,0,0,0,0,0,0,0,
1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
0,1,3,2,2,3,2,3,0,0,1,2,2,2,0,2,0,2,2,0,2,2,2,0,0,2,0,2,1,0,0,1,
0,2,0,1,2,2,0,0,2,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,0,0,2,0,0,0,3,2,0,0,0,0,3,0,2,0,1,1,0,0,0,0,0,0,0,0,0,0,2,0,
2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,3,3,3,2,2,3,1,0,2,2,2,2,0,2,0,2,2,0,2,1,0,2,2,2,1,1,2,0,0,0,
0,2,0,0,2,1,0,0,2,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,
2,3,0,0,0,0,0,0,3,3,0,0,0,0,3,0,3,0,3,2,0,0,0,0,2,2,0,2,0,0,2,0,
2,2,2,0,1,2,0,2,0,1,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,1,2,1,2,2,2,2,0,2,0,3,2,0,0,2,0,2,2,0,3,2,2,1,0,1,0,0,2,0,1,0,
0,2,0,1,2,0,0,0,2,1,1,0,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,3,0,0,2,3,3,0,0,0,0,2,0,2,0,2,3,0,0,0,2,2,0,0,0,0,2,1,0,
2,0,2,1,0,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
3,2,0,0,3,1,0,0,3,3,0,0,0,2,2,2,2,0,2,2,0,1,0,2,3,0,0,1,1,2,2,0,
2,2,2,0,2,0,0,2,0,0,2,0,0,2,0,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,1,0,3,0,0,2,2,2,0,0,0,0,2,0,2,0,3,2,0,0,0,1,0,0,0,1,0,0,2,0,
2,0,2,0,0,0,0,0,0,0,1,0,0,2,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,0,2,1,2,2,2,1,1,2,2,2,2,0,2,0,2,1,0,0,2,2,1,0,2,2,2,2,2,2,2,
2,2,2,2,2,2,0,2,0,2,2,2,2,1,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,3,2,1,2,2,2,0,0,1,2,0,0,0,1,0,2,0,0,2,0,2,0,0,1,0,2,2,0,0,2,
1,2,2,0,2,2,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
3,3,2,3,0,2,1,2,3,2,0,0,2,2,0,0,0,2,1,0,1,2,2,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,2,0,2,0,0,3,2,3,0,0,0,0,2,2,1,0,2,2,0,0,0,1,2,0,1,0,0,0,2,0,
2,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,0,0,0,0,3,2,0,0,0,0,2,0,2,0,3,2,0,0,0,2,2,0,0,2,0,0,2,0,
2,2,1,1,0,0,0,2,0,0,2,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
3,3,0,0,3,0,1,3,2,2,0,0,0,0,2,0,2,0,2,2,0,0,0,2,2,0,0,0,0,0,0,0,
2,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,0,1,2,0,0,2,2,2,0,0,0,1,1,0,3,1,2,0,0,0,0,0,0,0,0,0,0,0,2,0,
1,0,2,0,0,0,0,2,0,0,0,0,2,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,0,0,0,0,0,0,2,2,0,0,0,2,2,0,2,0,2,2,0,0,0,0,2,2,0,2,1,0,2,0,
2,2,2,0,2,2,0,2,0,1,2,1,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
3,2,0,0,2,0,0,2,2,2,0,0,0,3,0,0,0,0,0,0,0,0,0,0,1,0,2,0,0,0,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,3,3,2,2,1,3,0,0,1,2,0,0,0,0,0,0,0,0,0,2,0,2,0,1,0,2,0,0,0,0,
0,2,0,1,2,2,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,2,3,0,2,2,0,0,1,1,0,2,0,2,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
0,1,0,0,2,1,0,0,0,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,2,2,2,0,1,0,0,0,0,2,2,0,2,0,0,0,0,0,0,0,2,0,0,0,1,0,0,0,0,
0,2,0,0,2,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
1,2,2,1,2,2,0,0,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,0,0,0,1,0,0,2,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
2,2,2,0,0,1,0,1,2,1,0,0,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,2,2,0,0,
0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,2,0,2,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,2,2,2,0,0,0,2,0,0,0,0,2,0,2,0,0,0,2,0,0,0,1,0,0,0,0,0,1,
0,0,0,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,2,2,0,0,2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,
0,0,0,0,0,0,0,2,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

const SequenceModel WINDOWS_1252swedishModel = 
{
  swedish_WINDOWS_1252CharToOrderMap,
  swedishLangModel,
  (float)0.989923,
  PR_TRUE,
  "WINDOWS-1252",
  "swedish"
};
