#ifndef INCLUDED_OFFICECFG_OFFICE_CALC_HXX
#define INCLUDED_OFFICECFG_OFFICE_CALC_HXX

#include "sal/config.h"

#include <optional>
#include "com/sun/star/uno/Sequence.hxx"
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "comphelper/configuration.hxx"

namespace officecfg { namespace Office { namespace Calc {

struct UnitConversion: public comphelper::ConfigurationSet< UnitConversion> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/UnitConversion"_ustr); return PATH; }
private:
    UnitConversion(); // not defined
    ~UnitConversion(); // not defined
};

struct Content: public comphelper::ConfigurationGroup< Content> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content"_ustr); return PATH; }

struct Display: public comphelper::ConfigurationGroup< Display> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display"_ustr); return PATH; }

struct Formula: public comphelper::ConfigurationProperty<Formula, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/Formula"_ustr); return PATH; }
private:
    Formula(); // not defined
    ~Formula(); // not defined
};

struct ZeroValue: public comphelper::ConfigurationProperty<ZeroValue, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/ZeroValue"_ustr); return PATH; }
private:
    ZeroValue(); // not defined
    ~ZeroValue(); // not defined
};

struct NoteTag: public comphelper::ConfigurationProperty<NoteTag, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/NoteTag"_ustr); return PATH; }
private:
    NoteTag(); // not defined
    ~NoteTag(); // not defined
};

struct NoteIndicator: public comphelper::ConfigurationProperty<NoteIndicator, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/NoteIndicator"_ustr); return PATH; }
private:
    NoteIndicator(); // not defined
    ~NoteIndicator(); // not defined
};

struct NoteAuthor: public comphelper::ConfigurationProperty<NoteAuthor, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/NoteAuthor"_ustr); return PATH; }
private:
    NoteAuthor(); // not defined
    ~NoteAuthor(); // not defined
};

struct FormulaMark: public comphelper::ConfigurationProperty<FormulaMark, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/FormulaMark"_ustr); return PATH; }
private:
    FormulaMark(); // not defined
    ~FormulaMark(); // not defined
};

struct ValueHighlighting: public comphelper::ConfigurationProperty<ValueHighlighting, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/ValueHighlighting"_ustr); return PATH; }
private:
    ValueHighlighting(); // not defined
    ~ValueHighlighting(); // not defined
};

struct ColumnRowHighlighting: public comphelper::ConfigurationProperty<ColumnRowHighlighting, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/ColumnRowHighlighting"_ustr); return PATH; }
private:
    ColumnRowHighlighting(); // not defined
    ~ColumnRowHighlighting(); // not defined
};

struct EditCellBackgroundHighlighting: public comphelper::ConfigurationProperty<EditCellBackgroundHighlighting, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/EditCellBackgroundHighlighting"_ustr); return PATH; }
private:
    EditCellBackgroundHighlighting(); // not defined
    ~EditCellBackgroundHighlighting(); // not defined
};

struct Anchor: public comphelper::ConfigurationProperty<Anchor, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/Anchor"_ustr); return PATH; }
private:
    Anchor(); // not defined
    ~Anchor(); // not defined
};

struct ObjectGraphic: public comphelper::ConfigurationProperty<ObjectGraphic, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/ObjectGraphic"_ustr); return PATH; }
private:
    ObjectGraphic(); // not defined
    ~ObjectGraphic(); // not defined
};

struct Chart: public comphelper::ConfigurationProperty<Chart, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/Chart"_ustr); return PATH; }
private:
    Chart(); // not defined
    ~Chart(); // not defined
};

struct DrawingObject: public comphelper::ConfigurationProperty<DrawingObject, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Display/DrawingObject"_ustr); return PATH; }
private:
    DrawingObject(); // not defined
    ~DrawingObject(); // not defined
};

private:
    Display(); // not defined
    ~Display(); // not defined
};

struct Update: public comphelper::ConfigurationGroup< Update> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Update"_ustr); return PATH; }

struct Link: public comphelper::ConfigurationProperty<Link, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Content/Update/Link"_ustr); return PATH; }
private:
    Link(); // not defined
    ~Link(); // not defined
};

private:
    Update(); // not defined
    ~Update(); // not defined
};

private:
    Content(); // not defined
    ~Content(); // not defined
};

struct Layout: public comphelper::ConfigurationGroup< Layout> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout"_ustr); return PATH; }

struct Line: public comphelper::ConfigurationGroup< Line> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Line"_ustr); return PATH; }

struct GridLine: public comphelper::ConfigurationProperty<GridLine, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Line/GridLine"_ustr); return PATH; }
private:
    GridLine(); // not defined
    ~GridLine(); // not defined
};

struct GridOnColoredCells: public comphelper::ConfigurationProperty<GridOnColoredCells, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Line/GridOnColoredCells"_ustr); return PATH; }
private:
    GridOnColoredCells(); // not defined
    ~GridOnColoredCells(); // not defined
};

struct GridLineColor: public comphelper::ConfigurationProperty<GridLineColor, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Line/GridLineColor"_ustr); return PATH; }
private:
    GridLineColor(); // not defined
    ~GridLineColor(); // not defined
};

struct PageBreak: public comphelper::ConfigurationProperty<PageBreak, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Line/PageBreak"_ustr); return PATH; }
private:
    PageBreak(); // not defined
    ~PageBreak(); // not defined
};

struct Guide: public comphelper::ConfigurationProperty<Guide, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Line/Guide"_ustr); return PATH; }
private:
    Guide(); // not defined
    ~Guide(); // not defined
};

private:
    Line(); // not defined
    ~Line(); // not defined
};

struct Window: public comphelper::ConfigurationGroup< Window> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Window"_ustr); return PATH; }

struct ColumnRowHeader: public comphelper::ConfigurationProperty<ColumnRowHeader, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Window/ColumnRowHeader"_ustr); return PATH; }
private:
    ColumnRowHeader(); // not defined
    ~ColumnRowHeader(); // not defined
};

struct HorizontalScroll: public comphelper::ConfigurationProperty<HorizontalScroll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Window/HorizontalScroll"_ustr); return PATH; }
private:
    HorizontalScroll(); // not defined
    ~HorizontalScroll(); // not defined
};

struct VerticalScroll: public comphelper::ConfigurationProperty<VerticalScroll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Window/VerticalScroll"_ustr); return PATH; }
private:
    VerticalScroll(); // not defined
    ~VerticalScroll(); // not defined
};

struct SheetTab: public comphelper::ConfigurationProperty<SheetTab, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Window/SheetTab"_ustr); return PATH; }
private:
    SheetTab(); // not defined
    ~SheetTab(); // not defined
};

struct OutlineSymbol: public comphelper::ConfigurationProperty<OutlineSymbol, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Window/OutlineSymbol"_ustr); return PATH; }
private:
    OutlineSymbol(); // not defined
    ~OutlineSymbol(); // not defined
};

struct SearchSummary: public comphelper::ConfigurationProperty<SearchSummary, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Window/SearchSummary"_ustr); return PATH; }
private:
    SearchSummary(); // not defined
    ~SearchSummary(); // not defined
};

struct ThemedCursor: public comphelper::ConfigurationProperty<ThemedCursor, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Window/ThemedCursor"_ustr); return PATH; }
private:
    ThemedCursor(); // not defined
    ~ThemedCursor(); // not defined
};

private:
    Window(); // not defined
    ~Window(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other"_ustr); return PATH; }

struct StatusbarMultiFunction: public comphelper::ConfigurationProperty<StatusbarMultiFunction, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/StatusbarMultiFunction"_ustr); return PATH; }
private:
    StatusbarMultiFunction(); // not defined
    ~StatusbarMultiFunction(); // not defined
};

struct StatusbarFunction: public comphelper::ConfigurationProperty<StatusbarFunction, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/StatusbarFunction"_ustr); return PATH; }
private:
    StatusbarFunction(); // not defined
    ~StatusbarFunction(); // not defined
};

struct TabbarInlineWithScrollbar: public comphelper::ConfigurationProperty<TabbarInlineWithScrollbar, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/TabbarInlineWithScrollbar"_ustr); return PATH; }
private:
    TabbarInlineWithScrollbar(); // not defined
    ~TabbarInlineWithScrollbar(); // not defined
};

struct TabStop: public comphelper::ConfigurationGroup< TabStop> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/TabStop"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/TabStop/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/TabStop/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    TabStop(); // not defined
    ~TabStop(); // not defined
};

struct MeasureUnit: public comphelper::ConfigurationGroup< MeasureUnit> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/MeasureUnit"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/MeasureUnit/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Other/MeasureUnit/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    MeasureUnit(); // not defined
    ~MeasureUnit(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

struct Zoom: public comphelper::ConfigurationGroup< Zoom> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Zoom"_ustr); return PATH; }

struct Type: public comphelper::ConfigurationProperty<Type, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Zoom/Type"_ustr); return PATH; }
private:
    Type(); // not defined
    ~Type(); // not defined
};

struct Value: public comphelper::ConfigurationProperty<Value, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Zoom/Value"_ustr); return PATH; }
private:
    Value(); // not defined
    ~Value(); // not defined
};

struct Synchronize: public comphelper::ConfigurationProperty<Synchronize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Layout/Zoom/Synchronize"_ustr); return PATH; }
private:
    Synchronize(); // not defined
    ~Synchronize(); // not defined
};

private:
    Zoom(); // not defined
    ~Zoom(); // not defined
};

private:
    Layout(); // not defined
    ~Layout(); // not defined
};

struct Input: public comphelper::ConfigurationGroup< Input> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input"_ustr); return PATH; }

struct MoveSelection: public comphelper::ConfigurationProperty<MoveSelection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/MoveSelection"_ustr); return PATH; }
private:
    MoveSelection(); // not defined
    ~MoveSelection(); // not defined
};

struct MoveSelectionDirection: public comphelper::ConfigurationProperty<MoveSelectionDirection, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/MoveSelectionDirection"_ustr); return PATH; }
private:
    MoveSelectionDirection(); // not defined
    ~MoveSelectionDirection(); // not defined
};

struct SwitchToEditMode: public comphelper::ConfigurationProperty<SwitchToEditMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/SwitchToEditMode"_ustr); return PATH; }
private:
    SwitchToEditMode(); // not defined
    ~SwitchToEditMode(); // not defined
};

struct ExpandFormatting: public comphelper::ConfigurationProperty<ExpandFormatting, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/ExpandFormatting"_ustr); return PATH; }
private:
    ExpandFormatting(); // not defined
    ~ExpandFormatting(); // not defined
};

struct ShowReference: public comphelper::ConfigurationProperty<ShowReference, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/ShowReference"_ustr); return PATH; }
private:
    ShowReference(); // not defined
    ~ShowReference(); // not defined
};

struct ExpandReference: public comphelper::ConfigurationProperty<ExpandReference, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/ExpandReference"_ustr); return PATH; }
private:
    ExpandReference(); // not defined
    ~ExpandReference(); // not defined
};

struct UpdateReferenceOnSort: public comphelper::ConfigurationProperty<UpdateReferenceOnSort, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/UpdateReferenceOnSort"_ustr); return PATH; }
private:
    UpdateReferenceOnSort(); // not defined
    ~UpdateReferenceOnSort(); // not defined
};

struct HighlightSelection: public comphelper::ConfigurationProperty<HighlightSelection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/HighlightSelection"_ustr); return PATH; }
private:
    HighlightSelection(); // not defined
    ~HighlightSelection(); // not defined
};

struct UseTabCol: public comphelper::ConfigurationProperty<UseTabCol, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/UseTabCol"_ustr); return PATH; }
private:
    UseTabCol(); // not defined
    ~UseTabCol(); // not defined
};

struct ReplaceCellsWarning: public comphelper::ConfigurationProperty<ReplaceCellsWarning, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/ReplaceCellsWarning"_ustr); return PATH; }
private:
    ReplaceCellsWarning(); // not defined
    ~ReplaceCellsWarning(); // not defined
};

struct LegacyCellSelection: public comphelper::ConfigurationProperty<LegacyCellSelection, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/LegacyCellSelection"_ustr); return PATH; }
private:
    LegacyCellSelection(); // not defined
    ~LegacyCellSelection(); // not defined
};

struct EnterPasteMode: public comphelper::ConfigurationProperty<EnterPasteMode, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/EnterPasteMode"_ustr); return PATH; }
private:
    EnterPasteMode(); // not defined
    ~EnterPasteMode(); // not defined
};

struct WarnActiveSheet: public comphelper::ConfigurationProperty<WarnActiveSheet, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/WarnActiveSheet"_ustr); return PATH; }
private:
    WarnActiveSheet(); // not defined
    ~WarnActiveSheet(); // not defined
};

struct UseScrollLock: public comphelper::ConfigurationProperty<UseScrollLock, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/UseScrollLock"_ustr); return PATH; }
private:
    UseScrollLock(); // not defined
    ~UseScrollLock(); // not defined
};

struct WrapNextPrevSheetTab: public comphelper::ConfigurationProperty<WrapNextPrevSheetTab, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/WrapNextPrevSheetTab"_ustr); return PATH; }
private:
    WrapNextPrevSheetTab(); // not defined
    ~WrapNextPrevSheetTab(); // not defined
};

struct LastFunctions: public comphelper::ConfigurationProperty<LastFunctions, com::sun::star::uno::Sequence<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/LastFunctions"_ustr); return PATH; }
private:
    LastFunctions(); // not defined
    ~LastFunctions(); // not defined
};

struct FavouriteFunctions: public comphelper::ConfigurationProperty<FavouriteFunctions, com::sun::star::uno::Sequence<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/FavouriteFunctions"_ustr); return PATH; }
private:
    FavouriteFunctions(); // not defined
    ~FavouriteFunctions(); // not defined
};

struct AutoInput: public comphelper::ConfigurationProperty<AutoInput, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/AutoInput"_ustr); return PATH; }
private:
    AutoInput(); // not defined
    ~AutoInput(); // not defined
};

struct DetectiveAuto: public comphelper::ConfigurationProperty<DetectiveAuto, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/DetectiveAuto"_ustr); return PATH; }
private:
    DetectiveAuto(); // not defined
    ~DetectiveAuto(); // not defined
};

struct SelectRangeBeforeAll: public comphelper::ConfigurationProperty<SelectRangeBeforeAll, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Input/SelectRangeBeforeAll"_ustr); return PATH; }
private:
    SelectRangeBeforeAll(); // not defined
    ~SelectRangeBeforeAll(); // not defined
};

private:
    Input(); // not defined
    ~Input(); // not defined
};

struct Grid: public comphelper::ConfigurationGroup< Grid> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid"_ustr); return PATH; }

struct Option: public comphelper::ConfigurationGroup< Option> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Option"_ustr); return PATH; }

struct SnapToGrid: public comphelper::ConfigurationProperty<SnapToGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Option/SnapToGrid"_ustr); return PATH; }
private:
    SnapToGrid(); // not defined
    ~SnapToGrid(); // not defined
};

struct SizeToGrid: public comphelper::ConfigurationProperty<SizeToGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Option/SizeToGrid"_ustr); return PATH; }
private:
    SizeToGrid(); // not defined
    ~SizeToGrid(); // not defined
};

struct VisibleGrid: public comphelper::ConfigurationProperty<VisibleGrid, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Option/VisibleGrid"_ustr); return PATH; }
private:
    VisibleGrid(); // not defined
    ~VisibleGrid(); // not defined
};

struct Synchronize: public comphelper::ConfigurationProperty<Synchronize, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Option/Synchronize"_ustr); return PATH; }
private:
    Synchronize(); // not defined
    ~Synchronize(); // not defined
};

private:
    Option(); // not defined
    ~Option(); // not defined
};

struct Resolution: public comphelper::ConfigurationGroup< Resolution> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Resolution"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationGroup< XAxis> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Resolution/XAxis"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Resolution/XAxis/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Resolution/XAxis/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationGroup< YAxis> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Resolution/YAxis"_ustr); return PATH; }

struct Metric: public comphelper::ConfigurationProperty<Metric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Resolution/YAxis/Metric"_ustr); return PATH; }
private:
    Metric(); // not defined
    ~Metric(); // not defined
};

struct NonMetric: public comphelper::ConfigurationProperty<NonMetric, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Resolution/YAxis/NonMetric"_ustr); return PATH; }
private:
    NonMetric(); // not defined
    ~NonMetric(); // not defined
};

private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Resolution(); // not defined
    ~Resolution(); // not defined
};

struct Subdivision: public comphelper::ConfigurationGroup< Subdivision> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Subdivision"_ustr); return PATH; }

struct XAxis: public comphelper::ConfigurationProperty<XAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Subdivision/XAxis"_ustr); return PATH; }
private:
    XAxis(); // not defined
    ~XAxis(); // not defined
};

struct YAxis: public comphelper::ConfigurationProperty<YAxis, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Grid/Subdivision/YAxis"_ustr); return PATH; }
private:
    YAxis(); // not defined
    ~YAxis(); // not defined
};

private:
    Subdivision(); // not defined
    ~Subdivision(); // not defined
};

private:
    Grid(); // not defined
    ~Grid(); // not defined
};

struct SortList: public comphelper::ConfigurationGroup< SortList> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/SortList"_ustr); return PATH; }

struct List: public comphelper::ConfigurationProperty<List, com::sun::star::uno::Sequence<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/SortList/List"_ustr); return PATH; }
private:
    List(); // not defined
    ~List(); // not defined
};

private:
    SortList(); // not defined
    ~SortList(); // not defined
};

struct Dialogs: public comphelper::ConfigurationGroup< Dialogs> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs"_ustr); return PATH; }

struct DBFImport: public comphelper::ConfigurationGroup< DBFImport> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/DBFImport"_ustr); return PATH; }

struct CharSet: public comphelper::ConfigurationProperty<CharSet, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/DBFImport/CharSet"_ustr); return PATH; }
private:
    CharSet(); // not defined
    ~CharSet(); // not defined
};

private:
    DBFImport(); // not defined
    ~DBFImport(); // not defined
};

struct DBFExport: public comphelper::ConfigurationGroup< DBFExport> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/DBFExport"_ustr); return PATH; }

struct CharSet: public comphelper::ConfigurationProperty<CharSet, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/DBFExport/CharSet"_ustr); return PATH; }
private:
    CharSet(); // not defined
    ~CharSet(); // not defined
};

private:
    DBFExport(); // not defined
    ~DBFExport(); // not defined
};

struct CSVExport: public comphelper::ConfigurationGroup< CSVExport> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVExport"_ustr); return PATH; }

struct CharSet: public comphelper::ConfigurationProperty<CharSet, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVExport/CharSet"_ustr); return PATH; }
private:
    CharSet(); // not defined
    ~CharSet(); // not defined
};

struct FieldSeparator: public comphelper::ConfigurationProperty<FieldSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVExport/FieldSeparator"_ustr); return PATH; }
private:
    FieldSeparator(); // not defined
    ~FieldSeparator(); // not defined
};

struct TextSeparator: public comphelper::ConfigurationProperty<TextSeparator, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVExport/TextSeparator"_ustr); return PATH; }
private:
    TextSeparator(); // not defined
    ~TextSeparator(); // not defined
};

struct SaveTrueCellContent: public comphelper::ConfigurationProperty<SaveTrueCellContent, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVExport/SaveTrueCellContent"_ustr); return PATH; }
private:
    SaveTrueCellContent(); // not defined
    ~SaveTrueCellContent(); // not defined
};

struct SaveCellFormulas: public comphelper::ConfigurationProperty<SaveCellFormulas, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVExport/SaveCellFormulas"_ustr); return PATH; }
private:
    SaveCellFormulas(); // not defined
    ~SaveCellFormulas(); // not defined
};

struct QuoteAllTextCells: public comphelper::ConfigurationProperty<QuoteAllTextCells, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVExport/QuoteAllTextCells"_ustr); return PATH; }
private:
    QuoteAllTextCells(); // not defined
    ~QuoteAllTextCells(); // not defined
};

struct FixedWidth: public comphelper::ConfigurationProperty<FixedWidth, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVExport/FixedWidth"_ustr); return PATH; }
private:
    FixedWidth(); // not defined
    ~FixedWidth(); // not defined
};

private:
    CSVExport(); // not defined
    ~CSVExport(); // not defined
};

struct CSVImport: public comphelper::ConfigurationGroup< CSVImport> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport"_ustr); return PATH; }

struct MergeDelimiters: public comphelper::ConfigurationProperty<MergeDelimiters, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/MergeDelimiters"_ustr); return PATH; }
private:
    MergeDelimiters(); // not defined
    ~MergeDelimiters(); // not defined
};

struct RemoveSpace: public comphelper::ConfigurationProperty<RemoveSpace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/RemoveSpace"_ustr); return PATH; }
private:
    RemoveSpace(); // not defined
    ~RemoveSpace(); // not defined
};

struct EvaluateFormulas: public comphelper::ConfigurationProperty<EvaluateFormulas, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/EvaluateFormulas"_ustr); return PATH; }
private:
    EvaluateFormulas(); // not defined
    ~EvaluateFormulas(); // not defined
};

struct SeparatorType: public comphelper::ConfigurationProperty<SeparatorType, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/SeparatorType"_ustr); return PATH; }
private:
    SeparatorType(); // not defined
    ~SeparatorType(); // not defined
};

struct QuotedFieldAsText: public comphelper::ConfigurationProperty<QuotedFieldAsText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/QuotedFieldAsText"_ustr); return PATH; }
private:
    QuotedFieldAsText(); // not defined
    ~QuotedFieldAsText(); // not defined
};

struct DetectSpecialNumbers: public comphelper::ConfigurationProperty<DetectSpecialNumbers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/DetectSpecialNumbers"_ustr); return PATH; }
private:
    DetectSpecialNumbers(); // not defined
    ~DetectSpecialNumbers(); // not defined
};

struct DetectScientificNumbers: public comphelper::ConfigurationProperty<DetectScientificNumbers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/DetectScientificNumbers"_ustr); return PATH; }
private:
    DetectScientificNumbers(); // not defined
    ~DetectScientificNumbers(); // not defined
};

struct Language: public comphelper::ConfigurationProperty<Language, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/Language"_ustr); return PATH; }
private:
    Language(); // not defined
    ~Language(); // not defined
};

struct Separators: public comphelper::ConfigurationProperty<Separators, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/Separators"_ustr); return PATH; }
private:
    Separators(); // not defined
    ~Separators(); // not defined
};

struct TextSeparators: public comphelper::ConfigurationProperty<TextSeparators, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/TextSeparators"_ustr); return PATH; }
private:
    TextSeparators(); // not defined
    ~TextSeparators(); // not defined
};

struct FixedWidth: public comphelper::ConfigurationProperty<FixedWidth, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/FixedWidth"_ustr); return PATH; }
private:
    FixedWidth(); // not defined
    ~FixedWidth(); // not defined
};

struct FromRow: public comphelper::ConfigurationProperty<FromRow, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/FromRow"_ustr); return PATH; }
private:
    FromRow(); // not defined
    ~FromRow(); // not defined
};

struct CharSet: public comphelper::ConfigurationProperty<CharSet, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/CharSet"_ustr); return PATH; }
private:
    CharSet(); // not defined
    ~CharSet(); // not defined
};

struct Encoding: public comphelper::ConfigurationProperty<Encoding, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/Encoding"_ustr); return PATH; }
private:
    Encoding(); // not defined
    ~Encoding(); // not defined
};

struct FixedWidthList: public comphelper::ConfigurationProperty<FixedWidthList, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/CSVImport/FixedWidthList"_ustr); return PATH; }
private:
    FixedWidthList(); // not defined
    ~FixedWidthList(); // not defined
};

private:
    CSVImport(); // not defined
    ~CSVImport(); // not defined
};

struct ClipboardTextImport: public comphelper::ConfigurationGroup< ClipboardTextImport> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport"_ustr); return PATH; }

struct MergeDelimiters: public comphelper::ConfigurationProperty<MergeDelimiters, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/MergeDelimiters"_ustr); return PATH; }
private:
    MergeDelimiters(); // not defined
    ~MergeDelimiters(); // not defined
};

struct RemoveSpace: public comphelper::ConfigurationProperty<RemoveSpace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/RemoveSpace"_ustr); return PATH; }
private:
    RemoveSpace(); // not defined
    ~RemoveSpace(); // not defined
};

struct EvaluateFormulas: public comphelper::ConfigurationProperty<EvaluateFormulas, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/EvaluateFormulas"_ustr); return PATH; }
private:
    EvaluateFormulas(); // not defined
    ~EvaluateFormulas(); // not defined
};

struct SeparatorType: public comphelper::ConfigurationProperty<SeparatorType, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/SeparatorType"_ustr); return PATH; }
private:
    SeparatorType(); // not defined
    ~SeparatorType(); // not defined
};

struct QuotedFieldAsText: public comphelper::ConfigurationProperty<QuotedFieldAsText, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/QuotedFieldAsText"_ustr); return PATH; }
private:
    QuotedFieldAsText(); // not defined
    ~QuotedFieldAsText(); // not defined
};

struct DetectSpecialNumbers: public comphelper::ConfigurationProperty<DetectSpecialNumbers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/DetectSpecialNumbers"_ustr); return PATH; }
private:
    DetectSpecialNumbers(); // not defined
    ~DetectSpecialNumbers(); // not defined
};

struct DetectScientificNumbers: public comphelper::ConfigurationProperty<DetectScientificNumbers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/DetectScientificNumbers"_ustr); return PATH; }
private:
    DetectScientificNumbers(); // not defined
    ~DetectScientificNumbers(); // not defined
};

struct SkipEmptyCells: public comphelper::ConfigurationProperty<SkipEmptyCells, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/SkipEmptyCells"_ustr); return PATH; }
private:
    SkipEmptyCells(); // not defined
    ~SkipEmptyCells(); // not defined
};

struct Language: public comphelper::ConfigurationProperty<Language, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/Language"_ustr); return PATH; }
private:
    Language(); // not defined
    ~Language(); // not defined
};

struct Separators: public comphelper::ConfigurationProperty<Separators, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/Separators"_ustr); return PATH; }
private:
    Separators(); // not defined
    ~Separators(); // not defined
};

struct TextSeparators: public comphelper::ConfigurationProperty<TextSeparators, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/TextSeparators"_ustr); return PATH; }
private:
    TextSeparators(); // not defined
    ~TextSeparators(); // not defined
};

struct FixedWidth: public comphelper::ConfigurationProperty<FixedWidth, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/FixedWidth"_ustr); return PATH; }
private:
    FixedWidth(); // not defined
    ~FixedWidth(); // not defined
};

struct FromRow: public comphelper::ConfigurationProperty<FromRow, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/FromRow"_ustr); return PATH; }
private:
    FromRow(); // not defined
    ~FromRow(); // not defined
};

struct CharSet: public comphelper::ConfigurationProperty<CharSet, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/CharSet"_ustr); return PATH; }
private:
    CharSet(); // not defined
    ~CharSet(); // not defined
};

struct Encoding: public comphelper::ConfigurationProperty<Encoding, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/Encoding"_ustr); return PATH; }
private:
    Encoding(); // not defined
    ~Encoding(); // not defined
};

struct FixedWidthList: public comphelper::ConfigurationProperty<FixedWidthList, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardTextImport/FixedWidthList"_ustr); return PATH; }
private:
    FixedWidthList(); // not defined
    ~FixedWidthList(); // not defined
};

private:
    ClipboardTextImport(); // not defined
    ~ClipboardTextImport(); // not defined
};

struct ClipboardHTMLImport: public comphelper::ConfigurationGroup< ClipboardHTMLImport> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardHTMLImport"_ustr); return PATH; }

struct Language: public comphelper::ConfigurationProperty<Language, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardHTMLImport/Language"_ustr); return PATH; }
private:
    Language(); // not defined
    ~Language(); // not defined
};

struct DetectSpecialNumbers: public comphelper::ConfigurationProperty<DetectSpecialNumbers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardHTMLImport/DetectSpecialNumbers"_ustr); return PATH; }
private:
    DetectSpecialNumbers(); // not defined
    ~DetectSpecialNumbers(); // not defined
};

struct DetectScientificNumbers: public comphelper::ConfigurationProperty<DetectScientificNumbers, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/ClipboardHTMLImport/DetectScientificNumbers"_ustr); return PATH; }
private:
    DetectScientificNumbers(); // not defined
    ~DetectScientificNumbers(); // not defined
};

private:
    ClipboardHTMLImport(); // not defined
    ~ClipboardHTMLImport(); // not defined
};

struct TextToColumnsImport: public comphelper::ConfigurationGroup< TextToColumnsImport> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport"_ustr); return PATH; }

struct MergeDelimiters: public comphelper::ConfigurationProperty<MergeDelimiters, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/MergeDelimiters"_ustr); return PATH; }
private:
    MergeDelimiters(); // not defined
    ~MergeDelimiters(); // not defined
};

struct RemoveSpace: public comphelper::ConfigurationProperty<RemoveSpace, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/RemoveSpace"_ustr); return PATH; }
private:
    RemoveSpace(); // not defined
    ~RemoveSpace(); // not defined
};

struct EvaluateFormulas: public comphelper::ConfigurationProperty<EvaluateFormulas, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/EvaluateFormulas"_ustr); return PATH; }
private:
    EvaluateFormulas(); // not defined
    ~EvaluateFormulas(); // not defined
};

struct SeparatorType: public comphelper::ConfigurationProperty<SeparatorType, sal_Int16> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/SeparatorType"_ustr); return PATH; }
private:
    SeparatorType(); // not defined
    ~SeparatorType(); // not defined
};

struct Separators: public comphelper::ConfigurationProperty<Separators, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/Separators"_ustr); return PATH; }
private:
    Separators(); // not defined
    ~Separators(); // not defined
};

struct SkipEmptyCells: public comphelper::ConfigurationProperty<SkipEmptyCells, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/SkipEmptyCells"_ustr); return PATH; }
private:
    SkipEmptyCells(); // not defined
    ~SkipEmptyCells(); // not defined
};

struct TextSeparators: public comphelper::ConfigurationProperty<TextSeparators, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/TextSeparators"_ustr); return PATH; }
private:
    TextSeparators(); // not defined
    ~TextSeparators(); // not defined
};

struct FixedWidth: public comphelper::ConfigurationProperty<FixedWidth, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/FixedWidth"_ustr); return PATH; }
private:
    FixedWidth(); // not defined
    ~FixedWidth(); // not defined
};

struct FixedWidthList: public comphelper::ConfigurationProperty<FixedWidthList, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Dialogs/TextToColumnsImport/FixedWidthList"_ustr); return PATH; }
private:
    FixedWidthList(); // not defined
    ~FixedWidthList(); // not defined
};

private:
    TextToColumnsImport(); // not defined
    ~TextToColumnsImport(); // not defined
};

private:
    Dialogs(); // not defined
    ~Dialogs(); // not defined
};

struct Calculate: public comphelper::ConfigurationGroup< Calculate> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate"_ustr); return PATH; }

struct IterativeReference: public comphelper::ConfigurationGroup< IterativeReference> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/IterativeReference"_ustr); return PATH; }

struct Iteration: public comphelper::ConfigurationProperty<Iteration, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/IterativeReference/Iteration"_ustr); return PATH; }
private:
    Iteration(); // not defined
    ~Iteration(); // not defined
};

struct Steps: public comphelper::ConfigurationProperty<Steps, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/IterativeReference/Steps"_ustr); return PATH; }
private:
    Steps(); // not defined
    ~Steps(); // not defined
};

struct MinimumChange: public comphelper::ConfigurationProperty<MinimumChange, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/IterativeReference/MinimumChange"_ustr); return PATH; }
private:
    MinimumChange(); // not defined
    ~MinimumChange(); // not defined
};

private:
    IterativeReference(); // not defined
    ~IterativeReference(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/Other"_ustr); return PATH; }

struct CaseSensitive: public comphelper::ConfigurationProperty<CaseSensitive, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/Other/CaseSensitive"_ustr); return PATH; }
private:
    CaseSensitive(); // not defined
    ~CaseSensitive(); // not defined
};

struct Precision: public comphelper::ConfigurationProperty<Precision, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/Other/Precision"_ustr); return PATH; }
private:
    Precision(); // not defined
    ~Precision(); // not defined
};

struct SearchCriteria: public comphelper::ConfigurationProperty<SearchCriteria, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/Other/SearchCriteria"_ustr); return PATH; }
private:
    SearchCriteria(); // not defined
    ~SearchCriteria(); // not defined
};

struct FindLabel: public comphelper::ConfigurationProperty<FindLabel, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/Other/FindLabel"_ustr); return PATH; }
private:
    FindLabel(); // not defined
    ~FindLabel(); // not defined
};

struct DecimalPlaces: public comphelper::ConfigurationProperty<DecimalPlaces, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/Other/DecimalPlaces"_ustr); return PATH; }
private:
    DecimalPlaces(); // not defined
    ~DecimalPlaces(); // not defined
};

struct RegularExpressions: public comphelper::ConfigurationProperty<RegularExpressions, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/Other/RegularExpressions"_ustr); return PATH; }
private:
    RegularExpressions(); // not defined
    ~RegularExpressions(); // not defined
};

struct Wildcards: public comphelper::ConfigurationProperty<Wildcards, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Calculate/Other/Wildcards"_ustr); return PATH; }
private:
    Wildcards(); // not defined
    ~Wildcards(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

private:
    Calculate(); // not defined
    ~Calculate(); // not defined
};

struct Formula: public comphelper::ConfigurationGroup< Formula> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula"_ustr); return PATH; }

struct Calculation: public comphelper::ConfigurationGroup< Calculation> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Calculation"_ustr); return PATH; }

struct UseThreadedCalculationForFormulaGroups: public comphelper::ConfigurationProperty<UseThreadedCalculationForFormulaGroups, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Calculation/UseThreadedCalculationForFormulaGroups"_ustr); return PATH; }
private:
    UseThreadedCalculationForFormulaGroups(); // not defined
    ~UseThreadedCalculationForFormulaGroups(); // not defined
};

struct OpenCLSubsetOnly: public comphelper::ConfigurationProperty<OpenCLSubsetOnly, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Calculation/OpenCLSubsetOnly"_ustr); return PATH; }
private:
    OpenCLSubsetOnly(); // not defined
    ~OpenCLSubsetOnly(); // not defined
};

struct OpenCLMinimumDataSize: public comphelper::ConfigurationProperty<OpenCLMinimumDataSize, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Calculation/OpenCLMinimumDataSize"_ustr); return PATH; }
private:
    OpenCLMinimumDataSize(); // not defined
    ~OpenCLMinimumDataSize(); // not defined
};

struct OpenCLSubsetOpCodes: public comphelper::ConfigurationProperty<OpenCLSubsetOpCodes, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Calculation/OpenCLSubsetOpCodes"_ustr); return PATH; }
private:
    OpenCLSubsetOpCodes(); // not defined
    ~OpenCLSubsetOpCodes(); // not defined
};

struct OpenCLAutoSelect: public comphelper::ConfigurationProperty<OpenCLAutoSelect, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Calculation/OpenCLAutoSelect"_ustr); return PATH; }
private:
    OpenCLAutoSelect(); // not defined
    ~OpenCLAutoSelect(); // not defined
};

struct OpenCLDevice: public comphelper::ConfigurationProperty<OpenCLDevice, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Calculation/OpenCLDevice"_ustr); return PATH; }
private:
    OpenCLDevice(); // not defined
    ~OpenCLDevice(); // not defined
};

private:
    Calculation(); // not defined
    ~Calculation(); // not defined
};

struct Syntax: public comphelper::ConfigurationGroup< Syntax> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax"_ustr); return PATH; }

struct Grammar: public comphelper::ConfigurationProperty<Grammar, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax/Grammar"_ustr); return PATH; }
private:
    Grammar(); // not defined
    ~Grammar(); // not defined
};

struct EnglishFunctionName: public comphelper::ConfigurationProperty<EnglishFunctionName, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax/EnglishFunctionName"_ustr); return PATH; }
private:
    EnglishFunctionName(); // not defined
    ~EnglishFunctionName(); // not defined
};

struct SeparatorArg: public comphelper::ConfigurationProperty<SeparatorArg, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax/SeparatorArg"_ustr); return PATH; }
private:
    SeparatorArg(); // not defined
    ~SeparatorArg(); // not defined
};

struct SeparatorArrayRow: public comphelper::ConfigurationProperty<SeparatorArrayRow, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax/SeparatorArrayRow"_ustr); return PATH; }
private:
    SeparatorArrayRow(); // not defined
    ~SeparatorArrayRow(); // not defined
};

struct SeparatorArrayCol: public comphelper::ConfigurationProperty<SeparatorArrayCol, OUString> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax/SeparatorArrayCol"_ustr); return PATH; }
private:
    SeparatorArrayCol(); // not defined
    ~SeparatorArrayCol(); // not defined
};

struct StringRefAddressSyntax: public comphelper::ConfigurationProperty<StringRefAddressSyntax, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax/StringRefAddressSyntax"_ustr); return PATH; }
private:
    StringRefAddressSyntax(); // not defined
    ~StringRefAddressSyntax(); // not defined
};

struct EmptyStringAsZero: public comphelper::ConfigurationProperty<EmptyStringAsZero, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax/EmptyStringAsZero"_ustr); return PATH; }
private:
    EmptyStringAsZero(); // not defined
    ~EmptyStringAsZero(); // not defined
};

struct StringConversion: public comphelper::ConfigurationProperty<StringConversion, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Syntax/StringConversion"_ustr); return PATH; }
private:
    StringConversion(); // not defined
    ~StringConversion(); // not defined
};

private:
    Syntax(); // not defined
    ~Syntax(); // not defined
};

struct Load: public comphelper::ConfigurationGroup< Load> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Load"_ustr); return PATH; }

struct OOXMLRecalcMode: public comphelper::ConfigurationProperty<OOXMLRecalcMode, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Load/OOXMLRecalcMode"_ustr); return PATH; }
private:
    OOXMLRecalcMode(); // not defined
    ~OOXMLRecalcMode(); // not defined
};

struct ODFRecalcMode: public comphelper::ConfigurationProperty<ODFRecalcMode, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Load/ODFRecalcMode"_ustr); return PATH; }
private:
    ODFRecalcMode(); // not defined
    ~ODFRecalcMode(); // not defined
};

struct RecalcOptimalRowHeightMode: public comphelper::ConfigurationProperty<RecalcOptimalRowHeightMode, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Formula/Load/RecalcOptimalRowHeightMode"_ustr); return PATH; }
private:
    RecalcOptimalRowHeightMode(); // not defined
    ~RecalcOptimalRowHeightMode(); // not defined
};

private:
    Load(); // not defined
    ~Load(); // not defined
};

private:
    Formula(); // not defined
    ~Formula(); // not defined
};

struct Revision: public comphelper::ConfigurationGroup< Revision> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Revision"_ustr); return PATH; }

struct Color: public comphelper::ConfigurationGroup< Color> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Revision/Color"_ustr); return PATH; }

struct Change: public comphelper::ConfigurationProperty<Change, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Revision/Color/Change"_ustr); return PATH; }
private:
    Change(); // not defined
    ~Change(); // not defined
};

struct Deletion: public comphelper::ConfigurationProperty<Deletion, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Revision/Color/Deletion"_ustr); return PATH; }
private:
    Deletion(); // not defined
    ~Deletion(); // not defined
};

struct Insertion: public comphelper::ConfigurationProperty<Insertion, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Revision/Color/Insertion"_ustr); return PATH; }
private:
    Insertion(); // not defined
    ~Insertion(); // not defined
};

struct MovedEntry: public comphelper::ConfigurationProperty<MovedEntry, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Revision/Color/MovedEntry"_ustr); return PATH; }
private:
    MovedEntry(); // not defined
    ~MovedEntry(); // not defined
};

private:
    Color(); // not defined
    ~Color(); // not defined
};

private:
    Revision(); // not defined
    ~Revision(); // not defined
};

struct Filter: public comphelper::ConfigurationGroup< Filter> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter"_ustr); return PATH; }

struct Import: public comphelper::ConfigurationGroup< Import> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import"_ustr); return PATH; }

struct VBA: public comphelper::ConfigurationGroup< VBA> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/VBA"_ustr); return PATH; }

struct UseExport: public comphelper::ConfigurationProperty<UseExport, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/VBA/UseExport"_ustr); return PATH; }
private:
    UseExport(); // not defined
    ~UseExport(); // not defined
};

struct Load: public comphelper::ConfigurationProperty<Load, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/VBA/Load"_ustr); return PATH; }
private:
    Load(); // not defined
    ~Load(); // not defined
};

struct Executable: public comphelper::ConfigurationProperty<Executable, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/VBA/Executable"_ustr); return PATH; }
private:
    Executable(); // not defined
    ~Executable(); // not defined
};

struct Save: public comphelper::ConfigurationProperty<Save, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/VBA/Save"_ustr); return PATH; }
private:
    Save(); // not defined
    ~Save(); // not defined
};

private:
    VBA(); // not defined
    ~VBA(); // not defined
};

struct Lotus123: public comphelper::ConfigurationGroup< Lotus123> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/Lotus123"_ustr); return PATH; }

struct WK3: public comphelper::ConfigurationProperty<WK3, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/Lotus123/WK3"_ustr); return PATH; }
private:
    WK3(); // not defined
    ~WK3(); // not defined
};

private:
    Lotus123(); // not defined
    ~Lotus123(); // not defined
};

struct MS_Excel: public comphelper::ConfigurationGroup< MS_Excel> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/MS_Excel"_ustr); return PATH; }

struct ColScale: public comphelper::ConfigurationProperty<ColScale, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/MS_Excel/ColScale"_ustr); return PATH; }
private:
    ColScale(); // not defined
    ~ColScale(); // not defined
};

struct RowScale: public comphelper::ConfigurationProperty<RowScale, double> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Import/MS_Excel/RowScale"_ustr); return PATH; }
private:
    RowScale(); // not defined
    ~RowScale(); // not defined
};

private:
    MS_Excel(); // not defined
    ~MS_Excel(); // not defined
};

private:
    Import(); // not defined
    ~Import(); // not defined
};

struct Export: public comphelper::ConfigurationGroup< Export> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Export"_ustr); return PATH; }

struct MS_Excel: public comphelper::ConfigurationGroup< MS_Excel> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Export/MS_Excel"_ustr); return PATH; }

struct TruncateLongSheetNames: public comphelper::ConfigurationProperty<TruncateLongSheetNames, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Filter/Export/MS_Excel/TruncateLongSheetNames"_ustr); return PATH; }
private:
    TruncateLongSheetNames(); // not defined
    ~TruncateLongSheetNames(); // not defined
};

private:
    MS_Excel(); // not defined
    ~MS_Excel(); // not defined
};

private:
    Export(); // not defined
    ~Export(); // not defined
};

private:
    Filter(); // not defined
    ~Filter(); // not defined
};

struct Print: public comphelper::ConfigurationGroup< Print> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Print"_ustr); return PATH; }

struct Page: public comphelper::ConfigurationGroup< Page> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Print/Page"_ustr); return PATH; }

struct EmptyPages: public comphelper::ConfigurationProperty<EmptyPages, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Print/Page/EmptyPages"_ustr); return PATH; }
private:
    EmptyPages(); // not defined
    ~EmptyPages(); // not defined
};

struct ForceBreaks: public comphelper::ConfigurationProperty<ForceBreaks, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Print/Page/ForceBreaks"_ustr); return PATH; }
private:
    ForceBreaks(); // not defined
    ~ForceBreaks(); // not defined
};

private:
    Page(); // not defined
    ~Page(); // not defined
};

struct Other: public comphelper::ConfigurationGroup< Other> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Print/Other"_ustr); return PATH; }

struct AllSheets: public comphelper::ConfigurationProperty<AllSheets, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Print/Other/AllSheets"_ustr); return PATH; }
private:
    AllSheets(); // not defined
    ~AllSheets(); // not defined
};

private:
    Other(); // not defined
    ~Other(); // not defined
};

private:
    Print(); // not defined
    ~Print(); // not defined
};

struct Misc: public comphelper::ConfigurationGroup< Misc> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc"_ustr); return PATH; }

struct HandleDuplicateRecords: public comphelper::ConfigurationGroup< HandleDuplicateRecords> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/HandleDuplicateRecords"_ustr); return PATH; }

struct DataIncludesHeaders: public comphelper::ConfigurationProperty<DataIncludesHeaders, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/HandleDuplicateRecords/DataIncludesHeaders"_ustr); return PATH; }
private:
    DataIncludesHeaders(); // not defined
    ~DataIncludesHeaders(); // not defined
};

struct RemoveDuplicateRows: public comphelper::ConfigurationProperty<RemoveDuplicateRows, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/HandleDuplicateRecords/RemoveDuplicateRows"_ustr); return PATH; }
private:
    RemoveDuplicateRows(); // not defined
    ~RemoveDuplicateRows(); // not defined
};

struct RemoveRecords: public comphelper::ConfigurationProperty<RemoveRecords, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/HandleDuplicateRecords/RemoveRecords"_ustr); return PATH; }
private:
    RemoveRecords(); // not defined
    ~RemoveRecords(); // not defined
};

private:
    HandleDuplicateRecords(); // not defined
    ~HandleDuplicateRecords(); // not defined
};

struct DefaultObjectSize: public comphelper::ConfigurationGroup< DefaultObjectSize> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/DefaultObjectSize"_ustr); return PATH; }

struct Width: public comphelper::ConfigurationProperty<Width, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/DefaultObjectSize/Width"_ustr); return PATH; }
private:
    Width(); // not defined
    ~Width(); // not defined
};

struct Height: public comphelper::ConfigurationProperty<Height, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/DefaultObjectSize/Height"_ustr); return PATH; }
private:
    Height(); // not defined
    ~Height(); // not defined
};

private:
    DefaultObjectSize(); // not defined
    ~DefaultObjectSize(); // not defined
};

struct SharedDocument: public comphelper::ConfigurationGroup< SharedDocument> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/SharedDocument"_ustr); return PATH; }

struct ShowWarning: public comphelper::ConfigurationProperty<ShowWarning, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/SharedDocument/ShowWarning"_ustr); return PATH; }
private:
    ShowWarning(); // not defined
    ~ShowWarning(); // not defined
};

private:
    SharedDocument(); // not defined
    ~SharedDocument(); // not defined
};

struct Draw: public comphelper::ConfigurationGroup< Draw> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/Draw"_ustr); return PATH; }

struct ClickChangeRotation: public comphelper::ConfigurationProperty<ClickChangeRotation, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Misc/Draw/ClickChangeRotation"_ustr); return PATH; }
private:
    ClickChangeRotation(); // not defined
    ~ClickChangeRotation(); // not defined
};

private:
    Draw(); // not defined
    ~Draw(); // not defined
};

private:
    Misc(); // not defined
    ~Misc(); // not defined
};

struct Compatibility: public comphelper::ConfigurationGroup< Compatibility> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Compatibility"_ustr); return PATH; }

struct MergeCells: public comphelper::ConfigurationGroup< MergeCells> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Compatibility/MergeCells"_ustr); return PATH; }

struct ShowDialog: public comphelper::ConfigurationProperty<ShowDialog, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Compatibility/MergeCells/ShowDialog"_ustr); return PATH; }
private:
    ShowDialog(); // not defined
    ~ShowDialog(); // not defined
};

struct EmptyMergedCells: public comphelper::ConfigurationProperty<EmptyMergedCells, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Compatibility/MergeCells/EmptyMergedCells"_ustr); return PATH; }
private:
    EmptyMergedCells(); // not defined
    ~EmptyMergedCells(); // not defined
};

private:
    MergeCells(); // not defined
    ~MergeCells(); // not defined
};

struct KeyBindings: public comphelper::ConfigurationGroup< KeyBindings> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Compatibility/KeyBindings"_ustr); return PATH; }

struct BaseGroup: public comphelper::ConfigurationProperty<BaseGroup, std::optional<sal_Int32> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Compatibility/KeyBindings/BaseGroup"_ustr); return PATH; }
private:
    BaseGroup(); // not defined
    ~BaseGroup(); // not defined
};

private:
    KeyBindings(); // not defined
    ~KeyBindings(); // not defined
};

struct Links: public comphelper::ConfigurationProperty<Links, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Compatibility/Links"_ustr); return PATH; }
private:
    Links(); // not defined
    ~Links(); // not defined
};

private:
    Compatibility(); // not defined
    ~Compatibility(); // not defined
};

struct Defaults: public comphelper::ConfigurationGroup< Defaults> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Defaults"_ustr); return PATH; }

struct Sheet: public comphelper::ConfigurationGroup< Sheet> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Defaults/Sheet"_ustr); return PATH; }

struct SheetCount: public comphelper::ConfigurationProperty<SheetCount, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Defaults/Sheet/SheetCount"_ustr); return PATH; }
private:
    SheetCount(); // not defined
    ~SheetCount(); // not defined
};

struct SheetPrefix: public comphelper::ConfigurationProperty<SheetPrefix, std::optional<OUString> > {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Defaults/Sheet/SheetPrefix"_ustr); return PATH; }
private:
    SheetPrefix(); // not defined
    ~SheetPrefix(); // not defined
};

struct JumboSheets: public comphelper::ConfigurationProperty<JumboSheets, bool> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/Defaults/Sheet/JumboSheets"_ustr); return PATH; }
private:
    JumboSheets(); // not defined
    ~JumboSheets(); // not defined
};

private:
    Sheet(); // not defined
    ~Sheet(); // not defined
};

private:
    Defaults(); // not defined
    ~Defaults(); // not defined
};

struct DataStream: public comphelper::ConfigurationGroup< DataStream> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/DataStream"_ustr); return PATH; }

struct UpdateTimeout: public comphelper::ConfigurationProperty<UpdateTimeout, sal_Int32> {
    static OUString path() { static constexpr OUString PATH(u"/org.openoffice.Office.Calc/DataStream/UpdateTimeout"_ustr); return PATH; }
private:
    UpdateTimeout(); // not defined
    ~UpdateTimeout(); // not defined
};

private:
    DataStream(); // not defined
    ~DataStream(); // not defined
};

} } }

#endif
