#ifndef SBK_KCOLORBUTTONWRAPPER_H
#define SBK_KCOLORBUTTONWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kcolorbutton.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KColorButtonWrapper : public KColorButton
{
public:
    KColorButtonWrapper(::QWidget * parent = nullptr);
    KColorButtonWrapper(const ::QColor & c, ::QWidget * parent = nullptr);
    KColorButtonWrapper(const ::QColor & c, const ::QColor & defaultColor, ::QWidget * parent = nullptr);
    KColorButtonWrapper(const KColorButtonWrapper &) = delete;
    KColorButtonWrapper& operator=(const KColorButtonWrapper &) = delete;
    KColorButtonWrapper(KColorButtonWrapper &&) = delete;
    KColorButtonWrapper& operator=(KColorButtonWrapper &&) = delete;
    ~KColorButtonWrapper() override;

    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * e) override;
    void checkStateSet() override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * event) override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * arg__1) override;
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    void dragMoveEvent(::QDragMoveEvent * event) override;
    void dropEvent(::QDropEvent * arg__1) override;
    void enterEvent(::QEnterEvent * event) override;
    bool event(::QEvent * e) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * arg__1) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * arg__1) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * event) override;
    bool hitButton(const ::QPoint & pos) const override;
    void initPainter(::QPainter * painter) const override;
    void initStyleOption(::QStyleOptionButton * option) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent(::QKeyEvent * e) override;
    void keyReleaseEvent(::QKeyEvent * e) override;
    void leaveEvent(::QEvent * event) override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent(::QMouseEvent * e) override;
    void mousePressEvent(::QMouseEvent * e) override;
    void mouseReleaseEvent(::QMouseEvent * e) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    void nextCheckState() override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * pe) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * event) override;
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * event) override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * e) override;
    void wheelEvent(::QWheelEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 51> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KCOLORBUTTONWRAPPER_H
