
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kunitconversion_python.h"

// main header
#include "kunitconversion_unit_wrapper.h"

// Argument includes
#include <QString>
#include <qchar.h>
#include <unit.h>
#include <unitcategory.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

using namespace KUnitConversion;

extern "C" {
static PyTypeObject *_Sbk_KUnitConversion_Unit_Type = nullptr;
static PyTypeObject *Sbk_KUnitConversion_Unit_TypeF(void)
{
    return _Sbk_KUnitConversion_Unit_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUnitConversion_Unit_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUnitConversion::Unit >()))
        return -1;

    ::KUnitConversion::Unit *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "Unit", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Unit::Unit()
    // 1: Unit::Unit(KUnitConversion::Unit)
    if (numArgs == 0) {
        overloadId = 0; // Unit()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), (pyArgs[0])))) {
        overloadId = 1; // Unit(KUnitConversion::Unit)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Unit()
        {

            // Unit()
            cptr = new ::KUnitConversion::Unit();
            break;
        }
        case 1: // Unit(const KUnitConversion::Unit &other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KUnitConversion::Unit *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Unit(KUnitConversion::Unit)
                cptr = new ::KUnitConversion::Unit(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KUnitConversion::Unit >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KUnitConversion_UnitFunc_category(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // category()const
        KUnitConversion::UnitCategory* cppResult = new KUnitConversion::UnitCategory(const_cast<const ::KUnitConversion::Unit *>(cppSelf)->category());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitCategory_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_categoryId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // categoryId()const
        KUnitConversion::CategoryId cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->categoryId();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_CategoryId_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_description(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // description()const
        QString cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->description();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_fromDefault(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Unit::fromDefault(qreal)const->qreal
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // fromDefault(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fromDefault", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fromDefault(qreal)const
            qreal cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->fromDefault(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_id(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // id()const
        KUnitConversion::UnitId cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->id();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_UnitId_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isNull()const
        bool cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->isNull();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_symbol(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // symbol()const
        QString cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->symbol();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_toDefault(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: Unit::toDefault(qreal)const->qreal
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // toDefault(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "toDefault", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // toDefault(qreal)const
            qreal cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->toDefault(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_toString(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "toString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:toString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Unit::toString(qreal,int=,char=,int=,const QChar&=)const->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toString(qreal,int,char,int,QChar)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toString(qreal,int,char,int,QChar)const
            } else if (numArgs >= 3
                && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // toString(qreal,int,char,int,QChar)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // toString(qreal,int,char,int,QChar)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[4])))) {
                        overloadId = 0; // toString(qreal,int,char,int,QChar)const
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "toString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"fieldWidth", 1}, {"format", 2}, {"precision", 3}, {"fillChar", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "toString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        char cppArg2 = 'g';
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = -1;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QChar cppArg4 = QLatin1Char(' ');
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // toString(qreal,int,char,int,QChar)const
            QString cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->toString(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUnitConversion_UnitFunc_toSymbolString(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "toSymbolString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:toSymbolString", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: Unit::toSymbolString(qreal,int=,char=,int=,const QChar&=)const->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // toSymbolString(qreal,int,char,int,QChar)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // toSymbolString(qreal,int,char,int,QChar)const
            } else if (numArgs >= 3
                && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // toSymbolString(qreal,int,char,int,QChar)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // toSymbolString(qreal,int,char,int,QChar)const
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[4])))) {
                        overloadId = 0; // toSymbolString(qreal,int,char,int,QChar)const
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "toSymbolString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"fieldWidth", 1}, {"format", 2}, {"precision", 3}, {"fillChar", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<char>(), (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "toSymbolString", errInfo, SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]);
            }
        }
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        char cppArg2 = 'g';
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = -1;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QChar cppArg4 = QLatin1Char(' ');
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // toSymbolString(qreal,int,char,int,QChar)const
            QString cppResult = const_cast<const ::KUnitConversion::Unit *>(cppSelf)->toSymbolString(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KUnitConversion_Unit_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUnitConversion_Unit_methods[] = {
    {"category", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_category), METH_NOARGS, nullptr},
    {"categoryId", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_categoryId), METH_NOARGS, nullptr},
    {"description", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_description), METH_NOARGS, nullptr},
    {"fromDefault", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_fromDefault), METH_O, nullptr},
    {"id", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_id), METH_NOARGS, nullptr},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_isNull), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_isValid), METH_NOARGS, nullptr},
    {"symbol", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_symbol), METH_NOARGS, nullptr},
    {"toDefault", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_toDefault), METH_O, nullptr},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_toString), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"toSymbolString", reinterpret_cast<PyCFunction>(Sbk_KUnitConversion_UnitFunc_toSymbolString), METH_VARARGS|METH_KEYWORDS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_KUnitConversion_Unit_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KUnitConversion::Unit *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), (pyArg)))) {
                // operator!=(const KUnitConversion::Unit &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUnitConversion::Unit *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf != (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX]), (pyArg)))) {
                // operator==(const KUnitConversion::Unit &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::KUnitConversion::Unit *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

} // extern "C"

static int Sbk_KUnitConversion_Unit_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUnitConversion_Unit_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUnitConversion_Unit_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUnitConversion_Unit_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUnitConversion_Unit_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_KUnitConversion_Unit_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUnitConversion_Unit_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUnitConversion_Unit_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUnitConversion_Unit_spec = {
    "1:KUnitConversion.KUnitConversion.Unit",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUnitConversion_Unit_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Unit_PythonToCpp_Unit_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUnitConversion_Unit_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Unit_PythonToCpp_Unit_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUnitConversion_Unit_TypeF()))
        return Unit_PythonToCpp_Unit_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Unit_PTR_CppToPython_Unit(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KUnitConversion_Unit_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KUnitConversion_Unit_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUnitConversion_Unit_SignatureStrings[] = {
    "1:KUnitConversion.KUnitConversion.Unit(self)",
    "0:KUnitConversion.KUnitConversion.Unit(self,other:KUnitConversion.KUnitConversion.Unit)",
    "KUnitConversion.KUnitConversion.Unit.category(self)->KUnitConversion.KUnitConversion.UnitCategory",
    "KUnitConversion.KUnitConversion.Unit.categoryId(self)->KUnitConversion.KUnitConversion.CategoryId",
    "KUnitConversion.KUnitConversion.Unit.description(self)->QString",
    "KUnitConversion.KUnitConversion.Unit.fromDefault(self,value:qreal)->qreal",
    "KUnitConversion.KUnitConversion.Unit.id(self)->KUnitConversion.KUnitConversion.UnitId",
    "KUnitConversion.KUnitConversion.Unit.isNull(self)->bool",
    "KUnitConversion.KUnitConversion.Unit.isValid(self)->bool",
    "KUnitConversion.KUnitConversion.Unit.symbol(self)->QString",
    "KUnitConversion.KUnitConversion.Unit.toDefault(self,value:qreal)->qreal",
    "KUnitConversion.KUnitConversion.Unit.toString(self,value:qreal,fieldWidth:int=0,format:char='g',precision:int=-1,fillChar:QChar=QLatin1Char(' '))->QString",
    "KUnitConversion.KUnitConversion.Unit.toSymbolString(self,value:qreal,fieldWidth:int=0,format:char='g',precision:int=-1,fillChar:QChar=QLatin1Char(' '))->QString",
    "KUnitConversion.KUnitConversion.Unit.__ne__(self,other:KUnitConversion.KUnitConversion.Unit)->bool",
    "KUnitConversion.KUnitConversion.Unit.__eq__(self,other:KUnitConversion.KUnitConversion.Unit)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t KUnitConversion_Unit_SignatureByteSize = 265;
static constexpr uint8_t KUnitConversion_Unit_SignatureBytes[265] = {
    0x78, 0xda, 0xcd, 0x54, 0xc1, 0x6a, 0xc3, 0x30, 0x0c, 0xbd, 0xf7, 0x2b, 0x76, 0x4b, 0x03, 0x69,
    0x69, 0xae, 0x81, 0xec, 0x92, 0x5d, 0xca, 0xc6, 0x20, 0x94, 0x6d, 0x47, 0xe3, 0x26, 0x72, 0x22,
    0x70, 0xac, 0xd6, 0x56, 0x0a, 0xfd, 0xfb, 0x25, 0x69, 0xbb, 0xc1, 0x76, 0x51, 0xca, 0x0e, 0xbb,
    0xd8, 0x96, 0xa5, 0xf7, 0x9e, 0xf4, 0x30, 0x4e, 0xb3, 0xe7, 0x37, 0x87, 0x5c, 0x90, 0x3b, 0x81,
    0x0f, 0x48, 0x6e, 0xfd, 0x33, 0x1e, 0xc3, 0x65, 0x00, 0x6b, 0xe2, 0xc5, 0x46, 0x5e, 0x9c, 0x10,
    0xb7, 0xe0, 0x45, 0xf5, 0xf1, 0x42, 0x52, 0xb5, 0xae, 0x34, 0x43, 0x43, 0xfe, 0x7c, 0xe9, 0x65,
    0xf5, 0x28, 0x01, 0x15, 0x57, 0xcc, 0x3c, 0x85, 0x6d, 0x2d, 0xd5, 0x28, 0xbe, 0x10, 0x32, 0x85,
    0x1a, 0x42, 0xe5, 0xf1, 0xc0, 0xc3, 0xc5, 0x4d, 0xa2, 0xdc, 0xb1, 0x47, 0xd7, 0xc8, 0xf0, 0xc6,
    0x53, 0xf7, 0x04, 0x46, 0xf7, 0xf6, 0xea, 0xf2, 0x49, 0xdb, 0x1e, 0xb2, 0xa3, 0x07, 0x6d, 0x07,
    0xae, 0x69, 0x97, 0x31, 0x61, 0x3d, 0xc7, 0x47, 0xe9, 0x7c, 0x18, 0x5e, 0x7b, 0x6b, 0x6f, 0xcc,
    0x7b, 0x22, 0x69, 0x37, 0xe1, 0x5d, 0xdb, 0xef, 0x96, 0xe4, 0xc0, 0x70, 0xee, 0xf6, 0x64, 0xef,
    0xf2, 0x92, 0xe9, 0x6f, 0x9c, 0x64, 0xba, 0xa8, 0xfe, 0xa2, 0x49, 0x0c, 0x82, 0xad, 0x3f, 0xb0,
    0xe6, 0x36, 0x43, 0xc7, 0xf9, 0x26, 0x31, 0xe4, 0x3b, 0xcd, 0x59, 0xd5, 0x6a, 0x9f, 0x47, 0x4d,
    0x94, 0x1c, 0x3c, 0x54, 0x38, 0x32, 0x4d, 0xf9, 0x55, 0x3a, 0x20, 0xac, 0x2d, 0x86, 0x6c, 0x56,
    0x8e, 0x6b, 0x5e, 0xbe, 0x68, 0x46, 0x97, 0x8e, 0xe7, 0x65, 0xf4, 0x10, 0xc5, 0xf3, 0x47, 0xdc,
    0x4d, 0xfe, 0xfc, 0xdb, 0x06, 0x95, 0x72, 0xa0, 0xd4, 0xec, 0x0f, 0x63, 0xce, 0x0b, 0x51, 0x0a,
    0x8e, 0xf7, 0x4b, 0x7c, 0x02, 0x92, 0xdc, 0xe8, 0x40
};
#endif

PyTypeObject *init_KUnitConversion_Unit(PyObject *enclosingClass)
{
    if (SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX].type != nullptr)
        return SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX].type;

    Shiboken::AutoDecRef Sbk_KUnitConversion_Unit_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUnitConversion_Unit_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Unit",
        "KUnitConversion::Unit*",
        &Sbk_KUnitConversion_Unit_spec,
        &Shiboken::callCppDestructor< ::KUnitConversion::Unit >,
        Sbk_KUnitConversion_Unit_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass);
    auto *pyType = _Sbk_KUnitConversion_Unit_Type; // references _Sbk_KUnitConversion_Unit_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUnitConversion_Unit_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUnitConversion_Unit_SignatureBytes, KUnitConversion_Unit_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUnitConversion_Unit_PropertyStrings);
    SbkKUnitConversionTypeStructs[SBK_KUnitConversion_Unit_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Unit_PythonToCpp_Unit_PTR,
        is_Unit_PythonToCpp_Unit_PTR_Convertible,
        Unit_PTR_CppToPython_Unit);

    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Unit");
    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Unit*");
    Shiboken::Conversions::registerConverterName(converter, "KUnitConversion::Unit&");
    Shiboken::Conversions::registerConverterAlias(converter, "Unit");
    Shiboken::Conversions::registerConverterAlias(converter, "Unit*");
    Shiboken::Conversions::registerConverterAlias(converter, "Unit&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUnitConversion::Unit).name());

    qRegisterMetaType< ::KUnitConversion::Unit *>();

    return pyType;
}
