
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kuserid_wrapper.h"

// Argument includes
#include <QString>
#include <kuser.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KUserId_Type = nullptr;
static PyTypeObject *Sbk_KUserId_TypeF(void)
{
    return _Sbk_KUserId_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KUserId_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KUserId >()))
        return -1;

    ::KUserId *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KUserId", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KUserId::KUserId()
    // 1: KUserId::KUserId(KUserId)
    // 2: KUserId::KUserId(uint)
    if (numArgs == 0) {
        overloadId = 0; // KUserId()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 2; // KUserId(uint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KUserId(KUserId)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KUserId()
        {

            // KUserId()
            cptr = new ::KUserId();
            break;
        }
        case 1: // KUserId(const KUserId &KUserId)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KUserId cppArg0_local;
            ::KUserId *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KUserId(KUserId)
                cptr = new ::KUserId(*cppArg0);
            }
            break;
        }
        case 2: // KUserId(unsigned int uid)
        {
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KUserId(uint)
                cptr = new ::KUserId(cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KUserId >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KUserIdFunc_currentEffectiveUserId(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentEffectiveUserId()
        KUserId cppResult = ::KUserId::currentEffectiveUserId();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserIdFunc_currentUserId(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentUserId()
        KUserId cppResult = ::KUserId::currentUserId();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserIdFunc_fromName(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KUserId::fromName(QString)->KUserId
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // fromName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fromName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fromName(QString)
            KUserId cppResult = ::KUserId::fromName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KUserId__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KUserId *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KUserId_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KUserId_methods[] = {
    {"currentEffectiveUserId", reinterpret_cast<PyCFunction>(Sbk_KUserIdFunc_currentEffectiveUserId), METH_NOARGS|METH_STATIC, nullptr},
    {"currentUserId", reinterpret_cast<PyCFunction>(Sbk_KUserIdFunc_currentUserId), METH_NOARGS|METH_STATIC, nullptr},
    {"fromName", reinterpret_cast<PyCFunction>(Sbk_KUserIdFunc_fromName), METH_O|METH_STATIC, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KUserId__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static Py_hash_t Sbk_KUserId_HashFunc(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KUserId *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(qHash(*cppSelf));
}

static int Sbk_KUserId_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KUserId_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KUserId_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_KUserId_HashFunc)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KUserId_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KUserId_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KUserId_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KUserId_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KUserId_spec = {
    "1:KCoreAddons.KUserId",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KUserId_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KUserId_PythonToCpp_KUserId_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KUserId_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KUserId_PythonToCpp_KUserId_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KUserId_TypeF()))
        return KUserId_PythonToCpp_KUserId_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KUserId_PTR_CppToPython_KUserId(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KUserId_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KUserId_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KUserId_COPY_CppToPython_KUserId(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KUserId *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KUserId_TypeF(), new ::KUserId(*source), true, true);
}

// Python to C++ copy conversion.
static void KUserId_PythonToCpp_KUserId_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KUserId *>(cppOut) = *reinterpret_cast< ::KUserId *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KUserId_PythonToCpp_KUserId_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KUserId_TypeF()))
        return KUserId_PythonToCpp_KUserId_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KUserId_SignatureStrings[] = {
    "2:KCoreAddons.KUserId(self)",
    "1:KCoreAddons.KUserId(self,KUserId:KCoreAddons.KUserId)",
    "0:KCoreAddons.KUserId(self,uid:unsigned int)",
    "KCoreAddons.KUserId.currentEffectiveUserId()->KCoreAddons.KUserId",
    "KCoreAddons.KUserId.currentUserId()->KCoreAddons.KUserId",
    "KCoreAddons.KUserId.fromName(name:QString)->KCoreAddons.KUserId",
    "KCoreAddons.KUserId.__copy__(self)->typing._Self",
    "KCoreAddons.KUserId.__hash__(self)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t KUserId_SignatureByteSize = 154;
static constexpr uint8_t KUserId_SignatureBytes[154] = {
    0x78, 0xda, 0x33, 0xb2, 0xf2, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6,
    0xf3, 0x0e, 0x2d, 0x4e, 0x2d, 0xf2, 0x4c, 0xd1, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4, 0x32, 0xc4,
    0x29, 0xa7, 0x03, 0xe5, 0x60, 0x53, 0xa0, 0xc9, 0x65, 0x80, 0x5b, 0x5f, 0x69, 0x66, 0x8a, 0x55,
    0x69, 0x5e, 0x71, 0x66, 0x7a, 0x5e, 0x6a, 0x8a, 0x42, 0x66, 0x5e, 0x89, 0x26, 0x17, 0x16, 0xa5,
    0x7a, 0xc9, 0xa5, 0x45, 0x45, 0xa9, 0x79, 0x25, 0xae, 0x69, 0x69, 0xa9, 0xc9, 0x25, 0x99, 0x65,
    0xa9, 0x50, 0x13, 0x34, 0x75, 0xed, 0xb0, 0xa8, 0xc6, 0x67, 0x02, 0xe9, 0x1a, 0xd3, 0x8a, 0xf2,
    0x73, 0xfd, 0x12, 0x73, 0x53, 0x35, 0xf2, 0x80, 0x84, 0x55, 0x60, 0x70, 0x49, 0x51, 0x66, 0x5e,
    0x3a, 0x09, 0xfa, 0xe3, 0xe3, 0x93, 0xf3, 0x0b, 0x2a, 0xe3, 0xe3, 0x21, 0x41, 0xa8, 0x6b, 0x57,
    0x52, 0x59, 0x00, 0x34, 0x40, 0x2f, 0x3e, 0x18, 0xc8, 0xc5, 0xa1, 0x21, 0x23, 0xb1, 0x38, 0x03,
    0xa1, 0x01, 0x18, 0x28, 0x5c, 0x00, 0xb0, 0xda, 0x8e, 0x89
};
#endif

PyTypeObject *init_KUserId(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX].type;

    Shiboken::AutoDecRef Sbk_KUserId_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KUserId_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KUserId",
        "KUserId",
        &Sbk_KUserId_spec,
        &Shiboken::callCppDestructor< ::KUserId >,
        Sbk_KUserId_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KUserId_Type; // references _Sbk_KUserId_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KUserId_SignatureStrings);
#else
    InitSignatureBytes(pyType, KUserId_SignatureBytes, KUserId_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KUserId_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KUserId_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KUserId_PythonToCpp_KUserId_PTR,
        is_KUserId_PythonToCpp_KUserId_PTR_Convertible,
        KUserId_PTR_CppToPython_KUserId,
        KUserId_COPY_CppToPython_KUserId);

    Shiboken::Conversions::registerConverterName(converter, "KUserId");
    Shiboken::Conversions::registerConverterName(converter, "KUserId*");
    Shiboken::Conversions::registerConverterName(converter, "KUserId&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KUserId).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KUserId_PythonToCpp_KUserId_COPY,
        is_KUserId_PythonToCpp_KUserId_COPY_Convertible);

    qRegisterMetaType< ::KUserId >("KUserId");

    return pyType;
}
