#line 1 "ad_x86.cpp"
//
// Copyright (c) 2003, 2017, Oracle and/or its affiliates. All rights reserved.
// DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
//
// This code is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License version 2 only, as
// published by the Free Software Foundation.
//
// This code is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// version 2 for more details (a copy is included in the LICENSE file that
// accompanied this code).
//
// You should have received a copy of the GNU General Public License version
// 2 along with this work; if not, write to the Free Software Foundation,
// Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
//
// Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
// or visit www.oracle.com if you need additional information or have any
// questions.
//
//

// Machine Generated File.  Do Not Edit!

#include "precompiled.hpp"
#include "adfiles/adGlobals_x86.hpp"
#include "adfiles/ad_x86.hpp"
#include "memory/allocation.inline.hpp"
#include "asm/macroAssembler.inline.hpp"
#include "code/compiledIC.hpp"
#include "code/nativeInst.hpp"
#include "code/vmreg.inline.hpp"
#include "gc/shared/collectedHeap.inline.hpp"
#include "oops/compiledICHolder.hpp"
#include "oops/markOop.hpp"
#include "oops/method.hpp"
#include "oops/oop.inline.hpp"
#include "opto/cfgnode.hpp"
#include "opto/intrinsicnode.hpp"
#include "opto/locknode.hpp"
#include "opto/opcodes.hpp"
#include "opto/regalloc.hpp"
#include "opto/regmask.hpp"
#include "opto/runtime.hpp"
#include "runtime/biasedLocking.hpp"
#include "runtime/safepointMechanism.hpp"
#include "runtime/sharedRuntime.hpp"
#include "runtime/stubRoutines.hpp"
#include "utilities/growableArray.hpp"

//SourceForm

#line 551 "src/hotspot/cpu/x86/x86_64.ad"

#define   RELOC_IMM64    Assembler::imm_operand
#define   RELOC_DISP32   Assembler::disp32_operand

#define __ _masm.

static bool generate_vzeroupper(Compile* C) {
  return (VM_Version::supports_vzeroupper() && (C->max_vector_size() > 16 || C->clear_upper_avx() == true)) ? true: false;  // Generate vzeroupper
}

static int clear_avx_size() {
  return generate_vzeroupper(Compile::current()) ? 3: 0;  // vzeroupper
}

// !!!!! Special hack to get all types of calls to specify the byte offset
//       from the start of the call to the point where the return address
//       will point.
int MachCallStaticJavaNode::ret_addr_offset()
{
  int offset = 5; // 5 bytes from start of call to where return address points
  offset += clear_avx_size();
  return offset;
}

int MachCallDynamicJavaNode::ret_addr_offset()
{
  int offset = 15; // 15 bytes from start of call to where return address points
  offset += clear_avx_size();
  return offset;
}

int MachCallRuntimeNode::ret_addr_offset() {
  int offset = 13; // movq r10,#addr; callq (r10)
  offset += clear_avx_size();
  return offset;
}

// Indicate if the safepoint node needs the polling page as an input,
// it does if the polling page is more than disp32 away.
bool SafePointNode::needs_polling_address_input()
{
  return SafepointMechanism::uses_thread_local_poll() || Assembler::is_polling_page_far();
}

//
// Compute padding required for nodes which need alignment
//

// The address of the call instruction needs to be 4-byte aligned to
// ensure that it does not span a cache line so that it can be patched.
int CallStaticJavaDirectNode::compute_padding(int current_offset) const
{
  current_offset += clear_avx_size(); // skip vzeroupper
  current_offset += 1; // skip call opcode byte
  return align_up(current_offset, alignment_required()) - current_offset;
}

// The address of the call instruction needs to be 4-byte aligned to
// ensure that it does not span a cache line so that it can be patched.
int CallDynamicJavaDirectNode::compute_padding(int current_offset) const
{
  current_offset += clear_avx_size(); // skip vzeroupper
  current_offset += 11; // skip movq instruction + call opcode byte
  return align_up(current_offset, alignment_required()) - current_offset;
}

// EMIT_RM()
void emit_rm(CodeBuffer &cbuf, int f1, int f2, int f3) {
  unsigned char c = (unsigned char) ((f1 << 6) | (f2 << 3) | f3);
  cbuf.insts()->emit_int8(c);
}

// EMIT_CC()
void emit_cc(CodeBuffer &cbuf, int f1, int f2) {
  unsigned char c = (unsigned char) (f1 | f2);
  cbuf.insts()->emit_int8(c);
}

// EMIT_OPCODE()
void emit_opcode(CodeBuffer &cbuf, int code) {
  cbuf.insts()->emit_int8((unsigned char) code);
}

// EMIT_OPCODE() w/ relocation information
void emit_opcode(CodeBuffer &cbuf,
                 int code, relocInfo::relocType reloc, int offset, int format)
{
  cbuf.relocate(cbuf.insts_mark() + offset, reloc, format);
  emit_opcode(cbuf, code);
}

// EMIT_D8()
void emit_d8(CodeBuffer &cbuf, int d8) {
  cbuf.insts()->emit_int8((unsigned char) d8);
}

// EMIT_D16()
void emit_d16(CodeBuffer &cbuf, int d16) {
  cbuf.insts()->emit_int16(d16);
}

// EMIT_D32()
void emit_d32(CodeBuffer &cbuf, int d32) {
  cbuf.insts()->emit_int32(d32);
}

// EMIT_D64()
void emit_d64(CodeBuffer &cbuf, int64_t d64) {
  cbuf.insts()->emit_int64(d64);
}

// emit 32 bit value and construct relocation entry from relocInfo::relocType
void emit_d32_reloc(CodeBuffer& cbuf,
                    int d32,
                    relocInfo::relocType reloc,
                    int format)
{
  assert(reloc != relocInfo::external_word_type, "use 2-arg emit_d32_reloc");
  cbuf.relocate(cbuf.insts_mark(), reloc, format);
  cbuf.insts()->emit_int32(d32);
}

// emit 32 bit value and construct relocation entry from RelocationHolder
void emit_d32_reloc(CodeBuffer& cbuf, int d32, RelocationHolder const& rspec, int format) {
#ifdef ASSERT
  if (rspec.reloc()->type() == relocInfo::oop_type &&
      d32 != 0 && d32 != (intptr_t) Universe::non_oop_word()) {
    assert(Universe::heap()->is_in_reserved((address)(intptr_t)d32), "should be real oop");
    assert(oopDesc::is_oop(cast_to_oop((intptr_t)d32)) && (ScavengeRootsInCode || !Universe::heap()->is_scavengable(cast_to_oop((intptr_t)d32))), "cannot embed scavengable oops in code");
  }
#endif
  cbuf.relocate(cbuf.insts_mark(), rspec, format);
  cbuf.insts()->emit_int32(d32);
}

void emit_d32_reloc(CodeBuffer& cbuf, address addr) {
  address next_ip = cbuf.insts_end() + 4;
  emit_d32_reloc(cbuf, (int) (addr - next_ip),
                 external_word_Relocation::spec(addr),
                 RELOC_DISP32);
}


// emit 64 bit value and construct relocation entry from relocInfo::relocType
void emit_d64_reloc(CodeBuffer& cbuf, int64_t d64, relocInfo::relocType reloc, int format) {
  cbuf.relocate(cbuf.insts_mark(), reloc, format);
  cbuf.insts()->emit_int64(d64);
}

// emit 64 bit value and construct relocation entry from RelocationHolder
void emit_d64_reloc(CodeBuffer& cbuf, int64_t d64, RelocationHolder const& rspec, int format) {
#ifdef ASSERT
  if (rspec.reloc()->type() == relocInfo::oop_type &&
      d64 != 0 && d64 != (int64_t) Universe::non_oop_word()) {
    assert(Universe::heap()->is_in_reserved((address)d64), "should be real oop");
    assert(oopDesc::is_oop(cast_to_oop(d64)) && (ScavengeRootsInCode || !Universe::heap()->is_scavengable(cast_to_oop(d64))),
           "cannot embed scavengable oops in code");
  }
#endif
  cbuf.relocate(cbuf.insts_mark(), rspec, format);
  cbuf.insts()->emit_int64(d64);
}

// Access stack slot for load or store
void store_to_stackslot(CodeBuffer &cbuf, int opcode, int rm_field, int disp)
{
  emit_opcode(cbuf, opcode);                  // (e.g., FILD   [RSP+src])
  if (-0x80 <= disp && disp < 0x80) {
    emit_rm(cbuf, 0x01, rm_field, RSP_enc);   // R/M byte
    emit_rm(cbuf, 0x00, RSP_enc, RSP_enc);    // SIB byte
    emit_d8(cbuf, disp);     // Displacement  // R/M byte
  } else {
    emit_rm(cbuf, 0x02, rm_field, RSP_enc);   // R/M byte
    emit_rm(cbuf, 0x00, RSP_enc, RSP_enc);    // SIB byte
    emit_d32(cbuf, disp);     // Displacement // R/M byte
  }
}

   // rRegI ereg, memory mem) %{    // emit_reg_mem
void encode_RegMem(CodeBuffer &cbuf,
                   int reg,
                   int base, int index, int scale, int disp, relocInfo::relocType disp_reloc)
{
  assert(disp_reloc == relocInfo::none, "cannot have disp");
  int regenc = reg & 7;
  int baseenc = base & 7;
  int indexenc = index & 7;

  // There is no index & no scale, use form without SIB byte
  if (index == 0x4 && scale == 0 && base != RSP_enc && base != R12_enc) {
    // If no displacement, mode is 0x0; unless base is [RBP] or [R13]
    if (disp == 0 && base != RBP_enc && base != R13_enc) {
      emit_rm(cbuf, 0x0, regenc, baseenc); // *
    } else if (-0x80 <= disp && disp < 0x80 && disp_reloc == relocInfo::none) {
      // If 8-bit displacement, mode 0x1
      emit_rm(cbuf, 0x1, regenc, baseenc); // *
      emit_d8(cbuf, disp);
    } else {
      // If 32-bit displacement
      if (base == -1) { // Special flag for absolute address
        emit_rm(cbuf, 0x0, regenc, 0x5); // *
        if (disp_reloc != relocInfo::none) {
          emit_d32_reloc(cbuf, disp, relocInfo::oop_type, RELOC_DISP32);
        } else {
          emit_d32(cbuf, disp);
        }
      } else {
        // Normal base + offset
        emit_rm(cbuf, 0x2, regenc, baseenc); // *
        if (disp_reloc != relocInfo::none) {
          emit_d32_reloc(cbuf, disp, relocInfo::oop_type, RELOC_DISP32);
        } else {
          emit_d32(cbuf, disp);
        }
      }
    }
  } else {
    // Else, encode with the SIB byte
    // If no displacement, mode is 0x0; unless base is [RBP] or [R13]
    if (disp == 0 && base != RBP_enc && base != R13_enc) {
      // If no displacement
      emit_rm(cbuf, 0x0, regenc, 0x4); // *
      emit_rm(cbuf, scale, indexenc, baseenc);
    } else {
      if (-0x80 <= disp && disp < 0x80 && disp_reloc == relocInfo::none) {
        // If 8-bit displacement, mode 0x1
        emit_rm(cbuf, 0x1, regenc, 0x4); // *
        emit_rm(cbuf, scale, indexenc, baseenc);
        emit_d8(cbuf, disp);
      } else {
        // If 32-bit displacement
        if (base == 0x04 ) {
          emit_rm(cbuf, 0x2, regenc, 0x4);
          emit_rm(cbuf, scale, indexenc, 0x04); // XXX is this valid???
        } else {
          emit_rm(cbuf, 0x2, regenc, 0x4);
          emit_rm(cbuf, scale, indexenc, baseenc); // *
        }
        if (disp_reloc != relocInfo::none) {
          emit_d32_reloc(cbuf, disp, relocInfo::oop_type, RELOC_DISP32);
        } else {
          emit_d32(cbuf, disp);
        }
      }
    }
  }
}

// This could be in MacroAssembler but it's fairly C2 specific
void emit_cmpfp_fixup(MacroAssembler& _masm) {
  Label exit;
  __ jccb(Assembler::noParity, exit);
  __ pushf();
  //
  // comiss/ucomiss instructions set ZF,PF,CF flags and
  // zero OF,AF,SF for NaN values.
  // Fixup flags by zeroing ZF,PF so that compare of NaN
  // values returns 'less than' result (CF is set).
  // Leave the rest of flags unchanged.
  //
  //    7 6 5 4 3 2 1 0
  //   |S|Z|r|A|r|P|r|C|  (r - reserved bit)
  //    0 0 1 0 1 0 1 1   (0x2B)
  //
  __ andq(Address(rsp, 0), 0xffffff2b);
  __ popf();
  __ bind(exit);
}

void emit_cmpfp3(MacroAssembler& _masm, Register dst) {
  Label done;
  __ movl(dst, -1);
  __ jcc(Assembler::parity, done);
  __ jcc(Assembler::below, done);
  __ setb(Assembler::notEqual, dst);
  __ movzbl(dst, dst);
  __ bind(done);
}

// Math.min()    # Math.max()
// --------------------------
// ucomis[s/d]   #
// ja   -> b     # a
// jp   -> NaN   # NaN
// jb   -> a     # b
// je            #
// |-jz -> a | b # a & b
// |    -> a     #
void emit_fp_min_max(MacroAssembler& _masm, XMMRegister dst,
                     XMMRegister a, XMMRegister b,
                     XMMRegister xmmt, Register rt,
                     bool min, bool single) {

  Label nan, zero, below, above, done;

  if (single)
    __ ucomiss(a, b);
  else
    __ ucomisd(a, b);

  if (dst->encoding() != (min ? b : a)->encoding())
    __ jccb(Assembler::above, above); // CF=0 & ZF=0
  else
    __ jccb(Assembler::above, done);

  __ jccb(Assembler::parity, nan);  // PF=1
  __ jccb(Assembler::below, below); // CF=1

  // equal
  __ vpxor(xmmt, xmmt, xmmt, Assembler::AVX_128bit);
  if (single) {
    __ ucomiss(a, xmmt);
    __ jccb(Assembler::equal, zero);

    __ movflt(dst, a);
    __ jmp(done);
  }
  else {
    __ ucomisd(a, xmmt);
    __ jccb(Assembler::equal, zero);

    __ movdbl(dst, a);
    __ jmp(done);
  }

  __ bind(zero);
  if (min)
    __ vpor(dst, a, b, Assembler::AVX_128bit);
  else
    __ vpand(dst, a, b, Assembler::AVX_128bit);

  __ jmp(done);

  __ bind(above);
  if (single)
    __ movflt(dst, min ? b : a);
  else
    __ movdbl(dst, min ? b : a);

  __ jmp(done);

  __ bind(nan);
  if (single) {
    __ movl(rt, 0x7fc00000); // Float.NaN
    __ movdl(dst, rt);
  }
  else {
    __ mov64(rt, 0x7ff8000000000000L); // Double.NaN
    __ movdq(dst, rt);
  }
  __ jmp(done);

  __ bind(below);
  if (single)
    __ movflt(dst, min ? a : b);
  else
    __ movdbl(dst, min ? a : b);

  __ bind(done);
}

//=============================================================================
const RegMask& MachConstantBaseNode::_out_RegMask = RegMask::Empty;

int Compile::ConstantTable::calculate_table_base_offset() const {
  return 0;  // absolute addressing, no offset
}

bool MachConstantBaseNode::requires_postalloc_expand() const { return false; }
void MachConstantBaseNode::postalloc_expand(GrowableArray <Node *> *nodes, PhaseRegAlloc *ra_) {
  ShouldNotReachHere();
}

void MachConstantBaseNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  // Empty encoding
}

uint MachConstantBaseNode::size(PhaseRegAlloc* ra_) const {
  return 0;
}

#ifndef PRODUCT
void MachConstantBaseNode::format(PhaseRegAlloc* ra_, outputStream* st) const {
  st->print("# MachConstantBaseNode (empty encoding)");
}
#endif


//=============================================================================
#ifndef PRODUCT
void MachPrologNode::format(PhaseRegAlloc* ra_, outputStream* st) const {
  Compile* C = ra_->C;

  int framesize = C->frame_size_in_bytes();
  int bangsize = C->bang_size_in_bytes();
  assert((framesize & (StackAlignmentInBytes-1)) == 0, "frame size not aligned");
  // Remove wordSize for return addr which is already pushed.
  framesize -= wordSize;

  if (C->need_stack_bang(bangsize)) {
    framesize -= wordSize;
    st->print("# stack bang (%d bytes)", bangsize);
    st->print("\n\t");
    st->print("pushq   rbp\t# Save rbp");
    if (PreserveFramePointer) {
        st->print("\n\t");
        st->print("movq    rbp, rsp\t# Save the caller's SP into rbp");
    }
    if (framesize) {
      st->print("\n\t");
      st->print("subq    rsp, #%d\t# Create frame",framesize);
    }
  } else {
    st->print("subq    rsp, #%d\t# Create frame",framesize);
    st->print("\n\t");
    framesize -= wordSize;
    st->print("movq    [rsp + #%d], rbp\t# Save rbp",framesize);
    if (PreserveFramePointer) {
      st->print("\n\t");
      st->print("movq    rbp, rsp\t# Save the caller's SP into rbp");
      if (framesize > 0) {
        st->print("\n\t");
        st->print("addq    rbp, #%d", framesize);
      }
    }
  }

  if (VerifyStackAtCalls) {
    st->print("\n\t");
    framesize -= wordSize;
    st->print("movq    [rsp + #%d], 0xbadb100d\t# Majik cookie for stack depth check",framesize);
#ifdef ASSERT
    st->print("\n\t");
    st->print("# stack alignment check");
#endif
  }
  st->cr();
}
#endif

void MachPrologNode::emit(CodeBuffer &cbuf, PhaseRegAlloc *ra_) const {
  Compile* C = ra_->C;
  MacroAssembler _masm(&cbuf);

  int framesize = C->frame_size_in_bytes();
  int bangsize = C->bang_size_in_bytes();

  __ verified_entry(framesize, C->need_stack_bang(bangsize)?bangsize:0, false);

  C->set_frame_complete(cbuf.insts_size());

  if (C->has_mach_constant_base_node()) {
    // NOTE: We set the table base offset here because users might be
    // emitted before MachConstantBaseNode.
    Compile::ConstantTable& constant_table = C->constant_table();
    constant_table.set_table_base_offset(constant_table.calculate_table_base_offset());
  }
}

uint MachPrologNode::size(PhaseRegAlloc* ra_) const
{
  return MachNode::size(ra_); // too many variables; just compute it
                              // the hard way
}

int MachPrologNode::reloc() const
{
  return 0; // a large enough number
}

//=============================================================================
#ifndef PRODUCT
void MachEpilogNode::format(PhaseRegAlloc* ra_, outputStream* st) const
{
  Compile* C = ra_->C;
  if (generate_vzeroupper(C)) {
    st->print("vzeroupper");
    st->cr(); st->print("\t");
  }

  int framesize = C->frame_size_in_bytes();
  assert((framesize & (StackAlignmentInBytes-1)) == 0, "frame size not aligned");
  // Remove word for return adr already pushed
  // and RBP
  framesize -= 2*wordSize;

  if (framesize) {
    st->print_cr("addq    rsp, %d\t# Destroy frame", framesize);
    st->print("\t");
  }

  st->print_cr("popq   rbp");
  if (do_polling() && C->is_method_compilation()) {
    st->print("\t");
    if (SafepointMechanism::uses_thread_local_poll()) {
      st->print_cr("movq   rscratch1, poll_offset[r15_thread] #polling_page_address\n\t"
                   "testl  rax, [rscratch1]\t"
                   "# Safepoint: poll for GC");
    } else if (Assembler::is_polling_page_far()) {
      st->print_cr("movq   rscratch1, #polling_page_address\n\t"
                   "testl  rax, [rscratch1]\t"
                   "# Safepoint: poll for GC");
    } else {
      st->print_cr("testl  rax, [rip + #offset_to_poll_page]\t"
                   "# Safepoint: poll for GC");
    }
  }
}
#endif

void MachEpilogNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const
{
  Compile* C = ra_->C;
  MacroAssembler _masm(&cbuf);

  if (generate_vzeroupper(C)) {
    // Clear upper bits of YMM registers when current compiled code uses
    // wide vectors to avoid AVX <-> SSE transition penalty during call.
    __ vzeroupper();
  }

  int framesize = C->frame_size_in_bytes();
  assert((framesize & (StackAlignmentInBytes-1)) == 0, "frame size not aligned");
  // Remove word for return adr already pushed
  // and RBP
  framesize -= 2*wordSize;

  // Note that VerifyStackAtCalls' Majik cookie does not change the frame size popped here

  if (framesize) {
    emit_opcode(cbuf, Assembler::REX_W);
    if (framesize < 0x80) {
      emit_opcode(cbuf, 0x83); // addq rsp, #framesize
      emit_rm(cbuf, 0x3, 0x00, RSP_enc);
      emit_d8(cbuf, framesize);
    } else {
      emit_opcode(cbuf, 0x81); // addq rsp, #framesize
      emit_rm(cbuf, 0x3, 0x00, RSP_enc);
      emit_d32(cbuf, framesize);
    }
  }

  // popq rbp
  emit_opcode(cbuf, 0x58 | RBP_enc);

  if (StackReservedPages > 0 && C->has_reserved_stack_access()) {
    __ reserved_stack_check();
  }

  if (do_polling() && C->is_method_compilation()) {
    MacroAssembler _masm(&cbuf);
    if (SafepointMechanism::uses_thread_local_poll()) {
      __ movq(rscratch1, Address(r15_thread, Thread::polling_page_offset()));
      __ relocate(relocInfo::poll_return_type);
      __ testl(rax, Address(rscratch1, 0));
    } else {
      AddressLiteral polling_page(os::get_polling_page(), relocInfo::poll_return_type);
      if (Assembler::is_polling_page_far()) {
        __ lea(rscratch1, polling_page);
        __ relocate(relocInfo::poll_return_type);
        __ testl(rax, Address(rscratch1, 0));
      } else {
        __ testl(rax, polling_page);
      }
    }
  }
}

uint MachEpilogNode::size(PhaseRegAlloc* ra_) const
{
  return MachNode::size(ra_); // too many variables; just compute it
                              // the hard way
}

int MachEpilogNode::reloc() const
{
  return 2; // a large enough number
}

const Pipeline* MachEpilogNode::pipeline() const
{
  return MachNode::pipeline_class();
}

int MachEpilogNode::safepoint_offset() const
{
  return 0;
}

//=============================================================================

enum RC {
  rc_bad,
  rc_int,
  rc_float,
  rc_stack
};

static enum RC rc_class(OptoReg::Name reg)
{
  if( !OptoReg::is_valid(reg)  ) return rc_bad;

  if (OptoReg::is_stack(reg)) return rc_stack;

  VMReg r = OptoReg::as_VMReg(reg);

  if (r->is_Register()) return rc_int;

  assert(r->is_XMMRegister(), "must be");
  return rc_float;
}

// Next two methods are shared by 32- and 64-bit VM. They are defined in x86.ad.
static int vec_mov_helper(CodeBuffer *cbuf, bool do_size, int src_lo, int dst_lo,
                          int src_hi, int dst_hi, uint ireg, outputStream* st);

static int vec_spill_helper(CodeBuffer *cbuf, bool do_size, bool is_load,
                            int stack_offset, int reg, uint ireg, outputStream* st);

static void vec_stack_to_stack_helper(CodeBuffer *cbuf, int src_offset,
                                      int dst_offset, uint ireg, outputStream* st) {
  if (cbuf) {
    MacroAssembler _masm(cbuf);
    switch (ireg) {
    case Op_VecS:
      __ movq(Address(rsp, -8), rax);
      __ movl(rax, Address(rsp, src_offset));
      __ movl(Address(rsp, dst_offset), rax);
      __ movq(rax, Address(rsp, -8));
      break;
    case Op_VecD:
      __ pushq(Address(rsp, src_offset));
      __ popq (Address(rsp, dst_offset));
      break;
    case Op_VecX:
      __ pushq(Address(rsp, src_offset));
      __ popq (Address(rsp, dst_offset));
      __ pushq(Address(rsp, src_offset+8));
      __ popq (Address(rsp, dst_offset+8));
      break;
    case Op_VecY:
      __ vmovdqu(Address(rsp, -32), xmm0);
      __ vmovdqu(xmm0, Address(rsp, src_offset));
      __ vmovdqu(Address(rsp, dst_offset), xmm0);
      __ vmovdqu(xmm0, Address(rsp, -32));
      break;
    case Op_VecZ:
      __ evmovdquq(Address(rsp, -64), xmm0, 2);
      __ evmovdquq(xmm0, Address(rsp, src_offset), 2);
      __ evmovdquq(Address(rsp, dst_offset), xmm0, 2);
      __ evmovdquq(xmm0, Address(rsp, -64), 2);
      break;
    default:
      ShouldNotReachHere();
    }
#ifndef PRODUCT
  } else {
    switch (ireg) {
    case Op_VecS:
      st->print("movq    [rsp - #8], rax\t# 32-bit mem-mem spill\n\t"
                "movl    rax, [rsp + #%d]\n\t"
                "movl    [rsp + #%d], rax\n\t"
                "movq    rax, [rsp - #8]",
                src_offset, dst_offset);
      break;
    case Op_VecD:
      st->print("pushq   [rsp + #%d]\t# 64-bit mem-mem spill\n\t"
                "popq    [rsp + #%d]",
                src_offset, dst_offset);
      break;
     case Op_VecX:
      st->print("pushq   [rsp + #%d]\t# 128-bit mem-mem spill\n\t"
                "popq    [rsp + #%d]\n\t"
                "pushq   [rsp + #%d]\n\t"
                "popq    [rsp + #%d]",
                src_offset, dst_offset, src_offset+8, dst_offset+8);
      break;
    case Op_VecY:
      st->print("vmovdqu [rsp - #32], xmm0\t# 256-bit mem-mem spill\n\t"
                "vmovdqu xmm0, [rsp + #%d]\n\t"
                "vmovdqu [rsp + #%d], xmm0\n\t"
                "vmovdqu xmm0, [rsp - #32]",
                src_offset, dst_offset);
      break;
    case Op_VecZ:
      st->print("vmovdqu [rsp - #64], xmm0\t# 512-bit mem-mem spill\n\t"
                "vmovdqu xmm0, [rsp + #%d]\n\t"
                "vmovdqu [rsp + #%d], xmm0\n\t"
                "vmovdqu xmm0, [rsp - #64]",
                src_offset, dst_offset);
      break;
    default:
      ShouldNotReachHere();
    }
#endif
  }
}

uint MachSpillCopyNode::implementation(CodeBuffer* cbuf,
                                       PhaseRegAlloc* ra_,
                                       bool do_size,
                                       outputStream* st) const {
  assert(cbuf != NULL || st  != NULL, "sanity");
  // Get registers to move
  OptoReg::Name src_second = ra_->get_reg_second(in(1));
  OptoReg::Name src_first = ra_->get_reg_first(in(1));
  OptoReg::Name dst_second = ra_->get_reg_second(this);
  OptoReg::Name dst_first = ra_->get_reg_first(this);

  enum RC src_second_rc = rc_class(src_second);
  enum RC src_first_rc = rc_class(src_first);
  enum RC dst_second_rc = rc_class(dst_second);
  enum RC dst_first_rc = rc_class(dst_first);

  assert(OptoReg::is_valid(src_first) && OptoReg::is_valid(dst_first),
         "must move at least 1 register" );

  if (src_first == dst_first && src_second == dst_second) {
    // Self copy, no move
    return 0;
  }
  if (bottom_type()->isa_vect() != NULL) {
    uint ireg = ideal_reg();
    assert((src_first_rc != rc_int && dst_first_rc != rc_int), "sanity");
    assert((ireg == Op_VecS || ireg == Op_VecD || ireg == Op_VecX || ireg == Op_VecY || ireg == Op_VecZ ), "sanity");
    if( src_first_rc == rc_stack && dst_first_rc == rc_stack ) {
      // mem -> mem
      int src_offset = ra_->reg2offset(src_first);
      int dst_offset = ra_->reg2offset(dst_first);
      vec_stack_to_stack_helper(cbuf, src_offset, dst_offset, ireg, st);
    } else if (src_first_rc == rc_float && dst_first_rc == rc_float ) {
      vec_mov_helper(cbuf, false, src_first, dst_first, src_second, dst_second, ireg, st);
    } else if (src_first_rc == rc_float && dst_first_rc == rc_stack ) {
      int stack_offset = ra_->reg2offset(dst_first);
      vec_spill_helper(cbuf, false, false, stack_offset, src_first, ireg, st);
    } else if (src_first_rc == rc_stack && dst_first_rc == rc_float ) {
      int stack_offset = ra_->reg2offset(src_first);
      vec_spill_helper(cbuf, false, true,  stack_offset, dst_first, ireg, st);
    } else {
      ShouldNotReachHere();
    }
    return 0;
  }
  if (src_first_rc == rc_stack) {
    // mem ->
    if (dst_first_rc == rc_stack) {
      // mem -> mem
      assert(src_second != dst_first, "overlap");
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        int src_offset = ra_->reg2offset(src_first);
        int dst_offset = ra_->reg2offset(dst_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ pushq(Address(rsp, src_offset));
          __ popq (Address(rsp, dst_offset));
#ifndef PRODUCT
        } else {
          st->print("pushq   [rsp + #%d]\t# 64-bit mem-mem spill\n\t"
                    "popq    [rsp + #%d]",
                     src_offset, dst_offset);
#endif
        }
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        // No pushl/popl, so:
        int src_offset = ra_->reg2offset(src_first);
        int dst_offset = ra_->reg2offset(dst_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movq(Address(rsp, -8), rax);
          __ movl(rax, Address(rsp, src_offset));
          __ movl(Address(rsp, dst_offset), rax);
          __ movq(rax, Address(rsp, -8));
#ifndef PRODUCT
        } else {
          st->print("movq    [rsp - #8], rax\t# 32-bit mem-mem spill\n\t"
                    "movl    rax, [rsp + #%d]\n\t"
                    "movl    [rsp + #%d], rax\n\t"
                    "movq    rax, [rsp - #8]",
                     src_offset, dst_offset);
#endif
        }
      }
      return 0;
    } else if (dst_first_rc == rc_int) {
      // mem -> gpr
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        int offset = ra_->reg2offset(src_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movq(as_Register(Matcher::_regEncode[dst_first]), Address(rsp, offset));
#ifndef PRODUCT
        } else {
          st->print("movq    %s, [rsp + #%d]\t# spill",
                     Matcher::regName[dst_first],
                     offset);
#endif
        }
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        int offset = ra_->reg2offset(src_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movl(as_Register(Matcher::_regEncode[dst_first]), Address(rsp, offset));
#ifndef PRODUCT
        } else {
          st->print("movl    %s, [rsp + #%d]\t# spill",
                     Matcher::regName[dst_first],
                     offset);
#endif
        }
      }
      return 0;
    } else if (dst_first_rc == rc_float) {
      // mem-> xmm
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        int offset = ra_->reg2offset(src_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movdbl( as_XMMRegister(Matcher::_regEncode[dst_first]), Address(rsp, offset));
#ifndef PRODUCT
        } else {
          st->print("%s  %s, [rsp + #%d]\t# spill",
                     UseXmmLoadAndClearUpper ? "movsd " : "movlpd",
                     Matcher::regName[dst_first],
                     offset);
#endif
        }
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        int offset = ra_->reg2offset(src_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movflt( as_XMMRegister(Matcher::_regEncode[dst_first]), Address(rsp, offset));
#ifndef PRODUCT
        } else {
          st->print("movss   %s, [rsp + #%d]\t# spill",
                     Matcher::regName[dst_first],
                     offset);
#endif
        }
      }
      return 0;
    }
  } else if (src_first_rc == rc_int) {
    // gpr ->
    if (dst_first_rc == rc_stack) {
      // gpr -> mem
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        int offset = ra_->reg2offset(dst_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movq(Address(rsp, offset), as_Register(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movq    [rsp + #%d], %s\t# spill",
                     offset,
                     Matcher::regName[src_first]);
#endif
        }
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        int offset = ra_->reg2offset(dst_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movl(Address(rsp, offset), as_Register(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movl    [rsp + #%d], %s\t# spill",
                     offset,
                     Matcher::regName[src_first]);
#endif
        }
      }
      return 0;
    } else if (dst_first_rc == rc_int) {
      // gpr -> gpr
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movq(as_Register(Matcher::_regEncode[dst_first]),
                  as_Register(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movq    %s, %s\t# spill",
                     Matcher::regName[dst_first],
                     Matcher::regName[src_first]);
#endif
        }
        return 0;
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movl(as_Register(Matcher::_regEncode[dst_first]),
                  as_Register(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movl    %s, %s\t# spill",
                     Matcher::regName[dst_first],
                     Matcher::regName[src_first]);
#endif
        }
        return 0;
      }
    } else if (dst_first_rc == rc_float) {
      // gpr -> xmm
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movdq( as_XMMRegister(Matcher::_regEncode[dst_first]), as_Register(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movdq   %s, %s\t# spill",
                     Matcher::regName[dst_first],
                     Matcher::regName[src_first]);
#endif
        }
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movdl( as_XMMRegister(Matcher::_regEncode[dst_first]), as_Register(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movdl   %s, %s\t# spill",
                     Matcher::regName[dst_first],
                     Matcher::regName[src_first]);
#endif
        }
      }
      return 0;
    }
  } else if (src_first_rc == rc_float) {
    // xmm ->
    if (dst_first_rc == rc_stack) {
      // xmm -> mem
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        int offset = ra_->reg2offset(dst_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movdbl( Address(rsp, offset), as_XMMRegister(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movsd   [rsp + #%d], %s\t# spill",
                     offset,
                     Matcher::regName[src_first]);
#endif
        }
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        int offset = ra_->reg2offset(dst_first);
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movflt(Address(rsp, offset), as_XMMRegister(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movss   [rsp + #%d], %s\t# spill",
                     offset,
                     Matcher::regName[src_first]);
#endif
        }
      }
      return 0;
    } else if (dst_first_rc == rc_int) {
      // xmm -> gpr
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movdq( as_Register(Matcher::_regEncode[dst_first]), as_XMMRegister(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movdq   %s, %s\t# spill",
                     Matcher::regName[dst_first],
                     Matcher::regName[src_first]);
#endif
        }
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movdl( as_Register(Matcher::_regEncode[dst_first]), as_XMMRegister(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("movdl   %s, %s\t# spill",
                     Matcher::regName[dst_first],
                     Matcher::regName[src_first]);
#endif
        }
      }
      return 0;
    } else if (dst_first_rc == rc_float) {
      // xmm -> xmm
      if ((src_first & 1) == 0 && src_first + 1 == src_second &&
          (dst_first & 1) == 0 && dst_first + 1 == dst_second) {
        // 64-bit
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movdbl( as_XMMRegister(Matcher::_regEncode[dst_first]), as_XMMRegister(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("%s  %s, %s\t# spill",
                     UseXmmRegToRegMoveAll ? "movapd" : "movsd ",
                     Matcher::regName[dst_first],
                     Matcher::regName[src_first]);
#endif
        }
      } else {
        // 32-bit
        assert(!((src_first & 1) == 0 && src_first + 1 == src_second), "no transform");
        assert(!((dst_first & 1) == 0 && dst_first + 1 == dst_second), "no transform");
        if (cbuf) {
          MacroAssembler _masm(cbuf);
          __ movflt( as_XMMRegister(Matcher::_regEncode[dst_first]), as_XMMRegister(Matcher::_regEncode[src_first]));
#ifndef PRODUCT
        } else {
          st->print("%s  %s, %s\t# spill",
                     UseXmmRegToRegMoveAll ? "movaps" : "movss ",
                     Matcher::regName[dst_first],
                     Matcher::regName[src_first]);
#endif
        }
      }
      return 0;
    }
  }

  assert(0," foo ");
  Unimplemented();
  return 0;
}

#ifndef PRODUCT
void MachSpillCopyNode::format(PhaseRegAlloc *ra_, outputStream* st) const {
  implementation(NULL, ra_, false, st);
}
#endif

void MachSpillCopyNode::emit(CodeBuffer &cbuf, PhaseRegAlloc *ra_) const {
  implementation(&cbuf, ra_, false, NULL);
}

uint MachSpillCopyNode::size(PhaseRegAlloc *ra_) const {
  return MachNode::size(ra_);
}

//=============================================================================
#ifndef PRODUCT
void BoxLockNode::format(PhaseRegAlloc* ra_, outputStream* st) const
{
  int offset = ra_->reg2offset(in_RegMask(0).find_first_elem());
  int reg = ra_->get_reg_first(this);
  st->print("leaq    %s, [rsp + #%d]\t# box lock",
            Matcher::regName[reg], offset);
}
#endif

void BoxLockNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const
{
  int offset = ra_->reg2offset(in_RegMask(0).find_first_elem());
  int reg = ra_->get_encode(this);
  if (offset >= 0x80) {
    emit_opcode(cbuf, reg < 8 ? Assembler::REX_W : Assembler::REX_WR);
    emit_opcode(cbuf, 0x8D); // LEA  reg,[SP+offset]
    emit_rm(cbuf, 0x2, reg & 7, 0x04);
    emit_rm(cbuf, 0x0, 0x04, RSP_enc);
    emit_d32(cbuf, offset);
  } else {
    emit_opcode(cbuf, reg < 8 ? Assembler::REX_W : Assembler::REX_WR);
    emit_opcode(cbuf, 0x8D); // LEA  reg,[SP+offset]
    emit_rm(cbuf, 0x1, reg & 7, 0x04);
    emit_rm(cbuf, 0x0, 0x04, RSP_enc);
    emit_d8(cbuf, offset);
  }
}

uint BoxLockNode::size(PhaseRegAlloc *ra_) const
{
  int offset = ra_->reg2offset(in_RegMask(0).find_first_elem());
  return (offset < 0x80) ? 5 : 8; // REX
}

//=============================================================================
#ifndef PRODUCT
void MachUEPNode::format(PhaseRegAlloc* ra_, outputStream* st) const
{
  if (UseCompressedClassPointers) {
    st->print_cr("movl    rscratch1, [j_rarg0 + oopDesc::klass_offset_in_bytes()]\t# compressed klass");
    st->print_cr("\tdecode_klass_not_null rscratch1, rscratch1");
    st->print_cr("\tcmpq    rax, rscratch1\t # Inline cache check");
  } else {
    st->print_cr("\tcmpq    rax, [j_rarg0 + oopDesc::klass_offset_in_bytes()]\t"
                 "# Inline cache check");
  }
  st->print_cr("\tjne     SharedRuntime::_ic_miss_stub");
  st->print_cr("\tnop\t# nops to align entry point");
}
#endif

void MachUEPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const
{
  MacroAssembler masm(&cbuf);
  uint insts_size = cbuf.insts_size();
  if (UseCompressedClassPointers) {
    masm.load_klass(rscratch1, j_rarg0);
    masm.cmpptr(rax, rscratch1);
  } else {
    masm.cmpptr(rax, Address(j_rarg0, oopDesc::klass_offset_in_bytes()));
  }

  masm.jump_cc(Assembler::notEqual, RuntimeAddress(SharedRuntime::get_ic_miss_stub()));

  /* WARNING these NOPs are critical so that verified entry point is properly
     4 bytes aligned for patching by NativeJump::patch_verified_entry() */
  int nops_cnt = 4 - ((cbuf.insts_size() - insts_size) & 0x3);
  if (OptoBreakpoint) {
    // Leave space for int3
    nops_cnt -= 1;
  }
  nops_cnt &= 0x3; // Do not add nops if code is aligned.
  if (nops_cnt > 0)
    masm.nop(nops_cnt);
}

uint MachUEPNode::size(PhaseRegAlloc* ra_) const
{
  return MachNode::size(ra_); // too many variables; just compute it
                              // the hard way
}


//=============================================================================

int Matcher::regnum_to_fpu_offset(int regnum)
{
  return regnum - 32; // The FP registers are in the second chunk
}

// This is UltraSparc specific, true just means we have fast l2f conversion
const bool Matcher::convL2FSupported(void) {
  return true;
}

// Is this branch offset short enough that a short branch can be used?
//
// NOTE: If the platform does not provide any short branch variants, then
//       this method should return false for offset 0.
bool Matcher::is_short_branch_offset(int rule, int br_size, int offset) {
  // The passed offset is relative to address of the branch.
  // On 86 a branch displacement is calculated relative to address
  // of a next instruction.
  offset -= br_size;

  // the short version of jmpConUCF2 contains multiple branches,
  // making the reach slightly less
  if (rule == jmpConUCF2_rule)
    return (-126 <= offset && offset <= 125);
  return (-128 <= offset && offset <= 127);
}

const bool Matcher::isSimpleConstant64(jlong value) {
  // Will one (StoreL ConL) be cheaper than two (StoreI ConI)?.
  //return value == (int) value;  // Cf. storeImmL and immL32.

  // Probably always true, even if a temp register is required.
  return true;
}

// The ecx parameter to rep stosq for the ClearArray node is in words.
const bool Matcher::init_array_count_is_in_bytes = false;

// No additional cost for CMOVL.
const int Matcher::long_cmove_cost() { return 0; }

// No CMOVF/CMOVD with SSE2
const int Matcher::float_cmove_cost() { return ConditionalMoveLimit; }

// Does the CPU require late expand (see block.cpp for description of late expand)?
const bool Matcher::require_postalloc_expand = false;

// Do we need to mask the count passed to shift instructions or does
// the cpu only look at the lower 5/6 bits anyway?
const bool Matcher::need_masked_shift_count = false;

bool Matcher::narrow_oop_use_complex_address() {
  assert(UseCompressedOops, "only for compressed oops code");
  return (LogMinObjAlignmentInBytes <= 3);
}

bool Matcher::narrow_klass_use_complex_address() {
  assert(UseCompressedClassPointers, "only for compressed klass code");
  return (LogKlassAlignmentInBytes <= 3);
}

bool Matcher::const_oop_prefer_decode() {
  // Prefer ConN+DecodeN over ConP.
  return true;
}

bool Matcher::const_klass_prefer_decode() {
  // TODO: Either support matching DecodeNKlass (heap-based) in operand
  //       or condisider the following:
  // Prefer ConNKlass+DecodeNKlass over ConP in simple compressed klass mode.
  //return Universe::narrow_klass_base() == NULL;
  return true;
}

// Is it better to copy float constants, or load them directly from
// memory?  Intel can load a float constant from a direct address,
// requiring no extra registers.  Most RISCs will have to materialize
// an address into a register first, so they would do better to copy
// the constant from stack.
const bool Matcher::rematerialize_float_constants = true; // XXX

// If CPU can load and store mis-aligned doubles directly then no
// fixup is needed.  Else we split the double into 2 integer pieces
// and move it piece-by-piece.  Only happens when passing doubles into
// C code as the Java calling convention forces doubles to be aligned.
const bool Matcher::misaligned_doubles_ok = true;

// No-op on amd64
void Matcher::pd_implicit_null_fixup(MachNode *node, uint idx) {}

// Advertise here if the CPU requires explicit rounding operations to
// implement the UseStrictFP mode.
const bool Matcher::strict_fp_requires_explicit_rounding = true;

// Are floats conerted to double when stored to stack during deoptimization?
// On x64 it is stored without convertion so we can use normal access.
bool Matcher::float_in_double() { return false; }

// Do ints take an entire long register or just half?
const bool Matcher::int_in_long = true;

// Return whether or not this register is ever used as an argument.
// This function is used on startup to build the trampoline stubs in
// generateOptoStub.  Registers not mentioned will be killed by the VM
// call in the trampoline, and arguments in those registers not be
// available to the callee.
bool Matcher::can_be_java_arg(int reg)
{
  return
    reg ==  RDI_num || reg == RDI_H_num ||
    reg ==  RSI_num || reg == RSI_H_num ||
    reg ==  RDX_num || reg == RDX_H_num ||
    reg ==  RCX_num || reg == RCX_H_num ||
    reg ==   R8_num || reg ==  R8_H_num ||
    reg ==   R9_num || reg ==  R9_H_num ||
    reg ==  R12_num || reg == R12_H_num ||
    reg == XMM0_num || reg == XMM0b_num ||
    reg == XMM1_num || reg == XMM1b_num ||
    reg == XMM2_num || reg == XMM2b_num ||
    reg == XMM3_num || reg == XMM3b_num ||
    reg == XMM4_num || reg == XMM4b_num ||
    reg == XMM5_num || reg == XMM5b_num ||
    reg == XMM6_num || reg == XMM6b_num ||
    reg == XMM7_num || reg == XMM7b_num;
}

bool Matcher::is_spillable_arg(int reg)
{
  return can_be_java_arg(reg);
}

bool Matcher::use_asm_for_ldiv_by_con( jlong divisor ) {
  // In 64 bit mode a code which use multiply when
  // devisor is constant is faster than hardware
  // DIV instruction (it uses MulHiL).
  return false;
}

// Register for DIVI projection of divmodI
RegMask Matcher::divI_proj_mask() {
  return INT_RAX_REG_mask();
}

// Register for MODI projection of divmodI
RegMask Matcher::modI_proj_mask() {
  return INT_RDX_REG_mask();
}

// Register for DIVL projection of divmodL
RegMask Matcher::divL_proj_mask() {
  return LONG_RAX_REG_mask();
}

// Register for MODL projection of divmodL
RegMask Matcher::modL_proj_mask() {
  return LONG_RDX_REG_mask();
}

// Register for saving SP into on method handle invokes. Not used on x86_64.
const RegMask Matcher::method_handle_invoke_SP_save_mask() {
    return NO_REG_mask();
}


#line 1386 "ad_x86.cpp"


//SourceForm

#line 1312 "src/hotspot/cpu/x86/x86.ad"


#include "opto/addnode.hpp"

// Emit exception handler code.
// Stuff framesize into a register and call a VM stub routine.
int HandlerImpl::emit_exception_handler(CodeBuffer& cbuf) {

  // Note that the code buffer's insts_mark is always relative to insts.
  // That's why we must use the macroassembler to generate a handler.
  MacroAssembler _masm(&cbuf);
  address base = __ start_a_stub(size_exception_handler());
  if (base == NULL) {
    ciEnv::current()->record_failure("CodeCache is full");
    return 0;  // CodeBuffer::expand failed
  }
  int offset = __ offset();
  __ jump(RuntimeAddress(OptoRuntime::exception_blob()->entry_point()));
  assert(__ offset() - offset <= (int) size_exception_handler(), "overflow");
  __ end_a_stub();
  return offset;
}

// Emit deopt handler code.
int HandlerImpl::emit_deopt_handler(CodeBuffer& cbuf) {

  // Note that the code buffer's insts_mark is always relative to insts.
  // That's why we must use the macroassembler to generate a handler.
  MacroAssembler _masm(&cbuf);
  address base = __ start_a_stub(size_deopt_handler());
  if (base == NULL) {
    ciEnv::current()->record_failure("CodeCache is full");
    return 0;  // CodeBuffer::expand failed
  }
  int offset = __ offset();

#ifdef _LP64
  address the_pc = (address) __ pc();
  Label next;
  // push a "the_pc" on the stack without destroying any registers
  // as they all may be live.

  // push address of "next"
  __ call(next, relocInfo::none); // reloc none is fine since it is a disp32
  __ bind(next);
  // adjust it so it matches "the_pc"
  __ subptr(Address(rsp, 0), __ offset() - offset);
#else
  InternalAddress here(__ pc());
  __ pushptr(here.addr());
#endif

  __ jump(RuntimeAddress(SharedRuntime::deopt_blob()->unpack()));
  assert(__ offset() - offset <= (int) size_deopt_handler(), "overflow");
  __ end_a_stub();
  return offset;
}


//=============================================================================

  // Float masks come from different places depending on platform.
#ifdef _LP64
  static address float_signmask()  { return StubRoutines::x86::float_sign_mask(); }
  static address float_signflip()  { return StubRoutines::x86::float_sign_flip(); }
  static address double_signmask() { return StubRoutines::x86::double_sign_mask(); }
  static address double_signflip() { return StubRoutines::x86::double_sign_flip(); }
#else
  static address float_signmask()  { return (address)float_signmask_pool; }
  static address float_signflip()  { return (address)float_signflip_pool; }
  static address double_signmask() { return (address)double_signmask_pool; }
  static address double_signflip() { return (address)double_signflip_pool; }
#endif
  static address vector_short_to_byte_mask() { return StubRoutines::x86::vector_short_to_byte_mask(); }
  static address vector_byte_perm_mask() { return StubRoutines::x86::vector_byte_perm_mask(); }
  static address vector_long_sign_mask() { return StubRoutines::x86::vector_long_sign_mask(); }

//=============================================================================
const bool Matcher::match_rule_supported(int opcode) {
  if (!has_match_rule(opcode))
    return false;

  bool ret_value = true;
  switch (opcode) {
    case Op_AbsVL:
      if (UseAVX < 3)
        ret_value = false;
    case Op_PopCountI:
    case Op_PopCountL:
      if (!UsePopCountInstruction)
        ret_value = false;
      break;
    case Op_PopCountVI:
      if (!UsePopCountInstruction || !VM_Version::supports_vpopcntdq())
        ret_value = false;
      break;
    case Op_MulVI:
      if ((UseSSE < 4) && (UseAVX < 1)) // only with SSE4_1 or AVX
        ret_value = false;
      break;
    case Op_MulVL:
    case Op_MulReductionVL:
      if (VM_Version::supports_avx512dq() == false)
        ret_value = false;
      break;
    case Op_AddReductionVL:
      if (UseAVX < 3) // only EVEX : vector connectivity becomes an issue here
        ret_value = false;
      break;
    case Op_AbsVB:
    case Op_AbsVS:
    case Op_AbsVI:
    case Op_AddReductionVI:
      if (UseSSE < 3 || !VM_Version::supports_ssse3()) // requires at least SSSE3
        ret_value = false;
      break;
    case Op_MulReductionVI:
      if (UseSSE < 4) // requires at least SSE4
        ret_value = false;
      break;
    case Op_AddReductionVF:
    case Op_AddReductionVD:
    case Op_MulReductionVF:
    case Op_MulReductionVD:
      if (UseSSE < 1) // requires at least SSE
        ret_value = false;
      break;
    case Op_SqrtVD:
    case Op_SqrtVF:
      if (UseAVX < 1) // enabled for AVX only
        ret_value = false;
      break;
    case Op_CompareAndSwapL:
#ifdef _LP64
    case Op_CompareAndSwapP:
#endif
      if (!VM_Version::supports_cx8())
        ret_value = false;
      break;
    case Op_CMoveVF:
    case Op_CMoveVD:
      if (UseAVX < 1 || UseAVX > 2)
        ret_value = false;
      break;
    case Op_StrIndexOf:
      if (!UseSSE42Intrinsics)
        ret_value = false;
      break;
    case Op_StrIndexOfChar:
      if (!UseSSE42Intrinsics)
        ret_value = false;
      break;
    case Op_OnSpinWait:
      if (VM_Version::supports_on_spin_wait() == false)
        ret_value = false;
      break;
    case Op_RShiftVL:
    case Op_AbsVD:
    case Op_NegVD:
      if (UseSSE < 2)
        ret_value = false;
      break;
    case Op_MulVB:
    case Op_LShiftVB:
    case Op_RShiftVB:
    case Op_URShiftVB:
      if (UseSSE < 4)
        ret_value = false;
      break;
#ifdef _LP64
    case Op_MaxD:
    case Op_MaxF:
    case Op_MinD:
    case Op_MinF:
      if (UseAVX < 1) // enabled for AVX only
        ret_value = false;
      break;
#endif
    case Op_RoundDoubleMode:
      if (UseSSE < 4)
        ret_value = false;
      break;
    case Op_SqrtF:
      if (UseSSE < 1) {
        return false;
      }
      break;
    case Op_SqrtD:
#ifdef _LP64
      if (UseSSE < 2) {
        return false;
      }
#else
      // x86_32.ad has a special match rule for SqrtD.
      // Together with common x86 rules, this handles all UseSSE cases.
#endif
      break;
  }

  return ret_value;  // Per default match rules are supported.
}

const bool Matcher::match_rule_supported_vector(int opcode, int vlen) {
  // identify extra cases that we might want to provide match rules for
  // e.g. Op_ vector nodes and other intrinsics while guarding with vlen
  bool ret_value = match_rule_supported(opcode);
  if (ret_value) {
    switch (opcode) {
      case Op_AbsVB:
      case Op_AddVB:
      case Op_SubVB:
        if ((vlen == 64) && (VM_Version::supports_avx512bw() == false))
          ret_value = false;
        break;
      case Op_AbsVS:
      case Op_AddVS:
      case Op_SubVS:
      case Op_MulVS:
      case Op_LShiftVS:
      case Op_RShiftVS:
      case Op_URShiftVS:
        if ((vlen == 32) && (VM_Version::supports_avx512bw() == false))
          ret_value = false;
        break;
      case Op_MulVB:
      case Op_LShiftVB:
      case Op_RShiftVB:
      case Op_URShiftVB:
        if ((vlen == 32 && UseAVX < 2) || 
            ((vlen == 64) && (VM_Version::supports_avx512bw() == false)))
          ret_value = false;
        break;
      case Op_NegVF:
        if ((vlen == 16) && (VM_Version::supports_avx512dq() == false))
          ret_value = false;
        break;
      case Op_CMoveVF:
        if (vlen != 8)
          ret_value  = false;
        break;
      case Op_NegVD:
        if ((vlen == 8) && (VM_Version::supports_avx512dq() == false))
          ret_value = false;
        break;
      case Op_CMoveVD:
        if (vlen != 4)
          ret_value  = false;
        break;
      case Op_RoundDoubleModeV:
        if (VM_Version::supports_avx() == false)
          ret_value = false;
        break;
    }
  }

  return ret_value;  // Per default match rules are supported.
}

const bool Matcher::has_predicated_vectors(void) {
  bool ret_value = false;
  if (UseAVX > 2) {
    ret_value = VM_Version::supports_avx512vl();
  }

  return ret_value;
}

const int Matcher::float_pressure(int default_pressure_threshold) {
  int float_pressure_threshold = default_pressure_threshold;
#ifdef _LP64
  if (UseAVX > 2) {
    // Increase pressure threshold on machines with AVX3 which have
    // 2x more XMM registers.
    float_pressure_threshold = default_pressure_threshold * 2;
  }
#endif
  return float_pressure_threshold;
}

// Max vector size in bytes. 0 if not supported.
const int Matcher::vector_width_in_bytes(BasicType bt) {
  assert(is_java_primitive(bt), "only primitive type vectors");
  if (UseSSE < 2) return 0;
  // SSE2 supports 128bit vectors for all types.
  // AVX2 supports 256bit vectors for all types.
  // AVX2/EVEX supports 512bit vectors for all types.
  int size = (UseAVX > 1) ? (1 << UseAVX) * 8 : 16;
  // AVX1 supports 256bit vectors only for FLOAT and DOUBLE.
  if (UseAVX > 0 && (bt == T_FLOAT || bt == T_DOUBLE))
    size = (UseAVX > 2) ? 64 : 32;
  if (UseAVX > 2 && (bt == T_BYTE || bt == T_SHORT || bt == T_CHAR))
    size = (VM_Version::supports_avx512bw()) ? 64 : 32;
  // Use flag to limit vector size.
  size = MIN2(size,(int)MaxVectorSize);
  // Minimum 2 values in vector (or 4 for bytes).
  switch (bt) {
  case T_DOUBLE:
  case T_LONG:
    if (size < 16) return 0;
    break;
  case T_FLOAT:
  case T_INT:
    if (size < 8) return 0;
    break;
  case T_BOOLEAN:
    if (size < 4) return 0;
    break;
  case T_CHAR:
    if (size < 4) return 0;
    break;
  case T_BYTE:
    if (size < 4) return 0;
    break;
  case T_SHORT:
    if (size < 4) return 0;
    break;
  default:
    ShouldNotReachHere();
  }
  return size;
}

// Limits on vector size (number of elements) loaded into vector.
const int Matcher::max_vector_size(const BasicType bt) {
  return vector_width_in_bytes(bt)/type2aelembytes(bt);
}
const int Matcher::min_vector_size(const BasicType bt) {
  int max_size = max_vector_size(bt);
  // Min size which can be loaded into vector is 4 bytes.
  int size = (type2aelembytes(bt) == 1) ? 4 : 2;
  return MIN2(size,max_size);
}

// Vector ideal reg corresponding to specified size in bytes
const uint Matcher::vector_ideal_reg(int size) {
  assert(MaxVectorSize >= size, "");
  switch(size) {
    case  4: return Op_VecS;
    case  8: return Op_VecD;
    case 16: return Op_VecX;
    case 32: return Op_VecY;
    case 64: return Op_VecZ;
  }
  ShouldNotReachHere();
  return 0;
}

// Only lowest bits of xmm reg are used for vector shift count.
const uint Matcher::vector_shift_count_ideal_reg(int size) {
  return Op_VecS;
}

// x86 supports misaligned vectors store/load.
const bool Matcher::misaligned_vectors_ok() {
  return true;
}

// x86 AES instructions are compatible with SunJCE expanded
// keys, hence we do not need to pass the original key to stubs
const bool Matcher::pass_original_key_for_aes() {
  return false;
}


const bool Matcher::convi2l_type_required = true;

// Check for shift by small constant as well
static bool clone_shift(Node* shift, Matcher* matcher, Matcher::MStack& mstack, VectorSet& address_visited) {
  if (shift->Opcode() == Op_LShiftX && shift->in(2)->is_Con() &&
      shift->in(2)->get_int() <= 3 &&
      // Are there other uses besides address expressions?
      !matcher->is_visited(shift)) {
    address_visited.set(shift->_idx); // Flag as address_visited
    mstack.push(shift->in(2), Matcher::Visit);
    Node *conv = shift->in(1);
#ifdef _LP64
    // Allow Matcher to match the rule which bypass
    // ConvI2L operation for an array index on LP64
    // if the index value is positive.
    if (conv->Opcode() == Op_ConvI2L &&
        conv->as_Type()->type()->is_long()->_lo >= 0 &&
        // Are there other uses besides address expressions?
        !matcher->is_visited(conv)) {
      address_visited.set(conv->_idx); // Flag as address_visited
      mstack.push(conv->in(1), Matcher::Pre_Visit);
    } else
#endif
      mstack.push(conv, Matcher::Pre_Visit);
    return true;
  }
  return false;
}

// Should the Matcher clone shifts on addressing modes, expecting them
// to be subsumed into complex addressing expressions or compute them
// into registers?
bool Matcher::clone_address_expressions(AddPNode* m, Matcher::MStack& mstack, VectorSet& address_visited) {
  Node *off = m->in(AddPNode::Offset);
  if (off->is_Con()) {
    address_visited.test_set(m->_idx); // Flag as address_visited
    Node *adr = m->in(AddPNode::Address);

    // Intel can handle 2 adds in addressing mode
    // AtomicAdd is not an addressing expression.
    // Cheap to find it by looking for screwy base.
    if (adr->is_AddP() &&
        !adr->in(AddPNode::Base)->is_top() &&
        LP64_ONLY( off->get_long() == (int) (off->get_long()) && ) // immL32
        // Are there other uses besides address expressions?
        !is_visited(adr)) {
      address_visited.set(adr->_idx); // Flag as address_visited
      Node *shift = adr->in(AddPNode::Offset);
      if (!clone_shift(shift, this, mstack, address_visited)) {
        mstack.push(shift, Pre_Visit);
      }
      mstack.push(adr->in(AddPNode::Address), Pre_Visit);
      mstack.push(adr->in(AddPNode::Base), Pre_Visit);
    } else {
      mstack.push(adr, Pre_Visit);
    }

    // Clone X+offset as it also folds into most addressing expressions
    mstack.push(off, Visit);
    mstack.push(m->in(AddPNode::Base), Pre_Visit);
    return true;
  } else if (clone_shift(off, this, mstack, address_visited)) {
    address_visited.test_set(m->_idx); // Flag as address_visited
    mstack.push(m->in(AddPNode::Address), Pre_Visit);
    mstack.push(m->in(AddPNode::Base), Pre_Visit);
    return true;
  }
  return false;
}

void Compile::reshape_address(AddPNode* addp) {
}

// Helper methods for MachSpillCopyNode::implementation().
static int vec_mov_helper(CodeBuffer *cbuf, bool do_size, int src_lo, int dst_lo,
                          int src_hi, int dst_hi, uint ireg, outputStream* st) {
  // In 64-bit VM size calculation is very complex. Emitting instructions
  // into scratch buffer is used to get size in 64-bit VM.
  LP64_ONLY( assert(!do_size, "this method calculates size only for 32-bit VM"); )
  assert(ireg == Op_VecS || // 32bit vector
         (src_lo & 1) == 0 && (src_lo + 1) == src_hi &&
         (dst_lo & 1) == 0 && (dst_lo + 1) == dst_hi,
         "no non-adjacent vector moves" );
  if (cbuf) {
    MacroAssembler _masm(cbuf);
    int offset = __ offset();
    switch (ireg) {
    case Op_VecS: // copy whole register
    case Op_VecD:
    case Op_VecX:
#ifndef _LP64
      __ movdqu(as_XMMRegister(Matcher::_regEncode[dst_lo]), as_XMMRegister(Matcher::_regEncode[src_lo]));
#else
      if ((UseAVX < 3) || VM_Version::supports_avx512vl()) {
        __ movdqu(as_XMMRegister(Matcher::_regEncode[dst_lo]), as_XMMRegister(Matcher::_regEncode[src_lo]));
      } else {
        __ vextractf32x4(as_XMMRegister(Matcher::_regEncode[dst_lo]), as_XMMRegister(Matcher::_regEncode[src_lo]), 0x0);
     }
#endif
      break;
    case Op_VecY:
#ifndef _LP64
      __ vmovdqu(as_XMMRegister(Matcher::_regEncode[dst_lo]), as_XMMRegister(Matcher::_regEncode[src_lo]));
#else
      if ((UseAVX < 3) || VM_Version::supports_avx512vl()) {
        __ vmovdqu(as_XMMRegister(Matcher::_regEncode[dst_lo]), as_XMMRegister(Matcher::_regEncode[src_lo]));
      } else {
        __ vextractf64x4(as_XMMRegister(Matcher::_regEncode[dst_lo]), as_XMMRegister(Matcher::_regEncode[src_lo]), 0x0);
     }
#endif
      break;
    case Op_VecZ:
      __ evmovdquq(as_XMMRegister(Matcher::_regEncode[dst_lo]), as_XMMRegister(Matcher::_regEncode[src_lo]), 2);
      break;
    default:
      ShouldNotReachHere();
    }
    int size = __ offset() - offset;
#ifdef ASSERT
    // VEX_2bytes prefix is used if UseAVX > 0, so it takes the same 2 bytes as SIMD prefix.
    assert(!do_size || size == 4, "incorrect size calculattion");
#endif
    return size;
#ifndef PRODUCT
  } else if (!do_size) {
    switch (ireg) {
    case Op_VecS:
    case Op_VecD:
    case Op_VecX:
      st->print("movdqu  %s,%s\t# spill",Matcher::regName[dst_lo],Matcher::regName[src_lo]);
      break;
    case Op_VecY:
    case Op_VecZ:
      st->print("vmovdqu %s,%s\t# spill",Matcher::regName[dst_lo],Matcher::regName[src_lo]);
      break;
    default:
      ShouldNotReachHere();
    }
#endif
  }
  // VEX_2bytes prefix is used if UseAVX > 0, and it takes the same 2 bytes as SIMD prefix.
  return (UseAVX > 2) ? 6 : 4;
}

static int vec_spill_helper(CodeBuffer *cbuf, bool do_size, bool is_load,
                            int stack_offset, int reg, uint ireg, outputStream* st) {
  // In 64-bit VM size calculation is very complex. Emitting instructions
  // into scratch buffer is used to get size in 64-bit VM.
  LP64_ONLY( assert(!do_size, "this method calculates size only for 32-bit VM"); )
  if (cbuf) {
    MacroAssembler _masm(cbuf);
    int offset = __ offset();
    if (is_load) {
      switch (ireg) {
      case Op_VecS:
        __ movdl(as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset));
        break;
      case Op_VecD:
        __ movq(as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset));
        break;
      case Op_VecX:
#ifndef _LP64
        __ movdqu(as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset));
#else
        if ((UseAVX < 3) || VM_Version::supports_avx512vl()) {
          __ movdqu(as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset));
        } else {
          __ vpxor(as_XMMRegister(Matcher::_regEncode[reg]), as_XMMRegister(Matcher::_regEncode[reg]), as_XMMRegister(Matcher::_regEncode[reg]), 2);
          __ vinsertf32x4(as_XMMRegister(Matcher::_regEncode[reg]), as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset),0x0);
        }
#endif
        break;
      case Op_VecY:
#ifndef _LP64
        __ vmovdqu(as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset));
#else
        if ((UseAVX < 3) || VM_Version::supports_avx512vl()) {
          __ vmovdqu(as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset));
        } else {
          __ vpxor(as_XMMRegister(Matcher::_regEncode[reg]), as_XMMRegister(Matcher::_regEncode[reg]), as_XMMRegister(Matcher::_regEncode[reg]), 2);
          __ vinsertf64x4(as_XMMRegister(Matcher::_regEncode[reg]), as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset),0x0);
        }
#endif
        break;
      case Op_VecZ:
        __ evmovdquq(as_XMMRegister(Matcher::_regEncode[reg]), Address(rsp, stack_offset), 2);
        break;
      default:
        ShouldNotReachHere();
      }
    } else { // store
      switch (ireg) {
      case Op_VecS:
        __ movdl(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]));
        break;
      case Op_VecD:
        __ movq(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]));
        break;
      case Op_VecX:
#ifndef _LP64
        __ movdqu(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]));
#else
        if ((UseAVX < 3) || VM_Version::supports_avx512vl()) {
          __ movdqu(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]));
        }
        else {
          __ vextractf32x4(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]), 0x0);
        }
#endif
        break;
      case Op_VecY:
#ifndef _LP64
        __ vmovdqu(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]));
#else
        if ((UseAVX < 3) || VM_Version::supports_avx512vl()) {
          __ vmovdqu(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]));
        }
        else {
          __ vextractf64x4(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]), 0x0);
        }
#endif
        break;
      case Op_VecZ:
        __ evmovdquq(Address(rsp, stack_offset), as_XMMRegister(Matcher::_regEncode[reg]), 2);
        break;
      default:
        ShouldNotReachHere();
      }
    }
    int size = __ offset() - offset;
#ifdef ASSERT
    int offset_size = (stack_offset == 0) ? 0 : ((stack_offset < 0x80) ? 1 : (UseAVX > 2) ? 6 : 4);
    // VEX_2bytes prefix is used if UseAVX > 0, so it takes the same 2 bytes as SIMD prefix.
    assert(!do_size || size == (5+offset_size), "incorrect size calculattion");
#endif
    return size;
#ifndef PRODUCT
  } else if (!do_size) {
    if (is_load) {
      switch (ireg) {
      case Op_VecS:
        st->print("movd    %s,[rsp + %d]\t# spill", Matcher::regName[reg], stack_offset);
        break;
      case Op_VecD:
        st->print("movq    %s,[rsp + %d]\t# spill", Matcher::regName[reg], stack_offset);
        break;
       case Op_VecX:
        st->print("movdqu  %s,[rsp + %d]\t# spill", Matcher::regName[reg], stack_offset);
        break;
      case Op_VecY:
      case Op_VecZ:
        st->print("vmovdqu %s,[rsp + %d]\t# spill", Matcher::regName[reg], stack_offset);
        break;
      default:
        ShouldNotReachHere();
      }
    } else { // store
      switch (ireg) {
      case Op_VecS:
        st->print("movd    [rsp + %d],%s\t# spill", stack_offset, Matcher::regName[reg]);
        break;
      case Op_VecD:
        st->print("movq    [rsp + %d],%s\t# spill", stack_offset, Matcher::regName[reg]);
        break;
       case Op_VecX:
        st->print("movdqu  [rsp + %d],%s\t# spill", stack_offset, Matcher::regName[reg]);
        break;
      case Op_VecY:
      case Op_VecZ:
        st->print("vmovdqu [rsp + %d],%s\t# spill", stack_offset, Matcher::regName[reg]);
        break;
      default:
        ShouldNotReachHere();
      }
    }
#endif
  }
  bool is_single_byte = false;
  int vec_len = 0;
  if ((UseAVX > 2) && (stack_offset != 0)) {
    int tuple_type = Assembler::EVEX_FVM;
    int input_size = Assembler::EVEX_32bit;
    switch (ireg) {
    case Op_VecS:
      tuple_type = Assembler::EVEX_T1S;
      break;
    case Op_VecD:
      tuple_type = Assembler::EVEX_T1S;
      input_size = Assembler::EVEX_64bit;
      break;
    case Op_VecX:
      break;
    case Op_VecY:
      vec_len = 1;
      break;
    case Op_VecZ:
      vec_len = 2;
      break;
    }
    is_single_byte = Assembler::query_compressed_disp_byte(stack_offset, true, vec_len, tuple_type, input_size, 0);
  }
  int offset_size = 0;
  int size = 5;
  if (UseAVX > 2 ) {
    if (VM_Version::supports_avx512novl() && (vec_len == 2)) {
      offset_size = (stack_offset == 0) ? 0 : ((is_single_byte) ? 1 : 4);
      size += 2; // Need an additional two bytes for EVEX encoding
    } else if (VM_Version::supports_avx512novl() && (vec_len < 2)) {
      offset_size = (stack_offset == 0) ? 0 : ((stack_offset <= 127) ? 1 : 4);
    } else {
      offset_size = (stack_offset == 0) ? 0 : ((is_single_byte) ? 1 : 4);
      size += 2; // Need an additional two bytes for EVEX encodding
    }
  } else {
    offset_size = (stack_offset == 0) ? 0 : ((stack_offset <= 127) ? 1 : 4);
  }
  // VEX_2bytes prefix is used if UseAVX > 0, so it takes the same 2 bytes as SIMD prefix.
  return size+offset_size;
}

static inline jint replicate4_imm(int con, int width) {
  // Load a constant of "width" (in bytes) and replicate it to fill 32bit.
  assert(width == 1 || width == 2, "only byte or short types here");
  int bit_width = width * 8;
  jint val = con;
  val &= (1 << bit_width) - 1;  // mask off sign bits
  while(bit_width < 32) {
    val |= (val << bit_width);
    bit_width <<= 1;
  }
  return val;
}

static inline jlong replicate8_imm(int con, int width) {
  // Load a constant of "width" (in bytes) and replicate it to fill 64bit.
  assert(width == 1 || width == 2 || width == 4, "only byte, short or int types here");
  int bit_width = width * 8;
  jlong val = con;
  val &= (((jlong) 1) << bit_width) - 1;  // mask off sign bits
  while(bit_width < 64) {
    val |= (val << bit_width);
    bit_width <<= 1;
  }
  return val;
}

#ifndef PRODUCT
  void MachNopNode::format(PhaseRegAlloc*, outputStream* st) const {
    st->print("nop \t# %d bytes pad for loops and calls", _count);
  }
#endif

  void MachNopNode::emit(CodeBuffer &cbuf, PhaseRegAlloc*) const {
    MacroAssembler _masm(&cbuf);
    __ nop(_count);
  }

  uint MachNopNode::size(PhaseRegAlloc*) const {
    return _count;
  }

#ifndef PRODUCT
  void MachBreakpointNode::format(PhaseRegAlloc*, outputStream* st) const {
    st->print("# breakpoint");
  }
#endif

  void MachBreakpointNode::emit(CodeBuffer &cbuf, PhaseRegAlloc* ra_) const {
    MacroAssembler _masm(&cbuf);
    __ int3();
  }

  uint MachBreakpointNode::size(PhaseRegAlloc* ra_) const {
    return MachNode::size(ra_);
  }


#line 2133 "ad_x86.cpp"


#ifndef PRODUCT
void Compile::adlc_verification() {

  // Following assertions generated from definition section
}
#endif

// Map from machine-independent register number to register_save_policy
const        char register_save_policy[] = {
  'C', // R10
  'C', // R10_H
  'C', // R11
  'C', // R11_H
  'C', // R8
  'C', // R8_H
  'C', // R9
  'C', // R9_H
  'C', // R12
  'C', // R12_H
  'C', // RCX
  'C', // RCX_H
  'C', // RBX
  'C', // RBX_H
  'C', // RDI
  'C', // RDI_H
  'C', // RDX
  'C', // RDX_H
  'C', // RSI
  'C', // RSI_H
  'C', // RAX
  'C', // RAX_H
  'N', // RBP
  'N', // RBP_H
  'C', // R13
  'C', // R13_H
  'C', // R14
  'C', // R14_H
  'C', // R15
  'C', // R15_H
  'N', // RSP
  'N', // RSP_H
  'C', // XMM0
  'C', // XMM0b
  'C', // XMM0c
  'C', // XMM0d
  'C', // XMM0e
  'C', // XMM0f
  'C', // XMM0g
  'C', // XMM0h
  'C', // XMM0i
  'C', // XMM0j
  'C', // XMM0k
  'C', // XMM0l
  'C', // XMM0m
  'C', // XMM0n
  'C', // XMM0o
  'C', // XMM0p
  'C', // XMM1
  'C', // XMM1b
  'C', // XMM1c
  'C', // XMM1d
  'C', // XMM1e
  'C', // XMM1f
  'C', // XMM1g
  'C', // XMM1h
  'C', // XMM1i
  'C', // XMM1j
  'C', // XMM1k
  'C', // XMM1l
  'C', // XMM1m
  'C', // XMM1n
  'C', // XMM1o
  'C', // XMM1p
  'C', // XMM2
  'C', // XMM2b
  'C', // XMM2c
  'C', // XMM2d
  'C', // XMM2e
  'C', // XMM2f
  'C', // XMM2g
  'C', // XMM2h
  'C', // XMM2i
  'C', // XMM2j
  'C', // XMM2k
  'C', // XMM2l
  'C', // XMM2m
  'C', // XMM2n
  'C', // XMM2o
  'C', // XMM2p
  'C', // XMM3
  'C', // XMM3b
  'C', // XMM3c
  'C', // XMM3d
  'C', // XMM3e
  'C', // XMM3f
  'C', // XMM3g
  'C', // XMM3h
  'C', // XMM3i
  'C', // XMM3j
  'C', // XMM3k
  'C', // XMM3l
  'C', // XMM3m
  'C', // XMM3n
  'C', // XMM3o
  'C', // XMM3p
  'C', // XMM4
  'C', // XMM4b
  'C', // XMM4c
  'C', // XMM4d
  'C', // XMM4e
  'C', // XMM4f
  'C', // XMM4g
  'C', // XMM4h
  'C', // XMM4i
  'C', // XMM4j
  'C', // XMM4k
  'C', // XMM4l
  'C', // XMM4m
  'C', // XMM4n
  'C', // XMM4o
  'C', // XMM4p
  'C', // XMM5
  'C', // XMM5b
  'C', // XMM5c
  'C', // XMM5d
  'C', // XMM5e
  'C', // XMM5f
  'C', // XMM5g
  'C', // XMM5h
  'C', // XMM5i
  'C', // XMM5j
  'C', // XMM5k
  'C', // XMM5l
  'C', // XMM5m
  'C', // XMM5n
  'C', // XMM5o
  'C', // XMM5p
  'C', // XMM6
  'C', // XMM6b
  'C', // XMM6c
  'C', // XMM6d
  'C', // XMM6e
  'C', // XMM6f
  'C', // XMM6g
  'C', // XMM6h
  'C', // XMM6i
  'C', // XMM6j
  'C', // XMM6k
  'C', // XMM6l
  'C', // XMM6m
  'C', // XMM6n
  'C', // XMM6o
  'C', // XMM6p
  'C', // XMM7
  'C', // XMM7b
  'C', // XMM7c
  'C', // XMM7d
  'C', // XMM7e
  'C', // XMM7f
  'C', // XMM7g
  'C', // XMM7h
  'C', // XMM7i
  'C', // XMM7j
  'C', // XMM7k
  'C', // XMM7l
  'C', // XMM7m
  'C', // XMM7n
  'C', // XMM7o
  'C', // XMM7p
  'C', // XMM8
  'C', // XMM8b
  'C', // XMM8c
  'C', // XMM8d
  'C', // XMM8e
  'C', // XMM8f
  'C', // XMM8g
  'C', // XMM8h
  'C', // XMM8i
  'C', // XMM8j
  'C', // XMM8k
  'C', // XMM8l
  'C', // XMM8m
  'C', // XMM8n
  'C', // XMM8o
  'C', // XMM8p
  'C', // XMM9
  'C', // XMM9b
  'C', // XMM9c
  'C', // XMM9d
  'C', // XMM9e
  'C', // XMM9f
  'C', // XMM9g
  'C', // XMM9h
  'C', // XMM9i
  'C', // XMM9j
  'C', // XMM9k
  'C', // XMM9l
  'C', // XMM9m
  'C', // XMM9n
  'C', // XMM9o
  'C', // XMM9p
  'C', // XMM10
  'C', // XMM10b
  'C', // XMM10c
  'C', // XMM10d
  'C', // XMM10e
  'C', // XMM10f
  'C', // XMM10g
  'C', // XMM10h
  'C', // XMM10i
  'C', // XMM10j
  'C', // XMM10k
  'C', // XMM10l
  'C', // XMM10m
  'C', // XMM10n
  'C', // XMM10o
  'C', // XMM10p
  'C', // XMM11
  'C', // XMM11b
  'C', // XMM11c
  'C', // XMM11d
  'C', // XMM11e
  'C', // XMM11f
  'C', // XMM11g
  'C', // XMM11h
  'C', // XMM11i
  'C', // XMM11j
  'C', // XMM11k
  'C', // XMM11l
  'C', // XMM11m
  'C', // XMM11n
  'C', // XMM11o
  'C', // XMM11p
  'C', // XMM12
  'C', // XMM12b
  'C', // XMM12c
  'C', // XMM12d
  'C', // XMM12e
  'C', // XMM12f
  'C', // XMM12g
  'C', // XMM12h
  'C', // XMM12i
  'C', // XMM12j
  'C', // XMM12k
  'C', // XMM12l
  'C', // XMM12m
  'C', // XMM12n
  'C', // XMM12o
  'C', // XMM12p
  'C', // XMM13
  'C', // XMM13b
  'C', // XMM13c
  'C', // XMM13d
  'C', // XMM13e
  'C', // XMM13f
  'C', // XMM13g
  'C', // XMM13h
  'C', // XMM13i
  'C', // XMM13j
  'C', // XMM13k
  'C', // XMM13l
  'C', // XMM13m
  'C', // XMM13n
  'C', // XMM13o
  'C', // XMM13p
  'C', // XMM14
  'C', // XMM14b
  'C', // XMM14c
  'C', // XMM14d
  'C', // XMM14e
  'C', // XMM14f
  'C', // XMM14g
  'C', // XMM14h
  'C', // XMM14i
  'C', // XMM14j
  'C', // XMM14k
  'C', // XMM14l
  'C', // XMM14m
  'C', // XMM14n
  'C', // XMM14o
  'C', // XMM14p
  'C', // XMM15
  'C', // XMM15b
  'C', // XMM15c
  'C', // XMM15d
  'C', // XMM15e
  'C', // XMM15f
  'C', // XMM15g
  'C', // XMM15h
  'C', // XMM15i
  'C', // XMM15j
  'C', // XMM15k
  'C', // XMM15l
  'C', // XMM15m
  'C', // XMM15n
  'C', // XMM15o
  'C', // XMM15p
  'C', // XMM16
  'C', // XMM16b
  'C', // XMM16c
  'C', // XMM16d
  'C', // XMM16e
  'C', // XMM16f
  'C', // XMM16g
  'C', // XMM16h
  'C', // XMM16i
  'C', // XMM16j
  'C', // XMM16k
  'C', // XMM16l
  'C', // XMM16m
  'C', // XMM16n
  'C', // XMM16o
  'C', // XMM16p
  'C', // XMM17
  'C', // XMM17b
  'C', // XMM17c
  'C', // XMM17d
  'C', // XMM17e
  'C', // XMM17f
  'C', // XMM17g
  'C', // XMM17h
  'C', // XMM17i
  'C', // XMM17j
  'C', // XMM17k
  'C', // XMM17l
  'C', // XMM17m
  'C', // XMM17n
  'C', // XMM17o
  'C', // XMM17p
  'C', // XMM18
  'C', // XMM18b
  'C', // XMM18c
  'C', // XMM18d
  'C', // XMM18e
  'C', // XMM18f
  'C', // XMM18g
  'C', // XMM18h
  'C', // XMM18i
  'C', // XMM18j
  'C', // XMM18k
  'C', // XMM18l
  'C', // XMM18m
  'C', // XMM18n
  'C', // XMM18o
  'C', // XMM18p
  'C', // XMM19
  'C', // XMM19b
  'C', // XMM19c
  'C', // XMM19d
  'C', // XMM19e
  'C', // XMM19f
  'C', // XMM19g
  'C', // XMM19h
  'C', // XMM19i
  'C', // XMM19j
  'C', // XMM19k
  'C', // XMM19l
  'C', // XMM19m
  'C', // XMM19n
  'C', // XMM19o
  'C', // XMM19p
  'C', // XMM20
  'C', // XMM20b
  'C', // XMM20c
  'C', // XMM20d
  'C', // XMM20e
  'C', // XMM20f
  'C', // XMM20g
  'C', // XMM20h
  'C', // XMM20i
  'C', // XMM20j
  'C', // XMM20k
  'C', // XMM20l
  'C', // XMM20m
  'C', // XMM20n
  'C', // XMM20o
  'C', // XMM20p
  'C', // XMM21
  'C', // XMM21b
  'C', // XMM21c
  'C', // XMM21d
  'C', // XMM21e
  'C', // XMM21f
  'C', // XMM21g
  'C', // XMM21h
  'C', // XMM21i
  'C', // XMM21j
  'C', // XMM21k
  'C', // XMM21l
  'C', // XMM21m
  'C', // XMM21n
  'C', // XMM21o
  'C', // XMM21p
  'C', // XMM22
  'C', // XMM22b
  'C', // XMM22c
  'C', // XMM22d
  'C', // XMM22e
  'C', // XMM22f
  'C', // XMM22g
  'C', // XMM22h
  'C', // XMM22i
  'C', // XMM22j
  'C', // XMM22k
  'C', // XMM22l
  'C', // XMM22m
  'C', // XMM22n
  'C', // XMM22o
  'C', // XMM22p
  'C', // XMM23
  'C', // XMM23b
  'C', // XMM23c
  'C', // XMM23d
  'C', // XMM23e
  'C', // XMM23f
  'C', // XMM23g
  'C', // XMM23h
  'C', // XMM23i
  'C', // XMM23j
  'C', // XMM23k
  'C', // XMM23l
  'C', // XMM23m
  'C', // XMM23n
  'C', // XMM23o
  'C', // XMM23p
  'C', // XMM24
  'C', // XMM24b
  'C', // XMM24c
  'C', // XMM24d
  'C', // XMM24e
  'C', // XMM24f
  'C', // XMM24g
  'C', // XMM24h
  'C', // XMM24i
  'C', // XMM24j
  'C', // XMM24k
  'C', // XMM24l
  'C', // XMM24m
  'C', // XMM24n
  'C', // XMM24o
  'C', // XMM24p
  'C', // XMM25
  'C', // XMM25b
  'C', // XMM25c
  'C', // XMM25d
  'C', // XMM25e
  'C', // XMM25f
  'C', // XMM25g
  'C', // XMM25h
  'C', // XMM25i
  'C', // XMM25j
  'C', // XMM25k
  'C', // XMM25l
  'C', // XMM25m
  'C', // XMM25n
  'C', // XMM25o
  'C', // XMM25p
  'C', // XMM26
  'C', // XMM26b
  'C', // XMM26c
  'C', // XMM26d
  'C', // XMM26e
  'C', // XMM26f
  'C', // XMM26g
  'C', // XMM26h
  'C', // XMM26i
  'C', // XMM26j
  'C', // XMM26k
  'C', // XMM26l
  'C', // XMM26m
  'C', // XMM26n
  'C', // XMM26o
  'C', // XMM26p
  'C', // XMM27
  'C', // XMM27b
  'C', // XMM27c
  'C', // XMM27d
  'C', // XMM27e
  'C', // XMM27f
  'C', // XMM27g
  'C', // XMM27h
  'C', // XMM27i
  'C', // XMM27j
  'C', // XMM27k
  'C', // XMM27l
  'C', // XMM27m
  'C', // XMM27n
  'C', // XMM27o
  'C', // XMM27p
  'C', // XMM28
  'C', // XMM28b
  'C', // XMM28c
  'C', // XMM28d
  'C', // XMM28e
  'C', // XMM28f
  'C', // XMM28g
  'C', // XMM28h
  'C', // XMM28i
  'C', // XMM28j
  'C', // XMM28k
  'C', // XMM28l
  'C', // XMM28m
  'C', // XMM28n
  'C', // XMM28o
  'C', // XMM28p
  'C', // XMM29
  'C', // XMM29b
  'C', // XMM29c
  'C', // XMM29d
  'C', // XMM29e
  'C', // XMM29f
  'C', // XMM29g
  'C', // XMM29h
  'C', // XMM29i
  'C', // XMM29j
  'C', // XMM29k
  'C', // XMM29l
  'C', // XMM29m
  'C', // XMM29n
  'C', // XMM29o
  'C', // XMM29p
  'C', // XMM30
  'C', // XMM30b
  'C', // XMM30c
  'C', // XMM30d
  'C', // XMM30e
  'C', // XMM30f
  'C', // XMM30g
  'C', // XMM30h
  'C', // XMM30i
  'C', // XMM30j
  'C', // XMM30k
  'C', // XMM30l
  'C', // XMM30m
  'C', // XMM30n
  'C', // XMM30o
  'C', // XMM30p
  'C', // XMM31
  'C', // XMM31b
  'C', // XMM31c
  'C', // XMM31d
  'C', // XMM31e
  'C', // XMM31f
  'C', // XMM31g
  'C', // XMM31h
  'C', // XMM31i
  'C', // XMM31j
  'C', // XMM31k
  'C', // XMM31l
  'C', // XMM31m
  'C', // XMM31n
  'C', // XMM31o
  'C', // XMM31p
  'C' // no trailing comma // RFLAGS
};

// Map from machine-independent register number to c_reg_save_policy
const        char c_reg_save_policy[] = {
  'C', // R10
  'C', // R10_H
  'C', // R11
  'C', // R11_H
  'C', // R8
  'C', // R8_H
  'C', // R9
  'C', // R9_H
  'E', // R12
  'E', // R12_H
  'C', // RCX
  'C', // RCX_H
  'E', // RBX
  'E', // RBX_H
  'C', // RDI
  'C', // RDI_H
  'C', // RDX
  'C', // RDX_H
  'C', // RSI
  'C', // RSI_H
  'C', // RAX
  'C', // RAX_H
  'E', // RBP
  'E', // RBP_H
  'E', // R13
  'E', // R13_H
  'E', // R14
  'E', // R14_H
  'E', // R15
  'E', // R15_H
  'N', // RSP
  'N', // RSP_H
  'C', // XMM0
  'C', // XMM0b
  'C', // XMM0c
  'C', // XMM0d
  'C', // XMM0e
  'C', // XMM0f
  'C', // XMM0g
  'C', // XMM0h
  'C', // XMM0i
  'C', // XMM0j
  'C', // XMM0k
  'C', // XMM0l
  'C', // XMM0m
  'C', // XMM0n
  'C', // XMM0o
  'C', // XMM0p
  'C', // XMM1
  'C', // XMM1b
  'C', // XMM1c
  'C', // XMM1d
  'C', // XMM1e
  'C', // XMM1f
  'C', // XMM1g
  'C', // XMM1h
  'C', // XMM1i
  'C', // XMM1j
  'C', // XMM1k
  'C', // XMM1l
  'C', // XMM1m
  'C', // XMM1n
  'C', // XMM1o
  'C', // XMM1p
  'C', // XMM2
  'C', // XMM2b
  'C', // XMM2c
  'C', // XMM2d
  'C', // XMM2e
  'C', // XMM2f
  'C', // XMM2g
  'C', // XMM2h
  'C', // XMM2i
  'C', // XMM2j
  'C', // XMM2k
  'C', // XMM2l
  'C', // XMM2m
  'C', // XMM2n
  'C', // XMM2o
  'C', // XMM2p
  'C', // XMM3
  'C', // XMM3b
  'C', // XMM3c
  'C', // XMM3d
  'C', // XMM3e
  'C', // XMM3f
  'C', // XMM3g
  'C', // XMM3h
  'C', // XMM3i
  'C', // XMM3j
  'C', // XMM3k
  'C', // XMM3l
  'C', // XMM3m
  'C', // XMM3n
  'C', // XMM3o
  'C', // XMM3p
  'C', // XMM4
  'C', // XMM4b
  'C', // XMM4c
  'C', // XMM4d
  'C', // XMM4e
  'C', // XMM4f
  'C', // XMM4g
  'C', // XMM4h
  'C', // XMM4i
  'C', // XMM4j
  'C', // XMM4k
  'C', // XMM4l
  'C', // XMM4m
  'C', // XMM4n
  'C', // XMM4o
  'C', // XMM4p
  'C', // XMM5
  'C', // XMM5b
  'C', // XMM5c
  'C', // XMM5d
  'C', // XMM5e
  'C', // XMM5f
  'C', // XMM5g
  'C', // XMM5h
  'C', // XMM5i
  'C', // XMM5j
  'C', // XMM5k
  'C', // XMM5l
  'C', // XMM5m
  'C', // XMM5n
  'C', // XMM5o
  'C', // XMM5p
  'C', // XMM6
  'C', // XMM6b
  'C', // XMM6c
  'C', // XMM6d
  'C', // XMM6e
  'C', // XMM6f
  'C', // XMM6g
  'C', // XMM6h
  'C', // XMM6i
  'C', // XMM6j
  'C', // XMM6k
  'C', // XMM6l
  'C', // XMM6m
  'C', // XMM6n
  'C', // XMM6o
  'C', // XMM6p
  'C', // XMM7
  'C', // XMM7b
  'C', // XMM7c
  'C', // XMM7d
  'C', // XMM7e
  'C', // XMM7f
  'C', // XMM7g
  'C', // XMM7h
  'C', // XMM7i
  'C', // XMM7j
  'C', // XMM7k
  'C', // XMM7l
  'C', // XMM7m
  'C', // XMM7n
  'C', // XMM7o
  'C', // XMM7p
  'C', // XMM8
  'C', // XMM8b
  'C', // XMM8c
  'C', // XMM8d
  'C', // XMM8e
  'C', // XMM8f
  'C', // XMM8g
  'C', // XMM8h
  'C', // XMM8i
  'C', // XMM8j
  'C', // XMM8k
  'C', // XMM8l
  'C', // XMM8m
  'C', // XMM8n
  'C', // XMM8o
  'C', // XMM8p
  'C', // XMM9
  'C', // XMM9b
  'C', // XMM9c
  'C', // XMM9d
  'C', // XMM9e
  'C', // XMM9f
  'C', // XMM9g
  'C', // XMM9h
  'C', // XMM9i
  'C', // XMM9j
  'C', // XMM9k
  'C', // XMM9l
  'C', // XMM9m
  'C', // XMM9n
  'C', // XMM9o
  'C', // XMM9p
  'C', // XMM10
  'C', // XMM10b
  'C', // XMM10c
  'C', // XMM10d
  'C', // XMM10e
  'C', // XMM10f
  'C', // XMM10g
  'C', // XMM10h
  'C', // XMM10i
  'C', // XMM10j
  'C', // XMM10k
  'C', // XMM10l
  'C', // XMM10m
  'C', // XMM10n
  'C', // XMM10o
  'C', // XMM10p
  'C', // XMM11
  'C', // XMM11b
  'C', // XMM11c
  'C', // XMM11d
  'C', // XMM11e
  'C', // XMM11f
  'C', // XMM11g
  'C', // XMM11h
  'C', // XMM11i
  'C', // XMM11j
  'C', // XMM11k
  'C', // XMM11l
  'C', // XMM11m
  'C', // XMM11n
  'C', // XMM11o
  'C', // XMM11p
  'C', // XMM12
  'C', // XMM12b
  'C', // XMM12c
  'C', // XMM12d
  'C', // XMM12e
  'C', // XMM12f
  'C', // XMM12g
  'C', // XMM12h
  'C', // XMM12i
  'C', // XMM12j
  'C', // XMM12k
  'C', // XMM12l
  'C', // XMM12m
  'C', // XMM12n
  'C', // XMM12o
  'C', // XMM12p
  'C', // XMM13
  'C', // XMM13b
  'C', // XMM13c
  'C', // XMM13d
  'C', // XMM13e
  'C', // XMM13f
  'C', // XMM13g
  'C', // XMM13h
  'C', // XMM13i
  'C', // XMM13j
  'C', // XMM13k
  'C', // XMM13l
  'C', // XMM13m
  'C', // XMM13n
  'C', // XMM13o
  'C', // XMM13p
  'C', // XMM14
  'C', // XMM14b
  'C', // XMM14c
  'C', // XMM14d
  'C', // XMM14e
  'C', // XMM14f
  'C', // XMM14g
  'C', // XMM14h
  'C', // XMM14i
  'C', // XMM14j
  'C', // XMM14k
  'C', // XMM14l
  'C', // XMM14m
  'C', // XMM14n
  'C', // XMM14o
  'C', // XMM14p
  'C', // XMM15
  'C', // XMM15b
  'C', // XMM15c
  'C', // XMM15d
  'C', // XMM15e
  'C', // XMM15f
  'C', // XMM15g
  'C', // XMM15h
  'C', // XMM15i
  'C', // XMM15j
  'C', // XMM15k
  'C', // XMM15l
  'C', // XMM15m
  'C', // XMM15n
  'C', // XMM15o
  'C', // XMM15p
  'C', // XMM16
  'C', // XMM16b
  'C', // XMM16c
  'C', // XMM16d
  'C', // XMM16e
  'C', // XMM16f
  'C', // XMM16g
  'C', // XMM16h
  'C', // XMM16i
  'C', // XMM16j
  'C', // XMM16k
  'C', // XMM16l
  'C', // XMM16m
  'C', // XMM16n
  'C', // XMM16o
  'C', // XMM16p
  'C', // XMM17
  'C', // XMM17b
  'C', // XMM17c
  'C', // XMM17d
  'C', // XMM17e
  'C', // XMM17f
  'C', // XMM17g
  'C', // XMM17h
  'C', // XMM17i
  'C', // XMM17j
  'C', // XMM17k
  'C', // XMM17l
  'C', // XMM17m
  'C', // XMM17n
  'C', // XMM17o
  'C', // XMM17p
  'C', // XMM18
  'C', // XMM18b
  'C', // XMM18c
  'C', // XMM18d
  'C', // XMM18e
  'C', // XMM18f
  'C', // XMM18g
  'C', // XMM18h
  'C', // XMM18i
  'C', // XMM18j
  'C', // XMM18k
  'C', // XMM18l
  'C', // XMM18m
  'C', // XMM18n
  'C', // XMM18o
  'C', // XMM18p
  'C', // XMM19
  'C', // XMM19b
  'C', // XMM19c
  'C', // XMM19d
  'C', // XMM19e
  'C', // XMM19f
  'C', // XMM19g
  'C', // XMM19h
  'C', // XMM19i
  'C', // XMM19j
  'C', // XMM19k
  'C', // XMM19l
  'C', // XMM19m
  'C', // XMM19n
  'C', // XMM19o
  'C', // XMM19p
  'C', // XMM20
  'C', // XMM20b
  'C', // XMM20c
  'C', // XMM20d
  'C', // XMM20e
  'C', // XMM20f
  'C', // XMM20g
  'C', // XMM20h
  'C', // XMM20i
  'C', // XMM20j
  'C', // XMM20k
  'C', // XMM20l
  'C', // XMM20m
  'C', // XMM20n
  'C', // XMM20o
  'C', // XMM20p
  'C', // XMM21
  'C', // XMM21b
  'C', // XMM21c
  'C', // XMM21d
  'C', // XMM21e
  'C', // XMM21f
  'C', // XMM21g
  'C', // XMM21h
  'C', // XMM21i
  'C', // XMM21j
  'C', // XMM21k
  'C', // XMM21l
  'C', // XMM21m
  'C', // XMM21n
  'C', // XMM21o
  'C', // XMM21p
  'C', // XMM22
  'C', // XMM22b
  'C', // XMM22c
  'C', // XMM22d
  'C', // XMM22e
  'C', // XMM22f
  'C', // XMM22g
  'C', // XMM22h
  'C', // XMM22i
  'C', // XMM22j
  'C', // XMM22k
  'C', // XMM22l
  'C', // XMM22m
  'C', // XMM22n
  'C', // XMM22o
  'C', // XMM22p
  'C', // XMM23
  'C', // XMM23b
  'C', // XMM23c
  'C', // XMM23d
  'C', // XMM23e
  'C', // XMM23f
  'C', // XMM23g
  'C', // XMM23h
  'C', // XMM23i
  'C', // XMM23j
  'C', // XMM23k
  'C', // XMM23l
  'C', // XMM23m
  'C', // XMM23n
  'C', // XMM23o
  'C', // XMM23p
  'C', // XMM24
  'C', // XMM24b
  'C', // XMM24c
  'C', // XMM24d
  'C', // XMM24e
  'C', // XMM24f
  'C', // XMM24g
  'C', // XMM24h
  'C', // XMM24i
  'C', // XMM24j
  'C', // XMM24k
  'C', // XMM24l
  'C', // XMM24m
  'C', // XMM24n
  'C', // XMM24o
  'C', // XMM24p
  'C', // XMM25
  'C', // XMM25b
  'C', // XMM25c
  'C', // XMM25d
  'C', // XMM25e
  'C', // XMM25f
  'C', // XMM25g
  'C', // XMM25h
  'C', // XMM25i
  'C', // XMM25j
  'C', // XMM25k
  'C', // XMM25l
  'C', // XMM25m
  'C', // XMM25n
  'C', // XMM25o
  'C', // XMM25p
  'C', // XMM26
  'C', // XMM26b
  'C', // XMM26c
  'C', // XMM26d
  'C', // XMM26e
  'C', // XMM26f
  'C', // XMM26g
  'C', // XMM26h
  'C', // XMM26i
  'C', // XMM26j
  'C', // XMM26k
  'C', // XMM26l
  'C', // XMM26m
  'C', // XMM26n
  'C', // XMM26o
  'C', // XMM26p
  'C', // XMM27
  'C', // XMM27b
  'C', // XMM27c
  'C', // XMM27d
  'C', // XMM27e
  'C', // XMM27f
  'C', // XMM27g
  'C', // XMM27h
  'C', // XMM27i
  'C', // XMM27j
  'C', // XMM27k
  'C', // XMM27l
  'C', // XMM27m
  'C', // XMM27n
  'C', // XMM27o
  'C', // XMM27p
  'C', // XMM28
  'C', // XMM28b
  'C', // XMM28c
  'C', // XMM28d
  'C', // XMM28e
  'C', // XMM28f
  'C', // XMM28g
  'C', // XMM28h
  'C', // XMM28i
  'C', // XMM28j
  'C', // XMM28k
  'C', // XMM28l
  'C', // XMM28m
  'C', // XMM28n
  'C', // XMM28o
  'C', // XMM28p
  'C', // XMM29
  'C', // XMM29b
  'C', // XMM29c
  'C', // XMM29d
  'C', // XMM29e
  'C', // XMM29f
  'C', // XMM29g
  'C', // XMM29h
  'C', // XMM29i
  'C', // XMM29j
  'C', // XMM29k
  'C', // XMM29l
  'C', // XMM29m
  'C', // XMM29n
  'C', // XMM29o
  'C', // XMM29p
  'C', // XMM30
  'C', // XMM30b
  'C', // XMM30c
  'C', // XMM30d
  'C', // XMM30e
  'C', // XMM30f
  'C', // XMM30g
  'C', // XMM30h
  'C', // XMM30i
  'C', // XMM30j
  'C', // XMM30k
  'C', // XMM30l
  'C', // XMM30m
  'C', // XMM30n
  'C', // XMM30o
  'C', // XMM30p
  'C', // XMM31
  'C', // XMM31b
  'C', // XMM31c
  'C', // XMM31d
  'C', // XMM31e
  'C', // XMM31f
  'C', // XMM31g
  'C', // XMM31h
  'C', // XMM31i
  'C', // XMM31j
  'C', // XMM31k
  'C', // XMM31l
  'C', // XMM31m
  'C', // XMM31n
  'C', // XMM31o
  'C', // XMM31p
  'C' // no trailing comma // RFLAGS
};

// Map from machine-independent register number to register_save_type
const        int register_save_type[] = {
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegI,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  Op_RegF,
  0 // no trailing comma
};


const        int   reduceOp[] = {
  /*    0 */  0,
  /*    1 */  0,
  /*    2 */  0,
  /*    3 */  0,
  /*    4 */  0,
  /*    5 */  0,
  /*    6 */  0,
  /*    7 */  0,
  /*    8 */  immI_rule,
  /*    9 */  immI0_rule,
  /*   10 */  immI1_rule,
  /*   11 */  immI_M1_rule,
  /*   12 */  immI2_rule,
  /*   13 */  immI8_rule,
  /*   14 */  immU8_rule,
  /*   15 */  immI16_rule,
  /*   16 */  immU31_rule,
  /*   17 */  immI_32_rule,
  /*   18 */  immI_64_rule,
  /*   19 */  immP_rule,
  /*   20 */  immP0_rule,
  /*   21 */  immN_rule,
  /*   22 */  immNKlass_rule,
  /*   23 */  immN0_rule,
  /*   24 */  immP31_rule,
  /*   25 */  immL_rule,
  /*   26 */  immL8_rule,
  /*   27 */  immUL32_rule,
  /*   28 */  immL32_rule,
  /*   29 */  immL0_rule,
  /*   30 */  immL1_rule,
  /*   31 */  immL_M1_rule,
  /*   32 */  immL10_rule,
  /*   33 */  immL_127_rule,
  /*   34 */  immL_32bits_rule,
  /*   35 */  immF0_rule,
  /*   36 */  immF_rule,
  /*   37 */  immD0_rule,
  /*   38 */  immD_rule,
  /*   39 */  immI_16_rule,
  /*   40 */  immI_24_rule,
  /*   41 */  immI_255_rule,
  /*   42 */  immI_65535_rule,
  /*   43 */  immL_255_rule,
  /*   44 */  immL_65535_rule,
  /*   45 */  rRegI_rule,
  /*   46 */  rax_RegI_rule,
  /*   47 */  rbx_RegI_rule,
  /*   48 */  rcx_RegI_rule,
  /*   49 */  rdx_RegI_rule,
  /*   50 */  rdi_RegI_rule,
  /*   51 */  no_rcx_RegI_rule,
  /*   52 */  no_rax_rdx_RegI_rule,
  /*   53 */  any_RegP_rule,
  /*   54 */  rRegP_rule,
  /*   55 */  rRegN_rule,
  /*   56 */  no_rax_RegP_rule,
  /*   57 */  no_rbp_RegP_rule,
  /*   58 */  no_rax_rbx_RegP_rule,
  /*   59 */  rax_RegP_rule,
  /*   60 */  rax_RegN_rule,
  /*   61 */  rbx_RegP_rule,
  /*   62 */  rsi_RegP_rule,
  /*   63 */  rdi_RegP_rule,
  /*   64 */  r15_RegP_rule,
  /*   65 */  rex_RegP_rule,
  /*   66 */  rRegL_rule,
  /*   67 */  no_rax_rdx_RegL_rule,
  /*   68 */  no_rax_RegL_rule,
  /*   69 */  no_rcx_RegL_rule,
  /*   70 */  rax_RegL_rule,
  /*   71 */  rcx_RegL_rule,
  /*   72 */  rdx_RegL_rule,
  /*   73 */  rFlagsReg_rule,
  /*   74 */  rFlagsRegU_rule,
  /*   75 */  rFlagsRegUCF_rule,
  /*   76 */  regF_rule,
  /*   77 */  legRegF_rule,
  /*   78 */  vlRegF_rule,
  /*   79 */  regD_rule,
  /*   80 */  legRegD_rule,
  /*   81 */  vlRegD_rule,
  /*   82 */  vecS_rule,
  /*   83 */  legVecS_rule,
  /*   84 */  vecD_rule,
  /*   85 */  legVecD_rule,
  /*   86 */  vecX_rule,
  /*   87 */  legVecX_rule,
  /*   88 */  vecY_rule,
  /*   89 */  legVecY_rule,
  /*   90 */  indirect_rule,
  /*   91 */  indOffset8_rule,
  /*   92 */  indOffset32_rule,
  /*   93 */  indIndexOffset_rule,
  /*   94 */  indIndex_rule,
  /*   95 */  indIndexScale_rule,
  /*   96 */  indPosIndexScale_rule,
  /*   97 */  indIndexScaleOffset_rule,
  /*   98 */  indPosIndexOffset_rule,
  /*   99 */  indPosIndexScaleOffset_rule,
  /*  100 */  indCompressedOopOffset_rule,
  /*  101 */  indirectNarrow_rule,
  /*  102 */  indOffset8Narrow_rule,
  /*  103 */  indOffset32Narrow_rule,
  /*  104 */  indIndexOffsetNarrow_rule,
  /*  105 */  indIndexNarrow_rule,
  /*  106 */  indIndexScaleNarrow_rule,
  /*  107 */  indIndexScaleOffsetNarrow_rule,
  /*  108 */  indPosIndexOffsetNarrow_rule,
  /*  109 */  indPosIndexScaleOffsetNarrow_rule,
  /*  110 */  stackSlotP_rule,
  /*  111 */  stackSlotI_rule,
  /*  112 */  stackSlotF_rule,
  /*  113 */  stackSlotD_rule,
  /*  114 */  stackSlotL_rule,
  /*  115 */  cmpOp_rule,
  /*  116 */  cmpOpU_rule,
  /*  117 */  cmpOpUCF_rule,
  /*  118 */  cmpOpUCF2_rule,
  /*  119 */  rxmm0_rule,
  /*  120 */  rxmm1_rule,
  /*  121 */  rxmm2_rule,
  /*  122 */  rxmm3_rule,
  /*  123 */  rxmm4_rule,
  /*  124 */  rxmm5_rule,
  /*  125 */  rxmm6_rule,
  /*  126 */  rxmm7_rule,
  /*  127 */  rxmm8_rule,
  /*  128 */  rxmm9_rule,
  /*  129 */  rxmm10_rule,
  /*  130 */  rxmm11_rule,
  /*  131 */  rxmm12_rule,
  /*  132 */  rxmm13_rule,
  /*  133 */  rxmm14_rule,
  /*  134 */  rxmm15_rule,
  /*  135 */  rxmm16_rule,
  /*  136 */  rxmm17_rule,
  /*  137 */  rxmm18_rule,
  /*  138 */  rxmm19_rule,
  /*  139 */  rxmm20_rule,
  /*  140 */  rxmm21_rule,
  /*  141 */  rxmm22_rule,
  /*  142 */  rxmm23_rule,
  /*  143 */  rxmm24_rule,
  /*  144 */  rxmm25_rule,
  /*  145 */  rxmm26_rule,
  /*  146 */  rxmm27_rule,
  /*  147 */  rxmm28_rule,
  /*  148 */  rxmm29_rule,
  /*  149 */  rxmm30_rule,
  /*  150 */  rxmm31_rule,
  /*  151 */  vecZ_rule,
  /*  152 */  legVecZ_rule,
  /*  153 */  cmpOp_vcmppd_rule,
  // last operand
  /*  154 */  memory_rule,
  // last operand class
  /*  155 */  _AddP_any_RegP_rRegL_rule,
  /*  156 */  _LShiftL_rRegL_immI2_rule,
  /*  157 */  _ConvI2L_rRegI__rule,
  /*  158 */  _LShiftL__ConvI2L_rRegI__immI2_rule,
  /*  159 */  _AddP_any_RegP__LShiftL_rRegL_immI2_rule,
  /*  160 */  _AddP_any_RegP__ConvI2L_rRegI__rule,
  /*  161 */  _AddP_any_RegP__LShiftL__ConvI2L_rRegI__immI2_rule,
  /*  162 */  _DecodeN_rRegN__rule,
  /*  163 */  _AddP__DecodeN_rRegN__rRegL_rule,
  /*  164 */  _AddP__DecodeN_rRegN___LShiftL_rRegL_immI2_rule,
  /*  165 */  _AddP__DecodeN_rRegN___ConvI2L_rRegI__rule,
  /*  166 */  _AddP__DecodeN_rRegN___LShiftL__ConvI2L_rRegI__immI2_rule,
  /*  167 */  _LoadB_memory__rule,
  /*  168 */  _LoadUB_memory__rule,
  /*  169 */  _AndI__LoadUB_memory__immI_rule,
  /*  170 */  _LoadS_memory__rule,
  /*  171 */  _LShiftI__LoadS_memory__immI_24_rule,
  /*  172 */  _LoadUS_memory__rule,
  /*  173 */  _LShiftI__LoadUS_memory__immI_24_rule,
  /*  174 */  _AndI__LoadUS_memory__immI_255_rule,
  /*  175 */  _AndI__LoadUS_memory__immI_rule,
  /*  176 */  _LoadI_memory__rule,
  /*  177 */  _LShiftI__LoadI_memory__immI_24_rule,
  /*  178 */  _LShiftI__LoadI_memory__immI_16_rule,
  /*  179 */  _AndI__LoadI_memory__immI_255_rule,
  /*  180 */  _AndI__LoadI_memory__immI_65535_rule,
  /*  181 */  _AndI__LoadI_memory__immU31_rule,
  /*  182 */  _ConvI2L__LoadI_memory___rule,
  /*  183 */  _LoadL_memory__rule,
  /*  184 */  _CastP2X_rRegP__rule,
  /*  185 */  _CastP2X__DecodeN_rRegN___rule,
  /*  186 */  _AddL__LShiftL_rRegL_immI2_immL32_rule,
  /*  187 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  188 */  _Binary_rRegI_rRegI_rule,
  /*  189 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  190 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  191 */  _Binary_rRegI__LoadI_memory__rule,
  /*  192 */  _Binary_rRegN_rRegN_rule,
  /*  193 */  _Binary_rRegP_rRegP_rule,
  /*  194 */  _Binary_rRegL_rRegL_rule,
  /*  195 */  _Binary_rRegL__LoadL_memory__rule,
  /*  196 */  _Binary_regF_regF_rule,
  /*  197 */  _Binary_regD_regD_rule,
  /*  198 */  _AddI__LoadI_memory__rRegI_rule,
  /*  199 */  _AddI_rRegI__LoadI_memory__rule,
  /*  200 */  _AddI__LoadI_memory__immI_rule,
  /*  201 */  _AddI__LoadI_memory__immI1_rule,
  /*  202 */  _AddI__LoadI_memory__immI_M1_rule,
  /*  203 */  _AddL__LoadL_memory__rRegL_rule,
  /*  204 */  _AddL_rRegL__LoadL_memory__rule,
  /*  205 */  _AddL__LoadL_memory__immL32_rule,
  /*  206 */  _AddL__LoadL_memory__immL1_rule,
  /*  207 */  _AddL__LoadL_memory__immL_M1_rule,
  /*  208 */  _Binary_rax_RegP_rRegP_rule,
  /*  209 */  _Binary_rax_RegI_rRegI_rule,
  /*  210 */  _Binary_rax_RegL_rRegL_rule,
  /*  211 */  _Binary_rax_RegN_rRegN_rule,
  /*  212 */  _SubI__LoadI_memory__rRegI_rule,
  /*  213 */  _SubI__LoadI_memory__immI_rule,
  /*  214 */  _SubL__LoadL_memory__rRegL_rule,
  /*  215 */  _SubL__LoadL_memory__immL32_rule,
  /*  216 */  _SubI_immI0_rRegI_rule,
  /*  217 */  _SubI_immI0__LoadI_memory__rule,
  /*  218 */  _SubL_immL0__LoadL_memory__rule,
  /*  219 */  _LShiftI__LoadI_memory__immI1_rule,
  /*  220 */  _LShiftI__LoadI_memory__immI8_rule,
  /*  221 */  _LShiftI__LoadI_memory__rcx_RegI_rule,
  /*  222 */  _RShiftI__LoadI_memory__immI1_rule,
  /*  223 */  _RShiftI__LoadI_memory__immI8_rule,
  /*  224 */  _RShiftI__LoadI_memory__rcx_RegI_rule,
  /*  225 */  _URShiftI__LoadI_memory__immI1_rule,
  /*  226 */  _URShiftI__LoadI_memory__immI8_rule,
  /*  227 */  _URShiftI__LoadI_memory__rcx_RegI_rule,
  /*  228 */  _LShiftL__LoadL_memory__immI1_rule,
  /*  229 */  _LShiftL__LoadL_memory__immI8_rule,
  /*  230 */  _LShiftL__LoadL_memory__rcx_RegI_rule,
  /*  231 */  _RShiftL__LoadL_memory__immI1_rule,
  /*  232 */  _RShiftL__LoadL_memory__immI8_rule,
  /*  233 */  _RShiftL__LoadL_memory__rcx_RegI_rule,
  /*  234 */  _URShiftL__LoadL_memory__immI1_rule,
  /*  235 */  _URShiftL__LoadL_memory__immI8_rule,
  /*  236 */  _URShiftL__LoadL_memory__rcx_RegI_rule,
  /*  237 */  _LShiftI_rRegI_immI_24_rule,
  /*  238 */  _LShiftI_rRegI_immI_16_rule,
  /*  239 */  _LShiftI_rRegI_immI1_rule,
  /*  240 */  _URShiftI_rRegI_immI_M1_rule,
  /*  241 */  _LShiftI_rRegI_immI8_rule,
  /*  242 */  _URShiftI_rRegI_immI8_rule,
  /*  243 */  _LShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  244 */  _SubI_immI0_rcx_RegI_rule,
  /*  245 */  _URShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI_rule,
  /*  246 */  _SubI_immI_32_rcx_RegI_rule,
  /*  247 */  _URShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI_rule,
  /*  248 */  _URShiftI_rRegI_immI1_rule,
  /*  249 */  _LShiftI_rRegI_immI_M1_rule,
  /*  250 */  _URShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  251 */  _LShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI_rule,
  /*  252 */  _LShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI_rule,
  /*  253 */  _LShiftL_rRegL_immI1_rule,
  /*  254 */  _URShiftL_rRegL_immI_M1_rule,
  /*  255 */  _LShiftL_rRegL_immI8_rule,
  /*  256 */  _URShiftL_rRegL_immI8_rule,
  /*  257 */  _LShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  258 */  _URShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI_rule,
  /*  259 */  _SubI_immI_64_rcx_RegI_rule,
  /*  260 */  _URShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI_rule,
  /*  261 */  _URShiftL_rRegL_immI1_rule,
  /*  262 */  _LShiftL_rRegL_immI_M1_rule,
  /*  263 */  _URShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  264 */  _LShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI_rule,
  /*  265 */  _LShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI_rule,
  /*  266 */  _AndI_rRegI_immI_255_rule,
  /*  267 */  _AndI_rRegI_immI_65535_rule,
  /*  268 */  _AndI__LoadI_memory__rRegI_rule,
  /*  269 */  _AndI_rRegI__LoadI_memory__rule,
  /*  270 */  _AndI__LoadI_memory__immI_rule,
  /*  271 */  _XorI_rRegI_immI_M1_rule,
  /*  272 */  _AddI_rRegI_immI_M1_rule,
  /*  273 */  _OrI__LoadI_memory__rRegI_rule,
  /*  274 */  _OrI_rRegI__LoadI_memory__rule,
  /*  275 */  _OrI__LoadI_memory__immI_rule,
  /*  276 */  _XorI__LoadI_memory__rRegI_rule,
  /*  277 */  _XorI_rRegI__LoadI_memory__rule,
  /*  278 */  _XorI__LoadI_memory__immI_rule,
  /*  279 */  _AndL__LoadL_memory__rRegL_rule,
  /*  280 */  _AndL_rRegL__LoadL_memory__rule,
  /*  281 */  _AndL__LoadL_memory__immL32_rule,
  /*  282 */  _XorL_rRegL_immL_M1_rule,
  /*  283 */  _SubL_immL0_rRegL_rule,
  /*  284 */  _AddL_rRegL_immL_M1_rule,
  /*  285 */  _CastP2X_any_RegP__rule,
  /*  286 */  _OrL__LoadL_memory__rRegL_rule,
  /*  287 */  _OrL_rRegL__LoadL_memory__rule,
  /*  288 */  _OrL__LoadL_memory__immL32_rule,
  /*  289 */  _XorL__LoadL_memory__rRegL_rule,
  /*  290 */  _XorL_rRegL__LoadL_memory__rule,
  /*  291 */  _XorL__LoadL_memory__immL32_rule,
  /*  292 */  _CmpLTMask_rRegI_rRegI_rule,
  /*  293 */  _AndI__CmpLTMask_rRegI_rRegI_rRegI_rule,
  /*  294 */  _SubI_rRegI_rRegI_rule,
  /*  295 */  _AndI_rRegI__CmpLTMask_rRegI_rRegI_rule,
  /*  296 */  _LoadF_memory__rule,
  /*  297 */  _LoadD_memory__rule,
  /*  298 */  _Binary_rdi_RegP_rcx_RegI_rule,
  /*  299 */  _Binary_rsi_RegP_rdx_RegI_rule,
  /*  300 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  301 */  _Binary_rsi_RegP_immI_rule,
  /*  302 */  _Binary_rsi_RegP_rax_RegI_rule,
  /*  303 */  _Binary_rdi_RegP_rsi_RegP_rule,
  /*  304 */  _AndI_rRegI_immI_rule,
  /*  305 */  _LoadP_memory__rule,
  /*  306 */  _LoadN_memory__rule,
  /*  307 */  _LoadNKlass_memory__rule,
  /*  308 */  _AndL_rRegL_immL32_rule,
  /*  309 */  _AndL__CastP2X_rRegP___LoadL_memory__rule,
  /*  310 */  _AndL__LoadL_memory___CastP2X_rRegP__rule,
  /*  311 */  _AndI__LoadB_memory__immI8_rule,
  /*  312 */  _PartialSubtypeCheck_rsi_RegP_rax_RegP_rule,
  /*  313 */  _LoadVector_memory__rule,
  /*  314 */  _Binary_cmpOp_vcmppd_immI8_rule,
  /*  315 */  _Binary_legVecY_legVecY_rule,
  /*  316 */  _Binary_vecX_vecX_rule,
  /*  317 */  _Binary_vecX__LoadVector_memory__rule,
  /*  318 */  _Binary_vecY_vecY_rule,
  /*  319 */  _Binary_vecY__LoadVector_memory__rule,
  /*  320 */  _Binary_vecZ_vecZ_rule,
  /*  321 */  _Binary_vecZ__LoadVector_memory__rule,
  // last internally defined operand
  /*  322 */  stackSlotI_rule,
  /*  323 */  stackSlotL_rule,
  /*  324 */  stackSlotP_rule,
  /*  325 */  stackSlotF_rule,
  /*  326 */  stackSlotD_rule,
  /*  327 */  vlRegF_rule,
  /*  328 */  legRegF_rule,
  /*  329 */  regF_rule,
  /*  330 */  regF_rule,
  /*  331 */  vlRegD_rule,
  /*  332 */  legRegD_rule,
  /*  333 */  regD_rule,
  /*  334 */  regD_rule,
  /*  335 */  rRegP_rule,
  /*  336 */  rRegP_rule,
  /*  337 */  rRegP_rule,
  /*  338 */  rRegP_rule,
  /*  339 */  rRegP_rule,
  /*  340 */  rRegP_rule,
  /*  341 */  rRegP_rule,
  /*  342 */  rRegP_rule,
  /*  343 */  rRegP_rule,
  /*  344 */  rRegP_rule,
  /*  345 */  rRegP_rule,
  /*  346 */  rRegP_rule,
  /*  347 */  rRegP_rule,
  /*  348 */  rRegP_rule,
  /*  349 */  rRegP_rule,
  /*  350 */  rRegP_rule,
  /*  351 */  rRegI_rule,
  /*  352 */  rRegI_rule,
  /*  353 */  rRegL_rule,
  /*  354 */  rRegL_rule,
  /*  355 */  rRegL_rule,
  /*  356 */  rRegL_rule,
  /*  357 */  rRegP_rule,
  /*  358 */  rRegP_rule,
  /*  359 */  rRegP_rule,
  /*  360 */  regF_rule,
  /*  361 */  rRegN_rule,
  /*  362 */  rRegN_rule,
  /*  363 */  rRegN_rule,
  /*  364 */  regF_rule,
  /*  365 */  regD_rule,
  /*  366 */  regD_rule,
  /*  367 */  rRegI_rule,
  /*  368 */  rRegL_rule,
  /*  369 */  rRegP_rule,
  /*  370 */  regF_rule,
  /*  371 */  regD_rule,
  /*  372 */  legVecS_rule,
  /*  373 */  vecS_rule,
  /*  374 */  legVecD_rule,
  /*  375 */  vecD_rule,
  /*  376 */  legVecX_rule,
  /*  377 */  vecX_rule,
  /*  378 */  legVecY_rule,
  /*  379 */  vecY_rule,
  /*  380 */  legVecZ_rule,
  /*  381 */  vecZ_rule,
  /*  382 */  vecS_rule,
  /*  383 */  Universe_rule,
  /*  384 */  rRegP_rule,
  /*  385 */  rRegL_rule,
  /*  386 */  rRegP_rule,
  /*  387 */  rRegP_rule,
  /*  388 */  rRegI_rule,
  /*  389 */  rFlagsReg_rule,
  /*  390 */  rFlagsReg_rule,
  /*  391 */  rFlagsReg_rule,
  /*  392 */  rFlagsRegU_rule,
  /*  393 */  rFlagsRegUCF_rule,
  /*  394 */  rFlagsRegU_rule,
  /*  395 */  rFlagsRegUCF_rule,
  /*  396 */  rFlagsRegU_rule,
  /*  397 */  rFlagsRegUCF_rule,
  /*  398 */  rFlagsRegU_rule,
  /*  399 */  rFlagsRegUCF_rule,
  /*  400 */  rFlagsRegU_rule,
  /*  401 */  rFlagsRegUCF_rule,
  /*  402 */  rFlagsRegU_rule,
  /*  403 */  rFlagsRegUCF_rule,
  /*  404 */  regF_rule,
  /*  405 */  regD_rule,
  /*  406 */  rRegI_rule,
  /*  407 */  regF_rule,
  /*  408 */  rRegL_rule,
  /*  409 */  regD_rule,
  /*  410 */  regD_rule,
  /*  411 */  rRegI_rule,
  /*  412 */  rRegL_rule,
  /*  413 */  regF_rule,
  /*  414 */  regD_rule,
  /*  415 */  rFlagsReg_rule,
  /*  416 */  rFlagsReg_rule,
  /*  417 */  rFlagsReg_rule,
  /*  418 */  rFlagsReg_rule,
  /*  419 */  rFlagsReg_rule,
  /*  420 */  rFlagsReg_rule,
  /*  421 */  rFlagsReg_rule,
  /*  422 */  rFlagsReg_rule,
  /*  423 */  rFlagsReg_rule,
  /*  424 */  rFlagsReg_rule,
  /*  425 */  rFlagsReg_rule,
  /*  426 */  rFlagsReg_rule,
  /*  427 */  rFlagsReg_rule,
  /*  428 */  rFlagsReg_rule,
  /*  429 */  rFlagsReg_rule,
  /*  430 */  rFlagsReg_rule,
  /*  431 */  rFlagsReg_rule,
  /*  432 */  rFlagsReg_rule,
  /*  433 */  rFlagsReg_rule,
  /*  434 */  rFlagsReg_rule,
  /*  435 */  rFlagsReg_rule,
  /*  436 */  rFlagsRegU_rule,
  /*  437 */  rFlagsRegU_rule,
  /*  438 */  rFlagsRegU_rule,
  /*  439 */  rFlagsRegU_rule,
  /*  440 */  rFlagsRegU_rule,
  /*  441 */  rFlagsRegU_rule,
  /*  442 */  rFlagsRegU_rule,
  /*  443 */  rFlagsReg_rule,
  /*  444 */  rFlagsReg_rule,
  /*  445 */  rFlagsReg_rule,
  /*  446 */  rFlagsRegU_rule,
  /*  447 */  rFlagsRegU_rule,
  /*  448 */  rFlagsRegU_rule,
  /*  449 */  rFlagsRegU_rule,
  /*  450 */  rFlagsRegU_rule,
  /*  451 */  rFlagsRegU_rule,
  /*  452 */  rFlagsReg_rule,
  /*  453 */  rFlagsReg_rule,
  /*  454 */  rFlagsReg_rule,
  /*  455 */  rFlagsReg_rule,
  /*  456 */  rFlagsReg_rule,
  /*  457 */  rFlagsReg_rule,
  /*  458 */  rFlagsReg_rule,
  /*  459 */  rFlagsReg_rule,
  /*  460 */  rFlagsReg_rule,
  /*  461 */  rFlagsReg_rule,
  /*  462 */  rFlagsReg_rule,
  /*  463 */  rFlagsReg_rule,
  /*  464 */  rFlagsRegU_rule,
  /*  465 */  rFlagsRegU_rule,
  /*  466 */  rFlagsRegU_rule,
  /*  467 */  rFlagsRegU_rule,
  /*  468 */  rFlagsReg_rule,
  /*  469 */  rFlagsReg_rule,
  /*  470 */  rFlagsReg_rule,
  /*  471 */  rFlagsReg_rule,
  /*  472 */  rFlagsReg_rule,
  /*  473 */  rFlagsReg_rule,
  /*  474 */  Universe_rule,
  /*  475 */  r15_RegP_rule,
  /*  476 */  regF_rule,
  /*  477 */  vlRegF_rule,
  /*  478 */  regD_rule,
  /*  479 */  vlRegD_rule,
  /*  480 */  regF_rule,
  /*  481 */  vlRegF_rule,
  /*  482 */  regD_rule,
  /*  483 */  vlRegD_rule,
  /*  484 */  vecX_rule,
  /*  485 */  vecX_rule,
  /*  486 */  vecY_rule,
  /*  487 */  vecY_rule,
  /*  488 */  vecZ_rule,
  /*  489 */  vecZ_rule,
  /*  490 */  vecD_rule,
  /*  491 */  vecD_rule,
  /*  492 */  vecX_rule,
  /*  493 */  vecX_rule,
  /*  494 */  vecY_rule,
  /*  495 */  vecY_rule,
  /*  496 */  vecZ_rule,
  /*  497 */  vecZ_rule,
  /*  498 */  vecS_rule,
  /*  499 */  vecS_rule,
  /*  500 */  vecS_rule,
  /*  501 */  vecD_rule,
  /*  502 */  vecX_rule,
  /*  503 */  vecY_rule,
  /*  504 */  vecZ_rule,
  /*  505 */  vecD_rule,
  /*  506 */  vecD_rule,
  /*  507 */  vecX_rule,
  /*  508 */  vecY_rule,
  /*  509 */  vecZ_rule,
  /*  510 */  vecD_rule,
  /*  511 */  vecX_rule,
  /*  512 */  vecY_rule,
  /*  513 */  vecZ_rule,
  /*  514 */  vecX_rule,
  /*  515 */  vecY_rule,
  /*  516 */  vecZ_rule,
  /*  517 */  vecD_rule,
  /*  518 */  vecX_rule,
  /*  519 */  vecY_rule,
  /*  520 */  vecZ_rule,
  /*  521 */  rRegI_rule,
  /*  522 */  rRegL_rule,
  /*  523 */  rRegI_rule,
  /*  524 */  rRegL_rule,
  /*  525 */  rRegL_rule,
  /*  526 */  rRegI_rule,
  /*  527 */  rRegI_rule,
  /*  528 */  rRegL_rule,
  /*  529 */  rRegI_rule,
  /*  530 */  rRegI_rule,
  /*  531 */  rRegL_rule,
  /*  532 */  rRegL_rule,
  /*  533 */  rRegL_rule,
  /*  534 */  rRegI_rule,
  /*  535 */  rRegI_rule,
  /*  536 */  rRegI_rule,
  /*  537 */  rRegI_rule,
  /*  538 */  rRegI_rule,
  /*  539 */  rRegL_rule,
  /*  540 */  rRegL_rule,
  /*  541 */  rRegL_rule,
  /*  542 */  rRegL_rule,
  /*  543 */  rRegL_rule,
  /*  544 */  rRegL_rule,
  /*  545 */  rRegI_rule,
  /*  546 */  rRegP_rule,
  /*  547 */  rRegN_rule,
  /*  548 */  rRegP_rule,
  /*  549 */  rRegN_rule,
  /*  550 */  regF_rule,
  /*  551 */  regD_rule,
  /*  552 */  regD_rule,
  /*  553 */  legRegF_rule,
  /*  554 */  legRegF_rule,
  /*  555 */  legRegD_rule,
  /*  556 */  legRegD_rule,
  /*  557 */  legRegF_rule,
  /*  558 */  legRegF_rule,
  /*  559 */  legRegD_rule,
  /*  560 */  legRegD_rule,
  /*  561 */  Universe_rule,
  /*  562 */  Universe_rule,
  /*  563 */  Universe_rule,
  /*  564 */  Universe_rule,
  /*  565 */  Universe_rule,
  /*  566 */  Universe_rule,
  /*  567 */  Universe_rule,
  /*  568 */  Universe_rule,
  /*  569 */  Universe_rule,
  /*  570 */  Universe_rule,
  /*  571 */  Universe_rule,
  /*  572 */  Universe_rule,
  /*  573 */  Universe_rule,
  /*  574 */  Universe_rule,
  /*  575 */  Universe_rule,
  /*  576 */  Universe_rule,
  /*  577 */  Universe_rule,
  /*  578 */  Universe_rule,
  /*  579 */  Universe_rule,
  /*  580 */  Universe_rule,
  /*  581 */  Universe_rule,
  /*  582 */  Universe_rule,
  /*  583 */  Universe_rule,
  /*  584 */  Universe_rule,
  /*  585 */  Universe_rule,
  /*  586 */  Universe_rule,
  /*  587 */  Universe_rule,
  /*  588 */  Universe_rule,
  /*  589 */  Universe_rule,
  /*  590 */  Universe_rule,
  /*  591 */  Universe_rule,
  /*  592 */  Universe_rule,
  /*  593 */  rRegI_rule,
  /*  594 */  rRegL_rule,
  /*  595 */  rRegI_rule,
  /*  596 */  rRegI_rule,
  /*  597 */  rRegI_rule,
  /*  598 */  rRegI_rule,
  /*  599 */  rRegI_rule,
  /*  600 */  rRegI_rule,
  /*  601 */  rRegI_rule,
  /*  602 */  rRegI_rule,
  /*  603 */  rRegI_rule,
  /*  604 */  rRegI_rule,
  /*  605 */  rRegI_rule,
  /*  606 */  rRegI_rule,
  /*  607 */  rRegI_rule,
  /*  608 */  rRegI_rule,
  /*  609 */  Universe_rule,
  /*  610 */  Universe_rule,
  /*  611 */  Universe_rule,
  /*  612 */  Universe_rule,
  /*  613 */  Universe_rule,
  /*  614 */  Universe_rule,
  /*  615 */  Universe_rule,
  /*  616 */  Universe_rule,
  /*  617 */  rRegI_rule,
  /*  618 */  rRegI_rule,
  /*  619 */  rRegN_rule,
  /*  620 */  rRegN_rule,
  /*  621 */  rRegP_rule,
  /*  622 */  rRegP_rule,
  /*  623 */  rRegN_rule,
  /*  624 */  rRegP_rule,
  /*  625 */  Universe_rule,
  /*  626 */  Universe_rule,
  /*  627 */  Universe_rule,
  /*  628 */  rRegI_rule,
  /*  629 */  rRegI_rule,
  /*  630 */  rRegI_rule,
  /*  631 */  rRegI_rule,
  /*  632 */  rRegI_rule,
  /*  633 */  rRegI_rule,
  /*  634 */  rRegN_rule,
  /*  635 */  rRegN_rule,
  /*  636 */  rRegN_rule,
  /*  637 */  rRegP_rule,
  /*  638 */  rRegP_rule,
  /*  639 */  rRegP_rule,
  /*  640 */  rRegL_rule,
  /*  641 */  rRegL_rule,
  /*  642 */  rRegL_rule,
  /*  643 */  rRegL_rule,
  /*  644 */  rRegL_rule,
  /*  645 */  rRegL_rule,
  /*  646 */  regF_rule,
  /*  647 */  regF_rule,
  /*  648 */  regF_rule,
  /*  649 */  regD_rule,
  /*  650 */  regD_rule,
  /*  651 */  regD_rule,
  /*  652 */  rRegI_rule,
  /*  653 */  rRegI_rule,
  /*  654 */  rRegI_rule,
  /*  655 */  rRegI_rule,
  /*  656 */  Universe_rule,
  /*  657 */  Universe_rule,
  /*  658 */  Universe_rule,
  /*  659 */  rRegI_rule,
  /*  660 */  Universe_rule,
  /*  661 */  rRegI_rule,
  /*  662 */  Universe_rule,
  /*  663 */  rRegI_rule,
  /*  664 */  rRegL_rule,
  /*  665 */  rRegL_rule,
  /*  666 */  rRegL_rule,
  /*  667 */  rRegL_rule,
  /*  668 */  Universe_rule,
  /*  669 */  Universe_rule,
  /*  670 */  Universe_rule,
  /*  671 */  rRegI_rule,
  /*  672 */  Universe_rule,
  /*  673 */  rRegL_rule,
  /*  674 */  Universe_rule,
  /*  675 */  rRegL_rule,
  /*  676 */  rRegP_rule,
  /*  677 */  rRegP_rule,
  /*  678 */  rRegP_rule,
  /*  679 */  rRegP_rule,
  /*  680 */  rRegI_rule,
  /*  681 */  rRegI_rule,
  /*  682 */  rRegI_rule,
  /*  683 */  rRegI_rule,
  /*  684 */  rRegI_rule,
  /*  685 */  rRegI_rule,
  /*  686 */  rRegI_rule,
  /*  687 */  rRegI_rule,
  /*  688 */  rRegI_rule,
  /*  689 */  rRegI_rule,
  /*  690 */  rRegI_rule,
  /*  691 */  rRegI_rule,
  /*  692 */  rax_RegI_rule,
  /*  693 */  rax_RegI_rule,
  /*  694 */  rax_RegI_rule,
  /*  695 */  rax_RegL_rule,
  /*  696 */  rax_RegN_rule,
  /*  697 */  rax_RegP_rule,
  /*  698 */  Universe_rule,
  /*  699 */  rRegI_rule,
  /*  700 */  Universe_rule,
  /*  701 */  rRegI_rule,
  /*  702 */  Universe_rule,
  /*  703 */  rRegI_rule,
  /*  704 */  Universe_rule,
  /*  705 */  rRegL_rule,
  /*  706 */  rRegI_rule,
  /*  707 */  rRegI_rule,
  /*  708 */  rRegI_rule,
  /*  709 */  rRegL_rule,
  /*  710 */  rRegP_rule,
  /*  711 */  rRegN_rule,
  /*  712 */  rRegI_rule,
  /*  713 */  rRegL_rule,
  /*  714 */  rRegI_rule,
  /*  715 */  rRegI_rule,
  /*  716 */  rRegI_rule,
  /*  717 */  Universe_rule,
  /*  718 */  Universe_rule,
  /*  719 */  rRegL_rule,
  /*  720 */  rRegI_rule,
  /*  721 */  rRegL_rule,
  /*  722 */  Universe_rule,
  /*  723 */  Universe_rule,
  /*  724 */  rRegP_rule,
  /*  725 */  rRegI_rule,
  /*  726 */  Universe_rule,
  /*  727 */  rRegL_rule,
  /*  728 */  Universe_rule,
  /*  729 */  rRegI_rule,
  /*  730 */  rRegI_rule,
  /*  731 */  rRegI_rule,
  /*  732 */  rRegI_rule,
  /*  733 */  rRegI_rule,
  /*  734 */  rRegL_rule,
  /*  735 */  rRegL_rule,
  /*  736 */  rRegL_rule,
  /*  737 */  rRegL_rule,
  /*  738 */  rRegL_rule,
  /*  739 */  rdx_RegL_rule,
  /*  740 */  rax_RegI_rule,
  /*  741 */  rax_RegL_rule,
  /*  742 */  Universe_rule,
  /*  743 */  Universe_rule,
  /*  744 */  0,
  /*  745 */  0,
  /*  746 */  0,
  /*  747 */  0,
  /*  748 */  rdx_RegL_rule,
  /*  749 */  rdx_RegI_rule,
  /*  750 */  rdx_RegL_rule,
  /*  751 */  rRegI_rule,
  /*  752 */  Universe_rule,
  /*  753 */  rRegI_rule,
  /*  754 */  Universe_rule,
  /*  755 */  rRegI_rule,
  /*  756 */  Universe_rule,
  /*  757 */  rRegI_rule,
  /*  758 */  Universe_rule,
  /*  759 */  rRegI_rule,
  /*  760 */  Universe_rule,
  /*  761 */  rRegI_rule,
  /*  762 */  Universe_rule,
  /*  763 */  rRegI_rule,
  /*  764 */  Universe_rule,
  /*  765 */  rRegI_rule,
  /*  766 */  Universe_rule,
  /*  767 */  rRegI_rule,
  /*  768 */  Universe_rule,
  /*  769 */  rRegL_rule,
  /*  770 */  Universe_rule,
  /*  771 */  rRegL_rule,
  /*  772 */  Universe_rule,
  /*  773 */  rRegL_rule,
  /*  774 */  Universe_rule,
  /*  775 */  rRegL_rule,
  /*  776 */  Universe_rule,
  /*  777 */  rRegL_rule,
  /*  778 */  Universe_rule,
  /*  779 */  rRegL_rule,
  /*  780 */  Universe_rule,
  /*  781 */  rRegL_rule,
  /*  782 */  Universe_rule,
  /*  783 */  rRegL_rule,
  /*  784 */  Universe_rule,
  /*  785 */  rRegL_rule,
  /*  786 */  Universe_rule,
  /*  787 */  rRegI_rule,
  /*  788 */  rRegI_rule,
  /*  789 */  0,
  /*  790 */  0,
  /*  791 */  0,
  /*  792 */  rRegI_rule,
  /*  793 */  rRegI_rule,
  /*  794 */  rRegI_rule,
  /*  795 */  rRegI_rule,
  /*  796 */  no_rcx_RegI_rule,
  /*  797 */  no_rcx_RegI_rule,
  /*  798 */  no_rcx_RegI_rule,
  /*  799 */  no_rcx_RegI_rule,
  /*  800 */  0,
  /*  801 */  0,
  /*  802 */  0,
  /*  803 */  rRegI_rule,
  /*  804 */  rRegI_rule,
  /*  805 */  rRegI_rule,
  /*  806 */  rRegI_rule,
  /*  807 */  no_rcx_RegI_rule,
  /*  808 */  no_rcx_RegI_rule,
  /*  809 */  no_rcx_RegI_rule,
  /*  810 */  no_rcx_RegI_rule,
  /*  811 */  0,
  /*  812 */  0,
  /*  813 */  0,
  /*  814 */  rRegL_rule,
  /*  815 */  rRegL_rule,
  /*  816 */  rRegL_rule,
  /*  817 */  rRegL_rule,
  /*  818 */  no_rcx_RegL_rule,
  /*  819 */  no_rcx_RegL_rule,
  /*  820 */  no_rcx_RegL_rule,
  /*  821 */  no_rcx_RegL_rule,
  /*  822 */  0,
  /*  823 */  0,
  /*  824 */  0,
  /*  825 */  rRegL_rule,
  /*  826 */  rRegL_rule,
  /*  827 */  rRegL_rule,
  /*  828 */  rRegL_rule,
  /*  829 */  no_rcx_RegL_rule,
  /*  830 */  no_rcx_RegL_rule,
  /*  831 */  no_rcx_RegL_rule,
  /*  832 */  no_rcx_RegL_rule,
  /*  833 */  rRegI_rule,
  /*  834 */  rRegI_rule,
  /*  835 */  rRegL_rule,
  /*  836 */  rRegI_rule,
  /*  837 */  rRegL_rule,
  /*  838 */  rRegI_rule,
  /*  839 */  rRegI_rule,
  /*  840 */  rRegI_rule,
  /*  841 */  Universe_rule,
  /*  842 */  Universe_rule,
  /*  843 */  Universe_rule,
  /*  844 */  rRegI_rule,
  /*  845 */  rRegI_rule,
  /*  846 */  rRegI_rule,
  /*  847 */  rRegI_rule,
  /*  848 */  rRegI_rule,
  /*  849 */  rRegI_rule,
  /*  850 */  rRegI_rule,
  /*  851 */  rRegI_rule,
  /*  852 */  rRegI_rule,
  /*  853 */  rRegI_rule,
  /*  854 */  rRegI_rule,
  /*  855 */  rRegI_rule,
  /*  856 */  rRegI_rule,
  /*  857 */  rRegI_rule,
  /*  858 */  rRegI_rule,
  /*  859 */  rRegI_rule,
  /*  860 */  rRegI_rule,
  /*  861 */  rRegI_rule,
  /*  862 */  rRegI_rule,
  /*  863 */  rRegI_rule,
  /*  864 */  Universe_rule,
  /*  865 */  Universe_rule,
  /*  866 */  Universe_rule,
  /*  867 */  rRegI_rule,
  /*  868 */  rRegI_rule,
  /*  869 */  rRegI_rule,
  /*  870 */  rRegI_rule,
  /*  871 */  rRegI_rule,
  /*  872 */  Universe_rule,
  /*  873 */  Universe_rule,
  /*  874 */  Universe_rule,
  /*  875 */  rRegL_rule,
  /*  876 */  rRegL_rule,
  /*  877 */  rRegL_rule,
  /*  878 */  rRegL_rule,
  /*  879 */  rRegL_rule,
  /*  880 */  rRegL_rule,
  /*  881 */  Universe_rule,
  /*  882 */  Universe_rule,
  /*  883 */  Universe_rule,
  /*  884 */  rRegL_rule,
  /*  885 */  rRegL_rule,
  /*  886 */  rRegL_rule,
  /*  887 */  rRegL_rule,
  /*  888 */  rRegL_rule,
  /*  889 */  rRegL_rule,
  /*  890 */  rRegL_rule,
  /*  891 */  rRegL_rule,
  /*  892 */  rRegL_rule,
  /*  893 */  rRegL_rule,
  /*  894 */  rRegL_rule,
  /*  895 */  rRegL_rule,
  /*  896 */  rRegL_rule,
  /*  897 */  rRegL_rule,
  /*  898 */  rRegL_rule,
  /*  899 */  rRegL_rule,
  /*  900 */  rRegL_rule,
  /*  901 */  rRegL_rule,
  /*  902 */  rRegL_rule,
  /*  903 */  rRegL_rule,
  /*  904 */  rRegL_rule,
  /*  905 */  rRegL_rule,
  /*  906 */  Universe_rule,
  /*  907 */  Universe_rule,
  /*  908 */  Universe_rule,
  /*  909 */  rRegL_rule,
  /*  910 */  rRegL_rule,
  /*  911 */  rRegL_rule,
  /*  912 */  rRegL_rule,
  /*  913 */  rRegL_rule,
  /*  914 */  Universe_rule,
  /*  915 */  Universe_rule,
  /*  916 */  Universe_rule,
  /*  917 */  rRegI_rule,
  /*  918 */  rRegI_rule,
  /*  919 */  rRegI_rule,
  /*  920 */  rRegI_rule,
  /*  921 */  rRegI_rule,
  /*  922 */  rRegI_rule,
  /*  923 */  rRegI_rule,
  /*  924 */  rRegI_rule,
  /*  925 */  rRegI_rule,
  /*  926 */  rRegI_rule,
  /*  927 */  rRegI_rule,
  /*  928 */  rRegI_rule,
  /*  929 */  rRegI_rule,
  /*  930 */  rRegI_rule,
  /*  931 */  rRegI_rule,
  /*  932 */  rRegI_rule,
  /*  933 */  regD_rule,
  /*  934 */  regD_rule,
  /*  935 */  regF_rule,
  /*  936 */  regF_rule,
  /*  937 */  rRegI_rule,
  /*  938 */  rRegL_rule,
  /*  939 */  rRegI_rule,
  /*  940 */  rRegL_rule,
  /*  941 */  regF_rule,
  /*  942 */  regF_rule,
  /*  943 */  regD_rule,
  /*  944 */  regD_rule,
  /*  945 */  regF_rule,
  /*  946 */  regD_rule,
  /*  947 */  regF_rule,
  /*  948 */  regF_rule,
  /*  949 */  regD_rule,
  /*  950 */  regD_rule,
  /*  951 */  rRegL_rule,
  /*  952 */  rRegL_rule,
  /*  953 */  rRegL_rule,
  /*  954 */  rRegL_rule,
  /*  955 */  rRegI_rule,
  /*  956 */  stackSlotI_rule,
  /*  957 */  stackSlotF_rule,
  /*  958 */  stackSlotL_rule,
  /*  959 */  stackSlotD_rule,
  /*  960 */  Universe_rule,
  /*  961 */  Universe_rule,
  /*  962 */  rax_RegI_rule,
  /*  963 */  rax_RegI_rule,
  /*  964 */  rax_RegI_rule,
  /*  965 */  rax_RegI_rule,
  /*  966 */  rbx_RegI_rule,
  /*  967 */  rbx_RegI_rule,
  /*  968 */  rbx_RegI_rule,
  /*  969 */  rbx_RegI_rule,
  /*  970 */  rbx_RegI_rule,
  /*  971 */  rbx_RegI_rule,
  /*  972 */  rbx_RegI_rule,
  /*  973 */  rax_RegI_rule,
  /*  974 */  rax_RegI_rule,
  /*  975 */  rax_RegI_rule,
  /*  976 */  rax_RegI_rule,
  /*  977 */  rax_RegI_rule,
  /*  978 */  Universe_rule,
  /*  979 */  rax_RegI_rule,
  /*  980 */  rRegI_rule,
  /*  981 */  0,
  /*  982 */  rRegI_rule,
  /*  983 */  0,
  /*  984 */  rRegI_rule,
  /*  985 */  Universe_rule,
  /*  986 */  Universe_rule,
  /*  987 */  Universe_rule,
  /*  988 */  Universe_rule,
  /*  989 */  Universe_rule,
  /*  990 */  Universe_rule,
  /*  991 */  Universe_rule,
  /*  992 */  Universe_rule,
  /*  993 */  Universe_rule,
  /*  994 */  Universe_rule,
  /*  995 */  Universe_rule,
  /*  996 */  rdi_RegP_rule,
  /*  997 */  Universe_rule,
  /*  998 */  Universe_rule,
  /*  999 */  Universe_rule,
  /* 1000 */  Universe_rule,
  /* 1001 */  Universe_rule,
  /* 1002 */  Universe_rule,
  /* 1003 */  Universe_rule,
  /* 1004 */  Universe_rule,
  /* 1005 */  Universe_rule,
  /* 1006 */  Universe_rule,
  /* 1007 */  Universe_rule,
  /* 1008 */  Universe_rule,
  /* 1009 */  Universe_rule,
  /* 1010 */  Universe_rule,
  /* 1011 */  Universe_rule,
  /* 1012 */  Universe_rule,
  /* 1013 */  Universe_rule,
  /* 1014 */  Universe_rule,
  /* 1015 */  rax_RegP_rule,
  /* 1016 */  Universe_rule,
  /* 1017 */  rRegP_rule,
  /* 1018 */  rRegP_rule,
  /* 1019 */  rRegP_rule,
  /* 1020 */  rRegP_rule,
  /* 1021 */  rRegP_rule,
  /* 1022 */  rRegP_rule,
  /* 1023 */  Universe_rule,
  /* 1024 */  rRegI_rule,
  /* 1025 */  regF_rule,
  /* 1026 */  regF_rule,
  /* 1027 */  regF_rule,
  /* 1028 */  regF_rule,
  /* 1029 */  regF_rule,
  /* 1030 */  regF_rule,
  /* 1031 */  regF_rule,
  /* 1032 */  regF_rule,
  /* 1033 */  regD_rule,
  /* 1034 */  regD_rule,
  /* 1035 */  regD_rule,
  /* 1036 */  regD_rule,
  /* 1037 */  regD_rule,
  /* 1038 */  regD_rule,
  /* 1039 */  regD_rule,
  /* 1040 */  regD_rule,
  /* 1041 */  regF_rule,
  /* 1042 */  regF_rule,
  /* 1043 */  regF_rule,
  /* 1044 */  regF_rule,
  /* 1045 */  regF_rule,
  /* 1046 */  regF_rule,
  /* 1047 */  regD_rule,
  /* 1048 */  regD_rule,
  /* 1049 */  regD_rule,
  /* 1050 */  regD_rule,
  /* 1051 */  regD_rule,
  /* 1052 */  regD_rule,
  /* 1053 */  regF_rule,
  /* 1054 */  regF_rule,
  /* 1055 */  regF_rule,
  /* 1056 */  regF_rule,
  /* 1057 */  regF_rule,
  /* 1058 */  regF_rule,
  /* 1059 */  regF_rule,
  /* 1060 */  regF_rule,
  /* 1061 */  regD_rule,
  /* 1062 */  regD_rule,
  /* 1063 */  regD_rule,
  /* 1064 */  regD_rule,
  /* 1065 */  regD_rule,
  /* 1066 */  regD_rule,
  /* 1067 */  regD_rule,
  /* 1068 */  regD_rule,
  /* 1069 */  regF_rule,
  /* 1070 */  regF_rule,
  /* 1071 */  regF_rule,
  /* 1072 */  regF_rule,
  /* 1073 */  regF_rule,
  /* 1074 */  regF_rule,
  /* 1075 */  regD_rule,
  /* 1076 */  regD_rule,
  /* 1077 */  regD_rule,
  /* 1078 */  regD_rule,
  /* 1079 */  regD_rule,
  /* 1080 */  regD_rule,
  /* 1081 */  regF_rule,
  /* 1082 */  regF_rule,
  /* 1083 */  regF_rule,
  /* 1084 */  regD_rule,
  /* 1085 */  regD_rule,
  /* 1086 */  regD_rule,
  /* 1087 */  legRegD_rule,
  /* 1088 */  legRegD_rule,
  /* 1089 */  legRegD_rule,
  /* 1090 */  legVecX_rule,
  /* 1091 */  legVecX_rule,
  /* 1092 */  legVecY_rule,
  /* 1093 */  legVecY_rule,
  /* 1094 */  vecZ_rule,
  /* 1095 */  vecZ_rule,
  /* 1096 */  Universe_rule,
  /* 1097 */  regD_rule,
  /* 1098 */  regF_rule,
  /* 1099 */  vecS_rule,
  /* 1100 */  vecD_rule,
  /* 1101 */  vecX_rule,
  /* 1102 */  vecY_rule,
  /* 1103 */  vecZ_rule,
  /* 1104 */  vecZ_rule,
  /* 1105 */  Universe_rule,
  /* 1106 */  Universe_rule,
  /* 1107 */  Universe_rule,
  /* 1108 */  Universe_rule,
  /* 1109 */  Universe_rule,
  /* 1110 */  Universe_rule,
  /* 1111 */  vecX_rule,
  /* 1112 */  vecY_rule,
  /* 1113 */  legVecZ_rule,
  /* 1114 */  vecX_rule,
  /* 1115 */  vecY_rule,
  /* 1116 */  legVecZ_rule,
  /* 1117 */  vecD_rule,
  /* 1118 */  vecD_rule,
  /* 1119 */  vecX_rule,
  /* 1120 */  vecX_rule,
  /* 1121 */  vecX_rule,
  /* 1122 */  vecY_rule,
  /* 1123 */  vecY_rule,
  /* 1124 */  vecY_rule,
  /* 1125 */  legVecZ_rule,
  /* 1126 */  legVecZ_rule,
  /* 1127 */  legVecZ_rule,
  /* 1128 */  vecX_rule,
  /* 1129 */  vecX_rule,
  /* 1130 */  vecY_rule,
  /* 1131 */  vecY_rule,
  /* 1132 */  legVecZ_rule,
  /* 1133 */  legVecZ_rule,
  /* 1134 */  vecX_rule,
  /* 1135 */  vecY_rule,
  /* 1136 */  legVecZ_rule,
  /* 1137 */  vecX_rule,
  /* 1138 */  vecY_rule,
  /* 1139 */  legVecZ_rule,
  /* 1140 */  vecY_rule,
  /* 1141 */  legVecZ_rule,
  /* 1142 */  vecY_rule,
  /* 1143 */  legVecZ_rule,
  /* 1144 */  vecD_rule,
  /* 1145 */  vecX_rule,
  /* 1146 */  vecY_rule,
  /* 1147 */  vecY_rule,
  /* 1148 */  legVecZ_rule,
  /* 1149 */  legVecZ_rule,
  /* 1150 */  vecD_rule,
  /* 1151 */  vecX_rule,
  /* 1152 */  vecY_rule,
  /* 1153 */  vecX_rule,
  /* 1154 */  vecY_rule,
  /* 1155 */  vecY_rule,
  /* 1156 */  legVecZ_rule,
  /* 1157 */  legVecZ_rule,
  /* 1158 */  vecX_rule,
  /* 1159 */  vecY_rule,
  /* 1160 */  vecS_rule,
  /* 1161 */  vecD_rule,
  /* 1162 */  vecS_rule,
  /* 1163 */  vecD_rule,
  /* 1164 */  vecS_rule,
  /* 1165 */  vecD_rule,
  /* 1166 */  vecX_rule,
  /* 1167 */  vecY_rule,
  /* 1168 */  vecS_rule,
  /* 1169 */  vecS_rule,
  /* 1170 */  vecD_rule,
  /* 1171 */  vecS_rule,
  /* 1172 */  vecD_rule,
  /* 1173 */  vecX_rule,
  /* 1174 */  vecY_rule,
  /* 1175 */  vecD_rule,
  /* 1176 */  vecD_rule,
  /* 1177 */  vecD_rule,
  /* 1178 */  vecD_rule,
  /* 1179 */  vecX_rule,
  /* 1180 */  vecY_rule,
  /* 1181 */  vecX_rule,
  /* 1182 */  vecX_rule,
  /* 1183 */  vecX_rule,
  /* 1184 */  vecY_rule,
  /* 1185 */  vecD_rule,
  /* 1186 */  vecX_rule,
  /* 1187 */  vecX_rule,
  /* 1188 */  vecS_rule,
  /* 1189 */  vecD_rule,
  /* 1190 */  vecX_rule,
  /* 1191 */  vecX_rule,
  /* 1192 */  vecY_rule,
  /* 1193 */  vecY_rule,
  /* 1194 */  vecZ_rule,
  /* 1195 */  vecZ_rule,
  /* 1196 */  vecX_rule,
  /* 1197 */  vecY_rule,
  /* 1198 */  vecZ_rule,
  /* 1199 */  vecZ_rule,
  /* 1200 */  vecD_rule,
  /* 1201 */  vecD_rule,
  /* 1202 */  vecX_rule,
  /* 1203 */  vecX_rule,
  /* 1204 */  vecY_rule,
  /* 1205 */  vecY_rule,
  /* 1206 */  vecZ_rule,
  /* 1207 */  vecZ_rule,
  /* 1208 */  vecX_rule,
  /* 1209 */  vecY_rule,
  /* 1210 */  vecZ_rule,
  /* 1211 */  vecZ_rule,
  /* 1212 */  vecX_rule,
  /* 1213 */  vecX_rule,
  /* 1214 */  vecY_rule,
  /* 1215 */  vecY_rule,
  /* 1216 */  vecZ_rule,
  /* 1217 */  vecZ_rule,
  /* 1218 */  vecX_rule,
  /* 1219 */  vecY_rule,
  /* 1220 */  vecZ_rule,
  /* 1221 */  vecZ_rule,
  /* 1222 */  vecY_rule,
  /* 1223 */  vecZ_rule,
  /* 1224 */  vecY_rule,
  /* 1225 */  vecZ_rule,
  /* 1226 */  vecX_rule,
  /* 1227 */  vecY_rule,
  /* 1228 */  vecZ_rule,
  /* 1229 */  vecZ_rule,
  /* 1230 */  vecY_rule,
  /* 1231 */  vecY_rule,
  /* 1232 */  vecZ_rule,
  /* 1233 */  vecZ_rule,
  /* 1234 */  vecZ_rule,
  /* 1235 */  vecY_rule,
  /* 1236 */  vecY_rule,
  /* 1237 */  vecZ_rule,
  /* 1238 */  vecZ_rule,
  /* 1239 */  vecZ_rule,
  /* 1240 */  rRegI_rule,
  /* 1241 */  rRegI_rule,
  /* 1242 */  rRegI_rule,
  /* 1243 */  rRegI_rule,
  /* 1244 */  rRegI_rule,
  /* 1245 */  rRegI_rule,
  /* 1246 */  rRegI_rule,
  /* 1247 */  rRegI_rule,
  /* 1248 */  rRegI_rule,
  /* 1249 */  rRegL_rule,
  /* 1250 */  rRegL_rule,
  /* 1251 */  rRegL_rule,
  /* 1252 */  regF_rule,
  /* 1253 */  regF_rule,
  /* 1254 */  regF_rule,
  /* 1255 */  regF_rule,
  /* 1256 */  regF_rule,
  /* 1257 */  regF_rule,
  /* 1258 */  regD_rule,
  /* 1259 */  regD_rule,
  /* 1260 */  regD_rule,
  /* 1261 */  regD_rule,
  /* 1262 */  rRegI_rule,
  /* 1263 */  rRegI_rule,
  /* 1264 */  rRegI_rule,
  /* 1265 */  rRegI_rule,
  /* 1266 */  rRegI_rule,
  /* 1267 */  rRegI_rule,
  /* 1268 */  rRegL_rule,
  /* 1269 */  rRegL_rule,
  /* 1270 */  rRegL_rule,
  /* 1271 */  regF_rule,
  /* 1272 */  regF_rule,
  /* 1273 */  regF_rule,
  /* 1274 */  regF_rule,
  /* 1275 */  regF_rule,
  /* 1276 */  regF_rule,
  /* 1277 */  regD_rule,
  /* 1278 */  regD_rule,
  /* 1279 */  regD_rule,
  /* 1280 */  regD_rule,
  /* 1281 */  vecS_rule,
  /* 1282 */  vecS_rule,
  /* 1283 */  vecS_rule,
  /* 1284 */  vecS_rule,
  /* 1285 */  vecD_rule,
  /* 1286 */  vecD_rule,
  /* 1287 */  vecD_rule,
  /* 1288 */  vecD_rule,
  /* 1289 */  vecX_rule,
  /* 1290 */  vecX_rule,
  /* 1291 */  vecX_rule,
  /* 1292 */  vecX_rule,
  /* 1293 */  vecY_rule,
  /* 1294 */  vecY_rule,
  /* 1295 */  vecY_rule,
  /* 1296 */  vecZ_rule,
  /* 1297 */  vecZ_rule,
  /* 1298 */  vecZ_rule,
  /* 1299 */  vecS_rule,
  /* 1300 */  vecS_rule,
  /* 1301 */  vecS_rule,
  /* 1302 */  vecS_rule,
  /* 1303 */  vecD_rule,
  /* 1304 */  vecD_rule,
  /* 1305 */  vecD_rule,
  /* 1306 */  vecD_rule,
  /* 1307 */  vecX_rule,
  /* 1308 */  vecX_rule,
  /* 1309 */  vecX_rule,
  /* 1310 */  vecX_rule,
  /* 1311 */  vecY_rule,
  /* 1312 */  vecY_rule,
  /* 1313 */  vecY_rule,
  /* 1314 */  vecZ_rule,
  /* 1315 */  vecZ_rule,
  /* 1316 */  vecZ_rule,
  /* 1317 */  vecD_rule,
  /* 1318 */  vecD_rule,
  /* 1319 */  vecD_rule,
  /* 1320 */  vecD_rule,
  /* 1321 */  vecX_rule,
  /* 1322 */  vecX_rule,
  /* 1323 */  vecX_rule,
  /* 1324 */  vecX_rule,
  /* 1325 */  vecY_rule,
  /* 1326 */  vecY_rule,
  /* 1327 */  vecY_rule,
  /* 1328 */  vecZ_rule,
  /* 1329 */  vecZ_rule,
  /* 1330 */  vecZ_rule,
  /* 1331 */  vecX_rule,
  /* 1332 */  vecX_rule,
  /* 1333 */  vecX_rule,
  /* 1334 */  vecX_rule,
  /* 1335 */  vecY_rule,
  /* 1336 */  vecY_rule,
  /* 1337 */  vecY_rule,
  /* 1338 */  vecZ_rule,
  /* 1339 */  vecZ_rule,
  /* 1340 */  vecZ_rule,
  /* 1341 */  vecD_rule,
  /* 1342 */  vecD_rule,
  /* 1343 */  vecD_rule,
  /* 1344 */  vecD_rule,
  /* 1345 */  vecX_rule,
  /* 1346 */  vecX_rule,
  /* 1347 */  vecX_rule,
  /* 1348 */  vecX_rule,
  /* 1349 */  vecY_rule,
  /* 1350 */  vecY_rule,
  /* 1351 */  vecY_rule,
  /* 1352 */  vecZ_rule,
  /* 1353 */  vecZ_rule,
  /* 1354 */  vecZ_rule,
  /* 1355 */  vecX_rule,
  /* 1356 */  vecX_rule,
  /* 1357 */  vecX_rule,
  /* 1358 */  vecX_rule,
  /* 1359 */  vecY_rule,
  /* 1360 */  vecY_rule,
  /* 1361 */  vecY_rule,
  /* 1362 */  vecZ_rule,
  /* 1363 */  vecZ_rule,
  /* 1364 */  vecZ_rule,
  /* 1365 */  vecS_rule,
  /* 1366 */  vecS_rule,
  /* 1367 */  vecS_rule,
  /* 1368 */  vecD_rule,
  /* 1369 */  vecD_rule,
  /* 1370 */  vecD_rule,
  /* 1371 */  vecX_rule,
  /* 1372 */  vecX_rule,
  /* 1373 */  vecX_rule,
  /* 1374 */  vecY_rule,
  /* 1375 */  vecY_rule,
  /* 1376 */  vecZ_rule,
  /* 1377 */  vecZ_rule,
  /* 1378 */  vecS_rule,
  /* 1379 */  vecS_rule,
  /* 1380 */  vecS_rule,
  /* 1381 */  vecD_rule,
  /* 1382 */  vecD_rule,
  /* 1383 */  vecD_rule,
  /* 1384 */  vecX_rule,
  /* 1385 */  vecX_rule,
  /* 1386 */  vecX_rule,
  /* 1387 */  vecY_rule,
  /* 1388 */  vecY_rule,
  /* 1389 */  vecZ_rule,
  /* 1390 */  vecZ_rule,
  /* 1391 */  vecD_rule,
  /* 1392 */  vecD_rule,
  /* 1393 */  vecD_rule,
  /* 1394 */  vecX_rule,
  /* 1395 */  vecX_rule,
  /* 1396 */  vecX_rule,
  /* 1397 */  vecY_rule,
  /* 1398 */  vecY_rule,
  /* 1399 */  vecZ_rule,
  /* 1400 */  vecZ_rule,
  /* 1401 */  vecX_rule,
  /* 1402 */  vecX_rule,
  /* 1403 */  vecX_rule,
  /* 1404 */  vecY_rule,
  /* 1405 */  vecY_rule,
  /* 1406 */  vecZ_rule,
  /* 1407 */  vecZ_rule,
  /* 1408 */  vecD_rule,
  /* 1409 */  vecD_rule,
  /* 1410 */  vecD_rule,
  /* 1411 */  vecX_rule,
  /* 1412 */  vecX_rule,
  /* 1413 */  vecX_rule,
  /* 1414 */  vecY_rule,
  /* 1415 */  vecY_rule,
  /* 1416 */  vecZ_rule,
  /* 1417 */  vecZ_rule,
  /* 1418 */  vecX_rule,
  /* 1419 */  vecX_rule,
  /* 1420 */  vecX_rule,
  /* 1421 */  vecY_rule,
  /* 1422 */  vecY_rule,
  /* 1423 */  vecZ_rule,
  /* 1424 */  vecZ_rule,
  /* 1425 */  vecS_rule,
  /* 1426 */  vecD_rule,
  /* 1427 */  vecX_rule,
  /* 1428 */  vecX_rule,
  /* 1429 */  vecY_rule,
  /* 1430 */  vecZ_rule,
  /* 1431 */  vecS_rule,
  /* 1432 */  vecS_rule,
  /* 1433 */  vecS_rule,
  /* 1434 */  vecS_rule,
  /* 1435 */  vecD_rule,
  /* 1436 */  vecD_rule,
  /* 1437 */  vecD_rule,
  /* 1438 */  vecD_rule,
  /* 1439 */  vecX_rule,
  /* 1440 */  vecX_rule,
  /* 1441 */  vecX_rule,
  /* 1442 */  vecX_rule,
  /* 1443 */  vecY_rule,
  /* 1444 */  vecY_rule,
  /* 1445 */  vecY_rule,
  /* 1446 */  vecZ_rule,
  /* 1447 */  vecZ_rule,
  /* 1448 */  vecZ_rule,
  /* 1449 */  vecD_rule,
  /* 1450 */  vecD_rule,
  /* 1451 */  vecD_rule,
  /* 1452 */  vecD_rule,
  /* 1453 */  vecX_rule,
  /* 1454 */  vecX_rule,
  /* 1455 */  vecX_rule,
  /* 1456 */  vecX_rule,
  /* 1457 */  vecX_rule,
  /* 1458 */  vecX_rule,
  /* 1459 */  vecX_rule,
  /* 1460 */  vecY_rule,
  /* 1461 */  vecY_rule,
  /* 1462 */  vecY_rule,
  /* 1463 */  vecZ_rule,
  /* 1464 */  vecZ_rule,
  /* 1465 */  vecZ_rule,
  /* 1466 */  vecY_rule,
  /* 1467 */  vecY_rule,
  /* 1468 */  vecY_rule,
  /* 1469 */  vecZ_rule,
  /* 1470 */  vecZ_rule,
  /* 1471 */  vecZ_rule,
  /* 1472 */  vecD_rule,
  /* 1473 */  vecD_rule,
  /* 1474 */  vecD_rule,
  /* 1475 */  vecD_rule,
  /* 1476 */  vecX_rule,
  /* 1477 */  vecX_rule,
  /* 1478 */  vecX_rule,
  /* 1479 */  vecX_rule,
  /* 1480 */  vecY_rule,
  /* 1481 */  vecY_rule,
  /* 1482 */  vecY_rule,
  /* 1483 */  vecZ_rule,
  /* 1484 */  vecZ_rule,
  /* 1485 */  vecZ_rule,
  /* 1486 */  vecX_rule,
  /* 1487 */  vecX_rule,
  /* 1488 */  vecX_rule,
  /* 1489 */  vecX_rule,
  /* 1490 */  vecY_rule,
  /* 1491 */  vecY_rule,
  /* 1492 */  vecY_rule,
  /* 1493 */  vecZ_rule,
  /* 1494 */  vecZ_rule,
  /* 1495 */  vecZ_rule,
  /* 1496 */  legVecY_rule,
  /* 1497 */  legVecY_rule,
  /* 1498 */  vecD_rule,
  /* 1499 */  vecD_rule,
  /* 1500 */  vecD_rule,
  /* 1501 */  vecX_rule,
  /* 1502 */  vecX_rule,
  /* 1503 */  vecX_rule,
  /* 1504 */  vecY_rule,
  /* 1505 */  vecY_rule,
  /* 1506 */  vecZ_rule,
  /* 1507 */  vecZ_rule,
  /* 1508 */  vecX_rule,
  /* 1509 */  vecX_rule,
  /* 1510 */  vecX_rule,
  /* 1511 */  vecY_rule,
  /* 1512 */  vecY_rule,
  /* 1513 */  vecZ_rule,
  /* 1514 */  vecZ_rule,
  /* 1515 */  vecS_rule,
  /* 1516 */  vecS_rule,
  /* 1517 */  vecS_rule,
  /* 1518 */  vecD_rule,
  /* 1519 */  vecD_rule,
  /* 1520 */  vecD_rule,
  /* 1521 */  vecX_rule,
  /* 1522 */  vecX_rule,
  /* 1523 */  vecX_rule,
  /* 1524 */  vecX_rule,
  /* 1525 */  vecX_rule,
  /* 1526 */  vecX_rule,
  /* 1527 */  vecY_rule,
  /* 1528 */  vecY_rule,
  /* 1529 */  vecY_rule,
  /* 1530 */  vecZ_rule,
  /* 1531 */  vecZ_rule,
  /* 1532 */  vecZ_rule,
  /* 1533 */  vecS_rule,
  /* 1534 */  vecS_rule,
  /* 1535 */  vecS_rule,
  /* 1536 */  vecD_rule,
  /* 1537 */  vecD_rule,
  /* 1538 */  vecD_rule,
  /* 1539 */  vecX_rule,
  /* 1540 */  vecX_rule,
  /* 1541 */  vecX_rule,
  /* 1542 */  vecY_rule,
  /* 1543 */  vecY_rule,
  /* 1544 */  vecY_rule,
  /* 1545 */  vecZ_rule,
  /* 1546 */  vecZ_rule,
  /* 1547 */  vecZ_rule,
  /* 1548 */  vecD_rule,
  /* 1549 */  vecD_rule,
  /* 1550 */  vecD_rule,
  /* 1551 */  vecX_rule,
  /* 1552 */  vecX_rule,
  /* 1553 */  vecX_rule,
  /* 1554 */  vecY_rule,
  /* 1555 */  vecY_rule,
  /* 1556 */  vecY_rule,
  /* 1557 */  vecZ_rule,
  /* 1558 */  vecZ_rule,
  /* 1559 */  vecZ_rule,
  /* 1560 */  vecX_rule,
  /* 1561 */  vecX_rule,
  /* 1562 */  vecY_rule,
  /* 1563 */  vecY_rule,
  /* 1564 */  vecZ_rule,
  /* 1565 */  vecZ_rule,
  /* 1566 */  vecZ_rule,
  /* 1567 */  vecX_rule,
  /* 1568 */  vecX_rule,
  /* 1569 */  vecY_rule,
  /* 1570 */  vecY_rule,
  /* 1571 */  vecS_rule,
  /* 1572 */  vecS_rule,
  /* 1573 */  vecS_rule,
  /* 1574 */  vecS_rule,
  /* 1575 */  vecD_rule,
  /* 1576 */  vecD_rule,
  /* 1577 */  vecD_rule,
  /* 1578 */  vecD_rule,
  /* 1579 */  vecX_rule,
  /* 1580 */  vecX_rule,
  /* 1581 */  vecX_rule,
  /* 1582 */  vecX_rule,
  /* 1583 */  vecY_rule,
  /* 1584 */  vecY_rule,
  /* 1585 */  vecY_rule,
  /* 1586 */  vecZ_rule,
  /* 1587 */  vecZ_rule,
  /* 1588 */  vecZ_rule,
  /* 1589 */  vecS_rule,
  /* 1590 */  vecS_rule,
  /* 1591 */  vecS_rule,
  /* 1592 */  vecS_rule,
  /* 1593 */  vecD_rule,
  /* 1594 */  vecD_rule,
  /* 1595 */  vecD_rule,
  /* 1596 */  vecD_rule,
  /* 1597 */  vecX_rule,
  /* 1598 */  vecX_rule,
  /* 1599 */  vecX_rule,
  /* 1600 */  vecX_rule,
  /* 1601 */  vecY_rule,
  /* 1602 */  vecY_rule,
  /* 1603 */  vecY_rule,
  /* 1604 */  vecZ_rule,
  /* 1605 */  vecZ_rule,
  /* 1606 */  vecZ_rule,
  /* 1607 */  vecS_rule,
  /* 1608 */  vecS_rule,
  /* 1609 */  vecS_rule,
  /* 1610 */  vecS_rule,
  /* 1611 */  vecD_rule,
  /* 1612 */  vecD_rule,
  /* 1613 */  vecD_rule,
  /* 1614 */  vecD_rule,
  /* 1615 */  vecX_rule,
  /* 1616 */  vecX_rule,
  /* 1617 */  vecX_rule,
  /* 1618 */  vecX_rule,
  /* 1619 */  vecY_rule,
  /* 1620 */  vecY_rule,
  /* 1621 */  vecY_rule,
  /* 1622 */  vecZ_rule,
  /* 1623 */  vecZ_rule,
  /* 1624 */  vecZ_rule,
  /* 1625 */  vecX_rule,
  /* 1626 */  vecX_rule,
  /* 1627 */  vecY_rule,
  /* 1628 */  vecY_rule,
  /* 1629 */  vecZ_rule,
  /* 1630 */  vecZ_rule,
  /* 1631 */  vecD_rule,
  /* 1632 */  vecD_rule,
  /* 1633 */  vecX_rule,
  /* 1634 */  vecX_rule,
  /* 1635 */  vecY_rule,
  /* 1636 */  vecY_rule,
  /* 1637 */  vecZ_rule,
  /* 1638 */  vecZ_rule,
  /* 1639 */  vecX_rule,
  /* 1640 */  vecX_rule,
  /* 1641 */  vecY_rule,
  /* 1642 */  vecY_rule,
  /* 1643 */  vecZ_rule,
  /* 1644 */  vecZ_rule,
  /* 1645 */  vecX_rule,
  /* 1646 */  vecX_rule,
  /* 1647 */  vecY_rule,
  /* 1648 */  vecY_rule,
  /* 1649 */  vecZ_rule,
  /* 1650 */  vecZ_rule,
  /* 1651 */  rRegI_rule,
  /* 1652 */  rRegI_rule,
  /* 1653 */  rRegI_rule,
  /* 1654 */  rRegI_rule,
  /* 1655 */  rax_RegN_rule,
  /* 1656 */  rax_RegP_rule,
  // last instruction
  0 // no trailing comma
};

const        int   leftOp[] = {
  /*    0 */  0,
  /*    1 */  0,
  /*    2 */  0,
  /*    3 */  0,
  /*    4 */  0,
  /*    5 */  0,
  /*    6 */  0,
  /*    7 */  0,
  /*    8 */  0,
  /*    9 */  0,
  /*   10 */  0,
  /*   11 */  0,
  /*   12 */  0,
  /*   13 */  0,
  /*   14 */  0,
  /*   15 */  0,
  /*   16 */  0,
  /*   17 */  0,
  /*   18 */  0,
  /*   19 */  0,
  /*   20 */  0,
  /*   21 */  0,
  /*   22 */  0,
  /*   23 */  0,
  /*   24 */  0,
  /*   25 */  0,
  /*   26 */  0,
  /*   27 */  0,
  /*   28 */  0,
  /*   29 */  0,
  /*   30 */  0,
  /*   31 */  0,
  /*   32 */  0,
  /*   33 */  0,
  /*   34 */  0,
  /*   35 */  0,
  /*   36 */  0,
  /*   37 */  0,
  /*   38 */  0,
  /*   39 */  0,
  /*   40 */  0,
  /*   41 */  0,
  /*   42 */  0,
  /*   43 */  0,
  /*   44 */  0,
  /*   45 */  0,
  /*   46 */  0,
  /*   47 */  0,
  /*   48 */  0,
  /*   49 */  0,
  /*   50 */  0,
  /*   51 */  0,
  /*   52 */  0,
  /*   53 */  0,
  /*   54 */  0,
  /*   55 */  0,
  /*   56 */  0,
  /*   57 */  0,
  /*   58 */  0,
  /*   59 */  0,
  /*   60 */  0,
  /*   61 */  0,
  /*   62 */  0,
  /*   63 */  0,
  /*   64 */  0,
  /*   65 */  0,
  /*   66 */  0,
  /*   67 */  0,
  /*   68 */  0,
  /*   69 */  0,
  /*   70 */  0,
  /*   71 */  0,
  /*   72 */  0,
  /*   73 */  0,
  /*   74 */  0,
  /*   75 */  0,
  /*   76 */  0,
  /*   77 */  0,
  /*   78 */  0,
  /*   79 */  0,
  /*   80 */  0,
  /*   81 */  0,
  /*   82 */  0,
  /*   83 */  0,
  /*   84 */  0,
  /*   85 */  0,
  /*   86 */  0,
  /*   87 */  0,
  /*   88 */  0,
  /*   89 */  0,
  /*   90 */  0,
  /*   91 */  any_RegP_rule,
  /*   92 */  any_RegP_rule,
  /*   93 */  _AddP_any_RegP_rRegL_rule,
  /*   94 */  any_RegP_rule,
  /*   95 */  any_RegP_rule,
  /*   96 */  any_RegP_rule,
  /*   97 */  _AddP_any_RegP__LShiftL_rRegL_immI2_rule,
  /*   98 */  _AddP_any_RegP__ConvI2L_rRegI__rule,
  /*   99 */  _AddP_any_RegP__LShiftL__ConvI2L_rRegI__immI2_rule,
  /*  100 */  _DecodeN_rRegN__rule,
  /*  101 */  rRegN_rule,
  /*  102 */  _DecodeN_rRegN__rule,
  /*  103 */  _DecodeN_rRegN__rule,
  /*  104 */  _AddP__DecodeN_rRegN__rRegL_rule,
  /*  105 */  _DecodeN_rRegN__rule,
  /*  106 */  _DecodeN_rRegN__rule,
  /*  107 */  _AddP__DecodeN_rRegN___LShiftL_rRegL_immI2_rule,
  /*  108 */  _AddP__DecodeN_rRegN___ConvI2L_rRegI__rule,
  /*  109 */  _AddP__DecodeN_rRegN___LShiftL__ConvI2L_rRegI__immI2_rule,
  /*  110 */  0,
  /*  111 */  0,
  /*  112 */  0,
  /*  113 */  0,
  /*  114 */  0,
  /*  115 */  0,
  /*  116 */  0,
  /*  117 */  0,
  /*  118 */  0,
  /*  119 */  0,
  /*  120 */  0,
  /*  121 */  0,
  /*  122 */  0,
  /*  123 */  0,
  /*  124 */  0,
  /*  125 */  0,
  /*  126 */  0,
  /*  127 */  0,
  /*  128 */  0,
  /*  129 */  0,
  /*  130 */  0,
  /*  131 */  0,
  /*  132 */  0,
  /*  133 */  0,
  /*  134 */  0,
  /*  135 */  0,
  /*  136 */  0,
  /*  137 */  0,
  /*  138 */  0,
  /*  139 */  0,
  /*  140 */  0,
  /*  141 */  0,
  /*  142 */  0,
  /*  143 */  0,
  /*  144 */  0,
  /*  145 */  0,
  /*  146 */  0,
  /*  147 */  0,
  /*  148 */  0,
  /*  149 */  0,
  /*  150 */  0,
  /*  151 */  0,
  /*  152 */  0,
  /*  153 */  0,
  // last operand
  /*  154 */  0,
  // last operand class
  /*  155 */  any_RegP_rule,
  /*  156 */  rRegL_rule,
  /*  157 */  rRegI_rule,
  /*  158 */  _ConvI2L_rRegI__rule,
  /*  159 */  any_RegP_rule,
  /*  160 */  any_RegP_rule,
  /*  161 */  any_RegP_rule,
  /*  162 */  rRegN_rule,
  /*  163 */  _DecodeN_rRegN__rule,
  /*  164 */  _DecodeN_rRegN__rule,
  /*  165 */  _DecodeN_rRegN__rule,
  /*  166 */  _DecodeN_rRegN__rule,
  /*  167 */  memory_rule,
  /*  168 */  memory_rule,
  /*  169 */  _LoadUB_memory__rule,
  /*  170 */  memory_rule,
  /*  171 */  _LoadS_memory__rule,
  /*  172 */  memory_rule,
  /*  173 */  _LoadUS_memory__rule,
  /*  174 */  _LoadUS_memory__rule,
  /*  175 */  _LoadUS_memory__rule,
  /*  176 */  memory_rule,
  /*  177 */  _LoadI_memory__rule,
  /*  178 */  _LoadI_memory__rule,
  /*  179 */  _LoadI_memory__rule,
  /*  180 */  _LoadI_memory__rule,
  /*  181 */  _LoadI_memory__rule,
  /*  182 */  _LoadI_memory__rule,
  /*  183 */  memory_rule,
  /*  184 */  rRegP_rule,
  /*  185 */  _DecodeN_rRegN__rule,
  /*  186 */  _LShiftL_rRegL_immI2_rule,
  /*  187 */  cmpOp_rule,
  /*  188 */  rRegI_rule,
  /*  189 */  cmpOpU_rule,
  /*  190 */  cmpOpUCF_rule,
  /*  191 */  rRegI_rule,
  /*  192 */  rRegN_rule,
  /*  193 */  rRegP_rule,
  /*  194 */  rRegL_rule,
  /*  195 */  rRegL_rule,
  /*  196 */  regF_rule,
  /*  197 */  regD_rule,
  /*  198 */  _LoadI_memory__rule,
  /*  199 */  rRegI_rule,
  /*  200 */  _LoadI_memory__rule,
  /*  201 */  _LoadI_memory__rule,
  /*  202 */  _LoadI_memory__rule,
  /*  203 */  _LoadL_memory__rule,
  /*  204 */  rRegL_rule,
  /*  205 */  _LoadL_memory__rule,
  /*  206 */  _LoadL_memory__rule,
  /*  207 */  _LoadL_memory__rule,
  /*  208 */  rax_RegP_rule,
  /*  209 */  rax_RegI_rule,
  /*  210 */  rax_RegL_rule,
  /*  211 */  rax_RegN_rule,
  /*  212 */  _LoadI_memory__rule,
  /*  213 */  _LoadI_memory__rule,
  /*  214 */  _LoadL_memory__rule,
  /*  215 */  _LoadL_memory__rule,
  /*  216 */  immI0_rule,
  /*  217 */  immI0_rule,
  /*  218 */  immL0_rule,
  /*  219 */  _LoadI_memory__rule,
  /*  220 */  _LoadI_memory__rule,
  /*  221 */  _LoadI_memory__rule,
  /*  222 */  _LoadI_memory__rule,
  /*  223 */  _LoadI_memory__rule,
  /*  224 */  _LoadI_memory__rule,
  /*  225 */  _LoadI_memory__rule,
  /*  226 */  _LoadI_memory__rule,
  /*  227 */  _LoadI_memory__rule,
  /*  228 */  _LoadL_memory__rule,
  /*  229 */  _LoadL_memory__rule,
  /*  230 */  _LoadL_memory__rule,
  /*  231 */  _LoadL_memory__rule,
  /*  232 */  _LoadL_memory__rule,
  /*  233 */  _LoadL_memory__rule,
  /*  234 */  _LoadL_memory__rule,
  /*  235 */  _LoadL_memory__rule,
  /*  236 */  _LoadL_memory__rule,
  /*  237 */  rRegI_rule,
  /*  238 */  rRegI_rule,
  /*  239 */  rRegI_rule,
  /*  240 */  rRegI_rule,
  /*  241 */  rRegI_rule,
  /*  242 */  rRegI_rule,
  /*  243 */  no_rcx_RegI_rule,
  /*  244 */  immI0_rule,
  /*  245 */  no_rcx_RegI_rule,
  /*  246 */  immI_32_rule,
  /*  247 */  no_rcx_RegI_rule,
  /*  248 */  rRegI_rule,
  /*  249 */  rRegI_rule,
  /*  250 */  no_rcx_RegI_rule,
  /*  251 */  no_rcx_RegI_rule,
  /*  252 */  no_rcx_RegI_rule,
  /*  253 */  rRegL_rule,
  /*  254 */  rRegL_rule,
  /*  255 */  rRegL_rule,
  /*  256 */  rRegL_rule,
  /*  257 */  no_rcx_RegL_rule,
  /*  258 */  no_rcx_RegL_rule,
  /*  259 */  immI_64_rule,
  /*  260 */  no_rcx_RegL_rule,
  /*  261 */  rRegL_rule,
  /*  262 */  rRegL_rule,
  /*  263 */  no_rcx_RegL_rule,
  /*  264 */  no_rcx_RegL_rule,
  /*  265 */  no_rcx_RegL_rule,
  /*  266 */  rRegI_rule,
  /*  267 */  rRegI_rule,
  /*  268 */  _LoadI_memory__rule,
  /*  269 */  rRegI_rule,
  /*  270 */  _LoadI_memory__rule,
  /*  271 */  rRegI_rule,
  /*  272 */  rRegI_rule,
  /*  273 */  _LoadI_memory__rule,
  /*  274 */  rRegI_rule,
  /*  275 */  _LoadI_memory__rule,
  /*  276 */  _LoadI_memory__rule,
  /*  277 */  rRegI_rule,
  /*  278 */  _LoadI_memory__rule,
  /*  279 */  _LoadL_memory__rule,
  /*  280 */  rRegL_rule,
  /*  281 */  _LoadL_memory__rule,
  /*  282 */  rRegL_rule,
  /*  283 */  immL0_rule,
  /*  284 */  rRegL_rule,
  /*  285 */  any_RegP_rule,
  /*  286 */  _LoadL_memory__rule,
  /*  287 */  rRegL_rule,
  /*  288 */  _LoadL_memory__rule,
  /*  289 */  _LoadL_memory__rule,
  /*  290 */  rRegL_rule,
  /*  291 */  _LoadL_memory__rule,
  /*  292 */  rRegI_rule,
  /*  293 */  _CmpLTMask_rRegI_rRegI_rule,
  /*  294 */  rRegI_rule,
  /*  295 */  rRegI_rule,
  /*  296 */  memory_rule,
  /*  297 */  memory_rule,
  /*  298 */  rdi_RegP_rule,
  /*  299 */  rsi_RegP_rule,
  /*  300 */  rdi_RegP_rule,
  /*  301 */  rsi_RegP_rule,
  /*  302 */  rsi_RegP_rule,
  /*  303 */  rdi_RegP_rule,
  /*  304 */  rRegI_rule,
  /*  305 */  memory_rule,
  /*  306 */  memory_rule,
  /*  307 */  memory_rule,
  /*  308 */  rRegL_rule,
  /*  309 */  _CastP2X_rRegP__rule,
  /*  310 */  _LoadL_memory__rule,
  /*  311 */  _LoadB_memory__rule,
  /*  312 */  rsi_RegP_rule,
  /*  313 */  memory_rule,
  /*  314 */  cmpOp_vcmppd_rule,
  /*  315 */  legVecY_rule,
  /*  316 */  vecX_rule,
  /*  317 */  vecX_rule,
  /*  318 */  vecY_rule,
  /*  319 */  vecY_rule,
  /*  320 */  vecZ_rule,
  /*  321 */  vecZ_rule,
  // last internally defined operand
  /*  322 */  rRegI_rule,
  /*  323 */  rRegL_rule,
  /*  324 */  rRegP_rule,
  /*  325 */  regF_rule,
  /*  326 */  regD_rule,
  /*  327 */  regF_rule,
  /*  328 */  regF_rule,
  /*  329 */  vlRegF_rule,
  /*  330 */  legRegF_rule,
  /*  331 */  regD_rule,
  /*  332 */  regD_rule,
  /*  333 */  vlRegD_rule,
  /*  334 */  legRegD_rule,
  /*  335 */  indOffset8_rule,
  /*  336 */  indOffset32_rule,
  /*  337 */  indIndexOffset_rule,
  /*  338 */  indIndexScale_rule,
  /*  339 */  indPosIndexScale_rule,
  /*  340 */  indIndexScaleOffset_rule,
  /*  341 */  indPosIndexOffset_rule,
  /*  342 */  indPosIndexScaleOffset_rule,
  /*  343 */  indCompressedOopOffset_rule,
  /*  344 */  indOffset8Narrow_rule,
  /*  345 */  indOffset32Narrow_rule,
  /*  346 */  indIndexOffsetNarrow_rule,
  /*  347 */  indIndexScaleNarrow_rule,
  /*  348 */  indIndexScaleOffsetNarrow_rule,
  /*  349 */  indPosIndexOffsetNarrow_rule,
  /*  350 */  indPosIndexScaleOffsetNarrow_rule,
  /*  351 */  immI_rule,
  /*  352 */  immI0_rule,
  /*  353 */  immL_rule,
  /*  354 */  immL0_rule,
  /*  355 */  immUL32_rule,
  /*  356 */  immL32_rule,
  /*  357 */  immP_rule,
  /*  358 */  immP0_rule,
  /*  359 */  immP31_rule,
  /*  360 */  immF_rule,
  /*  361 */  immN0_rule,
  /*  362 */  immN_rule,
  /*  363 */  immNKlass_rule,
  /*  364 */  immF0_rule,
  /*  365 */  immD_rule,
  /*  366 */  immD0_rule,
  /*  367 */  stackSlotI_rule,
  /*  368 */  stackSlotL_rule,
  /*  369 */  stackSlotP_rule,
  /*  370 */  stackSlotF_rule,
  /*  371 */  stackSlotD_rule,
  /*  372 */  vecS_rule,
  /*  373 */  legVecS_rule,
  /*  374 */  vecD_rule,
  /*  375 */  legVecD_rule,
  /*  376 */  vecX_rule,
  /*  377 */  legVecX_rule,
  /*  378 */  vecY_rule,
  /*  379 */  legVecY_rule,
  /*  380 */  vecZ_rule,
  /*  381 */  legVecZ_rule,
  /*  382 */  immI8_rule,
  /*  383 */  0,
  /*  384 */  rRegL_rule,
  /*  385 */  rRegP_rule,
  /*  386 */  rRegP_rule,
  /*  387 */  rRegP_rule,
  /*  388 */  rRegI_rule,
  /*  389 */  memory_rule,
  /*  390 */  memory_rule,
  /*  391 */  memory_rule,
  /*  392 */  regF_rule,
  /*  393 */  regF_rule,
  /*  394 */  regF_rule,
  /*  395 */  regF_rule,
  /*  396 */  regF_rule,
  /*  397 */  regF_rule,
  /*  398 */  regD_rule,
  /*  399 */  regD_rule,
  /*  400 */  regD_rule,
  /*  401 */  regD_rule,
  /*  402 */  regD_rule,
  /*  403 */  regD_rule,
  /*  404 */  regF_rule,
  /*  405 */  regD_rule,
  /*  406 */  stackSlotF_rule,
  /*  407 */  stackSlotI_rule,
  /*  408 */  stackSlotD_rule,
  /*  409 */  stackSlotL_rule,
  /*  410 */  stackSlotL_rule,
  /*  411 */  regF_rule,
  /*  412 */  regD_rule,
  /*  413 */  rRegI_rule,
  /*  414 */  rRegL_rule,
  /*  415 */  rax_RegI_rule,
  /*  416 */  rax_RegI_rule,
  /*  417 */  rax_RegL_rule,
  /*  418 */  rax_RegL_rule,
  /*  419 */  rRegI_rule,
  /*  420 */  rRegI_rule,
  /*  421 */  rRegL_rule,
  /*  422 */  rRegL_rule,
  /*  423 */  immI0_rule,
  /*  424 */  immL0_rule,
  /*  425 */  rax_RegI_rule,
  /*  426 */  rRegI_rule,
  /*  427 */  rax_RegL_rule,
  /*  428 */  rRegL_rule,
  /*  429 */  rRegI_rule,
  /*  430 */  rRegI_rule,
  /*  431 */  rRegI_rule,
  /*  432 */  rRegI_rule,
  /*  433 */  _AndI_rRegI_immI_rule,
  /*  434 */  _AndI_rRegI__LoadI_memory__rule,
  /*  435 */  _AndI__LoadI_memory__rRegI_rule,
  /*  436 */  rRegI_rule,
  /*  437 */  rRegI_rule,
  /*  438 */  rRegI_rule,
  /*  439 */  rRegI_rule,
  /*  440 */  rRegP_rule,
  /*  441 */  rRegP_rule,
  /*  442 */  rRegP_rule,
  /*  443 */  rRegP_rule,
  /*  444 */  _LoadP_memory__rule,
  /*  445 */  _LoadP_memory__rule,
  /*  446 */  rRegN_rule,
  /*  447 */  rRegN_rule,
  /*  448 */  rRegN_rule,
  /*  449 */  immN_rule,
  /*  450 */  rRegN_rule,
  /*  451 */  immNKlass_rule,
  /*  452 */  rRegN_rule,
  /*  453 */  _LoadN_memory__rule,
  /*  454 */  _LoadN_memory__rule,
  /*  455 */  rRegL_rule,
  /*  456 */  rRegL_rule,
  /*  457 */  rRegL_rule,
  /*  458 */  rRegL_rule,
  /*  459 */  _AndL_rRegL_immL32_rule,
  /*  460 */  _AndL_rRegL__LoadL_memory__rule,
  /*  461 */  _AndL__LoadL_memory__rRegL_rule,
  /*  462 */  _AndL__CastP2X_rRegP___LoadL_memory__rule,
  /*  463 */  _AndL__LoadL_memory___CastP2X_rRegP__rule,
  /*  464 */  rRegL_rule,
  /*  465 */  rRegL_rule,
  /*  466 */  rRegL_rule,
  /*  467 */  rRegL_rule,
  /*  468 */  _LoadB_memory__rule,
  /*  469 */  _AndI__LoadB_memory__immI8_rule,
  /*  470 */  _PartialSubtypeCheck_rsi_RegP_rax_RegP_rule,
  /*  471 */  rRegP_rule,
  /*  472 */  rRegP_rule,
  /*  473 */  rRegP_rule,
  /*  474 */  0,
  /*  475 */  0,
  /*  476 */  regF_rule,
  /*  477 */  vlRegF_rule,
  /*  478 */  regD_rule,
  /*  479 */  vlRegD_rule,
  /*  480 */  regF_rule,
  /*  481 */  vlRegF_rule,
  /*  482 */  regD_rule,
  /*  483 */  vlRegD_rule,
  /*  484 */  vecX_rule,
  /*  485 */  _LoadVector_memory__rule,
  /*  486 */  vecY_rule,
  /*  487 */  _LoadVector_memory__rule,
  /*  488 */  vecZ_rule,
  /*  489 */  _LoadVector_memory__rule,
  /*  490 */  vecD_rule,
  /*  491 */  _LoadVector_memory__rule,
  /*  492 */  vecX_rule,
  /*  493 */  _LoadVector_memory__rule,
  /*  494 */  vecY_rule,
  /*  495 */  _LoadVector_memory__rule,
  /*  496 */  vecZ_rule,
  /*  497 */  _LoadVector_memory__rule,
  /*  498 */  rRegI_rule,
  /*  499 */  rRegI_rule,
  /*  500 */  vecS_rule,
  /*  501 */  vecD_rule,
  /*  502 */  vecX_rule,
  /*  503 */  vecY_rule,
  /*  504 */  vecZ_rule,
  /*  505 */  vecD_rule,
  /*  506 */  vecD_rule,
  /*  507 */  vecX_rule,
  /*  508 */  vecY_rule,
  /*  509 */  vecZ_rule,
  /*  510 */  vecD_rule,
  /*  511 */  vecX_rule,
  /*  512 */  vecY_rule,
  /*  513 */  vecZ_rule,
  /*  514 */  vecX_rule,
  /*  515 */  vecY_rule,
  /*  516 */  vecZ_rule,
  /*  517 */  vecD_rule,
  /*  518 */  vecX_rule,
  /*  519 */  vecY_rule,
  /*  520 */  vecZ_rule,
  /*  521 */  memory_rule,
  /*  522 */  _LoadB_memory__rule,
  /*  523 */  memory_rule,
  /*  524 */  _LoadUB_memory__rule,
  /*  525 */  _AndI__LoadUB_memory__immI_rule,
  /*  526 */  memory_rule,
  /*  527 */  _LShiftI__LoadS_memory__immI_24_rule,
  /*  528 */  _LoadS_memory__rule,
  /*  529 */  memory_rule,
  /*  530 */  _LShiftI__LoadUS_memory__immI_24_rule,
  /*  531 */  _LoadUS_memory__rule,
  /*  532 */  _AndI__LoadUS_memory__immI_255_rule,
  /*  533 */  _AndI__LoadUS_memory__immI_rule,
  /*  534 */  memory_rule,
  /*  535 */  _LShiftI__LoadI_memory__immI_24_rule,
  /*  536 */  _LoadI_memory__rule,
  /*  537 */  _LShiftI__LoadI_memory__immI_16_rule,
  /*  538 */  _LoadI_memory__rule,
  /*  539 */  _LoadI_memory__rule,
  /*  540 */  _AndI__LoadI_memory__immI_255_rule,
  /*  541 */  _AndI__LoadI_memory__immI_65535_rule,
  /*  542 */  _AndI__LoadI_memory__immU31_rule,
  /*  543 */  _ConvI2L__LoadI_memory___rule,
  /*  544 */  memory_rule,
  /*  545 */  memory_rule,
  /*  546 */  memory_rule,
  /*  547 */  memory_rule,
  /*  548 */  memory_rule,
  /*  549 */  memory_rule,
  /*  550 */  memory_rule,
  /*  551 */  memory_rule,
  /*  552 */  memory_rule,
  /*  553 */  legRegF_rule,
  /*  554 */  legRegF_rule,
  /*  555 */  legRegD_rule,
  /*  556 */  legRegD_rule,
  /*  557 */  legRegF_rule,
  /*  558 */  legRegF_rule,
  /*  559 */  legRegD_rule,
  /*  560 */  legRegD_rule,
  /*  561 */  memory_rule,
  /*  562 */  memory_rule,
  /*  563 */  memory_rule,
  /*  564 */  memory_rule,
  /*  565 */  memory_rule,
  /*  566 */  memory_rule,
  /*  567 */  memory_rule,
  /*  568 */  memory_rule,
  /*  569 */  memory_rule,
  /*  570 */  memory_rule,
  /*  571 */  memory_rule,
  /*  572 */  memory_rule,
  /*  573 */  memory_rule,
  /*  574 */  memory_rule,
  /*  575 */  memory_rule,
  /*  576 */  memory_rule,
  /*  577 */  memory_rule,
  /*  578 */  memory_rule,
  /*  579 */  memory_rule,
  /*  580 */  memory_rule,
  /*  581 */  memory_rule,
  /*  582 */  memory_rule,
  /*  583 */  memory_rule,
  /*  584 */  memory_rule,
  /*  585 */  memory_rule,
  /*  586 */  memory_rule,
  /*  587 */  memory_rule,
  /*  588 */  memory_rule,
  /*  589 */  memory_rule,
  /*  590 */  memory_rule,
  /*  591 */  memory_rule,
  /*  592 */  memory_rule,
  /*  593 */  rRegI_rule,
  /*  594 */  rRegL_rule,
  /*  595 */  rRegI_rule,
  /*  596 */  rRegI_rule,
  /*  597 */  rRegI_rule,
  /*  598 */  rRegI_rule,
  /*  599 */  rRegL_rule,
  /*  600 */  rRegL_rule,
  /*  601 */  rRegI_rule,
  /*  602 */  rRegI_rule,
  /*  603 */  rRegL_rule,
  /*  604 */  rRegL_rule,
  /*  605 */  rRegI_rule,
  /*  606 */  _LoadI_memory__rule,
  /*  607 */  rRegL_rule,
  /*  608 */  _LoadL_memory__rule,
  /*  609 */  0,
  /*  610 */  0,
  /*  611 */  0,
  /*  612 */  0,
  /*  613 */  0,
  /*  614 */  0,
  /*  615 */  0,
  /*  616 */  0,
  /*  617 */  _CastP2X_rRegP__rule,
  /*  618 */  _CastP2X__DecodeN_rRegN___rule,
  /*  619 */  rRegP_rule,
  /*  620 */  rRegP_rule,
  /*  621 */  rRegN_rule,
  /*  622 */  rRegN_rule,
  /*  623 */  rRegP_rule,
  /*  624 */  rRegN_rule,
  /*  625 */  _LShiftL_rRegL_immI2_rule,
  /*  626 */  _AddL__LShiftL_rRegL_immI2_immL32_rule,
  /*  627 */  rRegL_rule,
  /*  628 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  629 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  630 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  631 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  632 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  633 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  634 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  635 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  636 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  637 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  638 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  639 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  640 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  641 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  642 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  643 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  644 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  645 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  646 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  647 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  648 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  649 */  _Binary_cmpOp_rFlagsReg_rule,
  /*  650 */  _Binary_cmpOpU_rFlagsRegU_rule,
  /*  651 */  _Binary_cmpOpUCF_rFlagsRegUCF_rule,
  /*  652 */  rRegI_rule,
  /*  653 */  rRegI_rule,
  /*  654 */  rRegI_rule,
  /*  655 */  _LoadI_memory__rule,
  /*  656 */  memory_rule,
  /*  657 */  memory_rule,
  /*  658 */  memory_rule,
  /*  659 */  rRegI_rule,
  /*  660 */  memory_rule,
  /*  661 */  rRegI_rule,
  /*  662 */  memory_rule,
  /*  663 */  rRegI_rule,
  /*  664 */  rRegL_rule,
  /*  665 */  rRegL_rule,
  /*  666 */  rRegL_rule,
  /*  667 */  _LoadL_memory__rule,
  /*  668 */  memory_rule,
  /*  669 */  memory_rule,
  /*  670 */  memory_rule,
  /*  671 */  rRegI_rule,
  /*  672 */  memory_rule,
  /*  673 */  rRegL_rule,
  /*  674 */  memory_rule,
  /*  675 */  rRegL_rule,
  /*  676 */  rRegP_rule,
  /*  677 */  rRegP_rule,
  /*  678 */  rRegP_rule,
  /*  679 */  memory_rule,
  /*  680 */  memory_rule,
  /*  681 */  memory_rule,
  /*  682 */  memory_rule,
  /*  683 */  memory_rule,
  /*  684 */  memory_rule,
  /*  685 */  memory_rule,
  /*  686 */  memory_rule,
  /*  687 */  memory_rule,
  /*  688 */  memory_rule,
  /*  689 */  memory_rule,
  /*  690 */  memory_rule,
  /*  691 */  memory_rule,
  /*  692 */  memory_rule,
  /*  693 */  memory_rule,
  /*  694 */  memory_rule,
  /*  695 */  memory_rule,
  /*  696 */  memory_rule,
  /*  697 */  memory_rule,
  /*  698 */  memory_rule,
  /*  699 */  memory_rule,
  /*  700 */  memory_rule,
  /*  701 */  memory_rule,
  /*  702 */  memory_rule,
  /*  703 */  memory_rule,
  /*  704 */  memory_rule,
  /*  705 */  memory_rule,
  /*  706 */  memory_rule,
  /*  707 */  memory_rule,
  /*  708 */  memory_rule,
  /*  709 */  memory_rule,
  /*  710 */  memory_rule,
  /*  711 */  memory_rule,
  /*  712 */  rRegI_rule,
  /*  713 */  rRegL_rule,
  /*  714 */  rRegI_rule,
  /*  715 */  rRegI_rule,
  /*  716 */  rRegI_rule,
  /*  717 */  memory_rule,
  /*  718 */  memory_rule,
  /*  719 */  rRegL_rule,
  /*  720 */  rRegI_rule,
  /*  721 */  rRegL_rule,
  /*  722 */  memory_rule,
  /*  723 */  memory_rule,
  /*  724 */  rRegP_rule,
  /*  725 */  immI0_rule,
  /*  726 */  memory_rule,
  /*  727 */  immL0_rule,
  /*  728 */  memory_rule,
  /*  729 */  rRegI_rule,
  /*  730 */  rRegI_rule,
  /*  731 */  rRegI_rule,
  /*  732 */  _LoadI_memory__rule,
  /*  733 */  _LoadI_memory__rule,
  /*  734 */  rRegL_rule,
  /*  735 */  rRegL_rule,
  /*  736 */  rRegL_rule,
  /*  737 */  _LoadL_memory__rule,
  /*  738 */  _LoadL_memory__rule,
  /*  739 */  no_rax_RegL_rule,
  /*  740 */  rax_RegI_rule,
  /*  741 */  rax_RegL_rule,
  /*  742 */  rax_RegI_rule,
  /*  743 */  rax_RegL_rule,
  /*  744 */  0,
  /*  745 */  0,
  /*  746 */  0,
  /*  747 */  0,
  /*  748 */  no_rax_RegL_rule,
  /*  749 */  rax_RegI_rule,
  /*  750 */  rax_RegL_rule,
  /*  751 */  rRegI_rule,
  /*  752 */  memory_rule,
  /*  753 */  rRegI_rule,
  /*  754 */  memory_rule,
  /*  755 */  rRegI_rule,
  /*  756 */  memory_rule,
  /*  757 */  rRegI_rule,
  /*  758 */  memory_rule,
  /*  759 */  rRegI_rule,
  /*  760 */  memory_rule,
  /*  761 */  rRegI_rule,
  /*  762 */  memory_rule,
  /*  763 */  rRegI_rule,
  /*  764 */  memory_rule,
  /*  765 */  rRegI_rule,
  /*  766 */  memory_rule,
  /*  767 */  rRegI_rule,
  /*  768 */  memory_rule,
  /*  769 */  rRegL_rule,
  /*  770 */  memory_rule,
  /*  771 */  rRegL_rule,
  /*  772 */  memory_rule,
  /*  773 */  rRegL_rule,
  /*  774 */  memory_rule,
  /*  775 */  rRegL_rule,
  /*  776 */  memory_rule,
  /*  777 */  rRegL_rule,
  /*  778 */  memory_rule,
  /*  779 */  rRegL_rule,
  /*  780 */  memory_rule,
  /*  781 */  rRegL_rule,
  /*  782 */  memory_rule,
  /*  783 */  rRegL_rule,
  /*  784 */  memory_rule,
  /*  785 */  rRegL_rule,
  /*  786 */  memory_rule,
  /*  787 */  _LShiftI_rRegI_immI_24_rule,
  /*  788 */  _LShiftI_rRegI_immI_16_rule,
  /*  789 */  0,
  /*  790 */  0,
  /*  791 */  0,
  /*  792 */  _LShiftI_rRegI_immI1_rule,
  /*  793 */  _URShiftI_rRegI_immI_M1_rule,
  /*  794 */  _LShiftI_rRegI_immI8_rule,
  /*  795 */  _URShiftI_rRegI_immI8_rule,
  /*  796 */  _LShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  797 */  _URShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI_rule,
  /*  798 */  _LShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  799 */  _URShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI_rule,
  /*  800 */  0,
  /*  801 */  0,
  /*  802 */  0,
  /*  803 */  _URShiftI_rRegI_immI1_rule,
  /*  804 */  _LShiftI_rRegI_immI_M1_rule,
  /*  805 */  _URShiftI_rRegI_immI8_rule,
  /*  806 */  _LShiftI_rRegI_immI8_rule,
  /*  807 */  _URShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  808 */  _LShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI_rule,
  /*  809 */  _URShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  810 */  _LShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI_rule,
  /*  811 */  0,
  /*  812 */  0,
  /*  813 */  0,
  /*  814 */  _LShiftL_rRegL_immI1_rule,
  /*  815 */  _URShiftL_rRegL_immI_M1_rule,
  /*  816 */  _LShiftL_rRegL_immI8_rule,
  /*  817 */  _URShiftL_rRegL_immI8_rule,
  /*  818 */  _LShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  819 */  _URShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI_rule,
  /*  820 */  _LShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  821 */  _URShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI_rule,
  /*  822 */  0,
  /*  823 */  0,
  /*  824 */  0,
  /*  825 */  _URShiftL_rRegL_immI1_rule,
  /*  826 */  _LShiftL_rRegL_immI_M1_rule,
  /*  827 */  _URShiftL_rRegL_immI8_rule,
  /*  828 */  _LShiftL_rRegL_immI8_rule,
  /*  829 */  _URShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  830 */  _LShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI_rule,
  /*  831 */  _URShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  832 */  _LShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI_rule,
  /*  833 */  rRegI_rule,
  /*  834 */  rRegI_rule,
  /*  835 */  _AndI_rRegI_immI_255_rule,
  /*  836 */  rRegI_rule,
  /*  837 */  _AndI_rRegI_immI_65535_rule,
  /*  838 */  rRegI_rule,
  /*  839 */  rRegI_rule,
  /*  840 */  _LoadI_memory__rule,
  /*  841 */  memory_rule,
  /*  842 */  memory_rule,
  /*  843 */  memory_rule,
  /*  844 */  _XorI_rRegI_immI_M1_rule,
  /*  845 */  _LoadI_memory__rule,
  /*  846 */  _XorI_rRegI_immI_M1_rule,
  /*  847 */  rRegI_rule,
  /*  848 */  _SubI_immI0_rRegI_rule,
  /*  849 */  rRegI_rule,
  /*  850 */  _SubI_immI0__LoadI_memory__rule,
  /*  851 */  _LoadI_memory__rule,
  /*  852 */  _AddI__LoadI_memory__immI_M1_rule,
  /*  853 */  _LoadI_memory__rule,
  /*  854 */  _AddI_rRegI_immI_M1_rule,
  /*  855 */  rRegI_rule,
  /*  856 */  _AddI_rRegI_immI_M1_rule,
  /*  857 */  rRegI_rule,
  /*  858 */  _AddI__LoadI_memory__immI_M1_rule,
  /*  859 */  _LoadI_memory__rule,
  /*  860 */  rRegI_rule,
  /*  861 */  rRegI_rule,
  /*  862 */  rRegI_rule,
  /*  863 */  _LoadI_memory__rule,
  /*  864 */  memory_rule,
  /*  865 */  memory_rule,
  /*  866 */  memory_rule,
  /*  867 */  rRegI_rule,
  /*  868 */  rRegI_rule,
  /*  869 */  rRegI_rule,
  /*  870 */  rRegI_rule,
  /*  871 */  _LoadI_memory__rule,
  /*  872 */  memory_rule,
  /*  873 */  memory_rule,
  /*  874 */  memory_rule,
  /*  875 */  rRegL_rule,
  /*  876 */  rRegL_rule,
  /*  877 */  rRegL_rule,
  /*  878 */  rRegL_rule,
  /*  879 */  rRegL_rule,
  /*  880 */  _LoadL_memory__rule,
  /*  881 */  memory_rule,
  /*  882 */  memory_rule,
  /*  883 */  memory_rule,
  /*  884 */  _XorL_rRegL_immL_M1_rule,
  /*  885 */  _LoadL_memory__rule,
  /*  886 */  _XorL_rRegL_immL_M1_rule,
  /*  887 */  rRegL_rule,
  /*  888 */  _SubL_immL0_rRegL_rule,
  /*  889 */  rRegL_rule,
  /*  890 */  _SubL_immL0__LoadL_memory__rule,
  /*  891 */  _LoadL_memory__rule,
  /*  892 */  _AddL__LoadL_memory__immL_M1_rule,
  /*  893 */  _LoadL_memory__rule,
  /*  894 */  _AddL_rRegL_immL_M1_rule,
  /*  895 */  rRegL_rule,
  /*  896 */  _AddL_rRegL_immL_M1_rule,
  /*  897 */  rRegL_rule,
  /*  898 */  _AddL__LoadL_memory__immL_M1_rule,
  /*  899 */  _LoadL_memory__rule,
  /*  900 */  rRegL_rule,
  /*  901 */  rRegL_rule,
  /*  902 */  _CastP2X_any_RegP__rule,
  /*  903 */  rRegL_rule,
  /*  904 */  rRegL_rule,
  /*  905 */  _LoadL_memory__rule,
  /*  906 */  memory_rule,
  /*  907 */  memory_rule,
  /*  908 */  memory_rule,
  /*  909 */  rRegL_rule,
  /*  910 */  rRegL_rule,
  /*  911 */  rRegL_rule,
  /*  912 */  rRegL_rule,
  /*  913 */  _LoadL_memory__rule,
  /*  914 */  memory_rule,
  /*  915 */  memory_rule,
  /*  916 */  memory_rule,
  /*  917 */  rRegI_rule,
  /*  918 */  rRegP_rule,
  /*  919 */  rRegI_rule,
  /*  920 */  rRegI_rule,
  /*  921 */  _AndI__CmpLTMask_rRegI_rRegI_rRegI_rule,
  /*  922 */  _SubI_rRegI_rRegI_rule,
  /*  923 */  _AndI_rRegI__CmpLTMask_rRegI_rRegI_rule,
  /*  924 */  _SubI_rRegI_rRegI_rule,
  /*  925 */  _CmpLTMask_rRegI_rRegI_rule,
  /*  926 */  rRegI_rule,
  /*  927 */  regF_rule,
  /*  928 */  regF_rule,
  /*  929 */  regF_rule,
  /*  930 */  regD_rule,
  /*  931 */  regD_rule,
  /*  932 */  regD_rule,
  /*  933 */  regF_rule,
  /*  934 */  _LoadF_memory__rule,
  /*  935 */  regD_rule,
  /*  936 */  _LoadD_memory__rule,
  /*  937 */  regF_rule,
  /*  938 */  regF_rule,
  /*  939 */  regD_rule,
  /*  940 */  regD_rule,
  /*  941 */  rRegI_rule,
  /*  942 */  _LoadI_memory__rule,
  /*  943 */  rRegI_rule,
  /*  944 */  _LoadI_memory__rule,
  /*  945 */  rRegI_rule,
  /*  946 */  rRegI_rule,
  /*  947 */  rRegL_rule,
  /*  948 */  _LoadL_memory__rule,
  /*  949 */  rRegL_rule,
  /*  950 */  _LoadL_memory__rule,
  /*  951 */  rRegI_rule,
  /*  952 */  _ConvI2L_rRegI__rule,
  /*  953 */  _ConvI2L__LoadI_memory___rule,
  /*  954 */  rRegL_rule,
  /*  955 */  rRegL_rule,
  /*  956 */  regF_rule,
  /*  957 */  rRegI_rule,
  /*  958 */  regD_rule,
  /*  959 */  rRegL_rule,
  /*  960 */  rcx_RegL_rule,
  /*  961 */  rcx_RegL_rule,
  /*  962 */  _Binary_rdi_RegP_rcx_RegI_rule,
  /*  963 */  _Binary_rdi_RegP_rcx_RegI_rule,
  /*  964 */  _Binary_rdi_RegP_rcx_RegI_rule,
  /*  965 */  _Binary_rsi_RegP_rdx_RegI_rule,
  /*  966 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  967 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  968 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  969 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  970 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  971 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  972 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  973 */  _Binary_rdi_RegP_rsi_RegP_rule,
  /*  974 */  rdi_RegP_rule,
  /*  975 */  rdi_RegP_rule,
  /*  976 */  rsi_RegP_rule,
  /*  977 */  rsi_RegP_rule,
  /*  978 */  rsi_RegP_rule,
  /*  979 */  rsi_RegP_rule,
  /*  980 */  rRegL_rule,
  /*  981 */  0,
  /*  982 */  rRegI_rule,
  /*  983 */  0,
  /*  984 */  rRegI_rule,
  /*  985 */  0,
  /*  986 */  cmpOp_rule,
  /*  987 */  cmpOp_rule,
  /*  988 */  cmpOpU_rule,
  /*  989 */  cmpOpUCF_rule,
  /*  990 */  cmpOp_rule,
  /*  991 */  cmpOpU_rule,
  /*  992 */  cmpOpUCF_rule,
  /*  993 */  cmpOpU_rule,
  /*  994 */  cmpOpUCF_rule,
  /*  995 */  cmpOpUCF2_rule,
  /*  996 */  rsi_RegP_rule,
  /*  997 */  0,
  /*  998 */  cmpOp_rule,
  /*  999 */  cmpOp_rule,
  /* 1000 */  cmpOpU_rule,
  /* 1001 */  cmpOpUCF_rule,
  /* 1002 */  cmpOpU_rule,
  /* 1003 */  cmpOpUCF_rule,
  /* 1004 */  cmpOpUCF2_rule,
  /* 1005 */  rRegP_rule,
  /* 1006 */  rex_RegP_rule,
  /* 1007 */  0,
  /* 1008 */  0,
  /* 1009 */  0,
  /* 1010 */  0,
  /* 1011 */  0,
  /* 1012 */  0,
  /* 1013 */  no_rbp_RegP_rule,
  /* 1014 */  no_rbp_RegP_rule,
  /* 1015 */  0,
  /* 1016 */  0,
  /* 1017 */  memory_rule,
  /* 1018 */  memory_rule,
  /* 1019 */  memory_rule,
  /* 1020 */  memory_rule,
  /* 1021 */  memory_rule,
  /* 1022 */  memory_rule,
  /* 1023 */  0,
  /* 1024 */  rRegI_rule,
  /* 1025 */  regF_rule,
  /* 1026 */  regF_rule,
  /* 1027 */  _LoadF_memory__rule,
  /* 1028 */  regF_rule,
  /* 1029 */  regF_rule,
  /* 1030 */  regF_rule,
  /* 1031 */  _LoadF_memory__rule,
  /* 1032 */  regF_rule,
  /* 1033 */  regD_rule,
  /* 1034 */  regD_rule,
  /* 1035 */  _LoadD_memory__rule,
  /* 1036 */  regD_rule,
  /* 1037 */  regD_rule,
  /* 1038 */  regD_rule,
  /* 1039 */  _LoadD_memory__rule,
  /* 1040 */  regD_rule,
  /* 1041 */  regF_rule,
  /* 1042 */  regF_rule,
  /* 1043 */  regF_rule,
  /* 1044 */  regF_rule,
  /* 1045 */  regF_rule,
  /* 1046 */  regF_rule,
  /* 1047 */  regD_rule,
  /* 1048 */  regD_rule,
  /* 1049 */  regD_rule,
  /* 1050 */  regD_rule,
  /* 1051 */  regD_rule,
  /* 1052 */  regD_rule,
  /* 1053 */  regF_rule,
  /* 1054 */  regF_rule,
  /* 1055 */  _LoadF_memory__rule,
  /* 1056 */  regF_rule,
  /* 1057 */  regF_rule,
  /* 1058 */  regF_rule,
  /* 1059 */  _LoadF_memory__rule,
  /* 1060 */  regF_rule,
  /* 1061 */  regD_rule,
  /* 1062 */  regD_rule,
  /* 1063 */  _LoadD_memory__rule,
  /* 1064 */  regD_rule,
  /* 1065 */  regD_rule,
  /* 1066 */  regD_rule,
  /* 1067 */  _LoadD_memory__rule,
  /* 1068 */  regD_rule,
  /* 1069 */  regF_rule,
  /* 1070 */  regF_rule,
  /* 1071 */  regF_rule,
  /* 1072 */  regF_rule,
  /* 1073 */  regF_rule,
  /* 1074 */  regF_rule,
  /* 1075 */  regD_rule,
  /* 1076 */  regD_rule,
  /* 1077 */  regD_rule,
  /* 1078 */  regD_rule,
  /* 1079 */  regD_rule,
  /* 1080 */  regD_rule,
  /* 1081 */  regF_rule,
  /* 1082 */  _LoadF_memory__rule,
  /* 1083 */  immF_rule,
  /* 1084 */  regD_rule,
  /* 1085 */  _LoadD_memory__rule,
  /* 1086 */  immD_rule,
  /* 1087 */  legRegD_rule,
  /* 1088 */  _LoadD_memory__rule,
  /* 1089 */  immD_rule,
  /* 1090 */  legVecX_rule,
  /* 1091 */  _LoadVector_memory__rule,
  /* 1092 */  legVecY_rule,
  /* 1093 */  _LoadVector_memory__rule,
  /* 1094 */  vecZ_rule,
  /* 1095 */  _LoadVector_memory__rule,
  /* 1096 */  0,
  /* 1097 */  regD_rule,
  /* 1098 */  regF_rule,
  /* 1099 */  memory_rule,
  /* 1100 */  memory_rule,
  /* 1101 */  memory_rule,
  /* 1102 */  memory_rule,
  /* 1103 */  memory_rule,
  /* 1104 */  memory_rule,
  /* 1105 */  memory_rule,
  /* 1106 */  memory_rule,
  /* 1107 */  memory_rule,
  /* 1108 */  memory_rule,
  /* 1109 */  memory_rule,
  /* 1110 */  memory_rule,
  /* 1111 */  rRegI_rule,
  /* 1112 */  rRegI_rule,
  /* 1113 */  rRegI_rule,
  /* 1114 */  immI_rule,
  /* 1115 */  immI_rule,
  /* 1116 */  immI_rule,
  /* 1117 */  rRegI_rule,
  /* 1118 */  _LoadS_memory__rule,
  /* 1119 */  rRegI_rule,
  /* 1120 */  _LoadS_memory__rule,
  /* 1121 */  immI_rule,
  /* 1122 */  rRegI_rule,
  /* 1123 */  _LoadS_memory__rule,
  /* 1124 */  immI_rule,
  /* 1125 */  rRegI_rule,
  /* 1126 */  _LoadS_memory__rule,
  /* 1127 */  immI_rule,
  /* 1128 */  rRegI_rule,
  /* 1129 */  _LoadI_memory__rule,
  /* 1130 */  rRegI_rule,
  /* 1131 */  _LoadI_memory__rule,
  /* 1132 */  rRegI_rule,
  /* 1133 */  _LoadI_memory__rule,
  /* 1134 */  immI_rule,
  /* 1135 */  immI_rule,
  /* 1136 */  immI_rule,
  /* 1137 */  _LoadL_memory__rule,
  /* 1138 */  rRegL_rule,
  /* 1139 */  rRegL_rule,
  /* 1140 */  immL_rule,
  /* 1141 */  immL_rule,
  /* 1142 */  _LoadL_memory__rule,
  /* 1143 */  _LoadL_memory__rule,
  /* 1144 */  _LoadF_memory__rule,
  /* 1145 */  _LoadF_memory__rule,
  /* 1146 */  vlRegF_rule,
  /* 1147 */  _LoadF_memory__rule,
  /* 1148 */  vlRegF_rule,
  /* 1149 */  _LoadF_memory__rule,
  /* 1150 */  immF0_rule,
  /* 1151 */  immF0_rule,
  /* 1152 */  immF0_rule,
  /* 1153 */  _LoadD_memory__rule,
  /* 1154 */  vlRegD_rule,
  /* 1155 */  _LoadD_memory__rule,
  /* 1156 */  vlRegD_rule,
  /* 1157 */  _LoadD_memory__rule,
  /* 1158 */  immD0_rule,
  /* 1159 */  immD0_rule,
  /* 1160 */  rRegI_rule,
  /* 1161 */  rRegI_rule,
  /* 1162 */  immI_rule,
  /* 1163 */  immI_rule,
  /* 1164 */  immI0_rule,
  /* 1165 */  immI0_rule,
  /* 1166 */  immI0_rule,
  /* 1167 */  immI0_rule,
  /* 1168 */  rRegI_rule,
  /* 1169 */  immI_rule,
  /* 1170 */  immI_rule,
  /* 1171 */  immI0_rule,
  /* 1172 */  immI0_rule,
  /* 1173 */  immI0_rule,
  /* 1174 */  immI0_rule,
  /* 1175 */  rRegI_rule,
  /* 1176 */  _LoadI_memory__rule,
  /* 1177 */  immI_rule,
  /* 1178 */  immI0_rule,
  /* 1179 */  immI0_rule,
  /* 1180 */  immI0_rule,
  /* 1181 */  rRegL_rule,
  /* 1182 */  immL_rule,
  /* 1183 */  immL0_rule,
  /* 1184 */  immL0_rule,
  /* 1185 */  vlRegF_rule,
  /* 1186 */  vlRegF_rule,
  /* 1187 */  vlRegD_rule,
  /* 1188 */  _LoadB_memory__rule,
  /* 1189 */  _LoadB_memory__rule,
  /* 1190 */  rRegI_rule,
  /* 1191 */  _LoadB_memory__rule,
  /* 1192 */  rRegI_rule,
  /* 1193 */  _LoadB_memory__rule,
  /* 1194 */  rRegI_rule,
  /* 1195 */  _LoadB_memory__rule,
  /* 1196 */  immI_rule,
  /* 1197 */  immI_rule,
  /* 1198 */  immI_rule,
  /* 1199 */  immI0_rule,
  /* 1200 */  rRegI_rule,
  /* 1201 */  _LoadS_memory__rule,
  /* 1202 */  rRegI_rule,
  /* 1203 */  _LoadS_memory__rule,
  /* 1204 */  rRegI_rule,
  /* 1205 */  _LoadS_memory__rule,
  /* 1206 */  rRegI_rule,
  /* 1207 */  _LoadS_memory__rule,
  /* 1208 */  immI_rule,
  /* 1209 */  immI_rule,
  /* 1210 */  immI_rule,
  /* 1211 */  immI0_rule,
  /* 1212 */  rRegI_rule,
  /* 1213 */  _LoadI_memory__rule,
  /* 1214 */  rRegI_rule,
  /* 1215 */  _LoadI_memory__rule,
  /* 1216 */  rRegI_rule,
  /* 1217 */  _LoadI_memory__rule,
  /* 1218 */  immI_rule,
  /* 1219 */  immI_rule,
  /* 1220 */  immI_rule,
  /* 1221 */  immI0_rule,
  /* 1222 */  rRegL_rule,
  /* 1223 */  rRegL_rule,
  /* 1224 */  immL_rule,
  /* 1225 */  immL_rule,
  /* 1226 */  _LoadL_memory__rule,
  /* 1227 */  _LoadL_memory__rule,
  /* 1228 */  _LoadL_memory__rule,
  /* 1229 */  immL0_rule,
  /* 1230 */  regF_rule,
  /* 1231 */  _LoadF_memory__rule,
  /* 1232 */  regF_rule,
  /* 1233 */  _LoadF_memory__rule,
  /* 1234 */  immF0_rule,
  /* 1235 */  regD_rule,
  /* 1236 */  _LoadD_memory__rule,
  /* 1237 */  regD_rule,
  /* 1238 */  _LoadD_memory__rule,
  /* 1239 */  immD0_rule,
  /* 1240 */  rRegI_rule,
  /* 1241 */  rRegI_rule,
  /* 1242 */  rRegI_rule,
  /* 1243 */  rRegI_rule,
  /* 1244 */  rRegI_rule,
  /* 1245 */  rRegI_rule,
  /* 1246 */  rRegI_rule,
  /* 1247 */  rRegI_rule,
  /* 1248 */  rRegI_rule,
  /* 1249 */  rRegL_rule,
  /* 1250 */  rRegL_rule,
  /* 1251 */  rRegL_rule,
  /* 1252 */  regF_rule,
  /* 1253 */  regF_rule,
  /* 1254 */  regF_rule,
  /* 1255 */  regF_rule,
  /* 1256 */  regF_rule,
  /* 1257 */  regF_rule,
  /* 1258 */  regD_rule,
  /* 1259 */  regD_rule,
  /* 1260 */  regD_rule,
  /* 1261 */  regD_rule,
  /* 1262 */  rRegI_rule,
  /* 1263 */  rRegI_rule,
  /* 1264 */  rRegI_rule,
  /* 1265 */  rRegI_rule,
  /* 1266 */  rRegI_rule,
  /* 1267 */  rRegI_rule,
  /* 1268 */  rRegL_rule,
  /* 1269 */  rRegL_rule,
  /* 1270 */  rRegL_rule,
  /* 1271 */  regF_rule,
  /* 1272 */  regF_rule,
  /* 1273 */  regF_rule,
  /* 1274 */  regF_rule,
  /* 1275 */  regF_rule,
  /* 1276 */  regF_rule,
  /* 1277 */  regD_rule,
  /* 1278 */  regD_rule,
  /* 1279 */  regD_rule,
  /* 1280 */  regD_rule,
  /* 1281 */  vecS_rule,
  /* 1282 */  vecS_rule,
  /* 1283 */  vecS_rule,
  /* 1284 */  _LoadVector_memory__rule,
  /* 1285 */  vecD_rule,
  /* 1286 */  vecD_rule,
  /* 1287 */  vecD_rule,
  /* 1288 */  _LoadVector_memory__rule,
  /* 1289 */  vecX_rule,
  /* 1290 */  vecX_rule,
  /* 1291 */  vecX_rule,
  /* 1292 */  _LoadVector_memory__rule,
  /* 1293 */  vecY_rule,
  /* 1294 */  vecY_rule,
  /* 1295 */  _LoadVector_memory__rule,
  /* 1296 */  vecZ_rule,
  /* 1297 */  vecZ_rule,
  /* 1298 */  _LoadVector_memory__rule,
  /* 1299 */  vecS_rule,
  /* 1300 */  vecS_rule,
  /* 1301 */  vecS_rule,
  /* 1302 */  _LoadVector_memory__rule,
  /* 1303 */  vecD_rule,
  /* 1304 */  vecD_rule,
  /* 1305 */  vecD_rule,
  /* 1306 */  _LoadVector_memory__rule,
  /* 1307 */  vecX_rule,
  /* 1308 */  vecX_rule,
  /* 1309 */  vecX_rule,
  /* 1310 */  _LoadVector_memory__rule,
  /* 1311 */  vecY_rule,
  /* 1312 */  vecY_rule,
  /* 1313 */  _LoadVector_memory__rule,
  /* 1314 */  vecZ_rule,
  /* 1315 */  vecZ_rule,
  /* 1316 */  _LoadVector_memory__rule,
  /* 1317 */  vecD_rule,
  /* 1318 */  vecD_rule,
  /* 1319 */  vecD_rule,
  /* 1320 */  _LoadVector_memory__rule,
  /* 1321 */  vecX_rule,
  /* 1322 */  vecX_rule,
  /* 1323 */  vecX_rule,
  /* 1324 */  _LoadVector_memory__rule,
  /* 1325 */  vecY_rule,
  /* 1326 */  vecY_rule,
  /* 1327 */  _LoadVector_memory__rule,
  /* 1328 */  vecZ_rule,
  /* 1329 */  vecZ_rule,
  /* 1330 */  _LoadVector_memory__rule,
  /* 1331 */  vecX_rule,
  /* 1332 */  vecX_rule,
  /* 1333 */  vecX_rule,
  /* 1334 */  _LoadVector_memory__rule,
  /* 1335 */  vecY_rule,
  /* 1336 */  vecY_rule,
  /* 1337 */  _LoadVector_memory__rule,
  /* 1338 */  vecZ_rule,
  /* 1339 */  vecZ_rule,
  /* 1340 */  _LoadVector_memory__rule,
  /* 1341 */  vecD_rule,
  /* 1342 */  vecD_rule,
  /* 1343 */  vecD_rule,
  /* 1344 */  _LoadVector_memory__rule,
  /* 1345 */  vecX_rule,
  /* 1346 */  vecX_rule,
  /* 1347 */  vecX_rule,
  /* 1348 */  _LoadVector_memory__rule,
  /* 1349 */  vecY_rule,
  /* 1350 */  vecY_rule,
  /* 1351 */  _LoadVector_memory__rule,
  /* 1352 */  vecZ_rule,
  /* 1353 */  vecZ_rule,
  /* 1354 */  _LoadVector_memory__rule,
  /* 1355 */  vecX_rule,
  /* 1356 */  vecX_rule,
  /* 1357 */  vecX_rule,
  /* 1358 */  _LoadVector_memory__rule,
  /* 1359 */  vecY_rule,
  /* 1360 */  vecY_rule,
  /* 1361 */  _LoadVector_memory__rule,
  /* 1362 */  vecZ_rule,
  /* 1363 */  vecZ_rule,
  /* 1364 */  _LoadVector_memory__rule,
  /* 1365 */  vecS_rule,
  /* 1366 */  vecS_rule,
  /* 1367 */  vecS_rule,
  /* 1368 */  vecD_rule,
  /* 1369 */  vecD_rule,
  /* 1370 */  vecD_rule,
  /* 1371 */  vecX_rule,
  /* 1372 */  vecX_rule,
  /* 1373 */  vecX_rule,
  /* 1374 */  vecY_rule,
  /* 1375 */  vecY_rule,
  /* 1376 */  vecZ_rule,
  /* 1377 */  vecZ_rule,
  /* 1378 */  vecS_rule,
  /* 1379 */  vecS_rule,
  /* 1380 */  vecS_rule,
  /* 1381 */  vecD_rule,
  /* 1382 */  vecD_rule,
  /* 1383 */  vecD_rule,
  /* 1384 */  vecX_rule,
  /* 1385 */  vecX_rule,
  /* 1386 */  vecX_rule,
  /* 1387 */  vecY_rule,
  /* 1388 */  vecY_rule,
  /* 1389 */  vecZ_rule,
  /* 1390 */  vecZ_rule,
  /* 1391 */  vecD_rule,
  /* 1392 */  vecD_rule,
  /* 1393 */  vecD_rule,
  /* 1394 */  vecX_rule,
  /* 1395 */  vecX_rule,
  /* 1396 */  vecX_rule,
  /* 1397 */  vecY_rule,
  /* 1398 */  vecY_rule,
  /* 1399 */  vecZ_rule,
  /* 1400 */  vecZ_rule,
  /* 1401 */  vecX_rule,
  /* 1402 */  vecX_rule,
  /* 1403 */  vecX_rule,
  /* 1404 */  vecY_rule,
  /* 1405 */  vecY_rule,
  /* 1406 */  vecZ_rule,
  /* 1407 */  vecZ_rule,
  /* 1408 */  vecD_rule,
  /* 1409 */  vecD_rule,
  /* 1410 */  vecD_rule,
  /* 1411 */  vecX_rule,
  /* 1412 */  vecX_rule,
  /* 1413 */  vecX_rule,
  /* 1414 */  vecY_rule,
  /* 1415 */  vecY_rule,
  /* 1416 */  vecZ_rule,
  /* 1417 */  vecZ_rule,
  /* 1418 */  vecX_rule,
  /* 1419 */  vecX_rule,
  /* 1420 */  vecX_rule,
  /* 1421 */  vecY_rule,
  /* 1422 */  vecY_rule,
  /* 1423 */  vecZ_rule,
  /* 1424 */  vecZ_rule,
  /* 1425 */  vecS_rule,
  /* 1426 */  vecD_rule,
  /* 1427 */  vecX_rule,
  /* 1428 */  vecX_rule,
  /* 1429 */  vecY_rule,
  /* 1430 */  vecZ_rule,
  /* 1431 */  vecS_rule,
  /* 1432 */  vecS_rule,
  /* 1433 */  vecS_rule,
  /* 1434 */  _LoadVector_memory__rule,
  /* 1435 */  vecD_rule,
  /* 1436 */  vecD_rule,
  /* 1437 */  vecD_rule,
  /* 1438 */  _LoadVector_memory__rule,
  /* 1439 */  vecX_rule,
  /* 1440 */  vecX_rule,
  /* 1441 */  vecX_rule,
  /* 1442 */  _LoadVector_memory__rule,
  /* 1443 */  vecY_rule,
  /* 1444 */  vecY_rule,
  /* 1445 */  _LoadVector_memory__rule,
  /* 1446 */  vecZ_rule,
  /* 1447 */  vecZ_rule,
  /* 1448 */  _LoadVector_memory__rule,
  /* 1449 */  vecD_rule,
  /* 1450 */  vecD_rule,
  /* 1451 */  vecD_rule,
  /* 1452 */  _LoadVector_memory__rule,
  /* 1453 */  vecX_rule,
  /* 1454 */  vecX_rule,
  /* 1455 */  vecX_rule,
  /* 1456 */  _LoadVector_memory__rule,
  /* 1457 */  vecX_rule,
  /* 1458 */  vecX_rule,
  /* 1459 */  _LoadVector_memory__rule,
  /* 1460 */  vecY_rule,
  /* 1461 */  vecY_rule,
  /* 1462 */  _LoadVector_memory__rule,
  /* 1463 */  vecZ_rule,
  /* 1464 */  vecZ_rule,
  /* 1465 */  _LoadVector_memory__rule,
  /* 1466 */  vecY_rule,
  /* 1467 */  vecY_rule,
  /* 1468 */  _LoadVector_memory__rule,
  /* 1469 */  vecZ_rule,
  /* 1470 */  vecZ_rule,
  /* 1471 */  _LoadVector_memory__rule,
  /* 1472 */  vecD_rule,
  /* 1473 */  vecD_rule,
  /* 1474 */  vecD_rule,
  /* 1475 */  _LoadVector_memory__rule,
  /* 1476 */  vecX_rule,
  /* 1477 */  vecX_rule,
  /* 1478 */  vecX_rule,
  /* 1479 */  _LoadVector_memory__rule,
  /* 1480 */  vecY_rule,
  /* 1481 */  vecY_rule,
  /* 1482 */  _LoadVector_memory__rule,
  /* 1483 */  vecZ_rule,
  /* 1484 */  vecZ_rule,
  /* 1485 */  _LoadVector_memory__rule,
  /* 1486 */  vecX_rule,
  /* 1487 */  vecX_rule,
  /* 1488 */  vecX_rule,
  /* 1489 */  _LoadVector_memory__rule,
  /* 1490 */  vecY_rule,
  /* 1491 */  vecY_rule,
  /* 1492 */  _LoadVector_memory__rule,
  /* 1493 */  vecZ_rule,
  /* 1494 */  vecZ_rule,
  /* 1495 */  _LoadVector_memory__rule,
  /* 1496 */  _Binary_cmpOp_vcmppd_immI8_rule,
  /* 1497 */  _Binary_cmpOp_vcmppd_immI8_rule,
  /* 1498 */  vecD_rule,
  /* 1499 */  vecD_rule,
  /* 1500 */  vecD_rule,
  /* 1501 */  vecX_rule,
  /* 1502 */  vecX_rule,
  /* 1503 */  vecX_rule,
  /* 1504 */  vecY_rule,
  /* 1505 */  vecY_rule,
  /* 1506 */  vecZ_rule,
  /* 1507 */  vecZ_rule,
  /* 1508 */  vecX_rule,
  /* 1509 */  vecX_rule,
  /* 1510 */  vecX_rule,
  /* 1511 */  vecY_rule,
  /* 1512 */  vecY_rule,
  /* 1513 */  vecZ_rule,
  /* 1514 */  vecZ_rule,
  /* 1515 */  vecS_rule,
  /* 1516 */  vecS_rule,
  /* 1517 */  vecS_rule,
  /* 1518 */  vecD_rule,
  /* 1519 */  vecD_rule,
  /* 1520 */  vecD_rule,
  /* 1521 */  vecX_rule,
  /* 1522 */  vecX_rule,
  /* 1523 */  vecX_rule,
  /* 1524 */  vecX_rule,
  /* 1525 */  vecX_rule,
  /* 1526 */  vecX_rule,
  /* 1527 */  vecY_rule,
  /* 1528 */  vecY_rule,
  /* 1529 */  vecY_rule,
  /* 1530 */  vecZ_rule,
  /* 1531 */  vecZ_rule,
  /* 1532 */  vecZ_rule,
  /* 1533 */  vecS_rule,
  /* 1534 */  vecS_rule,
  /* 1535 */  vecS_rule,
  /* 1536 */  vecD_rule,
  /* 1537 */  vecD_rule,
  /* 1538 */  vecD_rule,
  /* 1539 */  vecX_rule,
  /* 1540 */  vecX_rule,
  /* 1541 */  vecX_rule,
  /* 1542 */  vecY_rule,
  /* 1543 */  vecY_rule,
  /* 1544 */  vecY_rule,
  /* 1545 */  vecZ_rule,
  /* 1546 */  vecZ_rule,
  /* 1547 */  vecZ_rule,
  /* 1548 */  vecD_rule,
  /* 1549 */  vecD_rule,
  /* 1550 */  vecD_rule,
  /* 1551 */  vecX_rule,
  /* 1552 */  vecX_rule,
  /* 1553 */  vecX_rule,
  /* 1554 */  vecY_rule,
  /* 1555 */  vecY_rule,
  /* 1556 */  vecY_rule,
  /* 1557 */  vecZ_rule,
  /* 1558 */  vecZ_rule,
  /* 1559 */  vecZ_rule,
  /* 1560 */  vecX_rule,
  /* 1561 */  vecX_rule,
  /* 1562 */  vecY_rule,
  /* 1563 */  vecY_rule,
  /* 1564 */  vecZ_rule,
  /* 1565 */  vecZ_rule,
  /* 1566 */  vecZ_rule,
  /* 1567 */  vecX_rule,
  /* 1568 */  vecX_rule,
  /* 1569 */  vecY_rule,
  /* 1570 */  vecY_rule,
  /* 1571 */  vecS_rule,
  /* 1572 */  vecS_rule,
  /* 1573 */  vecS_rule,
  /* 1574 */  _LoadVector_memory__rule,
  /* 1575 */  vecD_rule,
  /* 1576 */  vecD_rule,
  /* 1577 */  vecD_rule,
  /* 1578 */  _LoadVector_memory__rule,
  /* 1579 */  vecX_rule,
  /* 1580 */  vecX_rule,
  /* 1581 */  vecX_rule,
  /* 1582 */  _LoadVector_memory__rule,
  /* 1583 */  vecY_rule,
  /* 1584 */  vecY_rule,
  /* 1585 */  _LoadVector_memory__rule,
  /* 1586 */  vecZ_rule,
  /* 1587 */  vecZ_rule,
  /* 1588 */  _LoadVector_memory__rule,
  /* 1589 */  vecS_rule,
  /* 1590 */  vecS_rule,
  /* 1591 */  vecS_rule,
  /* 1592 */  _LoadVector_memory__rule,
  /* 1593 */  vecD_rule,
  /* 1594 */  vecD_rule,
  /* 1595 */  vecD_rule,
  /* 1596 */  _LoadVector_memory__rule,
  /* 1597 */  vecX_rule,
  /* 1598 */  vecX_rule,
  /* 1599 */  vecX_rule,
  /* 1600 */  _LoadVector_memory__rule,
  /* 1601 */  vecY_rule,
  /* 1602 */  vecY_rule,
  /* 1603 */  _LoadVector_memory__rule,
  /* 1604 */  vecZ_rule,
  /* 1605 */  vecZ_rule,
  /* 1606 */  _LoadVector_memory__rule,
  /* 1607 */  vecS_rule,
  /* 1608 */  vecS_rule,
  /* 1609 */  vecS_rule,
  /* 1610 */  _LoadVector_memory__rule,
  /* 1611 */  vecD_rule,
  /* 1612 */  vecD_rule,
  /* 1613 */  vecD_rule,
  /* 1614 */  _LoadVector_memory__rule,
  /* 1615 */  vecX_rule,
  /* 1616 */  vecX_rule,
  /* 1617 */  vecX_rule,
  /* 1618 */  _LoadVector_memory__rule,
  /* 1619 */  vecY_rule,
  /* 1620 */  vecY_rule,
  /* 1621 */  _LoadVector_memory__rule,
  /* 1622 */  vecZ_rule,
  /* 1623 */  vecZ_rule,
  /* 1624 */  _LoadVector_memory__rule,
  /* 1625 */  vecX_rule,
  /* 1626 */  vecX_rule,
  /* 1627 */  vecY_rule,
  /* 1628 */  vecY_rule,
  /* 1629 */  vecZ_rule,
  /* 1630 */  vecZ_rule,
  /* 1631 */  vecD_rule,
  /* 1632 */  vecD_rule,
  /* 1633 */  vecX_rule,
  /* 1634 */  vecX_rule,
  /* 1635 */  vecY_rule,
  /* 1636 */  vecY_rule,
  /* 1637 */  vecZ_rule,
  /* 1638 */  vecZ_rule,
  /* 1639 */  vecX_rule,
  /* 1640 */  vecX_rule,
  /* 1641 */  vecY_rule,
  /* 1642 */  vecY_rule,
  /* 1643 */  vecZ_rule,
  /* 1644 */  vecZ_rule,
  /* 1645 */  vecX_rule,
  /* 1646 */  vecX_rule,
  /* 1647 */  vecY_rule,
  /* 1648 */  vecY_rule,
  /* 1649 */  vecZ_rule,
  /* 1650 */  vecZ_rule,
  /* 1651 */  memory_rule,
  /* 1652 */  memory_rule,
  /* 1653 */  memory_rule,
  /* 1654 */  memory_rule,
  /* 1655 */  memory_rule,
  /* 1656 */  memory_rule,
  // last instruction
  0 // no trailing comma
};

const        int   rightOp[] = {
  /*    0 */  0,
  /*    1 */  0,
  /*    2 */  0,
  /*    3 */  0,
  /*    4 */  0,
  /*    5 */  0,
  /*    6 */  0,
  /*    7 */  0,
  /*    8 */  0,
  /*    9 */  0,
  /*   10 */  0,
  /*   11 */  0,
  /*   12 */  0,
  /*   13 */  0,
  /*   14 */  0,
  /*   15 */  0,
  /*   16 */  0,
  /*   17 */  0,
  /*   18 */  0,
  /*   19 */  0,
  /*   20 */  0,
  /*   21 */  0,
  /*   22 */  0,
  /*   23 */  0,
  /*   24 */  0,
  /*   25 */  0,
  /*   26 */  0,
  /*   27 */  0,
  /*   28 */  0,
  /*   29 */  0,
  /*   30 */  0,
  /*   31 */  0,
  /*   32 */  0,
  /*   33 */  0,
  /*   34 */  0,
  /*   35 */  0,
  /*   36 */  0,
  /*   37 */  0,
  /*   38 */  0,
  /*   39 */  0,
  /*   40 */  0,
  /*   41 */  0,
  /*   42 */  0,
  /*   43 */  0,
  /*   44 */  0,
  /*   45 */  0,
  /*   46 */  0,
  /*   47 */  0,
  /*   48 */  0,
  /*   49 */  0,
  /*   50 */  0,
  /*   51 */  0,
  /*   52 */  0,
  /*   53 */  0,
  /*   54 */  0,
  /*   55 */  0,
  /*   56 */  0,
  /*   57 */  0,
  /*   58 */  0,
  /*   59 */  0,
  /*   60 */  0,
  /*   61 */  0,
  /*   62 */  0,
  /*   63 */  0,
  /*   64 */  0,
  /*   65 */  0,
  /*   66 */  0,
  /*   67 */  0,
  /*   68 */  0,
  /*   69 */  0,
  /*   70 */  0,
  /*   71 */  0,
  /*   72 */  0,
  /*   73 */  0,
  /*   74 */  0,
  /*   75 */  0,
  /*   76 */  0,
  /*   77 */  0,
  /*   78 */  0,
  /*   79 */  0,
  /*   80 */  0,
  /*   81 */  0,
  /*   82 */  0,
  /*   83 */  0,
  /*   84 */  0,
  /*   85 */  0,
  /*   86 */  0,
  /*   87 */  0,
  /*   88 */  0,
  /*   89 */  0,
  /*   90 */  0,
  /*   91 */  immL8_rule,
  /*   92 */  immL32_rule,
  /*   93 */  immL32_rule,
  /*   94 */  rRegL_rule,
  /*   95 */  _LShiftL_rRegL_immI2_rule,
  /*   96 */  _LShiftL__ConvI2L_rRegI__immI2_rule,
  /*   97 */  immL32_rule,
  /*   98 */  immL32_rule,
  /*   99 */  immL32_rule,
  /*  100 */  immL32_rule,
  /*  101 */  0,
  /*  102 */  immL8_rule,
  /*  103 */  immL32_rule,
  /*  104 */  immL32_rule,
  /*  105 */  rRegL_rule,
  /*  106 */  _LShiftL_rRegL_immI2_rule,
  /*  107 */  immL32_rule,
  /*  108 */  immL32_rule,
  /*  109 */  immL32_rule,
  /*  110 */  0,
  /*  111 */  0,
  /*  112 */  0,
  /*  113 */  0,
  /*  114 */  0,
  /*  115 */  0,
  /*  116 */  0,
  /*  117 */  0,
  /*  118 */  0,
  /*  119 */  0,
  /*  120 */  0,
  /*  121 */  0,
  /*  122 */  0,
  /*  123 */  0,
  /*  124 */  0,
  /*  125 */  0,
  /*  126 */  0,
  /*  127 */  0,
  /*  128 */  0,
  /*  129 */  0,
  /*  130 */  0,
  /*  131 */  0,
  /*  132 */  0,
  /*  133 */  0,
  /*  134 */  0,
  /*  135 */  0,
  /*  136 */  0,
  /*  137 */  0,
  /*  138 */  0,
  /*  139 */  0,
  /*  140 */  0,
  /*  141 */  0,
  /*  142 */  0,
  /*  143 */  0,
  /*  144 */  0,
  /*  145 */  0,
  /*  146 */  0,
  /*  147 */  0,
  /*  148 */  0,
  /*  149 */  0,
  /*  150 */  0,
  /*  151 */  0,
  /*  152 */  0,
  /*  153 */  0,
  // last operand
  /*  154 */  0,
  // last operand class
  /*  155 */  rRegL_rule,
  /*  156 */  immI2_rule,
  /*  157 */  0,
  /*  158 */  immI2_rule,
  /*  159 */  _LShiftL_rRegL_immI2_rule,
  /*  160 */  _ConvI2L_rRegI__rule,
  /*  161 */  _LShiftL__ConvI2L_rRegI__immI2_rule,
  /*  162 */  0,
  /*  163 */  rRegL_rule,
  /*  164 */  _LShiftL_rRegL_immI2_rule,
  /*  165 */  _ConvI2L_rRegI__rule,
  /*  166 */  _LShiftL__ConvI2L_rRegI__immI2_rule,
  /*  167 */  0,
  /*  168 */  0,
  /*  169 */  immI_rule,
  /*  170 */  0,
  /*  171 */  immI_24_rule,
  /*  172 */  0,
  /*  173 */  immI_24_rule,
  /*  174 */  immI_255_rule,
  /*  175 */  immI_rule,
  /*  176 */  0,
  /*  177 */  immI_24_rule,
  /*  178 */  immI_16_rule,
  /*  179 */  immI_255_rule,
  /*  180 */  immI_65535_rule,
  /*  181 */  immU31_rule,
  /*  182 */  0,
  /*  183 */  0,
  /*  184 */  0,
  /*  185 */  0,
  /*  186 */  immL32_rule,
  /*  187 */  rFlagsReg_rule,
  /*  188 */  rRegI_rule,
  /*  189 */  rFlagsRegU_rule,
  /*  190 */  rFlagsRegUCF_rule,
  /*  191 */  _LoadI_memory__rule,
  /*  192 */  rRegN_rule,
  /*  193 */  rRegP_rule,
  /*  194 */  rRegL_rule,
  /*  195 */  _LoadL_memory__rule,
  /*  196 */  regF_rule,
  /*  197 */  regD_rule,
  /*  198 */  rRegI_rule,
  /*  199 */  _LoadI_memory__rule,
  /*  200 */  immI_rule,
  /*  201 */  immI1_rule,
  /*  202 */  immI_M1_rule,
  /*  203 */  rRegL_rule,
  /*  204 */  _LoadL_memory__rule,
  /*  205 */  immL32_rule,
  /*  206 */  immL1_rule,
  /*  207 */  immL_M1_rule,
  /*  208 */  rRegP_rule,
  /*  209 */  rRegI_rule,
  /*  210 */  rRegL_rule,
  /*  211 */  rRegN_rule,
  /*  212 */  rRegI_rule,
  /*  213 */  immI_rule,
  /*  214 */  rRegL_rule,
  /*  215 */  immL32_rule,
  /*  216 */  rRegI_rule,
  /*  217 */  _LoadI_memory__rule,
  /*  218 */  _LoadL_memory__rule,
  /*  219 */  immI1_rule,
  /*  220 */  immI8_rule,
  /*  221 */  rcx_RegI_rule,
  /*  222 */  immI1_rule,
  /*  223 */  immI8_rule,
  /*  224 */  rcx_RegI_rule,
  /*  225 */  immI1_rule,
  /*  226 */  immI8_rule,
  /*  227 */  rcx_RegI_rule,
  /*  228 */  immI1_rule,
  /*  229 */  immI8_rule,
  /*  230 */  rcx_RegI_rule,
  /*  231 */  immI1_rule,
  /*  232 */  immI8_rule,
  /*  233 */  rcx_RegI_rule,
  /*  234 */  immI1_rule,
  /*  235 */  immI8_rule,
  /*  236 */  rcx_RegI_rule,
  /*  237 */  immI_24_rule,
  /*  238 */  immI_16_rule,
  /*  239 */  immI1_rule,
  /*  240 */  immI_M1_rule,
  /*  241 */  immI8_rule,
  /*  242 */  immI8_rule,
  /*  243 */  rcx_RegI_rule,
  /*  244 */  rcx_RegI_rule,
  /*  245 */  _SubI_immI0_rcx_RegI_rule,
  /*  246 */  rcx_RegI_rule,
  /*  247 */  _SubI_immI_32_rcx_RegI_rule,
  /*  248 */  immI1_rule,
  /*  249 */  immI_M1_rule,
  /*  250 */  rcx_RegI_rule,
  /*  251 */  _SubI_immI0_rcx_RegI_rule,
  /*  252 */  _SubI_immI_32_rcx_RegI_rule,
  /*  253 */  immI1_rule,
  /*  254 */  immI_M1_rule,
  /*  255 */  immI8_rule,
  /*  256 */  immI8_rule,
  /*  257 */  rcx_RegI_rule,
  /*  258 */  _SubI_immI0_rcx_RegI_rule,
  /*  259 */  rcx_RegI_rule,
  /*  260 */  _SubI_immI_64_rcx_RegI_rule,
  /*  261 */  immI1_rule,
  /*  262 */  immI_M1_rule,
  /*  263 */  rcx_RegI_rule,
  /*  264 */  _SubI_immI0_rcx_RegI_rule,
  /*  265 */  _SubI_immI_64_rcx_RegI_rule,
  /*  266 */  immI_255_rule,
  /*  267 */  immI_65535_rule,
  /*  268 */  rRegI_rule,
  /*  269 */  _LoadI_memory__rule,
  /*  270 */  immI_rule,
  /*  271 */  immI_M1_rule,
  /*  272 */  immI_M1_rule,
  /*  273 */  rRegI_rule,
  /*  274 */  _LoadI_memory__rule,
  /*  275 */  immI_rule,
  /*  276 */  rRegI_rule,
  /*  277 */  _LoadI_memory__rule,
  /*  278 */  immI_rule,
  /*  279 */  rRegL_rule,
  /*  280 */  _LoadL_memory__rule,
  /*  281 */  immL32_rule,
  /*  282 */  immL_M1_rule,
  /*  283 */  rRegL_rule,
  /*  284 */  immL_M1_rule,
  /*  285 */  0,
  /*  286 */  rRegL_rule,
  /*  287 */  _LoadL_memory__rule,
  /*  288 */  immL32_rule,
  /*  289 */  rRegL_rule,
  /*  290 */  _LoadL_memory__rule,
  /*  291 */  immL32_rule,
  /*  292 */  rRegI_rule,
  /*  293 */  rRegI_rule,
  /*  294 */  rRegI_rule,
  /*  295 */  _CmpLTMask_rRegI_rRegI_rule,
  /*  296 */  0,
  /*  297 */  0,
  /*  298 */  rcx_RegI_rule,
  /*  299 */  rdx_RegI_rule,
  /*  300 */  rdx_RegI_rule,
  /*  301 */  immI_rule,
  /*  302 */  rax_RegI_rule,
  /*  303 */  rsi_RegP_rule,
  /*  304 */  immI_rule,
  /*  305 */  0,
  /*  306 */  0,
  /*  307 */  0,
  /*  308 */  immL32_rule,
  /*  309 */  _LoadL_memory__rule,
  /*  310 */  _CastP2X_rRegP__rule,
  /*  311 */  immI8_rule,
  /*  312 */  rax_RegP_rule,
  /*  313 */  0,
  /*  314 */  immI8_rule,
  /*  315 */  legVecY_rule,
  /*  316 */  vecX_rule,
  /*  317 */  _LoadVector_memory__rule,
  /*  318 */  vecY_rule,
  /*  319 */  _LoadVector_memory__rule,
  /*  320 */  vecZ_rule,
  /*  321 */  _LoadVector_memory__rule,
  // last internally defined operand
  /*  322 */  0,
  /*  323 */  0,
  /*  324 */  0,
  /*  325 */  0,
  /*  326 */  0,
  /*  327 */  0,
  /*  328 */  0,
  /*  329 */  0,
  /*  330 */  0,
  /*  331 */  0,
  /*  332 */  0,
  /*  333 */  0,
  /*  334 */  0,
  /*  335 */  0,
  /*  336 */  0,
  /*  337 */  0,
  /*  338 */  0,
  /*  339 */  0,
  /*  340 */  0,
  /*  341 */  0,
  /*  342 */  0,
  /*  343 */  0,
  /*  344 */  0,
  /*  345 */  0,
  /*  346 */  0,
  /*  347 */  0,
  /*  348 */  0,
  /*  349 */  0,
  /*  350 */  0,
  /*  351 */  0,
  /*  352 */  0,
  /*  353 */  0,
  /*  354 */  0,
  /*  355 */  0,
  /*  356 */  0,
  /*  357 */  0,
  /*  358 */  0,
  /*  359 */  0,
  /*  360 */  0,
  /*  361 */  0,
  /*  362 */  0,
  /*  363 */  0,
  /*  364 */  0,
  /*  365 */  0,
  /*  366 */  0,
  /*  367 */  0,
  /*  368 */  0,
  /*  369 */  0,
  /*  370 */  0,
  /*  371 */  0,
  /*  372 */  0,
  /*  373 */  0,
  /*  374 */  0,
  /*  375 */  0,
  /*  376 */  0,
  /*  377 */  0,
  /*  378 */  0,
  /*  379 */  0,
  /*  380 */  0,
  /*  381 */  0,
  /*  382 */  0,
  /*  383 */  0,
  /*  384 */  0,
  /*  385 */  0,
  /*  386 */  0,
  /*  387 */  0,
  /*  388 */  0,
  /*  389 */  _Binary_rax_RegP_rRegP_rule,
  /*  390 */  _Binary_rax_RegI_rRegI_rule,
  /*  391 */  _Binary_rax_RegL_rRegL_rule,
  /*  392 */  regF_rule,
  /*  393 */  regF_rule,
  /*  394 */  _LoadF_memory__rule,
  /*  395 */  _LoadF_memory__rule,
  /*  396 */  immF_rule,
  /*  397 */  immF_rule,
  /*  398 */  regD_rule,
  /*  399 */  regD_rule,
  /*  400 */  _LoadD_memory__rule,
  /*  401 */  _LoadD_memory__rule,
  /*  402 */  immD_rule,
  /*  403 */  immD_rule,
  /*  404 */  0,
  /*  405 */  0,
  /*  406 */  0,
  /*  407 */  0,
  /*  408 */  0,
  /*  409 */  0,
  /*  410 */  0,
  /*  411 */  0,
  /*  412 */  0,
  /*  413 */  0,
  /*  414 */  0,
  /*  415 */  rRegI_rule,
  /*  416 */  immI_rule,
  /*  417 */  rRegL_rule,
  /*  418 */  immL32_rule,
  /*  419 */  rRegI_rule,
  /*  420 */  immI_rule,
  /*  421 */  rRegL_rule,
  /*  422 */  immL32_rule,
  /*  423 */  rax_RegI_rule,
  /*  424 */  rax_RegL_rule,
  /*  425 */  rRegI_rule,
  /*  426 */  immI_rule,
  /*  427 */  rRegL_rule,
  /*  428 */  immL32_rule,
  /*  429 */  rRegI_rule,
  /*  430 */  immI_rule,
  /*  431 */  _LoadI_memory__rule,
  /*  432 */  immI0_rule,
  /*  433 */  immI0_rule,
  /*  434 */  immI0_rule,
  /*  435 */  immI0_rule,
  /*  436 */  rRegI_rule,
  /*  437 */  immI_rule,
  /*  438 */  _LoadI_memory__rule,
  /*  439 */  immI0_rule,
  /*  440 */  rRegP_rule,
  /*  441 */  _LoadP_memory__rule,
  /*  442 */  _LoadP_memory__rule,
  /*  443 */  immP0_rule,
  /*  444 */  immP0_rule,
  /*  445 */  immP0_rule,
  /*  446 */  rRegN_rule,
  /*  447 */  _LoadN_memory__rule,
  /*  448 */  immN_rule,
  /*  449 */  _LoadN_memory__rule,
  /*  450 */  immNKlass_rule,
  /*  451 */  _LoadNKlass_memory__rule,
  /*  452 */  immN0_rule,
  /*  453 */  immN0_rule,
  /*  454 */  immN0_rule,
  /*  455 */  rRegL_rule,
  /*  456 */  immL32_rule,
  /*  457 */  _LoadL_memory__rule,
  /*  458 */  immL0_rule,
  /*  459 */  immL0_rule,
  /*  460 */  immL0_rule,
  /*  461 */  immL0_rule,
  /*  462 */  immL0_rule,
  /*  463 */  immL0_rule,
  /*  464 */  rRegL_rule,
  /*  465 */  immL32_rule,
  /*  466 */  _LoadL_memory__rule,
  /*  467 */  immL0_rule,
  /*  468 */  immI8_rule,
  /*  469 */  immI0_rule,
  /*  470 */  immP0_rule,
  /*  471 */  rbx_RegP_rule,
  /*  472 */  rbx_RegP_rule,
  /*  473 */  rax_RegP_rule,
  /*  474 */  0,
  /*  475 */  0,
  /*  476 */  0,
  /*  477 */  0,
  /*  478 */  0,
  /*  479 */  0,
  /*  480 */  0,
  /*  481 */  0,
  /*  482 */  0,
  /*  483 */  0,
  /*  484 */  0,
  /*  485 */  0,
  /*  486 */  0,
  /*  487 */  0,
  /*  488 */  0,
  /*  489 */  0,
  /*  490 */  0,
  /*  491 */  0,
  /*  492 */  0,
  /*  493 */  0,
  /*  494 */  0,
  /*  495 */  0,
  /*  496 */  0,
  /*  497 */  0,
  /*  498 */  0,
  /*  499 */  0,
  /*  500 */  0,
  /*  501 */  0,
  /*  502 */  0,
  /*  503 */  0,
  /*  504 */  0,
  /*  505 */  0,
  /*  506 */  0,
  /*  507 */  0,
  /*  508 */  0,
  /*  509 */  0,
  /*  510 */  0,
  /*  511 */  0,
  /*  512 */  0,
  /*  513 */  0,
  /*  514 */  0,
  /*  515 */  0,
  /*  516 */  0,
  /*  517 */  0,
  /*  518 */  0,
  /*  519 */  0,
  /*  520 */  0,
  /*  521 */  0,
  /*  522 */  0,
  /*  523 */  0,
  /*  524 */  0,
  /*  525 */  0,
  /*  526 */  0,
  /*  527 */  immI_24_rule,
  /*  528 */  0,
  /*  529 */  0,
  /*  530 */  immI_24_rule,
  /*  531 */  0,
  /*  532 */  0,
  /*  533 */  0,
  /*  534 */  0,
  /*  535 */  immI_24_rule,
  /*  536 */  immI_255_rule,
  /*  537 */  immI_16_rule,
  /*  538 */  immI_65535_rule,
  /*  539 */  0,
  /*  540 */  0,
  /*  541 */  0,
  /*  542 */  0,
  /*  543 */  immL_32bits_rule,
  /*  544 */  0,
  /*  545 */  0,
  /*  546 */  0,
  /*  547 */  0,
  /*  548 */  0,
  /*  549 */  0,
  /*  550 */  0,
  /*  551 */  0,
  /*  552 */  0,
  /*  553 */  legRegF_rule,
  /*  554 */  legRegF_rule,
  /*  555 */  legRegD_rule,
  /*  556 */  legRegD_rule,
  /*  557 */  legRegF_rule,
  /*  558 */  legRegF_rule,
  /*  559 */  legRegD_rule,
  /*  560 */  legRegD_rule,
  /*  561 */  0,
  /*  562 */  0,
  /*  563 */  0,
  /*  564 */  0,
  /*  565 */  rRegI_rule,
  /*  566 */  rRegI_rule,
  /*  567 */  rRegI_rule,
  /*  568 */  rRegL_rule,
  /*  569 */  any_RegP_rule,
  /*  570 */  immP0_rule,
  /*  571 */  immP31_rule,
  /*  572 */  rRegN_rule,
  /*  573 */  rRegN_rule,
  /*  574 */  immN0_rule,
  /*  575 */  immN_rule,
  /*  576 */  immNKlass_rule,
  /*  577 */  immI0_rule,
  /*  578 */  immI_rule,
  /*  579 */  immL0_rule,
  /*  580 */  immL32_rule,
  /*  581 */  immI0_rule,
  /*  582 */  immI16_rule,
  /*  583 */  immI0_rule,
  /*  584 */  immI8_rule,
  /*  585 */  immI0_rule,
  /*  586 */  immI0_rule,
  /*  587 */  regF_rule,
  /*  588 */  immF0_rule,
  /*  589 */  immF_rule,
  /*  590 */  regD_rule,
  /*  591 */  immD0_rule,
  /*  592 */  immD0_rule,
  /*  593 */  0,
  /*  594 */  0,
  /*  595 */  0,
  /*  596 */  0,
  /*  597 */  0,
  /*  598 */  0,
  /*  599 */  0,
  /*  600 */  0,
  /*  601 */  0,
  /*  602 */  0,
  /*  603 */  0,
  /*  604 */  0,
  /*  605 */  0,
  /*  606 */  0,
  /*  607 */  0,
  /*  608 */  0,
  /*  609 */  0,
  /*  610 */  0,
  /*  611 */  0,
  /*  612 */  0,
  /*  613 */  0,
  /*  614 */  0,
  /*  615 */  0,
  /*  616 */  0,
  /*  617 */  0,
  /*  618 */  0,
  /*  619 */  0,
  /*  620 */  0,
  /*  621 */  0,
  /*  622 */  0,
  /*  623 */  0,
  /*  624 */  0,
  /*  625 */  0,
  /*  626 */  0,
  /*  627 */  0,
  /*  628 */  _Binary_rRegI_rRegI_rule,
  /*  629 */  _Binary_rRegI_rRegI_rule,
  /*  630 */  _Binary_rRegI_rRegI_rule,
  /*  631 */  _Binary_rRegI__LoadI_memory__rule,
  /*  632 */  _Binary_rRegI__LoadI_memory__rule,
  /*  633 */  _Binary_rRegI__LoadI_memory__rule,
  /*  634 */  _Binary_rRegN_rRegN_rule,
  /*  635 */  _Binary_rRegN_rRegN_rule,
  /*  636 */  _Binary_rRegN_rRegN_rule,
  /*  637 */  _Binary_rRegP_rRegP_rule,
  /*  638 */  _Binary_rRegP_rRegP_rule,
  /*  639 */  _Binary_rRegP_rRegP_rule,
  /*  640 */  _Binary_rRegL_rRegL_rule,
  /*  641 */  _Binary_rRegL__LoadL_memory__rule,
  /*  642 */  _Binary_rRegL_rRegL_rule,
  /*  643 */  _Binary_rRegL_rRegL_rule,
  /*  644 */  _Binary_rRegL__LoadL_memory__rule,
  /*  645 */  _Binary_rRegL__LoadL_memory__rule,
  /*  646 */  _Binary_regF_regF_rule,
  /*  647 */  _Binary_regF_regF_rule,
  /*  648 */  _Binary_regF_regF_rule,
  /*  649 */  _Binary_regD_regD_rule,
  /*  650 */  _Binary_regD_regD_rule,
  /*  651 */  _Binary_regD_regD_rule,
  /*  652 */  rRegI_rule,
  /*  653 */  immI_rule,
  /*  654 */  _LoadI_memory__rule,
  /*  655 */  rRegI_rule,
  /*  656 */  _AddI__LoadI_memory__rRegI_rule,
  /*  657 */  _AddI_rRegI__LoadI_memory__rule,
  /*  658 */  _AddI__LoadI_memory__immI_rule,
  /*  659 */  immI1_rule,
  /*  660 */  _AddI__LoadI_memory__immI1_rule,
  /*  661 */  immI_M1_rule,
  /*  662 */  _AddI__LoadI_memory__immI_M1_rule,
  /*  663 */  immI_rule,
  /*  664 */  rRegL_rule,
  /*  665 */  immL32_rule,
  /*  666 */  _LoadL_memory__rule,
  /*  667 */  rRegL_rule,
  /*  668 */  _AddL__LoadL_memory__rRegL_rule,
  /*  669 */  _AddL_rRegL__LoadL_memory__rule,
  /*  670 */  _AddL__LoadL_memory__immL32_rule,
  /*  671 */  immL1_rule,
  /*  672 */  _AddL__LoadL_memory__immL1_rule,
  /*  673 */  immL_M1_rule,
  /*  674 */  _AddL__LoadL_memory__immL_M1_rule,
  /*  675 */  immL32_rule,
  /*  676 */  rRegL_rule,
  /*  677 */  immL32_rule,
  /*  678 */  immL32_rule,
  /*  679 */  0,
  /*  680 */  _Binary_rax_RegP_rRegP_rule,
  /*  681 */  _Binary_rax_RegP_rRegP_rule,
  /*  682 */  _Binary_rax_RegL_rRegL_rule,
  /*  683 */  _Binary_rax_RegL_rRegL_rule,
  /*  684 */  _Binary_rax_RegI_rRegI_rule,
  /*  685 */  _Binary_rax_RegI_rRegI_rule,
  /*  686 */  _Binary_rax_RegI_rRegI_rule,
  /*  687 */  _Binary_rax_RegI_rRegI_rule,
  /*  688 */  _Binary_rax_RegI_rRegI_rule,
  /*  689 */  _Binary_rax_RegI_rRegI_rule,
  /*  690 */  _Binary_rax_RegN_rRegN_rule,
  /*  691 */  _Binary_rax_RegN_rRegN_rule,
  /*  692 */  _Binary_rax_RegI_rRegI_rule,
  /*  693 */  _Binary_rax_RegI_rRegI_rule,
  /*  694 */  _Binary_rax_RegI_rRegI_rule,
  /*  695 */  _Binary_rax_RegL_rRegL_rule,
  /*  696 */  _Binary_rax_RegN_rRegN_rule,
  /*  697 */  _Binary_rax_RegP_rRegP_rule,
  /*  698 */  immI_rule,
  /*  699 */  rRegI_rule,
  /*  700 */  immI_rule,
  /*  701 */  rRegI_rule,
  /*  702 */  immI_rule,
  /*  703 */  rRegI_rule,
  /*  704 */  immL32_rule,
  /*  705 */  rRegL_rule,
  /*  706 */  rRegI_rule,
  /*  707 */  rRegI_rule,
  /*  708 */  rRegI_rule,
  /*  709 */  rRegL_rule,
  /*  710 */  rRegP_rule,
  /*  711 */  rRegN_rule,
  /*  712 */  0,
  /*  713 */  0,
  /*  714 */  rRegI_rule,
  /*  715 */  immI_rule,
  /*  716 */  _LoadI_memory__rule,
  /*  717 */  _SubI__LoadI_memory__rRegI_rule,
  /*  718 */  _SubI__LoadI_memory__immI_rule,
  /*  719 */  rRegL_rule,
  /*  720 */  immL32_rule,
  /*  721 */  _LoadL_memory__rule,
  /*  722 */  _SubL__LoadL_memory__rRegL_rule,
  /*  723 */  _SubL__LoadL_memory__immL32_rule,
  /*  724 */  _SubI_immI0_rRegI_rule,
  /*  725 */  rRegI_rule,
  /*  726 */  _SubI_immI0__LoadI_memory__rule,
  /*  727 */  rRegL_rule,
  /*  728 */  _SubL_immL0__LoadL_memory__rule,
  /*  729 */  rRegI_rule,
  /*  730 */  immI_rule,
  /*  731 */  _LoadI_memory__rule,
  /*  732 */  rRegI_rule,
  /*  733 */  immI_rule,
  /*  734 */  rRegL_rule,
  /*  735 */  immL32_rule,
  /*  736 */  _LoadL_memory__rule,
  /*  737 */  rRegL_rule,
  /*  738 */  immL32_rule,
  /*  739 */  rax_RegL_rule,
  /*  740 */  no_rax_rdx_RegI_rule,
  /*  741 */  no_rax_rdx_RegL_rule,
  /*  742 */  no_rax_rdx_RegI_rule,
  /*  743 */  no_rax_rdx_RegL_rule,
  /*  744 */  0,
  /*  745 */  0,
  /*  746 */  0,
  /*  747 */  0,
  /*  748 */  immL10_rule,
  /*  749 */  no_rax_rdx_RegI_rule,
  /*  750 */  no_rax_rdx_RegL_rule,
  /*  751 */  immI1_rule,
  /*  752 */  _LShiftI__LoadI_memory__immI1_rule,
  /*  753 */  immI8_rule,
  /*  754 */  _LShiftI__LoadI_memory__immI8_rule,
  /*  755 */  rcx_RegI_rule,
  /*  756 */  _LShiftI__LoadI_memory__rcx_RegI_rule,
  /*  757 */  immI1_rule,
  /*  758 */  _RShiftI__LoadI_memory__immI1_rule,
  /*  759 */  immI8_rule,
  /*  760 */  _RShiftI__LoadI_memory__immI8_rule,
  /*  761 */  rcx_RegI_rule,
  /*  762 */  _RShiftI__LoadI_memory__rcx_RegI_rule,
  /*  763 */  immI1_rule,
  /*  764 */  _URShiftI__LoadI_memory__immI1_rule,
  /*  765 */  immI8_rule,
  /*  766 */  _URShiftI__LoadI_memory__immI8_rule,
  /*  767 */  rcx_RegI_rule,
  /*  768 */  _URShiftI__LoadI_memory__rcx_RegI_rule,
  /*  769 */  immI1_rule,
  /*  770 */  _LShiftL__LoadL_memory__immI1_rule,
  /*  771 */  immI8_rule,
  /*  772 */  _LShiftL__LoadL_memory__immI8_rule,
  /*  773 */  rcx_RegI_rule,
  /*  774 */  _LShiftL__LoadL_memory__rcx_RegI_rule,
  /*  775 */  immI1_rule,
  /*  776 */  _RShiftL__LoadL_memory__immI1_rule,
  /*  777 */  immI8_rule,
  /*  778 */  _RShiftL__LoadL_memory__immI8_rule,
  /*  779 */  rcx_RegI_rule,
  /*  780 */  _RShiftL__LoadL_memory__rcx_RegI_rule,
  /*  781 */  immI1_rule,
  /*  782 */  _URShiftL__LoadL_memory__immI1_rule,
  /*  783 */  immI8_rule,
  /*  784 */  _URShiftL__LoadL_memory__immI8_rule,
  /*  785 */  rcx_RegI_rule,
  /*  786 */  _URShiftL__LoadL_memory__rcx_RegI_rule,
  /*  787 */  immI_24_rule,
  /*  788 */  immI_16_rule,
  /*  789 */  0,
  /*  790 */  0,
  /*  791 */  0,
  /*  792 */  _URShiftI_rRegI_immI_M1_rule,
  /*  793 */  _LShiftI_rRegI_immI1_rule,
  /*  794 */  _URShiftI_rRegI_immI8_rule,
  /*  795 */  _LShiftI_rRegI_immI8_rule,
  /*  796 */  _URShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI_rule,
  /*  797 */  _LShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  798 */  _URShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI_rule,
  /*  799 */  _LShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  800 */  0,
  /*  801 */  0,
  /*  802 */  0,
  /*  803 */  _LShiftI_rRegI_immI_M1_rule,
  /*  804 */  _URShiftI_rRegI_immI1_rule,
  /*  805 */  _LShiftI_rRegI_immI8_rule,
  /*  806 */  _URShiftI_rRegI_immI8_rule,
  /*  807 */  _LShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI_rule,
  /*  808 */  _URShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  809 */  _LShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI_rule,
  /*  810 */  _URShiftI_no_rcx_RegI_rcx_RegI_rule,
  /*  811 */  0,
  /*  812 */  0,
  /*  813 */  0,
  /*  814 */  _URShiftL_rRegL_immI_M1_rule,
  /*  815 */  _LShiftL_rRegL_immI1_rule,
  /*  816 */  _URShiftL_rRegL_immI8_rule,
  /*  817 */  _LShiftL_rRegL_immI8_rule,
  /*  818 */  _URShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI_rule,
  /*  819 */  _LShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  820 */  _URShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI_rule,
  /*  821 */  _LShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  822 */  0,
  /*  823 */  0,
  /*  824 */  0,
  /*  825 */  _LShiftL_rRegL_immI_M1_rule,
  /*  826 */  _URShiftL_rRegL_immI1_rule,
  /*  827 */  _LShiftL_rRegL_immI8_rule,
  /*  828 */  _URShiftL_rRegL_immI8_rule,
  /*  829 */  _LShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI_rule,
  /*  830 */  _URShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  831 */  _LShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI_rule,
  /*  832 */  _URShiftL_no_rcx_RegL_rcx_RegI_rule,
  /*  833 */  rRegI_rule,
  /*  834 */  immI_255_rule,
  /*  835 */  0,
  /*  836 */  immI_65535_rule,
  /*  837 */  0,
  /*  838 */  immI_rule,
  /*  839 */  _LoadI_memory__rule,
  /*  840 */  rRegI_rule,
  /*  841 */  _AndI__LoadI_memory__rRegI_rule,
  /*  842 */  _AndI_rRegI__LoadI_memory__rule,
  /*  843 */  _AndI__LoadI_memory__immI_rule,
  /*  844 */  _LoadI_memory__rule,
  /*  845 */  _XorI_rRegI_immI_M1_rule,
  /*  846 */  rRegI_rule,
  /*  847 */  _XorI_rRegI_immI_M1_rule,
  /*  848 */  rRegI_rule,
  /*  849 */  _SubI_immI0_rRegI_rule,
  /*  850 */  _LoadI_memory__rule,
  /*  851 */  _SubI_immI0__LoadI_memory__rule,
  /*  852 */  _LoadI_memory__rule,
  /*  853 */  _AddI__LoadI_memory__immI_M1_rule,
  /*  854 */  rRegI_rule,
  /*  855 */  _AddI_rRegI_immI_M1_rule,
  /*  856 */  rRegI_rule,
  /*  857 */  _AddI_rRegI_immI_M1_rule,
  /*  858 */  _LoadI_memory__rule,
  /*  859 */  _AddI__LoadI_memory__immI_M1_rule,
  /*  860 */  rRegI_rule,
  /*  861 */  immI_rule,
  /*  862 */  _LoadI_memory__rule,
  /*  863 */  rRegI_rule,
  /*  864 */  _OrI__LoadI_memory__rRegI_rule,
  /*  865 */  _OrI_rRegI__LoadI_memory__rule,
  /*  866 */  _OrI__LoadI_memory__immI_rule,
  /*  867 */  rRegI_rule,
  /*  868 */  immI_M1_rule,
  /*  869 */  immI_rule,
  /*  870 */  _LoadI_memory__rule,
  /*  871 */  rRegI_rule,
  /*  872 */  _XorI__LoadI_memory__rRegI_rule,
  /*  873 */  _XorI_rRegI__LoadI_memory__rule,
  /*  874 */  _XorI__LoadI_memory__immI_rule,
  /*  875 */  rRegL_rule,
  /*  876 */  immL_255_rule,
  /*  877 */  immL_65535_rule,
  /*  878 */  immL32_rule,
  /*  879 */  _LoadL_memory__rule,
  /*  880 */  rRegL_rule,
  /*  881 */  _AndL__LoadL_memory__rRegL_rule,
  /*  882 */  _AndL_rRegL__LoadL_memory__rule,
  /*  883 */  _AndL__LoadL_memory__immL32_rule,
  /*  884 */  _LoadL_memory__rule,
  /*  885 */  _XorL_rRegL_immL_M1_rule,
  /*  886 */  rRegL_rule,
  /*  887 */  _XorL_rRegL_immL_M1_rule,
  /*  888 */  rRegL_rule,
  /*  889 */  _SubL_immL0_rRegL_rule,
  /*  890 */  _LoadL_memory__rule,
  /*  891 */  _SubL_immL0__LoadL_memory__rule,
  /*  892 */  _LoadL_memory__rule,
  /*  893 */  _AddL__LoadL_memory__immL_M1_rule,
  /*  894 */  rRegL_rule,
  /*  895 */  _AddL_rRegL_immL_M1_rule,
  /*  896 */  rRegL_rule,
  /*  897 */  _AddL_rRegL_immL_M1_rule,
  /*  898 */  _LoadL_memory__rule,
  /*  899 */  _AddL__LoadL_memory__immL_M1_rule,
  /*  900 */  rRegL_rule,
  /*  901 */  _CastP2X_any_RegP__rule,
  /*  902 */  rRegL_rule,
  /*  903 */  immL32_rule,
  /*  904 */  _LoadL_memory__rule,
  /*  905 */  rRegL_rule,
  /*  906 */  _OrL__LoadL_memory__rRegL_rule,
  /*  907 */  _OrL_rRegL__LoadL_memory__rule,
  /*  908 */  _OrL__LoadL_memory__immL32_rule,
  /*  909 */  rRegL_rule,
  /*  910 */  immL_M1_rule,
  /*  911 */  immL32_rule,
  /*  912 */  _LoadL_memory__rule,
  /*  913 */  rRegL_rule,
  /*  914 */  _XorL__LoadL_memory__rRegL_rule,
  /*  915 */  _XorL_rRegL__LoadL_memory__rule,
  /*  916 */  _XorL__LoadL_memory__immL32_rule,
  /*  917 */  0,
  /*  918 */  0,
  /*  919 */  rRegI_rule,
  /*  920 */  immI0_rule,
  /*  921 */  _SubI_rRegI_rRegI_rule,
  /*  922 */  _AndI__CmpLTMask_rRegI_rRegI_rRegI_rule,
  /*  923 */  _SubI_rRegI_rRegI_rule,
  /*  924 */  _AndI_rRegI__CmpLTMask_rRegI_rRegI_rule,
  /*  925 */  rRegI_rule,
  /*  926 */  _CmpLTMask_rRegI_rRegI_rule,
  /*  927 */  regF_rule,
  /*  928 */  _LoadF_memory__rule,
  /*  929 */  immF_rule,
  /*  930 */  regD_rule,
  /*  931 */  _LoadD_memory__rule,
  /*  932 */  immD_rule,
  /*  933 */  0,
  /*  934 */  0,
  /*  935 */  0,
  /*  936 */  0,
  /*  937 */  0,
  /*  938 */  0,
  /*  939 */  0,
  /*  940 */  0,
  /*  941 */  0,
  /*  942 */  0,
  /*  943 */  0,
  /*  944 */  0,
  /*  945 */  0,
  /*  946 */  0,
  /*  947 */  0,
  /*  948 */  0,
  /*  949 */  0,
  /*  950 */  0,
  /*  951 */  0,
  /*  952 */  immL_32bits_rule,
  /*  953 */  immL_32bits_rule,
  /*  954 */  immL_32bits_rule,
  /*  955 */  0,
  /*  956 */  0,
  /*  957 */  0,
  /*  958 */  0,
  /*  959 */  0,
  /*  960 */  rdi_RegP_rule,
  /*  961 */  rdi_RegP_rule,
  /*  962 */  _Binary_rsi_RegP_rdx_RegI_rule,
  /*  963 */  _Binary_rsi_RegP_rdx_RegI_rule,
  /*  964 */  _Binary_rsi_RegP_rdx_RegI_rule,
  /*  965 */  _Binary_rdi_RegP_rcx_RegI_rule,
  /*  966 */  _Binary_rsi_RegP_immI_rule,
  /*  967 */  _Binary_rsi_RegP_immI_rule,
  /*  968 */  _Binary_rsi_RegP_immI_rule,
  /*  969 */  _Binary_rsi_RegP_rax_RegI_rule,
  /*  970 */  _Binary_rsi_RegP_rax_RegI_rule,
  /*  971 */  _Binary_rsi_RegP_rax_RegI_rule,
  /*  972 */  rax_RegI_rule,
  /*  973 */  rcx_RegI_rule,
  /*  974 */  rsi_RegP_rule,
  /*  975 */  rsi_RegP_rule,
  /*  976 */  rcx_RegI_rule,
  /*  977 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  978 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  979 */  _Binary_rdi_RegP_rdx_RegI_rule,
  /*  980 */  rRegL_rule,
  /*  981 */  0,
  /*  982 */  rRegI_rule,
  /*  983 */  0,
  /*  984 */  rRegI_rule,
  /*  985 */  0,
  /*  986 */  rFlagsReg_rule,
  /*  987 */  rFlagsReg_rule,
  /*  988 */  rFlagsRegU_rule,
  /*  989 */  rFlagsRegUCF_rule,
  /*  990 */  rFlagsReg_rule,
  /*  991 */  rFlagsRegU_rule,
  /*  992 */  rFlagsRegUCF_rule,
  /*  993 */  rFlagsRegU_rule,
  /*  994 */  rFlagsRegUCF_rule,
  /*  995 */  rFlagsRegUCF_rule,
  /*  996 */  rax_RegP_rule,
  /*  997 */  0,
  /*  998 */  rFlagsReg_rule,
  /*  999 */  rFlagsReg_rule,
  /* 1000 */  rFlagsRegU_rule,
  /* 1001 */  rFlagsRegUCF_rule,
  /* 1002 */  rFlagsRegU_rule,
  /* 1003 */  rFlagsRegUCF_rule,
  /* 1004 */  rFlagsRegUCF_rule,
  /* 1005 */  0,
  /* 1006 */  0,
  /* 1007 */  0,
  /* 1008 */  0,
  /* 1009 */  0,
  /* 1010 */  0,
  /* 1011 */  0,
  /* 1012 */  0,
  /* 1013 */  rbx_RegP_rule,
  /* 1014 */  rax_RegP_rule,
  /* 1015 */  0,
  /* 1016 */  0,
  /* 1017 */  0,
  /* 1018 */  0,
  /* 1019 */  0,
  /* 1020 */  0,
  /* 1021 */  0,
  /* 1022 */  0,
  /* 1023 */  0,
  /* 1024 */  0,
  /* 1025 */  regF_rule,
  /* 1026 */  _LoadF_memory__rule,
  /* 1027 */  regF_rule,
  /* 1028 */  immF_rule,
  /* 1029 */  regF_rule,
  /* 1030 */  _LoadF_memory__rule,
  /* 1031 */  regF_rule,
  /* 1032 */  immF_rule,
  /* 1033 */  regD_rule,
  /* 1034 */  _LoadD_memory__rule,
  /* 1035 */  regD_rule,
  /* 1036 */  immD_rule,
  /* 1037 */  regD_rule,
  /* 1038 */  _LoadD_memory__rule,
  /* 1039 */  regD_rule,
  /* 1040 */  immD_rule,
  /* 1041 */  regF_rule,
  /* 1042 */  _LoadF_memory__rule,
  /* 1043 */  immF_rule,
  /* 1044 */  regF_rule,
  /* 1045 */  _LoadF_memory__rule,
  /* 1046 */  immF_rule,
  /* 1047 */  regD_rule,
  /* 1048 */  _LoadD_memory__rule,
  /* 1049 */  immD_rule,
  /* 1050 */  regD_rule,
  /* 1051 */  _LoadD_memory__rule,
  /* 1052 */  immD_rule,
  /* 1053 */  regF_rule,
  /* 1054 */  _LoadF_memory__rule,
  /* 1055 */  regF_rule,
  /* 1056 */  immF_rule,
  /* 1057 */  regF_rule,
  /* 1058 */  _LoadF_memory__rule,
  /* 1059 */  regF_rule,
  /* 1060 */  immF_rule,
  /* 1061 */  regD_rule,
  /* 1062 */  _LoadD_memory__rule,
  /* 1063 */  regD_rule,
  /* 1064 */  immD_rule,
  /* 1065 */  regD_rule,
  /* 1066 */  _LoadD_memory__rule,
  /* 1067 */  regD_rule,
  /* 1068 */  immD_rule,
  /* 1069 */  regF_rule,
  /* 1070 */  _LoadF_memory__rule,
  /* 1071 */  immF_rule,
  /* 1072 */  regF_rule,
  /* 1073 */  _LoadF_memory__rule,
  /* 1074 */  immF_rule,
  /* 1075 */  regD_rule,
  /* 1076 */  _LoadD_memory__rule,
  /* 1077 */  immD_rule,
  /* 1078 */  regD_rule,
  /* 1079 */  _LoadD_memory__rule,
  /* 1080 */  immD_rule,
  /* 1081 */  0,
  /* 1082 */  0,
  /* 1083 */  0,
  /* 1084 */  0,
  /* 1085 */  0,
  /* 1086 */  0,
  /* 1087 */  immU8_rule,
  /* 1088 */  immU8_rule,
  /* 1089 */  immU8_rule,
  /* 1090 */  immU8_rule,
  /* 1091 */  immU8_rule,
  /* 1092 */  legVecY_rule,
  /* 1093 */  immU8_rule,
  /* 1094 */  immU8_rule,
  /* 1095 */  immU8_rule,
  /* 1096 */  0,
  /* 1097 */  _Binary_regD_regD_rule,
  /* 1098 */  _Binary_regF_regF_rule,
  /* 1099 */  0,
  /* 1100 */  0,
  /* 1101 */  0,
  /* 1102 */  0,
  /* 1103 */  0,
  /* 1104 */  0,
  /* 1105 */  vecS_rule,
  /* 1106 */  vecD_rule,
  /* 1107 */  vecX_rule,
  /* 1108 */  vecY_rule,
  /* 1109 */  vecZ_rule,
  /* 1110 */  vecZ_rule,
  /* 1111 */  0,
  /* 1112 */  0,
  /* 1113 */  0,
  /* 1114 */  0,
  /* 1115 */  0,
  /* 1116 */  0,
  /* 1117 */  0,
  /* 1118 */  0,
  /* 1119 */  0,
  /* 1120 */  0,
  /* 1121 */  0,
  /* 1122 */  0,
  /* 1123 */  0,
  /* 1124 */  0,
  /* 1125 */  0,
  /* 1126 */  0,
  /* 1127 */  0,
  /* 1128 */  0,
  /* 1129 */  0,
  /* 1130 */  0,
  /* 1131 */  0,
  /* 1132 */  0,
  /* 1133 */  0,
  /* 1134 */  0,
  /* 1135 */  0,
  /* 1136 */  0,
  /* 1137 */  0,
  /* 1138 */  0,
  /* 1139 */  0,
  /* 1140 */  0,
  /* 1141 */  0,
  /* 1142 */  0,
  /* 1143 */  0,
  /* 1144 */  0,
  /* 1145 */  0,
  /* 1146 */  0,
  /* 1147 */  0,
  /* 1148 */  0,
  /* 1149 */  0,
  /* 1150 */  0,
  /* 1151 */  0,
  /* 1152 */  0,
  /* 1153 */  0,
  /* 1154 */  0,
  /* 1155 */  0,
  /* 1156 */  0,
  /* 1157 */  0,
  /* 1158 */  0,
  /* 1159 */  0,
  /* 1160 */  0,
  /* 1161 */  0,
  /* 1162 */  0,
  /* 1163 */  0,
  /* 1164 */  0,
  /* 1165 */  0,
  /* 1166 */  0,
  /* 1167 */  0,
  /* 1168 */  0,
  /* 1169 */  0,
  /* 1170 */  0,
  /* 1171 */  0,
  /* 1172 */  0,
  /* 1173 */  0,
  /* 1174 */  0,
  /* 1175 */  0,
  /* 1176 */  0,
  /* 1177 */  0,
  /* 1178 */  0,
  /* 1179 */  0,
  /* 1180 */  0,
  /* 1181 */  0,
  /* 1182 */  0,
  /* 1183 */  0,
  /* 1184 */  0,
  /* 1185 */  0,
  /* 1186 */  0,
  /* 1187 */  0,
  /* 1188 */  0,
  /* 1189 */  0,
  /* 1190 */  0,
  /* 1191 */  0,
  /* 1192 */  0,
  /* 1193 */  0,
  /* 1194 */  0,
  /* 1195 */  0,
  /* 1196 */  0,
  /* 1197 */  0,
  /* 1198 */  0,
  /* 1199 */  0,
  /* 1200 */  0,
  /* 1201 */  0,
  /* 1202 */  0,
  /* 1203 */  0,
  /* 1204 */  0,
  /* 1205 */  0,
  /* 1206 */  0,
  /* 1207 */  0,
  /* 1208 */  0,
  /* 1209 */  0,
  /* 1210 */  0,
  /* 1211 */  0,
  /* 1212 */  0,
  /* 1213 */  0,
  /* 1214 */  0,
  /* 1215 */  0,
  /* 1216 */  0,
  /* 1217 */  0,
  /* 1218 */  0,
  /* 1219 */  0,
  /* 1220 */  0,
  /* 1221 */  0,
  /* 1222 */  0,
  /* 1223 */  0,
  /* 1224 */  0,
  /* 1225 */  0,
  /* 1226 */  0,
  /* 1227 */  0,
  /* 1228 */  0,
  /* 1229 */  0,
  /* 1230 */  0,
  /* 1231 */  0,
  /* 1232 */  0,
  /* 1233 */  0,
  /* 1234 */  0,
  /* 1235 */  0,
  /* 1236 */  0,
  /* 1237 */  0,
  /* 1238 */  0,
  /* 1239 */  0,
  /* 1240 */  vecD_rule,
  /* 1241 */  vecD_rule,
  /* 1242 */  vecD_rule,
  /* 1243 */  vecX_rule,
  /* 1244 */  vecX_rule,
  /* 1245 */  vecX_rule,
  /* 1246 */  vecY_rule,
  /* 1247 */  vecY_rule,
  /* 1248 */  legVecZ_rule,
  /* 1249 */  vecX_rule,
  /* 1250 */  vecY_rule,
  /* 1251 */  legVecZ_rule,
  /* 1252 */  vecD_rule,
  /* 1253 */  vecD_rule,
  /* 1254 */  vecX_rule,
  /* 1255 */  vecX_rule,
  /* 1256 */  vecY_rule,
  /* 1257 */  legVecZ_rule,
  /* 1258 */  vecX_rule,
  /* 1259 */  vecX_rule,
  /* 1260 */  vecY_rule,
  /* 1261 */  legVecZ_rule,
  /* 1262 */  vecD_rule,
  /* 1263 */  vecD_rule,
  /* 1264 */  vecX_rule,
  /* 1265 */  vecX_rule,
  /* 1266 */  vecY_rule,
  /* 1267 */  legVecZ_rule,
  /* 1268 */  vecX_rule,
  /* 1269 */  vecY_rule,
  /* 1270 */  legVecZ_rule,
  /* 1271 */  vecD_rule,
  /* 1272 */  vecD_rule,
  /* 1273 */  vecX_rule,
  /* 1274 */  vecX_rule,
  /* 1275 */  vecY_rule,
  /* 1276 */  legVecZ_rule,
  /* 1277 */  vecX_rule,
  /* 1278 */  vecX_rule,
  /* 1279 */  vecY_rule,
  /* 1280 */  legVecZ_rule,
  /* 1281 */  vecS_rule,
  /* 1282 */  vecS_rule,
  /* 1283 */  _LoadVector_memory__rule,
  /* 1284 */  vecS_rule,
  /* 1285 */  vecD_rule,
  /* 1286 */  vecD_rule,
  /* 1287 */  _LoadVector_memory__rule,
  /* 1288 */  vecD_rule,
  /* 1289 */  vecX_rule,
  /* 1290 */  vecX_rule,
  /* 1291 */  _LoadVector_memory__rule,
  /* 1292 */  vecX_rule,
  /* 1293 */  vecY_rule,
  /* 1294 */  _LoadVector_memory__rule,
  /* 1295 */  vecY_rule,
  /* 1296 */  vecZ_rule,
  /* 1297 */  _LoadVector_memory__rule,
  /* 1298 */  vecZ_rule,
  /* 1299 */  vecS_rule,
  /* 1300 */  vecS_rule,
  /* 1301 */  _LoadVector_memory__rule,
  /* 1302 */  vecS_rule,
  /* 1303 */  vecD_rule,
  /* 1304 */  vecD_rule,
  /* 1305 */  _LoadVector_memory__rule,
  /* 1306 */  vecD_rule,
  /* 1307 */  vecX_rule,
  /* 1308 */  vecX_rule,
  /* 1309 */  _LoadVector_memory__rule,
  /* 1310 */  vecX_rule,
  /* 1311 */  vecY_rule,
  /* 1312 */  _LoadVector_memory__rule,
  /* 1313 */  vecY_rule,
  /* 1314 */  vecZ_rule,
  /* 1315 */  _LoadVector_memory__rule,
  /* 1316 */  vecZ_rule,
  /* 1317 */  vecD_rule,
  /* 1318 */  vecD_rule,
  /* 1319 */  _LoadVector_memory__rule,
  /* 1320 */  vecD_rule,
  /* 1321 */  vecX_rule,
  /* 1322 */  vecX_rule,
  /* 1323 */  _LoadVector_memory__rule,
  /* 1324 */  vecX_rule,
  /* 1325 */  vecY_rule,
  /* 1326 */  _LoadVector_memory__rule,
  /* 1327 */  vecY_rule,
  /* 1328 */  vecZ_rule,
  /* 1329 */  _LoadVector_memory__rule,
  /* 1330 */  vecZ_rule,
  /* 1331 */  vecX_rule,
  /* 1332 */  vecX_rule,
  /* 1333 */  _LoadVector_memory__rule,
  /* 1334 */  vecX_rule,
  /* 1335 */  vecY_rule,
  /* 1336 */  _LoadVector_memory__rule,
  /* 1337 */  vecY_rule,
  /* 1338 */  vecZ_rule,
  /* 1339 */  _LoadVector_memory__rule,
  /* 1340 */  vecZ_rule,
  /* 1341 */  vecD_rule,
  /* 1342 */  vecD_rule,
  /* 1343 */  _LoadVector_memory__rule,
  /* 1344 */  vecD_rule,
  /* 1345 */  vecX_rule,
  /* 1346 */  vecX_rule,
  /* 1347 */  _LoadVector_memory__rule,
  /* 1348 */  vecX_rule,
  /* 1349 */  vecY_rule,
  /* 1350 */  _LoadVector_memory__rule,
  /* 1351 */  vecY_rule,
  /* 1352 */  vecZ_rule,
  /* 1353 */  _LoadVector_memory__rule,
  /* 1354 */  vecZ_rule,
  /* 1355 */  vecX_rule,
  /* 1356 */  vecX_rule,
  /* 1357 */  _LoadVector_memory__rule,
  /* 1358 */  vecX_rule,
  /* 1359 */  vecY_rule,
  /* 1360 */  _LoadVector_memory__rule,
  /* 1361 */  vecY_rule,
  /* 1362 */  vecZ_rule,
  /* 1363 */  _LoadVector_memory__rule,
  /* 1364 */  vecZ_rule,
  /* 1365 */  vecS_rule,
  /* 1366 */  vecS_rule,
  /* 1367 */  _LoadVector_memory__rule,
  /* 1368 */  vecD_rule,
  /* 1369 */  vecD_rule,
  /* 1370 */  _LoadVector_memory__rule,
  /* 1371 */  vecX_rule,
  /* 1372 */  vecX_rule,
  /* 1373 */  _LoadVector_memory__rule,
  /* 1374 */  vecY_rule,
  /* 1375 */  _LoadVector_memory__rule,
  /* 1376 */  vecZ_rule,
  /* 1377 */  _LoadVector_memory__rule,
  /* 1378 */  vecS_rule,
  /* 1379 */  vecS_rule,
  /* 1380 */  _LoadVector_memory__rule,
  /* 1381 */  vecD_rule,
  /* 1382 */  vecD_rule,
  /* 1383 */  _LoadVector_memory__rule,
  /* 1384 */  vecX_rule,
  /* 1385 */  vecX_rule,
  /* 1386 */  _LoadVector_memory__rule,
  /* 1387 */  vecY_rule,
  /* 1388 */  _LoadVector_memory__rule,
  /* 1389 */  vecZ_rule,
  /* 1390 */  _LoadVector_memory__rule,
  /* 1391 */  vecD_rule,
  /* 1392 */  vecD_rule,
  /* 1393 */  _LoadVector_memory__rule,
  /* 1394 */  vecX_rule,
  /* 1395 */  vecX_rule,
  /* 1396 */  _LoadVector_memory__rule,
  /* 1397 */  vecY_rule,
  /* 1398 */  _LoadVector_memory__rule,
  /* 1399 */  vecZ_rule,
  /* 1400 */  _LoadVector_memory__rule,
  /* 1401 */  vecX_rule,
  /* 1402 */  vecX_rule,
  /* 1403 */  _LoadVector_memory__rule,
  /* 1404 */  vecY_rule,
  /* 1405 */  _LoadVector_memory__rule,
  /* 1406 */  vecZ_rule,
  /* 1407 */  _LoadVector_memory__rule,
  /* 1408 */  vecD_rule,
  /* 1409 */  vecD_rule,
  /* 1410 */  _LoadVector_memory__rule,
  /* 1411 */  vecX_rule,
  /* 1412 */  vecX_rule,
  /* 1413 */  _LoadVector_memory__rule,
  /* 1414 */  vecY_rule,
  /* 1415 */  _LoadVector_memory__rule,
  /* 1416 */  vecZ_rule,
  /* 1417 */  _LoadVector_memory__rule,
  /* 1418 */  vecX_rule,
  /* 1419 */  vecX_rule,
  /* 1420 */  _LoadVector_memory__rule,
  /* 1421 */  vecY_rule,
  /* 1422 */  _LoadVector_memory__rule,
  /* 1423 */  vecZ_rule,
  /* 1424 */  _LoadVector_memory__rule,
  /* 1425 */  vecS_rule,
  /* 1426 */  vecD_rule,
  /* 1427 */  vecX_rule,
  /* 1428 */  vecX_rule,
  /* 1429 */  vecY_rule,
  /* 1430 */  vecZ_rule,
  /* 1431 */  vecS_rule,
  /* 1432 */  vecS_rule,
  /* 1433 */  _LoadVector_memory__rule,
  /* 1434 */  vecS_rule,
  /* 1435 */  vecD_rule,
  /* 1436 */  vecD_rule,
  /* 1437 */  _LoadVector_memory__rule,
  /* 1438 */  vecD_rule,
  /* 1439 */  vecX_rule,
  /* 1440 */  vecX_rule,
  /* 1441 */  _LoadVector_memory__rule,
  /* 1442 */  vecX_rule,
  /* 1443 */  vecY_rule,
  /* 1444 */  _LoadVector_memory__rule,
  /* 1445 */  vecY_rule,
  /* 1446 */  vecZ_rule,
  /* 1447 */  _LoadVector_memory__rule,
  /* 1448 */  vecZ_rule,
  /* 1449 */  vecD_rule,
  /* 1450 */  vecD_rule,
  /* 1451 */  _LoadVector_memory__rule,
  /* 1452 */  vecD_rule,
  /* 1453 */  vecX_rule,
  /* 1454 */  vecX_rule,
  /* 1455 */  _LoadVector_memory__rule,
  /* 1456 */  vecX_rule,
  /* 1457 */  vecX_rule,
  /* 1458 */  _LoadVector_memory__rule,
  /* 1459 */  vecX_rule,
  /* 1460 */  vecY_rule,
  /* 1461 */  _LoadVector_memory__rule,
  /* 1462 */  vecY_rule,
  /* 1463 */  vecZ_rule,
  /* 1464 */  _LoadVector_memory__rule,
  /* 1465 */  vecZ_rule,
  /* 1466 */  vecY_rule,
  /* 1467 */  _LoadVector_memory__rule,
  /* 1468 */  vecY_rule,
  /* 1469 */  vecZ_rule,
  /* 1470 */  _LoadVector_memory__rule,
  /* 1471 */  vecZ_rule,
  /* 1472 */  vecD_rule,
  /* 1473 */  vecD_rule,
  /* 1474 */  _LoadVector_memory__rule,
  /* 1475 */  vecD_rule,
  /* 1476 */  vecX_rule,
  /* 1477 */  vecX_rule,
  /* 1478 */  _LoadVector_memory__rule,
  /* 1479 */  vecX_rule,
  /* 1480 */  vecY_rule,
  /* 1481 */  _LoadVector_memory__rule,
  /* 1482 */  vecY_rule,
  /* 1483 */  vecZ_rule,
  /* 1484 */  _LoadVector_memory__rule,
  /* 1485 */  vecZ_rule,
  /* 1486 */  vecX_rule,
  /* 1487 */  vecX_rule,
  /* 1488 */  _LoadVector_memory__rule,
  /* 1489 */  vecX_rule,
  /* 1490 */  vecY_rule,
  /* 1491 */  _LoadVector_memory__rule,
  /* 1492 */  vecY_rule,
  /* 1493 */  vecZ_rule,
  /* 1494 */  _LoadVector_memory__rule,
  /* 1495 */  vecZ_rule,
  /* 1496 */  _Binary_legVecY_legVecY_rule,
  /* 1497 */  _Binary_legVecY_legVecY_rule,
  /* 1498 */  vecD_rule,
  /* 1499 */  vecD_rule,
  /* 1500 */  _LoadVector_memory__rule,
  /* 1501 */  vecX_rule,
  /* 1502 */  vecX_rule,
  /* 1503 */  _LoadVector_memory__rule,
  /* 1504 */  vecY_rule,
  /* 1505 */  _LoadVector_memory__rule,
  /* 1506 */  vecZ_rule,
  /* 1507 */  _LoadVector_memory__rule,
  /* 1508 */  vecX_rule,
  /* 1509 */  vecX_rule,
  /* 1510 */  _LoadVector_memory__rule,
  /* 1511 */  vecY_rule,
  /* 1512 */  _LoadVector_memory__rule,
  /* 1513 */  vecZ_rule,
  /* 1514 */  _LoadVector_memory__rule,
  /* 1515 */  vecS_rule,
  /* 1516 */  vecS_rule,
  /* 1517 */  vecS_rule,
  /* 1518 */  vecS_rule,
  /* 1519 */  vecS_rule,
  /* 1520 */  vecS_rule,
  /* 1521 */  vecS_rule,
  /* 1522 */  vecS_rule,
  /* 1523 */  vecS_rule,
  /* 1524 */  vecS_rule,
  /* 1525 */  vecS_rule,
  /* 1526 */  vecS_rule,
  /* 1527 */  vecS_rule,
  /* 1528 */  vecS_rule,
  /* 1529 */  vecS_rule,
  /* 1530 */  vecS_rule,
  /* 1531 */  vecS_rule,
  /* 1532 */  vecS_rule,
  /* 1533 */  vecS_rule,
  /* 1534 */  vecS_rule,
  /* 1535 */  vecS_rule,
  /* 1536 */  vecS_rule,
  /* 1537 */  vecS_rule,
  /* 1538 */  vecS_rule,
  /* 1539 */  vecS_rule,
  /* 1540 */  vecS_rule,
  /* 1541 */  vecS_rule,
  /* 1542 */  vecS_rule,
  /* 1543 */  vecS_rule,
  /* 1544 */  vecS_rule,
  /* 1545 */  vecS_rule,
  /* 1546 */  vecS_rule,
  /* 1547 */  vecS_rule,
  /* 1548 */  vecS_rule,
  /* 1549 */  vecS_rule,
  /* 1550 */  vecS_rule,
  /* 1551 */  vecS_rule,
  /* 1552 */  vecS_rule,
  /* 1553 */  vecS_rule,
  /* 1554 */  vecS_rule,
  /* 1555 */  vecS_rule,
  /* 1556 */  vecS_rule,
  /* 1557 */  vecS_rule,
  /* 1558 */  vecS_rule,
  /* 1559 */  vecS_rule,
  /* 1560 */  vecS_rule,
  /* 1561 */  vecS_rule,
  /* 1562 */  vecS_rule,
  /* 1563 */  vecS_rule,
  /* 1564 */  vecS_rule,
  /* 1565 */  vecS_rule,
  /* 1566 */  vecS_rule,
  /* 1567 */  vecS_rule,
  /* 1568 */  vecS_rule,
  /* 1569 */  vecS_rule,
  /* 1570 */  vecS_rule,
  /* 1571 */  vecS_rule,
  /* 1572 */  vecS_rule,
  /* 1573 */  _LoadVector_memory__rule,
  /* 1574 */  vecS_rule,
  /* 1575 */  vecD_rule,
  /* 1576 */  vecD_rule,
  /* 1577 */  _LoadVector_memory__rule,
  /* 1578 */  vecD_rule,
  /* 1579 */  vecX_rule,
  /* 1580 */  vecX_rule,
  /* 1581 */  _LoadVector_memory__rule,
  /* 1582 */  vecX_rule,
  /* 1583 */  vecY_rule,
  /* 1584 */  _LoadVector_memory__rule,
  /* 1585 */  vecY_rule,
  /* 1586 */  vecZ_rule,
  /* 1587 */  _LoadVector_memory__rule,
  /* 1588 */  vecZ_rule,
  /* 1589 */  vecS_rule,
  /* 1590 */  vecS_rule,
  /* 1591 */  _LoadVector_memory__rule,
  /* 1592 */  vecS_rule,
  /* 1593 */  vecD_rule,
  /* 1594 */  vecD_rule,
  /* 1595 */  _LoadVector_memory__rule,
  /* 1596 */  vecD_rule,
  /* 1597 */  vecX_rule,
  /* 1598 */  vecX_rule,
  /* 1599 */  _LoadVector_memory__rule,
  /* 1600 */  vecX_rule,
  /* 1601 */  vecY_rule,
  /* 1602 */  _LoadVector_memory__rule,
  /* 1603 */  vecY_rule,
  /* 1604 */  vecZ_rule,
  /* 1605 */  _LoadVector_memory__rule,
  /* 1606 */  vecZ_rule,
  /* 1607 */  vecS_rule,
  /* 1608 */  vecS_rule,
  /* 1609 */  _LoadVector_memory__rule,
  /* 1610 */  vecS_rule,
  /* 1611 */  vecD_rule,
  /* 1612 */  vecD_rule,
  /* 1613 */  _LoadVector_memory__rule,
  /* 1614 */  vecD_rule,
  /* 1615 */  vecX_rule,
  /* 1616 */  vecX_rule,
  /* 1617 */  _LoadVector_memory__rule,
  /* 1618 */  vecX_rule,
  /* 1619 */  vecY_rule,
  /* 1620 */  _LoadVector_memory__rule,
  /* 1621 */  vecY_rule,
  /* 1622 */  vecZ_rule,
  /* 1623 */  _LoadVector_memory__rule,
  /* 1624 */  vecZ_rule,
  /* 1625 */  0,
  /* 1626 */  0,
  /* 1627 */  0,
  /* 1628 */  0,
  /* 1629 */  0,
  /* 1630 */  0,
  /* 1631 */  0,
  /* 1632 */  0,
  /* 1633 */  0,
  /* 1634 */  0,
  /* 1635 */  0,
  /* 1636 */  0,
  /* 1637 */  0,
  /* 1638 */  0,
  /* 1639 */  _Binary_vecX_vecX_rule,
  /* 1640 */  _Binary_vecX__LoadVector_memory__rule,
  /* 1641 */  _Binary_vecY_vecY_rule,
  /* 1642 */  _Binary_vecY__LoadVector_memory__rule,
  /* 1643 */  _Binary_vecZ_vecZ_rule,
  /* 1644 */  _Binary_vecZ__LoadVector_memory__rule,
  /* 1645 */  _Binary_vecX_vecX_rule,
  /* 1646 */  _Binary_vecX__LoadVector_memory__rule,
  /* 1647 */  _Binary_vecY_vecY_rule,
  /* 1648 */  _Binary_vecY__LoadVector_memory__rule,
  /* 1649 */  _Binary_vecZ_vecZ_rule,
  /* 1650 */  _Binary_vecZ__LoadVector_memory__rule,
  /* 1651 */  _Binary_rax_RegP_rRegP_rule,
  /* 1652 */  _Binary_rax_RegP_rRegP_rule,
  /* 1653 */  _Binary_rax_RegN_rRegN_rule,
  /* 1654 */  _Binary_rax_RegN_rRegN_rule,
  /* 1655 */  _Binary_rax_RegN_rRegN_rule,
  /* 1656 */  _Binary_rax_RegP_rRegP_rule,
  // last instruction
  0 // no trailing comma
};

const char        *ruleName[] = {
  /*    0 */  "UNIVERSE",
  /*    1 */  "LABEL",
  /*    2 */  "SREGI",
  /*    3 */  "SREGP",
  /*    4 */  "SREGF",
  /*    5 */  "SREGD",
  /*    6 */  "SREGL",
  /*    7 */  "METHOD",
  /*    8 */  "IMMI",
  /*    9 */  "IMMI0",
  /*   10 */  "IMMI1",
  /*   11 */  "IMMI_M1",
  /*   12 */  "IMMI2",
  /*   13 */  "IMMI8",
  /*   14 */  "IMMU8",
  /*   15 */  "IMMI16",
  /*   16 */  "IMMU31",
  /*   17 */  "IMMI_32",
  /*   18 */  "IMMI_64",
  /*   19 */  "IMMP",
  /*   20 */  "IMMP0",
  /*   21 */  "IMMN",
  /*   22 */  "IMMNKLASS",
  /*   23 */  "IMMN0",
  /*   24 */  "IMMP31",
  /*   25 */  "IMML",
  /*   26 */  "IMML8",
  /*   27 */  "IMMUL32",
  /*   28 */  "IMML32",
  /*   29 */  "IMML0",
  /*   30 */  "IMML1",
  /*   31 */  "IMML_M1",
  /*   32 */  "IMML10",
  /*   33 */  "IMML_127",
  /*   34 */  "IMML_32BITS",
  /*   35 */  "IMMF0",
  /*   36 */  "IMMF",
  /*   37 */  "IMMD0",
  /*   38 */  "IMMD",
  /*   39 */  "IMMI_16",
  /*   40 */  "IMMI_24",
  /*   41 */  "IMMI_255",
  /*   42 */  "IMMI_65535",
  /*   43 */  "IMML_255",
  /*   44 */  "IMML_65535",
  /*   45 */  "RREGI",
  /*   46 */  "RAX_REGI",
  /*   47 */  "RBX_REGI",
  /*   48 */  "RCX_REGI",
  /*   49 */  "RDX_REGI",
  /*   50 */  "RDI_REGI",
  /*   51 */  "NO_RCX_REGI",
  /*   52 */  "NO_RAX_RDX_REGI",
  /*   53 */  "ANY_REGP",
  /*   54 */  "RREGP",
  /*   55 */  "RREGN",
  /*   56 */  "NO_RAX_REGP",
  /*   57 */  "NO_RBP_REGP",
  /*   58 */  "NO_RAX_RBX_REGP",
  /*   59 */  "RAX_REGP",
  /*   60 */  "RAX_REGN",
  /*   61 */  "RBX_REGP",
  /*   62 */  "RSI_REGP",
  /*   63 */  "RDI_REGP",
  /*   64 */  "R15_REGP",
  /*   65 */  "REX_REGP",
  /*   66 */  "RREGL",
  /*   67 */  "NO_RAX_RDX_REGL",
  /*   68 */  "NO_RAX_REGL",
  /*   69 */  "NO_RCX_REGL",
  /*   70 */  "RAX_REGL",
  /*   71 */  "RCX_REGL",
  /*   72 */  "RDX_REGL",
  /*   73 */  "RFLAGSREG",
  /*   74 */  "RFLAGSREGU",
  /*   75 */  "RFLAGSREGUCF",
  /*   76 */  "REGF",
  /*   77 */  "LEGREGF",
  /*   78 */  "VLREGF",
  /*   79 */  "REGD",
  /*   80 */  "LEGREGD",
  /*   81 */  "VLREGD",
  /*   82 */  "VECS",
  /*   83 */  "LEGVECS",
  /*   84 */  "VECD",
  /*   85 */  "LEGVECD",
  /*   86 */  "VECX",
  /*   87 */  "LEGVECX",
  /*   88 */  "VECY",
  /*   89 */  "LEGVECY",
  /*   90 */  "INDIRECT",
  /*   91 */  "INDOFFSET8",
  /*   92 */  "INDOFFSET32",
  /*   93 */  "INDINDEXOFFSET",
  /*   94 */  "INDINDEX",
  /*   95 */  "INDINDEXSCALE",
  /*   96 */  "INDPOSINDEXSCALE",
  /*   97 */  "INDINDEXSCALEOFFSET",
  /*   98 */  "INDPOSINDEXOFFSET",
  /*   99 */  "INDPOSINDEXSCALEOFFSET",
  /*  100 */  "INDCOMPRESSEDOOPOFFSET",
  /*  101 */  "INDIRECTNARROW",
  /*  102 */  "INDOFFSET8NARROW",
  /*  103 */  "INDOFFSET32NARROW",
  /*  104 */  "INDINDEXOFFSETNARROW",
  /*  105 */  "INDINDEXNARROW",
  /*  106 */  "INDINDEXSCALENARROW",
  /*  107 */  "INDINDEXSCALEOFFSETNARROW",
  /*  108 */  "INDPOSINDEXOFFSETNARROW",
  /*  109 */  "INDPOSINDEXSCALEOFFSETNARROW",
  /*  110 */  "STACKSLOTP",
  /*  111 */  "STACKSLOTI",
  /*  112 */  "STACKSLOTF",
  /*  113 */  "STACKSLOTD",
  /*  114 */  "STACKSLOTL",
  /*  115 */  "CMPOP",
  /*  116 */  "CMPOPU",
  /*  117 */  "CMPOPUCF",
  /*  118 */  "CMPOPUCF2",
  /*  119 */  "RXMM0",
  /*  120 */  "RXMM1",
  /*  121 */  "RXMM2",
  /*  122 */  "RXMM3",
  /*  123 */  "RXMM4",
  /*  124 */  "RXMM5",
  /*  125 */  "RXMM6",
  /*  126 */  "RXMM7",
  /*  127 */  "RXMM8",
  /*  128 */  "RXMM9",
  /*  129 */  "RXMM10",
  /*  130 */  "RXMM11",
  /*  131 */  "RXMM12",
  /*  132 */  "RXMM13",
  /*  133 */  "RXMM14",
  /*  134 */  "RXMM15",
  /*  135 */  "RXMM16",
  /*  136 */  "RXMM17",
  /*  137 */  "RXMM18",
  /*  138 */  "RXMM19",
  /*  139 */  "RXMM20",
  /*  140 */  "RXMM21",
  /*  141 */  "RXMM22",
  /*  142 */  "RXMM23",
  /*  143 */  "RXMM24",
  /*  144 */  "RXMM25",
  /*  145 */  "RXMM26",
  /*  146 */  "RXMM27",
  /*  147 */  "RXMM28",
  /*  148 */  "RXMM29",
  /*  149 */  "RXMM30",
  /*  150 */  "RXMM31",
  /*  151 */  "VECZ",
  /*  152 */  "LEGVECZ",
  /*  153 */  "CMPOP_VCMPPD",
  // last operand
  /*  154 */  "MEMORY",
  // last operand class
  /*  155 */  "_AddP_any_RegP_rRegL",
  /*  156 */  "_LShiftL_rRegL_immI2",
  /*  157 */  "_ConvI2L_rRegI_",
  /*  158 */  "_LShiftL__ConvI2L_rRegI__immI2",
  /*  159 */  "_AddP_any_RegP__LShiftL_rRegL_immI2",
  /*  160 */  "_AddP_any_RegP__ConvI2L_rRegI_",
  /*  161 */  "_AddP_any_RegP__LShiftL__ConvI2L_rRegI__immI2",
  /*  162 */  "_DecodeN_rRegN_",
  /*  163 */  "_AddP__DecodeN_rRegN__rRegL",
  /*  164 */  "_AddP__DecodeN_rRegN___LShiftL_rRegL_immI2",
  /*  165 */  "_AddP__DecodeN_rRegN___ConvI2L_rRegI_",
  /*  166 */  "_AddP__DecodeN_rRegN___LShiftL__ConvI2L_rRegI__immI2",
  /*  167 */  "_LoadB_memory_",
  /*  168 */  "_LoadUB_memory_",
  /*  169 */  "_AndI__LoadUB_memory__immI",
  /*  170 */  "_LoadS_memory_",
  /*  171 */  "_LShiftI__LoadS_memory__immI_24",
  /*  172 */  "_LoadUS_memory_",
  /*  173 */  "_LShiftI__LoadUS_memory__immI_24",
  /*  174 */  "_AndI__LoadUS_memory__immI_255",
  /*  175 */  "_AndI__LoadUS_memory__immI",
  /*  176 */  "_LoadI_memory_",
  /*  177 */  "_LShiftI__LoadI_memory__immI_24",
  /*  178 */  "_LShiftI__LoadI_memory__immI_16",
  /*  179 */  "_AndI__LoadI_memory__immI_255",
  /*  180 */  "_AndI__LoadI_memory__immI_65535",
  /*  181 */  "_AndI__LoadI_memory__immU31",
  /*  182 */  "_ConvI2L__LoadI_memory__",
  /*  183 */  "_LoadL_memory_",
  /*  184 */  "_CastP2X_rRegP_",
  /*  185 */  "_CastP2X__DecodeN_rRegN__",
  /*  186 */  "_AddL__LShiftL_rRegL_immI2_immL32",
  /*  187 */  "_Binary_cmpOp_rFlagsReg",
  /*  188 */  "_Binary_rRegI_rRegI",
  /*  189 */  "_Binary_cmpOpU_rFlagsRegU",
  /*  190 */  "_Binary_cmpOpUCF_rFlagsRegUCF",
  /*  191 */  "_Binary_rRegI__LoadI_memory_",
  /*  192 */  "_Binary_rRegN_rRegN",
  /*  193 */  "_Binary_rRegP_rRegP",
  /*  194 */  "_Binary_rRegL_rRegL",
  /*  195 */  "_Binary_rRegL__LoadL_memory_",
  /*  196 */  "_Binary_regF_regF",
  /*  197 */  "_Binary_regD_regD",
  /*  198 */  "_AddI__LoadI_memory__rRegI",
  /*  199 */  "_AddI_rRegI__LoadI_memory_",
  /*  200 */  "_AddI__LoadI_memory__immI",
  /*  201 */  "_AddI__LoadI_memory__immI1",
  /*  202 */  "_AddI__LoadI_memory__immI_M1",
  /*  203 */  "_AddL__LoadL_memory__rRegL",
  /*  204 */  "_AddL_rRegL__LoadL_memory_",
  /*  205 */  "_AddL__LoadL_memory__immL32",
  /*  206 */  "_AddL__LoadL_memory__immL1",
  /*  207 */  "_AddL__LoadL_memory__immL_M1",
  /*  208 */  "_Binary_rax_RegP_rRegP",
  /*  209 */  "_Binary_rax_RegI_rRegI",
  /*  210 */  "_Binary_rax_RegL_rRegL",
  /*  211 */  "_Binary_rax_RegN_rRegN",
  /*  212 */  "_SubI__LoadI_memory__rRegI",
  /*  213 */  "_SubI__LoadI_memory__immI",
  /*  214 */  "_SubL__LoadL_memory__rRegL",
  /*  215 */  "_SubL__LoadL_memory__immL32",
  /*  216 */  "_SubI_immI0_rRegI",
  /*  217 */  "_SubI_immI0__LoadI_memory_",
  /*  218 */  "_SubL_immL0__LoadL_memory_",
  /*  219 */  "_LShiftI__LoadI_memory__immI1",
  /*  220 */  "_LShiftI__LoadI_memory__immI8",
  /*  221 */  "_LShiftI__LoadI_memory__rcx_RegI",
  /*  222 */  "_RShiftI__LoadI_memory__immI1",
  /*  223 */  "_RShiftI__LoadI_memory__immI8",
  /*  224 */  "_RShiftI__LoadI_memory__rcx_RegI",
  /*  225 */  "_URShiftI__LoadI_memory__immI1",
  /*  226 */  "_URShiftI__LoadI_memory__immI8",
  /*  227 */  "_URShiftI__LoadI_memory__rcx_RegI",
  /*  228 */  "_LShiftL__LoadL_memory__immI1",
  /*  229 */  "_LShiftL__LoadL_memory__immI8",
  /*  230 */  "_LShiftL__LoadL_memory__rcx_RegI",
  /*  231 */  "_RShiftL__LoadL_memory__immI1",
  /*  232 */  "_RShiftL__LoadL_memory__immI8",
  /*  233 */  "_RShiftL__LoadL_memory__rcx_RegI",
  /*  234 */  "_URShiftL__LoadL_memory__immI1",
  /*  235 */  "_URShiftL__LoadL_memory__immI8",
  /*  236 */  "_URShiftL__LoadL_memory__rcx_RegI",
  /*  237 */  "_LShiftI_rRegI_immI_24",
  /*  238 */  "_LShiftI_rRegI_immI_16",
  /*  239 */  "_LShiftI_rRegI_immI1",
  /*  240 */  "_URShiftI_rRegI_immI_M1",
  /*  241 */  "_LShiftI_rRegI_immI8",
  /*  242 */  "_URShiftI_rRegI_immI8",
  /*  243 */  "_LShiftI_no_rcx_RegI_rcx_RegI",
  /*  244 */  "_SubI_immI0_rcx_RegI",
  /*  245 */  "_URShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI",
  /*  246 */  "_SubI_immI_32_rcx_RegI",
  /*  247 */  "_URShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI",
  /*  248 */  "_URShiftI_rRegI_immI1",
  /*  249 */  "_LShiftI_rRegI_immI_M1",
  /*  250 */  "_URShiftI_no_rcx_RegI_rcx_RegI",
  /*  251 */  "_LShiftI_no_rcx_RegI__SubI_immI0_rcx_RegI",
  /*  252 */  "_LShiftI_no_rcx_RegI__SubI_immI_32_rcx_RegI",
  /*  253 */  "_LShiftL_rRegL_immI1",
  /*  254 */  "_URShiftL_rRegL_immI_M1",
  /*  255 */  "_LShiftL_rRegL_immI8",
  /*  256 */  "_URShiftL_rRegL_immI8",
  /*  257 */  "_LShiftL_no_rcx_RegL_rcx_RegI",
  /*  258 */  "_URShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI",
  /*  259 */  "_SubI_immI_64_rcx_RegI",
  /*  260 */  "_URShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI",
  /*  261 */  "_URShiftL_rRegL_immI1",
  /*  262 */  "_LShiftL_rRegL_immI_M1",
  /*  263 */  "_URShiftL_no_rcx_RegL_rcx_RegI",
  /*  264 */  "_LShiftL_no_rcx_RegL__SubI_immI0_rcx_RegI",
  /*  265 */  "_LShiftL_no_rcx_RegL__SubI_immI_64_rcx_RegI",
  /*  266 */  "_AndI_rRegI_immI_255",
  /*  267 */  "_AndI_rRegI_immI_65535",
  /*  268 */  "_AndI__LoadI_memory__rRegI",
  /*  269 */  "_AndI_rRegI__LoadI_memory_",
  /*  270 */  "_AndI__LoadI_memory__immI",
  /*  271 */  "_XorI_rRegI_immI_M1",
  /*  272 */  "_AddI_rRegI_immI_M1",
  /*  273 */  "_OrI__LoadI_memory__rRegI",
  /*  274 */  "_OrI_rRegI__LoadI_memory_",
  /*  275 */  "_OrI__LoadI_memory__immI",
  /*  276 */  "_XorI__LoadI_memory__rRegI",
  /*  277 */  "_XorI_rRegI__LoadI_memory_",
  /*  278 */  "_XorI__LoadI_memory__immI",
  /*  279 */  "_AndL__LoadL_memory__rRegL",
  /*  280 */  "_AndL_rRegL__LoadL_memory_",
  /*  281 */  "_AndL__LoadL_memory__immL32",
  /*  282 */  "_XorL_rRegL_immL_M1",
  /*  283 */  "_SubL_immL0_rRegL",
  /*  284 */  "_AddL_rRegL_immL_M1",
  /*  285 */  "_CastP2X_any_RegP_",
  /*  286 */  "_OrL__LoadL_memory__rRegL",
  /*  287 */  "_OrL_rRegL__LoadL_memory_",
  /*  288 */  "_OrL__LoadL_memory__immL32",
  /*  289 */  "_XorL__LoadL_memory__rRegL",
  /*  290 */  "_XorL_rRegL__LoadL_memory_",
  /*  291 */  "_XorL__LoadL_memory__immL32",
  /*  292 */  "_CmpLTMask_rRegI_rRegI",
  /*  293 */  "_AndI__CmpLTMask_rRegI_rRegI_rRegI",
  /*  294 */  "_SubI_rRegI_rRegI",
  /*  295 */  "_AndI_rRegI__CmpLTMask_rRegI_rRegI",
  /*  296 */  "_LoadF_memory_",
  /*  297 */  "_LoadD_memory_",
  /*  298 */  "_Binary_rdi_RegP_rcx_RegI",
  /*  299 */  "_Binary_rsi_RegP_rdx_RegI",
  /*  300 */  "_Binary_rdi_RegP_rdx_RegI",
  /*  301 */  "_Binary_rsi_RegP_immI",
  /*  302 */  "_Binary_rsi_RegP_rax_RegI",
  /*  303 */  "_Binary_rdi_RegP_rsi_RegP",
  /*  304 */  "_AndI_rRegI_immI",
  /*  305 */  "_LoadP_memory_",
  /*  306 */  "_LoadN_memory_",
  /*  307 */  "_LoadNKlass_memory_",
  /*  308 */  "_AndL_rRegL_immL32",
  /*  309 */  "_AndL__CastP2X_rRegP___LoadL_memory_",
  /*  310 */  "_AndL__LoadL_memory___CastP2X_rRegP_",
  /*  311 */  "_AndI__LoadB_memory__immI8",
  /*  312 */  "_PartialSubtypeCheck_rsi_RegP_rax_RegP",
  /*  313 */  "_LoadVector_memory_",
  /*  314 */  "_Binary_cmpOp_vcmppd_immI8",
  /*  315 */  "_Binary_legVecY_legVecY",
  /*  316 */  "_Binary_vecX_vecX",
  /*  317 */  "_Binary_vecX__LoadVector_memory_",
  /*  318 */  "_Binary_vecY_vecY",
  /*  319 */  "_Binary_vecY__LoadVector_memory_",
  /*  320 */  "_Binary_vecZ_vecZ",
  /*  321 */  "_Binary_vecZ__LoadVector_memory_",
  // last internally defined operand
  /*  322 */  "storeSSI",
  /*  323 */  "storeSSL",
  /*  324 */  "storeSSP",
  /*  325 */  "storeSSF",
  /*  326 */  "storeSSD",
  /*  327 */  "MoveF2VL",
  /*  328 */  "MoveF2LEG",
  /*  329 */  "MoveVL2F",
  /*  330 */  "MoveLEG2F",
  /*  331 */  "MoveD2VL",
  /*  332 */  "MoveD2LEG",
  /*  333 */  "MoveVL2D",
  /*  334 */  "MoveLEG2D",
  /*  335 */  "leaP8",
  /*  336 */  "leaP32",
  /*  337 */  "leaPIdxOff",
  /*  338 */  "leaPIdxScale",
  /*  339 */  "leaPPosIdxScale",
  /*  340 */  "leaPIdxScaleOff",
  /*  341 */  "leaPPosIdxOff",
  /*  342 */  "leaPPosIdxScaleOff",
  /*  343 */  "leaPCompressedOopOffset",
  /*  344 */  "leaP8Narrow",
  /*  345 */  "leaP32Narrow",
  /*  346 */  "leaPIdxOffNarrow",
  /*  347 */  "leaPIdxScaleNarrow",
  /*  348 */  "leaPIdxScaleOffNarrow",
  /*  349 */  "leaPPosIdxOffNarrow",
  /*  350 */  "leaPPosIdxScaleOffNarrow",
  /*  351 */  "loadConI",
  /*  352 */  "loadConI0",
  /*  353 */  "loadConL",
  /*  354 */  "loadConL0",
  /*  355 */  "loadConUL32",
  /*  356 */  "loadConL32",
  /*  357 */  "loadConP",
  /*  358 */  "loadConP0",
  /*  359 */  "loadConP31",
  /*  360 */  "loadConF",
  /*  361 */  "loadConN0",
  /*  362 */  "loadConN",
  /*  363 */  "loadConNKlass",
  /*  364 */  "loadConF0",
  /*  365 */  "loadConD",
  /*  366 */  "loadConD0",
  /*  367 */  "loadSSI",
  /*  368 */  "loadSSL",
  /*  369 */  "loadSSP",
  /*  370 */  "loadSSF",
  /*  371 */  "loadSSD",
  /*  372 */  "MoveVecS2Leg",
  /*  373 */  "MoveLeg2VecS",
  /*  374 */  "MoveVecD2Leg",
  /*  375 */  "MoveLeg2VecD",
  /*  376 */  "MoveVecX2Leg",
  /*  377 */  "MoveLeg2VecX",
  /*  378 */  "MoveVecY2Leg",
  /*  379 */  "MoveLeg2VecY",
  /*  380 */  "MoveVecZ2Leg",
  /*  381 */  "MoveLeg2VecZ",
  /*  382 */  "vshiftcntimm",
  /*  383 */  "membar_volatile",
  /*  384 */  "castX2P",
  /*  385 */  "castP2X",
  /*  386 */  "checkCastPP",
  /*  387 */  "castPP",
  /*  388 */  "castII",
  /*  389 */  "storePConditional",
  /*  390 */  "storeIConditional",
  /*  391 */  "storeLConditional",
  /*  392 */  "cmpF_cc_reg",
  /*  393 */  "cmpF_cc_reg_CF",
  /*  394 */  "cmpF_cc_mem",
  /*  395 */  "cmpF_cc_memCF",
  /*  396 */  "cmpF_cc_imm",
  /*  397 */  "cmpF_cc_immCF",
  /*  398 */  "cmpD_cc_reg",
  /*  399 */  "cmpD_cc_reg_CF",
  /*  400 */  "cmpD_cc_mem",
  /*  401 */  "cmpD_cc_memCF",
  /*  402 */  "cmpD_cc_imm",
  /*  403 */  "cmpD_cc_immCF",
  /*  404 */  "roundFloat_nop",
  /*  405 */  "roundDouble_nop",
  /*  406 */  "MoveF2I_stack_reg",
  /*  407 */  "MoveI2F_stack_reg",
  /*  408 */  "MoveD2L_stack_reg",
  /*  409 */  "MoveL2D_stack_reg_partial",
  /*  410 */  "MoveL2D_stack_reg",
  /*  411 */  "MoveF2I_reg_reg",
  /*  412 */  "MoveD2L_reg_reg",
  /*  413 */  "MoveI2F_reg_reg",
  /*  414 */  "MoveL2D_reg_reg",
  /*  415 */  "overflowAddI_rReg",
  /*  416 */  "overflowAddI_rReg_imm",
  /*  417 */  "overflowAddL_rReg",
  /*  418 */  "overflowAddL_rReg_imm",
  /*  419 */  "overflowSubI_rReg",
  /*  420 */  "overflowSubI_rReg_imm",
  /*  421 */  "overflowSubL_rReg",
  /*  422 */  "overflowSubL_rReg_imm",
  /*  423 */  "overflowNegI_rReg",
  /*  424 */  "overflowNegL_rReg",
  /*  425 */  "overflowMulI_rReg",
  /*  426 */  "overflowMulI_rReg_imm",
  /*  427 */  "overflowMulL_rReg",
  /*  428 */  "overflowMulL_rReg_imm",
  /*  429 */  "compI_rReg",
  /*  430 */  "compI_rReg_imm",
  /*  431 */  "compI_rReg_mem",
  /*  432 */  "testI_reg",
  /*  433 */  "testI_reg_imm",
  /*  434 */  "testI_reg_mem",
  /*  435 */  "testI_reg_mem_0",
  /*  436 */  "compU_rReg",
  /*  437 */  "compU_rReg_imm",
  /*  438 */  "compU_rReg_mem",
  /*  439 */  "testU_reg",
  /*  440 */  "compP_rReg",
  /*  441 */  "compP_rReg_mem",
  /*  442 */  "compP_mem_rReg",
  /*  443 */  "testP_reg",
  /*  444 */  "testP_mem",
  /*  445 */  "testP_mem_reg0",
  /*  446 */  "compN_rReg",
  /*  447 */  "compN_rReg_mem",
  /*  448 */  "compN_rReg_imm",
  /*  449 */  "compN_mem_imm",
  /*  450 */  "compN_rReg_imm_klass",
  /*  451 */  "compN_mem_imm_klass",
  /*  452 */  "testN_reg",
  /*  453 */  "testN_mem",
  /*  454 */  "testN_mem_reg0",
  /*  455 */  "compL_rReg",
  /*  456 */  "compL_rReg_imm",
  /*  457 */  "compL_rReg_mem",
  /*  458 */  "testL_reg",
  /*  459 */  "testL_reg_imm",
  /*  460 */  "testL_reg_mem",
  /*  461 */  "testL_reg_mem_0",
  /*  462 */  "testL_reg_mem2",
  /*  463 */  "testL_reg_mem2_0",
  /*  464 */  "compUL_rReg",
  /*  465 */  "compUL_rReg_imm",
  /*  466 */  "compUL_rReg_mem",
  /*  467 */  "testUL_reg",
  /*  468 */  "compB_mem_imm",
  /*  469 */  "testB_mem_imm",
  /*  470 */  "partialSubtypeCheck_vs_Zero",
  /*  471 */  "cmpFastLockRTM",
  /*  472 */  "cmpFastLock",
  /*  473 */  "cmpFastUnlock",
  /*  474 */  "safePoint_poll",
  /*  475 */  "tlsLoadP",
  /*  476 */  "absF_reg",
  /*  477 */  "absF_reg_reg",
  /*  478 */  "absD_reg",
  /*  479 */  "absD_reg_reg",
  /*  480 */  "negF_reg",
  /*  481 */  "negF_reg_reg",
  /*  482 */  "negD_reg",
  /*  483 */  "negD_reg_reg",
  /*  484 */  "vsqrt2D_reg",
  /*  485 */  "vsqrt2D_mem",
  /*  486 */  "vsqrt4D_reg",
  /*  487 */  "vsqrt4D_mem",
  /*  488 */  "vsqrt8D_reg",
  /*  489 */  "vsqrt8D_mem",
  /*  490 */  "vsqrt2F_reg",
  /*  491 */  "vsqrt2F_mem",
  /*  492 */  "vsqrt4F_reg",
  /*  493 */  "vsqrt4F_mem",
  /*  494 */  "vsqrt8F_reg",
  /*  495 */  "vsqrt8F_mem",
  /*  496 */  "vsqrt16F_reg",
  /*  497 */  "vsqrt16F_mem",
  /*  498 */  "vshiftcnt",
  /*  499 */  "vshiftcnt_0",
  /*  500 */  "vabs4B_reg",
  /*  501 */  "vabs8B_reg",
  /*  502 */  "vabs16B_reg",
  /*  503 */  "vabs32B_reg",
  /*  504 */  "vabs64B_reg",
  /*  505 */  "vabs2S_reg",
  /*  506 */  "vabs4S_reg",
  /*  507 */  "vabs8S_reg",
  /*  508 */  "vabs16S_reg",
  /*  509 */  "vabs32S_reg",
  /*  510 */  "vabs2I_reg",
  /*  511 */  "vabs4I_reg",
  /*  512 */  "vabs8I_reg",
  /*  513 */  "vabs16I_reg",
  /*  514 */  "vabs2L_reg",
  /*  515 */  "vabs4L_reg",
  /*  516 */  "vabs8L_reg",
  /*  517 */  "vpopcount2I",
  /*  518 */  "vpopcount4I",
  /*  519 */  "vpopcount8I",
  /*  520 */  "vpopcount16I",
  /*  521 */  "loadB",
  /*  522 */  "loadB2L",
  /*  523 */  "loadUB",
  /*  524 */  "loadUB2L",
  /*  525 */  "loadUB2L_immI",
  /*  526 */  "loadS",
  /*  527 */  "loadS2B",
  /*  528 */  "loadS2L",
  /*  529 */  "loadUS",
  /*  530 */  "loadUS2B",
  /*  531 */  "loadUS2L",
  /*  532 */  "loadUS2L_immI_255",
  /*  533 */  "loadUS2L_immI",
  /*  534 */  "loadI",
  /*  535 */  "loadI2B",
  /*  536 */  "loadI2UB",
  /*  537 */  "loadI2S",
  /*  538 */  "loadI2US",
  /*  539 */  "loadI2L",
  /*  540 */  "loadI2L_immI_255",
  /*  541 */  "loadI2L_immI_65535",
  /*  542 */  "loadI2L_immU31",
  /*  543 */  "loadUI2L",
  /*  544 */  "loadL",
  /*  545 */  "loadRange",
  /*  546 */  "loadP",
  /*  547 */  "loadN",
  /*  548 */  "loadKlass",
  /*  549 */  "loadNKlass",
  /*  550 */  "loadF",
  /*  551 */  "loadD_partial",
  /*  552 */  "loadD",
  /*  553 */  "maxF_reg",
  /*  554 */  "maxF_reduction_reg",
  /*  555 */  "maxD_reg",
  /*  556 */  "maxD_reduction_reg",
  /*  557 */  "minF_reg",
  /*  558 */  "minF_reduction_reg",
  /*  559 */  "minD_reg",
  /*  560 */  "minD_reduction_reg",
  /*  561 */  "prefetchAlloc",
  /*  562 */  "prefetchAllocNTA",
  /*  563 */  "prefetchAllocT0",
  /*  564 */  "prefetchAllocT2",
  /*  565 */  "storeB",
  /*  566 */  "storeC",
  /*  567 */  "storeI",
  /*  568 */  "storeL",
  /*  569 */  "storeP",
  /*  570 */  "storeImmP0",
  /*  571 */  "storeImmP",
  /*  572 */  "storeN",
  /*  573 */  "storeNKlass",
  /*  574 */  "storeImmN0",
  /*  575 */  "storeImmN",
  /*  576 */  "storeImmNKlass",
  /*  577 */  "storeImmI0",
  /*  578 */  "storeImmI",
  /*  579 */  "storeImmL0",
  /*  580 */  "storeImmL",
  /*  581 */  "storeImmC0",
  /*  582 */  "storeImmI16",
  /*  583 */  "storeImmB0",
  /*  584 */  "storeImmB",
  /*  585 */  "storeImmCM0_reg",
  /*  586 */  "storeImmCM0",
  /*  587 */  "storeF",
  /*  588 */  "storeF0",
  /*  589 */  "storeF_imm",
  /*  590 */  "storeD",
  /*  591 */  "storeD0_imm",
  /*  592 */  "storeD0",
  /*  593 */  "bytes_reverse_int",
  /*  594 */  "bytes_reverse_long",
  /*  595 */  "bytes_reverse_unsigned_short",
  /*  596 */  "bytes_reverse_short",
  /*  597 */  "countLeadingZerosI",
  /*  598 */  "countLeadingZerosI_bsr",
  /*  599 */  "countLeadingZerosL",
  /*  600 */  "countLeadingZerosL_bsr",
  /*  601 */  "countTrailingZerosI",
  /*  602 */  "countTrailingZerosI_bsf",
  /*  603 */  "countTrailingZerosL",
  /*  604 */  "countTrailingZerosL_bsf",
  /*  605 */  "popCountI",
  /*  606 */  "popCountI_mem",
  /*  607 */  "popCountL",
  /*  608 */  "popCountL_mem",
  /*  609 */  "membar_acquire",
  /*  610 */  "membar_acquire_0",
  /*  611 */  "membar_acquire_lock",
  /*  612 */  "membar_release",
  /*  613 */  "membar_release_0",
  /*  614 */  "membar_release_lock",
  /*  615 */  "unnecessary_membar_volatile",
  /*  616 */  "membar_storestore",
  /*  617 */  "convP2I",
  /*  618 */  "convN2I",
  /*  619 */  "encodeHeapOop",
  /*  620 */  "encodeHeapOop_not_null",
  /*  621 */  "decodeHeapOop",
  /*  622 */  "decodeHeapOop_not_null",
  /*  623 */  "encodeKlass_not_null",
  /*  624 */  "decodeKlass_not_null",
  /*  625 */  "jumpXtnd_offset",
  /*  626 */  "jumpXtnd_addr",
  /*  627 */  "jumpXtnd",
  /*  628 */  "cmovI_reg",
  /*  629 */  "cmovI_regU",
  /*  630 */  "cmovI_regUCF",
  /*  631 */  "cmovI_mem",
  /*  632 */  "cmovI_memU",
  /*  633 */  "cmovI_memUCF",
  /*  634 */  "cmovN_reg",
  /*  635 */  "cmovN_regU",
  /*  636 */  "cmovN_regUCF",
  /*  637 */  "cmovP_reg",
  /*  638 */  "cmovP_regU",
  /*  639 */  "cmovP_regUCF",
  /*  640 */  "cmovL_reg",
  /*  641 */  "cmovL_mem",
  /*  642 */  "cmovL_regU",
  /*  643 */  "cmovL_regUCF",
  /*  644 */  "cmovL_memU",
  /*  645 */  "cmovL_memUCF",
  /*  646 */  "cmovF_reg",
  /*  647 */  "cmovF_regU",
  /*  648 */  "cmovF_regUCF",
  /*  649 */  "cmovD_reg",
  /*  650 */  "cmovD_regU",
  /*  651 */  "cmovD_regUCF",
  /*  652 */  "addI_rReg",
  /*  653 */  "addI_rReg_imm",
  /*  654 */  "addI_rReg_mem",
  /*  655 */  "addI_rReg_mem_0",
  /*  656 */  "addI_mem_rReg",
  /*  657 */  "addI_mem_rReg_0",
  /*  658 */  "addI_mem_imm",
  /*  659 */  "incI_rReg",
  /*  660 */  "incI_mem",
  /*  661 */  "decI_rReg",
  /*  662 */  "decI_mem",
  /*  663 */  "leaI_rReg_immI",
  /*  664 */  "addL_rReg",
  /*  665 */  "addL_rReg_imm",
  /*  666 */  "addL_rReg_mem",
  /*  667 */  "addL_rReg_mem_0",
  /*  668 */  "addL_mem_rReg",
  /*  669 */  "addL_mem_rReg_0",
  /*  670 */  "addL_mem_imm",
  /*  671 */  "incL_rReg",
  /*  672 */  "incL_mem",
  /*  673 */  "decL_rReg",
  /*  674 */  "decL_mem",
  /*  675 */  "leaL_rReg_immL",
  /*  676 */  "addP_rReg",
  /*  677 */  "addP_rReg_imm",
  /*  678 */  "leaP_rReg_imm",
  /*  679 */  "loadPLocked",
  /*  680 */  "compareAndSwapP",
  /*  681 */  "compareAndSwapP_0",
  /*  682 */  "compareAndSwapL",
  /*  683 */  "compareAndSwapL_0",
  /*  684 */  "compareAndSwapI",
  /*  685 */  "compareAndSwapI_0",
  /*  686 */  "compareAndSwapB",
  /*  687 */  "compareAndSwapB_0",
  /*  688 */  "compareAndSwapS",
  /*  689 */  "compareAndSwapS_0",
  /*  690 */  "compareAndSwapN",
  /*  691 */  "compareAndSwapN_0",
  /*  692 */  "compareAndExchangeB",
  /*  693 */  "compareAndExchangeS",
  /*  694 */  "compareAndExchangeI",
  /*  695 */  "compareAndExchangeL",
  /*  696 */  "compareAndExchangeN",
  /*  697 */  "compareAndExchangeP",
  /*  698 */  "xaddB_no_res",
  /*  699 */  "xaddB",
  /*  700 */  "xaddS_no_res",
  /*  701 */  "xaddS",
  /*  702 */  "xaddI_no_res",
  /*  703 */  "xaddI",
  /*  704 */  "xaddL_no_res",
  /*  705 */  "xaddL",
  /*  706 */  "xchgB",
  /*  707 */  "xchgS",
  /*  708 */  "xchgI",
  /*  709 */  "xchgL",
  /*  710 */  "xchgP",
  /*  711 */  "xchgN",
  /*  712 */  "absI_rReg",
  /*  713 */  "absL_rReg",
  /*  714 */  "subI_rReg",
  /*  715 */  "subI_rReg_imm",
  /*  716 */  "subI_rReg_mem",
  /*  717 */  "subI_mem_rReg",
  /*  718 */  "subI_mem_imm",
  /*  719 */  "subL_rReg",
  /*  720 */  "subL_rReg_imm",
  /*  721 */  "subL_rReg_mem",
  /*  722 */  "subL_mem_rReg",
  /*  723 */  "subL_mem_imm",
  /*  724 */  "subP_rReg",
  /*  725 */  "negI_rReg",
  /*  726 */  "negI_mem",
  /*  727 */  "negL_rReg",
  /*  728 */  "negL_mem",
  /*  729 */  "mulI_rReg",
  /*  730 */  "mulI_rReg_imm",
  /*  731 */  "mulI_mem",
  /*  732 */  "mulI_mem_0",
  /*  733 */  "mulI_mem_imm",
  /*  734 */  "mulL_rReg",
  /*  735 */  "mulL_rReg_imm",
  /*  736 */  "mulL_mem",
  /*  737 */  "mulL_mem_0",
  /*  738 */  "mulL_mem_imm",
  /*  739 */  "mulHiL_rReg",
  /*  740 */  "divI_rReg",
  /*  741 */  "divL_rReg",
  /*  742 */  "divModI_rReg_divmod",
  /*  743 */  "divModL_rReg_divmod",
  /*  744 */  "loadConL_0x6666666666666667",
  /*  745 */  "mul_hi",
  /*  746 */  "sarL_rReg_63",
  /*  747 */  "sarL_rReg_2",
  /*  748 */  "divL_10",
  /*  749 */  "modI_rReg",
  /*  750 */  "modL_rReg",
  /*  751 */  "salI_rReg_1",
  /*  752 */  "salI_mem_1",
  /*  753 */  "salI_rReg_imm",
  /*  754 */  "salI_mem_imm",
  /*  755 */  "salI_rReg_CL",
  /*  756 */  "salI_mem_CL",
  /*  757 */  "sarI_rReg_1",
  /*  758 */  "sarI_mem_1",
  /*  759 */  "sarI_rReg_imm",
  /*  760 */  "sarI_mem_imm",
  /*  761 */  "sarI_rReg_CL",
  /*  762 */  "sarI_mem_CL",
  /*  763 */  "shrI_rReg_1",
  /*  764 */  "shrI_mem_1",
  /*  765 */  "shrI_rReg_imm",
  /*  766 */  "shrI_mem_imm",
  /*  767 */  "shrI_rReg_CL",
  /*  768 */  "shrI_mem_CL",
  /*  769 */  "salL_rReg_1",
  /*  770 */  "salL_mem_1",
  /*  771 */  "salL_rReg_imm",
  /*  772 */  "salL_mem_imm",
  /*  773 */  "salL_rReg_CL",
  /*  774 */  "salL_mem_CL",
  /*  775 */  "sarL_rReg_1",
  /*  776 */  "sarL_mem_1",
  /*  777 */  "sarL_rReg_imm",
  /*  778 */  "sarL_mem_imm",
  /*  779 */  "sarL_rReg_CL",
  /*  780 */  "sarL_mem_CL",
  /*  781 */  "shrL_rReg_1",
  /*  782 */  "shrL_mem_1",
  /*  783 */  "shrL_rReg_imm",
  /*  784 */  "shrL_mem_imm",
  /*  785 */  "shrL_rReg_CL",
  /*  786 */  "shrL_mem_CL",
  /*  787 */  "i2b",
  /*  788 */  "i2s",
  /*  789 */  "rolI_rReg_imm1",
  /*  790 */  "rolI_rReg_imm8",
  /*  791 */  "rolI_rReg_CL",
  /*  792 */  "rolI_rReg_i1",
  /*  793 */  "rolI_rReg_i1_0",
  /*  794 */  "rolI_rReg_i8",
  /*  795 */  "rolI_rReg_i8_0",
  /*  796 */  "rolI_rReg_Var_C0",
  /*  797 */  "rolI_rReg_Var_C0_0",
  /*  798 */  "rolI_rReg_Var_C32",
  /*  799 */  "rolI_rReg_Var_C32_0",
  /*  800 */  "rorI_rReg_imm1",
  /*  801 */  "rorI_rReg_imm8",
  /*  802 */  "rorI_rReg_CL",
  /*  803 */  "rorI_rReg_i1",
  /*  804 */  "rorI_rReg_i1_0",
  /*  805 */  "rorI_rReg_i8",
  /*  806 */  "rorI_rReg_i8_0",
  /*  807 */  "rorI_rReg_Var_C0",
  /*  808 */  "rorI_rReg_Var_C0_0",
  /*  809 */  "rorI_rReg_Var_C32",
  /*  810 */  "rorI_rReg_Var_C32_0",
  /*  811 */  "rolL_rReg_imm1",
  /*  812 */  "rolL_rReg_imm8",
  /*  813 */  "rolL_rReg_CL",
  /*  814 */  "rolL_rReg_i1",
  /*  815 */  "rolL_rReg_i1_0",
  /*  816 */  "rolL_rReg_i8",
  /*  817 */  "rolL_rReg_i8_0",
  /*  818 */  "rolL_rReg_Var_C0",
  /*  819 */  "rolL_rReg_Var_C0_0",
  /*  820 */  "rolL_rReg_Var_C64",
  /*  821 */  "rolL_rReg_Var_C64_0",
  /*  822 */  "rorL_rReg_imm1",
  /*  823 */  "rorL_rReg_imm8",
  /*  824 */  "rorL_rReg_CL",
  /*  825 */  "rorL_rReg_i1",
  /*  826 */  "rorL_rReg_i1_0",
  /*  827 */  "rorL_rReg_i8",
  /*  828 */  "rorL_rReg_i8_0",
  /*  829 */  "rorL_rReg_Var_C0",
  /*  830 */  "rorL_rReg_Var_C0_0",
  /*  831 */  "rorL_rReg_Var_C64",
  /*  832 */  "rorL_rReg_Var_C64_0",
  /*  833 */  "andI_rReg",
  /*  834 */  "andI_rReg_imm255",
  /*  835 */  "andI2L_rReg_imm255",
  /*  836 */  "andI_rReg_imm65535",
  /*  837 */  "andI2L_rReg_imm65535",
  /*  838 */  "andI_rReg_imm",
  /*  839 */  "andI_rReg_mem",
  /*  840 */  "andI_rReg_mem_0",
  /*  841 */  "andI_mem_rReg",
  /*  842 */  "andI_mem_rReg_0",
  /*  843 */  "andI_mem_imm",
  /*  844 */  "andnI_rReg_rReg_mem",
  /*  845 */  "andnI_rReg_rReg_mem_0",
  /*  846 */  "andnI_rReg_rReg_rReg",
  /*  847 */  "andnI_rReg_rReg_rReg_0",
  /*  848 */  "blsiI_rReg_rReg",
  /*  849 */  "blsiI_rReg_rReg_0",
  /*  850 */  "blsiI_rReg_mem",
  /*  851 */  "blsiI_rReg_mem_0",
  /*  852 */  "blsmskI_rReg_mem",
  /*  853 */  "blsmskI_rReg_mem_0",
  /*  854 */  "blsmskI_rReg_rReg",
  /*  855 */  "blsmskI_rReg_rReg_0",
  /*  856 */  "blsrI_rReg_rReg",
  /*  857 */  "blsrI_rReg_rReg_0",
  /*  858 */  "blsrI_rReg_mem",
  /*  859 */  "blsrI_rReg_mem_0",
  /*  860 */  "orI_rReg",
  /*  861 */  "orI_rReg_imm",
  /*  862 */  "orI_rReg_mem",
  /*  863 */  "orI_rReg_mem_0",
  /*  864 */  "orI_mem_rReg",
  /*  865 */  "orI_mem_rReg_0",
  /*  866 */  "orI_mem_imm",
  /*  867 */  "xorI_rReg",
  /*  868 */  "xorI_rReg_im1",
  /*  869 */  "xorI_rReg_imm",
  /*  870 */  "xorI_rReg_mem",
  /*  871 */  "xorI_rReg_mem_0",
  /*  872 */  "xorI_mem_rReg",
  /*  873 */  "xorI_mem_rReg_0",
  /*  874 */  "xorI_mem_imm",
  /*  875 */  "andL_rReg",
  /*  876 */  "andL_rReg_imm255",
  /*  877 */  "andL_rReg_imm65535",
  /*  878 */  "andL_rReg_imm",
  /*  879 */  "andL_rReg_mem",
  /*  880 */  "andL_rReg_mem_0",
  /*  881 */  "andL_mem_rReg",
  /*  882 */  "andL_mem_rReg_0",
  /*  883 */  "andL_mem_imm",
  /*  884 */  "andnL_rReg_rReg_mem",
  /*  885 */  "andnL_rReg_rReg_mem_0",
  /*  886 */  "andnL_rReg_rReg_rReg",
  /*  887 */  "andnL_rReg_rReg_rReg_0",
  /*  888 */  "blsiL_rReg_rReg",
  /*  889 */  "blsiL_rReg_rReg_0",
  /*  890 */  "blsiL_rReg_mem",
  /*  891 */  "blsiL_rReg_mem_0",
  /*  892 */  "blsmskL_rReg_mem",
  /*  893 */  "blsmskL_rReg_mem_0",
  /*  894 */  "blsmskL_rReg_rReg",
  /*  895 */  "blsmskL_rReg_rReg_0",
  /*  896 */  "blsrL_rReg_rReg",
  /*  897 */  "blsrL_rReg_rReg_0",
  /*  898 */  "blsrL_rReg_mem",
  /*  899 */  "blsrL_rReg_mem_0",
  /*  900 */  "orL_rReg",
  /*  901 */  "orL_rReg_castP2X",
  /*  902 */  "orL_rReg_castP2X_0",
  /*  903 */  "orL_rReg_imm",
  /*  904 */  "orL_rReg_mem",
  /*  905 */  "orL_rReg_mem_0",
  /*  906 */  "orL_mem_rReg",
  /*  907 */  "orL_mem_rReg_0",
  /*  908 */  "orL_mem_imm",
  /*  909 */  "xorL_rReg",
  /*  910 */  "xorL_rReg_im1",
  /*  911 */  "xorL_rReg_imm",
  /*  912 */  "xorL_rReg_mem",
  /*  913 */  "xorL_rReg_mem_0",
  /*  914 */  "xorL_mem_rReg",
  /*  915 */  "xorL_mem_rReg_0",
  /*  916 */  "xorL_mem_imm",
  /*  917 */  "convI2B",
  /*  918 */  "convP2B",
  /*  919 */  "cmpLTMask",
  /*  920 */  "cmpLTMask0",
  /*  921 */  "cadd_cmpLTMask",
  /*  922 */  "cadd_cmpLTMask_1",
  /*  923 */  "cadd_cmpLTMask_0",
  /*  924 */  "cadd_cmpLTMask_2",
  /*  925 */  "and_cmpLTMask",
  /*  926 */  "and_cmpLTMask_0",
  /*  927 */  "cmpF_reg",
  /*  928 */  "cmpF_mem",
  /*  929 */  "cmpF_imm",
  /*  930 */  "cmpD_reg",
  /*  931 */  "cmpD_mem",
  /*  932 */  "cmpD_imm",
  /*  933 */  "convF2D_reg_reg",
  /*  934 */  "convF2D_reg_mem",
  /*  935 */  "convD2F_reg_reg",
  /*  936 */  "convD2F_reg_mem",
  /*  937 */  "convF2I_reg_reg",
  /*  938 */  "convF2L_reg_reg",
  /*  939 */  "convD2I_reg_reg",
  /*  940 */  "convD2L_reg_reg",
  /*  941 */  "convI2F_reg_reg",
  /*  942 */  "convI2F_reg_mem",
  /*  943 */  "convI2D_reg_reg",
  /*  944 */  "convI2D_reg_mem",
  /*  945 */  "convXI2F_reg",
  /*  946 */  "convXI2D_reg",
  /*  947 */  "convL2F_reg_reg",
  /*  948 */  "convL2F_reg_mem",
  /*  949 */  "convL2D_reg_reg",
  /*  950 */  "convL2D_reg_mem",
  /*  951 */  "convI2L_reg_reg",
  /*  952 */  "convI2L_reg_reg_zex",
  /*  953 */  "convI2L_reg_mem_zex",
  /*  954 */  "zerox_long_reg_reg",
  /*  955 */  "convL2I_reg_reg",
  /*  956 */  "MoveF2I_reg_stack",
  /*  957 */  "MoveI2F_reg_stack",
  /*  958 */  "MoveD2L_reg_stack",
  /*  959 */  "MoveL2D_reg_stack",
  /*  960 */  "rep_stos",
  /*  961 */  "rep_stos_large",
  /*  962 */  "string_compareL",
  /*  963 */  "string_compareU",
  /*  964 */  "string_compareLU",
  /*  965 */  "string_compareUL",
  /*  966 */  "string_indexof_conL",
  /*  967 */  "string_indexof_conU",
  /*  968 */  "string_indexof_conUL",
  /*  969 */  "string_indexofL",
  /*  970 */  "string_indexofU",
  /*  971 */  "string_indexofUL",
  /*  972 */  "string_indexofU_char",
  /*  973 */  "string_equals",
  /*  974 */  "array_equalsB",
  /*  975 */  "array_equalsC",
  /*  976 */  "has_negatives",
  /*  977 */  "string_compress",
  /*  978 */  "string_inflate",
  /*  979 */  "encode_iso_array",
  /*  980 */  "cmpL3_reg_reg",
  /*  981 */  "cmovI_reg_g",
  /*  982 */  "minI_rReg",
  /*  983 */  "cmovI_reg_l",
  /*  984 */  "maxI_rReg",
  /*  985 */  "jmpDir",
  /*  986 */  "jmpCon",
  /*  987 */  "jmpLoopEnd",
  /*  988 */  "jmpLoopEndU",
  /*  989 */  "jmpLoopEndUCF",
  /*  990 */  "jmpLoopEnd_and_restoreMask",
  /*  991 */  "jmpLoopEndU_and_restoreMask",
  /*  992 */  "jmpLoopEndUCF_and_restoreMask",
  /*  993 */  "jmpConU",
  /*  994 */  "jmpConUCF",
  /*  995 */  "jmpConUCF2",
  /*  996 */  "partialSubtypeCheck",
  /*  997 */  "jmpDir_short",
  /*  998 */  "jmpCon_short",
  /*  999 */  "jmpLoopEnd_short",
  /* 1000 */  "jmpLoopEndU_short",
  /* 1001 */  "jmpLoopEndUCF_short",
  /* 1002 */  "jmpConU_short",
  /* 1003 */  "jmpConUCF_short",
  /* 1004 */  "jmpConUCF2_short",
  /* 1005 */  "safePoint_poll_far",
  /* 1006 */  "safePoint_poll_tls",
  /* 1007 */  "CallStaticJavaDirect",
  /* 1008 */  "CallDynamicJavaDirect",
  /* 1009 */  "CallRuntimeDirect",
  /* 1010 */  "CallLeafDirect",
  /* 1011 */  "CallLeafNoFPDirect",
  /* 1012 */  "Ret",
  /* 1013 */  "TailCalljmpInd",
  /* 1014 */  "tailjmpInd",
  /* 1015 */  "CreateException",
  /* 1016 */  "RethrowException",
  /* 1017 */  "loadBarrierSlowRegNoVec",
  /* 1018 */  "loadBarrierSlowRegXmmAndYmm",
  /* 1019 */  "loadBarrierSlowRegZmm",
  /* 1020 */  "loadBarrierWeakSlowRegNoVec",
  /* 1021 */  "loadBarrierWeakSlowRegXmmAndYmm",
  /* 1022 */  "loadBarrierWeakSlowRegZmm",
  /* 1023 */  "ShouldNotReachHere",
  /* 1024 */  "setMask",
  /* 1025 */  "addF_reg",
  /* 1026 */  "addF_mem",
  /* 1027 */  "addF_mem_0",
  /* 1028 */  "addF_imm",
  /* 1029 */  "addF_reg_reg",
  /* 1030 */  "addF_reg_mem",
  /* 1031 */  "addF_reg_mem_0",
  /* 1032 */  "addF_reg_imm",
  /* 1033 */  "addD_reg",
  /* 1034 */  "addD_mem",
  /* 1035 */  "addD_mem_0",
  /* 1036 */  "addD_imm",
  /* 1037 */  "addD_reg_reg",
  /* 1038 */  "addD_reg_mem",
  /* 1039 */  "addD_reg_mem_0",
  /* 1040 */  "addD_reg_imm",
  /* 1041 */  "subF_reg",
  /* 1042 */  "subF_mem",
  /* 1043 */  "subF_imm",
  /* 1044 */  "subF_reg_reg",
  /* 1045 */  "subF_reg_mem",
  /* 1046 */  "subF_reg_imm",
  /* 1047 */  "subD_reg",
  /* 1048 */  "subD_mem",
  /* 1049 */  "subD_imm",
  /* 1050 */  "subD_reg_reg",
  /* 1051 */  "subD_reg_mem",
  /* 1052 */  "subD_reg_imm",
  /* 1053 */  "mulF_reg",
  /* 1054 */  "mulF_mem",
  /* 1055 */  "mulF_mem_0",
  /* 1056 */  "mulF_imm",
  /* 1057 */  "mulF_reg_reg",
  /* 1058 */  "mulF_reg_mem",
  /* 1059 */  "mulF_reg_mem_0",
  /* 1060 */  "mulF_reg_imm",
  /* 1061 */  "mulD_reg",
  /* 1062 */  "mulD_mem",
  /* 1063 */  "mulD_mem_0",
  /* 1064 */  "mulD_imm",
  /* 1065 */  "mulD_reg_reg",
  /* 1066 */  "mulD_reg_mem",
  /* 1067 */  "mulD_reg_mem_0",
  /* 1068 */  "mulD_reg_imm",
  /* 1069 */  "divF_reg",
  /* 1070 */  "divF_mem",
  /* 1071 */  "divF_imm",
  /* 1072 */  "divF_reg_reg",
  /* 1073 */  "divF_reg_mem",
  /* 1074 */  "divF_reg_imm",
  /* 1075 */  "divD_reg",
  /* 1076 */  "divD_mem",
  /* 1077 */  "divD_imm",
  /* 1078 */  "divD_reg_reg",
  /* 1079 */  "divD_reg_mem",
  /* 1080 */  "divD_reg_imm",
  /* 1081 */  "sqrtF_reg",
  /* 1082 */  "sqrtF_mem",
  /* 1083 */  "sqrtF_imm",
  /* 1084 */  "sqrtD_reg",
  /* 1085 */  "sqrtD_mem",
  /* 1086 */  "sqrtD_imm",
  /* 1087 */  "roundD_reg",
  /* 1088 */  "roundD_mem",
  /* 1089 */  "roundD_imm",
  /* 1090 */  "vround2D_reg",
  /* 1091 */  "vround2D_mem",
  /* 1092 */  "vround4D_reg",
  /* 1093 */  "vround4D_mem",
  /* 1094 */  "vround8D_reg",
  /* 1095 */  "vround8D_mem",
  /* 1096 */  "onspinwait",
  /* 1097 */  "fmaD_reg",
  /* 1098 */  "fmaF_reg",
  /* 1099 */  "loadV4",
  /* 1100 */  "loadV8",
  /* 1101 */  "loadV16",
  /* 1102 */  "loadV32",
  /* 1103 */  "loadV64_dword",
  /* 1104 */  "loadV64_qword",
  /* 1105 */  "storeV4",
  /* 1106 */  "storeV8",
  /* 1107 */  "storeV16",
  /* 1108 */  "storeV32",
  /* 1109 */  "storeV64_dword",
  /* 1110 */  "storeV64_qword",
  /* 1111 */  "Repl16B",
  /* 1112 */  "Repl32B",
  /* 1113 */  "Repl64B",
  /* 1114 */  "Repl16B_imm",
  /* 1115 */  "Repl32B_imm",
  /* 1116 */  "Repl64B_imm",
  /* 1117 */  "Repl4S",
  /* 1118 */  "Repl4S_mem",
  /* 1119 */  "Repl8S",
  /* 1120 */  "Repl8S_mem",
  /* 1121 */  "Repl8S_imm",
  /* 1122 */  "Repl16S",
  /* 1123 */  "Repl16S_mem",
  /* 1124 */  "Repl16S_imm",
  /* 1125 */  "Repl32S",
  /* 1126 */  "Repl32S_mem",
  /* 1127 */  "Repl32S_imm",
  /* 1128 */  "Repl4I",
  /* 1129 */  "Repl4I_mem",
  /* 1130 */  "Repl8I",
  /* 1131 */  "Repl8I_mem",
  /* 1132 */  "Repl16I",
  /* 1133 */  "Repl16I_mem",
  /* 1134 */  "Repl4I_imm",
  /* 1135 */  "Repl8I_imm",
  /* 1136 */  "Repl16I_imm",
  /* 1137 */  "Repl2L_mem",
  /* 1138 */  "Repl4L",
  /* 1139 */  "Repl8L",
  /* 1140 */  "Repl4L_imm",
  /* 1141 */  "Repl8L_imm",
  /* 1142 */  "Repl4L_mem",
  /* 1143 */  "Repl8L_mem",
  /* 1144 */  "Repl2F_mem",
  /* 1145 */  "Repl4F_mem",
  /* 1146 */  "Repl8F",
  /* 1147 */  "Repl8F_mem",
  /* 1148 */  "Repl16F",
  /* 1149 */  "Repl16F_mem",
  /* 1150 */  "Repl2F_zero",
  /* 1151 */  "Repl4F_zero",
  /* 1152 */  "Repl8F_zero",
  /* 1153 */  "Repl2D_mem",
  /* 1154 */  "Repl4D",
  /* 1155 */  "Repl4D_mem",
  /* 1156 */  "Repl8D",
  /* 1157 */  "Repl8D_mem",
  /* 1158 */  "Repl2D_zero",
  /* 1159 */  "Repl4D_zero",
  /* 1160 */  "Repl4B",
  /* 1161 */  "Repl8B",
  /* 1162 */  "Repl4B_imm",
  /* 1163 */  "Repl8B_imm",
  /* 1164 */  "Repl4B_zero",
  /* 1165 */  "Repl8B_zero",
  /* 1166 */  "Repl16B_zero",
  /* 1167 */  "Repl32B_zero",
  /* 1168 */  "Repl2S",
  /* 1169 */  "Repl2S_imm",
  /* 1170 */  "Repl4S_imm",
  /* 1171 */  "Repl2S_zero",
  /* 1172 */  "Repl4S_zero",
  /* 1173 */  "Repl8S_zero",
  /* 1174 */  "Repl16S_zero",
  /* 1175 */  "Repl2I",
  /* 1176 */  "Repl2I_mem",
  /* 1177 */  "Repl2I_imm",
  /* 1178 */  "Repl2I_zero",
  /* 1179 */  "Repl4I_zero",
  /* 1180 */  "Repl8I_zero",
  /* 1181 */  "Repl2L",
  /* 1182 */  "Repl2L_imm",
  /* 1183 */  "Repl2L_zero",
  /* 1184 */  "Repl4L_zero",
  /* 1185 */  "Repl2F",
  /* 1186 */  "Repl4F",
  /* 1187 */  "Repl2D",
  /* 1188 */  "Repl4B_mem_evex",
  /* 1189 */  "Repl8B_mem_evex",
  /* 1190 */  "Repl16B_evex",
  /* 1191 */  "Repl16B_mem_evex",
  /* 1192 */  "Repl32B_evex",
  /* 1193 */  "Repl32B_mem_evex",
  /* 1194 */  "Repl64B_evex",
  /* 1195 */  "Repl64B_mem_evex",
  /* 1196 */  "Repl16B_imm_evex",
  /* 1197 */  "Repl32B_imm_evex",
  /* 1198 */  "Repl64B_imm_evex",
  /* 1199 */  "Repl64B_zero_evex",
  /* 1200 */  "Repl4S_evex",
  /* 1201 */  "Repl4S_mem_evex",
  /* 1202 */  "Repl8S_evex",
  /* 1203 */  "Repl8S_mem_evex",
  /* 1204 */  "Repl16S_evex",
  /* 1205 */  "Repl16S_mem_evex",
  /* 1206 */  "Repl32S_evex",
  /* 1207 */  "Repl32S_mem_evex",
  /* 1208 */  "Repl8S_imm_evex",
  /* 1209 */  "Repl16S_imm_evex",
  /* 1210 */  "Repl32S_imm_evex",
  /* 1211 */  "Repl32S_zero_evex",
  /* 1212 */  "Repl4I_evex",
  /* 1213 */  "Repl4I_mem_evex",
  /* 1214 */  "Repl8I_evex",
  /* 1215 */  "Repl8I_mem_evex",
  /* 1216 */  "Repl16I_evex",
  /* 1217 */  "Repl16I_mem_evex",
  /* 1218 */  "Repl4I_imm_evex",
  /* 1219 */  "Repl8I_imm_evex",
  /* 1220 */  "Repl16I_imm_evex",
  /* 1221 */  "Repl16I_zero_evex",
  /* 1222 */  "Repl4L_evex",
  /* 1223 */  "Repl8L_evex",
  /* 1224 */  "Repl4L_imm_evex",
  /* 1225 */  "Repl8L_imm_evex",
  /* 1226 */  "Repl2L_mem_evex",
  /* 1227 */  "Repl4L_mem_evex",
  /* 1228 */  "Repl8L_mem_evex",
  /* 1229 */  "Repl8L_zero_evex",
  /* 1230 */  "Repl8F_evex",
  /* 1231 */  "Repl8F_mem_evex",
  /* 1232 */  "Repl16F_evex",
  /* 1233 */  "Repl16F_mem_evex",
  /* 1234 */  "Repl16F_zero_evex",
  /* 1235 */  "Repl4D_evex",
  /* 1236 */  "Repl4D_mem_evex",
  /* 1237 */  "Repl8D_evex",
  /* 1238 */  "Repl8D_mem_evex",
  /* 1239 */  "Repl8D_zero_evex",
  /* 1240 */  "rsadd2I_reduction_reg",
  /* 1241 */  "rvadd2I_reduction_reg",
  /* 1242 */  "rvadd2I_reduction_reg_evex",
  /* 1243 */  "rsadd4I_reduction_reg",
  /* 1244 */  "rvadd4I_reduction_reg",
  /* 1245 */  "rvadd4I_reduction_reg_evex",
  /* 1246 */  "rvadd8I_reduction_reg",
  /* 1247 */  "rvadd8I_reduction_reg_evex",
  /* 1248 */  "rvadd16I_reduction_reg_evex",
  /* 1249 */  "rvadd2L_reduction_reg",
  /* 1250 */  "rvadd4L_reduction_reg",
  /* 1251 */  "rvadd8L_reduction_reg",
  /* 1252 */  "rsadd2F_reduction_reg",
  /* 1253 */  "rvadd2F_reduction_reg",
  /* 1254 */  "rsadd4F_reduction_reg",
  /* 1255 */  "rvadd4F_reduction_reg",
  /* 1256 */  "radd8F_reduction_reg",
  /* 1257 */  "radd16F_reduction_reg",
  /* 1258 */  "rsadd2D_reduction_reg",
  /* 1259 */  "rvadd2D_reduction_reg",
  /* 1260 */  "rvadd4D_reduction_reg",
  /* 1261 */  "rvadd8D_reduction_reg",
  /* 1262 */  "rsmul2I_reduction_reg",
  /* 1263 */  "rvmul2I_reduction_reg",
  /* 1264 */  "rsmul4I_reduction_reg",
  /* 1265 */  "rvmul4I_reduction_reg",
  /* 1266 */  "rvmul8I_reduction_reg",
  /* 1267 */  "rvmul16I_reduction_reg",
  /* 1268 */  "rvmul2L_reduction_reg",
  /* 1269 */  "rvmul4L_reduction_reg",
  /* 1270 */  "rvmul8L_reduction_reg",
  /* 1271 */  "rsmul2F_reduction",
  /* 1272 */  "rvmul2F_reduction_reg",
  /* 1273 */  "rsmul4F_reduction_reg",
  /* 1274 */  "rvmul4F_reduction_reg",
  /* 1275 */  "rvmul8F_reduction_reg",
  /* 1276 */  "rvmul16F_reduction_reg",
  /* 1277 */  "rsmul2D_reduction_reg",
  /* 1278 */  "rvmul2D_reduction_reg",
  /* 1279 */  "rvmul4D_reduction_reg",
  /* 1280 */  "rvmul8D_reduction_reg",
  /* 1281 */  "vadd4B",
  /* 1282 */  "vadd4B_reg",
  /* 1283 */  "vadd4B_mem",
  /* 1284 */  "vadd4B_mem_0",
  /* 1285 */  "vadd8B",
  /* 1286 */  "vadd8B_reg",
  /* 1287 */  "vadd8B_mem",
  /* 1288 */  "vadd8B_mem_0",
  /* 1289 */  "vadd16B",
  /* 1290 */  "vadd16B_reg",
  /* 1291 */  "vadd16B_mem",
  /* 1292 */  "vadd16B_mem_0",
  /* 1293 */  "vadd32B_reg",
  /* 1294 */  "vadd32B_mem",
  /* 1295 */  "vadd32B_mem_0",
  /* 1296 */  "vadd64B_reg",
  /* 1297 */  "vadd64B_mem",
  /* 1298 */  "vadd64B_mem_0",
  /* 1299 */  "vadd2S",
  /* 1300 */  "vadd2S_reg",
  /* 1301 */  "vadd2S_mem",
  /* 1302 */  "vadd2S_mem_0",
  /* 1303 */  "vadd4S",
  /* 1304 */  "vadd4S_reg",
  /* 1305 */  "vadd4S_mem",
  /* 1306 */  "vadd4S_mem_0",
  /* 1307 */  "vadd8S",
  /* 1308 */  "vadd8S_reg",
  /* 1309 */  "vadd8S_mem",
  /* 1310 */  "vadd8S_mem_0",
  /* 1311 */  "vadd16S_reg",
  /* 1312 */  "vadd16S_mem",
  /* 1313 */  "vadd16S_mem_0",
  /* 1314 */  "vadd32S_reg",
  /* 1315 */  "vadd32S_mem",
  /* 1316 */  "vadd32S_mem_0",
  /* 1317 */  "vadd2I",
  /* 1318 */  "vadd2I_reg",
  /* 1319 */  "vadd2I_mem",
  /* 1320 */  "vadd2I_mem_0",
  /* 1321 */  "vadd4I",
  /* 1322 */  "vadd4I_reg",
  /* 1323 */  "vadd4I_mem",
  /* 1324 */  "vadd4I_mem_0",
  /* 1325 */  "vadd8I_reg",
  /* 1326 */  "vadd8I_mem",
  /* 1327 */  "vadd8I_mem_0",
  /* 1328 */  "vadd16I_reg",
  /* 1329 */  "vadd16I_mem",
  /* 1330 */  "vadd16I_mem_0",
  /* 1331 */  "vadd2L",
  /* 1332 */  "vadd2L_reg",
  /* 1333 */  "vadd2L_mem",
  /* 1334 */  "vadd2L_mem_0",
  /* 1335 */  "vadd4L_reg",
  /* 1336 */  "vadd4L_mem",
  /* 1337 */  "vadd4L_mem_0",
  /* 1338 */  "vadd8L_reg",
  /* 1339 */  "vadd8L_mem",
  /* 1340 */  "vadd8L_mem_0",
  /* 1341 */  "vadd2F",
  /* 1342 */  "vadd2F_reg",
  /* 1343 */  "vadd2F_mem",
  /* 1344 */  "vadd2F_mem_0",
  /* 1345 */  "vadd4F",
  /* 1346 */  "vadd4F_reg",
  /* 1347 */  "vadd4F_mem",
  /* 1348 */  "vadd4F_mem_0",
  /* 1349 */  "vadd8F_reg",
  /* 1350 */  "vadd8F_mem",
  /* 1351 */  "vadd8F_mem_0",
  /* 1352 */  "vadd16F_reg",
  /* 1353 */  "vadd16F_mem",
  /* 1354 */  "vadd16F_mem_0",
  /* 1355 */  "vadd2D",
  /* 1356 */  "vadd2D_reg",
  /* 1357 */  "vadd2D_mem",
  /* 1358 */  "vadd2D_mem_0",
  /* 1359 */  "vadd4D_reg",
  /* 1360 */  "vadd4D_mem",
  /* 1361 */  "vadd4D_mem_0",
  /* 1362 */  "vadd8D_reg",
  /* 1363 */  "vadd8D_mem",
  /* 1364 */  "vadd8D_mem_0",
  /* 1365 */  "vsub4B",
  /* 1366 */  "vsub4B_reg",
  /* 1367 */  "vsub4B_mem",
  /* 1368 */  "vsub8B",
  /* 1369 */  "vsub8B_reg",
  /* 1370 */  "vsub8B_mem",
  /* 1371 */  "vsub16B",
  /* 1372 */  "vsub16B_reg",
  /* 1373 */  "vsub16B_mem",
  /* 1374 */  "vsub32B_reg",
  /* 1375 */  "vsub32B_mem",
  /* 1376 */  "vsub64B_reg",
  /* 1377 */  "vsub64B_mem",
  /* 1378 */  "vsub2S",
  /* 1379 */  "vsub2S_reg",
  /* 1380 */  "vsub2S_mem",
  /* 1381 */  "vsub4S",
  /* 1382 */  "vsub4S_reg",
  /* 1383 */  "vsub4S_mem",
  /* 1384 */  "vsub8S",
  /* 1385 */  "vsub8S_reg",
  /* 1386 */  "vsub8S_mem",
  /* 1387 */  "vsub16S_reg",
  /* 1388 */  "vsub16S_mem",
  /* 1389 */  "vsub32S_reg",
  /* 1390 */  "vsub32S_mem",
  /* 1391 */  "vsub2I",
  /* 1392 */  "vsub2I_reg",
  /* 1393 */  "vsub2I_mem",
  /* 1394 */  "vsub4I",
  /* 1395 */  "vsub4I_reg",
  /* 1396 */  "vsub4I_mem",
  /* 1397 */  "vsub8I_reg",
  /* 1398 */  "vsub8I_mem",
  /* 1399 */  "vsub16I_reg",
  /* 1400 */  "vsub16I_mem",
  /* 1401 */  "vsub2L",
  /* 1402 */  "vsub2L_reg",
  /* 1403 */  "vsub2L_mem",
  /* 1404 */  "vsub4L_reg",
  /* 1405 */  "vsub4L_mem",
  /* 1406 */  "vsub8L_reg",
  /* 1407 */  "vsub8L_mem",
  /* 1408 */  "vsub2F",
  /* 1409 */  "vsub2F_reg",
  /* 1410 */  "vsub2F_mem",
  /* 1411 */  "vsub4F",
  /* 1412 */  "vsub4F_reg",
  /* 1413 */  "vsub4F_mem",
  /* 1414 */  "vsub8F_reg",
  /* 1415 */  "vsub8F_mem",
  /* 1416 */  "vsub16F_reg",
  /* 1417 */  "vsub16F_mem",
  /* 1418 */  "vsub2D",
  /* 1419 */  "vsub2D_reg",
  /* 1420 */  "vsub2D_mem",
  /* 1421 */  "vsub4D_reg",
  /* 1422 */  "vsub4D_mem",
  /* 1423 */  "vsub8D_reg",
  /* 1424 */  "vsub8D_mem",
  /* 1425 */  "mul4B_reg",
  /* 1426 */  "mul8B_reg",
  /* 1427 */  "mul16B_reg",
  /* 1428 */  "vmul16B_reg_avx",
  /* 1429 */  "vmul32B_reg_avx",
  /* 1430 */  "vmul64B_reg_avx",
  /* 1431 */  "vmul2S",
  /* 1432 */  "vmul2S_reg",
  /* 1433 */  "vmul2S_mem",
  /* 1434 */  "vmul2S_mem_0",
  /* 1435 */  "vmul4S",
  /* 1436 */  "vmul4S_reg",
  /* 1437 */  "vmul4S_mem",
  /* 1438 */  "vmul4S_mem_0",
  /* 1439 */  "vmul8S",
  /* 1440 */  "vmul8S_reg",
  /* 1441 */  "vmul8S_mem",
  /* 1442 */  "vmul8S_mem_0",
  /* 1443 */  "vmul16S_reg",
  /* 1444 */  "vmul16S_mem",
  /* 1445 */  "vmul16S_mem_0",
  /* 1446 */  "vmul32S_reg",
  /* 1447 */  "vmul32S_mem",
  /* 1448 */  "vmul32S_mem_0",
  /* 1449 */  "vmul2I",
  /* 1450 */  "vmul2I_reg",
  /* 1451 */  "vmul2I_mem",
  /* 1452 */  "vmul2I_mem_0",
  /* 1453 */  "vmul4I",
  /* 1454 */  "vmul4I_reg",
  /* 1455 */  "vmul4I_mem",
  /* 1456 */  "vmul4I_mem_0",
  /* 1457 */  "vmul2L_reg",
  /* 1458 */  "vmul2L_mem",
  /* 1459 */  "vmul2L_mem_0",
  /* 1460 */  "vmul4L_reg",
  /* 1461 */  "vmul4L_mem",
  /* 1462 */  "vmul4L_mem_0",
  /* 1463 */  "vmul8L_reg",
  /* 1464 */  "vmul8L_mem",
  /* 1465 */  "vmul8L_mem_0",
  /* 1466 */  "vmul8I_reg",
  /* 1467 */  "vmul8I_mem",
  /* 1468 */  "vmul8I_mem_0",
  /* 1469 */  "vmul16I_reg",
  /* 1470 */  "vmul16I_mem",
  /* 1471 */  "vmul16I_mem_0",
  /* 1472 */  "vmul2F",
  /* 1473 */  "vmul2F_reg",
  /* 1474 */  "vmul2F_mem",
  /* 1475 */  "vmul2F_mem_0",
  /* 1476 */  "vmul4F",
  /* 1477 */  "vmul4F_reg",
  /* 1478 */  "vmul4F_mem",
  /* 1479 */  "vmul4F_mem_0",
  /* 1480 */  "vmul8F_reg",
  /* 1481 */  "vmul8F_mem",
  /* 1482 */  "vmul8F_mem_0",
  /* 1483 */  "vmul16F_reg",
  /* 1484 */  "vmul16F_mem",
  /* 1485 */  "vmul16F_mem_0",
  /* 1486 */  "vmul2D",
  /* 1487 */  "vmul2D_reg",
  /* 1488 */  "vmul2D_mem",
  /* 1489 */  "vmul2D_mem_0",
  /* 1490 */  "vmul4D_reg",
  /* 1491 */  "vmul4D_mem",
  /* 1492 */  "vmul4D_mem_0",
  /* 1493 */  "vmul8D_reg",
  /* 1494 */  "vmul8D_mem",
  /* 1495 */  "vmul8D_mem_0",
  /* 1496 */  "vcmov8F_reg",
  /* 1497 */  "vcmov4D_reg",
  /* 1498 */  "vdiv2F",
  /* 1499 */  "vdiv2F_reg",
  /* 1500 */  "vdiv2F_mem",
  /* 1501 */  "vdiv4F",
  /* 1502 */  "vdiv4F_reg",
  /* 1503 */  "vdiv4F_mem",
  /* 1504 */  "vdiv8F_reg",
  /* 1505 */  "vdiv8F_mem",
  /* 1506 */  "vdiv16F_reg",
  /* 1507 */  "vdiv16F_mem",
  /* 1508 */  "vdiv2D",
  /* 1509 */  "vdiv2D_reg",
  /* 1510 */  "vdiv2D_mem",
  /* 1511 */  "vdiv4D_reg",
  /* 1512 */  "vdiv4D_mem",
  /* 1513 */  "vdiv8D_reg",
  /* 1514 */  "vdiv8D_mem",
  /* 1515 */  "vshift4B",
  /* 1516 */  "vshift4B_0",
  /* 1517 */  "vshift4B_1",
  /* 1518 */  "vshift8B",
  /* 1519 */  "vshift8B_0",
  /* 1520 */  "vshift8B_1",
  /* 1521 */  "vshift16B",
  /* 1522 */  "vshift16B_0",
  /* 1523 */  "vshift16B_1",
  /* 1524 */  "vshift16B_avx",
  /* 1525 */  "vshift16B_avx_0",
  /* 1526 */  "vshift16B_avx_1",
  /* 1527 */  "vshift32B_avx",
  /* 1528 */  "vshift32B_avx_0",
  /* 1529 */  "vshift32B_avx_1",
  /* 1530 */  "vshift64B_avx",
  /* 1531 */  "vshift64B_avx_0",
  /* 1532 */  "vshift64B_avx_1",
  /* 1533 */  "vshist2S",
  /* 1534 */  "vshist2S_0",
  /* 1535 */  "vshist2S_1",
  /* 1536 */  "vshift4S",
  /* 1537 */  "vshift4S_0",
  /* 1538 */  "vshift4S_1",
  /* 1539 */  "vshift8S",
  /* 1540 */  "vshift8S_0",
  /* 1541 */  "vshift8S_1",
  /* 1542 */  "vshift16S",
  /* 1543 */  "vshift16S_0",
  /* 1544 */  "vshift16S_1",
  /* 1545 */  "vshift32S",
  /* 1546 */  "vshift32S_0",
  /* 1547 */  "vshift32S_1",
  /* 1548 */  "vshift2I",
  /* 1549 */  "vshift2I_0",
  /* 1550 */  "vshift2I_1",
  /* 1551 */  "vshift4I",
  /* 1552 */  "vshift4I_0",
  /* 1553 */  "vshift4I_1",
  /* 1554 */  "vshift8I",
  /* 1555 */  "vshift8I_0",
  /* 1556 */  "vshift8I_1",
  /* 1557 */  "vshift16I",
  /* 1558 */  "vshift16I_0",
  /* 1559 */  "vshift16I_1",
  /* 1560 */  "vshift2L",
  /* 1561 */  "vshift2L_0",
  /* 1562 */  "vshift4L",
  /* 1563 */  "vshift4L_0",
  /* 1564 */  "vshift8L",
  /* 1565 */  "vshift8L_0",
  /* 1566 */  "vshift8L_1",
  /* 1567 */  "vsra2L_reg",
  /* 1568 */  "vsra2L_reg_evex",
  /* 1569 */  "vsra4L_reg",
  /* 1570 */  "vsra4L_reg_evex",
  /* 1571 */  "vand4B",
  /* 1572 */  "vand4B_reg",
  /* 1573 */  "vand4B_mem",
  /* 1574 */  "vand4B_mem_0",
  /* 1575 */  "vand8B",
  /* 1576 */  "vand8B_reg",
  /* 1577 */  "vand8B_mem",
  /* 1578 */  "vand8B_mem_0",
  /* 1579 */  "vand16B",
  /* 1580 */  "vand16B_reg",
  /* 1581 */  "vand16B_mem",
  /* 1582 */  "vand16B_mem_0",
  /* 1583 */  "vand32B_reg",
  /* 1584 */  "vand32B_mem",
  /* 1585 */  "vand32B_mem_0",
  /* 1586 */  "vand64B_reg",
  /* 1587 */  "vand64B_mem",
  /* 1588 */  "vand64B_mem_0",
  /* 1589 */  "vor4B",
  /* 1590 */  "vor4B_reg",
  /* 1591 */  "vor4B_mem",
  /* 1592 */  "vor4B_mem_0",
  /* 1593 */  "vor8B",
  /* 1594 */  "vor8B_reg",
  /* 1595 */  "vor8B_mem",
  /* 1596 */  "vor8B_mem_0",
  /* 1597 */  "vor16B",
  /* 1598 */  "vor16B_reg",
  /* 1599 */  "vor16B_mem",
  /* 1600 */  "vor16B_mem_0",
  /* 1601 */  "vor32B_reg",
  /* 1602 */  "vor32B_mem",
  /* 1603 */  "vor32B_mem_0",
  /* 1604 */  "vor64B_reg",
  /* 1605 */  "vor64B_mem",
  /* 1606 */  "vor64B_mem_0",
  /* 1607 */  "vxor4B",
  /* 1608 */  "vxor4B_reg",
  /* 1609 */  "vxor4B_mem",
  /* 1610 */  "vxor4B_mem_0",
  /* 1611 */  "vxor8B",
  /* 1612 */  "vxor8B_reg",
  /* 1613 */  "vxor8B_mem",
  /* 1614 */  "vxor8B_mem_0",
  /* 1615 */  "vxor16B",
  /* 1616 */  "vxor16B_reg",
  /* 1617 */  "vxor16B_mem",
  /* 1618 */  "vxor16B_mem_0",
  /* 1619 */  "vxor32B_reg",
  /* 1620 */  "vxor32B_mem",
  /* 1621 */  "vxor32B_mem_0",
  /* 1622 */  "vxor64B_reg",
  /* 1623 */  "vxor64B_mem",
  /* 1624 */  "vxor64B_mem_0",
  /* 1625 */  "vabsneg2D",
  /* 1626 */  "vabsneg2D_0",
  /* 1627 */  "vabsneg4D",
  /* 1628 */  "vabsneg4D_0",
  /* 1629 */  "vabsneg8D",
  /* 1630 */  "vabsneg8D_0",
  /* 1631 */  "vabsneg2F",
  /* 1632 */  "vabsneg2F_0",
  /* 1633 */  "vabsneg4F",
  /* 1634 */  "vabsneg4F_0",
  /* 1635 */  "vabsneg8F",
  /* 1636 */  "vabsneg8F_0",
  /* 1637 */  "vabsneg16F",
  /* 1638 */  "vabsneg16F_0",
  /* 1639 */  "vfma2D_reg",
  /* 1640 */  "vfma2D_mem",
  /* 1641 */  "vfma4D_reg",
  /* 1642 */  "vfma4D_mem",
  /* 1643 */  "vfma8D_reg",
  /* 1644 */  "vfma8D_mem",
  /* 1645 */  "vfma4F_reg",
  /* 1646 */  "vfma4F_mem",
  /* 1647 */  "vfma8F_reg",
  /* 1648 */  "vfma8F_mem",
  /* 1649 */  "vfma16F_reg",
  /* 1650 */  "vfma16F_mem",
  /* 1651 */  "compareAndSwapP_shenandoah",
  /* 1652 */  "compareAndSwapP_shenandoah_0",
  /* 1653 */  "compareAndSwapN_shenandoah",
  /* 1654 */  "compareAndSwapN_shenandoah_0",
  /* 1655 */  "compareAndExchangeN_shenandoah",
  /* 1656 */  "compareAndExchangeP_shenandoah",
  // last instruction
  "invalid rule name" // no trailing comma
};

const        bool  swallowed[] = {
  /*    0 */  false,
  /*    1 */  false,
  /*    2 */  false,
  /*    3 */  false,
  /*    4 */  false,
  /*    5 */  false,
  /*    6 */  false,
  /*    7 */  false,
  /*    8 */  true,
  /*    9 */  true,
  /*   10 */  true,
  /*   11 */  true,
  /*   12 */  true,
  /*   13 */  true,
  /*   14 */  true,
  /*   15 */  true,
  /*   16 */  true,
  /*   17 */  true,
  /*   18 */  true,
  /*   19 */  true,
  /*   20 */  true,
  /*   21 */  true,
  /*   22 */  true,
  /*   23 */  true,
  /*   24 */  true,
  /*   25 */  true,
  /*   26 */  true,
  /*   27 */  true,
  /*   28 */  true,
  /*   29 */  true,
  /*   30 */  true,
  /*   31 */  true,
  /*   32 */  true,
  /*   33 */  true,
  /*   34 */  true,
  /*   35 */  true,
  /*   36 */  true,
  /*   37 */  true,
  /*   38 */  true,
  /*   39 */  true,
  /*   40 */  true,
  /*   41 */  true,
  /*   42 */  true,
  /*   43 */  true,
  /*   44 */  true,
  /*   45 */  false,
  /*   46 */  false,
  /*   47 */  false,
  /*   48 */  false,
  /*   49 */  false,
  /*   50 */  false,
  /*   51 */  false,
  /*   52 */  false,
  /*   53 */  false,
  /*   54 */  false,
  /*   55 */  false,
  /*   56 */  false,
  /*   57 */  false,
  /*   58 */  false,
  /*   59 */  false,
  /*   60 */  false,
  /*   61 */  false,
  /*   62 */  false,
  /*   63 */  false,
  /*   64 */  false,
  /*   65 */  false,
  /*   66 */  false,
  /*   67 */  false,
  /*   68 */  false,
  /*   69 */  false,
  /*   70 */  false,
  /*   71 */  false,
  /*   72 */  false,
  /*   73 */  false,
  /*   74 */  false,
  /*   75 */  false,
  /*   76 */  false,
  /*   77 */  false,
  /*   78 */  false,
  /*   79 */  false,
  /*   80 */  false,
  /*   81 */  false,
  /*   82 */  false,
  /*   83 */  false,
  /*   84 */  false,
  /*   85 */  false,
  /*   86 */  false,
  /*   87 */  false,
  /*   88 */  false,
  /*   89 */  false,
  /*   90 */  false,
  /*   91 */  false,
  /*   92 */  false,
  /*   93 */  false,
  /*   94 */  false,
  /*   95 */  false,
  /*   96 */  false,
  /*   97 */  false,
  /*   98 */  false,
  /*   99 */  false,
  /*  100 */  false,
  /*  101 */  false,
  /*  102 */  false,
  /*  103 */  false,
  /*  104 */  false,
  /*  105 */  false,
  /*  106 */  false,
  /*  107 */  false,
  /*  108 */  false,
  /*  109 */  false,
  /*  110 */  false,
  /*  111 */  false,
  /*  112 */  false,
  /*  113 */  false,
  /*  114 */  false,
  /*  115 */  true,
  /*  116 */  true,
  /*  117 */  true,
  /*  118 */  true,
  /*  119 */  false,
  /*  120 */  false,
  /*  121 */  false,
  /*  122 */  false,
  /*  123 */  false,
  /*  124 */  false,
  /*  125 */  false,
  /*  126 */  false,
  /*  127 */  false,
  /*  128 */  false,
  /*  129 */  false,
  /*  130 */  false,
  /*  131 */  false,
  /*  132 */  false,
  /*  133 */  false,
  /*  134 */  false,
  /*  135 */  false,
  /*  136 */  false,
  /*  137 */  false,
  /*  138 */  false,
  /*  139 */  false,
  /*  140 */  false,
  /*  141 */  false,
  /*  142 */  false,
  /*  143 */  false,
  /*  144 */  false,
  /*  145 */  false,
  /*  146 */  false,
  /*  147 */  false,
  /*  148 */  false,
  /*  149 */  false,
  /*  150 */  false,
  /*  151 */  false,
  /*  152 */  false,
  /*  153 */  true,
  // last operand
  /*  154 */  false,
  // last operand class
  /*  155 */  false,
  /*  156 */  false,
  /*  157 */  false,
  /*  158 */  false,
  /*  159 */  false,
  /*  160 */  false,
  /*  161 */  false,
  /*  162 */  false,
  /*  163 */  false,
  /*  164 */  false,
  /*  165 */  false,
  /*  166 */  false,
  /*  167 */  false,
  /*  168 */  false,
  /*  169 */  false,
  /*  170 */  false,
  /*  171 */  false,
  /*  172 */  false,
  /*  173 */  false,
  /*  174 */  false,
  /*  175 */  false,
  /*  176 */  false,
  /*  177 */  false,
  /*  178 */  false,
  /*  179 */  false,
  /*  180 */  false,
  /*  181 */  false,
  /*  182 */  false,
  /*  183 */  false,
  /*  184 */  false,
  /*  185 */  false,
  /*  186 */  false,
  /*  187 */  false,
  /*  188 */  false,
  /*  189 */  false,
  /*  190 */  false,
  /*  191 */  false,
  /*  192 */  false,
  /*  193 */  false,
  /*  194 */  false,
  /*  195 */  false,
  /*  196 */  false,
  /*  197 */  false,
  /*  198 */  false,
  /*  199 */  false,
  /*  200 */  false,
  /*  201 */  false,
  /*  202 */  false,
  /*  203 */  false,
  /*  204 */  false,
  /*  205 */  false,
  /*  206 */  false,
  /*  207 */  false,
  /*  208 */  false,
  /*  209 */  false,
  /*  210 */  false,
  /*  211 */  false,
  /*  212 */  false,
  /*  213 */  false,
  /*  214 */  false,
  /*  215 */  false,
  /*  216 */  false,
  /*  217 */  false,
  /*  218 */  false,
  /*  219 */  false,
  /*  220 */  false,
  /*  221 */  false,
  /*  222 */  false,
  /*  223 */  false,
  /*  224 */  false,
  /*  225 */  false,
  /*  226 */  false,
  /*  227 */  false,
  /*  228 */  false,
  /*  229 */  false,
  /*  230 */  false,
  /*  231 */  false,
  /*  232 */  false,
  /*  233 */  false,
  /*  234 */  false,
  /*  235 */  false,
  /*  236 */  false,
  /*  237 */  false,
  /*  238 */  false,
  /*  239 */  false,
  /*  240 */  false,
  /*  241 */  false,
  /*  242 */  false,
  /*  243 */  false,
  /*  244 */  false,
  /*  245 */  false,
  /*  246 */  false,
  /*  247 */  false,
  /*  248 */  false,
  /*  249 */  false,
  /*  250 */  false,
  /*  251 */  false,
  /*  252 */  false,
  /*  253 */  false,
  /*  254 */  false,
  /*  255 */  false,
  /*  256 */  false,
  /*  257 */  false,
  /*  258 */  false,
  /*  259 */  false,
  /*  260 */  false,
  /*  261 */  false,
  /*  262 */  false,
  /*  263 */  false,
  /*  264 */  false,
  /*  265 */  false,
  /*  266 */  false,
  /*  267 */  false,
  /*  268 */  false,
  /*  269 */  false,
  /*  270 */  false,
  /*  271 */  false,
  /*  272 */  false,
  /*  273 */  false,
  /*  274 */  false,
  /*  275 */  false,
  /*  276 */  false,
  /*  277 */  false,
  /*  278 */  false,
  /*  279 */  false,
  /*  280 */  false,
  /*  281 */  false,
  /*  282 */  false,
  /*  283 */  false,
  /*  284 */  false,
  /*  285 */  false,
  /*  286 */  false,
  /*  287 */  false,
  /*  288 */  false,
  /*  289 */  false,
  /*  290 */  false,
  /*  291 */  false,
  /*  292 */  false,
  /*  293 */  false,
  /*  294 */  false,
  /*  295 */  false,
  /*  296 */  false,
  /*  297 */  false,
  /*  298 */  false,
  /*  299 */  false,
  /*  300 */  false,
  /*  301 */  false,
  /*  302 */  false,
  /*  303 */  false,
  /*  304 */  false,
  /*  305 */  false,
  /*  306 */  false,
  /*  307 */  false,
  /*  308 */  false,
  /*  309 */  false,
  /*  310 */  false,
  /*  311 */  false,
  /*  312 */  false,
  /*  313 */  false,
  /*  314 */  false,
  /*  315 */  false,
  /*  316 */  false,
  /*  317 */  false,
  /*  318 */  false,
  /*  319 */  false,
  /*  320 */  false,
  /*  321 */  false,
  // last internally defined operand
  /*  322 */  false,
  /*  323 */  false,
  /*  324 */  false,
  /*  325 */  false,
  /*  326 */  false,
  /*  327 */  false,
  /*  328 */  false,
  /*  329 */  false,
  /*  330 */  false,
  /*  331 */  false,
  /*  332 */  false,
  /*  333 */  false,
  /*  334 */  false,
  /*  335 */  false,
  /*  336 */  false,
  /*  337 */  false,
  /*  338 */  false,
  /*  339 */  false,
  /*  340 */  false,
  /*  341 */  false,
  /*  342 */  false,
  /*  343 */  false,
  /*  344 */  false,
  /*  345 */  false,
  /*  346 */  false,
  /*  347 */  false,
  /*  348 */  false,
  /*  349 */  false,
  /*  350 */  false,
  /*  351 */  false,
  /*  352 */  false,
  /*  353 */  false,
  /*  354 */  false,
  /*  355 */  false,
  /*  356 */  false,
  /*  357 */  false,
  /*  358 */  false,
  /*  359 */  false,
  /*  360 */  false,
  /*  361 */  false,
  /*  362 */  false,
  /*  363 */  false,
  /*  364 */  false,
  /*  365 */  false,
  /*  366 */  false,
  /*  367 */  false,
  /*  368 */  false,
  /*  369 */  false,
  /*  370 */  false,
  /*  371 */  false,
  /*  372 */  false,
  /*  373 */  false,
  /*  374 */  false,
  /*  375 */  false,
  /*  376 */  false,
  /*  377 */  false,
  /*  378 */  false,
  /*  379 */  false,
  /*  380 */  false,
  /*  381 */  false,
  /*  382 */  false,
  /*  383 */  false,
  /*  384 */  false,
  /*  385 */  false,
  /*  386 */  false,
  /*  387 */  false,
  /*  388 */  false,
  /*  389 */  false,
  /*  390 */  false,
  /*  391 */  false,
  /*  392 */  false,
  /*  393 */  false,
  /*  394 */  false,
  /*  395 */  false,
  /*  396 */  false,
  /*  397 */  false,
  /*  398 */  false,
  /*  399 */  false,
  /*  400 */  false,
  /*  401 */  false,
  /*  402 */  false,
  /*  403 */  false,
  /*  404 */  false,
  /*  405 */  false,
  /*  406 */  false,
  /*  407 */  false,
  /*  408 */  false,
  /*  409 */  false,
  /*  410 */  false,
  /*  411 */  false,
  /*  412 */  false,
  /*  413 */  false,
  /*  414 */  false,
  /*  415 */  false,
  /*  416 */  false,
  /*  417 */  false,
  /*  418 */  false,
  /*  419 */  false,
  /*  420 */  false,
  /*  421 */  false,
  /*  422 */  false,
  /*  423 */  false,
  /*  424 */  false,
  /*  425 */  false,
  /*  426 */  false,
  /*  427 */  false,
  /*  428 */  false,
  /*  429 */  false,
  /*  430 */  false,
  /*  431 */  false,
  /*  432 */  false,
  /*  433 */  false,
  /*  434 */  false,
  /*  435 */  false,
  /*  436 */  false,
  /*  437 */  false,
  /*  438 */  false,
  /*  439 */  false,
  /*  440 */  false,
  /*  441 */  false,
  /*  442 */  false,
  /*  443 */  false,
  /*  444 */  false,
  /*  445 */  false,
  /*  446 */  false,
  /*  447 */  false,
  /*  448 */  false,
  /*  449 */  false,
  /*  450 */  false,
  /*  451 */  false,
  /*  452 */  false,
  /*  453 */  false,
  /*  454 */  false,
  /*  455 */  false,
  /*  456 */  false,
  /*  457 */  false,
  /*  458 */  false,
  /*  459 */  false,
  /*  460 */  false,
  /*  461 */  false,
  /*  462 */  false,
  /*  463 */  false,
  /*  464 */  false,
  /*  465 */  false,
  /*  466 */  false,
  /*  467 */  false,
  /*  468 */  false,
  /*  469 */  false,
  /*  470 */  false,
  /*  471 */  false,
  /*  472 */  false,
  /*  473 */  false,
  /*  474 */  false,
  /*  475 */  false,
  /*  476 */  false,
  /*  477 */  false,
  /*  478 */  false,
  /*  479 */  false,
  /*  480 */  false,
  /*  481 */  false,
  /*  482 */  false,
  /*  483 */  false,
  /*  484 */  false,
  /*  485 */  false,
  /*  486 */  false,
  /*  487 */  false,
  /*  488 */  false,
  /*  489 */  false,
  /*  490 */  false,
  /*  491 */  false,
  /*  492 */  false,
  /*  493 */  false,
  /*  494 */  false,
  /*  495 */  false,
  /*  496 */  false,
  /*  497 */  false,
  /*  498 */  false,
  /*  499 */  false,
  /*  500 */  false,
  /*  501 */  false,
  /*  502 */  false,
  /*  503 */  false,
  /*  504 */  false,
  /*  505 */  false,
  /*  506 */  false,
  /*  507 */  false,
  /*  508 */  false,
  /*  509 */  false,
  /*  510 */  false,
  /*  511 */  false,
  /*  512 */  false,
  /*  513 */  false,
  /*  514 */  false,
  /*  515 */  false,
  /*  516 */  false,
  /*  517 */  false,
  /*  518 */  false,
  /*  519 */  false,
  /*  520 */  false,
  /*  521 */  false,
  /*  522 */  false,
  /*  523 */  false,
  /*  524 */  false,
  /*  525 */  false,
  /*  526 */  false,
  /*  527 */  false,
  /*  528 */  false,
  /*  529 */  false,
  /*  530 */  false,
  /*  531 */  false,
  /*  532 */  false,
  /*  533 */  false,
  /*  534 */  false,
  /*  535 */  false,
  /*  536 */  false,
  /*  537 */  false,
  /*  538 */  false,
  /*  539 */  false,
  /*  540 */  false,
  /*  541 */  false,
  /*  542 */  false,
  /*  543 */  false,
  /*  544 */  false,
  /*  545 */  false,
  /*  546 */  false,
  /*  547 */  false,
  /*  548 */  false,
  /*  549 */  false,
  /*  550 */  false,
  /*  551 */  false,
  /*  552 */  false,
  /*  553 */  false,
  /*  554 */  false,
  /*  555 */  false,
  /*  556 */  false,
  /*  557 */  false,
  /*  558 */  false,
  /*  559 */  false,
  /*  560 */  false,
  /*  561 */  false,
  /*  562 */  false,
  /*  563 */  false,
  /*  564 */  false,
  /*  565 */  false,
  /*  566 */  false,
  /*  567 */  false,
  /*  568 */  false,
  /*  569 */  false,
  /*  570 */  false,
  /*  571 */  false,
  /*  572 */  false,
  /*  573 */  false,
  /*  574 */  false,
  /*  575 */  false,
  /*  576 */  false,
  /*  577 */  false,
  /*  578 */  false,
  /*  579 */  false,
  /*  580 */  false,
  /*  581 */  false,
  /*  582 */  false,
  /*  583 */  false,
  /*  584 */  false,
  /*  585 */  false,
  /*  586 */  false,
  /*  587 */  false,
  /*  588 */  false,
  /*  589 */  false,
  /*  590 */  false,
  /*  591 */  false,
  /*  592 */  false,
  /*  593 */  false,
  /*  594 */  false,
  /*  595 */  false,
  /*  596 */  false,
  /*  597 */  false,
  /*  598 */  false,
  /*  599 */  false,
  /*  600 */  false,
  /*  601 */  false,
  /*  602 */  false,
  /*  603 */  false,
  /*  604 */  false,
  /*  605 */  false,
  /*  606 */  false,
  /*  607 */  false,
  /*  608 */  false,
  /*  609 */  false,
  /*  610 */  false,
  /*  611 */  false,
  /*  612 */  false,
  /*  613 */  false,
  /*  614 */  false,
  /*  615 */  false,
  /*  616 */  false,
  /*  617 */  false,
  /*  618 */  false,
  /*  619 */  false,
  /*  620 */  false,
  /*  621 */  false,
  /*  622 */  false,
  /*  623 */  false,
  /*  624 */  false,
  /*  625 */  false,
  /*  626 */  false,
  /*  627 */  false,
  /*  628 */  false,
  /*  629 */  false,
  /*  630 */  false,
  /*  631 */  false,
  /*  632 */  false,
  /*  633 */  false,
  /*  634 */  false,
  /*  635 */  false,
  /*  636 */  false,
  /*  637 */  false,
  /*  638 */  false,
  /*  639 */  false,
  /*  640 */  false,
  /*  641 */  false,
  /*  642 */  false,
  /*  643 */  false,
  /*  644 */  false,
  /*  645 */  false,
  /*  646 */  false,
  /*  647 */  false,
  /*  648 */  false,
  /*  649 */  false,
  /*  650 */  false,
  /*  651 */  false,
  /*  652 */  false,
  /*  653 */  false,
  /*  654 */  false,
  /*  655 */  false,
  /*  656 */  false,
  /*  657 */  false,
  /*  658 */  false,
  /*  659 */  false,
  /*  660 */  false,
  /*  661 */  false,
  /*  662 */  false,
  /*  663 */  false,
  /*  664 */  false,
  /*  665 */  false,
  /*  666 */  false,
  /*  667 */  false,
  /*  668 */  false,
  /*  669 */  false,
  /*  670 */  false,
  /*  671 */  false,
  /*  672 */  false,
  /*  673 */  false,
  /*  674 */  false,
  /*  675 */  false,
  /*  676 */  false,
  /*  677 */  false,
  /*  678 */  false,
  /*  679 */  false,
  /*  680 */  false,
  /*  681 */  false,
  /*  682 */  false,
  /*  683 */  false,
  /*  684 */  false,
  /*  685 */  false,
  /*  686 */  false,
  /*  687 */  false,
  /*  688 */  false,
  /*  689 */  false,
  /*  690 */  false,
  /*  691 */  false,
  /*  692 */  false,
  /*  693 */  false,
  /*  694 */  false,
  /*  695 */  false,
  /*  696 */  false,
  /*  697 */  false,
  /*  698 */  false,
  /*  699 */  false,
  /*  700 */  false,
  /*  701 */  false,
  /*  702 */  false,
  /*  703 */  false,
  /*  704 */  false,
  /*  705 */  false,
  /*  706 */  false,
  /*  707 */  false,
  /*  708 */  false,
  /*  709 */  false,
  /*  710 */  false,
  /*  711 */  false,
  /*  712 */  false,
  /*  713 */  false,
  /*  714 */  false,
  /*  715 */  false,
  /*  716 */  false,
  /*  717 */  false,
  /*  718 */  false,
  /*  719 */  false,
  /*  720 */  false,
  /*  721 */  false,
  /*  722 */  false,
  /*  723 */  false,
  /*  724 */  false,
  /*  725 */  false,
  /*  726 */  false,
  /*  727 */  false,
  /*  728 */  false,
  /*  729 */  false,
  /*  730 */  false,
  /*  731 */  false,
  /*  732 */  false,
  /*  733 */  false,
  /*  734 */  false,
  /*  735 */  false,
  /*  736 */  false,
  /*  737 */  false,
  /*  738 */  false,
  /*  739 */  false,
  /*  740 */  false,
  /*  741 */  false,
  /*  742 */  false,
  /*  743 */  false,
  /*  744 */  false,
  /*  745 */  false,
  /*  746 */  false,
  /*  747 */  false,
  /*  748 */  false,
  /*  749 */  false,
  /*  750 */  false,
  /*  751 */  false,
  /*  752 */  false,
  /*  753 */  false,
  /*  754 */  false,
  /*  755 */  false,
  /*  756 */  false,
  /*  757 */  false,
  /*  758 */  false,
  /*  759 */  false,
  /*  760 */  false,
  /*  761 */  false,
  /*  762 */  false,
  /*  763 */  false,
  /*  764 */  false,
  /*  765 */  false,
  /*  766 */  false,
  /*  767 */  false,
  /*  768 */  false,
  /*  769 */  false,
  /*  770 */  false,
  /*  771 */  false,
  /*  772 */  false,
  /*  773 */  false,
  /*  774 */  false,
  /*  775 */  false,
  /*  776 */  false,
  /*  777 */  false,
  /*  778 */  false,
  /*  779 */  false,
  /*  780 */  false,
  /*  781 */  false,
  /*  782 */  false,
  /*  783 */  false,
  /*  784 */  false,
  /*  785 */  false,
  /*  786 */  false,
  /*  787 */  false,
  /*  788 */  false,
  /*  789 */  false,
  /*  790 */  false,
  /*  791 */  false,
  /*  792 */  false,
  /*  793 */  false,
  /*  794 */  false,
  /*  795 */  false,
  /*  796 */  false,
  /*  797 */  false,
  /*  798 */  false,
  /*  799 */  false,
  /*  800 */  false,
  /*  801 */  false,
  /*  802 */  false,
  /*  803 */  false,
  /*  804 */  false,
  /*  805 */  false,
  /*  806 */  false,
  /*  807 */  false,
  /*  808 */  false,
  /*  809 */  false,
  /*  810 */  false,
  /*  811 */  false,
  /*  812 */  false,
  /*  813 */  false,
  /*  814 */  false,
  /*  815 */  false,
  /*  816 */  false,
  /*  817 */  false,
  /*  818 */  false,
  /*  819 */  false,
  /*  820 */  false,
  /*  821 */  false,
  /*  822 */  false,
  /*  823 */  false,
  /*  824 */  false,
  /*  825 */  false,
  /*  826 */  false,
  /*  827 */  false,
  /*  828 */  false,
  /*  829 */  false,
  /*  830 */  false,
  /*  831 */  false,
  /*  832 */  false,
  /*  833 */  false,
  /*  834 */  false,
  /*  835 */  false,
  /*  836 */  false,
  /*  837 */  false,
  /*  838 */  false,
  /*  839 */  false,
  /*  840 */  false,
  /*  841 */  false,
  /*  842 */  false,
  /*  843 */  false,
  /*  844 */  false,
  /*  845 */  false,
  /*  846 */  false,
  /*  847 */  false,
  /*  848 */  false,
  /*  849 */  false,
  /*  850 */  false,
  /*  851 */  false,
  /*  852 */  false,
  /*  853 */  false,
  /*  854 */  false,
  /*  855 */  false,
  /*  856 */  false,
  /*  857 */  false,
  /*  858 */  false,
  /*  859 */  false,
  /*  860 */  false,
  /*  861 */  false,
  /*  862 */  false,
  /*  863 */  false,
  /*  864 */  false,
  /*  865 */  false,
  /*  866 */  false,
  /*  867 */  false,
  /*  868 */  false,
  /*  869 */  false,
  /*  870 */  false,
  /*  871 */  false,
  /*  872 */  false,
  /*  873 */  false,
  /*  874 */  false,
  /*  875 */  false,
  /*  876 */  false,
  /*  877 */  false,
  /*  878 */  false,
  /*  879 */  false,
  /*  880 */  false,
  /*  881 */  false,
  /*  882 */  false,
  /*  883 */  false,
  /*  884 */  false,
  /*  885 */  false,
  /*  886 */  false,
  /*  887 */  false,
  /*  888 */  false,
  /*  889 */  false,
  /*  890 */  false,
  /*  891 */  false,
  /*  892 */  false,
  /*  893 */  false,
  /*  894 */  false,
  /*  895 */  false,
  /*  896 */  false,
  /*  897 */  false,
  /*  898 */  false,
  /*  899 */  false,
  /*  900 */  false,
  /*  901 */  false,
  /*  902 */  false,
  /*  903 */  false,
  /*  904 */  false,
  /*  905 */  false,
  /*  906 */  false,
  /*  907 */  false,
  /*  908 */  false,
  /*  909 */  false,
  /*  910 */  false,
  /*  911 */  false,
  /*  912 */  false,
  /*  913 */  false,
  /*  914 */  false,
  /*  915 */  false,
  /*  916 */  false,
  /*  917 */  false,
  /*  918 */  false,
  /*  919 */  false,
  /*  920 */  false,
  /*  921 */  false,
  /*  922 */  false,
  /*  923 */  false,
  /*  924 */  false,
  /*  925 */  false,
  /*  926 */  false,
  /*  927 */  false,
  /*  928 */  false,
  /*  929 */  false,
  /*  930 */  false,
  /*  931 */  false,
  /*  932 */  false,
  /*  933 */  false,
  /*  934 */  false,
  /*  935 */  false,
  /*  936 */  false,
  /*  937 */  false,
  /*  938 */  false,
  /*  939 */  false,
  /*  940 */  false,
  /*  941 */  false,
  /*  942 */  false,
  /*  943 */  false,
  /*  944 */  false,
  /*  945 */  false,
  /*  946 */  false,
  /*  947 */  false,
  /*  948 */  false,
  /*  949 */  false,
  /*  950 */  false,
  /*  951 */  false,
  /*  952 */  false,
  /*  953 */  false,
  /*  954 */  false,
  /*  955 */  false,
  /*  956 */  false,
  /*  957 */  false,
  /*  958 */  false,
  /*  959 */  false,
  /*  960 */  false,
  /*  961 */  false,
  /*  962 */  false,
  /*  963 */  false,
  /*  964 */  false,
  /*  965 */  false,
  /*  966 */  false,
  /*  967 */  false,
  /*  968 */  false,
  /*  969 */  false,
  /*  970 */  false,
  /*  971 */  false,
  /*  972 */  false,
  /*  973 */  false,
  /*  974 */  false,
  /*  975 */  false,
  /*  976 */  false,
  /*  977 */  false,
  /*  978 */  false,
  /*  979 */  false,
  /*  980 */  false,
  /*  981 */  false,
  /*  982 */  false,
  /*  983 */  false,
  /*  984 */  false,
  /*  985 */  false,
  /*  986 */  false,
  /*  987 */  false,
  /*  988 */  false,
  /*  989 */  false,
  /*  990 */  false,
  /*  991 */  false,
  /*  992 */  false,
  /*  993 */  false,
  /*  994 */  false,
  /*  995 */  false,
  /*  996 */  false,
  /*  997 */  false,
  /*  998 */  false,
  /*  999 */  false,
  /* 1000 */  false,
  /* 1001 */  false,
  /* 1002 */  false,
  /* 1003 */  false,
  /* 1004 */  false,
  /* 1005 */  false,
  /* 1006 */  false,
  /* 1007 */  false,
  /* 1008 */  false,
  /* 1009 */  false,
  /* 1010 */  false,
  /* 1011 */  false,
  /* 1012 */  false,
  /* 1013 */  false,
  /* 1014 */  false,
  /* 1015 */  false,
  /* 1016 */  false,
  /* 1017 */  false,
  /* 1018 */  false,
  /* 1019 */  false,
  /* 1020 */  false,
  /* 1021 */  false,
  /* 1022 */  false,
  /* 1023 */  false,
  /* 1024 */  false,
  /* 1025 */  false,
  /* 1026 */  false,
  /* 1027 */  false,
  /* 1028 */  false,
  /* 1029 */  false,
  /* 1030 */  false,
  /* 1031 */  false,
  /* 1032 */  false,
  /* 1033 */  false,
  /* 1034 */  false,
  /* 1035 */  false,
  /* 1036 */  false,
  /* 1037 */  false,
  /* 1038 */  false,
  /* 1039 */  false,
  /* 1040 */  false,
  /* 1041 */  false,
  /* 1042 */  false,
  /* 1043 */  false,
  /* 1044 */  false,
  /* 1045 */  false,
  /* 1046 */  false,
  /* 1047 */  false,
  /* 1048 */  false,
  /* 1049 */  false,
  /* 1050 */  false,
  /* 1051 */  false,
  /* 1052 */  false,
  /* 1053 */  false,
  /* 1054 */  false,
  /* 1055 */  false,
  /* 1056 */  false,
  /* 1057 */  false,
  /* 1058 */  false,
  /* 1059 */  false,
  /* 1060 */  false,
  /* 1061 */  false,
  /* 1062 */  false,
  /* 1063 */  false,
  /* 1064 */  false,
  /* 1065 */  false,
  /* 1066 */  false,
  /* 1067 */  false,
  /* 1068 */  false,
  /* 1069 */  false,
  /* 1070 */  false,
  /* 1071 */  false,
  /* 1072 */  false,
  /* 1073 */  false,
  /* 1074 */  false,
  /* 1075 */  false,
  /* 1076 */  false,
  /* 1077 */  false,
  /* 1078 */  false,
  /* 1079 */  false,
  /* 1080 */  false,
  /* 1081 */  false,
  /* 1082 */  false,
  /* 1083 */  false,
  /* 1084 */  false,
  /* 1085 */  false,
  /* 1086 */  false,
  /* 1087 */  false,
  /* 1088 */  false,
  /* 1089 */  false,
  /* 1090 */  false,
  /* 1091 */  false,
  /* 1092 */  false,
  /* 1093 */  false,
  /* 1094 */  false,
  /* 1095 */  false,
  /* 1096 */  false,
  /* 1097 */  false,
  /* 1098 */  false,
  /* 1099 */  false,
  /* 1100 */  false,
  /* 1101 */  false,
  /* 1102 */  false,
  /* 1103 */  false,
  /* 1104 */  false,
  /* 1105 */  false,
  /* 1106 */  false,
  /* 1107 */  false,
  /* 1108 */  false,
  /* 1109 */  false,
  /* 1110 */  false,
  /* 1111 */  false,
  /* 1112 */  false,
  /* 1113 */  false,
  /* 1114 */  false,
  /* 1115 */  false,
  /* 1116 */  false,
  /* 1117 */  false,
  /* 1118 */  false,
  /* 1119 */  false,
  /* 1120 */  false,
  /* 1121 */  false,
  /* 1122 */  false,
  /* 1123 */  false,
  /* 1124 */  false,
  /* 1125 */  false,
  /* 1126 */  false,
  /* 1127 */  false,
  /* 1128 */  false,
  /* 1129 */  false,
  /* 1130 */  false,
  /* 1131 */  false,
  /* 1132 */  false,
  /* 1133 */  false,
  /* 1134 */  false,
  /* 1135 */  false,
  /* 1136 */  false,
  /* 1137 */  false,
  /* 1138 */  false,
  /* 1139 */  false,
  /* 1140 */  false,
  /* 1141 */  false,
  /* 1142 */  false,
  /* 1143 */  false,
  /* 1144 */  false,
  /* 1145 */  false,
  /* 1146 */  false,
  /* 1147 */  false,
  /* 1148 */  false,
  /* 1149 */  false,
  /* 1150 */  false,
  /* 1151 */  false,
  /* 1152 */  false,
  /* 1153 */  false,
  /* 1154 */  false,
  /* 1155 */  false,
  /* 1156 */  false,
  /* 1157 */  false,
  /* 1158 */  false,
  /* 1159 */  false,
  /* 1160 */  false,
  /* 1161 */  false,
  /* 1162 */  false,
  /* 1163 */  false,
  /* 1164 */  false,
  /* 1165 */  false,
  /* 1166 */  false,
  /* 1167 */  false,
  /* 1168 */  false,
  /* 1169 */  false,
  /* 1170 */  false,
  /* 1171 */  false,
  /* 1172 */  false,
  /* 1173 */  false,
  /* 1174 */  false,
  /* 1175 */  false,
  /* 1176 */  false,
  /* 1177 */  false,
  /* 1178 */  false,
  /* 1179 */  false,
  /* 1180 */  false,
  /* 1181 */  false,
  /* 1182 */  false,
  /* 1183 */  false,
  /* 1184 */  false,
  /* 1185 */  false,
  /* 1186 */  false,
  /* 1187 */  false,
  /* 1188 */  false,
  /* 1189 */  false,
  /* 1190 */  false,
  /* 1191 */  false,
  /* 1192 */  false,
  /* 1193 */  false,
  /* 1194 */  false,
  /* 1195 */  false,
  /* 1196 */  false,
  /* 1197 */  false,
  /* 1198 */  false,
  /* 1199 */  false,
  /* 1200 */  false,
  /* 1201 */  false,
  /* 1202 */  false,
  /* 1203 */  false,
  /* 1204 */  false,
  /* 1205 */  false,
  /* 1206 */  false,
  /* 1207 */  false,
  /* 1208 */  false,
  /* 1209 */  false,
  /* 1210 */  false,
  /* 1211 */  false,
  /* 1212 */  false,
  /* 1213 */  false,
  /* 1214 */  false,
  /* 1215 */  false,
  /* 1216 */  false,
  /* 1217 */  false,
  /* 1218 */  false,
  /* 1219 */  false,
  /* 1220 */  false,
  /* 1221 */  false,
  /* 1222 */  false,
  /* 1223 */  false,
  /* 1224 */  false,
  /* 1225 */  false,
  /* 1226 */  false,
  /* 1227 */  false,
  /* 1228 */  false,
  /* 1229 */  false,
  /* 1230 */  false,
  /* 1231 */  false,
  /* 1232 */  false,
  /* 1233 */  false,
  /* 1234 */  false,
  /* 1235 */  false,
  /* 1236 */  false,
  /* 1237 */  false,
  /* 1238 */  false,
  /* 1239 */  false,
  /* 1240 */  false,
  /* 1241 */  false,
  /* 1242 */  false,
  /* 1243 */  false,
  /* 1244 */  false,
  /* 1245 */  false,
  /* 1246 */  false,
  /* 1247 */  false,
  /* 1248 */  false,
  /* 1249 */  false,
  /* 1250 */  false,
  /* 1251 */  false,
  /* 1252 */  false,
  /* 1253 */  false,
  /* 1254 */  false,
  /* 1255 */  false,
  /* 1256 */  false,
  /* 1257 */  false,
  /* 1258 */  false,
  /* 1259 */  false,
  /* 1260 */  false,
  /* 1261 */  false,
  /* 1262 */  false,
  /* 1263 */  false,
  /* 1264 */  false,
  /* 1265 */  false,
  /* 1266 */  false,
  /* 1267 */  false,
  /* 1268 */  false,
  /* 1269 */  false,
  /* 1270 */  false,
  /* 1271 */  false,
  /* 1272 */  false,
  /* 1273 */  false,
  /* 1274 */  false,
  /* 1275 */  false,
  /* 1276 */  false,
  /* 1277 */  false,
  /* 1278 */  false,
  /* 1279 */  false,
  /* 1280 */  false,
  /* 1281 */  false,
  /* 1282 */  false,
  /* 1283 */  false,
  /* 1284 */  false,
  /* 1285 */  false,
  /* 1286 */  false,
  /* 1287 */  false,
  /* 1288 */  false,
  /* 1289 */  false,
  /* 1290 */  false,
  /* 1291 */  false,
  /* 1292 */  false,
  /* 1293 */  false,
  /* 1294 */  false,
  /* 1295 */  false,
  /* 1296 */  false,
  /* 1297 */  false,
  /* 1298 */  false,
  /* 1299 */  false,
  /* 1300 */  false,
  /* 1301 */  false,
  /* 1302 */  false,
  /* 1303 */  false,
  /* 1304 */  false,
  /* 1305 */  false,
  /* 1306 */  false,
  /* 1307 */  false,
  /* 1308 */  false,
  /* 1309 */  false,
  /* 1310 */  false,
  /* 1311 */  false,
  /* 1312 */  false,
  /* 1313 */  false,
  /* 1314 */  false,
  /* 1315 */  false,
  /* 1316 */  false,
  /* 1317 */  false,
  /* 1318 */  false,
  /* 1319 */  false,
  /* 1320 */  false,
  /* 1321 */  false,
  /* 1322 */  false,
  /* 1323 */  false,
  /* 1324 */  false,
  /* 1325 */  false,
  /* 1326 */  false,
  /* 1327 */  false,
  /* 1328 */  false,
  /* 1329 */  false,
  /* 1330 */  false,
  /* 1331 */  false,
  /* 1332 */  false,
  /* 1333 */  false,
  /* 1334 */  false,
  /* 1335 */  false,
  /* 1336 */  false,
  /* 1337 */  false,
  /* 1338 */  false,
  /* 1339 */  false,
  /* 1340 */  false,
  /* 1341 */  false,
  /* 1342 */  false,
  /* 1343 */  false,
  /* 1344 */  false,
  /* 1345 */  false,
  /* 1346 */  false,
  /* 1347 */  false,
  /* 1348 */  false,
  /* 1349 */  false,
  /* 1350 */  false,
  /* 1351 */  false,
  /* 1352 */  false,
  /* 1353 */  false,
  /* 1354 */  false,
  /* 1355 */  false,
  /* 1356 */  false,
  /* 1357 */  false,
  /* 1358 */  false,
  /* 1359 */  false,
  /* 1360 */  false,
  /* 1361 */  false,
  /* 1362 */  false,
  /* 1363 */  false,
  /* 1364 */  false,
  /* 1365 */  false,
  /* 1366 */  false,
  /* 1367 */  false,
  /* 1368 */  false,
  /* 1369 */  false,
  /* 1370 */  false,
  /* 1371 */  false,
  /* 1372 */  false,
  /* 1373 */  false,
  /* 1374 */  false,
  /* 1375 */  false,
  /* 1376 */  false,
  /* 1377 */  false,
  /* 1378 */  false,
  /* 1379 */  false,
  /* 1380 */  false,
  /* 1381 */  false,
  /* 1382 */  false,
  /* 1383 */  false,
  /* 1384 */  false,
  /* 1385 */  false,
  /* 1386 */  false,
  /* 1387 */  false,
  /* 1388 */  false,
  /* 1389 */  false,
  /* 1390 */  false,
  /* 1391 */  false,
  /* 1392 */  false,
  /* 1393 */  false,
  /* 1394 */  false,
  /* 1395 */  false,
  /* 1396 */  false,
  /* 1397 */  false,
  /* 1398 */  false,
  /* 1399 */  false,
  /* 1400 */  false,
  /* 1401 */  false,
  /* 1402 */  false,
  /* 1403 */  false,
  /* 1404 */  false,
  /* 1405 */  false,
  /* 1406 */  false,
  /* 1407 */  false,
  /* 1408 */  false,
  /* 1409 */  false,
  /* 1410 */  false,
  /* 1411 */  false,
  /* 1412 */  false,
  /* 1413 */  false,
  /* 1414 */  false,
  /* 1415 */  false,
  /* 1416 */  false,
  /* 1417 */  false,
  /* 1418 */  false,
  /* 1419 */  false,
  /* 1420 */  false,
  /* 1421 */  false,
  /* 1422 */  false,
  /* 1423 */  false,
  /* 1424 */  false,
  /* 1425 */  false,
  /* 1426 */  false,
  /* 1427 */  false,
  /* 1428 */  false,
  /* 1429 */  false,
  /* 1430 */  false,
  /* 1431 */  false,
  /* 1432 */  false,
  /* 1433 */  false,
  /* 1434 */  false,
  /* 1435 */  false,
  /* 1436 */  false,
  /* 1437 */  false,
  /* 1438 */  false,
  /* 1439 */  false,
  /* 1440 */  false,
  /* 1441 */  false,
  /* 1442 */  false,
  /* 1443 */  false,
  /* 1444 */  false,
  /* 1445 */  false,
  /* 1446 */  false,
  /* 1447 */  false,
  /* 1448 */  false,
  /* 1449 */  false,
  /* 1450 */  false,
  /* 1451 */  false,
  /* 1452 */  false,
  /* 1453 */  false,
  /* 1454 */  false,
  /* 1455 */  false,
  /* 1456 */  false,
  /* 1457 */  false,
  /* 1458 */  false,
  /* 1459 */  false,
  /* 1460 */  false,
  /* 1461 */  false,
  /* 1462 */  false,
  /* 1463 */  false,
  /* 1464 */  false,
  /* 1465 */  false,
  /* 1466 */  false,
  /* 1467 */  false,
  /* 1468 */  false,
  /* 1469 */  false,
  /* 1470 */  false,
  /* 1471 */  false,
  /* 1472 */  false,
  /* 1473 */  false,
  /* 1474 */  false,
  /* 1475 */  false,
  /* 1476 */  false,
  /* 1477 */  false,
  /* 1478 */  false,
  /* 1479 */  false,
  /* 1480 */  false,
  /* 1481 */  false,
  /* 1482 */  false,
  /* 1483 */  false,
  /* 1484 */  false,
  /* 1485 */  false,
  /* 1486 */  false,
  /* 1487 */  false,
  /* 1488 */  false,
  /* 1489 */  false,
  /* 1490 */  false,
  /* 1491 */  false,
  /* 1492 */  false,
  /* 1493 */  false,
  /* 1494 */  false,
  /* 1495 */  false,
  /* 1496 */  false,
  /* 1497 */  false,
  /* 1498 */  false,
  /* 1499 */  false,
  /* 1500 */  false,
  /* 1501 */  false,
  /* 1502 */  false,
  /* 1503 */  false,
  /* 1504 */  false,
  /* 1505 */  false,
  /* 1506 */  false,
  /* 1507 */  false,
  /* 1508 */  false,
  /* 1509 */  false,
  /* 1510 */  false,
  /* 1511 */  false,
  /* 1512 */  false,
  /* 1513 */  false,
  /* 1514 */  false,
  /* 1515 */  false,
  /* 1516 */  false,
  /* 1517 */  false,
  /* 1518 */  false,
  /* 1519 */  false,
  /* 1520 */  false,
  /* 1521 */  false,
  /* 1522 */  false,
  /* 1523 */  false,
  /* 1524 */  false,
  /* 1525 */  false,
  /* 1526 */  false,
  /* 1527 */  false,
  /* 1528 */  false,
  /* 1529 */  false,
  /* 1530 */  false,
  /* 1531 */  false,
  /* 1532 */  false,
  /* 1533 */  false,
  /* 1534 */  false,
  /* 1535 */  false,
  /* 1536 */  false,
  /* 1537 */  false,
  /* 1538 */  false,
  /* 1539 */  false,
  /* 1540 */  false,
  /* 1541 */  false,
  /* 1542 */  false,
  /* 1543 */  false,
  /* 1544 */  false,
  /* 1545 */  false,
  /* 1546 */  false,
  /* 1547 */  false,
  /* 1548 */  false,
  /* 1549 */  false,
  /* 1550 */  false,
  /* 1551 */  false,
  /* 1552 */  false,
  /* 1553 */  false,
  /* 1554 */  false,
  /* 1555 */  false,
  /* 1556 */  false,
  /* 1557 */  false,
  /* 1558 */  false,
  /* 1559 */  false,
  /* 1560 */  false,
  /* 1561 */  false,
  /* 1562 */  false,
  /* 1563 */  false,
  /* 1564 */  false,
  /* 1565 */  false,
  /* 1566 */  false,
  /* 1567 */  false,
  /* 1568 */  false,
  /* 1569 */  false,
  /* 1570 */  false,
  /* 1571 */  false,
  /* 1572 */  false,
  /* 1573 */  false,
  /* 1574 */  false,
  /* 1575 */  false,
  /* 1576 */  false,
  /* 1577 */  false,
  /* 1578 */  false,
  /* 1579 */  false,
  /* 1580 */  false,
  /* 1581 */  false,
  /* 1582 */  false,
  /* 1583 */  false,
  /* 1584 */  false,
  /* 1585 */  false,
  /* 1586 */  false,
  /* 1587 */  false,
  /* 1588 */  false,
  /* 1589 */  false,
  /* 1590 */  false,
  /* 1591 */  false,
  /* 1592 */  false,
  /* 1593 */  false,
  /* 1594 */  false,
  /* 1595 */  false,
  /* 1596 */  false,
  /* 1597 */  false,
  /* 1598 */  false,
  /* 1599 */  false,
  /* 1600 */  false,
  /* 1601 */  false,
  /* 1602 */  false,
  /* 1603 */  false,
  /* 1604 */  false,
  /* 1605 */  false,
  /* 1606 */  false,
  /* 1607 */  false,
  /* 1608 */  false,
  /* 1609 */  false,
  /* 1610 */  false,
  /* 1611 */  false,
  /* 1612 */  false,
  /* 1613 */  false,
  /* 1614 */  false,
  /* 1615 */  false,
  /* 1616 */  false,
  /* 1617 */  false,
  /* 1618 */  false,
  /* 1619 */  false,
  /* 1620 */  false,
  /* 1621 */  false,
  /* 1622 */  false,
  /* 1623 */  false,
  /* 1624 */  false,
  /* 1625 */  false,
  /* 1626 */  false,
  /* 1627 */  false,
  /* 1628 */  false,
  /* 1629 */  false,
  /* 1630 */  false,
  /* 1631 */  false,
  /* 1632 */  false,
  /* 1633 */  false,
  /* 1634 */  false,
  /* 1635 */  false,
  /* 1636 */  false,
  /* 1637 */  false,
  /* 1638 */  false,
  /* 1639 */  false,
  /* 1640 */  false,
  /* 1641 */  false,
  /* 1642 */  false,
  /* 1643 */  false,
  /* 1644 */  false,
  /* 1645 */  false,
  /* 1646 */  false,
  /* 1647 */  false,
  /* 1648 */  false,
  /* 1649 */  false,
  /* 1650 */  false,
  /* 1651 */  false,
  /* 1652 */  false,
  /* 1653 */  false,
  /* 1654 */  false,
  /* 1655 */  false,
  /* 1656 */  false,
  // last instruction
  false // no trailing comma
};

// Mapping from machine-independent opcode to boolean
const        char must_clone[] = {
  0, // Node: 0
  0, // Set: 1
  0, // RegN: 2
  0, // RegI: 3
  0, // RegP: 4
  0, // RegF: 5
  0, // RegD: 6
  0, // RegL: 7
  0, // RegFlags: 8
  0, // VecS: 9
  0, // VecD: 10
  0, // VecX: 11
  0, // VecY: 12
  0, // VecZ: 13
  0, // _last_machine_leaf: 14
  0, // AbsD: 15
  0, // AbsF: 16
  0, // AbsI: 17
  0, // AbsL: 18
  0, // AddD: 19
  0, // AddF: 20
  0, // AddI: 21
  0, // AddL: 22
  0, // AddP: 23
  0, // Allocate: 24
  0, // AllocateArray: 25
  0, // AndI: 26
  0, // AndL: 27
  0, // ArrayCopy: 28
  0, // AryEq: 29
  0, // AtanD: 30
  1, // Binary: 31
  1, // Bool: 32
  0, // BoxLock: 33
  0, // ReverseBytesI: 34
  0, // ReverseBytesL: 35
  0, // ReverseBytesUS: 36
  0, // ReverseBytesS: 37
  0, // CProj: 38
  0, // CallDynamicJava: 39
  0, // CallJava: 40
  0, // CallLeaf: 41
  0, // CallLeafNoFP: 42
  0, // CallRuntime: 43
  0, // CallStaticJava: 44
  0, // CastII: 45
  0, // CastX2P: 46
  0, // CastP2X: 47
  0, // CastPP: 48
  0, // Catch: 49
  0, // CatchProj: 50
  0, // CheckCastPP: 51
  0, // ClearArray: 52
  0, // ConstraintCast: 53
  0, // CMoveD: 54
  0, // CMoveVD: 55
  0, // CMoveF: 56
  0, // CMoveVF: 57
  0, // CMoveI: 58
  0, // CMoveL: 59
  0, // CMoveP: 60
  0, // CMoveN: 61
  1, // CmpN: 62
  1, // CmpD: 63
  0, // CmpD3: 64
  1, // CmpF: 65
  0, // CmpF3: 66
  1, // CmpI: 67
  1, // CmpL: 68
  0, // CmpL3: 69
  0, // CmpLTMask: 70
  1, // CmpP: 71
  1, // CmpU: 72
  1, // CmpUL: 73
  0, // CompareAndSwapB: 74
  0, // CompareAndSwapS: 75
  0, // CompareAndSwapI: 76
  0, // CompareAndSwapL: 77
  0, // CompareAndSwapP: 78
  0, // CompareAndSwapN: 79
  0, // WeakCompareAndSwapB: 80
  0, // WeakCompareAndSwapS: 81
  0, // WeakCompareAndSwapI: 82
  0, // WeakCompareAndSwapL: 83
  0, // WeakCompareAndSwapP: 84
  0, // WeakCompareAndSwapN: 85
  0, // CompareAndExchangeB: 86
  0, // CompareAndExchangeS: 87
  0, // CompareAndExchangeI: 88
  0, // CompareAndExchangeL: 89
  0, // CompareAndExchangeP: 90
  0, // CompareAndExchangeN: 91
  0, // GetAndAddB: 92
  0, // GetAndAddS: 93
  0, // GetAndAddI: 94
  0, // GetAndAddL: 95
  0, // GetAndSetB: 96
  0, // GetAndSetS: 97
  0, // GetAndSetI: 98
  0, // GetAndSetL: 99
  0, // GetAndSetP: 100
  0, // GetAndSetN: 101
  0, // Con: 102
  0, // ConN: 103
  0, // ConNKlass: 104
  0, // ConD: 105
  0, // ConF: 106
  0, // ConI: 107
  0, // ConL: 108
  0, // ConP: 109
  0, // Conv2B: 110
  0, // ConvD2F: 111
  0, // ConvD2I: 112
  0, // ConvD2L: 113
  0, // ConvF2D: 114
  0, // ConvF2I: 115
  0, // ConvF2L: 116
  0, // ConvI2D: 117
  0, // ConvI2F: 118
  0, // ConvI2L: 119
  0, // ConvL2D: 120
  0, // ConvL2F: 121
  0, // ConvL2I: 122
  0, // CountedLoop: 123
  0, // CountedLoopEnd: 124
  0, // OuterStripMinedLoop: 125
  0, // OuterStripMinedLoopEnd: 126
  0, // CountLeadingZerosI: 127
  0, // CountLeadingZerosL: 128
  0, // CountTrailingZerosI: 129
  0, // CountTrailingZerosL: 130
  0, // CreateEx: 131
  0, // DecodeN: 132
  0, // DecodeNKlass: 133
  0, // DivD: 134
  0, // DivF: 135
  0, // DivI: 136
  0, // DivL: 137
  0, // DivMod: 138
  0, // DivModI: 139
  0, // DivModL: 140
  0, // EncodeISOArray: 141
  0, // EncodeP: 142
  0, // EncodePKlass: 143
  1, // FastLock: 144
  1, // FastUnlock: 145
  0, // FmaD: 146
  0, // FmaF: 147
  0, // Goto: 148
  0, // Halt: 149
  0, // HasNegatives: 150
  0, // If: 151
  0, // RangeCheck: 152
  0, // IfFalse: 153
  0, // IfTrue: 154
  0, // Initialize: 155
  0, // JProj: 156
  0, // Jump: 157
  0, // JumpProj: 158
  0, // LShiftI: 159
  0, // LShiftL: 160
  0, // LoadB: 161
  0, // LoadUB: 162
  0, // LoadUS: 163
  0, // LoadD: 164
  0, // LoadD_unaligned: 165
  0, // LoadF: 166
  0, // LoadI: 167
  0, // LoadKlass: 168
  0, // LoadNKlass: 169
  0, // LoadL: 170
  0, // LoadL_unaligned: 171
  0, // LoadPLocked: 172
  0, // LoadP: 173
  0, // LoadN: 174
  0, // LoadRange: 175
  0, // LoadS: 176
  0, // LoadBarrier: 177
  0, // LoadBarrierSlowReg: 178
  0, // LoadBarrierWeakSlowReg: 179
  0, // Lock: 180
  0, // Loop: 181
  0, // LoopLimit: 182
  0, // Mach: 183
  0, // MachNullCheck: 184
  0, // MachProj: 185
  0, // MaxD: 186
  0, // MaxF: 187
  0, // MaxI: 188
  0, // MaxL: 189
  0, // MemBarAcquire: 190
  0, // LoadFence: 191
  0, // SetVectMaskI: 192
  0, // MemBarAcquireLock: 193
  0, // MemBarCPUOrder: 194
  0, // MemBarRelease: 195
  0, // StoreFence: 196
  0, // MemBarReleaseLock: 197
  0, // MemBarVolatile: 198
  0, // MemBarStoreStore: 199
  0, // MergeMem: 200
  0, // MinD: 201
  0, // MinF: 202
  0, // MinI: 203
  0, // MinL: 204
  0, // ModD: 205
  0, // ModF: 206
  0, // ModI: 207
  0, // ModL: 208
  0, // MoveI2F: 209
  0, // MoveF2I: 210
  0, // MoveL2D: 211
  0, // MoveD2L: 212
  0, // MulD: 213
  0, // MulF: 214
  0, // MulHiL: 215
  0, // MulI: 216
  0, // MulL: 217
  0, // Multi: 218
  0, // NegD: 219
  0, // NegF: 220
  0, // NeverBranch: 221
  0, // OnSpinWait: 222
  0, // Opaque1: 223
  0, // OpaqueLoopInit: 224
  0, // OpaqueLoopStride: 225
  0, // Opaque2: 226
  0, // Opaque3: 227
  0, // Opaque4: 228
  0, // ProfileBoolean: 229
  0, // OrI: 230
  0, // OrL: 231
  1, // OverflowAddI: 232
  1, // OverflowSubI: 233
  1, // OverflowMulI: 234
  1, // OverflowAddL: 235
  1, // OverflowSubL: 236
  1, // OverflowMulL: 237
  0, // PCTable: 238
  0, // Parm: 239
  0, // PartialSubtypeCheck: 240
  0, // Phi: 241
  0, // PopCountI: 242
  0, // PopCountL: 243
  0, // PopCountVI: 244
  0, // PrefetchAllocation: 245
  0, // Proj: 246
  0, // RShiftI: 247
  0, // RShiftL: 248
  0, // Region: 249
  0, // Rethrow: 250
  0, // Return: 251
  0, // Root: 252
  0, // RoundDouble: 253
  0, // RoundDoubleMode: 254
  0, // RoundDoubleModeV: 255
  0, // RoundFloat: 256
  0, // SafePoint: 257
  0, // SafePointScalarObject: 258
  0, // ShenandoahCompareAndExchangeP: 259
  0, // ShenandoahCompareAndExchangeN: 260
  0, // ShenandoahCompareAndSwapN: 261
  0, // ShenandoahCompareAndSwapP: 262
  0, // ShenandoahWeakCompareAndSwapN: 263
  0, // ShenandoahWeakCompareAndSwapP: 264
  0, // ShenandoahIUBarrier: 265
  0, // ShenandoahLoadReferenceBarrier: 266
  0, // SCMemProj: 267
  0, // CopySignD: 268
  0, // CopySignF: 269
  0, // SignumD: 270
  0, // SignumF: 271
  0, // SqrtD: 272
  0, // SqrtF: 273
  0, // Start: 274
  0, // StartOSR: 275
  0, // StoreB: 276
  0, // StoreC: 277
  0, // StoreCM: 278
  0, // StorePConditional: 279
  0, // StoreIConditional: 280
  0, // StoreLConditional: 281
  0, // StoreD: 282
  0, // StoreF: 283
  0, // StoreI: 284
  0, // StoreL: 285
  0, // StoreP: 286
  0, // StoreN: 287
  0, // StoreNKlass: 288
  0, // StrComp: 289
  0, // StrCompressedCopy: 290
  0, // StrEquals: 291
  0, // StrIndexOf: 292
  0, // StrIndexOfChar: 293
  0, // StrInflatedCopy: 294
  0, // SubD: 295
  0, // SubF: 296
  0, // SubI: 297
  0, // SubL: 298
  0, // TailCall: 299
  0, // TailJump: 300
  0, // ThreadLocal: 301
  0, // Unlock: 302
  0, // URShiftI: 303
  0, // URShiftL: 304
  0, // XorI: 305
  0, // XorL: 306
  0, // Vector: 307
  0, // AddVB: 308
  0, // AddVS: 309
  0, // AddVI: 310
  0, // AddReductionVI: 311
  0, // AddVL: 312
  0, // AddReductionVL: 313
  0, // AddVF: 314
  0, // AddReductionVF: 315
  0, // AddVD: 316
  0, // AddReductionVD: 317
  0, // SubVB: 318
  0, // SubVS: 319
  0, // SubVI: 320
  0, // SubVL: 321
  0, // SubVF: 322
  0, // SubVD: 323
  0, // MulVB: 324
  0, // MulVS: 325
  0, // MulVI: 326
  0, // MulReductionVI: 327
  0, // MulVL: 328
  0, // MulReductionVL: 329
  0, // MulVF: 330
  0, // MulReductionVF: 331
  0, // MulVD: 332
  0, // MulReductionVD: 333
  0, // FmaVD: 334
  0, // FmaVF: 335
  0, // DivVF: 336
  0, // DivVD: 337
  0, // AbsVB: 338
  0, // AbsVS: 339
  0, // AbsVI: 340
  0, // AbsVL: 341
  0, // AbsVF: 342
  0, // AbsVD: 343
  0, // NegVF: 344
  0, // NegVD: 345
  0, // SqrtVD: 346
  0, // SqrtVF: 347
  0, // LShiftCntV: 348
  0, // RShiftCntV: 349
  0, // LShiftVB: 350
  0, // LShiftVS: 351
  0, // LShiftVI: 352
  0, // LShiftVL: 353
  0, // RShiftVB: 354
  0, // RShiftVS: 355
  0, // RShiftVI: 356
  0, // RShiftVL: 357
  0, // URShiftVB: 358
  0, // URShiftVS: 359
  0, // URShiftVI: 360
  0, // URShiftVL: 361
  0, // AndV: 362
  0, // OrV: 363
  0, // XorV: 364
  0, // MinV: 365
  0, // MaxV: 366
  0, // MinReductionV: 367
  0, // MaxReductionV: 368
  0, // LoadVector: 369
  0, // StoreVector: 370
  0, // Pack: 371
  0, // PackB: 372
  0, // PackS: 373
  0, // PackI: 374
  0, // PackL: 375
  0, // PackF: 376
  0, // PackD: 377
  0, // Pack2L: 378
  0, // Pack2D: 379
  0, // ReplicateB: 380
  0, // ReplicateS: 381
  0, // ReplicateI: 382
  0, // ReplicateL: 383
  0, // ReplicateF: 384
  0, // ReplicateD: 385
  0, // Extract: 386
  0, // ExtractB: 387
  0, // ExtractUB: 388
  0, // ExtractC: 389
  0, // ExtractS: 390
  0, // ExtractI: 391
  0, // ExtractL: 392
  0, // ExtractF: 393
  0, // ExtractD: 394
  0, // Digit: 395
  0, // LowerCase: 396
  0, // UpperCase: 397
  0 // no trailing comma // Whitespace: 398
};
//  The following instructions can cisc-spill
//  MoveVL2F can cisc-spill operand 1 to loadF
//  MoveLEG2F can cisc-spill operand 1 to loadF
//  MoveVL2D can cisc-spill operand 1 to loadSSD
//  MoveLEG2D can cisc-spill operand 1 to loadSSD
//  popCountI can cisc-spill operand 1 to popCountI_mem
//  popCountL can cisc-spill operand 1 to popCountL_mem
//  cmovI_reg can cisc-spill operand 4 to cmovI_mem
//  cmovI_regU can cisc-spill operand 4 to cmovI_memU
//  cmovI_regUCF can cisc-spill operand 4 to cmovI_memUCF
//  cmovL_reg can cisc-spill operand 4 to cmovL_mem
//  cmovL_regU can cisc-spill operand 4 to cmovL_memU
//  cmovL_regUCF can cisc-spill operand 4 to cmovL_memUCF
//  addI_rReg can cisc-spill operand 2 to addI_rReg_mem
//  addL_rReg can cisc-spill operand 2 to addL_rReg_mem
//  subI_rReg can cisc-spill operand 2 to subI_rReg_mem
//  subL_rReg can cisc-spill operand 2 to subL_rReg_mem
//  mulI_rReg can cisc-spill operand 2 to mulI_mem
//  mulI_rReg_imm can cisc-spill operand 1 to mulI_mem_imm
//  mulL_rReg can cisc-spill operand 2 to mulL_mem
//  mulL_rReg_imm can cisc-spill operand 1 to mulL_mem_imm
//  i2b can cisc-spill operand 1 to loadI2B
//  i2s can cisc-spill operand 1 to loadI2S
//  andI_rReg can cisc-spill operand 2 to andI_rReg_mem
//  andI2L_rReg_imm255 can cisc-spill operand 1 to loadI2L_immI_255
//  andI2L_rReg_imm65535 can cisc-spill operand 1 to loadI2L_immI_65535
//  andnI_rReg_rReg_rReg can cisc-spill operand 3 to andnI_rReg_rReg_mem
//  andnI_rReg_rReg_rReg_0 can cisc-spill operand 1 to andnI_rReg_rReg_mem_0
//  orI_rReg can cisc-spill operand 2 to orI_rReg_mem
//  xorI_rReg can cisc-spill operand 2 to xorI_rReg_mem
//  andL_rReg can cisc-spill operand 2 to andL_rReg_mem
//  andnL_rReg_rReg_rReg can cisc-spill operand 3 to andnL_rReg_rReg_mem
//  andnL_rReg_rReg_rReg_0 can cisc-spill operand 1 to andnL_rReg_rReg_mem_0
//  orL_rReg can cisc-spill operand 2 to orL_rReg_mem
//  xorL_rReg can cisc-spill operand 2 to xorL_rReg_mem
//  cmpF_cc_reg can cisc-spill operand 2 to cmpF_cc_mem
//  cmpF_cc_reg_CF can cisc-spill operand 2 to cmpF_cc_memCF
//  cmpD_cc_reg can cisc-spill operand 2 to cmpD_cc_mem
//  cmpD_cc_reg_CF can cisc-spill operand 2 to cmpD_cc_memCF
//  cmpF_reg can cisc-spill operand 2 to cmpF_mem
//  cmpD_reg can cisc-spill operand 2 to cmpD_mem
//  convF2D_reg_reg can cisc-spill operand 1 to convF2D_reg_mem
//  convD2F_reg_reg can cisc-spill operand 1 to convD2F_reg_mem
//  convL2F_reg_reg can cisc-spill operand 1 to convL2F_reg_mem
//  convL2D_reg_reg can cisc-spill operand 1 to convL2D_reg_mem
//  convI2L_reg_reg can cisc-spill operand 1 to loadI2L
//  convI2L_reg_reg_zex can cisc-spill operand 1 to loadUI2L
//  MoveF2I_reg_reg can cisc-spill operand 1 to MoveF2I_stack_reg
//  MoveD2L_reg_reg can cisc-spill operand 1 to MoveD2L_stack_reg
//  MoveI2F_reg_reg can cisc-spill operand 1 to MoveI2F_stack_reg
//  compI_rReg can cisc-spill operand 2 to compI_rReg_mem
//  compU_rReg can cisc-spill operand 2 to compU_rReg_mem
//  compP_rReg can cisc-spill operand 2 to compP_rReg_mem
//  compL_rReg can cisc-spill operand 2 to compL_rReg_mem
//  compUL_rReg can cisc-spill operand 2 to compUL_rReg_mem
//  addF_reg can cisc-spill operand 2 to addF_mem
//  addF_reg_reg can cisc-spill operand 2 to addF_reg_mem
//  addD_reg can cisc-spill operand 2 to addD_mem
//  addD_reg_reg can cisc-spill operand 2 to addD_reg_mem
//  subF_reg can cisc-spill operand 2 to subF_mem
//  subF_reg_reg can cisc-spill operand 2 to subF_reg_mem
//  subD_reg can cisc-spill operand 2 to subD_mem
//  subD_reg_reg can cisc-spill operand 2 to subD_reg_mem
//  mulF_reg can cisc-spill operand 2 to mulF_mem
//  mulF_reg_reg can cisc-spill operand 2 to mulF_reg_mem
//  mulD_reg can cisc-spill operand 2 to mulD_mem
//  mulD_reg_reg can cisc-spill operand 2 to mulD_reg_mem
//  divF_reg can cisc-spill operand 2 to divF_mem
//  divF_reg_reg can cisc-spill operand 2 to divF_reg_mem
//  divD_reg can cisc-spill operand 2 to divD_mem
//  divD_reg_reg can cisc-spill operand 2 to divD_reg_mem
//  sqrtF_reg can cisc-spill operand 1 to sqrtF_mem
//  sqrtD_reg can cisc-spill operand 1 to sqrtD_mem
//  roundD_reg can cisc-spill operand 1 to roundD_mem
//  Repl8I can cisc-spill operand 1 to Repl8I_mem
//  Repl16I can cisc-spill operand 1 to Repl16I_mem
//  Repl4L can cisc-spill operand 1 to Repl4L_mem
//  Repl8L can cisc-spill operand 1 to Repl8L_mem
//  Repl2I can cisc-spill operand 1 to Repl2I_mem
//  Repl4I_evex can cisc-spill operand 1 to Repl4I_mem_evex
//  Repl8I_evex can cisc-spill operand 1 to Repl8I_mem_evex
//  Repl16I_evex can cisc-spill operand 1 to Repl16I_mem_evex
//  Repl4L_evex can cisc-spill operand 1 to Repl4L_mem_evex
//  Repl8L_evex can cisc-spill operand 1 to Repl8L_mem_evex
//  Repl8F_evex can cisc-spill operand 1 to Repl8F_mem_evex
//  Repl16F_evex can cisc-spill operand 1 to Repl16F_mem_evex
//  Repl4D_evex can cisc-spill operand 1 to Repl4D_mem_evex
//  Repl8D_evex can cisc-spill operand 1 to Repl8D_mem_evex



// An array of character pointers to machine register names.
const char *Matcher::regName[REG_COUNT] = {
  "R10",
  "R10_H",
  "R11",
  "R11_H",
  "R8",
  "R8_H",
  "R9",
  "R9_H",
  "R12",
  "R12_H",
  "RCX",
  "RCX_H",
  "RBX",
  "RBX_H",
  "RDI",
  "RDI_H",
  "RDX",
  "RDX_H",
  "RSI",
  "RSI_H",
  "RAX",
  "RAX_H",
  "RBP",
  "RBP_H",
  "R13",
  "R13_H",
  "R14",
  "R14_H",
  "R15",
  "R15_H",
  "RSP",
  "RSP_H",
  "XMM0",
  "XMM0b",
  "XMM0c",
  "XMM0d",
  "XMM0e",
  "XMM0f",
  "XMM0g",
  "XMM0h",
  "XMM0i",
  "XMM0j",
  "XMM0k",
  "XMM0l",
  "XMM0m",
  "XMM0n",
  "XMM0o",
  "XMM0p",
  "XMM1",
  "XMM1b",
  "XMM1c",
  "XMM1d",
  "XMM1e",
  "XMM1f",
  "XMM1g",
  "XMM1h",
  "XMM1i",
  "XMM1j",
  "XMM1k",
  "XMM1l",
  "XMM1m",
  "XMM1n",
  "XMM1o",
  "XMM1p",
  "XMM2",
  "XMM2b",
  "XMM2c",
  "XMM2d",
  "XMM2e",
  "XMM2f",
  "XMM2g",
  "XMM2h",
  "XMM2i",
  "XMM2j",
  "XMM2k",
  "XMM2l",
  "XMM2m",
  "XMM2n",
  "XMM2o",
  "XMM2p",
  "XMM3",
  "XMM3b",
  "XMM3c",
  "XMM3d",
  "XMM3e",
  "XMM3f",
  "XMM3g",
  "XMM3h",
  "XMM3i",
  "XMM3j",
  "XMM3k",
  "XMM3l",
  "XMM3m",
  "XMM3n",
  "XMM3o",
  "XMM3p",
  "XMM4",
  "XMM4b",
  "XMM4c",
  "XMM4d",
  "XMM4e",
  "XMM4f",
  "XMM4g",
  "XMM4h",
  "XMM4i",
  "XMM4j",
  "XMM4k",
  "XMM4l",
  "XMM4m",
  "XMM4n",
  "XMM4o",
  "XMM4p",
  "XMM5",
  "XMM5b",
  "XMM5c",
  "XMM5d",
  "XMM5e",
  "XMM5f",
  "XMM5g",
  "XMM5h",
  "XMM5i",
  "XMM5j",
  "XMM5k",
  "XMM5l",
  "XMM5m",
  "XMM5n",
  "XMM5o",
  "XMM5p",
  "XMM6",
  "XMM6b",
  "XMM6c",
  "XMM6d",
  "XMM6e",
  "XMM6f",
  "XMM6g",
  "XMM6h",
  "XMM6i",
  "XMM6j",
  "XMM6k",
  "XMM6l",
  "XMM6m",
  "XMM6n",
  "XMM6o",
  "XMM6p",
  "XMM7",
  "XMM7b",
  "XMM7c",
  "XMM7d",
  "XMM7e",
  "XMM7f",
  "XMM7g",
  "XMM7h",
  "XMM7i",
  "XMM7j",
  "XMM7k",
  "XMM7l",
  "XMM7m",
  "XMM7n",
  "XMM7o",
  "XMM7p",
  "XMM8",
  "XMM8b",
  "XMM8c",
  "XMM8d",
  "XMM8e",
  "XMM8f",
  "XMM8g",
  "XMM8h",
  "XMM8i",
  "XMM8j",
  "XMM8k",
  "XMM8l",
  "XMM8m",
  "XMM8n",
  "XMM8o",
  "XMM8p",
  "XMM9",
  "XMM9b",
  "XMM9c",
  "XMM9d",
  "XMM9e",
  "XMM9f",
  "XMM9g",
  "XMM9h",
  "XMM9i",
  "XMM9j",
  "XMM9k",
  "XMM9l",
  "XMM9m",
  "XMM9n",
  "XMM9o",
  "XMM9p",
  "XMM10",
  "XMM10b",
  "XMM10c",
  "XMM10d",
  "XMM10e",
  "XMM10f",
  "XMM10g",
  "XMM10h",
  "XMM10i",
  "XMM10j",
  "XMM10k",
  "XMM10l",
  "XMM10m",
  "XMM10n",
  "XMM10o",
  "XMM10p",
  "XMM11",
  "XMM11b",
  "XMM11c",
  "XMM11d",
  "XMM11e",
  "XMM11f",
  "XMM11g",
  "XMM11h",
  "XMM11i",
  "XMM11j",
  "XMM11k",
  "XMM11l",
  "XMM11m",
  "XMM11n",
  "XMM11o",
  "XMM11p",
  "XMM12",
  "XMM12b",
  "XMM12c",
  "XMM12d",
  "XMM12e",
  "XMM12f",
  "XMM12g",
  "XMM12h",
  "XMM12i",
  "XMM12j",
  "XMM12k",
  "XMM12l",
  "XMM12m",
  "XMM12n",
  "XMM12o",
  "XMM12p",
  "XMM13",
  "XMM13b",
  "XMM13c",
  "XMM13d",
  "XMM13e",
  "XMM13f",
  "XMM13g",
  "XMM13h",
  "XMM13i",
  "XMM13j",
  "XMM13k",
  "XMM13l",
  "XMM13m",
  "XMM13n",
  "XMM13o",
  "XMM13p",
  "XMM14",
  "XMM14b",
  "XMM14c",
  "XMM14d",
  "XMM14e",
  "XMM14f",
  "XMM14g",
  "XMM14h",
  "XMM14i",
  "XMM14j",
  "XMM14k",
  "XMM14l",
  "XMM14m",
  "XMM14n",
  "XMM14o",
  "XMM14p",
  "XMM15",
  "XMM15b",
  "XMM15c",
  "XMM15d",
  "XMM15e",
  "XMM15f",
  "XMM15g",
  "XMM15h",
  "XMM15i",
  "XMM15j",
  "XMM15k",
  "XMM15l",
  "XMM15m",
  "XMM15n",
  "XMM15o",
  "XMM15p",
  "XMM16",
  "XMM16b",
  "XMM16c",
  "XMM16d",
  "XMM16e",
  "XMM16f",
  "XMM16g",
  "XMM16h",
  "XMM16i",
  "XMM16j",
  "XMM16k",
  "XMM16l",
  "XMM16m",
  "XMM16n",
  "XMM16o",
  "XMM16p",
  "XMM17",
  "XMM17b",
  "XMM17c",
  "XMM17d",
  "XMM17e",
  "XMM17f",
  "XMM17g",
  "XMM17h",
  "XMM17i",
  "XMM17j",
  "XMM17k",
  "XMM17l",
  "XMM17m",
  "XMM17n",
  "XMM17o",
  "XMM17p",
  "XMM18",
  "XMM18b",
  "XMM18c",
  "XMM18d",
  "XMM18e",
  "XMM18f",
  "XMM18g",
  "XMM18h",
  "XMM18i",
  "XMM18j",
  "XMM18k",
  "XMM18l",
  "XMM18m",
  "XMM18n",
  "XMM18o",
  "XMM18p",
  "XMM19",
  "XMM19b",
  "XMM19c",
  "XMM19d",
  "XMM19e",
  "XMM19f",
  "XMM19g",
  "XMM19h",
  "XMM19i",
  "XMM19j",
  "XMM19k",
  "XMM19l",
  "XMM19m",
  "XMM19n",
  "XMM19o",
  "XMM19p",
  "XMM20",
  "XMM20b",
  "XMM20c",
  "XMM20d",
  "XMM20e",
  "XMM20f",
  "XMM20g",
  "XMM20h",
  "XMM20i",
  "XMM20j",
  "XMM20k",
  "XMM20l",
  "XMM20m",
  "XMM20n",
  "XMM20o",
  "XMM20p",
  "XMM21",
  "XMM21b",
  "XMM21c",
  "XMM21d",
  "XMM21e",
  "XMM21f",
  "XMM21g",
  "XMM21h",
  "XMM21i",
  "XMM21j",
  "XMM21k",
  "XMM21l",
  "XMM21m",
  "XMM21n",
  "XMM21o",
  "XMM21p",
  "XMM22",
  "XMM22b",
  "XMM22c",
  "XMM22d",
  "XMM22e",
  "XMM22f",
  "XMM22g",
  "XMM22h",
  "XMM22i",
  "XMM22j",
  "XMM22k",
  "XMM22l",
  "XMM22m",
  "XMM22n",
  "XMM22o",
  "XMM22p",
  "XMM23",
  "XMM23b",
  "XMM23c",
  "XMM23d",
  "XMM23e",
  "XMM23f",
  "XMM23g",
  "XMM23h",
  "XMM23i",
  "XMM23j",
  "XMM23k",
  "XMM23l",
  "XMM23m",
  "XMM23n",
  "XMM23o",
  "XMM23p",
  "XMM24",
  "XMM24b",
  "XMM24c",
  "XMM24d",
  "XMM24e",
  "XMM24f",
  "XMM24g",
  "XMM24h",
  "XMM24i",
  "XMM24j",
  "XMM24k",
  "XMM24l",
  "XMM24m",
  "XMM24n",
  "XMM24o",
  "XMM24p",
  "XMM25",
  "XMM25b",
  "XMM25c",
  "XMM25d",
  "XMM25e",
  "XMM25f",
  "XMM25g",
  "XMM25h",
  "XMM25i",
  "XMM25j",
  "XMM25k",
  "XMM25l",
  "XMM25m",
  "XMM25n",
  "XMM25o",
  "XMM25p",
  "XMM26",
  "XMM26b",
  "XMM26c",
  "XMM26d",
  "XMM26e",
  "XMM26f",
  "XMM26g",
  "XMM26h",
  "XMM26i",
  "XMM26j",
  "XMM26k",
  "XMM26l",
  "XMM26m",
  "XMM26n",
  "XMM26o",
  "XMM26p",
  "XMM27",
  "XMM27b",
  "XMM27c",
  "XMM27d",
  "XMM27e",
  "XMM27f",
  "XMM27g",
  "XMM27h",
  "XMM27i",
  "XMM27j",
  "XMM27k",
  "XMM27l",
  "XMM27m",
  "XMM27n",
  "XMM27o",
  "XMM27p",
  "XMM28",
  "XMM28b",
  "XMM28c",
  "XMM28d",
  "XMM28e",
  "XMM28f",
  "XMM28g",
  "XMM28h",
  "XMM28i",
  "XMM28j",
  "XMM28k",
  "XMM28l",
  "XMM28m",
  "XMM28n",
  "XMM28o",
  "XMM28p",
  "XMM29",
  "XMM29b",
  "XMM29c",
  "XMM29d",
  "XMM29e",
  "XMM29f",
  "XMM29g",
  "XMM29h",
  "XMM29i",
  "XMM29j",
  "XMM29k",
  "XMM29l",
  "XMM29m",
  "XMM29n",
  "XMM29o",
  "XMM29p",
  "XMM30",
  "XMM30b",
  "XMM30c",
  "XMM30d",
  "XMM30e",
  "XMM30f",
  "XMM30g",
  "XMM30h",
  "XMM30i",
  "XMM30j",
  "XMM30k",
  "XMM30l",
  "XMM30m",
  "XMM30n",
  "XMM30o",
  "XMM30p",
  "XMM31",
  "XMM31b",
  "XMM31c",
  "XMM31d",
  "XMM31e",
  "XMM31f",
  "XMM31g",
  "XMM31h",
  "XMM31i",
  "XMM31j",
  "XMM31k",
  "XMM31l",
  "XMM31m",
  "XMM31n",
  "XMM31o",
  "XMM31p",
  "RFLAGS" // no trailing comma
};

// An array of character pointers to machine register names.
const VMReg OptoReg::opto2vm[REG_COUNT] = {
	r10->as_VMReg(),
	r10->as_VMReg()->next(),
	r11->as_VMReg(),
	r11->as_VMReg()->next(),
	r8->as_VMReg(),
	r8->as_VMReg()->next(),
	r9->as_VMReg(),
	r9->as_VMReg()->next(),
	r12->as_VMReg(),
	r12->as_VMReg()->next(),
	rcx->as_VMReg(),
	rcx->as_VMReg()->next(),
	rbx->as_VMReg(),
	rbx->as_VMReg()->next(),
	rdi->as_VMReg(),
	rdi->as_VMReg()->next(),
	rdx->as_VMReg(),
	rdx->as_VMReg()->next(),
	rsi->as_VMReg(),
	rsi->as_VMReg()->next(),
	rax->as_VMReg(),
	rax->as_VMReg()->next(),
	rbp->as_VMReg(),
	rbp->as_VMReg()->next(),
	r13->as_VMReg(),
	r13->as_VMReg()->next(),
	r14->as_VMReg(),
	r14->as_VMReg()->next(),
	r15->as_VMReg(),
	r15->as_VMReg()->next(),
	rsp->as_VMReg(),
	rsp->as_VMReg()->next(),
	xmm0->as_VMReg(),
	xmm0->as_VMReg()->next(1),
	xmm0->as_VMReg()->next(2),
	xmm0->as_VMReg()->next(3),
	xmm0->as_VMReg()->next(4),
	xmm0->as_VMReg()->next(5),
	xmm0->as_VMReg()->next(6),
	xmm0->as_VMReg()->next(7),
	xmm0->as_VMReg()->next(8),
	xmm0->as_VMReg()->next(9),
	xmm0->as_VMReg()->next(10),
	xmm0->as_VMReg()->next(11),
	xmm0->as_VMReg()->next(12),
	xmm0->as_VMReg()->next(13),
	xmm0->as_VMReg()->next(14),
	xmm0->as_VMReg()->next(15),
	xmm1->as_VMReg(),
	xmm1->as_VMReg()->next(1),
	xmm1->as_VMReg()->next(2),
	xmm1->as_VMReg()->next(3),
	xmm1->as_VMReg()->next(4),
	xmm1->as_VMReg()->next(5),
	xmm1->as_VMReg()->next(6),
	xmm1->as_VMReg()->next(7),
	xmm1->as_VMReg()->next(8),
	xmm1->as_VMReg()->next(9),
	xmm1->as_VMReg()->next(10),
	xmm1->as_VMReg()->next(11),
	xmm1->as_VMReg()->next(12),
	xmm1->as_VMReg()->next(13),
	xmm1->as_VMReg()->next(14),
	xmm1->as_VMReg()->next(15),
	xmm2->as_VMReg(),
	xmm2->as_VMReg()->next(1),
	xmm2->as_VMReg()->next(2),
	xmm2->as_VMReg()->next(3),
	xmm2->as_VMReg()->next(4),
	xmm2->as_VMReg()->next(5),
	xmm2->as_VMReg()->next(6),
	xmm2->as_VMReg()->next(7),
	xmm2->as_VMReg()->next(8),
	xmm2->as_VMReg()->next(9),
	xmm2->as_VMReg()->next(10),
	xmm2->as_VMReg()->next(11),
	xmm2->as_VMReg()->next(12),
	xmm2->as_VMReg()->next(13),
	xmm2->as_VMReg()->next(14),
	xmm2->as_VMReg()->next(15),
	xmm3->as_VMReg(),
	xmm3->as_VMReg()->next(1),
	xmm3->as_VMReg()->next(2),
	xmm3->as_VMReg()->next(3),
	xmm3->as_VMReg()->next(4),
	xmm3->as_VMReg()->next(5),
	xmm3->as_VMReg()->next(6),
	xmm3->as_VMReg()->next(7),
	xmm3->as_VMReg()->next(8),
	xmm3->as_VMReg()->next(9),
	xmm3->as_VMReg()->next(10),
	xmm3->as_VMReg()->next(11),
	xmm3->as_VMReg()->next(12),
	xmm3->as_VMReg()->next(13),
	xmm3->as_VMReg()->next(14),
	xmm3->as_VMReg()->next(15),
	xmm4->as_VMReg(),
	xmm4->as_VMReg()->next(1),
	xmm4->as_VMReg()->next(2),
	xmm4->as_VMReg()->next(3),
	xmm4->as_VMReg()->next(4),
	xmm4->as_VMReg()->next(5),
	xmm4->as_VMReg()->next(6),
	xmm4->as_VMReg()->next(7),
	xmm4->as_VMReg()->next(8),
	xmm4->as_VMReg()->next(9),
	xmm4->as_VMReg()->next(10),
	xmm4->as_VMReg()->next(11),
	xmm4->as_VMReg()->next(12),
	xmm4->as_VMReg()->next(13),
	xmm4->as_VMReg()->next(14),
	xmm4->as_VMReg()->next(15),
	xmm5->as_VMReg(),
	xmm5->as_VMReg()->next(1),
	xmm5->as_VMReg()->next(2),
	xmm5->as_VMReg()->next(3),
	xmm5->as_VMReg()->next(4),
	xmm5->as_VMReg()->next(5),
	xmm5->as_VMReg()->next(6),
	xmm5->as_VMReg()->next(7),
	xmm5->as_VMReg()->next(8),
	xmm5->as_VMReg()->next(9),
	xmm5->as_VMReg()->next(10),
	xmm5->as_VMReg()->next(11),
	xmm5->as_VMReg()->next(12),
	xmm5->as_VMReg()->next(13),
	xmm5->as_VMReg()->next(14),
	xmm5->as_VMReg()->next(15),
	xmm6->as_VMReg(),
	xmm6->as_VMReg()->next(1),
	xmm6->as_VMReg()->next(2),
	xmm6->as_VMReg()->next(3),
	xmm6->as_VMReg()->next(4),
	xmm6->as_VMReg()->next(5),
	xmm6->as_VMReg()->next(6),
	xmm6->as_VMReg()->next(7),
	xmm6->as_VMReg()->next(8),
	xmm6->as_VMReg()->next(9),
	xmm6->as_VMReg()->next(10),
	xmm6->as_VMReg()->next(11),
	xmm6->as_VMReg()->next(12),
	xmm6->as_VMReg()->next(13),
	xmm6->as_VMReg()->next(14),
	xmm6->as_VMReg()->next(15),
	xmm7->as_VMReg(),
	xmm7->as_VMReg()->next(1),
	xmm7->as_VMReg()->next(2),
	xmm7->as_VMReg()->next(3),
	xmm7->as_VMReg()->next(4),
	xmm7->as_VMReg()->next(5),
	xmm7->as_VMReg()->next(6),
	xmm7->as_VMReg()->next(7),
	xmm7->as_VMReg()->next(8),
	xmm7->as_VMReg()->next(9),
	xmm7->as_VMReg()->next(10),
	xmm7->as_VMReg()->next(11),
	xmm7->as_VMReg()->next(12),
	xmm7->as_VMReg()->next(13),
	xmm7->as_VMReg()->next(14),
	xmm7->as_VMReg()->next(15),
	xmm8->as_VMReg(),
	xmm8->as_VMReg()->next(1),
	xmm8->as_VMReg()->next(2),
	xmm8->as_VMReg()->next(3),
	xmm8->as_VMReg()->next(4),
	xmm8->as_VMReg()->next(5),
	xmm8->as_VMReg()->next(6),
	xmm8->as_VMReg()->next(7),
	xmm8->as_VMReg()->next(8),
	xmm8->as_VMReg()->next(9),
	xmm8->as_VMReg()->next(10),
	xmm8->as_VMReg()->next(11),
	xmm8->as_VMReg()->next(12),
	xmm8->as_VMReg()->next(13),
	xmm8->as_VMReg()->next(14),
	xmm8->as_VMReg()->next(15),
	xmm9->as_VMReg(),
	xmm9->as_VMReg()->next(1),
	xmm9->as_VMReg()->next(2),
	xmm9->as_VMReg()->next(3),
	xmm9->as_VMReg()->next(4),
	xmm9->as_VMReg()->next(5),
	xmm9->as_VMReg()->next(6),
	xmm9->as_VMReg()->next(7),
	xmm9->as_VMReg()->next(8),
	xmm9->as_VMReg()->next(9),
	xmm9->as_VMReg()->next(10),
	xmm9->as_VMReg()->next(11),
	xmm9->as_VMReg()->next(12),
	xmm9->as_VMReg()->next(13),
	xmm9->as_VMReg()->next(14),
	xmm9->as_VMReg()->next(15),
	xmm10->as_VMReg(),
	xmm10->as_VMReg()->next(1),
	xmm10->as_VMReg()->next(2),
	xmm10->as_VMReg()->next(3),
	xmm10->as_VMReg()->next(4),
	xmm10->as_VMReg()->next(5),
	xmm10->as_VMReg()->next(6),
	xmm10->as_VMReg()->next(7),
	xmm10->as_VMReg()->next(8),
	xmm10->as_VMReg()->next(9),
	xmm10->as_VMReg()->next(10),
	xmm10->as_VMReg()->next(11),
	xmm10->as_VMReg()->next(12),
	xmm10->as_VMReg()->next(13),
	xmm10->as_VMReg()->next(14),
	xmm10->as_VMReg()->next(15),
	xmm11->as_VMReg(),
	xmm11->as_VMReg()->next(1),
	xmm11->as_VMReg()->next(2),
	xmm11->as_VMReg()->next(3),
	xmm11->as_VMReg()->next(4),
	xmm11->as_VMReg()->next(5),
	xmm11->as_VMReg()->next(6),
	xmm11->as_VMReg()->next(7),
	xmm11->as_VMReg()->next(8),
	xmm11->as_VMReg()->next(9),
	xmm11->as_VMReg()->next(10),
	xmm11->as_VMReg()->next(11),
	xmm11->as_VMReg()->next(12),
	xmm11->as_VMReg()->next(13),
	xmm11->as_VMReg()->next(14),
	xmm11->as_VMReg()->next(15),
	xmm12->as_VMReg(),
	xmm12->as_VMReg()->next(1),
	xmm12->as_VMReg()->next(2),
	xmm12->as_VMReg()->next(3),
	xmm12->as_VMReg()->next(4),
	xmm12->as_VMReg()->next(5),
	xmm12->as_VMReg()->next(6),
	xmm12->as_VMReg()->next(7),
	xmm12->as_VMReg()->next(8),
	xmm12->as_VMReg()->next(9),
	xmm12->as_VMReg()->next(10),
	xmm12->as_VMReg()->next(11),
	xmm12->as_VMReg()->next(12),
	xmm12->as_VMReg()->next(13),
	xmm12->as_VMReg()->next(14),
	xmm12->as_VMReg()->next(15),
	xmm13->as_VMReg(),
	xmm13->as_VMReg()->next(1),
	xmm13->as_VMReg()->next(2),
	xmm13->as_VMReg()->next(3),
	xmm13->as_VMReg()->next(4),
	xmm13->as_VMReg()->next(5),
	xmm13->as_VMReg()->next(6),
	xmm13->as_VMReg()->next(7),
	xmm13->as_VMReg()->next(8),
	xmm13->as_VMReg()->next(9),
	xmm13->as_VMReg()->next(10),
	xmm13->as_VMReg()->next(11),
	xmm13->as_VMReg()->next(12),
	xmm13->as_VMReg()->next(13),
	xmm13->as_VMReg()->next(14),
	xmm13->as_VMReg()->next(15),
	xmm14->as_VMReg(),
	xmm14->as_VMReg()->next(1),
	xmm14->as_VMReg()->next(2),
	xmm14->as_VMReg()->next(3),
	xmm14->as_VMReg()->next(4),
	xmm14->as_VMReg()->next(5),
	xmm14->as_VMReg()->next(6),
	xmm14->as_VMReg()->next(7),
	xmm14->as_VMReg()->next(8),
	xmm14->as_VMReg()->next(9),
	xmm14->as_VMReg()->next(10),
	xmm14->as_VMReg()->next(11),
	xmm14->as_VMReg()->next(12),
	xmm14->as_VMReg()->next(13),
	xmm14->as_VMReg()->next(14),
	xmm14->as_VMReg()->next(15),
	xmm15->as_VMReg(),
	xmm15->as_VMReg()->next(1),
	xmm15->as_VMReg()->next(2),
	xmm15->as_VMReg()->next(3),
	xmm15->as_VMReg()->next(4),
	xmm15->as_VMReg()->next(5),
	xmm15->as_VMReg()->next(6),
	xmm15->as_VMReg()->next(7),
	xmm15->as_VMReg()->next(8),
	xmm15->as_VMReg()->next(9),
	xmm15->as_VMReg()->next(10),
	xmm15->as_VMReg()->next(11),
	xmm15->as_VMReg()->next(12),
	xmm15->as_VMReg()->next(13),
	xmm15->as_VMReg()->next(14),
	xmm15->as_VMReg()->next(15),
	xmm16->as_VMReg(),
	xmm16->as_VMReg()->next(1),
	xmm16->as_VMReg()->next(2),
	xmm16->as_VMReg()->next(3),
	xmm16->as_VMReg()->next(4),
	xmm16->as_VMReg()->next(5),
	xmm16->as_VMReg()->next(6),
	xmm16->as_VMReg()->next(7),
	xmm16->as_VMReg()->next(8),
	xmm16->as_VMReg()->next(9),
	xmm16->as_VMReg()->next(10),
	xmm16->as_VMReg()->next(11),
	xmm16->as_VMReg()->next(12),
	xmm16->as_VMReg()->next(13),
	xmm16->as_VMReg()->next(14),
	xmm16->as_VMReg()->next(15),
	xmm17->as_VMReg(),
	xmm17->as_VMReg()->next(1),
	xmm17->as_VMReg()->next(2),
	xmm17->as_VMReg()->next(3),
	xmm17->as_VMReg()->next(4),
	xmm17->as_VMReg()->next(5),
	xmm17->as_VMReg()->next(6),
	xmm17->as_VMReg()->next(7),
	xmm17->as_VMReg()->next(8),
	xmm17->as_VMReg()->next(9),
	xmm17->as_VMReg()->next(10),
	xmm17->as_VMReg()->next(11),
	xmm17->as_VMReg()->next(12),
	xmm17->as_VMReg()->next(13),
	xmm17->as_VMReg()->next(14),
	xmm17->as_VMReg()->next(15),
	xmm18->as_VMReg(),
	xmm18->as_VMReg()->next(1),
	xmm18->as_VMReg()->next(2),
	xmm18->as_VMReg()->next(3),
	xmm18->as_VMReg()->next(4),
	xmm18->as_VMReg()->next(5),
	xmm18->as_VMReg()->next(6),
	xmm18->as_VMReg()->next(7),
	xmm18->as_VMReg()->next(8),
	xmm18->as_VMReg()->next(9),
	xmm18->as_VMReg()->next(10),
	xmm18->as_VMReg()->next(11),
	xmm18->as_VMReg()->next(12),
	xmm18->as_VMReg()->next(13),
	xmm18->as_VMReg()->next(14),
	xmm18->as_VMReg()->next(15),
	xmm19->as_VMReg(),
	xmm19->as_VMReg()->next(1),
	xmm19->as_VMReg()->next(2),
	xmm19->as_VMReg()->next(3),
	xmm19->as_VMReg()->next(4),
	xmm19->as_VMReg()->next(5),
	xmm19->as_VMReg()->next(6),
	xmm19->as_VMReg()->next(7),
	xmm19->as_VMReg()->next(8),
	xmm19->as_VMReg()->next(9),
	xmm19->as_VMReg()->next(10),
	xmm19->as_VMReg()->next(11),
	xmm19->as_VMReg()->next(12),
	xmm19->as_VMReg()->next(13),
	xmm19->as_VMReg()->next(14),
	xmm19->as_VMReg()->next(15),
	xmm20->as_VMReg(),
	xmm20->as_VMReg()->next(1),
	xmm20->as_VMReg()->next(2),
	xmm20->as_VMReg()->next(3),
	xmm20->as_VMReg()->next(4),
	xmm20->as_VMReg()->next(5),
	xmm20->as_VMReg()->next(6),
	xmm20->as_VMReg()->next(7),
	xmm20->as_VMReg()->next(8),
	xmm20->as_VMReg()->next(9),
	xmm20->as_VMReg()->next(10),
	xmm20->as_VMReg()->next(11),
	xmm20->as_VMReg()->next(12),
	xmm20->as_VMReg()->next(13),
	xmm20->as_VMReg()->next(14),
	xmm20->as_VMReg()->next(15),
	xmm21->as_VMReg(),
	xmm21->as_VMReg()->next(1),
	xmm21->as_VMReg()->next(2),
	xmm21->as_VMReg()->next(3),
	xmm21->as_VMReg()->next(4),
	xmm21->as_VMReg()->next(5),
	xmm21->as_VMReg()->next(6),
	xmm21->as_VMReg()->next(7),
	xmm21->as_VMReg()->next(8),
	xmm21->as_VMReg()->next(9),
	xmm21->as_VMReg()->next(10),
	xmm21->as_VMReg()->next(11),
	xmm21->as_VMReg()->next(12),
	xmm21->as_VMReg()->next(13),
	xmm21->as_VMReg()->next(14),
	xmm21->as_VMReg()->next(15),
	xmm22->as_VMReg(),
	xmm22->as_VMReg()->next(1),
	xmm22->as_VMReg()->next(2),
	xmm22->as_VMReg()->next(3),
	xmm22->as_VMReg()->next(4),
	xmm22->as_VMReg()->next(5),
	xmm22->as_VMReg()->next(6),
	xmm22->as_VMReg()->next(7),
	xmm22->as_VMReg()->next(8),
	xmm22->as_VMReg()->next(9),
	xmm22->as_VMReg()->next(10),
	xmm22->as_VMReg()->next(11),
	xmm22->as_VMReg()->next(12),
	xmm22->as_VMReg()->next(13),
	xmm22->as_VMReg()->next(14),
	xmm22->as_VMReg()->next(15),
	xmm23->as_VMReg(),
	xmm23->as_VMReg()->next(1),
	xmm23->as_VMReg()->next(2),
	xmm23->as_VMReg()->next(3),
	xmm23->as_VMReg()->next(4),
	xmm23->as_VMReg()->next(5),
	xmm23->as_VMReg()->next(6),
	xmm23->as_VMReg()->next(7),
	xmm23->as_VMReg()->next(8),
	xmm23->as_VMReg()->next(9),
	xmm23->as_VMReg()->next(10),
	xmm23->as_VMReg()->next(11),
	xmm23->as_VMReg()->next(12),
	xmm23->as_VMReg()->next(13),
	xmm23->as_VMReg()->next(14),
	xmm23->as_VMReg()->next(15),
	xmm24->as_VMReg(),
	xmm24->as_VMReg()->next(1),
	xmm24->as_VMReg()->next(2),
	xmm24->as_VMReg()->next(3),
	xmm24->as_VMReg()->next(4),
	xmm24->as_VMReg()->next(5),
	xmm24->as_VMReg()->next(6),
	xmm24->as_VMReg()->next(7),
	xmm24->as_VMReg()->next(8),
	xmm24->as_VMReg()->next(9),
	xmm24->as_VMReg()->next(10),
	xmm24->as_VMReg()->next(11),
	xmm24->as_VMReg()->next(12),
	xmm24->as_VMReg()->next(13),
	xmm24->as_VMReg()->next(14),
	xmm24->as_VMReg()->next(15),
	xmm25->as_VMReg(),
	xmm25->as_VMReg()->next(1),
	xmm25->as_VMReg()->next(2),
	xmm25->as_VMReg()->next(3),
	xmm25->as_VMReg()->next(4),
	xmm25->as_VMReg()->next(5),
	xmm25->as_VMReg()->next(6),
	xmm25->as_VMReg()->next(7),
	xmm25->as_VMReg()->next(8),
	xmm25->as_VMReg()->next(9),
	xmm25->as_VMReg()->next(10),
	xmm25->as_VMReg()->next(11),
	xmm25->as_VMReg()->next(12),
	xmm25->as_VMReg()->next(13),
	xmm25->as_VMReg()->next(14),
	xmm25->as_VMReg()->next(15),
	xmm26->as_VMReg(),
	xmm26->as_VMReg()->next(1),
	xmm26->as_VMReg()->next(2),
	xmm26->as_VMReg()->next(3),
	xmm26->as_VMReg()->next(4),
	xmm26->as_VMReg()->next(5),
	xmm26->as_VMReg()->next(6),
	xmm26->as_VMReg()->next(7),
	xmm26->as_VMReg()->next(8),
	xmm26->as_VMReg()->next(9),
	xmm26->as_VMReg()->next(10),
	xmm26->as_VMReg()->next(11),
	xmm26->as_VMReg()->next(12),
	xmm26->as_VMReg()->next(13),
	xmm26->as_VMReg()->next(14),
	xmm26->as_VMReg()->next(15),
	xmm27->as_VMReg(),
	xmm27->as_VMReg()->next(1),
	xmm27->as_VMReg()->next(2),
	xmm27->as_VMReg()->next(3),
	xmm27->as_VMReg()->next(4),
	xmm27->as_VMReg()->next(5),
	xmm27->as_VMReg()->next(6),
	xmm27->as_VMReg()->next(7),
	xmm27->as_VMReg()->next(8),
	xmm27->as_VMReg()->next(9),
	xmm27->as_VMReg()->next(10),
	xmm27->as_VMReg()->next(11),
	xmm27->as_VMReg()->next(12),
	xmm27->as_VMReg()->next(13),
	xmm27->as_VMReg()->next(14),
	xmm27->as_VMReg()->next(15),
	xmm28->as_VMReg(),
	xmm28->as_VMReg()->next(1),
	xmm28->as_VMReg()->next(2),
	xmm28->as_VMReg()->next(3),
	xmm28->as_VMReg()->next(4),
	xmm28->as_VMReg()->next(5),
	xmm28->as_VMReg()->next(6),
	xmm28->as_VMReg()->next(7),
	xmm28->as_VMReg()->next(8),
	xmm28->as_VMReg()->next(9),
	xmm28->as_VMReg()->next(10),
	xmm28->as_VMReg()->next(11),
	xmm28->as_VMReg()->next(12),
	xmm28->as_VMReg()->next(13),
	xmm28->as_VMReg()->next(14),
	xmm28->as_VMReg()->next(15),
	xmm29->as_VMReg(),
	xmm29->as_VMReg()->next(1),
	xmm29->as_VMReg()->next(2),
	xmm29->as_VMReg()->next(3),
	xmm29->as_VMReg()->next(4),
	xmm29->as_VMReg()->next(5),
	xmm29->as_VMReg()->next(6),
	xmm29->as_VMReg()->next(7),
	xmm29->as_VMReg()->next(8),
	xmm29->as_VMReg()->next(9),
	xmm29->as_VMReg()->next(10),
	xmm29->as_VMReg()->next(11),
	xmm29->as_VMReg()->next(12),
	xmm29->as_VMReg()->next(13),
	xmm29->as_VMReg()->next(14),
	xmm29->as_VMReg()->next(15),
	xmm30->as_VMReg(),
	xmm30->as_VMReg()->next(1),
	xmm30->as_VMReg()->next(2),
	xmm30->as_VMReg()->next(3),
	xmm30->as_VMReg()->next(4),
	xmm30->as_VMReg()->next(5),
	xmm30->as_VMReg()->next(6),
	xmm30->as_VMReg()->next(7),
	xmm30->as_VMReg()->next(8),
	xmm30->as_VMReg()->next(9),
	xmm30->as_VMReg()->next(10),
	xmm30->as_VMReg()->next(11),
	xmm30->as_VMReg()->next(12),
	xmm30->as_VMReg()->next(13),
	xmm30->as_VMReg()->next(14),
	xmm30->as_VMReg()->next(15),
	xmm31->as_VMReg(),
	xmm31->as_VMReg()->next(1),
	xmm31->as_VMReg()->next(2),
	xmm31->as_VMReg()->next(3),
	xmm31->as_VMReg()->next(4),
	xmm31->as_VMReg()->next(5),
	xmm31->as_VMReg()->next(6),
	xmm31->as_VMReg()->next(7),
	xmm31->as_VMReg()->next(8),
	xmm31->as_VMReg()->next(9),
	xmm31->as_VMReg()->next(10),
	xmm31->as_VMReg()->next(11),
	xmm31->as_VMReg()->next(12),
	xmm31->as_VMReg()->next(13),
	xmm31->as_VMReg()->next(14),
	xmm31->as_VMReg()->next(15),
	VMRegImpl::Bad() // no trailing comma
	};

 OptoReg::Name OptoReg::vm2opto[ConcreteRegisterImpl::number_of_registers];

// An array of the machine register encode values
const unsigned char Matcher::_regEncode[REG_COUNT] = {
  (unsigned char)'\xA',  // R10
  (unsigned char)'\xA',  // R10_H
  (unsigned char)'\xB',  // R11
  (unsigned char)'\xB',  // R11_H
  (unsigned char)'\x8',  // R8
  (unsigned char)'\x8',  // R8_H
  (unsigned char)'\x9',  // R9
  (unsigned char)'\x9',  // R9_H
  (unsigned char)'\xC',  // R12
  (unsigned char)'\xC',  // R12_H
  (unsigned char)'\x1',  // RCX
  (unsigned char)'\x1',  // RCX_H
  (unsigned char)'\x3',  // RBX
  (unsigned char)'\x3',  // RBX_H
  (unsigned char)'\x7',  // RDI
  (unsigned char)'\x7',  // RDI_H
  (unsigned char)'\x2',  // RDX
  (unsigned char)'\x2',  // RDX_H
  (unsigned char)'\x6',  // RSI
  (unsigned char)'\x6',  // RSI_H
  (unsigned char)'\x0',  // RAX
  (unsigned char)'\x0',  // RAX_H
  (unsigned char)'\x5',  // RBP
  (unsigned char)'\x5',  // RBP_H
  (unsigned char)'\xD',  // R13
  (unsigned char)'\xD',  // R13_H
  (unsigned char)'\xE',  // R14
  (unsigned char)'\xE',  // R14_H
  (unsigned char)'\xF',  // R15
  (unsigned char)'\xF',  // R15_H
  (unsigned char)'\x4',  // RSP
  (unsigned char)'\x4',  // RSP_H
  (unsigned char)'\x0',  // XMM0
  (unsigned char)'\x0',  // XMM0b
  (unsigned char)'\x0',  // XMM0c
  (unsigned char)'\x0',  // XMM0d
  (unsigned char)'\x0',  // XMM0e
  (unsigned char)'\x0',  // XMM0f
  (unsigned char)'\x0',  // XMM0g
  (unsigned char)'\x0',  // XMM0h
  (unsigned char)'\x0',  // XMM0i
  (unsigned char)'\x0',  // XMM0j
  (unsigned char)'\x0',  // XMM0k
  (unsigned char)'\x0',  // XMM0l
  (unsigned char)'\x0',  // XMM0m
  (unsigned char)'\x0',  // XMM0n
  (unsigned char)'\x0',  // XMM0o
  (unsigned char)'\x0',  // XMM0p
  (unsigned char)'\x1',  // XMM1
  (unsigned char)'\x1',  // XMM1b
  (unsigned char)'\x1',  // XMM1c
  (unsigned char)'\x1',  // XMM1d
  (unsigned char)'\x1',  // XMM1e
  (unsigned char)'\x1',  // XMM1f
  (unsigned char)'\x1',  // XMM1g
  (unsigned char)'\x1',  // XMM1h
  (unsigned char)'\x1',  // XMM1i
  (unsigned char)'\x1',  // XMM1j
  (unsigned char)'\x1',  // XMM1k
  (unsigned char)'\x1',  // XMM1l
  (unsigned char)'\x1',  // XMM1m
  (unsigned char)'\x1',  // XMM1n
  (unsigned char)'\x1',  // XMM1o
  (unsigned char)'\x1',  // XMM1p
  (unsigned char)'\x2',  // XMM2
  (unsigned char)'\x2',  // XMM2b
  (unsigned char)'\x2',  // XMM2c
  (unsigned char)'\x2',  // XMM2d
  (unsigned char)'\x2',  // XMM2e
  (unsigned char)'\x2',  // XMM2f
  (unsigned char)'\x2',  // XMM2g
  (unsigned char)'\x2',  // XMM2h
  (unsigned char)'\x2',  // XMM2i
  (unsigned char)'\x2',  // XMM2j
  (unsigned char)'\x2',  // XMM2k
  (unsigned char)'\x2',  // XMM2l
  (unsigned char)'\x2',  // XMM2m
  (unsigned char)'\x2',  // XMM2n
  (unsigned char)'\x2',  // XMM2o
  (unsigned char)'\x2',  // XMM2p
  (unsigned char)'\x3',  // XMM3
  (unsigned char)'\x3',  // XMM3b
  (unsigned char)'\x3',  // XMM3c
  (unsigned char)'\x3',  // XMM3d
  (unsigned char)'\x3',  // XMM3e
  (unsigned char)'\x3',  // XMM3f
  (unsigned char)'\x3',  // XMM3g
  (unsigned char)'\x3',  // XMM3h
  (unsigned char)'\x3',  // XMM3i
  (unsigned char)'\x3',  // XMM3j
  (unsigned char)'\x3',  // XMM3k
  (unsigned char)'\x3',  // XMM3l
  (unsigned char)'\x3',  // XMM3m
  (unsigned char)'\x3',  // XMM3n
  (unsigned char)'\x3',  // XMM3o
  (unsigned char)'\x3',  // XMM3p
  (unsigned char)'\x4',  // XMM4
  (unsigned char)'\x4',  // XMM4b
  (unsigned char)'\x4',  // XMM4c
  (unsigned char)'\x4',  // XMM4d
  (unsigned char)'\x4',  // XMM4e
  (unsigned char)'\x4',  // XMM4f
  (unsigned char)'\x4',  // XMM4g
  (unsigned char)'\x4',  // XMM4h
  (unsigned char)'\x4',  // XMM4i
  (unsigned char)'\x4',  // XMM4j
  (unsigned char)'\x4',  // XMM4k
  (unsigned char)'\x4',  // XMM4l
  (unsigned char)'\x4',  // XMM4m
  (unsigned char)'\x4',  // XMM4n
  (unsigned char)'\x4',  // XMM4o
  (unsigned char)'\x4',  // XMM4p
  (unsigned char)'\x5',  // XMM5
  (unsigned char)'\x5',  // XMM5b
  (unsigned char)'\x5',  // XMM5c
  (unsigned char)'\x5',  // XMM5d
  (unsigned char)'\x5',  // XMM5e
  (unsigned char)'\x5',  // XMM5f
  (unsigned char)'\x5',  // XMM5g
  (unsigned char)'\x5',  // XMM5h
  (unsigned char)'\x5',  // XMM5i
  (unsigned char)'\x5',  // XMM5j
  (unsigned char)'\x5',  // XMM5k
  (unsigned char)'\x5',  // XMM5l
  (unsigned char)'\x5',  // XMM5m
  (unsigned char)'\x5',  // XMM5n
  (unsigned char)'\x5',  // XMM5o
  (unsigned char)'\x5',  // XMM5p
  (unsigned char)'\x6',  // XMM6
  (unsigned char)'\x6',  // XMM6b
  (unsigned char)'\x6',  // XMM6c
  (unsigned char)'\x6',  // XMM6d
  (unsigned char)'\x6',  // XMM6e
  (unsigned char)'\x6',  // XMM6f
  (unsigned char)'\x6',  // XMM6g
  (unsigned char)'\x6',  // XMM6h
  (unsigned char)'\x6',  // XMM6i
  (unsigned char)'\x6',  // XMM6j
  (unsigned char)'\x6',  // XMM6k
  (unsigned char)'\x6',  // XMM6l
  (unsigned char)'\x6',  // XMM6m
  (unsigned char)'\x6',  // XMM6n
  (unsigned char)'\x6',  // XMM6o
  (unsigned char)'\x6',  // XMM6p
  (unsigned char)'\x7',  // XMM7
  (unsigned char)'\x7',  // XMM7b
  (unsigned char)'\x7',  // XMM7c
  (unsigned char)'\x7',  // XMM7d
  (unsigned char)'\x7',  // XMM7e
  (unsigned char)'\x7',  // XMM7f
  (unsigned char)'\x7',  // XMM7g
  (unsigned char)'\x7',  // XMM7h
  (unsigned char)'\x7',  // XMM7i
  (unsigned char)'\x7',  // XMM7j
  (unsigned char)'\x7',  // XMM7k
  (unsigned char)'\x7',  // XMM7l
  (unsigned char)'\x7',  // XMM7m
  (unsigned char)'\x7',  // XMM7n
  (unsigned char)'\x7',  // XMM7o
  (unsigned char)'\x7',  // XMM7p
  (unsigned char)'\x8',  // XMM8
  (unsigned char)'\x8',  // XMM8b
  (unsigned char)'\x8',  // XMM8c
  (unsigned char)'\x8',  // XMM8d
  (unsigned char)'\x8',  // XMM8e
  (unsigned char)'\x8',  // XMM8f
  (unsigned char)'\x8',  // XMM8g
  (unsigned char)'\x8',  // XMM8h
  (unsigned char)'\x8',  // XMM8i
  (unsigned char)'\x8',  // XMM8j
  (unsigned char)'\x8',  // XMM8k
  (unsigned char)'\x8',  // XMM8l
  (unsigned char)'\x8',  // XMM8m
  (unsigned char)'\x8',  // XMM8n
  (unsigned char)'\x8',  // XMM8o
  (unsigned char)'\x8',  // XMM8p
  (unsigned char)'\x9',  // XMM9
  (unsigned char)'\x9',  // XMM9b
  (unsigned char)'\x9',  // XMM9c
  (unsigned char)'\x9',  // XMM9d
  (unsigned char)'\x9',  // XMM9e
  (unsigned char)'\x9',  // XMM9f
  (unsigned char)'\x9',  // XMM9g
  (unsigned char)'\x9',  // XMM9h
  (unsigned char)'\x9',  // XMM9i
  (unsigned char)'\x9',  // XMM9j
  (unsigned char)'\x9',  // XMM9k
  (unsigned char)'\x9',  // XMM9l
  (unsigned char)'\x9',  // XMM9m
  (unsigned char)'\x9',  // XMM9n
  (unsigned char)'\x9',  // XMM9o
  (unsigned char)'\x9',  // XMM9p
  (unsigned char)'\xA',  // XMM10
  (unsigned char)'\xA',  // XMM10b
  (unsigned char)'\xA',  // XMM10c
  (unsigned char)'\xA',  // XMM10d
  (unsigned char)'\xA',  // XMM10e
  (unsigned char)'\xA',  // XMM10f
  (unsigned char)'\xA',  // XMM10g
  (unsigned char)'\xA',  // XMM10h
  (unsigned char)'\xA',  // XMM10i
  (unsigned char)'\xA',  // XMM10j
  (unsigned char)'\xA',  // XMM10k
  (unsigned char)'\xA',  // XMM10l
  (unsigned char)'\xA',  // XMM10m
  (unsigned char)'\xA',  // XMM10n
  (unsigned char)'\xA',  // XMM10o
  (unsigned char)'\xA',  // XMM10p
  (unsigned char)'\xB',  // XMM11
  (unsigned char)'\xB',  // XMM11b
  (unsigned char)'\xB',  // XMM11c
  (unsigned char)'\xB',  // XMM11d
  (unsigned char)'\xB',  // XMM11e
  (unsigned char)'\xB',  // XMM11f
  (unsigned char)'\xB',  // XMM11g
  (unsigned char)'\xB',  // XMM11h
  (unsigned char)'\xB',  // XMM11i
  (unsigned char)'\xB',  // XMM11j
  (unsigned char)'\xB',  // XMM11k
  (unsigned char)'\xB',  // XMM11l
  (unsigned char)'\xB',  // XMM11m
  (unsigned char)'\xB',  // XMM11n
  (unsigned char)'\xB',  // XMM11o
  (unsigned char)'\xB',  // XMM11p
  (unsigned char)'\xC',  // XMM12
  (unsigned char)'\xC',  // XMM12b
  (unsigned char)'\xC',  // XMM12c
  (unsigned char)'\xC',  // XMM12d
  (unsigned char)'\xC',  // XMM12e
  (unsigned char)'\xC',  // XMM12f
  (unsigned char)'\xC',  // XMM12g
  (unsigned char)'\xC',  // XMM12h
  (unsigned char)'\xC',  // XMM12i
  (unsigned char)'\xC',  // XMM12j
  (unsigned char)'\xC',  // XMM12k
  (unsigned char)'\xC',  // XMM12l
  (unsigned char)'\xC',  // XMM12m
  (unsigned char)'\xC',  // XMM12n
  (unsigned char)'\xC',  // XMM12o
  (unsigned char)'\xC',  // XMM12p
  (unsigned char)'\xD',  // XMM13
  (unsigned char)'\xD',  // XMM13b
  (unsigned char)'\xD',  // XMM13c
  (unsigned char)'\xD',  // XMM13d
  (unsigned char)'\xD',  // XMM13e
  (unsigned char)'\xD',  // XMM13f
  (unsigned char)'\xD',  // XMM13g
  (unsigned char)'\xD',  // XMM13h
  (unsigned char)'\xD',  // XMM13i
  (unsigned char)'\xD',  // XMM13j
  (unsigned char)'\xD',  // XMM13k
  (unsigned char)'\xD',  // XMM13l
  (unsigned char)'\xD',  // XMM13m
  (unsigned char)'\xD',  // XMM13n
  (unsigned char)'\xD',  // XMM13o
  (unsigned char)'\xD',  // XMM13p
  (unsigned char)'\xE',  // XMM14
  (unsigned char)'\xE',  // XMM14b
  (unsigned char)'\xE',  // XMM14c
  (unsigned char)'\xE',  // XMM14d
  (unsigned char)'\xE',  // XMM14e
  (unsigned char)'\xE',  // XMM14f
  (unsigned char)'\xE',  // XMM14g
  (unsigned char)'\xE',  // XMM14h
  (unsigned char)'\xE',  // XMM14i
  (unsigned char)'\xE',  // XMM14j
  (unsigned char)'\xE',  // XMM14k
  (unsigned char)'\xE',  // XMM14l
  (unsigned char)'\xE',  // XMM14m
  (unsigned char)'\xE',  // XMM14n
  (unsigned char)'\xE',  // XMM14o
  (unsigned char)'\xE',  // XMM14p
  (unsigned char)'\xF',  // XMM15
  (unsigned char)'\xF',  // XMM15b
  (unsigned char)'\xF',  // XMM15c
  (unsigned char)'\xF',  // XMM15d
  (unsigned char)'\xF',  // XMM15e
  (unsigned char)'\xF',  // XMM15f
  (unsigned char)'\xF',  // XMM15g
  (unsigned char)'\xF',  // XMM15h
  (unsigned char)'\xF',  // XMM15i
  (unsigned char)'\xF',  // XMM15j
  (unsigned char)'\xF',  // XMM15k
  (unsigned char)'\xF',  // XMM15l
  (unsigned char)'\xF',  // XMM15m
  (unsigned char)'\xF',  // XMM15n
  (unsigned char)'\xF',  // XMM15o
  (unsigned char)'\xF',  // XMM15p
  (unsigned char)'\x10',  // XMM16
  (unsigned char)'\x10',  // XMM16b
  (unsigned char)'\x10',  // XMM16c
  (unsigned char)'\x10',  // XMM16d
  (unsigned char)'\x10',  // XMM16e
  (unsigned char)'\x10',  // XMM16f
  (unsigned char)'\x10',  // XMM16g
  (unsigned char)'\x10',  // XMM16h
  (unsigned char)'\x10',  // XMM16i
  (unsigned char)'\x10',  // XMM16j
  (unsigned char)'\x10',  // XMM16k
  (unsigned char)'\x10',  // XMM16l
  (unsigned char)'\x10',  // XMM16m
  (unsigned char)'\x10',  // XMM16n
  (unsigned char)'\x10',  // XMM16o
  (unsigned char)'\x10',  // XMM16p
  (unsigned char)'\x11',  // XMM17
  (unsigned char)'\x11',  // XMM17b
  (unsigned char)'\x11',  // XMM17c
  (unsigned char)'\x11',  // XMM17d
  (unsigned char)'\x11',  // XMM17e
  (unsigned char)'\x11',  // XMM17f
  (unsigned char)'\x11',  // XMM17g
  (unsigned char)'\x11',  // XMM17h
  (unsigned char)'\x11',  // XMM17i
  (unsigned char)'\x11',  // XMM17j
  (unsigned char)'\x11',  // XMM17k
  (unsigned char)'\x11',  // XMM17l
  (unsigned char)'\x11',  // XMM17m
  (unsigned char)'\x11',  // XMM17n
  (unsigned char)'\x11',  // XMM17o
  (unsigned char)'\x11',  // XMM17p
  (unsigned char)'\x12',  // XMM18
  (unsigned char)'\x12',  // XMM18b
  (unsigned char)'\x12',  // XMM18c
  (unsigned char)'\x12',  // XMM18d
  (unsigned char)'\x12',  // XMM18e
  (unsigned char)'\x12',  // XMM18f
  (unsigned char)'\x12',  // XMM18g
  (unsigned char)'\x12',  // XMM18h
  (unsigned char)'\x12',  // XMM18i
  (unsigned char)'\x12',  // XMM18j
  (unsigned char)'\x12',  // XMM18k
  (unsigned char)'\x12',  // XMM18l
  (unsigned char)'\x12',  // XMM18m
  (unsigned char)'\x12',  // XMM18n
  (unsigned char)'\x12',  // XMM18o
  (unsigned char)'\x12',  // XMM18p
  (unsigned char)'\x13',  // XMM19
  (unsigned char)'\x13',  // XMM19b
  (unsigned char)'\x13',  // XMM19c
  (unsigned char)'\x13',  // XMM19d
  (unsigned char)'\x13',  // XMM19e
  (unsigned char)'\x13',  // XMM19f
  (unsigned char)'\x13',  // XMM19g
  (unsigned char)'\x13',  // XMM19h
  (unsigned char)'\x13',  // XMM19i
  (unsigned char)'\x13',  // XMM19j
  (unsigned char)'\x13',  // XMM19k
  (unsigned char)'\x13',  // XMM19l
  (unsigned char)'\x13',  // XMM19m
  (unsigned char)'\x13',  // XMM19n
  (unsigned char)'\x13',  // XMM19o
  (unsigned char)'\x13',  // XMM19p
  (unsigned char)'\x14',  // XMM20
  (unsigned char)'\x14',  // XMM20b
  (unsigned char)'\x14',  // XMM20c
  (unsigned char)'\x14',  // XMM20d
  (unsigned char)'\x14',  // XMM20e
  (unsigned char)'\x14',  // XMM20f
  (unsigned char)'\x14',  // XMM20g
  (unsigned char)'\x14',  // XMM20h
  (unsigned char)'\x14',  // XMM20i
  (unsigned char)'\x14',  // XMM20j
  (unsigned char)'\x14',  // XMM20k
  (unsigned char)'\x14',  // XMM20l
  (unsigned char)'\x14',  // XMM20m
  (unsigned char)'\x14',  // XMM20n
  (unsigned char)'\x14',  // XMM20o
  (unsigned char)'\x14',  // XMM20p
  (unsigned char)'\x15',  // XMM21
  (unsigned char)'\x15',  // XMM21b
  (unsigned char)'\x15',  // XMM21c
  (unsigned char)'\x15',  // XMM21d
  (unsigned char)'\x15',  // XMM21e
  (unsigned char)'\x15',  // XMM21f
  (unsigned char)'\x15',  // XMM21g
  (unsigned char)'\x15',  // XMM21h
  (unsigned char)'\x15',  // XMM21i
  (unsigned char)'\x15',  // XMM21j
  (unsigned char)'\x15',  // XMM21k
  (unsigned char)'\x15',  // XMM21l
  (unsigned char)'\x15',  // XMM21m
  (unsigned char)'\x15',  // XMM21n
  (unsigned char)'\x15',  // XMM21o
  (unsigned char)'\x15',  // XMM21p
  (unsigned char)'\x16',  // XMM22
  (unsigned char)'\x16',  // XMM22b
  (unsigned char)'\x16',  // XMM22c
  (unsigned char)'\x16',  // XMM22d
  (unsigned char)'\x16',  // XMM22e
  (unsigned char)'\x16',  // XMM22f
  (unsigned char)'\x16',  // XMM22g
  (unsigned char)'\x16',  // XMM22h
  (unsigned char)'\x16',  // XMM22i
  (unsigned char)'\x16',  // XMM22j
  (unsigned char)'\x16',  // XMM22k
  (unsigned char)'\x16',  // XMM22l
  (unsigned char)'\x16',  // XMM22m
  (unsigned char)'\x16',  // XMM22n
  (unsigned char)'\x16',  // XMM22o
  (unsigned char)'\x16',  // XMM22p
  (unsigned char)'\x17',  // XMM23
  (unsigned char)'\x17',  // XMM23b
  (unsigned char)'\x17',  // XMM23c
  (unsigned char)'\x17',  // XMM23d
  (unsigned char)'\x17',  // XMM23e
  (unsigned char)'\x17',  // XMM23f
  (unsigned char)'\x17',  // XMM23g
  (unsigned char)'\x17',  // XMM23h
  (unsigned char)'\x17',  // XMM23i
  (unsigned char)'\x17',  // XMM23j
  (unsigned char)'\x17',  // XMM23k
  (unsigned char)'\x17',  // XMM23l
  (unsigned char)'\x17',  // XMM23m
  (unsigned char)'\x17',  // XMM23n
  (unsigned char)'\x17',  // XMM23o
  (unsigned char)'\x17',  // XMM23p
  (unsigned char)'\x18',  // XMM24
  (unsigned char)'\x18',  // XMM24b
  (unsigned char)'\x18',  // XMM24c
  (unsigned char)'\x18',  // XMM24d
  (unsigned char)'\x18',  // XMM24e
  (unsigned char)'\x18',  // XMM24f
  (unsigned char)'\x18',  // XMM24g
  (unsigned char)'\x18',  // XMM24h
  (unsigned char)'\x18',  // XMM24i
  (unsigned char)'\x18',  // XMM24j
  (unsigned char)'\x18',  // XMM24k
  (unsigned char)'\x18',  // XMM24l
  (unsigned char)'\x18',  // XMM24m
  (unsigned char)'\x18',  // XMM24n
  (unsigned char)'\x18',  // XMM24o
  (unsigned char)'\x18',  // XMM24p
  (unsigned char)'\x19',  // XMM25
  (unsigned char)'\x19',  // XMM25b
  (unsigned char)'\x19',  // XMM25c
  (unsigned char)'\x19',  // XMM25d
  (unsigned char)'\x19',  // XMM25e
  (unsigned char)'\x19',  // XMM25f
  (unsigned char)'\x19',  // XMM25g
  (unsigned char)'\x19',  // XMM25h
  (unsigned char)'\x19',  // XMM25i
  (unsigned char)'\x19',  // XMM25j
  (unsigned char)'\x19',  // XMM25k
  (unsigned char)'\x19',  // XMM25l
  (unsigned char)'\x19',  // XMM25m
  (unsigned char)'\x19',  // XMM25n
  (unsigned char)'\x19',  // XMM25o
  (unsigned char)'\x19',  // XMM25p
  (unsigned char)'\x1A',  // XMM26
  (unsigned char)'\x1A',  // XMM26b
  (unsigned char)'\x1A',  // XMM26c
  (unsigned char)'\x1A',  // XMM26d
  (unsigned char)'\x1A',  // XMM26e
  (unsigned char)'\x1A',  // XMM26f
  (unsigned char)'\x1A',  // XMM26g
  (unsigned char)'\x1A',  // XMM26h
  (unsigned char)'\x1A',  // XMM26i
  (unsigned char)'\x1A',  // XMM26j
  (unsigned char)'\x1A',  // XMM26k
  (unsigned char)'\x1A',  // XMM26l
  (unsigned char)'\x1A',  // XMM26m
  (unsigned char)'\x1A',  // XMM26n
  (unsigned char)'\x1A',  // XMM26o
  (unsigned char)'\x1A',  // XMM26p
  (unsigned char)'\x1B',  // XMM27
  (unsigned char)'\x1B',  // XMM27b
  (unsigned char)'\x1B',  // XMM27c
  (unsigned char)'\x1B',  // XMM27d
  (unsigned char)'\x1B',  // XMM27e
  (unsigned char)'\x1B',  // XMM27f
  (unsigned char)'\x1B',  // XMM27g
  (unsigned char)'\x1B',  // XMM27h
  (unsigned char)'\x1B',  // XMM27i
  (unsigned char)'\x1B',  // XMM27j
  (unsigned char)'\x1B',  // XMM27k
  (unsigned char)'\x1B',  // XMM27l
  (unsigned char)'\x1B',  // XMM27m
  (unsigned char)'\x1B',  // XMM27n
  (unsigned char)'\x1B',  // XMM27o
  (unsigned char)'\x1B',  // XMM27p
  (unsigned char)'\x1C',  // XMM28
  (unsigned char)'\x1C',  // XMM28b
  (unsigned char)'\x1C',  // XMM28c
  (unsigned char)'\x1C',  // XMM28d
  (unsigned char)'\x1C',  // XMM28e
  (unsigned char)'\x1C',  // XMM28f
  (unsigned char)'\x1C',  // XMM28g
  (unsigned char)'\x1C',  // XMM28h
  (unsigned char)'\x1C',  // XMM28i
  (unsigned char)'\x1C',  // XMM28j
  (unsigned char)'\x1C',  // XMM28k
  (unsigned char)'\x1C',  // XMM28l
  (unsigned char)'\x1C',  // XMM28m
  (unsigned char)'\x1C',  // XMM28n
  (unsigned char)'\x1C',  // XMM28o
  (unsigned char)'\x1C',  // XMM28p
  (unsigned char)'\x1D',  // XMM29
  (unsigned char)'\x1D',  // XMM29b
  (unsigned char)'\x1D',  // XMM29c
  (unsigned char)'\x1D',  // XMM29d
  (unsigned char)'\x1D',  // XMM29e
  (unsigned char)'\x1D',  // XMM29f
  (unsigned char)'\x1D',  // XMM29g
  (unsigned char)'\x1D',  // XMM29h
  (unsigned char)'\x1D',  // XMM29i
  (unsigned char)'\x1D',  // XMM29j
  (unsigned char)'\x1D',  // XMM29k
  (unsigned char)'\x1D',  // XMM29l
  (unsigned char)'\x1D',  // XMM29m
  (unsigned char)'\x1D',  // XMM29n
  (unsigned char)'\x1D',  // XMM29o
  (unsigned char)'\x1D',  // XMM29p
  (unsigned char)'\x1E',  // XMM30
  (unsigned char)'\x1E',  // XMM30b
  (unsigned char)'\x1E',  // XMM30c
  (unsigned char)'\x1E',  // XMM30d
  (unsigned char)'\x1E',  // XMM30e
  (unsigned char)'\x1E',  // XMM30f
  (unsigned char)'\x1E',  // XMM30g
  (unsigned char)'\x1E',  // XMM30h
  (unsigned char)'\x1E',  // XMM30i
  (unsigned char)'\x1E',  // XMM30j
  (unsigned char)'\x1E',  // XMM30k
  (unsigned char)'\x1E',  // XMM30l
  (unsigned char)'\x1E',  // XMM30m
  (unsigned char)'\x1E',  // XMM30n
  (unsigned char)'\x1E',  // XMM30o
  (unsigned char)'\x1E',  // XMM30p
  (unsigned char)'\x1F',  // XMM31
  (unsigned char)'\x1F',  // XMM31b
  (unsigned char)'\x1F',  // XMM31c
  (unsigned char)'\x1F',  // XMM31d
  (unsigned char)'\x1F',  // XMM31e
  (unsigned char)'\x1F',  // XMM31f
  (unsigned char)'\x1F',  // XMM31g
  (unsigned char)'\x1F',  // XMM31h
  (unsigned char)'\x1F',  // XMM31i
  (unsigned char)'\x1F',  // XMM31j
  (unsigned char)'\x1F',  // XMM31k
  (unsigned char)'\x1F',  // XMM31l
  (unsigned char)'\x1F',  // XMM31m
  (unsigned char)'\x1F',  // XMM31n
  (unsigned char)'\x1F',  // XMM31o
  (unsigned char)'\x1F',  // XMM31p
  (unsigned char)'\x10' // no trailing comma  // RFLAGS
};


//------------------Define classes derived from MachOper---------------------
MachOper  *labelOper::clone() const {
  return  new labelOper(_label, _block_num);
}
uint labelOper::opcode() const { return LABEL; }

const RegMask *sRegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *sRegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *sRegFOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *sRegDOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *sRegLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

MachOper  *methodOper::clone() const {
  return  new methodOper(_method);
}
uint methodOper::opcode() const { return METHOD; }

const RegMask *rRegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_REG_mask();
}

const RegMask *rax_RegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_RAX_REG_mask();
}

const RegMask *rbx_RegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_RBX_REG_mask();
}

const RegMask *rcx_RegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_RCX_REG_mask();
}

const RegMask *rdx_RegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_RDX_REG_mask();
}

const RegMask *rdi_RegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_RDI_REG_mask();
}

const RegMask *no_rcx_RegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_NO_RCX_REG_mask();
}

const RegMask *no_rax_rdx_RegIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_NO_RAX_RDX_REG_mask();
}

const RegMask *any_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &ANY_REG_mask();
}

const RegMask *rRegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_REG_mask();
}

const RegMask *rRegNOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_REG_mask();
}

const RegMask *no_rax_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_NO_RAX_REG_mask();
}

const RegMask *no_rbp_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_REG_NO_RBP_mask();
}

const RegMask *no_rax_rbx_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_NO_RAX_RBX_REG_mask();
}

const RegMask *rax_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_RAX_REG_mask();
}

const RegMask *rax_RegNOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_RAX_REG_mask();
}

const RegMask *rbx_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_RBX_REG_mask();
}

const RegMask *rsi_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_RSI_REG_mask();
}

const RegMask *rdi_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_RDI_REG_mask();
}

const RegMask *r15_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_R15_REG_mask();
}

const RegMask *rex_RegPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_REX_REG_mask();
}

const RegMask *rRegLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &LONG_REG_mask();
}

const RegMask *no_rax_rdx_RegLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &LONG_NO_RAX_RDX_REG_mask();
}

const RegMask *no_rax_RegLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &LONG_NO_RAX_RDX_REG_mask();
}

const RegMask *no_rcx_RegLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &LONG_NO_RCX_REG_mask();
}

const RegMask *rax_RegLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &LONG_RAX_REG_mask();
}

const RegMask *rcx_RegLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &LONG_RCX_REG_mask();
}

const RegMask *rdx_RegLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &LONG_RDX_REG_mask();
}

const RegMask *rFlagsRegOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_FLAGS_mask();
}

const RegMask *rFlagsRegUOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_FLAGS_mask();
}

const RegMask *rFlagsRegUCFOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_FLAGS_mask();
}

const RegMask *regFOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &FLOAT_REG_mask();
}

const RegMask *legRegFOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &FLOAT_REG_LEGACY_mask();
}

const RegMask *vlRegFOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &FLOAT_REG_VL_mask();
}

const RegMask *regDOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &DOUBLE_REG_mask();
}

const RegMask *legRegDOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &DOUBLE_REG_LEGACY_mask();
}

const RegMask *vlRegDOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &DOUBLE_REG_VL_mask();
}

const RegMask *vecSOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORS_REG_VLBWDQ_mask();
}

const RegMask *legVecSOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORS_REG_LEGACY_mask();
}

const RegMask *vecDOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORD_REG_VLBWDQ_mask();
}

const RegMask *legVecDOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORD_REG_LEGACY_mask();
}

const RegMask *vecXOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORX_REG_VLBWDQ_mask();
}

const RegMask *legVecXOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORX_REG_LEGACY_mask();
}

const RegMask *vecYOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORY_REG_VLBWDQ_mask();
}

const RegMask *legVecYOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORY_REG_LEGACY_mask();
}

const RegMask *indirectOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &PTR_REG_mask();
}

const RegMask *indOffset8Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &ANY_REG_mask();
}

const RegMask *indOffset32Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &ANY_REG_mask();
}

const RegMask *indIndexOffsetOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &ANY_REG_mask();
  case 1: return &LONG_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indIndexOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &ANY_REG_mask();
  case 1: return &LONG_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indIndexScaleOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &ANY_REG_mask();
  case 1: return &LONG_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indPosIndexScaleOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &ANY_REG_mask();
  case 1: return &INT_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indIndexScaleOffsetOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &ANY_REG_mask();
  case 1: return &LONG_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indPosIndexOffsetOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &ANY_REG_mask();
  case 1: return &INT_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indPosIndexScaleOffsetOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &ANY_REG_mask();
  case 1: return &INT_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indCompressedOopOffsetOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_REG_mask();
}

const RegMask *indirectNarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_REG_mask();
}

const RegMask *indOffset8NarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_REG_mask();
}

const RegMask *indOffset32NarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &INT_REG_mask();
}

const RegMask *indIndexOffsetNarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &INT_REG_mask();
  case 1: return &LONG_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indIndexNarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &INT_REG_mask();
  case 1: return &LONG_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indIndexScaleNarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &INT_REG_mask();
  case 1: return &LONG_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indIndexScaleOffsetNarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  switch (index) {
  case 0: return &INT_REG_mask();
  case 1: return &LONG_REG_mask();
  }
  ShouldNotReachHere();
  return NULL;
}

const RegMask *indPosIndexOffsetNarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  return &INT_REG_mask();
}

const RegMask *indPosIndexScaleOffsetNarrowOper::in_RegMask(int index) const {
  assert(0 <= index && index < 2, "index out of range");
  return &INT_REG_mask();
}

const RegMask *stackSlotPOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *stackSlotIOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *stackSlotFOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *stackSlotDOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *stackSlotLOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &(Compile::current()->FIRST_STACK_mask());
}

const RegMask *rxmm0Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM0_REG_mask();
}

const RegMask *rxmm1Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM1_REG_mask();
}

const RegMask *rxmm2Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM2_REG_mask();
}

const RegMask *rxmm3Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM3_REG_mask();
}

const RegMask *rxmm4Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM4_REG_mask();
}

const RegMask *rxmm5Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM5_REG_mask();
}

const RegMask *rxmm6Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM6_REG_mask();
}

const RegMask *rxmm7Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM7_REG_mask();
}

const RegMask *rxmm8Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM8_REG_mask();
}

const RegMask *rxmm9Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM9_REG_mask();
}

const RegMask *rxmm10Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM10_REG_mask();
}

const RegMask *rxmm11Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM11_REG_mask();
}

const RegMask *rxmm12Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM12_REG_mask();
}

const RegMask *rxmm13Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM13_REG_mask();
}

const RegMask *rxmm14Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM14_REG_mask();
}

const RegMask *rxmm15Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM15_REG_mask();
}

const RegMask *rxmm16Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM16_REG_mask();
}

const RegMask *rxmm17Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM17_REG_mask();
}

const RegMask *rxmm18Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM18_REG_mask();
}

const RegMask *rxmm19Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM19_REG_mask();
}

const RegMask *rxmm20Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM20_REG_mask();
}

const RegMask *rxmm21Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM21_REG_mask();
}

const RegMask *rxmm22Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM22_REG_mask();
}

const RegMask *rxmm23Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM23_REG_mask();
}

const RegMask *rxmm24Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM24_REG_mask();
}

const RegMask *rxmm25Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM25_REG_mask();
}

const RegMask *rxmm26Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM26_REG_mask();
}

const RegMask *rxmm27Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM27_REG_mask();
}

const RegMask *rxmm28Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM28_REG_mask();
}

const RegMask *rxmm29Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM29_REG_mask();
}

const RegMask *rxmm30Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM30_REG_mask();
}

const RegMask *rxmm31Oper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &XMM31_REG_mask();
}

const RegMask *vecZOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORZ_REG_mask();
}

const RegMask *legVecZOper::in_RegMask(int index) const {
  assert(0 <= index && index < 1, "index out of range");
  return &VECTORZ_REG_LEGACY_mask();
}

//------------------Define members for classes derived from MachNode----------

void MoveVL2FNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_VL_mask();
}

// Build CISC version of this instruction
MachNode *MoveVL2FNode::cisc_version(int offset) {
  loadFNode *node = new loadFNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void MoveLEG2FNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_LEGACY_mask();
}

// Build CISC version of this instruction
MachNode *MoveLEG2FNode::cisc_version(int offset) {
  loadFNode *node = new loadFNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void MoveVL2DNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_VL_mask();
}

// Build CISC version of this instruction
MachNode *MoveVL2DNode::cisc_version(int offset) {
  loadSSDNode *node = new loadSSDNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void MoveLEG2DNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_LEGACY_mask();
}

// Build CISC version of this instruction
MachNode *MoveLEG2DNode::cisc_version(int offset) {
  loadSSDNode *node = new loadSSDNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void popCountINode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *popCountINode::cisc_version(int offset) {
  popCountI_memNode *node = new popCountI_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void popCountLNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *popCountLNode::cisc_version(int offset) {
  popCountL_memNode *node = new popCountL_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmovI_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmovI_regNode::cisc_version(int offset) {
  cmovI_memNode *node = new cmovI_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmovI_regUNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmovI_regUNode::cisc_version(int offset) {
  cmovI_memUNode *node = new cmovI_memUNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmovI_regUCFNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmovI_regUCFNode::cisc_version(int offset) {
  cmovI_memUCFNode *node = new cmovI_memUCFNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmovL_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmovL_regNode::cisc_version(int offset) {
  cmovL_memNode *node = new cmovL_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmovL_regUNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmovL_regUNode::cisc_version(int offset) {
  cmovL_memUNode *node = new cmovL_memUNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmovL_regUCFNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmovL_regUCFNode::cisc_version(int offset) {
  cmovL_memUCFNode *node = new cmovL_memUCFNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void addI_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *addI_rRegNode::cisc_version(int offset) {
  addI_rReg_memNode *node = new addI_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void addL_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *addL_rRegNode::cisc_version(int offset) {
  addL_rReg_memNode *node = new addL_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void subI_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *subI_rRegNode::cisc_version(int offset) {
  subI_rReg_memNode *node = new subI_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void subL_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *subL_rRegNode::cisc_version(int offset) {
  subL_rReg_memNode *node = new subL_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void mulI_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *mulI_rRegNode::cisc_version(int offset) {
  mulI_memNode *node = new mulI_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void mulI_rReg_immNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *mulI_rReg_immNode::cisc_version(int offset) {
  mulI_mem_immNode *node = new mulI_mem_immNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void mulL_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *mulL_rRegNode::cisc_version(int offset) {
  mulL_memNode *node = new mulL_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void mulL_rReg_immNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *mulL_rReg_immNode::cisc_version(int offset) {
  mulL_mem_immNode *node = new mulL_mem_immNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void i2bNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *i2bNode::cisc_version(int offset) {
  loadI2BNode *node = new loadI2BNode();
  node->_num_opnds = 3;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void i2sNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *i2sNode::cisc_version(int offset) {
  loadI2SNode *node = new loadI2SNode();
  node->_num_opnds = 3;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void andI_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *andI_rRegNode::cisc_version(int offset) {
  andI_rReg_memNode *node = new andI_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void andI2L_rReg_imm255Node::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *andI2L_rReg_imm255Node::cisc_version(int offset) {
  loadI2L_immI_255Node *node = new loadI2L_immI_255Node();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void andI2L_rReg_imm65535Node::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *andI2L_rReg_imm65535Node::cisc_version(int offset) {
  loadI2L_immI_65535Node *node = new loadI2L_immI_65535Node();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void andnI_rReg_rReg_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *andnI_rReg_rReg_rRegNode::cisc_version(int offset) {
  andnI_rReg_rReg_memNode *node = new andnI_rReg_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void andnI_rReg_rReg_rReg_0Node::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *andnI_rReg_rReg_rReg_0Node::cisc_version(int offset) {
  andnI_rReg_rReg_mem_0Node *node = new andnI_rReg_rReg_mem_0Node();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void orI_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *orI_rRegNode::cisc_version(int offset) {
  orI_rReg_memNode *node = new orI_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void xorI_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *xorI_rRegNode::cisc_version(int offset) {
  xorI_rReg_memNode *node = new xorI_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void andL_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *andL_rRegNode::cisc_version(int offset) {
  andL_rReg_memNode *node = new andL_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void andnL_rReg_rReg_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *andnL_rReg_rReg_rRegNode::cisc_version(int offset) {
  andnL_rReg_rReg_memNode *node = new andnL_rReg_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void andnL_rReg_rReg_rReg_0Node::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *andnL_rReg_rReg_rReg_0Node::cisc_version(int offset) {
  andnL_rReg_rReg_mem_0Node *node = new andnL_rReg_rReg_mem_0Node();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void orL_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *orL_rRegNode::cisc_version(int offset) {
  orL_rReg_memNode *node = new orL_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void xorL_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *xorL_rRegNode::cisc_version(int offset) {
  xorL_rReg_memNode *node = new xorL_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmpF_cc_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmpF_cc_regNode::cisc_version(int offset) {
  cmpF_cc_memNode *node = new cmpF_cc_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmpF_cc_reg_CFNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmpF_cc_reg_CFNode::cisc_version(int offset) {
  cmpF_cc_memCFNode *node = new cmpF_cc_memCFNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmpD_cc_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmpD_cc_regNode::cisc_version(int offset) {
  cmpD_cc_memNode *node = new cmpD_cc_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmpD_cc_reg_CFNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmpD_cc_reg_CFNode::cisc_version(int offset) {
  cmpD_cc_memCFNode *node = new cmpD_cc_memCFNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmpF_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmpF_regNode::cisc_version(int offset) {
  cmpF_memNode *node = new cmpF_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void cmpD_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *cmpD_regNode::cisc_version(int offset) {
  cmpD_memNode *node = new cmpD_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void convF2D_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *convF2D_reg_regNode::cisc_version(int offset) {
  convF2D_reg_memNode *node = new convF2D_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void convD2F_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *convD2F_reg_regNode::cisc_version(int offset) {
  convD2F_reg_memNode *node = new convD2F_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void convL2F_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *convL2F_reg_regNode::cisc_version(int offset) {
  convL2F_reg_memNode *node = new convL2F_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void convL2D_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *convL2D_reg_regNode::cisc_version(int offset) {
  convL2D_reg_memNode *node = new convL2D_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void convI2L_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *convI2L_reg_regNode::cisc_version(int offset) {
  loadI2LNode *node = new loadI2LNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void convI2L_reg_reg_zexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *convI2L_reg_reg_zexNode::cisc_version(int offset) {
  loadUI2LNode *node = new loadUI2LNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void MoveF2I_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *MoveF2I_reg_regNode::cisc_version(int offset) {
  MoveF2I_stack_regNode *node = new MoveF2I_stack_regNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void MoveD2L_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *MoveD2L_reg_regNode::cisc_version(int offset) {
  MoveD2L_stack_regNode *node = new MoveD2L_stack_regNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void MoveI2F_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *MoveI2F_reg_regNode::cisc_version(int offset) {
  MoveI2F_stack_regNode *node = new MoveI2F_stack_regNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void compI_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *compI_rRegNode::cisc_version(int offset) {
  compI_rReg_memNode *node = new compI_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void compU_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *compU_rRegNode::cisc_version(int offset) {
  compU_rReg_memNode *node = new compU_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void compP_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_PTR_REG_mask();
}

// Build CISC version of this instruction
MachNode *compP_rRegNode::cisc_version(int offset) {
  compP_rReg_memNode *node = new compP_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void compL_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *compL_rRegNode::cisc_version(int offset) {
  compL_rReg_memNode *node = new compL_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void compUL_rRegNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *compUL_rRegNode::cisc_version(int offset) {
  compUL_rReg_memNode *node = new compUL_rReg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}

// Build short branch version of this instruction
MachNode *jmpDirNode::short_branch_version() {
  jmpDir_shortNode *node = new jmpDir_shortNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  return node;
}

// Build short branch version of this instruction
MachNode *jmpConNode::short_branch_version() {
  jmpCon_shortNode *node = new jmpCon_shortNode();
  node->_prob = _prob;
  node->_fcnt = _fcnt;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  return node;
}

// Build short branch version of this instruction
MachNode *jmpLoopEndNode::short_branch_version() {
  jmpLoopEnd_shortNode *node = new jmpLoopEnd_shortNode();
  node->_prob = _prob;
  node->_fcnt = _fcnt;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  return node;
}

// Build short branch version of this instruction
MachNode *jmpLoopEndUNode::short_branch_version() {
  jmpLoopEndU_shortNode *node = new jmpLoopEndU_shortNode();
  node->_prob = _prob;
  node->_fcnt = _fcnt;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  return node;
}

// Build short branch version of this instruction
MachNode *jmpLoopEndUCFNode::short_branch_version() {
  jmpLoopEndUCF_shortNode *node = new jmpLoopEndUCF_shortNode();
  node->_prob = _prob;
  node->_fcnt = _fcnt;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  return node;
}

// Build short branch version of this instruction
MachNode *jmpConUNode::short_branch_version() {
  jmpConU_shortNode *node = new jmpConU_shortNode();
  node->_prob = _prob;
  node->_fcnt = _fcnt;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  return node;
}

// Build short branch version of this instruction
MachNode *jmpConUCFNode::short_branch_version() {
  jmpConUCF_shortNode *node = new jmpConUCF_shortNode();
  node->_prob = _prob;
  node->_fcnt = _fcnt;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  return node;
}

// Build short branch version of this instruction
MachNode *jmpConUCF2Node::short_branch_version() {
  jmpConUCF2_shortNode *node = new jmpConUCF2_shortNode();
  node->_prob = _prob;
  node->_fcnt = _fcnt;

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  return node;
}


void addF_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *addF_regNode::cisc_version(int offset) {
  addF_memNode *node = new addF_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void addF_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *addF_reg_regNode::cisc_version(int offset) {
  addF_reg_memNode *node = new addF_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void addD_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *addD_regNode::cisc_version(int offset) {
  addD_memNode *node = new addD_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void addD_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *addD_reg_regNode::cisc_version(int offset) {
  addD_reg_memNode *node = new addD_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void subF_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *subF_regNode::cisc_version(int offset) {
  subF_memNode *node = new subF_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void subF_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *subF_reg_regNode::cisc_version(int offset) {
  subF_reg_memNode *node = new subF_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void subD_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *subD_regNode::cisc_version(int offset) {
  subD_memNode *node = new subD_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void subD_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *subD_reg_regNode::cisc_version(int offset) {
  subD_reg_memNode *node = new subD_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void mulF_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *mulF_regNode::cisc_version(int offset) {
  mulF_memNode *node = new mulF_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void mulF_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *mulF_reg_regNode::cisc_version(int offset) {
  mulF_reg_memNode *node = new mulF_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void mulD_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *mulD_regNode::cisc_version(int offset) {
  mulD_memNode *node = new mulD_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void mulD_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *mulD_reg_regNode::cisc_version(int offset) {
  mulD_reg_memNode *node = new mulD_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void divF_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *divF_regNode::cisc_version(int offset) {
  divF_memNode *node = new divF_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void divF_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *divF_reg_regNode::cisc_version(int offset) {
  divF_reg_memNode *node = new divF_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void divD_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *divD_regNode::cisc_version(int offset) {
  divD_memNode *node = new divD_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void divD_reg_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *divD_reg_regNode::cisc_version(int offset) {
  divD_reg_memNode *node = new divD_reg_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void sqrtF_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *sqrtF_regNode::cisc_version(int offset) {
  sqrtF_memNode *node = new sqrtF_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void sqrtD_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *sqrtD_regNode::cisc_version(int offset) {
  sqrtD_memNode *node = new sqrtD_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void roundD_regNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_LEGACY_mask();
}

// Build CISC version of this instruction
MachNode *roundD_regNode::cisc_version(int offset) {
  roundD_memNode *node = new roundD_memNode();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl8INode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl8INode::cisc_version(int offset) {
  Repl8I_memNode *node = new Repl8I_memNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl16INode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl16INode::cisc_version(int offset) {
  Repl16I_memNode *node = new Repl16I_memNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl4LNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl4LNode::cisc_version(int offset) {
  Repl4L_memNode *node = new Repl4L_memNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl8LNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl8LNode::cisc_version(int offset) {
  Repl8L_memNode *node = new Repl8L_memNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl2INode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl2INode::cisc_version(int offset) {
  Repl2I_memNode *node = new Repl2I_memNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl4I_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl4I_evexNode::cisc_version(int offset) {
  Repl4I_mem_evexNode *node = new Repl4I_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl8I_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl8I_evexNode::cisc_version(int offset) {
  Repl8I_mem_evexNode *node = new Repl8I_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl16I_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_INT_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl16I_evexNode::cisc_version(int offset) {
  Repl16I_mem_evexNode *node = new Repl16I_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl4L_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl4L_evexNode::cisc_version(int offset) {
  Repl4L_mem_evexNode *node = new Repl4L_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl8L_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_LONG_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl8L_evexNode::cisc_version(int offset) {
  Repl8L_mem_evexNode *node = new Repl8L_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl8F_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl8F_evexNode::cisc_version(int offset) {
  Repl8F_mem_evexNode *node = new Repl8F_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl16F_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_FLOAT_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl16F_evexNode::cisc_version(int offset) {
  Repl16F_mem_evexNode *node = new Repl16F_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl4D_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl4D_evexNode::cisc_version(int offset) {
  Repl4D_mem_evexNode *node = new Repl4D_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


void Repl8D_evexNode::use_cisc_RegMask() {
  _cisc_RegMask = &STACK_OR_DOUBLE_REG_mask();
}

// Build CISC version of this instruction
MachNode *Repl8D_evexNode::cisc_version(int offset) {
  Repl8D_mem_evexNode *node = new Repl8D_mem_evexNode();
  node->_bottom_type = bottom_type();

  // Copy _idx, inputs and operands to new node
  fill_new_machnode(node);
  // Construct operand to access [stack_pointer + offset]
  node->set_opnd_array(cisc_operand(), new indOffset32Oper(offset));

  return node;
}


// Copy _idx, inputs and operands to new node
void MachNode::fill_new_machnode(MachNode* node) const {
  // New node must use same node index
  node->set_idx( _idx );
  // Copy machine-independent inputs
  for( uint j = 0; j < req(); j++ ) {
    node->add_req(in(j));
  }
  // Copy my operands, except for cisc position
  int nopnds = num_opnds();
  assert( node->num_opnds() == (uint)nopnds, "Must have same number of operands");
  MachOper **to = node->_opnds;
  for( int i = 0; i < nopnds; i++ ) {
    if( i != cisc_operand() ) 
      to[i] = _opnds[i]->clone();
  }
  // Do not increment node index counter, since node reuses my index
  Compile* C = Compile::current();
  C->set_unique(C->unique() - 1);
}

void jmpDirNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(1));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpDirNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(1));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpConNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpConNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEndNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEndNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEndUNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEndUNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEndUCFNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEndUCFNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEnd_and_restoreMaskNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEnd_and_restoreMaskNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEndU_and_restoreMaskNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEndU_and_restoreMaskNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEndUCF_and_restoreMaskNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEndUCF_and_restoreMaskNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpConUNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpConUNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpConUCFNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpConUCFNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpConUCF2Node::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpConUCF2Node::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpDir_shortNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(1));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpDir_shortNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(1));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpCon_shortNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpCon_shortNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEnd_shortNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEnd_shortNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEndU_shortNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEndU_shortNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpLoopEndUCF_shortNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpLoopEndUCF_shortNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpConU_shortNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpConU_shortNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpConUCF_shortNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpConUCF_shortNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void jmpConUCF2_shortNode::label_set( Label* label, uint block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  oper->_label     = label;
  oper->_block_num = block_num;
}
void jmpConUCF2_shortNode::save_label( Label** label, uint* block_num ) {
  labelOper* oper  = (labelOper*)(opnd_array(3));
  *label = oper->_label;
  *block_num = oper->_block_num;
}
void CallStaticJavaDirectNode::method_set( intptr_t method ) {
  ((methodOper*)opnd_array(1))->_method = method;
}

void CallDynamicJavaDirectNode::method_set( intptr_t method ) {
  ((methodOper*)opnd_array(1))->_method = method;
}

void CallRuntimeDirectNode::method_set( intptr_t method ) {
  ((methodOper*)opnd_array(1))->_method = method;
}

void CallLeafDirectNode::method_set( intptr_t method ) {
  ((methodOper*)opnd_array(1))->_method = method;
}

void CallLeafNoFPDirectNode::method_set( intptr_t method ) {
  ((methodOper*)opnd_array(1))->_method = method;
}

int loadBNode::reloc() const {
  return 1;
}

int loadB2LNode::reloc() const {
  return 1;
}

int loadUBNode::reloc() const {
  return 1;
}

int loadUB2LNode::reloc() const {
  return 1;
}

int loadUB2L_immINode::reloc() const {
  return 1;
}

int loadSNode::reloc() const {
  return 1;
}

int loadS2BNode::reloc() const {
  return 1;
}

int loadS2LNode::reloc() const {
  return 1;
}

int loadUSNode::reloc() const {
  return 1;
}

int loadUS2BNode::reloc() const {
  return 1;
}

int loadUS2LNode::reloc() const {
  return 1;
}

int loadUS2L_immI_255Node::reloc() const {
  return 1;
}

int loadUS2L_immINode::reloc() const {
  return 1;
}

int loadINode::reloc() const {
  return 1;
}

int loadI2BNode::reloc() const {
  return 1;
}

int loadI2UBNode::reloc() const {
  return 1;
}

int loadI2SNode::reloc() const {
  return 1;
}

int loadI2USNode::reloc() const {
  return 1;
}

int loadI2LNode::reloc() const {
  return 1;
}

int loadI2L_immI_255Node::reloc() const {
  return 1;
}

int loadI2L_immI_65535Node::reloc() const {
  return 1;
}

int loadI2L_immU31Node::reloc() const {
  return 1;
}

int loadUI2LNode::reloc() const {
  return 1;
}

int loadLNode::reloc() const {
  return 1;
}

int loadRangeNode::reloc() const {
  return 1;
}

int loadPNode::reloc() const {
  return 1;
}

int loadNNode::reloc() const {
  return 1;
}

int loadKlassNode::reloc() const {
  return 1;
}

int loadNKlassNode::reloc() const {
  return 1;
}

int loadFNode::reloc() const {
  return 1;
}

int loadD_partialNode::reloc() const {
  return 1;
}

int loadDNode::reloc() const {
  return 1;
}

int loadConPNode::reloc() const {
  return 1;
}

int loadConP0Node::reloc() const {
  return 1;
}

int loadConP31Node::reloc() const {
  return 1;
}

int loadConFNode::reloc() const {
  return 2;
}

int loadConF0Node::reloc() const {
  return 2;
}

int loadConDNode::reloc() const {
  return 2;
}

int loadConD0Node::reloc() const {
  return 2;
}

int prefetchAllocNode::reloc() const {
  return 1;
}

int prefetchAllocNTANode::reloc() const {
  return 1;
}

int prefetchAllocT0Node::reloc() const {
  return 1;
}

int prefetchAllocT2Node::reloc() const {
  return 1;
}

int storeBNode::reloc() const {
  return 2;
}

int storeCNode::reloc() const {
  return 2;
}

int storeINode::reloc() const {
  return 2;
}

int storeLNode::reloc() const {
  return 2;
}

int storePNode::reloc() const {
  return 2;
}

int storeImmP0Node::reloc() const {
  return 3;
}

int storeImmPNode::reloc() const {
  return 3;
}

int storeNNode::reloc() const {
  return 2;
}

int storeNKlassNode::reloc() const {
  return 2;
}

int storeImmN0Node::reloc() const {
  return 2;
}

int storeImmNNode::reloc() const {
  return 2;
}

int storeImmNKlassNode::reloc() const {
  return 2;
}

int storeImmI0Node::reloc() const {
  return 2;
}

int storeImmINode::reloc() const {
  return 2;
}

int storeImmL0Node::reloc() const {
  return 2;
}

int storeImmLNode::reloc() const {
  return 2;
}

int storeImmC0Node::reloc() const {
  return 2;
}

int storeImmI16Node::reloc() const {
  return 2;
}

int storeImmB0Node::reloc() const {
  return 2;
}

int storeImmBNode::reloc() const {
  return 2;
}

int storeImmCM0_regNode::reloc() const {
  return 2;
}

int storeImmCM0Node::reloc() const {
  return 2;
}

int storeFNode::reloc() const {
  return 2;
}

int storeF0Node::reloc() const {
  return 3;
}

int storeF_immNode::reloc() const {
  return 3;
}

int storeDNode::reloc() const {
  return 2;
}

int storeD0_immNode::reloc() const {
  return 3;
}

int storeD0Node::reloc() const {
  return 3;
}

int popCountI_memNode::reloc() const {
  return 1;
}

int popCountL_memNode::reloc() const {
  return 1;
}

int cmovI_memNode::reloc() const {
  return 1;
}

int cmovI_memUNode::reloc() const {
  return 1;
}

int cmovI_memUCFNode::reloc() const {
  return 1;
}

int cmovL_memNode::reloc() const {
  return 1;
}

int cmovL_memUNode::reloc() const {
  return 1;
}

int cmovL_memUCFNode::reloc() const {
  return 1;
}

int addI_rReg_memNode::reloc() const {
  return 1;
}

int addI_rReg_mem_0Node::reloc() const {
  return 1;
}

int addI_mem_rRegNode::reloc() const {
  return 3;
}

int addI_mem_rReg_0Node::reloc() const {
  return 3;
}

int addI_mem_immNode::reloc() const {
  return 3;
}

int incI_memNode::reloc() const {
  return 3;
}

int decI_memNode::reloc() const {
  return 3;
}

int addL_rReg_memNode::reloc() const {
  return 1;
}

int addL_rReg_mem_0Node::reloc() const {
  return 1;
}

int addL_mem_rRegNode::reloc() const {
  return 3;
}

int addL_mem_rReg_0Node::reloc() const {
  return 3;
}

int addL_mem_immNode::reloc() const {
  return 3;
}

int incL_memNode::reloc() const {
  return 3;
}

int decL_memNode::reloc() const {
  return 3;
}

int loadPLockedNode::reloc() const {
  return 1;
}

int storePConditionalNode::reloc() const {
  return 1;
}

int storeIConditionalNode::reloc() const {
  return 1;
}

int storeLConditionalNode::reloc() const {
  return 1;
}

int compareAndSwapPNode::reloc() const {
  return 1;
}

int compareAndSwapP_0Node::reloc() const {
  return 1;
}

int compareAndSwapLNode::reloc() const {
  return 1;
}

int compareAndSwapL_0Node::reloc() const {
  return 1;
}

int compareAndSwapINode::reloc() const {
  return 1;
}

int compareAndSwapI_0Node::reloc() const {
  return 1;
}

int compareAndSwapBNode::reloc() const {
  return 1;
}

int compareAndSwapB_0Node::reloc() const {
  return 1;
}

int compareAndSwapSNode::reloc() const {
  return 1;
}

int compareAndSwapS_0Node::reloc() const {
  return 1;
}

int compareAndSwapNNode::reloc() const {
  return 1;
}

int compareAndSwapN_0Node::reloc() const {
  return 1;
}

int compareAndExchangeBNode::reloc() const {
  return 1;
}

int compareAndExchangeSNode::reloc() const {
  return 1;
}

int compareAndExchangeINode::reloc() const {
  return 1;
}

int compareAndExchangeLNode::reloc() const {
  return 1;
}

int compareAndExchangeNNode::reloc() const {
  return 1;
}

int compareAndExchangePNode::reloc() const {
  return 1;
}

int xaddB_no_resNode::reloc() const {
  return 1;
}

int xaddBNode::reloc() const {
  return 1;
}

int xaddS_no_resNode::reloc() const {
  return 1;
}

int xaddSNode::reloc() const {
  return 1;
}

int xaddI_no_resNode::reloc() const {
  return 1;
}

int xaddINode::reloc() const {
  return 1;
}

int xaddL_no_resNode::reloc() const {
  return 1;
}

int xaddLNode::reloc() const {
  return 1;
}

int xchgBNode::reloc() const {
  return 1;
}

int xchgSNode::reloc() const {
  return 1;
}

int xchgINode::reloc() const {
  return 1;
}

int xchgLNode::reloc() const {
  return 1;
}

int xchgPNode::reloc() const {
  return 1;
}

int xchgNNode::reloc() const {
  return 1;
}

int subI_rReg_memNode::reloc() const {
  return 1;
}

int subI_mem_rRegNode::reloc() const {
  return 3;
}

int subI_mem_immNode::reloc() const {
  return 3;
}

int subL_rReg_memNode::reloc() const {
  return 1;
}

int subL_mem_rRegNode::reloc() const {
  return 3;
}

int subL_mem_immNode::reloc() const {
  return 3;
}

int negI_memNode::reloc() const {
  return 3;
}

int negL_memNode::reloc() const {
  return 3;
}

int mulI_memNode::reloc() const {
  return 1;
}

int mulI_mem_0Node::reloc() const {
  return 1;
}

int mulI_mem_immNode::reloc() const {
  return 1;
}

int mulL_memNode::reloc() const {
  return 1;
}

int mulL_mem_0Node::reloc() const {
  return 1;
}

int mulL_mem_immNode::reloc() const {
  return 1;
}

int salI_mem_1Node::reloc() const {
  return 3;
}

int salI_mem_immNode::reloc() const {
  return 3;
}

int salI_mem_CLNode::reloc() const {
  return 3;
}

int sarI_mem_1Node::reloc() const {
  return 3;
}

int sarI_mem_immNode::reloc() const {
  return 3;
}

int sarI_mem_CLNode::reloc() const {
  return 3;
}

int shrI_mem_1Node::reloc() const {
  return 3;
}

int shrI_mem_immNode::reloc() const {
  return 3;
}

int shrI_mem_CLNode::reloc() const {
  return 3;
}

int salL_mem_1Node::reloc() const {
  return 3;
}

int salL_mem_immNode::reloc() const {
  return 3;
}

int salL_mem_CLNode::reloc() const {
  return 3;
}

int sarL_mem_1Node::reloc() const {
  return 3;
}

int sarL_mem_immNode::reloc() const {
  return 3;
}

int sarL_mem_CLNode::reloc() const {
  return 3;
}

int shrL_mem_1Node::reloc() const {
  return 3;
}

int shrL_mem_immNode::reloc() const {
  return 3;
}

int shrL_mem_CLNode::reloc() const {
  return 3;
}

int andI_rReg_memNode::reloc() const {
  return 1;
}

int andI_rReg_mem_0Node::reloc() const {
  return 1;
}

int andI_mem_rRegNode::reloc() const {
  return 3;
}

int andI_mem_rReg_0Node::reloc() const {
  return 3;
}

int andI_mem_immNode::reloc() const {
  return 3;
}

int andnI_rReg_rReg_memNode::reloc() const {
  return 1;
}

int andnI_rReg_rReg_mem_0Node::reloc() const {
  return 1;
}

int blsiI_rReg_memNode::reloc() const {
  return 2;
}

int blsiI_rReg_mem_0Node::reloc() const {
  return 2;
}

int blsmskI_rReg_memNode::reloc() const {
  return 2;
}

int blsmskI_rReg_mem_0Node::reloc() const {
  return 2;
}

int blsrI_rReg_memNode::reloc() const {
  return 2;
}

int blsrI_rReg_mem_0Node::reloc() const {
  return 2;
}

int orI_rReg_memNode::reloc() const {
  return 1;
}

int orI_rReg_mem_0Node::reloc() const {
  return 1;
}

int orI_mem_rRegNode::reloc() const {
  return 3;
}

int orI_mem_rReg_0Node::reloc() const {
  return 3;
}

int orI_mem_immNode::reloc() const {
  return 3;
}

int xorI_rReg_memNode::reloc() const {
  return 1;
}

int xorI_rReg_mem_0Node::reloc() const {
  return 1;
}

int xorI_mem_rRegNode::reloc() const {
  return 3;
}

int xorI_mem_rReg_0Node::reloc() const {
  return 3;
}

int xorI_mem_immNode::reloc() const {
  return 3;
}

int andL_rReg_memNode::reloc() const {
  return 1;
}

int andL_rReg_mem_0Node::reloc() const {
  return 1;
}

int andL_mem_rRegNode::reloc() const {
  return 3;
}

int andL_mem_rReg_0Node::reloc() const {
  return 3;
}

int andL_mem_immNode::reloc() const {
  return 3;
}

int andnL_rReg_rReg_memNode::reloc() const {
  return 1;
}

int andnL_rReg_rReg_mem_0Node::reloc() const {
  return 1;
}

int blsiL_rReg_memNode::reloc() const {
  return 2;
}

int blsiL_rReg_mem_0Node::reloc() const {
  return 2;
}

int blsmskL_rReg_memNode::reloc() const {
  return 2;
}

int blsmskL_rReg_mem_0Node::reloc() const {
  return 2;
}

int blsrL_rReg_memNode::reloc() const {
  return 2;
}

int blsrL_rReg_mem_0Node::reloc() const {
  return 2;
}

int orL_rReg_memNode::reloc() const {
  return 1;
}

int orL_rReg_mem_0Node::reloc() const {
  return 1;
}

int orL_mem_rRegNode::reloc() const {
  return 3;
}

int orL_mem_rReg_0Node::reloc() const {
  return 3;
}

int orL_mem_immNode::reloc() const {
  return 3;
}

int xorL_rReg_memNode::reloc() const {
  return 1;
}

int xorL_rReg_mem_0Node::reloc() const {
  return 1;
}

int xorL_mem_rRegNode::reloc() const {
  return 3;
}

int xorL_mem_rReg_0Node::reloc() const {
  return 3;
}

int xorL_mem_immNode::reloc() const {
  return 3;
}

int cmpF_cc_memNode::reloc() const {
  return 1;
}

int cmpF_cc_memCFNode::reloc() const {
  return 1;
}

int cmpF_cc_immNode::reloc() const {
  return 1;
}

int cmpF_cc_immCFNode::reloc() const {
  return 1;
}

int cmpD_cc_memNode::reloc() const {
  return 1;
}

int cmpD_cc_memCFNode::reloc() const {
  return 1;
}

int cmpD_cc_immNode::reloc() const {
  return 1;
}

int cmpD_cc_immCFNode::reloc() const {
  return 1;
}

int cmpF_memNode::reloc() const {
  return 1;
}

int cmpF_immNode::reloc() const {
  return 1;
}

int cmpD_memNode::reloc() const {
  return 1;
}

int cmpD_immNode::reloc() const {
  return 1;
}

int convF2D_reg_memNode::reloc() const {
  return 1;
}

int convD2F_reg_memNode::reloc() const {
  return 1;
}

int convI2F_reg_memNode::reloc() const {
  return 1;
}

int convI2D_reg_memNode::reloc() const {
  return 1;
}

int convL2F_reg_memNode::reloc() const {
  return 1;
}

int convL2D_reg_memNode::reloc() const {
  return 1;
}

int convI2L_reg_mem_zexNode::reloc() const {
  return 1;
}

int compI_rReg_memNode::reloc() const {
  return 1;
}

int testI_reg_memNode::reloc() const {
  return 1;
}

int testI_reg_mem_0Node::reloc() const {
  return 1;
}

int compU_rReg_memNode::reloc() const {
  return 1;
}

int compP_rReg_memNode::reloc() const {
  return 1;
}

int compP_mem_rRegNode::reloc() const {
  return 1;
}

int testP_regNode::reloc() const {
  return 1;
}

int testP_memNode::reloc() const {
  return 2;
}

int testP_mem_reg0Node::reloc() const {
  return 2;
}

int compN_rReg_memNode::reloc() const {
  return 1;
}

int compN_mem_immNode::reloc() const {
  return 1;
}

int compN_mem_imm_klassNode::reloc() const {
  return 1;
}

int testN_memNode::reloc() const {
  return 1;
}

int testN_mem_reg0Node::reloc() const {
  return 1;
}

int compL_rReg_memNode::reloc() const {
  return 1;
}

int testL_reg_memNode::reloc() const {
  return 1;
}

int testL_reg_mem_0Node::reloc() const {
  return 1;
}

int testL_reg_mem2Node::reloc() const {
  return 1;
}

int testL_reg_mem2_0Node::reloc() const {
  return 1;
}

int compUL_rReg_memNode::reloc() const {
  return 1;
}

int compB_mem_immNode::reloc() const {
  return 1;
}

int testB_mem_immNode::reloc() const {
  return 1;
}

int partialSubtypeCheck_vs_ZeroNode::reloc() const {
  return 1;
}

int safePoint_pollNode::reloc() const {
  return 1;
}

int safePoint_poll_farNode::reloc() const {
  return 1;
}

int safePoint_poll_tlsNode::reloc() const {
  return 1;
}

int CallStaticJavaDirectNode::reloc() const {
  return 1;
}

int CallDynamicJavaDirectNode::reloc() const {
  return 1;
}

int CallRuntimeDirectNode::reloc() const {
  return 1;
}

int CallLeafDirectNode::reloc() const {
  return 1;
}

int CallLeafNoFPDirectNode::reloc() const {
  return 1;
}

int RetNode::reloc() const {
  return 1;
}

int TailCalljmpIndNode::reloc() const {
  return 1;
}

int tailjmpIndNode::reloc() const {
  return 1;
}

int RethrowExceptionNode::reloc() const {
  return 1;
}

int loadBarrierSlowRegNoVecNode::reloc() const {
  return 1;
}

int loadBarrierSlowRegXmmAndYmmNode::reloc() const {
  return 1;
}

int loadBarrierSlowRegZmmNode::reloc() const {
  return 1;
}

int loadBarrierWeakSlowRegNoVecNode::reloc() const {
  return 1;
}

int loadBarrierWeakSlowRegXmmAndYmmNode::reloc() const {
  return 1;
}

int loadBarrierWeakSlowRegZmmNode::reloc() const {
  return 1;
}

int addF_memNode::reloc() const {
  return 1;
}

int addF_mem_0Node::reloc() const {
  return 1;
}

int addF_immNode::reloc() const {
  return 1;
}

int addF_reg_memNode::reloc() const {
  return 1;
}

int addF_reg_mem_0Node::reloc() const {
  return 1;
}

int addF_reg_immNode::reloc() const {
  return 1;
}

int addD_memNode::reloc() const {
  return 1;
}

int addD_mem_0Node::reloc() const {
  return 1;
}

int addD_immNode::reloc() const {
  return 1;
}

int addD_reg_memNode::reloc() const {
  return 1;
}

int addD_reg_mem_0Node::reloc() const {
  return 1;
}

int addD_reg_immNode::reloc() const {
  return 1;
}

int subF_memNode::reloc() const {
  return 1;
}

int subF_immNode::reloc() const {
  return 1;
}

int subF_reg_memNode::reloc() const {
  return 1;
}

int subF_reg_immNode::reloc() const {
  return 1;
}

int subD_memNode::reloc() const {
  return 1;
}

int subD_immNode::reloc() const {
  return 1;
}

int subD_reg_memNode::reloc() const {
  return 1;
}

int subD_reg_immNode::reloc() const {
  return 1;
}

int mulF_memNode::reloc() const {
  return 1;
}

int mulF_mem_0Node::reloc() const {
  return 1;
}

int mulF_immNode::reloc() const {
  return 1;
}

int mulF_reg_memNode::reloc() const {
  return 1;
}

int mulF_reg_mem_0Node::reloc() const {
  return 1;
}

int mulF_reg_immNode::reloc() const {
  return 1;
}

int mulD_memNode::reloc() const {
  return 1;
}

int mulD_mem_0Node::reloc() const {
  return 1;
}

int mulD_immNode::reloc() const {
  return 1;
}

int mulD_reg_memNode::reloc() const {
  return 1;
}

int mulD_reg_mem_0Node::reloc() const {
  return 1;
}

int mulD_reg_immNode::reloc() const {
  return 1;
}

int divF_memNode::reloc() const {
  return 1;
}

int divF_immNode::reloc() const {
  return 1;
}

int divF_reg_memNode::reloc() const {
  return 1;
}

int divF_reg_immNode::reloc() const {
  return 1;
}

int divD_memNode::reloc() const {
  return 1;
}

int divD_immNode::reloc() const {
  return 1;
}

int divD_reg_memNode::reloc() const {
  return 1;
}

int divD_reg_immNode::reloc() const {
  return 1;
}

int sqrtF_memNode::reloc() const {
  return 1;
}

int sqrtF_immNode::reloc() const {
  return 1;
}

int sqrtD_memNode::reloc() const {
  return 1;
}

int sqrtD_immNode::reloc() const {
  return 1;
}

int roundD_memNode::reloc() const {
  return 1;
}

int roundD_immNode::reloc() const {
  return 1;
}

int vround2D_memNode::reloc() const {
  return 1;
}

int vround4D_memNode::reloc() const {
  return 1;
}

int vround8D_memNode::reloc() const {
  return 1;
}

int loadV4Node::reloc() const {
  return 1;
}

int loadV8Node::reloc() const {
  return 1;
}

int loadV16Node::reloc() const {
  return 1;
}

int loadV32Node::reloc() const {
  return 1;
}

int loadV64_dwordNode::reloc() const {
  return 1;
}

int loadV64_qwordNode::reloc() const {
  return 1;
}

int storeV4Node::reloc() const {
  return 2;
}

int storeV8Node::reloc() const {
  return 2;
}

int storeV16Node::reloc() const {
  return 2;
}

int storeV32Node::reloc() const {
  return 2;
}

int storeV64_dwordNode::reloc() const {
  return 2;
}

int storeV64_qwordNode::reloc() const {
  return 2;
}

int Repl4S_memNode::reloc() const {
  return 1;
}

int Repl8S_memNode::reloc() const {
  return 1;
}

int Repl16S_memNode::reloc() const {
  return 1;
}

int Repl32S_memNode::reloc() const {
  return 1;
}

int Repl4I_memNode::reloc() const {
  return 1;
}

int Repl8I_memNode::reloc() const {
  return 1;
}

int Repl16I_memNode::reloc() const {
  return 1;
}

int Repl2L_memNode::reloc() const {
  return 1;
}

int Repl4L_memNode::reloc() const {
  return 1;
}

int Repl8L_memNode::reloc() const {
  return 1;
}

int Repl2F_memNode::reloc() const {
  return 1;
}

int Repl4F_memNode::reloc() const {
  return 1;
}

int Repl8F_memNode::reloc() const {
  return 1;
}

int Repl16F_memNode::reloc() const {
  return 1;
}

int Repl2F_zeroNode::reloc() const {
  return 1;
}

int Repl4F_zeroNode::reloc() const {
  return 1;
}

int Repl8F_zeroNode::reloc() const {
  return 1;
}

int Repl2D_memNode::reloc() const {
  return 1;
}

int Repl4D_memNode::reloc() const {
  return 1;
}

int Repl8D_memNode::reloc() const {
  return 1;
}

int Repl2D_zeroNode::reloc() const {
  return 1;
}

int Repl4D_zeroNode::reloc() const {
  return 1;
}

int Repl2I_memNode::reloc() const {
  return 1;
}

int Repl4B_mem_evexNode::reloc() const {
  return 1;
}

int Repl8B_mem_evexNode::reloc() const {
  return 1;
}

int Repl16B_mem_evexNode::reloc() const {
  return 1;
}

int Repl32B_mem_evexNode::reloc() const {
  return 1;
}

int Repl64B_mem_evexNode::reloc() const {
  return 1;
}

int Repl4S_mem_evexNode::reloc() const {
  return 1;
}

int Repl8S_mem_evexNode::reloc() const {
  return 1;
}

int Repl16S_mem_evexNode::reloc() const {
  return 1;
}

int Repl32S_mem_evexNode::reloc() const {
  return 1;
}

int Repl4I_mem_evexNode::reloc() const {
  return 1;
}

int Repl8I_mem_evexNode::reloc() const {
  return 1;
}

int Repl16I_mem_evexNode::reloc() const {
  return 1;
}

int Repl2L_mem_evexNode::reloc() const {
  return 1;
}

int Repl4L_mem_evexNode::reloc() const {
  return 1;
}

int Repl8L_mem_evexNode::reloc() const {
  return 1;
}

int Repl8F_mem_evexNode::reloc() const {
  return 1;
}

int Repl16F_mem_evexNode::reloc() const {
  return 1;
}

int Repl16F_zero_evexNode::reloc() const {
  return 1;
}

int Repl4D_mem_evexNode::reloc() const {
  return 1;
}

int Repl8D_mem_evexNode::reloc() const {
  return 1;
}

int Repl8D_zero_evexNode::reloc() const {
  return 1;
}

int vadd4B_memNode::reloc() const {
  return 1;
}

int vadd4B_mem_0Node::reloc() const {
  return 1;
}

int vadd8B_memNode::reloc() const {
  return 1;
}

int vadd8B_mem_0Node::reloc() const {
  return 1;
}

int vadd16B_memNode::reloc() const {
  return 1;
}

int vadd16B_mem_0Node::reloc() const {
  return 1;
}

int vadd32B_memNode::reloc() const {
  return 1;
}

int vadd32B_mem_0Node::reloc() const {
  return 1;
}

int vadd64B_memNode::reloc() const {
  return 1;
}

int vadd64B_mem_0Node::reloc() const {
  return 1;
}

int vadd2S_memNode::reloc() const {
  return 1;
}

int vadd2S_mem_0Node::reloc() const {
  return 1;
}

int vadd4S_memNode::reloc() const {
  return 1;
}

int vadd4S_mem_0Node::reloc() const {
  return 1;
}

int vadd8S_memNode::reloc() const {
  return 1;
}

int vadd8S_mem_0Node::reloc() const {
  return 1;
}

int vadd16S_memNode::reloc() const {
  return 1;
}

int vadd16S_mem_0Node::reloc() const {
  return 1;
}

int vadd32S_memNode::reloc() const {
  return 1;
}

int vadd32S_mem_0Node::reloc() const {
  return 1;
}

int vadd2I_memNode::reloc() const {
  return 1;
}

int vadd2I_mem_0Node::reloc() const {
  return 1;
}

int vadd4I_memNode::reloc() const {
  return 1;
}

int vadd4I_mem_0Node::reloc() const {
  return 1;
}

int vadd8I_memNode::reloc() const {
  return 1;
}

int vadd8I_mem_0Node::reloc() const {
  return 1;
}

int vadd16I_memNode::reloc() const {
  return 1;
}

int vadd16I_mem_0Node::reloc() const {
  return 1;
}

int vadd2L_memNode::reloc() const {
  return 1;
}

int vadd2L_mem_0Node::reloc() const {
  return 1;
}

int vadd4L_memNode::reloc() const {
  return 1;
}

int vadd4L_mem_0Node::reloc() const {
  return 1;
}

int vadd8L_memNode::reloc() const {
  return 1;
}

int vadd8L_mem_0Node::reloc() const {
  return 1;
}

int vadd2F_memNode::reloc() const {
  return 1;
}

int vadd2F_mem_0Node::reloc() const {
  return 1;
}

int vadd4F_memNode::reloc() const {
  return 1;
}

int vadd4F_mem_0Node::reloc() const {
  return 1;
}

int vadd8F_memNode::reloc() const {
  return 1;
}

int vadd8F_mem_0Node::reloc() const {
  return 1;
}

int vadd16F_memNode::reloc() const {
  return 1;
}

int vadd16F_mem_0Node::reloc() const {
  return 1;
}

int vadd2D_memNode::reloc() const {
  return 1;
}

int vadd2D_mem_0Node::reloc() const {
  return 1;
}

int vadd4D_memNode::reloc() const {
  return 1;
}

int vadd4D_mem_0Node::reloc() const {
  return 1;
}

int vadd8D_memNode::reloc() const {
  return 1;
}

int vadd8D_mem_0Node::reloc() const {
  return 1;
}

int vsub4B_memNode::reloc() const {
  return 1;
}

int vsub8B_memNode::reloc() const {
  return 1;
}

int vsub16B_memNode::reloc() const {
  return 1;
}

int vsub32B_memNode::reloc() const {
  return 1;
}

int vsub64B_memNode::reloc() const {
  return 1;
}

int vsub2S_memNode::reloc() const {
  return 1;
}

int vsub4S_memNode::reloc() const {
  return 1;
}

int vsub8S_memNode::reloc() const {
  return 1;
}

int vsub16S_memNode::reloc() const {
  return 1;
}

int vsub32S_memNode::reloc() const {
  return 1;
}

int vsub2I_memNode::reloc() const {
  return 1;
}

int vsub4I_memNode::reloc() const {
  return 1;
}

int vsub8I_memNode::reloc() const {
  return 1;
}

int vsub16I_memNode::reloc() const {
  return 1;
}

int vsub2L_memNode::reloc() const {
  return 1;
}

int vsub4L_memNode::reloc() const {
  return 1;
}

int vsub8L_memNode::reloc() const {
  return 1;
}

int vsub2F_memNode::reloc() const {
  return 1;
}

int vsub4F_memNode::reloc() const {
  return 1;
}

int vsub8F_memNode::reloc() const {
  return 1;
}

int vsub16F_memNode::reloc() const {
  return 1;
}

int vsub2D_memNode::reloc() const {
  return 1;
}

int vsub4D_memNode::reloc() const {
  return 1;
}

int vsub8D_memNode::reloc() const {
  return 1;
}

int vmul2S_memNode::reloc() const {
  return 1;
}

int vmul2S_mem_0Node::reloc() const {
  return 1;
}

int vmul4S_memNode::reloc() const {
  return 1;
}

int vmul4S_mem_0Node::reloc() const {
  return 1;
}

int vmul8S_memNode::reloc() const {
  return 1;
}

int vmul8S_mem_0Node::reloc() const {
  return 1;
}

int vmul16S_memNode::reloc() const {
  return 1;
}

int vmul16S_mem_0Node::reloc() const {
  return 1;
}

int vmul32S_memNode::reloc() const {
  return 1;
}

int vmul32S_mem_0Node::reloc() const {
  return 1;
}

int vmul2I_memNode::reloc() const {
  return 1;
}

int vmul2I_mem_0Node::reloc() const {
  return 1;
}

int vmul4I_memNode::reloc() const {
  return 1;
}

int vmul4I_mem_0Node::reloc() const {
  return 1;
}

int vmul2L_memNode::reloc() const {
  return 1;
}

int vmul2L_mem_0Node::reloc() const {
  return 1;
}

int vmul4L_memNode::reloc() const {
  return 1;
}

int vmul4L_mem_0Node::reloc() const {
  return 1;
}

int vmul8L_memNode::reloc() const {
  return 1;
}

int vmul8L_mem_0Node::reloc() const {
  return 1;
}

int vmul8I_memNode::reloc() const {
  return 1;
}

int vmul8I_mem_0Node::reloc() const {
  return 1;
}

int vmul16I_memNode::reloc() const {
  return 1;
}

int vmul16I_mem_0Node::reloc() const {
  return 1;
}

int vmul2F_memNode::reloc() const {
  return 1;
}

int vmul2F_mem_0Node::reloc() const {
  return 1;
}

int vmul4F_memNode::reloc() const {
  return 1;
}

int vmul4F_mem_0Node::reloc() const {
  return 1;
}

int vmul8F_memNode::reloc() const {
  return 1;
}

int vmul8F_mem_0Node::reloc() const {
  return 1;
}

int vmul16F_memNode::reloc() const {
  return 1;
}

int vmul16F_mem_0Node::reloc() const {
  return 1;
}

int vmul2D_memNode::reloc() const {
  return 1;
}

int vmul2D_mem_0Node::reloc() const {
  return 1;
}

int vmul4D_memNode::reloc() const {
  return 1;
}

int vmul4D_mem_0Node::reloc() const {
  return 1;
}

int vmul8D_memNode::reloc() const {
  return 1;
}

int vmul8D_mem_0Node::reloc() const {
  return 1;
}

int vdiv2F_memNode::reloc() const {
  return 1;
}

int vdiv4F_memNode::reloc() const {
  return 1;
}

int vdiv8F_memNode::reloc() const {
  return 1;
}

int vdiv16F_memNode::reloc() const {
  return 1;
}

int vdiv2D_memNode::reloc() const {
  return 1;
}

int vdiv4D_memNode::reloc() const {
  return 1;
}

int vdiv8D_memNode::reloc() const {
  return 1;
}

int vsqrt2D_memNode::reloc() const {
  return 1;
}

int vsqrt4D_memNode::reloc() const {
  return 1;
}

int vsqrt8D_memNode::reloc() const {
  return 1;
}

int vsqrt2F_memNode::reloc() const {
  return 1;
}

int vsqrt4F_memNode::reloc() const {
  return 1;
}

int vsqrt8F_memNode::reloc() const {
  return 1;
}

int vsqrt16F_memNode::reloc() const {
  return 1;
}

int vand4B_memNode::reloc() const {
  return 1;
}

int vand4B_mem_0Node::reloc() const {
  return 1;
}

int vand8B_memNode::reloc() const {
  return 1;
}

int vand8B_mem_0Node::reloc() const {
  return 1;
}

int vand16B_memNode::reloc() const {
  return 1;
}

int vand16B_mem_0Node::reloc() const {
  return 1;
}

int vand32B_memNode::reloc() const {
  return 1;
}

int vand32B_mem_0Node::reloc() const {
  return 1;
}

int vand64B_memNode::reloc() const {
  return 1;
}

int vand64B_mem_0Node::reloc() const {
  return 1;
}

int vor4B_memNode::reloc() const {
  return 1;
}

int vor4B_mem_0Node::reloc() const {
  return 1;
}

int vor8B_memNode::reloc() const {
  return 1;
}

int vor8B_mem_0Node::reloc() const {
  return 1;
}

int vor16B_memNode::reloc() const {
  return 1;
}

int vor16B_mem_0Node::reloc() const {
  return 1;
}

int vor32B_memNode::reloc() const {
  return 1;
}

int vor32B_mem_0Node::reloc() const {
  return 1;
}

int vor64B_memNode::reloc() const {
  return 1;
}

int vor64B_mem_0Node::reloc() const {
  return 1;
}

int vxor4B_memNode::reloc() const {
  return 1;
}

int vxor4B_mem_0Node::reloc() const {
  return 1;
}

int vxor8B_memNode::reloc() const {
  return 1;
}

int vxor8B_mem_0Node::reloc() const {
  return 1;
}

int vxor16B_memNode::reloc() const {
  return 1;
}

int vxor16B_mem_0Node::reloc() const {
  return 1;
}

int vxor32B_memNode::reloc() const {
  return 1;
}

int vxor32B_mem_0Node::reloc() const {
  return 1;
}

int vxor64B_memNode::reloc() const {
  return 1;
}

int vxor64B_mem_0Node::reloc() const {
  return 1;
}

int vfma2D_memNode::reloc() const {
  return 1;
}

int vfma4D_memNode::reloc() const {
  return 1;
}

int vfma8D_memNode::reloc() const {
  return 1;
}

int vfma4F_memNode::reloc() const {
  return 1;
}

int vfma8F_memNode::reloc() const {
  return 1;
}

int vfma16F_memNode::reloc() const {
  return 1;
}

int compareAndSwapP_shenandoahNode::reloc() const {
  return 1;
}

int compareAndSwapP_shenandoah_0Node::reloc() const {
  return 1;
}

int compareAndSwapN_shenandoahNode::reloc() const {
  return 1;
}

int compareAndSwapN_shenandoah_0Node::reloc() const {
  return 1;
}

int compareAndExchangeN_shenandoahNode::reloc() const {
  return 1;
}

int compareAndExchangeP_shenandoahNode::reloc() const {
  return 1;
}


void loadBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5065 "src/hotspot/cpu/x86/x86_64.ad"

    __ movsbl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18849 "ad_x86.cpp"
  }
}

void loadB2LNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5080 "src/hotspot/cpu/x86/x86_64.ad"

    __ movsbq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18865 "ad_x86.cpp"
  }
}

void loadUBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5095 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzbl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18881 "ad_x86.cpp"
  }
}

void loadUB2LNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5110 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzbq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18897 "ad_x86.cpp"
  }
}

void loadUB2L_immINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5124 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rdst = opnd_array(0)->as_Register(ra_,this)/* dst */;
    __ movzbq(Rdst, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
    __ andl(Rdst, opnd_array(2)->constant()& right_n_bits(8));
  
#line 18916 "ad_x86.cpp"
  }
}

void loadSNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5140 "src/hotspot/cpu/x86/x86_64.ad"

    __ movswl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18932 "ad_x86.cpp"
  }
}

void loadS2BNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// twentyfour
  {
    MacroAssembler _masm(&cbuf);

#line 5153 "src/hotspot/cpu/x86/x86_64.ad"

    __ movsbl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18949 "ad_x86.cpp"
  }
}

void loadS2LNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5167 "src/hotspot/cpu/x86/x86_64.ad"

    __ movswq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18965 "ad_x86.cpp"
  }
}

void loadUSNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5182 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzwl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18981 "ad_x86.cpp"
  }
}

void loadUS2BNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// twentyfour
  {
    MacroAssembler _masm(&cbuf);

#line 5195 "src/hotspot/cpu/x86/x86_64.ad"

    __ movsbl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 18998 "ad_x86.cpp"
  }
}

void loadUS2LNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5209 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzwq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19014 "ad_x86.cpp"
  }
}

void loadUS2L_immI_255Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5221 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzbq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19031 "ad_x86.cpp"
  }
}

void loadUS2L_immINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5234 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rdst = opnd_array(0)->as_Register(ra_,this)/* dst */;
    __ movzwq(Rdst, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
    __ andl(Rdst, opnd_array(2)->constant()& right_n_bits(16));
  
#line 19050 "ad_x86.cpp"
  }
}

void loadINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5250 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19066 "ad_x86.cpp"
  }
}

void loadI2BNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// twentyfour
  {
    MacroAssembler _masm(&cbuf);

#line 5263 "src/hotspot/cpu/x86/x86_64.ad"

    __ movsbl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19083 "ad_x86.cpp"
  }
}

void loadI2UBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5275 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzbl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19100 "ad_x86.cpp"
  }
}

void loadI2SNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// sixteen
  {
    MacroAssembler _masm(&cbuf);

#line 5287 "src/hotspot/cpu/x86/x86_64.ad"

    __ movswl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19117 "ad_x86.cpp"
  }
}

void loadI2USNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5299 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzwl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19134 "ad_x86.cpp"
  }
}

void loadI2LNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5313 "src/hotspot/cpu/x86/x86_64.ad"

    __ movslq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19150 "ad_x86.cpp"
  }
}

void loadI2L_immI_255Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5325 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzbq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19167 "ad_x86.cpp"
  }
}

void loadI2L_immI_65535Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5336 "src/hotspot/cpu/x86/x86_64.ad"

    __ movzwq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19184 "ad_x86.cpp"
  }
}

void loadI2L_immU31Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5349 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rdst = opnd_array(0)->as_Register(ra_,this)/* dst */;
    __ movl(Rdst, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
    __ andl(Rdst, opnd_array(2)->constant());
  
#line 19203 "ad_x86.cpp"
  }
}

void loadUI2LNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {
    MacroAssembler _masm(&cbuf);

#line 5365 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19220 "ad_x86.cpp"
  }
}

void loadLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5380 "src/hotspot/cpu/x86/x86_64.ad"

    __ movq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19236 "ad_x86.cpp"
  }
}

void loadRangeNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 19277 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8B /*primary()*/));
  
#line 19285 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 19301 "ad_x86.cpp"
  }
}

void loadPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 19344 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8B /*primary()*/));
  
#line 19352 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 19368 "ad_x86.cpp"
  }
}

void loadNNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5418 "src/hotspot/cpu/x86/x86_64.ad"

     __ movl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
   
#line 19384 "ad_x86.cpp"
  }
}

void loadKlassNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 19427 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8B /*primary()*/));
  
#line 19435 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 19451 "ad_x86.cpp"
  }
}

void loadNKlassNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5444 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19467 "ad_x86.cpp"
  }
}

void loadFNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5457 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19483 "ad_x86.cpp"
  }
}

void MoveF2VLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 5467 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 19499 "ad_x86.cpp"
  }
}

void MoveF2LEGNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 5477 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 19515 "ad_x86.cpp"
  }
}

void MoveVL2FNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 5487 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 19531 "ad_x86.cpp"
  }
}

void MoveLEG2FNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 5497 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 19547 "ad_x86.cpp"
  }
}

void loadD_partialNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5511 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19563 "ad_x86.cpp"
  }
}

void loadDNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 5524 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 19579 "ad_x86.cpp"
  }
}

void MoveD2VLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 5534 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 19595 "ad_x86.cpp"
  }
}

void MoveD2LEGNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 5544 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 19611 "ad_x86.cpp"
  }
}

void MoveVL2DNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 5554 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 19627 "ad_x86.cpp"
  }
}

void MoveLEG2DNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 5564 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 19643 "ad_x86.cpp"
  }
}

void maxF_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// a
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// b
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// tmp
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// atmp
  unsigned idx5 = idx4 + opnd_array(4)->num_edges(); 	// btmp
  {
    MacroAssembler _masm(&cbuf);

#line 5589 "src/hotspot/cpu/x86/x86_64.ad"

    int vector_len = Assembler::AVX_128bit;
    __ blendvps(opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, vector_len);
    __ blendvps(opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, vector_len);
    __ vmaxss(opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* tmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */);
    __ cmpps(opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, Assembler::_false, vector_len);
    __ blendvps(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* tmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, vector_len);
 
#line 19668 "ad_x86.cpp"
  }
}

void maxF_reduction_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// a
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// b
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// xmmt
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// tmp
  {
    MacroAssembler _masm(&cbuf);

#line 5606 "src/hotspot/cpu/x86/x86_64.ad"

    emit_fp_min_max(_masm, opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* xmmt */, opnd_array(4)->as_Register(ra_,this,idx4)/* tmp */,
                    false /*min*/, true /*single*/);
  
#line 19688 "ad_x86.cpp"
  }
}

void maxD_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// a
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// b
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// tmp
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// atmp
  unsigned idx5 = idx4 + opnd_array(4)->num_edges(); 	// btmp
  {
    MacroAssembler _masm(&cbuf);

#line 5625 "src/hotspot/cpu/x86/x86_64.ad"

    int vector_len = Assembler::AVX_128bit;
    __ blendvpd(opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, vector_len);
    __ blendvpd(opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, vector_len);
    __ vmaxsd(opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* tmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */);
    __ cmppd(opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, Assembler::_false, vector_len);
    __ blendvpd(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* tmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, vector_len);
  
#line 19713 "ad_x86.cpp"
  }
}

void maxD_reduction_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// a
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// b
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// xmmt
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// tmp
  {
    MacroAssembler _masm(&cbuf);

#line 5642 "src/hotspot/cpu/x86/x86_64.ad"

    emit_fp_min_max(_masm, opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* xmmt */, opnd_array(4)->as_Register(ra_,this,idx4)/* tmp */,
                    false /*min*/, false /*single*/);
  
#line 19733 "ad_x86.cpp"
  }
}

void minF_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// a
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// b
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// tmp
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// atmp
  unsigned idx5 = idx4 + opnd_array(4)->num_edges(); 	// btmp
  {
    MacroAssembler _masm(&cbuf);

#line 5661 "src/hotspot/cpu/x86/x86_64.ad"

    int vector_len = Assembler::AVX_128bit;
    __ blendvps(opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, vector_len);
    __ blendvps(opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, vector_len);
    __ vminss(opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* tmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */);
    __ cmpps(opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, Assembler::_false, vector_len);
    __ blendvps(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* tmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, vector_len);
  
#line 19758 "ad_x86.cpp"
  }
}

void minF_reduction_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// a
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// b
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// xmmt
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// tmp
  {
    MacroAssembler _masm(&cbuf);

#line 5678 "src/hotspot/cpu/x86/x86_64.ad"

    emit_fp_min_max(_masm, opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* xmmt */, opnd_array(4)->as_Register(ra_,this,idx4)/* tmp */,
                    true /*min*/, true /*single*/);
  
#line 19778 "ad_x86.cpp"
  }
}

void minD_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// a
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// b
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// tmp
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// atmp
  unsigned idx5 = idx4 + opnd_array(4)->num_edges(); 	// btmp
  {
    MacroAssembler _masm(&cbuf);

#line 5697 "src/hotspot/cpu/x86/x86_64.ad"

    int vector_len = Assembler::AVX_128bit;
    __ blendvpd(opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, vector_len);
    __ blendvpd(opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, vector_len);
    __ vminsd(opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* tmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */);
    __ cmppd(opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, Assembler::_false, vector_len);
    __ blendvpd(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* tmp */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* atmp */, opnd_array(5)->as_XMMRegister(ra_,this,idx5)/* btmp */, vector_len);
  
#line 19803 "ad_x86.cpp"
  }
}

void minD_reduction_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// a
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// b
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// xmmt
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// tmp
  {
    MacroAssembler _masm(&cbuf);

#line 5714 "src/hotspot/cpu/x86/x86_64.ad"

    emit_fp_min_max(_masm, opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* a */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* b */, opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* xmmt */, opnd_array(4)->as_Register(ra_,this,idx4)/* tmp */,
                    true /*min*/, false /*single*/);
  
#line 19823 "ad_x86.cpp"
  }
}

void leaP8Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 19866 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 19874 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 19890 "ad_x86.cpp"
  }
}

void leaP32Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 19933 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 19941 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 19957 "ad_x86.cpp"
  }
}

void leaPIdxOffNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20000 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20008 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20024 "ad_x86.cpp"
  }
}

void leaPIdxScaleNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20067 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20075 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20091 "ad_x86.cpp"
  }
}

void leaPPosIdxScaleNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20134 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20142 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20158 "ad_x86.cpp"
  }
}

void leaPIdxScaleOffNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20201 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20209 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20225 "ad_x86.cpp"
  }
}

void leaPPosIdxOffNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20268 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20276 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20292 "ad_x86.cpp"
  }
}

void leaPPosIdxScaleOffNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20335 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20343 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20359 "ad_x86.cpp"
  }
}

void leaPCompressedOopOffsetNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20402 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20410 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20426 "ad_x86.cpp"
  }
}

void leaP8NarrowNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20469 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20477 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20493 "ad_x86.cpp"
  }
}

void leaP32NarrowNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20536 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20544 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20560 "ad_x86.cpp"
  }
}

void leaPIdxOffNarrowNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20603 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20611 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20627 "ad_x86.cpp"
  }
}

void leaPIdxScaleNarrowNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20670 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20678 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20694 "ad_x86.cpp"
  }
}

void leaPIdxScaleOffNarrowNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20737 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20745 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20761 "ad_x86.cpp"
  }
}

void leaPPosIdxOffNarrowNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20804 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20812 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20828 "ad_x86.cpp"
  }
}

void leaPPosIdxScaleOffNarrowNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 20871 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 20879 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 20895 "ad_x86.cpp"
  }
}

void loadConINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2325 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    emit_opcode(cbuf, 0xB8 | dstenc);
    emit_d32(cbuf, opnd_array(1)->constant());
  
#line 20916 "ad_x86.cpp"
  }
}

void loadConI0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* dst */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 20941 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 20949 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(0)->reg(ra_,this)/* dst */ & 7);
  
#line 20957 "ad_x86.cpp"
  }
}

void loadConLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2336 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_opcode(cbuf, 0xB8 | dstenc);
    emit_d64(cbuf, opnd_array(1)->constantL());
  
#line 20980 "ad_x86.cpp"
  }
}

void loadConL0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* dst */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 21005 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 21013 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(0)->reg(ra_,this)/* dst */ & 7);
  
#line 21021 "ad_x86.cpp"
  }
}

void loadConUL32Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2349 "src/hotspot/cpu/x86/x86_64.ad"

    // same as load_immI, but this time we care about zeroes in the high word
    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    emit_opcode(cbuf, 0xB8 | dstenc);
    emit_d32(cbuf, opnd_array(1)->constantL());
  
#line 21043 "ad_x86.cpp"
  }
}

void loadConL32Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2361 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_opcode(cbuf, 0xC7);
    emit_rm(cbuf, 0x03, 0x00, dstenc);
    emit_d32(cbuf, opnd_array(1)->constantL());
  
#line 21067 "ad_x86.cpp"
  }
}

void loadConPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// con
  {

#line 2387 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_opcode(cbuf, 0xB8 | dstenc);
    // This next line should be generated from ADLC
    if (opnd_array(1)->constant_reloc() != relocInfo::none) {
      emit_d64_reloc(cbuf, opnd_array(1)->constant(), opnd_array(1)->constant_reloc(), RELOC_IMM64);
    } else {
      emit_d64(cbuf, opnd_array(1)->constant());
    }
  
#line 21095 "ad_x86.cpp"
  }
}

void loadConP0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* dst */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 21120 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 21128 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(0)->reg(ra_,this)/* dst */ & 7);
  
#line 21136 "ad_x86.cpp"
  }
}

void loadConP31Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2375 "src/hotspot/cpu/x86/x86_64.ad"

    // same as load_immI, but this time we care about zeroes in the high word
    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    emit_opcode(cbuf, 0xB8 | dstenc);
    
if ( opnd_array(1)->constant_reloc() != relocInfo::none ) {
  emit_d32_reloc(cbuf, opnd_array(1)->constant(), opnd_array(1)->constant_reloc(), 0);
} else {
  emit_d32(cbuf, opnd_array(1)->constant());
};
  
#line 21163 "ad_x86.cpp"
  }
}

void loadConFNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// con
  {
    MacroAssembler _masm(&cbuf);

#line 6016 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, InternalAddress(__ code()->consts()->start() + constant_offset()));
  
#line 21179 "ad_x86.cpp"
  }
}

void loadConFNode::eval_constant(Compile* C) {
  {

#line 6017 "src/hotspot/cpu/x86/x86_64.ad"
    _constant = C->constant_table().add(this, opnd_array(1));
#line 21188 "ad_x86.cpp"
  }
}
void loadConN0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6026 "src/hotspot/cpu/x86/x86_64.ad"

    __ xorq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(0)->as_Register(ra_,this)/* dst */);
  
#line 21203 "ad_x86.cpp"
  }
}

void loadConNNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6037 "src/hotspot/cpu/x86/x86_64.ad"

    address con = (address)opnd_array(1)->constant();
    if (con == NULL) {
      ShouldNotReachHere();
    } else {
      __ set_narrow_oop(opnd_array(0)->as_Register(ra_,this)/* dst */, (jobject)opnd_array(1)->constant());
    }
  
#line 21224 "ad_x86.cpp"
  }
}

void loadConNKlassNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6053 "src/hotspot/cpu/x86/x86_64.ad"

    address con = (address)opnd_array(1)->constant();
    if (con == NULL) {
      ShouldNotReachHere();
    } else {
      __ set_narrow_klass(opnd_array(0)->as_Register(ra_,this)/* dst */, (Klass*)opnd_array(1)->constant());
    }
  
#line 21245 "ad_x86.cpp"
  }
}

void loadConF0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6070 "src/hotspot/cpu/x86/x86_64.ad"

    __ xorps(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(0)->as_XMMRegister(ra_,this)/* dst */);
  
#line 21261 "ad_x86.cpp"
  }
}

void loadConDNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// con
  {
    MacroAssembler _masm(&cbuf);

#line 6081 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, InternalAddress(__ code()->consts()->start() + constant_offset()));
  
#line 21277 "ad_x86.cpp"
  }
}

void loadConDNode::eval_constant(Compile* C) {
  {

#line 6082 "src/hotspot/cpu/x86/x86_64.ad"
    _constant = C->constant_table().add(this, opnd_array(1));
#line 21286 "ad_x86.cpp"
  }
}
void loadConD0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6093 "src/hotspot/cpu/x86/x86_64.ad"

    __ xorpd (opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, opnd_array(0)->as_XMMRegister(ra_,this)/* dst */);
  
#line 21301 "ad_x86.cpp"
  }
}

void loadSSINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 21342 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8B /*primary()*/));
  
#line 21350 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 21366 "ad_x86.cpp"
  }
}

void loadSSLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 21409 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8B /*primary()*/));
  
#line 21417 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 21433 "ad_x86.cpp"
  }
}

void loadSSPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 21476 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8B /*primary()*/));
  
#line 21484 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 21500 "ad_x86.cpp"
  }
}

void loadSSFNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6138 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, Address(rsp, opnd_array(1)->disp(ra_,this,idx1)));
  
#line 21516 "ad_x86.cpp"
  }
}

void loadSSDNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6151 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(opnd_array(0)->as_XMMRegister(ra_,this)/* dst */, Address(rsp, opnd_array(1)->disp(ra_,this,idx1)));
  
#line 21532 "ad_x86.cpp"
  }
}

void prefetchAllocNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// 
  {
    MacroAssembler _masm(&cbuf);

#line 6166 "src/hotspot/cpu/x86/x86_64.ad"

    __ prefetchw(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 21548 "ad_x86.cpp"
  }
}

void prefetchAllocNTANode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// 
  {
    MacroAssembler _masm(&cbuf);

#line 6178 "src/hotspot/cpu/x86/x86_64.ad"

    __ prefetchnta(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 21564 "ad_x86.cpp"
  }
}

void prefetchAllocT0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// 
  {
    MacroAssembler _masm(&cbuf);

#line 6190 "src/hotspot/cpu/x86/x86_64.ad"

    __ prefetcht0(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 21580 "ad_x86.cpp"
  }
}

void prefetchAllocT2Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// 
  {
    MacroAssembler _masm(&cbuf);

#line 6202 "src/hotspot/cpu/x86/x86_64.ad"

    __ prefetcht2(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 21596 "ad_x86.cpp"
  }
}

void storeBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2501 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        } else if (opnd_array(2)->reg(ra_,this,idx2)/* src */ >= 4) {
          emit_opcode(cbuf, Assembler::REX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 21640 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x88 /*primary()*/));
  
#line 21648 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 21664 "ad_x86.cpp"
  }
}

void storeCNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 1942 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, 0x66);
  
#line 21680 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 21714 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x89 /*primary()*/));
  
#line 21722 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 21738 "ad_x86.cpp"
  }
}

void storeINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 21780 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x89 /*primary()*/));
  
#line 21788 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 21804 "ad_x86.cpp"
  }
}

void storeLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 21848 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x89 /*primary()*/));
  
#line 21856 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 21872 "ad_x86.cpp"
  }
}

void storePNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 21916 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x89 /*primary()*/));
  
#line 21924 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 21940 "ad_x86.cpp"
  }
}

void storeImmP0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6277 "src/hotspot/cpu/x86/x86_64.ad"

    __ movq(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 21957 "ad_x86.cpp"
  }
}

void storeImmPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 21985 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC7 /*primary()*/));
  
#line 21993 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 22013 "ad_x86.cpp"
  }
  {

#line 2405 "src/hotspot/cpu/x86/x86_64.ad"

    // Output immediate
    
if ( opnd_array(2)->constant_reloc() != relocInfo::none ) {
  emit_d32_reloc(cbuf, opnd_array(2)->constant(), opnd_array(2)->constant_reloc(), 0);
} else {
  emit_d32(cbuf, opnd_array(2)->constant());
};
  
#line 22027 "ad_x86.cpp"
  }
}

void storeNNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6302 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->as_Register(ra_,this,idx2)/* src */);
  
#line 22044 "ad_x86.cpp"
  }
}

void storeNKlassNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6314 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->as_Register(ra_,this,idx2)/* src */);
  
#line 22061 "ad_x86.cpp"
  }
}

void storeImmN0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6327 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 22078 "ad_x86.cpp"
  }
}

void storeImmNNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6339 "src/hotspot/cpu/x86/x86_64.ad"

    address con = (address)opnd_array(2)->constant();
    if (con == NULL) {
      __ movl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), (int32_t)0);
    } else {
      __ set_narrow_oop(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), (jobject)opnd_array(2)->constant());
    }
  
#line 22100 "ad_x86.cpp"
  }
}

void storeImmNKlassNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6356 "src/hotspot/cpu/x86/x86_64.ad"

    __ set_narrow_klass(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), (Klass*)opnd_array(2)->constant());
  
#line 22117 "ad_x86.cpp"
  }
}

void storeImmI0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6370 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 22134 "ad_x86.cpp"
  }
}

void storeImmINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 22160 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC7 /*primary()*/));
  
#line 22168 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 22188 "ad_x86.cpp"
  }
  {

#line 2405 "src/hotspot/cpu/x86/x86_64.ad"

    // Output immediate
    emit_d32(cbuf, opnd_array(2)->constant());
  
#line 22197 "ad_x86.cpp"
  }
}

void storeImmL0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6395 "src/hotspot/cpu/x86/x86_64.ad"

    __ movq(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 22214 "ad_x86.cpp"
  }
}

void storeImmLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 22242 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC7 /*primary()*/));
  
#line 22250 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 22270 "ad_x86.cpp"
  }
  {

#line 2405 "src/hotspot/cpu/x86/x86_64.ad"

    // Output immediate
    emit_d32(cbuf, opnd_array(2)->constantL());
  
#line 22279 "ad_x86.cpp"
  }
}

void storeImmC0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6420 "src/hotspot/cpu/x86/x86_64.ad"

    __ movw(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 22296 "ad_x86.cpp"
  }
}

void storeImmI16Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 1942 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, 0x66);
  
#line 22312 "ad_x86.cpp"
  }
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 22330 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC7 /*primary()*/));
  
#line 22338 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 22358 "ad_x86.cpp"
  }
  {

#line 2419 "src/hotspot/cpu/x86/x86_64.ad"

    // Output immediate
    emit_d16(cbuf, opnd_array(2)->constant());
  
#line 22367 "ad_x86.cpp"
  }
}

void storeImmB0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6446 "src/hotspot/cpu/x86/x86_64.ad"

    __ movb(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 22384 "ad_x86.cpp"
  }
}

void storeImmBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 22410 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC6 /*primary()*/));
  
#line 22418 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 22438 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 22452 "ad_x86.cpp"
  }
}

void storeImmCM0_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6471 "src/hotspot/cpu/x86/x86_64.ad"

    __ movb(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 22469 "ad_x86.cpp"
  }
}

void storeImmCM0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 22495 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC6 /*primary()*/));
  
#line 22503 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 22523 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 22537 "ad_x86.cpp"
  }
}

void storeFNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6495 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* src */);
  
#line 22554 "ad_x86.cpp"
  }
}

void storeF0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6509 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 22571 "ad_x86.cpp"
  }
}

void storeF_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 22597 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC7 /*primary()*/));
  
#line 22605 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 22625 "ad_x86.cpp"
  }
  {

#line 2411 "src/hotspot/cpu/x86/x86_64.ad"

    // Output Float immediate bits
    jfloat jf = opnd_array(2)->constantF();
    jint jf_as_bits = jint_cast(jf);
    emit_d32(cbuf, jf_as_bits);
  
#line 22636 "ad_x86.cpp"
  }
}

void storeDNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6533 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* src */);
  
#line 22653 "ad_x86.cpp"
  }
}

void storeD0_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 22681 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC7 /*primary()*/));
  
#line 22689 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 22709 "ad_x86.cpp"
  }
  {

#line 2411 "src/hotspot/cpu/x86/x86_64.ad"

    // Output Float immediate bits
    jfloat jf = opnd_array(2)->constantD();
    jint jf_as_bits = jint_cast(jf);
    emit_d32(cbuf, jf_as_bits);
  
#line 22720 "ad_x86.cpp"
  }
}

void storeD0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 6559 "src/hotspot/cpu/x86/x86_64.ad"

    __ movq(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), r12);
  
#line 22737 "ad_x86.cpp"
  }
}

void storeSSINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
      if (opnd_array(0)->base(ra_,this,idx0) < 8) {
        if (opnd_array(0)->index(ra_,this,idx0) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(0)->base(ra_,this,idx0) < 8) {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 22778 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x89 /*primary()*/));
  
#line 22786 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* src */;
    int base = opnd_array(0)->base(ra_,this,idx0);
    int index = opnd_array(0)->index(ra_,this,idx0);
    int scale = opnd_array(0)->scale();
    int disp = opnd_array(0)->disp(ra_,this,0);
    relocInfo::relocType disp_reloc = opnd_array(0)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 22802 "ad_x86.cpp"
  }
}

void storeSSLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
      if (opnd_array(0)->base(ra_,this,idx0) < 8) {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(0)->base(ra_,this,idx0) < 8) {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 22845 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x89 /*primary()*/));
  
#line 22853 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* src */;
    int base = opnd_array(0)->base(ra_,this,idx0);
    int index = opnd_array(0)->index(ra_,this,idx0);
    int scale = opnd_array(0)->scale();
    int disp = opnd_array(0)->disp(ra_,this,0);
    relocInfo::relocType disp_reloc = opnd_array(0)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 22869 "ad_x86.cpp"
  }
}

void storeSSPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
      if (opnd_array(0)->base(ra_,this,idx0) < 8) {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(0)->base(ra_,this,idx0) < 8) {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(0)->index(ra_,this,idx0) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 22912 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x89 /*primary()*/));
  
#line 22920 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* src */;
    int base = opnd_array(0)->base(ra_,this,idx0);
    int index = opnd_array(0)->index(ra_,this,idx0);
    int scale = opnd_array(0)->scale();
    int disp = opnd_array(0)->disp(ra_,this,0);
    relocInfo::relocType disp_reloc = opnd_array(0)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 22936 "ad_x86.cpp"
  }
}

void storeSSFNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6604 "src/hotspot/cpu/x86/x86_64.ad"

    __ movflt(Address(rsp, opnd_array(0)->disp(ra_,this,0)), opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 22952 "ad_x86.cpp"
  }
}

void storeSSDNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6616 "src/hotspot/cpu/x86/x86_64.ad"

    __ movdbl(Address(rsp, opnd_array(0)->disp(ra_,this,0)), opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */);
  
#line 22968 "ad_x86.cpp"
  }
}

void bytes_reverse_intNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 22985 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 22993 "ad_x86.cpp"
  }
  {

#line 2164 "src/hotspot/cpu/x86/x86_64.ad"

    // BSWAP
    emit_cc(cbuf, (0xC8 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */);
  
#line 23002 "ad_x86.cpp"
  }
}

void bytes_reverse_longNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 23021 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 23029 "ad_x86.cpp"
  }
  {

#line 2164 "src/hotspot/cpu/x86/x86_64.ad"

    // BSWAP
    emit_cc(cbuf, (0xC8 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */);
  
#line 23038 "ad_x86.cpp"
  }
}

void bytes_reverse_unsigned_shortNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  {
    MacroAssembler _masm(&cbuf);

#line 6647 "src/hotspot/cpu/x86/x86_64.ad"

    __ bswapl(opnd_array(1)->as_Register(ra_,this,idx1)/* dst */);
    __ shrl(opnd_array(1)->as_Register(ra_,this,idx1)/* dst */, 16);
  
#line 23055 "ad_x86.cpp"
  }
}

void bytes_reverse_shortNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  {
    MacroAssembler _masm(&cbuf);

#line 6660 "src/hotspot/cpu/x86/x86_64.ad"

    __ bswapl(opnd_array(1)->as_Register(ra_,this,idx1)/* dst */);
    __ sarl(opnd_array(1)->as_Register(ra_,this,idx1)/* dst */, 16);
  
#line 23072 "ad_x86.cpp"
  }
}

void countLeadingZerosINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6675 "src/hotspot/cpu/x86/x86_64.ad"

    __ lzcntl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23088 "ad_x86.cpp"
  }
}

void countLeadingZerosI_bsrNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6692 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rdst = opnd_array(0)->as_Register(ra_,this)/* dst */;
    Register Rsrc = opnd_array(1)->as_Register(ra_,this,idx1)/* src */;
    Label skip;
    __ bsrl(Rdst, Rsrc);
    __ jccb(Assembler::notZero, skip);
    __ movl(Rdst, -1);
    __ bind(skip);
    __ negl(Rdst);
    __ addl(Rdst, BitsPerInt - 1);
  
#line 23112 "ad_x86.cpp"
  }
}

void countLeadingZerosLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6712 "src/hotspot/cpu/x86/x86_64.ad"

    __ lzcntq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23128 "ad_x86.cpp"
  }
}

void countLeadingZerosL_bsrNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6729 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rdst = opnd_array(0)->as_Register(ra_,this)/* dst */;
    Register Rsrc = opnd_array(1)->as_Register(ra_,this,idx1)/* src */;
    Label skip;
    __ bsrq(Rdst, Rsrc);
    __ jccb(Assembler::notZero, skip);
    __ movl(Rdst, -1);
    __ bind(skip);
    __ negl(Rdst);
    __ addl(Rdst, BitsPerLong - 1);
  
#line 23152 "ad_x86.cpp"
  }
}

void countTrailingZerosINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6749 "src/hotspot/cpu/x86/x86_64.ad"

    __ tzcntl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23168 "ad_x86.cpp"
  }
}

void countTrailingZerosI_bsfNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6764 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rdst = opnd_array(0)->as_Register(ra_,this)/* dst */;
    Label done;
    __ bsfl(Rdst, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
    __ jccb(Assembler::notZero, done);
    __ movl(Rdst, BitsPerInt);
    __ bind(done);
  
#line 23189 "ad_x86.cpp"
  }
}

void countTrailingZerosLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6781 "src/hotspot/cpu/x86/x86_64.ad"

    __ tzcntq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23205 "ad_x86.cpp"
  }
}

void countTrailingZerosL_bsfNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6796 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rdst = opnd_array(0)->as_Register(ra_,this)/* dst */;
    Label done;
    __ bsfq(Rdst, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
    __ jccb(Assembler::notZero, done);
    __ movl(Rdst, BitsPerLong);
    __ bind(done);
  
#line 23226 "ad_x86.cpp"
  }
}

void popCountINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6816 "src/hotspot/cpu/x86/x86_64.ad"

    __ popcntl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23242 "ad_x86.cpp"
  }
}

void popCountI_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 6828 "src/hotspot/cpu/x86/x86_64.ad"

    __ popcntl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 23258 "ad_x86.cpp"
  }
}

void popCountLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6841 "src/hotspot/cpu/x86/x86_64.ad"

    __ popcntq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23274 "ad_x86.cpp"
  }
}

void popCountL_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {
    MacroAssembler _masm(&cbuf);

#line 6854 "src/hotspot/cpu/x86/x86_64.ad"

    __ popcntq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 23290 "ad_x86.cpp"
  }
}

void membar_acquireNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  // User did not define which encode class to use.
}

uint membar_acquireNode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void membar_acquire_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  // User did not define which encode class to use.
}

uint membar_acquire_0Node::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void membar_acquire_lockNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  // User did not define which encode class to use.
}

uint membar_acquire_lockNode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void membar_releaseNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  // User did not define which encode class to use.
}

uint membar_releaseNode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void membar_release_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  // User did not define which encode class to use.
}

uint membar_release_0Node::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void membar_release_lockNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  // User did not define which encode class to use.
}

uint membar_release_lockNode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void membar_volatileNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  {
    MacroAssembler _masm(&cbuf);

#line 6923 "src/hotspot/cpu/x86/x86_64.ad"

    __ membar(Assembler::StoreLoad);
  
#line 23384 "ad_x86.cpp"
  }
}

void unnecessary_membar_volatileNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  // User did not define which encode class to use.
}

uint unnecessary_membar_volatileNode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void membar_storestoreNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  // User did not define which encode class to use.
}

uint membar_storestoreNode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void castX2PNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6958 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */!= opnd_array(1)->reg(ra_,this,idx1)/* src */) {
      __ movptr(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
    }
  
#line 23428 "ad_x86.cpp"
  }
}

void castP2XNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6971 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */!= opnd_array(1)->reg(ra_,this,idx1)/* src */) {
      __ movptr(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
    }
  
#line 23446 "ad_x86.cpp"
  }
}

void convP2INode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6985 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23462 "ad_x86.cpp"
  }
}

void convN2INode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 6999 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23478 "ad_x86.cpp"
  }
}

void encodeHeapOopNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7011 "src/hotspot/cpu/x86/x86_64.ad"

    Register s = opnd_array(1)->as_Register(ra_,this,idx1)/* src */;
    Register d = opnd_array(0)->as_Register(ra_,this)/* dst */;
    if (s != d) {
      __ movq(d, s);
    }
    __ encode_heap_oop(d);
  
#line 23499 "ad_x86.cpp"
  }
}

void encodeHeapOop_not_nullNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7027 "src/hotspot/cpu/x86/x86_64.ad"

    __ encode_heap_oop_not_null(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23515 "ad_x86.cpp"
  }
}

void decodeHeapOopNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7039 "src/hotspot/cpu/x86/x86_64.ad"

    Register s = opnd_array(1)->as_Register(ra_,this,idx1)/* src */;
    Register d = opnd_array(0)->as_Register(ra_,this)/* dst */;
    if (s != d) {
      __ movq(d, s);
    }
    __ decode_heap_oop(d);
  
#line 23536 "ad_x86.cpp"
  }
}

void decodeHeapOop_not_nullNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7056 "src/hotspot/cpu/x86/x86_64.ad"

    Register s = opnd_array(1)->as_Register(ra_,this,idx1)/* src */;
    Register d = opnd_array(0)->as_Register(ra_,this)/* dst */;
    if (s != d) {
      __ decode_heap_oop_not_null(d, s);
    } else {
      __ decode_heap_oop_not_null(d);
    }
  
#line 23558 "ad_x86.cpp"
  }
}

void encodeKlass_not_nullNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7072 "src/hotspot/cpu/x86/x86_64.ad"

    __ encode_klass_not_null(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 23574 "ad_x86.cpp"
  }
}

void decodeKlass_not_nullNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7082 "src/hotspot/cpu/x86/x86_64.ad"

    Register s = opnd_array(1)->as_Register(ra_,this,idx1)/* src */;
    Register d = opnd_array(0)->as_Register(ra_,this)/* dst */;
    if (s != d) {
      __ decode_klass_not_null(d, s);
    } else {
      __ decode_klass_not_null(d);
    }
  
#line 23596 "ad_x86.cpp"
  }
}

void jumpXtnd_offsetNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  ra_->C->constant_table().fill_jump_table(cbuf, (MachConstantNode*) this, _index2label);
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dest
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// 
  {
    MacroAssembler _masm(&cbuf);

#line 7106 "src/hotspot/cpu/x86/x86_64.ad"

    // We could use jump(ArrayAddress) except that the macro assembler needs to use r10
    // to do that and the compiler is using that register as one it can allocate.
    // So we build it all by hand.
    // Address index(noreg, switch_reg, (Address::ScaleFactor)$shift$$constant);
    // ArrayAddress dispatch(table, index);
    Address dispatch(opnd_array(3)->as_Register(ra_,this,idx3)/* dest */, opnd_array(1)->as_Register(ra_,this,idx1)/* switch_val */, (Address::ScaleFactor) opnd_array(2)->constant());
    __ lea(opnd_array(3)->as_Register(ra_,this,idx3)/* dest */, InternalAddress(__ code()->consts()->start() + constant_offset()));
    __ jmp(dispatch);
  
#line 23622 "ad_x86.cpp"
  }
}

void jumpXtnd_offsetNode::eval_constant(Compile* C) {
  _constant = C->constant_table().add_jump_table(this);
  // User did not define an encode section.
}
void jumpXtnd_addrNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  ra_->C->constant_table().fill_jump_table(cbuf, (MachConstantNode*) this, _index2label);
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// offset
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dest
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// 
  {
    MacroAssembler _masm(&cbuf);

#line 7126 "src/hotspot/cpu/x86/x86_64.ad"

    // We could use jump(ArrayAddress) except that the macro assembler needs to use r10
    // to do that and the compiler is using that register as one it can allocate.
    // So we build it all by hand.
    // Address index(noreg, switch_reg, (Address::ScaleFactor) $shift$$constant, (int) $offset$$constant);
    // ArrayAddress dispatch(table, index);
    Address dispatch(opnd_array(4)->as_Register(ra_,this,idx4)/* dest */, opnd_array(1)->as_Register(ra_,this,idx1)/* switch_val */, (Address::ScaleFactor) opnd_array(2)->constant(), (int) opnd_array(3)->constantL());
    __ lea(opnd_array(4)->as_Register(ra_,this,idx4)/* dest */, InternalAddress(__ code()->consts()->start() + constant_offset()));
    __ jmp(dispatch);
  
#line 23653 "ad_x86.cpp"
  }
}

void jumpXtnd_addrNode::eval_constant(Compile* C) {
  _constant = C->constant_table().add_jump_table(this);
  // User did not define an encode section.
}
void jumpXtndNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  ra_->C->constant_table().fill_jump_table(cbuf, (MachConstantNode*) this, _index2label);
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dest
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// 
  {
    MacroAssembler _masm(&cbuf);

#line 7146 "src/hotspot/cpu/x86/x86_64.ad"

    // We could use jump(ArrayAddress) except that the macro assembler needs to use r10
    // to do that and the compiler is using that register as one it can allocate.
    // So we build it all by hand.
    // Address index(noreg, switch_reg, Address::times_1);
    // ArrayAddress dispatch(table, index);
    Address dispatch(opnd_array(2)->as_Register(ra_,this,idx2)/* dest */, opnd_array(1)->as_Register(ra_,this,idx1)/* switch_val */, Address::times_1);
    __ lea(opnd_array(2)->as_Register(ra_,this,idx2)/* dest */, InternalAddress(__ code()->consts()->start() + constant_offset()));
    __ jmp(dispatch);
  
#line 23682 "ad_x86.cpp"
  }
}

void jumpXtndNode::eval_constant(Compile* C) {
  _constant = C->constant_table().add_jump_table(this);
  // User did not define an encode section.
}
void cmovI_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 23714 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 23724 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(3)->reg(ra_,this,idx3)/* dst */ & 7, opnd_array(4)->reg(ra_,this,idx4)/* src */ & 7);
  
#line 23732 "ad_x86.cpp"
  }
}

void cmovI_regUNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 23760 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 23770 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(3)->reg(ra_,this,idx3)/* dst */ & 7, opnd_array(4)->reg(ra_,this,idx4)/* src */ & 7);
  
#line 23778 "ad_x86.cpp"
  }
}

void cmovI_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->base(ra_,this,idx4) < 8) {
        if (opnd_array(4)->index(ra_,this,idx4) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(4)->base(ra_,this,idx4) < 8) {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 23822 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 23832 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* dst */;
    int base = opnd_array(4)->base(ra_,this,idx4);
    int index = opnd_array(4)->index(ra_,this,idx4);
    int scale = opnd_array(4)->scale();
    int disp = opnd_array(4)->disp(ra_,this,idx4);
    relocInfo::relocType disp_reloc = opnd_array(4)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 23848 "ad_x86.cpp"
  }
}

void cmovI_memUNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->base(ra_,this,idx4) < 8) {
        if (opnd_array(4)->index(ra_,this,idx4) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(4)->base(ra_,this,idx4) < 8) {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 23892 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 23902 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* dst */;
    int base = opnd_array(4)->base(ra_,this,idx4);
    int index = opnd_array(4)->index(ra_,this,idx4);
    int scale = opnd_array(4)->scale();
    int disp = opnd_array(4)->disp(ra_,this,idx4);
    relocInfo::relocType disp_reloc = opnd_array(4)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 23918 "ad_x86.cpp"
  }
}

void cmovN_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 23946 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 23956 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(3)->reg(ra_,this,idx3)/* dst */ & 7, opnd_array(4)->reg(ra_,this,idx4)/* src */ & 7);
  
#line 23964 "ad_x86.cpp"
  }
}

void cmovN_regUNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 23992 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 24002 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(3)->reg(ra_,this,idx3)/* dst */ & 7, opnd_array(4)->reg(ra_,this,idx4)/* src */ & 7);
  
#line 24010 "ad_x86.cpp"
  }
}

void cmovP_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 24040 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 24050 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(3)->reg(ra_,this,idx3)/* dst */ & 7, opnd_array(4)->reg(ra_,this,idx4)/* src */ & 7);
  
#line 24058 "ad_x86.cpp"
  }
}

void cmovP_regUNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 24088 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 24098 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(3)->reg(ra_,this,idx3)/* dst */ & 7, opnd_array(4)->reg(ra_,this,idx4)/* src */ & 7);
  
#line 24106 "ad_x86.cpp"
  }
}

void cmovL_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 24136 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 24146 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(3)->reg(ra_,this,idx3)/* dst */ & 7, opnd_array(4)->reg(ra_,this,idx4)/* src */ & 7);
  
#line 24154 "ad_x86.cpp"
  }
}

void cmovL_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->base(ra_,this,idx4) < 8) {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(4)->base(ra_,this,idx4) < 8) {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 24200 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 24210 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* dst */;
    int base = opnd_array(4)->base(ra_,this,idx4);
    int index = opnd_array(4)->index(ra_,this,idx4);
    int scale = opnd_array(4)->scale();
    int disp = opnd_array(4)->disp(ra_,this,idx4);
    relocInfo::relocType disp_reloc = opnd_array(4)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 24226 "ad_x86.cpp"
  }
}

void cmovL_regUNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(4)->reg(ra_,this,idx4)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 24256 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 24266 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(3)->reg(ra_,this,idx3)/* dst */ & 7, opnd_array(4)->reg(ra_,this,idx4)/* src */ & 7);
  
#line 24274 "ad_x86.cpp"
  }
}

void cmovL_memUNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* dst */ < 8) {
      if (opnd_array(4)->base(ra_,this,idx4) < 8) {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(4)->base(ra_,this,idx4) < 8) {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(4)->index(ra_,this,idx4) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 24320 "ad_x86.cpp"
  }
  {

#line 2182 "src/hotspot/cpu/x86/x86_64.ad"

    // CMOV
    emit_d8(cbuf, (0x0F /*primary()*/));
    emit_cc(cbuf, (0x40 /*secondary()*/), opnd_array(1)->ccode());
  
#line 24330 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* dst */;
    int base = opnd_array(4)->base(ra_,this,idx4);
    int index = opnd_array(4)->index(ra_,this,idx4);
    int scale = opnd_array(4)->scale();
    int disp = opnd_array(4)->disp(ra_,this,idx4);
    relocInfo::relocType disp_reloc = opnd_array(4)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 24346 "ad_x86.cpp"
  }
}

void cmovF_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7379 "src/hotspot/cpu/x86/x86_64.ad"

    Label Lskip;
    // Invert sense of branch from sense of CMOV
    __ jccb((Assembler::Condition)(opnd_array(1)->ccode()^1), Lskip);
    __ movflt(opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* dst */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* src */);
    __ bind(Lskip);
  
#line 24369 "ad_x86.cpp"
  }
}

void cmovF_regUNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7409 "src/hotspot/cpu/x86/x86_64.ad"

    Label Lskip;
    // Invert sense of branch from sense of CMOV
    __ jccb((Assembler::Condition)(opnd_array(1)->ccode()^1), Lskip);
    __ movflt(opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* dst */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* src */);
    __ bind(Lskip);
  
#line 24392 "ad_x86.cpp"
  }
}

void cmovD_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7435 "src/hotspot/cpu/x86/x86_64.ad"

    Label Lskip;
    // Invert sense of branch from sense of CMOV
    __ jccb((Assembler::Condition)(opnd_array(1)->ccode()^1), Lskip);
    __ movdbl(opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* dst */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* src */);
    __ bind(Lskip);
  
#line 24415 "ad_x86.cpp"
  }
}

void cmovD_regUNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cop
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// dst
  unsigned idx4 = idx3 + opnd_array(3)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 7453 "src/hotspot/cpu/x86/x86_64.ad"

    Label Lskip;
    // Invert sense of branch from sense of CMOV
    __ jccb((Assembler::Condition)(opnd_array(1)->ccode()^1), Lskip);
    __ movdbl(opnd_array(3)->as_XMMRegister(ra_,this,idx3)/* dst */, opnd_array(4)->as_XMMRegister(ra_,this,idx4)/* src */);
    __ bind(Lskip);
  
#line 24438 "ad_x86.cpp"
  }
}

void addI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 24464 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x03 /*primary()*/));
  
#line 24472 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 24480 "ad_x86.cpp"
  }
}

void addI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2111 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x00 /*secondary()*/), dstenc);
  
#line 24511 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 24525 "ad_x86.cpp"
  }
}

void addI_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 24567 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x03 /*primary()*/));
  
#line 24575 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 24591 "ad_x86.cpp"
  }
}

void addI_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 24633 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x03 /*primary()*/));
  
#line 24641 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 24657 "ad_x86.cpp"
  }
}

void addI_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 24699 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x01 /*primary()*/));
  
#line 24707 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 24723 "ad_x86.cpp"
  }
}

void addI_mem_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 24765 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x01 /*primary()*/));
  
#line 24773 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 24789 "ad_x86.cpp"
  }
}

void addI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 24815 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 24830 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 24850 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 24864 "ad_x86.cpp"
  }
}

void incI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 24882 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xFF /*primary()*/));
  
#line 24890 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x00 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 24899 "ad_x86.cpp"
  }
}

void incI_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 24925 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xFF /*primary()*/));
  
#line 24933 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 24953 "ad_x86.cpp"
  }
}

void decI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 24971 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xFF /*primary()*/));
  
#line 24979 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x01 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 24988 "ad_x86.cpp"
  }
}

void decI_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 25014 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xFF /*primary()*/));
  
#line 25022 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x01);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 25042 "ad_x86.cpp"
  }
}

void leaI_rReg_immINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src0
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src1
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x67));
  
#line 25058 "ad_x86.cpp"
  }
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src0 */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src0 */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 25076 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 25084 "ad_x86.cpp"
  }
  {

#line 2676 "src/hotspot/cpu/x86/x86_64.ad"

    int reg_encoding = opnd_array(0)->reg(ra_,this)/* dst */;
    int base         = opnd_array(1)->reg(ra_,this,idx1)/* src0 */;      // 0xFFFFFFFF indicates no base
    int index        = 0x04;            // 0x04 indicates no index
    int scale        = 0x00;            // 0x00 indicates no scale
    int displace     = opnd_array(2)->constant(); // 0x00 indicates no displacement
    relocInfo::relocType disp_reloc = relocInfo::none;
    encode_RegMem(cbuf, reg_encoding, base, index, scale, displace,
                  disp_reloc);
  
#line 25099 "ad_x86.cpp"
  }
}

void addL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 25127 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x03 /*primary()*/));
  
#line 25135 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 25143 "ad_x86.cpp"
  }
}

void addL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2131 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x00 /*secondary()*/), dstenc);
  
#line 25176 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 25190 "ad_x86.cpp"
  }
}

void addL_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 25234 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x03 /*primary()*/));
  
#line 25242 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 25258 "ad_x86.cpp"
  }
}

void addL_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 25302 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x03 /*primary()*/));
  
#line 25310 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 25326 "ad_x86.cpp"
  }
}

void addL_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 25370 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x01 /*primary()*/));
  
#line 25378 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 25394 "ad_x86.cpp"
  }
}

void addL_mem_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 25438 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x01 /*primary()*/));
  
#line 25446 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 25462 "ad_x86.cpp"
  }
}

void addL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 25490 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 25505 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 25525 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 25539 "ad_x86.cpp"
  }
}

void incL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 25559 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xFF /*primary()*/));
  
#line 25567 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x00 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 25576 "ad_x86.cpp"
  }
}

void incL_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 25604 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xFF /*primary()*/));
  
#line 25612 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x00);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 25632 "ad_x86.cpp"
  }
}

void decL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 25652 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xFF /*primary()*/));
  
#line 25660 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x01 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 25669 "ad_x86.cpp"
  }
}

void decL_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 25697 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xFF /*primary()*/));
  
#line 25705 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x01);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 25725 "ad_x86.cpp"
  }
}

void leaL_rReg_immLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src0
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src1
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src0 */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src0 */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 25753 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 25761 "ad_x86.cpp"
  }
  {

#line 2676 "src/hotspot/cpu/x86/x86_64.ad"

    int reg_encoding = opnd_array(0)->reg(ra_,this)/* dst */;
    int base         = opnd_array(1)->reg(ra_,this,idx1)/* src0 */;      // 0xFFFFFFFF indicates no base
    int index        = 0x04;            // 0x04 indicates no index
    int scale        = 0x00;            // 0x00 indicates no scale
    int displace     = opnd_array(2)->constantL(); // 0x00 indicates no displacement
    relocInfo::relocType disp_reloc = relocInfo::none;
    encode_RegMem(cbuf, reg_encoding, base, index, scale, displace,
                  disp_reloc);
  
#line 25776 "ad_x86.cpp"
  }
}

void addP_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 25804 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x03 /*primary()*/));
  
#line 25812 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 25820 "ad_x86.cpp"
  }
}

void addP_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2131 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x00 /*secondary()*/), dstenc);
  
#line 25853 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 25867 "ad_x86.cpp"
  }
}

void leaP_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src0
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src1
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src0 */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src0 */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 25895 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8D /*primary()*/));
  
#line 25903 "ad_x86.cpp"
  }
  {

#line 2676 "src/hotspot/cpu/x86/x86_64.ad"

    int reg_encoding = opnd_array(0)->reg(ra_,this)/* dst */;
    int base         = opnd_array(1)->reg(ra_,this,idx1)/* src0 */;      // 0xFFFFFFFF indicates no base
    int index        = 0x04;            // 0x04 indicates no index
    int scale        = 0x00;            // 0x00 indicates no scale
    int displace     = opnd_array(2)->constantL(); // 0x00 indicates no displacement
    relocInfo::relocType disp_reloc = relocInfo::none;
    encode_RegMem(cbuf, reg_encoding, base, index, scale, displace,
                  disp_reloc);
  
#line 25918 "ad_x86.cpp"
  }
}

void checkCastPPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  // User did not define which encode class to use.
}

uint checkCastPPNode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void castPPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  // User did not define which encode class to use.
}

uint castPPNode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void castIINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  // User did not define which encode class to use.
}

uint castIINode::size(PhaseRegAlloc *ra_) const {
  assert(VerifyOops || MachNode::size(ra_) <= 0, "bad fixed size");
  return (VerifyOops ? MachNode::size(ra_) : 0);
}

void loadPLockedNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 26000 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x8B /*primary()*/));
  
#line 26008 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 26024 "ad_x86.cpp"
  }
}

void storePConditionalNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// heap_top_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 26043 "ad_x86.cpp"
  }
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 26079 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 26087 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 26095 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 26111 "ad_x86.cpp"
  }
}

void storeIConditionalNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 26130 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 26164 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 26172 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 26180 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 26196 "ad_x86.cpp"
  }
}

void storeLConditionalNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 26215 "ad_x86.cpp"
  }
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 26251 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 26259 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 26267 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 26283 "ad_x86.cpp"
  }
}

void compareAndSwapPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 26302 "ad_x86.cpp"
  }
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 26338 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 26346 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 26354 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 26370 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 26380 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 26388 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 26396 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 26404 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 26422 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 26430 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 26438 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 26446 "ad_x86.cpp"
  }
}

void compareAndSwapP_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 26465 "ad_x86.cpp"
  }
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 26501 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 26509 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 26517 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 26533 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 26543 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 26551 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 26559 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 26567 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 26585 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 26593 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 26601 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 26609 "ad_x86.cpp"
  }
}

void compareAndSwapLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 26628 "ad_x86.cpp"
  }
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 26664 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 26672 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 26680 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 26696 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 26706 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 26714 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 26722 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 26730 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 26748 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 26756 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 26764 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 26772 "ad_x86.cpp"
  }
}

void compareAndSwapL_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 26791 "ad_x86.cpp"
  }
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 26827 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 26835 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 26843 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 26859 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 26869 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 26877 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 26885 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 26893 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 26911 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 26919 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 26927 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 26935 "ad_x86.cpp"
  }
}

void compareAndSwapINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 26954 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 26988 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 26996 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 27004 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 27020 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 27030 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 27038 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 27046 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27054 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 27072 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 27080 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 27088 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27096 "ad_x86.cpp"
  }
}

void compareAndSwapI_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 27115 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 27149 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 27157 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 27165 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 27181 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 27191 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 27199 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 27207 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27215 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 27233 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 27241 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 27249 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27257 "ad_x86.cpp"
  }
}

void compareAndSwapBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 27276 "ad_x86.cpp"
  }
  {

#line 2501 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        } else if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ >= 4) {
          emit_opcode(cbuf, Assembler::REX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 27312 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 27320 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB0 /*secondary()*/));
  
#line 27328 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 27344 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 27354 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 27362 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 27370 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27378 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 27396 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 27404 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 27412 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27420 "ad_x86.cpp"
  }
}

void compareAndSwapB_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 27439 "ad_x86.cpp"
  }
  {

#line 2501 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        } else if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ >= 4) {
          emit_opcode(cbuf, Assembler::REX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 27475 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 27483 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB0 /*secondary()*/));
  
#line 27491 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 27507 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 27517 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 27525 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 27533 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27541 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 27559 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 27567 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 27575 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27583 "ad_x86.cpp"
  }
}

void compareAndSwapSNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 27602 "ad_x86.cpp"
  }
  {

#line 1942 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, 0x66);
  
#line 27610 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 27644 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 27652 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 27660 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 27676 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 27686 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 27694 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 27702 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27710 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 27728 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 27736 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 27744 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27752 "ad_x86.cpp"
  }
}

void compareAndSwapS_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 27771 "ad_x86.cpp"
  }
  {

#line 1942 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, 0x66);
  
#line 27779 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 27813 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 27821 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 27829 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 27845 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 27855 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 27863 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 27871 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27879 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 27897 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 27905 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 27913 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 27921 "ad_x86.cpp"
  }
}

void compareAndSwapNNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 27940 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 27974 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 27982 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 27990 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 28006 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 28016 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 28024 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 28032 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 28040 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 28058 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 28066 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 28074 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 28082 "ad_x86.cpp"
  }
}

void compareAndSwapN_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 28101 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 28135 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 28143 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 28151 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 28167 "ad_x86.cpp"
  }
  {

#line 2477 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
      emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
    }
  
#line 28177 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 28185 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x94));
  
#line 28193 "ad_x86.cpp"
  }
  {

#line 1947 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, 0, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 28201 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* res */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* res */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* res */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 28219 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF));
  
#line 28227 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 28235 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* res */ & 7, opnd_array(0)->reg(ra_,this)/* res */ & 7);
  
#line 28243 "ad_x86.cpp"
  }
}

void compareAndExchangeBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 28262 "ad_x86.cpp"
  }
  {

#line 2501 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        } else if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ >= 4) {
          emit_opcode(cbuf, Assembler::REX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 28298 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 28306 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB0 /*secondary()*/));
  
#line 28314 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 28330 "ad_x86.cpp"
  }
}

void compareAndExchangeSNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 28349 "ad_x86.cpp"
  }
  {

#line 1942 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, 0x66);
  
#line 28357 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 28391 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 28399 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 28407 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 28423 "ad_x86.cpp"
  }
}

void compareAndExchangeINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 28442 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 28476 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 28484 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 28492 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 28508 "ad_x86.cpp"
  }
}

void compareAndExchangeLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 28527 "ad_x86.cpp"
  }
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 28563 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 28571 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 28579 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 28595 "ad_x86.cpp"
  }
}

void compareAndExchangeNNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 28614 "ad_x86.cpp"
  }
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 28648 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 28656 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 28664 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 28680 "ad_x86.cpp"
  }
}

void compareAndExchangePNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem_ptr
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// oldval
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// newval
  {

#line 2437 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) {
      emit_opcode(cbuf, 0xF0); // lock
    }
  
#line 28699 "ad_x86.cpp"
  }
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(3)->reg(ra_,this,idx3)/* newval */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 28735 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 28743 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB1 /*secondary()*/));
  
#line 28751 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(3)->reg(ra_,this,idx3)/* newval */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 28767 "ad_x86.cpp"
  }
}

void xaddB_no_resNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// add
  {
    MacroAssembler _masm(&cbuf);

#line 8116 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) { __ lock(); }
    __ addb(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->constant());
  
#line 28785 "ad_x86.cpp"
  }
}

void xaddBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8127 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) { __ lock(); }
    __ xaddb(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->as_Register(ra_,this,idx2)/* newval */);
  
#line 28803 "ad_x86.cpp"
  }
}

void xaddS_no_resNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// add
  {
    MacroAssembler _masm(&cbuf);

#line 8139 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) { __ lock(); }
    __ addw(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->constant());
  
#line 28821 "ad_x86.cpp"
  }
}

void xaddSNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8150 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) { __ lock(); }
    __ xaddw(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->as_Register(ra_,this,idx2)/* newval */);
  
#line 28839 "ad_x86.cpp"
  }
}

void xaddI_no_resNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// add
  {
    MacroAssembler _masm(&cbuf);

#line 8162 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) { __ lock(); }
    __ addl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->constant());
  
#line 28857 "ad_x86.cpp"
  }
}

void xaddINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8173 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) { __ lock(); }
    __ xaddl(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->as_Register(ra_,this,idx2)/* newval */);
  
#line 28875 "ad_x86.cpp"
  }
}

void xaddL_no_resNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// add
  {
    MacroAssembler _masm(&cbuf);

#line 8185 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) { __ lock(); }
    __ addq(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->constantL());
  
#line 28893 "ad_x86.cpp"
  }
}

void xaddLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8196 "src/hotspot/cpu/x86/x86_64.ad"

    if (os::is_MP()) { __ lock(); }
    __ xaddq(Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()), opnd_array(2)->as_Register(ra_,this,idx2)/* newval */);
  
#line 28911 "ad_x86.cpp"
  }
}

void xchgBNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8206 "src/hotspot/cpu/x86/x86_64.ad"

    __ xchgb(opnd_array(2)->as_Register(ra_,this,idx2)/* newval */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 28928 "ad_x86.cpp"
  }
}

void xchgSNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8215 "src/hotspot/cpu/x86/x86_64.ad"

    __ xchgw(opnd_array(2)->as_Register(ra_,this,idx2)/* newval */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 28945 "ad_x86.cpp"
  }
}

void xchgINode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8224 "src/hotspot/cpu/x86/x86_64.ad"

    __ xchgl(opnd_array(2)->as_Register(ra_,this,idx2)/* newval */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 28962 "ad_x86.cpp"
  }
}

void xchgLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8233 "src/hotspot/cpu/x86/x86_64.ad"

    __ xchgq(opnd_array(2)->as_Register(ra_,this,idx2)/* newval */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 28979 "ad_x86.cpp"
  }
}

void xchgPNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8242 "src/hotspot/cpu/x86/x86_64.ad"

    __ xchgq(opnd_array(2)->as_Register(ra_,this,idx2)/* newval */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 28996 "ad_x86.cpp"
  }
}

void xchgNNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// mem
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// newval
  {
    MacroAssembler _masm(&cbuf);

#line 8251 "src/hotspot/cpu/x86/x86_64.ad"

    __ xchgl(opnd_array(2)->as_Register(ra_,this,idx2)/* newval */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 29013 "ad_x86.cpp"
  }
}

void absI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// tmp
  {
    MacroAssembler _masm(&cbuf);

#line 8270 "src/hotspot/cpu/x86/x86_64.ad"

    __ movl(opnd_array(3)->as_Register(ra_,this,idx3)/* tmp */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
    __ sarl(opnd_array(3)->as_Register(ra_,this,idx3)/* tmp */, 31);
    __ movl(opnd_array(2)->as_Register(ra_,this,idx2)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
    __ xorl(opnd_array(2)->as_Register(ra_,this,idx2)/* dst */, opnd_array(3)->as_Register(ra_,this,idx3)/* tmp */);
    __ subl(opnd_array(2)->as_Register(ra_,this,idx2)/* dst */, opnd_array(3)->as_Register(ra_,this,idx3)/* tmp */);
  
#line 29035 "ad_x86.cpp"
  }
}

void absL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// tmp
  {
    MacroAssembler _masm(&cbuf);

#line 8292 "src/hotspot/cpu/x86/x86_64.ad"

    __ movq(opnd_array(3)->as_Register(ra_,this,idx3)/* tmp */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
    __ sarq(opnd_array(3)->as_Register(ra_,this,idx3)/* tmp */, 63);
    __ movq(opnd_array(2)->as_Register(ra_,this,idx2)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
    __ xorq(opnd_array(2)->as_Register(ra_,this,idx2)/* dst */, opnd_array(3)->as_Register(ra_,this,idx3)/* tmp */);
    __ subq(opnd_array(2)->as_Register(ra_,this,idx2)/* dst */, opnd_array(3)->as_Register(ra_,this,idx3)/* tmp */);
  
#line 29057 "ad_x86.cpp"
  }
}

void subI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 29083 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x2B /*primary()*/));
  
#line 29091 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 29099 "ad_x86.cpp"
  }
}

void subI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2111 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x05 /*secondary()*/), dstenc);
  
#line 29130 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 29144 "ad_x86.cpp"
  }
}

void subI_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 29186 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x2B /*primary()*/));
  
#line 29194 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 29210 "ad_x86.cpp"
  }
}

void subI_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 29252 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x29 /*primary()*/));
  
#line 29260 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 29276 "ad_x86.cpp"
  }
}

void subI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 29302 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 29317 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x05);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 29337 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 29351 "ad_x86.cpp"
  }
}

void subL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 29379 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x2B /*primary()*/));
  
#line 29387 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 29395 "ad_x86.cpp"
  }
}

void subL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2131 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x05 /*secondary()*/), dstenc);
  
#line 29428 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 29442 "ad_x86.cpp"
  }
}

void subL_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 29486 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x2B /*primary()*/));
  
#line 29494 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 29510 "ad_x86.cpp"
  }
}

void subL_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 29554 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x29 /*primary()*/));
  
#line 29562 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 29578 "ad_x86.cpp"
  }
}

void subL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 29606 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 29621 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x05);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 29641 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 29655 "ad_x86.cpp"
  }
}

void subP_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(3)->reg(ra_,this,idx3)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(3)->reg(ra_,this,idx3)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 29684 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x2B /*primary()*/));
  
#line 29692 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(3)->reg(ra_,this,idx3)/* src */ & 7);
  
#line 29700 "ad_x86.cpp"
  }
}

void negI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// zero
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 29718 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 29726 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x03 /*secondary()*/), opnd_array(2)->reg(ra_,this,idx2)/* dst */ & 7);
  
#line 29735 "ad_x86.cpp"
  }
}

void negI_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 29761 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 29769 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x03 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 29789 "ad_x86.cpp"
  }
}

void negL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// zero
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 29809 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 29817 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x03 /*secondary()*/), opnd_array(2)->reg(ra_,this,idx2)/* dst */ & 7);
  
#line 29826 "ad_x86.cpp"
  }
}

void negL_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 29854 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 29862 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x03 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 29882 "ad_x86.cpp"
  }
}

void mulI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 29908 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 29916 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xAF /*secondary()*/));
  
#line 29924 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 29932 "ad_x86.cpp"
  }
}

void mulI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 29958 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x69 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x69 /*primary()*/));
    }
  
#line 29973 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 29981 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 29995 "ad_x86.cpp"
  }
}

void mulI_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 30037 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 30045 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xAF /*secondary()*/));
  
#line 30053 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 30069 "ad_x86.cpp"
  }
}

void mulI_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 30111 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 30119 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xAF /*secondary()*/));
  
#line 30127 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 30143 "ad_x86.cpp"
  }
}

void mulI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 30185 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x69 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x69 /*primary()*/));
    }
  
#line 30200 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 30216 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 30230 "ad_x86.cpp"
  }
}

void mulL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 30258 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 30266 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xAF /*secondary()*/));
  
#line 30274 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 30282 "ad_x86.cpp"
  }
}

void mulL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 30310 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x69 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x69 /*primary()*/));
    }
  
#line 30325 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 30333 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 30347 "ad_x86.cpp"
  }
}

void mulL_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 30391 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 30399 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xAF /*secondary()*/));
  
#line 30407 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 30423 "ad_x86.cpp"
  }
}

void mulL_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 30467 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 30475 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xAF /*secondary()*/));
  
#line 30483 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 30499 "ad_x86.cpp"
  }
}

void mulL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 30543 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x69 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x69 /*primary()*/));
    }
  
#line 30558 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(0)->reg(ra_,this)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 30574 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 30588 "ad_x86.cpp"
  }
}

void mulHiL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// rax
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 30608 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 30616 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x5 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 30625 "ad_x86.cpp"
  }
}

void divI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// rax
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// div
  {

#line 1963 "src/hotspot/cpu/x86/x86_64.ad"

    // Full implementation of Java idiv and irem; checks for
    // special case as described in JVM spec., p.243 & p.271.
    //
    //         normal case                           special case
    //
    // input : rax: dividend                         min_int
    //         reg: divisor                          -1
    //
    // output: rax: quotient  (= rax idiv reg)       min_int
    //         rdx: remainder (= rax irem reg)       0
    //
    //  Code sequnce:
    //
    //    0:   3d 00 00 00 80          cmp    $0x80000000,%eax
    //    5:   75 07/08                jne    e <normal>
    //    7:   33 d2                   xor    %edx,%edx
    //  [div >= 8 -> offset + 1]
    //  [REX_B]
    //    9:   83 f9 ff                cmp    $0xffffffffffffffff,$div
    //    c:   74 03/04                je     11 <done>
    // 000000000000000e <normal>:
    //    e:   99                      cltd
    //  [div >= 8 -> offset + 1]
    //  [REX_B]
    //    f:   f7 f9                   idiv   $div
    // 0000000000000011 <done>:

    // cmp    $0x80000000,%eax
    emit_opcode(cbuf, 0x3d);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x80);

    // jne    e <normal>
    emit_opcode(cbuf, 0x75);
    emit_d8(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? 0x07 : 0x08);

    // xor    %edx,%edx
    emit_opcode(cbuf, 0x33);
    emit_d8(cbuf, 0xD2);

    // cmp    $0xffffffffffffffff,%ecx
    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
    emit_opcode(cbuf, 0x83);
    emit_rm(cbuf, 0x3, 0x7, opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
    emit_d8(cbuf, 0xFF);

    // je     11 <done>
    emit_opcode(cbuf, 0x74);
    emit_d8(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? 0x03 : 0x04);

    // <normal>
    // cltd
    emit_opcode(cbuf, 0x99);

    // idivl (note: must be emitted by the user of this rule)
    // <done>
  
#line 30700 "ad_x86.cpp"
  }
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 30710 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 30718 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
  
#line 30727 "ad_x86.cpp"
  }
}

void divL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// rax
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// div
  {

#line 2027 "src/hotspot/cpu/x86/x86_64.ad"

    // Full implementation of Java ldiv and lrem; checks for
    // special case as described in JVM spec., p.243 & p.271.
    //
    //         normal case                           special case
    //
    // input : rax: dividend                         min_long
    //         reg: divisor                          -1
    //
    // output: rax: quotient  (= rax idiv reg)       min_long
    //         rdx: remainder (= rax irem reg)       0
    //
    //  Code sequnce:
    //
    //    0:   48 ba 00 00 00 00 00    mov    $0x8000000000000000,%rdx
    //    7:   00 00 80
    //    a:   48 39 d0                cmp    %rdx,%rax
    //    d:   75 08                   jne    17 <normal>
    //    f:   33 d2                   xor    %edx,%edx
    //   11:   48 83 f9 ff             cmp    $0xffffffffffffffff,$div
    //   15:   74 05                   je     1c <done>
    // 0000000000000017 <normal>:
    //   17:   48 99                   cqto
    //   19:   48 f7 f9                idiv   $div
    // 000000000000001c <done>:

    // mov    $0x8000000000000000,%rdx
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0xBA);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x80);

    // cmp    %rdx,%rax
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0x39);
    emit_d8(cbuf, 0xD0);

    // jne    17 <normal>
    emit_opcode(cbuf, 0x75);
    emit_d8(cbuf, 0x08);

    // xor    %edx,%edx
    emit_opcode(cbuf, 0x33);
    emit_d8(cbuf, 0xD2);

    // cmp    $0xffffffffffffffff,$div
    emit_opcode(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? Assembler::REX_W : Assembler::REX_WB);
    emit_opcode(cbuf, 0x83);
    emit_rm(cbuf, 0x3, 0x7, opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
    emit_d8(cbuf, 0xFF);

    // je     1e <done>
    emit_opcode(cbuf, 0x74);
    emit_d8(cbuf, 0x05);

    // <normal>
    // cqto
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0x99);

    // idivq (note: must be emitted by the user of this rule)
    // <done>
  
#line 30809 "ad_x86.cpp"
  }
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 30821 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 30829 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
  
#line 30838 "ad_x86.cpp"
  }
}

void divModI_rReg_divmodNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// div
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// rdx
  {

#line 1963 "src/hotspot/cpu/x86/x86_64.ad"

    // Full implementation of Java idiv and irem; checks for
    // special case as described in JVM spec., p.243 & p.271.
    //
    //         normal case                           special case
    //
    // input : rax: dividend                         min_int
    //         reg: divisor                          -1
    //
    // output: rax: quotient  (= rax idiv reg)       min_int
    //         rdx: remainder (= rax irem reg)       0
    //
    //  Code sequnce:
    //
    //    0:   3d 00 00 00 80          cmp    $0x80000000,%eax
    //    5:   75 07/08                jne    e <normal>
    //    7:   33 d2                   xor    %edx,%edx
    //  [div >= 8 -> offset + 1]
    //  [REX_B]
    //    9:   83 f9 ff                cmp    $0xffffffffffffffff,$div
    //    c:   74 03/04                je     11 <done>
    // 000000000000000e <normal>:
    //    e:   99                      cltd
    //  [div >= 8 -> offset + 1]
    //  [REX_B]
    //    f:   f7 f9                   idiv   $div
    // 0000000000000011 <done>:

    // cmp    $0x80000000,%eax
    emit_opcode(cbuf, 0x3d);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x80);

    // jne    e <normal>
    emit_opcode(cbuf, 0x75);
    emit_d8(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? 0x07 : 0x08);

    // xor    %edx,%edx
    emit_opcode(cbuf, 0x33);
    emit_d8(cbuf, 0xD2);

    // cmp    $0xffffffffffffffff,%ecx
    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
    emit_opcode(cbuf, 0x83);
    emit_rm(cbuf, 0x3, 0x7, opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
    emit_d8(cbuf, 0xFF);

    // je     11 <done>
    emit_opcode(cbuf, 0x74);
    emit_d8(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? 0x03 : 0x04);

    // <normal>
    // cltd
    emit_opcode(cbuf, 0x99);

    // idivl (note: must be emitted by the user of this rule)
    // <done>
  
#line 30913 "ad_x86.cpp"
  }
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 30923 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 30931 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
  
#line 30940 "ad_x86.cpp"
  }
}

void divModL_rReg_divmodNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// div
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// rdx
  {

#line 2027 "src/hotspot/cpu/x86/x86_64.ad"

    // Full implementation of Java ldiv and lrem; checks for
    // special case as described in JVM spec., p.243 & p.271.
    //
    //         normal case                           special case
    //
    // input : rax: dividend                         min_long
    //         reg: divisor                          -1
    //
    // output: rax: quotient  (= rax idiv reg)       min_long
    //         rdx: remainder (= rax irem reg)       0
    //
    //  Code sequnce:
    //
    //    0:   48 ba 00 00 00 00 00    mov    $0x8000000000000000,%rdx
    //    7:   00 00 80
    //    a:   48 39 d0                cmp    %rdx,%rax
    //    d:   75 08                   jne    17 <normal>
    //    f:   33 d2                   xor    %edx,%edx
    //   11:   48 83 f9 ff             cmp    $0xffffffffffffffff,$div
    //   15:   74 05                   je     1c <done>
    // 0000000000000017 <normal>:
    //   17:   48 99                   cqto
    //   19:   48 f7 f9                idiv   $div
    // 000000000000001c <done>:

    // mov    $0x8000000000000000,%rdx
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0xBA);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x80);

    // cmp    %rdx,%rax
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0x39);
    emit_d8(cbuf, 0xD0);

    // jne    17 <normal>
    emit_opcode(cbuf, 0x75);
    emit_d8(cbuf, 0x08);

    // xor    %edx,%edx
    emit_opcode(cbuf, 0x33);
    emit_d8(cbuf, 0xD2);

    // cmp    $0xffffffffffffffff,$div
    emit_opcode(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? Assembler::REX_W : Assembler::REX_WB);
    emit_opcode(cbuf, 0x83);
    emit_rm(cbuf, 0x3, 0x7, opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
    emit_d8(cbuf, 0xFF);

    // je     1e <done>
    emit_opcode(cbuf, 0x74);
    emit_d8(cbuf, 0x05);

    // <normal>
    // cqto
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0x99);

    // idivq (note: must be emitted by the user of this rule)
    // <done>
  
#line 31022 "ad_x86.cpp"
  }
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 31034 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 31042 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
  
#line 31051 "ad_x86.cpp"
  }
}

void loadConL_0x6666666666666667Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// 
  {

#line 2336 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_opcode(cbuf, 0xB8 | dstenc);
    emit_d64(cbuf, (0x6666666666666667));
  
#line 31074 "ad_x86.cpp"
  }
}

void mul_hiNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// rax
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 31094 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 31102 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x5 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 31111 "ad_x86.cpp"
  }
}

void sarL_rReg_63Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cr
  {

#line 2310 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), dstenc);
    emit_d8(cbuf, (0x3F));
  
#line 31136 "ad_x86.cpp"
  }
}

void sarL_rReg_2Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cr
  {

#line 2310 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), dstenc);
    emit_d8(cbuf, (0x2));
  
#line 31161 "ad_x86.cpp"
  }
}

void modI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// rax
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// div
  {

#line 1963 "src/hotspot/cpu/x86/x86_64.ad"

    // Full implementation of Java idiv and irem; checks for
    // special case as described in JVM spec., p.243 & p.271.
    //
    //         normal case                           special case
    //
    // input : rax: dividend                         min_int
    //         reg: divisor                          -1
    //
    // output: rax: quotient  (= rax idiv reg)       min_int
    //         rdx: remainder (= rax irem reg)       0
    //
    //  Code sequnce:
    //
    //    0:   3d 00 00 00 80          cmp    $0x80000000,%eax
    //    5:   75 07/08                jne    e <normal>
    //    7:   33 d2                   xor    %edx,%edx
    //  [div >= 8 -> offset + 1]
    //  [REX_B]
    //    9:   83 f9 ff                cmp    $0xffffffffffffffff,$div
    //    c:   74 03/04                je     11 <done>
    // 000000000000000e <normal>:
    //    e:   99                      cltd
    //  [div >= 8 -> offset + 1]
    //  [REX_B]
    //    f:   f7 f9                   idiv   $div
    // 0000000000000011 <done>:

    // cmp    $0x80000000,%eax
    emit_opcode(cbuf, 0x3d);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x80);

    // jne    e <normal>
    emit_opcode(cbuf, 0x75);
    emit_d8(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? 0x07 : 0x08);

    // xor    %edx,%edx
    emit_opcode(cbuf, 0x33);
    emit_d8(cbuf, 0xD2);

    // cmp    $0xffffffffffffffff,%ecx
    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
    emit_opcode(cbuf, 0x83);
    emit_rm(cbuf, 0x3, 0x7, opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
    emit_d8(cbuf, 0xFF);

    // je     11 <done>
    emit_opcode(cbuf, 0x74);
    emit_d8(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? 0x03 : 0x04);

    // <normal>
    // cltd
    emit_opcode(cbuf, 0x99);

    // idivl (note: must be emitted by the user of this rule)
    // <done>
  
#line 31236 "ad_x86.cpp"
  }
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 31246 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 31254 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
  
#line 31263 "ad_x86.cpp"
  }
}

void modL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// rax
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// div
  {

#line 2027 "src/hotspot/cpu/x86/x86_64.ad"

    // Full implementation of Java ldiv and lrem; checks for
    // special case as described in JVM spec., p.243 & p.271.
    //
    //         normal case                           special case
    //
    // input : rax: dividend                         min_long
    //         reg: divisor                          -1
    //
    // output: rax: quotient  (= rax idiv reg)       min_long
    //         rdx: remainder (= rax irem reg)       0
    //
    //  Code sequnce:
    //
    //    0:   48 ba 00 00 00 00 00    mov    $0x8000000000000000,%rdx
    //    7:   00 00 80
    //    a:   48 39 d0                cmp    %rdx,%rax
    //    d:   75 08                   jne    17 <normal>
    //    f:   33 d2                   xor    %edx,%edx
    //   11:   48 83 f9 ff             cmp    $0xffffffffffffffff,$div
    //   15:   74 05                   je     1c <done>
    // 0000000000000017 <normal>:
    //   17:   48 99                   cqto
    //   19:   48 f7 f9                idiv   $div
    // 000000000000001c <done>:

    // mov    $0x8000000000000000,%rdx
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0xBA);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x00);
    emit_d8(cbuf, 0x80);

    // cmp    %rdx,%rax
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0x39);
    emit_d8(cbuf, 0xD0);

    // jne    17 <normal>
    emit_opcode(cbuf, 0x75);
    emit_d8(cbuf, 0x08);

    // xor    %edx,%edx
    emit_opcode(cbuf, 0x33);
    emit_d8(cbuf, 0xD2);

    // cmp    $0xffffffffffffffff,$div
    emit_opcode(cbuf, opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8 ? Assembler::REX_W : Assembler::REX_WB);
    emit_opcode(cbuf, 0x83);
    emit_rm(cbuf, 0x3, 0x7, opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
    emit_d8(cbuf, 0xFF);

    // je     1e <done>
    emit_opcode(cbuf, 0x74);
    emit_d8(cbuf, 0x05);

    // <normal>
    // cqto
    emit_opcode(cbuf, Assembler::REX_W);
    emit_opcode(cbuf, 0x99);

    // idivq (note: must be emitted by the user of this rule)
    // <done>
  
#line 31345 "ad_x86.cpp"
  }
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* div */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 31357 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xF7 /*primary()*/));
  
#line 31365 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(2)->reg(ra_,this,idx2)/* div */ & 7);
  
#line 31374 "ad_x86.cpp"
  }
}

void salI_rReg_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 31392 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 31400 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x4 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 31409 "ad_x86.cpp"
  }
}

void salI_mem_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 31435 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 31443 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x4 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 31463 "ad_x86.cpp"
  }
}

void salI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2297 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x4 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 31487 "ad_x86.cpp"
  }
}

void salI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 31513 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC1 /*primary()*/));
  
#line 31521 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x4 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 31541 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 31555 "ad_x86.cpp"
  }
}

void salI_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 31573 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 31581 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x4 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 31590 "ad_x86.cpp"
  }
}

void salI_mem_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 31616 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 31624 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x4 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 31644 "ad_x86.cpp"
  }
}

void sarI_rReg_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 31662 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 31670 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 31679 "ad_x86.cpp"
  }
}

void sarI_mem_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 31705 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 31713 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x7 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 31733 "ad_x86.cpp"
  }
}

void sarI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2297 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 31757 "ad_x86.cpp"
  }
}

void sarI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 31783 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC1 /*primary()*/));
  
#line 31791 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x7 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 31811 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 31825 "ad_x86.cpp"
  }
}

void sarI_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 31843 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 31851 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 31860 "ad_x86.cpp"
  }
}

void sarI_mem_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 31886 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 31894 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x7 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 31914 "ad_x86.cpp"
  }
}

void shrI_rReg_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 31932 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 31940 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x5 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 31949 "ad_x86.cpp"
  }
}

void shrI_mem_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 31975 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 31983 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x5 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32003 "ad_x86.cpp"
  }
}

void shrI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2297 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x5 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 32027 "ad_x86.cpp"
  }
}

void shrI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 32053 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC1 /*primary()*/));
  
#line 32061 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x5 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32081 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 32095 "ad_x86.cpp"
  }
}

void shrI_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 32113 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 32121 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x5 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 32130 "ad_x86.cpp"
  }
}

void shrI_mem_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 32156 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 32164 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x5 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32184 "ad_x86.cpp"
  }
}

void salL_rReg_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 32204 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 32212 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x4 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 32221 "ad_x86.cpp"
  }
}

void salL_mem_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 32249 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 32257 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x4 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32277 "ad_x86.cpp"
  }
}

void salL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2310 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x4 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 32303 "ad_x86.cpp"
  }
}

void salL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 32331 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC1 /*primary()*/));
  
#line 32339 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x4 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32359 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 32373 "ad_x86.cpp"
  }
}

void salL_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 32393 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 32401 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x4 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 32410 "ad_x86.cpp"
  }
}

void salL_mem_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 32438 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 32446 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x4 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32466 "ad_x86.cpp"
  }
}

void sarL_rReg_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 32486 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 32494 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 32503 "ad_x86.cpp"
  }
}

void sarL_mem_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 32531 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 32539 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x7 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32559 "ad_x86.cpp"
  }
}

void sarL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2310 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 32585 "ad_x86.cpp"
  }
}

void sarL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 32613 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC1 /*primary()*/));
  
#line 32621 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x7 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32641 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 32655 "ad_x86.cpp"
  }
}

void sarL_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 32675 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 32683 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x7 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 32692 "ad_x86.cpp"
  }
}

void sarL_mem_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 32720 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 32728 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x7 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32748 "ad_x86.cpp"
  }
}

void shrL_rReg_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 32768 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 32776 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x5 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 32785 "ad_x86.cpp"
  }
}

void shrL_mem_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 32813 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 32821 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x5 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32841 "ad_x86.cpp"
  }
}

void shrL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2310 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x5 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 32867 "ad_x86.cpp"
  }
}

void shrL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 32895 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xC1 /*primary()*/));
  
#line 32903 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x5 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 32923 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 32937 "ad_x86.cpp"
  }
}

void shrL_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 32957 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 32965 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x5 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 32974 "ad_x86.cpp"
  }
}

void shrL_mem_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// shift
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 33002 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 33010 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x5 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 33030 "ad_x86.cpp"
  }
}

void i2bNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// twentyfour
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ >= 4) {
        emit_opcode(cbuf, opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 33056 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 33064 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xBE /*secondary()*/));
  
#line 33072 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 33080 "ad_x86.cpp"
  }
}

void i2sNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// sixteen
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 33106 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 33114 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xBF /*secondary()*/));
  
#line 33122 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 33130 "ad_x86.cpp"
  }
}

void rolI_rReg_imm1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cr
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 33147 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 33155 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x0 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33164 "ad_x86.cpp"
  }
}

void rolI_rReg_imm8Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  {

#line 2297 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x0 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 33188 "ad_x86.cpp"
  }
}

void rolI_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 33206 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 33214 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x0 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33223 "ad_x86.cpp"
  }
}

void rorI_rReg_imm1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cr
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 33240 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 33248 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x1 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33257 "ad_x86.cpp"
  }
}

void rorI_rReg_imm8Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  {

#line 2297 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x1 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 33281 "ad_x86.cpp"
  }
}

void rorI_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  {

#line 2534 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
    }
  
#line 33299 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 33307 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x1 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33316 "ad_x86.cpp"
  }
}

void rolL_rReg_imm1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cr
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 33335 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 33343 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x0 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33352 "ad_x86.cpp"
  }
}

void rolL_rReg_imm8Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  {

#line 2310 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x0 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 33378 "ad_x86.cpp"
  }
}

void rolL_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 33398 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 33406 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x0 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33415 "ad_x86.cpp"
  }
}

void rorL_rReg_imm1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// cr
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 33434 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD1 /*primary()*/));
  
#line 33442 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x1 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33451 "ad_x86.cpp"
  }
}

void rorL_rReg_imm8Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  {

#line 2310 "src/hotspot/cpu/x86/x86_64.ad"

    // SAL, SAR, SHR
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    emit_d8(cbuf, (0xC1 /*primary()*/));
    emit_rm(cbuf, 0x3, (0x1 /*secondary()*/), dstenc);
    emit_d8(cbuf, opnd_array(2)->constant());
  
#line 33477 "ad_x86.cpp"
  }
}

void rorL_rReg_CLNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// shift
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// cr
  {

#line 2541 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
    }
  
#line 33497 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xD3 /*primary()*/));
  
#line 33505 "ad_x86.cpp"
  }
  {

#line 2176 "src/hotspot/cpu/x86/x86_64.ad"

    // INC, DEC, IDIV, IMOD, JMP indirect, ...
    emit_rm(cbuf, 0x3, (0x1 /*secondary()*/), opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33514 "ad_x86.cpp"
  }
}

void andI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 33540 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x23 /*primary()*/));
  
#line 33548 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 33556 "ad_x86.cpp"
  }
}

void andI_rReg_imm255Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 4) {
        emit_opcode(cbuf, opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 33582 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 33590 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6 /*secondary()*/));
  
#line 33598 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33606 "ad_x86.cpp"
  }
}

void andI2L_rReg_imm255Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ >= 4) {
        emit_opcode(cbuf, opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 33632 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 33640 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6 /*secondary()*/));
  
#line 33648 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 33656 "ad_x86.cpp"
  }
}

void andI_rReg_imm65535Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 33682 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 33690 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB7 /*secondary()*/));
  
#line 33698 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 33706 "ad_x86.cpp"
  }
}

void andI2L_rReg_imm65535Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// mask
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 33732 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 33740 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB7 /*secondary()*/));
  
#line 33748 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 33756 "ad_x86.cpp"
  }
}

void andI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2111 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x04 /*secondary()*/), dstenc);
  
#line 33787 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 33801 "ad_x86.cpp"
  }
}

void andI_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 33843 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x23 /*primary()*/));
  
#line 33851 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 33867 "ad_x86.cpp"
  }
}

void andI_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 33909 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x23 /*primary()*/));
  
#line 33917 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 33933 "ad_x86.cpp"
  }
}

void andI_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 33975 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x21 /*primary()*/));
  
#line 33983 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 33999 "ad_x86.cpp"
  }
}

void andI_mem_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 34041 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x21 /*primary()*/));
  
#line 34049 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 34065 "ad_x86.cpp"
  }
}

void andI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 34091 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 34106 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x4 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 34126 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 34140 "ad_x86.cpp"
  }
}

void andnI_rReg_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src1
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// src2
  {
    MacroAssembler _masm(&cbuf);

#line 9657 "src/hotspot/cpu/x86/x86_64.ad"

    __ andnl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src1 */, Address::make_raw(opnd_array(3)->base(ra_,this,idx3), opnd_array(3)->index(ra_,this,idx3), opnd_array(3)->scale(), opnd_array(3)->disp(ra_,this,idx3), opnd_array(3)->disp_reloc()));
  
#line 34158 "ad_x86.cpp"
  }
}

void andnI_rReg_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src2
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src1
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9657 "src/hotspot/cpu/x86/x86_64.ad"

    __ andnl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(2)->as_Register(ra_,this,idx2)/* src1 */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 34176 "ad_x86.cpp"
  }
}

void andnI_rReg_rReg_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src1
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// src2
  {
    MacroAssembler _masm(&cbuf);

#line 9670 "src/hotspot/cpu/x86/x86_64.ad"

    __ andnl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src1 */, opnd_array(3)->as_Register(ra_,this,idx3)/* src2 */);
  
#line 34194 "ad_x86.cpp"
  }
}

void andnI_rReg_rReg_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src2
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src1
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9670 "src/hotspot/cpu/x86/x86_64.ad"

    __ andnl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(2)->as_Register(ra_,this,idx2)/* src1 */, opnd_array(1)->as_Register(ra_,this,idx1)/* src2 */);
  
#line 34212 "ad_x86.cpp"
  }
}

void blsiI_rReg_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// imm_zero
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 9683 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsil(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(2)->as_Register(ra_,this,idx2)/* src */);
  
#line 34229 "ad_x86.cpp"
  }
}

void blsiI_rReg_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm_zero
  {
    MacroAssembler _masm(&cbuf);

#line 9683 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsil(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 34246 "ad_x86.cpp"
  }
}

void blsiI_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// imm_zero
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 9697 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsil(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(2)->base(ra_,this,idx2), opnd_array(2)->index(ra_,this,idx2), opnd_array(2)->scale(), opnd_array(2)->disp(ra_,this,idx2), opnd_array(2)->disp_reloc()));
  
#line 34263 "ad_x86.cpp"
  }
}

void blsiI_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm_zero
  {
    MacroAssembler _masm(&cbuf);

#line 9697 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsil(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 34280 "ad_x86.cpp"
  }
}

void blsmskI_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9712 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsmskl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 34297 "ad_x86.cpp"
  }
}

void blsmskI_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9712 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsmskl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 34314 "ad_x86.cpp"
  }
}

void blsmskI_rReg_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9726 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsmskl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 34331 "ad_x86.cpp"
  }
}

void blsmskI_rReg_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9726 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsmskl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 34348 "ad_x86.cpp"
  }
}

void blsrI_rReg_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9741 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsrl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 34365 "ad_x86.cpp"
  }
}

void blsrI_rReg_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9741 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsrl(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 34382 "ad_x86.cpp"
  }
}

void blsrI_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9757 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsrl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 34399 "ad_x86.cpp"
  }
}

void blsrI_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 9757 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsrl(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 34416 "ad_x86.cpp"
  }
}

void orI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 34442 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0B /*primary()*/));
  
#line 34450 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 34458 "ad_x86.cpp"
  }
}

void orI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2111 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x01 /*secondary()*/), dstenc);
  
#line 34489 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 34503 "ad_x86.cpp"
  }
}

void orI_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 34545 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0B /*primary()*/));
  
#line 34553 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 34569 "ad_x86.cpp"
  }
}

void orI_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 34611 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0B /*primary()*/));
  
#line 34619 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 34635 "ad_x86.cpp"
  }
}

void orI_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 34677 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x09 /*primary()*/));
  
#line 34685 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 34701 "ad_x86.cpp"
  }
}

void orI_mem_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 34743 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x09 /*primary()*/));
  
#line 34751 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 34767 "ad_x86.cpp"
  }
}

void orI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 34793 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 34808 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x1 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 34828 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 34842 "ad_x86.cpp"
  }
}

void xorI_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 34868 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 34876 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 34884 "ad_x86.cpp"
  }
}

void xorI_rReg_im1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm
  {
    MacroAssembler _masm(&cbuf);

#line 9847 "src/hotspot/cpu/x86/x86_64.ad"

     __ notl(opnd_array(1)->as_Register(ra_,this,idx1)/* dst */);
  
#line 34901 "ad_x86.cpp"
  }
}

void xorI_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2111 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x06 /*secondary()*/), dstenc);
  
#line 34932 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 34946 "ad_x86.cpp"
  }
}

void xorI_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 34988 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 34996 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 35012 "ad_x86.cpp"
  }
}

void xorI_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 35054 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 35062 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 35078 "ad_x86.cpp"
  }
}

void xorI_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 35120 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x31 /*primary()*/));
  
#line 35128 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 35144 "ad_x86.cpp"
  }
}

void xorI_mem_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2582 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
          emit_opcode(cbuf, Assembler::REX_X);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_B);
        } else {
          emit_opcode(cbuf, Assembler::REX_XB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_R);
        } else {
          emit_opcode(cbuf, Assembler::REX_RX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_RB);
        } else {
          emit_opcode(cbuf, Assembler::REX_RXB);
        }
      }
    }
  
#line 35186 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x31 /*primary()*/));
  
#line 35194 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 35210 "ad_x86.cpp"
  }
}

void xorI_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2444 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      } else {
        emit_opcode(cbuf, Assembler::REX_XB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) >= 8) {
        emit_opcode(cbuf, Assembler::REX_X);
      }
    }
  
#line 35236 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 35251 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x6 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 35271 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constant() && opnd_array(2)->constant() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constant());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constant());
    }
  
#line 35285 "ad_x86.cpp"
  }
}

void andL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 35313 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x23 /*primary()*/));
  
#line 35321 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 35329 "ad_x86.cpp"
  }
}

void andL_rReg_imm255Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 35357 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 35365 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6 /*secondary()*/));
  
#line 35373 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 35381 "ad_x86.cpp"
  }
}

void andL_rReg_imm65535Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 35409 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F /*primary()*/));
  
#line 35417 "ad_x86.cpp"
  }
  {

#line 1924 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB7 /*secondary()*/));
  
#line 35425 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7);
  
#line 35433 "ad_x86.cpp"
  }
}

void andL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2131 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x04 /*secondary()*/), dstenc);
  
#line 35466 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 35480 "ad_x86.cpp"
  }
}

void andL_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 35524 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x23 /*primary()*/));
  
#line 35532 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 35548 "ad_x86.cpp"
  }
}

void andL_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 35592 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x23 /*primary()*/));
  
#line 35600 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 35616 "ad_x86.cpp"
  }
}

void andL_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 35660 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x21 /*primary()*/));
  
#line 35668 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 35684 "ad_x86.cpp"
  }
}

void andL_mem_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 35728 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x21 /*primary()*/));
  
#line 35736 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 35752 "ad_x86.cpp"
  }
}

void andL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 35780 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 35795 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x4 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 35815 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 35829 "ad_x86.cpp"
  }
}

void andnL_rReg_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src1
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// src2
  {
    MacroAssembler _masm(&cbuf);

#line 10004 "src/hotspot/cpu/x86/x86_64.ad"

    __ andnq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src1 */, Address::make_raw(opnd_array(3)->base(ra_,this,idx3), opnd_array(3)->index(ra_,this,idx3), opnd_array(3)->scale(), opnd_array(3)->disp(ra_,this,idx3), opnd_array(3)->disp_reloc()));
  
#line 35847 "ad_x86.cpp"
  }
}

void andnL_rReg_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src2
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src1
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10004 "src/hotspot/cpu/x86/x86_64.ad"

    __ andnq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(2)->as_Register(ra_,this,idx2)/* src1 */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 35865 "ad_x86.cpp"
  }
}

void andnL_rReg_rReg_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src1
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// src2
  {
    MacroAssembler _masm(&cbuf);

#line 10017 "src/hotspot/cpu/x86/x86_64.ad"

  __ andnq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src1 */, opnd_array(3)->as_Register(ra_,this,idx3)/* src2 */);
  
#line 35883 "ad_x86.cpp"
  }
}

void andnL_rReg_rReg_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src2
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src1
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10017 "src/hotspot/cpu/x86/x86_64.ad"

  __ andnq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(2)->as_Register(ra_,this,idx2)/* src1 */, opnd_array(1)->as_Register(ra_,this,idx1)/* src2 */);
  
#line 35901 "ad_x86.cpp"
  }
}

void blsiL_rReg_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// imm_zero
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 10030 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsiq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(2)->as_Register(ra_,this,idx2)/* src */);
  
#line 35918 "ad_x86.cpp"
  }
}

void blsiL_rReg_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm_zero
  {
    MacroAssembler _masm(&cbuf);

#line 10030 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsiq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 35935 "ad_x86.cpp"
  }
}

void blsiL_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// imm_zero
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {
    MacroAssembler _masm(&cbuf);

#line 10044 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsiq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(2)->base(ra_,this,idx2), opnd_array(2)->index(ra_,this,idx2), opnd_array(2)->scale(), opnd_array(2)->disp(ra_,this,idx2), opnd_array(2)->disp_reloc()));
  
#line 35952 "ad_x86.cpp"
  }
}

void blsiL_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm_zero
  {
    MacroAssembler _masm(&cbuf);

#line 10044 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsiq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 35969 "ad_x86.cpp"
  }
}

void blsmskL_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10059 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsmskq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 35986 "ad_x86.cpp"
  }
}

void blsmskL_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10059 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsmskq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 36003 "ad_x86.cpp"
  }
}

void blsmskL_rReg_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10073 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsmskq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 36020 "ad_x86.cpp"
  }
}

void blsmskL_rReg_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10073 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsmskq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 36037 "ad_x86.cpp"
  }
}

void blsrL_rReg_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10088 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsrq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 36054 "ad_x86.cpp"
  }
}

void blsrL_rReg_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10088 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsrq(opnd_array(0)->as_Register(ra_,this)/* dst */, opnd_array(1)->as_Register(ra_,this,idx1)/* src */);
  
#line 36071 "ad_x86.cpp"
  }
}

void blsrL_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10104 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsrq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 36088 "ad_x86.cpp"
  }
}

void blsrL_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// minus_1
  {
    MacroAssembler _masm(&cbuf);

#line 10104 "src/hotspot/cpu/x86/x86_64.ad"

    __ blsrq(opnd_array(0)->as_Register(ra_,this)/* dst */, Address::make_raw(opnd_array(1)->base(ra_,this,idx1), opnd_array(1)->index(ra_,this,idx1), opnd_array(1)->scale(), opnd_array(1)->disp(ra_,this,idx1), opnd_array(1)->disp_reloc()));
  
#line 36105 "ad_x86.cpp"
  }
}

void orL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 36133 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0B /*primary()*/));
  
#line 36141 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 36149 "ad_x86.cpp"
  }
}

void orL_rReg_castP2XNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 36177 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0B /*primary()*/));
  
#line 36185 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 36193 "ad_x86.cpp"
  }
}

void orL_rReg_castP2X_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 36221 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0B /*primary()*/));
  
#line 36229 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(2)->reg(ra_,this,idx2)/* dst */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 36237 "ad_x86.cpp"
  }
}

void orL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2131 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x01 /*secondary()*/), dstenc);
  
#line 36270 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 36284 "ad_x86.cpp"
  }
}

void orL_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 36328 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0B /*primary()*/));
  
#line 36336 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 36352 "ad_x86.cpp"
  }
}

void orL_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 36396 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0B /*primary()*/));
  
#line 36404 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 36420 "ad_x86.cpp"
  }
}

void orL_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 36464 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x09 /*primary()*/));
  
#line 36472 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 36488 "ad_x86.cpp"
  }
}

void orL_mem_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 36532 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x09 /*primary()*/));
  
#line 36540 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 36556 "ad_x86.cpp"
  }
}

void orL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 36584 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 36599 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x1 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 36619 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 36633 "ad_x86.cpp"
  }
}

void xorL_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 36661 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 36669 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* dst */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* src */ & 7);
  
#line 36677 "ad_x86.cpp"
  }
}

void xorL_rReg_im1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// imm
  {
    MacroAssembler _masm(&cbuf);

#line 10206 "src/hotspot/cpu/x86/x86_64.ad"

     __ notq(opnd_array(1)->as_Register(ra_,this,idx1)/* dst */);
  
#line 36694 "ad_x86.cpp"
  }
}

void xorL_rReg_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2131 "src/hotspot/cpu/x86/x86_64.ad"

    // OpcSEr/m
    int dstenc = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    if (dstenc < 8) {
      emit_opcode(cbuf, Assembler::REX_W);
    } else {
      emit_opcode(cbuf, Assembler::REX_WB);
      dstenc -= 8;
    }
    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
    // Emit r/m byte with secondary opcode, after primary opcode.
    emit_rm(cbuf, 0x3, (0x06 /*secondary()*/), dstenc);
  
#line 36727 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 36741 "ad_x86.cpp"
  }
}

void xorL_rReg_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* dst */ < 8) {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(2)->base(ra_,this,idx2) < 8) {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(2)->index(ra_,this,idx2) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 36785 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 36793 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(1)->reg(ra_,this,idx1)/* dst */;
    int base = opnd_array(2)->base(ra_,this,idx2);
    int index = opnd_array(2)->index(ra_,this,idx2);
    int scale = opnd_array(2)->scale();
    int disp = opnd_array(2)->disp(ra_,this,idx2);
    relocInfo::relocType disp_reloc = opnd_array(2)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 36809 "ad_x86.cpp"
  }
}

void xorL_rReg_mem_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// dst
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* dst */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 36853 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x33 /*primary()*/));
  
#line 36861 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* dst */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 36877 "ad_x86.cpp"
  }
}

void xorL_mem_rRegNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 36921 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x31 /*primary()*/));
  
#line 36929 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 36945 "ad_x86.cpp"
  }
}

void xorL_mem_rReg_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2613 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(2)->reg(ra_,this,idx2)/* src */ < 8) {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_W);
        } else {
          emit_opcode(cbuf, Assembler::REX_WX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WXB);
        }
      }
    } else {
      if (opnd_array(1)->base(ra_,this,idx1) < 8) {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WR);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRX);
        }
      } else {
        if (opnd_array(1)->index(ra_,this,idx1) < 8) {
          emit_opcode(cbuf, Assembler::REX_WRB);
        } else {
          emit_opcode(cbuf, Assembler::REX_WRXB);
        }
      }
    }
  
#line 36989 "ad_x86.cpp"
  }
  {

#line 1918 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x31 /*primary()*/));
  
#line 36997 "ad_x86.cpp"
  }
  {

#line 2646 "src/hotspot/cpu/x86/x86_64.ad"

    // High registers handle in encode_RegMem
    int reg = opnd_array(2)->reg(ra_,this,idx2)/* src */;
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int disp = opnd_array(1)->disp(ra_,this,idx1);
    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();

    encode_RegMem(cbuf, reg, base, index, scale, disp, disp_reloc);
  
#line 37013 "ad_x86.cpp"
  }
}

void xorL_mem_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src
  {

#line 2459 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->base(ra_,this,idx1) >= 8) {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_WB);
      } else {
        emit_opcode(cbuf, Assembler::REX_WXB);
      }
    } else {
      if (opnd_array(1)->index(ra_,this,idx1) < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WX);
      }
    }
  
#line 37041 "ad_x86.cpp"
  }
  {

#line 2099 "src/hotspot/cpu/x86/x86_64.ad"

    // Emit primary opcode and set sign-extend bit
    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_opcode(cbuf, (0x81 /*primary()*/) | 0x02);
    } else {
      // 32-bit immediate
      emit_opcode(cbuf, (0x81 /*primary()*/));
    }
  
#line 37056 "ad_x86.cpp"
  }
  {

#line 2659 "src/hotspot/cpu/x86/x86_64.ad"

    int rm_byte_opcode = (0x6 /*secondary()*/);

    // High registers handle in encode_RegMem
    int base = opnd_array(1)->base(ra_,this,idx1);
    int index = opnd_array(1)->index(ra_,this,idx1);
    int scale = opnd_array(1)->scale();
    int displace = opnd_array(1)->disp(ra_,this,idx1);

    relocInfo::relocType disp_reloc = opnd_array(1)->disp_reloc();       // disp-as-oop when
                                            // working with static
                                            // globals
    encode_RegMem(cbuf, rm_byte_opcode, base, index, scale, displace,
                  disp_reloc);
  
#line 37076 "ad_x86.cpp"
  }
  {

#line 2153 "src/hotspot/cpu/x86/x86_64.ad"

    // Check for 8-bit immediate, and set sign extend bit in opcode
    if (-0x80 <= opnd_array(2)->constantL() && opnd_array(2)->constantL() < 0x80) {
      emit_d8(cbuf, opnd_array(2)->constantL());
    } else {
      // 32-bit immediate
      emit_d32(cbuf, opnd_array(2)->constantL());
    }
  
#line 37090 "ad_x86.cpp"
  }
}

void convI2BNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 37115 "ad_x86.cpp"
  }
  {

#line 1957 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x85));
    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 37124 "ad_x86.cpp"
  }
  {

#line 2729 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    } else if (dstenc >= 4) {
      emit_opcode(cbuf, Assembler::REX);
    }
    // SETNZ $dst
    emit_opcode(cbuf, 0x0F);
    emit_opcode(cbuf, 0x95);
    emit_rm(cbuf, 0x3, 0x0, dstenc);
  
#line 37142 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* dst */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* dst */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 37160 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 37168 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 37176 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(0)->reg(ra_,this)/* dst */ & 7);
  
#line 37184 "ad_x86.cpp"
  }
}

void convP2BNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  {

#line 2565 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_W);
      } else {
        emit_opcode(cbuf, Assembler::REX_WB);
      }
    } else {
      if (opnd_array(1)->reg(ra_,this,idx1)/* src */ < 8) {
        emit_opcode(cbuf, Assembler::REX_WR);
      } else {
        emit_opcode(cbuf, Assembler::REX_WRB);
      }
    }
  
#line 37211 "ad_x86.cpp"
  }
  {

#line 1957 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x85));
    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7, opnd_array(1)->reg(ra_,this,idx1)/* src */ & 7);
  
#line 37220 "ad_x86.cpp"
  }
  {

#line 2729 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    } else if (dstenc >= 4) {
      emit_opcode(cbuf, Assembler::REX);
    }
    // SETNZ $dst
    emit_opcode(cbuf, 0x0F);
    emit_opcode(cbuf, 0x95);
    emit_rm(cbuf, 0x3, 0x0, dstenc);
  
#line 37238 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* dst */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* dst */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 37256 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 37264 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 37272 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(0)->reg(ra_,this)/* dst */ & 7);
  
#line 37280 "ad_x86.cpp"
  }
}

void cmpLTMaskNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// p
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// q
  {

#line 2550 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(1)->reg(ra_,this,idx1)/* p */ < 8) {
      if (opnd_array(2)->reg(ra_,this,idx2)/* q */ >= 8) {
        emit_opcode(cbuf, Assembler::REX_B);
      }
    } else {
      if (opnd_array(2)->reg(ra_,this,idx2)/* q */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 37306 "ad_x86.cpp"
  }
  {

#line 1957 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x3B));
    emit_rm(cbuf, 0x3, opnd_array(1)->reg(ra_,this,idx1)/* p */ & 7, opnd_array(2)->reg(ra_,this,idx2)/* q */ & 7);
  
#line 37315 "ad_x86.cpp"
  }
  {

#line 2714 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    } else if (dstenc >= 4) {
      emit_opcode(cbuf, Assembler::REX);
    }
    // SETLT $dst
    emit_opcode(cbuf, 0x0F);
    emit_opcode(cbuf, 0x9C);
    emit_rm(cbuf, 0x3, 0x0, dstenc);
  
#line 37333 "ad_x86.cpp"
  }
  {

#line 2485 "src/hotspot/cpu/x86/x86_64.ad"

    if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
      if (opnd_array(0)->reg(ra_,this)/* dst */ >= 4) {
        emit_opcode(cbuf, opnd_array(0)->reg(ra_,this)/* dst */ < 8 ? Assembler::REX : Assembler::REX_B);
      }
    } else {
      if (opnd_array(0)->reg(ra_,this)/* dst */ < 8) {
        emit_opcode(cbuf, Assembler::REX_R);
      } else {
        emit_opcode(cbuf, Assembler::REX_RB);
      }
    }
  
#line 37351 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0x0F));
  
#line 37359 "ad_x86.cpp"
  }
  {

#line 1936 "src/hotspot/cpu/x86/x86_64.ad"

    emit_opcode(cbuf, (0xB6));
  
#line 37367 "ad_x86.cpp"
  }
  {

#line 1952 "src/hotspot/cpu/x86/x86_64.ad"

    emit_rm(cbuf, 0x3, opnd_array(0)->reg(ra_,this)/* dst */ & 7, opnd_array(0)->reg(ra_,this)/* dst */ & 7);
  
#line 37375 "ad_x86.cpp"
  }
  {

#line 2688 "src/hotspot/cpu/x86/x86_64.ad"

    int dstenc = opnd_array(0)->reg(ra_,this)/* dst */;
    if (dstenc >= 8) {
      emit_opcode(cbuf, Assembler::REX_B);
      dstenc -= 8;
    }
    // NEG $dst
    emit_opcode(cbuf, 0xF7);
    emit_rm(cbuf, 0x3, 0x03, dstenc);
  
#line 37390 "ad_x86.cpp"
  }
}

void cmpLTMask0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// dst
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// zero
  {
    MacroAssembler _masm(&cbuf);

#line 10321 "src/hotspot/cpu/x86/x86_64.ad"

  __ sarl(opnd_array(1)->as_Register(ra_,this,idx1)/* dst */, 31);
  
#line 37407 "ad_x86.cpp"
  }
}

void cadd_cmpLTMaskNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// p
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// q
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// y
  {
    MacroAssembler _masm(&cbuf);

#line 10337 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rp = opnd_array(1)->as_Register(ra_,this,idx1)/* p */;
    Register Rq = opnd_array(2)->as_Register(ra_,this,idx2)/* q */;
    Register Ry = opnd_array(3)->as_Register(ra_,this,idx3)/* y */;
    Label done;
    __ subl(Rp, Rq);
    __ jccb(Assembler::greaterEqual, done);
    __ addl(Rp, Ry);
    __ bind(done);
  
#line 37432 "ad_x86.cpp"
  }
}

void cadd_cmpLTMask_1Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// p
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// q
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// y
  {
    MacroAssembler _masm(&cbuf);

#line 10337 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rp = opnd_array(1)->as_Register(ra_,this,idx1)/* p */;
    Register Rq = opnd_array(2)->as_Register(ra_,this,idx2)/* q */;
    Register Ry = opnd_array(3)->as_Register(ra_,this,idx3)/* y */;
    Label done;
    __ subl(Rp, Rq);
    __ jccb(Assembler::greaterEqual, done);
    __ addl(Rp, Ry);
    __ bind(done);
  
#line 37457 "ad_x86.cpp"
  }
}

void cadd_cmpLTMask_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// y
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// p
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// q
  {
    MacroAssembler _masm(&cbuf);

#line 10337 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rp = opnd_array(2)->as_Register(ra_,this,idx2)/* p */;
    Register Rq = opnd_array(3)->as_Register(ra_,this,idx3)/* q */;
    Register Ry = opnd_array(1)->as_Register(ra_,this,idx1)/* y */;
    Label done;
    __ subl(Rp, Rq);
    __ jccb(Assembler::greaterEqual, done);
    __ addl(Rp, Ry);
    __ bind(done);
  
#line 37482 "ad_x86.cpp"
  }
}

void cadd_cmpLTMask_2Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// p
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// q
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// y
  {
    MacroAssembler _masm(&cbuf);

#line 10337 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rp = opnd_array(1)->as_Register(ra_,this,idx1)/* p */;
    Register Rq = opnd_array(2)->as_Register(ra_,this,idx2)/* q */;
    Register Ry = opnd_array(3)->as_Register(ra_,this,idx3)/* y */;
    Label done;
    __ subl(Rp, Rq);
    __ jccb(Assembler::greaterEqual, done);
    __ addl(Rp, Ry);
    __ bind(done);
  
#line 37507 "ad_x86.cpp"
  }
}

void and_cmpLTMaskNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// p
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// q
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// y
  {
    MacroAssembler _masm(&cbuf);

#line 10362 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rp = opnd_array(1)->as_Register(ra_,this,idx1)/* p */;
    Register Rq = opnd_array(2)->as_Register(ra_,this,idx2)/* q */;
    Register Ry = opnd_array(3)->as_Register(ra_,this,idx3)/* y */;
    Label done;
    __ cmpl(Rp, Rq);
    __ jccb(Assembler::less, done);
    __ xorl(Ry, Ry);
    __ bind(done);
  
#line 37532 "ad_x86.cpp"
  }
}

void and_cmpLTMask_0Node::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// y
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// p
  unsigned idx3 = idx2 + opnd_array(2)->num_edges(); 	// q
  {
    MacroAssembler _masm(&cbuf);

#line 10362 "src/hotspot/cpu/x86/x86_64.ad"

    Register Rp = opnd_array(2)->as_Register(ra_,this,idx2)/* p */;
    Register Rq = opnd_array(3)->as_Register(ra_,this,idx3)/* q */;
    Register Ry = opnd_array(1)->as_Register(ra_,this,idx1)/* y */;
    Label done;
    __ cmpl(Rp, Rq);
    __ jccb(Assembler::less, done);
    __ xorl(Ry, Ry);
    __ bind(done);
  
#line 37557 "ad_x86.cpp"
  }
}

void cmpF_cc_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src1
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src2
  {
    MacroAssembler _masm(&cbuf);

#line 10389 "src/hotspot/cpu/x86/x86_64.ad"

    __ ucomiss(opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src1 */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* src2 */);
    emit_cmpfp_fixup(_masm);
  
#line 37575 "ad_x86.cpp"
  }
}

void cmpF_cc_reg_CFNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src1
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src2
  {
    MacroAssembler _masm(&cbuf);

#line 10401 "src/hotspot/cpu/x86/x86_64.ad"

    __ ucomiss(opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src1 */, opnd_array(2)->as_XMMRegister(ra_,this,idx2)/* src2 */);
  
#line 37592 "ad_x86.cpp"
  }
}

void cmpF_cc_memNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src1
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src2
  {
    MacroAssembler _masm(&cbuf);

#line 10418 "src/hotspot/cpu/x86/x86_64.ad"

    __ ucomiss(opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src1 */, Address::make_raw(opnd_array(2)->base(ra_,this,idx2), opnd_array(2)->index(ra_,this,idx2), opnd_array(2)->scale(), opnd_array(2)->disp(ra_,this,idx2), opnd_array(2)->disp_reloc()));
    emit_cmpfp_fixup(_masm);
  
#line 37610 "ad_x86.cpp"
  }
}

void cmpF_cc_memCFNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 2;
  unsigned idx1 = 2; 	// src1
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// src2
  {
    MacroAssembler _masm(&cbuf);

#line 10430 "src/hotspot/cpu/x86/x86_64.ad"

    __ ucomiss(opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src1 */, Address::make_raw(opnd_array(2)->base(ra_,this,idx2), opnd_array(2)->index(ra_,this,idx2), opnd_array(2)->scale(), opnd_array(2)->disp(ra_,this,idx2), opnd_array(2)->disp_reloc()));
  
#line 37627 "ad_x86.cpp"
  }
}

void cmpF_cc_immNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// con
  {
    MacroAssembler _masm(&cbuf);

#line 10446 "src/hotspot/cpu/x86/x86_64.ad"

    __ ucomiss(opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */, InternalAddress(__ code()->consts()->start() + constant_offset()));
    emit_cmpfp_fixup(_masm);
  
#line 37645 "ad_x86.cpp"
  }
}

void cmpF_cc_immNode::eval_constant(Compile* C) {
  {

#line 10447 "src/hotspot/cpu/x86/x86_64.ad"
    _constant = C->constant_table().add(this, opnd_array(2));
#line 37654 "ad_x86.cpp"
  }
}
void cmpF_cc_immCFNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_mark();
  // Start at oper_input_base() and count operands
  unsigned idx0 = 1;
  unsigned idx1 = 1; 	// src
  unsigned idx2 = idx1 + opnd_array(1)->num_edges(); 	// con
  {
    MacroAssembler _masm(&cbuf);

#line 10457 "src/hotspot/cpu/x86/x86_64.ad"

    __ ucomiss(opnd_array(1)->as_XMMRegister(ra_,this,idx1)/* src */, InternalAddress(__ code()->consts()->start() + constant_offset()));
  
#line 37670 "ad_x86.cpp"
  }
}

void cmpF_cc_immCFNode::eval_constant(Compile* C) {
  {

#line 10458 "src/hotspot/cpu/x86/x86_64.ad"
    _constant = C->constant_table().add(this, opnd_array(2));
#line 37679 "ad_x86.cpp"
  }
}
void cmpD_cc_regNode::emit(CodeBuffer& cbuf, PhaseRegAlloc* ra_) const {
  cbuf.set_insts_m